//autogenerated:yes
//nolint:revive,misspell,govet,lll,dupl,gocritic
package common

import (
	"fmt"
	"strconv"
)

// Defines how throttle value is represented in MAV_CMD_DO_MOTOR_TEST.
type MOTOR_TEST_THROTTLE_TYPE uint64

const (
	// Throttle as a percentage (0 ~ 100)
	MOTOR_TEST_THROTTLE_PERCENT MOTOR_TEST_THROTTLE_TYPE = 0
	// Throttle as an absolute PWM value (normally in range of 1000~2000).
	MOTOR_TEST_THROTTLE_PWM MOTOR_TEST_THROTTLE_TYPE = 1
	// Throttle pass-through from pilot's transmitter.
	MOTOR_TEST_THROTTLE_PILOT MOTOR_TEST_THROTTLE_TYPE = 2
	// Per-motor compass calibration test.
	MOTOR_TEST_COMPASS_CAL MOTOR_TEST_THROTTLE_TYPE = 3
)

var labels_MOTOR_TEST_THROTTLE_TYPE = map[MOTOR_TEST_THROTTLE_TYPE]string{
	MOTOR_TEST_THROTTLE_PERCENT: "MOTOR_TEST_THROTTLE_PERCENT",
	MOTOR_TEST_THROTTLE_PWM:     "MOTOR_TEST_THROTTLE_PWM",
	MOTOR_TEST_THROTTLE_PILOT:   "MOTOR_TEST_THROTTLE_PILOT",
	MOTOR_TEST_COMPASS_CAL:      "MOTOR_TEST_COMPASS_CAL",
}

var values_MOTOR_TEST_THROTTLE_TYPE = map[string]MOTOR_TEST_THROTTLE_TYPE{
	"MOTOR_TEST_THROTTLE_PERCENT": MOTOR_TEST_THROTTLE_PERCENT,
	"MOTOR_TEST_THROTTLE_PWM":     MOTOR_TEST_THROTTLE_PWM,
	"MOTOR_TEST_THROTTLE_PILOT":   MOTOR_TEST_THROTTLE_PILOT,
	"MOTOR_TEST_COMPASS_CAL":      MOTOR_TEST_COMPASS_CAL,
}

// MarshalText implements the encoding.TextMarshaler interface.
func (e MOTOR_TEST_THROTTLE_TYPE) MarshalText() ([]byte, error) {
	if name, ok := labels_MOTOR_TEST_THROTTLE_TYPE[e]; ok {
		return []byte(name), nil
	}
	return []byte(strconv.Itoa(int(e))), nil
}

// UnmarshalText implements the encoding.TextUnmarshaler interface.
func (e *MOTOR_TEST_THROTTLE_TYPE) UnmarshalText(text []byte) error {
	if value, ok := values_MOTOR_TEST_THROTTLE_TYPE[string(text)]; ok {
		*e = value
	} else if value, err := strconv.Atoi(string(text)); err == nil {
		*e = MOTOR_TEST_THROTTLE_TYPE(value)
	} else {
		return fmt.Errorf("invalid label '%s'", text)
	}
	return nil
}

// String implements the fmt.Stringer interface.
func (e MOTOR_TEST_THROTTLE_TYPE) String() string {
	val, _ := e.MarshalText()
	return string(val)
}
