//autogenerated:yes
//nolint:revive,misspell,govet,lll,dupl,gocritic
package common

import (
	"fmt"
	"strconv"
	"strings"
)

// Power supply status flags (bitmask)
type MAV_POWER_STATUS uint64

const (
	// main brick power supply valid
	MAV_POWER_STATUS_BRICK_VALID MAV_POWER_STATUS = 1
	// main servo power supply valid for FMU
	MAV_POWER_STATUS_SERVO_VALID MAV_POWER_STATUS = 2
	// USB power is connected
	MAV_POWER_STATUS_USB_CONNECTED MAV_POWER_STATUS = 4
	// peripheral supply is in over-current state
	MAV_POWER_STATUS_PERIPH_OVERCURRENT MAV_POWER_STATUS = 8
	// hi-power peripheral supply is in over-current state
	MAV_POWER_STATUS_PERIPH_HIPOWER_OVERCURRENT MAV_POWER_STATUS = 16
	// Power status has changed since boot
	MAV_POWER_STATUS_CHANGED MAV_POWER_STATUS = 32
)

var labels_MAV_POWER_STATUS = map[MAV_POWER_STATUS]string{
	MAV_POWER_STATUS_BRICK_VALID:                "MAV_POWER_STATUS_BRICK_VALID",
	MAV_POWER_STATUS_SERVO_VALID:                "MAV_POWER_STATUS_SERVO_VALID",
	MAV_POWER_STATUS_USB_CONNECTED:              "MAV_POWER_STATUS_USB_CONNECTED",
	MAV_POWER_STATUS_PERIPH_OVERCURRENT:         "MAV_POWER_STATUS_PERIPH_OVERCURRENT",
	MAV_POWER_STATUS_PERIPH_HIPOWER_OVERCURRENT: "MAV_POWER_STATUS_PERIPH_HIPOWER_OVERCURRENT",
	MAV_POWER_STATUS_CHANGED:                    "MAV_POWER_STATUS_CHANGED",
}

var values_MAV_POWER_STATUS = map[string]MAV_POWER_STATUS{
	"MAV_POWER_STATUS_BRICK_VALID":                MAV_POWER_STATUS_BRICK_VALID,
	"MAV_POWER_STATUS_SERVO_VALID":                MAV_POWER_STATUS_SERVO_VALID,
	"MAV_POWER_STATUS_USB_CONNECTED":              MAV_POWER_STATUS_USB_CONNECTED,
	"MAV_POWER_STATUS_PERIPH_OVERCURRENT":         MAV_POWER_STATUS_PERIPH_OVERCURRENT,
	"MAV_POWER_STATUS_PERIPH_HIPOWER_OVERCURRENT": MAV_POWER_STATUS_PERIPH_HIPOWER_OVERCURRENT,
	"MAV_POWER_STATUS_CHANGED":                    MAV_POWER_STATUS_CHANGED,
}

// MarshalText implements the encoding.TextMarshaler interface.
func (e MAV_POWER_STATUS) MarshalText() ([]byte, error) {
	if e == 0 {
		return []byte("0"), nil
	}
	var names []string
	for i := 0; i < 6; i++ {
		mask := MAV_POWER_STATUS(1 << i)
		if e&mask == mask {
			names = append(names, labels_MAV_POWER_STATUS[mask])
		}
	}
	return []byte(strings.Join(names, " | ")), nil
}

// UnmarshalText implements the encoding.TextUnmarshaler interface.
func (e *MAV_POWER_STATUS) UnmarshalText(text []byte) error {
	labels := strings.Split(string(text), " | ")
	var mask MAV_POWER_STATUS
	for _, label := range labels {
		if value, ok := values_MAV_POWER_STATUS[label]; ok {
			mask |= value
		} else if value, err := strconv.Atoi(label); err == nil {
			mask |= MAV_POWER_STATUS(value)
		} else {
			return fmt.Errorf("invalid label '%s'", label)
		}
	}
	*e = mask
	return nil
}

// String implements the fmt.Stringer interface.
func (e MAV_POWER_STATUS) String() string {
	val, _ := e.MarshalText()
	return string(val)
}
