//autogenerated:yes
//nolint:revive,misspell,govet,lll,dupl,gocritic
package common

import (
	"fmt"
	"strconv"
)

// Specifies the datatype of a MAVLink parameter.
type MAV_PARAM_TYPE uint64

const (
	// 8-bit unsigned integer
	MAV_PARAM_TYPE_UINT8 MAV_PARAM_TYPE = 1
	// 8-bit signed integer
	MAV_PARAM_TYPE_INT8 MAV_PARAM_TYPE = 2
	// 16-bit unsigned integer
	MAV_PARAM_TYPE_UINT16 MAV_PARAM_TYPE = 3
	// 16-bit signed integer
	MAV_PARAM_TYPE_INT16 MAV_PARAM_TYPE = 4
	// 32-bit unsigned integer
	MAV_PARAM_TYPE_UINT32 MAV_PARAM_TYPE = 5
	// 32-bit signed integer
	MAV_PARAM_TYPE_INT32 MAV_PARAM_TYPE = 6
	// 64-bit unsigned integer
	MAV_PARAM_TYPE_UINT64 MAV_PARAM_TYPE = 7
	// 64-bit signed integer
	MAV_PARAM_TYPE_INT64 MAV_PARAM_TYPE = 8
	// 32-bit floating-point
	MAV_PARAM_TYPE_REAL32 MAV_PARAM_TYPE = 9
	// 64-bit floating-point
	MAV_PARAM_TYPE_REAL64 MAV_PARAM_TYPE = 10
)

var labels_MAV_PARAM_TYPE = map[MAV_PARAM_TYPE]string{
	MAV_PARAM_TYPE_UINT8:  "MAV_PARAM_TYPE_UINT8",
	MAV_PARAM_TYPE_INT8:   "MAV_PARAM_TYPE_INT8",
	MAV_PARAM_TYPE_UINT16: "MAV_PARAM_TYPE_UINT16",
	MAV_PARAM_TYPE_INT16:  "MAV_PARAM_TYPE_INT16",
	MAV_PARAM_TYPE_UINT32: "MAV_PARAM_TYPE_UINT32",
	MAV_PARAM_TYPE_INT32:  "MAV_PARAM_TYPE_INT32",
	MAV_PARAM_TYPE_UINT64: "MAV_PARAM_TYPE_UINT64",
	MAV_PARAM_TYPE_INT64:  "MAV_PARAM_TYPE_INT64",
	MAV_PARAM_TYPE_REAL32: "MAV_PARAM_TYPE_REAL32",
	MAV_PARAM_TYPE_REAL64: "MAV_PARAM_TYPE_REAL64",
}

var values_MAV_PARAM_TYPE = map[string]MAV_PARAM_TYPE{
	"MAV_PARAM_TYPE_UINT8":  MAV_PARAM_TYPE_UINT8,
	"MAV_PARAM_TYPE_INT8":   MAV_PARAM_TYPE_INT8,
	"MAV_PARAM_TYPE_UINT16": MAV_PARAM_TYPE_UINT16,
	"MAV_PARAM_TYPE_INT16":  MAV_PARAM_TYPE_INT16,
	"MAV_PARAM_TYPE_UINT32": MAV_PARAM_TYPE_UINT32,
	"MAV_PARAM_TYPE_INT32":  MAV_PARAM_TYPE_INT32,
	"MAV_PARAM_TYPE_UINT64": MAV_PARAM_TYPE_UINT64,
	"MAV_PARAM_TYPE_INT64":  MAV_PARAM_TYPE_INT64,
	"MAV_PARAM_TYPE_REAL32": MAV_PARAM_TYPE_REAL32,
	"MAV_PARAM_TYPE_REAL64": MAV_PARAM_TYPE_REAL64,
}

// MarshalText implements the encoding.TextMarshaler interface.
func (e MAV_PARAM_TYPE) MarshalText() ([]byte, error) {
	if name, ok := labels_MAV_PARAM_TYPE[e]; ok {
		return []byte(name), nil
	}
	return []byte(strconv.Itoa(int(e))), nil
}

// UnmarshalText implements the encoding.TextUnmarshaler interface.
func (e *MAV_PARAM_TYPE) UnmarshalText(text []byte) error {
	if value, ok := values_MAV_PARAM_TYPE[string(text)]; ok {
		*e = value
	} else if value, err := strconv.Atoi(string(text)); err == nil {
		*e = MAV_PARAM_TYPE(value)
	} else {
		return fmt.Errorf("invalid label '%s'", text)
	}
	return nil
}

// String implements the fmt.Stringer interface.
func (e MAV_PARAM_TYPE) String() string {
	val, _ := e.MarshalText()
	return string(val)
}
