//autogenerated:yes
//nolint:revive,misspell,govet,lll,dupl,gocritic
package common

import (
	"fmt"
	"strconv"
)

// Type of landing target
type LANDING_TARGET_TYPE uint64

const (
	// Landing target signaled by light beacon (ex: IR-LOCK)
	LANDING_TARGET_TYPE_LIGHT_BEACON LANDING_TARGET_TYPE = 0
	// Landing target signaled by radio beacon (ex: ILS, NDB)
	LANDING_TARGET_TYPE_RADIO_BEACON LANDING_TARGET_TYPE = 1
	// Landing target represented by a fiducial marker (ex: ARTag)
	LANDING_TARGET_TYPE_VISION_FIDUCIAL LANDING_TARGET_TYPE = 2
	// Landing target represented by a pre-defined visual shape/feature (ex: X-marker, H-marker, square)
	LANDING_TARGET_TYPE_VISION_OTHER LANDING_TARGET_TYPE = 3
)

var labels_LANDING_TARGET_TYPE = map[LANDING_TARGET_TYPE]string{
	LANDING_TARGET_TYPE_LIGHT_BEACON:    "LANDING_TARGET_TYPE_LIGHT_BEACON",
	LANDING_TARGET_TYPE_RADIO_BEACON:    "LANDING_TARGET_TYPE_RADIO_BEACON",
	LANDING_TARGET_TYPE_VISION_FIDUCIAL: "LANDING_TARGET_TYPE_VISION_FIDUCIAL",
	LANDING_TARGET_TYPE_VISION_OTHER:    "LANDING_TARGET_TYPE_VISION_OTHER",
}

var values_LANDING_TARGET_TYPE = map[string]LANDING_TARGET_TYPE{
	"LANDING_TARGET_TYPE_LIGHT_BEACON":    LANDING_TARGET_TYPE_LIGHT_BEACON,
	"LANDING_TARGET_TYPE_RADIO_BEACON":    LANDING_TARGET_TYPE_RADIO_BEACON,
	"LANDING_TARGET_TYPE_VISION_FIDUCIAL": LANDING_TARGET_TYPE_VISION_FIDUCIAL,
	"LANDING_TARGET_TYPE_VISION_OTHER":    LANDING_TARGET_TYPE_VISION_OTHER,
}

// MarshalText implements the encoding.TextMarshaler interface.
func (e LANDING_TARGET_TYPE) MarshalText() ([]byte, error) {
	if name, ok := labels_LANDING_TARGET_TYPE[e]; ok {
		return []byte(name), nil
	}
	return []byte(strconv.Itoa(int(e))), nil
}

// UnmarshalText implements the encoding.TextUnmarshaler interface.
func (e *LANDING_TARGET_TYPE) UnmarshalText(text []byte) error {
	if value, ok := values_LANDING_TARGET_TYPE[string(text)]; ok {
		*e = value
	} else if value, err := strconv.Atoi(string(text)); err == nil {
		*e = LANDING_TARGET_TYPE(value)
	} else {
		return fmt.Errorf("invalid label '%s'", text)
	}
	return nil
}

// String implements the fmt.Stringer interface.
func (e LANDING_TARGET_TYPE) String() string {
	val, _ := e.MarshalText()
	return string(val)
}
