//autogenerated:yes
//nolint:revive,misspell,govet,lll,dupl,gocritic
package common

import (
	"fmt"
	"strconv"
	"strings"
)

type FENCE_TYPE uint64

const (
	// All fence types
	FENCE_TYPE_ALL FENCE_TYPE = 0
	// Maximum altitude fence
	FENCE_TYPE_ALT_MAX FENCE_TYPE = 1
	// Circle fence
	FENCE_TYPE_CIRCLE FENCE_TYPE = 2
	// Polygon fence
	FENCE_TYPE_POLYGON FENCE_TYPE = 4
	// Minimum altitude fence
	FENCE_TYPE_ALT_MIN FENCE_TYPE = 8
)

var labels_FENCE_TYPE = map[FENCE_TYPE]string{
	FENCE_TYPE_ALL:     "FENCE_TYPE_ALL",
	FENCE_TYPE_ALT_MAX: "FENCE_TYPE_ALT_MAX",
	FENCE_TYPE_CIRCLE:  "FENCE_TYPE_CIRCLE",
	FENCE_TYPE_POLYGON: "FENCE_TYPE_POLYGON",
	FENCE_TYPE_ALT_MIN: "FENCE_TYPE_ALT_MIN",
}

var values_FENCE_TYPE = map[string]FENCE_TYPE{
	"FENCE_TYPE_ALL":     FENCE_TYPE_ALL,
	"FENCE_TYPE_ALT_MAX": FENCE_TYPE_ALT_MAX,
	"FENCE_TYPE_CIRCLE":  FENCE_TYPE_CIRCLE,
	"FENCE_TYPE_POLYGON": FENCE_TYPE_POLYGON,
	"FENCE_TYPE_ALT_MIN": FENCE_TYPE_ALT_MIN,
}

// MarshalText implements the encoding.TextMarshaler interface.
func (e FENCE_TYPE) MarshalText() ([]byte, error) {
	if e == 0 {
		return []byte("0"), nil
	}
	var names []string
	for i := 0; i < 5; i++ {
		mask := FENCE_TYPE(1 << i)
		if e&mask == mask {
			names = append(names, labels_FENCE_TYPE[mask])
		}
	}
	return []byte(strings.Join(names, " | ")), nil
}

// UnmarshalText implements the encoding.TextUnmarshaler interface.
func (e *FENCE_TYPE) UnmarshalText(text []byte) error {
	labels := strings.Split(string(text), " | ")
	var mask FENCE_TYPE
	for _, label := range labels {
		if value, ok := values_FENCE_TYPE[label]; ok {
			mask |= value
		} else if value, err := strconv.Atoi(label); err == nil {
			mask |= FENCE_TYPE(value)
		} else {
			return fmt.Errorf("invalid label '%s'", label)
		}
	}
	*e = mask
	return nil
}

// String implements the fmt.Stringer interface.
func (e FENCE_TYPE) String() string {
	val, _ := e.MarshalText()
	return string(val)
}
