//autogenerated:yes
//nolint:revive,misspell,govet,lll,dupl,gocritic
package common

import (
	"fmt"
	"strconv"
	"strings"
)

// Flags to report ESC failures.
type ESC_FAILURE_FLAGS uint64

const (
	// Over current failure.
	ESC_FAILURE_OVER_CURRENT ESC_FAILURE_FLAGS = 1
	// Over voltage failure.
	ESC_FAILURE_OVER_VOLTAGE ESC_FAILURE_FLAGS = 2
	// Over temperature failure.
	ESC_FAILURE_OVER_TEMPERATURE ESC_FAILURE_FLAGS = 4
	// Over RPM failure.
	ESC_FAILURE_OVER_RPM ESC_FAILURE_FLAGS = 8
	// Inconsistent command failure i.e. out of bounds.
	ESC_FAILURE_INCONSISTENT_CMD ESC_FAILURE_FLAGS = 16
	// Motor stuck failure.
	ESC_FAILURE_MOTOR_STUCK ESC_FAILURE_FLAGS = 32
	// Generic ESC failure.
	ESC_FAILURE_GENERIC ESC_FAILURE_FLAGS = 64
)

var labels_ESC_FAILURE_FLAGS = map[ESC_FAILURE_FLAGS]string{
	ESC_FAILURE_OVER_CURRENT:     "ESC_FAILURE_OVER_CURRENT",
	ESC_FAILURE_OVER_VOLTAGE:     "ESC_FAILURE_OVER_VOLTAGE",
	ESC_FAILURE_OVER_TEMPERATURE: "ESC_FAILURE_OVER_TEMPERATURE",
	ESC_FAILURE_OVER_RPM:         "ESC_FAILURE_OVER_RPM",
	ESC_FAILURE_INCONSISTENT_CMD: "ESC_FAILURE_INCONSISTENT_CMD",
	ESC_FAILURE_MOTOR_STUCK:      "ESC_FAILURE_MOTOR_STUCK",
	ESC_FAILURE_GENERIC:          "ESC_FAILURE_GENERIC",
}

var values_ESC_FAILURE_FLAGS = map[string]ESC_FAILURE_FLAGS{
	"ESC_FAILURE_OVER_CURRENT":     ESC_FAILURE_OVER_CURRENT,
	"ESC_FAILURE_OVER_VOLTAGE":     ESC_FAILURE_OVER_VOLTAGE,
	"ESC_FAILURE_OVER_TEMPERATURE": ESC_FAILURE_OVER_TEMPERATURE,
	"ESC_FAILURE_OVER_RPM":         ESC_FAILURE_OVER_RPM,
	"ESC_FAILURE_INCONSISTENT_CMD": ESC_FAILURE_INCONSISTENT_CMD,
	"ESC_FAILURE_MOTOR_STUCK":      ESC_FAILURE_MOTOR_STUCK,
	"ESC_FAILURE_GENERIC":          ESC_FAILURE_GENERIC,
}

// MarshalText implements the encoding.TextMarshaler interface.
func (e ESC_FAILURE_FLAGS) MarshalText() ([]byte, error) {
	if e == 0 {
		return []byte("0"), nil
	}
	var names []string
	for i := 0; i < 7; i++ {
		mask := ESC_FAILURE_FLAGS(1 << i)
		if e&mask == mask {
			names = append(names, labels_ESC_FAILURE_FLAGS[mask])
		}
	}
	return []byte(strings.Join(names, " | ")), nil
}

// UnmarshalText implements the encoding.TextUnmarshaler interface.
func (e *ESC_FAILURE_FLAGS) UnmarshalText(text []byte) error {
	labels := strings.Split(string(text), " | ")
	var mask ESC_FAILURE_FLAGS
	for _, label := range labels {
		if value, ok := values_ESC_FAILURE_FLAGS[label]; ok {
			mask |= value
		} else if value, err := strconv.Atoi(label); err == nil {
			mask |= ESC_FAILURE_FLAGS(value)
		} else {
			return fmt.Errorf("invalid label '%s'", label)
		}
	}
	*e = mask
	return nil
}

// String implements the fmt.Stringer interface.
func (e ESC_FAILURE_FLAGS) String() string {
	val, _ := e.MarshalText()
	return string(val)
}
