//autogenerated:yes
//nolint:revive,misspell,govet,lll,dupl,gocritic
package common

import (
	"fmt"
	"strconv"
	"strings"
)

// Enable axes that will be tuned via autotuning. Used in MAV_CMD_DO_AUTOTUNE_ENABLE.
type AUTOTUNE_AXIS uint64

const (
	// Flight stack tunes axis according to its default settings.
	AUTOTUNE_AXIS_DEFAULT AUTOTUNE_AXIS = 0
	// Autotune roll axis.
	AUTOTUNE_AXIS_ROLL AUTOTUNE_AXIS = 1
	// Autotune pitch axis.
	AUTOTUNE_AXIS_PITCH AUTOTUNE_AXIS = 2
	// Autotune yaw axis.
	AUTOTUNE_AXIS_YAW AUTOTUNE_AXIS = 4
)

var labels_AUTOTUNE_AXIS = map[AUTOTUNE_AXIS]string{
	AUTOTUNE_AXIS_DEFAULT: "AUTOTUNE_AXIS_DEFAULT",
	AUTOTUNE_AXIS_ROLL:    "AUTOTUNE_AXIS_ROLL",
	AUTOTUNE_AXIS_PITCH:   "AUTOTUNE_AXIS_PITCH",
	AUTOTUNE_AXIS_YAW:     "AUTOTUNE_AXIS_YAW",
}

var values_AUTOTUNE_AXIS = map[string]AUTOTUNE_AXIS{
	"AUTOTUNE_AXIS_DEFAULT": AUTOTUNE_AXIS_DEFAULT,
	"AUTOTUNE_AXIS_ROLL":    AUTOTUNE_AXIS_ROLL,
	"AUTOTUNE_AXIS_PITCH":   AUTOTUNE_AXIS_PITCH,
	"AUTOTUNE_AXIS_YAW":     AUTOTUNE_AXIS_YAW,
}

// MarshalText implements the encoding.TextMarshaler interface.
func (e AUTOTUNE_AXIS) MarshalText() ([]byte, error) {
	if e == 0 {
		return []byte("0"), nil
	}
	var names []string
	for i := 0; i < 4; i++ {
		mask := AUTOTUNE_AXIS(1 << i)
		if e&mask == mask {
			names = append(names, labels_AUTOTUNE_AXIS[mask])
		}
	}
	return []byte(strings.Join(names, " | ")), nil
}

// UnmarshalText implements the encoding.TextUnmarshaler interface.
func (e *AUTOTUNE_AXIS) UnmarshalText(text []byte) error {
	labels := strings.Split(string(text), " | ")
	var mask AUTOTUNE_AXIS
	for _, label := range labels {
		if value, ok := values_AUTOTUNE_AXIS[label]; ok {
			mask |= value
		} else if value, err := strconv.Atoi(label); err == nil {
			mask |= AUTOTUNE_AXIS(value)
		} else {
			return fmt.Errorf("invalid label '%s'", label)
		}
	}
	*e = mask
	return nil
}

// String implements the fmt.Stringer interface.
func (e AUTOTUNE_AXIS) String() string {
	val, _ := e.MarshalText()
	return string(val)
}
