//autogenerated:yes
//nolint:revive,misspell,govet,lll,dupl,gocritic
package ardupilotmega

import (
	"fmt"
	"strconv"
)

// A mapping of sub flight modes for custom_mode field of heartbeat.
type SUB_MODE uint64

const (
	SUB_MODE_STABILIZE SUB_MODE = 0
	SUB_MODE_ACRO      SUB_MODE = 1
	SUB_MODE_ALT_HOLD  SUB_MODE = 2
	SUB_MODE_AUTO      SUB_MODE = 3
	SUB_MODE_GUIDED    SUB_MODE = 4
	SUB_MODE_CIRCLE    SUB_MODE = 7
	SUB_MODE_SURFACE   SUB_MODE = 9
	SUB_MODE_POSHOLD   SUB_MODE = 16
	SUB_MODE_MANUAL    SUB_MODE = 19
)

var labels_SUB_MODE = map[SUB_MODE]string{
	SUB_MODE_STABILIZE: "SUB_MODE_STABILIZE",
	SUB_MODE_ACRO:      "SUB_MODE_ACRO",
	SUB_MODE_ALT_HOLD:  "SUB_MODE_ALT_HOLD",
	SUB_MODE_AUTO:      "SUB_MODE_AUTO",
	SUB_MODE_GUIDED:    "SUB_MODE_GUIDED",
	SUB_MODE_CIRCLE:    "SUB_MODE_CIRCLE",
	SUB_MODE_SURFACE:   "SUB_MODE_SURFACE",
	SUB_MODE_POSHOLD:   "SUB_MODE_POSHOLD",
	SUB_MODE_MANUAL:    "SUB_MODE_MANUAL",
}

var values_SUB_MODE = map[string]SUB_MODE{
	"SUB_MODE_STABILIZE": SUB_MODE_STABILIZE,
	"SUB_MODE_ACRO":      SUB_MODE_ACRO,
	"SUB_MODE_ALT_HOLD":  SUB_MODE_ALT_HOLD,
	"SUB_MODE_AUTO":      SUB_MODE_AUTO,
	"SUB_MODE_GUIDED":    SUB_MODE_GUIDED,
	"SUB_MODE_CIRCLE":    SUB_MODE_CIRCLE,
	"SUB_MODE_SURFACE":   SUB_MODE_SURFACE,
	"SUB_MODE_POSHOLD":   SUB_MODE_POSHOLD,
	"SUB_MODE_MANUAL":    SUB_MODE_MANUAL,
}

// MarshalText implements the encoding.TextMarshaler interface.
func (e SUB_MODE) MarshalText() ([]byte, error) {
	if name, ok := labels_SUB_MODE[e]; ok {
		return []byte(name), nil
	}
	return []byte(strconv.Itoa(int(e))), nil
}

// UnmarshalText implements the encoding.TextUnmarshaler interface.
func (e *SUB_MODE) UnmarshalText(text []byte) error {
	if value, ok := values_SUB_MODE[string(text)]; ok {
		*e = value
	} else if value, err := strconv.Atoi(string(text)); err == nil {
		*e = SUB_MODE(value)
	} else {
		return fmt.Errorf("invalid label '%s'", text)
	}
	return nil
}

// String implements the fmt.Stringer interface.
func (e SUB_MODE) String() string {
	val, _ := e.MarshalText()
	return string(val)
}
