//autogenerated:yes
//nolint:revive,misspell,govet,lll,dupl,gocritic
package ardupilotmega

import (
	"fmt"
	"strconv"
)

type GOPRO_HEARTBEAT_STATUS uint64

const (
	// No GoPro connected.
	GOPRO_HEARTBEAT_STATUS_DISCONNECTED GOPRO_HEARTBEAT_STATUS = 0
	// The detected GoPro is not HeroBus compatible.
	GOPRO_HEARTBEAT_STATUS_INCOMPATIBLE GOPRO_HEARTBEAT_STATUS = 1
	// A HeroBus compatible GoPro is connected.
	GOPRO_HEARTBEAT_STATUS_CONNECTED GOPRO_HEARTBEAT_STATUS = 2
	// An unrecoverable error was encountered with the connected GoPro, it may require a power cycle.
	GOPRO_HEARTBEAT_STATUS_ERROR GOPRO_HEARTBEAT_STATUS = 3
)

var labels_GOPRO_HEARTBEAT_STATUS = map[GOPRO_HEARTBEAT_STATUS]string{
	GOPRO_HEARTBEAT_STATUS_DISCONNECTED: "GOPRO_HEARTBEAT_STATUS_DISCONNECTED",
	GOPRO_HEARTBEAT_STATUS_INCOMPATIBLE: "GOPRO_HEARTBEAT_STATUS_INCOMPATIBLE",
	GOPRO_HEARTBEAT_STATUS_CONNECTED:    "GOPRO_HEARTBEAT_STATUS_CONNECTED",
	GOPRO_HEARTBEAT_STATUS_ERROR:        "GOPRO_HEARTBEAT_STATUS_ERROR",
}

var values_GOPRO_HEARTBEAT_STATUS = map[string]GOPRO_HEARTBEAT_STATUS{
	"GOPRO_HEARTBEAT_STATUS_DISCONNECTED": GOPRO_HEARTBEAT_STATUS_DISCONNECTED,
	"GOPRO_HEARTBEAT_STATUS_INCOMPATIBLE": GOPRO_HEARTBEAT_STATUS_INCOMPATIBLE,
	"GOPRO_HEARTBEAT_STATUS_CONNECTED":    GOPRO_HEARTBEAT_STATUS_CONNECTED,
	"GOPRO_HEARTBEAT_STATUS_ERROR":        GOPRO_HEARTBEAT_STATUS_ERROR,
}

// MarshalText implements the encoding.TextMarshaler interface.
func (e GOPRO_HEARTBEAT_STATUS) MarshalText() ([]byte, error) {
	if name, ok := labels_GOPRO_HEARTBEAT_STATUS[e]; ok {
		return []byte(name), nil
	}
	return []byte(strconv.Itoa(int(e))), nil
}

// UnmarshalText implements the encoding.TextUnmarshaler interface.
func (e *GOPRO_HEARTBEAT_STATUS) UnmarshalText(text []byte) error {
	if value, ok := values_GOPRO_HEARTBEAT_STATUS[string(text)]; ok {
		*e = value
	} else if value, err := strconv.Atoi(string(text)); err == nil {
		*e = GOPRO_HEARTBEAT_STATUS(value)
	} else {
		return fmt.Errorf("invalid label '%s'", text)
	}
	return nil
}

// String implements the fmt.Stringer interface.
func (e GOPRO_HEARTBEAT_STATUS) String() string {
	val, _ := e.MarshalText()
	return string(val)
}
