//autogenerated:yes
//nolint:revive,misspell,govet,lll,dupl,gocritic
package ardupilotmega

import (
	"fmt"
	"strconv"
)

type GOPRO_CHARGING uint64

const (
	// Charging disabled.
	GOPRO_CHARGING_DISABLED GOPRO_CHARGING = 0
	// Charging enabled.
	GOPRO_CHARGING_ENABLED GOPRO_CHARGING = 1
)

var labels_GOPRO_CHARGING = map[GOPRO_CHARGING]string{
	GOPRO_CHARGING_DISABLED: "GOPRO_CHARGING_DISABLED",
	GOPRO_CHARGING_ENABLED:  "GOPRO_CHARGING_ENABLED",
}

var values_GOPRO_CHARGING = map[string]GOPRO_CHARGING{
	"GOPRO_CHARGING_DISABLED": GOPRO_CHARGING_DISABLED,
	"GOPRO_CHARGING_ENABLED":  GOPRO_CHARGING_ENABLED,
}

// MarshalText implements the encoding.TextMarshaler interface.
func (e GOPRO_CHARGING) MarshalText() ([]byte, error) {
	if name, ok := labels_GOPRO_CHARGING[e]; ok {
		return []byte(name), nil
	}
	return []byte(strconv.Itoa(int(e))), nil
}

// UnmarshalText implements the encoding.TextUnmarshaler interface.
func (e *GOPRO_CHARGING) UnmarshalText(text []byte) error {
	if value, ok := values_GOPRO_CHARGING[string(text)]; ok {
		*e = value
	} else if value, err := strconv.Atoi(string(text)); err == nil {
		*e = GOPRO_CHARGING(value)
	} else {
		return fmt.Errorf("invalid label '%s'", text)
	}
	return nil
}

// String implements the fmt.Stringer interface.
func (e GOPRO_CHARGING) String() string {
	val, _ := e.MarshalText()
	return string(val)
}
