//autogenerated:yes
//nolint:revive,misspell,govet,lll,dupl,gocritic
package ardupilotmega

import (
	"fmt"
	"strconv"
)

type GIMBAL_AXIS uint64

const (
	// Gimbal yaw axis.
	GIMBAL_AXIS_YAW GIMBAL_AXIS = 0
	// Gimbal pitch axis.
	GIMBAL_AXIS_PITCH GIMBAL_AXIS = 1
	// Gimbal roll axis.
	GIMBAL_AXIS_ROLL GIMBAL_AXIS = 2
)

var labels_GIMBAL_AXIS = map[GIMBAL_AXIS]string{
	GIMBAL_AXIS_YAW:   "GIMBAL_AXIS_YAW",
	GIMBAL_AXIS_PITCH: "GIMBAL_AXIS_PITCH",
	GIMBAL_AXIS_ROLL:  "GIMBAL_AXIS_ROLL",
}

var values_GIMBAL_AXIS = map[string]GIMBAL_AXIS{
	"GIMBAL_AXIS_YAW":   GIMBAL_AXIS_YAW,
	"GIMBAL_AXIS_PITCH": GIMBAL_AXIS_PITCH,
	"GIMBAL_AXIS_ROLL":  GIMBAL_AXIS_ROLL,
}

// MarshalText implements the encoding.TextMarshaler interface.
func (e GIMBAL_AXIS) MarshalText() ([]byte, error) {
	if name, ok := labels_GIMBAL_AXIS[e]; ok {
		return []byte(name), nil
	}
	return []byte(strconv.Itoa(int(e))), nil
}

// UnmarshalText implements the encoding.TextUnmarshaler interface.
func (e *GIMBAL_AXIS) UnmarshalText(text []byte) error {
	if value, ok := values_GIMBAL_AXIS[string(text)]; ok {
		*e = value
	} else if value, err := strconv.Atoi(string(text)); err == nil {
		*e = GIMBAL_AXIS(value)
	} else {
		return fmt.Errorf("invalid label '%s'", text)
	}
	return nil
}

// String implements the fmt.Stringer interface.
func (e GIMBAL_AXIS) String() string {
	val, _ := e.MarshalText()
	return string(val)
}
