//autogenerated:yes
//nolint:revive,misspell,govet,lll,dupl,gocritic
package ardupilotmega

import (
	"fmt"
	"strconv"
)

// Bus types for device operations.
type DEVICE_OP_BUSTYPE uint64

const (
	// I2C Device operation.
	DEVICE_OP_BUSTYPE_I2C DEVICE_OP_BUSTYPE = 0
	// SPI Device operation.
	DEVICE_OP_BUSTYPE_SPI DEVICE_OP_BUSTYPE = 1
)

var labels_DEVICE_OP_BUSTYPE = map[DEVICE_OP_BUSTYPE]string{
	DEVICE_OP_BUSTYPE_I2C: "DEVICE_OP_BUSTYPE_I2C",
	DEVICE_OP_BUSTYPE_SPI: "DEVICE_OP_BUSTYPE_SPI",
}

var values_DEVICE_OP_BUSTYPE = map[string]DEVICE_OP_BUSTYPE{
	"DEVICE_OP_BUSTYPE_I2C": DEVICE_OP_BUSTYPE_I2C,
	"DEVICE_OP_BUSTYPE_SPI": DEVICE_OP_BUSTYPE_SPI,
}

// MarshalText implements the encoding.TextMarshaler interface.
func (e DEVICE_OP_BUSTYPE) MarshalText() ([]byte, error) {
	if name, ok := labels_DEVICE_OP_BUSTYPE[e]; ok {
		return []byte(name), nil
	}
	return []byte(strconv.Itoa(int(e))), nil
}

// UnmarshalText implements the encoding.TextUnmarshaler interface.
func (e *DEVICE_OP_BUSTYPE) UnmarshalText(text []byte) error {
	if value, ok := values_DEVICE_OP_BUSTYPE[string(text)]; ok {
		*e = value
	} else if value, err := strconv.Atoi(string(text)); err == nil {
		*e = DEVICE_OP_BUSTYPE(value)
	} else {
		return fmt.Errorf("invalid label '%s'", text)
	}
	return nil
}

// String implements the fmt.Stringer interface.
func (e DEVICE_OP_BUSTYPE) String() string {
	val, _ := e.MarshalText()
	return string(val)
}
