//go:build go1.6 && (codecgen || generated)
// +build go1.6
// +build codecgen generated

// Code generated by codecgen - DO NOT EDIT.

package codec

import (
	"errors"
	"runtime"
	"sort"
	"strconv"
	"time"
)

const (
	// ----- content types ----
	codecSelferCcUTF819780 = 1
	codecSelferCcRAW19780  = 255
	// ----- value types used ----
	codecSelferValueTypeArray19780     = 10
	codecSelferValueTypeMap19780       = 9
	codecSelferValueTypeString19780    = 6
	codecSelferValueTypeInt19780       = 2
	codecSelferValueTypeUint19780      = 3
	codecSelferValueTypeFloat19780     = 4
	codecSelferValueTypeNil19780       = 1
	codecSelferBitsize19780            = uint8(32 << (^uint(0) >> 63))
	codecSelferDecContainerLenNil19780 = -2147483648
)

var (
	errCodecSelferOnlyMapOrArrayEncodeToStruct19780                = errors.New(`only encoded map or array can be decoded into a struct`)
	_                                               sort.Interface = nil
)

type codecSelfer19780 struct{}

func codecSelfer19780False() bool { return false }
func codecSelfer19780True() bool  { return true }

type codecSelfer19780stringSlice []string

func (p codecSelfer19780stringSlice) Len() int           { return len(p) }
func (p codecSelfer19780stringSlice) Swap(i, j int)      { p[uint(i)], p[uint(j)] = p[uint(j)], p[uint(i)] }
func (p codecSelfer19780stringSlice) Less(i, j int) bool { return p[uint(i)] < p[uint(j)] }

type codecSelfer19780uint64Slice []uint64

func (p codecSelfer19780uint64Slice) Len() int           { return len(p) }
func (p codecSelfer19780uint64Slice) Swap(i, j int)      { p[uint(i)], p[uint(j)] = p[uint(j)], p[uint(i)] }
func (p codecSelfer19780uint64Slice) Less(i, j int) bool { return p[uint(i)] < p[uint(j)] }

type codecSelfer19780int64Slice []int64

func (p codecSelfer19780int64Slice) Len() int           { return len(p) }
func (p codecSelfer19780int64Slice) Swap(i, j int)      { p[uint(i)], p[uint(j)] = p[uint(j)], p[uint(i)] }
func (p codecSelfer19780int64Slice) Less(i, j int) bool { return p[uint(i)] < p[uint(j)] }

type codecSelfer19780float64Slice []float64

func (p codecSelfer19780float64Slice) Len() int           { return len(p) }
func (p codecSelfer19780float64Slice) Swap(i, j int)      { p[uint(i)], p[uint(j)] = p[uint(j)], p[uint(i)] }
func (p codecSelfer19780float64Slice) Less(i, j int) bool { return p[uint(i)] < p[uint(j)] }

func init() {
	if GenVersion != 28 {
		_, file, _, _ := runtime.Caller(0)
		ver := strconv.FormatInt(int64(GenVersion), 10)
		panic(errors.New("codecgen version mismatch: current: 28, need " + ver + ". Re-generate file: " + file))
	}
	if false { // reference the types, but skip this branch at build/run time
		var _ time.Time
	}
}

func (wrapSliceUint64) codecSelferViaCodecgen() {}
func (x wrapSliceUint64) CodecEncodeSelf(e *Encoder) {
	var h codecSelfer19780
	z, r := GenHelper().Encoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		z.F.EncSliceUint64V(([]uint64)(x), e)
	} // end block: if x slice == nil
}

func (x *wrapSliceUint64) CodecDecodeSelf(d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelper().Decoder(d)
	_, _, _ = h, z, r
	z.F.DecSliceUint64X((*[]uint64)(x), d)
}

func (wrapSliceString) codecSelferViaCodecgen() {}
func (x wrapSliceString) CodecEncodeSelf(e *Encoder) {
	var h codecSelfer19780
	z, r := GenHelper().Encoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		z.F.EncSliceStringV(([]string)(x), e)
	} // end block: if x slice == nil
}

func (x *wrapSliceString) CodecDecodeSelf(d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelper().Decoder(d)
	_, _, _ = h, z, r
	z.F.DecSliceStringX((*[]string)(x), d)
}

func (wrapUint64) codecSelferViaCodecgen() {}
func (x wrapUint64) CodecEncodeSelf(e *Encoder) {
	var h codecSelfer19780
	z, r := GenHelper().Encoder(e)
	_, _, _ = h, z, r
	r.EncodeUint(uint64(x))
}

func (x *wrapUint64) CodecDecodeSelf(d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelper().Decoder(d)
	_, _, _ = h, z, r
	*x = (wrapUint64)(r.DecodeUint64())
}

func (wrapString) codecSelferViaCodecgen() {}
func (x wrapString) CodecEncodeSelf(e *Encoder) {
	var h codecSelfer19780
	z, r := GenHelper().Encoder(e)
	_, _, _ = h, z, r
	r.EncodeString(string(x))
}

func (x *wrapString) CodecDecodeSelf(d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelper().Decoder(d)
	_, _, _ = h, z, r
	*x = (wrapString)(z.DecStringZC(r.DecodeStringAsBytes()))
}

func (wrapUint64Slice) codecSelferViaCodecgen() {}
func (x wrapUint64Slice) CodecEncodeSelf(e *Encoder) {
	var h codecSelfer19780
	z, r := GenHelper().Encoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		h.encwrapUint64Slice((wrapUint64Slice)(x), e)
	} // end block: if x slice == nil
}

func (x *wrapUint64Slice) CodecDecodeSelf(d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelper().Decoder(d)
	_, _, _ = h, z, r
	h.decwrapUint64Slice((*wrapUint64Slice)(x), d)
}

func (wrapStringSlice) codecSelferViaCodecgen() {}
func (x wrapStringSlice) CodecEncodeSelf(e *Encoder) {
	var h codecSelfer19780
	z, r := GenHelper().Encoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		h.encwrapStringSlice((wrapStringSlice)(x), e)
	} // end block: if x slice == nil
}

func (x *wrapStringSlice) CodecDecodeSelf(d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelper().Decoder(d)
	_, _, _ = h, z, r
	h.decwrapStringSlice((*wrapStringSlice)(x), d)
}

func (stringUint64T) codecSelferViaCodecgen() {}
func (x *stringUint64T) CodecEncodeSelf(e *Encoder) {
	var h codecSelfer19780
	z, r := GenHelper().Encoder(e)
	_, _, _ = h, z, r
	if z.EncBasicHandle().CheckCircularRef {
		z.EncEncode(x)
		return
	}
	if x == nil {
		r.EncodeNil()
	} else {
		yy2arr2 := z.EncBasicHandle().StructToArray
		_ = yy2arr2
		const yyr2 bool = false // struct tag has 'toArray'
		if yyr2 || yy2arr2 {
			z.EncWriteArrayStart(2)
			z.EncWriteArrayElem()
			r.EncodeString(string(x.S))
			z.EncWriteArrayElem()
			r.EncodeUint(uint64(x.U))
			z.EncWriteArrayEnd()
		} else {
			z.EncWriteMapStart(2)
			if z.EncBasicHandle().Canonical {
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"S\"")
				} else {
					r.EncodeString(`S`)
				}
				z.EncWriteMapElemValue()
				r.EncodeString(string(x.S))
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"U\"")
				} else {
					r.EncodeString(`U`)
				}
				z.EncWriteMapElemValue()
				r.EncodeUint(uint64(x.U))
			} else {
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"S\"")
				} else {
					r.EncodeString(`S`)
				}
				z.EncWriteMapElemValue()
				r.EncodeString(string(x.S))
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"U\"")
				} else {
					r.EncodeString(`U`)
				}
				z.EncWriteMapElemValue()
				r.EncodeUint(uint64(x.U))
			}
			z.EncWriteMapEnd()
		}
	}
}

func (x *stringUint64T) CodecDecodeSelf(d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelper().Decoder(d)
	_, _, _ = h, z, r
	yyct2 := r.ContainerType()
	if yyct2 == codecSelferValueTypeNil19780 {
		*(x) = stringUint64T{}
	} else if yyct2 == codecSelferValueTypeMap19780 {
		yyl2 := z.DecReadMapStart()
		if yyl2 == 0 {
		} else {
			x.codecDecodeSelfFromMap(yyl2, d)
		}
		z.DecReadMapEnd()
	} else if yyct2 == codecSelferValueTypeArray19780 {
		yyl2 := z.DecReadArrayStart()
		if yyl2 != 0 {
			x.codecDecodeSelfFromArray(yyl2, d)
		}
		z.DecReadArrayEnd()
	} else {
		panic(errCodecSelferOnlyMapOrArrayEncodeToStruct19780)
	}
}

func (x *stringUint64T) codecDecodeSelfFromMap(l int, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelper().Decoder(d)
	_, _, _ = h, z, r
	var yyhl3 bool = l >= 0
	for yyj3 := 0; z.DecContainerNext(yyj3, l, yyhl3); yyj3++ {
		z.DecReadMapElemKey()
		yys3 := r.DecodeStringAsBytes()
		z.DecReadMapElemValue()
		switch string(yys3) {
		case "S":
			x.S = (string)(z.DecStringZC(r.DecodeStringAsBytes()))
		case "U":
			x.U = (uint64)(r.DecodeUint64())
		default:
			z.DecStructFieldNotFound(-1, string(yys3))
		} // end switch yys3
	} // end for yyj3
}

func (x *stringUint64T) codecDecodeSelfFromArray(l int, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelper().Decoder(d)
	_, _, _ = h, z, r
	var yyj6 int
	var yyb6 bool
	var yyhl6 bool = l >= 0
	yyb6 = !z.DecContainerNext(yyj6, l, yyhl6)
	if yyb6 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.S = (string)(z.DecStringZC(r.DecodeStringAsBytes()))
	yyj6++
	yyb6 = !z.DecContainerNext(yyj6, l, yyhl6)
	if yyb6 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.U = (uint64)(r.DecodeUint64())
	yyj6++
	for ; z.DecContainerNext(yyj6, l, yyhl6); yyj6++ {
		z.DecReadArrayElem()
		z.DecStructFieldNotFound(yyj6-1, "")
	}
}

func (x *stringUint64T) IsCodecEmpty() bool {
	return !(x.S != "" || x.U != 0 || false)
}

func (AnonInTestStrucSlim) codecSelferViaCodecgen() {}
func (x *AnonInTestStrucSlim) CodecEncodeSelf(e *Encoder) {
	var h codecSelfer19780
	z, r := GenHelper().Encoder(e)
	_, _, _ = h, z, r
	if z.EncBasicHandle().CheckCircularRef {
		z.EncEncode(x)
		return
	}
	if x == nil {
		r.EncodeNil()
	} else {
		yy2arr2 := z.EncBasicHandle().StructToArray
		_ = yy2arr2
		const yyr2 bool = false // struct tag has 'toArray'
		var yyn4 bool = x.P == nil
		if yyr2 || yy2arr2 {
			z.EncWriteArrayStart(2)
			z.EncWriteArrayElem()
			r.EncodeString(string(x.S))
			if yyn4 {
				z.EncWriteArrayElem()
				r.EncodeNil()
			} else {
				z.EncWriteArrayElem()
				yy6 := *x.P
				r.EncodeString(string(yy6))
			}
			z.EncWriteArrayEnd()
		} else {
			z.EncWriteMapStart(2)
			if z.EncBasicHandle().Canonical {
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"P\"")
				} else {
					r.EncodeString(`P`)
				}
				z.EncWriteMapElemValue()
				if yyn4 {
					r.EncodeNil()
				} else {
					yy8 := *x.P
					r.EncodeString(string(yy8))
				}
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"S\"")
				} else {
					r.EncodeString(`S`)
				}
				z.EncWriteMapElemValue()
				r.EncodeString(string(x.S))
			} else {
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"S\"")
				} else {
					r.EncodeString(`S`)
				}
				z.EncWriteMapElemValue()
				r.EncodeString(string(x.S))
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"P\"")
				} else {
					r.EncodeString(`P`)
				}
				z.EncWriteMapElemValue()
				if yyn4 {
					r.EncodeNil()
				} else {
					yy12 := *x.P
					r.EncodeString(string(yy12))
				}
			}
			z.EncWriteMapEnd()
		}
	}
}

func (x *AnonInTestStrucSlim) CodecDecodeSelf(d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelper().Decoder(d)
	_, _, _ = h, z, r
	yyct2 := r.ContainerType()
	if yyct2 == codecSelferValueTypeNil19780 {
		*(x) = AnonInTestStrucSlim{}
	} else if yyct2 == codecSelferValueTypeMap19780 {
		yyl2 := z.DecReadMapStart()
		if yyl2 == 0 {
		} else {
			x.codecDecodeSelfFromMap(yyl2, d)
		}
		z.DecReadMapEnd()
	} else if yyct2 == codecSelferValueTypeArray19780 {
		yyl2 := z.DecReadArrayStart()
		if yyl2 != 0 {
			x.codecDecodeSelfFromArray(yyl2, d)
		}
		z.DecReadArrayEnd()
	} else {
		panic(errCodecSelferOnlyMapOrArrayEncodeToStruct19780)
	}
}

func (x *AnonInTestStrucSlim) codecDecodeSelfFromMap(l int, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelper().Decoder(d)
	_, _, _ = h, z, r
	var yyhl3 bool = l >= 0
	for yyj3 := 0; z.DecContainerNext(yyj3, l, yyhl3); yyj3++ {
		z.DecReadMapElemKey()
		yys3 := r.DecodeStringAsBytes()
		z.DecReadMapElemValue()
		switch string(yys3) {
		case "S":
			x.S = (string)(z.DecStringZC(r.DecodeStringAsBytes()))
		case "P":
			if r.TryNil() {
				if x.P != nil { // remove the if-true
					x.P = nil
				}
			} else {
				if x.P == nil {
					x.P = new(string)
				}
				*x.P = (string)(z.DecStringZC(r.DecodeStringAsBytes()))
			}
		default:
			z.DecStructFieldNotFound(-1, string(yys3))
		} // end switch yys3
	} // end for yyj3
}

func (x *AnonInTestStrucSlim) codecDecodeSelfFromArray(l int, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelper().Decoder(d)
	_, _, _ = h, z, r
	var yyj7 int
	var yyb7 bool
	var yyhl7 bool = l >= 0
	yyb7 = !z.DecContainerNext(yyj7, l, yyhl7)
	if yyb7 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.S = (string)(z.DecStringZC(r.DecodeStringAsBytes()))
	yyj7++
	yyb7 = !z.DecContainerNext(yyj7, l, yyhl7)
	if yyb7 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	if r.TryNil() {
		if x.P != nil { // remove the if-true
			x.P = nil
		}
	} else {
		if x.P == nil {
			x.P = new(string)
		}
		*x.P = (string)(z.DecStringZC(r.DecodeStringAsBytes()))
	}
	yyj7++
	for ; z.DecContainerNext(yyj7, l, yyhl7); yyj7++ {
		z.DecReadArrayElem()
		z.DecStructFieldNotFound(yyj7-1, "")
	}
}

func (x *AnonInTestStrucSlim) IsCodecEmpty() bool {
	return !(x.S != "" || false)
}

func (AnonInTestStruc) codecSelferViaCodecgen() {}
func (x *AnonInTestStruc) CodecEncodeSelf(e *Encoder) {
	var h codecSelfer19780
	z, r := GenHelper().Encoder(e)
	_, _, _ = h, z, r
	if z.EncBasicHandle().CheckCircularRef {
		z.EncEncode(x)
		return
	}
	if x == nil {
		r.EncodeNil()
	} else {
		yy2arr2 := z.EncBasicHandle().StructToArray
		_ = yy2arr2
		const yyr2 bool = false // struct tag has 'toArray'
		if yyr2 || yy2arr2 {
			z.EncWriteArrayStart(17)
			z.EncWriteArrayElem()
			r.EncodeString(string(x.AS))
			z.EncWriteArrayElem()
			r.EncodeInt(int64(x.AI64))
			z.EncWriteArrayElem()
			r.EncodeInt(int64(x.AI16))
			z.EncWriteArrayElem()
			r.EncodeUint(uint64(x.AUi64))
			z.EncWriteArrayElem()
			if x.ASslice == nil {
				r.EncodeNil()
			} else {
				z.F.EncSliceStringV(x.ASslice, e)
			} // end block: if x.ASslice slice == nil
			z.EncWriteArrayElem()
			if x.AI64slice == nil {
				r.EncodeNil()
			} else {
				z.F.EncSliceInt64V(x.AI64slice, e)
			} // end block: if x.AI64slice slice == nil
			z.EncWriteArrayElem()
			if x.AUi64slice == nil {
				r.EncodeNil()
			} else {
				z.F.EncSliceUint64V(x.AUi64slice, e)
			} // end block: if x.AUi64slice slice == nil
			z.EncWriteArrayElem()
			if x.AF64slice == nil {
				r.EncodeNil()
			} else {
				z.F.EncSliceFloat64V(x.AF64slice, e)
			} // end block: if x.AF64slice slice == nil
			z.EncWriteArrayElem()
			if x.AF32slice == nil {
				r.EncodeNil()
			} else {
				z.F.EncSliceFloat32V(x.AF32slice, e)
			} // end block: if x.AF32slice slice == nil
			z.EncWriteArrayElem()
			if x.AMSS == nil {
				r.EncodeNil()
			} else {
				z.F.EncMapStringStringV(x.AMSS, e)
			} // end block: if x.AMSS map == nil
			z.EncWriteArrayElem()
			if x.AMSU64 == nil {
				r.EncodeNil()
			} else {
				z.F.EncMapStringUint64V(x.AMSU64, e)
			} // end block: if x.AMSU64 map == nil
			z.EncWriteArrayElem()
			yy31 := &x.AI64arr8
			h.encArray8int64((*[8]int64)(yy31), e)
			z.EncWriteArrayElem()
			yy33 := &x.AI64arr0
			h.encArray0int64((*[0]int64)(yy33), e)
			z.EncWriteArrayElem()
			if x.AI64slice0 == nil {
				r.EncodeNil()
			} else {
				z.F.EncSliceInt64V(x.AI64slice0, e)
			} // end block: if x.AI64slice0 slice == nil
			z.EncWriteArrayElem()
			if x.AUi64sliceN == nil {
				r.EncodeNil()
			} else {
				z.F.EncSliceUint64V(x.AUi64sliceN, e)
			} // end block: if x.AUi64sliceN slice == nil
			z.EncWriteArrayElem()
			if x.AMSU64N == nil {
				r.EncodeNil()
			} else {
				z.F.EncMapStringUint64V(x.AMSU64N, e)
			} // end block: if x.AMSU64N map == nil
			z.EncWriteArrayElem()
			if x.AMSU64E == nil {
				r.EncodeNil()
			} else {
				z.F.EncMapStringUint64V(x.AMSU64E, e)
			} // end block: if x.AMSU64E map == nil
			z.EncWriteArrayEnd()
		} else {
			z.EncWriteMapStart(17)
			if z.EncBasicHandle().Canonical {
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"AF32slice\"")
				} else {
					r.EncodeString(`AF32slice`)
				}
				z.EncWriteMapElemValue()
				if x.AF32slice == nil {
					r.EncodeNil()
				} else {
					z.F.EncSliceFloat32V(x.AF32slice, e)
				} // end block: if x.AF32slice slice == nil
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"AF64slice\"")
				} else {
					r.EncodeString(`AF64slice`)
				}
				z.EncWriteMapElemValue()
				if x.AF64slice == nil {
					r.EncodeNil()
				} else {
					z.F.EncSliceFloat64V(x.AF64slice, e)
				} // end block: if x.AF64slice slice == nil
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"AI16\"")
				} else {
					r.EncodeString(`AI16`)
				}
				z.EncWriteMapElemValue()
				r.EncodeInt(int64(x.AI16))
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"AI64\"")
				} else {
					r.EncodeString(`AI64`)
				}
				z.EncWriteMapElemValue()
				r.EncodeInt(int64(x.AI64))
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"AI64arr0\"")
				} else {
					r.EncodeString(`AI64arr0`)
				}
				z.EncWriteMapElemValue()
				yy43 := &x.AI64arr0
				h.encArray0int64((*[0]int64)(yy43), e)
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"AI64arr8\"")
				} else {
					r.EncodeString(`AI64arr8`)
				}
				z.EncWriteMapElemValue()
				yy45 := &x.AI64arr8
				h.encArray8int64((*[8]int64)(yy45), e)
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"AI64slice\"")
				} else {
					r.EncodeString(`AI64slice`)
				}
				z.EncWriteMapElemValue()
				if x.AI64slice == nil {
					r.EncodeNil()
				} else {
					z.F.EncSliceInt64V(x.AI64slice, e)
				} // end block: if x.AI64slice slice == nil
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"AI64slice0\"")
				} else {
					r.EncodeString(`AI64slice0`)
				}
				z.EncWriteMapElemValue()
				if x.AI64slice0 == nil {
					r.EncodeNil()
				} else {
					z.F.EncSliceInt64V(x.AI64slice0, e)
				} // end block: if x.AI64slice0 slice == nil
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"AMSS\"")
				} else {
					r.EncodeString(`AMSS`)
				}
				z.EncWriteMapElemValue()
				if x.AMSS == nil {
					r.EncodeNil()
				} else {
					z.F.EncMapStringStringV(x.AMSS, e)
				} // end block: if x.AMSS map == nil
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"AMSU64\"")
				} else {
					r.EncodeString(`AMSU64`)
				}
				z.EncWriteMapElemValue()
				if x.AMSU64 == nil {
					r.EncodeNil()
				} else {
					z.F.EncMapStringUint64V(x.AMSU64, e)
				} // end block: if x.AMSU64 map == nil
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"AMSU64E\"")
				} else {
					r.EncodeString(`AMSU64E`)
				}
				z.EncWriteMapElemValue()
				if x.AMSU64E == nil {
					r.EncodeNil()
				} else {
					z.F.EncMapStringUint64V(x.AMSU64E, e)
				} // end block: if x.AMSU64E map == nil
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"AMSU64N\"")
				} else {
					r.EncodeString(`AMSU64N`)
				}
				z.EncWriteMapElemValue()
				if x.AMSU64N == nil {
					r.EncodeNil()
				} else {
					z.F.EncMapStringUint64V(x.AMSU64N, e)
				} // end block: if x.AMSU64N map == nil
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"AS\"")
				} else {
					r.EncodeString(`AS`)
				}
				z.EncWriteMapElemValue()
				r.EncodeString(string(x.AS))
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"ASslice\"")
				} else {
					r.EncodeString(`ASslice`)
				}
				z.EncWriteMapElemValue()
				if x.ASslice == nil {
					r.EncodeNil()
				} else {
					z.F.EncSliceStringV(x.ASslice, e)
				} // end block: if x.ASslice slice == nil
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"AUi64\"")
				} else {
					r.EncodeString(`AUi64`)
				}
				z.EncWriteMapElemValue()
				r.EncodeUint(uint64(x.AUi64))
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"AUi64slice\"")
				} else {
					r.EncodeString(`AUi64slice`)
				}
				z.EncWriteMapElemValue()
				if x.AUi64slice == nil {
					r.EncodeNil()
				} else {
					z.F.EncSliceUint64V(x.AUi64slice, e)
				} // end block: if x.AUi64slice slice == nil
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"AUi64sliceN\"")
				} else {
					r.EncodeString(`AUi64sliceN`)
				}
				z.EncWriteMapElemValue()
				if x.AUi64sliceN == nil {
					r.EncodeNil()
				} else {
					z.F.EncSliceUint64V(x.AUi64sliceN, e)
				} // end block: if x.AUi64sliceN slice == nil
			} else {
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"AS\"")
				} else {
					r.EncodeString(`AS`)
				}
				z.EncWriteMapElemValue()
				r.EncodeString(string(x.AS))
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"AI64\"")
				} else {
					r.EncodeString(`AI64`)
				}
				z.EncWriteMapElemValue()
				r.EncodeInt(int64(x.AI64))
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"AI16\"")
				} else {
					r.EncodeString(`AI16`)
				}
				z.EncWriteMapElemValue()
				r.EncodeInt(int64(x.AI16))
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"AUi64\"")
				} else {
					r.EncodeString(`AUi64`)
				}
				z.EncWriteMapElemValue()
				r.EncodeUint(uint64(x.AUi64))
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"ASslice\"")
				} else {
					r.EncodeString(`ASslice`)
				}
				z.EncWriteMapElemValue()
				if x.ASslice == nil {
					r.EncodeNil()
				} else {
					z.F.EncSliceStringV(x.ASslice, e)
				} // end block: if x.ASslice slice == nil
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"AI64slice\"")
				} else {
					r.EncodeString(`AI64slice`)
				}
				z.EncWriteMapElemValue()
				if x.AI64slice == nil {
					r.EncodeNil()
				} else {
					z.F.EncSliceInt64V(x.AI64slice, e)
				} // end block: if x.AI64slice slice == nil
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"AUi64slice\"")
				} else {
					r.EncodeString(`AUi64slice`)
				}
				z.EncWriteMapElemValue()
				if x.AUi64slice == nil {
					r.EncodeNil()
				} else {
					z.F.EncSliceUint64V(x.AUi64slice, e)
				} // end block: if x.AUi64slice slice == nil
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"AF64slice\"")
				} else {
					r.EncodeString(`AF64slice`)
				}
				z.EncWriteMapElemValue()
				if x.AF64slice == nil {
					r.EncodeNil()
				} else {
					z.F.EncSliceFloat64V(x.AF64slice, e)
				} // end block: if x.AF64slice slice == nil
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"AF32slice\"")
				} else {
					r.EncodeString(`AF32slice`)
				}
				z.EncWriteMapElemValue()
				if x.AF32slice == nil {
					r.EncodeNil()
				} else {
					z.F.EncSliceFloat32V(x.AF32slice, e)
				} // end block: if x.AF32slice slice == nil
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"AMSS\"")
				} else {
					r.EncodeString(`AMSS`)
				}
				z.EncWriteMapElemValue()
				if x.AMSS == nil {
					r.EncodeNil()
				} else {
					z.F.EncMapStringStringV(x.AMSS, e)
				} // end block: if x.AMSS map == nil
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"AMSU64\"")
				} else {
					r.EncodeString(`AMSU64`)
				}
				z.EncWriteMapElemValue()
				if x.AMSU64 == nil {
					r.EncodeNil()
				} else {
					z.F.EncMapStringUint64V(x.AMSU64, e)
				} // end block: if x.AMSU64 map == nil
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"AI64arr8\"")
				} else {
					r.EncodeString(`AI64arr8`)
				}
				z.EncWriteMapElemValue()
				yy69 := &x.AI64arr8
				h.encArray8int64((*[8]int64)(yy69), e)
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"AI64arr0\"")
				} else {
					r.EncodeString(`AI64arr0`)
				}
				z.EncWriteMapElemValue()
				yy71 := &x.AI64arr0
				h.encArray0int64((*[0]int64)(yy71), e)
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"AI64slice0\"")
				} else {
					r.EncodeString(`AI64slice0`)
				}
				z.EncWriteMapElemValue()
				if x.AI64slice0 == nil {
					r.EncodeNil()
				} else {
					z.F.EncSliceInt64V(x.AI64slice0, e)
				} // end block: if x.AI64slice0 slice == nil
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"AUi64sliceN\"")
				} else {
					r.EncodeString(`AUi64sliceN`)
				}
				z.EncWriteMapElemValue()
				if x.AUi64sliceN == nil {
					r.EncodeNil()
				} else {
					z.F.EncSliceUint64V(x.AUi64sliceN, e)
				} // end block: if x.AUi64sliceN slice == nil
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"AMSU64N\"")
				} else {
					r.EncodeString(`AMSU64N`)
				}
				z.EncWriteMapElemValue()
				if x.AMSU64N == nil {
					r.EncodeNil()
				} else {
					z.F.EncMapStringUint64V(x.AMSU64N, e)
				} // end block: if x.AMSU64N map == nil
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"AMSU64E\"")
				} else {
					r.EncodeString(`AMSU64E`)
				}
				z.EncWriteMapElemValue()
				if x.AMSU64E == nil {
					r.EncodeNil()
				} else {
					z.F.EncMapStringUint64V(x.AMSU64E, e)
				} // end block: if x.AMSU64E map == nil
			}
			z.EncWriteMapEnd()
		}
	}
}

func (x *AnonInTestStruc) CodecDecodeSelf(d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelper().Decoder(d)
	_, _, _ = h, z, r
	yyct2 := r.ContainerType()
	if yyct2 == codecSelferValueTypeNil19780 {
		*(x) = AnonInTestStruc{}
	} else if yyct2 == codecSelferValueTypeMap19780 {
		yyl2 := z.DecReadMapStart()
		if yyl2 == 0 {
		} else {
			x.codecDecodeSelfFromMap(yyl2, d)
		}
		z.DecReadMapEnd()
	} else if yyct2 == codecSelferValueTypeArray19780 {
		yyl2 := z.DecReadArrayStart()
		if yyl2 != 0 {
			x.codecDecodeSelfFromArray(yyl2, d)
		}
		z.DecReadArrayEnd()
	} else {
		panic(errCodecSelferOnlyMapOrArrayEncodeToStruct19780)
	}
}

func (x *AnonInTestStruc) codecDecodeSelfFromMap(l int, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelper().Decoder(d)
	_, _, _ = h, z, r
	var yyhl3 bool = l >= 0
	for yyj3 := 0; z.DecContainerNext(yyj3, l, yyhl3); yyj3++ {
		z.DecReadMapElemKey()
		yys3 := r.DecodeStringAsBytes()
		z.DecReadMapElemValue()
		switch string(yys3) {
		case "AS":
			x.AS = (string)(z.DecStringZC(r.DecodeStringAsBytes()))
		case "AI64":
			x.AI64 = (int64)(r.DecodeInt64())
		case "AI16":
			x.AI16 = (int16)(z.C.IntV(r.DecodeInt64(), 16))
		case "AUi64":
			x.AUi64 = (uint64)(r.DecodeUint64())
		case "ASslice":
			z.F.DecSliceStringX(&x.ASslice, d)
		case "AI64slice":
			z.F.DecSliceInt64X(&x.AI64slice, d)
		case "AUi64slice":
			z.F.DecSliceUint64X(&x.AUi64slice, d)
		case "AF64slice":
			z.F.DecSliceFloat64X(&x.AF64slice, d)
		case "AF32slice":
			z.F.DecSliceFloat32X(&x.AF32slice, d)
		case "AMSS":
			z.F.DecMapStringStringX(&x.AMSS, d)
		case "AMSU64":
			z.F.DecMapStringUint64X(&x.AMSU64, d)
		case "AI64arr8":
			h.decArray8int64((*[8]int64)(&x.AI64arr8), d)
		case "AI64arr0":
			h.decArray0int64((*[0]int64)(&x.AI64arr0), d)
		case "AI64slice0":
			z.F.DecSliceInt64X(&x.AI64slice0, d)
		case "AUi64sliceN":
			z.F.DecSliceUint64X(&x.AUi64sliceN, d)
		case "AMSU64N":
			z.F.DecMapStringUint64X(&x.AMSU64N, d)
		case "AMSU64E":
			z.F.DecMapStringUint64X(&x.AMSU64E, d)
		default:
			z.DecStructFieldNotFound(-1, string(yys3))
		} // end switch yys3
	} // end for yyj3
}

func (x *AnonInTestStruc) codecDecodeSelfFromArray(l int, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelper().Decoder(d)
	_, _, _ = h, z, r
	var yyj34 int
	var yyb34 bool
	var yyhl34 bool = l >= 0
	yyb34 = !z.DecContainerNext(yyj34, l, yyhl34)
	if yyb34 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.AS = (string)(z.DecStringZC(r.DecodeStringAsBytes()))
	yyj34++
	yyb34 = !z.DecContainerNext(yyj34, l, yyhl34)
	if yyb34 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.AI64 = (int64)(r.DecodeInt64())
	yyj34++
	yyb34 = !z.DecContainerNext(yyj34, l, yyhl34)
	if yyb34 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.AI16 = (int16)(z.C.IntV(r.DecodeInt64(), 16))
	yyj34++
	yyb34 = !z.DecContainerNext(yyj34, l, yyhl34)
	if yyb34 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.AUi64 = (uint64)(r.DecodeUint64())
	yyj34++
	yyb34 = !z.DecContainerNext(yyj34, l, yyhl34)
	if yyb34 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	z.F.DecSliceStringX(&x.ASslice, d)
	yyj34++
	yyb34 = !z.DecContainerNext(yyj34, l, yyhl34)
	if yyb34 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	z.F.DecSliceInt64X(&x.AI64slice, d)
	yyj34++
	yyb34 = !z.DecContainerNext(yyj34, l, yyhl34)
	if yyb34 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	z.F.DecSliceUint64X(&x.AUi64slice, d)
	yyj34++
	yyb34 = !z.DecContainerNext(yyj34, l, yyhl34)
	if yyb34 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	z.F.DecSliceFloat64X(&x.AF64slice, d)
	yyj34++
	yyb34 = !z.DecContainerNext(yyj34, l, yyhl34)
	if yyb34 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	z.F.DecSliceFloat32X(&x.AF32slice, d)
	yyj34++
	yyb34 = !z.DecContainerNext(yyj34, l, yyhl34)
	if yyb34 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	z.F.DecMapStringStringX(&x.AMSS, d)
	yyj34++
	yyb34 = !z.DecContainerNext(yyj34, l, yyhl34)
	if yyb34 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	z.F.DecMapStringUint64X(&x.AMSU64, d)
	yyj34++
	yyb34 = !z.DecContainerNext(yyj34, l, yyhl34)
	if yyb34 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	h.decArray8int64((*[8]int64)(&x.AI64arr8), d)
	yyj34++
	yyb34 = !z.DecContainerNext(yyj34, l, yyhl34)
	if yyb34 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	h.decArray0int64((*[0]int64)(&x.AI64arr0), d)
	yyj34++
	yyb34 = !z.DecContainerNext(yyj34, l, yyhl34)
	if yyb34 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	z.F.DecSliceInt64X(&x.AI64slice0, d)
	yyj34++
	yyb34 = !z.DecContainerNext(yyj34, l, yyhl34)
	if yyb34 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	z.F.DecSliceUint64X(&x.AUi64sliceN, d)
	yyj34++
	yyb34 = !z.DecContainerNext(yyj34, l, yyhl34)
	if yyb34 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	z.F.DecMapStringUint64X(&x.AMSU64N, d)
	yyj34++
	yyb34 = !z.DecContainerNext(yyj34, l, yyhl34)
	if yyb34 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	z.F.DecMapStringUint64X(&x.AMSU64E, d)
	yyj34++
	for ; z.DecContainerNext(yyj34, l, yyhl34); yyj34++ {
		z.DecReadArrayElem()
		z.DecStructFieldNotFound(yyj34-1, "")
	}
}

func (x *AnonInTestStruc) IsCodecEmpty() bool {
	return !(x.AS != "" || x.AI64 != 0 || x.AI16 != 0 || x.AUi64 != 0 || len(x.ASslice) != 0 || len(x.AI64slice) != 0 || len(x.AUi64slice) != 0 || len(x.AF64slice) != 0 || len(x.AF32slice) != 0 || len(x.AMSS) != 0 || len(x.AMSU64) != 0 || x.AI64arr8 != [8]int64{} || false || len(x.AI64slice0) != 0 || len(x.AUi64sliceN) != 0 || len(x.AMSU64N) != 0 || len(x.AMSU64E) != 0 || false)
}

func (testSimpleFields) codecSelferViaCodecgen() {}
func (x *testSimpleFields) CodecEncodeSelf(e *Encoder) {
	var h codecSelfer19780
	z, r := GenHelper().Encoder(e)
	_, _, _ = h, z, r
	if z.EncBasicHandle().CheckCircularRef {
		z.EncEncode(x)
		return
	}
	if x == nil {
		r.EncodeNil()
	} else {
		yy2arr2 := z.EncBasicHandle().StructToArray
		_ = yy2arr2
		const yyr2 bool = false // struct tag has 'toArray'
		if yyr2 || yy2arr2 {
			z.EncWriteArrayStart(17)
			z.EncWriteArrayElem()
			r.EncodeString(string(x.S))
			z.EncWriteArrayElem()
			r.EncodeInt(int64(x.I64))
			z.EncWriteArrayElem()
			r.EncodeInt(int64(x.I8))
			z.EncWriteArrayElem()
			r.EncodeUint(uint64(x.Ui64))
			z.EncWriteArrayElem()
			r.EncodeUint(uint64(x.Ui8))
			z.EncWriteArrayElem()
			r.EncodeFloat64(float64(x.F64))
			z.EncWriteArrayElem()
			r.EncodeFloat32(float32(x.F32))
			z.EncWriteArrayElem()
			r.EncodeBool(bool(x.B))
			z.EncWriteArrayElem()
			if x.Sslice == nil {
				r.EncodeNil()
			} else {
				z.F.EncSliceStringV(x.Sslice, e)
			} // end block: if x.Sslice slice == nil
			z.EncWriteArrayElem()
			if x.I32slice == nil {
				r.EncodeNil()
			} else {
				z.F.EncSliceInt32V(x.I32slice, e)
			} // end block: if x.I32slice slice == nil
			z.EncWriteArrayElem()
			if x.Ui64slice == nil {
				r.EncodeNil()
			} else {
				z.F.EncSliceUint64V(x.Ui64slice, e)
			} // end block: if x.Ui64slice slice == nil
			z.EncWriteArrayElem()
			if x.Ui8slice == nil {
				r.EncodeNil()
			} else {
				r.EncodeStringBytesRaw([]byte(x.Ui8slice))
			} // end block: if x.Ui8slice slice == nil
			z.EncWriteArrayElem()
			if x.Bslice == nil {
				r.EncodeNil()
			} else {
				z.F.EncSliceBoolV(x.Bslice, e)
			} // end block: if x.Bslice slice == nil
			z.EncWriteArrayElem()
			if x.Iptrslice == nil {
				r.EncodeNil()
			} else {
				h.encSlicePtrtoint64(([]*int64)(x.Iptrslice), e)
			} // end block: if x.Iptrslice slice == nil
			z.EncWriteArrayElem()
			if yyxt34 := z.Extension(x.WrapSliceInt64); yyxt34 != nil {
				z.EncExtension(x.WrapSliceInt64, yyxt34)
			} else {
				x.WrapSliceInt64.CodecEncodeSelf(e)
			}
			z.EncWriteArrayElem()
			if yyxt35 := z.Extension(x.WrapSliceString); yyxt35 != nil {
				z.EncExtension(x.WrapSliceString, yyxt35)
			} else {
				x.WrapSliceString.CodecEncodeSelf(e)
			}
			z.EncWriteArrayElem()
			if x.Msint == nil {
				r.EncodeNil()
			} else {
				z.F.EncMapStringIntV(x.Msint, e)
			} // end block: if x.Msint map == nil
			z.EncWriteArrayEnd()
		} else {
			z.EncWriteMapStart(17)
			if z.EncBasicHandle().Canonical {
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"B\"")
				} else {
					r.EncodeString(`B`)
				}
				z.EncWriteMapElemValue()
				r.EncodeBool(bool(x.B))
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"Bslice\"")
				} else {
					r.EncodeString(`Bslice`)
				}
				z.EncWriteMapElemValue()
				if x.Bslice == nil {
					r.EncodeNil()
				} else {
					z.F.EncSliceBoolV(x.Bslice, e)
				} // end block: if x.Bslice slice == nil
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"F32\"")
				} else {
					r.EncodeString(`F32`)
				}
				z.EncWriteMapElemValue()
				r.EncodeFloat32(float32(x.F32))
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"F64\"")
				} else {
					r.EncodeString(`F64`)
				}
				z.EncWriteMapElemValue()
				r.EncodeFloat64(float64(x.F64))
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"I32slice\"")
				} else {
					r.EncodeString(`I32slice`)
				}
				z.EncWriteMapElemValue()
				if x.I32slice == nil {
					r.EncodeNil()
				} else {
					z.F.EncSliceInt32V(x.I32slice, e)
				} // end block: if x.I32slice slice == nil
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"I64\"")
				} else {
					r.EncodeString(`I64`)
				}
				z.EncWriteMapElemValue()
				r.EncodeInt(int64(x.I64))
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"I8\"")
				} else {
					r.EncodeString(`I8`)
				}
				z.EncWriteMapElemValue()
				r.EncodeInt(int64(x.I8))
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"Iptrslice\"")
				} else {
					r.EncodeString(`Iptrslice`)
				}
				z.EncWriteMapElemValue()
				if x.Iptrslice == nil {
					r.EncodeNil()
				} else {
					h.encSlicePtrtoint64(([]*int64)(x.Iptrslice), e)
				} // end block: if x.Iptrslice slice == nil
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"Msint\"")
				} else {
					r.EncodeString(`Msint`)
				}
				z.EncWriteMapElemValue()
				if x.Msint == nil {
					r.EncodeNil()
				} else {
					z.F.EncMapStringIntV(x.Msint, e)
				} // end block: if x.Msint map == nil
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"S\"")
				} else {
					r.EncodeString(`S`)
				}
				z.EncWriteMapElemValue()
				r.EncodeString(string(x.S))
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"Sslice\"")
				} else {
					r.EncodeString(`Sslice`)
				}
				z.EncWriteMapElemValue()
				if x.Sslice == nil {
					r.EncodeNil()
				} else {
					z.F.EncSliceStringV(x.Sslice, e)
				} // end block: if x.Sslice slice == nil
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"Ui64\"")
				} else {
					r.EncodeString(`Ui64`)
				}
				z.EncWriteMapElemValue()
				r.EncodeUint(uint64(x.Ui64))
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"Ui64slice\"")
				} else {
					r.EncodeString(`Ui64slice`)
				}
				z.EncWriteMapElemValue()
				if x.Ui64slice == nil {
					r.EncodeNil()
				} else {
					z.F.EncSliceUint64V(x.Ui64slice, e)
				} // end block: if x.Ui64slice slice == nil
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"Ui8\"")
				} else {
					r.EncodeString(`Ui8`)
				}
				z.EncWriteMapElemValue()
				r.EncodeUint(uint64(x.Ui8))
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"Ui8slice\"")
				} else {
					r.EncodeString(`Ui8slice`)
				}
				z.EncWriteMapElemValue()
				if x.Ui8slice == nil {
					r.EncodeNil()
				} else {
					r.EncodeStringBytesRaw([]byte(x.Ui8slice))
				} // end block: if x.Ui8slice slice == nil
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"WrapSliceInt64\"")
				} else {
					r.EncodeString(`WrapSliceInt64`)
				}
				z.EncWriteMapElemValue()
				if yyxt52 := z.Extension(x.WrapSliceInt64); yyxt52 != nil {
					z.EncExtension(x.WrapSliceInt64, yyxt52)
				} else {
					x.WrapSliceInt64.CodecEncodeSelf(e)
				}
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"WrapSliceString\"")
				} else {
					r.EncodeString(`WrapSliceString`)
				}
				z.EncWriteMapElemValue()
				if yyxt53 := z.Extension(x.WrapSliceString); yyxt53 != nil {
					z.EncExtension(x.WrapSliceString, yyxt53)
				} else {
					x.WrapSliceString.CodecEncodeSelf(e)
				}
			} else {
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"S\"")
				} else {
					r.EncodeString(`S`)
				}
				z.EncWriteMapElemValue()
				r.EncodeString(string(x.S))
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"I64\"")
				} else {
					r.EncodeString(`I64`)
				}
				z.EncWriteMapElemValue()
				r.EncodeInt(int64(x.I64))
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"I8\"")
				} else {
					r.EncodeString(`I8`)
				}
				z.EncWriteMapElemValue()
				r.EncodeInt(int64(x.I8))
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"Ui64\"")
				} else {
					r.EncodeString(`Ui64`)
				}
				z.EncWriteMapElemValue()
				r.EncodeUint(uint64(x.Ui64))
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"Ui8\"")
				} else {
					r.EncodeString(`Ui8`)
				}
				z.EncWriteMapElemValue()
				r.EncodeUint(uint64(x.Ui8))
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"F64\"")
				} else {
					r.EncodeString(`F64`)
				}
				z.EncWriteMapElemValue()
				r.EncodeFloat64(float64(x.F64))
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"F32\"")
				} else {
					r.EncodeString(`F32`)
				}
				z.EncWriteMapElemValue()
				r.EncodeFloat32(float32(x.F32))
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"B\"")
				} else {
					r.EncodeString(`B`)
				}
				z.EncWriteMapElemValue()
				r.EncodeBool(bool(x.B))
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"Sslice\"")
				} else {
					r.EncodeString(`Sslice`)
				}
				z.EncWriteMapElemValue()
				if x.Sslice == nil {
					r.EncodeNil()
				} else {
					z.F.EncSliceStringV(x.Sslice, e)
				} // end block: if x.Sslice slice == nil
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"I32slice\"")
				} else {
					r.EncodeString(`I32slice`)
				}
				z.EncWriteMapElemValue()
				if x.I32slice == nil {
					r.EncodeNil()
				} else {
					z.F.EncSliceInt32V(x.I32slice, e)
				} // end block: if x.I32slice slice == nil
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"Ui64slice\"")
				} else {
					r.EncodeString(`Ui64slice`)
				}
				z.EncWriteMapElemValue()
				if x.Ui64slice == nil {
					r.EncodeNil()
				} else {
					z.F.EncSliceUint64V(x.Ui64slice, e)
				} // end block: if x.Ui64slice slice == nil
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"Ui8slice\"")
				} else {
					r.EncodeString(`Ui8slice`)
				}
				z.EncWriteMapElemValue()
				if x.Ui8slice == nil {
					r.EncodeNil()
				} else {
					r.EncodeStringBytesRaw([]byte(x.Ui8slice))
				} // end block: if x.Ui8slice slice == nil
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"Bslice\"")
				} else {
					r.EncodeString(`Bslice`)
				}
				z.EncWriteMapElemValue()
				if x.Bslice == nil {
					r.EncodeNil()
				} else {
					z.F.EncSliceBoolV(x.Bslice, e)
				} // end block: if x.Bslice slice == nil
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"Iptrslice\"")
				} else {
					r.EncodeString(`Iptrslice`)
				}
				z.EncWriteMapElemValue()
				if x.Iptrslice == nil {
					r.EncodeNil()
				} else {
					h.encSlicePtrtoint64(([]*int64)(x.Iptrslice), e)
				} // end block: if x.Iptrslice slice == nil
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"WrapSliceInt64\"")
				} else {
					r.EncodeString(`WrapSliceInt64`)
				}
				z.EncWriteMapElemValue()
				if yyxt68 := z.Extension(x.WrapSliceInt64); yyxt68 != nil {
					z.EncExtension(x.WrapSliceInt64, yyxt68)
				} else {
					x.WrapSliceInt64.CodecEncodeSelf(e)
				}
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"WrapSliceString\"")
				} else {
					r.EncodeString(`WrapSliceString`)
				}
				z.EncWriteMapElemValue()
				if yyxt69 := z.Extension(x.WrapSliceString); yyxt69 != nil {
					z.EncExtension(x.WrapSliceString, yyxt69)
				} else {
					x.WrapSliceString.CodecEncodeSelf(e)
				}
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"Msint\"")
				} else {
					r.EncodeString(`Msint`)
				}
				z.EncWriteMapElemValue()
				if x.Msint == nil {
					r.EncodeNil()
				} else {
					z.F.EncMapStringIntV(x.Msint, e)
				} // end block: if x.Msint map == nil
			}
			z.EncWriteMapEnd()
		}
	}
}

func (x *testSimpleFields) CodecDecodeSelf(d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelper().Decoder(d)
	_, _, _ = h, z, r
	yyct2 := r.ContainerType()
	if yyct2 == codecSelferValueTypeNil19780 {
		*(x) = testSimpleFields{}
	} else if yyct2 == codecSelferValueTypeMap19780 {
		yyl2 := z.DecReadMapStart()
		if yyl2 == 0 {
		} else {
			x.codecDecodeSelfFromMap(yyl2, d)
		}
		z.DecReadMapEnd()
	} else if yyct2 == codecSelferValueTypeArray19780 {
		yyl2 := z.DecReadArrayStart()
		if yyl2 != 0 {
			x.codecDecodeSelfFromArray(yyl2, d)
		}
		z.DecReadArrayEnd()
	} else {
		panic(errCodecSelferOnlyMapOrArrayEncodeToStruct19780)
	}
}

func (x *testSimpleFields) codecDecodeSelfFromMap(l int, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelper().Decoder(d)
	_, _, _ = h, z, r
	var yyhl3 bool = l >= 0
	for yyj3 := 0; z.DecContainerNext(yyj3, l, yyhl3); yyj3++ {
		z.DecReadMapElemKey()
		yys3 := r.DecodeStringAsBytes()
		z.DecReadMapElemValue()
		switch string(yys3) {
		case "S":
			x.S = (string)(z.DecStringZC(r.DecodeStringAsBytes()))
		case "I64":
			x.I64 = (int64)(r.DecodeInt64())
		case "I8":
			x.I8 = (int8)(z.C.IntV(r.DecodeInt64(), 8))
		case "Ui64":
			x.Ui64 = (uint64)(r.DecodeUint64())
		case "Ui8":
			x.Ui8 = (uint8)(z.C.UintV(r.DecodeUint64(), 8))
		case "F64":
			x.F64 = (float64)(r.DecodeFloat64())
		case "F32":
			x.F32 = (float32)(z.DecDecodeFloat32())
		case "B":
			x.B = (bool)(r.DecodeBool())
		case "Sslice":
			z.F.DecSliceStringX(&x.Sslice, d)
		case "I32slice":
			z.F.DecSliceInt32X(&x.I32slice, d)
		case "Ui64slice":
			z.F.DecSliceUint64X(&x.Ui64slice, d)
		case "Ui8slice":
			x.Ui8slice = z.DecodeBytesInto(([]byte)(x.Ui8slice))
		case "Bslice":
			z.F.DecSliceBoolX(&x.Bslice, d)
		case "Iptrslice":
			h.decSlicePtrtoint64((*[]*int64)(&x.Iptrslice), d)
		case "WrapSliceInt64":
			if yyxt25 := z.Extension(x.WrapSliceInt64); yyxt25 != nil {
				z.DecExtension(&x.WrapSliceInt64, yyxt25)
			} else {
				x.WrapSliceInt64.CodecDecodeSelf(d)
			}
		case "WrapSliceString":
			if yyxt27 := z.Extension(x.WrapSliceString); yyxt27 != nil {
				z.DecExtension(&x.WrapSliceString, yyxt27)
			} else {
				x.WrapSliceString.CodecDecodeSelf(d)
			}
		case "Msint":
			z.F.DecMapStringIntX(&x.Msint, d)
		default:
			z.DecStructFieldNotFound(-1, string(yys3))
		} // end switch yys3
	} // end for yyj3
}

func (x *testSimpleFields) codecDecodeSelfFromArray(l int, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelper().Decoder(d)
	_, _, _ = h, z, r
	var yyj30 int
	var yyb30 bool
	var yyhl30 bool = l >= 0
	yyb30 = !z.DecContainerNext(yyj30, l, yyhl30)
	if yyb30 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.S = (string)(z.DecStringZC(r.DecodeStringAsBytes()))
	yyj30++
	yyb30 = !z.DecContainerNext(yyj30, l, yyhl30)
	if yyb30 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.I64 = (int64)(r.DecodeInt64())
	yyj30++
	yyb30 = !z.DecContainerNext(yyj30, l, yyhl30)
	if yyb30 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.I8 = (int8)(z.C.IntV(r.DecodeInt64(), 8))
	yyj30++
	yyb30 = !z.DecContainerNext(yyj30, l, yyhl30)
	if yyb30 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.Ui64 = (uint64)(r.DecodeUint64())
	yyj30++
	yyb30 = !z.DecContainerNext(yyj30, l, yyhl30)
	if yyb30 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.Ui8 = (uint8)(z.C.UintV(r.DecodeUint64(), 8))
	yyj30++
	yyb30 = !z.DecContainerNext(yyj30, l, yyhl30)
	if yyb30 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.F64 = (float64)(r.DecodeFloat64())
	yyj30++
	yyb30 = !z.DecContainerNext(yyj30, l, yyhl30)
	if yyb30 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.F32 = (float32)(z.DecDecodeFloat32())
	yyj30++
	yyb30 = !z.DecContainerNext(yyj30, l, yyhl30)
	if yyb30 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.B = (bool)(r.DecodeBool())
	yyj30++
	yyb30 = !z.DecContainerNext(yyj30, l, yyhl30)
	if yyb30 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	z.F.DecSliceStringX(&x.Sslice, d)
	yyj30++
	yyb30 = !z.DecContainerNext(yyj30, l, yyhl30)
	if yyb30 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	z.F.DecSliceInt32X(&x.I32slice, d)
	yyj30++
	yyb30 = !z.DecContainerNext(yyj30, l, yyhl30)
	if yyb30 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	z.F.DecSliceUint64X(&x.Ui64slice, d)
	yyj30++
	yyb30 = !z.DecContainerNext(yyj30, l, yyhl30)
	if yyb30 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.Ui8slice = z.DecodeBytesInto(([]byte)(x.Ui8slice))
	yyj30++
	yyb30 = !z.DecContainerNext(yyj30, l, yyhl30)
	if yyb30 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	z.F.DecSliceBoolX(&x.Bslice, d)
	yyj30++
	yyb30 = !z.DecContainerNext(yyj30, l, yyhl30)
	if yyb30 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	h.decSlicePtrtoint64((*[]*int64)(&x.Iptrslice), d)
	yyj30++
	yyb30 = !z.DecContainerNext(yyj30, l, yyhl30)
	if yyb30 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	if yyxt52 := z.Extension(x.WrapSliceInt64); yyxt52 != nil {
		z.DecExtension(&x.WrapSliceInt64, yyxt52)
	} else {
		x.WrapSliceInt64.CodecDecodeSelf(d)
	}
	yyj30++
	yyb30 = !z.DecContainerNext(yyj30, l, yyhl30)
	if yyb30 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	if yyxt54 := z.Extension(x.WrapSliceString); yyxt54 != nil {
		z.DecExtension(&x.WrapSliceString, yyxt54)
	} else {
		x.WrapSliceString.CodecDecodeSelf(d)
	}
	yyj30++
	yyb30 = !z.DecContainerNext(yyj30, l, yyhl30)
	if yyb30 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	z.F.DecMapStringIntX(&x.Msint, d)
	yyj30++
	for ; z.DecContainerNext(yyj30, l, yyhl30); yyj30++ {
		z.DecReadArrayElem()
		z.DecStructFieldNotFound(yyj30-1, "")
	}
}

func (x *testSimpleFields) IsCodecEmpty() bool {
	return !(x.S != "" || x.I64 != 0 || x.I8 != 0 || x.Ui64 != 0 || x.Ui8 != 0 || x.F64 != 0 || x.F32 != 0 || bool(x.B) || len(x.Sslice) != 0 || len(x.I32slice) != 0 || len(x.Ui64slice) != 0 || len(x.Ui8slice) != 0 || len(x.Bslice) != 0 || len(x.Iptrslice) != 0 || len(x.WrapSliceInt64) != 0 || len(x.WrapSliceString) != 0 || len(x.Msint) != 0 || false)
}

func (TestStrucCommon) codecSelferViaCodecgen() {}
func (x *TestStrucCommon) CodecEncodeSelf(e *Encoder) {
	var h codecSelfer19780
	z, r := GenHelper().Encoder(e)
	_, _, _ = h, z, r
	if z.EncBasicHandle().CheckCircularRef {
		z.EncEncode(x)
		return
	}
	if x == nil {
		r.EncodeNil()
	} else {
		yy2arr2 := z.EncBasicHandle().StructToArray
		_ = yy2arr2
		const yyr2 bool = false // struct tag has 'toArray'
		var yyn54 bool = x.AnonInTestStrucSlim == nil || x.AnonInTestStrucSlim.P == nil
		var yyn55 bool = x.NotAnonSlim == nil
		var yyn58 bool = x.Nint64 == nil
		if yyr2 || yy2arr2 {
			z.EncWriteArrayStart(56)
			z.EncWriteArrayElem()
			r.EncodeString(string(x.S))
			z.EncWriteArrayElem()
			r.EncodeInt(int64(x.I64))
			z.EncWriteArrayElem()
			r.EncodeInt(int64(x.I32))
			z.EncWriteArrayElem()
			r.EncodeInt(int64(x.I16))
			z.EncWriteArrayElem()
			r.EncodeInt(int64(x.I8))
			z.EncWriteArrayElem()
			r.EncodeInt(int64(x.I64n))
			z.EncWriteArrayElem()
			r.EncodeInt(int64(x.I32n))
			z.EncWriteArrayElem()
			r.EncodeInt(int64(x.I16n))
			z.EncWriteArrayElem()
			r.EncodeInt(int64(x.I8n))
			z.EncWriteArrayElem()
			r.EncodeUint(uint64(x.Ui64))
			z.EncWriteArrayElem()
			r.EncodeUint(uint64(x.Ui32))
			z.EncWriteArrayElem()
			r.EncodeUint(uint64(x.Ui16))
			z.EncWriteArrayElem()
			r.EncodeUint(uint64(x.Ui8))
			z.EncWriteArrayElem()
			r.EncodeFloat64(float64(x.F64))
			z.EncWriteArrayElem()
			r.EncodeFloat32(float32(x.F32))
			z.EncWriteArrayElem()
			r.EncodeBool(bool(x.B))
			z.EncWriteArrayElem()
			r.EncodeUint(uint64(x.By))
			z.EncWriteArrayElem()
			if x.Sslice == nil {
				r.EncodeNil()
			} else {
				z.F.EncSliceStringV(x.Sslice, e)
			} // end block: if x.Sslice slice == nil
			z.EncWriteArrayElem()
			if x.I64slice == nil {
				r.EncodeNil()
			} else {
				z.F.EncSliceInt64V(x.I64slice, e)
			} // end block: if x.I64slice slice == nil
			z.EncWriteArrayElem()
			if x.I32slice == nil {
				r.EncodeNil()
			} else {
				z.F.EncSliceInt32V(x.I32slice, e)
			} // end block: if x.I32slice slice == nil
			z.EncWriteArrayElem()
			if x.Ui64slice == nil {
				r.EncodeNil()
			} else {
				z.F.EncSliceUint64V(x.Ui64slice, e)
			} // end block: if x.Ui64slice slice == nil
			z.EncWriteArrayElem()
			if x.Ui8slice == nil {
				r.EncodeNil()
			} else {
				r.EncodeStringBytesRaw([]byte(x.Ui8slice))
			} // end block: if x.Ui8slice slice == nil
			z.EncWriteArrayElem()
			if x.Bslice == nil {
				r.EncodeNil()
			} else {
				z.F.EncSliceBoolV(x.Bslice, e)
			} // end block: if x.Bslice slice == nil
			z.EncWriteArrayElem()
			if x.Byslice == nil {
				r.EncodeNil()
			} else {
				r.EncodeStringBytesRaw([]byte(x.Byslice))
			} // end block: if x.Byslice slice == nil
			z.EncWriteArrayElem()
			if x.BytesSlice == nil {
				r.EncodeNil()
			} else {
				z.F.EncSliceBytesV(x.BytesSlice, e)
			} // end block: if x.BytesSlice slice == nil
			z.EncWriteArrayElem()
			if x.Iptrslice == nil {
				r.EncodeNil()
			} else {
				h.encSlicePtrtoint64(([]*int64)(x.Iptrslice), e)
			} // end block: if x.Iptrslice slice == nil
			z.EncWriteArrayElem()
			if yyxt85 := z.Extension(x.WrapSliceInt64); yyxt85 != nil {
				z.EncExtension(x.WrapSliceInt64, yyxt85)
			} else {
				x.WrapSliceInt64.CodecEncodeSelf(e)
			}
			z.EncWriteArrayElem()
			if yyxt86 := z.Extension(x.WrapSliceString); yyxt86 != nil {
				z.EncExtension(x.WrapSliceString, yyxt86)
			} else {
				x.WrapSliceString.CodecEncodeSelf(e)
			}
			z.EncWriteArrayElem()
			if x.Msint == nil {
				r.EncodeNil()
			} else {
				z.F.EncMapStringIntV(x.Msint, e)
			} // end block: if x.Msint map == nil
			z.EncWriteArrayElem()
			if x.Msbytes == nil {
				r.EncodeNil()
			} else {
				z.F.EncMapStringBytesV(x.Msbytes, e)
			} // end block: if x.Msbytes map == nil
			z.EncWriteArrayElem()
			yy89 := &x.Simplef
			if yyxt90 := z.Extension(yy89); yyxt90 != nil {
				z.EncExtension(yy89, yyxt90)
			} else {
				yy89.CodecEncodeSelf(e)
			}
			z.EncWriteArrayElem()
			if x.SstrUi64T == nil {
				r.EncodeNil()
			} else {
				h.encSlicestringUint64T(([]stringUint64T)(x.SstrUi64T), e)
			} // end block: if x.SstrUi64T slice == nil
			z.EncWriteArrayElem()
			if x.MstrUi64T == nil {
				r.EncodeNil()
			} else {
				h.encMapstringPtrtostringUint64T((map[string]*stringUint64T)(x.MstrUi64T), e)
			} // end block: if x.MstrUi64T map == nil
			z.EncWriteArrayElem()
			r.EncodeString(string(x.AnonInTestStruc.AS))
			z.EncWriteArrayElem()
			r.EncodeInt(int64(x.AnonInTestStruc.AI64))
			z.EncWriteArrayElem()
			r.EncodeInt(int64(x.AnonInTestStruc.AI16))
			z.EncWriteArrayElem()
			r.EncodeUint(uint64(x.AnonInTestStruc.AUi64))
			z.EncWriteArrayElem()
			if x.AnonInTestStruc.ASslice == nil {
				r.EncodeNil()
			} else {
				z.F.EncSliceStringV(x.AnonInTestStruc.ASslice, e)
			} // end block: if x.AnonInTestStruc.ASslice slice == nil
			z.EncWriteArrayElem()
			if x.AnonInTestStruc.AI64slice == nil {
				r.EncodeNil()
			} else {
				z.F.EncSliceInt64V(x.AnonInTestStruc.AI64slice, e)
			} // end block: if x.AnonInTestStruc.AI64slice slice == nil
			z.EncWriteArrayElem()
			if x.AnonInTestStruc.AUi64slice == nil {
				r.EncodeNil()
			} else {
				z.F.EncSliceUint64V(x.AnonInTestStruc.AUi64slice, e)
			} // end block: if x.AnonInTestStruc.AUi64slice slice == nil
			z.EncWriteArrayElem()
			if x.AnonInTestStruc.AF64slice == nil {
				r.EncodeNil()
			} else {
				z.F.EncSliceFloat64V(x.AnonInTestStruc.AF64slice, e)
			} // end block: if x.AnonInTestStruc.AF64slice slice == nil
			z.EncWriteArrayElem()
			if x.AnonInTestStruc.AF32slice == nil {
				r.EncodeNil()
			} else {
				z.F.EncSliceFloat32V(x.AnonInTestStruc.AF32slice, e)
			} // end block: if x.AnonInTestStruc.AF32slice slice == nil
			z.EncWriteArrayElem()
			if x.AnonInTestStruc.AMSS == nil {
				r.EncodeNil()
			} else {
				z.F.EncMapStringStringV(x.AnonInTestStruc.AMSS, e)
			} // end block: if x.AnonInTestStruc.AMSS map == nil
			z.EncWriteArrayElem()
			if x.AnonInTestStruc.AMSU64 == nil {
				r.EncodeNil()
			} else {
				z.F.EncMapStringUint64V(x.AnonInTestStruc.AMSU64, e)
			} // end block: if x.AnonInTestStruc.AMSU64 map == nil
			z.EncWriteArrayElem()
			yy104 := &x.AnonInTestStruc.AI64arr8
			h.encArray8int64((*[8]int64)(yy104), e)
			z.EncWriteArrayElem()
			yy106 := &x.AnonInTestStruc.AI64arr0
			h.encArray0int64((*[0]int64)(yy106), e)
			z.EncWriteArrayElem()
			if x.AnonInTestStruc.AI64slice0 == nil {
				r.EncodeNil()
			} else {
				z.F.EncSliceInt64V(x.AnonInTestStruc.AI64slice0, e)
			} // end block: if x.AnonInTestStruc.AI64slice0 slice == nil
			z.EncWriteArrayElem()
			if x.AnonInTestStruc.AUi64sliceN == nil {
				r.EncodeNil()
			} else {
				z.F.EncSliceUint64V(x.AnonInTestStruc.AUi64sliceN, e)
			} // end block: if x.AnonInTestStruc.AUi64sliceN slice == nil
			z.EncWriteArrayElem()
			if x.AnonInTestStruc.AMSU64N == nil {
				r.EncodeNil()
			} else {
				z.F.EncMapStringUint64V(x.AnonInTestStruc.AMSU64N, e)
			} // end block: if x.AnonInTestStruc.AMSU64N map == nil
			z.EncWriteArrayElem()
			if x.AnonInTestStruc.AMSU64E == nil {
				r.EncodeNil()
			} else {
				z.F.EncMapStringUint64V(x.AnonInTestStruc.AMSU64E, e)
			} // end block: if x.AnonInTestStruc.AMSU64E map == nil
			z.EncWriteArrayElem()
			yy112 := &x.NotAnon
			if yyxt113 := z.Extension(yy112); yyxt113 != nil {
				z.EncExtension(yy112, yyxt113)
			} else {
				yy112.CodecEncodeSelf(e)
			}
			if yyn54 {
				z.EncWriteArrayElem()
				r.EncodeNil()
			} else {
				z.EncWriteArrayElem()
				yy114 := *x.AnonInTestStrucSlim.P
				r.EncodeString(string(yy114))
			}
			if yyn55 {
				z.EncWriteArrayElem()
				r.EncodeNil()
			} else {
				z.EncWriteArrayElem()
				if yyxt116 := z.Extension(x.NotAnonSlim); yyxt116 != nil {
					z.EncExtension(x.NotAnonSlim, yyxt116)
				} else {
					x.NotAnonSlim.CodecEncodeSelf(e)
				}
			}
			z.EncWriteArrayElem()
			if x.Nmap == nil {
				r.EncodeNil()
			} else {
				z.F.EncMapStringBoolV(x.Nmap, e)
			} // end block: if x.Nmap map == nil
			z.EncWriteArrayElem()
			if x.Nslice == nil {
				r.EncodeNil()
			} else {
				r.EncodeStringBytesRaw([]byte(x.Nslice))
			} // end block: if x.Nslice slice == nil
			if yyn58 {
				z.EncWriteArrayElem()
				r.EncodeNil()
			} else {
				z.EncWriteArrayElem()
				yy119 := *x.Nint64
				r.EncodeInt(int64(yy119))
			}
			z.EncWriteArrayEnd()
		} else {
			z.EncWriteMapStart(56)
			if z.EncBasicHandle().Canonical {
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"AF32slice\"")
				} else {
					r.EncodeString(`AF32slice`)
				}
				z.EncWriteMapElemValue()
				if x.AnonInTestStruc.AF32slice == nil {
					r.EncodeNil()
				} else {
					z.F.EncSliceFloat32V(x.AnonInTestStruc.AF32slice, e)
				} // end block: if x.AnonInTestStruc.AF32slice slice == nil
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"AF64slice\"")
				} else {
					r.EncodeString(`AF64slice`)
				}
				z.EncWriteMapElemValue()
				if x.AnonInTestStruc.AF64slice == nil {
					r.EncodeNil()
				} else {
					z.F.EncSliceFloat64V(x.AnonInTestStruc.AF64slice, e)
				} // end block: if x.AnonInTestStruc.AF64slice slice == nil
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"AI16\"")
				} else {
					r.EncodeString(`AI16`)
				}
				z.EncWriteMapElemValue()
				r.EncodeInt(int64(x.AnonInTestStruc.AI16))
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"AI64\"")
				} else {
					r.EncodeString(`AI64`)
				}
				z.EncWriteMapElemValue()
				r.EncodeInt(int64(x.AnonInTestStruc.AI64))
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"AI64arr0\"")
				} else {
					r.EncodeString(`AI64arr0`)
				}
				z.EncWriteMapElemValue()
				yy125 := &x.AnonInTestStruc.AI64arr0
				h.encArray0int64((*[0]int64)(yy125), e)
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"AI64arr8\"")
				} else {
					r.EncodeString(`AI64arr8`)
				}
				z.EncWriteMapElemValue()
				yy127 := &x.AnonInTestStruc.AI64arr8
				h.encArray8int64((*[8]int64)(yy127), e)
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"AI64slice\"")
				} else {
					r.EncodeString(`AI64slice`)
				}
				z.EncWriteMapElemValue()
				if x.AnonInTestStruc.AI64slice == nil {
					r.EncodeNil()
				} else {
					z.F.EncSliceInt64V(x.AnonInTestStruc.AI64slice, e)
				} // end block: if x.AnonInTestStruc.AI64slice slice == nil
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"AI64slice0\"")
				} else {
					r.EncodeString(`AI64slice0`)
				}
				z.EncWriteMapElemValue()
				if x.AnonInTestStruc.AI64slice0 == nil {
					r.EncodeNil()
				} else {
					z.F.EncSliceInt64V(x.AnonInTestStruc.AI64slice0, e)
				} // end block: if x.AnonInTestStruc.AI64slice0 slice == nil
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"AMSS\"")
				} else {
					r.EncodeString(`AMSS`)
				}
				z.EncWriteMapElemValue()
				if x.AnonInTestStruc.AMSS == nil {
					r.EncodeNil()
				} else {
					z.F.EncMapStringStringV(x.AnonInTestStruc.AMSS, e)
				} // end block: if x.AnonInTestStruc.AMSS map == nil
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"AMSU64\"")
				} else {
					r.EncodeString(`AMSU64`)
				}
				z.EncWriteMapElemValue()
				if x.AnonInTestStruc.AMSU64 == nil {
					r.EncodeNil()
				} else {
					z.F.EncMapStringUint64V(x.AnonInTestStruc.AMSU64, e)
				} // end block: if x.AnonInTestStruc.AMSU64 map == nil
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"AMSU64E\"")
				} else {
					r.EncodeString(`AMSU64E`)
				}
				z.EncWriteMapElemValue()
				if x.AnonInTestStruc.AMSU64E == nil {
					r.EncodeNil()
				} else {
					z.F.EncMapStringUint64V(x.AnonInTestStruc.AMSU64E, e)
				} // end block: if x.AnonInTestStruc.AMSU64E map == nil
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"AMSU64N\"")
				} else {
					r.EncodeString(`AMSU64N`)
				}
				z.EncWriteMapElemValue()
				if x.AnonInTestStruc.AMSU64N == nil {
					r.EncodeNil()
				} else {
					z.F.EncMapStringUint64V(x.AnonInTestStruc.AMSU64N, e)
				} // end block: if x.AnonInTestStruc.AMSU64N map == nil
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"AS\"")
				} else {
					r.EncodeString(`AS`)
				}
				z.EncWriteMapElemValue()
				r.EncodeString(string(x.AnonInTestStruc.AS))
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"ASslice\"")
				} else {
					r.EncodeString(`ASslice`)
				}
				z.EncWriteMapElemValue()
				if x.AnonInTestStruc.ASslice == nil {
					r.EncodeNil()
				} else {
					z.F.EncSliceStringV(x.AnonInTestStruc.ASslice, e)
				} // end block: if x.AnonInTestStruc.ASslice slice == nil
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"AUi64\"")
				} else {
					r.EncodeString(`AUi64`)
				}
				z.EncWriteMapElemValue()
				r.EncodeUint(uint64(x.AnonInTestStruc.AUi64))
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"AUi64slice\"")
				} else {
					r.EncodeString(`AUi64slice`)
				}
				z.EncWriteMapElemValue()
				if x.AnonInTestStruc.AUi64slice == nil {
					r.EncodeNil()
				} else {
					z.F.EncSliceUint64V(x.AnonInTestStruc.AUi64slice, e)
				} // end block: if x.AnonInTestStruc.AUi64slice slice == nil
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"AUi64sliceN\"")
				} else {
					r.EncodeString(`AUi64sliceN`)
				}
				z.EncWriteMapElemValue()
				if x.AnonInTestStruc.AUi64sliceN == nil {
					r.EncodeNil()
				} else {
					z.F.EncSliceUint64V(x.AnonInTestStruc.AUi64sliceN, e)
				} // end block: if x.AnonInTestStruc.AUi64sliceN slice == nil
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"B\"")
				} else {
					r.EncodeString(`B`)
				}
				z.EncWriteMapElemValue()
				r.EncodeBool(bool(x.B))
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"Bslice\"")
				} else {
					r.EncodeString(`Bslice`)
				}
				z.EncWriteMapElemValue()
				if x.Bslice == nil {
					r.EncodeNil()
				} else {
					z.F.EncSliceBoolV(x.Bslice, e)
				} // end block: if x.Bslice slice == nil
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"By\"")
				} else {
					r.EncodeString(`By`)
				}
				z.EncWriteMapElemValue()
				r.EncodeUint(uint64(x.By))
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"Byslice\"")
				} else {
					r.EncodeString(`Byslice`)
				}
				z.EncWriteMapElemValue()
				if x.Byslice == nil {
					r.EncodeNil()
				} else {
					r.EncodeStringBytesRaw([]byte(x.Byslice))
				} // end block: if x.Byslice slice == nil
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"BytesSlice\"")
				} else {
					r.EncodeString(`BytesSlice`)
				}
				z.EncWriteMapElemValue()
				if x.BytesSlice == nil {
					r.EncodeNil()
				} else {
					z.F.EncSliceBytesV(x.BytesSlice, e)
				} // end block: if x.BytesSlice slice == nil
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"F32\"")
				} else {
					r.EncodeString(`F32`)
				}
				z.EncWriteMapElemValue()
				r.EncodeFloat32(float32(x.F32))
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"F64\"")
				} else {
					r.EncodeString(`F64`)
				}
				z.EncWriteMapElemValue()
				r.EncodeFloat64(float64(x.F64))
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"I16\"")
				} else {
					r.EncodeString(`I16`)
				}
				z.EncWriteMapElemValue()
				r.EncodeInt(int64(x.I16))
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"I16n\"")
				} else {
					r.EncodeString(`I16n`)
				}
				z.EncWriteMapElemValue()
				r.EncodeInt(int64(x.I16n))
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"I32\"")
				} else {
					r.EncodeString(`I32`)
				}
				z.EncWriteMapElemValue()
				r.EncodeInt(int64(x.I32))
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"I32n\"")
				} else {
					r.EncodeString(`I32n`)
				}
				z.EncWriteMapElemValue()
				r.EncodeInt(int64(x.I32n))
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"I32slice\"")
				} else {
					r.EncodeString(`I32slice`)
				}
				z.EncWriteMapElemValue()
				if x.I32slice == nil {
					r.EncodeNil()
				} else {
					z.F.EncSliceInt32V(x.I32slice, e)
				} // end block: if x.I32slice slice == nil
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"I64\"")
				} else {
					r.EncodeString(`I64`)
				}
				z.EncWriteMapElemValue()
				r.EncodeInt(int64(x.I64))
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"I64n\"")
				} else {
					r.EncodeString(`I64n`)
				}
				z.EncWriteMapElemValue()
				r.EncodeInt(int64(x.I64n))
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"I64slice\"")
				} else {
					r.EncodeString(`I64slice`)
				}
				z.EncWriteMapElemValue()
				if x.I64slice == nil {
					r.EncodeNil()
				} else {
					z.F.EncSliceInt64V(x.I64slice, e)
				} // end block: if x.I64slice slice == nil
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"I8\"")
				} else {
					r.EncodeString(`I8`)
				}
				z.EncWriteMapElemValue()
				r.EncodeInt(int64(x.I8))
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"I8n\"")
				} else {
					r.EncodeString(`I8n`)
				}
				z.EncWriteMapElemValue()
				r.EncodeInt(int64(x.I8n))
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"Iptrslice\"")
				} else {
					r.EncodeString(`Iptrslice`)
				}
				z.EncWriteMapElemValue()
				if x.Iptrslice == nil {
					r.EncodeNil()
				} else {
					h.encSlicePtrtoint64(([]*int64)(x.Iptrslice), e)
				} // end block: if x.Iptrslice slice == nil
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"Msbytes\"")
				} else {
					r.EncodeString(`Msbytes`)
				}
				z.EncWriteMapElemValue()
				if x.Msbytes == nil {
					r.EncodeNil()
				} else {
					z.F.EncMapStringBytesV(x.Msbytes, e)
				} // end block: if x.Msbytes map == nil
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"Msint\"")
				} else {
					r.EncodeString(`Msint`)
				}
				z.EncWriteMapElemValue()
				if x.Msint == nil {
					r.EncodeNil()
				} else {
					z.F.EncMapStringIntV(x.Msint, e)
				} // end block: if x.Msint map == nil
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"MstrUi64T\"")
				} else {
					r.EncodeString(`MstrUi64T`)
				}
				z.EncWriteMapElemValue()
				if x.MstrUi64T == nil {
					r.EncodeNil()
				} else {
					h.encMapstringPtrtostringUint64T((map[string]*stringUint64T)(x.MstrUi64T), e)
				} // end block: if x.MstrUi64T map == nil
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"Nint64\"")
				} else {
					r.EncodeString(`Nint64`)
				}
				z.EncWriteMapElemValue()
				if yyn58 {
					r.EncodeNil()
				} else {
					yy161 := *x.Nint64
					r.EncodeInt(int64(yy161))
				}
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"Nmap\"")
				} else {
					r.EncodeString(`Nmap`)
				}
				z.EncWriteMapElemValue()
				if x.Nmap == nil {
					r.EncodeNil()
				} else {
					z.F.EncMapStringBoolV(x.Nmap, e)
				} // end block: if x.Nmap map == nil
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"NotAnon\"")
				} else {
					r.EncodeString(`NotAnon`)
				}
				z.EncWriteMapElemValue()
				yy164 := &x.NotAnon
				if yyxt165 := z.Extension(yy164); yyxt165 != nil {
					z.EncExtension(yy164, yyxt165)
				} else {
					yy164.CodecEncodeSelf(e)
				}
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"NotAnonSlim\"")
				} else {
					r.EncodeString(`NotAnonSlim`)
				}
				z.EncWriteMapElemValue()
				if yyn55 {
					r.EncodeNil()
				} else {
					if yyxt166 := z.Extension(x.NotAnonSlim); yyxt166 != nil {
						z.EncExtension(x.NotAnonSlim, yyxt166)
					} else {
						x.NotAnonSlim.CodecEncodeSelf(e)
					}
				}
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"Nslice\"")
				} else {
					r.EncodeString(`Nslice`)
				}
				z.EncWriteMapElemValue()
				if x.Nslice == nil {
					r.EncodeNil()
				} else {
					r.EncodeStringBytesRaw([]byte(x.Nslice))
				} // end block: if x.Nslice slice == nil
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"P\"")
				} else {
					r.EncodeString(`P`)
				}
				z.EncWriteMapElemValue()
				if yyn54 {
					r.EncodeNil()
				} else {
					yy168 := *x.AnonInTestStrucSlim.P
					r.EncodeString(string(yy168))
				}
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"S\"")
				} else {
					r.EncodeString(`S`)
				}
				z.EncWriteMapElemValue()
				r.EncodeString(string(x.S))
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"Simplef\"")
				} else {
					r.EncodeString(`Simplef`)
				}
				z.EncWriteMapElemValue()
				yy171 := &x.Simplef
				if yyxt172 := z.Extension(yy171); yyxt172 != nil {
					z.EncExtension(yy171, yyxt172)
				} else {
					yy171.CodecEncodeSelf(e)
				}
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"Sslice\"")
				} else {
					r.EncodeString(`Sslice`)
				}
				z.EncWriteMapElemValue()
				if x.Sslice == nil {
					r.EncodeNil()
				} else {
					z.F.EncSliceStringV(x.Sslice, e)
				} // end block: if x.Sslice slice == nil
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"SstrUi64T\"")
				} else {
					r.EncodeString(`SstrUi64T`)
				}
				z.EncWriteMapElemValue()
				if x.SstrUi64T == nil {
					r.EncodeNil()
				} else {
					h.encSlicestringUint64T(([]stringUint64T)(x.SstrUi64T), e)
				} // end block: if x.SstrUi64T slice == nil
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"Ui16\"")
				} else {
					r.EncodeString(`Ui16`)
				}
				z.EncWriteMapElemValue()
				r.EncodeUint(uint64(x.Ui16))
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"Ui32\"")
				} else {
					r.EncodeString(`Ui32`)
				}
				z.EncWriteMapElemValue()
				r.EncodeUint(uint64(x.Ui32))
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"Ui64\"")
				} else {
					r.EncodeString(`Ui64`)
				}
				z.EncWriteMapElemValue()
				r.EncodeUint(uint64(x.Ui64))
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"Ui64slice\"")
				} else {
					r.EncodeString(`Ui64slice`)
				}
				z.EncWriteMapElemValue()
				if x.Ui64slice == nil {
					r.EncodeNil()
				} else {
					z.F.EncSliceUint64V(x.Ui64slice, e)
				} // end block: if x.Ui64slice slice == nil
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"Ui8\"")
				} else {
					r.EncodeString(`Ui8`)
				}
				z.EncWriteMapElemValue()
				r.EncodeUint(uint64(x.Ui8))
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"Ui8slice\"")
				} else {
					r.EncodeString(`Ui8slice`)
				}
				z.EncWriteMapElemValue()
				if x.Ui8slice == nil {
					r.EncodeNil()
				} else {
					r.EncodeStringBytesRaw([]byte(x.Ui8slice))
				} // end block: if x.Ui8slice slice == nil
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"WrapSliceInt64\"")
				} else {
					r.EncodeString(`WrapSliceInt64`)
				}
				z.EncWriteMapElemValue()
				if yyxt181 := z.Extension(x.WrapSliceInt64); yyxt181 != nil {
					z.EncExtension(x.WrapSliceInt64, yyxt181)
				} else {
					x.WrapSliceInt64.CodecEncodeSelf(e)
				}
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"WrapSliceString\"")
				} else {
					r.EncodeString(`WrapSliceString`)
				}
				z.EncWriteMapElemValue()
				if yyxt182 := z.Extension(x.WrapSliceString); yyxt182 != nil {
					z.EncExtension(x.WrapSliceString, yyxt182)
				} else {
					x.WrapSliceString.CodecEncodeSelf(e)
				}
			} else {
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"S\"")
				} else {
					r.EncodeString(`S`)
				}
				z.EncWriteMapElemValue()
				r.EncodeString(string(x.S))
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"I64\"")
				} else {
					r.EncodeString(`I64`)
				}
				z.EncWriteMapElemValue()
				r.EncodeInt(int64(x.I64))
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"I32\"")
				} else {
					r.EncodeString(`I32`)
				}
				z.EncWriteMapElemValue()
				r.EncodeInt(int64(x.I32))
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"I16\"")
				} else {
					r.EncodeString(`I16`)
				}
				z.EncWriteMapElemValue()
				r.EncodeInt(int64(x.I16))
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"I8\"")
				} else {
					r.EncodeString(`I8`)
				}
				z.EncWriteMapElemValue()
				r.EncodeInt(int64(x.I8))
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"I64n\"")
				} else {
					r.EncodeString(`I64n`)
				}
				z.EncWriteMapElemValue()
				r.EncodeInt(int64(x.I64n))
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"I32n\"")
				} else {
					r.EncodeString(`I32n`)
				}
				z.EncWriteMapElemValue()
				r.EncodeInt(int64(x.I32n))
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"I16n\"")
				} else {
					r.EncodeString(`I16n`)
				}
				z.EncWriteMapElemValue()
				r.EncodeInt(int64(x.I16n))
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"I8n\"")
				} else {
					r.EncodeString(`I8n`)
				}
				z.EncWriteMapElemValue()
				r.EncodeInt(int64(x.I8n))
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"Ui64\"")
				} else {
					r.EncodeString(`Ui64`)
				}
				z.EncWriteMapElemValue()
				r.EncodeUint(uint64(x.Ui64))
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"Ui32\"")
				} else {
					r.EncodeString(`Ui32`)
				}
				z.EncWriteMapElemValue()
				r.EncodeUint(uint64(x.Ui32))
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"Ui16\"")
				} else {
					r.EncodeString(`Ui16`)
				}
				z.EncWriteMapElemValue()
				r.EncodeUint(uint64(x.Ui16))
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"Ui8\"")
				} else {
					r.EncodeString(`Ui8`)
				}
				z.EncWriteMapElemValue()
				r.EncodeUint(uint64(x.Ui8))
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"F64\"")
				} else {
					r.EncodeString(`F64`)
				}
				z.EncWriteMapElemValue()
				r.EncodeFloat64(float64(x.F64))
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"F32\"")
				} else {
					r.EncodeString(`F32`)
				}
				z.EncWriteMapElemValue()
				r.EncodeFloat32(float32(x.F32))
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"B\"")
				} else {
					r.EncodeString(`B`)
				}
				z.EncWriteMapElemValue()
				r.EncodeBool(bool(x.B))
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"By\"")
				} else {
					r.EncodeString(`By`)
				}
				z.EncWriteMapElemValue()
				r.EncodeUint(uint64(x.By))
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"Sslice\"")
				} else {
					r.EncodeString(`Sslice`)
				}
				z.EncWriteMapElemValue()
				if x.Sslice == nil {
					r.EncodeNil()
				} else {
					z.F.EncSliceStringV(x.Sslice, e)
				} // end block: if x.Sslice slice == nil
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"I64slice\"")
				} else {
					r.EncodeString(`I64slice`)
				}
				z.EncWriteMapElemValue()
				if x.I64slice == nil {
					r.EncodeNil()
				} else {
					z.F.EncSliceInt64V(x.I64slice, e)
				} // end block: if x.I64slice slice == nil
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"I32slice\"")
				} else {
					r.EncodeString(`I32slice`)
				}
				z.EncWriteMapElemValue()
				if x.I32slice == nil {
					r.EncodeNil()
				} else {
					z.F.EncSliceInt32V(x.I32slice, e)
				} // end block: if x.I32slice slice == nil
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"Ui64slice\"")
				} else {
					r.EncodeString(`Ui64slice`)
				}
				z.EncWriteMapElemValue()
				if x.Ui64slice == nil {
					r.EncodeNil()
				} else {
					z.F.EncSliceUint64V(x.Ui64slice, e)
				} // end block: if x.Ui64slice slice == nil
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"Ui8slice\"")
				} else {
					r.EncodeString(`Ui8slice`)
				}
				z.EncWriteMapElemValue()
				if x.Ui8slice == nil {
					r.EncodeNil()
				} else {
					r.EncodeStringBytesRaw([]byte(x.Ui8slice))
				} // end block: if x.Ui8slice slice == nil
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"Bslice\"")
				} else {
					r.EncodeString(`Bslice`)
				}
				z.EncWriteMapElemValue()
				if x.Bslice == nil {
					r.EncodeNil()
				} else {
					z.F.EncSliceBoolV(x.Bslice, e)
				} // end block: if x.Bslice slice == nil
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"Byslice\"")
				} else {
					r.EncodeString(`Byslice`)
				}
				z.EncWriteMapElemValue()
				if x.Byslice == nil {
					r.EncodeNil()
				} else {
					r.EncodeStringBytesRaw([]byte(x.Byslice))
				} // end block: if x.Byslice slice == nil
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"BytesSlice\"")
				} else {
					r.EncodeString(`BytesSlice`)
				}
				z.EncWriteMapElemValue()
				if x.BytesSlice == nil {
					r.EncodeNil()
				} else {
					z.F.EncSliceBytesV(x.BytesSlice, e)
				} // end block: if x.BytesSlice slice == nil
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"Iptrslice\"")
				} else {
					r.EncodeString(`Iptrslice`)
				}
				z.EncWriteMapElemValue()
				if x.Iptrslice == nil {
					r.EncodeNil()
				} else {
					h.encSlicePtrtoint64(([]*int64)(x.Iptrslice), e)
				} // end block: if x.Iptrslice slice == nil
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"WrapSliceInt64\"")
				} else {
					r.EncodeString(`WrapSliceInt64`)
				}
				z.EncWriteMapElemValue()
				if yyxt209 := z.Extension(x.WrapSliceInt64); yyxt209 != nil {
					z.EncExtension(x.WrapSliceInt64, yyxt209)
				} else {
					x.WrapSliceInt64.CodecEncodeSelf(e)
				}
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"WrapSliceString\"")
				} else {
					r.EncodeString(`WrapSliceString`)
				}
				z.EncWriteMapElemValue()
				if yyxt210 := z.Extension(x.WrapSliceString); yyxt210 != nil {
					z.EncExtension(x.WrapSliceString, yyxt210)
				} else {
					x.WrapSliceString.CodecEncodeSelf(e)
				}
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"Msint\"")
				} else {
					r.EncodeString(`Msint`)
				}
				z.EncWriteMapElemValue()
				if x.Msint == nil {
					r.EncodeNil()
				} else {
					z.F.EncMapStringIntV(x.Msint, e)
				} // end block: if x.Msint map == nil
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"Msbytes\"")
				} else {
					r.EncodeString(`Msbytes`)
				}
				z.EncWriteMapElemValue()
				if x.Msbytes == nil {
					r.EncodeNil()
				} else {
					z.F.EncMapStringBytesV(x.Msbytes, e)
				} // end block: if x.Msbytes map == nil
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"Simplef\"")
				} else {
					r.EncodeString(`Simplef`)
				}
				z.EncWriteMapElemValue()
				yy213 := &x.Simplef
				if yyxt214 := z.Extension(yy213); yyxt214 != nil {
					z.EncExtension(yy213, yyxt214)
				} else {
					yy213.CodecEncodeSelf(e)
				}
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"SstrUi64T\"")
				} else {
					r.EncodeString(`SstrUi64T`)
				}
				z.EncWriteMapElemValue()
				if x.SstrUi64T == nil {
					r.EncodeNil()
				} else {
					h.encSlicestringUint64T(([]stringUint64T)(x.SstrUi64T), e)
				} // end block: if x.SstrUi64T slice == nil
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"MstrUi64T\"")
				} else {
					r.EncodeString(`MstrUi64T`)
				}
				z.EncWriteMapElemValue()
				if x.MstrUi64T == nil {
					r.EncodeNil()
				} else {
					h.encMapstringPtrtostringUint64T((map[string]*stringUint64T)(x.MstrUi64T), e)
				} // end block: if x.MstrUi64T map == nil
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"AS\"")
				} else {
					r.EncodeString(`AS`)
				}
				z.EncWriteMapElemValue()
				r.EncodeString(string(x.AnonInTestStruc.AS))
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"AI64\"")
				} else {
					r.EncodeString(`AI64`)
				}
				z.EncWriteMapElemValue()
				r.EncodeInt(int64(x.AnonInTestStruc.AI64))
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"AI16\"")
				} else {
					r.EncodeString(`AI16`)
				}
				z.EncWriteMapElemValue()
				r.EncodeInt(int64(x.AnonInTestStruc.AI16))
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"AUi64\"")
				} else {
					r.EncodeString(`AUi64`)
				}
				z.EncWriteMapElemValue()
				r.EncodeUint(uint64(x.AnonInTestStruc.AUi64))
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"ASslice\"")
				} else {
					r.EncodeString(`ASslice`)
				}
				z.EncWriteMapElemValue()
				if x.AnonInTestStruc.ASslice == nil {
					r.EncodeNil()
				} else {
					z.F.EncSliceStringV(x.AnonInTestStruc.ASslice, e)
				} // end block: if x.AnonInTestStruc.ASslice slice == nil
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"AI64slice\"")
				} else {
					r.EncodeString(`AI64slice`)
				}
				z.EncWriteMapElemValue()
				if x.AnonInTestStruc.AI64slice == nil {
					r.EncodeNil()
				} else {
					z.F.EncSliceInt64V(x.AnonInTestStruc.AI64slice, e)
				} // end block: if x.AnonInTestStruc.AI64slice slice == nil
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"AUi64slice\"")
				} else {
					r.EncodeString(`AUi64slice`)
				}
				z.EncWriteMapElemValue()
				if x.AnonInTestStruc.AUi64slice == nil {
					r.EncodeNil()
				} else {
					z.F.EncSliceUint64V(x.AnonInTestStruc.AUi64slice, e)
				} // end block: if x.AnonInTestStruc.AUi64slice slice == nil
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"AF64slice\"")
				} else {
					r.EncodeString(`AF64slice`)
				}
				z.EncWriteMapElemValue()
				if x.AnonInTestStruc.AF64slice == nil {
					r.EncodeNil()
				} else {
					z.F.EncSliceFloat64V(x.AnonInTestStruc.AF64slice, e)
				} // end block: if x.AnonInTestStruc.AF64slice slice == nil
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"AF32slice\"")
				} else {
					r.EncodeString(`AF32slice`)
				}
				z.EncWriteMapElemValue()
				if x.AnonInTestStruc.AF32slice == nil {
					r.EncodeNil()
				} else {
					z.F.EncSliceFloat32V(x.AnonInTestStruc.AF32slice, e)
				} // end block: if x.AnonInTestStruc.AF32slice slice == nil
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"AMSS\"")
				} else {
					r.EncodeString(`AMSS`)
				}
				z.EncWriteMapElemValue()
				if x.AnonInTestStruc.AMSS == nil {
					r.EncodeNil()
				} else {
					z.F.EncMapStringStringV(x.AnonInTestStruc.AMSS, e)
				} // end block: if x.AnonInTestStruc.AMSS map == nil
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"AMSU64\"")
				} else {
					r.EncodeString(`AMSU64`)
				}
				z.EncWriteMapElemValue()
				if x.AnonInTestStruc.AMSU64 == nil {
					r.EncodeNil()
				} else {
					z.F.EncMapStringUint64V(x.AnonInTestStruc.AMSU64, e)
				} // end block: if x.AnonInTestStruc.AMSU64 map == nil
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"AI64arr8\"")
				} else {
					r.EncodeString(`AI64arr8`)
				}
				z.EncWriteMapElemValue()
				yy228 := &x.AnonInTestStruc.AI64arr8
				h.encArray8int64((*[8]int64)(yy228), e)
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"AI64arr0\"")
				} else {
					r.EncodeString(`AI64arr0`)
				}
				z.EncWriteMapElemValue()
				yy230 := &x.AnonInTestStruc.AI64arr0
				h.encArray0int64((*[0]int64)(yy230), e)
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"AI64slice0\"")
				} else {
					r.EncodeString(`AI64slice0`)
				}
				z.EncWriteMapElemValue()
				if x.AnonInTestStruc.AI64slice0 == nil {
					r.EncodeNil()
				} else {
					z.F.EncSliceInt64V(x.AnonInTestStruc.AI64slice0, e)
				} // end block: if x.AnonInTestStruc.AI64slice0 slice == nil
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"AUi64sliceN\"")
				} else {
					r.EncodeString(`AUi64sliceN`)
				}
				z.EncWriteMapElemValue()
				if x.AnonInTestStruc.AUi64sliceN == nil {
					r.EncodeNil()
				} else {
					z.F.EncSliceUint64V(x.AnonInTestStruc.AUi64sliceN, e)
				} // end block: if x.AnonInTestStruc.AUi64sliceN slice == nil
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"AMSU64N\"")
				} else {
					r.EncodeString(`AMSU64N`)
				}
				z.EncWriteMapElemValue()
				if x.AnonInTestStruc.AMSU64N == nil {
					r.EncodeNil()
				} else {
					z.F.EncMapStringUint64V(x.AnonInTestStruc.AMSU64N, e)
				} // end block: if x.AnonInTestStruc.AMSU64N map == nil
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"AMSU64E\"")
				} else {
					r.EncodeString(`AMSU64E`)
				}
				z.EncWriteMapElemValue()
				if x.AnonInTestStruc.AMSU64E == nil {
					r.EncodeNil()
				} else {
					z.F.EncMapStringUint64V(x.AnonInTestStruc.AMSU64E, e)
				} // end block: if x.AnonInTestStruc.AMSU64E map == nil
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"NotAnon\"")
				} else {
					r.EncodeString(`NotAnon`)
				}
				z.EncWriteMapElemValue()
				yy236 := &x.NotAnon
				if yyxt237 := z.Extension(yy236); yyxt237 != nil {
					z.EncExtension(yy236, yyxt237)
				} else {
					yy236.CodecEncodeSelf(e)
				}
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"P\"")
				} else {
					r.EncodeString(`P`)
				}
				z.EncWriteMapElemValue()
				if yyn54 {
					r.EncodeNil()
				} else {
					yy238 := *x.AnonInTestStrucSlim.P
					r.EncodeString(string(yy238))
				}
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"NotAnonSlim\"")
				} else {
					r.EncodeString(`NotAnonSlim`)
				}
				z.EncWriteMapElemValue()
				if yyn55 {
					r.EncodeNil()
				} else {
					if yyxt240 := z.Extension(x.NotAnonSlim); yyxt240 != nil {
						z.EncExtension(x.NotAnonSlim, yyxt240)
					} else {
						x.NotAnonSlim.CodecEncodeSelf(e)
					}
				}
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"Nmap\"")
				} else {
					r.EncodeString(`Nmap`)
				}
				z.EncWriteMapElemValue()
				if x.Nmap == nil {
					r.EncodeNil()
				} else {
					z.F.EncMapStringBoolV(x.Nmap, e)
				} // end block: if x.Nmap map == nil
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"Nslice\"")
				} else {
					r.EncodeString(`Nslice`)
				}
				z.EncWriteMapElemValue()
				if x.Nslice == nil {
					r.EncodeNil()
				} else {
					r.EncodeStringBytesRaw([]byte(x.Nslice))
				} // end block: if x.Nslice slice == nil
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"Nint64\"")
				} else {
					r.EncodeString(`Nint64`)
				}
				z.EncWriteMapElemValue()
				if yyn58 {
					r.EncodeNil()
				} else {
					yy243 := *x.Nint64
					r.EncodeInt(int64(yy243))
				}
			}
			z.EncWriteMapEnd()
		}
	}
}

func (x *TestStrucCommon) CodecDecodeSelf(d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelper().Decoder(d)
	_, _, _ = h, z, r
	yyct2 := r.ContainerType()
	if yyct2 == codecSelferValueTypeNil19780 {
		*(x) = TestStrucCommon{}
	} else if yyct2 == codecSelferValueTypeMap19780 {
		yyl2 := z.DecReadMapStart()
		if yyl2 == 0 {
		} else {
			x.codecDecodeSelfFromMap(yyl2, d)
		}
		z.DecReadMapEnd()
	} else if yyct2 == codecSelferValueTypeArray19780 {
		yyl2 := z.DecReadArrayStart()
		if yyl2 != 0 {
			x.codecDecodeSelfFromArray(yyl2, d)
		}
		z.DecReadArrayEnd()
	} else {
		panic(errCodecSelferOnlyMapOrArrayEncodeToStruct19780)
	}
}

func (x *TestStrucCommon) codecDecodeSelfFromMap(l int, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelper().Decoder(d)
	_, _, _ = h, z, r
	var yyhl3 bool = l >= 0
	for yyj3 := 0; z.DecContainerNext(yyj3, l, yyhl3); yyj3++ {
		z.DecReadMapElemKey()
		yys3 := r.DecodeStringAsBytes()
		z.DecReadMapElemValue()
		switch string(yys3) {
		case "S":
			x.S = (string)(z.DecStringZC(r.DecodeStringAsBytes()))
		case "I64":
			x.I64 = (int64)(r.DecodeInt64())
		case "I32":
			x.I32 = (int32)(z.C.IntV(r.DecodeInt64(), 32))
		case "I16":
			x.I16 = (int16)(z.C.IntV(r.DecodeInt64(), 16))
		case "I8":
			x.I8 = (int8)(z.C.IntV(r.DecodeInt64(), 8))
		case "I64n":
			x.I64n = (int64)(r.DecodeInt64())
		case "I32n":
			x.I32n = (int32)(z.C.IntV(r.DecodeInt64(), 32))
		case "I16n":
			x.I16n = (int16)(z.C.IntV(r.DecodeInt64(), 16))
		case "I8n":
			x.I8n = (int8)(z.C.IntV(r.DecodeInt64(), 8))
		case "Ui64":
			x.Ui64 = (uint64)(r.DecodeUint64())
		case "Ui32":
			x.Ui32 = (uint32)(z.C.UintV(r.DecodeUint64(), 32))
		case "Ui16":
			x.Ui16 = (uint16)(z.C.UintV(r.DecodeUint64(), 16))
		case "Ui8":
			x.Ui8 = (uint8)(z.C.UintV(r.DecodeUint64(), 8))
		case "F64":
			x.F64 = (float64)(r.DecodeFloat64())
		case "F32":
			x.F32 = (float32)(z.DecDecodeFloat32())
		case "B":
			x.B = (bool)(r.DecodeBool())
		case "By":
			x.By = (uint8)(z.C.UintV(r.DecodeUint64(), 8))
		case "Sslice":
			z.F.DecSliceStringX(&x.Sslice, d)
		case "I64slice":
			z.F.DecSliceInt64X(&x.I64slice, d)
		case "I32slice":
			z.F.DecSliceInt32X(&x.I32slice, d)
		case "Ui64slice":
			z.F.DecSliceUint64X(&x.Ui64slice, d)
		case "Ui8slice":
			x.Ui8slice = z.DecodeBytesInto(([]byte)(x.Ui8slice))
		case "Bslice":
			z.F.DecSliceBoolX(&x.Bslice, d)
		case "Byslice":
			x.Byslice = z.DecodeBytesInto(([]byte)(x.Byslice))
		case "BytesSlice":
			z.F.DecSliceBytesX(&x.BytesSlice, d)
		case "Iptrslice":
			h.decSlicePtrtoint64((*[]*int64)(&x.Iptrslice), d)
		case "WrapSliceInt64":
			if yyxt40 := z.Extension(x.WrapSliceInt64); yyxt40 != nil {
				z.DecExtension(&x.WrapSliceInt64, yyxt40)
			} else {
				x.WrapSliceInt64.CodecDecodeSelf(d)
			}
		case "WrapSliceString":
			if yyxt42 := z.Extension(x.WrapSliceString); yyxt42 != nil {
				z.DecExtension(&x.WrapSliceString, yyxt42)
			} else {
				x.WrapSliceString.CodecDecodeSelf(d)
			}
		case "Msint":
			z.F.DecMapStringIntX(&x.Msint, d)
		case "Msbytes":
			z.F.DecMapStringBytesX(&x.Msbytes, d)
		case "Simplef":
			if yyxt48 := z.Extension(x.Simplef); yyxt48 != nil {
				z.DecExtension(&x.Simplef, yyxt48)
			} else {
				x.Simplef.CodecDecodeSelf(d)
			}
		case "SstrUi64T":
			h.decSlicestringUint64T((*[]stringUint64T)(&x.SstrUi64T), d)
		case "MstrUi64T":
			h.decMapstringPtrtostringUint64T((*map[string]*stringUint64T)(&x.MstrUi64T), d)
		case "AS":
			x.AnonInTestStruc.AS = (string)(z.DecStringZC(r.DecodeStringAsBytes()))
		case "AI64":
			x.AnonInTestStruc.AI64 = (int64)(r.DecodeInt64())
		case "AI16":
			x.AnonInTestStruc.AI16 = (int16)(z.C.IntV(r.DecodeInt64(), 16))
		case "AUi64":
			x.AnonInTestStruc.AUi64 = (uint64)(r.DecodeUint64())
		case "ASslice":
			z.F.DecSliceStringX(&x.AnonInTestStruc.ASslice, d)
		case "AI64slice":
			z.F.DecSliceInt64X(&x.AnonInTestStruc.AI64slice, d)
		case "AUi64slice":
			z.F.DecSliceUint64X(&x.AnonInTestStruc.AUi64slice, d)
		case "AF64slice":
			z.F.DecSliceFloat64X(&x.AnonInTestStruc.AF64slice, d)
		case "AF32slice":
			z.F.DecSliceFloat32X(&x.AnonInTestStruc.AF32slice, d)
		case "AMSS":
			z.F.DecMapStringStringX(&x.AnonInTestStruc.AMSS, d)
		case "AMSU64":
			z.F.DecMapStringUint64X(&x.AnonInTestStruc.AMSU64, d)
		case "AI64arr8":
			h.decArray8int64((*[8]int64)(&x.AnonInTestStruc.AI64arr8), d)
		case "AI64arr0":
			h.decArray0int64((*[0]int64)(&x.AnonInTestStruc.AI64arr0), d)
		case "AI64slice0":
			z.F.DecSliceInt64X(&x.AnonInTestStruc.AI64slice0, d)
		case "AUi64sliceN":
			z.F.DecSliceUint64X(&x.AnonInTestStruc.AUi64sliceN, d)
		case "AMSU64N":
			z.F.DecMapStringUint64X(&x.AnonInTestStruc.AMSU64N, d)
		case "AMSU64E":
			z.F.DecMapStringUint64X(&x.AnonInTestStruc.AMSU64E, d)
		case "NotAnon":
			if yyxt84 := z.Extension(x.NotAnon); yyxt84 != nil {
				z.DecExtension(&x.NotAnon, yyxt84)
			} else {
				x.NotAnon.CodecDecodeSelf(d)
			}
		case "P":
			if r.TryNil() {
				if x.AnonInTestStrucSlim != nil && x.AnonInTestStrucSlim.P != nil { // remove the if-true
					x.AnonInTestStrucSlim.P = nil
				}
			} else {
				if x.AnonInTestStrucSlim == nil {
					x.AnonInTestStrucSlim = new(AnonInTestStrucSlim)
				}
				if x.AnonInTestStrucSlim.P == nil {
					x.AnonInTestStrucSlim.P = new(string)
				}
				*x.AnonInTestStrucSlim.P = (string)(z.DecStringZC(r.DecodeStringAsBytes()))
			}
		case "NotAnonSlim":
			if r.TryNil() {
				if x.NotAnonSlim != nil { // remove the if-true
					x.NotAnonSlim = nil
				}
			} else {
				if x.NotAnonSlim == nil {
					x.NotAnonSlim = new(AnonInTestStrucSlim)
				}
				if yyxt88 := z.Extension(x.NotAnonSlim); yyxt88 != nil {
					z.DecExtension(x.NotAnonSlim, yyxt88)
				} else {
					x.NotAnonSlim.CodecDecodeSelf(d)
				}
			}
		case "Nmap":
			z.F.DecMapStringBoolX(&x.Nmap, d)
		case "Nslice":
			x.Nslice = z.DecodeBytesInto(([]byte)(x.Nslice))
		case "Nint64":
			if r.TryNil() {
				if x.Nint64 != nil { // remove the if-true
					x.Nint64 = nil
				}
			} else {
				if x.Nint64 == nil {
					x.Nint64 = new(int64)
				}
				*x.Nint64 = (int64)(r.DecodeInt64())
			}
		default:
			z.DecStructFieldNotFound(-1, string(yys3))
		} // end switch yys3
	} // end for yyj3
}

func (x *TestStrucCommon) codecDecodeSelfFromArray(l int, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelper().Decoder(d)
	_, _, _ = h, z, r
	var yyj95 int
	var yyb95 bool
	var yyhl95 bool = l >= 0
	yyb95 = !z.DecContainerNext(yyj95, l, yyhl95)
	if yyb95 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.S = (string)(z.DecStringZC(r.DecodeStringAsBytes()))
	yyj95++
	yyb95 = !z.DecContainerNext(yyj95, l, yyhl95)
	if yyb95 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.I64 = (int64)(r.DecodeInt64())
	yyj95++
	yyb95 = !z.DecContainerNext(yyj95, l, yyhl95)
	if yyb95 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.I32 = (int32)(z.C.IntV(r.DecodeInt64(), 32))
	yyj95++
	yyb95 = !z.DecContainerNext(yyj95, l, yyhl95)
	if yyb95 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.I16 = (int16)(z.C.IntV(r.DecodeInt64(), 16))
	yyj95++
	yyb95 = !z.DecContainerNext(yyj95, l, yyhl95)
	if yyb95 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.I8 = (int8)(z.C.IntV(r.DecodeInt64(), 8))
	yyj95++
	yyb95 = !z.DecContainerNext(yyj95, l, yyhl95)
	if yyb95 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.I64n = (int64)(r.DecodeInt64())
	yyj95++
	yyb95 = !z.DecContainerNext(yyj95, l, yyhl95)
	if yyb95 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.I32n = (int32)(z.C.IntV(r.DecodeInt64(), 32))
	yyj95++
	yyb95 = !z.DecContainerNext(yyj95, l, yyhl95)
	if yyb95 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.I16n = (int16)(z.C.IntV(r.DecodeInt64(), 16))
	yyj95++
	yyb95 = !z.DecContainerNext(yyj95, l, yyhl95)
	if yyb95 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.I8n = (int8)(z.C.IntV(r.DecodeInt64(), 8))
	yyj95++
	yyb95 = !z.DecContainerNext(yyj95, l, yyhl95)
	if yyb95 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.Ui64 = (uint64)(r.DecodeUint64())
	yyj95++
	yyb95 = !z.DecContainerNext(yyj95, l, yyhl95)
	if yyb95 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.Ui32 = (uint32)(z.C.UintV(r.DecodeUint64(), 32))
	yyj95++
	yyb95 = !z.DecContainerNext(yyj95, l, yyhl95)
	if yyb95 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.Ui16 = (uint16)(z.C.UintV(r.DecodeUint64(), 16))
	yyj95++
	yyb95 = !z.DecContainerNext(yyj95, l, yyhl95)
	if yyb95 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.Ui8 = (uint8)(z.C.UintV(r.DecodeUint64(), 8))
	yyj95++
	yyb95 = !z.DecContainerNext(yyj95, l, yyhl95)
	if yyb95 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.F64 = (float64)(r.DecodeFloat64())
	yyj95++
	yyb95 = !z.DecContainerNext(yyj95, l, yyhl95)
	if yyb95 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.F32 = (float32)(z.DecDecodeFloat32())
	yyj95++
	yyb95 = !z.DecContainerNext(yyj95, l, yyhl95)
	if yyb95 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.B = (bool)(r.DecodeBool())
	yyj95++
	yyb95 = !z.DecContainerNext(yyj95, l, yyhl95)
	if yyb95 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.By = (uint8)(z.C.UintV(r.DecodeUint64(), 8))
	yyj95++
	yyb95 = !z.DecContainerNext(yyj95, l, yyhl95)
	if yyb95 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	z.F.DecSliceStringX(&x.Sslice, d)
	yyj95++
	yyb95 = !z.DecContainerNext(yyj95, l, yyhl95)
	if yyb95 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	z.F.DecSliceInt64X(&x.I64slice, d)
	yyj95++
	yyb95 = !z.DecContainerNext(yyj95, l, yyhl95)
	if yyb95 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	z.F.DecSliceInt32X(&x.I32slice, d)
	yyj95++
	yyb95 = !z.DecContainerNext(yyj95, l, yyhl95)
	if yyb95 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	z.F.DecSliceUint64X(&x.Ui64slice, d)
	yyj95++
	yyb95 = !z.DecContainerNext(yyj95, l, yyhl95)
	if yyb95 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.Ui8slice = z.DecodeBytesInto(([]byte)(x.Ui8slice))
	yyj95++
	yyb95 = !z.DecContainerNext(yyj95, l, yyhl95)
	if yyb95 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	z.F.DecSliceBoolX(&x.Bslice, d)
	yyj95++
	yyb95 = !z.DecContainerNext(yyj95, l, yyhl95)
	if yyb95 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.Byslice = z.DecodeBytesInto(([]byte)(x.Byslice))
	yyj95++
	yyb95 = !z.DecContainerNext(yyj95, l, yyhl95)
	if yyb95 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	z.F.DecSliceBytesX(&x.BytesSlice, d)
	yyj95++
	yyb95 = !z.DecContainerNext(yyj95, l, yyhl95)
	if yyb95 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	h.decSlicePtrtoint64((*[]*int64)(&x.Iptrslice), d)
	yyj95++
	yyb95 = !z.DecContainerNext(yyj95, l, yyhl95)
	if yyb95 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	if yyxt132 := z.Extension(x.WrapSliceInt64); yyxt132 != nil {
		z.DecExtension(&x.WrapSliceInt64, yyxt132)
	} else {
		x.WrapSliceInt64.CodecDecodeSelf(d)
	}
	yyj95++
	yyb95 = !z.DecContainerNext(yyj95, l, yyhl95)
	if yyb95 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	if yyxt134 := z.Extension(x.WrapSliceString); yyxt134 != nil {
		z.DecExtension(&x.WrapSliceString, yyxt134)
	} else {
		x.WrapSliceString.CodecDecodeSelf(d)
	}
	yyj95++
	yyb95 = !z.DecContainerNext(yyj95, l, yyhl95)
	if yyb95 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	z.F.DecMapStringIntX(&x.Msint, d)
	yyj95++
	yyb95 = !z.DecContainerNext(yyj95, l, yyhl95)
	if yyb95 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	z.F.DecMapStringBytesX(&x.Msbytes, d)
	yyj95++
	yyb95 = !z.DecContainerNext(yyj95, l, yyhl95)
	if yyb95 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	if yyxt140 := z.Extension(x.Simplef); yyxt140 != nil {
		z.DecExtension(&x.Simplef, yyxt140)
	} else {
		x.Simplef.CodecDecodeSelf(d)
	}
	yyj95++
	yyb95 = !z.DecContainerNext(yyj95, l, yyhl95)
	if yyb95 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	h.decSlicestringUint64T((*[]stringUint64T)(&x.SstrUi64T), d)
	yyj95++
	yyb95 = !z.DecContainerNext(yyj95, l, yyhl95)
	if yyb95 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	h.decMapstringPtrtostringUint64T((*map[string]*stringUint64T)(&x.MstrUi64T), d)
	yyj95++
	yyb95 = !z.DecContainerNext(yyj95, l, yyhl95)
	if yyb95 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.AnonInTestStruc.AS = (string)(z.DecStringZC(r.DecodeStringAsBytes()))
	yyj95++
	yyb95 = !z.DecContainerNext(yyj95, l, yyhl95)
	if yyb95 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.AnonInTestStruc.AI64 = (int64)(r.DecodeInt64())
	yyj95++
	yyb95 = !z.DecContainerNext(yyj95, l, yyhl95)
	if yyb95 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.AnonInTestStruc.AI16 = (int16)(z.C.IntV(r.DecodeInt64(), 16))
	yyj95++
	yyb95 = !z.DecContainerNext(yyj95, l, yyhl95)
	if yyb95 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.AnonInTestStruc.AUi64 = (uint64)(r.DecodeUint64())
	yyj95++
	yyb95 = !z.DecContainerNext(yyj95, l, yyhl95)
	if yyb95 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	z.F.DecSliceStringX(&x.AnonInTestStruc.ASslice, d)
	yyj95++
	yyb95 = !z.DecContainerNext(yyj95, l, yyhl95)
	if yyb95 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	z.F.DecSliceInt64X(&x.AnonInTestStruc.AI64slice, d)
	yyj95++
	yyb95 = !z.DecContainerNext(yyj95, l, yyhl95)
	if yyb95 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	z.F.DecSliceUint64X(&x.AnonInTestStruc.AUi64slice, d)
	yyj95++
	yyb95 = !z.DecContainerNext(yyj95, l, yyhl95)
	if yyb95 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	z.F.DecSliceFloat64X(&x.AnonInTestStruc.AF64slice, d)
	yyj95++
	yyb95 = !z.DecContainerNext(yyj95, l, yyhl95)
	if yyb95 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	z.F.DecSliceFloat32X(&x.AnonInTestStruc.AF32slice, d)
	yyj95++
	yyb95 = !z.DecContainerNext(yyj95, l, yyhl95)
	if yyb95 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	z.F.DecMapStringStringX(&x.AnonInTestStruc.AMSS, d)
	yyj95++
	yyb95 = !z.DecContainerNext(yyj95, l, yyhl95)
	if yyb95 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	z.F.DecMapStringUint64X(&x.AnonInTestStruc.AMSU64, d)
	yyj95++
	yyb95 = !z.DecContainerNext(yyj95, l, yyhl95)
	if yyb95 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	h.decArray8int64((*[8]int64)(&x.AnonInTestStruc.AI64arr8), d)
	yyj95++
	yyb95 = !z.DecContainerNext(yyj95, l, yyhl95)
	if yyb95 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	h.decArray0int64((*[0]int64)(&x.AnonInTestStruc.AI64arr0), d)
	yyj95++
	yyb95 = !z.DecContainerNext(yyj95, l, yyhl95)
	if yyb95 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	z.F.DecSliceInt64X(&x.AnonInTestStruc.AI64slice0, d)
	yyj95++
	yyb95 = !z.DecContainerNext(yyj95, l, yyhl95)
	if yyb95 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	z.F.DecSliceUint64X(&x.AnonInTestStruc.AUi64sliceN, d)
	yyj95++
	yyb95 = !z.DecContainerNext(yyj95, l, yyhl95)
	if yyb95 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	z.F.DecMapStringUint64X(&x.AnonInTestStruc.AMSU64N, d)
	yyj95++
	yyb95 = !z.DecContainerNext(yyj95, l, yyhl95)
	if yyb95 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	z.F.DecMapStringUint64X(&x.AnonInTestStruc.AMSU64E, d)
	yyj95++
	yyb95 = !z.DecContainerNext(yyj95, l, yyhl95)
	if yyb95 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	if yyxt176 := z.Extension(x.NotAnon); yyxt176 != nil {
		z.DecExtension(&x.NotAnon, yyxt176)
	} else {
		x.NotAnon.CodecDecodeSelf(d)
	}
	yyj95++
	yyb95 = !z.DecContainerNext(yyj95, l, yyhl95)
	if yyb95 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	if r.TryNil() {
		if x.AnonInTestStrucSlim != nil && x.AnonInTestStrucSlim.P != nil { // remove the if-true
			x.AnonInTestStrucSlim.P = nil
		}
	} else {
		if x.AnonInTestStrucSlim == nil {
			x.AnonInTestStrucSlim = new(AnonInTestStrucSlim)
		}
		if x.AnonInTestStrucSlim.P == nil {
			x.AnonInTestStrucSlim.P = new(string)
		}
		*x.AnonInTestStrucSlim.P = (string)(z.DecStringZC(r.DecodeStringAsBytes()))
	}
	yyj95++
	yyb95 = !z.DecContainerNext(yyj95, l, yyhl95)
	if yyb95 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	if r.TryNil() {
		if x.NotAnonSlim != nil { // remove the if-true
			x.NotAnonSlim = nil
		}
	} else {
		if x.NotAnonSlim == nil {
			x.NotAnonSlim = new(AnonInTestStrucSlim)
		}
		if yyxt180 := z.Extension(x.NotAnonSlim); yyxt180 != nil {
			z.DecExtension(x.NotAnonSlim, yyxt180)
		} else {
			x.NotAnonSlim.CodecDecodeSelf(d)
		}
	}
	yyj95++
	yyb95 = !z.DecContainerNext(yyj95, l, yyhl95)
	if yyb95 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	z.F.DecMapStringBoolX(&x.Nmap, d)
	yyj95++
	yyb95 = !z.DecContainerNext(yyj95, l, yyhl95)
	if yyb95 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.Nslice = z.DecodeBytesInto(([]byte)(x.Nslice))
	yyj95++
	yyb95 = !z.DecContainerNext(yyj95, l, yyhl95)
	if yyb95 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	if r.TryNil() {
		if x.Nint64 != nil { // remove the if-true
			x.Nint64 = nil
		}
	} else {
		if x.Nint64 == nil {
			x.Nint64 = new(int64)
		}
		*x.Nint64 = (int64)(r.DecodeInt64())
	}
	yyj95++
	for ; z.DecContainerNext(yyj95, l, yyhl95); yyj95++ {
		z.DecReadArrayElem()
		z.DecStructFieldNotFound(yyj95-1, "")
	}
}

func (x *TestStrucCommon) IsCodecEmpty() bool {
	return !(x.S != "" || x.I64 != 0 || x.I32 != 0 || x.I16 != 0 || x.I8 != 0 || x.I64n != 0 || x.I32n != 0 || x.I16n != 0 || x.I8n != 0 || x.Ui64 != 0 || x.Ui32 != 0 || x.Ui16 != 0 || x.Ui8 != 0 || x.F64 != 0 || x.F32 != 0 || bool(x.B) || x.By != 0 || len(x.Sslice) != 0 || len(x.I64slice) != 0 || len(x.I32slice) != 0 || len(x.Ui64slice) != 0 || len(x.Ui8slice) != 0 || len(x.Bslice) != 0 || len(x.Byslice) != 0 || len(x.BytesSlice) != 0 || len(x.Iptrslice) != 0 || len(x.WrapSliceInt64) != 0 || len(x.WrapSliceString) != 0 || len(x.Msint) != 0 || len(x.Msbytes) != 0 || !(x.Simplef.IsCodecEmpty()) || len(x.SstrUi64T) != 0 || len(x.MstrUi64T) != 0 || !(x.AnonInTestStruc.IsCodecEmpty()) || !(x.NotAnon.IsCodecEmpty()) || x.AnonInTestStrucSlim != nil && len(x.Nmap) != 0 || len(x.Nslice) != 0 || false)
}

func (TestStruc) codecSelferViaCodecgen() {}
func (x *TestStruc) CodecEncodeSelf(e *Encoder) {
	var h codecSelfer19780
	z, r := GenHelper().Encoder(e)
	_, _, _ = h, z, r
	if z.EncBasicHandle().CheckCircularRef {
		z.EncEncode(x)
		return
	}
	if x == nil {
		r.EncodeNil()
	} else {
		yy2arr2 := z.EncBasicHandle().StructToArray
		_ = yy2arr2
		const yyr2 bool = false // struct tag has 'toArray'
		var yyn54 bool = x.TestStrucCommon.AnonInTestStrucSlim == nil || x.TestStrucCommon.AnonInTestStrucSlim.P == nil
		var yyn55 bool = x.TestStrucCommon.NotAnonSlim == nil
		var yyn58 bool = x.TestStrucCommon.Nint64 == nil
		var yyn62 bool = x.Nteststruc == nil
		if yyr2 || yy2arr2 {
			z.EncWriteArrayStart(60)
			z.EncWriteArrayElem()
			r.EncodeString(string(x.TestStrucCommon.S))
			z.EncWriteArrayElem()
			r.EncodeInt(int64(x.TestStrucCommon.I64))
			z.EncWriteArrayElem()
			r.EncodeInt(int64(x.TestStrucCommon.I32))
			z.EncWriteArrayElem()
			r.EncodeInt(int64(x.TestStrucCommon.I16))
			z.EncWriteArrayElem()
			r.EncodeInt(int64(x.TestStrucCommon.I8))
			z.EncWriteArrayElem()
			r.EncodeInt(int64(x.TestStrucCommon.I64n))
			z.EncWriteArrayElem()
			r.EncodeInt(int64(x.TestStrucCommon.I32n))
			z.EncWriteArrayElem()
			r.EncodeInt(int64(x.TestStrucCommon.I16n))
			z.EncWriteArrayElem()
			r.EncodeInt(int64(x.TestStrucCommon.I8n))
			z.EncWriteArrayElem()
			r.EncodeUint(uint64(x.TestStrucCommon.Ui64))
			z.EncWriteArrayElem()
			r.EncodeUint(uint64(x.TestStrucCommon.Ui32))
			z.EncWriteArrayElem()
			r.EncodeUint(uint64(x.TestStrucCommon.Ui16))
			z.EncWriteArrayElem()
			r.EncodeUint(uint64(x.TestStrucCommon.Ui8))
			z.EncWriteArrayElem()
			r.EncodeFloat64(float64(x.TestStrucCommon.F64))
			z.EncWriteArrayElem()
			r.EncodeFloat32(float32(x.TestStrucCommon.F32))
			z.EncWriteArrayElem()
			r.EncodeBool(bool(x.TestStrucCommon.B))
			z.EncWriteArrayElem()
			r.EncodeUint(uint64(x.TestStrucCommon.By))
			z.EncWriteArrayElem()
			if x.TestStrucCommon.Sslice == nil {
				r.EncodeNil()
			} else {
				z.F.EncSliceStringV(x.TestStrucCommon.Sslice, e)
			} // end block: if x.TestStrucCommon.Sslice slice == nil
			z.EncWriteArrayElem()
			if x.TestStrucCommon.I64slice == nil {
				r.EncodeNil()
			} else {
				z.F.EncSliceInt64V(x.TestStrucCommon.I64slice, e)
			} // end block: if x.TestStrucCommon.I64slice slice == nil
			z.EncWriteArrayElem()
			if x.TestStrucCommon.I32slice == nil {
				r.EncodeNil()
			} else {
				z.F.EncSliceInt32V(x.TestStrucCommon.I32slice, e)
			} // end block: if x.TestStrucCommon.I32slice slice == nil
			z.EncWriteArrayElem()
			if x.TestStrucCommon.Ui64slice == nil {
				r.EncodeNil()
			} else {
				z.F.EncSliceUint64V(x.TestStrucCommon.Ui64slice, e)
			} // end block: if x.TestStrucCommon.Ui64slice slice == nil
			z.EncWriteArrayElem()
			if x.TestStrucCommon.Ui8slice == nil {
				r.EncodeNil()
			} else {
				r.EncodeStringBytesRaw([]byte(x.TestStrucCommon.Ui8slice))
			} // end block: if x.TestStrucCommon.Ui8slice slice == nil
			z.EncWriteArrayElem()
			if x.TestStrucCommon.Bslice == nil {
				r.EncodeNil()
			} else {
				z.F.EncSliceBoolV(x.TestStrucCommon.Bslice, e)
			} // end block: if x.TestStrucCommon.Bslice slice == nil
			z.EncWriteArrayElem()
			if x.TestStrucCommon.Byslice == nil {
				r.EncodeNil()
			} else {
				r.EncodeStringBytesRaw([]byte(x.TestStrucCommon.Byslice))
			} // end block: if x.TestStrucCommon.Byslice slice == nil
			z.EncWriteArrayElem()
			if x.TestStrucCommon.BytesSlice == nil {
				r.EncodeNil()
			} else {
				z.F.EncSliceBytesV(x.TestStrucCommon.BytesSlice, e)
			} // end block: if x.TestStrucCommon.BytesSlice slice == nil
			z.EncWriteArrayElem()
			if x.TestStrucCommon.Iptrslice == nil {
				r.EncodeNil()
			} else {
				h.encSlicePtrtoint64(([]*int64)(x.TestStrucCommon.Iptrslice), e)
			} // end block: if x.TestStrucCommon.Iptrslice slice == nil
			z.EncWriteArrayElem()
			if yyxt89 := z.Extension(x.TestStrucCommon.WrapSliceInt64); yyxt89 != nil {
				z.EncExtension(x.TestStrucCommon.WrapSliceInt64, yyxt89)
			} else {
				x.TestStrucCommon.WrapSliceInt64.CodecEncodeSelf(e)
			}
			z.EncWriteArrayElem()
			if yyxt90 := z.Extension(x.TestStrucCommon.WrapSliceString); yyxt90 != nil {
				z.EncExtension(x.TestStrucCommon.WrapSliceString, yyxt90)
			} else {
				x.TestStrucCommon.WrapSliceString.CodecEncodeSelf(e)
			}
			z.EncWriteArrayElem()
			if x.TestStrucCommon.Msint == nil {
				r.EncodeNil()
			} else {
				z.F.EncMapStringIntV(x.TestStrucCommon.Msint, e)
			} // end block: if x.TestStrucCommon.Msint map == nil
			z.EncWriteArrayElem()
			if x.TestStrucCommon.Msbytes == nil {
				r.EncodeNil()
			} else {
				z.F.EncMapStringBytesV(x.TestStrucCommon.Msbytes, e)
			} // end block: if x.TestStrucCommon.Msbytes map == nil
			z.EncWriteArrayElem()
			yy93 := &x.TestStrucCommon.Simplef
			if yyxt94 := z.Extension(yy93); yyxt94 != nil {
				z.EncExtension(yy93, yyxt94)
			} else {
				yy93.CodecEncodeSelf(e)
			}
			z.EncWriteArrayElem()
			if x.TestStrucCommon.SstrUi64T == nil {
				r.EncodeNil()
			} else {
				h.encSlicestringUint64T(([]stringUint64T)(x.TestStrucCommon.SstrUi64T), e)
			} // end block: if x.TestStrucCommon.SstrUi64T slice == nil
			z.EncWriteArrayElem()
			if x.TestStrucCommon.MstrUi64T == nil {
				r.EncodeNil()
			} else {
				h.encMapstringPtrtostringUint64T((map[string]*stringUint64T)(x.TestStrucCommon.MstrUi64T), e)
			} // end block: if x.TestStrucCommon.MstrUi64T map == nil
			z.EncWriteArrayElem()
			r.EncodeString(string(x.TestStrucCommon.AnonInTestStruc.AS))
			z.EncWriteArrayElem()
			r.EncodeInt(int64(x.TestStrucCommon.AnonInTestStruc.AI64))
			z.EncWriteArrayElem()
			r.EncodeInt(int64(x.TestStrucCommon.AnonInTestStruc.AI16))
			z.EncWriteArrayElem()
			r.EncodeUint(uint64(x.TestStrucCommon.AnonInTestStruc.AUi64))
			z.EncWriteArrayElem()
			if x.TestStrucCommon.AnonInTestStruc.ASslice == nil {
				r.EncodeNil()
			} else {
				z.F.EncSliceStringV(x.TestStrucCommon.AnonInTestStruc.ASslice, e)
			} // end block: if x.TestStrucCommon.AnonInTestStruc.ASslice slice == nil
			z.EncWriteArrayElem()
			if x.TestStrucCommon.AnonInTestStruc.AI64slice == nil {
				r.EncodeNil()
			} else {
				z.F.EncSliceInt64V(x.TestStrucCommon.AnonInTestStruc.AI64slice, e)
			} // end block: if x.TestStrucCommon.AnonInTestStruc.AI64slice slice == nil
			z.EncWriteArrayElem()
			if x.TestStrucCommon.AnonInTestStruc.AUi64slice == nil {
				r.EncodeNil()
			} else {
				z.F.EncSliceUint64V(x.TestStrucCommon.AnonInTestStruc.AUi64slice, e)
			} // end block: if x.TestStrucCommon.AnonInTestStruc.AUi64slice slice == nil
			z.EncWriteArrayElem()
			if x.TestStrucCommon.AnonInTestStruc.AF64slice == nil {
				r.EncodeNil()
			} else {
				z.F.EncSliceFloat64V(x.TestStrucCommon.AnonInTestStruc.AF64slice, e)
			} // end block: if x.TestStrucCommon.AnonInTestStruc.AF64slice slice == nil
			z.EncWriteArrayElem()
			if x.TestStrucCommon.AnonInTestStruc.AF32slice == nil {
				r.EncodeNil()
			} else {
				z.F.EncSliceFloat32V(x.TestStrucCommon.AnonInTestStruc.AF32slice, e)
			} // end block: if x.TestStrucCommon.AnonInTestStruc.AF32slice slice == nil
			z.EncWriteArrayElem()
			if x.TestStrucCommon.AnonInTestStruc.AMSS == nil {
				r.EncodeNil()
			} else {
				z.F.EncMapStringStringV(x.TestStrucCommon.AnonInTestStruc.AMSS, e)
			} // end block: if x.TestStrucCommon.AnonInTestStruc.AMSS map == nil
			z.EncWriteArrayElem()
			if x.TestStrucCommon.AnonInTestStruc.AMSU64 == nil {
				r.EncodeNil()
			} else {
				z.F.EncMapStringUint64V(x.TestStrucCommon.AnonInTestStruc.AMSU64, e)
			} // end block: if x.TestStrucCommon.AnonInTestStruc.AMSU64 map == nil
			z.EncWriteArrayElem()
			yy108 := &x.TestStrucCommon.AnonInTestStruc.AI64arr8
			h.encArray8int64((*[8]int64)(yy108), e)
			z.EncWriteArrayElem()
			yy110 := &x.TestStrucCommon.AnonInTestStruc.AI64arr0
			h.encArray0int64((*[0]int64)(yy110), e)
			z.EncWriteArrayElem()
			if x.TestStrucCommon.AnonInTestStruc.AI64slice0 == nil {
				r.EncodeNil()
			} else {
				z.F.EncSliceInt64V(x.TestStrucCommon.AnonInTestStruc.AI64slice0, e)
			} // end block: if x.TestStrucCommon.AnonInTestStruc.AI64slice0 slice == nil
			z.EncWriteArrayElem()
			if x.TestStrucCommon.AnonInTestStruc.AUi64sliceN == nil {
				r.EncodeNil()
			} else {
				z.F.EncSliceUint64V(x.TestStrucCommon.AnonInTestStruc.AUi64sliceN, e)
			} // end block: if x.TestStrucCommon.AnonInTestStruc.AUi64sliceN slice == nil
			z.EncWriteArrayElem()
			if x.TestStrucCommon.AnonInTestStruc.AMSU64N == nil {
				r.EncodeNil()
			} else {
				z.F.EncMapStringUint64V(x.TestStrucCommon.AnonInTestStruc.AMSU64N, e)
			} // end block: if x.TestStrucCommon.AnonInTestStruc.AMSU64N map == nil
			z.EncWriteArrayElem()
			if x.TestStrucCommon.AnonInTestStruc.AMSU64E == nil {
				r.EncodeNil()
			} else {
				z.F.EncMapStringUint64V(x.TestStrucCommon.AnonInTestStruc.AMSU64E, e)
			} // end block: if x.TestStrucCommon.AnonInTestStruc.AMSU64E map == nil
			z.EncWriteArrayElem()
			yy116 := &x.TestStrucCommon.NotAnon
			if yyxt117 := z.Extension(yy116); yyxt117 != nil {
				z.EncExtension(yy116, yyxt117)
			} else {
				yy116.CodecEncodeSelf(e)
			}
			if yyn54 {
				z.EncWriteArrayElem()
				r.EncodeNil()
			} else {
				z.EncWriteArrayElem()
				yy118 := *x.TestStrucCommon.AnonInTestStrucSlim.P
				r.EncodeString(string(yy118))
			}
			if yyn55 {
				z.EncWriteArrayElem()
				r.EncodeNil()
			} else {
				z.EncWriteArrayElem()
				if yyxt120 := z.Extension(x.TestStrucCommon.NotAnonSlim); yyxt120 != nil {
					z.EncExtension(x.TestStrucCommon.NotAnonSlim, yyxt120)
				} else {
					x.TestStrucCommon.NotAnonSlim.CodecEncodeSelf(e)
				}
			}
			z.EncWriteArrayElem()
			if x.TestStrucCommon.Nmap == nil {
				r.EncodeNil()
			} else {
				z.F.EncMapStringBoolV(x.TestStrucCommon.Nmap, e)
			} // end block: if x.TestStrucCommon.Nmap map == nil
			z.EncWriteArrayElem()
			if x.TestStrucCommon.Nslice == nil {
				r.EncodeNil()
			} else {
				r.EncodeStringBytesRaw([]byte(x.TestStrucCommon.Nslice))
			} // end block: if x.TestStrucCommon.Nslice slice == nil
			if yyn58 {
				z.EncWriteArrayElem()
				r.EncodeNil()
			} else {
				z.EncWriteArrayElem()
				yy123 := *x.TestStrucCommon.Nint64
				r.EncodeInt(int64(yy123))
			}
			z.EncWriteArrayElem()
			if x.Mtsptr == nil {
				r.EncodeNil()
			} else {
				h.encMapstringPtrtoTestStruc((map[string]*TestStruc)(x.Mtsptr), e)
			} // end block: if x.Mtsptr map == nil
			z.EncWriteArrayElem()
			if x.Mts == nil {
				r.EncodeNil()
			} else {
				h.encMapstringTestStruc((map[string]TestStruc)(x.Mts), e)
			} // end block: if x.Mts map == nil
			z.EncWriteArrayElem()
			if x.Its == nil {
				r.EncodeNil()
			} else {
				h.encSlicePtrtoTestStruc(([]*TestStruc)(x.Its), e)
			} // end block: if x.Its slice == nil
			if yyn62 {
				z.EncWriteArrayElem()
				r.EncodeNil()
			} else {
				z.EncWriteArrayElem()
				if yyxt128 := z.Extension(x.Nteststruc); yyxt128 != nil {
					z.EncExtension(x.Nteststruc, yyxt128)
				} else {
					x.Nteststruc.CodecEncodeSelf(e)
				}
			}
			z.EncWriteArrayEnd()
		} else {
			z.EncWriteMapStart(60)
			if z.EncBasicHandle().Canonical {
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"AF32slice\"")
				} else {
					r.EncodeString(`AF32slice`)
				}
				z.EncWriteMapElemValue()
				if x.TestStrucCommon.AnonInTestStruc.AF32slice == nil {
					r.EncodeNil()
				} else {
					z.F.EncSliceFloat32V(x.TestStrucCommon.AnonInTestStruc.AF32slice, e)
				} // end block: if x.TestStrucCommon.AnonInTestStruc.AF32slice slice == nil
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"AF64slice\"")
				} else {
					r.EncodeString(`AF64slice`)
				}
				z.EncWriteMapElemValue()
				if x.TestStrucCommon.AnonInTestStruc.AF64slice == nil {
					r.EncodeNil()
				} else {
					z.F.EncSliceFloat64V(x.TestStrucCommon.AnonInTestStruc.AF64slice, e)
				} // end block: if x.TestStrucCommon.AnonInTestStruc.AF64slice slice == nil
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"AI16\"")
				} else {
					r.EncodeString(`AI16`)
				}
				z.EncWriteMapElemValue()
				r.EncodeInt(int64(x.TestStrucCommon.AnonInTestStruc.AI16))
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"AI64\"")
				} else {
					r.EncodeString(`AI64`)
				}
				z.EncWriteMapElemValue()
				r.EncodeInt(int64(x.TestStrucCommon.AnonInTestStruc.AI64))
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"AI64arr0\"")
				} else {
					r.EncodeString(`AI64arr0`)
				}
				z.EncWriteMapElemValue()
				yy133 := &x.TestStrucCommon.AnonInTestStruc.AI64arr0
				h.encArray0int64((*[0]int64)(yy133), e)
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"AI64arr8\"")
				} else {
					r.EncodeString(`AI64arr8`)
				}
				z.EncWriteMapElemValue()
				yy135 := &x.TestStrucCommon.AnonInTestStruc.AI64arr8
				h.encArray8int64((*[8]int64)(yy135), e)
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"AI64slice\"")
				} else {
					r.EncodeString(`AI64slice`)
				}
				z.EncWriteMapElemValue()
				if x.TestStrucCommon.AnonInTestStruc.AI64slice == nil {
					r.EncodeNil()
				} else {
					z.F.EncSliceInt64V(x.TestStrucCommon.AnonInTestStruc.AI64slice, e)
				} // end block: if x.TestStrucCommon.AnonInTestStruc.AI64slice slice == nil
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"AI64slice0\"")
				} else {
					r.EncodeString(`AI64slice0`)
				}
				z.EncWriteMapElemValue()
				if x.TestStrucCommon.AnonInTestStruc.AI64slice0 == nil {
					r.EncodeNil()
				} else {
					z.F.EncSliceInt64V(x.TestStrucCommon.AnonInTestStruc.AI64slice0, e)
				} // end block: if x.TestStrucCommon.AnonInTestStruc.AI64slice0 slice == nil
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"AMSS\"")
				} else {
					r.EncodeString(`AMSS`)
				}
				z.EncWriteMapElemValue()
				if x.TestStrucCommon.AnonInTestStruc.AMSS == nil {
					r.EncodeNil()
				} else {
					z.F.EncMapStringStringV(x.TestStrucCommon.AnonInTestStruc.AMSS, e)
				} // end block: if x.TestStrucCommon.AnonInTestStruc.AMSS map == nil
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"AMSU64\"")
				} else {
					r.EncodeString(`AMSU64`)
				}
				z.EncWriteMapElemValue()
				if x.TestStrucCommon.AnonInTestStruc.AMSU64 == nil {
					r.EncodeNil()
				} else {
					z.F.EncMapStringUint64V(x.TestStrucCommon.AnonInTestStruc.AMSU64, e)
				} // end block: if x.TestStrucCommon.AnonInTestStruc.AMSU64 map == nil
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"AMSU64E\"")
				} else {
					r.EncodeString(`AMSU64E`)
				}
				z.EncWriteMapElemValue()
				if x.TestStrucCommon.AnonInTestStruc.AMSU64E == nil {
					r.EncodeNil()
				} else {
					z.F.EncMapStringUint64V(x.TestStrucCommon.AnonInTestStruc.AMSU64E, e)
				} // end block: if x.TestStrucCommon.AnonInTestStruc.AMSU64E map == nil
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"AMSU64N\"")
				} else {
					r.EncodeString(`AMSU64N`)
				}
				z.EncWriteMapElemValue()
				if x.TestStrucCommon.AnonInTestStruc.AMSU64N == nil {
					r.EncodeNil()
				} else {
					z.F.EncMapStringUint64V(x.TestStrucCommon.AnonInTestStruc.AMSU64N, e)
				} // end block: if x.TestStrucCommon.AnonInTestStruc.AMSU64N map == nil
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"AS\"")
				} else {
					r.EncodeString(`AS`)
				}
				z.EncWriteMapElemValue()
				r.EncodeString(string(x.TestStrucCommon.AnonInTestStruc.AS))
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"ASslice\"")
				} else {
					r.EncodeString(`ASslice`)
				}
				z.EncWriteMapElemValue()
				if x.TestStrucCommon.AnonInTestStruc.ASslice == nil {
					r.EncodeNil()
				} else {
					z.F.EncSliceStringV(x.TestStrucCommon.AnonInTestStruc.ASslice, e)
				} // end block: if x.TestStrucCommon.AnonInTestStruc.ASslice slice == nil
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"AUi64\"")
				} else {
					r.EncodeString(`AUi64`)
				}
				z.EncWriteMapElemValue()
				r.EncodeUint(uint64(x.TestStrucCommon.AnonInTestStruc.AUi64))
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"AUi64slice\"")
				} else {
					r.EncodeString(`AUi64slice`)
				}
				z.EncWriteMapElemValue()
				if x.TestStrucCommon.AnonInTestStruc.AUi64slice == nil {
					r.EncodeNil()
				} else {
					z.F.EncSliceUint64V(x.TestStrucCommon.AnonInTestStruc.AUi64slice, e)
				} // end block: if x.TestStrucCommon.AnonInTestStruc.AUi64slice slice == nil
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"AUi64sliceN\"")
				} else {
					r.EncodeString(`AUi64sliceN`)
				}
				z.EncWriteMapElemValue()
				if x.TestStrucCommon.AnonInTestStruc.AUi64sliceN == nil {
					r.EncodeNil()
				} else {
					z.F.EncSliceUint64V(x.TestStrucCommon.AnonInTestStruc.AUi64sliceN, e)
				} // end block: if x.TestStrucCommon.AnonInTestStruc.AUi64sliceN slice == nil
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"B\"")
				} else {
					r.EncodeString(`B`)
				}
				z.EncWriteMapElemValue()
				r.EncodeBool(bool(x.TestStrucCommon.B))
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"Bslice\"")
				} else {
					r.EncodeString(`Bslice`)
				}
				z.EncWriteMapElemValue()
				if x.TestStrucCommon.Bslice == nil {
					r.EncodeNil()
				} else {
					z.F.EncSliceBoolV(x.TestStrucCommon.Bslice, e)
				} // end block: if x.TestStrucCommon.Bslice slice == nil
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"By\"")
				} else {
					r.EncodeString(`By`)
				}
				z.EncWriteMapElemValue()
				r.EncodeUint(uint64(x.TestStrucCommon.By))
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"Byslice\"")
				} else {
					r.EncodeString(`Byslice`)
				}
				z.EncWriteMapElemValue()
				if x.TestStrucCommon.Byslice == nil {
					r.EncodeNil()
				} else {
					r.EncodeStringBytesRaw([]byte(x.TestStrucCommon.Byslice))
				} // end block: if x.TestStrucCommon.Byslice slice == nil
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"BytesSlice\"")
				} else {
					r.EncodeString(`BytesSlice`)
				}
				z.EncWriteMapElemValue()
				if x.TestStrucCommon.BytesSlice == nil {
					r.EncodeNil()
				} else {
					z.F.EncSliceBytesV(x.TestStrucCommon.BytesSlice, e)
				} // end block: if x.TestStrucCommon.BytesSlice slice == nil
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"F32\"")
				} else {
					r.EncodeString(`F32`)
				}
				z.EncWriteMapElemValue()
				r.EncodeFloat32(float32(x.TestStrucCommon.F32))
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"F64\"")
				} else {
					r.EncodeString(`F64`)
				}
				z.EncWriteMapElemValue()
				r.EncodeFloat64(float64(x.TestStrucCommon.F64))
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"I16\"")
				} else {
					r.EncodeString(`I16`)
				}
				z.EncWriteMapElemValue()
				r.EncodeInt(int64(x.TestStrucCommon.I16))
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"I16n\"")
				} else {
					r.EncodeString(`I16n`)
				}
				z.EncWriteMapElemValue()
				r.EncodeInt(int64(x.TestStrucCommon.I16n))
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"I32\"")
				} else {
					r.EncodeString(`I32`)
				}
				z.EncWriteMapElemValue()
				r.EncodeInt(int64(x.TestStrucCommon.I32))
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"I32n\"")
				} else {
					r.EncodeString(`I32n`)
				}
				z.EncWriteMapElemValue()
				r.EncodeInt(int64(x.TestStrucCommon.I32n))
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"I32slice\"")
				} else {
					r.EncodeString(`I32slice`)
				}
				z.EncWriteMapElemValue()
				if x.TestStrucCommon.I32slice == nil {
					r.EncodeNil()
				} else {
					z.F.EncSliceInt32V(x.TestStrucCommon.I32slice, e)
				} // end block: if x.TestStrucCommon.I32slice slice == nil
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"I64\"")
				} else {
					r.EncodeString(`I64`)
				}
				z.EncWriteMapElemValue()
				r.EncodeInt(int64(x.TestStrucCommon.I64))
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"I64n\"")
				} else {
					r.EncodeString(`I64n`)
				}
				z.EncWriteMapElemValue()
				r.EncodeInt(int64(x.TestStrucCommon.I64n))
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"I64slice\"")
				} else {
					r.EncodeString(`I64slice`)
				}
				z.EncWriteMapElemValue()
				if x.TestStrucCommon.I64slice == nil {
					r.EncodeNil()
				} else {
					z.F.EncSliceInt64V(x.TestStrucCommon.I64slice, e)
				} // end block: if x.TestStrucCommon.I64slice slice == nil
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"I8\"")
				} else {
					r.EncodeString(`I8`)
				}
				z.EncWriteMapElemValue()
				r.EncodeInt(int64(x.TestStrucCommon.I8))
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"I8n\"")
				} else {
					r.EncodeString(`I8n`)
				}
				z.EncWriteMapElemValue()
				r.EncodeInt(int64(x.TestStrucCommon.I8n))
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"Iptrslice\"")
				} else {
					r.EncodeString(`Iptrslice`)
				}
				z.EncWriteMapElemValue()
				if x.TestStrucCommon.Iptrslice == nil {
					r.EncodeNil()
				} else {
					h.encSlicePtrtoint64(([]*int64)(x.TestStrucCommon.Iptrslice), e)
				} // end block: if x.TestStrucCommon.Iptrslice slice == nil
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"Its\"")
				} else {
					r.EncodeString(`Its`)
				}
				z.EncWriteMapElemValue()
				if x.Its == nil {
					r.EncodeNil()
				} else {
					h.encSlicePtrtoTestStruc(([]*TestStruc)(x.Its), e)
				} // end block: if x.Its slice == nil
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"Msbytes\"")
				} else {
					r.EncodeString(`Msbytes`)
				}
				z.EncWriteMapElemValue()
				if x.TestStrucCommon.Msbytes == nil {
					r.EncodeNil()
				} else {
					z.F.EncMapStringBytesV(x.TestStrucCommon.Msbytes, e)
				} // end block: if x.TestStrucCommon.Msbytes map == nil
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"Msint\"")
				} else {
					r.EncodeString(`Msint`)
				}
				z.EncWriteMapElemValue()
				if x.TestStrucCommon.Msint == nil {
					r.EncodeNil()
				} else {
					z.F.EncMapStringIntV(x.TestStrucCommon.Msint, e)
				} // end block: if x.TestStrucCommon.Msint map == nil
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"MstrUi64T\"")
				} else {
					r.EncodeString(`MstrUi64T`)
				}
				z.EncWriteMapElemValue()
				if x.TestStrucCommon.MstrUi64T == nil {
					r.EncodeNil()
				} else {
					h.encMapstringPtrtostringUint64T((map[string]*stringUint64T)(x.TestStrucCommon.MstrUi64T), e)
				} // end block: if x.TestStrucCommon.MstrUi64T map == nil
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"Mts\"")
				} else {
					r.EncodeString(`Mts`)
				}
				z.EncWriteMapElemValue()
				if x.Mts == nil {
					r.EncodeNil()
				} else {
					h.encMapstringTestStruc((map[string]TestStruc)(x.Mts), e)
				} // end block: if x.Mts map == nil
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"Mtsptr\"")
				} else {
					r.EncodeString(`Mtsptr`)
				}
				z.EncWriteMapElemValue()
				if x.Mtsptr == nil {
					r.EncodeNil()
				} else {
					h.encMapstringPtrtoTestStruc((map[string]*TestStruc)(x.Mtsptr), e)
				} // end block: if x.Mtsptr map == nil
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"Nint64\"")
				} else {
					r.EncodeString(`Nint64`)
				}
				z.EncWriteMapElemValue()
				if yyn58 {
					r.EncodeNil()
				} else {
					yy172 := *x.TestStrucCommon.Nint64
					r.EncodeInt(int64(yy172))
				}
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"Nmap\"")
				} else {
					r.EncodeString(`Nmap`)
				}
				z.EncWriteMapElemValue()
				if x.TestStrucCommon.Nmap == nil {
					r.EncodeNil()
				} else {
					z.F.EncMapStringBoolV(x.TestStrucCommon.Nmap, e)
				} // end block: if x.TestStrucCommon.Nmap map == nil
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"NotAnon\"")
				} else {
					r.EncodeString(`NotAnon`)
				}
				z.EncWriteMapElemValue()
				yy175 := &x.TestStrucCommon.NotAnon
				if yyxt176 := z.Extension(yy175); yyxt176 != nil {
					z.EncExtension(yy175, yyxt176)
				} else {
					yy175.CodecEncodeSelf(e)
				}
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"NotAnonSlim\"")
				} else {
					r.EncodeString(`NotAnonSlim`)
				}
				z.EncWriteMapElemValue()
				if yyn55 {
					r.EncodeNil()
				} else {
					if yyxt177 := z.Extension(x.TestStrucCommon.NotAnonSlim); yyxt177 != nil {
						z.EncExtension(x.TestStrucCommon.NotAnonSlim, yyxt177)
					} else {
						x.TestStrucCommon.NotAnonSlim.CodecEncodeSelf(e)
					}
				}
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"Nslice\"")
				} else {
					r.EncodeString(`Nslice`)
				}
				z.EncWriteMapElemValue()
				if x.TestStrucCommon.Nslice == nil {
					r.EncodeNil()
				} else {
					r.EncodeStringBytesRaw([]byte(x.TestStrucCommon.Nslice))
				} // end block: if x.TestStrucCommon.Nslice slice == nil
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"Nteststruc\"")
				} else {
					r.EncodeString(`Nteststruc`)
				}
				z.EncWriteMapElemValue()
				if yyn62 {
					r.EncodeNil()
				} else {
					if yyxt179 := z.Extension(x.Nteststruc); yyxt179 != nil {
						z.EncExtension(x.Nteststruc, yyxt179)
					} else {
						x.Nteststruc.CodecEncodeSelf(e)
					}
				}
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"P\"")
				} else {
					r.EncodeString(`P`)
				}
				z.EncWriteMapElemValue()
				if yyn54 {
					r.EncodeNil()
				} else {
					yy180 := *x.TestStrucCommon.AnonInTestStrucSlim.P
					r.EncodeString(string(yy180))
				}
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"S\"")
				} else {
					r.EncodeString(`S`)
				}
				z.EncWriteMapElemValue()
				r.EncodeString(string(x.TestStrucCommon.S))
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"Simplef\"")
				} else {
					r.EncodeString(`Simplef`)
				}
				z.EncWriteMapElemValue()
				yy183 := &x.TestStrucCommon.Simplef
				if yyxt184 := z.Extension(yy183); yyxt184 != nil {
					z.EncExtension(yy183, yyxt184)
				} else {
					yy183.CodecEncodeSelf(e)
				}
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"Sslice\"")
				} else {
					r.EncodeString(`Sslice`)
				}
				z.EncWriteMapElemValue()
				if x.TestStrucCommon.Sslice == nil {
					r.EncodeNil()
				} else {
					z.F.EncSliceStringV(x.TestStrucCommon.Sslice, e)
				} // end block: if x.TestStrucCommon.Sslice slice == nil
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"SstrUi64T\"")
				} else {
					r.EncodeString(`SstrUi64T`)
				}
				z.EncWriteMapElemValue()
				if x.TestStrucCommon.SstrUi64T == nil {
					r.EncodeNil()
				} else {
					h.encSlicestringUint64T(([]stringUint64T)(x.TestStrucCommon.SstrUi64T), e)
				} // end block: if x.TestStrucCommon.SstrUi64T slice == nil
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"Ui16\"")
				} else {
					r.EncodeString(`Ui16`)
				}
				z.EncWriteMapElemValue()
				r.EncodeUint(uint64(x.TestStrucCommon.Ui16))
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"Ui32\"")
				} else {
					r.EncodeString(`Ui32`)
				}
				z.EncWriteMapElemValue()
				r.EncodeUint(uint64(x.TestStrucCommon.Ui32))
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"Ui64\"")
				} else {
					r.EncodeString(`Ui64`)
				}
				z.EncWriteMapElemValue()
				r.EncodeUint(uint64(x.TestStrucCommon.Ui64))
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"Ui64slice\"")
				} else {
					r.EncodeString(`Ui64slice`)
				}
				z.EncWriteMapElemValue()
				if x.TestStrucCommon.Ui64slice == nil {
					r.EncodeNil()
				} else {
					z.F.EncSliceUint64V(x.TestStrucCommon.Ui64slice, e)
				} // end block: if x.TestStrucCommon.Ui64slice slice == nil
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"Ui8\"")
				} else {
					r.EncodeString(`Ui8`)
				}
				z.EncWriteMapElemValue()
				r.EncodeUint(uint64(x.TestStrucCommon.Ui8))
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"Ui8slice\"")
				} else {
					r.EncodeString(`Ui8slice`)
				}
				z.EncWriteMapElemValue()
				if x.TestStrucCommon.Ui8slice == nil {
					r.EncodeNil()
				} else {
					r.EncodeStringBytesRaw([]byte(x.TestStrucCommon.Ui8slice))
				} // end block: if x.TestStrucCommon.Ui8slice slice == nil
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"WrapSliceInt64\"")
				} else {
					r.EncodeString(`WrapSliceInt64`)
				}
				z.EncWriteMapElemValue()
				if yyxt193 := z.Extension(x.TestStrucCommon.WrapSliceInt64); yyxt193 != nil {
					z.EncExtension(x.TestStrucCommon.WrapSliceInt64, yyxt193)
				} else {
					x.TestStrucCommon.WrapSliceInt64.CodecEncodeSelf(e)
				}
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"WrapSliceString\"")
				} else {
					r.EncodeString(`WrapSliceString`)
				}
				z.EncWriteMapElemValue()
				if yyxt194 := z.Extension(x.TestStrucCommon.WrapSliceString); yyxt194 != nil {
					z.EncExtension(x.TestStrucCommon.WrapSliceString, yyxt194)
				} else {
					x.TestStrucCommon.WrapSliceString.CodecEncodeSelf(e)
				}
			} else {
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"S\"")
				} else {
					r.EncodeString(`S`)
				}
				z.EncWriteMapElemValue()
				r.EncodeString(string(x.TestStrucCommon.S))
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"I64\"")
				} else {
					r.EncodeString(`I64`)
				}
				z.EncWriteMapElemValue()
				r.EncodeInt(int64(x.TestStrucCommon.I64))
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"I32\"")
				} else {
					r.EncodeString(`I32`)
				}
				z.EncWriteMapElemValue()
				r.EncodeInt(int64(x.TestStrucCommon.I32))
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"I16\"")
				} else {
					r.EncodeString(`I16`)
				}
				z.EncWriteMapElemValue()
				r.EncodeInt(int64(x.TestStrucCommon.I16))
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"I8\"")
				} else {
					r.EncodeString(`I8`)
				}
				z.EncWriteMapElemValue()
				r.EncodeInt(int64(x.TestStrucCommon.I8))
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"I64n\"")
				} else {
					r.EncodeString(`I64n`)
				}
				z.EncWriteMapElemValue()
				r.EncodeInt(int64(x.TestStrucCommon.I64n))
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"I32n\"")
				} else {
					r.EncodeString(`I32n`)
				}
				z.EncWriteMapElemValue()
				r.EncodeInt(int64(x.TestStrucCommon.I32n))
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"I16n\"")
				} else {
					r.EncodeString(`I16n`)
				}
				z.EncWriteMapElemValue()
				r.EncodeInt(int64(x.TestStrucCommon.I16n))
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"I8n\"")
				} else {
					r.EncodeString(`I8n`)
				}
				z.EncWriteMapElemValue()
				r.EncodeInt(int64(x.TestStrucCommon.I8n))
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"Ui64\"")
				} else {
					r.EncodeString(`Ui64`)
				}
				z.EncWriteMapElemValue()
				r.EncodeUint(uint64(x.TestStrucCommon.Ui64))
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"Ui32\"")
				} else {
					r.EncodeString(`Ui32`)
				}
				z.EncWriteMapElemValue()
				r.EncodeUint(uint64(x.TestStrucCommon.Ui32))
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"Ui16\"")
				} else {
					r.EncodeString(`Ui16`)
				}
				z.EncWriteMapElemValue()
				r.EncodeUint(uint64(x.TestStrucCommon.Ui16))
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"Ui8\"")
				} else {
					r.EncodeString(`Ui8`)
				}
				z.EncWriteMapElemValue()
				r.EncodeUint(uint64(x.TestStrucCommon.Ui8))
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"F64\"")
				} else {
					r.EncodeString(`F64`)
				}
				z.EncWriteMapElemValue()
				r.EncodeFloat64(float64(x.TestStrucCommon.F64))
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"F32\"")
				} else {
					r.EncodeString(`F32`)
				}
				z.EncWriteMapElemValue()
				r.EncodeFloat32(float32(x.TestStrucCommon.F32))
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"B\"")
				} else {
					r.EncodeString(`B`)
				}
				z.EncWriteMapElemValue()
				r.EncodeBool(bool(x.TestStrucCommon.B))
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"By\"")
				} else {
					r.EncodeString(`By`)
				}
				z.EncWriteMapElemValue()
				r.EncodeUint(uint64(x.TestStrucCommon.By))
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"Sslice\"")
				} else {
					r.EncodeString(`Sslice`)
				}
				z.EncWriteMapElemValue()
				if x.TestStrucCommon.Sslice == nil {
					r.EncodeNil()
				} else {
					z.F.EncSliceStringV(x.TestStrucCommon.Sslice, e)
				} // end block: if x.TestStrucCommon.Sslice slice == nil
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"I64slice\"")
				} else {
					r.EncodeString(`I64slice`)
				}
				z.EncWriteMapElemValue()
				if x.TestStrucCommon.I64slice == nil {
					r.EncodeNil()
				} else {
					z.F.EncSliceInt64V(x.TestStrucCommon.I64slice, e)
				} // end block: if x.TestStrucCommon.I64slice slice == nil
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"I32slice\"")
				} else {
					r.EncodeString(`I32slice`)
				}
				z.EncWriteMapElemValue()
				if x.TestStrucCommon.I32slice == nil {
					r.EncodeNil()
				} else {
					z.F.EncSliceInt32V(x.TestStrucCommon.I32slice, e)
				} // end block: if x.TestStrucCommon.I32slice slice == nil
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"Ui64slice\"")
				} else {
					r.EncodeString(`Ui64slice`)
				}
				z.EncWriteMapElemValue()
				if x.TestStrucCommon.Ui64slice == nil {
					r.EncodeNil()
				} else {
					z.F.EncSliceUint64V(x.TestStrucCommon.Ui64slice, e)
				} // end block: if x.TestStrucCommon.Ui64slice slice == nil
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"Ui8slice\"")
				} else {
					r.EncodeString(`Ui8slice`)
				}
				z.EncWriteMapElemValue()
				if x.TestStrucCommon.Ui8slice == nil {
					r.EncodeNil()
				} else {
					r.EncodeStringBytesRaw([]byte(x.TestStrucCommon.Ui8slice))
				} // end block: if x.TestStrucCommon.Ui8slice slice == nil
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"Bslice\"")
				} else {
					r.EncodeString(`Bslice`)
				}
				z.EncWriteMapElemValue()
				if x.TestStrucCommon.Bslice == nil {
					r.EncodeNil()
				} else {
					z.F.EncSliceBoolV(x.TestStrucCommon.Bslice, e)
				} // end block: if x.TestStrucCommon.Bslice slice == nil
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"Byslice\"")
				} else {
					r.EncodeString(`Byslice`)
				}
				z.EncWriteMapElemValue()
				if x.TestStrucCommon.Byslice == nil {
					r.EncodeNil()
				} else {
					r.EncodeStringBytesRaw([]byte(x.TestStrucCommon.Byslice))
				} // end block: if x.TestStrucCommon.Byslice slice == nil
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"BytesSlice\"")
				} else {
					r.EncodeString(`BytesSlice`)
				}
				z.EncWriteMapElemValue()
				if x.TestStrucCommon.BytesSlice == nil {
					r.EncodeNil()
				} else {
					z.F.EncSliceBytesV(x.TestStrucCommon.BytesSlice, e)
				} // end block: if x.TestStrucCommon.BytesSlice slice == nil
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"Iptrslice\"")
				} else {
					r.EncodeString(`Iptrslice`)
				}
				z.EncWriteMapElemValue()
				if x.TestStrucCommon.Iptrslice == nil {
					r.EncodeNil()
				} else {
					h.encSlicePtrtoint64(([]*int64)(x.TestStrucCommon.Iptrslice), e)
				} // end block: if x.TestStrucCommon.Iptrslice slice == nil
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"WrapSliceInt64\"")
				} else {
					r.EncodeString(`WrapSliceInt64`)
				}
				z.EncWriteMapElemValue()
				if yyxt221 := z.Extension(x.TestStrucCommon.WrapSliceInt64); yyxt221 != nil {
					z.EncExtension(x.TestStrucCommon.WrapSliceInt64, yyxt221)
				} else {
					x.TestStrucCommon.WrapSliceInt64.CodecEncodeSelf(e)
				}
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"WrapSliceString\"")
				} else {
					r.EncodeString(`WrapSliceString`)
				}
				z.EncWriteMapElemValue()
				if yyxt222 := z.Extension(x.TestStrucCommon.WrapSliceString); yyxt222 != nil {
					z.EncExtension(x.TestStrucCommon.WrapSliceString, yyxt222)
				} else {
					x.TestStrucCommon.WrapSliceString.CodecEncodeSelf(e)
				}
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"Msint\"")
				} else {
					r.EncodeString(`Msint`)
				}
				z.EncWriteMapElemValue()
				if x.TestStrucCommon.Msint == nil {
					r.EncodeNil()
				} else {
					z.F.EncMapStringIntV(x.TestStrucCommon.Msint, e)
				} // end block: if x.TestStrucCommon.Msint map == nil
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"Msbytes\"")
				} else {
					r.EncodeString(`Msbytes`)
				}
				z.EncWriteMapElemValue()
				if x.TestStrucCommon.Msbytes == nil {
					r.EncodeNil()
				} else {
					z.F.EncMapStringBytesV(x.TestStrucCommon.Msbytes, e)
				} // end block: if x.TestStrucCommon.Msbytes map == nil
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"Simplef\"")
				} else {
					r.EncodeString(`Simplef`)
				}
				z.EncWriteMapElemValue()
				yy225 := &x.TestStrucCommon.Simplef
				if yyxt226 := z.Extension(yy225); yyxt226 != nil {
					z.EncExtension(yy225, yyxt226)
				} else {
					yy225.CodecEncodeSelf(e)
				}
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"SstrUi64T\"")
				} else {
					r.EncodeString(`SstrUi64T`)
				}
				z.EncWriteMapElemValue()
				if x.TestStrucCommon.SstrUi64T == nil {
					r.EncodeNil()
				} else {
					h.encSlicestringUint64T(([]stringUint64T)(x.TestStrucCommon.SstrUi64T), e)
				} // end block: if x.TestStrucCommon.SstrUi64T slice == nil
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"MstrUi64T\"")
				} else {
					r.EncodeString(`MstrUi64T`)
				}
				z.EncWriteMapElemValue()
				if x.TestStrucCommon.MstrUi64T == nil {
					r.EncodeNil()
				} else {
					h.encMapstringPtrtostringUint64T((map[string]*stringUint64T)(x.TestStrucCommon.MstrUi64T), e)
				} // end block: if x.TestStrucCommon.MstrUi64T map == nil
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"AS\"")
				} else {
					r.EncodeString(`AS`)
				}
				z.EncWriteMapElemValue()
				r.EncodeString(string(x.TestStrucCommon.AnonInTestStruc.AS))
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"AI64\"")
				} else {
					r.EncodeString(`AI64`)
				}
				z.EncWriteMapElemValue()
				r.EncodeInt(int64(x.TestStrucCommon.AnonInTestStruc.AI64))
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"AI16\"")
				} else {
					r.EncodeString(`AI16`)
				}
				z.EncWriteMapElemValue()
				r.EncodeInt(int64(x.TestStrucCommon.AnonInTestStruc.AI16))
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"AUi64\"")
				} else {
					r.EncodeString(`AUi64`)
				}
				z.EncWriteMapElemValue()
				r.EncodeUint(uint64(x.TestStrucCommon.AnonInTestStruc.AUi64))
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"ASslice\"")
				} else {
					r.EncodeString(`ASslice`)
				}
				z.EncWriteMapElemValue()
				if x.TestStrucCommon.AnonInTestStruc.ASslice == nil {
					r.EncodeNil()
				} else {
					z.F.EncSliceStringV(x.TestStrucCommon.AnonInTestStruc.ASslice, e)
				} // end block: if x.TestStrucCommon.AnonInTestStruc.ASslice slice == nil
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"AI64slice\"")
				} else {
					r.EncodeString(`AI64slice`)
				}
				z.EncWriteMapElemValue()
				if x.TestStrucCommon.AnonInTestStruc.AI64slice == nil {
					r.EncodeNil()
				} else {
					z.F.EncSliceInt64V(x.TestStrucCommon.AnonInTestStruc.AI64slice, e)
				} // end block: if x.TestStrucCommon.AnonInTestStruc.AI64slice slice == nil
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"AUi64slice\"")
				} else {
					r.EncodeString(`AUi64slice`)
				}
				z.EncWriteMapElemValue()
				if x.TestStrucCommon.AnonInTestStruc.AUi64slice == nil {
					r.EncodeNil()
				} else {
					z.F.EncSliceUint64V(x.TestStrucCommon.AnonInTestStruc.AUi64slice, e)
				} // end block: if x.TestStrucCommon.AnonInTestStruc.AUi64slice slice == nil
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"AF64slice\"")
				} else {
					r.EncodeString(`AF64slice`)
				}
				z.EncWriteMapElemValue()
				if x.TestStrucCommon.AnonInTestStruc.AF64slice == nil {
					r.EncodeNil()
				} else {
					z.F.EncSliceFloat64V(x.TestStrucCommon.AnonInTestStruc.AF64slice, e)
				} // end block: if x.TestStrucCommon.AnonInTestStruc.AF64slice slice == nil
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"AF32slice\"")
				} else {
					r.EncodeString(`AF32slice`)
				}
				z.EncWriteMapElemValue()
				if x.TestStrucCommon.AnonInTestStruc.AF32slice == nil {
					r.EncodeNil()
				} else {
					z.F.EncSliceFloat32V(x.TestStrucCommon.AnonInTestStruc.AF32slice, e)
				} // end block: if x.TestStrucCommon.AnonInTestStruc.AF32slice slice == nil
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"AMSS\"")
				} else {
					r.EncodeString(`AMSS`)
				}
				z.EncWriteMapElemValue()
				if x.TestStrucCommon.AnonInTestStruc.AMSS == nil {
					r.EncodeNil()
				} else {
					z.F.EncMapStringStringV(x.TestStrucCommon.AnonInTestStruc.AMSS, e)
				} // end block: if x.TestStrucCommon.AnonInTestStruc.AMSS map == nil
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"AMSU64\"")
				} else {
					r.EncodeString(`AMSU64`)
				}
				z.EncWriteMapElemValue()
				if x.TestStrucCommon.AnonInTestStruc.AMSU64 == nil {
					r.EncodeNil()
				} else {
					z.F.EncMapStringUint64V(x.TestStrucCommon.AnonInTestStruc.AMSU64, e)
				} // end block: if x.TestStrucCommon.AnonInTestStruc.AMSU64 map == nil
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"AI64arr8\"")
				} else {
					r.EncodeString(`AI64arr8`)
				}
				z.EncWriteMapElemValue()
				yy240 := &x.TestStrucCommon.AnonInTestStruc.AI64arr8
				h.encArray8int64((*[8]int64)(yy240), e)
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"AI64arr0\"")
				} else {
					r.EncodeString(`AI64arr0`)
				}
				z.EncWriteMapElemValue()
				yy242 := &x.TestStrucCommon.AnonInTestStruc.AI64arr0
				h.encArray0int64((*[0]int64)(yy242), e)
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"AI64slice0\"")
				} else {
					r.EncodeString(`AI64slice0`)
				}
				z.EncWriteMapElemValue()
				if x.TestStrucCommon.AnonInTestStruc.AI64slice0 == nil {
					r.EncodeNil()
				} else {
					z.F.EncSliceInt64V(x.TestStrucCommon.AnonInTestStruc.AI64slice0, e)
				} // end block: if x.TestStrucCommon.AnonInTestStruc.AI64slice0 slice == nil
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"AUi64sliceN\"")
				} else {
					r.EncodeString(`AUi64sliceN`)
				}
				z.EncWriteMapElemValue()
				if x.TestStrucCommon.AnonInTestStruc.AUi64sliceN == nil {
					r.EncodeNil()
				} else {
					z.F.EncSliceUint64V(x.TestStrucCommon.AnonInTestStruc.AUi64sliceN, e)
				} // end block: if x.TestStrucCommon.AnonInTestStruc.AUi64sliceN slice == nil
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"AMSU64N\"")
				} else {
					r.EncodeString(`AMSU64N`)
				}
				z.EncWriteMapElemValue()
				if x.TestStrucCommon.AnonInTestStruc.AMSU64N == nil {
					r.EncodeNil()
				} else {
					z.F.EncMapStringUint64V(x.TestStrucCommon.AnonInTestStruc.AMSU64N, e)
				} // end block: if x.TestStrucCommon.AnonInTestStruc.AMSU64N map == nil
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"AMSU64E\"")
				} else {
					r.EncodeString(`AMSU64E`)
				}
				z.EncWriteMapElemValue()
				if x.TestStrucCommon.AnonInTestStruc.AMSU64E == nil {
					r.EncodeNil()
				} else {
					z.F.EncMapStringUint64V(x.TestStrucCommon.AnonInTestStruc.AMSU64E, e)
				} // end block: if x.TestStrucCommon.AnonInTestStruc.AMSU64E map == nil
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"NotAnon\"")
				} else {
					r.EncodeString(`NotAnon`)
				}
				z.EncWriteMapElemValue()
				yy248 := &x.TestStrucCommon.NotAnon
				if yyxt249 := z.Extension(yy248); yyxt249 != nil {
					z.EncExtension(yy248, yyxt249)
				} else {
					yy248.CodecEncodeSelf(e)
				}
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"P\"")
				} else {
					r.EncodeString(`P`)
				}
				z.EncWriteMapElemValue()
				if yyn54 {
					r.EncodeNil()
				} else {
					yy250 := *x.TestStrucCommon.AnonInTestStrucSlim.P
					r.EncodeString(string(yy250))
				}
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"NotAnonSlim\"")
				} else {
					r.EncodeString(`NotAnonSlim`)
				}
				z.EncWriteMapElemValue()
				if yyn55 {
					r.EncodeNil()
				} else {
					if yyxt252 := z.Extension(x.TestStrucCommon.NotAnonSlim); yyxt252 != nil {
						z.EncExtension(x.TestStrucCommon.NotAnonSlim, yyxt252)
					} else {
						x.TestStrucCommon.NotAnonSlim.CodecEncodeSelf(e)
					}
				}
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"Nmap\"")
				} else {
					r.EncodeString(`Nmap`)
				}
				z.EncWriteMapElemValue()
				if x.TestStrucCommon.Nmap == nil {
					r.EncodeNil()
				} else {
					z.F.EncMapStringBoolV(x.TestStrucCommon.Nmap, e)
				} // end block: if x.TestStrucCommon.Nmap map == nil
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"Nslice\"")
				} else {
					r.EncodeString(`Nslice`)
				}
				z.EncWriteMapElemValue()
				if x.TestStrucCommon.Nslice == nil {
					r.EncodeNil()
				} else {
					r.EncodeStringBytesRaw([]byte(x.TestStrucCommon.Nslice))
				} // end block: if x.TestStrucCommon.Nslice slice == nil
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"Nint64\"")
				} else {
					r.EncodeString(`Nint64`)
				}
				z.EncWriteMapElemValue()
				if yyn58 {
					r.EncodeNil()
				} else {
					yy255 := *x.TestStrucCommon.Nint64
					r.EncodeInt(int64(yy255))
				}
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"Mtsptr\"")
				} else {
					r.EncodeString(`Mtsptr`)
				}
				z.EncWriteMapElemValue()
				if x.Mtsptr == nil {
					r.EncodeNil()
				} else {
					h.encMapstringPtrtoTestStruc((map[string]*TestStruc)(x.Mtsptr), e)
				} // end block: if x.Mtsptr map == nil
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"Mts\"")
				} else {
					r.EncodeString(`Mts`)
				}
				z.EncWriteMapElemValue()
				if x.Mts == nil {
					r.EncodeNil()
				} else {
					h.encMapstringTestStruc((map[string]TestStruc)(x.Mts), e)
				} // end block: if x.Mts map == nil
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"Its\"")
				} else {
					r.EncodeString(`Its`)
				}
				z.EncWriteMapElemValue()
				if x.Its == nil {
					r.EncodeNil()
				} else {
					h.encSlicePtrtoTestStruc(([]*TestStruc)(x.Its), e)
				} // end block: if x.Its slice == nil
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"Nteststruc\"")
				} else {
					r.EncodeString(`Nteststruc`)
				}
				z.EncWriteMapElemValue()
				if yyn62 {
					r.EncodeNil()
				} else {
					if yyxt260 := z.Extension(x.Nteststruc); yyxt260 != nil {
						z.EncExtension(x.Nteststruc, yyxt260)
					} else {
						x.Nteststruc.CodecEncodeSelf(e)
					}
				}
			}
			z.EncWriteMapEnd()
		}
	}
}

func (x *TestStruc) CodecDecodeSelf(d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelper().Decoder(d)
	_, _, _ = h, z, r
	yyct2 := r.ContainerType()
	if yyct2 == codecSelferValueTypeNil19780 {
		*(x) = TestStruc{}
	} else if yyct2 == codecSelferValueTypeMap19780 {
		yyl2 := z.DecReadMapStart()
		if yyl2 == 0 {
		} else {
			x.codecDecodeSelfFromMap(yyl2, d)
		}
		z.DecReadMapEnd()
	} else if yyct2 == codecSelferValueTypeArray19780 {
		yyl2 := z.DecReadArrayStart()
		if yyl2 != 0 {
			x.codecDecodeSelfFromArray(yyl2, d)
		}
		z.DecReadArrayEnd()
	} else {
		panic(errCodecSelferOnlyMapOrArrayEncodeToStruct19780)
	}
}

func (x *TestStruc) codecDecodeSelfFromMap(l int, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelper().Decoder(d)
	_, _, _ = h, z, r
	var yyhl3 bool = l >= 0
	for yyj3 := 0; z.DecContainerNext(yyj3, l, yyhl3); yyj3++ {
		z.DecReadMapElemKey()
		yys3 := r.DecodeStringAsBytes()
		z.DecReadMapElemValue()
		switch string(yys3) {
		case "S":
			x.TestStrucCommon.S = (string)(z.DecStringZC(r.DecodeStringAsBytes()))
		case "I64":
			x.TestStrucCommon.I64 = (int64)(r.DecodeInt64())
		case "I32":
			x.TestStrucCommon.I32 = (int32)(z.C.IntV(r.DecodeInt64(), 32))
		case "I16":
			x.TestStrucCommon.I16 = (int16)(z.C.IntV(r.DecodeInt64(), 16))
		case "I8":
			x.TestStrucCommon.I8 = (int8)(z.C.IntV(r.DecodeInt64(), 8))
		case "I64n":
			x.TestStrucCommon.I64n = (int64)(r.DecodeInt64())
		case "I32n":
			x.TestStrucCommon.I32n = (int32)(z.C.IntV(r.DecodeInt64(), 32))
		case "I16n":
			x.TestStrucCommon.I16n = (int16)(z.C.IntV(r.DecodeInt64(), 16))
		case "I8n":
			x.TestStrucCommon.I8n = (int8)(z.C.IntV(r.DecodeInt64(), 8))
		case "Ui64":
			x.TestStrucCommon.Ui64 = (uint64)(r.DecodeUint64())
		case "Ui32":
			x.TestStrucCommon.Ui32 = (uint32)(z.C.UintV(r.DecodeUint64(), 32))
		case "Ui16":
			x.TestStrucCommon.Ui16 = (uint16)(z.C.UintV(r.DecodeUint64(), 16))
		case "Ui8":
			x.TestStrucCommon.Ui8 = (uint8)(z.C.UintV(r.DecodeUint64(), 8))
		case "F64":
			x.TestStrucCommon.F64 = (float64)(r.DecodeFloat64())
		case "F32":
			x.TestStrucCommon.F32 = (float32)(z.DecDecodeFloat32())
		case "B":
			x.TestStrucCommon.B = (bool)(r.DecodeBool())
		case "By":
			x.TestStrucCommon.By = (uint8)(z.C.UintV(r.DecodeUint64(), 8))
		case "Sslice":
			z.F.DecSliceStringX(&x.TestStrucCommon.Sslice, d)
		case "I64slice":
			z.F.DecSliceInt64X(&x.TestStrucCommon.I64slice, d)
		case "I32slice":
			z.F.DecSliceInt32X(&x.TestStrucCommon.I32slice, d)
		case "Ui64slice":
			z.F.DecSliceUint64X(&x.TestStrucCommon.Ui64slice, d)
		case "Ui8slice":
			x.TestStrucCommon.Ui8slice = z.DecodeBytesInto(([]byte)(x.TestStrucCommon.Ui8slice))
		case "Bslice":
			z.F.DecSliceBoolX(&x.TestStrucCommon.Bslice, d)
		case "Byslice":
			x.TestStrucCommon.Byslice = z.DecodeBytesInto(([]byte)(x.TestStrucCommon.Byslice))
		case "BytesSlice":
			z.F.DecSliceBytesX(&x.TestStrucCommon.BytesSlice, d)
		case "Iptrslice":
			h.decSlicePtrtoint64((*[]*int64)(&x.TestStrucCommon.Iptrslice), d)
		case "WrapSliceInt64":
			if yyxt40 := z.Extension(x.TestStrucCommon.WrapSliceInt64); yyxt40 != nil {
				z.DecExtension(&x.TestStrucCommon.WrapSliceInt64, yyxt40)
			} else {
				x.TestStrucCommon.WrapSliceInt64.CodecDecodeSelf(d)
			}
		case "WrapSliceString":
			if yyxt42 := z.Extension(x.TestStrucCommon.WrapSliceString); yyxt42 != nil {
				z.DecExtension(&x.TestStrucCommon.WrapSliceString, yyxt42)
			} else {
				x.TestStrucCommon.WrapSliceString.CodecDecodeSelf(d)
			}
		case "Msint":
			z.F.DecMapStringIntX(&x.TestStrucCommon.Msint, d)
		case "Msbytes":
			z.F.DecMapStringBytesX(&x.TestStrucCommon.Msbytes, d)
		case "Simplef":
			if yyxt48 := z.Extension(x.TestStrucCommon.Simplef); yyxt48 != nil {
				z.DecExtension(&x.TestStrucCommon.Simplef, yyxt48)
			} else {
				x.TestStrucCommon.Simplef.CodecDecodeSelf(d)
			}
		case "SstrUi64T":
			h.decSlicestringUint64T((*[]stringUint64T)(&x.TestStrucCommon.SstrUi64T), d)
		case "MstrUi64T":
			h.decMapstringPtrtostringUint64T((*map[string]*stringUint64T)(&x.TestStrucCommon.MstrUi64T), d)
		case "AS":
			x.TestStrucCommon.AnonInTestStruc.AS = (string)(z.DecStringZC(r.DecodeStringAsBytes()))
		case "AI64":
			x.TestStrucCommon.AnonInTestStruc.AI64 = (int64)(r.DecodeInt64())
		case "AI16":
			x.TestStrucCommon.AnonInTestStruc.AI16 = (int16)(z.C.IntV(r.DecodeInt64(), 16))
		case "AUi64":
			x.TestStrucCommon.AnonInTestStruc.AUi64 = (uint64)(r.DecodeUint64())
		case "ASslice":
			z.F.DecSliceStringX(&x.TestStrucCommon.AnonInTestStruc.ASslice, d)
		case "AI64slice":
			z.F.DecSliceInt64X(&x.TestStrucCommon.AnonInTestStruc.AI64slice, d)
		case "AUi64slice":
			z.F.DecSliceUint64X(&x.TestStrucCommon.AnonInTestStruc.AUi64slice, d)
		case "AF64slice":
			z.F.DecSliceFloat64X(&x.TestStrucCommon.AnonInTestStruc.AF64slice, d)
		case "AF32slice":
			z.F.DecSliceFloat32X(&x.TestStrucCommon.AnonInTestStruc.AF32slice, d)
		case "AMSS":
			z.F.DecMapStringStringX(&x.TestStrucCommon.AnonInTestStruc.AMSS, d)
		case "AMSU64":
			z.F.DecMapStringUint64X(&x.TestStrucCommon.AnonInTestStruc.AMSU64, d)
		case "AI64arr8":
			h.decArray8int64((*[8]int64)(&x.TestStrucCommon.AnonInTestStruc.AI64arr8), d)
		case "AI64arr0":
			h.decArray0int64((*[0]int64)(&x.TestStrucCommon.AnonInTestStruc.AI64arr0), d)
		case "AI64slice0":
			z.F.DecSliceInt64X(&x.TestStrucCommon.AnonInTestStruc.AI64slice0, d)
		case "AUi64sliceN":
			z.F.DecSliceUint64X(&x.TestStrucCommon.AnonInTestStruc.AUi64sliceN, d)
		case "AMSU64N":
			z.F.DecMapStringUint64X(&x.TestStrucCommon.AnonInTestStruc.AMSU64N, d)
		case "AMSU64E":
			z.F.DecMapStringUint64X(&x.TestStrucCommon.AnonInTestStruc.AMSU64E, d)
		case "NotAnon":
			if yyxt84 := z.Extension(x.TestStrucCommon.NotAnon); yyxt84 != nil {
				z.DecExtension(&x.TestStrucCommon.NotAnon, yyxt84)
			} else {
				x.TestStrucCommon.NotAnon.CodecDecodeSelf(d)
			}
		case "P":
			if r.TryNil() {
				if x.TestStrucCommon.AnonInTestStrucSlim != nil && x.TestStrucCommon.AnonInTestStrucSlim.P != nil { // remove the if-true
					x.TestStrucCommon.AnonInTestStrucSlim.P = nil
				}
			} else {
				if x.TestStrucCommon.AnonInTestStrucSlim == nil {
					x.TestStrucCommon.AnonInTestStrucSlim = new(AnonInTestStrucSlim)
				}
				if x.TestStrucCommon.AnonInTestStrucSlim.P == nil {
					x.TestStrucCommon.AnonInTestStrucSlim.P = new(string)
				}
				*x.TestStrucCommon.AnonInTestStrucSlim.P = (string)(z.DecStringZC(r.DecodeStringAsBytes()))
			}
		case "NotAnonSlim":
			if r.TryNil() {
				if x.TestStrucCommon.NotAnonSlim != nil { // remove the if-true
					x.TestStrucCommon.NotAnonSlim = nil
				}
			} else {
				if x.TestStrucCommon.NotAnonSlim == nil {
					x.TestStrucCommon.NotAnonSlim = new(AnonInTestStrucSlim)
				}
				if yyxt88 := z.Extension(x.TestStrucCommon.NotAnonSlim); yyxt88 != nil {
					z.DecExtension(x.TestStrucCommon.NotAnonSlim, yyxt88)
				} else {
					x.TestStrucCommon.NotAnonSlim.CodecDecodeSelf(d)
				}
			}
		case "Nmap":
			z.F.DecMapStringBoolX(&x.TestStrucCommon.Nmap, d)
		case "Nslice":
			x.TestStrucCommon.Nslice = z.DecodeBytesInto(([]byte)(x.TestStrucCommon.Nslice))
		case "Nint64":
			if r.TryNil() {
				if x.TestStrucCommon.Nint64 != nil { // remove the if-true
					x.TestStrucCommon.Nint64 = nil
				}
			} else {
				if x.TestStrucCommon.Nint64 == nil {
					x.TestStrucCommon.Nint64 = new(int64)
				}
				*x.TestStrucCommon.Nint64 = (int64)(r.DecodeInt64())
			}
		case "Mtsptr":
			h.decMapstringPtrtoTestStruc((*map[string]*TestStruc)(&x.Mtsptr), d)
		case "Mts":
			h.decMapstringTestStruc((*map[string]TestStruc)(&x.Mts), d)
		case "Its":
			h.decSlicePtrtoTestStruc((*[]*TestStruc)(&x.Its), d)
		case "Nteststruc":
			if r.TryNil() {
				if x.Nteststruc != nil { // remove the if-true
					x.Nteststruc = nil
				}
			} else {
				if x.Nteststruc == nil {
					x.Nteststruc = new(TestStruc)
				}
				if yyxt102 := z.Extension(x.Nteststruc); yyxt102 != nil {
					z.DecExtension(x.Nteststruc, yyxt102)
				} else {
					x.Nteststruc.CodecDecodeSelf(d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, string(yys3))
		} // end switch yys3
	} // end for yyj3
}

func (x *TestStruc) codecDecodeSelfFromArray(l int, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelper().Decoder(d)
	_, _, _ = h, z, r
	var yyj103 int
	var yyb103 bool
	var yyhl103 bool = l >= 0
	yyb103 = !z.DecContainerNext(yyj103, l, yyhl103)
	if yyb103 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.TestStrucCommon.S = (string)(z.DecStringZC(r.DecodeStringAsBytes()))
	yyj103++
	yyb103 = !z.DecContainerNext(yyj103, l, yyhl103)
	if yyb103 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.TestStrucCommon.I64 = (int64)(r.DecodeInt64())
	yyj103++
	yyb103 = !z.DecContainerNext(yyj103, l, yyhl103)
	if yyb103 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.TestStrucCommon.I32 = (int32)(z.C.IntV(r.DecodeInt64(), 32))
	yyj103++
	yyb103 = !z.DecContainerNext(yyj103, l, yyhl103)
	if yyb103 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.TestStrucCommon.I16 = (int16)(z.C.IntV(r.DecodeInt64(), 16))
	yyj103++
	yyb103 = !z.DecContainerNext(yyj103, l, yyhl103)
	if yyb103 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.TestStrucCommon.I8 = (int8)(z.C.IntV(r.DecodeInt64(), 8))
	yyj103++
	yyb103 = !z.DecContainerNext(yyj103, l, yyhl103)
	if yyb103 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.TestStrucCommon.I64n = (int64)(r.DecodeInt64())
	yyj103++
	yyb103 = !z.DecContainerNext(yyj103, l, yyhl103)
	if yyb103 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.TestStrucCommon.I32n = (int32)(z.C.IntV(r.DecodeInt64(), 32))
	yyj103++
	yyb103 = !z.DecContainerNext(yyj103, l, yyhl103)
	if yyb103 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.TestStrucCommon.I16n = (int16)(z.C.IntV(r.DecodeInt64(), 16))
	yyj103++
	yyb103 = !z.DecContainerNext(yyj103, l, yyhl103)
	if yyb103 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.TestStrucCommon.I8n = (int8)(z.C.IntV(r.DecodeInt64(), 8))
	yyj103++
	yyb103 = !z.DecContainerNext(yyj103, l, yyhl103)
	if yyb103 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.TestStrucCommon.Ui64 = (uint64)(r.DecodeUint64())
	yyj103++
	yyb103 = !z.DecContainerNext(yyj103, l, yyhl103)
	if yyb103 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.TestStrucCommon.Ui32 = (uint32)(z.C.UintV(r.DecodeUint64(), 32))
	yyj103++
	yyb103 = !z.DecContainerNext(yyj103, l, yyhl103)
	if yyb103 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.TestStrucCommon.Ui16 = (uint16)(z.C.UintV(r.DecodeUint64(), 16))
	yyj103++
	yyb103 = !z.DecContainerNext(yyj103, l, yyhl103)
	if yyb103 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.TestStrucCommon.Ui8 = (uint8)(z.C.UintV(r.DecodeUint64(), 8))
	yyj103++
	yyb103 = !z.DecContainerNext(yyj103, l, yyhl103)
	if yyb103 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.TestStrucCommon.F64 = (float64)(r.DecodeFloat64())
	yyj103++
	yyb103 = !z.DecContainerNext(yyj103, l, yyhl103)
	if yyb103 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.TestStrucCommon.F32 = (float32)(z.DecDecodeFloat32())
	yyj103++
	yyb103 = !z.DecContainerNext(yyj103, l, yyhl103)
	if yyb103 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.TestStrucCommon.B = (bool)(r.DecodeBool())
	yyj103++
	yyb103 = !z.DecContainerNext(yyj103, l, yyhl103)
	if yyb103 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.TestStrucCommon.By = (uint8)(z.C.UintV(r.DecodeUint64(), 8))
	yyj103++
	yyb103 = !z.DecContainerNext(yyj103, l, yyhl103)
	if yyb103 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	z.F.DecSliceStringX(&x.TestStrucCommon.Sslice, d)
	yyj103++
	yyb103 = !z.DecContainerNext(yyj103, l, yyhl103)
	if yyb103 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	z.F.DecSliceInt64X(&x.TestStrucCommon.I64slice, d)
	yyj103++
	yyb103 = !z.DecContainerNext(yyj103, l, yyhl103)
	if yyb103 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	z.F.DecSliceInt32X(&x.TestStrucCommon.I32slice, d)
	yyj103++
	yyb103 = !z.DecContainerNext(yyj103, l, yyhl103)
	if yyb103 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	z.F.DecSliceUint64X(&x.TestStrucCommon.Ui64slice, d)
	yyj103++
	yyb103 = !z.DecContainerNext(yyj103, l, yyhl103)
	if yyb103 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.TestStrucCommon.Ui8slice = z.DecodeBytesInto(([]byte)(x.TestStrucCommon.Ui8slice))
	yyj103++
	yyb103 = !z.DecContainerNext(yyj103, l, yyhl103)
	if yyb103 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	z.F.DecSliceBoolX(&x.TestStrucCommon.Bslice, d)
	yyj103++
	yyb103 = !z.DecContainerNext(yyj103, l, yyhl103)
	if yyb103 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.TestStrucCommon.Byslice = z.DecodeBytesInto(([]byte)(x.TestStrucCommon.Byslice))
	yyj103++
	yyb103 = !z.DecContainerNext(yyj103, l, yyhl103)
	if yyb103 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	z.F.DecSliceBytesX(&x.TestStrucCommon.BytesSlice, d)
	yyj103++
	yyb103 = !z.DecContainerNext(yyj103, l, yyhl103)
	if yyb103 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	h.decSlicePtrtoint64((*[]*int64)(&x.TestStrucCommon.Iptrslice), d)
	yyj103++
	yyb103 = !z.DecContainerNext(yyj103, l, yyhl103)
	if yyb103 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	if yyxt140 := z.Extension(x.TestStrucCommon.WrapSliceInt64); yyxt140 != nil {
		z.DecExtension(&x.TestStrucCommon.WrapSliceInt64, yyxt140)
	} else {
		x.TestStrucCommon.WrapSliceInt64.CodecDecodeSelf(d)
	}
	yyj103++
	yyb103 = !z.DecContainerNext(yyj103, l, yyhl103)
	if yyb103 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	if yyxt142 := z.Extension(x.TestStrucCommon.WrapSliceString); yyxt142 != nil {
		z.DecExtension(&x.TestStrucCommon.WrapSliceString, yyxt142)
	} else {
		x.TestStrucCommon.WrapSliceString.CodecDecodeSelf(d)
	}
	yyj103++
	yyb103 = !z.DecContainerNext(yyj103, l, yyhl103)
	if yyb103 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	z.F.DecMapStringIntX(&x.TestStrucCommon.Msint, d)
	yyj103++
	yyb103 = !z.DecContainerNext(yyj103, l, yyhl103)
	if yyb103 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	z.F.DecMapStringBytesX(&x.TestStrucCommon.Msbytes, d)
	yyj103++
	yyb103 = !z.DecContainerNext(yyj103, l, yyhl103)
	if yyb103 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	if yyxt148 := z.Extension(x.TestStrucCommon.Simplef); yyxt148 != nil {
		z.DecExtension(&x.TestStrucCommon.Simplef, yyxt148)
	} else {
		x.TestStrucCommon.Simplef.CodecDecodeSelf(d)
	}
	yyj103++
	yyb103 = !z.DecContainerNext(yyj103, l, yyhl103)
	if yyb103 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	h.decSlicestringUint64T((*[]stringUint64T)(&x.TestStrucCommon.SstrUi64T), d)
	yyj103++
	yyb103 = !z.DecContainerNext(yyj103, l, yyhl103)
	if yyb103 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	h.decMapstringPtrtostringUint64T((*map[string]*stringUint64T)(&x.TestStrucCommon.MstrUi64T), d)
	yyj103++
	yyb103 = !z.DecContainerNext(yyj103, l, yyhl103)
	if yyb103 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.TestStrucCommon.AnonInTestStruc.AS = (string)(z.DecStringZC(r.DecodeStringAsBytes()))
	yyj103++
	yyb103 = !z.DecContainerNext(yyj103, l, yyhl103)
	if yyb103 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.TestStrucCommon.AnonInTestStruc.AI64 = (int64)(r.DecodeInt64())
	yyj103++
	yyb103 = !z.DecContainerNext(yyj103, l, yyhl103)
	if yyb103 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.TestStrucCommon.AnonInTestStruc.AI16 = (int16)(z.C.IntV(r.DecodeInt64(), 16))
	yyj103++
	yyb103 = !z.DecContainerNext(yyj103, l, yyhl103)
	if yyb103 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.TestStrucCommon.AnonInTestStruc.AUi64 = (uint64)(r.DecodeUint64())
	yyj103++
	yyb103 = !z.DecContainerNext(yyj103, l, yyhl103)
	if yyb103 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	z.F.DecSliceStringX(&x.TestStrucCommon.AnonInTestStruc.ASslice, d)
	yyj103++
	yyb103 = !z.DecContainerNext(yyj103, l, yyhl103)
	if yyb103 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	z.F.DecSliceInt64X(&x.TestStrucCommon.AnonInTestStruc.AI64slice, d)
	yyj103++
	yyb103 = !z.DecContainerNext(yyj103, l, yyhl103)
	if yyb103 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	z.F.DecSliceUint64X(&x.TestStrucCommon.AnonInTestStruc.AUi64slice, d)
	yyj103++
	yyb103 = !z.DecContainerNext(yyj103, l, yyhl103)
	if yyb103 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	z.F.DecSliceFloat64X(&x.TestStrucCommon.AnonInTestStruc.AF64slice, d)
	yyj103++
	yyb103 = !z.DecContainerNext(yyj103, l, yyhl103)
	if yyb103 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	z.F.DecSliceFloat32X(&x.TestStrucCommon.AnonInTestStruc.AF32slice, d)
	yyj103++
	yyb103 = !z.DecContainerNext(yyj103, l, yyhl103)
	if yyb103 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	z.F.DecMapStringStringX(&x.TestStrucCommon.AnonInTestStruc.AMSS, d)
	yyj103++
	yyb103 = !z.DecContainerNext(yyj103, l, yyhl103)
	if yyb103 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	z.F.DecMapStringUint64X(&x.TestStrucCommon.AnonInTestStruc.AMSU64, d)
	yyj103++
	yyb103 = !z.DecContainerNext(yyj103, l, yyhl103)
	if yyb103 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	h.decArray8int64((*[8]int64)(&x.TestStrucCommon.AnonInTestStruc.AI64arr8), d)
	yyj103++
	yyb103 = !z.DecContainerNext(yyj103, l, yyhl103)
	if yyb103 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	h.decArray0int64((*[0]int64)(&x.TestStrucCommon.AnonInTestStruc.AI64arr0), d)
	yyj103++
	yyb103 = !z.DecContainerNext(yyj103, l, yyhl103)
	if yyb103 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	z.F.DecSliceInt64X(&x.TestStrucCommon.AnonInTestStruc.AI64slice0, d)
	yyj103++
	yyb103 = !z.DecContainerNext(yyj103, l, yyhl103)
	if yyb103 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	z.F.DecSliceUint64X(&x.TestStrucCommon.AnonInTestStruc.AUi64sliceN, d)
	yyj103++
	yyb103 = !z.DecContainerNext(yyj103, l, yyhl103)
	if yyb103 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	z.F.DecMapStringUint64X(&x.TestStrucCommon.AnonInTestStruc.AMSU64N, d)
	yyj103++
	yyb103 = !z.DecContainerNext(yyj103, l, yyhl103)
	if yyb103 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	z.F.DecMapStringUint64X(&x.TestStrucCommon.AnonInTestStruc.AMSU64E, d)
	yyj103++
	yyb103 = !z.DecContainerNext(yyj103, l, yyhl103)
	if yyb103 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	if yyxt184 := z.Extension(x.TestStrucCommon.NotAnon); yyxt184 != nil {
		z.DecExtension(&x.TestStrucCommon.NotAnon, yyxt184)
	} else {
		x.TestStrucCommon.NotAnon.CodecDecodeSelf(d)
	}
	yyj103++
	yyb103 = !z.DecContainerNext(yyj103, l, yyhl103)
	if yyb103 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	if r.TryNil() {
		if x.TestStrucCommon.AnonInTestStrucSlim != nil && x.TestStrucCommon.AnonInTestStrucSlim.P != nil { // remove the if-true
			x.TestStrucCommon.AnonInTestStrucSlim.P = nil
		}
	} else {
		if x.TestStrucCommon.AnonInTestStrucSlim == nil {
			x.TestStrucCommon.AnonInTestStrucSlim = new(AnonInTestStrucSlim)
		}
		if x.TestStrucCommon.AnonInTestStrucSlim.P == nil {
			x.TestStrucCommon.AnonInTestStrucSlim.P = new(string)
		}
		*x.TestStrucCommon.AnonInTestStrucSlim.P = (string)(z.DecStringZC(r.DecodeStringAsBytes()))
	}
	yyj103++
	yyb103 = !z.DecContainerNext(yyj103, l, yyhl103)
	if yyb103 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	if r.TryNil() {
		if x.TestStrucCommon.NotAnonSlim != nil { // remove the if-true
			x.TestStrucCommon.NotAnonSlim = nil
		}
	} else {
		if x.TestStrucCommon.NotAnonSlim == nil {
			x.TestStrucCommon.NotAnonSlim = new(AnonInTestStrucSlim)
		}
		if yyxt188 := z.Extension(x.TestStrucCommon.NotAnonSlim); yyxt188 != nil {
			z.DecExtension(x.TestStrucCommon.NotAnonSlim, yyxt188)
		} else {
			x.TestStrucCommon.NotAnonSlim.CodecDecodeSelf(d)
		}
	}
	yyj103++
	yyb103 = !z.DecContainerNext(yyj103, l, yyhl103)
	if yyb103 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	z.F.DecMapStringBoolX(&x.TestStrucCommon.Nmap, d)
	yyj103++
	yyb103 = !z.DecContainerNext(yyj103, l, yyhl103)
	if yyb103 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.TestStrucCommon.Nslice = z.DecodeBytesInto(([]byte)(x.TestStrucCommon.Nslice))
	yyj103++
	yyb103 = !z.DecContainerNext(yyj103, l, yyhl103)
	if yyb103 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	if r.TryNil() {
		if x.TestStrucCommon.Nint64 != nil { // remove the if-true
			x.TestStrucCommon.Nint64 = nil
		}
	} else {
		if x.TestStrucCommon.Nint64 == nil {
			x.TestStrucCommon.Nint64 = new(int64)
		}
		*x.TestStrucCommon.Nint64 = (int64)(r.DecodeInt64())
	}
	yyj103++
	yyb103 = !z.DecContainerNext(yyj103, l, yyhl103)
	if yyb103 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	h.decMapstringPtrtoTestStruc((*map[string]*TestStruc)(&x.Mtsptr), d)
	yyj103++
	yyb103 = !z.DecContainerNext(yyj103, l, yyhl103)
	if yyb103 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	h.decMapstringTestStruc((*map[string]TestStruc)(&x.Mts), d)
	yyj103++
	yyb103 = !z.DecContainerNext(yyj103, l, yyhl103)
	if yyb103 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	h.decSlicePtrtoTestStruc((*[]*TestStruc)(&x.Its), d)
	yyj103++
	yyb103 = !z.DecContainerNext(yyj103, l, yyhl103)
	if yyb103 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	if r.TryNil() {
		if x.Nteststruc != nil { // remove the if-true
			x.Nteststruc = nil
		}
	} else {
		if x.Nteststruc == nil {
			x.Nteststruc = new(TestStruc)
		}
		if yyxt202 := z.Extension(x.Nteststruc); yyxt202 != nil {
			z.DecExtension(x.Nteststruc, yyxt202)
		} else {
			x.Nteststruc.CodecDecodeSelf(d)
		}
	}
	yyj103++
	for ; z.DecContainerNext(yyj103, l, yyhl103); yyj103++ {
		z.DecReadArrayElem()
		z.DecStructFieldNotFound(yyj103-1, "")
	}
}

func (x *TestStruc) IsCodecEmpty() bool {
	return !(!(x.TestStrucCommon.IsCodecEmpty()) || len(x.Mtsptr) != 0 || len(x.Mts) != 0 || len(x.Its) != 0 || false)
}

func (codecgenA) codecSelferViaCodecgen() {}
func (x *codecgenA) CodecEncodeSelf(e *Encoder) {
	var h codecSelfer19780
	z, r := GenHelper().Encoder(e)
	_, _, _ = h, z, r
	if z.EncBasicHandle().CheckCircularRef {
		z.EncEncode(x)
		return
	}
	if x == nil {
		r.EncodeNil()
	} else {
		yy2arr2 := z.EncBasicHandle().StructToArray
		_ = yy2arr2
		const yyr2 bool = false // struct tag has 'toArray'
		if yyr2 || yy2arr2 {
			z.EncWriteArrayStart(1)
			z.EncWriteArrayElem()
			if x.ZZ == nil {
				r.EncodeNil()
			} else {
				r.EncodeStringBytesRaw([]byte(x.ZZ))
			} // end block: if x.ZZ slice == nil
			z.EncWriteArrayEnd()
		} else {
			z.EncWriteMapStart(1)
			if z.EncBasicHandle().Canonical {
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"ZZ\"")
				} else {
					r.EncodeString(`ZZ`)
				}
				z.EncWriteMapElemValue()
				if x.ZZ == nil {
					r.EncodeNil()
				} else {
					r.EncodeStringBytesRaw([]byte(x.ZZ))
				} // end block: if x.ZZ slice == nil
			} else {
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"ZZ\"")
				} else {
					r.EncodeString(`ZZ`)
				}
				z.EncWriteMapElemValue()
				if x.ZZ == nil {
					r.EncodeNil()
				} else {
					r.EncodeStringBytesRaw([]byte(x.ZZ))
				} // end block: if x.ZZ slice == nil
			}
			z.EncWriteMapEnd()
		}
	}
}

func (x *codecgenA) CodecDecodeSelf(d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelper().Decoder(d)
	_, _, _ = h, z, r
	yyct2 := r.ContainerType()
	if yyct2 == codecSelferValueTypeNil19780 {
		*(x) = codecgenA{}
	} else if yyct2 == codecSelferValueTypeMap19780 {
		yyl2 := z.DecReadMapStart()
		if yyl2 == 0 {
		} else {
			x.codecDecodeSelfFromMap(yyl2, d)
		}
		z.DecReadMapEnd()
	} else if yyct2 == codecSelferValueTypeArray19780 {
		yyl2 := z.DecReadArrayStart()
		if yyl2 != 0 {
			x.codecDecodeSelfFromArray(yyl2, d)
		}
		z.DecReadArrayEnd()
	} else {
		panic(errCodecSelferOnlyMapOrArrayEncodeToStruct19780)
	}
}

func (x *codecgenA) codecDecodeSelfFromMap(l int, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelper().Decoder(d)
	_, _, _ = h, z, r
	var yyhl3 bool = l >= 0
	for yyj3 := 0; z.DecContainerNext(yyj3, l, yyhl3); yyj3++ {
		z.DecReadMapElemKey()
		yys3 := r.DecodeStringAsBytes()
		z.DecReadMapElemValue()
		switch string(yys3) {
		case "ZZ":
			x.ZZ = z.DecodeBytesInto(([]byte)(x.ZZ))
		default:
			z.DecStructFieldNotFound(-1, string(yys3))
		} // end switch yys3
	} // end for yyj3
}

func (x *codecgenA) codecDecodeSelfFromArray(l int, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelper().Decoder(d)
	_, _, _ = h, z, r
	var yyj6 int
	var yyb6 bool
	var yyhl6 bool = l >= 0
	yyb6 = !z.DecContainerNext(yyj6, l, yyhl6)
	if yyb6 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.ZZ = z.DecodeBytesInto(([]byte)(x.ZZ))
	yyj6++
	for ; z.DecContainerNext(yyj6, l, yyhl6); yyj6++ {
		z.DecReadArrayElem()
		z.DecStructFieldNotFound(yyj6-1, "")
	}
}

func (x *codecgenA) IsCodecEmpty() bool {
	return !(len(x.ZZ) != 0 || false)
}

func (codecgenB) codecSelferViaCodecgen() {}
func (x *codecgenB) CodecEncodeSelf(e *Encoder) {
	var h codecSelfer19780
	z, r := GenHelper().Encoder(e)
	_, _, _ = h, z, r
	if z.EncBasicHandle().CheckCircularRef {
		z.EncEncode(x)
		return
	}
	if x == nil {
		r.EncodeNil()
	} else {
		yy2arr2 := z.EncBasicHandle().StructToArray
		_ = yy2arr2
		const yyr2 bool = false // struct tag has 'toArray'
		if yyr2 || yy2arr2 {
			z.EncWriteArrayStart(1)
			z.EncWriteArrayElem()
			yy4 := &x.AA
			if yyxt5 := z.Extension(yy4); yyxt5 != nil {
				z.EncExtension(yy4, yyxt5)
			} else {
				yy4.CodecEncodeSelf(e)
			}
			z.EncWriteArrayEnd()
		} else {
			z.EncWriteMapStart(1)
			if z.EncBasicHandle().Canonical {
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"AA\"")
				} else {
					r.EncodeString(`AA`)
				}
				z.EncWriteMapElemValue()
				yy6 := &x.AA
				if yyxt7 := z.Extension(yy6); yyxt7 != nil {
					z.EncExtension(yy6, yyxt7)
				} else {
					yy6.CodecEncodeSelf(e)
				}
			} else {
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"AA\"")
				} else {
					r.EncodeString(`AA`)
				}
				z.EncWriteMapElemValue()
				yy8 := &x.AA
				if yyxt9 := z.Extension(yy8); yyxt9 != nil {
					z.EncExtension(yy8, yyxt9)
				} else {
					yy8.CodecEncodeSelf(e)
				}
			}
			z.EncWriteMapEnd()
		}
	}
}

func (x *codecgenB) CodecDecodeSelf(d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelper().Decoder(d)
	_, _, _ = h, z, r
	yyct2 := r.ContainerType()
	if yyct2 == codecSelferValueTypeNil19780 {
		*(x) = codecgenB{}
	} else if yyct2 == codecSelferValueTypeMap19780 {
		yyl2 := z.DecReadMapStart()
		if yyl2 == 0 {
		} else {
			x.codecDecodeSelfFromMap(yyl2, d)
		}
		z.DecReadMapEnd()
	} else if yyct2 == codecSelferValueTypeArray19780 {
		yyl2 := z.DecReadArrayStart()
		if yyl2 != 0 {
			x.codecDecodeSelfFromArray(yyl2, d)
		}
		z.DecReadArrayEnd()
	} else {
		panic(errCodecSelferOnlyMapOrArrayEncodeToStruct19780)
	}
}

func (x *codecgenB) codecDecodeSelfFromMap(l int, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelper().Decoder(d)
	_, _, _ = h, z, r
	var yyhl3 bool = l >= 0
	for yyj3 := 0; z.DecContainerNext(yyj3, l, yyhl3); yyj3++ {
		z.DecReadMapElemKey()
		yys3 := r.DecodeStringAsBytes()
		z.DecReadMapElemValue()
		switch string(yys3) {
		case "AA":
			if yyxt5 := z.Extension(x.AA); yyxt5 != nil {
				z.DecExtension(&x.AA, yyxt5)
			} else {
				x.AA.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, string(yys3))
		} // end switch yys3
	} // end for yyj3
}

func (x *codecgenB) codecDecodeSelfFromArray(l int, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelper().Decoder(d)
	_, _, _ = h, z, r
	var yyj6 int
	var yyb6 bool
	var yyhl6 bool = l >= 0
	yyb6 = !z.DecContainerNext(yyj6, l, yyhl6)
	if yyb6 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	if yyxt8 := z.Extension(x.AA); yyxt8 != nil {
		z.DecExtension(&x.AA, yyxt8)
	} else {
		x.AA.CodecDecodeSelf(d)
	}
	yyj6++
	for ; z.DecContainerNext(yyj6, l, yyhl6); yyj6++ {
		z.DecReadArrayElem()
		z.DecStructFieldNotFound(yyj6-1, "")
	}
}

func (x *codecgenB) IsCodecEmpty() bool {
	return !(!(x.AA.IsCodecEmpty()) || false)
}

func (codecgenC) codecSelferViaCodecgen() {}
func (x *codecgenC) CodecEncodeSelf(e *Encoder) {
	var h codecSelfer19780
	z, r := GenHelper().Encoder(e)
	_, _, _ = h, z, r
	if z.EncBasicHandle().CheckCircularRef {
		z.EncEncode(x)
		return
	}
	if x == nil {
		r.EncodeNil()
	} else {
		yy2arr2 := z.EncBasicHandle().StructToArray
		_ = yy2arr2
		const yyr2 bool = false // struct tag has 'toArray'
		var yyq2 = [1]bool{     // should field at this index be written?
			!(x.BB.IsCodecEmpty()), // BB
		}
		_ = yyq2
		if yyr2 || yy2arr2 {
			z.EncWriteArrayStart(1)
			z.EncWriteArrayElem()
			if yyq2[0] {
				yy4 := &x.BB
				if yyxt5 := z.Extension(yy4); yyxt5 != nil {
					z.EncExtension(yy4, yyxt5)
				} else {
					yy4.CodecEncodeSelf(e)
				}
			} else {
				r.EncodeNil()
			}
			z.EncWriteArrayEnd()
		} else {
			var yynn2 int
			for _, b := range yyq2 {
				if b {
					yynn2++
				}
			}
			z.EncWriteMapStart(yynn2)
			yynn2 = 0
			if z.EncBasicHandle().Canonical {
				if yyq2[0] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"BB\"")
					} else {
						r.EncodeString(`BB`)
					}
					z.EncWriteMapElemValue()
					yy6 := &x.BB
					if yyxt7 := z.Extension(yy6); yyxt7 != nil {
						z.EncExtension(yy6, yyxt7)
					} else {
						yy6.CodecEncodeSelf(e)
					}
				}
			} else {
				if yyq2[0] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"BB\"")
					} else {
						r.EncodeString(`BB`)
					}
					z.EncWriteMapElemValue()
					yy8 := &x.BB
					if yyxt9 := z.Extension(yy8); yyxt9 != nil {
						z.EncExtension(yy8, yyxt9)
					} else {
						yy8.CodecEncodeSelf(e)
					}
				}
			}
			z.EncWriteMapEnd()
		}
	}
}

func (x *codecgenC) CodecDecodeSelf(d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelper().Decoder(d)
	_, _, _ = h, z, r
	yyct2 := r.ContainerType()
	if yyct2 == codecSelferValueTypeNil19780 {
		*(x) = codecgenC{}
	} else if yyct2 == codecSelferValueTypeMap19780 {
		yyl2 := z.DecReadMapStart()
		if yyl2 == 0 {
		} else {
			x.codecDecodeSelfFromMap(yyl2, d)
		}
		z.DecReadMapEnd()
	} else if yyct2 == codecSelferValueTypeArray19780 {
		yyl2 := z.DecReadArrayStart()
		if yyl2 != 0 {
			x.codecDecodeSelfFromArray(yyl2, d)
		}
		z.DecReadArrayEnd()
	} else {
		panic(errCodecSelferOnlyMapOrArrayEncodeToStruct19780)
	}
}

func (x *codecgenC) codecDecodeSelfFromMap(l int, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelper().Decoder(d)
	_, _, _ = h, z, r
	var yyhl3 bool = l >= 0
	for yyj3 := 0; z.DecContainerNext(yyj3, l, yyhl3); yyj3++ {
		z.DecReadMapElemKey()
		yys3 := r.DecodeStringAsBytes()
		z.DecReadMapElemValue()
		switch string(yys3) {
		case "BB":
			if yyxt5 := z.Extension(x.BB); yyxt5 != nil {
				z.DecExtension(&x.BB, yyxt5)
			} else {
				x.BB.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, string(yys3))
		} // end switch yys3
	} // end for yyj3
}

func (x *codecgenC) codecDecodeSelfFromArray(l int, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelper().Decoder(d)
	_, _, _ = h, z, r
	var yyj6 int
	var yyb6 bool
	var yyhl6 bool = l >= 0
	yyb6 = !z.DecContainerNext(yyj6, l, yyhl6)
	if yyb6 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	if yyxt8 := z.Extension(x.BB); yyxt8 != nil {
		z.DecExtension(&x.BB, yyxt8)
	} else {
		x.BB.CodecDecodeSelf(d)
	}
	yyj6++
	for ; z.DecContainerNext(yyj6, l, yyhl6); yyj6++ {
		z.DecReadArrayElem()
		z.DecStructFieldNotFound(yyj6-1, "")
	}
}

func (x *codecgenC) IsCodecEmpty() bool {
	return !(!(x.BB.IsCodecEmpty()) || false)
}

func (TestCodecgenG) codecSelferViaCodecgen() {}
func (x *TestCodecgenG) CodecEncodeSelf(e *Encoder) {
	var h codecSelfer19780
	z, r := GenHelper().Encoder(e)
	_, _, _ = h, z, r
	if z.EncBasicHandle().CheckCircularRef {
		z.EncEncode(x)
		return
	}
	if x == nil {
		r.EncodeNil()
	} else {
		yy2arr2 := z.EncBasicHandle().StructToArray
		_ = yy2arr2
		const yyr2 bool = false // struct tag has 'toArray'
		if yyr2 || yy2arr2 {
			z.EncWriteArrayStart(1)
			z.EncWriteArrayElem()
			r.EncodeInt(int64(x.TestCodecgenG))
			z.EncWriteArrayEnd()
		} else {
			z.EncWriteMapStart(1)
			if z.EncBasicHandle().Canonical {
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"TestCodecgenG\"")
				} else {
					r.EncodeString(`TestCodecgenG`)
				}
				z.EncWriteMapElemValue()
				r.EncodeInt(int64(x.TestCodecgenG))
			} else {
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"TestCodecgenG\"")
				} else {
					r.EncodeString(`TestCodecgenG`)
				}
				z.EncWriteMapElemValue()
				r.EncodeInt(int64(x.TestCodecgenG))
			}
			z.EncWriteMapEnd()
		}
	}
}

func (x *TestCodecgenG) CodecDecodeSelf(d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelper().Decoder(d)
	_, _, _ = h, z, r
	yyct2 := r.ContainerType()
	if yyct2 == codecSelferValueTypeNil19780 {
		*(x) = TestCodecgenG{}
	} else if yyct2 == codecSelferValueTypeMap19780 {
		yyl2 := z.DecReadMapStart()
		if yyl2 == 0 {
		} else {
			x.codecDecodeSelfFromMap(yyl2, d)
		}
		z.DecReadMapEnd()
	} else if yyct2 == codecSelferValueTypeArray19780 {
		yyl2 := z.DecReadArrayStart()
		if yyl2 != 0 {
			x.codecDecodeSelfFromArray(yyl2, d)
		}
		z.DecReadArrayEnd()
	} else {
		panic(errCodecSelferOnlyMapOrArrayEncodeToStruct19780)
	}
}

func (x *TestCodecgenG) codecDecodeSelfFromMap(l int, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelper().Decoder(d)
	_, _, _ = h, z, r
	var yyhl3 bool = l >= 0
	for yyj3 := 0; z.DecContainerNext(yyj3, l, yyhl3); yyj3++ {
		z.DecReadMapElemKey()
		yys3 := r.DecodeStringAsBytes()
		z.DecReadMapElemValue()
		switch string(yys3) {
		case "TestCodecgenG":
			x.TestCodecgenG = (int)(z.C.IntV(r.DecodeInt64(), codecSelferBitsize19780))
		default:
			z.DecStructFieldNotFound(-1, string(yys3))
		} // end switch yys3
	} // end for yyj3
}

func (x *TestCodecgenG) codecDecodeSelfFromArray(l int, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelper().Decoder(d)
	_, _, _ = h, z, r
	var yyj5 int
	var yyb5 bool
	var yyhl5 bool = l >= 0
	yyb5 = !z.DecContainerNext(yyj5, l, yyhl5)
	if yyb5 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.TestCodecgenG = (int)(z.C.IntV(r.DecodeInt64(), codecSelferBitsize19780))
	yyj5++
	for ; z.DecContainerNext(yyj5, l, yyhl5); yyj5++ {
		z.DecReadArrayElem()
		z.DecStructFieldNotFound(yyj5-1, "")
	}
}

func (x *TestCodecgenG) IsCodecEmpty() bool {
	return !(x.TestCodecgenG != 0 || false)
}

func (codecgenH) codecSelferViaCodecgen() {}
func (x *codecgenH) CodecEncodeSelf(e *Encoder) {
	var h codecSelfer19780
	z, r := GenHelper().Encoder(e)
	_, _, _ = h, z, r
	if z.EncBasicHandle().CheckCircularRef {
		z.EncEncode(x)
		return
	}
	if x == nil {
		r.EncodeNil()
	} else {
		yy2arr2 := z.EncBasicHandle().StructToArray
		_ = yy2arr2
		const yyr2 bool = false // struct tag has 'toArray'
		if yyr2 || yy2arr2 {
			z.EncWriteArrayStart(1)
			z.EncWriteArrayElem()
			r.EncodeInt(int64(x.TestCodecgenG.TestCodecgenG))
			z.EncWriteArrayEnd()
		} else {
			z.EncWriteMapStart(1)
			if z.EncBasicHandle().Canonical {
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"TestCodecgenG\"")
				} else {
					r.EncodeString(`TestCodecgenG`)
				}
				z.EncWriteMapElemValue()
				r.EncodeInt(int64(x.TestCodecgenG.TestCodecgenG))
			} else {
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"TestCodecgenG\"")
				} else {
					r.EncodeString(`TestCodecgenG`)
				}
				z.EncWriteMapElemValue()
				r.EncodeInt(int64(x.TestCodecgenG.TestCodecgenG))
			}
			z.EncWriteMapEnd()
		}
	}
}

func (x *codecgenH) CodecDecodeSelf(d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelper().Decoder(d)
	_, _, _ = h, z, r
	yyct2 := r.ContainerType()
	if yyct2 == codecSelferValueTypeNil19780 {
		*(x) = codecgenH{}
	} else if yyct2 == codecSelferValueTypeMap19780 {
		yyl2 := z.DecReadMapStart()
		if yyl2 == 0 {
		} else {
			x.codecDecodeSelfFromMap(yyl2, d)
		}
		z.DecReadMapEnd()
	} else if yyct2 == codecSelferValueTypeArray19780 {
		yyl2 := z.DecReadArrayStart()
		if yyl2 != 0 {
			x.codecDecodeSelfFromArray(yyl2, d)
		}
		z.DecReadArrayEnd()
	} else {
		panic(errCodecSelferOnlyMapOrArrayEncodeToStruct19780)
	}
}

func (x *codecgenH) codecDecodeSelfFromMap(l int, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelper().Decoder(d)
	_, _, _ = h, z, r
	var yyhl3 bool = l >= 0
	for yyj3 := 0; z.DecContainerNext(yyj3, l, yyhl3); yyj3++ {
		z.DecReadMapElemKey()
		yys3 := r.DecodeStringAsBytes()
		z.DecReadMapElemValue()
		switch string(yys3) {
		case "TestCodecgenG":
			x.TestCodecgenG.TestCodecgenG = (int)(z.C.IntV(r.DecodeInt64(), codecSelferBitsize19780))
		default:
			z.DecStructFieldNotFound(-1, string(yys3))
		} // end switch yys3
	} // end for yyj3
}

func (x *codecgenH) codecDecodeSelfFromArray(l int, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelper().Decoder(d)
	_, _, _ = h, z, r
	var yyj5 int
	var yyb5 bool
	var yyhl5 bool = l >= 0
	yyb5 = !z.DecContainerNext(yyj5, l, yyhl5)
	if yyb5 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.TestCodecgenG.TestCodecgenG = (int)(z.C.IntV(r.DecodeInt64(), codecSelferBitsize19780))
	yyj5++
	for ; z.DecContainerNext(yyj5, l, yyhl5); yyj5++ {
		z.DecReadArrayElem()
		z.DecStructFieldNotFound(yyj5-1, "")
	}
}

func (x *codecgenH) IsCodecEmpty() bool {
	return !(!(x.TestCodecgenG.IsCodecEmpty()) || false)
}

func (codecgenI) codecSelferViaCodecgen() {}
func (x *codecgenI) CodecEncodeSelf(e *Encoder) {
	var h codecSelfer19780
	z, r := GenHelper().Encoder(e)
	_, _, _ = h, z, r
	if z.EncBasicHandle().CheckCircularRef {
		z.EncEncode(x)
		return
	}
	if x == nil {
		r.EncodeNil()
	} else {
		yy2arr2 := z.EncBasicHandle().StructToArray
		_ = yy2arr2
		const yyr2 bool = false // struct tag has 'toArray'
		if yyr2 || yy2arr2 {
			z.EncWriteArrayStart(1)
			z.EncWriteArrayElem()
			r.EncodeInt(int64(x.codecgenH.TestCodecgenG.TestCodecgenG))
			z.EncWriteArrayEnd()
		} else {
			z.EncWriteMapStart(1)
			if z.EncBasicHandle().Canonical {
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"TestCodecgenG\"")
				} else {
					r.EncodeString(`TestCodecgenG`)
				}
				z.EncWriteMapElemValue()
				r.EncodeInt(int64(x.codecgenH.TestCodecgenG.TestCodecgenG))
			} else {
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"TestCodecgenG\"")
				} else {
					r.EncodeString(`TestCodecgenG`)
				}
				z.EncWriteMapElemValue()
				r.EncodeInt(int64(x.codecgenH.TestCodecgenG.TestCodecgenG))
			}
			z.EncWriteMapEnd()
		}
	}
}

func (x *codecgenI) CodecDecodeSelf(d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelper().Decoder(d)
	_, _, _ = h, z, r
	yyct2 := r.ContainerType()
	if yyct2 == codecSelferValueTypeNil19780 {
		*(x) = codecgenI{}
	} else if yyct2 == codecSelferValueTypeMap19780 {
		yyl2 := z.DecReadMapStart()
		if yyl2 == 0 {
		} else {
			x.codecDecodeSelfFromMap(yyl2, d)
		}
		z.DecReadMapEnd()
	} else if yyct2 == codecSelferValueTypeArray19780 {
		yyl2 := z.DecReadArrayStart()
		if yyl2 != 0 {
			x.codecDecodeSelfFromArray(yyl2, d)
		}
		z.DecReadArrayEnd()
	} else {
		panic(errCodecSelferOnlyMapOrArrayEncodeToStruct19780)
	}
}

func (x *codecgenI) codecDecodeSelfFromMap(l int, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelper().Decoder(d)
	_, _, _ = h, z, r
	var yyhl3 bool = l >= 0
	for yyj3 := 0; z.DecContainerNext(yyj3, l, yyhl3); yyj3++ {
		z.DecReadMapElemKey()
		yys3 := r.DecodeStringAsBytes()
		z.DecReadMapElemValue()
		switch string(yys3) {
		case "TestCodecgenG":
			x.codecgenH.TestCodecgenG.TestCodecgenG = (int)(z.C.IntV(r.DecodeInt64(), codecSelferBitsize19780))
		default:
			z.DecStructFieldNotFound(-1, string(yys3))
		} // end switch yys3
	} // end for yyj3
}

func (x *codecgenI) codecDecodeSelfFromArray(l int, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelper().Decoder(d)
	_, _, _ = h, z, r
	var yyj5 int
	var yyb5 bool
	var yyhl5 bool = l >= 0
	yyb5 = !z.DecContainerNext(yyj5, l, yyhl5)
	if yyb5 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.codecgenH.TestCodecgenG.TestCodecgenG = (int)(z.C.IntV(r.DecodeInt64(), codecSelferBitsize19780))
	yyj5++
	for ; z.DecContainerNext(yyj5, l, yyhl5); yyj5++ {
		z.DecReadArrayElem()
		z.DecStructFieldNotFound(yyj5-1, "")
	}
}

func (x *codecgenI) IsCodecEmpty() bool {
	return !(!(x.codecgenH.IsCodecEmpty()) || false)
}

func (codecgenK) codecSelferViaCodecgen() {}
func (x *codecgenK) CodecEncodeSelf(e *Encoder) {
	var h codecSelfer19780
	z, r := GenHelper().Encoder(e)
	_, _, _ = h, z, r
	if z.EncBasicHandle().CheckCircularRef {
		z.EncEncode(x)
		return
	}
	if x == nil {
		r.EncodeNil()
	} else {
		yy2arr2 := z.EncBasicHandle().StructToArray
		_ = yy2arr2
		const yyr2 bool = false // struct tag has 'toArray'
		if yyr2 || yy2arr2 {
			z.EncWriteArrayStart(2)
			z.EncWriteArrayElem()
			r.EncodeInt(int64(x.X))
			z.EncWriteArrayElem()
			r.EncodeString(string(x.Y))
			z.EncWriteArrayEnd()
		} else {
			z.EncWriteMapStart(2)
			if z.EncBasicHandle().Canonical {
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"X\"")
				} else {
					r.EncodeString(`X`)
				}
				z.EncWriteMapElemValue()
				r.EncodeInt(int64(x.X))
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"Y\"")
				} else {
					r.EncodeString(`Y`)
				}
				z.EncWriteMapElemValue()
				r.EncodeString(string(x.Y))
			} else {
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"X\"")
				} else {
					r.EncodeString(`X`)
				}
				z.EncWriteMapElemValue()
				r.EncodeInt(int64(x.X))
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"Y\"")
				} else {
					r.EncodeString(`Y`)
				}
				z.EncWriteMapElemValue()
				r.EncodeString(string(x.Y))
			}
			z.EncWriteMapEnd()
		}
	}
}

func (x *codecgenK) CodecDecodeSelf(d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelper().Decoder(d)
	_, _, _ = h, z, r
	yyct2 := r.ContainerType()
	if yyct2 == codecSelferValueTypeNil19780 {
		*(x) = codecgenK{}
	} else if yyct2 == codecSelferValueTypeMap19780 {
		yyl2 := z.DecReadMapStart()
		if yyl2 == 0 {
		} else {
			x.codecDecodeSelfFromMap(yyl2, d)
		}
		z.DecReadMapEnd()
	} else if yyct2 == codecSelferValueTypeArray19780 {
		yyl2 := z.DecReadArrayStart()
		if yyl2 != 0 {
			x.codecDecodeSelfFromArray(yyl2, d)
		}
		z.DecReadArrayEnd()
	} else {
		panic(errCodecSelferOnlyMapOrArrayEncodeToStruct19780)
	}
}

func (x *codecgenK) codecDecodeSelfFromMap(l int, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelper().Decoder(d)
	_, _, _ = h, z, r
	var yyhl3 bool = l >= 0
	for yyj3 := 0; z.DecContainerNext(yyj3, l, yyhl3); yyj3++ {
		z.DecReadMapElemKey()
		yys3 := r.DecodeStringAsBytes()
		z.DecReadMapElemValue()
		switch string(yys3) {
		case "X":
			x.X = (int)(z.C.IntV(r.DecodeInt64(), codecSelferBitsize19780))
		case "Y":
			x.Y = (string)(z.DecStringZC(r.DecodeStringAsBytes()))
		default:
			z.DecStructFieldNotFound(-1, string(yys3))
		} // end switch yys3
	} // end for yyj3
}

func (x *codecgenK) codecDecodeSelfFromArray(l int, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelper().Decoder(d)
	_, _, _ = h, z, r
	var yyj6 int
	var yyb6 bool
	var yyhl6 bool = l >= 0
	yyb6 = !z.DecContainerNext(yyj6, l, yyhl6)
	if yyb6 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.X = (int)(z.C.IntV(r.DecodeInt64(), codecSelferBitsize19780))
	yyj6++
	yyb6 = !z.DecContainerNext(yyj6, l, yyhl6)
	if yyb6 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.Y = (string)(z.DecStringZC(r.DecodeStringAsBytes()))
	yyj6++
	for ; z.DecContainerNext(yyj6, l, yyhl6); yyj6++ {
		z.DecReadArrayElem()
		z.DecStructFieldNotFound(yyj6-1, "")
	}
}

func (x *codecgenK) IsCodecEmpty() bool {
	return !(x.X != 0 || x.Y != "" || false)
}

func (codecgenL) codecSelferViaCodecgen() {}
func (x *codecgenL) CodecEncodeSelf(e *Encoder) {
	var h codecSelfer19780
	z, r := GenHelper().Encoder(e)
	_, _, _ = h, z, r
	if z.EncBasicHandle().CheckCircularRef {
		z.EncEncode(x)
		return
	}
	if x == nil {
		r.EncodeNil()
	} else {
		yy2arr2 := z.EncBasicHandle().StructToArray
		_ = yy2arr2
		const yyr2 bool = false // struct tag has 'toArray'
		if yyr2 || yy2arr2 {
			z.EncWriteArrayStart(2)
			z.EncWriteArrayElem()
			r.EncodeInt(int64(x.X))
			z.EncWriteArrayElem()
			r.EncodeUint(uint64(x.Y))
			z.EncWriteArrayEnd()
		} else {
			z.EncWriteMapStart(2)
			if z.EncBasicHandle().Canonical {
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"X\"")
				} else {
					r.EncodeString(`X`)
				}
				z.EncWriteMapElemValue()
				r.EncodeInt(int64(x.X))
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"Y\"")
				} else {
					r.EncodeString(`Y`)
				}
				z.EncWriteMapElemValue()
				r.EncodeUint(uint64(x.Y))
			} else {
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"X\"")
				} else {
					r.EncodeString(`X`)
				}
				z.EncWriteMapElemValue()
				r.EncodeInt(int64(x.X))
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"Y\"")
				} else {
					r.EncodeString(`Y`)
				}
				z.EncWriteMapElemValue()
				r.EncodeUint(uint64(x.Y))
			}
			z.EncWriteMapEnd()
		}
	}
}

func (x *codecgenL) CodecDecodeSelf(d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelper().Decoder(d)
	_, _, _ = h, z, r
	yyct2 := r.ContainerType()
	if yyct2 == codecSelferValueTypeNil19780 {
		*(x) = codecgenL{}
	} else if yyct2 == codecSelferValueTypeMap19780 {
		yyl2 := z.DecReadMapStart()
		if yyl2 == 0 {
		} else {
			x.codecDecodeSelfFromMap(yyl2, d)
		}
		z.DecReadMapEnd()
	} else if yyct2 == codecSelferValueTypeArray19780 {
		yyl2 := z.DecReadArrayStart()
		if yyl2 != 0 {
			x.codecDecodeSelfFromArray(yyl2, d)
		}
		z.DecReadArrayEnd()
	} else {
		panic(errCodecSelferOnlyMapOrArrayEncodeToStruct19780)
	}
}

func (x *codecgenL) codecDecodeSelfFromMap(l int, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelper().Decoder(d)
	_, _, _ = h, z, r
	var yyhl3 bool = l >= 0
	for yyj3 := 0; z.DecContainerNext(yyj3, l, yyhl3); yyj3++ {
		z.DecReadMapElemKey()
		yys3 := r.DecodeStringAsBytes()
		z.DecReadMapElemValue()
		switch string(yys3) {
		case "X":
			x.X = (int)(z.C.IntV(r.DecodeInt64(), codecSelferBitsize19780))
		case "Y":
			x.Y = (uint32)(z.C.UintV(r.DecodeUint64(), 32))
		default:
			z.DecStructFieldNotFound(-1, string(yys3))
		} // end switch yys3
	} // end for yyj3
}

func (x *codecgenL) codecDecodeSelfFromArray(l int, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelper().Decoder(d)
	_, _, _ = h, z, r
	var yyj6 int
	var yyb6 bool
	var yyhl6 bool = l >= 0
	yyb6 = !z.DecContainerNext(yyj6, l, yyhl6)
	if yyb6 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.X = (int)(z.C.IntV(r.DecodeInt64(), codecSelferBitsize19780))
	yyj6++
	yyb6 = !z.DecContainerNext(yyj6, l, yyhl6)
	if yyb6 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.Y = (uint32)(z.C.UintV(r.DecodeUint64(), 32))
	yyj6++
	for ; z.DecContainerNext(yyj6, l, yyhl6); yyj6++ {
		z.DecReadArrayElem()
		z.DecStructFieldNotFound(yyj6-1, "")
	}
}

func (x *codecgenL) IsCodecEmpty() bool {
	return !(x.X != 0 || x.Y != 0 || false)
}

func (codecgenM) codecSelferViaCodecgen() {}
func (x *codecgenM) CodecEncodeSelf(e *Encoder) {
	var h codecSelfer19780
	z, r := GenHelper().Encoder(e)
	_, _, _ = h, z, r
	if z.EncBasicHandle().CheckCircularRef {
		z.EncEncode(x)
		return
	}
	if x == nil {
		r.EncodeNil()
	} else {
		yy2arr2 := z.EncBasicHandle().StructToArray
		_ = yy2arr2
		const yyr2 bool = false // struct tag has 'toArray'
		if yyr2 || yy2arr2 {
			z.EncWriteArrayStart(2)
			z.EncWriteArrayElem()
			r.EncodeInt(int64(x.codecgenK.X))
			z.EncWriteArrayElem()
			r.EncodeString(string(x.codecgenK.Y))
			z.EncWriteArrayEnd()
		} else {
			z.EncWriteMapStart(2)
			if z.EncBasicHandle().Canonical {
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"X\"")
				} else {
					r.EncodeString(`X`)
				}
				z.EncWriteMapElemValue()
				r.EncodeInt(int64(x.codecgenK.X))
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"Y\"")
				} else {
					r.EncodeString(`Y`)
				}
				z.EncWriteMapElemValue()
				r.EncodeString(string(x.codecgenK.Y))
			} else {
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"X\"")
				} else {
					r.EncodeString(`X`)
				}
				z.EncWriteMapElemValue()
				r.EncodeInt(int64(x.codecgenK.X))
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"Y\"")
				} else {
					r.EncodeString(`Y`)
				}
				z.EncWriteMapElemValue()
				r.EncodeString(string(x.codecgenK.Y))
			}
			z.EncWriteMapEnd()
		}
	}
}

func (x *codecgenM) CodecDecodeSelf(d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelper().Decoder(d)
	_, _, _ = h, z, r
	yyct2 := r.ContainerType()
	if yyct2 == codecSelferValueTypeNil19780 {
		*(x) = codecgenM{}
	} else if yyct2 == codecSelferValueTypeMap19780 {
		yyl2 := z.DecReadMapStart()
		if yyl2 == 0 {
		} else {
			x.codecDecodeSelfFromMap(yyl2, d)
		}
		z.DecReadMapEnd()
	} else if yyct2 == codecSelferValueTypeArray19780 {
		yyl2 := z.DecReadArrayStart()
		if yyl2 != 0 {
			x.codecDecodeSelfFromArray(yyl2, d)
		}
		z.DecReadArrayEnd()
	} else {
		panic(errCodecSelferOnlyMapOrArrayEncodeToStruct19780)
	}
}

func (x *codecgenM) codecDecodeSelfFromMap(l int, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelper().Decoder(d)
	_, _, _ = h, z, r
	var yyhl3 bool = l >= 0
	for yyj3 := 0; z.DecContainerNext(yyj3, l, yyhl3); yyj3++ {
		z.DecReadMapElemKey()
		yys3 := r.DecodeStringAsBytes()
		z.DecReadMapElemValue()
		switch string(yys3) {
		case "X":
			x.codecgenK.X = (int)(z.C.IntV(r.DecodeInt64(), codecSelferBitsize19780))
		case "Y":
			x.codecgenK.Y = (string)(z.DecStringZC(r.DecodeStringAsBytes()))
		default:
			z.DecStructFieldNotFound(-1, string(yys3))
		} // end switch yys3
	} // end for yyj3
}

func (x *codecgenM) codecDecodeSelfFromArray(l int, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelper().Decoder(d)
	_, _, _ = h, z, r
	var yyj6 int
	var yyb6 bool
	var yyhl6 bool = l >= 0
	yyb6 = !z.DecContainerNext(yyj6, l, yyhl6)
	if yyb6 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.codecgenK.X = (int)(z.C.IntV(r.DecodeInt64(), codecSelferBitsize19780))
	yyj6++
	yyb6 = !z.DecContainerNext(yyj6, l, yyhl6)
	if yyb6 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.codecgenK.Y = (string)(z.DecStringZC(r.DecodeStringAsBytes()))
	yyj6++
	for ; z.DecContainerNext(yyj6, l, yyhl6); yyj6++ {
		z.DecReadArrayElem()
		z.DecStructFieldNotFound(yyj6-1, "")
	}
}

func (x *codecgenM) IsCodecEmpty() bool {
	return !(!(x.codecgenK.IsCodecEmpty()) || false)
}

func (testStrucKeyTypeT0) codecSelferViaCodecgen() {}
func (x *testStrucKeyTypeT0) CodecEncodeSelf(e *Encoder) {
	var h codecSelfer19780
	z, r := GenHelper().Encoder(e)
	_, _, _ = h, z, r
	if z.EncBasicHandle().CheckCircularRef {
		z.EncEncode(x)
		return
	}
	if x == nil {
		r.EncodeNil()
	} else {
		yy2arr2 := z.EncBasicHandle().StructToArray
		_ = yy2arr2
		const yyr2 bool = false // struct tag has 'toArray'
		if yyr2 || yy2arr2 {
			z.EncWriteArrayStart(1)
			z.EncWriteArrayElem()
			r.EncodeInt(int64(x.F))
			z.EncWriteArrayEnd()
		} else {
			z.EncWriteMapStart(1)
			if z.EncBasicHandle().Canonical {
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"F\"")
				} else {
					r.EncodeString(`F`)
				}
				z.EncWriteMapElemValue()
				r.EncodeInt(int64(x.F))
			} else {
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"F\"")
				} else {
					r.EncodeString(`F`)
				}
				z.EncWriteMapElemValue()
				r.EncodeInt(int64(x.F))
			}
			z.EncWriteMapEnd()
		}
	}
}

func (x *testStrucKeyTypeT0) CodecDecodeSelf(d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelper().Decoder(d)
	_, _, _ = h, z, r
	yyct2 := r.ContainerType()
	if yyct2 == codecSelferValueTypeNil19780 {
		*(x) = testStrucKeyTypeT0{}
	} else if yyct2 == codecSelferValueTypeMap19780 {
		yyl2 := z.DecReadMapStart()
		if yyl2 == 0 {
		} else {
			x.codecDecodeSelfFromMap(yyl2, d)
		}
		z.DecReadMapEnd()
	} else if yyct2 == codecSelferValueTypeArray19780 {
		yyl2 := z.DecReadArrayStart()
		if yyl2 != 0 {
			x.codecDecodeSelfFromArray(yyl2, d)
		}
		z.DecReadArrayEnd()
	} else {
		panic(errCodecSelferOnlyMapOrArrayEncodeToStruct19780)
	}
}

func (x *testStrucKeyTypeT0) codecDecodeSelfFromMap(l int, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelper().Decoder(d)
	_, _, _ = h, z, r
	var yyhl3 bool = l >= 0
	for yyj3 := 0; z.DecContainerNext(yyj3, l, yyhl3); yyj3++ {
		z.DecReadMapElemKey()
		yys3 := r.DecodeStringAsBytes()
		z.DecReadMapElemValue()
		switch string(yys3) {
		case "F":
			x.F = (int)(z.C.IntV(r.DecodeInt64(), codecSelferBitsize19780))
		default:
			z.DecStructFieldNotFound(-1, string(yys3))
		} // end switch yys3
	} // end for yyj3
}

func (x *testStrucKeyTypeT0) codecDecodeSelfFromArray(l int, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelper().Decoder(d)
	_, _, _ = h, z, r
	var yyj5 int
	var yyb5 bool
	var yyhl5 bool = l >= 0
	yyb5 = !z.DecContainerNext(yyj5, l, yyhl5)
	if yyb5 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.F = (int)(z.C.IntV(r.DecodeInt64(), codecSelferBitsize19780))
	yyj5++
	for ; z.DecContainerNext(yyj5, l, yyhl5); yyj5++ {
		z.DecReadArrayElem()
		z.DecStructFieldNotFound(yyj5-1, "")
	}
}

func (x *testStrucKeyTypeT0) IsCodecEmpty() bool {
	return !(x.F != 0 || false)
}

func (testStrucKeyTypeT1) codecSelferViaCodecgen() {}
func (x *testStrucKeyTypeT1) CodecEncodeSelf(e *Encoder) {
	var h codecSelfer19780
	z, r := GenHelper().Encoder(e)
	_, _, _ = h, z, r
	if z.EncBasicHandle().CheckCircularRef {
		z.EncEncode(x)
		return
	}
	if x == nil {
		r.EncodeNil()
	} else {
		yy2arr2 := z.EncBasicHandle().StructToArray
		_ = yy2arr2
		const yyr2 bool = false // struct tag has 'toArray'
		if yyr2 || yy2arr2 {
			z.EncWriteArrayStart(1)
			z.EncWriteArrayElem()
			r.EncodeInt(int64(x.F))
			z.EncWriteArrayEnd()
		} else {
			z.EncWriteMapStart(1)
			if z.EncBasicHandle().Canonical {
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"FFFF\"")
				} else {
					r.EncodeString(`FFFF`)
				}
				z.EncWriteMapElemValue()
				r.EncodeInt(int64(x.F))
			} else {
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"FFFF\"")
				} else {
					r.EncodeString(`FFFF`)
				}
				z.EncWriteMapElemValue()
				r.EncodeInt(int64(x.F))
			}
			z.EncWriteMapEnd()
		}
	}
}

func (x *testStrucKeyTypeT1) CodecDecodeSelf(d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelper().Decoder(d)
	_, _, _ = h, z, r
	yyct2 := r.ContainerType()
	if yyct2 == codecSelferValueTypeNil19780 {
		*(x) = testStrucKeyTypeT1{}
	} else if yyct2 == codecSelferValueTypeMap19780 {
		yyl2 := z.DecReadMapStart()
		if yyl2 == 0 {
		} else {
			x.codecDecodeSelfFromMap(yyl2, d)
		}
		z.DecReadMapEnd()
	} else if yyct2 == codecSelferValueTypeArray19780 {
		yyl2 := z.DecReadArrayStart()
		if yyl2 != 0 {
			x.codecDecodeSelfFromArray(yyl2, d)
		}
		z.DecReadArrayEnd()
	} else {
		panic(errCodecSelferOnlyMapOrArrayEncodeToStruct19780)
	}
}

func (x *testStrucKeyTypeT1) codecDecodeSelfFromMap(l int, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelper().Decoder(d)
	_, _, _ = h, z, r
	var yyhl3 bool = l >= 0
	for yyj3 := 0; z.DecContainerNext(yyj3, l, yyhl3); yyj3++ {
		z.DecReadMapElemKey()
		yys3 := r.DecodeStringAsBytes()
		z.DecReadMapElemValue()
		switch string(yys3) {
		case "FFFF":
			x.F = (int)(z.C.IntV(r.DecodeInt64(), codecSelferBitsize19780))
		default:
			z.DecStructFieldNotFound(-1, string(yys3))
		} // end switch yys3
	} // end for yyj3
}

func (x *testStrucKeyTypeT1) codecDecodeSelfFromArray(l int, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelper().Decoder(d)
	_, _, _ = h, z, r
	var yyj5 int
	var yyb5 bool
	var yyhl5 bool = l >= 0
	yyb5 = !z.DecContainerNext(yyj5, l, yyhl5)
	if yyb5 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.F = (int)(z.C.IntV(r.DecodeInt64(), codecSelferBitsize19780))
	yyj5++
	for ; z.DecContainerNext(yyj5, l, yyhl5); yyj5++ {
		z.DecReadArrayElem()
		z.DecStructFieldNotFound(yyj5-1, "")
	}
}

func (x *testStrucKeyTypeT1) IsCodecEmpty() bool {
	return !(x.F != 0 || false)
}

func (testStrucKeyTypeT2) codecSelferViaCodecgen() {}
func (x *testStrucKeyTypeT2) CodecEncodeSelf(e *Encoder) {
	var h codecSelfer19780
	z, r := GenHelper().Encoder(e)
	_, _, _ = h, z, r
	if z.EncBasicHandle().CheckCircularRef {
		z.EncEncode(x)
		return
	}
	if x == nil {
		r.EncodeNil()
	} else {
		yy2arr2 := z.EncBasicHandle().StructToArray
		_ = yy2arr2
		const yyr2 bool = false // struct tag has 'toArray'
		if yyr2 || yy2arr2 {
			z.EncWriteArrayStart(1)
			z.EncWriteArrayElem()
			r.EncodeInt(int64(x.F))
			z.EncWriteArrayEnd()
		} else {
			z.EncWriteMapStart(1)
			if z.EncBasicHandle().Canonical {
				z.EncWriteMapElemKey()
				r.EncodeInt(z.M.Int(strconv.ParseInt(`-1`, 10, 64)))
				z.EncWriteMapElemValue()
				r.EncodeInt(int64(x.F))
			} else {
				z.EncWriteMapElemKey()
				r.EncodeInt(z.M.Int(strconv.ParseInt(`-1`, 10, 64)))
				z.EncWriteMapElemValue()
				r.EncodeInt(int64(x.F))
			}
			z.EncWriteMapEnd()
		}
	}
}

func (x *testStrucKeyTypeT2) CodecDecodeSelf(d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelper().Decoder(d)
	_, _, _ = h, z, r
	yyct2 := r.ContainerType()
	if yyct2 == codecSelferValueTypeNil19780 {
		*(x) = testStrucKeyTypeT2{}
	} else if yyct2 == codecSelferValueTypeMap19780 {
		yyl2 := z.DecReadMapStart()
		if yyl2 == 0 {
		} else {
			x.codecDecodeSelfFromMap(yyl2, d)
		}
		z.DecReadMapEnd()
	} else if yyct2 == codecSelferValueTypeArray19780 {
		yyl2 := z.DecReadArrayStart()
		if yyl2 != 0 {
			x.codecDecodeSelfFromArray(yyl2, d)
		}
		z.DecReadArrayEnd()
	} else {
		panic(errCodecSelferOnlyMapOrArrayEncodeToStruct19780)
	}
}

func (x *testStrucKeyTypeT2) codecDecodeSelfFromMap(l int, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelper().Decoder(d)
	_, _, _ = h, z, r
	var yyhl3 bool = l >= 0
	for yyj3 := 0; z.DecContainerNext(yyj3, l, yyhl3); yyj3++ {
		z.DecReadMapElemKey()
		yys3 := strconv.AppendInt(z.DecScratchArrayBuffer()[:0], r.DecodeInt64(), 10)
		z.DecReadMapElemValue()
		switch string(yys3) {
		case "-1":
			x.F = (int)(z.C.IntV(r.DecodeInt64(), codecSelferBitsize19780))
		default:
			z.DecStructFieldNotFound(-1, string(yys3))
		} // end switch yys3
	} // end for yyj3
}

func (x *testStrucKeyTypeT2) codecDecodeSelfFromArray(l int, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelper().Decoder(d)
	_, _, _ = h, z, r
	var yyj5 int
	var yyb5 bool
	var yyhl5 bool = l >= 0
	yyb5 = !z.DecContainerNext(yyj5, l, yyhl5)
	if yyb5 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.F = (int)(z.C.IntV(r.DecodeInt64(), codecSelferBitsize19780))
	yyj5++
	for ; z.DecContainerNext(yyj5, l, yyhl5); yyj5++ {
		z.DecReadArrayElem()
		z.DecStructFieldNotFound(yyj5-1, "")
	}
}

func (x *testStrucKeyTypeT2) IsCodecEmpty() bool {
	return !(x.F != 0 || false)
}

func (testStrucKeyTypeT3) codecSelferViaCodecgen() {}
func (x *testStrucKeyTypeT3) CodecEncodeSelf(e *Encoder) {
	var h codecSelfer19780
	z, r := GenHelper().Encoder(e)
	_, _, _ = h, z, r
	if z.EncBasicHandle().CheckCircularRef {
		z.EncEncode(x)
		return
	}
	if x == nil {
		r.EncodeNil()
	} else {
		yy2arr2 := z.EncBasicHandle().StructToArray
		_ = yy2arr2
		const yyr2 bool = false // struct tag has 'toArray'
		if yyr2 || yy2arr2 {
			z.EncWriteArrayStart(1)
			z.EncWriteArrayElem()
			r.EncodeInt(int64(x.F))
			z.EncWriteArrayEnd()
		} else {
			z.EncWriteMapStart(1)
			if z.EncBasicHandle().Canonical {
				z.EncWriteMapElemKey()
				r.EncodeUint(z.M.Uint(strconv.ParseUint(`1`, 10, 64)))
				z.EncWriteMapElemValue()
				r.EncodeInt(int64(x.F))
			} else {
				z.EncWriteMapElemKey()
				r.EncodeUint(z.M.Uint(strconv.ParseUint(`1`, 10, 64)))
				z.EncWriteMapElemValue()
				r.EncodeInt(int64(x.F))
			}
			z.EncWriteMapEnd()
		}
	}
}

func (x *testStrucKeyTypeT3) CodecDecodeSelf(d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelper().Decoder(d)
	_, _, _ = h, z, r
	yyct2 := r.ContainerType()
	if yyct2 == codecSelferValueTypeNil19780 {
		*(x) = testStrucKeyTypeT3{}
	} else if yyct2 == codecSelferValueTypeMap19780 {
		yyl2 := z.DecReadMapStart()
		if yyl2 == 0 {
		} else {
			x.codecDecodeSelfFromMap(yyl2, d)
		}
		z.DecReadMapEnd()
	} else if yyct2 == codecSelferValueTypeArray19780 {
		yyl2 := z.DecReadArrayStart()
		if yyl2 != 0 {
			x.codecDecodeSelfFromArray(yyl2, d)
		}
		z.DecReadArrayEnd()
	} else {
		panic(errCodecSelferOnlyMapOrArrayEncodeToStruct19780)
	}
}

func (x *testStrucKeyTypeT3) codecDecodeSelfFromMap(l int, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelper().Decoder(d)
	_, _, _ = h, z, r
	var yyhl3 bool = l >= 0
	for yyj3 := 0; z.DecContainerNext(yyj3, l, yyhl3); yyj3++ {
		z.DecReadMapElemKey()
		yys3 := strconv.AppendUint(z.DecScratchArrayBuffer()[:0], r.DecodeUint64(), 10)
		z.DecReadMapElemValue()
		switch string(yys3) {
		case "1":
			x.F = (int)(z.C.IntV(r.DecodeInt64(), codecSelferBitsize19780))
		default:
			z.DecStructFieldNotFound(-1, string(yys3))
		} // end switch yys3
	} // end for yyj3
}

func (x *testStrucKeyTypeT3) codecDecodeSelfFromArray(l int, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelper().Decoder(d)
	_, _, _ = h, z, r
	var yyj5 int
	var yyb5 bool
	var yyhl5 bool = l >= 0
	yyb5 = !z.DecContainerNext(yyj5, l, yyhl5)
	if yyb5 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.F = (int)(z.C.IntV(r.DecodeInt64(), codecSelferBitsize19780))
	yyj5++
	for ; z.DecContainerNext(yyj5, l, yyhl5); yyj5++ {
		z.DecReadArrayElem()
		z.DecStructFieldNotFound(yyj5-1, "")
	}
}

func (x *testStrucKeyTypeT3) IsCodecEmpty() bool {
	return !(x.F != 0 || false)
}

func (testStrucKeyTypeT4) codecSelferViaCodecgen() {}
func (x *testStrucKeyTypeT4) CodecEncodeSelf(e *Encoder) {
	var h codecSelfer19780
	z, r := GenHelper().Encoder(e)
	_, _, _ = h, z, r
	if z.EncBasicHandle().CheckCircularRef {
		z.EncEncode(x)
		return
	}
	if x == nil {
		r.EncodeNil()
	} else {
		yy2arr2 := z.EncBasicHandle().StructToArray
		_ = yy2arr2
		const yyr2 bool = false // struct tag has 'toArray'
		if yyr2 || yy2arr2 {
			z.EncWriteArrayStart(1)
			z.EncWriteArrayElem()
			r.EncodeInt(int64(x.F))
			z.EncWriteArrayEnd()
		} else {
			z.EncWriteMapStart(1)
			if z.EncBasicHandle().Canonical {
				z.EncWriteMapElemKey()
				r.EncodeFloat64(z.M.Float(strconv.ParseFloat(`2.5`, 64)))
				z.EncWriteMapElemValue()
				r.EncodeInt(int64(x.F))
			} else {
				z.EncWriteMapElemKey()
				r.EncodeFloat64(z.M.Float(strconv.ParseFloat(`2.5`, 64)))
				z.EncWriteMapElemValue()
				r.EncodeInt(int64(x.F))
			}
			z.EncWriteMapEnd()
		}
	}
}

func (x *testStrucKeyTypeT4) CodecDecodeSelf(d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelper().Decoder(d)
	_, _, _ = h, z, r
	yyct2 := r.ContainerType()
	if yyct2 == codecSelferValueTypeNil19780 {
		*(x) = testStrucKeyTypeT4{}
	} else if yyct2 == codecSelferValueTypeMap19780 {
		yyl2 := z.DecReadMapStart()
		if yyl2 == 0 {
		} else {
			x.codecDecodeSelfFromMap(yyl2, d)
		}
		z.DecReadMapEnd()
	} else if yyct2 == codecSelferValueTypeArray19780 {
		yyl2 := z.DecReadArrayStart()
		if yyl2 != 0 {
			x.codecDecodeSelfFromArray(yyl2, d)
		}
		z.DecReadArrayEnd()
	} else {
		panic(errCodecSelferOnlyMapOrArrayEncodeToStruct19780)
	}
}

func (x *testStrucKeyTypeT4) codecDecodeSelfFromMap(l int, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelper().Decoder(d)
	_, _, _ = h, z, r
	var yyhl3 bool = l >= 0
	for yyj3 := 0; z.DecContainerNext(yyj3, l, yyhl3); yyj3++ {
		z.DecReadMapElemKey()
		yys3 := strconv.AppendFloat(z.DecScratchArrayBuffer()[:0], r.DecodeFloat64(), 'f', -1, 64)
		z.DecReadMapElemValue()
		switch string(yys3) {
		case "2.5":
			x.F = (int)(z.C.IntV(r.DecodeInt64(), codecSelferBitsize19780))
		default:
			z.DecStructFieldNotFound(-1, string(yys3))
		} // end switch yys3
	} // end for yyj3
}

func (x *testStrucKeyTypeT4) codecDecodeSelfFromArray(l int, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelper().Decoder(d)
	_, _, _ = h, z, r
	var yyj5 int
	var yyb5 bool
	var yyhl5 bool = l >= 0
	yyb5 = !z.DecContainerNext(yyj5, l, yyhl5)
	if yyb5 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.F = (int)(z.C.IntV(r.DecodeInt64(), codecSelferBitsize19780))
	yyj5++
	for ; z.DecContainerNext(yyj5, l, yyhl5); yyj5++ {
		z.DecReadArrayElem()
		z.DecStructFieldNotFound(yyj5-1, "")
	}
}

func (x *testStrucKeyTypeT4) IsCodecEmpty() bool {
	return !(x.F != 0 || false)
}

func (Bbool) codecSelferViaCodecgen() {}
func (x Bbool) CodecEncodeSelf(e *Encoder) {
	var h codecSelfer19780
	z, r := GenHelper().Encoder(e)
	_, _, _ = h, z, r
	r.EncodeBool(bool(x))
}

func (x *Bbool) CodecDecodeSelf(d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelper().Decoder(d)
	_, _, _ = h, z, r
	*x = (Bbool)(r.DecodeBool())
}

func (Aarray) codecSelferViaCodecgen() {}
func (x *Aarray) CodecEncodeSelf(e *Encoder) {
	var h codecSelfer19780
	z, r := GenHelper().Encoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		z.F.EncSliceStringV(([]string)(x[:]), e)
	}
}

func (x *Aarray) CodecDecodeSelf(d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelper().Decoder(d)
	_, _, _ = h, z, r
	z.F.DecSliceStringN(([]string)(x[:]), d)
}

func (Sstring) codecSelferViaCodecgen() {}
func (x Sstring) CodecEncodeSelf(e *Encoder) {
	var h codecSelfer19780
	z, r := GenHelper().Encoder(e)
	_, _, _ = h, z, r
	r.EncodeString(string(x))
}

func (x *Sstring) CodecDecodeSelf(d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelper().Decoder(d)
	_, _, _ = h, z, r
	*x = (Sstring)(z.DecStringZC(r.DecodeStringAsBytes()))
}

func (Sstructsmall) codecSelferViaCodecgen() {}
func (x *Sstructsmall) CodecEncodeSelf(e *Encoder) {
	var h codecSelfer19780
	z, r := GenHelper().Encoder(e)
	_, _, _ = h, z, r
	if z.EncBasicHandle().CheckCircularRef {
		z.EncEncode(x)
		return
	}
	if x == nil {
		r.EncodeNil()
	} else {
		yy2arr2 := z.EncBasicHandle().StructToArray
		_ = yy2arr2
		const yyr2 bool = false // struct tag has 'toArray'
		if yyr2 || yy2arr2 {
			z.EncWriteArrayStart(1)
			z.EncWriteArrayElem()
			r.EncodeInt(int64(x.A))
			z.EncWriteArrayEnd()
		} else {
			z.EncWriteMapStart(1)
			if z.EncBasicHandle().Canonical {
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"A\"")
				} else {
					r.EncodeString(`A`)
				}
				z.EncWriteMapElemValue()
				r.EncodeInt(int64(x.A))
			} else {
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"A\"")
				} else {
					r.EncodeString(`A`)
				}
				z.EncWriteMapElemValue()
				r.EncodeInt(int64(x.A))
			}
			z.EncWriteMapEnd()
		}
	}
}

func (x *Sstructsmall) CodecDecodeSelf(d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelper().Decoder(d)
	_, _, _ = h, z, r
	yyct2 := r.ContainerType()
	if yyct2 == codecSelferValueTypeNil19780 {
		*(x) = Sstructsmall{}
	} else if yyct2 == codecSelferValueTypeMap19780 {
		yyl2 := z.DecReadMapStart()
		if yyl2 == 0 {
		} else {
			x.codecDecodeSelfFromMap(yyl2, d)
		}
		z.DecReadMapEnd()
	} else if yyct2 == codecSelferValueTypeArray19780 {
		yyl2 := z.DecReadArrayStart()
		if yyl2 != 0 {
			x.codecDecodeSelfFromArray(yyl2, d)
		}
		z.DecReadArrayEnd()
	} else {
		panic(errCodecSelferOnlyMapOrArrayEncodeToStruct19780)
	}
}

func (x *Sstructsmall) codecDecodeSelfFromMap(l int, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelper().Decoder(d)
	_, _, _ = h, z, r
	var yyhl3 bool = l >= 0
	for yyj3 := 0; z.DecContainerNext(yyj3, l, yyhl3); yyj3++ {
		z.DecReadMapElemKey()
		yys3 := r.DecodeStringAsBytes()
		z.DecReadMapElemValue()
		switch string(yys3) {
		case "A":
			x.A = (int)(z.C.IntV(r.DecodeInt64(), codecSelferBitsize19780))
		default:
			z.DecStructFieldNotFound(-1, string(yys3))
		} // end switch yys3
	} // end for yyj3
}

func (x *Sstructsmall) codecDecodeSelfFromArray(l int, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelper().Decoder(d)
	_, _, _ = h, z, r
	var yyj5 int
	var yyb5 bool
	var yyhl5 bool = l >= 0
	yyb5 = !z.DecContainerNext(yyj5, l, yyhl5)
	if yyb5 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.A = (int)(z.C.IntV(r.DecodeInt64(), codecSelferBitsize19780))
	yyj5++
	for ; z.DecContainerNext(yyj5, l, yyhl5); yyj5++ {
		z.DecReadArrayElem()
		z.DecStructFieldNotFound(yyj5-1, "")
	}
}

func (x *Sstructsmall) IsCodecEmpty() bool {
	return !(x.A != 0 || false)
}

func (Sstructbig) codecSelferViaCodecgen() {}
func (x *Sstructbig) CodecEncodeSelf(e *Encoder) {
	var h codecSelfer19780
	z, r := GenHelper().Encoder(e)
	_, _, _ = h, z, r
	if z.EncBasicHandle().CheckCircularRef {
		z.EncEncode(x)
		return
	}
	if x == nil {
		r.EncodeNil()
	} else {
		yy2arr2 := z.EncBasicHandle().StructToArray
		_ = yy2arr2
		const yyr2 bool = false // struct tag has 'toArray'
		var yyn5 bool = x.Ssmallptr == nil
		var yyn7 bool = x.Sptr == nil
		if yyr2 || yy2arr2 {
			z.EncWriteArrayStart(5)
			z.EncWriteArrayElem()
			r.EncodeInt(int64(x.A))
			z.EncWriteArrayElem()
			r.EncodeBool(bool(x.B))
			if yyn5 {
				z.EncWriteArrayElem()
				r.EncodeNil()
			} else {
				z.EncWriteArrayElem()
				if yyxt10 := z.Extension(x.Ssmallptr); yyxt10 != nil {
					z.EncExtension(x.Ssmallptr, yyxt10)
				} else {
					x.Ssmallptr.CodecEncodeSelf(e)
				}
			}
			z.EncWriteArrayElem()
			yy11 := &x.Ssmall
			if yyxt12 := z.Extension(yy11); yyxt12 != nil {
				z.EncExtension(yy11, yyxt12)
			} else {
				yy11.CodecEncodeSelf(e)
			}
			if yyn7 {
				z.EncWriteArrayElem()
				r.EncodeNil()
			} else {
				z.EncWriteArrayElem()
				if yyxt13 := z.Extension(x.Sptr); yyxt13 != nil {
					z.EncExtension(x.Sptr, yyxt13)
				} else {
					x.Sptr.CodecEncodeSelf(e)
				}
			}
			z.EncWriteArrayEnd()
		} else {
			z.EncWriteMapStart(5)
			if z.EncBasicHandle().Canonical {
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"A\"")
				} else {
					r.EncodeString(`A`)
				}
				z.EncWriteMapElemValue()
				r.EncodeInt(int64(x.A))
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"B\"")
				} else {
					r.EncodeString(`B`)
				}
				z.EncWriteMapElemValue()
				r.EncodeBool(bool(x.B))
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"Sptr\"")
				} else {
					r.EncodeString(`Sptr`)
				}
				z.EncWriteMapElemValue()
				if yyn7 {
					r.EncodeNil()
				} else {
					if yyxt16 := z.Extension(x.Sptr); yyxt16 != nil {
						z.EncExtension(x.Sptr, yyxt16)
					} else {
						x.Sptr.CodecEncodeSelf(e)
					}
				}
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"Ssmall\"")
				} else {
					r.EncodeString(`Ssmall`)
				}
				z.EncWriteMapElemValue()
				yy17 := &x.Ssmall
				if yyxt18 := z.Extension(yy17); yyxt18 != nil {
					z.EncExtension(yy17, yyxt18)
				} else {
					yy17.CodecEncodeSelf(e)
				}
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"Ssmallptr\"")
				} else {
					r.EncodeString(`Ssmallptr`)
				}
				z.EncWriteMapElemValue()
				if yyn5 {
					r.EncodeNil()
				} else {
					if yyxt19 := z.Extension(x.Ssmallptr); yyxt19 != nil {
						z.EncExtension(x.Ssmallptr, yyxt19)
					} else {
						x.Ssmallptr.CodecEncodeSelf(e)
					}
				}
			} else {
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"A\"")
				} else {
					r.EncodeString(`A`)
				}
				z.EncWriteMapElemValue()
				r.EncodeInt(int64(x.A))
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"B\"")
				} else {
					r.EncodeString(`B`)
				}
				z.EncWriteMapElemValue()
				r.EncodeBool(bool(x.B))
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"Ssmallptr\"")
				} else {
					r.EncodeString(`Ssmallptr`)
				}
				z.EncWriteMapElemValue()
				if yyn5 {
					r.EncodeNil()
				} else {
					if yyxt22 := z.Extension(x.Ssmallptr); yyxt22 != nil {
						z.EncExtension(x.Ssmallptr, yyxt22)
					} else {
						x.Ssmallptr.CodecEncodeSelf(e)
					}
				}
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"Ssmall\"")
				} else {
					r.EncodeString(`Ssmall`)
				}
				z.EncWriteMapElemValue()
				yy23 := &x.Ssmall
				if yyxt24 := z.Extension(yy23); yyxt24 != nil {
					z.EncExtension(yy23, yyxt24)
				} else {
					yy23.CodecEncodeSelf(e)
				}
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"Sptr\"")
				} else {
					r.EncodeString(`Sptr`)
				}
				z.EncWriteMapElemValue()
				if yyn7 {
					r.EncodeNil()
				} else {
					if yyxt25 := z.Extension(x.Sptr); yyxt25 != nil {
						z.EncExtension(x.Sptr, yyxt25)
					} else {
						x.Sptr.CodecEncodeSelf(e)
					}
				}
			}
			z.EncWriteMapEnd()
		}
	}
}

func (x *Sstructbig) CodecDecodeSelf(d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelper().Decoder(d)
	_, _, _ = h, z, r
	yyct2 := r.ContainerType()
	if yyct2 == codecSelferValueTypeNil19780 {
		*(x) = Sstructbig{}
	} else if yyct2 == codecSelferValueTypeMap19780 {
		yyl2 := z.DecReadMapStart()
		if yyl2 == 0 {
		} else {
			x.codecDecodeSelfFromMap(yyl2, d)
		}
		z.DecReadMapEnd()
	} else if yyct2 == codecSelferValueTypeArray19780 {
		yyl2 := z.DecReadArrayStart()
		if yyl2 != 0 {
			x.codecDecodeSelfFromArray(yyl2, d)
		}
		z.DecReadArrayEnd()
	} else {
		panic(errCodecSelferOnlyMapOrArrayEncodeToStruct19780)
	}
}

func (x *Sstructbig) codecDecodeSelfFromMap(l int, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelper().Decoder(d)
	_, _, _ = h, z, r
	var yyhl3 bool = l >= 0
	for yyj3 := 0; z.DecContainerNext(yyj3, l, yyhl3); yyj3++ {
		z.DecReadMapElemKey()
		yys3 := r.DecodeStringAsBytes()
		z.DecReadMapElemValue()
		switch string(yys3) {
		case "A":
			x.A = (int)(z.C.IntV(r.DecodeInt64(), codecSelferBitsize19780))
		case "B":
			x.B = (bool)(r.DecodeBool())
		case "Ssmallptr":
			if r.TryNil() {
				if x.Ssmallptr != nil { // remove the if-true
					x.Ssmallptr = nil
				}
			} else {
				if x.Ssmallptr == nil {
					x.Ssmallptr = new(Sstructsmall)
				}
				if yyxt7 := z.Extension(x.Ssmallptr); yyxt7 != nil {
					z.DecExtension(x.Ssmallptr, yyxt7)
				} else {
					x.Ssmallptr.CodecDecodeSelf(d)
				}
			}
		case "Ssmall":
			if yyxt9 := z.Extension(x.Ssmall); yyxt9 != nil {
				z.DecExtension(&x.Ssmall, yyxt9)
			} else {
				x.Ssmall.CodecDecodeSelf(d)
			}
		case "Sptr":
			if r.TryNil() {
				if x.Sptr != nil { // remove the if-true
					x.Sptr = nil
				}
			} else {
				if x.Sptr == nil {
					x.Sptr = new(Sstructbig)
				}
				if yyxt11 := z.Extension(x.Sptr); yyxt11 != nil {
					z.DecExtension(x.Sptr, yyxt11)
				} else {
					x.Sptr.CodecDecodeSelf(d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, string(yys3))
		} // end switch yys3
	} // end for yyj3
}

func (x *Sstructbig) codecDecodeSelfFromArray(l int, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelper().Decoder(d)
	_, _, _ = h, z, r
	var yyj12 int
	var yyb12 bool
	var yyhl12 bool = l >= 0
	yyb12 = !z.DecContainerNext(yyj12, l, yyhl12)
	if yyb12 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.A = (int)(z.C.IntV(r.DecodeInt64(), codecSelferBitsize19780))
	yyj12++
	yyb12 = !z.DecContainerNext(yyj12, l, yyhl12)
	if yyb12 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.B = (bool)(r.DecodeBool())
	yyj12++
	yyb12 = !z.DecContainerNext(yyj12, l, yyhl12)
	if yyb12 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	if r.TryNil() {
		if x.Ssmallptr != nil { // remove the if-true
			x.Ssmallptr = nil
		}
	} else {
		if x.Ssmallptr == nil {
			x.Ssmallptr = new(Sstructsmall)
		}
		if yyxt16 := z.Extension(x.Ssmallptr); yyxt16 != nil {
			z.DecExtension(x.Ssmallptr, yyxt16)
		} else {
			x.Ssmallptr.CodecDecodeSelf(d)
		}
	}
	yyj12++
	yyb12 = !z.DecContainerNext(yyj12, l, yyhl12)
	if yyb12 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	if yyxt18 := z.Extension(x.Ssmall); yyxt18 != nil {
		z.DecExtension(&x.Ssmall, yyxt18)
	} else {
		x.Ssmall.CodecDecodeSelf(d)
	}
	yyj12++
	yyb12 = !z.DecContainerNext(yyj12, l, yyhl12)
	if yyb12 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	if r.TryNil() {
		if x.Sptr != nil { // remove the if-true
			x.Sptr = nil
		}
	} else {
		if x.Sptr == nil {
			x.Sptr = new(Sstructbig)
		}
		if yyxt20 := z.Extension(x.Sptr); yyxt20 != nil {
			z.DecExtension(x.Sptr, yyxt20)
		} else {
			x.Sptr.CodecDecodeSelf(d)
		}
	}
	yyj12++
	for ; z.DecContainerNext(yyj12, l, yyhl12); yyj12++ {
		z.DecReadArrayElem()
		z.DecStructFieldNotFound(yyj12-1, "")
	}
}

func (x *Sstructbig) IsCodecEmpty() bool {
	return !(x.A != 0 || bool(x.B) || !(x.Ssmall.IsCodecEmpty()) || false)
}

func (SstructbigToArray) codecSelferViaCodecgen() {}
func (x *SstructbigToArray) CodecEncodeSelf(e *Encoder) {
	var h codecSelfer19780
	z, r := GenHelper().Encoder(e)
	_, _, _ = h, z, r
	if z.EncBasicHandle().CheckCircularRef {
		z.EncEncode(x)
		return
	}
	if x == nil {
		r.EncodeNil()
	} else {
		yy2arr2 := z.EncBasicHandle().StructToArray
		_ = yy2arr2
		const yyr2 bool = true // struct tag has 'toArray'
		var yyn5 bool = x.Ssmallptr == nil
		var yyn7 bool = x.Sptr == nil
		if yyr2 || yy2arr2 {
			z.EncWriteArrayStart(5)
			z.EncWriteArrayElem()
			r.EncodeInt(int64(x.A))
			z.EncWriteArrayElem()
			r.EncodeBool(bool(x.B))
			if yyn5 {
				z.EncWriteArrayElem()
				r.EncodeNil()
			} else {
				z.EncWriteArrayElem()
				if yyxt10 := z.Extension(x.Ssmallptr); yyxt10 != nil {
					z.EncExtension(x.Ssmallptr, yyxt10)
				} else {
					x.Ssmallptr.CodecEncodeSelf(e)
				}
			}
			z.EncWriteArrayElem()
			yy11 := &x.Ssmall
			if yyxt12 := z.Extension(yy11); yyxt12 != nil {
				z.EncExtension(yy11, yyxt12)
			} else {
				yy11.CodecEncodeSelf(e)
			}
			if yyn7 {
				z.EncWriteArrayElem()
				r.EncodeNil()
			} else {
				z.EncWriteArrayElem()
				if yyxt13 := z.Extension(x.Sptr); yyxt13 != nil {
					z.EncExtension(x.Sptr, yyxt13)
				} else {
					x.Sptr.CodecEncodeSelf(e)
				}
			}
			z.EncWriteArrayEnd()
		} else {
			z.EncWriteMapStart(5)
			if z.EncBasicHandle().Canonical {
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"A\"")
				} else {
					r.EncodeString(`A`)
				}
				z.EncWriteMapElemValue()
				r.EncodeInt(int64(x.A))
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"B\"")
				} else {
					r.EncodeString(`B`)
				}
				z.EncWriteMapElemValue()
				r.EncodeBool(bool(x.B))
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"Sptr\"")
				} else {
					r.EncodeString(`Sptr`)
				}
				z.EncWriteMapElemValue()
				if yyn7 {
					r.EncodeNil()
				} else {
					if yyxt16 := z.Extension(x.Sptr); yyxt16 != nil {
						z.EncExtension(x.Sptr, yyxt16)
					} else {
						x.Sptr.CodecEncodeSelf(e)
					}
				}
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"Ssmall\"")
				} else {
					r.EncodeString(`Ssmall`)
				}
				z.EncWriteMapElemValue()
				yy17 := &x.Ssmall
				if yyxt18 := z.Extension(yy17); yyxt18 != nil {
					z.EncExtension(yy17, yyxt18)
				} else {
					yy17.CodecEncodeSelf(e)
				}
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"Ssmallptr\"")
				} else {
					r.EncodeString(`Ssmallptr`)
				}
				z.EncWriteMapElemValue()
				if yyn5 {
					r.EncodeNil()
				} else {
					if yyxt19 := z.Extension(x.Ssmallptr); yyxt19 != nil {
						z.EncExtension(x.Ssmallptr, yyxt19)
					} else {
						x.Ssmallptr.CodecEncodeSelf(e)
					}
				}
			} else {
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"A\"")
				} else {
					r.EncodeString(`A`)
				}
				z.EncWriteMapElemValue()
				r.EncodeInt(int64(x.A))
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"B\"")
				} else {
					r.EncodeString(`B`)
				}
				z.EncWriteMapElemValue()
				r.EncodeBool(bool(x.B))
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"Ssmallptr\"")
				} else {
					r.EncodeString(`Ssmallptr`)
				}
				z.EncWriteMapElemValue()
				if yyn5 {
					r.EncodeNil()
				} else {
					if yyxt22 := z.Extension(x.Ssmallptr); yyxt22 != nil {
						z.EncExtension(x.Ssmallptr, yyxt22)
					} else {
						x.Ssmallptr.CodecEncodeSelf(e)
					}
				}
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"Ssmall\"")
				} else {
					r.EncodeString(`Ssmall`)
				}
				z.EncWriteMapElemValue()
				yy23 := &x.Ssmall
				if yyxt24 := z.Extension(yy23); yyxt24 != nil {
					z.EncExtension(yy23, yyxt24)
				} else {
					yy23.CodecEncodeSelf(e)
				}
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"Sptr\"")
				} else {
					r.EncodeString(`Sptr`)
				}
				z.EncWriteMapElemValue()
				if yyn7 {
					r.EncodeNil()
				} else {
					if yyxt25 := z.Extension(x.Sptr); yyxt25 != nil {
						z.EncExtension(x.Sptr, yyxt25)
					} else {
						x.Sptr.CodecEncodeSelf(e)
					}
				}
			}
			z.EncWriteMapEnd()
		}
	}
}

func (x *SstructbigToArray) CodecDecodeSelf(d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelper().Decoder(d)
	_, _, _ = h, z, r
	yyct2 := r.ContainerType()
	if yyct2 == codecSelferValueTypeNil19780 {
		*(x) = SstructbigToArray{}
	} else if yyct2 == codecSelferValueTypeMap19780 {
		yyl2 := z.DecReadMapStart()
		if yyl2 == 0 {
		} else {
			x.codecDecodeSelfFromMap(yyl2, d)
		}
		z.DecReadMapEnd()
	} else if yyct2 == codecSelferValueTypeArray19780 {
		yyl2 := z.DecReadArrayStart()
		if yyl2 != 0 {
			x.codecDecodeSelfFromArray(yyl2, d)
		}
		z.DecReadArrayEnd()
	} else {
		panic(errCodecSelferOnlyMapOrArrayEncodeToStruct19780)
	}
}

func (x *SstructbigToArray) codecDecodeSelfFromMap(l int, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelper().Decoder(d)
	_, _, _ = h, z, r
	var yyhl3 bool = l >= 0
	for yyj3 := 0; z.DecContainerNext(yyj3, l, yyhl3); yyj3++ {
		z.DecReadMapElemKey()
		yys3 := r.DecodeStringAsBytes()
		z.DecReadMapElemValue()
		switch string(yys3) {
		case "A":
			x.A = (int)(z.C.IntV(r.DecodeInt64(), codecSelferBitsize19780))
		case "B":
			x.B = (bool)(r.DecodeBool())
		case "Ssmallptr":
			if r.TryNil() {
				if x.Ssmallptr != nil { // remove the if-true
					x.Ssmallptr = nil
				}
			} else {
				if x.Ssmallptr == nil {
					x.Ssmallptr = new(Sstructsmall)
				}
				if yyxt7 := z.Extension(x.Ssmallptr); yyxt7 != nil {
					z.DecExtension(x.Ssmallptr, yyxt7)
				} else {
					x.Ssmallptr.CodecDecodeSelf(d)
				}
			}
		case "Ssmall":
			if yyxt9 := z.Extension(x.Ssmall); yyxt9 != nil {
				z.DecExtension(&x.Ssmall, yyxt9)
			} else {
				x.Ssmall.CodecDecodeSelf(d)
			}
		case "Sptr":
			if r.TryNil() {
				if x.Sptr != nil { // remove the if-true
					x.Sptr = nil
				}
			} else {
				if x.Sptr == nil {
					x.Sptr = new(Sstructbig)
				}
				if yyxt11 := z.Extension(x.Sptr); yyxt11 != nil {
					z.DecExtension(x.Sptr, yyxt11)
				} else {
					x.Sptr.CodecDecodeSelf(d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, string(yys3))
		} // end switch yys3
	} // end for yyj3
}

func (x *SstructbigToArray) codecDecodeSelfFromArray(l int, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelper().Decoder(d)
	_, _, _ = h, z, r
	var yyj12 int
	var yyb12 bool
	var yyhl12 bool = l >= 0
	yyb12 = !z.DecContainerNext(yyj12, l, yyhl12)
	if yyb12 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.A = (int)(z.C.IntV(r.DecodeInt64(), codecSelferBitsize19780))
	yyj12++
	yyb12 = !z.DecContainerNext(yyj12, l, yyhl12)
	if yyb12 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.B = (bool)(r.DecodeBool())
	yyj12++
	yyb12 = !z.DecContainerNext(yyj12, l, yyhl12)
	if yyb12 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	if r.TryNil() {
		if x.Ssmallptr != nil { // remove the if-true
			x.Ssmallptr = nil
		}
	} else {
		if x.Ssmallptr == nil {
			x.Ssmallptr = new(Sstructsmall)
		}
		if yyxt16 := z.Extension(x.Ssmallptr); yyxt16 != nil {
			z.DecExtension(x.Ssmallptr, yyxt16)
		} else {
			x.Ssmallptr.CodecDecodeSelf(d)
		}
	}
	yyj12++
	yyb12 = !z.DecContainerNext(yyj12, l, yyhl12)
	if yyb12 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	if yyxt18 := z.Extension(x.Ssmall); yyxt18 != nil {
		z.DecExtension(&x.Ssmall, yyxt18)
	} else {
		x.Ssmall.CodecDecodeSelf(d)
	}
	yyj12++
	yyb12 = !z.DecContainerNext(yyj12, l, yyhl12)
	if yyb12 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	if r.TryNil() {
		if x.Sptr != nil { // remove the if-true
			x.Sptr = nil
		}
	} else {
		if x.Sptr == nil {
			x.Sptr = new(Sstructbig)
		}
		if yyxt20 := z.Extension(x.Sptr); yyxt20 != nil {
			z.DecExtension(x.Sptr, yyxt20)
		} else {
			x.Sptr.CodecDecodeSelf(d)
		}
	}
	yyj12++
	for ; z.DecContainerNext(yyj12, l, yyhl12); yyj12++ {
		z.DecReadArrayElem()
		z.DecStructFieldNotFound(yyj12-1, "")
	}
}

func (x *SstructbigToArray) IsCodecEmpty() bool {
	return !(x.A != 0 || bool(x.B) || !(x.Ssmall.IsCodecEmpty()) || false)
}

func (tLowerFirstLetter) codecSelferViaCodecgen() {}
func (x *tLowerFirstLetter) CodecEncodeSelf(e *Encoder) {
	var h codecSelfer19780
	z, r := GenHelper().Encoder(e)
	_, _, _ = h, z, r
	if z.EncBasicHandle().CheckCircularRef {
		z.EncEncode(x)
		return
	}
	if x == nil {
		r.EncodeNil()
	} else {
		yy2arr2 := z.EncBasicHandle().StructToArray
		_ = yy2arr2
		const yyr2 bool = false // struct tag has 'toArray'
		if yyr2 || yy2arr2 {
			z.EncWriteArrayStart(2)
			z.EncWriteArrayElem()
			r.EncodeInt(int64(x.I))
			z.EncWriteArrayElem()
			r.EncodeString(string(x.S))
			z.EncWriteArrayEnd()
		} else {
			z.EncWriteMapStart(2)
			if z.EncBasicHandle().Canonical {
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"I\"")
				} else {
					r.EncodeString(`I`)
				}
				z.EncWriteMapElemValue()
				r.EncodeInt(int64(x.I))
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"S\"")
				} else {
					r.EncodeString(`S`)
				}
				z.EncWriteMapElemValue()
				r.EncodeString(string(x.S))
			} else {
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"I\"")
				} else {
					r.EncodeString(`I`)
				}
				z.EncWriteMapElemValue()
				r.EncodeInt(int64(x.I))
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"S\"")
				} else {
					r.EncodeString(`S`)
				}
				z.EncWriteMapElemValue()
				r.EncodeString(string(x.S))
			}
			z.EncWriteMapEnd()
		}
	}
}

func (x *tLowerFirstLetter) CodecDecodeSelf(d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelper().Decoder(d)
	_, _, _ = h, z, r
	yyct2 := r.ContainerType()
	if yyct2 == codecSelferValueTypeNil19780 {
		*(x) = tLowerFirstLetter{}
	} else if yyct2 == codecSelferValueTypeMap19780 {
		yyl2 := z.DecReadMapStart()
		if yyl2 == 0 {
		} else {
			x.codecDecodeSelfFromMap(yyl2, d)
		}
		z.DecReadMapEnd()
	} else if yyct2 == codecSelferValueTypeArray19780 {
		yyl2 := z.DecReadArrayStart()
		if yyl2 != 0 {
			x.codecDecodeSelfFromArray(yyl2, d)
		}
		z.DecReadArrayEnd()
	} else {
		panic(errCodecSelferOnlyMapOrArrayEncodeToStruct19780)
	}
}

func (x *tLowerFirstLetter) codecDecodeSelfFromMap(l int, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelper().Decoder(d)
	_, _, _ = h, z, r
	var yyhl3 bool = l >= 0
	for yyj3 := 0; z.DecContainerNext(yyj3, l, yyhl3); yyj3++ {
		z.DecReadMapElemKey()
		yys3 := r.DecodeStringAsBytes()
		z.DecReadMapElemValue()
		switch string(yys3) {
		case "I":
			x.I = (int)(z.C.IntV(r.DecodeInt64(), codecSelferBitsize19780))
		case "S":
			x.S = (string)(z.DecStringZC(r.DecodeStringAsBytes()))
		default:
			z.DecStructFieldNotFound(-1, string(yys3))
		} // end switch yys3
	} // end for yyj3
}

func (x *tLowerFirstLetter) codecDecodeSelfFromArray(l int, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelper().Decoder(d)
	_, _, _ = h, z, r
	var yyj6 int
	var yyb6 bool
	var yyhl6 bool = l >= 0
	yyb6 = !z.DecContainerNext(yyj6, l, yyhl6)
	if yyb6 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.I = (int)(z.C.IntV(r.DecodeInt64(), codecSelferBitsize19780))
	yyj6++
	yyb6 = !z.DecContainerNext(yyj6, l, yyhl6)
	if yyb6 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.S = (string)(z.DecStringZC(r.DecodeStringAsBytes()))
	yyj6++
	for ; z.DecContainerNext(yyj6, l, yyhl6); yyj6++ {
		z.DecReadArrayElem()
		z.DecStructFieldNotFound(yyj6-1, "")
	}
}

func (x *tLowerFirstLetter) IsCodecEmpty() bool {
	return !(x.I != 0 || x.S != "" || false)
}

func (wrapInt64) codecSelferViaCodecgen() {}
func (x wrapInt64) CodecEncodeSelf(e *Encoder) {
	var h codecSelfer19780
	z, r := GenHelper().Encoder(e)
	_, _, _ = h, z, r
	r.EncodeInt(int64(x))
}

func (x *wrapInt64) CodecDecodeSelf(d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelper().Decoder(d)
	_, _, _ = h, z, r
	*x = (wrapInt64)(r.DecodeInt64())
}

func (wrapUint8) codecSelferViaCodecgen() {}
func (x wrapUint8) CodecEncodeSelf(e *Encoder) {
	var h codecSelfer19780
	z, r := GenHelper().Encoder(e)
	_, _, _ = h, z, r
	r.EncodeUint(uint64(x))
}

func (x *wrapUint8) CodecDecodeSelf(d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelper().Decoder(d)
	_, _, _ = h, z, r
	*x = (wrapUint8)(z.C.UintV(r.DecodeUint64(), 8))
}

func (wrapBytes) codecSelferViaCodecgen() {}
func (x wrapBytes) CodecEncodeSelf(e *Encoder) {
	var h codecSelfer19780
	z, r := GenHelper().Encoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		z.F.EncSliceUint8V(([]uint8)(x), e)
	} // end block: if x slice == nil
}

func (x *wrapBytes) CodecDecodeSelf(d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelper().Decoder(d)
	_, _, _ = h, z, r
	z.F.DecSliceUint8X((*[]uint8)(x), d)
}

func (testMarshalAsJSON) codecSelferViaCodecgen() {}
func (x testMarshalAsJSON) CodecEncodeSelf(e *Encoder) {
	var h codecSelfer19780
	z, r := GenHelper().Encoder(e)
	_, _, _ = h, z, r
	if !z.EncBinary() && z.IsJSONHandle() {
		z.EncJSONMarshal(x)
	} else {
		r.EncodeBool(bool(x))
	}
}

func (x *testMarshalAsJSON) CodecDecodeSelf(d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelper().Decoder(d)
	_, _, _ = h, z, r
	if !z.DecBinary() && z.IsJSONHandle() {
		z.DecJSONUnmarshal(x)
	} else {
		*x = (testMarshalAsJSON)(r.DecodeBool())
	}
}

func (testMarshalAsBinary) codecSelferViaCodecgen() {}
func (x testMarshalAsBinary) CodecEncodeSelf(e *Encoder) {
	var h codecSelfer19780
	z, r := GenHelper().Encoder(e)
	_, _, _ = h, z, r
	if z.EncBinary() {
		z.EncBinaryMarshal(x)
	} else {
		if x == nil {
			r.EncodeNil()
		} else {
			z.F.EncSliceUint8V(([]uint8)(x), e)
		} // end block: if x slice == nil
	}
}

func (x *testMarshalAsBinary) CodecDecodeSelf(d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelper().Decoder(d)
	_, _, _ = h, z, r
	if z.DecBinary() {
		z.DecBinaryUnmarshal(x)
	} else {
		z.F.DecSliceUint8X((*[]uint8)(x), d)
	}
}

func (testMarshalAsText) codecSelferViaCodecgen() {}
func (x testMarshalAsText) CodecEncodeSelf(e *Encoder) {
	var h codecSelfer19780
	z, r := GenHelper().Encoder(e)
	_, _, _ = h, z, r
	if !z.EncBinary() {
		z.EncTextMarshal(x)
	} else {
		r.EncodeString(string(x))
	}
}

func (x *testMarshalAsText) CodecDecodeSelf(d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelper().Decoder(d)
	_, _, _ = h, z, r
	if !z.DecBinary() {
		z.DecTextUnmarshal(x)
	} else {
		*x = (testMarshalAsText)(z.DecStringZC(r.DecodeStringAsBytes()))
	}
}

func (testUintToBytes) codecSelferViaCodecgen() {}
func (x testUintToBytes) CodecEncodeSelf(e *Encoder) {
	var h codecSelfer19780
	z, r := GenHelper().Encoder(e)
	_, _, _ = h, z, r
	r.EncodeUint(uint64(x))
}

func (x *testUintToBytes) CodecDecodeSelf(d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelper().Decoder(d)
	_, _, _ = h, z, r
	*x = (testUintToBytes)(z.C.UintV(r.DecodeUint64(), 32))
}

func (AnonInTestStrucIntf) codecSelferViaCodecgen() {}
func (x *AnonInTestStrucIntf) CodecEncodeSelf(e *Encoder) {
	var h codecSelfer19780
	z, r := GenHelper().Encoder(e)
	_, _, _ = h, z, r
	if z.EncBasicHandle().CheckCircularRef {
		z.EncEncode(x)
		return
	}
	if x == nil {
		r.EncodeNil()
	} else {
		yy2arr2 := z.EncBasicHandle().StructToArray
		_ = yy2arr2
		const yyr2 bool = false // struct tag has 'toArray'
		var yyn7 bool = x.Tptr == nil
		if yyr2 || yy2arr2 {
			z.EncWriteArrayStart(5)
			z.EncWriteArrayElem()
			if x.Islice == nil {
				r.EncodeNil()
			} else {
				z.F.EncSliceIntfV(x.Islice, e)
			} // end block: if x.Islice slice == nil
			z.EncWriteArrayElem()
			if x.Ms == nil {
				r.EncodeNil()
			} else {
				z.F.EncMapStringIntfV(x.Ms, e)
			} // end block: if x.Ms map == nil
			z.EncWriteArrayElem()
			z.EncFallback(x.Nintf)
			z.EncWriteArrayElem()
			if z.EncBasicHandle().TimeBuiltin() {
				r.EncodeTime(x.T)
			} else if yyxt11 := z.Extension(x.T); yyxt11 != nil {
				z.EncExtension(x.T, yyxt11)
			} else if z.EncBinary() {
				z.EncBinaryMarshal(x.T)
			} else if !z.EncBinary() && z.IsJSONHandle() {
				z.EncJSONMarshal(x.T)
			} else {
				z.EncFallback(x.T)
			}
			if yyn7 {
				z.EncWriteArrayElem()
				r.EncodeNil()
			} else {
				z.EncWriteArrayElem()
				yy12 := *x.Tptr
				if z.EncBasicHandle().TimeBuiltin() {
					r.EncodeTime(yy12)
				} else if yyxt13 := z.Extension(yy12); yyxt13 != nil {
					z.EncExtension(yy12, yyxt13)
				} else if z.EncBinary() {
					z.EncBinaryMarshal(yy12)
				} else if !z.EncBinary() && z.IsJSONHandle() {
					z.EncJSONMarshal(yy12)
				} else {
					z.EncFallback(yy12)
				}
			}
			z.EncWriteArrayEnd()
		} else {
			z.EncWriteMapStart(5)
			if z.EncBasicHandle().Canonical {
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"Islice\"")
				} else {
					r.EncodeString(`Islice`)
				}
				z.EncWriteMapElemValue()
				if x.Islice == nil {
					r.EncodeNil()
				} else {
					z.F.EncSliceIntfV(x.Islice, e)
				} // end block: if x.Islice slice == nil
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"Ms\"")
				} else {
					r.EncodeString(`Ms`)
				}
				z.EncWriteMapElemValue()
				if x.Ms == nil {
					r.EncodeNil()
				} else {
					z.F.EncMapStringIntfV(x.Ms, e)
				} // end block: if x.Ms map == nil
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"Nintf\"")
				} else {
					r.EncodeString(`Nintf`)
				}
				z.EncWriteMapElemValue()
				z.EncFallback(x.Nintf)
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"T\"")
				} else {
					r.EncodeString(`T`)
				}
				z.EncWriteMapElemValue()
				if z.EncBasicHandle().TimeBuiltin() {
					r.EncodeTime(x.T)
				} else if yyxt17 := z.Extension(x.T); yyxt17 != nil {
					z.EncExtension(x.T, yyxt17)
				} else if z.EncBinary() {
					z.EncBinaryMarshal(x.T)
				} else if !z.EncBinary() && z.IsJSONHandle() {
					z.EncJSONMarshal(x.T)
				} else {
					z.EncFallback(x.T)
				}
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"Tptr\"")
				} else {
					r.EncodeString(`Tptr`)
				}
				z.EncWriteMapElemValue()
				if yyn7 {
					r.EncodeNil()
				} else {
					yy18 := *x.Tptr
					if z.EncBasicHandle().TimeBuiltin() {
						r.EncodeTime(yy18)
					} else if yyxt19 := z.Extension(yy18); yyxt19 != nil {
						z.EncExtension(yy18, yyxt19)
					} else if z.EncBinary() {
						z.EncBinaryMarshal(yy18)
					} else if !z.EncBinary() && z.IsJSONHandle() {
						z.EncJSONMarshal(yy18)
					} else {
						z.EncFallback(yy18)
					}
				}
			} else {
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"Islice\"")
				} else {
					r.EncodeString(`Islice`)
				}
				z.EncWriteMapElemValue()
				if x.Islice == nil {
					r.EncodeNil()
				} else {
					z.F.EncSliceIntfV(x.Islice, e)
				} // end block: if x.Islice slice == nil
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"Ms\"")
				} else {
					r.EncodeString(`Ms`)
				}
				z.EncWriteMapElemValue()
				if x.Ms == nil {
					r.EncodeNil()
				} else {
					z.F.EncMapStringIntfV(x.Ms, e)
				} // end block: if x.Ms map == nil
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"Nintf\"")
				} else {
					r.EncodeString(`Nintf`)
				}
				z.EncWriteMapElemValue()
				z.EncFallback(x.Nintf)
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"T\"")
				} else {
					r.EncodeString(`T`)
				}
				z.EncWriteMapElemValue()
				if z.EncBasicHandle().TimeBuiltin() {
					r.EncodeTime(x.T)
				} else if yyxt23 := z.Extension(x.T); yyxt23 != nil {
					z.EncExtension(x.T, yyxt23)
				} else if z.EncBinary() {
					z.EncBinaryMarshal(x.T)
				} else if !z.EncBinary() && z.IsJSONHandle() {
					z.EncJSONMarshal(x.T)
				} else {
					z.EncFallback(x.T)
				}
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"Tptr\"")
				} else {
					r.EncodeString(`Tptr`)
				}
				z.EncWriteMapElemValue()
				if yyn7 {
					r.EncodeNil()
				} else {
					yy24 := *x.Tptr
					if z.EncBasicHandle().TimeBuiltin() {
						r.EncodeTime(yy24)
					} else if yyxt25 := z.Extension(yy24); yyxt25 != nil {
						z.EncExtension(yy24, yyxt25)
					} else if z.EncBinary() {
						z.EncBinaryMarshal(yy24)
					} else if !z.EncBinary() && z.IsJSONHandle() {
						z.EncJSONMarshal(yy24)
					} else {
						z.EncFallback(yy24)
					}
				}
			}
			z.EncWriteMapEnd()
		}
	}
}

func (x *AnonInTestStrucIntf) CodecDecodeSelf(d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelper().Decoder(d)
	_, _, _ = h, z, r
	yyct2 := r.ContainerType()
	if yyct2 == codecSelferValueTypeNil19780 {
		*(x) = AnonInTestStrucIntf{}
	} else if yyct2 == codecSelferValueTypeMap19780 {
		yyl2 := z.DecReadMapStart()
		if yyl2 == 0 {
		} else {
			x.codecDecodeSelfFromMap(yyl2, d)
		}
		z.DecReadMapEnd()
	} else if yyct2 == codecSelferValueTypeArray19780 {
		yyl2 := z.DecReadArrayStart()
		if yyl2 != 0 {
			x.codecDecodeSelfFromArray(yyl2, d)
		}
		z.DecReadArrayEnd()
	} else {
		panic(errCodecSelferOnlyMapOrArrayEncodeToStruct19780)
	}
}

func (x *AnonInTestStrucIntf) codecDecodeSelfFromMap(l int, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelper().Decoder(d)
	_, _, _ = h, z, r
	var yyhl3 bool = l >= 0
	for yyj3 := 0; z.DecContainerNext(yyj3, l, yyhl3); yyj3++ {
		z.DecReadMapElemKey()
		yys3 := r.DecodeStringAsBytes()
		z.DecReadMapElemValue()
		switch string(yys3) {
		case "Islice":
			z.F.DecSliceIntfX(&x.Islice, d)
		case "Ms":
			z.F.DecMapStringIntfX(&x.Ms, d)
		case "Nintf":
			z.DecFallback(&x.Nintf, true)
		case "T":
			if z.DecBasicHandle().TimeBuiltin() {
				x.T = r.DecodeTime()
			} else if yyxt11 := z.Extension(x.T); yyxt11 != nil {
				z.DecExtension(&x.T, yyxt11)
			} else if z.DecBinary() {
				z.DecBinaryUnmarshal(&x.T)
			} else if !z.DecBinary() && z.IsJSONHandle() {
				z.DecJSONUnmarshal(&x.T)
			} else {
				z.DecFallback(&x.T, false)
			}
		case "Tptr":
			if r.TryNil() {
				if x.Tptr != nil { // remove the if-true
					x.Tptr = nil
				}
			} else {
				if x.Tptr == nil {
					x.Tptr = new(time.Time)
				}
				if z.DecBasicHandle().TimeBuiltin() {
					*x.Tptr = r.DecodeTime()
				} else if yyxt13 := z.Extension(x.Tptr); yyxt13 != nil {
					z.DecExtension(x.Tptr, yyxt13)
				} else if z.DecBinary() {
					z.DecBinaryUnmarshal(x.Tptr)
				} else if !z.DecBinary() && z.IsJSONHandle() {
					z.DecJSONUnmarshal(x.Tptr)
				} else {
					z.DecFallback(x.Tptr, false)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, string(yys3))
		} // end switch yys3
	} // end for yyj3
}

func (x *AnonInTestStrucIntf) codecDecodeSelfFromArray(l int, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelper().Decoder(d)
	_, _, _ = h, z, r
	var yyj14 int
	var yyb14 bool
	var yyhl14 bool = l >= 0
	yyb14 = !z.DecContainerNext(yyj14, l, yyhl14)
	if yyb14 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	z.F.DecSliceIntfX(&x.Islice, d)
	yyj14++
	yyb14 = !z.DecContainerNext(yyj14, l, yyhl14)
	if yyb14 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	z.F.DecMapStringIntfX(&x.Ms, d)
	yyj14++
	yyb14 = !z.DecContainerNext(yyj14, l, yyhl14)
	if yyb14 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	z.DecFallback(&x.Nintf, true)
	yyj14++
	yyb14 = !z.DecContainerNext(yyj14, l, yyhl14)
	if yyb14 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	if z.DecBasicHandle().TimeBuiltin() {
		x.T = r.DecodeTime()
	} else if yyxt22 := z.Extension(x.T); yyxt22 != nil {
		z.DecExtension(&x.T, yyxt22)
	} else if z.DecBinary() {
		z.DecBinaryUnmarshal(&x.T)
	} else if !z.DecBinary() && z.IsJSONHandle() {
		z.DecJSONUnmarshal(&x.T)
	} else {
		z.DecFallback(&x.T, false)
	}
	yyj14++
	yyb14 = !z.DecContainerNext(yyj14, l, yyhl14)
	if yyb14 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	if r.TryNil() {
		if x.Tptr != nil { // remove the if-true
			x.Tptr = nil
		}
	} else {
		if x.Tptr == nil {
			x.Tptr = new(time.Time)
		}
		if z.DecBasicHandle().TimeBuiltin() {
			*x.Tptr = r.DecodeTime()
		} else if yyxt24 := z.Extension(x.Tptr); yyxt24 != nil {
			z.DecExtension(x.Tptr, yyxt24)
		} else if z.DecBinary() {
			z.DecBinaryUnmarshal(x.Tptr)
		} else if !z.DecBinary() && z.IsJSONHandle() {
			z.DecJSONUnmarshal(x.Tptr)
		} else {
			z.DecFallback(x.Tptr, false)
		}
	}
	yyj14++
	for ; z.DecContainerNext(yyj14, l, yyhl14); yyj14++ {
		z.DecReadArrayElem()
		z.DecStructFieldNotFound(yyj14-1, "")
	}
}

func (x *AnonInTestStrucIntf) IsCodecEmpty() bool {
	return !(len(x.Islice) != 0 || len(x.Ms) != 0 || x.Nintf != nil || !(x.T.IsZero()) || false)
}

func (missingFielderT2) codecSelferViaCodecgen() {}
func (x *missingFielderT2) CodecEncodeSelf(e *Encoder) {
	var h codecSelfer19780
	z, r := GenHelper().Encoder(e)
	_, _, _ = h, z, r
	if z.EncBasicHandle().CheckCircularRef {
		z.EncEncode(x)
		return
	}
	if x == nil {
		r.EncodeNil()
	} else {
		yy2arr2 := z.EncBasicHandle().StructToArray
		_ = yy2arr2
		const yyr2 bool = false // struct tag has 'toArray'
		if yyr2 || yy2arr2 {
			z.EncWriteArrayStart(4)
			z.EncWriteArrayElem()
			r.EncodeString(string(x.S))
			z.EncWriteArrayElem()
			r.EncodeBool(bool(x.B))
			z.EncWriteArrayElem()
			r.EncodeFloat64(float64(x.F))
			z.EncWriteArrayElem()
			r.EncodeInt(int64(x.I))
			z.EncWriteArrayEnd()
		} else {
			z.EncWriteMapStart(4)
			if z.EncBasicHandle().Canonical {
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"B\"")
				} else {
					r.EncodeString(`B`)
				}
				z.EncWriteMapElemValue()
				r.EncodeBool(bool(x.B))
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"F\"")
				} else {
					r.EncodeString(`F`)
				}
				z.EncWriteMapElemValue()
				r.EncodeFloat64(float64(x.F))
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"I\"")
				} else {
					r.EncodeString(`I`)
				}
				z.EncWriteMapElemValue()
				r.EncodeInt(int64(x.I))
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"S\"")
				} else {
					r.EncodeString(`S`)
				}
				z.EncWriteMapElemValue()
				r.EncodeString(string(x.S))
			} else {
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"S\"")
				} else {
					r.EncodeString(`S`)
				}
				z.EncWriteMapElemValue()
				r.EncodeString(string(x.S))
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"B\"")
				} else {
					r.EncodeString(`B`)
				}
				z.EncWriteMapElemValue()
				r.EncodeBool(bool(x.B))
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"F\"")
				} else {
					r.EncodeString(`F`)
				}
				z.EncWriteMapElemValue()
				r.EncodeFloat64(float64(x.F))
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"I\"")
				} else {
					r.EncodeString(`I`)
				}
				z.EncWriteMapElemValue()
				r.EncodeInt(int64(x.I))
			}
			z.EncWriteMapEnd()
		}
	}
}

func (x *missingFielderT2) CodecDecodeSelf(d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelper().Decoder(d)
	_, _, _ = h, z, r
	yyct2 := r.ContainerType()
	if yyct2 == codecSelferValueTypeNil19780 {
		*(x) = missingFielderT2{}
	} else if yyct2 == codecSelferValueTypeMap19780 {
		yyl2 := z.DecReadMapStart()
		if yyl2 == 0 {
		} else {
			x.codecDecodeSelfFromMap(yyl2, d)
		}
		z.DecReadMapEnd()
	} else if yyct2 == codecSelferValueTypeArray19780 {
		yyl2 := z.DecReadArrayStart()
		if yyl2 != 0 {
			x.codecDecodeSelfFromArray(yyl2, d)
		}
		z.DecReadArrayEnd()
	} else {
		panic(errCodecSelferOnlyMapOrArrayEncodeToStruct19780)
	}
}

func (x *missingFielderT2) codecDecodeSelfFromMap(l int, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelper().Decoder(d)
	_, _, _ = h, z, r
	var yyhl3 bool = l >= 0
	for yyj3 := 0; z.DecContainerNext(yyj3, l, yyhl3); yyj3++ {
		z.DecReadMapElemKey()
		yys3 := r.DecodeStringAsBytes()
		z.DecReadMapElemValue()
		switch string(yys3) {
		case "S":
			x.S = (string)(z.DecStringZC(r.DecodeStringAsBytes()))
		case "B":
			x.B = (bool)(r.DecodeBool())
		case "F":
			x.F = (float64)(r.DecodeFloat64())
		case "I":
			x.I = (int64)(r.DecodeInt64())
		default:
			z.DecStructFieldNotFound(-1, string(yys3))
		} // end switch yys3
	} // end for yyj3
}

func (x *missingFielderT2) codecDecodeSelfFromArray(l int, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelper().Decoder(d)
	_, _, _ = h, z, r
	var yyj8 int
	var yyb8 bool
	var yyhl8 bool = l >= 0
	yyb8 = !z.DecContainerNext(yyj8, l, yyhl8)
	if yyb8 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.S = (string)(z.DecStringZC(r.DecodeStringAsBytes()))
	yyj8++
	yyb8 = !z.DecContainerNext(yyj8, l, yyhl8)
	if yyb8 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.B = (bool)(r.DecodeBool())
	yyj8++
	yyb8 = !z.DecContainerNext(yyj8, l, yyhl8)
	if yyb8 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.F = (float64)(r.DecodeFloat64())
	yyj8++
	yyb8 = !z.DecContainerNext(yyj8, l, yyhl8)
	if yyb8 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.I = (int64)(r.DecodeInt64())
	yyj8++
	for ; z.DecContainerNext(yyj8, l, yyhl8); yyj8++ {
		z.DecReadArrayElem()
		z.DecStructFieldNotFound(yyj8-1, "")
	}
}

func (x *missingFielderT2) IsCodecEmpty() bool {
	return !(x.S != "" || bool(x.B) || x.F != 0 || x.I != 0 || false)
}

func (testSelfExtHelper) codecSelferViaCodecgen() {}
func (x *testSelfExtHelper) CodecEncodeSelf(e *Encoder) {
	var h codecSelfer19780
	z, r := GenHelper().Encoder(e)
	_, _, _ = h, z, r
	if z.EncBasicHandle().CheckCircularRef {
		z.EncEncode(x)
		return
	}
	if x == nil {
		r.EncodeNil()
	} else {
		yy2arr2 := z.EncBasicHandle().StructToArray
		_ = yy2arr2
		const yyr2 bool = false // struct tag has 'toArray'
		if yyr2 || yy2arr2 {
			z.EncWriteArrayStart(3)
			z.EncWriteArrayElem()
			r.EncodeString(string(x.S))
			z.EncWriteArrayElem()
			r.EncodeInt(int64(x.I))
			z.EncWriteArrayElem()
			r.EncodeBool(bool(x.B))
			z.EncWriteArrayEnd()
		} else {
			z.EncWriteMapStart(3)
			if z.EncBasicHandle().Canonical {
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"B\"")
				} else {
					r.EncodeString(`B`)
				}
				z.EncWriteMapElemValue()
				r.EncodeBool(bool(x.B))
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"I\"")
				} else {
					r.EncodeString(`I`)
				}
				z.EncWriteMapElemValue()
				r.EncodeInt(int64(x.I))
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"S\"")
				} else {
					r.EncodeString(`S`)
				}
				z.EncWriteMapElemValue()
				r.EncodeString(string(x.S))
			} else {
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"S\"")
				} else {
					r.EncodeString(`S`)
				}
				z.EncWriteMapElemValue()
				r.EncodeString(string(x.S))
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"I\"")
				} else {
					r.EncodeString(`I`)
				}
				z.EncWriteMapElemValue()
				r.EncodeInt(int64(x.I))
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"B\"")
				} else {
					r.EncodeString(`B`)
				}
				z.EncWriteMapElemValue()
				r.EncodeBool(bool(x.B))
			}
			z.EncWriteMapEnd()
		}
	}
}

func (x *testSelfExtHelper) CodecDecodeSelf(d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelper().Decoder(d)
	_, _, _ = h, z, r
	yyct2 := r.ContainerType()
	if yyct2 == codecSelferValueTypeNil19780 {
		*(x) = testSelfExtHelper{}
	} else if yyct2 == codecSelferValueTypeMap19780 {
		yyl2 := z.DecReadMapStart()
		if yyl2 == 0 {
		} else {
			x.codecDecodeSelfFromMap(yyl2, d)
		}
		z.DecReadMapEnd()
	} else if yyct2 == codecSelferValueTypeArray19780 {
		yyl2 := z.DecReadArrayStart()
		if yyl2 != 0 {
			x.codecDecodeSelfFromArray(yyl2, d)
		}
		z.DecReadArrayEnd()
	} else {
		panic(errCodecSelferOnlyMapOrArrayEncodeToStruct19780)
	}
}

func (x *testSelfExtHelper) codecDecodeSelfFromMap(l int, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelper().Decoder(d)
	_, _, _ = h, z, r
	var yyhl3 bool = l >= 0
	for yyj3 := 0; z.DecContainerNext(yyj3, l, yyhl3); yyj3++ {
		z.DecReadMapElemKey()
		yys3 := r.DecodeStringAsBytes()
		z.DecReadMapElemValue()
		switch string(yys3) {
		case "S":
			x.S = (string)(z.DecStringZC(r.DecodeStringAsBytes()))
		case "I":
			x.I = (int64)(r.DecodeInt64())
		case "B":
			x.B = (bool)(r.DecodeBool())
		default:
			z.DecStructFieldNotFound(-1, string(yys3))
		} // end switch yys3
	} // end for yyj3
}

func (x *testSelfExtHelper) codecDecodeSelfFromArray(l int, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelper().Decoder(d)
	_, _, _ = h, z, r
	var yyj7 int
	var yyb7 bool
	var yyhl7 bool = l >= 0
	yyb7 = !z.DecContainerNext(yyj7, l, yyhl7)
	if yyb7 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.S = (string)(z.DecStringZC(r.DecodeStringAsBytes()))
	yyj7++
	yyb7 = !z.DecContainerNext(yyj7, l, yyhl7)
	if yyb7 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.I = (int64)(r.DecodeInt64())
	yyj7++
	yyb7 = !z.DecContainerNext(yyj7, l, yyhl7)
	if yyb7 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.B = (bool)(r.DecodeBool())
	yyj7++
	for ; z.DecContainerNext(yyj7, l, yyhl7); yyj7++ {
		z.DecReadArrayElem()
		z.DecStructFieldNotFound(yyj7-1, "")
	}
}

func (x *testSelfExtHelper) IsCodecEmpty() bool {
	return !(x.S != "" || x.I != 0 || bool(x.B) || false)
}

func (TestSelfExtImpl) codecSelferViaCodecgen() {}
func (x *TestSelfExtImpl) CodecEncodeSelf(e *Encoder) {
	var h codecSelfer19780
	z, r := GenHelper().Encoder(e)
	_, _, _ = h, z, r
	if z.EncBasicHandle().CheckCircularRef {
		z.EncEncode(x)
		return
	}
	if x == nil {
		r.EncodeNil()
	} else {
		yy2arr2 := z.EncBasicHandle().StructToArray
		_ = yy2arr2
		const yyr2 bool = false // struct tag has 'toArray'
		if yyr2 || yy2arr2 {
			z.EncWriteArrayStart(3)
			z.EncWriteArrayElem()
			r.EncodeString(string(x.testSelfExtHelper.S))
			z.EncWriteArrayElem()
			r.EncodeInt(int64(x.testSelfExtHelper.I))
			z.EncWriteArrayElem()
			r.EncodeBool(bool(x.testSelfExtHelper.B))
			z.EncWriteArrayEnd()
		} else {
			z.EncWriteMapStart(3)
			if z.EncBasicHandle().Canonical {
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"B\"")
				} else {
					r.EncodeString(`B`)
				}
				z.EncWriteMapElemValue()
				r.EncodeBool(bool(x.testSelfExtHelper.B))
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"I\"")
				} else {
					r.EncodeString(`I`)
				}
				z.EncWriteMapElemValue()
				r.EncodeInt(int64(x.testSelfExtHelper.I))
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"S\"")
				} else {
					r.EncodeString(`S`)
				}
				z.EncWriteMapElemValue()
				r.EncodeString(string(x.testSelfExtHelper.S))
			} else {
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"S\"")
				} else {
					r.EncodeString(`S`)
				}
				z.EncWriteMapElemValue()
				r.EncodeString(string(x.testSelfExtHelper.S))
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"I\"")
				} else {
					r.EncodeString(`I`)
				}
				z.EncWriteMapElemValue()
				r.EncodeInt(int64(x.testSelfExtHelper.I))
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"B\"")
				} else {
					r.EncodeString(`B`)
				}
				z.EncWriteMapElemValue()
				r.EncodeBool(bool(x.testSelfExtHelper.B))
			}
			z.EncWriteMapEnd()
		}
	}
}

func (x *TestSelfExtImpl) CodecDecodeSelf(d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelper().Decoder(d)
	_, _, _ = h, z, r
	yyct2 := r.ContainerType()
	if yyct2 == codecSelferValueTypeNil19780 {
		*(x) = TestSelfExtImpl{}
	} else if yyct2 == codecSelferValueTypeMap19780 {
		yyl2 := z.DecReadMapStart()
		if yyl2 == 0 {
		} else {
			x.codecDecodeSelfFromMap(yyl2, d)
		}
		z.DecReadMapEnd()
	} else if yyct2 == codecSelferValueTypeArray19780 {
		yyl2 := z.DecReadArrayStart()
		if yyl2 != 0 {
			x.codecDecodeSelfFromArray(yyl2, d)
		}
		z.DecReadArrayEnd()
	} else {
		panic(errCodecSelferOnlyMapOrArrayEncodeToStruct19780)
	}
}

func (x *TestSelfExtImpl) codecDecodeSelfFromMap(l int, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelper().Decoder(d)
	_, _, _ = h, z, r
	var yyhl3 bool = l >= 0
	for yyj3 := 0; z.DecContainerNext(yyj3, l, yyhl3); yyj3++ {
		z.DecReadMapElemKey()
		yys3 := r.DecodeStringAsBytes()
		z.DecReadMapElemValue()
		switch string(yys3) {
		case "S":
			x.testSelfExtHelper.S = (string)(z.DecStringZC(r.DecodeStringAsBytes()))
		case "I":
			x.testSelfExtHelper.I = (int64)(r.DecodeInt64())
		case "B":
			x.testSelfExtHelper.B = (bool)(r.DecodeBool())
		default:
			z.DecStructFieldNotFound(-1, string(yys3))
		} // end switch yys3
	} // end for yyj3
}

func (x *TestSelfExtImpl) codecDecodeSelfFromArray(l int, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelper().Decoder(d)
	_, _, _ = h, z, r
	var yyj7 int
	var yyb7 bool
	var yyhl7 bool = l >= 0
	yyb7 = !z.DecContainerNext(yyj7, l, yyhl7)
	if yyb7 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.testSelfExtHelper.S = (string)(z.DecStringZC(r.DecodeStringAsBytes()))
	yyj7++
	yyb7 = !z.DecContainerNext(yyj7, l, yyhl7)
	if yyb7 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.testSelfExtHelper.I = (int64)(r.DecodeInt64())
	yyj7++
	yyb7 = !z.DecContainerNext(yyj7, l, yyhl7)
	if yyb7 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.testSelfExtHelper.B = (bool)(r.DecodeBool())
	yyj7++
	for ; z.DecContainerNext(yyj7, l, yyhl7); yyj7++ {
		z.DecReadArrayElem()
		z.DecStructFieldNotFound(yyj7-1, "")
	}
}

func (x *TestSelfExtImpl) IsCodecEmpty() bool {
	return !(!(x.testSelfExtHelper.IsCodecEmpty()) || false)
}

func (TestSelfExtImpl2) codecSelferViaCodecgen() {}
func (x *TestSelfExtImpl2) CodecEncodeSelf(e *Encoder) {
	var h codecSelfer19780
	z, r := GenHelper().Encoder(e)
	_, _, _ = h, z, r
	if z.EncBasicHandle().CheckCircularRef {
		z.EncEncode(x)
		return
	}
	if x == nil {
		r.EncodeNil()
	} else {
		yy2arr2 := z.EncBasicHandle().StructToArray
		_ = yy2arr2
		const yyr2 bool = false // struct tag has 'toArray'
		if yyr2 || yy2arr2 {
			z.EncWriteArrayStart(2)
			z.EncWriteArrayElem()
			r.EncodeString(string(x.M))
			z.EncWriteArrayElem()
			r.EncodeBool(bool(x.O))
			z.EncWriteArrayEnd()
		} else {
			z.EncWriteMapStart(2)
			if z.EncBasicHandle().Canonical {
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"M\"")
				} else {
					r.EncodeString(`M`)
				}
				z.EncWriteMapElemValue()
				r.EncodeString(string(x.M))
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"O\"")
				} else {
					r.EncodeString(`O`)
				}
				z.EncWriteMapElemValue()
				r.EncodeBool(bool(x.O))
			} else {
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"M\"")
				} else {
					r.EncodeString(`M`)
				}
				z.EncWriteMapElemValue()
				r.EncodeString(string(x.M))
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"O\"")
				} else {
					r.EncodeString(`O`)
				}
				z.EncWriteMapElemValue()
				r.EncodeBool(bool(x.O))
			}
			z.EncWriteMapEnd()
		}
	}
}

func (x *TestSelfExtImpl2) CodecDecodeSelf(d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelper().Decoder(d)
	_, _, _ = h, z, r
	yyct2 := r.ContainerType()
	if yyct2 == codecSelferValueTypeNil19780 {
		*(x) = TestSelfExtImpl2{}
	} else if yyct2 == codecSelferValueTypeMap19780 {
		yyl2 := z.DecReadMapStart()
		if yyl2 == 0 {
		} else {
			x.codecDecodeSelfFromMap(yyl2, d)
		}
		z.DecReadMapEnd()
	} else if yyct2 == codecSelferValueTypeArray19780 {
		yyl2 := z.DecReadArrayStart()
		if yyl2 != 0 {
			x.codecDecodeSelfFromArray(yyl2, d)
		}
		z.DecReadArrayEnd()
	} else {
		panic(errCodecSelferOnlyMapOrArrayEncodeToStruct19780)
	}
}

func (x *TestSelfExtImpl2) codecDecodeSelfFromMap(l int, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelper().Decoder(d)
	_, _, _ = h, z, r
	var yyhl3 bool = l >= 0
	for yyj3 := 0; z.DecContainerNext(yyj3, l, yyhl3); yyj3++ {
		z.DecReadMapElemKey()
		yys3 := r.DecodeStringAsBytes()
		z.DecReadMapElemValue()
		switch string(yys3) {
		case "M":
			x.M = (string)(z.DecStringZC(r.DecodeStringAsBytes()))
		case "O":
			x.O = (bool)(r.DecodeBool())
		default:
			z.DecStructFieldNotFound(-1, string(yys3))
		} // end switch yys3
	} // end for yyj3
}

func (x *TestSelfExtImpl2) codecDecodeSelfFromArray(l int, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelper().Decoder(d)
	_, _, _ = h, z, r
	var yyj6 int
	var yyb6 bool
	var yyhl6 bool = l >= 0
	yyb6 = !z.DecContainerNext(yyj6, l, yyhl6)
	if yyb6 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.M = (string)(z.DecStringZC(r.DecodeStringAsBytes()))
	yyj6++
	yyb6 = !z.DecContainerNext(yyj6, l, yyhl6)
	if yyb6 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.O = (bool)(r.DecodeBool())
	yyj6++
	for ; z.DecContainerNext(yyj6, l, yyhl6); yyj6++ {
		z.DecReadArrayElem()
		z.DecStructFieldNotFound(yyj6-1, "")
	}
}

func (x *TestSelfExtImpl2) IsCodecEmpty() bool {
	return !(x.M != "" || bool(x.O) || false)
}

func (TestTwoNakedInterfaces) codecSelferViaCodecgen() {}
func (x *TestTwoNakedInterfaces) CodecEncodeSelf(e *Encoder) {
	var h codecSelfer19780
	z, r := GenHelper().Encoder(e)
	_, _, _ = h, z, r
	if z.EncBasicHandle().CheckCircularRef {
		z.EncEncode(x)
		return
	}
	if x == nil {
		r.EncodeNil()
	} else {
		yy2arr2 := z.EncBasicHandle().StructToArray
		_ = yy2arr2
		const yyr2 bool = false // struct tag has 'toArray'
		if yyr2 || yy2arr2 {
			z.EncWriteArrayStart(2)
			z.EncWriteArrayElem()
			z.EncFallback(x.A)
			z.EncWriteArrayElem()
			z.EncFallback(x.B)
			z.EncWriteArrayEnd()
		} else {
			z.EncWriteMapStart(2)
			if z.EncBasicHandle().Canonical {
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"A\"")
				} else {
					r.EncodeString(`A`)
				}
				z.EncWriteMapElemValue()
				z.EncFallback(x.A)
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"B\"")
				} else {
					r.EncodeString(`B`)
				}
				z.EncWriteMapElemValue()
				z.EncFallback(x.B)
			} else {
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"A\"")
				} else {
					r.EncodeString(`A`)
				}
				z.EncWriteMapElemValue()
				z.EncFallback(x.A)
				z.EncWriteMapElemKey()
				if z.IsJSONHandle() {
					z.EncWr().WriteStr("\"B\"")
				} else {
					r.EncodeString(`B`)
				}
				z.EncWriteMapElemValue()
				z.EncFallback(x.B)
			}
			z.EncWriteMapEnd()
		}
	}
}

func (x *TestTwoNakedInterfaces) CodecDecodeSelf(d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelper().Decoder(d)
	_, _, _ = h, z, r
	yyct2 := r.ContainerType()
	if yyct2 == codecSelferValueTypeNil19780 {
		*(x) = TestTwoNakedInterfaces{}
	} else if yyct2 == codecSelferValueTypeMap19780 {
		yyl2 := z.DecReadMapStart()
		if yyl2 == 0 {
		} else {
			x.codecDecodeSelfFromMap(yyl2, d)
		}
		z.DecReadMapEnd()
	} else if yyct2 == codecSelferValueTypeArray19780 {
		yyl2 := z.DecReadArrayStart()
		if yyl2 != 0 {
			x.codecDecodeSelfFromArray(yyl2, d)
		}
		z.DecReadArrayEnd()
	} else {
		panic(errCodecSelferOnlyMapOrArrayEncodeToStruct19780)
	}
}

func (x *TestTwoNakedInterfaces) codecDecodeSelfFromMap(l int, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelper().Decoder(d)
	_, _, _ = h, z, r
	var yyhl3 bool = l >= 0
	for yyj3 := 0; z.DecContainerNext(yyj3, l, yyhl3); yyj3++ {
		z.DecReadMapElemKey()
		yys3 := r.DecodeStringAsBytes()
		z.DecReadMapElemValue()
		switch string(yys3) {
		case "A":
			z.DecFallback(&x.A, true)
		case "B":
			z.DecFallback(&x.B, true)
		default:
			z.DecStructFieldNotFound(-1, string(yys3))
		} // end switch yys3
	} // end for yyj3
}

func (x *TestTwoNakedInterfaces) codecDecodeSelfFromArray(l int, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelper().Decoder(d)
	_, _, _ = h, z, r
	var yyj8 int
	var yyb8 bool
	var yyhl8 bool = l >= 0
	yyb8 = !z.DecContainerNext(yyj8, l, yyhl8)
	if yyb8 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	z.DecFallback(&x.A, true)
	yyj8++
	yyb8 = !z.DecContainerNext(yyj8, l, yyhl8)
	if yyb8 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	z.DecFallback(&x.B, true)
	yyj8++
	for ; z.DecContainerNext(yyj8, l, yyhl8); yyj8++ {
		z.DecReadArrayElem()
		z.DecStructFieldNotFound(yyj8-1, "")
	}
}

func (x *TestTwoNakedInterfaces) IsCodecEmpty() bool {
	return !(x.A != nil || x.B != nil || false)
}

func (TestStrucFlex) codecSelferViaCodecgen() {}
func (x *TestStrucFlex) CodecEncodeSelf(e *Encoder) {
	var h codecSelfer19780
	z, r := GenHelper().Encoder(e)
	_, _, _ = h, z, r
	if z.EncBasicHandle().CheckCircularRef {
		z.EncEncode(x)
		return
	}
	if x == nil {
		r.EncodeNil()
	} else {
		yy2arr2 := z.EncBasicHandle().StructToArray
		_ = yy2arr2
		const yyr2 bool = false // struct tag has 'toArray'
		var yyn54 bool = x.TestStrucCommon.AnonInTestStrucSlim == nil || x.TestStrucCommon.AnonInTestStrucSlim.P == nil
		var yyn55 bool = x.TestStrucCommon.NotAnonSlim == nil
		var yyn58 bool = x.TestStrucCommon.Nint64 == nil
		var yyn81 bool = x.Ttimeptr == nil
		var yyn82 bool = x.AnonInTestStrucIntf == nil
		var yyn83 bool = x.AnonInTestStrucIntf == nil
		var yyn84 bool = x.AnonInTestStrucIntf == nil
		var yyn85 bool = x.AnonInTestStrucIntf == nil
		var yyn86 bool = x.AnonInTestStrucIntf == nil || x.AnonInTestStrucIntf.Tptr == nil
		var yyn91 bool = x.Nteststruc == nil
		var yyq2 = [95]bool{ // should field at this index be written?
			x.S != "",                   // S
			x.I64 != 0,                  // I64
			x.I32 != 0,                  // I32
			x.I16 != 0,                  // I16
			x.I8 != 0,                   // I8
			x.I64n != 0,                 // I64n
			x.I32n != 0,                 // I32n
			x.I16n != 0,                 // I16n
			x.I8n != 0,                  // I8n
			x.Ui64 != 0,                 // Ui64
			x.Ui32 != 0,                 // Ui32
			x.Ui16 != 0,                 // Ui16
			x.Ui8 != 0,                  // Ui8
			x.F64 != 0,                  // F64
			x.F32 != 0,                  // F32
			bool(x.B),                   // B
			x.By != 0,                   // By
			len(x.Sslice) != 0,          // Sslice
			len(x.I64slice) != 0,        // I64slice
			len(x.I32slice) != 0,        // I32slice
			len(x.Ui64slice) != 0,       // Ui64slice
			len(x.Ui8slice) != 0,        // Ui8slice
			len(x.Bslice) != 0,          // Bslice
			len(x.Byslice) != 0,         // Byslice
			len(x.BytesSlice) != 0,      // BytesSlice
			len(x.Iptrslice) != 0,       // Iptrslice
			len(x.WrapSliceInt64) != 0,  // WrapSliceInt64
			len(x.WrapSliceString) != 0, // WrapSliceString
			len(x.Msint) != 0,           // Msint
			len(x.Msbytes) != 0,         // Msbytes
			!(x.Simplef.IsCodecEmpty()), // Simplef
			len(x.SstrUi64T) != 0,       // SstrUi64T
			len(x.MstrUi64T) != 0,       // MstrUi64T
			x.AS != "",                  // AS
			x.AI64 != 0,                 // AI64
			x.AI16 != 0,                 // AI16
			x.AUi64 != 0,                // AUi64
			len(x.ASslice) != 0,         // ASslice
			len(x.AI64slice) != 0,       // AI64slice
			len(x.AUi64slice) != 0,      // AUi64slice
			len(x.AF64slice) != 0,       // AF64slice
			len(x.AF32slice) != 0,       // AF32slice
			len(x.AMSS) != 0,            // AMSS
			len(x.AMSU64) != 0,          // AMSU64
			x.AI64arr8 != [8]int64{},    // AI64arr8
			false,                       // AI64arr0
			len(x.AI64slice0) != 0,      // AI64slice0
			len(x.AUi64sliceN) != 0,     // AUi64sliceN
			len(x.AMSU64N) != 0,         // AMSU64N
			len(x.AMSU64E) != 0,         // AMSU64E
			!(x.NotAnon.IsCodecEmpty()), // NotAnon
			x.TestStrucCommon.AnonInTestStrucSlim != nil && x.P != nil, // P
			x.NotAnonSlim != nil,                // NotAnonSlim
			len(x.Nmap) != 0,                    // Nmap
			len(x.Nslice) != 0,                  // Nslice
			x.Nint64 != nil,                     // Nint64
			len(x.Chstr) != 0,                   // Chstr
			len(x.Mis) != 0,                     // Mis
			len(x.Mbu64) != 0,                   // Mbu64
			len(x.Mu8e) != 0,                    // Mu8e
			len(x.Mu8u64) != 0,                  // Mu8u64
			len(x.Msp2ss) != 0,                  // Msp2ss
			len(x.Mip2ss) != 0,                  // Mip2ss
			len(x.Ms2misu) != 0,                 // Ms2misu
			len(x.Miwu64s) != 0,                 // Miwu64s
			len(x.Mfwss) != 0,                   // Mfwss
			len(x.Mf32wss) != 0,                 // Mf32wss
			len(x.Mui2wss) != 0,                 // Mui2wss
			len(x.Msu2wss) != 0,                 // Msu2wss
			x.Ci64 != 0,                         // Ci64
			len(x.Swrapbytes) != 0,              // Swrapbytes
			len(x.Swrapuint8) != 0,              // Swrapuint8
			x.ArrStrUi64T != [4]stringUint64T{}, // ArrStrUi64T
			x.Ui64array != [4]uint64{},          // Ui64array
			len(x.Ui64slicearray) != 0,          // Ui64slicearray
			len(x.SintfAarray) != 0,             // SintfAarray
			len(x.MstrUi64TSelf) != 0,           // MstrUi64TSelf
			!(x.Ttime.IsZero()),                 // Ttime
			x.Ttimeptr != nil,                   // Ttimeptr
			x.AnonInTestStrucIntf != nil && len(x.Islice) != 0, // Islice
			x.AnonInTestStrucIntf != nil && len(x.Ms) != 0,     // Ms
			x.AnonInTestStrucIntf != nil && x.Nintf != nil,     // Nintf
			x.AnonInTestStrucIntf != nil && !(x.T.IsZero()),    // T
			x.AnonInTestStrucIntf != nil && x.Tptr != nil,      // Tptr
			len(x.Msu) != 0,     // Msu
			len(x.Mtsptr) != 0,  // Mtsptr
			len(x.Mts) != 0,     // Mts
			len(x.Its) != 0,     // Its
			x.Nteststruc != nil, // Nteststruc
			bool(x.MarJ),        // MarJ
			x.MarT != "",        // MarT
			len(x.MarB) != 0,    // MarB
			x.XuintToBytes != 0, // XuintToBytes
			x.Cmplx64 != 0,      // Cmplx64
			x.Cmplx128 != 0,     // Cmplx128
		}
		_ = yyq2
		if yyr2 || yy2arr2 {
			z.EncWriteArrayStart(95)
			z.EncWriteArrayElem()
			if yyq2[0] {
				r.EncodeString(string(x.TestStrucCommon.S))
			} else {
				r.EncodeString("")
			}
			z.EncWriteArrayElem()
			if yyq2[1] {
				r.EncodeInt(int64(x.TestStrucCommon.I64))
			} else {
				r.EncodeInt(0)
			}
			z.EncWriteArrayElem()
			if yyq2[2] {
				r.EncodeInt(int64(x.TestStrucCommon.I32))
			} else {
				r.EncodeInt(0)
			}
			z.EncWriteArrayElem()
			if yyq2[3] {
				r.EncodeInt(int64(x.TestStrucCommon.I16))
			} else {
				r.EncodeInt(0)
			}
			z.EncWriteArrayElem()
			if yyq2[4] {
				r.EncodeInt(int64(x.TestStrucCommon.I8))
			} else {
				r.EncodeInt(0)
			}
			z.EncWriteArrayElem()
			if yyq2[5] {
				r.EncodeInt(int64(x.TestStrucCommon.I64n))
			} else {
				r.EncodeInt(0)
			}
			z.EncWriteArrayElem()
			if yyq2[6] {
				r.EncodeInt(int64(x.TestStrucCommon.I32n))
			} else {
				r.EncodeInt(0)
			}
			z.EncWriteArrayElem()
			if yyq2[7] {
				r.EncodeInt(int64(x.TestStrucCommon.I16n))
			} else {
				r.EncodeInt(0)
			}
			z.EncWriteArrayElem()
			if yyq2[8] {
				r.EncodeInt(int64(x.TestStrucCommon.I8n))
			} else {
				r.EncodeInt(0)
			}
			z.EncWriteArrayElem()
			if yyq2[9] {
				r.EncodeUint(uint64(x.TestStrucCommon.Ui64))
			} else {
				r.EncodeUint(0)
			}
			z.EncWriteArrayElem()
			if yyq2[10] {
				r.EncodeUint(uint64(x.TestStrucCommon.Ui32))
			} else {
				r.EncodeUint(0)
			}
			z.EncWriteArrayElem()
			if yyq2[11] {
				r.EncodeUint(uint64(x.TestStrucCommon.Ui16))
			} else {
				r.EncodeUint(0)
			}
			z.EncWriteArrayElem()
			if yyq2[12] {
				r.EncodeUint(uint64(x.TestStrucCommon.Ui8))
			} else {
				r.EncodeUint(0)
			}
			z.EncWriteArrayElem()
			if yyq2[13] {
				r.EncodeFloat64(float64(x.TestStrucCommon.F64))
			} else {
				r.EncodeFloat64(0)
			}
			z.EncWriteArrayElem()
			if yyq2[14] {
				r.EncodeFloat32(float32(x.TestStrucCommon.F32))
			} else {
				r.EncodeFloat32(0)
			}
			z.EncWriteArrayElem()
			if yyq2[15] {
				r.EncodeBool(bool(x.TestStrucCommon.B))
			} else {
				r.EncodeBool(false)
			}
			z.EncWriteArrayElem()
			if yyq2[16] {
				r.EncodeUint(uint64(x.TestStrucCommon.By))
			} else {
				r.EncodeUint(0)
			}
			z.EncWriteArrayElem()
			if yyq2[17] {
				if x.TestStrucCommon.Sslice == nil {
					r.EncodeNil()
				} else {
					z.F.EncSliceStringV(x.TestStrucCommon.Sslice, e)
				} // end block: if x.TestStrucCommon.Sslice slice == nil
			} else {
				r.EncodeNil()
			}
			z.EncWriteArrayElem()
			if yyq2[18] {
				if x.TestStrucCommon.I64slice == nil {
					r.EncodeNil()
				} else {
					z.F.EncSliceInt64V(x.TestStrucCommon.I64slice, e)
				} // end block: if x.TestStrucCommon.I64slice slice == nil
			} else {
				r.EncodeNil()
			}
			z.EncWriteArrayElem()
			if yyq2[19] {
				if x.TestStrucCommon.I32slice == nil {
					r.EncodeNil()
				} else {
					z.F.EncSliceInt32V(x.TestStrucCommon.I32slice, e)
				} // end block: if x.TestStrucCommon.I32slice slice == nil
			} else {
				r.EncodeNil()
			}
			z.EncWriteArrayElem()
			if yyq2[20] {
				if x.TestStrucCommon.Ui64slice == nil {
					r.EncodeNil()
				} else {
					z.F.EncSliceUint64V(x.TestStrucCommon.Ui64slice, e)
				} // end block: if x.TestStrucCommon.Ui64slice slice == nil
			} else {
				r.EncodeNil()
			}
			z.EncWriteArrayElem()
			if yyq2[21] {
				if x.TestStrucCommon.Ui8slice == nil {
					r.EncodeNil()
				} else {
					r.EncodeStringBytesRaw([]byte(x.TestStrucCommon.Ui8slice))
				} // end block: if x.TestStrucCommon.Ui8slice slice == nil
			} else {
				r.EncodeNil()
			}
			z.EncWriteArrayElem()
			if yyq2[22] {
				if x.TestStrucCommon.Bslice == nil {
					r.EncodeNil()
				} else {
					z.F.EncSliceBoolV(x.TestStrucCommon.Bslice, e)
				} // end block: if x.TestStrucCommon.Bslice slice == nil
			} else {
				r.EncodeNil()
			}
			z.EncWriteArrayElem()
			if yyq2[23] {
				if x.TestStrucCommon.Byslice == nil {
					r.EncodeNil()
				} else {
					r.EncodeStringBytesRaw([]byte(x.TestStrucCommon.Byslice))
				} // end block: if x.TestStrucCommon.Byslice slice == nil
			} else {
				r.EncodeNil()
			}
			z.EncWriteArrayElem()
			if yyq2[24] {
				if x.TestStrucCommon.BytesSlice == nil {
					r.EncodeNil()
				} else {
					z.F.EncSliceBytesV(x.TestStrucCommon.BytesSlice, e)
				} // end block: if x.TestStrucCommon.BytesSlice slice == nil
			} else {
				r.EncodeNil()
			}
			z.EncWriteArrayElem()
			if yyq2[25] {
				if x.TestStrucCommon.Iptrslice == nil {
					r.EncodeNil()
				} else {
					h.encSlicePtrtoint64(([]*int64)(x.TestStrucCommon.Iptrslice), e)
				} // end block: if x.TestStrucCommon.Iptrslice slice == nil
			} else {
				r.EncodeNil()
			}
			z.EncWriteArrayElem()
			if yyq2[26] {
				if yyxt124 := z.Extension(x.TestStrucCommon.WrapSliceInt64); yyxt124 != nil {
					z.EncExtension(x.TestStrucCommon.WrapSliceInt64, yyxt124)
				} else {
					x.TestStrucCommon.WrapSliceInt64.CodecEncodeSelf(e)
				}
			} else {
				r.EncodeNil()
			}
			z.EncWriteArrayElem()
			if yyq2[27] {
				if yyxt125 := z.Extension(x.TestStrucCommon.WrapSliceString); yyxt125 != nil {
					z.EncExtension(x.TestStrucCommon.WrapSliceString, yyxt125)
				} else {
					x.TestStrucCommon.WrapSliceString.CodecEncodeSelf(e)
				}
			} else {
				r.EncodeNil()
			}
			z.EncWriteArrayElem()
			if yyq2[28] {
				if x.TestStrucCommon.Msint == nil {
					r.EncodeNil()
				} else {
					z.F.EncMapStringIntV(x.TestStrucCommon.Msint, e)
				} // end block: if x.TestStrucCommon.Msint map == nil
			} else {
				r.EncodeNil()
			}
			z.EncWriteArrayElem()
			if yyq2[29] {
				if x.TestStrucCommon.Msbytes == nil {
					r.EncodeNil()
				} else {
					z.F.EncMapStringBytesV(x.TestStrucCommon.Msbytes, e)
				} // end block: if x.TestStrucCommon.Msbytes map == nil
			} else {
				r.EncodeNil()
			}
			z.EncWriteArrayElem()
			if yyq2[30] {
				yy128 := &x.TestStrucCommon.Simplef
				if yyxt129 := z.Extension(yy128); yyxt129 != nil {
					z.EncExtension(yy128, yyxt129)
				} else {
					yy128.CodecEncodeSelf(e)
				}
			} else {
				r.EncodeNil()
			}
			z.EncWriteArrayElem()
			if yyq2[31] {
				if x.TestStrucCommon.SstrUi64T == nil {
					r.EncodeNil()
				} else {
					h.encSlicestringUint64T(([]stringUint64T)(x.TestStrucCommon.SstrUi64T), e)
				} // end block: if x.TestStrucCommon.SstrUi64T slice == nil
			} else {
				r.EncodeNil()
			}
			z.EncWriteArrayElem()
			if yyq2[32] {
				if x.TestStrucCommon.MstrUi64T == nil {
					r.EncodeNil()
				} else {
					h.encMapstringPtrtostringUint64T((map[string]*stringUint64T)(x.TestStrucCommon.MstrUi64T), e)
				} // end block: if x.TestStrucCommon.MstrUi64T map == nil
			} else {
				r.EncodeNil()
			}
			z.EncWriteArrayElem()
			if yyq2[33] {
				r.EncodeString(string(x.TestStrucCommon.AnonInTestStruc.AS))
			} else {
				r.EncodeString("")
			}
			z.EncWriteArrayElem()
			if yyq2[34] {
				r.EncodeInt(int64(x.TestStrucCommon.AnonInTestStruc.AI64))
			} else {
				r.EncodeInt(0)
			}
			z.EncWriteArrayElem()
			if yyq2[35] {
				r.EncodeInt(int64(x.TestStrucCommon.AnonInTestStruc.AI16))
			} else {
				r.EncodeInt(0)
			}
			z.EncWriteArrayElem()
			if yyq2[36] {
				r.EncodeUint(uint64(x.TestStrucCommon.AnonInTestStruc.AUi64))
			} else {
				r.EncodeUint(0)
			}
			z.EncWriteArrayElem()
			if yyq2[37] {
				if x.TestStrucCommon.AnonInTestStruc.ASslice == nil {
					r.EncodeNil()
				} else {
					z.F.EncSliceStringV(x.TestStrucCommon.AnonInTestStruc.ASslice, e)
				} // end block: if x.TestStrucCommon.AnonInTestStruc.ASslice slice == nil
			} else {
				r.EncodeNil()
			}
			z.EncWriteArrayElem()
			if yyq2[38] {
				if x.TestStrucCommon.AnonInTestStruc.AI64slice == nil {
					r.EncodeNil()
				} else {
					z.F.EncSliceInt64V(x.TestStrucCommon.AnonInTestStruc.AI64slice, e)
				} // end block: if x.TestStrucCommon.AnonInTestStruc.AI64slice slice == nil
			} else {
				r.EncodeNil()
			}
			z.EncWriteArrayElem()
			if yyq2[39] {
				if x.TestStrucCommon.AnonInTestStruc.AUi64slice == nil {
					r.EncodeNil()
				} else {
					z.F.EncSliceUint64V(x.TestStrucCommon.AnonInTestStruc.AUi64slice, e)
				} // end block: if x.TestStrucCommon.AnonInTestStruc.AUi64slice slice == nil
			} else {
				r.EncodeNil()
			}
			z.EncWriteArrayElem()
			if yyq2[40] {
				if x.TestStrucCommon.AnonInTestStruc.AF64slice == nil {
					r.EncodeNil()
				} else {
					z.F.EncSliceFloat64V(x.TestStrucCommon.AnonInTestStruc.AF64slice, e)
				} // end block: if x.TestStrucCommon.AnonInTestStruc.AF64slice slice == nil
			} else {
				r.EncodeNil()
			}
			z.EncWriteArrayElem()
			if yyq2[41] {
				if x.TestStrucCommon.AnonInTestStruc.AF32slice == nil {
					r.EncodeNil()
				} else {
					z.F.EncSliceFloat32V(x.TestStrucCommon.AnonInTestStruc.AF32slice, e)
				} // end block: if x.TestStrucCommon.AnonInTestStruc.AF32slice slice == nil
			} else {
				r.EncodeNil()
			}
			z.EncWriteArrayElem()
			if yyq2[42] {
				if x.TestStrucCommon.AnonInTestStruc.AMSS == nil {
					r.EncodeNil()
				} else {
					z.F.EncMapStringStringV(x.TestStrucCommon.AnonInTestStruc.AMSS, e)
				} // end block: if x.TestStrucCommon.AnonInTestStruc.AMSS map == nil
			} else {
				r.EncodeNil()
			}
			z.EncWriteArrayElem()
			if yyq2[43] {
				if x.TestStrucCommon.AnonInTestStruc.AMSU64 == nil {
					r.EncodeNil()
				} else {
					z.F.EncMapStringUint64V(x.TestStrucCommon.AnonInTestStruc.AMSU64, e)
				} // end block: if x.TestStrucCommon.AnonInTestStruc.AMSU64 map == nil
			} else {
				r.EncodeNil()
			}
			z.EncWriteArrayElem()
			if yyq2[44] {
				yy143 := &x.TestStrucCommon.AnonInTestStruc.AI64arr8
				h.encArray8int64((*[8]int64)(yy143), e)
			} else {
				r.EncodeNil()
			}
			z.EncWriteArrayElem()
			if yyq2[45] {
				yy145 := &x.TestStrucCommon.AnonInTestStruc.AI64arr0
				h.encArray0int64((*[0]int64)(yy145), e)
			} else {
				r.EncodeNil()
			}
			z.EncWriteArrayElem()
			if yyq2[46] {
				if x.TestStrucCommon.AnonInTestStruc.AI64slice0 == nil {
					r.EncodeNil()
				} else {
					z.F.EncSliceInt64V(x.TestStrucCommon.AnonInTestStruc.AI64slice0, e)
				} // end block: if x.TestStrucCommon.AnonInTestStruc.AI64slice0 slice == nil
			} else {
				r.EncodeNil()
			}
			z.EncWriteArrayElem()
			if yyq2[47] {
				if x.TestStrucCommon.AnonInTestStruc.AUi64sliceN == nil {
					r.EncodeNil()
				} else {
					z.F.EncSliceUint64V(x.TestStrucCommon.AnonInTestStruc.AUi64sliceN, e)
				} // end block: if x.TestStrucCommon.AnonInTestStruc.AUi64sliceN slice == nil
			} else {
				r.EncodeNil()
			}
			z.EncWriteArrayElem()
			if yyq2[48] {
				if x.TestStrucCommon.AnonInTestStruc.AMSU64N == nil {
					r.EncodeNil()
				} else {
					z.F.EncMapStringUint64V(x.TestStrucCommon.AnonInTestStruc.AMSU64N, e)
				} // end block: if x.TestStrucCommon.AnonInTestStruc.AMSU64N map == nil
			} else {
				r.EncodeNil()
			}
			z.EncWriteArrayElem()
			if yyq2[49] {
				if x.TestStrucCommon.AnonInTestStruc.AMSU64E == nil {
					r.EncodeNil()
				} else {
					z.F.EncMapStringUint64V(x.TestStrucCommon.AnonInTestStruc.AMSU64E, e)
				} // end block: if x.TestStrucCommon.AnonInTestStruc.AMSU64E map == nil
			} else {
				r.EncodeNil()
			}
			z.EncWriteArrayElem()
			if yyq2[50] {
				yy151 := &x.TestStrucCommon.NotAnon
				if yyxt152 := z.Extension(yy151); yyxt152 != nil {
					z.EncExtension(yy151, yyxt152)
				} else {
					yy151.CodecEncodeSelf(e)
				}
			} else {
				r.EncodeNil()
			}
			if yyn54 {
				z.EncWriteArrayElem()
				r.EncodeNil()
			} else {
				z.EncWriteArrayElem()
				if yyq2[51] {
					yy153 := *x.TestStrucCommon.AnonInTestStrucSlim.P
					r.EncodeString(string(yy153))
				} else {
					r.EncodeNil()
				}
			}
			if yyn55 {
				z.EncWriteArrayElem()
				r.EncodeNil()
			} else {
				z.EncWriteArrayElem()
				if yyq2[52] {
					if yyxt155 := z.Extension(x.TestStrucCommon.NotAnonSlim); yyxt155 != nil {
						z.EncExtension(x.TestStrucCommon.NotAnonSlim, yyxt155)
					} else {
						x.TestStrucCommon.NotAnonSlim.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			}
			z.EncWriteArrayElem()
			if yyq2[53] {
				if x.TestStrucCommon.Nmap == nil {
					r.EncodeNil()
				} else {
					z.F.EncMapStringBoolV(x.TestStrucCommon.Nmap, e)
				} // end block: if x.TestStrucCommon.Nmap map == nil
			} else {
				r.EncodeNil()
			}
			z.EncWriteArrayElem()
			if yyq2[54] {
				if x.TestStrucCommon.Nslice == nil {
					r.EncodeNil()
				} else {
					r.EncodeStringBytesRaw([]byte(x.TestStrucCommon.Nslice))
				} // end block: if x.TestStrucCommon.Nslice slice == nil
			} else {
				r.EncodeNil()
			}
			if yyn58 {
				z.EncWriteArrayElem()
				r.EncodeNil()
			} else {
				z.EncWriteArrayElem()
				if yyq2[55] {
					yy158 := *x.TestStrucCommon.Nint64
					r.EncodeInt(int64(yy158))
				} else {
					r.EncodeNil()
				}
			}
			z.EncWriteArrayElem()
			if yyq2[56] {
				h.encChanstring((chan string)(x.Chstr), e)
			} else {
				r.EncodeNil()
			}
			z.EncWriteArrayElem()
			if yyq2[57] {
				if x.Mis == nil {
					r.EncodeNil()
				} else {
					z.F.EncMapIntStringV(x.Mis, e)
				} // end block: if x.Mis map == nil
			} else {
				r.EncodeNil()
			}
			z.EncWriteArrayElem()
			if yyq2[58] {
				if x.Mbu64 == nil {
					r.EncodeNil()
				} else {
					h.encMapboolc3RydWN0IHt9((map[bool]struct{})(x.Mbu64), e)
				} // end block: if x.Mbu64 map == nil
			} else {
				r.EncodeNil()
			}
			z.EncWriteArrayElem()
			if yyq2[59] {
				if x.Mu8e == nil {
					r.EncodeNil()
				} else {
					h.encMapuint8c3RydWN0IHt9((map[uint8]struct{})(x.Mu8e), e)
				} // end block: if x.Mu8e map == nil
			} else {
				r.EncodeNil()
			}
			z.EncWriteArrayElem()
			if yyq2[60] {
				if x.Mu8u64 == nil {
					r.EncodeNil()
				} else {
					h.encMapuint8stringUint64T((map[uint8]stringUint64T)(x.Mu8u64), e)
				} // end block: if x.Mu8u64 map == nil
			} else {
				r.EncodeNil()
			}
			z.EncWriteArrayElem()
			if yyq2[61] {
				if x.Msp2ss == nil {
					r.EncodeNil()
				} else {
					h.encMapPtrtostringSlicestring((map[*string][]string)(x.Msp2ss), e)
				} // end block: if x.Msp2ss map == nil
			} else {
				r.EncodeNil()
			}
			z.EncWriteArrayElem()
			if yyq2[62] {
				if x.Mip2ss == nil {
					r.EncodeNil()
				} else {
					h.encMapPtrtouint64Slicestring((map[*uint64][]string)(x.Mip2ss), e)
				} // end block: if x.Mip2ss map == nil
			} else {
				r.EncodeNil()
			}
			z.EncWriteArrayElem()
			if yyq2[63] {
				if x.Ms2misu == nil {
					r.EncodeNil()
				} else {
					h.encMapstringMapuint64stringUint64T((map[string]map[uint64]stringUint64T)(x.Ms2misu), e)
				} // end block: if x.Ms2misu map == nil
			} else {
				r.EncodeNil()
			}
			z.EncWriteArrayElem()
			if yyq2[64] {
				if x.Miwu64s == nil {
					r.EncodeNil()
				} else {
					h.encMapintwrapUint64Slice((map[int]wrapUint64Slice)(x.Miwu64s), e)
				} // end block: if x.Miwu64s map == nil
			} else {
				r.EncodeNil()
			}
			z.EncWriteArrayElem()
			if yyq2[65] {
				if x.Mfwss == nil {
					r.EncodeNil()
				} else {
					h.encMapfloat64wrapStringSlice((map[float64]wrapStringSlice)(x.Mfwss), e)
				} // end block: if x.Mfwss map == nil
			} else {
				r.EncodeNil()
			}
			z.EncWriteArrayElem()
			if yyq2[66] {
				if x.Mf32wss == nil {
					r.EncodeNil()
				} else {
					h.encMapfloat32wrapStringSlice((map[float32]wrapStringSlice)(x.Mf32wss), e)
				} // end block: if x.Mf32wss map == nil
			} else {
				r.EncodeNil()
			}
			z.EncWriteArrayElem()
			if yyq2[67] {
				if x.Mui2wss == nil {
					r.EncodeNil()
				} else {
					h.encMapuint64wrapStringSlice((map[uint64]wrapStringSlice)(x.Mui2wss), e)
				} // end block: if x.Mui2wss map == nil
			} else {
				r.EncodeNil()
			}
			z.EncWriteArrayElem()
			if yyq2[68] {
				if x.Msu2wss == nil {
					r.EncodeNil()
				} else {
					h.encMapstringUint64TwrapStringSlice((map[stringUint64T]wrapStringSlice)(x.Msu2wss), e)
				} // end block: if x.Msu2wss map == nil
			} else {
				r.EncodeNil()
			}
			z.EncWriteArrayElem()
			if yyq2[69] {
				if yyxt173 := z.Extension(x.Ci64); yyxt173 != nil {
					z.EncExtension(x.Ci64, yyxt173)
				} else {
					x.Ci64.CodecEncodeSelf(e)
				}
			} else {
				r.EncodeInt(0)
			}
			z.EncWriteArrayElem()
			if yyq2[70] {
				if x.Swrapbytes == nil {
					r.EncodeNil()
				} else {
					h.encSlicewrapBytes(([]wrapBytes)(x.Swrapbytes), e)
				} // end block: if x.Swrapbytes slice == nil
			} else {
				r.EncodeNil()
			}
			z.EncWriteArrayElem()
			if yyq2[71] {
				if x.Swrapuint8 == nil {
					r.EncodeNil()
				} else {
					h.encSlicewrapUint8(([]wrapUint8)(x.Swrapuint8), e)
				} // end block: if x.Swrapuint8 slice == nil
			} else {
				r.EncodeNil()
			}
			z.EncWriteArrayElem()
			if yyq2[72] {
				yy176 := &x.ArrStrUi64T
				h.encArray4stringUint64T((*[4]stringUint64T)(yy176), e)
			} else {
				r.EncodeNil()
			}
			z.EncWriteArrayElem()
			if yyq2[73] {
				yy178 := &x.Ui64array
				h.encArray4uint64((*[4]uint64)(yy178), e)
			} else {
				r.EncodeNil()
			}
			z.EncWriteArrayElem()
			if yyq2[74] {
				if x.Ui64slicearray == nil {
					r.EncodeNil()
				} else {
					h.encSlicePtrtoArray4uint64(([]*[4]uint64)(x.Ui64slicearray), e)
				} // end block: if x.Ui64slicearray slice == nil
			} else {
				r.EncodeNil()
			}
			z.EncWriteArrayElem()
			if yyq2[75] {
				if x.SintfAarray == nil {
					r.EncodeNil()
				} else {
					z.F.EncSliceIntfV(x.SintfAarray, e)
				} // end block: if x.SintfAarray slice == nil
			} else {
				r.EncodeNil()
			}
			z.EncWriteArrayElem()
			if yyq2[76] {
				if x.MstrUi64TSelf == nil {
					r.EncodeNil()
				} else {
					h.encMapstringUint64TPtrtostringUint64T((map[stringUint64T]*stringUint64T)(x.MstrUi64TSelf), e)
				} // end block: if x.MstrUi64TSelf map == nil
			} else {
				r.EncodeNil()
			}
			z.EncWriteArrayElem()
			if yyq2[77] {
				if z.EncBasicHandle().TimeBuiltin() {
					r.EncodeTime(x.Ttime)
				} else if yyxt183 := z.Extension(x.Ttime); yyxt183 != nil {
					z.EncExtension(x.Ttime, yyxt183)
				} else if z.EncBinary() {
					z.EncBinaryMarshal(x.Ttime)
				} else if !z.EncBinary() && z.IsJSONHandle() {
					z.EncJSONMarshal(x.Ttime)
				} else {
					z.EncFallback(x.Ttime)
				}
			} else {
				r.EncodeNil()
			}
			if yyn81 {
				z.EncWriteArrayElem()
				r.EncodeNil()
			} else {
				z.EncWriteArrayElem()
				if yyq2[78] {
					yy184 := *x.Ttimeptr
					if z.EncBasicHandle().TimeBuiltin() {
						r.EncodeTime(yy184)
					} else if yyxt185 := z.Extension(yy184); yyxt185 != nil {
						z.EncExtension(yy184, yyxt185)
					} else if z.EncBinary() {
						z.EncBinaryMarshal(yy184)
					} else if !z.EncBinary() && z.IsJSONHandle() {
						z.EncJSONMarshal(yy184)
					} else {
						z.EncFallback(yy184)
					}
				} else {
					r.EncodeNil()
				}
			}
			if yyn82 {
				z.EncWriteArrayElem()
				r.EncodeNil()
			} else {
				z.EncWriteArrayElem()
				if yyq2[79] {
					if x.AnonInTestStrucIntf.Islice == nil {
						r.EncodeNil()
					} else {
						z.F.EncSliceIntfV(x.AnonInTestStrucIntf.Islice, e)
					} // end block: if x.AnonInTestStrucIntf.Islice slice == nil
				} else {
					r.EncodeNil()
				}
			}
			if yyn83 {
				z.EncWriteArrayElem()
				r.EncodeNil()
			} else {
				z.EncWriteArrayElem()
				if yyq2[80] {
					if x.AnonInTestStrucIntf.Ms == nil {
						r.EncodeNil()
					} else {
						z.F.EncMapStringIntfV(x.AnonInTestStrucIntf.Ms, e)
					} // end block: if x.AnonInTestStrucIntf.Ms map == nil
				} else {
					r.EncodeNil()
				}
			}
			if yyn84 {
				z.EncWriteArrayElem()
				r.EncodeNil()
			} else {
				z.EncWriteArrayElem()
				if yyq2[81] {
					z.EncFallback(x.AnonInTestStrucIntf.Nintf)
				} else {
					r.EncodeNil()
				}
			}
			if yyn85 {
				z.EncWriteArrayElem()
				r.EncodeNil()
			} else {
				z.EncWriteArrayElem()
				if yyq2[82] {
					if z.EncBasicHandle().TimeBuiltin() {
						r.EncodeTime(x.AnonInTestStrucIntf.T)
					} else if yyxt189 := z.Extension(x.AnonInTestStrucIntf.T); yyxt189 != nil {
						z.EncExtension(x.AnonInTestStrucIntf.T, yyxt189)
					} else if z.EncBinary() {
						z.EncBinaryMarshal(x.AnonInTestStrucIntf.T)
					} else if !z.EncBinary() && z.IsJSONHandle() {
						z.EncJSONMarshal(x.AnonInTestStrucIntf.T)
					} else {
						z.EncFallback(x.AnonInTestStrucIntf.T)
					}
				} else {
					r.EncodeNil()
				}
			}
			if yyn86 {
				z.EncWriteArrayElem()
				r.EncodeNil()
			} else {
				z.EncWriteArrayElem()
				if yyq2[83] {
					yy190 := *x.AnonInTestStrucIntf.Tptr
					if z.EncBasicHandle().TimeBuiltin() {
						r.EncodeTime(yy190)
					} else if yyxt191 := z.Extension(yy190); yyxt191 != nil {
						z.EncExtension(yy190, yyxt191)
					} else if z.EncBinary() {
						z.EncBinaryMarshal(yy190)
					} else if !z.EncBinary() && z.IsJSONHandle() {
						z.EncJSONMarshal(yy190)
					} else {
						z.EncFallback(yy190)
					}
				} else {
					r.EncodeNil()
				}
			}
			z.EncWriteArrayElem()
			if yyq2[84] {
				if x.Msu == nil {
					r.EncodeNil()
				} else {
					h.encMapwrapStringInterface((map[wrapString]interface{})(x.Msu), e)
				} // end block: if x.Msu map == nil
			} else {
				r.EncodeNil()
			}
			z.EncWriteArrayElem()
			if yyq2[85] {
				if x.Mtsptr == nil {
					r.EncodeNil()
				} else {
					h.encMapstringPtrtoTestStrucFlex((map[string]*TestStrucFlex)(x.Mtsptr), e)
				} // end block: if x.Mtsptr map == nil
			} else {
				r.EncodeNil()
			}
			z.EncWriteArrayElem()
			if yyq2[86] {
				if x.Mts == nil {
					r.EncodeNil()
				} else {
					h.encMapstringTestStrucFlex((map[string]TestStrucFlex)(x.Mts), e)
				} // end block: if x.Mts map == nil
			} else {
				r.EncodeNil()
			}
			z.EncWriteArrayElem()
			if yyq2[87] {
				if x.Its == nil {
					r.EncodeNil()
				} else {
					h.encSlicePtrtoTestStrucFlex(([]*TestStrucFlex)(x.Its), e)
				} // end block: if x.Its slice == nil
			} else {
				r.EncodeNil()
			}
			if yyn91 {
				z.EncWriteArrayElem()
				r.EncodeNil()
			} else {
				z.EncWriteArrayElem()
				if yyq2[88] {
					if yyxt196 := z.Extension(x.Nteststruc); yyxt196 != nil {
						z.EncExtension(x.Nteststruc, yyxt196)
					} else {
						x.Nteststruc.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			}
			z.EncWriteArrayElem()
			if yyq2[89] {
				if yyxt197 := z.Extension(x.MarJ); yyxt197 != nil {
					z.EncExtension(x.MarJ, yyxt197)
				} else {
					x.MarJ.CodecEncodeSelf(e)
				}
			} else {
				r.EncodeBool(false)
			}
			z.EncWriteArrayElem()
			if yyq2[90] {
				if yyxt198 := z.Extension(x.MarT); yyxt198 != nil {
					z.EncExtension(x.MarT, yyxt198)
				} else {
					x.MarT.CodecEncodeSelf(e)
				}
			} else {
				r.EncodeString("")
			}
			z.EncWriteArrayElem()
			if yyq2[91] {
				if yyxt199 := z.Extension(x.MarB); yyxt199 != nil {
					z.EncExtension(x.MarB, yyxt199)
				} else {
					x.MarB.CodecEncodeSelf(e)
				}
			} else {
				r.EncodeNil()
			}
			z.EncWriteArrayElem()
			if yyq2[92] {
				if yyxt200 := z.Extension(x.XuintToBytes); yyxt200 != nil {
					z.EncExtension(x.XuintToBytes, yyxt200)
				} else {
					x.XuintToBytes.CodecEncodeSelf(e)
				}
			} else {
				r.EncodeUint(0)
			}
			z.EncWriteArrayElem()
			if yyq2[93] {
				z.EncEncodeComplex64(complex64(x.Cmplx64))
			} else {
				z.EncEncodeComplex64(0)
			}
			z.EncWriteArrayElem()
			if yyq2[94] {
				z.EncEncodeComplex128(complex128(x.Cmplx128))
			} else {
				z.EncEncodeComplex128(0)
			}
			z.EncWriteArrayEnd()
		} else {
			var yynn2 int
			for _, b := range yyq2 {
				if b {
					yynn2++
				}
			}
			z.EncWriteMapStart(yynn2)
			yynn2 = 0
			if z.EncBasicHandle().Canonical {
				if yyq2[41] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"AF32slice\"")
					} else {
						r.EncodeString(`AF32slice`)
					}
					z.EncWriteMapElemValue()
					if x.TestStrucCommon.AnonInTestStruc.AF32slice == nil {
						r.EncodeNil()
					} else {
						z.F.EncSliceFloat32V(x.TestStrucCommon.AnonInTestStruc.AF32slice, e)
					} // end block: if x.TestStrucCommon.AnonInTestStruc.AF32slice slice == nil
				}
				if yyq2[40] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"AF64slice\"")
					} else {
						r.EncodeString(`AF64slice`)
					}
					z.EncWriteMapElemValue()
					if x.TestStrucCommon.AnonInTestStruc.AF64slice == nil {
						r.EncodeNil()
					} else {
						z.F.EncSliceFloat64V(x.TestStrucCommon.AnonInTestStruc.AF64slice, e)
					} // end block: if x.TestStrucCommon.AnonInTestStruc.AF64slice slice == nil
				}
				if yyq2[35] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"AI16\"")
					} else {
						r.EncodeString(`AI16`)
					}
					z.EncWriteMapElemValue()
					r.EncodeInt(int64(x.TestStrucCommon.AnonInTestStruc.AI16))
				}
				if yyq2[34] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"AI64\"")
					} else {
						r.EncodeString(`AI64`)
					}
					z.EncWriteMapElemValue()
					r.EncodeInt(int64(x.TestStrucCommon.AnonInTestStruc.AI64))
				}
				if yyq2[45] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"AI64arr0\"")
					} else {
						r.EncodeString(`AI64arr0`)
					}
					z.EncWriteMapElemValue()
					yy207 := &x.TestStrucCommon.AnonInTestStruc.AI64arr0
					h.encArray0int64((*[0]int64)(yy207), e)
				}
				if yyq2[44] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"AI64arr8\"")
					} else {
						r.EncodeString(`AI64arr8`)
					}
					z.EncWriteMapElemValue()
					yy209 := &x.TestStrucCommon.AnonInTestStruc.AI64arr8
					h.encArray8int64((*[8]int64)(yy209), e)
				}
				if yyq2[38] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"AI64slice\"")
					} else {
						r.EncodeString(`AI64slice`)
					}
					z.EncWriteMapElemValue()
					if x.TestStrucCommon.AnonInTestStruc.AI64slice == nil {
						r.EncodeNil()
					} else {
						z.F.EncSliceInt64V(x.TestStrucCommon.AnonInTestStruc.AI64slice, e)
					} // end block: if x.TestStrucCommon.AnonInTestStruc.AI64slice slice == nil
				}
				if yyq2[46] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"AI64slice0\"")
					} else {
						r.EncodeString(`AI64slice0`)
					}
					z.EncWriteMapElemValue()
					if x.TestStrucCommon.AnonInTestStruc.AI64slice0 == nil {
						r.EncodeNil()
					} else {
						z.F.EncSliceInt64V(x.TestStrucCommon.AnonInTestStruc.AI64slice0, e)
					} // end block: if x.TestStrucCommon.AnonInTestStruc.AI64slice0 slice == nil
				}
				if yyq2[42] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"AMSS\"")
					} else {
						r.EncodeString(`AMSS`)
					}
					z.EncWriteMapElemValue()
					if x.TestStrucCommon.AnonInTestStruc.AMSS == nil {
						r.EncodeNil()
					} else {
						z.F.EncMapStringStringV(x.TestStrucCommon.AnonInTestStruc.AMSS, e)
					} // end block: if x.TestStrucCommon.AnonInTestStruc.AMSS map == nil
				}
				if yyq2[43] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"AMSU64\"")
					} else {
						r.EncodeString(`AMSU64`)
					}
					z.EncWriteMapElemValue()
					if x.TestStrucCommon.AnonInTestStruc.AMSU64 == nil {
						r.EncodeNil()
					} else {
						z.F.EncMapStringUint64V(x.TestStrucCommon.AnonInTestStruc.AMSU64, e)
					} // end block: if x.TestStrucCommon.AnonInTestStruc.AMSU64 map == nil
				}
				if yyq2[49] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"AMSU64E\"")
					} else {
						r.EncodeString(`AMSU64E`)
					}
					z.EncWriteMapElemValue()
					if x.TestStrucCommon.AnonInTestStruc.AMSU64E == nil {
						r.EncodeNil()
					} else {
						z.F.EncMapStringUint64V(x.TestStrucCommon.AnonInTestStruc.AMSU64E, e)
					} // end block: if x.TestStrucCommon.AnonInTestStruc.AMSU64E map == nil
				}
				if yyq2[48] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"AMSU64N\"")
					} else {
						r.EncodeString(`AMSU64N`)
					}
					z.EncWriteMapElemValue()
					if x.TestStrucCommon.AnonInTestStruc.AMSU64N == nil {
						r.EncodeNil()
					} else {
						z.F.EncMapStringUint64V(x.TestStrucCommon.AnonInTestStruc.AMSU64N, e)
					} // end block: if x.TestStrucCommon.AnonInTestStruc.AMSU64N map == nil
				}
				if yyq2[33] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"AS\"")
					} else {
						r.EncodeString(`AS`)
					}
					z.EncWriteMapElemValue()
					r.EncodeString(string(x.TestStrucCommon.AnonInTestStruc.AS))
				}
				if yyq2[37] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"ASslice\"")
					} else {
						r.EncodeString(`ASslice`)
					}
					z.EncWriteMapElemValue()
					if x.TestStrucCommon.AnonInTestStruc.ASslice == nil {
						r.EncodeNil()
					} else {
						z.F.EncSliceStringV(x.TestStrucCommon.AnonInTestStruc.ASslice, e)
					} // end block: if x.TestStrucCommon.AnonInTestStruc.ASslice slice == nil
				}
				if yyq2[36] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"AUi64\"")
					} else {
						r.EncodeString(`AUi64`)
					}
					z.EncWriteMapElemValue()
					r.EncodeUint(uint64(x.TestStrucCommon.AnonInTestStruc.AUi64))
				}
				if yyq2[39] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"AUi64slice\"")
					} else {
						r.EncodeString(`AUi64slice`)
					}
					z.EncWriteMapElemValue()
					if x.TestStrucCommon.AnonInTestStruc.AUi64slice == nil {
						r.EncodeNil()
					} else {
						z.F.EncSliceUint64V(x.TestStrucCommon.AnonInTestStruc.AUi64slice, e)
					} // end block: if x.TestStrucCommon.AnonInTestStruc.AUi64slice slice == nil
				}
				if yyq2[47] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"AUi64sliceN\"")
					} else {
						r.EncodeString(`AUi64sliceN`)
					}
					z.EncWriteMapElemValue()
					if x.TestStrucCommon.AnonInTestStruc.AUi64sliceN == nil {
						r.EncodeNil()
					} else {
						z.F.EncSliceUint64V(x.TestStrucCommon.AnonInTestStruc.AUi64sliceN, e)
					} // end block: if x.TestStrucCommon.AnonInTestStruc.AUi64sliceN slice == nil
				}
				if yyq2[72] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"ArrStrUi64T\"")
					} else {
						r.EncodeString(`ArrStrUi64T`)
					}
					z.EncWriteMapElemValue()
					yy222 := &x.ArrStrUi64T
					h.encArray4stringUint64T((*[4]stringUint64T)(yy222), e)
				}
				if yyq2[15] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"B\"")
					} else {
						r.EncodeString(`B`)
					}
					z.EncWriteMapElemValue()
					r.EncodeBool(bool(x.TestStrucCommon.B))
				}
				if yyq2[22] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"Bslice\"")
					} else {
						r.EncodeString(`Bslice`)
					}
					z.EncWriteMapElemValue()
					if x.TestStrucCommon.Bslice == nil {
						r.EncodeNil()
					} else {
						z.F.EncSliceBoolV(x.TestStrucCommon.Bslice, e)
					} // end block: if x.TestStrucCommon.Bslice slice == nil
				}
				if yyq2[16] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"By\"")
					} else {
						r.EncodeString(`By`)
					}
					z.EncWriteMapElemValue()
					r.EncodeUint(uint64(x.TestStrucCommon.By))
				}
				if yyq2[23] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"Byslice\"")
					} else {
						r.EncodeString(`Byslice`)
					}
					z.EncWriteMapElemValue()
					if x.TestStrucCommon.Byslice == nil {
						r.EncodeNil()
					} else {
						r.EncodeStringBytesRaw([]byte(x.TestStrucCommon.Byslice))
					} // end block: if x.TestStrucCommon.Byslice slice == nil
				}
				if yyq2[24] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"BytesSlice\"")
					} else {
						r.EncodeString(`BytesSlice`)
					}
					z.EncWriteMapElemValue()
					if x.TestStrucCommon.BytesSlice == nil {
						r.EncodeNil()
					} else {
						z.F.EncSliceBytesV(x.TestStrucCommon.BytesSlice, e)
					} // end block: if x.TestStrucCommon.BytesSlice slice == nil
				}
				if yyq2[56] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"Chstr\"")
					} else {
						r.EncodeString(`Chstr`)
					}
					z.EncWriteMapElemValue()
					h.encChanstring((chan string)(x.Chstr), e)
				}
				if yyq2[69] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"Ci64\"")
					} else {
						r.EncodeString(`Ci64`)
					}
					z.EncWriteMapElemValue()
					if yyxt230 := z.Extension(x.Ci64); yyxt230 != nil {
						z.EncExtension(x.Ci64, yyxt230)
					} else {
						x.Ci64.CodecEncodeSelf(e)
					}
				}
				if yyq2[94] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"Cmplx128\"")
					} else {
						r.EncodeString(`Cmplx128`)
					}
					z.EncWriteMapElemValue()
					z.EncEncodeComplex128(complex128(x.Cmplx128))
				}
				if yyq2[93] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"Cmplx64\"")
					} else {
						r.EncodeString(`Cmplx64`)
					}
					z.EncWriteMapElemValue()
					z.EncEncodeComplex64(complex64(x.Cmplx64))
				}
				if yyq2[14] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"F32\"")
					} else {
						r.EncodeString(`F32`)
					}
					z.EncWriteMapElemValue()
					r.EncodeFloat32(float32(x.TestStrucCommon.F32))
				}
				if yyq2[13] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"F64\"")
					} else {
						r.EncodeString(`F64`)
					}
					z.EncWriteMapElemValue()
					r.EncodeFloat64(float64(x.TestStrucCommon.F64))
				}
				if yyq2[3] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"I16\"")
					} else {
						r.EncodeString(`I16`)
					}
					z.EncWriteMapElemValue()
					r.EncodeInt(int64(x.TestStrucCommon.I16))
				}
				if yyq2[7] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"I16n\"")
					} else {
						r.EncodeString(`I16n`)
					}
					z.EncWriteMapElemValue()
					r.EncodeInt(int64(x.TestStrucCommon.I16n))
				}
				if yyq2[2] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"I32\"")
					} else {
						r.EncodeString(`I32`)
					}
					z.EncWriteMapElemValue()
					r.EncodeInt(int64(x.TestStrucCommon.I32))
				}
				if yyq2[6] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"I32n\"")
					} else {
						r.EncodeString(`I32n`)
					}
					z.EncWriteMapElemValue()
					r.EncodeInt(int64(x.TestStrucCommon.I32n))
				}
				if yyq2[19] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"I32slice\"")
					} else {
						r.EncodeString(`I32slice`)
					}
					z.EncWriteMapElemValue()
					if x.TestStrucCommon.I32slice == nil {
						r.EncodeNil()
					} else {
						z.F.EncSliceInt32V(x.TestStrucCommon.I32slice, e)
					} // end block: if x.TestStrucCommon.I32slice slice == nil
				}
				if yyq2[1] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"I64\"")
					} else {
						r.EncodeString(`I64`)
					}
					z.EncWriteMapElemValue()
					r.EncodeInt(int64(x.TestStrucCommon.I64))
				}
				if yyq2[5] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"I64n\"")
					} else {
						r.EncodeString(`I64n`)
					}
					z.EncWriteMapElemValue()
					r.EncodeInt(int64(x.TestStrucCommon.I64n))
				}
				if yyq2[18] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"I64slice\"")
					} else {
						r.EncodeString(`I64slice`)
					}
					z.EncWriteMapElemValue()
					if x.TestStrucCommon.I64slice == nil {
						r.EncodeNil()
					} else {
						z.F.EncSliceInt64V(x.TestStrucCommon.I64slice, e)
					} // end block: if x.TestStrucCommon.I64slice slice == nil
				}
				if yyq2[4] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"I8\"")
					} else {
						r.EncodeString(`I8`)
					}
					z.EncWriteMapElemValue()
					r.EncodeInt(int64(x.TestStrucCommon.I8))
				}
				if yyq2[8] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"I8n\"")
					} else {
						r.EncodeString(`I8n`)
					}
					z.EncWriteMapElemValue()
					r.EncodeInt(int64(x.TestStrucCommon.I8n))
				}
				if yyq2[25] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"Iptrslice\"")
					} else {
						r.EncodeString(`Iptrslice`)
					}
					z.EncWriteMapElemValue()
					if x.TestStrucCommon.Iptrslice == nil {
						r.EncodeNil()
					} else {
						h.encSlicePtrtoint64(([]*int64)(x.TestStrucCommon.Iptrslice), e)
					} // end block: if x.TestStrucCommon.Iptrslice slice == nil
				}
				if yyq2[79] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"Islice\"")
					} else {
						r.EncodeString(`Islice`)
					}
					z.EncWriteMapElemValue()
					if yyn82 {
						r.EncodeNil()
					} else {
						if x.AnonInTestStrucIntf.Islice == nil {
							r.EncodeNil()
						} else {
							z.F.EncSliceIntfV(x.AnonInTestStrucIntf.Islice, e)
						} // end block: if x.AnonInTestStrucIntf.Islice slice == nil
					}
				}
				if yyq2[87] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"Its\"")
					} else {
						r.EncodeString(`Its`)
					}
					z.EncWriteMapElemValue()
					if x.Its == nil {
						r.EncodeNil()
					} else {
						h.encSlicePtrtoTestStrucFlex(([]*TestStrucFlex)(x.Its), e)
					} // end block: if x.Its slice == nil
				}
				if yyq2[91] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"MarB\"")
					} else {
						r.EncodeString(`MarB`)
					}
					z.EncWriteMapElemValue()
					if yyxt248 := z.Extension(x.MarB); yyxt248 != nil {
						z.EncExtension(x.MarB, yyxt248)
					} else {
						x.MarB.CodecEncodeSelf(e)
					}
				}
				if yyq2[89] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"MarJ\"")
					} else {
						r.EncodeString(`MarJ`)
					}
					z.EncWriteMapElemValue()
					if yyxt249 := z.Extension(x.MarJ); yyxt249 != nil {
						z.EncExtension(x.MarJ, yyxt249)
					} else {
						x.MarJ.CodecEncodeSelf(e)
					}
				}
				if yyq2[90] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"MarT\"")
					} else {
						r.EncodeString(`MarT`)
					}
					z.EncWriteMapElemValue()
					if yyxt250 := z.Extension(x.MarT); yyxt250 != nil {
						z.EncExtension(x.MarT, yyxt250)
					} else {
						x.MarT.CodecEncodeSelf(e)
					}
				}
				if yyq2[58] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"Mbu64\"")
					} else {
						r.EncodeString(`Mbu64`)
					}
					z.EncWriteMapElemValue()
					if x.Mbu64 == nil {
						r.EncodeNil()
					} else {
						h.encMapboolc3RydWN0IHt9((map[bool]struct{})(x.Mbu64), e)
					} // end block: if x.Mbu64 map == nil
				}
				if yyq2[66] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"Mf32wss\"")
					} else {
						r.EncodeString(`Mf32wss`)
					}
					z.EncWriteMapElemValue()
					if x.Mf32wss == nil {
						r.EncodeNil()
					} else {
						h.encMapfloat32wrapStringSlice((map[float32]wrapStringSlice)(x.Mf32wss), e)
					} // end block: if x.Mf32wss map == nil
				}
				if yyq2[65] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"Mfwss\"")
					} else {
						r.EncodeString(`Mfwss`)
					}
					z.EncWriteMapElemValue()
					if x.Mfwss == nil {
						r.EncodeNil()
					} else {
						h.encMapfloat64wrapStringSlice((map[float64]wrapStringSlice)(x.Mfwss), e)
					} // end block: if x.Mfwss map == nil
				}
				if yyq2[62] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"Mip2ss\"")
					} else {
						r.EncodeString(`Mip2ss`)
					}
					z.EncWriteMapElemValue()
					if x.Mip2ss == nil {
						r.EncodeNil()
					} else {
						h.encMapPtrtouint64Slicestring((map[*uint64][]string)(x.Mip2ss), e)
					} // end block: if x.Mip2ss map == nil
				}
				if yyq2[57] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"Mis\"")
					} else {
						r.EncodeString(`Mis`)
					}
					z.EncWriteMapElemValue()
					if x.Mis == nil {
						r.EncodeNil()
					} else {
						z.F.EncMapIntStringV(x.Mis, e)
					} // end block: if x.Mis map == nil
				}
				if yyq2[64] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"Miwu64s\"")
					} else {
						r.EncodeString(`Miwu64s`)
					}
					z.EncWriteMapElemValue()
					if x.Miwu64s == nil {
						r.EncodeNil()
					} else {
						h.encMapintwrapUint64Slice((map[int]wrapUint64Slice)(x.Miwu64s), e)
					} // end block: if x.Miwu64s map == nil
				}
				if yyq2[80] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"Ms\"")
					} else {
						r.EncodeString(`Ms`)
					}
					z.EncWriteMapElemValue()
					if yyn83 {
						r.EncodeNil()
					} else {
						if x.AnonInTestStrucIntf.Ms == nil {
							r.EncodeNil()
						} else {
							z.F.EncMapStringIntfV(x.AnonInTestStrucIntf.Ms, e)
						} // end block: if x.AnonInTestStrucIntf.Ms map == nil
					}
				}
				if yyq2[63] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"Ms2misu\"")
					} else {
						r.EncodeString(`Ms2misu`)
					}
					z.EncWriteMapElemValue()
					if x.Ms2misu == nil {
						r.EncodeNil()
					} else {
						h.encMapstringMapuint64stringUint64T((map[string]map[uint64]stringUint64T)(x.Ms2misu), e)
					} // end block: if x.Ms2misu map == nil
				}
				if yyq2[29] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"Msbytes\"")
					} else {
						r.EncodeString(`Msbytes`)
					}
					z.EncWriteMapElemValue()
					if x.TestStrucCommon.Msbytes == nil {
						r.EncodeNil()
					} else {
						z.F.EncMapStringBytesV(x.TestStrucCommon.Msbytes, e)
					} // end block: if x.TestStrucCommon.Msbytes map == nil
				}
				if yyq2[28] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"Msint\"")
					} else {
						r.EncodeString(`Msint`)
					}
					z.EncWriteMapElemValue()
					if x.TestStrucCommon.Msint == nil {
						r.EncodeNil()
					} else {
						z.F.EncMapStringIntV(x.TestStrucCommon.Msint, e)
					} // end block: if x.TestStrucCommon.Msint map == nil
				}
				if yyq2[61] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"Msp2ss\"")
					} else {
						r.EncodeString(`Msp2ss`)
					}
					z.EncWriteMapElemValue()
					if x.Msp2ss == nil {
						r.EncodeNil()
					} else {
						h.encMapPtrtostringSlicestring((map[*string][]string)(x.Msp2ss), e)
					} // end block: if x.Msp2ss map == nil
				}
				if yyq2[32] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"MstrUi64T\"")
					} else {
						r.EncodeString(`MstrUi64T`)
					}
					z.EncWriteMapElemValue()
					if x.TestStrucCommon.MstrUi64T == nil {
						r.EncodeNil()
					} else {
						h.encMapstringPtrtostringUint64T((map[string]*stringUint64T)(x.TestStrucCommon.MstrUi64T), e)
					} // end block: if x.TestStrucCommon.MstrUi64T map == nil
				}
				if yyq2[76] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"MstrUi64TSelf\"")
					} else {
						r.EncodeString(`MstrUi64TSelf`)
					}
					z.EncWriteMapElemValue()
					if x.MstrUi64TSelf == nil {
						r.EncodeNil()
					} else {
						h.encMapstringUint64TPtrtostringUint64T((map[stringUint64T]*stringUint64T)(x.MstrUi64TSelf), e)
					} // end block: if x.MstrUi64TSelf map == nil
				}
				if yyq2[84] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"Msu\"")
					} else {
						r.EncodeString(`Msu`)
					}
					z.EncWriteMapElemValue()
					if x.Msu == nil {
						r.EncodeNil()
					} else {
						h.encMapwrapStringInterface((map[wrapString]interface{})(x.Msu), e)
					} // end block: if x.Msu map == nil
				}
				if yyq2[68] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"Msu2wss\"")
					} else {
						r.EncodeString(`Msu2wss`)
					}
					z.EncWriteMapElemValue()
					if x.Msu2wss == nil {
						r.EncodeNil()
					} else {
						h.encMapstringUint64TwrapStringSlice((map[stringUint64T]wrapStringSlice)(x.Msu2wss), e)
					} // end block: if x.Msu2wss map == nil
				}
				if yyq2[86] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"Mts\"")
					} else {
						r.EncodeString(`Mts`)
					}
					z.EncWriteMapElemValue()
					if x.Mts == nil {
						r.EncodeNil()
					} else {
						h.encMapstringTestStrucFlex((map[string]TestStrucFlex)(x.Mts), e)
					} // end block: if x.Mts map == nil
				}
				if yyq2[85] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"Mtsptr\"")
					} else {
						r.EncodeString(`Mtsptr`)
					}
					z.EncWriteMapElemValue()
					if x.Mtsptr == nil {
						r.EncodeNil()
					} else {
						h.encMapstringPtrtoTestStrucFlex((map[string]*TestStrucFlex)(x.Mtsptr), e)
					} // end block: if x.Mtsptr map == nil
				}
				if yyq2[59] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"Mu8e\"")
					} else {
						r.EncodeString(`Mu8e`)
					}
					z.EncWriteMapElemValue()
					if x.Mu8e == nil {
						r.EncodeNil()
					} else {
						h.encMapuint8c3RydWN0IHt9((map[uint8]struct{})(x.Mu8e), e)
					} // end block: if x.Mu8e map == nil
				}
				if yyq2[60] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"Mu8u64\"")
					} else {
						r.EncodeString(`Mu8u64`)
					}
					z.EncWriteMapElemValue()
					if x.Mu8u64 == nil {
						r.EncodeNil()
					} else {
						h.encMapuint8stringUint64T((map[uint8]stringUint64T)(x.Mu8u64), e)
					} // end block: if x.Mu8u64 map == nil
				}
				if yyq2[67] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"Mui2wss\"")
					} else {
						r.EncodeString(`Mui2wss`)
					}
					z.EncWriteMapElemValue()
					if x.Mui2wss == nil {
						r.EncodeNil()
					} else {
						h.encMapuint64wrapStringSlice((map[uint64]wrapStringSlice)(x.Mui2wss), e)
					} // end block: if x.Mui2wss map == nil
				}
				if yyq2[55] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"Nint64\"")
					} else {
						r.EncodeString(`Nint64`)
					}
					z.EncWriteMapElemValue()
					if yyn58 {
						r.EncodeNil()
					} else {
						yy271 := *x.TestStrucCommon.Nint64
						r.EncodeInt(int64(yy271))
					}
				}
				if yyq2[81] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"Nintf\"")
					} else {
						r.EncodeString(`Nintf`)
					}
					z.EncWriteMapElemValue()
					if yyn84 {
						r.EncodeNil()
					} else {
						z.EncFallback(x.AnonInTestStrucIntf.Nintf)
					}
				}
				if yyq2[53] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"Nmap\"")
					} else {
						r.EncodeString(`Nmap`)
					}
					z.EncWriteMapElemValue()
					if x.TestStrucCommon.Nmap == nil {
						r.EncodeNil()
					} else {
						z.F.EncMapStringBoolV(x.TestStrucCommon.Nmap, e)
					} // end block: if x.TestStrucCommon.Nmap map == nil
				}
				if yyq2[50] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"NotAnon\"")
					} else {
						r.EncodeString(`NotAnon`)
					}
					z.EncWriteMapElemValue()
					yy275 := &x.TestStrucCommon.NotAnon
					if yyxt276 := z.Extension(yy275); yyxt276 != nil {
						z.EncExtension(yy275, yyxt276)
					} else {
						yy275.CodecEncodeSelf(e)
					}
				}
				if yyq2[52] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"NotAnonSlim\"")
					} else {
						r.EncodeString(`NotAnonSlim`)
					}
					z.EncWriteMapElemValue()
					if yyn55 {
						r.EncodeNil()
					} else {
						if yyxt277 := z.Extension(x.TestStrucCommon.NotAnonSlim); yyxt277 != nil {
							z.EncExtension(x.TestStrucCommon.NotAnonSlim, yyxt277)
						} else {
							x.TestStrucCommon.NotAnonSlim.CodecEncodeSelf(e)
						}
					}
				}
				if yyq2[54] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"Nslice\"")
					} else {
						r.EncodeString(`Nslice`)
					}
					z.EncWriteMapElemValue()
					if x.TestStrucCommon.Nslice == nil {
						r.EncodeNil()
					} else {
						r.EncodeStringBytesRaw([]byte(x.TestStrucCommon.Nslice))
					} // end block: if x.TestStrucCommon.Nslice slice == nil
				}
				if yyq2[88] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"Nteststruc\"")
					} else {
						r.EncodeString(`Nteststruc`)
					}
					z.EncWriteMapElemValue()
					if yyn91 {
						r.EncodeNil()
					} else {
						if yyxt279 := z.Extension(x.Nteststruc); yyxt279 != nil {
							z.EncExtension(x.Nteststruc, yyxt279)
						} else {
							x.Nteststruc.CodecEncodeSelf(e)
						}
					}
				}
				if yyq2[51] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"P\"")
					} else {
						r.EncodeString(`P`)
					}
					z.EncWriteMapElemValue()
					if yyn54 {
						r.EncodeNil()
					} else {
						yy280 := *x.TestStrucCommon.AnonInTestStrucSlim.P
						r.EncodeString(string(yy280))
					}
				}
				if yyq2[0] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"S\"")
					} else {
						r.EncodeString(`S`)
					}
					z.EncWriteMapElemValue()
					r.EncodeString(string(x.TestStrucCommon.S))
				}
				if yyq2[30] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"Simplef\"")
					} else {
						r.EncodeString(`Simplef`)
					}
					z.EncWriteMapElemValue()
					yy283 := &x.TestStrucCommon.Simplef
					if yyxt284 := z.Extension(yy283); yyxt284 != nil {
						z.EncExtension(yy283, yyxt284)
					} else {
						yy283.CodecEncodeSelf(e)
					}
				}
				if yyq2[75] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"SintfAarray\"")
					} else {
						r.EncodeString(`SintfAarray`)
					}
					z.EncWriteMapElemValue()
					if x.SintfAarray == nil {
						r.EncodeNil()
					} else {
						z.F.EncSliceIntfV(x.SintfAarray, e)
					} // end block: if x.SintfAarray slice == nil
				}
				if yyq2[17] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"Sslice\"")
					} else {
						r.EncodeString(`Sslice`)
					}
					z.EncWriteMapElemValue()
					if x.TestStrucCommon.Sslice == nil {
						r.EncodeNil()
					} else {
						z.F.EncSliceStringV(x.TestStrucCommon.Sslice, e)
					} // end block: if x.TestStrucCommon.Sslice slice == nil
				}
				if yyq2[31] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"SstrUi64T\"")
					} else {
						r.EncodeString(`SstrUi64T`)
					}
					z.EncWriteMapElemValue()
					if x.TestStrucCommon.SstrUi64T == nil {
						r.EncodeNil()
					} else {
						h.encSlicestringUint64T(([]stringUint64T)(x.TestStrucCommon.SstrUi64T), e)
					} // end block: if x.TestStrucCommon.SstrUi64T slice == nil
				}
				if yyq2[70] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"Swrapbytes\"")
					} else {
						r.EncodeString(`Swrapbytes`)
					}
					z.EncWriteMapElemValue()
					if x.Swrapbytes == nil {
						r.EncodeNil()
					} else {
						h.encSlicewrapBytes(([]wrapBytes)(x.Swrapbytes), e)
					} // end block: if x.Swrapbytes slice == nil
				}
				if yyq2[71] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"Swrapuint8\"")
					} else {
						r.EncodeString(`Swrapuint8`)
					}
					z.EncWriteMapElemValue()
					if x.Swrapuint8 == nil {
						r.EncodeNil()
					} else {
						h.encSlicewrapUint8(([]wrapUint8)(x.Swrapuint8), e)
					} // end block: if x.Swrapuint8 slice == nil
				}
				if yyq2[82] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"T\"")
					} else {
						r.EncodeString(`T`)
					}
					z.EncWriteMapElemValue()
					if yyn85 {
						r.EncodeNil()
					} else {
						if z.EncBasicHandle().TimeBuiltin() {
							r.EncodeTime(x.AnonInTestStrucIntf.T)
						} else if yyxt290 := z.Extension(x.AnonInTestStrucIntf.T); yyxt290 != nil {
							z.EncExtension(x.AnonInTestStrucIntf.T, yyxt290)
						} else if z.EncBinary() {
							z.EncBinaryMarshal(x.AnonInTestStrucIntf.T)
						} else if !z.EncBinary() && z.IsJSONHandle() {
							z.EncJSONMarshal(x.AnonInTestStrucIntf.T)
						} else {
							z.EncFallback(x.AnonInTestStrucIntf.T)
						}
					}
				}
				if yyq2[83] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"Tptr\"")
					} else {
						r.EncodeString(`Tptr`)
					}
					z.EncWriteMapElemValue()
					if yyn86 {
						r.EncodeNil()
					} else {
						yy291 := *x.AnonInTestStrucIntf.Tptr
						if z.EncBasicHandle().TimeBuiltin() {
							r.EncodeTime(yy291)
						} else if yyxt292 := z.Extension(yy291); yyxt292 != nil {
							z.EncExtension(yy291, yyxt292)
						} else if z.EncBinary() {
							z.EncBinaryMarshal(yy291)
						} else if !z.EncBinary() && z.IsJSONHandle() {
							z.EncJSONMarshal(yy291)
						} else {
							z.EncFallback(yy291)
						}
					}
				}
				if yyq2[77] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"Ttime\"")
					} else {
						r.EncodeString(`Ttime`)
					}
					z.EncWriteMapElemValue()
					if z.EncBasicHandle().TimeBuiltin() {
						r.EncodeTime(x.Ttime)
					} else if yyxt293 := z.Extension(x.Ttime); yyxt293 != nil {
						z.EncExtension(x.Ttime, yyxt293)
					} else if z.EncBinary() {
						z.EncBinaryMarshal(x.Ttime)
					} else if !z.EncBinary() && z.IsJSONHandle() {
						z.EncJSONMarshal(x.Ttime)
					} else {
						z.EncFallback(x.Ttime)
					}
				}
				if yyq2[78] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"Ttimeptr\"")
					} else {
						r.EncodeString(`Ttimeptr`)
					}
					z.EncWriteMapElemValue()
					if yyn81 {
						r.EncodeNil()
					} else {
						yy294 := *x.Ttimeptr
						if z.EncBasicHandle().TimeBuiltin() {
							r.EncodeTime(yy294)
						} else if yyxt295 := z.Extension(yy294); yyxt295 != nil {
							z.EncExtension(yy294, yyxt295)
						} else if z.EncBinary() {
							z.EncBinaryMarshal(yy294)
						} else if !z.EncBinary() && z.IsJSONHandle() {
							z.EncJSONMarshal(yy294)
						} else {
							z.EncFallback(yy294)
						}
					}
				}
				if yyq2[11] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"Ui16\"")
					} else {
						r.EncodeString(`Ui16`)
					}
					z.EncWriteMapElemValue()
					r.EncodeUint(uint64(x.TestStrucCommon.Ui16))
				}
				if yyq2[10] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"Ui32\"")
					} else {
						r.EncodeString(`Ui32`)
					}
					z.EncWriteMapElemValue()
					r.EncodeUint(uint64(x.TestStrucCommon.Ui32))
				}
				if yyq2[9] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"Ui64\"")
					} else {
						r.EncodeString(`Ui64`)
					}
					z.EncWriteMapElemValue()
					r.EncodeUint(uint64(x.TestStrucCommon.Ui64))
				}
				if yyq2[73] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"Ui64array\"")
					} else {
						r.EncodeString(`Ui64array`)
					}
					z.EncWriteMapElemValue()
					yy299 := &x.Ui64array
					h.encArray4uint64((*[4]uint64)(yy299), e)
				}
				if yyq2[20] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"Ui64slice\"")
					} else {
						r.EncodeString(`Ui64slice`)
					}
					z.EncWriteMapElemValue()
					if x.TestStrucCommon.Ui64slice == nil {
						r.EncodeNil()
					} else {
						z.F.EncSliceUint64V(x.TestStrucCommon.Ui64slice, e)
					} // end block: if x.TestStrucCommon.Ui64slice slice == nil
				}
				if yyq2[74] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"Ui64slicearray\"")
					} else {
						r.EncodeString(`Ui64slicearray`)
					}
					z.EncWriteMapElemValue()
					if x.Ui64slicearray == nil {
						r.EncodeNil()
					} else {
						h.encSlicePtrtoArray4uint64(([]*[4]uint64)(x.Ui64slicearray), e)
					} // end block: if x.Ui64slicearray slice == nil
				}
				if yyq2[12] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"Ui8\"")
					} else {
						r.EncodeString(`Ui8`)
					}
					z.EncWriteMapElemValue()
					r.EncodeUint(uint64(x.TestStrucCommon.Ui8))
				}
				if yyq2[21] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"Ui8slice\"")
					} else {
						r.EncodeString(`Ui8slice`)
					}
					z.EncWriteMapElemValue()
					if x.TestStrucCommon.Ui8slice == nil {
						r.EncodeNil()
					} else {
						r.EncodeStringBytesRaw([]byte(x.TestStrucCommon.Ui8slice))
					} // end block: if x.TestStrucCommon.Ui8slice slice == nil
				}
				if yyq2[26] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"WrapSliceInt64\"")
					} else {
						r.EncodeString(`WrapSliceInt64`)
					}
					z.EncWriteMapElemValue()
					if yyxt305 := z.Extension(x.TestStrucCommon.WrapSliceInt64); yyxt305 != nil {
						z.EncExtension(x.TestStrucCommon.WrapSliceInt64, yyxt305)
					} else {
						x.TestStrucCommon.WrapSliceInt64.CodecEncodeSelf(e)
					}
				}
				if yyq2[27] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"WrapSliceString\"")
					} else {
						r.EncodeString(`WrapSliceString`)
					}
					z.EncWriteMapElemValue()
					if yyxt306 := z.Extension(x.TestStrucCommon.WrapSliceString); yyxt306 != nil {
						z.EncExtension(x.TestStrucCommon.WrapSliceString, yyxt306)
					} else {
						x.TestStrucCommon.WrapSliceString.CodecEncodeSelf(e)
					}
				}
				if yyq2[92] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"XuintToBytes\"")
					} else {
						r.EncodeString(`XuintToBytes`)
					}
					z.EncWriteMapElemValue()
					if yyxt307 := z.Extension(x.XuintToBytes); yyxt307 != nil {
						z.EncExtension(x.XuintToBytes, yyxt307)
					} else {
						x.XuintToBytes.CodecEncodeSelf(e)
					}
				}
			} else {
				if yyq2[0] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"S\"")
					} else {
						r.EncodeString(`S`)
					}
					z.EncWriteMapElemValue()
					r.EncodeString(string(x.TestStrucCommon.S))
				}
				if yyq2[1] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"I64\"")
					} else {
						r.EncodeString(`I64`)
					}
					z.EncWriteMapElemValue()
					r.EncodeInt(int64(x.TestStrucCommon.I64))
				}
				if yyq2[2] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"I32\"")
					} else {
						r.EncodeString(`I32`)
					}
					z.EncWriteMapElemValue()
					r.EncodeInt(int64(x.TestStrucCommon.I32))
				}
				if yyq2[3] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"I16\"")
					} else {
						r.EncodeString(`I16`)
					}
					z.EncWriteMapElemValue()
					r.EncodeInt(int64(x.TestStrucCommon.I16))
				}
				if yyq2[4] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"I8\"")
					} else {
						r.EncodeString(`I8`)
					}
					z.EncWriteMapElemValue()
					r.EncodeInt(int64(x.TestStrucCommon.I8))
				}
				if yyq2[5] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"I64n\"")
					} else {
						r.EncodeString(`I64n`)
					}
					z.EncWriteMapElemValue()
					r.EncodeInt(int64(x.TestStrucCommon.I64n))
				}
				if yyq2[6] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"I32n\"")
					} else {
						r.EncodeString(`I32n`)
					}
					z.EncWriteMapElemValue()
					r.EncodeInt(int64(x.TestStrucCommon.I32n))
				}
				if yyq2[7] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"I16n\"")
					} else {
						r.EncodeString(`I16n`)
					}
					z.EncWriteMapElemValue()
					r.EncodeInt(int64(x.TestStrucCommon.I16n))
				}
				if yyq2[8] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"I8n\"")
					} else {
						r.EncodeString(`I8n`)
					}
					z.EncWriteMapElemValue()
					r.EncodeInt(int64(x.TestStrucCommon.I8n))
				}
				if yyq2[9] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"Ui64\"")
					} else {
						r.EncodeString(`Ui64`)
					}
					z.EncWriteMapElemValue()
					r.EncodeUint(uint64(x.TestStrucCommon.Ui64))
				}
				if yyq2[10] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"Ui32\"")
					} else {
						r.EncodeString(`Ui32`)
					}
					z.EncWriteMapElemValue()
					r.EncodeUint(uint64(x.TestStrucCommon.Ui32))
				}
				if yyq2[11] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"Ui16\"")
					} else {
						r.EncodeString(`Ui16`)
					}
					z.EncWriteMapElemValue()
					r.EncodeUint(uint64(x.TestStrucCommon.Ui16))
				}
				if yyq2[12] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"Ui8\"")
					} else {
						r.EncodeString(`Ui8`)
					}
					z.EncWriteMapElemValue()
					r.EncodeUint(uint64(x.TestStrucCommon.Ui8))
				}
				if yyq2[13] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"F64\"")
					} else {
						r.EncodeString(`F64`)
					}
					z.EncWriteMapElemValue()
					r.EncodeFloat64(float64(x.TestStrucCommon.F64))
				}
				if yyq2[14] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"F32\"")
					} else {
						r.EncodeString(`F32`)
					}
					z.EncWriteMapElemValue()
					r.EncodeFloat32(float32(x.TestStrucCommon.F32))
				}
				if yyq2[15] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"B\"")
					} else {
						r.EncodeString(`B`)
					}
					z.EncWriteMapElemValue()
					r.EncodeBool(bool(x.TestStrucCommon.B))
				}
				if yyq2[16] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"By\"")
					} else {
						r.EncodeString(`By`)
					}
					z.EncWriteMapElemValue()
					r.EncodeUint(uint64(x.TestStrucCommon.By))
				}
				if yyq2[17] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"Sslice\"")
					} else {
						r.EncodeString(`Sslice`)
					}
					z.EncWriteMapElemValue()
					if x.TestStrucCommon.Sslice == nil {
						r.EncodeNil()
					} else {
						z.F.EncSliceStringV(x.TestStrucCommon.Sslice, e)
					} // end block: if x.TestStrucCommon.Sslice slice == nil
				}
				if yyq2[18] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"I64slice\"")
					} else {
						r.EncodeString(`I64slice`)
					}
					z.EncWriteMapElemValue()
					if x.TestStrucCommon.I64slice == nil {
						r.EncodeNil()
					} else {
						z.F.EncSliceInt64V(x.TestStrucCommon.I64slice, e)
					} // end block: if x.TestStrucCommon.I64slice slice == nil
				}
				if yyq2[19] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"I32slice\"")
					} else {
						r.EncodeString(`I32slice`)
					}
					z.EncWriteMapElemValue()
					if x.TestStrucCommon.I32slice == nil {
						r.EncodeNil()
					} else {
						z.F.EncSliceInt32V(x.TestStrucCommon.I32slice, e)
					} // end block: if x.TestStrucCommon.I32slice slice == nil
				}
				if yyq2[20] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"Ui64slice\"")
					} else {
						r.EncodeString(`Ui64slice`)
					}
					z.EncWriteMapElemValue()
					if x.TestStrucCommon.Ui64slice == nil {
						r.EncodeNil()
					} else {
						z.F.EncSliceUint64V(x.TestStrucCommon.Ui64slice, e)
					} // end block: if x.TestStrucCommon.Ui64slice slice == nil
				}
				if yyq2[21] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"Ui8slice\"")
					} else {
						r.EncodeString(`Ui8slice`)
					}
					z.EncWriteMapElemValue()
					if x.TestStrucCommon.Ui8slice == nil {
						r.EncodeNil()
					} else {
						r.EncodeStringBytesRaw([]byte(x.TestStrucCommon.Ui8slice))
					} // end block: if x.TestStrucCommon.Ui8slice slice == nil
				}
				if yyq2[22] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"Bslice\"")
					} else {
						r.EncodeString(`Bslice`)
					}
					z.EncWriteMapElemValue()
					if x.TestStrucCommon.Bslice == nil {
						r.EncodeNil()
					} else {
						z.F.EncSliceBoolV(x.TestStrucCommon.Bslice, e)
					} // end block: if x.TestStrucCommon.Bslice slice == nil
				}
				if yyq2[23] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"Byslice\"")
					} else {
						r.EncodeString(`Byslice`)
					}
					z.EncWriteMapElemValue()
					if x.TestStrucCommon.Byslice == nil {
						r.EncodeNil()
					} else {
						r.EncodeStringBytesRaw([]byte(x.TestStrucCommon.Byslice))
					} // end block: if x.TestStrucCommon.Byslice slice == nil
				}
				if yyq2[24] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"BytesSlice\"")
					} else {
						r.EncodeString(`BytesSlice`)
					}
					z.EncWriteMapElemValue()
					if x.TestStrucCommon.BytesSlice == nil {
						r.EncodeNil()
					} else {
						z.F.EncSliceBytesV(x.TestStrucCommon.BytesSlice, e)
					} // end block: if x.TestStrucCommon.BytesSlice slice == nil
				}
				if yyq2[25] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"Iptrslice\"")
					} else {
						r.EncodeString(`Iptrslice`)
					}
					z.EncWriteMapElemValue()
					if x.TestStrucCommon.Iptrslice == nil {
						r.EncodeNil()
					} else {
						h.encSlicePtrtoint64(([]*int64)(x.TestStrucCommon.Iptrslice), e)
					} // end block: if x.TestStrucCommon.Iptrslice slice == nil
				}
				if yyq2[26] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"WrapSliceInt64\"")
					} else {
						r.EncodeString(`WrapSliceInt64`)
					}
					z.EncWriteMapElemValue()
					if yyxt334 := z.Extension(x.TestStrucCommon.WrapSliceInt64); yyxt334 != nil {
						z.EncExtension(x.TestStrucCommon.WrapSliceInt64, yyxt334)
					} else {
						x.TestStrucCommon.WrapSliceInt64.CodecEncodeSelf(e)
					}
				}
				if yyq2[27] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"WrapSliceString\"")
					} else {
						r.EncodeString(`WrapSliceString`)
					}
					z.EncWriteMapElemValue()
					if yyxt335 := z.Extension(x.TestStrucCommon.WrapSliceString); yyxt335 != nil {
						z.EncExtension(x.TestStrucCommon.WrapSliceString, yyxt335)
					} else {
						x.TestStrucCommon.WrapSliceString.CodecEncodeSelf(e)
					}
				}
				if yyq2[28] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"Msint\"")
					} else {
						r.EncodeString(`Msint`)
					}
					z.EncWriteMapElemValue()
					if x.TestStrucCommon.Msint == nil {
						r.EncodeNil()
					} else {
						z.F.EncMapStringIntV(x.TestStrucCommon.Msint, e)
					} // end block: if x.TestStrucCommon.Msint map == nil
				}
				if yyq2[29] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"Msbytes\"")
					} else {
						r.EncodeString(`Msbytes`)
					}
					z.EncWriteMapElemValue()
					if x.TestStrucCommon.Msbytes == nil {
						r.EncodeNil()
					} else {
						z.F.EncMapStringBytesV(x.TestStrucCommon.Msbytes, e)
					} // end block: if x.TestStrucCommon.Msbytes map == nil
				}
				if yyq2[30] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"Simplef\"")
					} else {
						r.EncodeString(`Simplef`)
					}
					z.EncWriteMapElemValue()
					yy338 := &x.TestStrucCommon.Simplef
					if yyxt339 := z.Extension(yy338); yyxt339 != nil {
						z.EncExtension(yy338, yyxt339)
					} else {
						yy338.CodecEncodeSelf(e)
					}
				}
				if yyq2[31] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"SstrUi64T\"")
					} else {
						r.EncodeString(`SstrUi64T`)
					}
					z.EncWriteMapElemValue()
					if x.TestStrucCommon.SstrUi64T == nil {
						r.EncodeNil()
					} else {
						h.encSlicestringUint64T(([]stringUint64T)(x.TestStrucCommon.SstrUi64T), e)
					} // end block: if x.TestStrucCommon.SstrUi64T slice == nil
				}
				if yyq2[32] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"MstrUi64T\"")
					} else {
						r.EncodeString(`MstrUi64T`)
					}
					z.EncWriteMapElemValue()
					if x.TestStrucCommon.MstrUi64T == nil {
						r.EncodeNil()
					} else {
						h.encMapstringPtrtostringUint64T((map[string]*stringUint64T)(x.TestStrucCommon.MstrUi64T), e)
					} // end block: if x.TestStrucCommon.MstrUi64T map == nil
				}
				if yyq2[33] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"AS\"")
					} else {
						r.EncodeString(`AS`)
					}
					z.EncWriteMapElemValue()
					r.EncodeString(string(x.TestStrucCommon.AnonInTestStruc.AS))
				}
				if yyq2[34] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"AI64\"")
					} else {
						r.EncodeString(`AI64`)
					}
					z.EncWriteMapElemValue()
					r.EncodeInt(int64(x.TestStrucCommon.AnonInTestStruc.AI64))
				}
				if yyq2[35] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"AI16\"")
					} else {
						r.EncodeString(`AI16`)
					}
					z.EncWriteMapElemValue()
					r.EncodeInt(int64(x.TestStrucCommon.AnonInTestStruc.AI16))
				}
				if yyq2[36] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"AUi64\"")
					} else {
						r.EncodeString(`AUi64`)
					}
					z.EncWriteMapElemValue()
					r.EncodeUint(uint64(x.TestStrucCommon.AnonInTestStruc.AUi64))
				}
				if yyq2[37] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"ASslice\"")
					} else {
						r.EncodeString(`ASslice`)
					}
					z.EncWriteMapElemValue()
					if x.TestStrucCommon.AnonInTestStruc.ASslice == nil {
						r.EncodeNil()
					} else {
						z.F.EncSliceStringV(x.TestStrucCommon.AnonInTestStruc.ASslice, e)
					} // end block: if x.TestStrucCommon.AnonInTestStruc.ASslice slice == nil
				}
				if yyq2[38] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"AI64slice\"")
					} else {
						r.EncodeString(`AI64slice`)
					}
					z.EncWriteMapElemValue()
					if x.TestStrucCommon.AnonInTestStruc.AI64slice == nil {
						r.EncodeNil()
					} else {
						z.F.EncSliceInt64V(x.TestStrucCommon.AnonInTestStruc.AI64slice, e)
					} // end block: if x.TestStrucCommon.AnonInTestStruc.AI64slice slice == nil
				}
				if yyq2[39] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"AUi64slice\"")
					} else {
						r.EncodeString(`AUi64slice`)
					}
					z.EncWriteMapElemValue()
					if x.TestStrucCommon.AnonInTestStruc.AUi64slice == nil {
						r.EncodeNil()
					} else {
						z.F.EncSliceUint64V(x.TestStrucCommon.AnonInTestStruc.AUi64slice, e)
					} // end block: if x.TestStrucCommon.AnonInTestStruc.AUi64slice slice == nil
				}
				if yyq2[40] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"AF64slice\"")
					} else {
						r.EncodeString(`AF64slice`)
					}
					z.EncWriteMapElemValue()
					if x.TestStrucCommon.AnonInTestStruc.AF64slice == nil {
						r.EncodeNil()
					} else {
						z.F.EncSliceFloat64V(x.TestStrucCommon.AnonInTestStruc.AF64slice, e)
					} // end block: if x.TestStrucCommon.AnonInTestStruc.AF64slice slice == nil
				}
				if yyq2[41] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"AF32slice\"")
					} else {
						r.EncodeString(`AF32slice`)
					}
					z.EncWriteMapElemValue()
					if x.TestStrucCommon.AnonInTestStruc.AF32slice == nil {
						r.EncodeNil()
					} else {
						z.F.EncSliceFloat32V(x.TestStrucCommon.AnonInTestStruc.AF32slice, e)
					} // end block: if x.TestStrucCommon.AnonInTestStruc.AF32slice slice == nil
				}
				if yyq2[42] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"AMSS\"")
					} else {
						r.EncodeString(`AMSS`)
					}
					z.EncWriteMapElemValue()
					if x.TestStrucCommon.AnonInTestStruc.AMSS == nil {
						r.EncodeNil()
					} else {
						z.F.EncMapStringStringV(x.TestStrucCommon.AnonInTestStruc.AMSS, e)
					} // end block: if x.TestStrucCommon.AnonInTestStruc.AMSS map == nil
				}
				if yyq2[43] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"AMSU64\"")
					} else {
						r.EncodeString(`AMSU64`)
					}
					z.EncWriteMapElemValue()
					if x.TestStrucCommon.AnonInTestStruc.AMSU64 == nil {
						r.EncodeNil()
					} else {
						z.F.EncMapStringUint64V(x.TestStrucCommon.AnonInTestStruc.AMSU64, e)
					} // end block: if x.TestStrucCommon.AnonInTestStruc.AMSU64 map == nil
				}
				if yyq2[44] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"AI64arr8\"")
					} else {
						r.EncodeString(`AI64arr8`)
					}
					z.EncWriteMapElemValue()
					yy353 := &x.TestStrucCommon.AnonInTestStruc.AI64arr8
					h.encArray8int64((*[8]int64)(yy353), e)
				}
				if yyq2[45] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"AI64arr0\"")
					} else {
						r.EncodeString(`AI64arr0`)
					}
					z.EncWriteMapElemValue()
					yy355 := &x.TestStrucCommon.AnonInTestStruc.AI64arr0
					h.encArray0int64((*[0]int64)(yy355), e)
				}
				if yyq2[46] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"AI64slice0\"")
					} else {
						r.EncodeString(`AI64slice0`)
					}
					z.EncWriteMapElemValue()
					if x.TestStrucCommon.AnonInTestStruc.AI64slice0 == nil {
						r.EncodeNil()
					} else {
						z.F.EncSliceInt64V(x.TestStrucCommon.AnonInTestStruc.AI64slice0, e)
					} // end block: if x.TestStrucCommon.AnonInTestStruc.AI64slice0 slice == nil
				}
				if yyq2[47] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"AUi64sliceN\"")
					} else {
						r.EncodeString(`AUi64sliceN`)
					}
					z.EncWriteMapElemValue()
					if x.TestStrucCommon.AnonInTestStruc.AUi64sliceN == nil {
						r.EncodeNil()
					} else {
						z.F.EncSliceUint64V(x.TestStrucCommon.AnonInTestStruc.AUi64sliceN, e)
					} // end block: if x.TestStrucCommon.AnonInTestStruc.AUi64sliceN slice == nil
				}
				if yyq2[48] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"AMSU64N\"")
					} else {
						r.EncodeString(`AMSU64N`)
					}
					z.EncWriteMapElemValue()
					if x.TestStrucCommon.AnonInTestStruc.AMSU64N == nil {
						r.EncodeNil()
					} else {
						z.F.EncMapStringUint64V(x.TestStrucCommon.AnonInTestStruc.AMSU64N, e)
					} // end block: if x.TestStrucCommon.AnonInTestStruc.AMSU64N map == nil
				}
				if yyq2[49] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"AMSU64E\"")
					} else {
						r.EncodeString(`AMSU64E`)
					}
					z.EncWriteMapElemValue()
					if x.TestStrucCommon.AnonInTestStruc.AMSU64E == nil {
						r.EncodeNil()
					} else {
						z.F.EncMapStringUint64V(x.TestStrucCommon.AnonInTestStruc.AMSU64E, e)
					} // end block: if x.TestStrucCommon.AnonInTestStruc.AMSU64E map == nil
				}
				if yyq2[50] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"NotAnon\"")
					} else {
						r.EncodeString(`NotAnon`)
					}
					z.EncWriteMapElemValue()
					yy361 := &x.TestStrucCommon.NotAnon
					if yyxt362 := z.Extension(yy361); yyxt362 != nil {
						z.EncExtension(yy361, yyxt362)
					} else {
						yy361.CodecEncodeSelf(e)
					}
				}
				if yyq2[51] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"P\"")
					} else {
						r.EncodeString(`P`)
					}
					z.EncWriteMapElemValue()
					if yyn54 {
						r.EncodeNil()
					} else {
						yy363 := *x.TestStrucCommon.AnonInTestStrucSlim.P
						r.EncodeString(string(yy363))
					}
				}
				if yyq2[52] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"NotAnonSlim\"")
					} else {
						r.EncodeString(`NotAnonSlim`)
					}
					z.EncWriteMapElemValue()
					if yyn55 {
						r.EncodeNil()
					} else {
						if yyxt365 := z.Extension(x.TestStrucCommon.NotAnonSlim); yyxt365 != nil {
							z.EncExtension(x.TestStrucCommon.NotAnonSlim, yyxt365)
						} else {
							x.TestStrucCommon.NotAnonSlim.CodecEncodeSelf(e)
						}
					}
				}
				if yyq2[53] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"Nmap\"")
					} else {
						r.EncodeString(`Nmap`)
					}
					z.EncWriteMapElemValue()
					if x.TestStrucCommon.Nmap == nil {
						r.EncodeNil()
					} else {
						z.F.EncMapStringBoolV(x.TestStrucCommon.Nmap, e)
					} // end block: if x.TestStrucCommon.Nmap map == nil
				}
				if yyq2[54] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"Nslice\"")
					} else {
						r.EncodeString(`Nslice`)
					}
					z.EncWriteMapElemValue()
					if x.TestStrucCommon.Nslice == nil {
						r.EncodeNil()
					} else {
						r.EncodeStringBytesRaw([]byte(x.TestStrucCommon.Nslice))
					} // end block: if x.TestStrucCommon.Nslice slice == nil
				}
				if yyq2[55] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"Nint64\"")
					} else {
						r.EncodeString(`Nint64`)
					}
					z.EncWriteMapElemValue()
					if yyn58 {
						r.EncodeNil()
					} else {
						yy368 := *x.TestStrucCommon.Nint64
						r.EncodeInt(int64(yy368))
					}
				}
				if yyq2[56] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"Chstr\"")
					} else {
						r.EncodeString(`Chstr`)
					}
					z.EncWriteMapElemValue()
					h.encChanstring((chan string)(x.Chstr), e)
				}
				if yyq2[57] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"Mis\"")
					} else {
						r.EncodeString(`Mis`)
					}
					z.EncWriteMapElemValue()
					if x.Mis == nil {
						r.EncodeNil()
					} else {
						z.F.EncMapIntStringV(x.Mis, e)
					} // end block: if x.Mis map == nil
				}
				if yyq2[58] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"Mbu64\"")
					} else {
						r.EncodeString(`Mbu64`)
					}
					z.EncWriteMapElemValue()
					if x.Mbu64 == nil {
						r.EncodeNil()
					} else {
						h.encMapboolc3RydWN0IHt9((map[bool]struct{})(x.Mbu64), e)
					} // end block: if x.Mbu64 map == nil
				}
				if yyq2[59] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"Mu8e\"")
					} else {
						r.EncodeString(`Mu8e`)
					}
					z.EncWriteMapElemValue()
					if x.Mu8e == nil {
						r.EncodeNil()
					} else {
						h.encMapuint8c3RydWN0IHt9((map[uint8]struct{})(x.Mu8e), e)
					} // end block: if x.Mu8e map == nil
				}
				if yyq2[60] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"Mu8u64\"")
					} else {
						r.EncodeString(`Mu8u64`)
					}
					z.EncWriteMapElemValue()
					if x.Mu8u64 == nil {
						r.EncodeNil()
					} else {
						h.encMapuint8stringUint64T((map[uint8]stringUint64T)(x.Mu8u64), e)
					} // end block: if x.Mu8u64 map == nil
				}
				if yyq2[61] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"Msp2ss\"")
					} else {
						r.EncodeString(`Msp2ss`)
					}
					z.EncWriteMapElemValue()
					if x.Msp2ss == nil {
						r.EncodeNil()
					} else {
						h.encMapPtrtostringSlicestring((map[*string][]string)(x.Msp2ss), e)
					} // end block: if x.Msp2ss map == nil
				}
				if yyq2[62] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"Mip2ss\"")
					} else {
						r.EncodeString(`Mip2ss`)
					}
					z.EncWriteMapElemValue()
					if x.Mip2ss == nil {
						r.EncodeNil()
					} else {
						h.encMapPtrtouint64Slicestring((map[*uint64][]string)(x.Mip2ss), e)
					} // end block: if x.Mip2ss map == nil
				}
				if yyq2[63] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"Ms2misu\"")
					} else {
						r.EncodeString(`Ms2misu`)
					}
					z.EncWriteMapElemValue()
					if x.Ms2misu == nil {
						r.EncodeNil()
					} else {
						h.encMapstringMapuint64stringUint64T((map[string]map[uint64]stringUint64T)(x.Ms2misu), e)
					} // end block: if x.Ms2misu map == nil
				}
				if yyq2[64] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"Miwu64s\"")
					} else {
						r.EncodeString(`Miwu64s`)
					}
					z.EncWriteMapElemValue()
					if x.Miwu64s == nil {
						r.EncodeNil()
					} else {
						h.encMapintwrapUint64Slice((map[int]wrapUint64Slice)(x.Miwu64s), e)
					} // end block: if x.Miwu64s map == nil
				}
				if yyq2[65] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"Mfwss\"")
					} else {
						r.EncodeString(`Mfwss`)
					}
					z.EncWriteMapElemValue()
					if x.Mfwss == nil {
						r.EncodeNil()
					} else {
						h.encMapfloat64wrapStringSlice((map[float64]wrapStringSlice)(x.Mfwss), e)
					} // end block: if x.Mfwss map == nil
				}
				if yyq2[66] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"Mf32wss\"")
					} else {
						r.EncodeString(`Mf32wss`)
					}
					z.EncWriteMapElemValue()
					if x.Mf32wss == nil {
						r.EncodeNil()
					} else {
						h.encMapfloat32wrapStringSlice((map[float32]wrapStringSlice)(x.Mf32wss), e)
					} // end block: if x.Mf32wss map == nil
				}
				if yyq2[67] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"Mui2wss\"")
					} else {
						r.EncodeString(`Mui2wss`)
					}
					z.EncWriteMapElemValue()
					if x.Mui2wss == nil {
						r.EncodeNil()
					} else {
						h.encMapuint64wrapStringSlice((map[uint64]wrapStringSlice)(x.Mui2wss), e)
					} // end block: if x.Mui2wss map == nil
				}
				if yyq2[68] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"Msu2wss\"")
					} else {
						r.EncodeString(`Msu2wss`)
					}
					z.EncWriteMapElemValue()
					if x.Msu2wss == nil {
						r.EncodeNil()
					} else {
						h.encMapstringUint64TwrapStringSlice((map[stringUint64T]wrapStringSlice)(x.Msu2wss), e)
					} // end block: if x.Msu2wss map == nil
				}
				if yyq2[69] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"Ci64\"")
					} else {
						r.EncodeString(`Ci64`)
					}
					z.EncWriteMapElemValue()
					if yyxt383 := z.Extension(x.Ci64); yyxt383 != nil {
						z.EncExtension(x.Ci64, yyxt383)
					} else {
						x.Ci64.CodecEncodeSelf(e)
					}
				}
				if yyq2[70] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"Swrapbytes\"")
					} else {
						r.EncodeString(`Swrapbytes`)
					}
					z.EncWriteMapElemValue()
					if x.Swrapbytes == nil {
						r.EncodeNil()
					} else {
						h.encSlicewrapBytes(([]wrapBytes)(x.Swrapbytes), e)
					} // end block: if x.Swrapbytes slice == nil
				}
				if yyq2[71] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"Swrapuint8\"")
					} else {
						r.EncodeString(`Swrapuint8`)
					}
					z.EncWriteMapElemValue()
					if x.Swrapuint8 == nil {
						r.EncodeNil()
					} else {
						h.encSlicewrapUint8(([]wrapUint8)(x.Swrapuint8), e)
					} // end block: if x.Swrapuint8 slice == nil
				}
				if yyq2[72] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"ArrStrUi64T\"")
					} else {
						r.EncodeString(`ArrStrUi64T`)
					}
					z.EncWriteMapElemValue()
					yy386 := &x.ArrStrUi64T
					h.encArray4stringUint64T((*[4]stringUint64T)(yy386), e)
				}
				if yyq2[73] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"Ui64array\"")
					} else {
						r.EncodeString(`Ui64array`)
					}
					z.EncWriteMapElemValue()
					yy388 := &x.Ui64array
					h.encArray4uint64((*[4]uint64)(yy388), e)
				}
				if yyq2[74] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"Ui64slicearray\"")
					} else {
						r.EncodeString(`Ui64slicearray`)
					}
					z.EncWriteMapElemValue()
					if x.Ui64slicearray == nil {
						r.EncodeNil()
					} else {
						h.encSlicePtrtoArray4uint64(([]*[4]uint64)(x.Ui64slicearray), e)
					} // end block: if x.Ui64slicearray slice == nil
				}
				if yyq2[75] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"SintfAarray\"")
					} else {
						r.EncodeString(`SintfAarray`)
					}
					z.EncWriteMapElemValue()
					if x.SintfAarray == nil {
						r.EncodeNil()
					} else {
						z.F.EncSliceIntfV(x.SintfAarray, e)
					} // end block: if x.SintfAarray slice == nil
				}
				if yyq2[76] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"MstrUi64TSelf\"")
					} else {
						r.EncodeString(`MstrUi64TSelf`)
					}
					z.EncWriteMapElemValue()
					if x.MstrUi64TSelf == nil {
						r.EncodeNil()
					} else {
						h.encMapstringUint64TPtrtostringUint64T((map[stringUint64T]*stringUint64T)(x.MstrUi64TSelf), e)
					} // end block: if x.MstrUi64TSelf map == nil
				}
				if yyq2[77] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"Ttime\"")
					} else {
						r.EncodeString(`Ttime`)
					}
					z.EncWriteMapElemValue()
					if z.EncBasicHandle().TimeBuiltin() {
						r.EncodeTime(x.Ttime)
					} else if yyxt393 := z.Extension(x.Ttime); yyxt393 != nil {
						z.EncExtension(x.Ttime, yyxt393)
					} else if z.EncBinary() {
						z.EncBinaryMarshal(x.Ttime)
					} else if !z.EncBinary() && z.IsJSONHandle() {
						z.EncJSONMarshal(x.Ttime)
					} else {
						z.EncFallback(x.Ttime)
					}
				}
				if yyq2[78] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"Ttimeptr\"")
					} else {
						r.EncodeString(`Ttimeptr`)
					}
					z.EncWriteMapElemValue()
					if yyn81 {
						r.EncodeNil()
					} else {
						yy394 := *x.Ttimeptr
						if z.EncBasicHandle().TimeBuiltin() {
							r.EncodeTime(yy394)
						} else if yyxt395 := z.Extension(yy394); yyxt395 != nil {
							z.EncExtension(yy394, yyxt395)
						} else if z.EncBinary() {
							z.EncBinaryMarshal(yy394)
						} else if !z.EncBinary() && z.IsJSONHandle() {
							z.EncJSONMarshal(yy394)
						} else {
							z.EncFallback(yy394)
						}
					}
				}
				if yyq2[79] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"Islice\"")
					} else {
						r.EncodeString(`Islice`)
					}
					z.EncWriteMapElemValue()
					if yyn82 {
						r.EncodeNil()
					} else {
						if x.AnonInTestStrucIntf.Islice == nil {
							r.EncodeNil()
						} else {
							z.F.EncSliceIntfV(x.AnonInTestStrucIntf.Islice, e)
						} // end block: if x.AnonInTestStrucIntf.Islice slice == nil
					}
				}
				if yyq2[80] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"Ms\"")
					} else {
						r.EncodeString(`Ms`)
					}
					z.EncWriteMapElemValue()
					if yyn83 {
						r.EncodeNil()
					} else {
						if x.AnonInTestStrucIntf.Ms == nil {
							r.EncodeNil()
						} else {
							z.F.EncMapStringIntfV(x.AnonInTestStrucIntf.Ms, e)
						} // end block: if x.AnonInTestStrucIntf.Ms map == nil
					}
				}
				if yyq2[81] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"Nintf\"")
					} else {
						r.EncodeString(`Nintf`)
					}
					z.EncWriteMapElemValue()
					if yyn84 {
						r.EncodeNil()
					} else {
						z.EncFallback(x.AnonInTestStrucIntf.Nintf)
					}
				}
				if yyq2[82] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"T\"")
					} else {
						r.EncodeString(`T`)
					}
					z.EncWriteMapElemValue()
					if yyn85 {
						r.EncodeNil()
					} else {
						if z.EncBasicHandle().TimeBuiltin() {
							r.EncodeTime(x.AnonInTestStrucIntf.T)
						} else if yyxt399 := z.Extension(x.AnonInTestStrucIntf.T); yyxt399 != nil {
							z.EncExtension(x.AnonInTestStrucIntf.T, yyxt399)
						} else if z.EncBinary() {
							z.EncBinaryMarshal(x.AnonInTestStrucIntf.T)
						} else if !z.EncBinary() && z.IsJSONHandle() {
							z.EncJSONMarshal(x.AnonInTestStrucIntf.T)
						} else {
							z.EncFallback(x.AnonInTestStrucIntf.T)
						}
					}
				}
				if yyq2[83] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"Tptr\"")
					} else {
						r.EncodeString(`Tptr`)
					}
					z.EncWriteMapElemValue()
					if yyn86 {
						r.EncodeNil()
					} else {
						yy400 := *x.AnonInTestStrucIntf.Tptr
						if z.EncBasicHandle().TimeBuiltin() {
							r.EncodeTime(yy400)
						} else if yyxt401 := z.Extension(yy400); yyxt401 != nil {
							z.EncExtension(yy400, yyxt401)
						} else if z.EncBinary() {
							z.EncBinaryMarshal(yy400)
						} else if !z.EncBinary() && z.IsJSONHandle() {
							z.EncJSONMarshal(yy400)
						} else {
							z.EncFallback(yy400)
						}
					}
				}
				if yyq2[84] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"Msu\"")
					} else {
						r.EncodeString(`Msu`)
					}
					z.EncWriteMapElemValue()
					if x.Msu == nil {
						r.EncodeNil()
					} else {
						h.encMapwrapStringInterface((map[wrapString]interface{})(x.Msu), e)
					} // end block: if x.Msu map == nil
				}
				if yyq2[85] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"Mtsptr\"")
					} else {
						r.EncodeString(`Mtsptr`)
					}
					z.EncWriteMapElemValue()
					if x.Mtsptr == nil {
						r.EncodeNil()
					} else {
						h.encMapstringPtrtoTestStrucFlex((map[string]*TestStrucFlex)(x.Mtsptr), e)
					} // end block: if x.Mtsptr map == nil
				}
				if yyq2[86] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"Mts\"")
					} else {
						r.EncodeString(`Mts`)
					}
					z.EncWriteMapElemValue()
					if x.Mts == nil {
						r.EncodeNil()
					} else {
						h.encMapstringTestStrucFlex((map[string]TestStrucFlex)(x.Mts), e)
					} // end block: if x.Mts map == nil
				}
				if yyq2[87] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"Its\"")
					} else {
						r.EncodeString(`Its`)
					}
					z.EncWriteMapElemValue()
					if x.Its == nil {
						r.EncodeNil()
					} else {
						h.encSlicePtrtoTestStrucFlex(([]*TestStrucFlex)(x.Its), e)
					} // end block: if x.Its slice == nil
				}
				if yyq2[88] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"Nteststruc\"")
					} else {
						r.EncodeString(`Nteststruc`)
					}
					z.EncWriteMapElemValue()
					if yyn91 {
						r.EncodeNil()
					} else {
						if yyxt406 := z.Extension(x.Nteststruc); yyxt406 != nil {
							z.EncExtension(x.Nteststruc, yyxt406)
						} else {
							x.Nteststruc.CodecEncodeSelf(e)
						}
					}
				}
				if yyq2[89] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"MarJ\"")
					} else {
						r.EncodeString(`MarJ`)
					}
					z.EncWriteMapElemValue()
					if yyxt407 := z.Extension(x.MarJ); yyxt407 != nil {
						z.EncExtension(x.MarJ, yyxt407)
					} else {
						x.MarJ.CodecEncodeSelf(e)
					}
				}
				if yyq2[90] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"MarT\"")
					} else {
						r.EncodeString(`MarT`)
					}
					z.EncWriteMapElemValue()
					if yyxt408 := z.Extension(x.MarT); yyxt408 != nil {
						z.EncExtension(x.MarT, yyxt408)
					} else {
						x.MarT.CodecEncodeSelf(e)
					}
				}
				if yyq2[91] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"MarB\"")
					} else {
						r.EncodeString(`MarB`)
					}
					z.EncWriteMapElemValue()
					if yyxt409 := z.Extension(x.MarB); yyxt409 != nil {
						z.EncExtension(x.MarB, yyxt409)
					} else {
						x.MarB.CodecEncodeSelf(e)
					}
				}
				if yyq2[92] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"XuintToBytes\"")
					} else {
						r.EncodeString(`XuintToBytes`)
					}
					z.EncWriteMapElemValue()
					if yyxt410 := z.Extension(x.XuintToBytes); yyxt410 != nil {
						z.EncExtension(x.XuintToBytes, yyxt410)
					} else {
						x.XuintToBytes.CodecEncodeSelf(e)
					}
				}
				if yyq2[93] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"Cmplx64\"")
					} else {
						r.EncodeString(`Cmplx64`)
					}
					z.EncWriteMapElemValue()
					z.EncEncodeComplex64(complex64(x.Cmplx64))
				}
				if yyq2[94] {
					z.EncWriteMapElemKey()
					if z.IsJSONHandle() {
						z.EncWr().WriteStr("\"Cmplx128\"")
					} else {
						r.EncodeString(`Cmplx128`)
					}
					z.EncWriteMapElemValue()
					z.EncEncodeComplex128(complex128(x.Cmplx128))
				}
			}
			z.EncWriteMapEnd()
		}
	}
}

func (x *TestStrucFlex) CodecDecodeSelf(d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelper().Decoder(d)
	_, _, _ = h, z, r
	yyct2 := r.ContainerType()
	if yyct2 == codecSelferValueTypeNil19780 {
		*(x) = TestStrucFlex{}
	} else if yyct2 == codecSelferValueTypeMap19780 {
		yyl2 := z.DecReadMapStart()
		if yyl2 == 0 {
		} else {
			x.codecDecodeSelfFromMap(yyl2, d)
		}
		z.DecReadMapEnd()
	} else if yyct2 == codecSelferValueTypeArray19780 {
		yyl2 := z.DecReadArrayStart()
		if yyl2 != 0 {
			x.codecDecodeSelfFromArray(yyl2, d)
		}
		z.DecReadArrayEnd()
	} else {
		panic(errCodecSelferOnlyMapOrArrayEncodeToStruct19780)
	}
}

func (x *TestStrucFlex) codecDecodeSelfFromMap(l int, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelper().Decoder(d)
	_, _, _ = h, z, r
	var yyhl3 bool = l >= 0
	for yyj3 := 0; z.DecContainerNext(yyj3, l, yyhl3); yyj3++ {
		z.DecReadMapElemKey()
		yys3 := r.DecodeStringAsBytes()
		z.DecReadMapElemValue()
		switch string(yys3) {
		case "S":
			x.TestStrucCommon.S = (string)(z.DecStringZC(r.DecodeStringAsBytes()))
		case "I64":
			x.TestStrucCommon.I64 = (int64)(r.DecodeInt64())
		case "I32":
			x.TestStrucCommon.I32 = (int32)(z.C.IntV(r.DecodeInt64(), 32))
		case "I16":
			x.TestStrucCommon.I16 = (int16)(z.C.IntV(r.DecodeInt64(), 16))
		case "I8":
			x.TestStrucCommon.I8 = (int8)(z.C.IntV(r.DecodeInt64(), 8))
		case "I64n":
			x.TestStrucCommon.I64n = (int64)(r.DecodeInt64())
		case "I32n":
			x.TestStrucCommon.I32n = (int32)(z.C.IntV(r.DecodeInt64(), 32))
		case "I16n":
			x.TestStrucCommon.I16n = (int16)(z.C.IntV(r.DecodeInt64(), 16))
		case "I8n":
			x.TestStrucCommon.I8n = (int8)(z.C.IntV(r.DecodeInt64(), 8))
		case "Ui64":
			x.TestStrucCommon.Ui64 = (uint64)(r.DecodeUint64())
		case "Ui32":
			x.TestStrucCommon.Ui32 = (uint32)(z.C.UintV(r.DecodeUint64(), 32))
		case "Ui16":
			x.TestStrucCommon.Ui16 = (uint16)(z.C.UintV(r.DecodeUint64(), 16))
		case "Ui8":
			x.TestStrucCommon.Ui8 = (uint8)(z.C.UintV(r.DecodeUint64(), 8))
		case "F64":
			x.TestStrucCommon.F64 = (float64)(r.DecodeFloat64())
		case "F32":
			x.TestStrucCommon.F32 = (float32)(z.DecDecodeFloat32())
		case "B":
			x.TestStrucCommon.B = (bool)(r.DecodeBool())
		case "By":
			x.TestStrucCommon.By = (uint8)(z.C.UintV(r.DecodeUint64(), 8))
		case "Sslice":
			z.F.DecSliceStringX(&x.TestStrucCommon.Sslice, d)
		case "I64slice":
			z.F.DecSliceInt64X(&x.TestStrucCommon.I64slice, d)
		case "I32slice":
			z.F.DecSliceInt32X(&x.TestStrucCommon.I32slice, d)
		case "Ui64slice":
			z.F.DecSliceUint64X(&x.TestStrucCommon.Ui64slice, d)
		case "Ui8slice":
			x.TestStrucCommon.Ui8slice = z.DecodeBytesInto(([]byte)(x.TestStrucCommon.Ui8slice))
		case "Bslice":
			z.F.DecSliceBoolX(&x.TestStrucCommon.Bslice, d)
		case "Byslice":
			x.TestStrucCommon.Byslice = z.DecodeBytesInto(([]byte)(x.TestStrucCommon.Byslice))
		case "BytesSlice":
			z.F.DecSliceBytesX(&x.TestStrucCommon.BytesSlice, d)
		case "Iptrslice":
			h.decSlicePtrtoint64((*[]*int64)(&x.TestStrucCommon.Iptrslice), d)
		case "WrapSliceInt64":
			if yyxt40 := z.Extension(x.TestStrucCommon.WrapSliceInt64); yyxt40 != nil {
				z.DecExtension(&x.TestStrucCommon.WrapSliceInt64, yyxt40)
			} else {
				x.TestStrucCommon.WrapSliceInt64.CodecDecodeSelf(d)
			}
		case "WrapSliceString":
			if yyxt42 := z.Extension(x.TestStrucCommon.WrapSliceString); yyxt42 != nil {
				z.DecExtension(&x.TestStrucCommon.WrapSliceString, yyxt42)
			} else {
				x.TestStrucCommon.WrapSliceString.CodecDecodeSelf(d)
			}
		case "Msint":
			z.F.DecMapStringIntX(&x.TestStrucCommon.Msint, d)
		case "Msbytes":
			z.F.DecMapStringBytesX(&x.TestStrucCommon.Msbytes, d)
		case "Simplef":
			if yyxt48 := z.Extension(x.TestStrucCommon.Simplef); yyxt48 != nil {
				z.DecExtension(&x.TestStrucCommon.Simplef, yyxt48)
			} else {
				x.TestStrucCommon.Simplef.CodecDecodeSelf(d)
			}
		case "SstrUi64T":
			h.decSlicestringUint64T((*[]stringUint64T)(&x.TestStrucCommon.SstrUi64T), d)
		case "MstrUi64T":
			h.decMapstringPtrtostringUint64T((*map[string]*stringUint64T)(&x.TestStrucCommon.MstrUi64T), d)
		case "AS":
			x.TestStrucCommon.AnonInTestStruc.AS = (string)(z.DecStringZC(r.DecodeStringAsBytes()))
		case "AI64":
			x.TestStrucCommon.AnonInTestStruc.AI64 = (int64)(r.DecodeInt64())
		case "AI16":
			x.TestStrucCommon.AnonInTestStruc.AI16 = (int16)(z.C.IntV(r.DecodeInt64(), 16))
		case "AUi64":
			x.TestStrucCommon.AnonInTestStruc.AUi64 = (uint64)(r.DecodeUint64())
		case "ASslice":
			z.F.DecSliceStringX(&x.TestStrucCommon.AnonInTestStruc.ASslice, d)
		case "AI64slice":
			z.F.DecSliceInt64X(&x.TestStrucCommon.AnonInTestStruc.AI64slice, d)
		case "AUi64slice":
			z.F.DecSliceUint64X(&x.TestStrucCommon.AnonInTestStruc.AUi64slice, d)
		case "AF64slice":
			z.F.DecSliceFloat64X(&x.TestStrucCommon.AnonInTestStruc.AF64slice, d)
		case "AF32slice":
			z.F.DecSliceFloat32X(&x.TestStrucCommon.AnonInTestStruc.AF32slice, d)
		case "AMSS":
			z.F.DecMapStringStringX(&x.TestStrucCommon.AnonInTestStruc.AMSS, d)
		case "AMSU64":
			z.F.DecMapStringUint64X(&x.TestStrucCommon.AnonInTestStruc.AMSU64, d)
		case "AI64arr8":
			h.decArray8int64((*[8]int64)(&x.TestStrucCommon.AnonInTestStruc.AI64arr8), d)
		case "AI64arr0":
			h.decArray0int64((*[0]int64)(&x.TestStrucCommon.AnonInTestStruc.AI64arr0), d)
		case "AI64slice0":
			z.F.DecSliceInt64X(&x.TestStrucCommon.AnonInTestStruc.AI64slice0, d)
		case "AUi64sliceN":
			z.F.DecSliceUint64X(&x.TestStrucCommon.AnonInTestStruc.AUi64sliceN, d)
		case "AMSU64N":
			z.F.DecMapStringUint64X(&x.TestStrucCommon.AnonInTestStruc.AMSU64N, d)
		case "AMSU64E":
			z.F.DecMapStringUint64X(&x.TestStrucCommon.AnonInTestStruc.AMSU64E, d)
		case "NotAnon":
			if yyxt84 := z.Extension(x.TestStrucCommon.NotAnon); yyxt84 != nil {
				z.DecExtension(&x.TestStrucCommon.NotAnon, yyxt84)
			} else {
				x.TestStrucCommon.NotAnon.CodecDecodeSelf(d)
			}
		case "P":
			if r.TryNil() {
				if x.TestStrucCommon.AnonInTestStrucSlim != nil && x.TestStrucCommon.AnonInTestStrucSlim.P != nil { // remove the if-true
					x.TestStrucCommon.AnonInTestStrucSlim.P = nil
				}
			} else {
				if x.TestStrucCommon.AnonInTestStrucSlim == nil {
					x.TestStrucCommon.AnonInTestStrucSlim = new(AnonInTestStrucSlim)
				}
				if x.TestStrucCommon.AnonInTestStrucSlim.P == nil {
					x.TestStrucCommon.AnonInTestStrucSlim.P = new(string)
				}
				*x.TestStrucCommon.AnonInTestStrucSlim.P = (string)(z.DecStringZC(r.DecodeStringAsBytes()))
			}
		case "NotAnonSlim":
			if r.TryNil() {
				if x.TestStrucCommon.NotAnonSlim != nil { // remove the if-true
					x.TestStrucCommon.NotAnonSlim = nil
				}
			} else {
				if x.TestStrucCommon.NotAnonSlim == nil {
					x.TestStrucCommon.NotAnonSlim = new(AnonInTestStrucSlim)
				}
				if yyxt88 := z.Extension(x.TestStrucCommon.NotAnonSlim); yyxt88 != nil {
					z.DecExtension(x.TestStrucCommon.NotAnonSlim, yyxt88)
				} else {
					x.TestStrucCommon.NotAnonSlim.CodecDecodeSelf(d)
				}
			}
		case "Nmap":
			z.F.DecMapStringBoolX(&x.TestStrucCommon.Nmap, d)
		case "Nslice":
			x.TestStrucCommon.Nslice = z.DecodeBytesInto(([]byte)(x.TestStrucCommon.Nslice))
		case "Nint64":
			if r.TryNil() {
				if x.TestStrucCommon.Nint64 != nil { // remove the if-true
					x.TestStrucCommon.Nint64 = nil
				}
			} else {
				if x.TestStrucCommon.Nint64 == nil {
					x.TestStrucCommon.Nint64 = new(int64)
				}
				*x.TestStrucCommon.Nint64 = (int64)(r.DecodeInt64())
			}
		case "Chstr":
			h.decChanstring((*chan string)(&x.Chstr), d)
		case "Mis":
			z.F.DecMapIntStringX(&x.Mis, d)
		case "Mbu64":
			h.decMapboolc3RydWN0IHt9((*map[bool]struct{})(&x.Mbu64), d)
		case "Mu8e":
			h.decMapuint8c3RydWN0IHt9((*map[uint8]struct{})(&x.Mu8e), d)
		case "Mu8u64":
			h.decMapuint8stringUint64T((*map[uint8]stringUint64T)(&x.Mu8u64), d)
		case "Msp2ss":
			h.decMapPtrtostringSlicestring((*map[*string][]string)(&x.Msp2ss), d)
		case "Mip2ss":
			h.decMapPtrtouint64Slicestring((*map[*uint64][]string)(&x.Mip2ss), d)
		case "Ms2misu":
			h.decMapstringMapuint64stringUint64T((*map[string]map[uint64]stringUint64T)(&x.Ms2misu), d)
		case "Miwu64s":
			h.decMapintwrapUint64Slice((*map[int]wrapUint64Slice)(&x.Miwu64s), d)
		case "Mfwss":
			h.decMapfloat64wrapStringSlice((*map[float64]wrapStringSlice)(&x.Mfwss), d)
		case "Mf32wss":
			h.decMapfloat32wrapStringSlice((*map[float32]wrapStringSlice)(&x.Mf32wss), d)
		case "Mui2wss":
			h.decMapuint64wrapStringSlice((*map[uint64]wrapStringSlice)(&x.Mui2wss), d)
		case "Msu2wss":
			h.decMapstringUint64TwrapStringSlice((*map[stringUint64T]wrapStringSlice)(&x.Msu2wss), d)
		case "Ci64":
			if yyxt122 := z.Extension(x.Ci64); yyxt122 != nil {
				z.DecExtension(&x.Ci64, yyxt122)
			} else {
				x.Ci64.CodecDecodeSelf(d)
			}
		case "Swrapbytes":
			h.decSlicewrapBytes((*[]wrapBytes)(&x.Swrapbytes), d)
		case "Swrapuint8":
			h.decSlicewrapUint8((*[]wrapUint8)(&x.Swrapuint8), d)
		case "ArrStrUi64T":
			h.decArray4stringUint64T((*[4]stringUint64T)(&x.ArrStrUi64T), d)
		case "Ui64array":
			h.decArray4uint64((*[4]uint64)(&x.Ui64array), d)
		case "Ui64slicearray":
			h.decSlicePtrtoArray4uint64((*[]*[4]uint64)(&x.Ui64slicearray), d)
		case "SintfAarray":
			z.F.DecSliceIntfX(&x.SintfAarray, d)
		case "MstrUi64TSelf":
			h.decMapstringUint64TPtrtostringUint64T((*map[stringUint64T]*stringUint64T)(&x.MstrUi64TSelf), d)
		case "Ttime":
			if z.DecBasicHandle().TimeBuiltin() {
				x.Ttime = r.DecodeTime()
			} else if yyxt138 := z.Extension(x.Ttime); yyxt138 != nil {
				z.DecExtension(&x.Ttime, yyxt138)
			} else if z.DecBinary() {
				z.DecBinaryUnmarshal(&x.Ttime)
			} else if !z.DecBinary() && z.IsJSONHandle() {
				z.DecJSONUnmarshal(&x.Ttime)
			} else {
				z.DecFallback(&x.Ttime, false)
			}
		case "Ttimeptr":
			if r.TryNil() {
				if x.Ttimeptr != nil { // remove the if-true
					x.Ttimeptr = nil
				}
			} else {
				if x.Ttimeptr == nil {
					x.Ttimeptr = new(time.Time)
				}
				if z.DecBasicHandle().TimeBuiltin() {
					*x.Ttimeptr = r.DecodeTime()
				} else if yyxt140 := z.Extension(x.Ttimeptr); yyxt140 != nil {
					z.DecExtension(x.Ttimeptr, yyxt140)
				} else if z.DecBinary() {
					z.DecBinaryUnmarshal(x.Ttimeptr)
				} else if !z.DecBinary() && z.IsJSONHandle() {
					z.DecJSONUnmarshal(x.Ttimeptr)
				} else {
					z.DecFallback(x.Ttimeptr, false)
				}
			}
		case "Islice":
			if r.TryNil() {
				if x.AnonInTestStrucIntf != nil { // remove the if-true
					x.AnonInTestStrucIntf.Islice = nil
				}
			} else {
				if x.AnonInTestStrucIntf == nil {
					x.AnonInTestStrucIntf = new(AnonInTestStrucIntf)
				}
				z.F.DecSliceIntfX(&x.AnonInTestStrucIntf.Islice, d)
			}
		case "Ms":
			if r.TryNil() {
				if x.AnonInTestStrucIntf != nil { // remove the if-true
					x.AnonInTestStrucIntf.Ms = nil
				}
			} else {
				if x.AnonInTestStrucIntf == nil {
					x.AnonInTestStrucIntf = new(AnonInTestStrucIntf)
				}
				z.F.DecMapStringIntfX(&x.AnonInTestStrucIntf.Ms, d)
			}
		case "Nintf":
			if r.TryNil() {
				if x.AnonInTestStrucIntf != nil { // remove the if-true
					x.AnonInTestStrucIntf.Nintf = nil
				}
			} else {
				if x.AnonInTestStrucIntf == nil {
					x.AnonInTestStrucIntf = new(AnonInTestStrucIntf)
				}
				z.DecFallback(&x.AnonInTestStrucIntf.Nintf, true)
			}
		case "T":
			if r.TryNil() {
				if x.AnonInTestStrucIntf != nil { // remove the if-true
					x.AnonInTestStrucIntf.T = time.Time{}
				}
			} else {
				if x.AnonInTestStrucIntf == nil {
					x.AnonInTestStrucIntf = new(AnonInTestStrucIntf)
				}
				if z.DecBasicHandle().TimeBuiltin() {
					x.AnonInTestStrucIntf.T = r.DecodeTime()
				} else if yyxt148 := z.Extension(x.AnonInTestStrucIntf.T); yyxt148 != nil {
					z.DecExtension(&x.AnonInTestStrucIntf.T, yyxt148)
				} else if z.DecBinary() {
					z.DecBinaryUnmarshal(&x.AnonInTestStrucIntf.T)
				} else if !z.DecBinary() && z.IsJSONHandle() {
					z.DecJSONUnmarshal(&x.AnonInTestStrucIntf.T)
				} else {
					z.DecFallback(&x.AnonInTestStrucIntf.T, false)
				}
			}
		case "Tptr":
			if r.TryNil() {
				if x.AnonInTestStrucIntf != nil && x.AnonInTestStrucIntf.Tptr != nil { // remove the if-true
					x.AnonInTestStrucIntf.Tptr = nil
				}
			} else {
				if x.AnonInTestStrucIntf == nil {
					x.AnonInTestStrucIntf = new(AnonInTestStrucIntf)
				}
				if x.AnonInTestStrucIntf.Tptr == nil {
					x.AnonInTestStrucIntf.Tptr = new(time.Time)
				}
				if z.DecBasicHandle().TimeBuiltin() {
					*x.AnonInTestStrucIntf.Tptr = r.DecodeTime()
				} else if yyxt150 := z.Extension(x.AnonInTestStrucIntf.Tptr); yyxt150 != nil {
					z.DecExtension(x.AnonInTestStrucIntf.Tptr, yyxt150)
				} else if z.DecBinary() {
					z.DecBinaryUnmarshal(x.AnonInTestStrucIntf.Tptr)
				} else if !z.DecBinary() && z.IsJSONHandle() {
					z.DecJSONUnmarshal(x.AnonInTestStrucIntf.Tptr)
				} else {
					z.DecFallback(x.AnonInTestStrucIntf.Tptr, false)
				}
			}
		case "Msu":
			h.decMapwrapStringInterface((*map[wrapString]interface{})(&x.Msu), d)
		case "Mtsptr":
			h.decMapstringPtrtoTestStrucFlex((*map[string]*TestStrucFlex)(&x.Mtsptr), d)
		case "Mts":
			h.decMapstringTestStrucFlex((*map[string]TestStrucFlex)(&x.Mts), d)
		case "Its":
			h.decSlicePtrtoTestStrucFlex((*[]*TestStrucFlex)(&x.Its), d)
		case "Nteststruc":
			if r.TryNil() {
				if x.Nteststruc != nil { // remove the if-true
					x.Nteststruc = nil
				}
			} else {
				if x.Nteststruc == nil {
					x.Nteststruc = new(TestStrucFlex)
				}
				if yyxt160 := z.Extension(x.Nteststruc); yyxt160 != nil {
					z.DecExtension(x.Nteststruc, yyxt160)
				} else {
					x.Nteststruc.CodecDecodeSelf(d)
				}
			}
		case "MarJ":
			if yyxt162 := z.Extension(x.MarJ); yyxt162 != nil {
				z.DecExtension(&x.MarJ, yyxt162)
			} else {
				x.MarJ.CodecDecodeSelf(d)
			}
		case "MarT":
			if yyxt164 := z.Extension(x.MarT); yyxt164 != nil {
				z.DecExtension(&x.MarT, yyxt164)
			} else {
				x.MarT.CodecDecodeSelf(d)
			}
		case "MarB":
			if yyxt166 := z.Extension(x.MarB); yyxt166 != nil {
				z.DecExtension(&x.MarB, yyxt166)
			} else {
				x.MarB.CodecDecodeSelf(d)
			}
		case "XuintToBytes":
			if yyxt168 := z.Extension(x.XuintToBytes); yyxt168 != nil {
				z.DecExtension(&x.XuintToBytes, yyxt168)
			} else {
				x.XuintToBytes.CodecDecodeSelf(d)
			}
		case "Cmplx64":
			x.Cmplx64 = (complex64)(complex(z.DecDecodeFloat32(), 0))
		case "Cmplx128":
			x.Cmplx128 = (complex128)(complex(r.DecodeFloat64(), 0))
		default:
			z.DecStructFieldNotFound(-1, string(yys3))
		} // end switch yys3
	} // end for yyj3
}

func (x *TestStrucFlex) codecDecodeSelfFromArray(l int, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelper().Decoder(d)
	_, _, _ = h, z, r
	var yyj171 int
	var yyb171 bool
	var yyhl171 bool = l >= 0
	yyb171 = !z.DecContainerNext(yyj171, l, yyhl171)
	if yyb171 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.TestStrucCommon.S = (string)(z.DecStringZC(r.DecodeStringAsBytes()))
	yyj171++
	yyb171 = !z.DecContainerNext(yyj171, l, yyhl171)
	if yyb171 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.TestStrucCommon.I64 = (int64)(r.DecodeInt64())
	yyj171++
	yyb171 = !z.DecContainerNext(yyj171, l, yyhl171)
	if yyb171 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.TestStrucCommon.I32 = (int32)(z.C.IntV(r.DecodeInt64(), 32))
	yyj171++
	yyb171 = !z.DecContainerNext(yyj171, l, yyhl171)
	if yyb171 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.TestStrucCommon.I16 = (int16)(z.C.IntV(r.DecodeInt64(), 16))
	yyj171++
	yyb171 = !z.DecContainerNext(yyj171, l, yyhl171)
	if yyb171 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.TestStrucCommon.I8 = (int8)(z.C.IntV(r.DecodeInt64(), 8))
	yyj171++
	yyb171 = !z.DecContainerNext(yyj171, l, yyhl171)
	if yyb171 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.TestStrucCommon.I64n = (int64)(r.DecodeInt64())
	yyj171++
	yyb171 = !z.DecContainerNext(yyj171, l, yyhl171)
	if yyb171 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.TestStrucCommon.I32n = (int32)(z.C.IntV(r.DecodeInt64(), 32))
	yyj171++
	yyb171 = !z.DecContainerNext(yyj171, l, yyhl171)
	if yyb171 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.TestStrucCommon.I16n = (int16)(z.C.IntV(r.DecodeInt64(), 16))
	yyj171++
	yyb171 = !z.DecContainerNext(yyj171, l, yyhl171)
	if yyb171 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.TestStrucCommon.I8n = (int8)(z.C.IntV(r.DecodeInt64(), 8))
	yyj171++
	yyb171 = !z.DecContainerNext(yyj171, l, yyhl171)
	if yyb171 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.TestStrucCommon.Ui64 = (uint64)(r.DecodeUint64())
	yyj171++
	yyb171 = !z.DecContainerNext(yyj171, l, yyhl171)
	if yyb171 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.TestStrucCommon.Ui32 = (uint32)(z.C.UintV(r.DecodeUint64(), 32))
	yyj171++
	yyb171 = !z.DecContainerNext(yyj171, l, yyhl171)
	if yyb171 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.TestStrucCommon.Ui16 = (uint16)(z.C.UintV(r.DecodeUint64(), 16))
	yyj171++
	yyb171 = !z.DecContainerNext(yyj171, l, yyhl171)
	if yyb171 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.TestStrucCommon.Ui8 = (uint8)(z.C.UintV(r.DecodeUint64(), 8))
	yyj171++
	yyb171 = !z.DecContainerNext(yyj171, l, yyhl171)
	if yyb171 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.TestStrucCommon.F64 = (float64)(r.DecodeFloat64())
	yyj171++
	yyb171 = !z.DecContainerNext(yyj171, l, yyhl171)
	if yyb171 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.TestStrucCommon.F32 = (float32)(z.DecDecodeFloat32())
	yyj171++
	yyb171 = !z.DecContainerNext(yyj171, l, yyhl171)
	if yyb171 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.TestStrucCommon.B = (bool)(r.DecodeBool())
	yyj171++
	yyb171 = !z.DecContainerNext(yyj171, l, yyhl171)
	if yyb171 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.TestStrucCommon.By = (uint8)(z.C.UintV(r.DecodeUint64(), 8))
	yyj171++
	yyb171 = !z.DecContainerNext(yyj171, l, yyhl171)
	if yyb171 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	z.F.DecSliceStringX(&x.TestStrucCommon.Sslice, d)
	yyj171++
	yyb171 = !z.DecContainerNext(yyj171, l, yyhl171)
	if yyb171 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	z.F.DecSliceInt64X(&x.TestStrucCommon.I64slice, d)
	yyj171++
	yyb171 = !z.DecContainerNext(yyj171, l, yyhl171)
	if yyb171 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	z.F.DecSliceInt32X(&x.TestStrucCommon.I32slice, d)
	yyj171++
	yyb171 = !z.DecContainerNext(yyj171, l, yyhl171)
	if yyb171 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	z.F.DecSliceUint64X(&x.TestStrucCommon.Ui64slice, d)
	yyj171++
	yyb171 = !z.DecContainerNext(yyj171, l, yyhl171)
	if yyb171 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.TestStrucCommon.Ui8slice = z.DecodeBytesInto(([]byte)(x.TestStrucCommon.Ui8slice))
	yyj171++
	yyb171 = !z.DecContainerNext(yyj171, l, yyhl171)
	if yyb171 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	z.F.DecSliceBoolX(&x.TestStrucCommon.Bslice, d)
	yyj171++
	yyb171 = !z.DecContainerNext(yyj171, l, yyhl171)
	if yyb171 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.TestStrucCommon.Byslice = z.DecodeBytesInto(([]byte)(x.TestStrucCommon.Byslice))
	yyj171++
	yyb171 = !z.DecContainerNext(yyj171, l, yyhl171)
	if yyb171 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	z.F.DecSliceBytesX(&x.TestStrucCommon.BytesSlice, d)
	yyj171++
	yyb171 = !z.DecContainerNext(yyj171, l, yyhl171)
	if yyb171 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	h.decSlicePtrtoint64((*[]*int64)(&x.TestStrucCommon.Iptrslice), d)
	yyj171++
	yyb171 = !z.DecContainerNext(yyj171, l, yyhl171)
	if yyb171 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	if yyxt208 := z.Extension(x.TestStrucCommon.WrapSliceInt64); yyxt208 != nil {
		z.DecExtension(&x.TestStrucCommon.WrapSliceInt64, yyxt208)
	} else {
		x.TestStrucCommon.WrapSliceInt64.CodecDecodeSelf(d)
	}
	yyj171++
	yyb171 = !z.DecContainerNext(yyj171, l, yyhl171)
	if yyb171 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	if yyxt210 := z.Extension(x.TestStrucCommon.WrapSliceString); yyxt210 != nil {
		z.DecExtension(&x.TestStrucCommon.WrapSliceString, yyxt210)
	} else {
		x.TestStrucCommon.WrapSliceString.CodecDecodeSelf(d)
	}
	yyj171++
	yyb171 = !z.DecContainerNext(yyj171, l, yyhl171)
	if yyb171 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	z.F.DecMapStringIntX(&x.TestStrucCommon.Msint, d)
	yyj171++
	yyb171 = !z.DecContainerNext(yyj171, l, yyhl171)
	if yyb171 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	z.F.DecMapStringBytesX(&x.TestStrucCommon.Msbytes, d)
	yyj171++
	yyb171 = !z.DecContainerNext(yyj171, l, yyhl171)
	if yyb171 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	if yyxt216 := z.Extension(x.TestStrucCommon.Simplef); yyxt216 != nil {
		z.DecExtension(&x.TestStrucCommon.Simplef, yyxt216)
	} else {
		x.TestStrucCommon.Simplef.CodecDecodeSelf(d)
	}
	yyj171++
	yyb171 = !z.DecContainerNext(yyj171, l, yyhl171)
	if yyb171 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	h.decSlicestringUint64T((*[]stringUint64T)(&x.TestStrucCommon.SstrUi64T), d)
	yyj171++
	yyb171 = !z.DecContainerNext(yyj171, l, yyhl171)
	if yyb171 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	h.decMapstringPtrtostringUint64T((*map[string]*stringUint64T)(&x.TestStrucCommon.MstrUi64T), d)
	yyj171++
	yyb171 = !z.DecContainerNext(yyj171, l, yyhl171)
	if yyb171 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.TestStrucCommon.AnonInTestStruc.AS = (string)(z.DecStringZC(r.DecodeStringAsBytes()))
	yyj171++
	yyb171 = !z.DecContainerNext(yyj171, l, yyhl171)
	if yyb171 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.TestStrucCommon.AnonInTestStruc.AI64 = (int64)(r.DecodeInt64())
	yyj171++
	yyb171 = !z.DecContainerNext(yyj171, l, yyhl171)
	if yyb171 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.TestStrucCommon.AnonInTestStruc.AI16 = (int16)(z.C.IntV(r.DecodeInt64(), 16))
	yyj171++
	yyb171 = !z.DecContainerNext(yyj171, l, yyhl171)
	if yyb171 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.TestStrucCommon.AnonInTestStruc.AUi64 = (uint64)(r.DecodeUint64())
	yyj171++
	yyb171 = !z.DecContainerNext(yyj171, l, yyhl171)
	if yyb171 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	z.F.DecSliceStringX(&x.TestStrucCommon.AnonInTestStruc.ASslice, d)
	yyj171++
	yyb171 = !z.DecContainerNext(yyj171, l, yyhl171)
	if yyb171 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	z.F.DecSliceInt64X(&x.TestStrucCommon.AnonInTestStruc.AI64slice, d)
	yyj171++
	yyb171 = !z.DecContainerNext(yyj171, l, yyhl171)
	if yyb171 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	z.F.DecSliceUint64X(&x.TestStrucCommon.AnonInTestStruc.AUi64slice, d)
	yyj171++
	yyb171 = !z.DecContainerNext(yyj171, l, yyhl171)
	if yyb171 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	z.F.DecSliceFloat64X(&x.TestStrucCommon.AnonInTestStruc.AF64slice, d)
	yyj171++
	yyb171 = !z.DecContainerNext(yyj171, l, yyhl171)
	if yyb171 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	z.F.DecSliceFloat32X(&x.TestStrucCommon.AnonInTestStruc.AF32slice, d)
	yyj171++
	yyb171 = !z.DecContainerNext(yyj171, l, yyhl171)
	if yyb171 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	z.F.DecMapStringStringX(&x.TestStrucCommon.AnonInTestStruc.AMSS, d)
	yyj171++
	yyb171 = !z.DecContainerNext(yyj171, l, yyhl171)
	if yyb171 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	z.F.DecMapStringUint64X(&x.TestStrucCommon.AnonInTestStruc.AMSU64, d)
	yyj171++
	yyb171 = !z.DecContainerNext(yyj171, l, yyhl171)
	if yyb171 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	h.decArray8int64((*[8]int64)(&x.TestStrucCommon.AnonInTestStruc.AI64arr8), d)
	yyj171++
	yyb171 = !z.DecContainerNext(yyj171, l, yyhl171)
	if yyb171 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	h.decArray0int64((*[0]int64)(&x.TestStrucCommon.AnonInTestStruc.AI64arr0), d)
	yyj171++
	yyb171 = !z.DecContainerNext(yyj171, l, yyhl171)
	if yyb171 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	z.F.DecSliceInt64X(&x.TestStrucCommon.AnonInTestStruc.AI64slice0, d)
	yyj171++
	yyb171 = !z.DecContainerNext(yyj171, l, yyhl171)
	if yyb171 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	z.F.DecSliceUint64X(&x.TestStrucCommon.AnonInTestStruc.AUi64sliceN, d)
	yyj171++
	yyb171 = !z.DecContainerNext(yyj171, l, yyhl171)
	if yyb171 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	z.F.DecMapStringUint64X(&x.TestStrucCommon.AnonInTestStruc.AMSU64N, d)
	yyj171++
	yyb171 = !z.DecContainerNext(yyj171, l, yyhl171)
	if yyb171 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	z.F.DecMapStringUint64X(&x.TestStrucCommon.AnonInTestStruc.AMSU64E, d)
	yyj171++
	yyb171 = !z.DecContainerNext(yyj171, l, yyhl171)
	if yyb171 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	if yyxt252 := z.Extension(x.TestStrucCommon.NotAnon); yyxt252 != nil {
		z.DecExtension(&x.TestStrucCommon.NotAnon, yyxt252)
	} else {
		x.TestStrucCommon.NotAnon.CodecDecodeSelf(d)
	}
	yyj171++
	yyb171 = !z.DecContainerNext(yyj171, l, yyhl171)
	if yyb171 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	if r.TryNil() {
		if x.TestStrucCommon.AnonInTestStrucSlim != nil && x.TestStrucCommon.AnonInTestStrucSlim.P != nil { // remove the if-true
			x.TestStrucCommon.AnonInTestStrucSlim.P = nil
		}
	} else {
		if x.TestStrucCommon.AnonInTestStrucSlim == nil {
			x.TestStrucCommon.AnonInTestStrucSlim = new(AnonInTestStrucSlim)
		}
		if x.TestStrucCommon.AnonInTestStrucSlim.P == nil {
			x.TestStrucCommon.AnonInTestStrucSlim.P = new(string)
		}
		*x.TestStrucCommon.AnonInTestStrucSlim.P = (string)(z.DecStringZC(r.DecodeStringAsBytes()))
	}
	yyj171++
	yyb171 = !z.DecContainerNext(yyj171, l, yyhl171)
	if yyb171 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	if r.TryNil() {
		if x.TestStrucCommon.NotAnonSlim != nil { // remove the if-true
			x.TestStrucCommon.NotAnonSlim = nil
		}
	} else {
		if x.TestStrucCommon.NotAnonSlim == nil {
			x.TestStrucCommon.NotAnonSlim = new(AnonInTestStrucSlim)
		}
		if yyxt256 := z.Extension(x.TestStrucCommon.NotAnonSlim); yyxt256 != nil {
			z.DecExtension(x.TestStrucCommon.NotAnonSlim, yyxt256)
		} else {
			x.TestStrucCommon.NotAnonSlim.CodecDecodeSelf(d)
		}
	}
	yyj171++
	yyb171 = !z.DecContainerNext(yyj171, l, yyhl171)
	if yyb171 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	z.F.DecMapStringBoolX(&x.TestStrucCommon.Nmap, d)
	yyj171++
	yyb171 = !z.DecContainerNext(yyj171, l, yyhl171)
	if yyb171 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.TestStrucCommon.Nslice = z.DecodeBytesInto(([]byte)(x.TestStrucCommon.Nslice))
	yyj171++
	yyb171 = !z.DecContainerNext(yyj171, l, yyhl171)
	if yyb171 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	if r.TryNil() {
		if x.TestStrucCommon.Nint64 != nil { // remove the if-true
			x.TestStrucCommon.Nint64 = nil
		}
	} else {
		if x.TestStrucCommon.Nint64 == nil {
			x.TestStrucCommon.Nint64 = new(int64)
		}
		*x.TestStrucCommon.Nint64 = (int64)(r.DecodeInt64())
	}
	yyj171++
	yyb171 = !z.DecContainerNext(yyj171, l, yyhl171)
	if yyb171 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	h.decChanstring((*chan string)(&x.Chstr), d)
	yyj171++
	yyb171 = !z.DecContainerNext(yyj171, l, yyhl171)
	if yyb171 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	z.F.DecMapIntStringX(&x.Mis, d)
	yyj171++
	yyb171 = !z.DecContainerNext(yyj171, l, yyhl171)
	if yyb171 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	h.decMapboolc3RydWN0IHt9((*map[bool]struct{})(&x.Mbu64), d)
	yyj171++
	yyb171 = !z.DecContainerNext(yyj171, l, yyhl171)
	if yyb171 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	h.decMapuint8c3RydWN0IHt9((*map[uint8]struct{})(&x.Mu8e), d)
	yyj171++
	yyb171 = !z.DecContainerNext(yyj171, l, yyhl171)
	if yyb171 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	h.decMapuint8stringUint64T((*map[uint8]stringUint64T)(&x.Mu8u64), d)
	yyj171++
	yyb171 = !z.DecContainerNext(yyj171, l, yyhl171)
	if yyb171 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	h.decMapPtrtostringSlicestring((*map[*string][]string)(&x.Msp2ss), d)
	yyj171++
	yyb171 = !z.DecContainerNext(yyj171, l, yyhl171)
	if yyb171 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	h.decMapPtrtouint64Slicestring((*map[*uint64][]string)(&x.Mip2ss), d)
	yyj171++
	yyb171 = !z.DecContainerNext(yyj171, l, yyhl171)
	if yyb171 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	h.decMapstringMapuint64stringUint64T((*map[string]map[uint64]stringUint64T)(&x.Ms2misu), d)
	yyj171++
	yyb171 = !z.DecContainerNext(yyj171, l, yyhl171)
	if yyb171 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	h.decMapintwrapUint64Slice((*map[int]wrapUint64Slice)(&x.Miwu64s), d)
	yyj171++
	yyb171 = !z.DecContainerNext(yyj171, l, yyhl171)
	if yyb171 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	h.decMapfloat64wrapStringSlice((*map[float64]wrapStringSlice)(&x.Mfwss), d)
	yyj171++
	yyb171 = !z.DecContainerNext(yyj171, l, yyhl171)
	if yyb171 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	h.decMapfloat32wrapStringSlice((*map[float32]wrapStringSlice)(&x.Mf32wss), d)
	yyj171++
	yyb171 = !z.DecContainerNext(yyj171, l, yyhl171)
	if yyb171 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	h.decMapuint64wrapStringSlice((*map[uint64]wrapStringSlice)(&x.Mui2wss), d)
	yyj171++
	yyb171 = !z.DecContainerNext(yyj171, l, yyhl171)
	if yyb171 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	h.decMapstringUint64TwrapStringSlice((*map[stringUint64T]wrapStringSlice)(&x.Msu2wss), d)
	yyj171++
	yyb171 = !z.DecContainerNext(yyj171, l, yyhl171)
	if yyb171 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	if yyxt290 := z.Extension(x.Ci64); yyxt290 != nil {
		z.DecExtension(&x.Ci64, yyxt290)
	} else {
		x.Ci64.CodecDecodeSelf(d)
	}
	yyj171++
	yyb171 = !z.DecContainerNext(yyj171, l, yyhl171)
	if yyb171 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	h.decSlicewrapBytes((*[]wrapBytes)(&x.Swrapbytes), d)
	yyj171++
	yyb171 = !z.DecContainerNext(yyj171, l, yyhl171)
	if yyb171 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	h.decSlicewrapUint8((*[]wrapUint8)(&x.Swrapuint8), d)
	yyj171++
	yyb171 = !z.DecContainerNext(yyj171, l, yyhl171)
	if yyb171 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	h.decArray4stringUint64T((*[4]stringUint64T)(&x.ArrStrUi64T), d)
	yyj171++
	yyb171 = !z.DecContainerNext(yyj171, l, yyhl171)
	if yyb171 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	h.decArray4uint64((*[4]uint64)(&x.Ui64array), d)
	yyj171++
	yyb171 = !z.DecContainerNext(yyj171, l, yyhl171)
	if yyb171 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	h.decSlicePtrtoArray4uint64((*[]*[4]uint64)(&x.Ui64slicearray), d)
	yyj171++
	yyb171 = !z.DecContainerNext(yyj171, l, yyhl171)
	if yyb171 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	z.F.DecSliceIntfX(&x.SintfAarray, d)
	yyj171++
	yyb171 = !z.DecContainerNext(yyj171, l, yyhl171)
	if yyb171 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	h.decMapstringUint64TPtrtostringUint64T((*map[stringUint64T]*stringUint64T)(&x.MstrUi64TSelf), d)
	yyj171++
	yyb171 = !z.DecContainerNext(yyj171, l, yyhl171)
	if yyb171 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	if z.DecBasicHandle().TimeBuiltin() {
		x.Ttime = r.DecodeTime()
	} else if yyxt306 := z.Extension(x.Ttime); yyxt306 != nil {
		z.DecExtension(&x.Ttime, yyxt306)
	} else if z.DecBinary() {
		z.DecBinaryUnmarshal(&x.Ttime)
	} else if !z.DecBinary() && z.IsJSONHandle() {
		z.DecJSONUnmarshal(&x.Ttime)
	} else {
		z.DecFallback(&x.Ttime, false)
	}
	yyj171++
	yyb171 = !z.DecContainerNext(yyj171, l, yyhl171)
	if yyb171 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	if r.TryNil() {
		if x.Ttimeptr != nil { // remove the if-true
			x.Ttimeptr = nil
		}
	} else {
		if x.Ttimeptr == nil {
			x.Ttimeptr = new(time.Time)
		}
		if z.DecBasicHandle().TimeBuiltin() {
			*x.Ttimeptr = r.DecodeTime()
		} else if yyxt308 := z.Extension(x.Ttimeptr); yyxt308 != nil {
			z.DecExtension(x.Ttimeptr, yyxt308)
		} else if z.DecBinary() {
			z.DecBinaryUnmarshal(x.Ttimeptr)
		} else if !z.DecBinary() && z.IsJSONHandle() {
			z.DecJSONUnmarshal(x.Ttimeptr)
		} else {
			z.DecFallback(x.Ttimeptr, false)
		}
	}
	yyj171++
	yyb171 = !z.DecContainerNext(yyj171, l, yyhl171)
	if yyb171 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	if r.TryNil() {
		if x.AnonInTestStrucIntf != nil { // remove the if-true
			x.AnonInTestStrucIntf.Islice = nil
		}
	} else {
		if x.AnonInTestStrucIntf == nil {
			x.AnonInTestStrucIntf = new(AnonInTestStrucIntf)
		}
		z.F.DecSliceIntfX(&x.AnonInTestStrucIntf.Islice, d)
	}
	yyj171++
	yyb171 = !z.DecContainerNext(yyj171, l, yyhl171)
	if yyb171 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	if r.TryNil() {
		if x.AnonInTestStrucIntf != nil { // remove the if-true
			x.AnonInTestStrucIntf.Ms = nil
		}
	} else {
		if x.AnonInTestStrucIntf == nil {
			x.AnonInTestStrucIntf = new(AnonInTestStrucIntf)
		}
		z.F.DecMapStringIntfX(&x.AnonInTestStrucIntf.Ms, d)
	}
	yyj171++
	yyb171 = !z.DecContainerNext(yyj171, l, yyhl171)
	if yyb171 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	if r.TryNil() {
		if x.AnonInTestStrucIntf != nil { // remove the if-true
			x.AnonInTestStrucIntf.Nintf = nil
		}
	} else {
		if x.AnonInTestStrucIntf == nil {
			x.AnonInTestStrucIntf = new(AnonInTestStrucIntf)
		}
		z.DecFallback(&x.AnonInTestStrucIntf.Nintf, true)
	}
	yyj171++
	yyb171 = !z.DecContainerNext(yyj171, l, yyhl171)
	if yyb171 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	if r.TryNil() {
		if x.AnonInTestStrucIntf != nil { // remove the if-true
			x.AnonInTestStrucIntf.T = time.Time{}
		}
	} else {
		if x.AnonInTestStrucIntf == nil {
			x.AnonInTestStrucIntf = new(AnonInTestStrucIntf)
		}
		if z.DecBasicHandle().TimeBuiltin() {
			x.AnonInTestStrucIntf.T = r.DecodeTime()
		} else if yyxt316 := z.Extension(x.AnonInTestStrucIntf.T); yyxt316 != nil {
			z.DecExtension(&x.AnonInTestStrucIntf.T, yyxt316)
		} else if z.DecBinary() {
			z.DecBinaryUnmarshal(&x.AnonInTestStrucIntf.T)
		} else if !z.DecBinary() && z.IsJSONHandle() {
			z.DecJSONUnmarshal(&x.AnonInTestStrucIntf.T)
		} else {
			z.DecFallback(&x.AnonInTestStrucIntf.T, false)
		}
	}
	yyj171++
	yyb171 = !z.DecContainerNext(yyj171, l, yyhl171)
	if yyb171 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	if r.TryNil() {
		if x.AnonInTestStrucIntf != nil && x.AnonInTestStrucIntf.Tptr != nil { // remove the if-true
			x.AnonInTestStrucIntf.Tptr = nil
		}
	} else {
		if x.AnonInTestStrucIntf == nil {
			x.AnonInTestStrucIntf = new(AnonInTestStrucIntf)
		}
		if x.AnonInTestStrucIntf.Tptr == nil {
			x.AnonInTestStrucIntf.Tptr = new(time.Time)
		}
		if z.DecBasicHandle().TimeBuiltin() {
			*x.AnonInTestStrucIntf.Tptr = r.DecodeTime()
		} else if yyxt318 := z.Extension(x.AnonInTestStrucIntf.Tptr); yyxt318 != nil {
			z.DecExtension(x.AnonInTestStrucIntf.Tptr, yyxt318)
		} else if z.DecBinary() {
			z.DecBinaryUnmarshal(x.AnonInTestStrucIntf.Tptr)
		} else if !z.DecBinary() && z.IsJSONHandle() {
			z.DecJSONUnmarshal(x.AnonInTestStrucIntf.Tptr)
		} else {
			z.DecFallback(x.AnonInTestStrucIntf.Tptr, false)
		}
	}
	yyj171++
	yyb171 = !z.DecContainerNext(yyj171, l, yyhl171)
	if yyb171 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	h.decMapwrapStringInterface((*map[wrapString]interface{})(&x.Msu), d)
	yyj171++
	yyb171 = !z.DecContainerNext(yyj171, l, yyhl171)
	if yyb171 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	h.decMapstringPtrtoTestStrucFlex((*map[string]*TestStrucFlex)(&x.Mtsptr), d)
	yyj171++
	yyb171 = !z.DecContainerNext(yyj171, l, yyhl171)
	if yyb171 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	h.decMapstringTestStrucFlex((*map[string]TestStrucFlex)(&x.Mts), d)
	yyj171++
	yyb171 = !z.DecContainerNext(yyj171, l, yyhl171)
	if yyb171 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	h.decSlicePtrtoTestStrucFlex((*[]*TestStrucFlex)(&x.Its), d)
	yyj171++
	yyb171 = !z.DecContainerNext(yyj171, l, yyhl171)
	if yyb171 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	if r.TryNil() {
		if x.Nteststruc != nil { // remove the if-true
			x.Nteststruc = nil
		}
	} else {
		if x.Nteststruc == nil {
			x.Nteststruc = new(TestStrucFlex)
		}
		if yyxt328 := z.Extension(x.Nteststruc); yyxt328 != nil {
			z.DecExtension(x.Nteststruc, yyxt328)
		} else {
			x.Nteststruc.CodecDecodeSelf(d)
		}
	}
	yyj171++
	yyb171 = !z.DecContainerNext(yyj171, l, yyhl171)
	if yyb171 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	if yyxt330 := z.Extension(x.MarJ); yyxt330 != nil {
		z.DecExtension(&x.MarJ, yyxt330)
	} else {
		x.MarJ.CodecDecodeSelf(d)
	}
	yyj171++
	yyb171 = !z.DecContainerNext(yyj171, l, yyhl171)
	if yyb171 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	if yyxt332 := z.Extension(x.MarT); yyxt332 != nil {
		z.DecExtension(&x.MarT, yyxt332)
	} else {
		x.MarT.CodecDecodeSelf(d)
	}
	yyj171++
	yyb171 = !z.DecContainerNext(yyj171, l, yyhl171)
	if yyb171 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	if yyxt334 := z.Extension(x.MarB); yyxt334 != nil {
		z.DecExtension(&x.MarB, yyxt334)
	} else {
		x.MarB.CodecDecodeSelf(d)
	}
	yyj171++
	yyb171 = !z.DecContainerNext(yyj171, l, yyhl171)
	if yyb171 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	if yyxt336 := z.Extension(x.XuintToBytes); yyxt336 != nil {
		z.DecExtension(&x.XuintToBytes, yyxt336)
	} else {
		x.XuintToBytes.CodecDecodeSelf(d)
	}
	yyj171++
	yyb171 = !z.DecContainerNext(yyj171, l, yyhl171)
	if yyb171 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.Cmplx64 = (complex64)(complex(z.DecDecodeFloat32(), 0))
	yyj171++
	yyb171 = !z.DecContainerNext(yyj171, l, yyhl171)
	if yyb171 {
		z.DecReadArrayEnd()
		return
	}
	z.DecReadArrayElem()
	x.Cmplx128 = (complex128)(complex(r.DecodeFloat64(), 0))
	yyj171++
	for ; z.DecContainerNext(yyj171, l, yyhl171); yyj171++ {
		z.DecReadArrayElem()
		z.DecStructFieldNotFound(yyj171-1, "")
	}
}

func (x *TestStrucFlex) IsCodecEmpty() bool {
	return !(!(x.TestStrucCommon.IsCodecEmpty()) || len(x.Chstr) != 0 || len(x.Mis) != 0 || len(x.Mbu64) != 0 || len(x.Mu8e) != 0 || len(x.Mu8u64) != 0 || len(x.Msp2ss) != 0 || len(x.Mip2ss) != 0 || len(x.Ms2misu) != 0 || len(x.Miwu64s) != 0 || len(x.Mfwss) != 0 || len(x.Mf32wss) != 0 || len(x.Mui2wss) != 0 || len(x.Msu2wss) != 0 || x.Ci64 != 0 || len(x.Swrapbytes) != 0 || len(x.Swrapuint8) != 0 || x.ArrStrUi64T != [4]stringUint64T{} || x.Ui64array != [4]uint64{} || len(x.Ui64slicearray) != 0 || len(x.SintfAarray) != 0 || len(x.MstrUi64TSelf) != 0 || !(x.Ttime.IsZero()) || x.AnonInTestStrucIntf != nil && len(x.Msu) != 0 || len(x.Mtsptr) != 0 || len(x.Mts) != 0 || len(x.Its) != 0 || bool(x.MarJ) || x.MarT != "" || len(x.MarB) != 0 || x.XuintToBytes != 0 || x.Cmplx64 != 0 || x.Cmplx128 != 0 || false)
}

func (x codecSelfer19780) encwrapUint64Slice(v wrapUint64Slice, e *Encoder) {
	var h codecSelfer19780
	z, r := GenHelper().Encoder(e)
	_, _, _ = h, z, r
	if v == nil {
		r.EncodeNil()
		return
	}
	z.EncWriteArrayStart(len(v))
	for yyv1 := range v {
		z.EncWriteArrayElem()
		if yyxt2 := z.Extension(v[yyv1]); yyxt2 != nil {
			z.EncExtension(v[yyv1], yyxt2)
		} else {
			v[yyv1].CodecEncodeSelf(e)
		}
	}
	z.EncWriteArrayEnd()
}

func (x codecSelfer19780) decwrapUint64Slice(v *wrapUint64Slice, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelper().Decoder(d)
	_, _, _ = h, z, r

	yyv1 := *v
	yyh1, yyl1 := z.DecSliceHelperStart()
	var yyc1 bool
	_ = yyc1
	if yyh1.IsNil {
		if yyv1 != nil {
			yyv1 = nil
			yyc1 = true
		}
	} else if yyl1 == 0 {
		if yyv1 == nil {
			yyv1 = []wrapUint64{}
			yyc1 = true
		} else if len(yyv1) != 0 {
			yyv1 = yyv1[:0]
			yyc1 = true
		}
	} else {
		yyhl1 := yyl1 > 0
		var yyrl1 int
		_ = yyrl1
		if yyhl1 {
			if yyl1 > cap(yyv1) {
				yyrl1 = z.DecInferLen(yyl1, z.DecBasicHandle().MaxInitLen, 8)
				if yyrl1 <= cap(yyv1) {
					yyv1 = yyv1[:yyrl1]
				} else {
					yyv1 = make([]wrapUint64, yyrl1)
				}
				yyc1 = true
			} else if yyl1 != len(yyv1) {
				yyv1 = yyv1[:yyl1]
				yyc1 = true
			}
		}
		var yyj1 int
		for yyj1 = 0; z.DecContainerNext(yyj1, yyl1, yyhl1); yyj1++ {
			if yyj1 == 0 && yyv1 == nil {
				if yyhl1 {
					yyrl1 = z.DecInferLen(yyl1, z.DecBasicHandle().MaxInitLen, 8)
				} else {
					yyrl1 = 8
				}
				yyv1 = make([]wrapUint64, yyrl1)
				yyc1 = true
			}
			yyh1.ElemContainerState(yyj1)
			var yydb1 bool
			if yyj1 >= len(yyv1) {
				yyv1 = append(yyv1, 0)
				yyc1 = true
			}
			if yydb1 {
				z.DecSwallow()
			} else {
				if yyxt3 := z.Extension(yyv1[yyj1]); yyxt3 != nil {
					z.DecExtension(&yyv1[yyj1], yyxt3)
				} else {
					yyv1[yyj1].CodecDecodeSelf(d)
				}
			}
		}
		if yyj1 < len(yyv1) {
			yyv1 = yyv1[:yyj1]
			yyc1 = true
		} else if yyj1 == 0 && yyv1 == nil {
			yyv1 = []wrapUint64{}
			yyc1 = true
		}
	}
	yyh1.End()
	if yyc1 {
		*v = yyv1
	}
}

func (x codecSelfer19780) encwrapStringSlice(v wrapStringSlice, e *Encoder) {
	var h codecSelfer19780
	z, r := GenHelper().Encoder(e)
	_, _, _ = h, z, r
	if v == nil {
		r.EncodeNil()
		return
	}
	z.EncWriteArrayStart(len(v))
	for yyv1 := range v {
		z.EncWriteArrayElem()
		if yyxt2 := z.Extension(v[yyv1]); yyxt2 != nil {
			z.EncExtension(v[yyv1], yyxt2)
		} else {
			v[yyv1].CodecEncodeSelf(e)
		}
	}
	z.EncWriteArrayEnd()
}

func (x codecSelfer19780) decwrapStringSlice(v *wrapStringSlice, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelper().Decoder(d)
	_, _, _ = h, z, r

	yyv1 := *v
	yyh1, yyl1 := z.DecSliceHelperStart()
	var yyc1 bool
	_ = yyc1
	if yyh1.IsNil {
		if yyv1 != nil {
			yyv1 = nil
			yyc1 = true
		}
	} else if yyl1 == 0 {
		if yyv1 == nil {
			yyv1 = []wrapString{}
			yyc1 = true
		} else if len(yyv1) != 0 {
			yyv1 = yyv1[:0]
			yyc1 = true
		}
	} else {
		yyhl1 := yyl1 > 0
		var yyrl1 int
		_ = yyrl1
		if yyhl1 {
			if yyl1 > cap(yyv1) {
				yyrl1 = z.DecInferLen(yyl1, z.DecBasicHandle().MaxInitLen, 16)
				if yyrl1 <= cap(yyv1) {
					yyv1 = yyv1[:yyrl1]
				} else {
					yyv1 = make([]wrapString, yyrl1)
				}
				yyc1 = true
			} else if yyl1 != len(yyv1) {
				yyv1 = yyv1[:yyl1]
				yyc1 = true
			}
		}
		var yyj1 int
		for yyj1 = 0; z.DecContainerNext(yyj1, yyl1, yyhl1); yyj1++ {
			if yyj1 == 0 && yyv1 == nil {
				if yyhl1 {
					yyrl1 = z.DecInferLen(yyl1, z.DecBasicHandle().MaxInitLen, 16)
				} else {
					yyrl1 = 8
				}
				yyv1 = make([]wrapString, yyrl1)
				yyc1 = true
			}
			yyh1.ElemContainerState(yyj1)
			var yydb1 bool
			if yyj1 >= len(yyv1) {
				yyv1 = append(yyv1, "")
				yyc1 = true
			}
			if yydb1 {
				z.DecSwallow()
			} else {
				if yyxt3 := z.Extension(yyv1[yyj1]); yyxt3 != nil {
					z.DecExtension(&yyv1[yyj1], yyxt3)
				} else {
					yyv1[yyj1].CodecDecodeSelf(d)
				}
			}
		}
		if yyj1 < len(yyv1) {
			yyv1 = yyv1[:yyj1]
			yyc1 = true
		} else if yyj1 == 0 && yyv1 == nil {
			yyv1 = []wrapString{}
			yyc1 = true
		}
	}
	yyh1.End()
	if yyc1 {
		*v = yyv1
	}
}

func (x codecSelfer19780) encArray8int64(v *[8]int64, e *Encoder) {
	var h codecSelfer19780
	z, r := GenHelper().Encoder(e)
	_, _, _ = h, z, r
	if v == nil {
		r.EncodeNil()
		return
	}
	z.EncWriteArrayStart(len(v))
	for yyv1 := range v {
		z.EncWriteArrayElem()
		r.EncodeInt(int64(v[yyv1]))
	}
	z.EncWriteArrayEnd()
}

func (x codecSelfer19780) decArray8int64(v *[8]int64, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelper().Decoder(d)
	_, _, _ = h, z, r

	yyv1 := v
	yyh1, yyl1 := z.DecSliceHelperStart()
	if yyl1 == 0 {
	} else {
		yyhl1 := yyl1 > 0
		var yyrl1 int
		_ = yyrl1
		var yyj1 int
		for yyj1 = 0; z.DecContainerNext(yyj1, yyl1, yyhl1); yyj1++ {
			yyh1.ElemContainerState(yyj1)
			var yydb1 bool
			if yyj1 >= len(yyv1) {
				z.DecArrayCannotExpand(len(v), yyj1+1)
				yydb1 = true
			}
			if yydb1 {
				z.DecSwallow()
			} else {
				yyv1[yyj1] = (int64)(r.DecodeInt64())
			}
		}
	}
	yyh1.End()
}

func (x codecSelfer19780) encArray0int64(v *[0]int64, e *Encoder) {
	var h codecSelfer19780
	z, r := GenHelper().Encoder(e)
	_, _, _ = h, z, r
	if v == nil {
		r.EncodeNil()
		return
	}
	z.EncWriteArrayStart(len(v))
	for yyv1 := range v {
		z.EncWriteArrayElem()
		r.EncodeInt(int64(v[yyv1]))
	}
	z.EncWriteArrayEnd()
}

func (x codecSelfer19780) decArray0int64(v *[0]int64, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelper().Decoder(d)
	_, _, _ = h, z, r

	yyv1 := v
	yyh1, yyl1 := z.DecSliceHelperStart()
	if yyl1 == 0 {
	} else {
		yyhl1 := yyl1 > 0
		var yyrl1 int
		_ = yyrl1
		var yyj1 int
		for yyj1 = 0; z.DecContainerNext(yyj1, yyl1, yyhl1); yyj1++ {
			yyh1.ElemContainerState(yyj1)
			var yydb1 bool
			if yyj1 >= len(yyv1) {
				z.DecArrayCannotExpand(len(v), yyj1+1)
				yydb1 = true
			}
			if yydb1 {
				z.DecSwallow()
			} else {
				yyv1[yyj1] = (int64)(r.DecodeInt64())
			}
		}
	}
	yyh1.End()
}

func (x codecSelfer19780) encSlicePtrtoint64(v []*int64, e *Encoder) {
	var h codecSelfer19780
	z, r := GenHelper().Encoder(e)
	_, _, _ = h, z, r
	if v == nil {
		r.EncodeNil()
		return
	}
	z.EncWriteArrayStart(len(v))
	for yyv1 := range v {
		z.EncWriteArrayElem()
		if v[yyv1] == nil {
			r.EncodeNil()
		} else {
			yy2 := *v[yyv1]
			r.EncodeInt(int64(yy2))
		}
	}
	z.EncWriteArrayEnd()
}

func (x codecSelfer19780) decSlicePtrtoint64(v *[]*int64, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelper().Decoder(d)
	_, _, _ = h, z, r

	yyv1 := *v
	yyh1, yyl1 := z.DecSliceHelperStart()
	var yyc1 bool
	_ = yyc1
	if yyh1.IsNil {
		if yyv1 != nil {
			yyv1 = nil
			yyc1 = true
		}
	} else if yyl1 == 0 {
		if yyv1 == nil {
			yyv1 = []*int64{}
			yyc1 = true
		} else if len(yyv1) != 0 {
			yyv1 = yyv1[:0]
			yyc1 = true
		}
	} else {
		yyhl1 := yyl1 > 0
		var yyrl1 int
		_ = yyrl1
		if yyhl1 {
			if yyl1 > cap(yyv1) {
				yyrl1 = z.DecInferLen(yyl1, z.DecBasicHandle().MaxInitLen, 8)
				if yyrl1 <= cap(yyv1) {
					yyv1 = yyv1[:yyrl1]
				} else {
					yyv1 = make([]*int64, yyrl1)
				}
				yyc1 = true
			} else if yyl1 != len(yyv1) {
				yyv1 = yyv1[:yyl1]
				yyc1 = true
			}
		}
		var yyj1 int
		for yyj1 = 0; z.DecContainerNext(yyj1, yyl1, yyhl1); yyj1++ {
			if yyj1 == 0 && yyv1 == nil {
				if yyhl1 {
					yyrl1 = z.DecInferLen(yyl1, z.DecBasicHandle().MaxInitLen, 8)
				} else {
					yyrl1 = 8
				}
				yyv1 = make([]*int64, yyrl1)
				yyc1 = true
			}
			yyh1.ElemContainerState(yyj1)
			var yydb1 bool
			if yyj1 >= len(yyv1) {
				yyv1 = append(yyv1, nil)
				yyc1 = true
			}
			if yydb1 {
				z.DecSwallow()
			} else {
				if r.TryNil() {
					yyv1[yyj1] = nil
				} else {
					if yyv1[yyj1] == nil {
						yyv1[yyj1] = new(int64)
					}
					*yyv1[yyj1] = (int64)(r.DecodeInt64())
				}
			}
		}
		if yyj1 < len(yyv1) {
			yyv1 = yyv1[:yyj1]
			yyc1 = true
		} else if yyj1 == 0 && yyv1 == nil {
			yyv1 = []*int64{}
			yyc1 = true
		}
	}
	yyh1.End()
	if yyc1 {
		*v = yyv1
	}
}

func (x codecSelfer19780) encSlicestringUint64T(v []stringUint64T, e *Encoder) {
	var h codecSelfer19780
	z, r := GenHelper().Encoder(e)
	_, _, _ = h, z, r
	if v == nil {
		r.EncodeNil()
		return
	}
	z.EncWriteArrayStart(len(v))
	for yyv1 := range v {
		z.EncWriteArrayElem()
		yy2 := &v[yyv1]
		if yyxt3 := z.Extension(yy2); yyxt3 != nil {
			z.EncExtension(yy2, yyxt3)
		} else {
			yy2.CodecEncodeSelf(e)
		}
	}
	z.EncWriteArrayEnd()
}

func (x codecSelfer19780) decSlicestringUint64T(v *[]stringUint64T, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelper().Decoder(d)
	_, _, _ = h, z, r

	yyv1 := *v
	yyh1, yyl1 := z.DecSliceHelperStart()
	var yyc1 bool
	_ = yyc1
	if yyh1.IsNil {
		if yyv1 != nil {
			yyv1 = nil
			yyc1 = true
		}
	} else if yyl1 == 0 {
		if yyv1 == nil {
			yyv1 = []stringUint64T{}
			yyc1 = true
		} else if len(yyv1) != 0 {
			yyv1 = yyv1[:0]
			yyc1 = true
		}
	} else {
		yyhl1 := yyl1 > 0
		var yyrl1 int
		_ = yyrl1
		if yyhl1 {
			if yyl1 > cap(yyv1) {
				yyrl1 = z.DecInferLen(yyl1, z.DecBasicHandle().MaxInitLen, 24)
				if yyrl1 <= cap(yyv1) {
					yyv1 = yyv1[:yyrl1]
				} else {
					yyv1 = make([]stringUint64T, yyrl1)
				}
				yyc1 = true
			} else if yyl1 != len(yyv1) {
				yyv1 = yyv1[:yyl1]
				yyc1 = true
			}
		}
		var yyj1 int
		for yyj1 = 0; z.DecContainerNext(yyj1, yyl1, yyhl1); yyj1++ {
			if yyj1 == 0 && yyv1 == nil {
				if yyhl1 {
					yyrl1 = z.DecInferLen(yyl1, z.DecBasicHandle().MaxInitLen, 24)
				} else {
					yyrl1 = 8
				}
				yyv1 = make([]stringUint64T, yyrl1)
				yyc1 = true
			}
			yyh1.ElemContainerState(yyj1)
			var yydb1 bool
			if yyj1 >= len(yyv1) {
				yyv1 = append(yyv1, stringUint64T{})
				yyc1 = true
			}
			if yydb1 {
				z.DecSwallow()
			} else {
				if yyxt3 := z.Extension(yyv1[yyj1]); yyxt3 != nil {
					z.DecExtension(&yyv1[yyj1], yyxt3)
				} else {
					yyv1[yyj1].CodecDecodeSelf(d)
				}
			}
		}
		if yyj1 < len(yyv1) {
			yyv1 = yyv1[:yyj1]
			yyc1 = true
		} else if yyj1 == 0 && yyv1 == nil {
			yyv1 = []stringUint64T{}
			yyc1 = true
		}
	}
	yyh1.End()
	if yyc1 {
		*v = yyv1
	}
}

func (x codecSelfer19780) encMapstringPtrtostringUint64T(v map[string]*stringUint64T, e *Encoder) {
	var h codecSelfer19780
	z, r := GenHelper().Encoder(e)
	_, _, _ = h, z, r
	if v == nil {
		r.EncodeNil()
	} else if z.EncBasicHandle().Canonical {
		yys1 := make([]string, 0, len(v))
		for k, _ := range v {
			yys1 = append(yys1, string(k))
		}
		sort.Sort(codecSelfer19780stringSlice(yys1))
		z.EncWriteMapStart(len(v))
		for _, yyv1 := range yys1 {
			z.EncWriteMapElemKey()
			r.EncodeString(yyv1)
			z.EncWriteMapElemValue()
			yye1 := v[string(yyv1)]
			if yye1 == nil {
				r.EncodeNil()
			} else {
				if yyxt2 := z.Extension(yye1); yyxt2 != nil {
					z.EncExtension(yye1, yyxt2)
				} else {
					yye1.CodecEncodeSelf(e)
				}
			}
		}
		z.EncWriteMapEnd()
	} else {
		z.EncWriteMapStart(len(v))
		for yyk1, yyv1 := range v {
			z.EncWriteMapElemKey()
			r.EncodeString(string(yyk1))
			z.EncWriteMapElemValue()
			if yyv1 == nil {
				r.EncodeNil()
			} else {
				if yyxt4 := z.Extension(yyv1); yyxt4 != nil {
					z.EncExtension(yyv1, yyxt4)
				} else {
					yyv1.CodecEncodeSelf(e)
				}
			}
		}
		z.EncWriteMapEnd()
	}
}

func (x codecSelfer19780) decMapstringPtrtostringUint64T(v *map[string]*stringUint64T, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelper().Decoder(d)
	_, _, _ = h, z, r

	yyv1 := *v
	yyl1 := z.DecReadMapStart()
	if yyl1 == codecSelferDecContainerLenNil19780 {
		*v = nil
	} else {
		if yyv1 == nil {
			yyrl1 := z.DecInferLen(yyl1, z.DecBasicHandle().MaxInitLen, 24)
			yyv1 = make(map[string]*stringUint64T, yyrl1)
			*v = yyv1
		}
		var yymk1 string
		var yymv1 *stringUint64T
		var yymg1, yymdn1, yyms1, yymok1 bool
		if z.DecBasicHandle().MapValueReset {
			yymg1 = true
		}
		if yyl1 != 0 {
			yyhl1 := yyl1 > 0
			for yyj1 := 0; z.DecContainerNext(yyj1, yyl1, yyhl1); yyj1++ {
				z.DecReadMapElemKey()
				yymk1 = (string)(z.DecStringZC(r.DecodeStringAsBytes()))
				yyms1 = true
				if yymg1 {
					yymv1, yymok1 = yyv1[yymk1]
					if yymok1 {
						yyms1 = false
					}
				} else {
					yymv1 = nil
				}
				z.DecReadMapElemValue()
				yymdn1 = false
				if r.TryNil() {
					yymdn1 = true
				} else {
					if yymv1 == nil {
						yymv1 = new(stringUint64T)
					}
					if yyxt4 := z.Extension(yymv1); yyxt4 != nil {
						z.DecExtension(yymv1, yyxt4)
					} else {
						yymv1.CodecDecodeSelf(d)
					}
				}
				if yymdn1 {
					yyv1[yymk1] = nil
				} else if yyms1 {
					yyv1[yymk1] = yymv1
				}
			}
		} // else len==0: leave as-is (do not clear map entries)
		z.DecReadMapEnd()
	}
}

func (x codecSelfer19780) encMapstringPtrtoTestStruc(v map[string]*TestStruc, e *Encoder) {
	var h codecSelfer19780
	z, r := GenHelper().Encoder(e)
	_, _, _ = h, z, r
	if v == nil {
		r.EncodeNil()
	} else if z.EncBasicHandle().Canonical {
		yys1 := make([]string, 0, len(v))
		for k, _ := range v {
			yys1 = append(yys1, string(k))
		}
		sort.Sort(codecSelfer19780stringSlice(yys1))
		z.EncWriteMapStart(len(v))
		for _, yyv1 := range yys1 {
			z.EncWriteMapElemKey()
			r.EncodeString(yyv1)
			z.EncWriteMapElemValue()
			yye1 := v[string(yyv1)]
			if yye1 == nil {
				r.EncodeNil()
			} else {
				if yyxt2 := z.Extension(yye1); yyxt2 != nil {
					z.EncExtension(yye1, yyxt2)
				} else {
					yye1.CodecEncodeSelf(e)
				}
			}
		}
		z.EncWriteMapEnd()
	} else {
		z.EncWriteMapStart(len(v))
		for yyk1, yyv1 := range v {
			z.EncWriteMapElemKey()
			r.EncodeString(string(yyk1))
			z.EncWriteMapElemValue()
			if yyv1 == nil {
				r.EncodeNil()
			} else {
				if yyxt4 := z.Extension(yyv1); yyxt4 != nil {
					z.EncExtension(yyv1, yyxt4)
				} else {
					yyv1.CodecEncodeSelf(e)
				}
			}
		}
		z.EncWriteMapEnd()
	}
}

func (x codecSelfer19780) decMapstringPtrtoTestStruc(v *map[string]*TestStruc, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelper().Decoder(d)
	_, _, _ = h, z, r

	yyv1 := *v
	yyl1 := z.DecReadMapStart()
	if yyl1 == codecSelferDecContainerLenNil19780 {
		*v = nil
	} else {
		if yyv1 == nil {
			yyrl1 := z.DecInferLen(yyl1, z.DecBasicHandle().MaxInitLen, 24)
			yyv1 = make(map[string]*TestStruc, yyrl1)
			*v = yyv1
		}
		var yymk1 string
		var yymv1 *TestStruc
		var yymg1, yymdn1, yyms1, yymok1 bool
		if z.DecBasicHandle().MapValueReset {
			yymg1 = true
		}
		if yyl1 != 0 {
			yyhl1 := yyl1 > 0
			for yyj1 := 0; z.DecContainerNext(yyj1, yyl1, yyhl1); yyj1++ {
				z.DecReadMapElemKey()
				yymk1 = (string)(z.DecStringZC(r.DecodeStringAsBytes()))
				yyms1 = true
				if yymg1 {
					yymv1, yymok1 = yyv1[yymk1]
					if yymok1 {
						yyms1 = false
					}
				} else {
					yymv1 = nil
				}
				z.DecReadMapElemValue()
				yymdn1 = false
				if r.TryNil() {
					yymdn1 = true
				} else {
					if yymv1 == nil {
						yymv1 = new(TestStruc)
					}
					if yyxt4 := z.Extension(yymv1); yyxt4 != nil {
						z.DecExtension(yymv1, yyxt4)
					} else {
						yymv1.CodecDecodeSelf(d)
					}
				}
				if yymdn1 {
					yyv1[yymk1] = nil
				} else if yyms1 {
					yyv1[yymk1] = yymv1
				}
			}
		} // else len==0: leave as-is (do not clear map entries)
		z.DecReadMapEnd()
	}
}

func (x codecSelfer19780) encMapstringTestStruc(v map[string]TestStruc, e *Encoder) {
	var h codecSelfer19780
	z, r := GenHelper().Encoder(e)
	_, _, _ = h, z, r
	if v == nil {
		r.EncodeNil()
	} else if z.EncBasicHandle().Canonical {
		yys1 := make([]string, 0, len(v))
		for k, _ := range v {
			yys1 = append(yys1, string(k))
		}
		sort.Sort(codecSelfer19780stringSlice(yys1))
		z.EncWriteMapStart(len(v))
		for _, yyv1 := range yys1 {
			z.EncWriteMapElemKey()
			r.EncodeString(yyv1)
			z.EncWriteMapElemValue()
			yye1 := v[string(yyv1)]
			yy2 := &yye1
			if yyxt3 := z.Extension(yy2); yyxt3 != nil {
				z.EncExtension(yy2, yyxt3)
			} else {
				yy2.CodecEncodeSelf(e)
			}
		}
		z.EncWriteMapEnd()
	} else {
		z.EncWriteMapStart(len(v))
		for yyk1, yyv1 := range v {
			z.EncWriteMapElemKey()
			r.EncodeString(string(yyk1))
			z.EncWriteMapElemValue()
			yy5 := &yyv1
			if yyxt6 := z.Extension(yy5); yyxt6 != nil {
				z.EncExtension(yy5, yyxt6)
			} else {
				yy5.CodecEncodeSelf(e)
			}
		}
		z.EncWriteMapEnd()
	}
}

func (x codecSelfer19780) decMapstringTestStruc(v *map[string]TestStruc, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelper().Decoder(d)
	_, _, _ = h, z, r

	yyv1 := *v
	yyl1 := z.DecReadMapStart()
	if yyl1 == codecSelferDecContainerLenNil19780 {
		*v = nil
	} else {
		if yyv1 == nil {
			yyrl1 := z.DecInferLen(yyl1, z.DecBasicHandle().MaxInitLen, 1384)
			yyv1 = make(map[string]TestStruc, yyrl1)
			*v = yyv1
		}
		var yymk1 string
		var yymv1 TestStruc
		var yymg1, yymdn1 bool
		if z.DecBasicHandle().MapValueReset {
			yymg1 = true
		}
		if yyl1 != 0 {
			yyhl1 := yyl1 > 0
			for yyj1 := 0; z.DecContainerNext(yyj1, yyl1, yyhl1); yyj1++ {
				z.DecReadMapElemKey()
				yymk1 = (string)(z.DecStringZC(r.DecodeStringAsBytes()))
				if yymg1 {
					yymv1 = yyv1[yymk1]
				} else {
					yymv1 = TestStruc{}
				}
				z.DecReadMapElemValue()
				yymdn1 = false
				if yyxt4 := z.Extension(yymv1); yyxt4 != nil {
					z.DecExtension(&yymv1, yyxt4)
				} else {
					yymv1.CodecDecodeSelf(d)
				}
				if yymdn1 {
					yyv1[yymk1] = TestStruc{}
				} else {
					yyv1[yymk1] = yymv1
				}
			}
		} // else len==0: leave as-is (do not clear map entries)
		z.DecReadMapEnd()
	}
}

func (x codecSelfer19780) encSlicePtrtoTestStruc(v []*TestStruc, e *Encoder) {
	var h codecSelfer19780
	z, r := GenHelper().Encoder(e)
	_, _, _ = h, z, r
	if v == nil {
		r.EncodeNil()
		return
	}
	z.EncWriteArrayStart(len(v))
	for yyv1 := range v {
		z.EncWriteArrayElem()
		if v[yyv1] == nil {
			r.EncodeNil()
		} else {
			if yyxt2 := z.Extension(v[yyv1]); yyxt2 != nil {
				z.EncExtension(v[yyv1], yyxt2)
			} else {
				v[yyv1].CodecEncodeSelf(e)
			}
		}
	}
	z.EncWriteArrayEnd()
}

func (x codecSelfer19780) decSlicePtrtoTestStruc(v *[]*TestStruc, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelper().Decoder(d)
	_, _, _ = h, z, r

	yyv1 := *v
	yyh1, yyl1 := z.DecSliceHelperStart()
	var yyc1 bool
	_ = yyc1
	if yyh1.IsNil {
		if yyv1 != nil {
			yyv1 = nil
			yyc1 = true
		}
	} else if yyl1 == 0 {
		if yyv1 == nil {
			yyv1 = []*TestStruc{}
			yyc1 = true
		} else if len(yyv1) != 0 {
			yyv1 = yyv1[:0]
			yyc1 = true
		}
	} else {
		yyhl1 := yyl1 > 0
		var yyrl1 int
		_ = yyrl1
		if yyhl1 {
			if yyl1 > cap(yyv1) {
				yyrl1 = z.DecInferLen(yyl1, z.DecBasicHandle().MaxInitLen, 8)
				if yyrl1 <= cap(yyv1) {
					yyv1 = yyv1[:yyrl1]
				} else {
					yyv1 = make([]*TestStruc, yyrl1)
				}
				yyc1 = true
			} else if yyl1 != len(yyv1) {
				yyv1 = yyv1[:yyl1]
				yyc1 = true
			}
		}
		var yyj1 int
		for yyj1 = 0; z.DecContainerNext(yyj1, yyl1, yyhl1); yyj1++ {
			if yyj1 == 0 && yyv1 == nil {
				if yyhl1 {
					yyrl1 = z.DecInferLen(yyl1, z.DecBasicHandle().MaxInitLen, 8)
				} else {
					yyrl1 = 8
				}
				yyv1 = make([]*TestStruc, yyrl1)
				yyc1 = true
			}
			yyh1.ElemContainerState(yyj1)
			var yydb1 bool
			if yyj1 >= len(yyv1) {
				yyv1 = append(yyv1, nil)
				yyc1 = true
			}
			if yydb1 {
				z.DecSwallow()
			} else {
				if r.TryNil() {
					yyv1[yyj1] = nil
				} else {
					if yyv1[yyj1] == nil {
						yyv1[yyj1] = new(TestStruc)
					}
					if yyxt3 := z.Extension(yyv1[yyj1]); yyxt3 != nil {
						z.DecExtension(yyv1[yyj1], yyxt3)
					} else {
						yyv1[yyj1].CodecDecodeSelf(d)
					}
				}
			}
		}
		if yyj1 < len(yyv1) {
			yyv1 = yyv1[:yyj1]
			yyc1 = true
		} else if yyj1 == 0 && yyv1 == nil {
			yyv1 = []*TestStruc{}
			yyc1 = true
		}
	}
	yyh1.End()
	if yyc1 {
		*v = yyv1
	}
}

func (x codecSelfer19780) encChanstring(v chan string, e *Encoder) {
	var h codecSelfer19780
	z, r := GenHelper().Encoder(e)
	_, _, _ = h, z, r
	if v == nil {
		r.EncodeNil()
		return
	}
	if v == nil {
		r.EncodeNil()
	} else {
		var sch1 []string

	Lsch1:
		switch timeout1 := z.EncBasicHandle().ChanRecvTimeout; {
		case timeout1 == 0: // only consume available
			for {
				select {
				case b1 := <-v:
					sch1 = append(sch1, b1)
				default:
					break Lsch1
				}
			}
		case timeout1 > 0: // consume until timeout
			tt1 := time.NewTimer(timeout1)
			for {
				select {
				case b1 := <-v:
					sch1 = append(sch1, b1)
				case <-tt1.C:
					// close(tt.C)
					break Lsch1
				}
			}
		default: // consume until close
			for b1 := range v {
				sch1 = append(sch1, b1)
			}
		}
		z.EncWriteArrayStart(len(sch1))
		for yyv1 := range sch1 {
			z.EncWriteArrayElem()
			r.EncodeString(string(sch1[yyv1]))
		}
		z.EncWriteArrayEnd()
	}
}

func (x codecSelfer19780) decChanstring(v *chan string, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelper().Decoder(d)
	_, _, _ = h, z, r

	yyv1 := *v
	yyh1, yyl1 := z.DecSliceHelperStart()
	var yyc1 bool
	_ = yyc1
	if yyh1.IsNil {
		if yyv1 != nil {
			yyv1 = nil
			yyc1 = true
		}
	} else if yyl1 == 0 {
		if yyv1 == nil {
			yyv1 = make(chan string, 0)
			yyc1 = true
		}
	} else {
		yyhl1 := yyl1 > 0
		var yyrl1 int
		_ = yyrl1
		var yyj1 int
		for yyj1 = 0; z.DecContainerNext(yyj1, yyl1, yyhl1); yyj1++ {
			if yyj1 == 0 && yyv1 == nil {
				if yyhl1 {
					yyrl1 = z.DecInferLen(yyl1, z.DecBasicHandle().MaxInitLen, 16)
				} else {
					yyrl1 = 64
				}
				yyv1 = make(chan string, yyrl1)
				yyc1 = true
			}
			yyh1.ElemContainerState(yyj1)
			var yyvcx1 string
			yyvcx1 = (string)(z.DecStringZC(r.DecodeStringAsBytes()))
			yyv1 <- yyvcx1
		}
	}
	yyh1.End()
	if yyc1 {
		*v = yyv1
	}
}

func (x codecSelfer19780) encMapboolc3RydWN0IHt9(v map[bool]struct{}, e *Encoder) {
	var h codecSelfer19780
	z, r := GenHelper().Encoder(e)
	_, _, _ = h, z, r
	if v == nil {
		r.EncodeNil()
	} else if z.EncBasicHandle().Canonical {
		z.EncEncodeMapNonNil(v)
	} else {
		z.EncWriteMapStart(len(v))
		for yyk1, yyv1 := range v {
			z.EncWriteMapElemKey()
			r.EncodeBool(bool(yyk1))
			z.EncWriteMapElemValue()
			yy3 := &yyv1
			z.EncFallback(yy3)
		}
		z.EncWriteMapEnd()
	}
}

func (x codecSelfer19780) decMapboolc3RydWN0IHt9(v *map[bool]struct{}, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelper().Decoder(d)
	_, _, _ = h, z, r

	yyv1 := *v
	yyl1 := z.DecReadMapStart()
	if yyl1 == codecSelferDecContainerLenNil19780 {
		*v = nil
	} else {
		if yyv1 == nil {
			yyrl1 := z.DecInferLen(yyl1, z.DecBasicHandle().MaxInitLen, 1)
			yyv1 = make(map[bool]struct{}, yyrl1)
			*v = yyv1
		}
		var yymk1 bool
		var yymv1 struct{}
		var yymg1, yymdn1 bool
		if z.DecBasicHandle().MapValueReset {
			yymg1 = true
		}
		if yyl1 != 0 {
			yyhl1 := yyl1 > 0
			for yyj1 := 0; z.DecContainerNext(yyj1, yyl1, yyhl1); yyj1++ {
				z.DecReadMapElemKey()
				yymk1 = (bool)(r.DecodeBool())
				if yymg1 {
					yymv1 = yyv1[yymk1]
				} else {
					yymv1 = struct{}{}
				}
				z.DecReadMapElemValue()
				yymdn1 = false
				z.DecFallback(&yymv1, false)
				if yymdn1 {
					yyv1[yymk1] = struct{}{}
				} else {
					yyv1[yymk1] = yymv1
				}
			}
		} // else len==0: leave as-is (do not clear map entries)
		z.DecReadMapEnd()
	}
}

func (x codecSelfer19780) encMapuint8c3RydWN0IHt9(v map[uint8]struct{}, e *Encoder) {
	var h codecSelfer19780
	z, r := GenHelper().Encoder(e)
	_, _, _ = h, z, r
	if v == nil {
		r.EncodeNil()
	} else if z.EncBasicHandle().Canonical {
		yys1 := make([]uint64, 0, len(v))
		for k, _ := range v {
			yys1 = append(yys1, uint64(k))
		}
		sort.Sort(codecSelfer19780uint64Slice(yys1))
		z.EncWriteMapStart(len(v))
		for _, yyv1 := range yys1 {
			z.EncWriteMapElemKey()
			r.EncodeUint(yyv1)
			z.EncWriteMapElemValue()
			yye1 := v[uint8(yyv1)]
			yy2 := &yye1
			z.EncFallback(yy2)
		}
		z.EncWriteMapEnd()
	} else {
		z.EncWriteMapStart(len(v))
		for yyk1, yyv1 := range v {
			z.EncWriteMapElemKey()
			r.EncodeUint(uint64(yyk1))
			z.EncWriteMapElemValue()
			yy5 := &yyv1
			z.EncFallback(yy5)
		}
		z.EncWriteMapEnd()
	}
}

func (x codecSelfer19780) decMapuint8c3RydWN0IHt9(v *map[uint8]struct{}, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelper().Decoder(d)
	_, _, _ = h, z, r

	yyv1 := *v
	yyl1 := z.DecReadMapStart()
	if yyl1 == codecSelferDecContainerLenNil19780 {
		*v = nil
	} else {
		if yyv1 == nil {
			yyrl1 := z.DecInferLen(yyl1, z.DecBasicHandle().MaxInitLen, 1)
			yyv1 = make(map[uint8]struct{}, yyrl1)
			*v = yyv1
		}
		var yymk1 uint8
		var yymv1 struct{}
		var yymg1, yymdn1 bool
		if z.DecBasicHandle().MapValueReset {
			yymg1 = true
		}
		if yyl1 != 0 {
			yyhl1 := yyl1 > 0
			for yyj1 := 0; z.DecContainerNext(yyj1, yyl1, yyhl1); yyj1++ {
				z.DecReadMapElemKey()
				yymk1 = (uint8)(z.C.UintV(r.DecodeUint64(), 8))
				if yymg1 {
					yymv1 = yyv1[yymk1]
				} else {
					yymv1 = struct{}{}
				}
				z.DecReadMapElemValue()
				yymdn1 = false
				z.DecFallback(&yymv1, false)
				if yymdn1 {
					yyv1[yymk1] = struct{}{}
				} else {
					yyv1[yymk1] = yymv1
				}
			}
		} // else len==0: leave as-is (do not clear map entries)
		z.DecReadMapEnd()
	}
}

func (x codecSelfer19780) encMapuint8stringUint64T(v map[uint8]stringUint64T, e *Encoder) {
	var h codecSelfer19780
	z, r := GenHelper().Encoder(e)
	_, _, _ = h, z, r
	if v == nil {
		r.EncodeNil()
	} else if z.EncBasicHandle().Canonical {
		yys1 := make([]uint64, 0, len(v))
		for k, _ := range v {
			yys1 = append(yys1, uint64(k))
		}
		sort.Sort(codecSelfer19780uint64Slice(yys1))
		z.EncWriteMapStart(len(v))
		for _, yyv1 := range yys1 {
			z.EncWriteMapElemKey()
			r.EncodeUint(yyv1)
			z.EncWriteMapElemValue()
			yye1 := v[uint8(yyv1)]
			yy2 := &yye1
			if yyxt3 := z.Extension(yy2); yyxt3 != nil {
				z.EncExtension(yy2, yyxt3)
			} else {
				yy2.CodecEncodeSelf(e)
			}
		}
		z.EncWriteMapEnd()
	} else {
		z.EncWriteMapStart(len(v))
		for yyk1, yyv1 := range v {
			z.EncWriteMapElemKey()
			r.EncodeUint(uint64(yyk1))
			z.EncWriteMapElemValue()
			yy5 := &yyv1
			if yyxt6 := z.Extension(yy5); yyxt6 != nil {
				z.EncExtension(yy5, yyxt6)
			} else {
				yy5.CodecEncodeSelf(e)
			}
		}
		z.EncWriteMapEnd()
	}
}

func (x codecSelfer19780) decMapuint8stringUint64T(v *map[uint8]stringUint64T, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelper().Decoder(d)
	_, _, _ = h, z, r

	yyv1 := *v
	yyl1 := z.DecReadMapStart()
	if yyl1 == codecSelferDecContainerLenNil19780 {
		*v = nil
	} else {
		if yyv1 == nil {
			yyrl1 := z.DecInferLen(yyl1, z.DecBasicHandle().MaxInitLen, 25)
			yyv1 = make(map[uint8]stringUint64T, yyrl1)
			*v = yyv1
		}
		var yymk1 uint8
		var yymv1 stringUint64T
		var yymg1, yymdn1 bool
		if z.DecBasicHandle().MapValueReset {
			yymg1 = true
		}
		if yyl1 != 0 {
			yyhl1 := yyl1 > 0
			for yyj1 := 0; z.DecContainerNext(yyj1, yyl1, yyhl1); yyj1++ {
				z.DecReadMapElemKey()
				yymk1 = (uint8)(z.C.UintV(r.DecodeUint64(), 8))
				if yymg1 {
					yymv1 = yyv1[yymk1]
				} else {
					yymv1 = stringUint64T{}
				}
				z.DecReadMapElemValue()
				yymdn1 = false
				if yyxt4 := z.Extension(yymv1); yyxt4 != nil {
					z.DecExtension(&yymv1, yyxt4)
				} else {
					yymv1.CodecDecodeSelf(d)
				}
				if yymdn1 {
					yyv1[yymk1] = stringUint64T{}
				} else {
					yyv1[yymk1] = yymv1
				}
			}
		} // else len==0: leave as-is (do not clear map entries)
		z.DecReadMapEnd()
	}
}

func (x codecSelfer19780) encMapPtrtostringSlicestring(v map[*string][]string, e *Encoder) {
	var h codecSelfer19780
	z, r := GenHelper().Encoder(e)
	_, _, _ = h, z, r
	if v == nil {
		r.EncodeNil()
	} else if z.EncBasicHandle().Canonical {
		z.EncEncodeMapNonNil(v)
	} else {
		z.EncWriteMapStart(len(v))
		for yyk1, yyv1 := range v {
			z.EncWriteMapElemKey()
			if yyk1 == nil {
				r.EncodeNil()
			} else {
				yy2 := *yyk1
				r.EncodeString(string(yy2))
			}
			z.EncWriteMapElemValue()
			if yyv1 == nil {
				r.EncodeNil()
			} else {
				z.F.EncSliceStringV(yyv1, e)
			} // end block: if yyv1 slice == nil
		}
		z.EncWriteMapEnd()
	}
}

func (x codecSelfer19780) decMapPtrtostringSlicestring(v *map[*string][]string, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelper().Decoder(d)
	_, _, _ = h, z, r

	yyv1 := *v
	yyl1 := z.DecReadMapStart()
	if yyl1 == codecSelferDecContainerLenNil19780 {
		*v = nil
	} else {
		if yyv1 == nil {
			yyrl1 := z.DecInferLen(yyl1, z.DecBasicHandle().MaxInitLen, 32)
			yyv1 = make(map[*string][]string, yyrl1)
			*v = yyv1
		}
		var yymk1 *string
		var yymv1 []string
		var yymg1, yymdn1 bool
		if z.DecBasicHandle().MapValueReset {
			yymg1 = true
		}
		if yyl1 != 0 {
			yyhl1 := yyl1 > 0
			for yyj1 := 0; z.DecContainerNext(yyj1, yyl1, yyhl1); yyj1++ {
				z.DecReadMapElemKey()
				if r.TryNil() {
					*yymk1 = ""
				} else {
					if yymk1 == nil {
						yymk1 = new(string)
					}
					*yymk1 = (string)(z.DecStringZC(r.DecodeStringAsBytes()))
				}
				if yymg1 {
					yymv1 = yyv1[yymk1]
				} else {
					yymv1 = nil
				}
				z.DecReadMapElemValue()
				yymdn1 = false
				z.F.DecSliceStringX(&yymv1, d)
				if yymdn1 {
					yyv1[yymk1] = nil
				} else {
					yyv1[yymk1] = yymv1
				}
			}
		} // else len==0: leave as-is (do not clear map entries)
		z.DecReadMapEnd()
	}
}

func (x codecSelfer19780) encMapPtrtouint64Slicestring(v map[*uint64][]string, e *Encoder) {
	var h codecSelfer19780
	z, r := GenHelper().Encoder(e)
	_, _, _ = h, z, r
	if v == nil {
		r.EncodeNil()
	} else if z.EncBasicHandle().Canonical {
		z.EncEncodeMapNonNil(v)
	} else {
		z.EncWriteMapStart(len(v))
		for yyk1, yyv1 := range v {
			z.EncWriteMapElemKey()
			if yyk1 == nil {
				r.EncodeNil()
			} else {
				yy2 := *yyk1
				r.EncodeUint(uint64(yy2))
			}
			z.EncWriteMapElemValue()
			if yyv1 == nil {
				r.EncodeNil()
			} else {
				z.F.EncSliceStringV(yyv1, e)
			} // end block: if yyv1 slice == nil
		}
		z.EncWriteMapEnd()
	}
}

func (x codecSelfer19780) decMapPtrtouint64Slicestring(v *map[*uint64][]string, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelper().Decoder(d)
	_, _, _ = h, z, r

	yyv1 := *v
	yyl1 := z.DecReadMapStart()
	if yyl1 == codecSelferDecContainerLenNil19780 {
		*v = nil
	} else {
		if yyv1 == nil {
			yyrl1 := z.DecInferLen(yyl1, z.DecBasicHandle().MaxInitLen, 32)
			yyv1 = make(map[*uint64][]string, yyrl1)
			*v = yyv1
		}
		var yymk1 *uint64
		var yymv1 []string
		var yymg1, yymdn1 bool
		if z.DecBasicHandle().MapValueReset {
			yymg1 = true
		}
		if yyl1 != 0 {
			yyhl1 := yyl1 > 0
			for yyj1 := 0; z.DecContainerNext(yyj1, yyl1, yyhl1); yyj1++ {
				z.DecReadMapElemKey()
				if r.TryNil() {
					*yymk1 = 0
				} else {
					if yymk1 == nil {
						yymk1 = new(uint64)
					}
					*yymk1 = (uint64)(r.DecodeUint64())
				}
				if yymg1 {
					yymv1 = yyv1[yymk1]
				} else {
					yymv1 = nil
				}
				z.DecReadMapElemValue()
				yymdn1 = false
				z.F.DecSliceStringX(&yymv1, d)
				if yymdn1 {
					yyv1[yymk1] = nil
				} else {
					yyv1[yymk1] = yymv1
				}
			}
		} // else len==0: leave as-is (do not clear map entries)
		z.DecReadMapEnd()
	}
}

func (x codecSelfer19780) encMapstringMapuint64stringUint64T(v map[string]map[uint64]stringUint64T, e *Encoder) {
	var h codecSelfer19780
	z, r := GenHelper().Encoder(e)
	_, _, _ = h, z, r
	if v == nil {
		r.EncodeNil()
	} else if z.EncBasicHandle().Canonical {
		yys1 := make([]string, 0, len(v))
		for k, _ := range v {
			yys1 = append(yys1, string(k))
		}
		sort.Sort(codecSelfer19780stringSlice(yys1))
		z.EncWriteMapStart(len(v))
		for _, yyv1 := range yys1 {
			z.EncWriteMapElemKey()
			r.EncodeString(yyv1)
			z.EncWriteMapElemValue()
			yye1 := v[string(yyv1)]
			if yye1 == nil {
				r.EncodeNil()
			} else {
				h.encMapuint64stringUint64T((map[uint64]stringUint64T)(yye1), e)
			} // end block: if yye1 map == nil
		}
		z.EncWriteMapEnd()
	} else {
		z.EncWriteMapStart(len(v))
		for yyk1, yyv1 := range v {
			z.EncWriteMapElemKey()
			r.EncodeString(string(yyk1))
			z.EncWriteMapElemValue()
			if yyv1 == nil {
				r.EncodeNil()
			} else {
				h.encMapuint64stringUint64T((map[uint64]stringUint64T)(yyv1), e)
			} // end block: if yyv1 map == nil
		}
		z.EncWriteMapEnd()
	}
}

func (x codecSelfer19780) decMapstringMapuint64stringUint64T(v *map[string]map[uint64]stringUint64T, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelper().Decoder(d)
	_, _, _ = h, z, r

	yyv1 := *v
	yyl1 := z.DecReadMapStart()
	if yyl1 == codecSelferDecContainerLenNil19780 {
		*v = nil
	} else {
		if yyv1 == nil {
			yyrl1 := z.DecInferLen(yyl1, z.DecBasicHandle().MaxInitLen, 24)
			yyv1 = make(map[string]map[uint64]stringUint64T, yyrl1)
			*v = yyv1
		}
		var yymk1 string
		var yymv1 map[uint64]stringUint64T
		var yymg1, yymdn1 bool
		if z.DecBasicHandle().MapValueReset {
			yymg1 = true
		}
		if yyl1 != 0 {
			yyhl1 := yyl1 > 0
			for yyj1 := 0; z.DecContainerNext(yyj1, yyl1, yyhl1); yyj1++ {
				z.DecReadMapElemKey()
				yymk1 = (string)(z.DecStringZC(r.DecodeStringAsBytes()))
				if yymg1 {
					yymv1 = yyv1[yymk1]
				} else {
					yymv1 = nil
				}
				z.DecReadMapElemValue()
				yymdn1 = false
				h.decMapuint64stringUint64T((*map[uint64]stringUint64T)(&yymv1), d)
				if yymdn1 {
					yyv1[yymk1] = nil
				} else {
					yyv1[yymk1] = yymv1
				}
			}
		} // else len==0: leave as-is (do not clear map entries)
		z.DecReadMapEnd()
	}
}

func (x codecSelfer19780) encMapuint64stringUint64T(v map[uint64]stringUint64T, e *Encoder) {
	var h codecSelfer19780
	z, r := GenHelper().Encoder(e)
	_, _, _ = h, z, r
	if v == nil {
		r.EncodeNil()
	} else if z.EncBasicHandle().Canonical {
		yys1 := make([]uint64, 0, len(v))
		for k, _ := range v {
			yys1 = append(yys1, uint64(k))
		}
		sort.Sort(codecSelfer19780uint64Slice(yys1))
		z.EncWriteMapStart(len(v))
		for _, yyv1 := range yys1 {
			z.EncWriteMapElemKey()
			r.EncodeUint(uint64(yyv1))
			z.EncWriteMapElemValue()
			yye1 := v[uint64(yyv1)]
			yy2 := &yye1
			if yyxt3 := z.Extension(yy2); yyxt3 != nil {
				z.EncExtension(yy2, yyxt3)
			} else {
				yy2.CodecEncodeSelf(e)
			}
		}
		z.EncWriteMapEnd()
	} else {
		z.EncWriteMapStart(len(v))
		for yyk1, yyv1 := range v {
			z.EncWriteMapElemKey()
			r.EncodeUint(uint64(yyk1))
			z.EncWriteMapElemValue()
			yy5 := &yyv1
			if yyxt6 := z.Extension(yy5); yyxt6 != nil {
				z.EncExtension(yy5, yyxt6)
			} else {
				yy5.CodecEncodeSelf(e)
			}
		}
		z.EncWriteMapEnd()
	}
}

func (x codecSelfer19780) decMapuint64stringUint64T(v *map[uint64]stringUint64T, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelper().Decoder(d)
	_, _, _ = h, z, r

	yyv1 := *v
	yyl1 := z.DecReadMapStart()
	if yyl1 == codecSelferDecContainerLenNil19780 {
		*v = nil
	} else {
		if yyv1 == nil {
			yyrl1 := z.DecInferLen(yyl1, z.DecBasicHandle().MaxInitLen, 32)
			yyv1 = make(map[uint64]stringUint64T, yyrl1)
			*v = yyv1
		}
		var yymk1 uint64
		var yymv1 stringUint64T
		var yymg1, yymdn1 bool
		if z.DecBasicHandle().MapValueReset {
			yymg1 = true
		}
		if yyl1 != 0 {
			yyhl1 := yyl1 > 0
			for yyj1 := 0; z.DecContainerNext(yyj1, yyl1, yyhl1); yyj1++ {
				z.DecReadMapElemKey()
				yymk1 = (uint64)(r.DecodeUint64())
				if yymg1 {
					yymv1 = yyv1[yymk1]
				} else {
					yymv1 = stringUint64T{}
				}
				z.DecReadMapElemValue()
				yymdn1 = false
				if yyxt4 := z.Extension(yymv1); yyxt4 != nil {
					z.DecExtension(&yymv1, yyxt4)
				} else {
					yymv1.CodecDecodeSelf(d)
				}
				if yymdn1 {
					yyv1[yymk1] = stringUint64T{}
				} else {
					yyv1[yymk1] = yymv1
				}
			}
		} // else len==0: leave as-is (do not clear map entries)
		z.DecReadMapEnd()
	}
}

func (x codecSelfer19780) encMapintwrapUint64Slice(v map[int]wrapUint64Slice, e *Encoder) {
	var h codecSelfer19780
	z, r := GenHelper().Encoder(e)
	_, _, _ = h, z, r
	if v == nil {
		r.EncodeNil()
	} else if z.EncBasicHandle().Canonical {
		yys1 := make([]int64, 0, len(v))
		for k, _ := range v {
			yys1 = append(yys1, int64(k))
		}
		sort.Sort(codecSelfer19780int64Slice(yys1))
		z.EncWriteMapStart(len(v))
		for _, yyv1 := range yys1 {
			z.EncWriteMapElemKey()
			r.EncodeInt(int64(yyv1))
			z.EncWriteMapElemValue()
			yye1 := v[int(yyv1)]
			if yyxt2 := z.Extension(yye1); yyxt2 != nil {
				z.EncExtension(yye1, yyxt2)
			} else {
				yye1.CodecEncodeSelf(e)
			}
		}
		z.EncWriteMapEnd()
	} else {
		z.EncWriteMapStart(len(v))
		for yyk1, yyv1 := range v {
			z.EncWriteMapElemKey()
			r.EncodeInt(int64(yyk1))
			z.EncWriteMapElemValue()
			if yyxt4 := z.Extension(yyv1); yyxt4 != nil {
				z.EncExtension(yyv1, yyxt4)
			} else {
				yyv1.CodecEncodeSelf(e)
			}
		}
		z.EncWriteMapEnd()
	}
}

func (x codecSelfer19780) decMapintwrapUint64Slice(v *map[int]wrapUint64Slice, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelper().Decoder(d)
	_, _, _ = h, z, r

	yyv1 := *v
	yyl1 := z.DecReadMapStart()
	if yyl1 == codecSelferDecContainerLenNil19780 {
		*v = nil
	} else {
		if yyv1 == nil {
			yyrl1 := z.DecInferLen(yyl1, z.DecBasicHandle().MaxInitLen, 32)
			yyv1 = make(map[int]wrapUint64Slice, yyrl1)
			*v = yyv1
		}
		var yymk1 int
		var yymv1 wrapUint64Slice
		var yymg1, yymdn1 bool
		if z.DecBasicHandle().MapValueReset {
			yymg1 = true
		}
		if yyl1 != 0 {
			yyhl1 := yyl1 > 0
			for yyj1 := 0; z.DecContainerNext(yyj1, yyl1, yyhl1); yyj1++ {
				z.DecReadMapElemKey()
				yymk1 = (int)(z.C.IntV(r.DecodeInt64(), codecSelferBitsize19780))
				if yymg1 {
					yymv1 = yyv1[yymk1]
				} else {
					yymv1 = nil
				}
				z.DecReadMapElemValue()
				yymdn1 = false
				if yyxt4 := z.Extension(yymv1); yyxt4 != nil {
					z.DecExtension(&yymv1, yyxt4)
				} else {
					yymv1.CodecDecodeSelf(d)
				}
				if yymdn1 {
					yyv1[yymk1] = nil
				} else {
					yyv1[yymk1] = yymv1
				}
			}
		} // else len==0: leave as-is (do not clear map entries)
		z.DecReadMapEnd()
	}
}

func (x codecSelfer19780) encMapfloat64wrapStringSlice(v map[float64]wrapStringSlice, e *Encoder) {
	var h codecSelfer19780
	z, r := GenHelper().Encoder(e)
	_, _, _ = h, z, r
	if v == nil {
		r.EncodeNil()
	} else if z.EncBasicHandle().Canonical {
		yys1 := make([]float64, 0, len(v))
		for k, _ := range v {
			yys1 = append(yys1, float64(k))
		}
		sort.Sort(codecSelfer19780float64Slice(yys1))
		z.EncWriteMapStart(len(v))
		for _, yyv1 := range yys1 {
			z.EncWriteMapElemKey()
			r.EncodeFloat64(yyv1)
			z.EncWriteMapElemValue()
			yye1 := v[float64(yyv1)]
			if yyxt2 := z.Extension(yye1); yyxt2 != nil {
				z.EncExtension(yye1, yyxt2)
			} else {
				yye1.CodecEncodeSelf(e)
			}
		}
		z.EncWriteMapEnd()
	} else {
		z.EncWriteMapStart(len(v))
		for yyk1, yyv1 := range v {
			z.EncWriteMapElemKey()
			r.EncodeFloat64(float64(yyk1))
			z.EncWriteMapElemValue()
			if yyxt4 := z.Extension(yyv1); yyxt4 != nil {
				z.EncExtension(yyv1, yyxt4)
			} else {
				yyv1.CodecEncodeSelf(e)
			}
		}
		z.EncWriteMapEnd()
	}
}

func (x codecSelfer19780) decMapfloat64wrapStringSlice(v *map[float64]wrapStringSlice, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelper().Decoder(d)
	_, _, _ = h, z, r

	yyv1 := *v
	yyl1 := z.DecReadMapStart()
	if yyl1 == codecSelferDecContainerLenNil19780 {
		*v = nil
	} else {
		if yyv1 == nil {
			yyrl1 := z.DecInferLen(yyl1, z.DecBasicHandle().MaxInitLen, 32)
			yyv1 = make(map[float64]wrapStringSlice, yyrl1)
			*v = yyv1
		}
		var yymk1 float64
		var yymv1 wrapStringSlice
		var yymg1, yymdn1 bool
		if z.DecBasicHandle().MapValueReset {
			yymg1 = true
		}
		if yyl1 != 0 {
			yyhl1 := yyl1 > 0
			for yyj1 := 0; z.DecContainerNext(yyj1, yyl1, yyhl1); yyj1++ {
				z.DecReadMapElemKey()
				yymk1 = (float64)(r.DecodeFloat64())
				if yymg1 {
					yymv1 = yyv1[yymk1]
				} else {
					yymv1 = nil
				}
				z.DecReadMapElemValue()
				yymdn1 = false
				if yyxt4 := z.Extension(yymv1); yyxt4 != nil {
					z.DecExtension(&yymv1, yyxt4)
				} else {
					yymv1.CodecDecodeSelf(d)
				}
				if yymdn1 {
					yyv1[yymk1] = nil
				} else {
					yyv1[yymk1] = yymv1
				}
			}
		} // else len==0: leave as-is (do not clear map entries)
		z.DecReadMapEnd()
	}
}

func (x codecSelfer19780) encMapfloat32wrapStringSlice(v map[float32]wrapStringSlice, e *Encoder) {
	var h codecSelfer19780
	z, r := GenHelper().Encoder(e)
	_, _, _ = h, z, r
	if v == nil {
		r.EncodeNil()
	} else if z.EncBasicHandle().Canonical {
		yys1 := make([]float64, 0, len(v))
		for k, _ := range v {
			yys1 = append(yys1, float64(k))
		}
		sort.Sort(codecSelfer19780float64Slice(yys1))
		z.EncWriteMapStart(len(v))
		for _, yyv1 := range yys1 {
			z.EncWriteMapElemKey()
			r.EncodeFloat32(float32(yyv1))
			z.EncWriteMapElemValue()
			yye1 := v[float32(yyv1)]
			if yyxt2 := z.Extension(yye1); yyxt2 != nil {
				z.EncExtension(yye1, yyxt2)
			} else {
				yye1.CodecEncodeSelf(e)
			}
		}
		z.EncWriteMapEnd()
	} else {
		z.EncWriteMapStart(len(v))
		for yyk1, yyv1 := range v {
			z.EncWriteMapElemKey()
			r.EncodeFloat32(float32(yyk1))
			z.EncWriteMapElemValue()
			if yyxt4 := z.Extension(yyv1); yyxt4 != nil {
				z.EncExtension(yyv1, yyxt4)
			} else {
				yyv1.CodecEncodeSelf(e)
			}
		}
		z.EncWriteMapEnd()
	}
}

func (x codecSelfer19780) decMapfloat32wrapStringSlice(v *map[float32]wrapStringSlice, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelper().Decoder(d)
	_, _, _ = h, z, r

	yyv1 := *v
	yyl1 := z.DecReadMapStart()
	if yyl1 == codecSelferDecContainerLenNil19780 {
		*v = nil
	} else {
		if yyv1 == nil {
			yyrl1 := z.DecInferLen(yyl1, z.DecBasicHandle().MaxInitLen, 28)
			yyv1 = make(map[float32]wrapStringSlice, yyrl1)
			*v = yyv1
		}
		var yymk1 float32
		var yymv1 wrapStringSlice
		var yymg1, yymdn1 bool
		if z.DecBasicHandle().MapValueReset {
			yymg1 = true
		}
		if yyl1 != 0 {
			yyhl1 := yyl1 > 0
			for yyj1 := 0; z.DecContainerNext(yyj1, yyl1, yyhl1); yyj1++ {
				z.DecReadMapElemKey()
				yymk1 = (float32)(z.DecDecodeFloat32())
				if yymg1 {
					yymv1 = yyv1[yymk1]
				} else {
					yymv1 = nil
				}
				z.DecReadMapElemValue()
				yymdn1 = false
				if yyxt4 := z.Extension(yymv1); yyxt4 != nil {
					z.DecExtension(&yymv1, yyxt4)
				} else {
					yymv1.CodecDecodeSelf(d)
				}
				if yymdn1 {
					yyv1[yymk1] = nil
				} else {
					yyv1[yymk1] = yymv1
				}
			}
		} // else len==0: leave as-is (do not clear map entries)
		z.DecReadMapEnd()
	}
}

func (x codecSelfer19780) encMapuint64wrapStringSlice(v map[uint64]wrapStringSlice, e *Encoder) {
	var h codecSelfer19780
	z, r := GenHelper().Encoder(e)
	_, _, _ = h, z, r
	if v == nil {
		r.EncodeNil()
	} else if z.EncBasicHandle().Canonical {
		yys1 := make([]uint64, 0, len(v))
		for k, _ := range v {
			yys1 = append(yys1, uint64(k))
		}
		sort.Sort(codecSelfer19780uint64Slice(yys1))
		z.EncWriteMapStart(len(v))
		for _, yyv1 := range yys1 {
			z.EncWriteMapElemKey()
			r.EncodeUint(uint64(yyv1))
			z.EncWriteMapElemValue()
			yye1 := v[uint64(yyv1)]
			if yyxt2 := z.Extension(yye1); yyxt2 != nil {
				z.EncExtension(yye1, yyxt2)
			} else {
				yye1.CodecEncodeSelf(e)
			}
		}
		z.EncWriteMapEnd()
	} else {
		z.EncWriteMapStart(len(v))
		for yyk1, yyv1 := range v {
			z.EncWriteMapElemKey()
			r.EncodeUint(uint64(yyk1))
			z.EncWriteMapElemValue()
			if yyxt4 := z.Extension(yyv1); yyxt4 != nil {
				z.EncExtension(yyv1, yyxt4)
			} else {
				yyv1.CodecEncodeSelf(e)
			}
		}
		z.EncWriteMapEnd()
	}
}

func (x codecSelfer19780) decMapuint64wrapStringSlice(v *map[uint64]wrapStringSlice, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelper().Decoder(d)
	_, _, _ = h, z, r

	yyv1 := *v
	yyl1 := z.DecReadMapStart()
	if yyl1 == codecSelferDecContainerLenNil19780 {
		*v = nil
	} else {
		if yyv1 == nil {
			yyrl1 := z.DecInferLen(yyl1, z.DecBasicHandle().MaxInitLen, 32)
			yyv1 = make(map[uint64]wrapStringSlice, yyrl1)
			*v = yyv1
		}
		var yymk1 uint64
		var yymv1 wrapStringSlice
		var yymg1, yymdn1 bool
		if z.DecBasicHandle().MapValueReset {
			yymg1 = true
		}
		if yyl1 != 0 {
			yyhl1 := yyl1 > 0
			for yyj1 := 0; z.DecContainerNext(yyj1, yyl1, yyhl1); yyj1++ {
				z.DecReadMapElemKey()
				yymk1 = (uint64)(r.DecodeUint64())
				if yymg1 {
					yymv1 = yyv1[yymk1]
				} else {
					yymv1 = nil
				}
				z.DecReadMapElemValue()
				yymdn1 = false
				if yyxt4 := z.Extension(yymv1); yyxt4 != nil {
					z.DecExtension(&yymv1, yyxt4)
				} else {
					yymv1.CodecDecodeSelf(d)
				}
				if yymdn1 {
					yyv1[yymk1] = nil
				} else {
					yyv1[yymk1] = yymv1
				}
			}
		} // else len==0: leave as-is (do not clear map entries)
		z.DecReadMapEnd()
	}
}

func (x codecSelfer19780) encMapstringUint64TwrapStringSlice(v map[stringUint64T]wrapStringSlice, e *Encoder) {
	var h codecSelfer19780
	z, r := GenHelper().Encoder(e)
	_, _, _ = h, z, r
	if v == nil {
		r.EncodeNil()
	} else if z.EncBasicHandle().Canonical {
		z.EncEncodeMapNonNil(v)
	} else {
		z.EncWriteMapStart(len(v))
		for yyk1, yyv1 := range v {
			z.EncWriteMapElemKey()
			yy2 := &yyk1
			if yyxt3 := z.Extension(yy2); yyxt3 != nil {
				z.EncExtension(yy2, yyxt3)
			} else {
				yy2.CodecEncodeSelf(e)
			}
			z.EncWriteMapElemValue()
			if yyxt4 := z.Extension(yyv1); yyxt4 != nil {
				z.EncExtension(yyv1, yyxt4)
			} else {
				yyv1.CodecEncodeSelf(e)
			}
		}
		z.EncWriteMapEnd()
	}
}

func (x codecSelfer19780) decMapstringUint64TwrapStringSlice(v *map[stringUint64T]wrapStringSlice, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelper().Decoder(d)
	_, _, _ = h, z, r

	yyv1 := *v
	yyl1 := z.DecReadMapStart()
	if yyl1 == codecSelferDecContainerLenNil19780 {
		*v = nil
	} else {
		if yyv1 == nil {
			yyrl1 := z.DecInferLen(yyl1, z.DecBasicHandle().MaxInitLen, 48)
			yyv1 = make(map[stringUint64T]wrapStringSlice, yyrl1)
			*v = yyv1
		}
		var yymk1 stringUint64T
		var yymv1 wrapStringSlice
		var yymg1, yymdn1 bool
		if z.DecBasicHandle().MapValueReset {
			yymg1 = true
		}
		if yyl1 != 0 {
			yyhl1 := yyl1 > 0
			for yyj1 := 0; z.DecContainerNext(yyj1, yyl1, yyhl1); yyj1++ {
				z.DecReadMapElemKey()
				if yyxt3 := z.Extension(yymk1); yyxt3 != nil {
					z.DecExtension(&yymk1, yyxt3)
				} else {
					yymk1.CodecDecodeSelf(d)
				}
				if yymg1 {
					yymv1 = yyv1[yymk1]
				} else {
					yymv1 = nil
				}
				z.DecReadMapElemValue()
				yymdn1 = false
				if yyxt5 := z.Extension(yymv1); yyxt5 != nil {
					z.DecExtension(&yymv1, yyxt5)
				} else {
					yymv1.CodecDecodeSelf(d)
				}
				if yymdn1 {
					yyv1[yymk1] = nil
				} else {
					yyv1[yymk1] = yymv1
				}
			}
		} // else len==0: leave as-is (do not clear map entries)
		z.DecReadMapEnd()
	}
}

func (x codecSelfer19780) encSlicewrapBytes(v []wrapBytes, e *Encoder) {
	var h codecSelfer19780
	z, r := GenHelper().Encoder(e)
	_, _, _ = h, z, r
	if v == nil {
		r.EncodeNil()
		return
	}
	z.EncWriteArrayStart(len(v))
	for yyv1 := range v {
		z.EncWriteArrayElem()
		if yyxt2 := z.Extension(v[yyv1]); yyxt2 != nil {
			z.EncExtension(v[yyv1], yyxt2)
		} else {
			v[yyv1].CodecEncodeSelf(e)
		}
	}
	z.EncWriteArrayEnd()
}

func (x codecSelfer19780) decSlicewrapBytes(v *[]wrapBytes, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelper().Decoder(d)
	_, _, _ = h, z, r

	yyv1 := *v
	yyh1, yyl1 := z.DecSliceHelperStart()
	var yyc1 bool
	_ = yyc1
	if yyh1.IsNil {
		if yyv1 != nil {
			yyv1 = nil
			yyc1 = true
		}
	} else if yyl1 == 0 {
		if yyv1 == nil {
			yyv1 = []wrapBytes{}
			yyc1 = true
		} else if len(yyv1) != 0 {
			yyv1 = yyv1[:0]
			yyc1 = true
		}
	} else {
		yyhl1 := yyl1 > 0
		var yyrl1 int
		_ = yyrl1
		if yyhl1 {
			if yyl1 > cap(yyv1) {
				yyrl1 = z.DecInferLen(yyl1, z.DecBasicHandle().MaxInitLen, 24)
				if yyrl1 <= cap(yyv1) {
					yyv1 = yyv1[:yyrl1]
				} else {
					yyv1 = make([]wrapBytes, yyrl1)
				}
				yyc1 = true
			} else if yyl1 != len(yyv1) {
				yyv1 = yyv1[:yyl1]
				yyc1 = true
			}
		}
		var yyj1 int
		for yyj1 = 0; z.DecContainerNext(yyj1, yyl1, yyhl1); yyj1++ {
			if yyj1 == 0 && yyv1 == nil {
				if yyhl1 {
					yyrl1 = z.DecInferLen(yyl1, z.DecBasicHandle().MaxInitLen, 24)
				} else {
					yyrl1 = 8
				}
				yyv1 = make([]wrapBytes, yyrl1)
				yyc1 = true
			}
			yyh1.ElemContainerState(yyj1)
			var yydb1 bool
			if yyj1 >= len(yyv1) {
				yyv1 = append(yyv1, nil)
				yyc1 = true
			}
			if yydb1 {
				z.DecSwallow()
			} else {
				if yyxt3 := z.Extension(yyv1[yyj1]); yyxt3 != nil {
					z.DecExtension(&yyv1[yyj1], yyxt3)
				} else {
					yyv1[yyj1].CodecDecodeSelf(d)
				}
			}
		}
		if yyj1 < len(yyv1) {
			yyv1 = yyv1[:yyj1]
			yyc1 = true
		} else if yyj1 == 0 && yyv1 == nil {
			yyv1 = []wrapBytes{}
			yyc1 = true
		}
	}
	yyh1.End()
	if yyc1 {
		*v = yyv1
	}
}

func (x codecSelfer19780) encSlicewrapUint8(v []wrapUint8, e *Encoder) {
	var h codecSelfer19780
	z, r := GenHelper().Encoder(e)
	_, _, _ = h, z, r
	if v == nil {
		r.EncodeNil()
		return
	}
	z.EncWriteArrayStart(len(v))
	for yyv1 := range v {
		z.EncWriteArrayElem()
		if yyxt2 := z.Extension(v[yyv1]); yyxt2 != nil {
			z.EncExtension(v[yyv1], yyxt2)
		} else {
			v[yyv1].CodecEncodeSelf(e)
		}
	}
	z.EncWriteArrayEnd()
}

func (x codecSelfer19780) decSlicewrapUint8(v *[]wrapUint8, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelper().Decoder(d)
	_, _, _ = h, z, r

	yyv1 := *v
	yyh1, yyl1 := z.DecSliceHelperStart()
	var yyc1 bool
	_ = yyc1
	if yyh1.IsNil {
		if yyv1 != nil {
			yyv1 = nil
			yyc1 = true
		}
	} else if yyl1 == 0 {
		if yyv1 == nil {
			yyv1 = []wrapUint8{}
			yyc1 = true
		} else if len(yyv1) != 0 {
			yyv1 = yyv1[:0]
			yyc1 = true
		}
	} else {
		yyhl1 := yyl1 > 0
		var yyrl1 int
		_ = yyrl1
		if yyhl1 {
			if yyl1 > cap(yyv1) {
				yyrl1 = z.DecInferLen(yyl1, z.DecBasicHandle().MaxInitLen, 1)
				if yyrl1 <= cap(yyv1) {
					yyv1 = yyv1[:yyrl1]
				} else {
					yyv1 = make([]wrapUint8, yyrl1)
				}
				yyc1 = true
			} else if yyl1 != len(yyv1) {
				yyv1 = yyv1[:yyl1]
				yyc1 = true
			}
		}
		var yyj1 int
		for yyj1 = 0; z.DecContainerNext(yyj1, yyl1, yyhl1); yyj1++ {
			if yyj1 == 0 && yyv1 == nil {
				if yyhl1 {
					yyrl1 = z.DecInferLen(yyl1, z.DecBasicHandle().MaxInitLen, 1)
				} else {
					yyrl1 = 8
				}
				yyv1 = make([]wrapUint8, yyrl1)
				yyc1 = true
			}
			yyh1.ElemContainerState(yyj1)
			var yydb1 bool
			if yyj1 >= len(yyv1) {
				yyv1 = append(yyv1, 0)
				yyc1 = true
			}
			if yydb1 {
				z.DecSwallow()
			} else {
				if yyxt3 := z.Extension(yyv1[yyj1]); yyxt3 != nil {
					z.DecExtension(&yyv1[yyj1], yyxt3)
				} else {
					yyv1[yyj1].CodecDecodeSelf(d)
				}
			}
		}
		if yyj1 < len(yyv1) {
			yyv1 = yyv1[:yyj1]
			yyc1 = true
		} else if yyj1 == 0 && yyv1 == nil {
			yyv1 = []wrapUint8{}
			yyc1 = true
		}
	}
	yyh1.End()
	if yyc1 {
		*v = yyv1
	}
}

func (x codecSelfer19780) encArray4stringUint64T(v *[4]stringUint64T, e *Encoder) {
	var h codecSelfer19780
	z, r := GenHelper().Encoder(e)
	_, _, _ = h, z, r
	if v == nil {
		r.EncodeNil()
		return
	}
	z.EncWriteArrayStart(len(v))
	for yyv1 := range v {
		z.EncWriteArrayElem()
		yy2 := &v[yyv1]
		if yyxt3 := z.Extension(yy2); yyxt3 != nil {
			z.EncExtension(yy2, yyxt3)
		} else {
			yy2.CodecEncodeSelf(e)
		}
	}
	z.EncWriteArrayEnd()
}

func (x codecSelfer19780) decArray4stringUint64T(v *[4]stringUint64T, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelper().Decoder(d)
	_, _, _ = h, z, r

	yyv1 := v
	yyh1, yyl1 := z.DecSliceHelperStart()
	if yyl1 == 0 {
	} else {
		yyhl1 := yyl1 > 0
		var yyrl1 int
		_ = yyrl1
		var yyj1 int
		for yyj1 = 0; z.DecContainerNext(yyj1, yyl1, yyhl1); yyj1++ {
			yyh1.ElemContainerState(yyj1)
			var yydb1 bool
			if yyj1 >= len(yyv1) {
				z.DecArrayCannotExpand(len(v), yyj1+1)
				yydb1 = true
			}
			if yydb1 {
				z.DecSwallow()
			} else {
				if yyxt3 := z.Extension(yyv1[yyj1]); yyxt3 != nil {
					z.DecExtension(&yyv1[yyj1], yyxt3)
				} else {
					yyv1[yyj1].CodecDecodeSelf(d)
				}
			}
		}
	}
	yyh1.End()
}

func (x codecSelfer19780) encArray4uint64(v *[4]uint64, e *Encoder) {
	var h codecSelfer19780
	z, r := GenHelper().Encoder(e)
	_, _, _ = h, z, r
	if v == nil {
		r.EncodeNil()
		return
	}
	z.EncWriteArrayStart(len(v))
	for yyv1 := range v {
		z.EncWriteArrayElem()
		r.EncodeUint(uint64(v[yyv1]))
	}
	z.EncWriteArrayEnd()
}

func (x codecSelfer19780) decArray4uint64(v *[4]uint64, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelper().Decoder(d)
	_, _, _ = h, z, r

	yyv1 := v
	yyh1, yyl1 := z.DecSliceHelperStart()
	if yyl1 == 0 {
	} else {
		yyhl1 := yyl1 > 0
		var yyrl1 int
		_ = yyrl1
		var yyj1 int
		for yyj1 = 0; z.DecContainerNext(yyj1, yyl1, yyhl1); yyj1++ {
			yyh1.ElemContainerState(yyj1)
			var yydb1 bool
			if yyj1 >= len(yyv1) {
				z.DecArrayCannotExpand(len(v), yyj1+1)
				yydb1 = true
			}
			if yydb1 {
				z.DecSwallow()
			} else {
				yyv1[yyj1] = (uint64)(r.DecodeUint64())
			}
		}
	}
	yyh1.End()
}

func (x codecSelfer19780) encSlicePtrtoArray4uint64(v []*[4]uint64, e *Encoder) {
	var h codecSelfer19780
	z, r := GenHelper().Encoder(e)
	_, _, _ = h, z, r
	if v == nil {
		r.EncodeNil()
		return
	}
	z.EncWriteArrayStart(len(v))
	for yyv1 := range v {
		z.EncWriteArrayElem()
		if v[yyv1] == nil {
			r.EncodeNil()
		} else {
			h.encArray4uint64((*[4]uint64)(v[yyv1]), e)
		}
	}
	z.EncWriteArrayEnd()
}

func (x codecSelfer19780) decSlicePtrtoArray4uint64(v *[]*[4]uint64, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelper().Decoder(d)
	_, _, _ = h, z, r

	yyv1 := *v
	yyh1, yyl1 := z.DecSliceHelperStart()
	var yyc1 bool
	_ = yyc1
	if yyh1.IsNil {
		if yyv1 != nil {
			yyv1 = nil
			yyc1 = true
		}
	} else if yyl1 == 0 {
		if yyv1 == nil {
			yyv1 = []*[4]uint64{}
			yyc1 = true
		} else if len(yyv1) != 0 {
			yyv1 = yyv1[:0]
			yyc1 = true
		}
	} else {
		yyhl1 := yyl1 > 0
		var yyrl1 int
		_ = yyrl1
		if yyhl1 {
			if yyl1 > cap(yyv1) {
				yyrl1 = z.DecInferLen(yyl1, z.DecBasicHandle().MaxInitLen, 8)
				if yyrl1 <= cap(yyv1) {
					yyv1 = yyv1[:yyrl1]
				} else {
					yyv1 = make([]*[4]uint64, yyrl1)
				}
				yyc1 = true
			} else if yyl1 != len(yyv1) {
				yyv1 = yyv1[:yyl1]
				yyc1 = true
			}
		}
		var yyj1 int
		for yyj1 = 0; z.DecContainerNext(yyj1, yyl1, yyhl1); yyj1++ {
			if yyj1 == 0 && yyv1 == nil {
				if yyhl1 {
					yyrl1 = z.DecInferLen(yyl1, z.DecBasicHandle().MaxInitLen, 8)
				} else {
					yyrl1 = 8
				}
				yyv1 = make([]*[4]uint64, yyrl1)
				yyc1 = true
			}
			yyh1.ElemContainerState(yyj1)
			var yydb1 bool
			if yyj1 >= len(yyv1) {
				yyv1 = append(yyv1, nil)
				yyc1 = true
			}
			if yydb1 {
				z.DecSwallow()
			} else {
				if r.TryNil() {
					yyv1[yyj1] = nil
				} else {
					if yyv1[yyj1] == nil {
						yyv1[yyj1] = new([4]uint64)
					}
					h.decArray4uint64((*[4]uint64)(yyv1[yyj1]), d)
				}
			}
		}
		if yyj1 < len(yyv1) {
			yyv1 = yyv1[:yyj1]
			yyc1 = true
		} else if yyj1 == 0 && yyv1 == nil {
			yyv1 = []*[4]uint64{}
			yyc1 = true
		}
	}
	yyh1.End()
	if yyc1 {
		*v = yyv1
	}
}

func (x codecSelfer19780) encMapstringUint64TPtrtostringUint64T(v map[stringUint64T]*stringUint64T, e *Encoder) {
	var h codecSelfer19780
	z, r := GenHelper().Encoder(e)
	_, _, _ = h, z, r
	if v == nil {
		r.EncodeNil()
	} else if z.EncBasicHandle().Canonical {
		z.EncEncodeMapNonNil(v)
	} else {
		z.EncWriteMapStart(len(v))
		for yyk1, yyv1 := range v {
			z.EncWriteMapElemKey()
			yy2 := &yyk1
			if yyxt3 := z.Extension(yy2); yyxt3 != nil {
				z.EncExtension(yy2, yyxt3)
			} else {
				yy2.CodecEncodeSelf(e)
			}
			z.EncWriteMapElemValue()
			if yyv1 == nil {
				r.EncodeNil()
			} else {
				if yyxt4 := z.Extension(yyv1); yyxt4 != nil {
					z.EncExtension(yyv1, yyxt4)
				} else {
					yyv1.CodecEncodeSelf(e)
				}
			}
		}
		z.EncWriteMapEnd()
	}
}

func (x codecSelfer19780) decMapstringUint64TPtrtostringUint64T(v *map[stringUint64T]*stringUint64T, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelper().Decoder(d)
	_, _, _ = h, z, r

	yyv1 := *v
	yyl1 := z.DecReadMapStart()
	if yyl1 == codecSelferDecContainerLenNil19780 {
		*v = nil
	} else {
		if yyv1 == nil {
			yyrl1 := z.DecInferLen(yyl1, z.DecBasicHandle().MaxInitLen, 32)
			yyv1 = make(map[stringUint64T]*stringUint64T, yyrl1)
			*v = yyv1
		}
		var yymk1 stringUint64T
		var yymv1 *stringUint64T
		var yymg1, yymdn1, yyms1, yymok1 bool
		if z.DecBasicHandle().MapValueReset {
			yymg1 = true
		}
		if yyl1 != 0 {
			yyhl1 := yyl1 > 0
			for yyj1 := 0; z.DecContainerNext(yyj1, yyl1, yyhl1); yyj1++ {
				z.DecReadMapElemKey()
				if yyxt3 := z.Extension(yymk1); yyxt3 != nil {
					z.DecExtension(&yymk1, yyxt3)
				} else {
					yymk1.CodecDecodeSelf(d)
				}
				yyms1 = true
				if yymg1 {
					yymv1, yymok1 = yyv1[yymk1]
					if yymok1 {
						yyms1 = false
					}
				} else {
					yymv1 = nil
				}
				z.DecReadMapElemValue()
				yymdn1 = false
				if r.TryNil() {
					yymdn1 = true
				} else {
					if yymv1 == nil {
						yymv1 = new(stringUint64T)
					}
					if yyxt5 := z.Extension(yymv1); yyxt5 != nil {
						z.DecExtension(yymv1, yyxt5)
					} else {
						yymv1.CodecDecodeSelf(d)
					}
				}
				if yymdn1 {
					yyv1[yymk1] = nil
				} else if yyms1 {
					yyv1[yymk1] = yymv1
				}
			}
		} // else len==0: leave as-is (do not clear map entries)
		z.DecReadMapEnd()
	}
}

func (x codecSelfer19780) encMapwrapStringInterface(v map[wrapString]interface{}, e *Encoder) {
	var h codecSelfer19780
	z, r := GenHelper().Encoder(e)
	_, _, _ = h, z, r
	if v == nil {
		r.EncodeNil()
	} else if z.EncBasicHandle().Canonical {
		var yyvv1 wrapString
		yyencfn1 := z.EncFnGivenAddr(&yyvv1)
		yys1 := make([]string, 0, len(v))
		for k, _ := range v {
			yys1 = append(yys1, string(k))
		}
		sort.Sort(codecSelfer19780stringSlice(yys1))
		z.EncWriteMapStart(len(v))
		for _, yyv1 := range yys1 {
			z.EncWriteMapElemKey()
			yyvv1 = wrapString(yyv1)
			z.EncEncodeNumBoolStrKindGivenAddr(&yyvv1, yyencfn1)
			z.EncWriteMapElemValue()
			yye1 := v[yyvv1]
			if yye1 == nil {
				r.EncodeNil()
			} else {
				z.EncFallback(yye1)
			}
		}
		z.EncWriteMapEnd()
	} else {
		z.EncWriteMapStart(len(v))
		for yyk1, yyv1 := range v {
			z.EncWriteMapElemKey()
			if yyxt3 := z.Extension(yyk1); yyxt3 != nil {
				z.EncExtension(yyk1, yyxt3)
			} else {
				yyk1.CodecEncodeSelf(e)
			}
			z.EncWriteMapElemValue()
			if yyv1 == nil {
				r.EncodeNil()
			} else {
				z.EncFallback(yyv1)
			}
		}
		z.EncWriteMapEnd()
	}
}

func (x codecSelfer19780) decMapwrapStringInterface(v *map[wrapString]interface{}, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelper().Decoder(d)
	_, _, _ = h, z, r

	yyv1 := *v
	yyl1 := z.DecReadMapStart()
	if yyl1 == codecSelferDecContainerLenNil19780 {
		*v = nil
	} else {
		if yyv1 == nil {
			yyrl1 := z.DecInferLen(yyl1, z.DecBasicHandle().MaxInitLen, 32)
			yyv1 = make(map[wrapString]interface{}, yyrl1)
			*v = yyv1
		}
		var yymk1 wrapString
		var yymv1 interface{}
		var yymg1, yymdn1 bool
		if z.DecBasicHandle().MapValueReset {
			if !z.DecBasicHandle().InterfaceReset {
				yymg1 = true
			}
		}
		if yyl1 != 0 {
			yyhl1 := yyl1 > 0
			for yyj1 := 0; z.DecContainerNext(yyj1, yyl1, yyhl1); yyj1++ {
				z.DecReadMapElemKey()
				if yyxt3 := z.Extension(yymk1); yyxt3 != nil {
					z.DecExtension(&yymk1, yyxt3)
				} else {
					yymk1.CodecDecodeSelf(d)
				}
				if yymg1 {
					yymv1 = yyv1[yymk1]
				} else {
					yymv1 = nil
				}
				z.DecReadMapElemValue()
				yymdn1 = false
				z.DecFallback(&yymv1, true)
				if yymdn1 {
					yyv1[yymk1] = nil
				} else {
					yyv1[yymk1] = yymv1
				}
			}
		} // else len==0: leave as-is (do not clear map entries)
		z.DecReadMapEnd()
	}
}

func (x codecSelfer19780) encMapstringPtrtoTestStrucFlex(v map[string]*TestStrucFlex, e *Encoder) {
	var h codecSelfer19780
	z, r := GenHelper().Encoder(e)
	_, _, _ = h, z, r
	if v == nil {
		r.EncodeNil()
	} else if z.EncBasicHandle().Canonical {
		yys1 := make([]string, 0, len(v))
		for k, _ := range v {
			yys1 = append(yys1, string(k))
		}
		sort.Sort(codecSelfer19780stringSlice(yys1))
		z.EncWriteMapStart(len(v))
		for _, yyv1 := range yys1 {
			z.EncWriteMapElemKey()
			r.EncodeString(yyv1)
			z.EncWriteMapElemValue()
			yye1 := v[string(yyv1)]
			if yye1 == nil {
				r.EncodeNil()
			} else {
				if yyxt2 := z.Extension(yye1); yyxt2 != nil {
					z.EncExtension(yye1, yyxt2)
				} else {
					yye1.CodecEncodeSelf(e)
				}
			}
		}
		z.EncWriteMapEnd()
	} else {
		z.EncWriteMapStart(len(v))
		for yyk1, yyv1 := range v {
			z.EncWriteMapElemKey()
			r.EncodeString(string(yyk1))
			z.EncWriteMapElemValue()
			if yyv1 == nil {
				r.EncodeNil()
			} else {
				if yyxt4 := z.Extension(yyv1); yyxt4 != nil {
					z.EncExtension(yyv1, yyxt4)
				} else {
					yyv1.CodecEncodeSelf(e)
				}
			}
		}
		z.EncWriteMapEnd()
	}
}

func (x codecSelfer19780) decMapstringPtrtoTestStrucFlex(v *map[string]*TestStrucFlex, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelper().Decoder(d)
	_, _, _ = h, z, r

	yyv1 := *v
	yyl1 := z.DecReadMapStart()
	if yyl1 == codecSelferDecContainerLenNil19780 {
		*v = nil
	} else {
		if yyv1 == nil {
			yyrl1 := z.DecInferLen(yyl1, z.DecBasicHandle().MaxInitLen, 24)
			yyv1 = make(map[string]*TestStrucFlex, yyrl1)
			*v = yyv1
		}
		var yymk1 string
		var yymv1 *TestStrucFlex
		var yymg1, yymdn1, yyms1, yymok1 bool
		if z.DecBasicHandle().MapValueReset {
			yymg1 = true
		}
		if yyl1 != 0 {
			yyhl1 := yyl1 > 0
			for yyj1 := 0; z.DecContainerNext(yyj1, yyl1, yyhl1); yyj1++ {
				z.DecReadMapElemKey()
				yymk1 = (string)(z.DecStringZC(r.DecodeStringAsBytes()))
				yyms1 = true
				if yymg1 {
					yymv1, yymok1 = yyv1[yymk1]
					if yymok1 {
						yyms1 = false
					}
				} else {
					yymv1 = nil
				}
				z.DecReadMapElemValue()
				yymdn1 = false
				if r.TryNil() {
					yymdn1 = true
				} else {
					if yymv1 == nil {
						yymv1 = new(TestStrucFlex)
					}
					if yyxt4 := z.Extension(yymv1); yyxt4 != nil {
						z.DecExtension(yymv1, yyxt4)
					} else {
						yymv1.CodecDecodeSelf(d)
					}
				}
				if yymdn1 {
					yyv1[yymk1] = nil
				} else if yyms1 {
					yyv1[yymk1] = yymv1
				}
			}
		} // else len==0: leave as-is (do not clear map entries)
		z.DecReadMapEnd()
	}
}

func (x codecSelfer19780) encMapstringTestStrucFlex(v map[string]TestStrucFlex, e *Encoder) {
	var h codecSelfer19780
	z, r := GenHelper().Encoder(e)
	_, _, _ = h, z, r
	if v == nil {
		r.EncodeNil()
	} else if z.EncBasicHandle().Canonical {
		yys1 := make([]string, 0, len(v))
		for k, _ := range v {
			yys1 = append(yys1, string(k))
		}
		sort.Sort(codecSelfer19780stringSlice(yys1))
		z.EncWriteMapStart(len(v))
		for _, yyv1 := range yys1 {
			z.EncWriteMapElemKey()
			r.EncodeString(yyv1)
			z.EncWriteMapElemValue()
			yye1 := v[string(yyv1)]
			yy2 := &yye1
			if yyxt3 := z.Extension(yy2); yyxt3 != nil {
				z.EncExtension(yy2, yyxt3)
			} else {
				yy2.CodecEncodeSelf(e)
			}
		}
		z.EncWriteMapEnd()
	} else {
		z.EncWriteMapStart(len(v))
		for yyk1, yyv1 := range v {
			z.EncWriteMapElemKey()
			r.EncodeString(string(yyk1))
			z.EncWriteMapElemValue()
			yy5 := &yyv1
			if yyxt6 := z.Extension(yy5); yyxt6 != nil {
				z.EncExtension(yy5, yyxt6)
			} else {
				yy5.CodecEncodeSelf(e)
			}
		}
		z.EncWriteMapEnd()
	}
}

func (x codecSelfer19780) decMapstringTestStrucFlex(v *map[string]TestStrucFlex, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelper().Decoder(d)
	_, _, _ = h, z, r

	yyv1 := *v
	yyl1 := z.DecReadMapStart()
	if yyl1 == codecSelferDecContainerLenNil19780 {
		*v = nil
	} else {
		if yyv1 == nil {
			yyrl1 := z.DecInferLen(yyl1, z.DecBasicHandle().MaxInitLen, 1880)
			yyv1 = make(map[string]TestStrucFlex, yyrl1)
			*v = yyv1
		}
		var yymk1 string
		var yymv1 TestStrucFlex
		var yymg1, yymdn1 bool
		if z.DecBasicHandle().MapValueReset {
			yymg1 = true
		}
		if yyl1 != 0 {
			yyhl1 := yyl1 > 0
			for yyj1 := 0; z.DecContainerNext(yyj1, yyl1, yyhl1); yyj1++ {
				z.DecReadMapElemKey()
				yymk1 = (string)(z.DecStringZC(r.DecodeStringAsBytes()))
				if yymg1 {
					yymv1 = yyv1[yymk1]
				} else {
					yymv1 = TestStrucFlex{}
				}
				z.DecReadMapElemValue()
				yymdn1 = false
				if yyxt4 := z.Extension(yymv1); yyxt4 != nil {
					z.DecExtension(&yymv1, yyxt4)
				} else {
					yymv1.CodecDecodeSelf(d)
				}
				if yymdn1 {
					yyv1[yymk1] = TestStrucFlex{}
				} else {
					yyv1[yymk1] = yymv1
				}
			}
		} // else len==0: leave as-is (do not clear map entries)
		z.DecReadMapEnd()
	}
}

func (x codecSelfer19780) encSlicePtrtoTestStrucFlex(v []*TestStrucFlex, e *Encoder) {
	var h codecSelfer19780
	z, r := GenHelper().Encoder(e)
	_, _, _ = h, z, r
	if v == nil {
		r.EncodeNil()
		return
	}
	z.EncWriteArrayStart(len(v))
	for yyv1 := range v {
		z.EncWriteArrayElem()
		if v[yyv1] == nil {
			r.EncodeNil()
		} else {
			if yyxt2 := z.Extension(v[yyv1]); yyxt2 != nil {
				z.EncExtension(v[yyv1], yyxt2)
			} else {
				v[yyv1].CodecEncodeSelf(e)
			}
		}
	}
	z.EncWriteArrayEnd()
}

func (x codecSelfer19780) decSlicePtrtoTestStrucFlex(v *[]*TestStrucFlex, d *Decoder) {
	var h codecSelfer19780
	z, r := GenHelper().Decoder(d)
	_, _, _ = h, z, r

	yyv1 := *v
	yyh1, yyl1 := z.DecSliceHelperStart()
	var yyc1 bool
	_ = yyc1
	if yyh1.IsNil {
		if yyv1 != nil {
			yyv1 = nil
			yyc1 = true
		}
	} else if yyl1 == 0 {
		if yyv1 == nil {
			yyv1 = []*TestStrucFlex{}
			yyc1 = true
		} else if len(yyv1) != 0 {
			yyv1 = yyv1[:0]
			yyc1 = true
		}
	} else {
		yyhl1 := yyl1 > 0
		var yyrl1 int
		_ = yyrl1
		if yyhl1 {
			if yyl1 > cap(yyv1) {
				yyrl1 = z.DecInferLen(yyl1, z.DecBasicHandle().MaxInitLen, 8)
				if yyrl1 <= cap(yyv1) {
					yyv1 = yyv1[:yyrl1]
				} else {
					yyv1 = make([]*TestStrucFlex, yyrl1)
				}
				yyc1 = true
			} else if yyl1 != len(yyv1) {
				yyv1 = yyv1[:yyl1]
				yyc1 = true
			}
		}
		var yyj1 int
		for yyj1 = 0; z.DecContainerNext(yyj1, yyl1, yyhl1); yyj1++ {
			if yyj1 == 0 && yyv1 == nil {
				if yyhl1 {
					yyrl1 = z.DecInferLen(yyl1, z.DecBasicHandle().MaxInitLen, 8)
				} else {
					yyrl1 = 8
				}
				yyv1 = make([]*TestStrucFlex, yyrl1)
				yyc1 = true
			}
			yyh1.ElemContainerState(yyj1)
			var yydb1 bool
			if yyj1 >= len(yyv1) {
				yyv1 = append(yyv1, nil)
				yyc1 = true
			}
			if yydb1 {
				z.DecSwallow()
			} else {
				if r.TryNil() {
					yyv1[yyj1] = nil
				} else {
					if yyv1[yyj1] == nil {
						yyv1[yyj1] = new(TestStrucFlex)
					}
					if yyxt3 := z.Extension(yyv1[yyj1]); yyxt3 != nil {
						z.DecExtension(yyv1[yyj1], yyxt3)
					} else {
						yyv1[yyj1].CodecDecodeSelf(d)
					}
				}
			}
		}
		if yyj1 < len(yyv1) {
			yyv1 = yyv1[:yyj1]
			yyc1 = true
		} else if yyj1 == 0 && yyv1 == nil {
			yyv1 = []*TestStrucFlex{}
			yyc1 = true
		}
	}
	yyh1.End()
	if yyc1 {
		*v = yyv1
	}
}
