# -*- coding: utf-8 -*-
from operator import attrgetter
from pyangbind.lib.yangtypes import RestrictedPrecisionDecimalType
from pyangbind.lib.yangtypes import RestrictedClassType
from pyangbind.lib.yangtypes import TypedListType
from pyangbind.lib.yangtypes import YANGBool
from pyangbind.lib.yangtypes import YANGListType
from pyangbind.lib.yangtypes import YANGDynClass
from pyangbind.lib.yangtypes import ReferenceType
from pyangbind.lib.base import PybindBase
from collections import OrderedDict
from decimal import Decimal
from bitarray import bitarray
import six

# PY3 support of some PY2 keywords (needs improved)
if six.PY3:
  import builtins as __builtin__
  long = int
elif six.PY2:
  import __builtin__

class yc_config_openconfig_macsec__macsec_mka_policies_policy_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-macsec - based on the path /macsec/mka/policies/policy/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configuration of the MKA policy
  """
  __slots__ = ('_path_helper', '_extmethods', '__name','__key_server_priority','__macsec_cipher_suite','__confidentiality_offset','__delay_protection','__include_icv_indicator','__sak_rekey_interval','__sak_rekey_on_live_peer_loss','__use_updated_eth_header',)

  _yang_name = 'config'
  _yang_namespace = 'http://openconfig.net/yang/macsec'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='string', is_config=True)
    self.__key_server_priority = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8)(16), is_leaf=True, yang_name="key-server-priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='uint8', is_config=True)
    self.__macsec_cipher_suite = YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'GCM_AES_128': {}, 'GCM_AES_256': {}, 'GCM_AES_XPN_128': {}, 'GCM_AES_XPN_256': {}},)), is_leaf=False, yang_name="macsec-cipher-suite", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='macsec-types:macsec-cipher-suite', is_config=True)
    self.__confidentiality_offset = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'0_BYTES': {}, '30_BYTES': {}, '50_BYTES': {}},), default=six.text_type("0_BYTES"), is_leaf=True, yang_name="confidentiality-offset", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='macsec-types:confidentiality-offset', is_config=True)
    self.__delay_protection = YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="delay-protection", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='boolean', is_config=True)
    self.__include_icv_indicator = YANGDynClass(base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="include-icv-indicator", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='boolean', is_config=True)
    self.__sak_rekey_interval = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['0', '30..65535']}), default=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32)(0), is_leaf=True, yang_name="sak-rekey-interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='uint32', is_config=True)
    self.__sak_rekey_on_live_peer_loss = YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="sak-rekey-on-live-peer-loss", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='boolean', is_config=True)
    self.__use_updated_eth_header = YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="use-updated-eth-header", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='boolean', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['macsec', 'mka', 'policies', 'policy', 'config']

  def _get_name(self):
    """
    Getter method for name, mapped from YANG variable /macsec/mka/policies/policy/config/name (string)

    YANG Description: Name of the MKA policy.
    """
    return self.__name
      
  def _set_name(self, v, load=False):
    """
    Setter method for name, mapped from YANG variable /macsec/mka/policies/policy/config/name (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_name() directly.

    YANG Description: Name of the MKA policy.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='string', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """name must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='string', is_config=True)""",
        })

    self.__name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_name(self):
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='string', is_config=True)


  def _get_key_server_priority(self):
    """
    Getter method for key_server_priority, mapped from YANG variable /macsec/mka/policies/policy/config/key_server_priority (uint8)

    YANG Description: Specifies the key server priority used by the MACsec Key Agreement
(MKA) protocol to select the key server when MACsec is enabled using
static connectivity association key (CAK) security mode. The switch with
the lower priority-number is selected as the key server. If the
priority-number is identical on both sides of a point-to-point link, the
MKA protocol selects the device with the lower MAC address as the key
server
    """
    return self.__key_server_priority
      
  def _set_key_server_priority(self, v, load=False):
    """
    Setter method for key_server_priority, mapped from YANG variable /macsec/mka/policies/policy/config/key_server_priority (uint8)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_key_server_priority is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_key_server_priority() directly.

    YANG Description: Specifies the key server priority used by the MACsec Key Agreement
(MKA) protocol to select the key server when MACsec is enabled using
static connectivity association key (CAK) security mode. The switch with
the lower priority-number is selected as the key server. If the
priority-number is identical on both sides of a point-to-point link, the
MKA protocol selects the device with the lower MAC address as the key
server
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8)(16), is_leaf=True, yang_name="key-server-priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='uint8', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """key_server_priority must be of a type compatible with uint8""",
          'defined-type': "uint8",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8)(16), is_leaf=True, yang_name="key-server-priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='uint8', is_config=True)""",
        })

    self.__key_server_priority = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_key_server_priority(self):
    self.__key_server_priority = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8)(16), is_leaf=True, yang_name="key-server-priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='uint8', is_config=True)


  def _get_macsec_cipher_suite(self):
    """
    Getter method for macsec_cipher_suite, mapped from YANG variable /macsec/mka/policies/policy/config/macsec_cipher_suite (macsec-types:macsec-cipher-suite)

    YANG Description: Set Cipher suite(s) for SAK derivation
    """
    return self.__macsec_cipher_suite
      
  def _set_macsec_cipher_suite(self, v, load=False):
    """
    Setter method for macsec_cipher_suite, mapped from YANG variable /macsec/mka/policies/policy/config/macsec_cipher_suite (macsec-types:macsec-cipher-suite)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_macsec_cipher_suite is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_macsec_cipher_suite() directly.

    YANG Description: Set Cipher suite(s) for SAK derivation
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'GCM_AES_128': {}, 'GCM_AES_256': {}, 'GCM_AES_XPN_128': {}, 'GCM_AES_XPN_256': {}},)), is_leaf=False, yang_name="macsec-cipher-suite", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='macsec-types:macsec-cipher-suite', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """macsec_cipher_suite must be of a type compatible with macsec-types:macsec-cipher-suite""",
          'defined-type': "macsec-types:macsec-cipher-suite",
          'generated-type': """YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'GCM_AES_128': {}, 'GCM_AES_256': {}, 'GCM_AES_XPN_128': {}, 'GCM_AES_XPN_256': {}},)), is_leaf=False, yang_name="macsec-cipher-suite", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='macsec-types:macsec-cipher-suite', is_config=True)""",
        })

    self.__macsec_cipher_suite = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_macsec_cipher_suite(self):
    self.__macsec_cipher_suite = YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'GCM_AES_128': {}, 'GCM_AES_256': {}, 'GCM_AES_XPN_128': {}, 'GCM_AES_XPN_256': {}},)), is_leaf=False, yang_name="macsec-cipher-suite", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='macsec-types:macsec-cipher-suite', is_config=True)


  def _get_confidentiality_offset(self):
    """
    Getter method for confidentiality_offset, mapped from YANG variable /macsec/mka/policies/policy/config/confidentiality_offset (macsec-types:confidentiality-offset)

    YANG Description: The confidentiality offset specifies a number of octets in an Ethernet
frame that are sent in unencrypted plain-text
    """
    return self.__confidentiality_offset
      
  def _set_confidentiality_offset(self, v, load=False):
    """
    Setter method for confidentiality_offset, mapped from YANG variable /macsec/mka/policies/policy/config/confidentiality_offset (macsec-types:confidentiality-offset)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_confidentiality_offset is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_confidentiality_offset() directly.

    YANG Description: The confidentiality offset specifies a number of octets in an Ethernet
frame that are sent in unencrypted plain-text
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'0_BYTES': {}, '30_BYTES': {}, '50_BYTES': {}},), default=six.text_type("0_BYTES"), is_leaf=True, yang_name="confidentiality-offset", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='macsec-types:confidentiality-offset', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """confidentiality_offset must be of a type compatible with macsec-types:confidentiality-offset""",
          'defined-type': "macsec-types:confidentiality-offset",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'0_BYTES': {}, '30_BYTES': {}, '50_BYTES': {}},), default=six.text_type("0_BYTES"), is_leaf=True, yang_name="confidentiality-offset", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='macsec-types:confidentiality-offset', is_config=True)""",
        })

    self.__confidentiality_offset = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_confidentiality_offset(self):
    self.__confidentiality_offset = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'0_BYTES': {}, '30_BYTES': {}, '50_BYTES': {}},), default=six.text_type("0_BYTES"), is_leaf=True, yang_name="confidentiality-offset", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='macsec-types:confidentiality-offset', is_config=True)


  def _get_delay_protection(self):
    """
    Getter method for delay_protection, mapped from YANG variable /macsec/mka/policies/policy/config/delay_protection (boolean)

    YANG Description: Traffic delayed longer than 2 seconds is rejected by the interfaces
enabled with delay protection.
    """
    return self.__delay_protection
      
  def _set_delay_protection(self, v, load=False):
    """
    Setter method for delay_protection, mapped from YANG variable /macsec/mka/policies/policy/config/delay_protection (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_delay_protection is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_delay_protection() directly.

    YANG Description: Traffic delayed longer than 2 seconds is rejected by the interfaces
enabled with delay protection.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="delay-protection", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='boolean', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """delay_protection must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="delay-protection", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='boolean', is_config=True)""",
        })

    self.__delay_protection = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_delay_protection(self):
    self.__delay_protection = YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="delay-protection", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='boolean', is_config=True)


  def _get_include_icv_indicator(self):
    """
    Getter method for include_icv_indicator, mapped from YANG variable /macsec/mka/policies/policy/config/include_icv_indicator (boolean)

    YANG Description: Generate and include an Integrity Check Value (ICV) field in the MKPDU.
For compatibility with previous MACsec implementation that do not
require an ICV
    """
    return self.__include_icv_indicator
      
  def _set_include_icv_indicator(self, v, load=False):
    """
    Setter method for include_icv_indicator, mapped from YANG variable /macsec/mka/policies/policy/config/include_icv_indicator (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_include_icv_indicator is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_include_icv_indicator() directly.

    YANG Description: Generate and include an Integrity Check Value (ICV) field in the MKPDU.
For compatibility with previous MACsec implementation that do not
require an ICV
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="include-icv-indicator", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='boolean', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """include_icv_indicator must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="include-icv-indicator", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='boolean', is_config=True)""",
        })

    self.__include_icv_indicator = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_include_icv_indicator(self):
    self.__include_icv_indicator = YANGDynClass(base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="include-icv-indicator", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='boolean', is_config=True)


  def _get_sak_rekey_interval(self):
    """
    Getter method for sak_rekey_interval, mapped from YANG variable /macsec/mka/policies/policy/config/sak_rekey_interval (uint32)

    YANG Description: SAK Rekey interval in seconds. The default value is 0 where no rekey is
performed.
    """
    return self.__sak_rekey_interval
      
  def _set_sak_rekey_interval(self, v, load=False):
    """
    Setter method for sak_rekey_interval, mapped from YANG variable /macsec/mka/policies/policy/config/sak_rekey_interval (uint32)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_sak_rekey_interval is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_sak_rekey_interval() directly.

    YANG Description: SAK Rekey interval in seconds. The default value is 0 where no rekey is
performed.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['0', '30..65535']}), default=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32)(0), is_leaf=True, yang_name="sak-rekey-interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='uint32', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """sak_rekey_interval must be of a type compatible with uint32""",
          'defined-type': "uint32",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['0', '30..65535']}), default=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32)(0), is_leaf=True, yang_name="sak-rekey-interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='uint32', is_config=True)""",
        })

    self.__sak_rekey_interval = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_sak_rekey_interval(self):
    self.__sak_rekey_interval = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['0', '30..65535']}), default=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32)(0), is_leaf=True, yang_name="sak-rekey-interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='uint32', is_config=True)


  def _get_sak_rekey_on_live_peer_loss(self):
    """
    Getter method for sak_rekey_on_live_peer_loss, mapped from YANG variable /macsec/mka/policies/policy/config/sak_rekey_on_live_peer_loss (boolean)

    YANG Description: Rekey on peer loss
    """
    return self.__sak_rekey_on_live_peer_loss
      
  def _set_sak_rekey_on_live_peer_loss(self, v, load=False):
    """
    Setter method for sak_rekey_on_live_peer_loss, mapped from YANG variable /macsec/mka/policies/policy/config/sak_rekey_on_live_peer_loss (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_sak_rekey_on_live_peer_loss is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_sak_rekey_on_live_peer_loss() directly.

    YANG Description: Rekey on peer loss
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="sak-rekey-on-live-peer-loss", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='boolean', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """sak_rekey_on_live_peer_loss must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="sak-rekey-on-live-peer-loss", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='boolean', is_config=True)""",
        })

    self.__sak_rekey_on_live_peer_loss = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_sak_rekey_on_live_peer_loss(self):
    self.__sak_rekey_on_live_peer_loss = YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="sak-rekey-on-live-peer-loss", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='boolean', is_config=True)


  def _get_use_updated_eth_header(self):
    """
    Getter method for use_updated_eth_header, mapped from YANG variable /macsec/mka/policies/policy/config/use_updated_eth_header (boolean)

    YANG Description: Use updated ethernet header for ICV calculation. In case the Ethernet
frame headers change, use the updated headers to calculate the ICV.
    """
    return self.__use_updated_eth_header
      
  def _set_use_updated_eth_header(self, v, load=False):
    """
    Setter method for use_updated_eth_header, mapped from YANG variable /macsec/mka/policies/policy/config/use_updated_eth_header (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_use_updated_eth_header is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_use_updated_eth_header() directly.

    YANG Description: Use updated ethernet header for ICV calculation. In case the Ethernet
frame headers change, use the updated headers to calculate the ICV.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="use-updated-eth-header", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='boolean', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """use_updated_eth_header must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="use-updated-eth-header", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='boolean', is_config=True)""",
        })

    self.__use_updated_eth_header = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_use_updated_eth_header(self):
    self.__use_updated_eth_header = YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="use-updated-eth-header", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='boolean', is_config=True)

  name = __builtin__.property(_get_name, _set_name)
  key_server_priority = __builtin__.property(_get_key_server_priority, _set_key_server_priority)
  macsec_cipher_suite = __builtin__.property(_get_macsec_cipher_suite, _set_macsec_cipher_suite)
  confidentiality_offset = __builtin__.property(_get_confidentiality_offset, _set_confidentiality_offset)
  delay_protection = __builtin__.property(_get_delay_protection, _set_delay_protection)
  include_icv_indicator = __builtin__.property(_get_include_icv_indicator, _set_include_icv_indicator)
  sak_rekey_interval = __builtin__.property(_get_sak_rekey_interval, _set_sak_rekey_interval)
  sak_rekey_on_live_peer_loss = __builtin__.property(_get_sak_rekey_on_live_peer_loss, _set_sak_rekey_on_live_peer_loss)
  use_updated_eth_header = __builtin__.property(_get_use_updated_eth_header, _set_use_updated_eth_header)


  _pyangbind_elements = OrderedDict([('name', name), ('key_server_priority', key_server_priority), ('macsec_cipher_suite', macsec_cipher_suite), ('confidentiality_offset', confidentiality_offset), ('delay_protection', delay_protection), ('include_icv_indicator', include_icv_indicator), ('sak_rekey_interval', sak_rekey_interval), ('sak_rekey_on_live_peer_loss', sak_rekey_on_live_peer_loss), ('use_updated_eth_header', use_updated_eth_header), ])


class yc_state_openconfig_macsec__macsec_mka_policies_policy_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-macsec - based on the path /macsec/mka/policies/policy/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational state data for MKA policy
  """
  __slots__ = ('_path_helper', '_extmethods', '__name','__key_server_priority','__macsec_cipher_suite','__confidentiality_offset','__delay_protection','__include_icv_indicator','__sak_rekey_interval','__sak_rekey_on_live_peer_loss','__use_updated_eth_header',)

  _yang_name = 'state'
  _yang_namespace = 'http://openconfig.net/yang/macsec'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='string', is_config=False)
    self.__key_server_priority = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8)(16), is_leaf=True, yang_name="key-server-priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='uint8', is_config=False)
    self.__macsec_cipher_suite = YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'GCM_AES_128': {}, 'GCM_AES_256': {}, 'GCM_AES_XPN_128': {}, 'GCM_AES_XPN_256': {}},)), is_leaf=False, yang_name="macsec-cipher-suite", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='macsec-types:macsec-cipher-suite', is_config=False)
    self.__confidentiality_offset = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'0_BYTES': {}, '30_BYTES': {}, '50_BYTES': {}},), default=six.text_type("0_BYTES"), is_leaf=True, yang_name="confidentiality-offset", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='macsec-types:confidentiality-offset', is_config=False)
    self.__delay_protection = YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="delay-protection", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='boolean', is_config=False)
    self.__include_icv_indicator = YANGDynClass(base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="include-icv-indicator", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='boolean', is_config=False)
    self.__sak_rekey_interval = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['0', '30..65535']}), default=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32)(0), is_leaf=True, yang_name="sak-rekey-interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='uint32', is_config=False)
    self.__sak_rekey_on_live_peer_loss = YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="sak-rekey-on-live-peer-loss", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='boolean', is_config=False)
    self.__use_updated_eth_header = YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="use-updated-eth-header", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='boolean', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['macsec', 'mka', 'policies', 'policy', 'state']

  def _get_name(self):
    """
    Getter method for name, mapped from YANG variable /macsec/mka/policies/policy/state/name (string)

    YANG Description: Name of the MKA policy.
    """
    return self.__name
      
  def _set_name(self, v, load=False):
    """
    Setter method for name, mapped from YANG variable /macsec/mka/policies/policy/state/name (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_name() directly.

    YANG Description: Name of the MKA policy.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """name must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='string', is_config=False)""",
        })

    self.__name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_name(self):
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='string', is_config=False)


  def _get_key_server_priority(self):
    """
    Getter method for key_server_priority, mapped from YANG variable /macsec/mka/policies/policy/state/key_server_priority (uint8)

    YANG Description: Specifies the key server priority used by the MACsec Key Agreement
(MKA) protocol to select the key server when MACsec is enabled using
static connectivity association key (CAK) security mode. The switch with
the lower priority-number is selected as the key server. If the
priority-number is identical on both sides of a point-to-point link, the
MKA protocol selects the device with the lower MAC address as the key
server
    """
    return self.__key_server_priority
      
  def _set_key_server_priority(self, v, load=False):
    """
    Setter method for key_server_priority, mapped from YANG variable /macsec/mka/policies/policy/state/key_server_priority (uint8)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_key_server_priority is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_key_server_priority() directly.

    YANG Description: Specifies the key server priority used by the MACsec Key Agreement
(MKA) protocol to select the key server when MACsec is enabled using
static connectivity association key (CAK) security mode. The switch with
the lower priority-number is selected as the key server. If the
priority-number is identical on both sides of a point-to-point link, the
MKA protocol selects the device with the lower MAC address as the key
server
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8)(16), is_leaf=True, yang_name="key-server-priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='uint8', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """key_server_priority must be of a type compatible with uint8""",
          'defined-type': "uint8",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8)(16), is_leaf=True, yang_name="key-server-priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='uint8', is_config=False)""",
        })

    self.__key_server_priority = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_key_server_priority(self):
    self.__key_server_priority = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8)(16), is_leaf=True, yang_name="key-server-priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='uint8', is_config=False)


  def _get_macsec_cipher_suite(self):
    """
    Getter method for macsec_cipher_suite, mapped from YANG variable /macsec/mka/policies/policy/state/macsec_cipher_suite (macsec-types:macsec-cipher-suite)

    YANG Description: Set Cipher suite(s) for SAK derivation
    """
    return self.__macsec_cipher_suite
      
  def _set_macsec_cipher_suite(self, v, load=False):
    """
    Setter method for macsec_cipher_suite, mapped from YANG variable /macsec/mka/policies/policy/state/macsec_cipher_suite (macsec-types:macsec-cipher-suite)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_macsec_cipher_suite is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_macsec_cipher_suite() directly.

    YANG Description: Set Cipher suite(s) for SAK derivation
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'GCM_AES_128': {}, 'GCM_AES_256': {}, 'GCM_AES_XPN_128': {}, 'GCM_AES_XPN_256': {}},)), is_leaf=False, yang_name="macsec-cipher-suite", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='macsec-types:macsec-cipher-suite', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """macsec_cipher_suite must be of a type compatible with macsec-types:macsec-cipher-suite""",
          'defined-type': "macsec-types:macsec-cipher-suite",
          'generated-type': """YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'GCM_AES_128': {}, 'GCM_AES_256': {}, 'GCM_AES_XPN_128': {}, 'GCM_AES_XPN_256': {}},)), is_leaf=False, yang_name="macsec-cipher-suite", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='macsec-types:macsec-cipher-suite', is_config=False)""",
        })

    self.__macsec_cipher_suite = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_macsec_cipher_suite(self):
    self.__macsec_cipher_suite = YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'GCM_AES_128': {}, 'GCM_AES_256': {}, 'GCM_AES_XPN_128': {}, 'GCM_AES_XPN_256': {}},)), is_leaf=False, yang_name="macsec-cipher-suite", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='macsec-types:macsec-cipher-suite', is_config=False)


  def _get_confidentiality_offset(self):
    """
    Getter method for confidentiality_offset, mapped from YANG variable /macsec/mka/policies/policy/state/confidentiality_offset (macsec-types:confidentiality-offset)

    YANG Description: The confidentiality offset specifies a number of octets in an Ethernet
frame that are sent in unencrypted plain-text
    """
    return self.__confidentiality_offset
      
  def _set_confidentiality_offset(self, v, load=False):
    """
    Setter method for confidentiality_offset, mapped from YANG variable /macsec/mka/policies/policy/state/confidentiality_offset (macsec-types:confidentiality-offset)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_confidentiality_offset is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_confidentiality_offset() directly.

    YANG Description: The confidentiality offset specifies a number of octets in an Ethernet
frame that are sent in unencrypted plain-text
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'0_BYTES': {}, '30_BYTES': {}, '50_BYTES': {}},), default=six.text_type("0_BYTES"), is_leaf=True, yang_name="confidentiality-offset", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='macsec-types:confidentiality-offset', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """confidentiality_offset must be of a type compatible with macsec-types:confidentiality-offset""",
          'defined-type': "macsec-types:confidentiality-offset",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'0_BYTES': {}, '30_BYTES': {}, '50_BYTES': {}},), default=six.text_type("0_BYTES"), is_leaf=True, yang_name="confidentiality-offset", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='macsec-types:confidentiality-offset', is_config=False)""",
        })

    self.__confidentiality_offset = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_confidentiality_offset(self):
    self.__confidentiality_offset = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'0_BYTES': {}, '30_BYTES': {}, '50_BYTES': {}},), default=six.text_type("0_BYTES"), is_leaf=True, yang_name="confidentiality-offset", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='macsec-types:confidentiality-offset', is_config=False)


  def _get_delay_protection(self):
    """
    Getter method for delay_protection, mapped from YANG variable /macsec/mka/policies/policy/state/delay_protection (boolean)

    YANG Description: Traffic delayed longer than 2 seconds is rejected by the interfaces
enabled with delay protection.
    """
    return self.__delay_protection
      
  def _set_delay_protection(self, v, load=False):
    """
    Setter method for delay_protection, mapped from YANG variable /macsec/mka/policies/policy/state/delay_protection (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_delay_protection is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_delay_protection() directly.

    YANG Description: Traffic delayed longer than 2 seconds is rejected by the interfaces
enabled with delay protection.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="delay-protection", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='boolean', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """delay_protection must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="delay-protection", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='boolean', is_config=False)""",
        })

    self.__delay_protection = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_delay_protection(self):
    self.__delay_protection = YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="delay-protection", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='boolean', is_config=False)


  def _get_include_icv_indicator(self):
    """
    Getter method for include_icv_indicator, mapped from YANG variable /macsec/mka/policies/policy/state/include_icv_indicator (boolean)

    YANG Description: Generate and include an Integrity Check Value (ICV) field in the MKPDU.
For compatibility with previous MACsec implementation that do not
require an ICV
    """
    return self.__include_icv_indicator
      
  def _set_include_icv_indicator(self, v, load=False):
    """
    Setter method for include_icv_indicator, mapped from YANG variable /macsec/mka/policies/policy/state/include_icv_indicator (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_include_icv_indicator is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_include_icv_indicator() directly.

    YANG Description: Generate and include an Integrity Check Value (ICV) field in the MKPDU.
For compatibility with previous MACsec implementation that do not
require an ICV
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="include-icv-indicator", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='boolean', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """include_icv_indicator must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="include-icv-indicator", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='boolean', is_config=False)""",
        })

    self.__include_icv_indicator = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_include_icv_indicator(self):
    self.__include_icv_indicator = YANGDynClass(base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="include-icv-indicator", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='boolean', is_config=False)


  def _get_sak_rekey_interval(self):
    """
    Getter method for sak_rekey_interval, mapped from YANG variable /macsec/mka/policies/policy/state/sak_rekey_interval (uint32)

    YANG Description: SAK Rekey interval in seconds. The default value is 0 where no rekey is
performed.
    """
    return self.__sak_rekey_interval
      
  def _set_sak_rekey_interval(self, v, load=False):
    """
    Setter method for sak_rekey_interval, mapped from YANG variable /macsec/mka/policies/policy/state/sak_rekey_interval (uint32)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_sak_rekey_interval is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_sak_rekey_interval() directly.

    YANG Description: SAK Rekey interval in seconds. The default value is 0 where no rekey is
performed.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['0', '30..65535']}), default=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32)(0), is_leaf=True, yang_name="sak-rekey-interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='uint32', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """sak_rekey_interval must be of a type compatible with uint32""",
          'defined-type': "uint32",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['0', '30..65535']}), default=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32)(0), is_leaf=True, yang_name="sak-rekey-interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='uint32', is_config=False)""",
        })

    self.__sak_rekey_interval = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_sak_rekey_interval(self):
    self.__sak_rekey_interval = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['0', '30..65535']}), default=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32)(0), is_leaf=True, yang_name="sak-rekey-interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='uint32', is_config=False)


  def _get_sak_rekey_on_live_peer_loss(self):
    """
    Getter method for sak_rekey_on_live_peer_loss, mapped from YANG variable /macsec/mka/policies/policy/state/sak_rekey_on_live_peer_loss (boolean)

    YANG Description: Rekey on peer loss
    """
    return self.__sak_rekey_on_live_peer_loss
      
  def _set_sak_rekey_on_live_peer_loss(self, v, load=False):
    """
    Setter method for sak_rekey_on_live_peer_loss, mapped from YANG variable /macsec/mka/policies/policy/state/sak_rekey_on_live_peer_loss (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_sak_rekey_on_live_peer_loss is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_sak_rekey_on_live_peer_loss() directly.

    YANG Description: Rekey on peer loss
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="sak-rekey-on-live-peer-loss", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='boolean', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """sak_rekey_on_live_peer_loss must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="sak-rekey-on-live-peer-loss", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='boolean', is_config=False)""",
        })

    self.__sak_rekey_on_live_peer_loss = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_sak_rekey_on_live_peer_loss(self):
    self.__sak_rekey_on_live_peer_loss = YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="sak-rekey-on-live-peer-loss", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='boolean', is_config=False)


  def _get_use_updated_eth_header(self):
    """
    Getter method for use_updated_eth_header, mapped from YANG variable /macsec/mka/policies/policy/state/use_updated_eth_header (boolean)

    YANG Description: Use updated ethernet header for ICV calculation. In case the Ethernet
frame headers change, use the updated headers to calculate the ICV.
    """
    return self.__use_updated_eth_header
      
  def _set_use_updated_eth_header(self, v, load=False):
    """
    Setter method for use_updated_eth_header, mapped from YANG variable /macsec/mka/policies/policy/state/use_updated_eth_header (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_use_updated_eth_header is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_use_updated_eth_header() directly.

    YANG Description: Use updated ethernet header for ICV calculation. In case the Ethernet
frame headers change, use the updated headers to calculate the ICV.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="use-updated-eth-header", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='boolean', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """use_updated_eth_header must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="use-updated-eth-header", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='boolean', is_config=False)""",
        })

    self.__use_updated_eth_header = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_use_updated_eth_header(self):
    self.__use_updated_eth_header = YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="use-updated-eth-header", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='boolean', is_config=False)

  name = __builtin__.property(_get_name)
  key_server_priority = __builtin__.property(_get_key_server_priority)
  macsec_cipher_suite = __builtin__.property(_get_macsec_cipher_suite)
  confidentiality_offset = __builtin__.property(_get_confidentiality_offset)
  delay_protection = __builtin__.property(_get_delay_protection)
  include_icv_indicator = __builtin__.property(_get_include_icv_indicator)
  sak_rekey_interval = __builtin__.property(_get_sak_rekey_interval)
  sak_rekey_on_live_peer_loss = __builtin__.property(_get_sak_rekey_on_live_peer_loss)
  use_updated_eth_header = __builtin__.property(_get_use_updated_eth_header)


  _pyangbind_elements = OrderedDict([('name', name), ('key_server_priority', key_server_priority), ('macsec_cipher_suite', macsec_cipher_suite), ('confidentiality_offset', confidentiality_offset), ('delay_protection', delay_protection), ('include_icv_indicator', include_icv_indicator), ('sak_rekey_interval', sak_rekey_interval), ('sak_rekey_on_live_peer_loss', sak_rekey_on_live_peer_loss), ('use_updated_eth_header', use_updated_eth_header), ])


class yc_policy_openconfig_macsec__macsec_mka_policies_policy(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-macsec - based on the path /macsec/mka/policies/policy. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: List of MKA policies
  """
  __slots__ = ('_path_helper', '_extmethods', '__name','__config','__state',)

  _yang_name = 'policy'
  _yang_namespace = 'http://openconfig.net/yang/macsec'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='leafref', is_config=True)
    self.__config = YANGDynClass(base=yc_config_openconfig_macsec__macsec_mka_policies_policy_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_macsec__macsec_mka_policies_policy_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['macsec', 'mka', 'policies', 'policy']

  def _get_name(self):
    """
    Getter method for name, mapped from YANG variable /macsec/mka/policies/policy/name (leafref)

    YANG Description: Reference to MKA policy name
    """
    return self.__name
      
  def _set_name(self, v, load=False):
    """
    Setter method for name, mapped from YANG variable /macsec/mka/policies/policy/name (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_name() directly.

    YANG Description: Reference to MKA policy name
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """name must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='leafref', is_config=True)""",
        })

    self.__name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_name(self):
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='leafref', is_config=True)


  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /macsec/mka/policies/policy/config (container)

    YANG Description: Configuration of the MKA policy
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /macsec/mka/policies/policy/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Configuration of the MKA policy
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_macsec__macsec_mka_policies_policy_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_macsec__macsec_mka_policies_policy_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_macsec__macsec_mka_policies_policy_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /macsec/mka/policies/policy/state (container)

    YANG Description: Operational state data for MKA policy
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /macsec/mka/policies/policy/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: Operational state data for MKA policy
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_macsec__macsec_mka_policies_policy_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_macsec__macsec_mka_policies_policy_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_macsec__macsec_mka_policies_policy_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='container', is_config=True)

  name = __builtin__.property(_get_name, _set_name)
  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)


  _pyangbind_elements = OrderedDict([('name', name), ('config', config), ('state', state), ])


class yc_policies_openconfig_macsec__macsec_mka_policies(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-macsec - based on the path /macsec/mka/policies. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Enclosing container for the list of MKA policies
  """
  __slots__ = ('_path_helper', '_extmethods', '__policy',)

  _yang_name = 'policies'
  _yang_namespace = 'http://openconfig.net/yang/macsec'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__policy = YANGDynClass(base=YANGListType("name",yc_policy_openconfig_macsec__macsec_mka_policies_policy, yang_name="policy", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name', extensions=None), is_container='list', yang_name="policy", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='list', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['macsec', 'mka', 'policies']

  def _get_policy(self):
    """
    Getter method for policy, mapped from YANG variable /macsec/mka/policies/policy (list)

    YANG Description: List of MKA policies
    """
    return self.__policy
      
  def _set_policy(self, v, load=False):
    """
    Setter method for policy, mapped from YANG variable /macsec/mka/policies/policy (list)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_policy is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_policy() directly.

    YANG Description: List of MKA policies
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGListType("name",yc_policy_openconfig_macsec__macsec_mka_policies_policy, yang_name="policy", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name', extensions=None), is_container='list', yang_name="policy", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='list', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """policy must be of a type compatible with list""",
          'defined-type': "list",
          'generated-type': """YANGDynClass(base=YANGListType("name",yc_policy_openconfig_macsec__macsec_mka_policies_policy, yang_name="policy", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name', extensions=None), is_container='list', yang_name="policy", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='list', is_config=True)""",
        })

    self.__policy = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_policy(self):
    self.__policy = YANGDynClass(base=YANGListType("name",yc_policy_openconfig_macsec__macsec_mka_policies_policy, yang_name="policy", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name', extensions=None), is_container='list', yang_name="policy", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='list', is_config=True)

  policy = __builtin__.property(_get_policy, _set_policy)


  _pyangbind_elements = OrderedDict([('policy', policy), ])


class yc_counters_openconfig_macsec__macsec_mka_state_counters(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-macsec - based on the path /macsec/mka/state/counters. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: MKA global counters
  """
  __slots__ = ('_path_helper', '_extmethods', '__out_mkpdu_errors','__in_mkpdu_icv_verification_errors','__in_mkpdu_validation_errors','__in_mkpdu_bad_peer_errors','__in_mkpdu_peer_list_errors','__sak_generation_errors','__sak_hash_errors','__sak_encryption_errors','__sak_decryption_errors','__sak_cipher_mismatch_errors',)

  _yang_name = 'counters'
  _yang_namespace = 'http://openconfig.net/yang/macsec'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__out_mkpdu_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-mkpdu-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='oc-yang:counter64', is_config=False)
    self.__in_mkpdu_icv_verification_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-mkpdu-icv-verification-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='oc-yang:counter64', is_config=False)
    self.__in_mkpdu_validation_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-mkpdu-validation-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='oc-yang:counter64', is_config=False)
    self.__in_mkpdu_bad_peer_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-mkpdu-bad-peer-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='oc-yang:counter64', is_config=False)
    self.__in_mkpdu_peer_list_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-mkpdu-peer-list-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='oc-yang:counter64', is_config=False)
    self.__sak_generation_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="sak-generation-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='oc-yang:counter64', is_config=False)
    self.__sak_hash_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="sak-hash-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='oc-yang:counter64', is_config=False)
    self.__sak_encryption_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="sak-encryption-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='oc-yang:counter64', is_config=False)
    self.__sak_decryption_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="sak-decryption-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='oc-yang:counter64', is_config=False)
    self.__sak_cipher_mismatch_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="sak-cipher-mismatch-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='oc-yang:counter64', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['macsec', 'mka', 'state', 'counters']

  def _get_out_mkpdu_errors(self):
    """
    Getter method for out_mkpdu_errors, mapped from YANG variable /macsec/mka/state/counters/out_mkpdu_errors (oc-yang:counter64)

    YANG Description: MKPDU TX error count
    """
    return self.__out_mkpdu_errors
      
  def _set_out_mkpdu_errors(self, v, load=False):
    """
    Setter method for out_mkpdu_errors, mapped from YANG variable /macsec/mka/state/counters/out_mkpdu_errors (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_out_mkpdu_errors is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_out_mkpdu_errors() directly.

    YANG Description: MKPDU TX error count
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-mkpdu-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """out_mkpdu_errors must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-mkpdu-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__out_mkpdu_errors = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_out_mkpdu_errors(self):
    self.__out_mkpdu_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-mkpdu-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='oc-yang:counter64', is_config=False)


  def _get_in_mkpdu_icv_verification_errors(self):
    """
    Getter method for in_mkpdu_icv_verification_errors, mapped from YANG variable /macsec/mka/state/counters/in_mkpdu_icv_verification_errors (oc-yang:counter64)

    YANG Description: MKPDU RX ICV verification error count
    """
    return self.__in_mkpdu_icv_verification_errors
      
  def _set_in_mkpdu_icv_verification_errors(self, v, load=False):
    """
    Setter method for in_mkpdu_icv_verification_errors, mapped from YANG variable /macsec/mka/state/counters/in_mkpdu_icv_verification_errors (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_in_mkpdu_icv_verification_errors is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_in_mkpdu_icv_verification_errors() directly.

    YANG Description: MKPDU RX ICV verification error count
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-mkpdu-icv-verification-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """in_mkpdu_icv_verification_errors must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-mkpdu-icv-verification-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__in_mkpdu_icv_verification_errors = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_in_mkpdu_icv_verification_errors(self):
    self.__in_mkpdu_icv_verification_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-mkpdu-icv-verification-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='oc-yang:counter64', is_config=False)


  def _get_in_mkpdu_validation_errors(self):
    """
    Getter method for in_mkpdu_validation_errors, mapped from YANG variable /macsec/mka/state/counters/in_mkpdu_validation_errors (oc-yang:counter64)

    YANG Description: MKPDU RX validation error count
    """
    return self.__in_mkpdu_validation_errors
      
  def _set_in_mkpdu_validation_errors(self, v, load=False):
    """
    Setter method for in_mkpdu_validation_errors, mapped from YANG variable /macsec/mka/state/counters/in_mkpdu_validation_errors (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_in_mkpdu_validation_errors is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_in_mkpdu_validation_errors() directly.

    YANG Description: MKPDU RX validation error count
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-mkpdu-validation-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """in_mkpdu_validation_errors must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-mkpdu-validation-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__in_mkpdu_validation_errors = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_in_mkpdu_validation_errors(self):
    self.__in_mkpdu_validation_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-mkpdu-validation-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='oc-yang:counter64', is_config=False)


  def _get_in_mkpdu_bad_peer_errors(self):
    """
    Getter method for in_mkpdu_bad_peer_errors, mapped from YANG variable /macsec/mka/state/counters/in_mkpdu_bad_peer_errors (oc-yang:counter64)

    YANG Description: MKPDU RX bad peer message number error count
    """
    return self.__in_mkpdu_bad_peer_errors
      
  def _set_in_mkpdu_bad_peer_errors(self, v, load=False):
    """
    Setter method for in_mkpdu_bad_peer_errors, mapped from YANG variable /macsec/mka/state/counters/in_mkpdu_bad_peer_errors (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_in_mkpdu_bad_peer_errors is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_in_mkpdu_bad_peer_errors() directly.

    YANG Description: MKPDU RX bad peer message number error count
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-mkpdu-bad-peer-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """in_mkpdu_bad_peer_errors must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-mkpdu-bad-peer-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__in_mkpdu_bad_peer_errors = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_in_mkpdu_bad_peer_errors(self):
    self.__in_mkpdu_bad_peer_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-mkpdu-bad-peer-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='oc-yang:counter64', is_config=False)


  def _get_in_mkpdu_peer_list_errors(self):
    """
    Getter method for in_mkpdu_peer_list_errors, mapped from YANG variable /macsec/mka/state/counters/in_mkpdu_peer_list_errors (oc-yang:counter64)

    YANG Description: MKPDU RX non-recent peer list Message Number error count
    """
    return self.__in_mkpdu_peer_list_errors
      
  def _set_in_mkpdu_peer_list_errors(self, v, load=False):
    """
    Setter method for in_mkpdu_peer_list_errors, mapped from YANG variable /macsec/mka/state/counters/in_mkpdu_peer_list_errors (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_in_mkpdu_peer_list_errors is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_in_mkpdu_peer_list_errors() directly.

    YANG Description: MKPDU RX non-recent peer list Message Number error count
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-mkpdu-peer-list-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """in_mkpdu_peer_list_errors must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-mkpdu-peer-list-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__in_mkpdu_peer_list_errors = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_in_mkpdu_peer_list_errors(self):
    self.__in_mkpdu_peer_list_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-mkpdu-peer-list-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='oc-yang:counter64', is_config=False)


  def _get_sak_generation_errors(self):
    """
    Getter method for sak_generation_errors, mapped from YANG variable /macsec/mka/state/counters/sak_generation_errors (oc-yang:counter64)

    YANG Description: MKA error SAK generation count
    """
    return self.__sak_generation_errors
      
  def _set_sak_generation_errors(self, v, load=False):
    """
    Setter method for sak_generation_errors, mapped from YANG variable /macsec/mka/state/counters/sak_generation_errors (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_sak_generation_errors is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_sak_generation_errors() directly.

    YANG Description: MKA error SAK generation count
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="sak-generation-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """sak_generation_errors must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="sak-generation-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__sak_generation_errors = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_sak_generation_errors(self):
    self.__sak_generation_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="sak-generation-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='oc-yang:counter64', is_config=False)


  def _get_sak_hash_errors(self):
    """
    Getter method for sak_hash_errors, mapped from YANG variable /macsec/mka/state/counters/sak_hash_errors (oc-yang:counter64)

    YANG Description: MKA error Hash Key generation count
    """
    return self.__sak_hash_errors
      
  def _set_sak_hash_errors(self, v, load=False):
    """
    Setter method for sak_hash_errors, mapped from YANG variable /macsec/mka/state/counters/sak_hash_errors (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_sak_hash_errors is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_sak_hash_errors() directly.

    YANG Description: MKA error Hash Key generation count
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="sak-hash-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """sak_hash_errors must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="sak-hash-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__sak_hash_errors = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_sak_hash_errors(self):
    self.__sak_hash_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="sak-hash-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='oc-yang:counter64', is_config=False)


  def _get_sak_encryption_errors(self):
    """
    Getter method for sak_encryption_errors, mapped from YANG variable /macsec/mka/state/counters/sak_encryption_errors (oc-yang:counter64)

    YANG Description: MKA error SAK encryption/wrap count
    """
    return self.__sak_encryption_errors
      
  def _set_sak_encryption_errors(self, v, load=False):
    """
    Setter method for sak_encryption_errors, mapped from YANG variable /macsec/mka/state/counters/sak_encryption_errors (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_sak_encryption_errors is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_sak_encryption_errors() directly.

    YANG Description: MKA error SAK encryption/wrap count
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="sak-encryption-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """sak_encryption_errors must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="sak-encryption-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__sak_encryption_errors = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_sak_encryption_errors(self):
    self.__sak_encryption_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="sak-encryption-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='oc-yang:counter64', is_config=False)


  def _get_sak_decryption_errors(self):
    """
    Getter method for sak_decryption_errors, mapped from YANG variable /macsec/mka/state/counters/sak_decryption_errors (oc-yang:counter64)

    YANG Description: MKA error SAK decryption/unwrap count
    """
    return self.__sak_decryption_errors
      
  def _set_sak_decryption_errors(self, v, load=False):
    """
    Setter method for sak_decryption_errors, mapped from YANG variable /macsec/mka/state/counters/sak_decryption_errors (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_sak_decryption_errors is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_sak_decryption_errors() directly.

    YANG Description: MKA error SAK decryption/unwrap count
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="sak-decryption-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """sak_decryption_errors must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="sak-decryption-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__sak_decryption_errors = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_sak_decryption_errors(self):
    self.__sak_decryption_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="sak-decryption-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='oc-yang:counter64', is_config=False)


  def _get_sak_cipher_mismatch_errors(self):
    """
    Getter method for sak_cipher_mismatch_errors, mapped from YANG variable /macsec/mka/state/counters/sak_cipher_mismatch_errors (oc-yang:counter64)

    YANG Description: MKA error SAK cipher mismatch count
    """
    return self.__sak_cipher_mismatch_errors
      
  def _set_sak_cipher_mismatch_errors(self, v, load=False):
    """
    Setter method for sak_cipher_mismatch_errors, mapped from YANG variable /macsec/mka/state/counters/sak_cipher_mismatch_errors (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_sak_cipher_mismatch_errors is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_sak_cipher_mismatch_errors() directly.

    YANG Description: MKA error SAK cipher mismatch count
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="sak-cipher-mismatch-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """sak_cipher_mismatch_errors must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="sak-cipher-mismatch-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__sak_cipher_mismatch_errors = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_sak_cipher_mismatch_errors(self):
    self.__sak_cipher_mismatch_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="sak-cipher-mismatch-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='oc-yang:counter64', is_config=False)

  out_mkpdu_errors = __builtin__.property(_get_out_mkpdu_errors)
  in_mkpdu_icv_verification_errors = __builtin__.property(_get_in_mkpdu_icv_verification_errors)
  in_mkpdu_validation_errors = __builtin__.property(_get_in_mkpdu_validation_errors)
  in_mkpdu_bad_peer_errors = __builtin__.property(_get_in_mkpdu_bad_peer_errors)
  in_mkpdu_peer_list_errors = __builtin__.property(_get_in_mkpdu_peer_list_errors)
  sak_generation_errors = __builtin__.property(_get_sak_generation_errors)
  sak_hash_errors = __builtin__.property(_get_sak_hash_errors)
  sak_encryption_errors = __builtin__.property(_get_sak_encryption_errors)
  sak_decryption_errors = __builtin__.property(_get_sak_decryption_errors)
  sak_cipher_mismatch_errors = __builtin__.property(_get_sak_cipher_mismatch_errors)


  _pyangbind_elements = OrderedDict([('out_mkpdu_errors', out_mkpdu_errors), ('in_mkpdu_icv_verification_errors', in_mkpdu_icv_verification_errors), ('in_mkpdu_validation_errors', in_mkpdu_validation_errors), ('in_mkpdu_bad_peer_errors', in_mkpdu_bad_peer_errors), ('in_mkpdu_peer_list_errors', in_mkpdu_peer_list_errors), ('sak_generation_errors', sak_generation_errors), ('sak_hash_errors', sak_hash_errors), ('sak_encryption_errors', sak_encryption_errors), ('sak_decryption_errors', sak_decryption_errors), ('sak_cipher_mismatch_errors', sak_cipher_mismatch_errors), ])


class yc_state_openconfig_macsec__macsec_mka_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-macsec - based on the path /macsec/mka/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational state data for MKA
  """
  __slots__ = ('_path_helper', '_extmethods', '__counters',)

  _yang_name = 'state'
  _yang_namespace = 'http://openconfig.net/yang/macsec'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__counters = YANGDynClass(base=yc_counters_openconfig_macsec__macsec_mka_state_counters, is_container='container', yang_name="counters", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='container', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['macsec', 'mka', 'state']

  def _get_counters(self):
    """
    Getter method for counters, mapped from YANG variable /macsec/mka/state/counters (container)

    YANG Description: MKA global counters
    """
    return self.__counters
      
  def _set_counters(self, v, load=False):
    """
    Setter method for counters, mapped from YANG variable /macsec/mka/state/counters (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_counters is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_counters() directly.

    YANG Description: MKA global counters
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_counters_openconfig_macsec__macsec_mka_state_counters, is_container='container', yang_name="counters", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """counters must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_counters_openconfig_macsec__macsec_mka_state_counters, is_container='container', yang_name="counters", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='container', is_config=False)""",
        })

    self.__counters = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_counters(self):
    self.__counters = YANGDynClass(base=yc_counters_openconfig_macsec__macsec_mka_state_counters, is_container='container', yang_name="counters", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='container', is_config=False)

  counters = __builtin__.property(_get_counters)


  _pyangbind_elements = OrderedDict([('counters', counters), ])


class yc_mka_openconfig_macsec__macsec_mka(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-macsec - based on the path /macsec/mka. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: The MKA
  """
  __slots__ = ('_path_helper', '_extmethods', '__policies','__state',)

  _yang_name = 'mka'
  _yang_namespace = 'http://openconfig.net/yang/macsec'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__policies = YANGDynClass(base=yc_policies_openconfig_macsec__macsec_mka_policies, is_container='container', yang_name="policies", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_macsec__macsec_mka_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['macsec', 'mka']

  def _get_policies(self):
    """
    Getter method for policies, mapped from YANG variable /macsec/mka/policies (container)

    YANG Description: Enclosing container for the list of MKA policies
    """
    return self.__policies
      
  def _set_policies(self, v, load=False):
    """
    Setter method for policies, mapped from YANG variable /macsec/mka/policies (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_policies is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_policies() directly.

    YANG Description: Enclosing container for the list of MKA policies
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_policies_openconfig_macsec__macsec_mka_policies, is_container='container', yang_name="policies", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """policies must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_policies_openconfig_macsec__macsec_mka_policies, is_container='container', yang_name="policies", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='container', is_config=True)""",
        })

    self.__policies = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_policies(self):
    self.__policies = YANGDynClass(base=yc_policies_openconfig_macsec__macsec_mka_policies, is_container='container', yang_name="policies", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /macsec/mka/state (container)

    YANG Description: Operational state data for MKA
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /macsec/mka/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: Operational state data for MKA
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_macsec__macsec_mka_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_macsec__macsec_mka_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_macsec__macsec_mka_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='container', is_config=True)

  policies = __builtin__.property(_get_policies, _set_policies)
  state = __builtin__.property(_get_state, _set_state)


  _pyangbind_elements = OrderedDict([('policies', policies), ('state', state), ])


class yc_config_openconfig_macsec__macsec_interfaces_interface_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-macsec - based on the path /macsec/interfaces/interface/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configuration data for MACsec on each interface
  """
  __slots__ = ('_path_helper', '_extmethods', '__name','__enable','__replay_protection',)

  _yang_name = 'config'
  _yang_namespace = 'http://openconfig.net/yang/macsec'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='oc-if:base-interface-ref', is_config=True)
    self.__enable = YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="enable", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='boolean', is_config=True)
    self.__replay_protection = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16)(0), is_leaf=True, yang_name="replay-protection", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='uint16', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['macsec', 'interfaces', 'interface', 'config']

  def _get_name(self):
    """
    Getter method for name, mapped from YANG variable /macsec/interfaces/interface/config/name (oc-if:base-interface-ref)

    YANG Description: Reference to the MACsec Ethernet interface
    """
    return self.__name
      
  def _set_name(self, v, load=False):
    """
    Setter method for name, mapped from YANG variable /macsec/interfaces/interface/config/name (oc-if:base-interface-ref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_name() directly.

    YANG Description: Reference to the MACsec Ethernet interface
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='oc-if:base-interface-ref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """name must be of a type compatible with oc-if:base-interface-ref""",
          'defined-type': "oc-if:base-interface-ref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='oc-if:base-interface-ref', is_config=True)""",
        })

    self.__name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_name(self):
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='oc-if:base-interface-ref', is_config=True)


  def _get_enable(self):
    """
    Getter method for enable, mapped from YANG variable /macsec/interfaces/interface/config/enable (boolean)

    YANG Description: Enable MACsec on an interface
    """
    return self.__enable
      
  def _set_enable(self, v, load=False):
    """
    Setter method for enable, mapped from YANG variable /macsec/interfaces/interface/config/enable (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_enable is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_enable() directly.

    YANG Description: Enable MACsec on an interface
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="enable", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='boolean', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """enable must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="enable", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='boolean', is_config=True)""",
        })

    self.__enable = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_enable(self):
    self.__enable = YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="enable", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='boolean', is_config=True)


  def _get_replay_protection(self):
    """
    Getter method for replay_protection, mapped from YANG variable /macsec/interfaces/interface/config/replay_protection (uint16)

    YANG Description: MACsec window size, as defined by the number of out-of-order frames
that are accepted. A value of 0 means that frames are accepted only in
the correct order.
    """
    return self.__replay_protection
      
  def _set_replay_protection(self, v, load=False):
    """
    Setter method for replay_protection, mapped from YANG variable /macsec/interfaces/interface/config/replay_protection (uint16)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_replay_protection is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_replay_protection() directly.

    YANG Description: MACsec window size, as defined by the number of out-of-order frames
that are accepted. A value of 0 means that frames are accepted only in
the correct order.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16)(0), is_leaf=True, yang_name="replay-protection", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='uint16', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """replay_protection must be of a type compatible with uint16""",
          'defined-type': "uint16",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16)(0), is_leaf=True, yang_name="replay-protection", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='uint16', is_config=True)""",
        })

    self.__replay_protection = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_replay_protection(self):
    self.__replay_protection = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16)(0), is_leaf=True, yang_name="replay-protection", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='uint16', is_config=True)

  name = __builtin__.property(_get_name, _set_name)
  enable = __builtin__.property(_get_enable, _set_enable)
  replay_protection = __builtin__.property(_get_replay_protection, _set_replay_protection)


  _pyangbind_elements = OrderedDict([('name', name), ('enable', enable), ('replay_protection', replay_protection), ])


class yc_counters_openconfig_macsec__macsec_interfaces_interface_state_counters(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-macsec - based on the path /macsec/interfaces/interface/state/counters. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: MACsec interface counters
  """
  __slots__ = ('_path_helper', '_extmethods', '__tx_untagged_pkts','__rx_untagged_pkts','__rx_badtag_pkts','__rx_unknownsci_pkts','__rx_nosci_pkts','__rx_late_pkts',)

  _yang_name = 'counters'
  _yang_namespace = 'http://openconfig.net/yang/macsec'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__tx_untagged_pkts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="tx-untagged-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='oc-yang:counter64', is_config=False)
    self.__rx_untagged_pkts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="rx-untagged-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='oc-yang:counter64', is_config=False)
    self.__rx_badtag_pkts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="rx-badtag-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='oc-yang:counter64', is_config=False)
    self.__rx_unknownsci_pkts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="rx-unknownsci-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='oc-yang:counter64', is_config=False)
    self.__rx_nosci_pkts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="rx-nosci-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='oc-yang:counter64', is_config=False)
    self.__rx_late_pkts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="rx-late-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='oc-yang:counter64', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['macsec', 'interfaces', 'interface', 'state', 'counters']

  def _get_tx_untagged_pkts(self):
    """
    Getter method for tx_untagged_pkts, mapped from YANG variable /macsec/interfaces/interface/state/counters/tx_untagged_pkts (oc-yang:counter64)

    YANG Description: MACsec interface level Transmit untagged Packets counter.
This counter will increment if MACsec is enabled on interface and the
outgoing packet is not tagged with MACsec header.
    """
    return self.__tx_untagged_pkts
      
  def _set_tx_untagged_pkts(self, v, load=False):
    """
    Setter method for tx_untagged_pkts, mapped from YANG variable /macsec/interfaces/interface/state/counters/tx_untagged_pkts (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_tx_untagged_pkts is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_tx_untagged_pkts() directly.

    YANG Description: MACsec interface level Transmit untagged Packets counter.
This counter will increment if MACsec is enabled on interface and the
outgoing packet is not tagged with MACsec header.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="tx-untagged-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """tx_untagged_pkts must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="tx-untagged-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__tx_untagged_pkts = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_tx_untagged_pkts(self):
    self.__tx_untagged_pkts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="tx-untagged-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='oc-yang:counter64', is_config=False)


  def _get_rx_untagged_pkts(self):
    """
    Getter method for rx_untagged_pkts, mapped from YANG variable /macsec/interfaces/interface/state/counters/rx_untagged_pkts (oc-yang:counter64)

    YANG Description: MACsec interface level Receive untagged Packets counter.
This counter will increment if MACsec is enabled on interface and the
incoming packet does not have MACsec tag.
    """
    return self.__rx_untagged_pkts
      
  def _set_rx_untagged_pkts(self, v, load=False):
    """
    Setter method for rx_untagged_pkts, mapped from YANG variable /macsec/interfaces/interface/state/counters/rx_untagged_pkts (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_rx_untagged_pkts is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_rx_untagged_pkts() directly.

    YANG Description: MACsec interface level Receive untagged Packets counter.
This counter will increment if MACsec is enabled on interface and the
incoming packet does not have MACsec tag.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="rx-untagged-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """rx_untagged_pkts must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="rx-untagged-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__rx_untagged_pkts = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_rx_untagged_pkts(self):
    self.__rx_untagged_pkts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="rx-untagged-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='oc-yang:counter64', is_config=False)


  def _get_rx_badtag_pkts(self):
    """
    Getter method for rx_badtag_pkts, mapped from YANG variable /macsec/interfaces/interface/state/counters/rx_badtag_pkts (oc-yang:counter64)

    YANG Description: MACsec interface level Receive Bad Tag Packets counter.
This counter will increment if MACsec is enabled on interface and
incoming packet has incorrect MACsec tag.
    """
    return self.__rx_badtag_pkts
      
  def _set_rx_badtag_pkts(self, v, load=False):
    """
    Setter method for rx_badtag_pkts, mapped from YANG variable /macsec/interfaces/interface/state/counters/rx_badtag_pkts (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_rx_badtag_pkts is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_rx_badtag_pkts() directly.

    YANG Description: MACsec interface level Receive Bad Tag Packets counter.
This counter will increment if MACsec is enabled on interface and
incoming packet has incorrect MACsec tag.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="rx-badtag-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """rx_badtag_pkts must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="rx-badtag-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__rx_badtag_pkts = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_rx_badtag_pkts(self):
    self.__rx_badtag_pkts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="rx-badtag-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='oc-yang:counter64', is_config=False)


  def _get_rx_unknownsci_pkts(self):
    """
    Getter method for rx_unknownsci_pkts, mapped from YANG variable /macsec/interfaces/interface/state/counters/rx_unknownsci_pkts (oc-yang:counter64)

    YANG Description: MACsec interface level Receive Unknown SCI Packets counter.
This counter will increment if MACsec is enabled on the interface and
SCI present in the MACsec tag of the incoming packet does not match any
SCI present in ingress SCI table.
    """
    return self.__rx_unknownsci_pkts
      
  def _set_rx_unknownsci_pkts(self, v, load=False):
    """
    Setter method for rx_unknownsci_pkts, mapped from YANG variable /macsec/interfaces/interface/state/counters/rx_unknownsci_pkts (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_rx_unknownsci_pkts is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_rx_unknownsci_pkts() directly.

    YANG Description: MACsec interface level Receive Unknown SCI Packets counter.
This counter will increment if MACsec is enabled on the interface and
SCI present in the MACsec tag of the incoming packet does not match any
SCI present in ingress SCI table.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="rx-unknownsci-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """rx_unknownsci_pkts must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="rx-unknownsci-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__rx_unknownsci_pkts = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_rx_unknownsci_pkts(self):
    self.__rx_unknownsci_pkts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="rx-unknownsci-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='oc-yang:counter64', is_config=False)


  def _get_rx_nosci_pkts(self):
    """
    Getter method for rx_nosci_pkts, mapped from YANG variable /macsec/interfaces/interface/state/counters/rx_nosci_pkts (oc-yang:counter64)

    YANG Description: MACsec interface level Receive No SCI Packets counter.
This counter will increment if MACsec is enabled on interface and
incoming packet does not have SCI field in MACsec tag.
    """
    return self.__rx_nosci_pkts
      
  def _set_rx_nosci_pkts(self, v, load=False):
    """
    Setter method for rx_nosci_pkts, mapped from YANG variable /macsec/interfaces/interface/state/counters/rx_nosci_pkts (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_rx_nosci_pkts is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_rx_nosci_pkts() directly.

    YANG Description: MACsec interface level Receive No SCI Packets counter.
This counter will increment if MACsec is enabled on interface and
incoming packet does not have SCI field in MACsec tag.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="rx-nosci-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """rx_nosci_pkts must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="rx-nosci-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__rx_nosci_pkts = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_rx_nosci_pkts(self):
    self.__rx_nosci_pkts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="rx-nosci-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='oc-yang:counter64', is_config=False)


  def _get_rx_late_pkts(self):
    """
    Getter method for rx_late_pkts, mapped from YANG variable /macsec/interfaces/interface/state/counters/rx_late_pkts (oc-yang:counter64)

    YANG Description: MACsec interface level Receive Late Packets counter.
This counter will increment if MACsec is enabled on the interface and
packet number of incoming packet is less than the lowest acceptable
packet number and replay protection is enabled.
    """
    return self.__rx_late_pkts
      
  def _set_rx_late_pkts(self, v, load=False):
    """
    Setter method for rx_late_pkts, mapped from YANG variable /macsec/interfaces/interface/state/counters/rx_late_pkts (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_rx_late_pkts is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_rx_late_pkts() directly.

    YANG Description: MACsec interface level Receive Late Packets counter.
This counter will increment if MACsec is enabled on the interface and
packet number of incoming packet is less than the lowest acceptable
packet number and replay protection is enabled.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="rx-late-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """rx_late_pkts must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="rx-late-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__rx_late_pkts = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_rx_late_pkts(self):
    self.__rx_late_pkts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="rx-late-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='oc-yang:counter64', is_config=False)

  tx_untagged_pkts = __builtin__.property(_get_tx_untagged_pkts)
  rx_untagged_pkts = __builtin__.property(_get_rx_untagged_pkts)
  rx_badtag_pkts = __builtin__.property(_get_rx_badtag_pkts)
  rx_unknownsci_pkts = __builtin__.property(_get_rx_unknownsci_pkts)
  rx_nosci_pkts = __builtin__.property(_get_rx_nosci_pkts)
  rx_late_pkts = __builtin__.property(_get_rx_late_pkts)


  _pyangbind_elements = OrderedDict([('tx_untagged_pkts', tx_untagged_pkts), ('rx_untagged_pkts', rx_untagged_pkts), ('rx_badtag_pkts', rx_badtag_pkts), ('rx_unknownsci_pkts', rx_unknownsci_pkts), ('rx_nosci_pkts', rx_nosci_pkts), ('rx_late_pkts', rx_late_pkts), ])


class yc_state_openconfig_macsec__macsec_interfaces_interface_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-macsec - based on the path /macsec/interfaces/interface/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational state data 
  """
  __slots__ = ('_path_helper', '_extmethods', '__name','__enable','__replay_protection','__counters',)

  _yang_name = 'state'
  _yang_namespace = 'http://openconfig.net/yang/macsec'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='oc-if:base-interface-ref', is_config=False)
    self.__enable = YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="enable", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='boolean', is_config=False)
    self.__replay_protection = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16)(0), is_leaf=True, yang_name="replay-protection", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='uint16', is_config=False)
    self.__counters = YANGDynClass(base=yc_counters_openconfig_macsec__macsec_interfaces_interface_state_counters, is_container='container', yang_name="counters", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='container', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['macsec', 'interfaces', 'interface', 'state']

  def _get_name(self):
    """
    Getter method for name, mapped from YANG variable /macsec/interfaces/interface/state/name (oc-if:base-interface-ref)

    YANG Description: Reference to the MACsec Ethernet interface
    """
    return self.__name
      
  def _set_name(self, v, load=False):
    """
    Setter method for name, mapped from YANG variable /macsec/interfaces/interface/state/name (oc-if:base-interface-ref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_name() directly.

    YANG Description: Reference to the MACsec Ethernet interface
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='oc-if:base-interface-ref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """name must be of a type compatible with oc-if:base-interface-ref""",
          'defined-type': "oc-if:base-interface-ref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='oc-if:base-interface-ref', is_config=False)""",
        })

    self.__name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_name(self):
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='oc-if:base-interface-ref', is_config=False)


  def _get_enable(self):
    """
    Getter method for enable, mapped from YANG variable /macsec/interfaces/interface/state/enable (boolean)

    YANG Description: Enable MACsec on an interface
    """
    return self.__enable
      
  def _set_enable(self, v, load=False):
    """
    Setter method for enable, mapped from YANG variable /macsec/interfaces/interface/state/enable (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_enable is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_enable() directly.

    YANG Description: Enable MACsec on an interface
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="enable", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='boolean', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """enable must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="enable", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='boolean', is_config=False)""",
        })

    self.__enable = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_enable(self):
    self.__enable = YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="enable", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='boolean', is_config=False)


  def _get_replay_protection(self):
    """
    Getter method for replay_protection, mapped from YANG variable /macsec/interfaces/interface/state/replay_protection (uint16)

    YANG Description: MACsec window size, as defined by the number of out-of-order frames
that are accepted. A value of 0 means that frames are accepted only in
the correct order.
    """
    return self.__replay_protection
      
  def _set_replay_protection(self, v, load=False):
    """
    Setter method for replay_protection, mapped from YANG variable /macsec/interfaces/interface/state/replay_protection (uint16)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_replay_protection is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_replay_protection() directly.

    YANG Description: MACsec window size, as defined by the number of out-of-order frames
that are accepted. A value of 0 means that frames are accepted only in
the correct order.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16)(0), is_leaf=True, yang_name="replay-protection", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='uint16', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """replay_protection must be of a type compatible with uint16""",
          'defined-type': "uint16",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16)(0), is_leaf=True, yang_name="replay-protection", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='uint16', is_config=False)""",
        })

    self.__replay_protection = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_replay_protection(self):
    self.__replay_protection = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16)(0), is_leaf=True, yang_name="replay-protection", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='uint16', is_config=False)


  def _get_counters(self):
    """
    Getter method for counters, mapped from YANG variable /macsec/interfaces/interface/state/counters (container)

    YANG Description: MACsec interface counters
    """
    return self.__counters
      
  def _set_counters(self, v, load=False):
    """
    Setter method for counters, mapped from YANG variable /macsec/interfaces/interface/state/counters (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_counters is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_counters() directly.

    YANG Description: MACsec interface counters
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_counters_openconfig_macsec__macsec_interfaces_interface_state_counters, is_container='container', yang_name="counters", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """counters must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_counters_openconfig_macsec__macsec_interfaces_interface_state_counters, is_container='container', yang_name="counters", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='container', is_config=False)""",
        })

    self.__counters = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_counters(self):
    self.__counters = YANGDynClass(base=yc_counters_openconfig_macsec__macsec_interfaces_interface_state_counters, is_container='container', yang_name="counters", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='container', is_config=False)

  name = __builtin__.property(_get_name)
  enable = __builtin__.property(_get_enable)
  replay_protection = __builtin__.property(_get_replay_protection)
  counters = __builtin__.property(_get_counters)


  _pyangbind_elements = OrderedDict([('name', name), ('enable', enable), ('replay_protection', replay_protection), ('counters', counters), ])


class yc_counters_openconfig_macsec__macsec_interfaces_interface_scsa_tx_scsa_tx_state_counters(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-macsec - based on the path /macsec/interfaces/interface/scsa-tx/scsa-tx/state/counters. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Counters container for macsec-scsa-tx-interface-stats
  """
  __slots__ = ('_path_helper', '_extmethods', '__sc_auth_only','__sc_encrypted','__sa_auth_only','__sa_encrypted',)

  _yang_name = 'counters'
  _yang_namespace = 'http://openconfig.net/yang/macsec'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__sc_auth_only = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="sc-auth-only", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='oc-yang:counter64', is_config=False)
    self.__sc_encrypted = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="sc-encrypted", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='oc-yang:counter64', is_config=False)
    self.__sa_auth_only = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="sa-auth-only", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='oc-yang:counter64', is_config=False)
    self.__sa_encrypted = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="sa-encrypted", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='oc-yang:counter64', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['macsec', 'interfaces', 'interface', 'scsa-tx', 'scsa-tx', 'state', 'counters']

  def _get_sc_auth_only(self):
    """
    Getter method for sc_auth_only, mapped from YANG variable /macsec/interfaces/interface/scsa_tx/scsa_tx/state/counters/sc_auth_only (oc-yang:counter64)

    YANG Description: Secure Channel Authenticated only TX Packets counter.
This counter reflects the number of authenticated only transmitted
packets in a secure channel.
    """
    return self.__sc_auth_only
      
  def _set_sc_auth_only(self, v, load=False):
    """
    Setter method for sc_auth_only, mapped from YANG variable /macsec/interfaces/interface/scsa_tx/scsa_tx/state/counters/sc_auth_only (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_sc_auth_only is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_sc_auth_only() directly.

    YANG Description: Secure Channel Authenticated only TX Packets counter.
This counter reflects the number of authenticated only transmitted
packets in a secure channel.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="sc-auth-only", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """sc_auth_only must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="sc-auth-only", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__sc_auth_only = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_sc_auth_only(self):
    self.__sc_auth_only = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="sc-auth-only", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='oc-yang:counter64', is_config=False)


  def _get_sc_encrypted(self):
    """
    Getter method for sc_encrypted, mapped from YANG variable /macsec/interfaces/interface/scsa_tx/scsa_tx/state/counters/sc_encrypted (oc-yang:counter64)

    YANG Description: Secure Channel Encrypted TX Packets counter.
This counter reflects the number of encrypted and authenticated
transmitted packets in a secure channel.
    """
    return self.__sc_encrypted
      
  def _set_sc_encrypted(self, v, load=False):
    """
    Setter method for sc_encrypted, mapped from YANG variable /macsec/interfaces/interface/scsa_tx/scsa_tx/state/counters/sc_encrypted (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_sc_encrypted is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_sc_encrypted() directly.

    YANG Description: Secure Channel Encrypted TX Packets counter.
This counter reflects the number of encrypted and authenticated
transmitted packets in a secure channel.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="sc-encrypted", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """sc_encrypted must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="sc-encrypted", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__sc_encrypted = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_sc_encrypted(self):
    self.__sc_encrypted = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="sc-encrypted", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='oc-yang:counter64', is_config=False)


  def _get_sa_auth_only(self):
    """
    Getter method for sa_auth_only, mapped from YANG variable /macsec/interfaces/interface/scsa_tx/scsa_tx/state/counters/sa_auth_only (oc-yang:counter64)

    YANG Description: Secure Association Authenticated only TX Packets counter.
This counter reflects the number of authenticated only, transmitted
packets in a secure association.
    """
    return self.__sa_auth_only
      
  def _set_sa_auth_only(self, v, load=False):
    """
    Setter method for sa_auth_only, mapped from YANG variable /macsec/interfaces/interface/scsa_tx/scsa_tx/state/counters/sa_auth_only (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_sa_auth_only is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_sa_auth_only() directly.

    YANG Description: Secure Association Authenticated only TX Packets counter.
This counter reflects the number of authenticated only, transmitted
packets in a secure association.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="sa-auth-only", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """sa_auth_only must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="sa-auth-only", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__sa_auth_only = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_sa_auth_only(self):
    self.__sa_auth_only = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="sa-auth-only", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='oc-yang:counter64', is_config=False)


  def _get_sa_encrypted(self):
    """
    Getter method for sa_encrypted, mapped from YANG variable /macsec/interfaces/interface/scsa_tx/scsa_tx/state/counters/sa_encrypted (oc-yang:counter64)

    YANG Description: Secure Association Encrypted TX Packets counter.
This counter reflects the number of encrypted and authenticated
transmitted packets in a secure association.
    """
    return self.__sa_encrypted
      
  def _set_sa_encrypted(self, v, load=False):
    """
    Setter method for sa_encrypted, mapped from YANG variable /macsec/interfaces/interface/scsa_tx/scsa_tx/state/counters/sa_encrypted (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_sa_encrypted is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_sa_encrypted() directly.

    YANG Description: Secure Association Encrypted TX Packets counter.
This counter reflects the number of encrypted and authenticated
transmitted packets in a secure association.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="sa-encrypted", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """sa_encrypted must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="sa-encrypted", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__sa_encrypted = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_sa_encrypted(self):
    self.__sa_encrypted = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="sa-encrypted", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='oc-yang:counter64', is_config=False)

  sc_auth_only = __builtin__.property(_get_sc_auth_only)
  sc_encrypted = __builtin__.property(_get_sc_encrypted)
  sa_auth_only = __builtin__.property(_get_sa_auth_only)
  sa_encrypted = __builtin__.property(_get_sa_encrypted)


  _pyangbind_elements = OrderedDict([('sc_auth_only', sc_auth_only), ('sc_encrypted', sc_encrypted), ('sa_auth_only', sa_auth_only), ('sa_encrypted', sa_encrypted), ])


class yc_state_openconfig_macsec__macsec_interfaces_interface_scsa_tx_scsa_tx_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-macsec - based on the path /macsec/interfaces/interface/scsa-tx/scsa-tx/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: State container for macsec-scsa-tx-interface-stats
  """
  __slots__ = ('_path_helper', '_extmethods', '__sci_tx','__counters',)

  _yang_name = 'state'
  _yang_namespace = 'http://openconfig.net/yang/macsec'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__sci_tx = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]*'}), restriction_dict={'length': ['16']}), is_leaf=True, yang_name="sci-tx", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='oc-yang:hex-string', is_config=False)
    self.__counters = YANGDynClass(base=yc_counters_openconfig_macsec__macsec_interfaces_interface_scsa_tx_scsa_tx_state_counters, is_container='container', yang_name="counters", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='container', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['macsec', 'interfaces', 'interface', 'scsa-tx', 'scsa-tx', 'state']

  def _get_sci_tx(self):
    """
    Getter method for sci_tx, mapped from YANG variable /macsec/interfaces/interface/scsa_tx/scsa_tx/state/sci_tx (oc-yang:hex-string)

    YANG Description: Secure Channel Identifier.
Every Transmit Channel is uniquely identified using this field.
    """
    return self.__sci_tx
      
  def _set_sci_tx(self, v, load=False):
    """
    Setter method for sci_tx, mapped from YANG variable /macsec/interfaces/interface/scsa_tx/scsa_tx/state/sci_tx (oc-yang:hex-string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_sci_tx is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_sci_tx() directly.

    YANG Description: Secure Channel Identifier.
Every Transmit Channel is uniquely identified using this field.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]*'}), restriction_dict={'length': ['16']}), is_leaf=True, yang_name="sci-tx", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='oc-yang:hex-string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """sci_tx must be of a type compatible with oc-yang:hex-string""",
          'defined-type': "oc-yang:hex-string",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]*'}), restriction_dict={'length': ['16']}), is_leaf=True, yang_name="sci-tx", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='oc-yang:hex-string', is_config=False)""",
        })

    self.__sci_tx = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_sci_tx(self):
    self.__sci_tx = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]*'}), restriction_dict={'length': ['16']}), is_leaf=True, yang_name="sci-tx", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='oc-yang:hex-string', is_config=False)


  def _get_counters(self):
    """
    Getter method for counters, mapped from YANG variable /macsec/interfaces/interface/scsa_tx/scsa_tx/state/counters (container)

    YANG Description: Counters container for macsec-scsa-tx-interface-stats
    """
    return self.__counters
      
  def _set_counters(self, v, load=False):
    """
    Setter method for counters, mapped from YANG variable /macsec/interfaces/interface/scsa_tx/scsa_tx/state/counters (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_counters is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_counters() directly.

    YANG Description: Counters container for macsec-scsa-tx-interface-stats
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_counters_openconfig_macsec__macsec_interfaces_interface_scsa_tx_scsa_tx_state_counters, is_container='container', yang_name="counters", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """counters must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_counters_openconfig_macsec__macsec_interfaces_interface_scsa_tx_scsa_tx_state_counters, is_container='container', yang_name="counters", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='container', is_config=False)""",
        })

    self.__counters = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_counters(self):
    self.__counters = YANGDynClass(base=yc_counters_openconfig_macsec__macsec_interfaces_interface_scsa_tx_scsa_tx_state_counters, is_container='container', yang_name="counters", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='container', is_config=False)

  sci_tx = __builtin__.property(_get_sci_tx)
  counters = __builtin__.property(_get_counters)


  _pyangbind_elements = OrderedDict([('sci_tx', sci_tx), ('counters', counters), ])


class yc_scsa_tx_openconfig_macsec__macsec_interfaces_interface_scsa_tx_scsa_tx(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-macsec - based on the path /macsec/interfaces/interface/scsa-tx/scsa-tx. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: TX Secure Channel and Secure Association Statistics
  """
  __slots__ = ('_path_helper', '_extmethods', '__sci_tx','__state',)

  _yang_name = 'scsa-tx'
  _yang_namespace = 'http://openconfig.net/yang/macsec'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__sci_tx = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="sci-tx", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='leafref', is_config=False)
    self.__state = YANGDynClass(base=yc_state_openconfig_macsec__macsec_interfaces_interface_scsa_tx_scsa_tx_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='container', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['macsec', 'interfaces', 'interface', 'scsa-tx', 'scsa-tx']

  def _get_sci_tx(self):
    """
    Getter method for sci_tx, mapped from YANG variable /macsec/interfaces/interface/scsa_tx/scsa_tx/sci_tx (leafref)

    YANG Description: TX Secure Channel and Secure Association Statistics
    """
    return self.__sci_tx
      
  def _set_sci_tx(self, v, load=False):
    """
    Setter method for sci_tx, mapped from YANG variable /macsec/interfaces/interface/scsa_tx/scsa_tx/sci_tx (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_sci_tx is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_sci_tx() directly.

    YANG Description: TX Secure Channel and Secure Association Statistics
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="sci-tx", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='leafref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """sci_tx must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="sci-tx", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='leafref', is_config=False)""",
        })

    self.__sci_tx = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_sci_tx(self):
    self.__sci_tx = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="sci-tx", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='leafref', is_config=False)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /macsec/interfaces/interface/scsa_tx/scsa_tx/state (container)

    YANG Description: State container for macsec-scsa-tx-interface-stats
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /macsec/interfaces/interface/scsa_tx/scsa_tx/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: State container for macsec-scsa-tx-interface-stats
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_macsec__macsec_interfaces_interface_scsa_tx_scsa_tx_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_macsec__macsec_interfaces_interface_scsa_tx_scsa_tx_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='container', is_config=False)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_macsec__macsec_interfaces_interface_scsa_tx_scsa_tx_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='container', is_config=False)

  sci_tx = __builtin__.property(_get_sci_tx)
  state = __builtin__.property(_get_state)


  _pyangbind_elements = OrderedDict([('sci_tx', sci_tx), ('state', state), ])


class yc_scsa_tx_openconfig_macsec__macsec_interfaces_interface_scsa_tx(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-macsec - based on the path /macsec/interfaces/interface/scsa-tx. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Enclosing container for transmitted packets for Secure Channel and
Secure Association
  """
  __slots__ = ('_path_helper', '_extmethods', '__scsa_tx',)

  _yang_name = 'scsa-tx'
  _yang_namespace = 'http://openconfig.net/yang/macsec'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__scsa_tx = YANGDynClass(base=YANGListType("sci_tx",yc_scsa_tx_openconfig_macsec__macsec_interfaces_interface_scsa_tx_scsa_tx, yang_name="scsa-tx", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='sci-tx', extensions=None), is_container='list', yang_name="scsa-tx", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='list', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['macsec', 'interfaces', 'interface', 'scsa-tx']

  def _get_scsa_tx(self):
    """
    Getter method for scsa_tx, mapped from YANG variable /macsec/interfaces/interface/scsa_tx/scsa_tx (list)

    YANG Description: TX Secure Channel and Secure Association Statistics
    """
    return self.__scsa_tx
      
  def _set_scsa_tx(self, v, load=False):
    """
    Setter method for scsa_tx, mapped from YANG variable /macsec/interfaces/interface/scsa_tx/scsa_tx (list)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_scsa_tx is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_scsa_tx() directly.

    YANG Description: TX Secure Channel and Secure Association Statistics
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGListType("sci_tx",yc_scsa_tx_openconfig_macsec__macsec_interfaces_interface_scsa_tx_scsa_tx, yang_name="scsa-tx", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='sci-tx', extensions=None), is_container='list', yang_name="scsa-tx", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='list', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """scsa_tx must be of a type compatible with list""",
          'defined-type': "list",
          'generated-type': """YANGDynClass(base=YANGListType("sci_tx",yc_scsa_tx_openconfig_macsec__macsec_interfaces_interface_scsa_tx_scsa_tx, yang_name="scsa-tx", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='sci-tx', extensions=None), is_container='list', yang_name="scsa-tx", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='list', is_config=False)""",
        })

    self.__scsa_tx = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_scsa_tx(self):
    self.__scsa_tx = YANGDynClass(base=YANGListType("sci_tx",yc_scsa_tx_openconfig_macsec__macsec_interfaces_interface_scsa_tx_scsa_tx, yang_name="scsa-tx", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='sci-tx', extensions=None), is_container='list', yang_name="scsa-tx", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='list', is_config=False)

  scsa_tx = __builtin__.property(_get_scsa_tx)


  _pyangbind_elements = OrderedDict([('scsa_tx', scsa_tx), ])


class yc_counters_openconfig_macsec__macsec_interfaces_interface_scsa_rx_scsa_rx_state_counters(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-macsec - based on the path /macsec/interfaces/interface/scsa-rx/scsa-rx/state/counters. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Counters container for macsec-scsa-rx-interface-stats
  """
  __slots__ = ('_path_helper', '_extmethods', '__sc_invalid','__sc_valid','__sa_invalid','__sa_valid',)

  _yang_name = 'counters'
  _yang_namespace = 'http://openconfig.net/yang/macsec'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__sc_invalid = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="sc-invalid", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='oc-yang:counter64', is_config=False)
    self.__sc_valid = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="sc-valid", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='oc-yang:counter64', is_config=False)
    self.__sa_invalid = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="sa-invalid", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='oc-yang:counter64', is_config=False)
    self.__sa_valid = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="sa-valid", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='oc-yang:counter64', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['macsec', 'interfaces', 'interface', 'scsa-rx', 'scsa-rx', 'state', 'counters']

  def _get_sc_invalid(self):
    """
    Getter method for sc_invalid, mapped from YANG variable /macsec/interfaces/interface/scsa_rx/scsa_rx/state/counters/sc_invalid (oc-yang:counter64)

    YANG Description: Invalid Secure Channel RX Packets counter.
This counter reflects the number of invalid received packets in a
secure channel.
    """
    return self.__sc_invalid
      
  def _set_sc_invalid(self, v, load=False):
    """
    Setter method for sc_invalid, mapped from YANG variable /macsec/interfaces/interface/scsa_rx/scsa_rx/state/counters/sc_invalid (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_sc_invalid is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_sc_invalid() directly.

    YANG Description: Invalid Secure Channel RX Packets counter.
This counter reflects the number of invalid received packets in a
secure channel.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="sc-invalid", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """sc_invalid must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="sc-invalid", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__sc_invalid = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_sc_invalid(self):
    self.__sc_invalid = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="sc-invalid", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='oc-yang:counter64', is_config=False)


  def _get_sc_valid(self):
    """
    Getter method for sc_valid, mapped from YANG variable /macsec/interfaces/interface/scsa_rx/scsa_rx/state/counters/sc_valid (oc-yang:counter64)

    YANG Description: Valid Secure Channel RX Packets counter.
This counter reflects the number of valid received packets in a
secure channel.
    """
    return self.__sc_valid
      
  def _set_sc_valid(self, v, load=False):
    """
    Setter method for sc_valid, mapped from YANG variable /macsec/interfaces/interface/scsa_rx/scsa_rx/state/counters/sc_valid (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_sc_valid is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_sc_valid() directly.

    YANG Description: Valid Secure Channel RX Packets counter.
This counter reflects the number of valid received packets in a
secure channel.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="sc-valid", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """sc_valid must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="sc-valid", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__sc_valid = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_sc_valid(self):
    self.__sc_valid = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="sc-valid", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='oc-yang:counter64', is_config=False)


  def _get_sa_invalid(self):
    """
    Getter method for sa_invalid, mapped from YANG variable /macsec/interfaces/interface/scsa_rx/scsa_rx/state/counters/sa_invalid (oc-yang:counter64)

    YANG Description: Invalid Secure Association RX Packets counter.
This counter reflects the number of integrity check fails for received
packets in a secure association.
    """
    return self.__sa_invalid
      
  def _set_sa_invalid(self, v, load=False):
    """
    Setter method for sa_invalid, mapped from YANG variable /macsec/interfaces/interface/scsa_rx/scsa_rx/state/counters/sa_invalid (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_sa_invalid is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_sa_invalid() directly.

    YANG Description: Invalid Secure Association RX Packets counter.
This counter reflects the number of integrity check fails for received
packets in a secure association.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="sa-invalid", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """sa_invalid must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="sa-invalid", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__sa_invalid = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_sa_invalid(self):
    self.__sa_invalid = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="sa-invalid", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='oc-yang:counter64', is_config=False)


  def _get_sa_valid(self):
    """
    Getter method for sa_valid, mapped from YANG variable /macsec/interfaces/interface/scsa_rx/scsa_rx/state/counters/sa_valid (oc-yang:counter64)

    YANG Description: Secure Association Valid RX Packets counter.
This counter reflects the number of packets in a secure association
that passed integrity check.
    """
    return self.__sa_valid
      
  def _set_sa_valid(self, v, load=False):
    """
    Setter method for sa_valid, mapped from YANG variable /macsec/interfaces/interface/scsa_rx/scsa_rx/state/counters/sa_valid (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_sa_valid is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_sa_valid() directly.

    YANG Description: Secure Association Valid RX Packets counter.
This counter reflects the number of packets in a secure association
that passed integrity check.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="sa-valid", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """sa_valid must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="sa-valid", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__sa_valid = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_sa_valid(self):
    self.__sa_valid = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="sa-valid", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='oc-yang:counter64', is_config=False)

  sc_invalid = __builtin__.property(_get_sc_invalid)
  sc_valid = __builtin__.property(_get_sc_valid)
  sa_invalid = __builtin__.property(_get_sa_invalid)
  sa_valid = __builtin__.property(_get_sa_valid)


  _pyangbind_elements = OrderedDict([('sc_invalid', sc_invalid), ('sc_valid', sc_valid), ('sa_invalid', sa_invalid), ('sa_valid', sa_valid), ])


class yc_state_openconfig_macsec__macsec_interfaces_interface_scsa_rx_scsa_rx_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-macsec - based on the path /macsec/interfaces/interface/scsa-rx/scsa-rx/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: State container for macsec-scsa-rx-interface-stats
  """
  __slots__ = ('_path_helper', '_extmethods', '__sci_rx','__counters',)

  _yang_name = 'state'
  _yang_namespace = 'http://openconfig.net/yang/macsec'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__sci_rx = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]*'}), restriction_dict={'length': ['16']}), is_leaf=True, yang_name="sci-rx", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='oc-yang:hex-string', is_config=False)
    self.__counters = YANGDynClass(base=yc_counters_openconfig_macsec__macsec_interfaces_interface_scsa_rx_scsa_rx_state_counters, is_container='container', yang_name="counters", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='container', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['macsec', 'interfaces', 'interface', 'scsa-rx', 'scsa-rx', 'state']

  def _get_sci_rx(self):
    """
    Getter method for sci_rx, mapped from YANG variable /macsec/interfaces/interface/scsa_rx/scsa_rx/state/sci_rx (oc-yang:hex-string)

    YANG Description: Secure Channel Identifier.
Every Receive Channel is uniquely identified using this field.
    """
    return self.__sci_rx
      
  def _set_sci_rx(self, v, load=False):
    """
    Setter method for sci_rx, mapped from YANG variable /macsec/interfaces/interface/scsa_rx/scsa_rx/state/sci_rx (oc-yang:hex-string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_sci_rx is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_sci_rx() directly.

    YANG Description: Secure Channel Identifier.
Every Receive Channel is uniquely identified using this field.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]*'}), restriction_dict={'length': ['16']}), is_leaf=True, yang_name="sci-rx", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='oc-yang:hex-string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """sci_rx must be of a type compatible with oc-yang:hex-string""",
          'defined-type': "oc-yang:hex-string",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]*'}), restriction_dict={'length': ['16']}), is_leaf=True, yang_name="sci-rx", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='oc-yang:hex-string', is_config=False)""",
        })

    self.__sci_rx = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_sci_rx(self):
    self.__sci_rx = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]*'}), restriction_dict={'length': ['16']}), is_leaf=True, yang_name="sci-rx", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='oc-yang:hex-string', is_config=False)


  def _get_counters(self):
    """
    Getter method for counters, mapped from YANG variable /macsec/interfaces/interface/scsa_rx/scsa_rx/state/counters (container)

    YANG Description: Counters container for macsec-scsa-rx-interface-stats
    """
    return self.__counters
      
  def _set_counters(self, v, load=False):
    """
    Setter method for counters, mapped from YANG variable /macsec/interfaces/interface/scsa_rx/scsa_rx/state/counters (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_counters is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_counters() directly.

    YANG Description: Counters container for macsec-scsa-rx-interface-stats
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_counters_openconfig_macsec__macsec_interfaces_interface_scsa_rx_scsa_rx_state_counters, is_container='container', yang_name="counters", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """counters must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_counters_openconfig_macsec__macsec_interfaces_interface_scsa_rx_scsa_rx_state_counters, is_container='container', yang_name="counters", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='container', is_config=False)""",
        })

    self.__counters = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_counters(self):
    self.__counters = YANGDynClass(base=yc_counters_openconfig_macsec__macsec_interfaces_interface_scsa_rx_scsa_rx_state_counters, is_container='container', yang_name="counters", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='container', is_config=False)

  sci_rx = __builtin__.property(_get_sci_rx)
  counters = __builtin__.property(_get_counters)


  _pyangbind_elements = OrderedDict([('sci_rx', sci_rx), ('counters', counters), ])


class yc_scsa_rx_openconfig_macsec__macsec_interfaces_interface_scsa_rx_scsa_rx(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-macsec - based on the path /macsec/interfaces/interface/scsa-rx/scsa-rx. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: RX Secure Channel and Secure Association Statistics
  """
  __slots__ = ('_path_helper', '_extmethods', '__sci_rx','__state',)

  _yang_name = 'scsa-rx'
  _yang_namespace = 'http://openconfig.net/yang/macsec'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__sci_rx = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="sci-rx", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='leafref', is_config=False)
    self.__state = YANGDynClass(base=yc_state_openconfig_macsec__macsec_interfaces_interface_scsa_rx_scsa_rx_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='container', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['macsec', 'interfaces', 'interface', 'scsa-rx', 'scsa-rx']

  def _get_sci_rx(self):
    """
    Getter method for sci_rx, mapped from YANG variable /macsec/interfaces/interface/scsa_rx/scsa_rx/sci_rx (leafref)

    YANG Description: RX Secure Channel and Secure Association Statistics
    """
    return self.__sci_rx
      
  def _set_sci_rx(self, v, load=False):
    """
    Setter method for sci_rx, mapped from YANG variable /macsec/interfaces/interface/scsa_rx/scsa_rx/sci_rx (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_sci_rx is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_sci_rx() directly.

    YANG Description: RX Secure Channel and Secure Association Statistics
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="sci-rx", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='leafref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """sci_rx must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="sci-rx", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='leafref', is_config=False)""",
        })

    self.__sci_rx = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_sci_rx(self):
    self.__sci_rx = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="sci-rx", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='leafref', is_config=False)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /macsec/interfaces/interface/scsa_rx/scsa_rx/state (container)

    YANG Description: State container for macsec-scsa-rx-interface-stats
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /macsec/interfaces/interface/scsa_rx/scsa_rx/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: State container for macsec-scsa-rx-interface-stats
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_macsec__macsec_interfaces_interface_scsa_rx_scsa_rx_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_macsec__macsec_interfaces_interface_scsa_rx_scsa_rx_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='container', is_config=False)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_macsec__macsec_interfaces_interface_scsa_rx_scsa_rx_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='container', is_config=False)

  sci_rx = __builtin__.property(_get_sci_rx)
  state = __builtin__.property(_get_state)


  _pyangbind_elements = OrderedDict([('sci_rx', sci_rx), ('state', state), ])


class yc_scsa_rx_openconfig_macsec__macsec_interfaces_interface_scsa_rx(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-macsec - based on the path /macsec/interfaces/interface/scsa-rx. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Enclosing container for received packets for Secure Channel and
Secure Association
  """
  __slots__ = ('_path_helper', '_extmethods', '__scsa_rx',)

  _yang_name = 'scsa-rx'
  _yang_namespace = 'http://openconfig.net/yang/macsec'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__scsa_rx = YANGDynClass(base=YANGListType("sci_rx",yc_scsa_rx_openconfig_macsec__macsec_interfaces_interface_scsa_rx_scsa_rx, yang_name="scsa-rx", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='sci-rx', extensions=None), is_container='list', yang_name="scsa-rx", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='list', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['macsec', 'interfaces', 'interface', 'scsa-rx']

  def _get_scsa_rx(self):
    """
    Getter method for scsa_rx, mapped from YANG variable /macsec/interfaces/interface/scsa_rx/scsa_rx (list)

    YANG Description: RX Secure Channel and Secure Association Statistics
    """
    return self.__scsa_rx
      
  def _set_scsa_rx(self, v, load=False):
    """
    Setter method for scsa_rx, mapped from YANG variable /macsec/interfaces/interface/scsa_rx/scsa_rx (list)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_scsa_rx is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_scsa_rx() directly.

    YANG Description: RX Secure Channel and Secure Association Statistics
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGListType("sci_rx",yc_scsa_rx_openconfig_macsec__macsec_interfaces_interface_scsa_rx_scsa_rx, yang_name="scsa-rx", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='sci-rx', extensions=None), is_container='list', yang_name="scsa-rx", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='list', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """scsa_rx must be of a type compatible with list""",
          'defined-type': "list",
          'generated-type': """YANGDynClass(base=YANGListType("sci_rx",yc_scsa_rx_openconfig_macsec__macsec_interfaces_interface_scsa_rx_scsa_rx, yang_name="scsa-rx", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='sci-rx', extensions=None), is_container='list', yang_name="scsa-rx", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='list', is_config=False)""",
        })

    self.__scsa_rx = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_scsa_rx(self):
    self.__scsa_rx = YANGDynClass(base=YANGListType("sci_rx",yc_scsa_rx_openconfig_macsec__macsec_interfaces_interface_scsa_rx_scsa_rx, yang_name="scsa-rx", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='sci-rx', extensions=None), is_container='list', yang_name="scsa-rx", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='list', is_config=False)

  scsa_rx = __builtin__.property(_get_scsa_rx)


  _pyangbind_elements = OrderedDict([('scsa_rx', scsa_rx), ])


class yc_config_openconfig_macsec__macsec_interfaces_interface_mka_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-macsec - based on the path /macsec/interfaces/interface/mka/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configuration data for MKA interface
  """
  __slots__ = ('_path_helper', '_extmethods', '__mka_policy','__key_chain',)

  _yang_name = 'config'
  _yang_namespace = 'http://openconfig.net/yang/macsec'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__mka_policy = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="mka-policy", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='leafref', is_config=True)
    self.__key_chain = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="key-chain", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='leafref', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['macsec', 'interfaces', 'interface', 'mka', 'config']

  def _get_mka_policy(self):
    """
    Getter method for mka_policy, mapped from YANG variable /macsec/interfaces/interface/mka/config/mka_policy (leafref)

    YANG Description: Apply MKA policy on the interface
    """
    return self.__mka_policy
      
  def _set_mka_policy(self, v, load=False):
    """
    Setter method for mka_policy, mapped from YANG variable /macsec/interfaces/interface/mka/config/mka_policy (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_mka_policy is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_mka_policy() directly.

    YANG Description: Apply MKA policy on the interface
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="mka-policy", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """mka_policy must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="mka-policy", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='leafref', is_config=True)""",
        })

    self.__mka_policy = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_mka_policy(self):
    self.__mka_policy = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="mka-policy", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='leafref', is_config=True)


  def _get_key_chain(self):
    """
    Getter method for key_chain, mapped from YANG variable /macsec/interfaces/interface/mka/config/key_chain (leafref)

    YANG Description: Configure Key Chain name
    """
    return self.__key_chain
      
  def _set_key_chain(self, v, load=False):
    """
    Setter method for key_chain, mapped from YANG variable /macsec/interfaces/interface/mka/config/key_chain (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_key_chain is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_key_chain() directly.

    YANG Description: Configure Key Chain name
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="key-chain", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """key_chain must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="key-chain", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='leafref', is_config=True)""",
        })

    self.__key_chain = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_key_chain(self):
    self.__key_chain = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="key-chain", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='leafref', is_config=True)

  mka_policy = __builtin__.property(_get_mka_policy, _set_mka_policy)
  key_chain = __builtin__.property(_get_key_chain, _set_key_chain)


  _pyangbind_elements = OrderedDict([('mka_policy', mka_policy), ('key_chain', key_chain), ])


class yc_counters_openconfig_macsec__macsec_interfaces_interface_mka_state_counters(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-macsec - based on the path /macsec/interfaces/interface/mka/state/counters. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: MKA interface counters
  """
  __slots__ = ('_path_helper', '_extmethods', '__in_mkpdu','__in_sak_mkpdu','__in_cak_mkpdu','__out_mkpdu','__out_sak_mkpdu','__out_cak_mkpdu',)

  _yang_name = 'counters'
  _yang_namespace = 'http://openconfig.net/yang/macsec'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__in_mkpdu = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-mkpdu", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='oc-yang:counter64', is_config=False)
    self.__in_sak_mkpdu = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-sak-mkpdu", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='oc-yang:counter64', is_config=False)
    self.__in_cak_mkpdu = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-cak-mkpdu", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='oc-yang:counter64', is_config=False)
    self.__out_mkpdu = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-mkpdu", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='oc-yang:counter64', is_config=False)
    self.__out_sak_mkpdu = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-sak-mkpdu", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='oc-yang:counter64', is_config=False)
    self.__out_cak_mkpdu = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-cak-mkpdu", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='oc-yang:counter64', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['macsec', 'interfaces', 'interface', 'mka', 'state', 'counters']

  def _get_in_mkpdu(self):
    """
    Getter method for in_mkpdu, mapped from YANG variable /macsec/interfaces/interface/mka/state/counters/in_mkpdu (oc-yang:counter64)

    YANG Description: Validated MKPDU received count
    """
    return self.__in_mkpdu
      
  def _set_in_mkpdu(self, v, load=False):
    """
    Setter method for in_mkpdu, mapped from YANG variable /macsec/interfaces/interface/mka/state/counters/in_mkpdu (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_in_mkpdu is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_in_mkpdu() directly.

    YANG Description: Validated MKPDU received count
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-mkpdu", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """in_mkpdu must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-mkpdu", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__in_mkpdu = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_in_mkpdu(self):
    self.__in_mkpdu = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-mkpdu", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='oc-yang:counter64', is_config=False)


  def _get_in_sak_mkpdu(self):
    """
    Getter method for in_sak_mkpdu, mapped from YANG variable /macsec/interfaces/interface/mka/state/counters/in_sak_mkpdu (oc-yang:counter64)

    YANG Description: Validated MKPDU received SAK count
    """
    return self.__in_sak_mkpdu
      
  def _set_in_sak_mkpdu(self, v, load=False):
    """
    Setter method for in_sak_mkpdu, mapped from YANG variable /macsec/interfaces/interface/mka/state/counters/in_sak_mkpdu (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_in_sak_mkpdu is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_in_sak_mkpdu() directly.

    YANG Description: Validated MKPDU received SAK count
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-sak-mkpdu", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """in_sak_mkpdu must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-sak-mkpdu", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__in_sak_mkpdu = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_in_sak_mkpdu(self):
    self.__in_sak_mkpdu = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-sak-mkpdu", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='oc-yang:counter64', is_config=False)


  def _get_in_cak_mkpdu(self):
    """
    Getter method for in_cak_mkpdu, mapped from YANG variable /macsec/interfaces/interface/mka/state/counters/in_cak_mkpdu (oc-yang:counter64)

    YANG Description: Validated MKPDU received CAK count
    """
    return self.__in_cak_mkpdu
      
  def _set_in_cak_mkpdu(self, v, load=False):
    """
    Setter method for in_cak_mkpdu, mapped from YANG variable /macsec/interfaces/interface/mka/state/counters/in_cak_mkpdu (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_in_cak_mkpdu is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_in_cak_mkpdu() directly.

    YANG Description: Validated MKPDU received CAK count
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-cak-mkpdu", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """in_cak_mkpdu must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-cak-mkpdu", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__in_cak_mkpdu = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_in_cak_mkpdu(self):
    self.__in_cak_mkpdu = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-cak-mkpdu", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='oc-yang:counter64', is_config=False)


  def _get_out_mkpdu(self):
    """
    Getter method for out_mkpdu, mapped from YANG variable /macsec/interfaces/interface/mka/state/counters/out_mkpdu (oc-yang:counter64)

    YANG Description: MKPDU sent count
    """
    return self.__out_mkpdu
      
  def _set_out_mkpdu(self, v, load=False):
    """
    Setter method for out_mkpdu, mapped from YANG variable /macsec/interfaces/interface/mka/state/counters/out_mkpdu (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_out_mkpdu is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_out_mkpdu() directly.

    YANG Description: MKPDU sent count
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-mkpdu", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """out_mkpdu must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-mkpdu", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__out_mkpdu = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_out_mkpdu(self):
    self.__out_mkpdu = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-mkpdu", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='oc-yang:counter64', is_config=False)


  def _get_out_sak_mkpdu(self):
    """
    Getter method for out_sak_mkpdu, mapped from YANG variable /macsec/interfaces/interface/mka/state/counters/out_sak_mkpdu (oc-yang:counter64)

    YANG Description: MKPDU SAK sent count
    """
    return self.__out_sak_mkpdu
      
  def _set_out_sak_mkpdu(self, v, load=False):
    """
    Setter method for out_sak_mkpdu, mapped from YANG variable /macsec/interfaces/interface/mka/state/counters/out_sak_mkpdu (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_out_sak_mkpdu is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_out_sak_mkpdu() directly.

    YANG Description: MKPDU SAK sent count
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-sak-mkpdu", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """out_sak_mkpdu must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-sak-mkpdu", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__out_sak_mkpdu = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_out_sak_mkpdu(self):
    self.__out_sak_mkpdu = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-sak-mkpdu", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='oc-yang:counter64', is_config=False)


  def _get_out_cak_mkpdu(self):
    """
    Getter method for out_cak_mkpdu, mapped from YANG variable /macsec/interfaces/interface/mka/state/counters/out_cak_mkpdu (oc-yang:counter64)

    YANG Description: MKPDU CAK sent count
    """
    return self.__out_cak_mkpdu
      
  def _set_out_cak_mkpdu(self, v, load=False):
    """
    Setter method for out_cak_mkpdu, mapped from YANG variable /macsec/interfaces/interface/mka/state/counters/out_cak_mkpdu (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_out_cak_mkpdu is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_out_cak_mkpdu() directly.

    YANG Description: MKPDU CAK sent count
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-cak-mkpdu", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """out_cak_mkpdu must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-cak-mkpdu", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__out_cak_mkpdu = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_out_cak_mkpdu(self):
    self.__out_cak_mkpdu = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-cak-mkpdu", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='oc-yang:counter64', is_config=False)

  in_mkpdu = __builtin__.property(_get_in_mkpdu)
  in_sak_mkpdu = __builtin__.property(_get_in_sak_mkpdu)
  in_cak_mkpdu = __builtin__.property(_get_in_cak_mkpdu)
  out_mkpdu = __builtin__.property(_get_out_mkpdu)
  out_sak_mkpdu = __builtin__.property(_get_out_sak_mkpdu)
  out_cak_mkpdu = __builtin__.property(_get_out_cak_mkpdu)


  _pyangbind_elements = OrderedDict([('in_mkpdu', in_mkpdu), ('in_sak_mkpdu', in_sak_mkpdu), ('in_cak_mkpdu', in_cak_mkpdu), ('out_mkpdu', out_mkpdu), ('out_sak_mkpdu', out_sak_mkpdu), ('out_cak_mkpdu', out_cak_mkpdu), ])


class yc_state_openconfig_macsec__macsec_interfaces_interface_mka_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-macsec - based on the path /macsec/interfaces/interface/mka/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational state data for MKA interface
  """
  __slots__ = ('_path_helper', '_extmethods', '__mka_policy','__key_chain','__counters',)

  _yang_name = 'state'
  _yang_namespace = 'http://openconfig.net/yang/macsec'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__mka_policy = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="mka-policy", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='leafref', is_config=False)
    self.__key_chain = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="key-chain", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='leafref', is_config=False)
    self.__counters = YANGDynClass(base=yc_counters_openconfig_macsec__macsec_interfaces_interface_mka_state_counters, is_container='container', yang_name="counters", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='container', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['macsec', 'interfaces', 'interface', 'mka', 'state']

  def _get_mka_policy(self):
    """
    Getter method for mka_policy, mapped from YANG variable /macsec/interfaces/interface/mka/state/mka_policy (leafref)

    YANG Description: Apply MKA policy on the interface
    """
    return self.__mka_policy
      
  def _set_mka_policy(self, v, load=False):
    """
    Setter method for mka_policy, mapped from YANG variable /macsec/interfaces/interface/mka/state/mka_policy (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_mka_policy is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_mka_policy() directly.

    YANG Description: Apply MKA policy on the interface
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="mka-policy", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='leafref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """mka_policy must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="mka-policy", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='leafref', is_config=False)""",
        })

    self.__mka_policy = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_mka_policy(self):
    self.__mka_policy = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="mka-policy", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='leafref', is_config=False)


  def _get_key_chain(self):
    """
    Getter method for key_chain, mapped from YANG variable /macsec/interfaces/interface/mka/state/key_chain (leafref)

    YANG Description: Configure Key Chain name
    """
    return self.__key_chain
      
  def _set_key_chain(self, v, load=False):
    """
    Setter method for key_chain, mapped from YANG variable /macsec/interfaces/interface/mka/state/key_chain (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_key_chain is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_key_chain() directly.

    YANG Description: Configure Key Chain name
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="key-chain", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='leafref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """key_chain must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="key-chain", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='leafref', is_config=False)""",
        })

    self.__key_chain = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_key_chain(self):
    self.__key_chain = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="key-chain", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='leafref', is_config=False)


  def _get_counters(self):
    """
    Getter method for counters, mapped from YANG variable /macsec/interfaces/interface/mka/state/counters (container)

    YANG Description: MKA interface counters
    """
    return self.__counters
      
  def _set_counters(self, v, load=False):
    """
    Setter method for counters, mapped from YANG variable /macsec/interfaces/interface/mka/state/counters (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_counters is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_counters() directly.

    YANG Description: MKA interface counters
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_counters_openconfig_macsec__macsec_interfaces_interface_mka_state_counters, is_container='container', yang_name="counters", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """counters must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_counters_openconfig_macsec__macsec_interfaces_interface_mka_state_counters, is_container='container', yang_name="counters", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='container', is_config=False)""",
        })

    self.__counters = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_counters(self):
    self.__counters = YANGDynClass(base=yc_counters_openconfig_macsec__macsec_interfaces_interface_mka_state_counters, is_container='container', yang_name="counters", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='container', is_config=False)

  mka_policy = __builtin__.property(_get_mka_policy)
  key_chain = __builtin__.property(_get_key_chain)
  counters = __builtin__.property(_get_counters)


  _pyangbind_elements = OrderedDict([('mka_policy', mka_policy), ('key_chain', key_chain), ('counters', counters), ])


class yc_mka_openconfig_macsec__macsec_interfaces_interface_mka(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-macsec - based on the path /macsec/interfaces/interface/mka. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Enclosing container for the MKA interface
  """
  __slots__ = ('_path_helper', '_extmethods', '__config','__state',)

  _yang_name = 'mka'
  _yang_namespace = 'http://openconfig.net/yang/macsec'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__config = YANGDynClass(base=yc_config_openconfig_macsec__macsec_interfaces_interface_mka_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_macsec__macsec_interfaces_interface_mka_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['macsec', 'interfaces', 'interface', 'mka']

  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /macsec/interfaces/interface/mka/config (container)

    YANG Description: Configuration data for MKA interface
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /macsec/interfaces/interface/mka/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Configuration data for MKA interface
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_macsec__macsec_interfaces_interface_mka_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_macsec__macsec_interfaces_interface_mka_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_macsec__macsec_interfaces_interface_mka_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /macsec/interfaces/interface/mka/state (container)

    YANG Description: Operational state data for MKA interface
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /macsec/interfaces/interface/mka/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: Operational state data for MKA interface
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_macsec__macsec_interfaces_interface_mka_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_macsec__macsec_interfaces_interface_mka_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_macsec__macsec_interfaces_interface_mka_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='container', is_config=True)

  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)


  _pyangbind_elements = OrderedDict([('config', config), ('state', state), ])


class yc_interface_openconfig_macsec__macsec_interfaces_interface(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-macsec - based on the path /macsec/interfaces/interface. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: List of interfaces on which MACsec is enabled / available
  """
  __slots__ = ('_path_helper', '_extmethods', '__name','__config','__state','__scsa_tx','__scsa_rx','__mka',)

  _yang_name = 'interface'
  _yang_namespace = 'http://openconfig.net/yang/macsec'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='leafref', is_config=True)
    self.__config = YANGDynClass(base=yc_config_openconfig_macsec__macsec_interfaces_interface_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_macsec__macsec_interfaces_interface_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='container', is_config=True)
    self.__scsa_tx = YANGDynClass(base=yc_scsa_tx_openconfig_macsec__macsec_interfaces_interface_scsa_tx, is_container='container', yang_name="scsa-tx", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='container', is_config=True)
    self.__scsa_rx = YANGDynClass(base=yc_scsa_rx_openconfig_macsec__macsec_interfaces_interface_scsa_rx, is_container='container', yang_name="scsa-rx", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='container', is_config=True)
    self.__mka = YANGDynClass(base=yc_mka_openconfig_macsec__macsec_interfaces_interface_mka, is_container='container', yang_name="mka", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['macsec', 'interfaces', 'interface']

  def _get_name(self):
    """
    Getter method for name, mapped from YANG variable /macsec/interfaces/interface/name (leafref)

    YANG Description: Reference to the list key
    """
    return self.__name
      
  def _set_name(self, v, load=False):
    """
    Setter method for name, mapped from YANG variable /macsec/interfaces/interface/name (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_name() directly.

    YANG Description: Reference to the list key
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """name must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='leafref', is_config=True)""",
        })

    self.__name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_name(self):
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='leafref', is_config=True)


  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /macsec/interfaces/interface/config (container)

    YANG Description: Configuration data for MACsec on each interface
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /macsec/interfaces/interface/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Configuration data for MACsec on each interface
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_macsec__macsec_interfaces_interface_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_macsec__macsec_interfaces_interface_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_macsec__macsec_interfaces_interface_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /macsec/interfaces/interface/state (container)

    YANG Description: Operational state data 
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /macsec/interfaces/interface/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: Operational state data 
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_macsec__macsec_interfaces_interface_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_macsec__macsec_interfaces_interface_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_macsec__macsec_interfaces_interface_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='container', is_config=True)


  def _get_scsa_tx(self):
    """
    Getter method for scsa_tx, mapped from YANG variable /macsec/interfaces/interface/scsa_tx (container)

    YANG Description: Enclosing container for transmitted packets for Secure Channel and
Secure Association
    """
    return self.__scsa_tx
      
  def _set_scsa_tx(self, v, load=False):
    """
    Setter method for scsa_tx, mapped from YANG variable /macsec/interfaces/interface/scsa_tx (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_scsa_tx is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_scsa_tx() directly.

    YANG Description: Enclosing container for transmitted packets for Secure Channel and
Secure Association
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_scsa_tx_openconfig_macsec__macsec_interfaces_interface_scsa_tx, is_container='container', yang_name="scsa-tx", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """scsa_tx must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_scsa_tx_openconfig_macsec__macsec_interfaces_interface_scsa_tx, is_container='container', yang_name="scsa-tx", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='container', is_config=True)""",
        })

    self.__scsa_tx = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_scsa_tx(self):
    self.__scsa_tx = YANGDynClass(base=yc_scsa_tx_openconfig_macsec__macsec_interfaces_interface_scsa_tx, is_container='container', yang_name="scsa-tx", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='container', is_config=True)


  def _get_scsa_rx(self):
    """
    Getter method for scsa_rx, mapped from YANG variable /macsec/interfaces/interface/scsa_rx (container)

    YANG Description: Enclosing container for received packets for Secure Channel and
Secure Association
    """
    return self.__scsa_rx
      
  def _set_scsa_rx(self, v, load=False):
    """
    Setter method for scsa_rx, mapped from YANG variable /macsec/interfaces/interface/scsa_rx (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_scsa_rx is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_scsa_rx() directly.

    YANG Description: Enclosing container for received packets for Secure Channel and
Secure Association
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_scsa_rx_openconfig_macsec__macsec_interfaces_interface_scsa_rx, is_container='container', yang_name="scsa-rx", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """scsa_rx must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_scsa_rx_openconfig_macsec__macsec_interfaces_interface_scsa_rx, is_container='container', yang_name="scsa-rx", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='container', is_config=True)""",
        })

    self.__scsa_rx = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_scsa_rx(self):
    self.__scsa_rx = YANGDynClass(base=yc_scsa_rx_openconfig_macsec__macsec_interfaces_interface_scsa_rx, is_container='container', yang_name="scsa-rx", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='container', is_config=True)


  def _get_mka(self):
    """
    Getter method for mka, mapped from YANG variable /macsec/interfaces/interface/mka (container)

    YANG Description: Enclosing container for the MKA interface
    """
    return self.__mka
      
  def _set_mka(self, v, load=False):
    """
    Setter method for mka, mapped from YANG variable /macsec/interfaces/interface/mka (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_mka is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_mka() directly.

    YANG Description: Enclosing container for the MKA interface
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_mka_openconfig_macsec__macsec_interfaces_interface_mka, is_container='container', yang_name="mka", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """mka must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_mka_openconfig_macsec__macsec_interfaces_interface_mka, is_container='container', yang_name="mka", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='container', is_config=True)""",
        })

    self.__mka = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_mka(self):
    self.__mka = YANGDynClass(base=yc_mka_openconfig_macsec__macsec_interfaces_interface_mka, is_container='container', yang_name="mka", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='container', is_config=True)

  name = __builtin__.property(_get_name, _set_name)
  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)
  scsa_tx = __builtin__.property(_get_scsa_tx, _set_scsa_tx)
  scsa_rx = __builtin__.property(_get_scsa_rx, _set_scsa_rx)
  mka = __builtin__.property(_get_mka, _set_mka)


  _pyangbind_elements = OrderedDict([('name', name), ('config', config), ('state', state), ('scsa_tx', scsa_tx), ('scsa_rx', scsa_rx), ('mka', mka), ])


class yc_interfaces_openconfig_macsec__macsec_interfaces(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-macsec - based on the path /macsec/interfaces. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Enclosing container for the MACsec interfaces list
  """
  __slots__ = ('_path_helper', '_extmethods', '__interface',)

  _yang_name = 'interfaces'
  _yang_namespace = 'http://openconfig.net/yang/macsec'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__interface = YANGDynClass(base=YANGListType("name",yc_interface_openconfig_macsec__macsec_interfaces_interface, yang_name="interface", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name', extensions=None), is_container='list', yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='list', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['macsec', 'interfaces']

  def _get_interface(self):
    """
    Getter method for interface, mapped from YANG variable /macsec/interfaces/interface (list)

    YANG Description: List of interfaces on which MACsec is enabled / available
    """
    return self.__interface
      
  def _set_interface(self, v, load=False):
    """
    Setter method for interface, mapped from YANG variable /macsec/interfaces/interface (list)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_interface is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_interface() directly.

    YANG Description: List of interfaces on which MACsec is enabled / available
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGListType("name",yc_interface_openconfig_macsec__macsec_interfaces_interface, yang_name="interface", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name', extensions=None), is_container='list', yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='list', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """interface must be of a type compatible with list""",
          'defined-type': "list",
          'generated-type': """YANGDynClass(base=YANGListType("name",yc_interface_openconfig_macsec__macsec_interfaces_interface, yang_name="interface", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name', extensions=None), is_container='list', yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='list', is_config=True)""",
        })

    self.__interface = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_interface(self):
    self.__interface = YANGDynClass(base=YANGListType("name",yc_interface_openconfig_macsec__macsec_interfaces_interface, yang_name="interface", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name', extensions=None), is_container='list', yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='list', is_config=True)

  interface = __builtin__.property(_get_interface, _set_interface)


  _pyangbind_elements = OrderedDict([('interface', interface), ])


class yc_macsec_openconfig_macsec__macsec(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-macsec - based on the path /macsec. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: The MACsec
  """
  __slots__ = ('_path_helper', '_extmethods', '__mka','__interfaces',)

  _yang_name = 'macsec'
  _yang_namespace = 'http://openconfig.net/yang/macsec'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__mka = YANGDynClass(base=yc_mka_openconfig_macsec__macsec_mka, is_container='container', yang_name="mka", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='container', is_config=True)
    self.__interfaces = YANGDynClass(base=yc_interfaces_openconfig_macsec__macsec_interfaces, is_container='container', yang_name="interfaces", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['macsec']

  def _get_mka(self):
    """
    Getter method for mka, mapped from YANG variable /macsec/mka (container)

    YANG Description: The MKA
    """
    return self.__mka
      
  def _set_mka(self, v, load=False):
    """
    Setter method for mka, mapped from YANG variable /macsec/mka (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_mka is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_mka() directly.

    YANG Description: The MKA
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_mka_openconfig_macsec__macsec_mka, is_container='container', yang_name="mka", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """mka must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_mka_openconfig_macsec__macsec_mka, is_container='container', yang_name="mka", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='container', is_config=True)""",
        })

    self.__mka = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_mka(self):
    self.__mka = YANGDynClass(base=yc_mka_openconfig_macsec__macsec_mka, is_container='container', yang_name="mka", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='container', is_config=True)


  def _get_interfaces(self):
    """
    Getter method for interfaces, mapped from YANG variable /macsec/interfaces (container)

    YANG Description: Enclosing container for the MACsec interfaces list
    """
    return self.__interfaces
      
  def _set_interfaces(self, v, load=False):
    """
    Setter method for interfaces, mapped from YANG variable /macsec/interfaces (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_interfaces is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_interfaces() directly.

    YANG Description: Enclosing container for the MACsec interfaces list
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_interfaces_openconfig_macsec__macsec_interfaces, is_container='container', yang_name="interfaces", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """interfaces must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_interfaces_openconfig_macsec__macsec_interfaces, is_container='container', yang_name="interfaces", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='container', is_config=True)""",
        })

    self.__interfaces = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_interfaces(self):
    self.__interfaces = YANGDynClass(base=yc_interfaces_openconfig_macsec__macsec_interfaces, is_container='container', yang_name="interfaces", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='container', is_config=True)

  mka = __builtin__.property(_get_mka, _set_mka)
  interfaces = __builtin__.property(_get_interfaces, _set_interfaces)


  _pyangbind_elements = OrderedDict([('mka', mka), ('interfaces', interfaces), ])


class openconfig_macsec(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-macsec - based on the path /openconfig-macsec. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: This module defines configuration and state data for
MACsec IEEE Std 802.1AE-2018.
  """
  __slots__ = ('_path_helper', '_extmethods', '__macsec',)

  _yang_name = 'openconfig-macsec'
  _yang_namespace = 'http://openconfig.net/yang/macsec'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__macsec = YANGDynClass(base=yc_macsec_openconfig_macsec__macsec, is_container='container', yang_name="macsec", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return []

  def _get_macsec(self):
    """
    Getter method for macsec, mapped from YANG variable /macsec (container)

    YANG Description: The MACsec
    """
    return self.__macsec
      
  def _set_macsec(self, v, load=False):
    """
    Setter method for macsec, mapped from YANG variable /macsec (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_macsec is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_macsec() directly.

    YANG Description: The MACsec
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_macsec_openconfig_macsec__macsec, is_container='container', yang_name="macsec", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """macsec must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_macsec_openconfig_macsec__macsec, is_container='container', yang_name="macsec", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='container', is_config=True)""",
        })

    self.__macsec = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_macsec(self):
    self.__macsec = YANGDynClass(base=yc_macsec_openconfig_macsec__macsec, is_container='container', yang_name="macsec", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/macsec', defining_module='openconfig-macsec', yang_type='container', is_config=True)

  macsec = __builtin__.property(_get_macsec, _set_macsec)


  _pyangbind_elements = OrderedDict([('macsec', macsec), ])


class openconfig_macsec_types(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-macsec-types - based on the path /openconfig-macsec-types. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: This module defines types related to the MACsec configuration
and operational state model.
  """
  _pyangbind_elements = {}

  

