# -*- coding: utf-8 -*-
from operator import attrgetter
from pyangbind.lib.yangtypes import RestrictedPrecisionDecimalType
from pyangbind.lib.yangtypes import RestrictedClassType
from pyangbind.lib.yangtypes import TypedListType
from pyangbind.lib.yangtypes import YANGBool
from pyangbind.lib.yangtypes import YANGListType
from pyangbind.lib.yangtypes import YANGDynClass
from pyangbind.lib.yangtypes import ReferenceType
from pyangbind.lib.base import PybindBase
from collections import OrderedDict
from decimal import Decimal
from bitarray import bitarray
import six

# PY3 support of some PY2 keywords (needs improved)
if six.PY3:
  import builtins as __builtin__
  long = int
elif six.PY2:
  import __builtin__

class yc_config_openconfig_bfd__bfd_interfaces_interface_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-bfd - based on the path /bfd/interfaces/interface/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configuration parameters for BFD on the specified
interface.
  """
  __slots__ = ('_path_helper', '_extmethods', '__id','__enabled','__local_address','__desired_minimum_tx_interval','__required_minimum_receive','__detection_multiplier','__enable_per_member_link',)

  _yang_name = 'config'
  _yang_namespace = 'http://openconfig.net/yang/bfd'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='string', is_config=True)
    self.__enabled = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='boolean', is_config=True)
    self.__local_address = YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}),], is_leaf=True, yang_name="local-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='oc-inet:ip-address', is_config=True)
    self.__desired_minimum_tx_interval = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="desired-minimum-tx-interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='uint32', is_config=True)
    self.__required_minimum_receive = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="required-minimum-receive", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='uint32', is_config=True)
    self.__detection_multiplier = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['1..max']}), is_leaf=True, yang_name="detection-multiplier", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='uint8', is_config=True)
    self.__enable_per_member_link = YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="enable-per-member-link", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='boolean', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['bfd', 'interfaces', 'interface', 'config']

  def _get_id(self):
    """
    Getter method for id, mapped from YANG variable /bfd/interfaces/interface/config/id (string)

    YANG Description: A unique identifier for the interface.
    """
    return self.__id
      
  def _set_id(self, v, load=False):
    """
    Setter method for id, mapped from YANG variable /bfd/interfaces/interface/config/id (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_id() directly.

    YANG Description: A unique identifier for the interface.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='string', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """id must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='string', is_config=True)""",
        })

    self.__id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_id(self):
    self.__id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='string', is_config=True)


  def _get_enabled(self):
    """
    Getter method for enabled, mapped from YANG variable /bfd/interfaces/interface/config/enabled (boolean)

    YANG Description: When this leaf is set to true then the BFD session is enabled
on the specified interface - if it is set to false, it is
administratively disabled.
    """
    return self.__enabled
      
  def _set_enabled(self, v, load=False):
    """
    Setter method for enabled, mapped from YANG variable /bfd/interfaces/interface/config/enabled (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_enabled is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_enabled() directly.

    YANG Description: When this leaf is set to true then the BFD session is enabled
on the specified interface - if it is set to false, it is
administratively disabled.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, is_leaf=True, yang_name="enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='boolean', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """enabled must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, is_leaf=True, yang_name="enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='boolean', is_config=True)""",
        })

    self.__enabled = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_enabled(self):
    self.__enabled = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='boolean', is_config=True)


  def _get_local_address(self):
    """
    Getter method for local_address, mapped from YANG variable /bfd/interfaces/interface/config/local_address (oc-inet:ip-address)

    YANG Description: The source IP address to be used for BFD sessions over this
interface.
    """
    return self.__local_address
      
  def _set_local_address(self, v, load=False):
    """
    Setter method for local_address, mapped from YANG variable /bfd/interfaces/interface/config/local_address (oc-inet:ip-address)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_local_address is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_local_address() directly.

    YANG Description: The source IP address to be used for BFD sessions over this
interface.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}),], is_leaf=True, yang_name="local-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='oc-inet:ip-address', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """local_address must be of a type compatible with oc-inet:ip-address""",
          'defined-type': "oc-inet:ip-address",
          'generated-type': """YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}),], is_leaf=True, yang_name="local-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='oc-inet:ip-address', is_config=True)""",
        })

    self.__local_address = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_local_address(self):
    self.__local_address = YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}),], is_leaf=True, yang_name="local-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='oc-inet:ip-address', is_config=True)


  def _get_desired_minimum_tx_interval(self):
    """
    Getter method for desired_minimum_tx_interval, mapped from YANG variable /bfd/interfaces/interface/config/desired_minimum_tx_interval (uint32)

    YANG Description: The minimum interval between transmission of BFD control
packets that the operator desires. This value is advertised to
the peer, however the actual interval used is specified by
taking the maximum of desired-minimum-tx-interval and the
value of the remote required-minimum-receive interval value.

This value is specified as an integer number of microseconds.
    """
    return self.__desired_minimum_tx_interval
      
  def _set_desired_minimum_tx_interval(self, v, load=False):
    """
    Setter method for desired_minimum_tx_interval, mapped from YANG variable /bfd/interfaces/interface/config/desired_minimum_tx_interval (uint32)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_desired_minimum_tx_interval is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_desired_minimum_tx_interval() directly.

    YANG Description: The minimum interval between transmission of BFD control
packets that the operator desires. This value is advertised to
the peer, however the actual interval used is specified by
taking the maximum of desired-minimum-tx-interval and the
value of the remote required-minimum-receive interval value.

This value is specified as an integer number of microseconds.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="desired-minimum-tx-interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='uint32', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """desired_minimum_tx_interval must be of a type compatible with uint32""",
          'defined-type': "uint32",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="desired-minimum-tx-interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='uint32', is_config=True)""",
        })

    self.__desired_minimum_tx_interval = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_desired_minimum_tx_interval(self):
    self.__desired_minimum_tx_interval = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="desired-minimum-tx-interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='uint32', is_config=True)


  def _get_required_minimum_receive(self):
    """
    Getter method for required_minimum_receive, mapped from YANG variable /bfd/interfaces/interface/config/required_minimum_receive (uint32)

    YANG Description: The minimum interval between received BFD control packets that
this system should support. This value is advertised to the
remote peer to indicate the maximum frequency (i.e., minimum
inter-packet interval) between BFD control packets that is
acceptable to the local system.
    """
    return self.__required_minimum_receive
      
  def _set_required_minimum_receive(self, v, load=False):
    """
    Setter method for required_minimum_receive, mapped from YANG variable /bfd/interfaces/interface/config/required_minimum_receive (uint32)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_required_minimum_receive is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_required_minimum_receive() directly.

    YANG Description: The minimum interval between received BFD control packets that
this system should support. This value is advertised to the
remote peer to indicate the maximum frequency (i.e., minimum
inter-packet interval) between BFD control packets that is
acceptable to the local system.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="required-minimum-receive", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='uint32', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """required_minimum_receive must be of a type compatible with uint32""",
          'defined-type': "uint32",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="required-minimum-receive", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='uint32', is_config=True)""",
        })

    self.__required_minimum_receive = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_required_minimum_receive(self):
    self.__required_minimum_receive = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="required-minimum-receive", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='uint32', is_config=True)


  def _get_detection_multiplier(self):
    """
    Getter method for detection_multiplier, mapped from YANG variable /bfd/interfaces/interface/config/detection_multiplier (uint8)

    YANG Description: The number of packets that must be missed to declare this
session as down. The detection interval for the BFD session
is calculated by multiplying the value of the negotiated
transmission interval by this value.
    """
    return self.__detection_multiplier
      
  def _set_detection_multiplier(self, v, load=False):
    """
    Setter method for detection_multiplier, mapped from YANG variable /bfd/interfaces/interface/config/detection_multiplier (uint8)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_detection_multiplier is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_detection_multiplier() directly.

    YANG Description: The number of packets that must be missed to declare this
session as down. The detection interval for the BFD session
is calculated by multiplying the value of the negotiated
transmission interval by this value.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['1..max']}), is_leaf=True, yang_name="detection-multiplier", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='uint8', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """detection_multiplier must be of a type compatible with uint8""",
          'defined-type': "uint8",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['1..max']}), is_leaf=True, yang_name="detection-multiplier", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='uint8', is_config=True)""",
        })

    self.__detection_multiplier = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_detection_multiplier(self):
    self.__detection_multiplier = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['1..max']}), is_leaf=True, yang_name="detection-multiplier", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='uint8', is_config=True)


  def _get_enable_per_member_link(self):
    """
    Getter method for enable_per_member_link, mapped from YANG variable /bfd/interfaces/interface/config/enable_per_member_link (boolean)

    YANG Description: When this leaf is set to true - BFD will be enabled on
each member interface of the aggregated Ethernet bundle.
    """
    return self.__enable_per_member_link
      
  def _set_enable_per_member_link(self, v, load=False):
    """
    Setter method for enable_per_member_link, mapped from YANG variable /bfd/interfaces/interface/config/enable_per_member_link (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_enable_per_member_link is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_enable_per_member_link() directly.

    YANG Description: When this leaf is set to true - BFD will be enabled on
each member interface of the aggregated Ethernet bundle.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="enable-per-member-link", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='boolean', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """enable_per_member_link must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="enable-per-member-link", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='boolean', is_config=True)""",
        })

    self.__enable_per_member_link = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_enable_per_member_link(self):
    self.__enable_per_member_link = YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="enable-per-member-link", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='boolean', is_config=True)

  id = __builtin__.property(_get_id, _set_id)
  enabled = __builtin__.property(_get_enabled, _set_enabled)
  local_address = __builtin__.property(_get_local_address, _set_local_address)
  desired_minimum_tx_interval = __builtin__.property(_get_desired_minimum_tx_interval, _set_desired_minimum_tx_interval)
  required_minimum_receive = __builtin__.property(_get_required_minimum_receive, _set_required_minimum_receive)
  detection_multiplier = __builtin__.property(_get_detection_multiplier, _set_detection_multiplier)
  enable_per_member_link = __builtin__.property(_get_enable_per_member_link, _set_enable_per_member_link)


  _pyangbind_elements = OrderedDict([('id', id), ('enabled', enabled), ('local_address', local_address), ('desired_minimum_tx_interval', desired_minimum_tx_interval), ('required_minimum_receive', required_minimum_receive), ('detection_multiplier', detection_multiplier), ('enable_per_member_link', enable_per_member_link), ])


class yc_state_openconfig_bfd__bfd_interfaces_interface_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-bfd - based on the path /bfd/interfaces/interface/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational state parameters for BFD on the specified
interface.
  """
  __slots__ = ('_path_helper', '_extmethods', '__id','__enabled','__local_address','__desired_minimum_tx_interval','__required_minimum_receive','__detection_multiplier','__enable_per_member_link',)

  _yang_name = 'state'
  _yang_namespace = 'http://openconfig.net/yang/bfd'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='string', is_config=False)
    self.__enabled = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='boolean', is_config=False)
    self.__local_address = YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}),], is_leaf=True, yang_name="local-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='oc-inet:ip-address', is_config=False)
    self.__desired_minimum_tx_interval = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="desired-minimum-tx-interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='uint32', is_config=False)
    self.__required_minimum_receive = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="required-minimum-receive", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='uint32', is_config=False)
    self.__detection_multiplier = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['1..max']}), is_leaf=True, yang_name="detection-multiplier", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='uint8', is_config=False)
    self.__enable_per_member_link = YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="enable-per-member-link", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='boolean', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['bfd', 'interfaces', 'interface', 'state']

  def _get_id(self):
    """
    Getter method for id, mapped from YANG variable /bfd/interfaces/interface/state/id (string)

    YANG Description: A unique identifier for the interface.
    """
    return self.__id
      
  def _set_id(self, v, load=False):
    """
    Setter method for id, mapped from YANG variable /bfd/interfaces/interface/state/id (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_id() directly.

    YANG Description: A unique identifier for the interface.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """id must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='string', is_config=False)""",
        })

    self.__id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_id(self):
    self.__id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='string', is_config=False)


  def _get_enabled(self):
    """
    Getter method for enabled, mapped from YANG variable /bfd/interfaces/interface/state/enabled (boolean)

    YANG Description: When this leaf is set to true then the BFD session is enabled
on the specified interface - if it is set to false, it is
administratively disabled.
    """
    return self.__enabled
      
  def _set_enabled(self, v, load=False):
    """
    Setter method for enabled, mapped from YANG variable /bfd/interfaces/interface/state/enabled (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_enabled is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_enabled() directly.

    YANG Description: When this leaf is set to true then the BFD session is enabled
on the specified interface - if it is set to false, it is
administratively disabled.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, is_leaf=True, yang_name="enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='boolean', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """enabled must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, is_leaf=True, yang_name="enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='boolean', is_config=False)""",
        })

    self.__enabled = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_enabled(self):
    self.__enabled = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='boolean', is_config=False)


  def _get_local_address(self):
    """
    Getter method for local_address, mapped from YANG variable /bfd/interfaces/interface/state/local_address (oc-inet:ip-address)

    YANG Description: The source IP address to be used for BFD sessions over this
interface.
    """
    return self.__local_address
      
  def _set_local_address(self, v, load=False):
    """
    Setter method for local_address, mapped from YANG variable /bfd/interfaces/interface/state/local_address (oc-inet:ip-address)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_local_address is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_local_address() directly.

    YANG Description: The source IP address to be used for BFD sessions over this
interface.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}),], is_leaf=True, yang_name="local-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='oc-inet:ip-address', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """local_address must be of a type compatible with oc-inet:ip-address""",
          'defined-type': "oc-inet:ip-address",
          'generated-type': """YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}),], is_leaf=True, yang_name="local-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='oc-inet:ip-address', is_config=False)""",
        })

    self.__local_address = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_local_address(self):
    self.__local_address = YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}),], is_leaf=True, yang_name="local-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='oc-inet:ip-address', is_config=False)


  def _get_desired_minimum_tx_interval(self):
    """
    Getter method for desired_minimum_tx_interval, mapped from YANG variable /bfd/interfaces/interface/state/desired_minimum_tx_interval (uint32)

    YANG Description: The minimum interval between transmission of BFD control
packets that the operator desires. This value is advertised to
the peer, however the actual interval used is specified by
taking the maximum of desired-minimum-tx-interval and the
value of the remote required-minimum-receive interval value.

This value is specified as an integer number of microseconds.
    """
    return self.__desired_minimum_tx_interval
      
  def _set_desired_minimum_tx_interval(self, v, load=False):
    """
    Setter method for desired_minimum_tx_interval, mapped from YANG variable /bfd/interfaces/interface/state/desired_minimum_tx_interval (uint32)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_desired_minimum_tx_interval is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_desired_minimum_tx_interval() directly.

    YANG Description: The minimum interval between transmission of BFD control
packets that the operator desires. This value is advertised to
the peer, however the actual interval used is specified by
taking the maximum of desired-minimum-tx-interval and the
value of the remote required-minimum-receive interval value.

This value is specified as an integer number of microseconds.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="desired-minimum-tx-interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='uint32', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """desired_minimum_tx_interval must be of a type compatible with uint32""",
          'defined-type': "uint32",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="desired-minimum-tx-interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='uint32', is_config=False)""",
        })

    self.__desired_minimum_tx_interval = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_desired_minimum_tx_interval(self):
    self.__desired_minimum_tx_interval = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="desired-minimum-tx-interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='uint32', is_config=False)


  def _get_required_minimum_receive(self):
    """
    Getter method for required_minimum_receive, mapped from YANG variable /bfd/interfaces/interface/state/required_minimum_receive (uint32)

    YANG Description: The minimum interval between received BFD control packets that
this system should support. This value is advertised to the
remote peer to indicate the maximum frequency (i.e., minimum
inter-packet interval) between BFD control packets that is
acceptable to the local system.
    """
    return self.__required_minimum_receive
      
  def _set_required_minimum_receive(self, v, load=False):
    """
    Setter method for required_minimum_receive, mapped from YANG variable /bfd/interfaces/interface/state/required_minimum_receive (uint32)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_required_minimum_receive is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_required_minimum_receive() directly.

    YANG Description: The minimum interval between received BFD control packets that
this system should support. This value is advertised to the
remote peer to indicate the maximum frequency (i.e., minimum
inter-packet interval) between BFD control packets that is
acceptable to the local system.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="required-minimum-receive", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='uint32', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """required_minimum_receive must be of a type compatible with uint32""",
          'defined-type': "uint32",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="required-minimum-receive", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='uint32', is_config=False)""",
        })

    self.__required_minimum_receive = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_required_minimum_receive(self):
    self.__required_minimum_receive = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="required-minimum-receive", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='uint32', is_config=False)


  def _get_detection_multiplier(self):
    """
    Getter method for detection_multiplier, mapped from YANG variable /bfd/interfaces/interface/state/detection_multiplier (uint8)

    YANG Description: The number of packets that must be missed to declare this
session as down. The detection interval for the BFD session
is calculated by multiplying the value of the negotiated
transmission interval by this value.
    """
    return self.__detection_multiplier
      
  def _set_detection_multiplier(self, v, load=False):
    """
    Setter method for detection_multiplier, mapped from YANG variable /bfd/interfaces/interface/state/detection_multiplier (uint8)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_detection_multiplier is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_detection_multiplier() directly.

    YANG Description: The number of packets that must be missed to declare this
session as down. The detection interval for the BFD session
is calculated by multiplying the value of the negotiated
transmission interval by this value.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['1..max']}), is_leaf=True, yang_name="detection-multiplier", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='uint8', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """detection_multiplier must be of a type compatible with uint8""",
          'defined-type': "uint8",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['1..max']}), is_leaf=True, yang_name="detection-multiplier", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='uint8', is_config=False)""",
        })

    self.__detection_multiplier = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_detection_multiplier(self):
    self.__detection_multiplier = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['1..max']}), is_leaf=True, yang_name="detection-multiplier", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='uint8', is_config=False)


  def _get_enable_per_member_link(self):
    """
    Getter method for enable_per_member_link, mapped from YANG variable /bfd/interfaces/interface/state/enable_per_member_link (boolean)

    YANG Description: When this leaf is set to true - BFD will be enabled on
each member interface of the aggregated Ethernet bundle.
    """
    return self.__enable_per_member_link
      
  def _set_enable_per_member_link(self, v, load=False):
    """
    Setter method for enable_per_member_link, mapped from YANG variable /bfd/interfaces/interface/state/enable_per_member_link (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_enable_per_member_link is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_enable_per_member_link() directly.

    YANG Description: When this leaf is set to true - BFD will be enabled on
each member interface of the aggregated Ethernet bundle.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="enable-per-member-link", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='boolean', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """enable_per_member_link must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="enable-per-member-link", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='boolean', is_config=False)""",
        })

    self.__enable_per_member_link = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_enable_per_member_link(self):
    self.__enable_per_member_link = YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="enable-per-member-link", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='boolean', is_config=False)

  id = __builtin__.property(_get_id)
  enabled = __builtin__.property(_get_enabled)
  local_address = __builtin__.property(_get_local_address)
  desired_minimum_tx_interval = __builtin__.property(_get_desired_minimum_tx_interval)
  required_minimum_receive = __builtin__.property(_get_required_minimum_receive)
  detection_multiplier = __builtin__.property(_get_detection_multiplier)
  enable_per_member_link = __builtin__.property(_get_enable_per_member_link)


  _pyangbind_elements = OrderedDict([('id', id), ('enabled', enabled), ('local_address', local_address), ('desired_minimum_tx_interval', desired_minimum_tx_interval), ('required_minimum_receive', required_minimum_receive), ('detection_multiplier', detection_multiplier), ('enable_per_member_link', enable_per_member_link), ])


class yc_config_openconfig_bfd__bfd_interfaces_interface_interface_ref_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-bfd - based on the path /bfd/interfaces/interface/interface-ref/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configured reference to interface / subinterface
  """
  __slots__ = ('_path_helper', '_extmethods', '__interface','__subinterface',)

  _yang_name = 'config'
  _yang_namespace = 'http://openconfig.net/yang/bfd'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__interface = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='leafref', is_config=True)
    self.__subinterface = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="subinterface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='leafref', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['bfd', 'interfaces', 'interface', 'interface-ref', 'config']

  def _get_interface(self):
    """
    Getter method for interface, mapped from YANG variable /bfd/interfaces/interface/interface_ref/config/interface (leafref)

    YANG Description: Reference to a base interface.  If a reference to a
subinterface is required, this leaf must be specified
to indicate the base interface.
    """
    return self.__interface
      
  def _set_interface(self, v, load=False):
    """
    Setter method for interface, mapped from YANG variable /bfd/interfaces/interface/interface_ref/config/interface (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_interface is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_interface() directly.

    YANG Description: Reference to a base interface.  If a reference to a
subinterface is required, this leaf must be specified
to indicate the base interface.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """interface must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='leafref', is_config=True)""",
        })

    self.__interface = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_interface(self):
    self.__interface = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='leafref', is_config=True)


  def _get_subinterface(self):
    """
    Getter method for subinterface, mapped from YANG variable /bfd/interfaces/interface/interface_ref/config/subinterface (leafref)

    YANG Description: Reference to a subinterface -- this requires the base
interface to be specified using the interface leaf in
this container.  If only a reference to a base interface
is requuired, this leaf should not be set.
    """
    return self.__subinterface
      
  def _set_subinterface(self, v, load=False):
    """
    Setter method for subinterface, mapped from YANG variable /bfd/interfaces/interface/interface_ref/config/subinterface (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_subinterface is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_subinterface() directly.

    YANG Description: Reference to a subinterface -- this requires the base
interface to be specified using the interface leaf in
this container.  If only a reference to a base interface
is requuired, this leaf should not be set.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="subinterface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """subinterface must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="subinterface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='leafref', is_config=True)""",
        })

    self.__subinterface = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_subinterface(self):
    self.__subinterface = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="subinterface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='leafref', is_config=True)

  interface = __builtin__.property(_get_interface, _set_interface)
  subinterface = __builtin__.property(_get_subinterface, _set_subinterface)


  _pyangbind_elements = OrderedDict([('interface', interface), ('subinterface', subinterface), ])


class yc_state_openconfig_bfd__bfd_interfaces_interface_interface_ref_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-bfd - based on the path /bfd/interfaces/interface/interface-ref/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational state for interface-ref
  """
  __slots__ = ('_path_helper', '_extmethods', '__interface','__subinterface',)

  _yang_name = 'state'
  _yang_namespace = 'http://openconfig.net/yang/bfd'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__interface = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='leafref', is_config=False)
    self.__subinterface = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="subinterface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='leafref', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['bfd', 'interfaces', 'interface', 'interface-ref', 'state']

  def _get_interface(self):
    """
    Getter method for interface, mapped from YANG variable /bfd/interfaces/interface/interface_ref/state/interface (leafref)

    YANG Description: Reference to a base interface.  If a reference to a
subinterface is required, this leaf must be specified
to indicate the base interface.
    """
    return self.__interface
      
  def _set_interface(self, v, load=False):
    """
    Setter method for interface, mapped from YANG variable /bfd/interfaces/interface/interface_ref/state/interface (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_interface is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_interface() directly.

    YANG Description: Reference to a base interface.  If a reference to a
subinterface is required, this leaf must be specified
to indicate the base interface.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='leafref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """interface must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='leafref', is_config=False)""",
        })

    self.__interface = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_interface(self):
    self.__interface = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='leafref', is_config=False)


  def _get_subinterface(self):
    """
    Getter method for subinterface, mapped from YANG variable /bfd/interfaces/interface/interface_ref/state/subinterface (leafref)

    YANG Description: Reference to a subinterface -- this requires the base
interface to be specified using the interface leaf in
this container.  If only a reference to a base interface
is requuired, this leaf should not be set.
    """
    return self.__subinterface
      
  def _set_subinterface(self, v, load=False):
    """
    Setter method for subinterface, mapped from YANG variable /bfd/interfaces/interface/interface_ref/state/subinterface (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_subinterface is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_subinterface() directly.

    YANG Description: Reference to a subinterface -- this requires the base
interface to be specified using the interface leaf in
this container.  If only a reference to a base interface
is requuired, this leaf should not be set.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="subinterface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='leafref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """subinterface must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="subinterface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='leafref', is_config=False)""",
        })

    self.__subinterface = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_subinterface(self):
    self.__subinterface = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="subinterface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='leafref', is_config=False)

  interface = __builtin__.property(_get_interface)
  subinterface = __builtin__.property(_get_subinterface)


  _pyangbind_elements = OrderedDict([('interface', interface), ('subinterface', subinterface), ])


class yc_interface_ref_openconfig_bfd__bfd_interfaces_interface_interface_ref(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-bfd - based on the path /bfd/interfaces/interface/interface-ref. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Reference to an interface or subinterface. The interface
that is being referenced is uniquely referenced based on
the specified interface and subinterface leaves. In contexts
where a Layer 3 interface is to be referenced, both the
interface and subinterface leaves must be populated, as
Layer 3 configuration within the OpenConfig models is
associated with a subinterface. In the case where a
Layer 2 interface is to be referenced, only the
interface is specified.

The interface/subinterface leaf tuple must be used as
the means by which the interface is specified, regardless
of any other context information (e.g., key in a list).
  """
  __slots__ = ('_path_helper', '_extmethods', '__config','__state',)

  _yang_name = 'interface-ref'
  _yang_namespace = 'http://openconfig.net/yang/bfd'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__config = YANGDynClass(base=yc_config_openconfig_bfd__bfd_interfaces_interface_interface_ref_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_bfd__bfd_interfaces_interface_interface_ref_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['bfd', 'interfaces', 'interface', 'interface-ref']

  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /bfd/interfaces/interface/interface_ref/config (container)

    YANG Description: Configured reference to interface / subinterface
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /bfd/interfaces/interface/interface_ref/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Configured reference to interface / subinterface
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_bfd__bfd_interfaces_interface_interface_ref_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_bfd__bfd_interfaces_interface_interface_ref_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_bfd__bfd_interfaces_interface_interface_ref_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /bfd/interfaces/interface/interface_ref/state (container)

    YANG Description: Operational state for interface-ref
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /bfd/interfaces/interface/interface_ref/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: Operational state for interface-ref
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_bfd__bfd_interfaces_interface_interface_ref_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_bfd__bfd_interfaces_interface_interface_ref_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_bfd__bfd_interfaces_interface_interface_ref_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='container', is_config=True)

  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)


  _pyangbind_elements = OrderedDict([('config', config), ('state', state), ])


class yc_config_openconfig_bfd__bfd_interfaces_interface_micro_bfd_sessions_micro_bfd_session_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-bfd - based on the path /bfd/interfaces/interface/micro-bfd-sessions/micro-bfd-session/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configuration parameters for the micro-BFD session.
  """
  __slots__ = ('_path_helper', '_extmethods', '__local_address','__remote_address','__member_interface',)

  _yang_name = 'config'
  _yang_namespace = 'http://openconfig.net/yang/bfd'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__local_address = YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}),], is_leaf=True, yang_name="local-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='oc-inet:ip-address', is_config=True)
    self.__remote_address = YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}),], is_leaf=True, yang_name="remote-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='oc-inet:ip-address', is_config=True)
    self.__member_interface = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="member-interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='leafref', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['bfd', 'interfaces', 'interface', 'micro-bfd-sessions', 'micro-bfd-session', 'config']

  def _get_local_address(self):
    """
    Getter method for local_address, mapped from YANG variable /bfd/interfaces/interface/micro_bfd_sessions/micro_bfd_session/config/local_address (oc-inet:ip-address)

    YANG Description: The local IP address used by the system for the micro-BFD session
specified.
    """
    return self.__local_address
      
  def _set_local_address(self, v, load=False):
    """
    Setter method for local_address, mapped from YANG variable /bfd/interfaces/interface/micro_bfd_sessions/micro_bfd_session/config/local_address (oc-inet:ip-address)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_local_address is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_local_address() directly.

    YANG Description: The local IP address used by the system for the micro-BFD session
specified.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}),], is_leaf=True, yang_name="local-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='oc-inet:ip-address', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """local_address must be of a type compatible with oc-inet:ip-address""",
          'defined-type': "oc-inet:ip-address",
          'generated-type': """YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}),], is_leaf=True, yang_name="local-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='oc-inet:ip-address', is_config=True)""",
        })

    self.__local_address = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_local_address(self):
    self.__local_address = YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}),], is_leaf=True, yang_name="local-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='oc-inet:ip-address', is_config=True)


  def _get_remote_address(self):
    """
    Getter method for remote_address, mapped from YANG variable /bfd/interfaces/interface/micro_bfd_sessions/micro_bfd_session/config/remote_address (oc-inet:ip-address)

    YANG Description: The remote IP destination that should be used by the system for
the micro-BFD session specified.
    """
    return self.__remote_address
      
  def _set_remote_address(self, v, load=False):
    """
    Setter method for remote_address, mapped from YANG variable /bfd/interfaces/interface/micro_bfd_sessions/micro_bfd_session/config/remote_address (oc-inet:ip-address)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_remote_address is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_remote_address() directly.

    YANG Description: The remote IP destination that should be used by the system for
the micro-BFD session specified.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}),], is_leaf=True, yang_name="remote-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='oc-inet:ip-address', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """remote_address must be of a type compatible with oc-inet:ip-address""",
          'defined-type': "oc-inet:ip-address",
          'generated-type': """YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}),], is_leaf=True, yang_name="remote-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='oc-inet:ip-address', is_config=True)""",
        })

    self.__remote_address = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_remote_address(self):
    self.__remote_address = YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}),], is_leaf=True, yang_name="remote-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='oc-inet:ip-address', is_config=True)


  def _get_member_interface(self):
    """
    Getter method for member_interface, mapped from YANG variable /bfd/interfaces/interface/micro_bfd_sessions/micro_bfd_session/config/member_interface (leafref)

    YANG Description: Reference to a member link of the aggregate interface being
described.
    """
    return self.__member_interface
      
  def _set_member_interface(self, v, load=False):
    """
    Setter method for member_interface, mapped from YANG variable /bfd/interfaces/interface/micro_bfd_sessions/micro_bfd_session/config/member_interface (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_member_interface is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_member_interface() directly.

    YANG Description: Reference to a member link of the aggregate interface being
described.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="member-interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """member_interface must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="member-interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='leafref', is_config=True)""",
        })

    self.__member_interface = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_member_interface(self):
    self.__member_interface = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="member-interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='leafref', is_config=True)

  local_address = __builtin__.property(_get_local_address, _set_local_address)
  remote_address = __builtin__.property(_get_remote_address, _set_remote_address)
  member_interface = __builtin__.property(_get_member_interface, _set_member_interface)


  _pyangbind_elements = OrderedDict([('local_address', local_address), ('remote_address', remote_address), ('member_interface', member_interface), ])


class yc_async_openconfig_bfd__bfd_interfaces_interface_micro_bfd_sessions_micro_bfd_session_state_async(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-bfd - based on the path /bfd/interfaces/interface/micro-bfd-sessions/micro-bfd-session/state/async. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational state parameters specifically relating to
asynchronous mode of BFD.
  """
  __slots__ = ('_path_helper', '_extmethods', '__last_packet_transmitted','__last_packet_received','__transmitted_packets','__received_packets','__up_transitions',)

  _yang_name = 'async'
  _yang_namespace = 'http://openconfig.net/yang/bfd'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__last_packet_transmitted = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="last-packet-transmitted", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='uint64', is_config=False)
    self.__last_packet_received = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="last-packet-received", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='uint64', is_config=False)
    self.__transmitted_packets = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="transmitted-packets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='uint64', is_config=False)
    self.__received_packets = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="received-packets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='uint64', is_config=False)
    self.__up_transitions = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="up-transitions", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='uint64', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['bfd', 'interfaces', 'interface', 'micro-bfd-sessions', 'micro-bfd-session', 'state', 'async']

  def _get_last_packet_transmitted(self):
    """
    Getter method for last_packet_transmitted, mapped from YANG variable /bfd/interfaces/interface/micro_bfd_sessions/micro_bfd_session/state/async/last_packet_transmitted (uint64)

    YANG Description: The date and time at which the last BFD packet
was transmitted for this session, expressed as the number
of nanoseconds since the Unix Epoch (January 1, 1970,
00:00 UTC).
    """
    return self.__last_packet_transmitted
      
  def _set_last_packet_transmitted(self, v, load=False):
    """
    Setter method for last_packet_transmitted, mapped from YANG variable /bfd/interfaces/interface/micro_bfd_sessions/micro_bfd_session/state/async/last_packet_transmitted (uint64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_last_packet_transmitted is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_last_packet_transmitted() directly.

    YANG Description: The date and time at which the last BFD packet
was transmitted for this session, expressed as the number
of nanoseconds since the Unix Epoch (January 1, 1970,
00:00 UTC).
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="last-packet-transmitted", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='uint64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """last_packet_transmitted must be of a type compatible with uint64""",
          'defined-type': "uint64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="last-packet-transmitted", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='uint64', is_config=False)""",
        })

    self.__last_packet_transmitted = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_last_packet_transmitted(self):
    self.__last_packet_transmitted = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="last-packet-transmitted", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='uint64', is_config=False)


  def _get_last_packet_received(self):
    """
    Getter method for last_packet_received, mapped from YANG variable /bfd/interfaces/interface/micro_bfd_sessions/micro_bfd_session/state/async/last_packet_received (uint64)

    YANG Description: The date and time at which the last BFD packet
was received for this session, expressed as the number
of nanoseconds since the Unix Epoch (January 1, 1970,
00:00 UTC).
    """
    return self.__last_packet_received
      
  def _set_last_packet_received(self, v, load=False):
    """
    Setter method for last_packet_received, mapped from YANG variable /bfd/interfaces/interface/micro_bfd_sessions/micro_bfd_session/state/async/last_packet_received (uint64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_last_packet_received is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_last_packet_received() directly.

    YANG Description: The date and time at which the last BFD packet
was received for this session, expressed as the number
of nanoseconds since the Unix Epoch (January 1, 1970,
00:00 UTC).
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="last-packet-received", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='uint64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """last_packet_received must be of a type compatible with uint64""",
          'defined-type': "uint64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="last-packet-received", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='uint64', is_config=False)""",
        })

    self.__last_packet_received = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_last_packet_received(self):
    self.__last_packet_received = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="last-packet-received", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='uint64', is_config=False)


  def _get_transmitted_packets(self):
    """
    Getter method for transmitted_packets, mapped from YANG variable /bfd/interfaces/interface/micro_bfd_sessions/micro_bfd_session/state/async/transmitted_packets (uint64)

    YANG Description: The number of packets that have been transmitted
by the local system.
    """
    return self.__transmitted_packets
      
  def _set_transmitted_packets(self, v, load=False):
    """
    Setter method for transmitted_packets, mapped from YANG variable /bfd/interfaces/interface/micro_bfd_sessions/micro_bfd_session/state/async/transmitted_packets (uint64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_transmitted_packets is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_transmitted_packets() directly.

    YANG Description: The number of packets that have been transmitted
by the local system.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="transmitted-packets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='uint64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """transmitted_packets must be of a type compatible with uint64""",
          'defined-type': "uint64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="transmitted-packets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='uint64', is_config=False)""",
        })

    self.__transmitted_packets = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_transmitted_packets(self):
    self.__transmitted_packets = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="transmitted-packets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='uint64', is_config=False)


  def _get_received_packets(self):
    """
    Getter method for received_packets, mapped from YANG variable /bfd/interfaces/interface/micro_bfd_sessions/micro_bfd_session/state/async/received_packets (uint64)

    YANG Description: The number of packets that have been received by the
local system from the remote neighbour.
    """
    return self.__received_packets
      
  def _set_received_packets(self, v, load=False):
    """
    Setter method for received_packets, mapped from YANG variable /bfd/interfaces/interface/micro_bfd_sessions/micro_bfd_session/state/async/received_packets (uint64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_received_packets is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_received_packets() directly.

    YANG Description: The number of packets that have been received by the
local system from the remote neighbour.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="received-packets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='uint64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """received_packets must be of a type compatible with uint64""",
          'defined-type': "uint64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="received-packets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='uint64', is_config=False)""",
        })

    self.__received_packets = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_received_packets(self):
    self.__received_packets = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="received-packets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='uint64', is_config=False)


  def _get_up_transitions(self):
    """
    Getter method for up_transitions, mapped from YANG variable /bfd/interfaces/interface/micro_bfd_sessions/micro_bfd_session/state/async/up_transitions (uint64)

    YANG Description: The number of times that the adjacency with the neighbor
has transitioned into the up state.
    """
    return self.__up_transitions
      
  def _set_up_transitions(self, v, load=False):
    """
    Setter method for up_transitions, mapped from YANG variable /bfd/interfaces/interface/micro_bfd_sessions/micro_bfd_session/state/async/up_transitions (uint64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_up_transitions is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_up_transitions() directly.

    YANG Description: The number of times that the adjacency with the neighbor
has transitioned into the up state.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="up-transitions", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='uint64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """up_transitions must be of a type compatible with uint64""",
          'defined-type': "uint64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="up-transitions", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='uint64', is_config=False)""",
        })

    self.__up_transitions = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_up_transitions(self):
    self.__up_transitions = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="up-transitions", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='uint64', is_config=False)

  last_packet_transmitted = __builtin__.property(_get_last_packet_transmitted)
  last_packet_received = __builtin__.property(_get_last_packet_received)
  transmitted_packets = __builtin__.property(_get_transmitted_packets)
  received_packets = __builtin__.property(_get_received_packets)
  up_transitions = __builtin__.property(_get_up_transitions)


  _pyangbind_elements = OrderedDict([('last_packet_transmitted', last_packet_transmitted), ('last_packet_received', last_packet_received), ('transmitted_packets', transmitted_packets), ('received_packets', received_packets), ('up_transitions', up_transitions), ])


class yc_state_openconfig_bfd__bfd_interfaces_interface_micro_bfd_sessions_micro_bfd_session_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-bfd - based on the path /bfd/interfaces/interface/micro-bfd-sessions/micro-bfd-session/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational state parameters for the micro-BFD session.
  """
  __slots__ = ('_path_helper', '_extmethods', '__local_address','__remote_address','__member_interface','__session_state','__remote_session_state','__last_failure_time','__failure_transitions','__local_discriminator','__remote_discriminator','__local_diagnostic_code','__remote_diagnostic_code','__remote_minimum_receive_interval','__demand_mode_requested','__remote_authentication_enabled','__remote_control_plane_independent','__async',)

  _yang_name = 'state'
  _yang_namespace = 'http://openconfig.net/yang/bfd'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__local_address = YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}),], is_leaf=True, yang_name="local-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='oc-inet:ip-address', is_config=False)
    self.__remote_address = YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}),], is_leaf=True, yang_name="remote-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='oc-inet:ip-address', is_config=False)
    self.__member_interface = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="member-interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='leafref', is_config=False)
    self.__session_state = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'UP': {}, 'DOWN': {}, 'ADMIN_DOWN': {}, 'INIT': {}},), is_leaf=True, yang_name="session-state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='bfd-session-state', is_config=False)
    self.__remote_session_state = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'UP': {}, 'DOWN': {}, 'ADMIN_DOWN': {}, 'INIT': {}},), is_leaf=True, yang_name="remote-session-state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='bfd-session-state', is_config=False)
    self.__last_failure_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="last-failure-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='oc-types:timeticks64', is_config=False)
    self.__failure_transitions = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="failure-transitions", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='uint64', is_config=False)
    self.__local_discriminator = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="local-discriminator", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='string', is_config=False)
    self.__remote_discriminator = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="remote-discriminator", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='string', is_config=False)
    self.__local_diagnostic_code = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'NO_DIAGNOSTIC': {'value': 0}, 'DETECTION_TIMEOUT': {'value': 1}, 'ECHO_FAILED': {'value': 2}, 'FORWARDING_RESET': {'value': 3}, 'PATH_DOWN': {'value': 4}, 'CONCATENATED_PATH_DOWN': {'value': 5}, 'ADMIN_DOWN': {'value': 6}, 'REVERSE_CONCATENATED_PATH_DOWN': {'value': 7}},), is_leaf=True, yang_name="local-diagnostic-code", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='bfd-diagnostic-code', is_config=False)
    self.__remote_diagnostic_code = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'NO_DIAGNOSTIC': {'value': 0}, 'DETECTION_TIMEOUT': {'value': 1}, 'ECHO_FAILED': {'value': 2}, 'FORWARDING_RESET': {'value': 3}, 'PATH_DOWN': {'value': 4}, 'CONCATENATED_PATH_DOWN': {'value': 5}, 'ADMIN_DOWN': {'value': 6}, 'REVERSE_CONCATENATED_PATH_DOWN': {'value': 7}},), is_leaf=True, yang_name="remote-diagnostic-code", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='bfd-diagnostic-code', is_config=False)
    self.__remote_minimum_receive_interval = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="remote-minimum-receive-interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='uint32', is_config=False)
    self.__demand_mode_requested = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="demand-mode-requested", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='boolean', is_config=False)
    self.__remote_authentication_enabled = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="remote-authentication-enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='boolean', is_config=False)
    self.__remote_control_plane_independent = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="remote-control-plane-independent", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='boolean', is_config=False)
    self.__async = YANGDynClass(base=yc_async_openconfig_bfd__bfd_interfaces_interface_micro_bfd_sessions_micro_bfd_session_state_async, is_container='container', yang_name="async", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='container', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['bfd', 'interfaces', 'interface', 'micro-bfd-sessions', 'micro-bfd-session', 'state']

  def _get_local_address(self):
    """
    Getter method for local_address, mapped from YANG variable /bfd/interfaces/interface/micro_bfd_sessions/micro_bfd_session/state/local_address (oc-inet:ip-address)

    YANG Description: The local IP address used by the system for the micro-BFD session
specified.
    """
    return self.__local_address
      
  def _set_local_address(self, v, load=False):
    """
    Setter method for local_address, mapped from YANG variable /bfd/interfaces/interface/micro_bfd_sessions/micro_bfd_session/state/local_address (oc-inet:ip-address)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_local_address is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_local_address() directly.

    YANG Description: The local IP address used by the system for the micro-BFD session
specified.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}),], is_leaf=True, yang_name="local-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='oc-inet:ip-address', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """local_address must be of a type compatible with oc-inet:ip-address""",
          'defined-type': "oc-inet:ip-address",
          'generated-type': """YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}),], is_leaf=True, yang_name="local-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='oc-inet:ip-address', is_config=False)""",
        })

    self.__local_address = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_local_address(self):
    self.__local_address = YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}),], is_leaf=True, yang_name="local-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='oc-inet:ip-address', is_config=False)


  def _get_remote_address(self):
    """
    Getter method for remote_address, mapped from YANG variable /bfd/interfaces/interface/micro_bfd_sessions/micro_bfd_session/state/remote_address (oc-inet:ip-address)

    YANG Description: The remote IP destination that should be used by the system for
the micro-BFD session specified.
    """
    return self.__remote_address
      
  def _set_remote_address(self, v, load=False):
    """
    Setter method for remote_address, mapped from YANG variable /bfd/interfaces/interface/micro_bfd_sessions/micro_bfd_session/state/remote_address (oc-inet:ip-address)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_remote_address is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_remote_address() directly.

    YANG Description: The remote IP destination that should be used by the system for
the micro-BFD session specified.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}),], is_leaf=True, yang_name="remote-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='oc-inet:ip-address', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """remote_address must be of a type compatible with oc-inet:ip-address""",
          'defined-type': "oc-inet:ip-address",
          'generated-type': """YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}),], is_leaf=True, yang_name="remote-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='oc-inet:ip-address', is_config=False)""",
        })

    self.__remote_address = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_remote_address(self):
    self.__remote_address = YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}),], is_leaf=True, yang_name="remote-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='oc-inet:ip-address', is_config=False)


  def _get_member_interface(self):
    """
    Getter method for member_interface, mapped from YANG variable /bfd/interfaces/interface/micro_bfd_sessions/micro_bfd_session/state/member_interface (leafref)

    YANG Description: Reference to a member link of the aggregate interface being
described.
    """
    return self.__member_interface
      
  def _set_member_interface(self, v, load=False):
    """
    Setter method for member_interface, mapped from YANG variable /bfd/interfaces/interface/micro_bfd_sessions/micro_bfd_session/state/member_interface (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_member_interface is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_member_interface() directly.

    YANG Description: Reference to a member link of the aggregate interface being
described.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="member-interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='leafref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """member_interface must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="member-interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='leafref', is_config=False)""",
        })

    self.__member_interface = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_member_interface(self):
    self.__member_interface = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="member-interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='leafref', is_config=False)


  def _get_session_state(self):
    """
    Getter method for session_state, mapped from YANG variable /bfd/interfaces/interface/micro_bfd_sessions/micro_bfd_session/state/session_state (bfd-session-state)

    YANG Description: The state of the BFD session perceived by the local system.
    """
    return self.__session_state
      
  def _set_session_state(self, v, load=False):
    """
    Setter method for session_state, mapped from YANG variable /bfd/interfaces/interface/micro_bfd_sessions/micro_bfd_session/state/session_state (bfd-session-state)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_session_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_session_state() directly.

    YANG Description: The state of the BFD session perceived by the local system.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'UP': {}, 'DOWN': {}, 'ADMIN_DOWN': {}, 'INIT': {}},), is_leaf=True, yang_name="session-state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='bfd-session-state', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """session_state must be of a type compatible with bfd-session-state""",
          'defined-type': "openconfig-bfd:bfd-session-state",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'UP': {}, 'DOWN': {}, 'ADMIN_DOWN': {}, 'INIT': {}},), is_leaf=True, yang_name="session-state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='bfd-session-state', is_config=False)""",
        })

    self.__session_state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_session_state(self):
    self.__session_state = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'UP': {}, 'DOWN': {}, 'ADMIN_DOWN': {}, 'INIT': {}},), is_leaf=True, yang_name="session-state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='bfd-session-state', is_config=False)


  def _get_remote_session_state(self):
    """
    Getter method for remote_session_state, mapped from YANG variable /bfd/interfaces/interface/micro_bfd_sessions/micro_bfd_session/state/remote_session_state (bfd-session-state)

    YANG Description: The reported state of the BFD session according to the remote
system. This state reflects the last state reported in a BFD
control packet.
    """
    return self.__remote_session_state
      
  def _set_remote_session_state(self, v, load=False):
    """
    Setter method for remote_session_state, mapped from YANG variable /bfd/interfaces/interface/micro_bfd_sessions/micro_bfd_session/state/remote_session_state (bfd-session-state)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_remote_session_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_remote_session_state() directly.

    YANG Description: The reported state of the BFD session according to the remote
system. This state reflects the last state reported in a BFD
control packet.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'UP': {}, 'DOWN': {}, 'ADMIN_DOWN': {}, 'INIT': {}},), is_leaf=True, yang_name="remote-session-state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='bfd-session-state', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """remote_session_state must be of a type compatible with bfd-session-state""",
          'defined-type': "openconfig-bfd:bfd-session-state",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'UP': {}, 'DOWN': {}, 'ADMIN_DOWN': {}, 'INIT': {}},), is_leaf=True, yang_name="remote-session-state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='bfd-session-state', is_config=False)""",
        })

    self.__remote_session_state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_remote_session_state(self):
    self.__remote_session_state = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'UP': {}, 'DOWN': {}, 'ADMIN_DOWN': {}, 'INIT': {}},), is_leaf=True, yang_name="remote-session-state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='bfd-session-state', is_config=False)


  def _get_last_failure_time(self):
    """
    Getter method for last_failure_time, mapped from YANG variable /bfd/interfaces/interface/micro_bfd_sessions/micro_bfd_session/state/last_failure_time (oc-types:timeticks64)

    YANG Description: The time of the last transition of the BFD session out of
the UP state, expressed as the number of nanoseconds since
the Unix epoch.
    """
    return self.__last_failure_time
      
  def _set_last_failure_time(self, v, load=False):
    """
    Setter method for last_failure_time, mapped from YANG variable /bfd/interfaces/interface/micro_bfd_sessions/micro_bfd_session/state/last_failure_time (oc-types:timeticks64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_last_failure_time is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_last_failure_time() directly.

    YANG Description: The time of the last transition of the BFD session out of
the UP state, expressed as the number of nanoseconds since
the Unix epoch.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="last-failure-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='oc-types:timeticks64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """last_failure_time must be of a type compatible with oc-types:timeticks64""",
          'defined-type': "oc-types:timeticks64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="last-failure-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='oc-types:timeticks64', is_config=False)""",
        })

    self.__last_failure_time = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_last_failure_time(self):
    self.__last_failure_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="last-failure-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='oc-types:timeticks64', is_config=False)


  def _get_failure_transitions(self):
    """
    Getter method for failure_transitions, mapped from YANG variable /bfd/interfaces/interface/micro_bfd_sessions/micro_bfd_session/state/failure_transitions (uint64)

    YANG Description: The number of times that the BFD session has transitioned
out of the UP state.
    """
    return self.__failure_transitions
      
  def _set_failure_transitions(self, v, load=False):
    """
    Setter method for failure_transitions, mapped from YANG variable /bfd/interfaces/interface/micro_bfd_sessions/micro_bfd_session/state/failure_transitions (uint64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_failure_transitions is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_failure_transitions() directly.

    YANG Description: The number of times that the BFD session has transitioned
out of the UP state.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="failure-transitions", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='uint64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """failure_transitions must be of a type compatible with uint64""",
          'defined-type': "uint64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="failure-transitions", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='uint64', is_config=False)""",
        })

    self.__failure_transitions = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_failure_transitions(self):
    self.__failure_transitions = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="failure-transitions", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='uint64', is_config=False)


  def _get_local_discriminator(self):
    """
    Getter method for local_discriminator, mapped from YANG variable /bfd/interfaces/interface/micro_bfd_sessions/micro_bfd_session/state/local_discriminator (string)

    YANG Description: A unique identifier used by the local system to identify this
BFD session.
    """
    return self.__local_discriminator
      
  def _set_local_discriminator(self, v, load=False):
    """
    Setter method for local_discriminator, mapped from YANG variable /bfd/interfaces/interface/micro_bfd_sessions/micro_bfd_session/state/local_discriminator (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_local_discriminator is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_local_discriminator() directly.

    YANG Description: A unique identifier used by the local system to identify this
BFD session.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="local-discriminator", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """local_discriminator must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="local-discriminator", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='string', is_config=False)""",
        })

    self.__local_discriminator = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_local_discriminator(self):
    self.__local_discriminator = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="local-discriminator", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='string', is_config=False)


  def _get_remote_discriminator(self):
    """
    Getter method for remote_discriminator, mapped from YANG variable /bfd/interfaces/interface/micro_bfd_sessions/micro_bfd_session/state/remote_discriminator (string)

    YANG Description: A unique identified used by the remote system to identify this
BFD session.
    """
    return self.__remote_discriminator
      
  def _set_remote_discriminator(self, v, load=False):
    """
    Setter method for remote_discriminator, mapped from YANG variable /bfd/interfaces/interface/micro_bfd_sessions/micro_bfd_session/state/remote_discriminator (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_remote_discriminator is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_remote_discriminator() directly.

    YANG Description: A unique identified used by the remote system to identify this
BFD session.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="remote-discriminator", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """remote_discriminator must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="remote-discriminator", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='string', is_config=False)""",
        })

    self.__remote_discriminator = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_remote_discriminator(self):
    self.__remote_discriminator = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="remote-discriminator", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='string', is_config=False)


  def _get_local_diagnostic_code(self):
    """
    Getter method for local_diagnostic_code, mapped from YANG variable /bfd/interfaces/interface/micro_bfd_sessions/micro_bfd_session/state/local_diagnostic_code (bfd-diagnostic-code)

    YANG Description: The local BFD diagnostic code indicating the most recent
reason for failure of this BFD session.
    """
    return self.__local_diagnostic_code
      
  def _set_local_diagnostic_code(self, v, load=False):
    """
    Setter method for local_diagnostic_code, mapped from YANG variable /bfd/interfaces/interface/micro_bfd_sessions/micro_bfd_session/state/local_diagnostic_code (bfd-diagnostic-code)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_local_diagnostic_code is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_local_diagnostic_code() directly.

    YANG Description: The local BFD diagnostic code indicating the most recent
reason for failure of this BFD session.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'NO_DIAGNOSTIC': {'value': 0}, 'DETECTION_TIMEOUT': {'value': 1}, 'ECHO_FAILED': {'value': 2}, 'FORWARDING_RESET': {'value': 3}, 'PATH_DOWN': {'value': 4}, 'CONCATENATED_PATH_DOWN': {'value': 5}, 'ADMIN_DOWN': {'value': 6}, 'REVERSE_CONCATENATED_PATH_DOWN': {'value': 7}},), is_leaf=True, yang_name="local-diagnostic-code", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='bfd-diagnostic-code', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """local_diagnostic_code must be of a type compatible with bfd-diagnostic-code""",
          'defined-type': "openconfig-bfd:bfd-diagnostic-code",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'NO_DIAGNOSTIC': {'value': 0}, 'DETECTION_TIMEOUT': {'value': 1}, 'ECHO_FAILED': {'value': 2}, 'FORWARDING_RESET': {'value': 3}, 'PATH_DOWN': {'value': 4}, 'CONCATENATED_PATH_DOWN': {'value': 5}, 'ADMIN_DOWN': {'value': 6}, 'REVERSE_CONCATENATED_PATH_DOWN': {'value': 7}},), is_leaf=True, yang_name="local-diagnostic-code", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='bfd-diagnostic-code', is_config=False)""",
        })

    self.__local_diagnostic_code = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_local_diagnostic_code(self):
    self.__local_diagnostic_code = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'NO_DIAGNOSTIC': {'value': 0}, 'DETECTION_TIMEOUT': {'value': 1}, 'ECHO_FAILED': {'value': 2}, 'FORWARDING_RESET': {'value': 3}, 'PATH_DOWN': {'value': 4}, 'CONCATENATED_PATH_DOWN': {'value': 5}, 'ADMIN_DOWN': {'value': 6}, 'REVERSE_CONCATENATED_PATH_DOWN': {'value': 7}},), is_leaf=True, yang_name="local-diagnostic-code", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='bfd-diagnostic-code', is_config=False)


  def _get_remote_diagnostic_code(self):
    """
    Getter method for remote_diagnostic_code, mapped from YANG variable /bfd/interfaces/interface/micro_bfd_sessions/micro_bfd_session/state/remote_diagnostic_code (bfd-diagnostic-code)

    YANG Description: The remote BFD diagnostic code indicating the remote system's
reason for failure of the BFD session
    """
    return self.__remote_diagnostic_code
      
  def _set_remote_diagnostic_code(self, v, load=False):
    """
    Setter method for remote_diagnostic_code, mapped from YANG variable /bfd/interfaces/interface/micro_bfd_sessions/micro_bfd_session/state/remote_diagnostic_code (bfd-diagnostic-code)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_remote_diagnostic_code is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_remote_diagnostic_code() directly.

    YANG Description: The remote BFD diagnostic code indicating the remote system's
reason for failure of the BFD session
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'NO_DIAGNOSTIC': {'value': 0}, 'DETECTION_TIMEOUT': {'value': 1}, 'ECHO_FAILED': {'value': 2}, 'FORWARDING_RESET': {'value': 3}, 'PATH_DOWN': {'value': 4}, 'CONCATENATED_PATH_DOWN': {'value': 5}, 'ADMIN_DOWN': {'value': 6}, 'REVERSE_CONCATENATED_PATH_DOWN': {'value': 7}},), is_leaf=True, yang_name="remote-diagnostic-code", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='bfd-diagnostic-code', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """remote_diagnostic_code must be of a type compatible with bfd-diagnostic-code""",
          'defined-type': "openconfig-bfd:bfd-diagnostic-code",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'NO_DIAGNOSTIC': {'value': 0}, 'DETECTION_TIMEOUT': {'value': 1}, 'ECHO_FAILED': {'value': 2}, 'FORWARDING_RESET': {'value': 3}, 'PATH_DOWN': {'value': 4}, 'CONCATENATED_PATH_DOWN': {'value': 5}, 'ADMIN_DOWN': {'value': 6}, 'REVERSE_CONCATENATED_PATH_DOWN': {'value': 7}},), is_leaf=True, yang_name="remote-diagnostic-code", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='bfd-diagnostic-code', is_config=False)""",
        })

    self.__remote_diagnostic_code = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_remote_diagnostic_code(self):
    self.__remote_diagnostic_code = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'NO_DIAGNOSTIC': {'value': 0}, 'DETECTION_TIMEOUT': {'value': 1}, 'ECHO_FAILED': {'value': 2}, 'FORWARDING_RESET': {'value': 3}, 'PATH_DOWN': {'value': 4}, 'CONCATENATED_PATH_DOWN': {'value': 5}, 'ADMIN_DOWN': {'value': 6}, 'REVERSE_CONCATENATED_PATH_DOWN': {'value': 7}},), is_leaf=True, yang_name="remote-diagnostic-code", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='bfd-diagnostic-code', is_config=False)


  def _get_remote_minimum_receive_interval(self):
    """
    Getter method for remote_minimum_receive_interval, mapped from YANG variable /bfd/interfaces/interface/micro_bfd_sessions/micro_bfd_session/state/remote_minimum_receive_interval (uint32)

    YANG Description: The value of the minimum receive interval that was specified
in the most recent BFD control packet received from the peer.
    """
    return self.__remote_minimum_receive_interval
      
  def _set_remote_minimum_receive_interval(self, v, load=False):
    """
    Setter method for remote_minimum_receive_interval, mapped from YANG variable /bfd/interfaces/interface/micro_bfd_sessions/micro_bfd_session/state/remote_minimum_receive_interval (uint32)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_remote_minimum_receive_interval is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_remote_minimum_receive_interval() directly.

    YANG Description: The value of the minimum receive interval that was specified
in the most recent BFD control packet received from the peer.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="remote-minimum-receive-interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='uint32', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """remote_minimum_receive_interval must be of a type compatible with uint32""",
          'defined-type': "uint32",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="remote-minimum-receive-interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='uint32', is_config=False)""",
        })

    self.__remote_minimum_receive_interval = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_remote_minimum_receive_interval(self):
    self.__remote_minimum_receive_interval = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="remote-minimum-receive-interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='uint32', is_config=False)


  def _get_demand_mode_requested(self):
    """
    Getter method for demand_mode_requested, mapped from YANG variable /bfd/interfaces/interface/micro_bfd_sessions/micro_bfd_session/state/demand_mode_requested (boolean)

    YANG Description: This leaf is set to true when the remote system has requested
demand mode be run for this session.
    """
    return self.__demand_mode_requested
      
  def _set_demand_mode_requested(self, v, load=False):
    """
    Setter method for demand_mode_requested, mapped from YANG variable /bfd/interfaces/interface/micro_bfd_sessions/micro_bfd_session/state/demand_mode_requested (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_demand_mode_requested is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_demand_mode_requested() directly.

    YANG Description: This leaf is set to true when the remote system has requested
demand mode be run for this session.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, is_leaf=True, yang_name="demand-mode-requested", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='boolean', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """demand_mode_requested must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, is_leaf=True, yang_name="demand-mode-requested", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='boolean', is_config=False)""",
        })

    self.__demand_mode_requested = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_demand_mode_requested(self):
    self.__demand_mode_requested = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="demand-mode-requested", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='boolean', is_config=False)


  def _get_remote_authentication_enabled(self):
    """
    Getter method for remote_authentication_enabled, mapped from YANG variable /bfd/interfaces/interface/micro_bfd_sessions/micro_bfd_session/state/remote_authentication_enabled (boolean)

    YANG Description: This leaf is set to true when the remote system has specified
that authentication is present for the BFD session.
    """
    return self.__remote_authentication_enabled
      
  def _set_remote_authentication_enabled(self, v, load=False):
    """
    Setter method for remote_authentication_enabled, mapped from YANG variable /bfd/interfaces/interface/micro_bfd_sessions/micro_bfd_session/state/remote_authentication_enabled (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_remote_authentication_enabled is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_remote_authentication_enabled() directly.

    YANG Description: This leaf is set to true when the remote system has specified
that authentication is present for the BFD session.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, is_leaf=True, yang_name="remote-authentication-enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='boolean', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """remote_authentication_enabled must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, is_leaf=True, yang_name="remote-authentication-enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='boolean', is_config=False)""",
        })

    self.__remote_authentication_enabled = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_remote_authentication_enabled(self):
    self.__remote_authentication_enabled = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="remote-authentication-enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='boolean', is_config=False)


  def _get_remote_control_plane_independent(self):
    """
    Getter method for remote_control_plane_independent, mapped from YANG variable /bfd/interfaces/interface/micro_bfd_sessions/micro_bfd_session/state/remote_control_plane_independent (boolean)

    YANG Description: This leaf is set to true when the remote system has specified
that the hardware implementing this BFD session is independent
of the control plane's liveliness.
    """
    return self.__remote_control_plane_independent
      
  def _set_remote_control_plane_independent(self, v, load=False):
    """
    Setter method for remote_control_plane_independent, mapped from YANG variable /bfd/interfaces/interface/micro_bfd_sessions/micro_bfd_session/state/remote_control_plane_independent (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_remote_control_plane_independent is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_remote_control_plane_independent() directly.

    YANG Description: This leaf is set to true when the remote system has specified
that the hardware implementing this BFD session is independent
of the control plane's liveliness.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, is_leaf=True, yang_name="remote-control-plane-independent", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='boolean', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """remote_control_plane_independent must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, is_leaf=True, yang_name="remote-control-plane-independent", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='boolean', is_config=False)""",
        })

    self.__remote_control_plane_independent = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_remote_control_plane_independent(self):
    self.__remote_control_plane_independent = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="remote-control-plane-independent", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='boolean', is_config=False)


  def _get_async(self):
    """
    Getter method for async, mapped from YANG variable /bfd/interfaces/interface/micro_bfd_sessions/micro_bfd_session/state/async (container)

    YANG Description: Operational state parameters specifically relating to
asynchronous mode of BFD.
    """
    return self.__async
      
  def _set_async(self, v, load=False):
    """
    Setter method for async, mapped from YANG variable /bfd/interfaces/interface/micro_bfd_sessions/micro_bfd_session/state/async (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_async is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_async() directly.

    YANG Description: Operational state parameters specifically relating to
asynchronous mode of BFD.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_async_openconfig_bfd__bfd_interfaces_interface_micro_bfd_sessions_micro_bfd_session_state_async, is_container='container', yang_name="async", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """async must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_async_openconfig_bfd__bfd_interfaces_interface_micro_bfd_sessions_micro_bfd_session_state_async, is_container='container', yang_name="async", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='container', is_config=False)""",
        })

    self.__async = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_async(self):
    self.__async = YANGDynClass(base=yc_async_openconfig_bfd__bfd_interfaces_interface_micro_bfd_sessions_micro_bfd_session_state_async, is_container='container', yang_name="async", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='container', is_config=False)

  local_address = __builtin__.property(_get_local_address)
  remote_address = __builtin__.property(_get_remote_address)
  member_interface = __builtin__.property(_get_member_interface)
  session_state = __builtin__.property(_get_session_state)
  remote_session_state = __builtin__.property(_get_remote_session_state)
  last_failure_time = __builtin__.property(_get_last_failure_time)
  failure_transitions = __builtin__.property(_get_failure_transitions)
  local_discriminator = __builtin__.property(_get_local_discriminator)
  remote_discriminator = __builtin__.property(_get_remote_discriminator)
  local_diagnostic_code = __builtin__.property(_get_local_diagnostic_code)
  remote_diagnostic_code = __builtin__.property(_get_remote_diagnostic_code)
  remote_minimum_receive_interval = __builtin__.property(_get_remote_minimum_receive_interval)
  demand_mode_requested = __builtin__.property(_get_demand_mode_requested)
  remote_authentication_enabled = __builtin__.property(_get_remote_authentication_enabled)
  remote_control_plane_independent = __builtin__.property(_get_remote_control_plane_independent)
  async = __builtin__.property(_get_async)


  _pyangbind_elements = OrderedDict([('local_address', local_address), ('remote_address', remote_address), ('member_interface', member_interface), ('session_state', session_state), ('remote_session_state', remote_session_state), ('last_failure_time', last_failure_time), ('failure_transitions', failure_transitions), ('local_discriminator', local_discriminator), ('remote_discriminator', remote_discriminator), ('local_diagnostic_code', local_diagnostic_code), ('remote_diagnostic_code', remote_diagnostic_code), ('remote_minimum_receive_interval', remote_minimum_receive_interval), ('demand_mode_requested', demand_mode_requested), ('remote_authentication_enabled', remote_authentication_enabled), ('remote_control_plane_independent', remote_control_plane_independent), ('async', async), ])


class yc_micro_bfd_session_openconfig_bfd__bfd_interfaces_interface_micro_bfd_sessions_micro_bfd_session(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-bfd - based on the path /bfd/interfaces/interface/micro-bfd-sessions/micro-bfd-session. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: This list contains configuration and state parameters
relating to micro-BFD session.
  """
  __slots__ = ('_path_helper', '_extmethods', '__member_interface','__config','__state',)

  _yang_name = 'micro-bfd-session'
  _yang_namespace = 'http://openconfig.net/yang/bfd'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__member_interface = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="member-interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='leafref', is_config=True)
    self.__config = YANGDynClass(base=yc_config_openconfig_bfd__bfd_interfaces_interface_micro_bfd_sessions_micro_bfd_session_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_bfd__bfd_interfaces_interface_micro_bfd_sessions_micro_bfd_session_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['bfd', 'interfaces', 'interface', 'micro-bfd-sessions', 'micro-bfd-session']

  def _get_member_interface(self):
    """
    Getter method for member_interface, mapped from YANG variable /bfd/interfaces/interface/micro_bfd_sessions/micro_bfd_session/member_interface (leafref)

    YANG Description: A reference to the member interface of the link
aggregate.
    """
    return self.__member_interface
      
  def _set_member_interface(self, v, load=False):
    """
    Setter method for member_interface, mapped from YANG variable /bfd/interfaces/interface/micro_bfd_sessions/micro_bfd_session/member_interface (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_member_interface is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_member_interface() directly.

    YANG Description: A reference to the member interface of the link
aggregate.
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="member-interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """member_interface must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="member-interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='leafref', is_config=True)""",
        })

    self.__member_interface = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_member_interface(self):
    self.__member_interface = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="member-interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='leafref', is_config=True)


  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /bfd/interfaces/interface/micro_bfd_sessions/micro_bfd_session/config (container)

    YANG Description: Configuration parameters for the micro-BFD session.
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /bfd/interfaces/interface/micro_bfd_sessions/micro_bfd_session/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Configuration parameters for the micro-BFD session.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_bfd__bfd_interfaces_interface_micro_bfd_sessions_micro_bfd_session_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_bfd__bfd_interfaces_interface_micro_bfd_sessions_micro_bfd_session_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_bfd__bfd_interfaces_interface_micro_bfd_sessions_micro_bfd_session_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /bfd/interfaces/interface/micro_bfd_sessions/micro_bfd_session/state (container)

    YANG Description: Operational state parameters for the micro-BFD session.
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /bfd/interfaces/interface/micro_bfd_sessions/micro_bfd_session/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: Operational state parameters for the micro-BFD session.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_bfd__bfd_interfaces_interface_micro_bfd_sessions_micro_bfd_session_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_bfd__bfd_interfaces_interface_micro_bfd_sessions_micro_bfd_session_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_bfd__bfd_interfaces_interface_micro_bfd_sessions_micro_bfd_session_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='container', is_config=True)

  member_interface = __builtin__.property(_get_member_interface, _set_member_interface)
  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)


  _pyangbind_elements = OrderedDict([('member_interface', member_interface), ('config', config), ('state', state), ])


class yc_micro_bfd_sessions_openconfig_bfd__bfd_interfaces_interface_micro_bfd_sessions(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-bfd - based on the path /bfd/interfaces/interface/micro-bfd-sessions. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Parameters relating to micro-BFD sessions associated
with the interface.
  """
  __slots__ = ('_path_helper', '_extmethods', '__micro_bfd_session',)

  _yang_name = 'micro-bfd-sessions'
  _yang_namespace = 'http://openconfig.net/yang/bfd'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__micro_bfd_session = YANGDynClass(base=YANGListType("member_interface",yc_micro_bfd_session_openconfig_bfd__bfd_interfaces_interface_micro_bfd_sessions_micro_bfd_session, yang_name="micro-bfd-session", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='member-interface', extensions=None), is_container='list', yang_name="micro-bfd-session", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='list', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['bfd', 'interfaces', 'interface', 'micro-bfd-sessions']

  def _get_micro_bfd_session(self):
    """
    Getter method for micro_bfd_session, mapped from YANG variable /bfd/interfaces/interface/micro_bfd_sessions/micro_bfd_session (list)

    YANG Description: This list contains configuration and state parameters
relating to micro-BFD session.
    """
    return self.__micro_bfd_session
      
  def _set_micro_bfd_session(self, v, load=False):
    """
    Setter method for micro_bfd_session, mapped from YANG variable /bfd/interfaces/interface/micro_bfd_sessions/micro_bfd_session (list)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_micro_bfd_session is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_micro_bfd_session() directly.

    YANG Description: This list contains configuration and state parameters
relating to micro-BFD session.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGListType("member_interface",yc_micro_bfd_session_openconfig_bfd__bfd_interfaces_interface_micro_bfd_sessions_micro_bfd_session, yang_name="micro-bfd-session", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='member-interface', extensions=None), is_container='list', yang_name="micro-bfd-session", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='list', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """micro_bfd_session must be of a type compatible with list""",
          'defined-type': "list",
          'generated-type': """YANGDynClass(base=YANGListType("member_interface",yc_micro_bfd_session_openconfig_bfd__bfd_interfaces_interface_micro_bfd_sessions_micro_bfd_session, yang_name="micro-bfd-session", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='member-interface', extensions=None), is_container='list', yang_name="micro-bfd-session", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='list', is_config=True)""",
        })

    self.__micro_bfd_session = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_micro_bfd_session(self):
    self.__micro_bfd_session = YANGDynClass(base=YANGListType("member_interface",yc_micro_bfd_session_openconfig_bfd__bfd_interfaces_interface_micro_bfd_sessions_micro_bfd_session, yang_name="micro-bfd-session", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='member-interface', extensions=None), is_container='list', yang_name="micro-bfd-session", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='list', is_config=True)

  micro_bfd_session = __builtin__.property(_get_micro_bfd_session, _set_micro_bfd_session)


  _pyangbind_elements = OrderedDict([('micro_bfd_session', micro_bfd_session), ])


class yc_echo_openconfig_bfd__bfd_interfaces_interface_peers_peer_state_echo(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-bfd - based on the path /bfd/interfaces/interface/peers/peer/state/echo. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational state parameters specifically relating to the
echo mode of BFD.
  """
  __slots__ = ('_path_helper', '_extmethods', '__active','__last_packet_transmitted','__last_packet_received','__transmitted_packets','__received_packets','__up_transitions',)

  _yang_name = 'echo'
  _yang_namespace = 'http://openconfig.net/yang/bfd'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__active = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="active", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='boolean', is_config=False)
    self.__last_packet_transmitted = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="last-packet-transmitted", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='uint64', is_config=False)
    self.__last_packet_received = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="last-packet-received", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='uint64', is_config=False)
    self.__transmitted_packets = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="transmitted-packets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='uint64', is_config=False)
    self.__received_packets = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="received-packets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='uint64', is_config=False)
    self.__up_transitions = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="up-transitions", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='uint64', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['bfd', 'interfaces', 'interface', 'peers', 'peer', 'state', 'echo']

  def _get_active(self):
    """
    Getter method for active, mapped from YANG variable /bfd/interfaces/interface/peers/peer/state/echo/active (boolean)

    YANG Description: This leaf is set to true when echo mode is running between
the local and remote system. When it is set to false, solely
asynchronous mode is active.
    """
    return self.__active
      
  def _set_active(self, v, load=False):
    """
    Setter method for active, mapped from YANG variable /bfd/interfaces/interface/peers/peer/state/echo/active (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_active is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_active() directly.

    YANG Description: This leaf is set to true when echo mode is running between
the local and remote system. When it is set to false, solely
asynchronous mode is active.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, is_leaf=True, yang_name="active", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='boolean', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """active must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, is_leaf=True, yang_name="active", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='boolean', is_config=False)""",
        })

    self.__active = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_active(self):
    self.__active = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="active", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='boolean', is_config=False)


  def _get_last_packet_transmitted(self):
    """
    Getter method for last_packet_transmitted, mapped from YANG variable /bfd/interfaces/interface/peers/peer/state/echo/last_packet_transmitted (uint64)

    YANG Description: The date and time at which the last BFD packet
was transmitted for this session, expressed as the number
of nanoseconds since the Unix Epoch (January 1, 1970,
00:00 UTC).
    """
    return self.__last_packet_transmitted
      
  def _set_last_packet_transmitted(self, v, load=False):
    """
    Setter method for last_packet_transmitted, mapped from YANG variable /bfd/interfaces/interface/peers/peer/state/echo/last_packet_transmitted (uint64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_last_packet_transmitted is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_last_packet_transmitted() directly.

    YANG Description: The date and time at which the last BFD packet
was transmitted for this session, expressed as the number
of nanoseconds since the Unix Epoch (January 1, 1970,
00:00 UTC).
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="last-packet-transmitted", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='uint64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """last_packet_transmitted must be of a type compatible with uint64""",
          'defined-type': "uint64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="last-packet-transmitted", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='uint64', is_config=False)""",
        })

    self.__last_packet_transmitted = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_last_packet_transmitted(self):
    self.__last_packet_transmitted = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="last-packet-transmitted", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='uint64', is_config=False)


  def _get_last_packet_received(self):
    """
    Getter method for last_packet_received, mapped from YANG variable /bfd/interfaces/interface/peers/peer/state/echo/last_packet_received (uint64)

    YANG Description: The date and time at which the last BFD packet
was received for this session, expressed as the number
of nanoseconds since the Unix Epoch (January 1, 1970,
00:00 UTC).
    """
    return self.__last_packet_received
      
  def _set_last_packet_received(self, v, load=False):
    """
    Setter method for last_packet_received, mapped from YANG variable /bfd/interfaces/interface/peers/peer/state/echo/last_packet_received (uint64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_last_packet_received is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_last_packet_received() directly.

    YANG Description: The date and time at which the last BFD packet
was received for this session, expressed as the number
of nanoseconds since the Unix Epoch (January 1, 1970,
00:00 UTC).
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="last-packet-received", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='uint64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """last_packet_received must be of a type compatible with uint64""",
          'defined-type': "uint64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="last-packet-received", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='uint64', is_config=False)""",
        })

    self.__last_packet_received = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_last_packet_received(self):
    self.__last_packet_received = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="last-packet-received", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='uint64', is_config=False)


  def _get_transmitted_packets(self):
    """
    Getter method for transmitted_packets, mapped from YANG variable /bfd/interfaces/interface/peers/peer/state/echo/transmitted_packets (uint64)

    YANG Description: The number of packets that have been transmitted
by the local system.
    """
    return self.__transmitted_packets
      
  def _set_transmitted_packets(self, v, load=False):
    """
    Setter method for transmitted_packets, mapped from YANG variable /bfd/interfaces/interface/peers/peer/state/echo/transmitted_packets (uint64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_transmitted_packets is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_transmitted_packets() directly.

    YANG Description: The number of packets that have been transmitted
by the local system.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="transmitted-packets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='uint64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """transmitted_packets must be of a type compatible with uint64""",
          'defined-type': "uint64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="transmitted-packets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='uint64', is_config=False)""",
        })

    self.__transmitted_packets = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_transmitted_packets(self):
    self.__transmitted_packets = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="transmitted-packets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='uint64', is_config=False)


  def _get_received_packets(self):
    """
    Getter method for received_packets, mapped from YANG variable /bfd/interfaces/interface/peers/peer/state/echo/received_packets (uint64)

    YANG Description: The number of packets that have been received by the
local system from the remote neighbour.
    """
    return self.__received_packets
      
  def _set_received_packets(self, v, load=False):
    """
    Setter method for received_packets, mapped from YANG variable /bfd/interfaces/interface/peers/peer/state/echo/received_packets (uint64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_received_packets is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_received_packets() directly.

    YANG Description: The number of packets that have been received by the
local system from the remote neighbour.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="received-packets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='uint64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """received_packets must be of a type compatible with uint64""",
          'defined-type': "uint64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="received-packets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='uint64', is_config=False)""",
        })

    self.__received_packets = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_received_packets(self):
    self.__received_packets = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="received-packets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='uint64', is_config=False)


  def _get_up_transitions(self):
    """
    Getter method for up_transitions, mapped from YANG variable /bfd/interfaces/interface/peers/peer/state/echo/up_transitions (uint64)

    YANG Description: The number of times that the adjacency with the neighbor
has transitioned into the up state.
    """
    return self.__up_transitions
      
  def _set_up_transitions(self, v, load=False):
    """
    Setter method for up_transitions, mapped from YANG variable /bfd/interfaces/interface/peers/peer/state/echo/up_transitions (uint64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_up_transitions is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_up_transitions() directly.

    YANG Description: The number of times that the adjacency with the neighbor
has transitioned into the up state.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="up-transitions", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='uint64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """up_transitions must be of a type compatible with uint64""",
          'defined-type': "uint64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="up-transitions", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='uint64', is_config=False)""",
        })

    self.__up_transitions = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_up_transitions(self):
    self.__up_transitions = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="up-transitions", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='uint64', is_config=False)

  active = __builtin__.property(_get_active)
  last_packet_transmitted = __builtin__.property(_get_last_packet_transmitted)
  last_packet_received = __builtin__.property(_get_last_packet_received)
  transmitted_packets = __builtin__.property(_get_transmitted_packets)
  received_packets = __builtin__.property(_get_received_packets)
  up_transitions = __builtin__.property(_get_up_transitions)


  _pyangbind_elements = OrderedDict([('active', active), ('last_packet_transmitted', last_packet_transmitted), ('last_packet_received', last_packet_received), ('transmitted_packets', transmitted_packets), ('received_packets', received_packets), ('up_transitions', up_transitions), ])


class yc_async_openconfig_bfd__bfd_interfaces_interface_peers_peer_state_async(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-bfd - based on the path /bfd/interfaces/interface/peers/peer/state/async. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational state parameters specifically relating to
asynchronous mode of BFD.
  """
  __slots__ = ('_path_helper', '_extmethods', '__last_packet_transmitted','__last_packet_received','__transmitted_packets','__received_packets','__up_transitions',)

  _yang_name = 'async'
  _yang_namespace = 'http://openconfig.net/yang/bfd'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__last_packet_transmitted = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="last-packet-transmitted", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='uint64', is_config=False)
    self.__last_packet_received = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="last-packet-received", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='uint64', is_config=False)
    self.__transmitted_packets = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="transmitted-packets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='uint64', is_config=False)
    self.__received_packets = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="received-packets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='uint64', is_config=False)
    self.__up_transitions = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="up-transitions", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='uint64', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['bfd', 'interfaces', 'interface', 'peers', 'peer', 'state', 'async']

  def _get_last_packet_transmitted(self):
    """
    Getter method for last_packet_transmitted, mapped from YANG variable /bfd/interfaces/interface/peers/peer/state/async/last_packet_transmitted (uint64)

    YANG Description: The date and time at which the last BFD packet
was transmitted for this session, expressed as the number
of nanoseconds since the Unix Epoch (January 1, 1970,
00:00 UTC).
    """
    return self.__last_packet_transmitted
      
  def _set_last_packet_transmitted(self, v, load=False):
    """
    Setter method for last_packet_transmitted, mapped from YANG variable /bfd/interfaces/interface/peers/peer/state/async/last_packet_transmitted (uint64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_last_packet_transmitted is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_last_packet_transmitted() directly.

    YANG Description: The date and time at which the last BFD packet
was transmitted for this session, expressed as the number
of nanoseconds since the Unix Epoch (January 1, 1970,
00:00 UTC).
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="last-packet-transmitted", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='uint64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """last_packet_transmitted must be of a type compatible with uint64""",
          'defined-type': "uint64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="last-packet-transmitted", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='uint64', is_config=False)""",
        })

    self.__last_packet_transmitted = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_last_packet_transmitted(self):
    self.__last_packet_transmitted = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="last-packet-transmitted", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='uint64', is_config=False)


  def _get_last_packet_received(self):
    """
    Getter method for last_packet_received, mapped from YANG variable /bfd/interfaces/interface/peers/peer/state/async/last_packet_received (uint64)

    YANG Description: The date and time at which the last BFD packet
was received for this session, expressed as the number
of nanoseconds since the Unix Epoch (January 1, 1970,
00:00 UTC).
    """
    return self.__last_packet_received
      
  def _set_last_packet_received(self, v, load=False):
    """
    Setter method for last_packet_received, mapped from YANG variable /bfd/interfaces/interface/peers/peer/state/async/last_packet_received (uint64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_last_packet_received is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_last_packet_received() directly.

    YANG Description: The date and time at which the last BFD packet
was received for this session, expressed as the number
of nanoseconds since the Unix Epoch (January 1, 1970,
00:00 UTC).
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="last-packet-received", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='uint64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """last_packet_received must be of a type compatible with uint64""",
          'defined-type': "uint64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="last-packet-received", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='uint64', is_config=False)""",
        })

    self.__last_packet_received = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_last_packet_received(self):
    self.__last_packet_received = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="last-packet-received", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='uint64', is_config=False)


  def _get_transmitted_packets(self):
    """
    Getter method for transmitted_packets, mapped from YANG variable /bfd/interfaces/interface/peers/peer/state/async/transmitted_packets (uint64)

    YANG Description: The number of packets that have been transmitted
by the local system.
    """
    return self.__transmitted_packets
      
  def _set_transmitted_packets(self, v, load=False):
    """
    Setter method for transmitted_packets, mapped from YANG variable /bfd/interfaces/interface/peers/peer/state/async/transmitted_packets (uint64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_transmitted_packets is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_transmitted_packets() directly.

    YANG Description: The number of packets that have been transmitted
by the local system.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="transmitted-packets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='uint64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """transmitted_packets must be of a type compatible with uint64""",
          'defined-type': "uint64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="transmitted-packets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='uint64', is_config=False)""",
        })

    self.__transmitted_packets = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_transmitted_packets(self):
    self.__transmitted_packets = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="transmitted-packets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='uint64', is_config=False)


  def _get_received_packets(self):
    """
    Getter method for received_packets, mapped from YANG variable /bfd/interfaces/interface/peers/peer/state/async/received_packets (uint64)

    YANG Description: The number of packets that have been received by the
local system from the remote neighbour.
    """
    return self.__received_packets
      
  def _set_received_packets(self, v, load=False):
    """
    Setter method for received_packets, mapped from YANG variable /bfd/interfaces/interface/peers/peer/state/async/received_packets (uint64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_received_packets is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_received_packets() directly.

    YANG Description: The number of packets that have been received by the
local system from the remote neighbour.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="received-packets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='uint64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """received_packets must be of a type compatible with uint64""",
          'defined-type': "uint64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="received-packets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='uint64', is_config=False)""",
        })

    self.__received_packets = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_received_packets(self):
    self.__received_packets = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="received-packets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='uint64', is_config=False)


  def _get_up_transitions(self):
    """
    Getter method for up_transitions, mapped from YANG variable /bfd/interfaces/interface/peers/peer/state/async/up_transitions (uint64)

    YANG Description: The number of times that the adjacency with the neighbor
has transitioned into the up state.
    """
    return self.__up_transitions
      
  def _set_up_transitions(self, v, load=False):
    """
    Setter method for up_transitions, mapped from YANG variable /bfd/interfaces/interface/peers/peer/state/async/up_transitions (uint64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_up_transitions is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_up_transitions() directly.

    YANG Description: The number of times that the adjacency with the neighbor
has transitioned into the up state.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="up-transitions", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='uint64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """up_transitions must be of a type compatible with uint64""",
          'defined-type': "uint64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="up-transitions", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='uint64', is_config=False)""",
        })

    self.__up_transitions = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_up_transitions(self):
    self.__up_transitions = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="up-transitions", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='uint64', is_config=False)

  last_packet_transmitted = __builtin__.property(_get_last_packet_transmitted)
  last_packet_received = __builtin__.property(_get_last_packet_received)
  transmitted_packets = __builtin__.property(_get_transmitted_packets)
  received_packets = __builtin__.property(_get_received_packets)
  up_transitions = __builtin__.property(_get_up_transitions)


  _pyangbind_elements = OrderedDict([('last_packet_transmitted', last_packet_transmitted), ('last_packet_received', last_packet_received), ('transmitted_packets', transmitted_packets), ('received_packets', received_packets), ('up_transitions', up_transitions), ])


class yc_state_openconfig_bfd__bfd_interfaces_interface_peers_peer_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-bfd - based on the path /bfd/interfaces/interface/peers/peer/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational state parameters for the BFD session.
  """
  __slots__ = ('_path_helper', '_extmethods', '__local_address','__remote_address','__subscribed_protocols','__session_state','__remote_session_state','__last_failure_time','__failure_transitions','__local_discriminator','__remote_discriminator','__local_diagnostic_code','__remote_diagnostic_code','__remote_minimum_receive_interval','__demand_mode_requested','__remote_authentication_enabled','__remote_control_plane_independent','__echo','__async',)

  _yang_name = 'state'
  _yang_namespace = 'http://openconfig.net/yang/bfd'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__local_address = YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}),], is_leaf=True, yang_name="local-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='oc-inet:ip-address', is_config=False)
    self.__remote_address = YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}),], is_leaf=True, yang_name="remote-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='oc-inet:ip-address', is_config=False)
    self.__subscribed_protocols = YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'BGP': {'@module': 'openconfig-policy-types', '@namespace': 'http://openconfig.net/yang/policy-types'}, 'oc-pol-types:BGP': {'@module': 'openconfig-policy-types', '@namespace': 'http://openconfig.net/yang/policy-types'}, 'ISIS': {'@module': 'openconfig-policy-types', '@namespace': 'http://openconfig.net/yang/policy-types'}, 'oc-pol-types:ISIS': {'@module': 'openconfig-policy-types', '@namespace': 'http://openconfig.net/yang/policy-types'}, 'OSPF': {'@module': 'openconfig-policy-types', '@namespace': 'http://openconfig.net/yang/policy-types'}, 'oc-pol-types:OSPF': {'@module': 'openconfig-policy-types', '@namespace': 'http://openconfig.net/yang/policy-types'}, 'OSPF3': {'@module': 'openconfig-policy-types', '@namespace': 'http://openconfig.net/yang/policy-types'}, 'oc-pol-types:OSPF3': {'@module': 'openconfig-policy-types', '@namespace': 'http://openconfig.net/yang/policy-types'}, 'STATIC': {'@module': 'openconfig-policy-types', '@namespace': 'http://openconfig.net/yang/policy-types'}, 'oc-pol-types:STATIC': {'@module': 'openconfig-policy-types', '@namespace': 'http://openconfig.net/yang/policy-types'}, 'DIRECTLY_CONNECTED': {'@module': 'openconfig-policy-types', '@namespace': 'http://openconfig.net/yang/policy-types'}, 'oc-pol-types:DIRECTLY_CONNECTED': {'@module': 'openconfig-policy-types', '@namespace': 'http://openconfig.net/yang/policy-types'}, 'LOCAL_AGGREGATE': {'@module': 'openconfig-policy-types', '@namespace': 'http://openconfig.net/yang/policy-types'}, 'oc-pol-types:LOCAL_AGGREGATE': {'@module': 'openconfig-policy-types', '@namespace': 'http://openconfig.net/yang/policy-types'}, 'PIM': {'@module': 'openconfig-policy-types', '@namespace': 'http://openconfig.net/yang/policy-types'}, 'oc-pol-types:PIM': {'@module': 'openconfig-policy-types', '@namespace': 'http://openconfig.net/yang/policy-types'}, 'IGMP': {'@module': 'openconfig-policy-types', '@namespace': 'http://openconfig.net/yang/policy-types'}, 'oc-pol-types:IGMP': {'@module': 'openconfig-policy-types', '@namespace': 'http://openconfig.net/yang/policy-types'}, 'GRIBI': {'@module': 'openconfig-policy-types', '@namespace': 'http://openconfig.net/yang/policy-types'}, 'oc-pol-types:GRIBI': {'@module': 'openconfig-policy-types', '@namespace': 'http://openconfig.net/yang/policy-types'}, 'PCEP': {'@module': 'openconfig-policy-types', '@namespace': 'http://openconfig.net/yang/policy-types'}, 'oc-pol-types:PCEP': {'@module': 'openconfig-policy-types', '@namespace': 'http://openconfig.net/yang/policy-types'}, 'LOCAL': {'@module': 'openconfig-policy-types', '@namespace': 'http://openconfig.net/yang/policy-types'}, 'oc-pol-types:LOCAL': {'@module': 'openconfig-policy-types', '@namespace': 'http://openconfig.net/yang/policy-types'}},)), is_leaf=False, yang_name="subscribed-protocols", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='identityref', is_config=False)
    self.__session_state = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'UP': {}, 'DOWN': {}, 'ADMIN_DOWN': {}, 'INIT': {}},), is_leaf=True, yang_name="session-state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='bfd-session-state', is_config=False)
    self.__remote_session_state = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'UP': {}, 'DOWN': {}, 'ADMIN_DOWN': {}, 'INIT': {}},), is_leaf=True, yang_name="remote-session-state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='bfd-session-state', is_config=False)
    self.__last_failure_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="last-failure-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='oc-types:timeticks64', is_config=False)
    self.__failure_transitions = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="failure-transitions", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='uint64', is_config=False)
    self.__local_discriminator = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="local-discriminator", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='string', is_config=False)
    self.__remote_discriminator = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="remote-discriminator", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='string', is_config=False)
    self.__local_diagnostic_code = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'NO_DIAGNOSTIC': {'value': 0}, 'DETECTION_TIMEOUT': {'value': 1}, 'ECHO_FAILED': {'value': 2}, 'FORWARDING_RESET': {'value': 3}, 'PATH_DOWN': {'value': 4}, 'CONCATENATED_PATH_DOWN': {'value': 5}, 'ADMIN_DOWN': {'value': 6}, 'REVERSE_CONCATENATED_PATH_DOWN': {'value': 7}},), is_leaf=True, yang_name="local-diagnostic-code", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='bfd-diagnostic-code', is_config=False)
    self.__remote_diagnostic_code = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'NO_DIAGNOSTIC': {'value': 0}, 'DETECTION_TIMEOUT': {'value': 1}, 'ECHO_FAILED': {'value': 2}, 'FORWARDING_RESET': {'value': 3}, 'PATH_DOWN': {'value': 4}, 'CONCATENATED_PATH_DOWN': {'value': 5}, 'ADMIN_DOWN': {'value': 6}, 'REVERSE_CONCATENATED_PATH_DOWN': {'value': 7}},), is_leaf=True, yang_name="remote-diagnostic-code", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='bfd-diagnostic-code', is_config=False)
    self.__remote_minimum_receive_interval = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="remote-minimum-receive-interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='uint32', is_config=False)
    self.__demand_mode_requested = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="demand-mode-requested", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='boolean', is_config=False)
    self.__remote_authentication_enabled = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="remote-authentication-enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='boolean', is_config=False)
    self.__remote_control_plane_independent = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="remote-control-plane-independent", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='boolean', is_config=False)
    self.__echo = YANGDynClass(base=yc_echo_openconfig_bfd__bfd_interfaces_interface_peers_peer_state_echo, is_container='container', yang_name="echo", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='container', is_config=False)
    self.__async = YANGDynClass(base=yc_async_openconfig_bfd__bfd_interfaces_interface_peers_peer_state_async, is_container='container', yang_name="async", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='container', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['bfd', 'interfaces', 'interface', 'peers', 'peer', 'state']

  def _get_local_address(self):
    """
    Getter method for local_address, mapped from YANG variable /bfd/interfaces/interface/peers/peer/state/local_address (oc-inet:ip-address)

    YANG Description: The IP address used by the local system for this BFD session.
    """
    return self.__local_address
      
  def _set_local_address(self, v, load=False):
    """
    Setter method for local_address, mapped from YANG variable /bfd/interfaces/interface/peers/peer/state/local_address (oc-inet:ip-address)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_local_address is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_local_address() directly.

    YANG Description: The IP address used by the local system for this BFD session.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}),], is_leaf=True, yang_name="local-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='oc-inet:ip-address', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """local_address must be of a type compatible with oc-inet:ip-address""",
          'defined-type': "oc-inet:ip-address",
          'generated-type': """YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}),], is_leaf=True, yang_name="local-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='oc-inet:ip-address', is_config=False)""",
        })

    self.__local_address = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_local_address(self):
    self.__local_address = YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}),], is_leaf=True, yang_name="local-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='oc-inet:ip-address', is_config=False)


  def _get_remote_address(self):
    """
    Getter method for remote_address, mapped from YANG variable /bfd/interfaces/interface/peers/peer/state/remote_address (oc-inet:ip-address)

    YANG Description: The IP address used by the remote system for this BFD session.
    """
    return self.__remote_address
      
  def _set_remote_address(self, v, load=False):
    """
    Setter method for remote_address, mapped from YANG variable /bfd/interfaces/interface/peers/peer/state/remote_address (oc-inet:ip-address)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_remote_address is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_remote_address() directly.

    YANG Description: The IP address used by the remote system for this BFD session.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}),], is_leaf=True, yang_name="remote-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='oc-inet:ip-address', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """remote_address must be of a type compatible with oc-inet:ip-address""",
          'defined-type': "oc-inet:ip-address",
          'generated-type': """YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}),], is_leaf=True, yang_name="remote-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='oc-inet:ip-address', is_config=False)""",
        })

    self.__remote_address = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_remote_address(self):
    self.__remote_address = YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}),], is_leaf=True, yang_name="remote-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='oc-inet:ip-address', is_config=False)


  def _get_subscribed_protocols(self):
    """
    Getter method for subscribed_protocols, mapped from YANG variable /bfd/interfaces/interface/peers/peer/state/subscribed_protocols (identityref)

    YANG Description: Indicates the set of protocols that currently use
this BFD session for liveliness detection.
    """
    return self.__subscribed_protocols
      
  def _set_subscribed_protocols(self, v, load=False):
    """
    Setter method for subscribed_protocols, mapped from YANG variable /bfd/interfaces/interface/peers/peer/state/subscribed_protocols (identityref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_subscribed_protocols is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_subscribed_protocols() directly.

    YANG Description: Indicates the set of protocols that currently use
this BFD session for liveliness detection.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'BGP': {'@module': 'openconfig-policy-types', '@namespace': 'http://openconfig.net/yang/policy-types'}, 'oc-pol-types:BGP': {'@module': 'openconfig-policy-types', '@namespace': 'http://openconfig.net/yang/policy-types'}, 'ISIS': {'@module': 'openconfig-policy-types', '@namespace': 'http://openconfig.net/yang/policy-types'}, 'oc-pol-types:ISIS': {'@module': 'openconfig-policy-types', '@namespace': 'http://openconfig.net/yang/policy-types'}, 'OSPF': {'@module': 'openconfig-policy-types', '@namespace': 'http://openconfig.net/yang/policy-types'}, 'oc-pol-types:OSPF': {'@module': 'openconfig-policy-types', '@namespace': 'http://openconfig.net/yang/policy-types'}, 'OSPF3': {'@module': 'openconfig-policy-types', '@namespace': 'http://openconfig.net/yang/policy-types'}, 'oc-pol-types:OSPF3': {'@module': 'openconfig-policy-types', '@namespace': 'http://openconfig.net/yang/policy-types'}, 'STATIC': {'@module': 'openconfig-policy-types', '@namespace': 'http://openconfig.net/yang/policy-types'}, 'oc-pol-types:STATIC': {'@module': 'openconfig-policy-types', '@namespace': 'http://openconfig.net/yang/policy-types'}, 'DIRECTLY_CONNECTED': {'@module': 'openconfig-policy-types', '@namespace': 'http://openconfig.net/yang/policy-types'}, 'oc-pol-types:DIRECTLY_CONNECTED': {'@module': 'openconfig-policy-types', '@namespace': 'http://openconfig.net/yang/policy-types'}, 'LOCAL_AGGREGATE': {'@module': 'openconfig-policy-types', '@namespace': 'http://openconfig.net/yang/policy-types'}, 'oc-pol-types:LOCAL_AGGREGATE': {'@module': 'openconfig-policy-types', '@namespace': 'http://openconfig.net/yang/policy-types'}, 'PIM': {'@module': 'openconfig-policy-types', '@namespace': 'http://openconfig.net/yang/policy-types'}, 'oc-pol-types:PIM': {'@module': 'openconfig-policy-types', '@namespace': 'http://openconfig.net/yang/policy-types'}, 'IGMP': {'@module': 'openconfig-policy-types', '@namespace': 'http://openconfig.net/yang/policy-types'}, 'oc-pol-types:IGMP': {'@module': 'openconfig-policy-types', '@namespace': 'http://openconfig.net/yang/policy-types'}, 'GRIBI': {'@module': 'openconfig-policy-types', '@namespace': 'http://openconfig.net/yang/policy-types'}, 'oc-pol-types:GRIBI': {'@module': 'openconfig-policy-types', '@namespace': 'http://openconfig.net/yang/policy-types'}, 'PCEP': {'@module': 'openconfig-policy-types', '@namespace': 'http://openconfig.net/yang/policy-types'}, 'oc-pol-types:PCEP': {'@module': 'openconfig-policy-types', '@namespace': 'http://openconfig.net/yang/policy-types'}, 'LOCAL': {'@module': 'openconfig-policy-types', '@namespace': 'http://openconfig.net/yang/policy-types'}, 'oc-pol-types:LOCAL': {'@module': 'openconfig-policy-types', '@namespace': 'http://openconfig.net/yang/policy-types'}},)), is_leaf=False, yang_name="subscribed-protocols", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='identityref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """subscribed_protocols must be of a type compatible with identityref""",
          'defined-type': "openconfig-bfd:identityref",
          'generated-type': """YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'BGP': {'@module': 'openconfig-policy-types', '@namespace': 'http://openconfig.net/yang/policy-types'}, 'oc-pol-types:BGP': {'@module': 'openconfig-policy-types', '@namespace': 'http://openconfig.net/yang/policy-types'}, 'ISIS': {'@module': 'openconfig-policy-types', '@namespace': 'http://openconfig.net/yang/policy-types'}, 'oc-pol-types:ISIS': {'@module': 'openconfig-policy-types', '@namespace': 'http://openconfig.net/yang/policy-types'}, 'OSPF': {'@module': 'openconfig-policy-types', '@namespace': 'http://openconfig.net/yang/policy-types'}, 'oc-pol-types:OSPF': {'@module': 'openconfig-policy-types', '@namespace': 'http://openconfig.net/yang/policy-types'}, 'OSPF3': {'@module': 'openconfig-policy-types', '@namespace': 'http://openconfig.net/yang/policy-types'}, 'oc-pol-types:OSPF3': {'@module': 'openconfig-policy-types', '@namespace': 'http://openconfig.net/yang/policy-types'}, 'STATIC': {'@module': 'openconfig-policy-types', '@namespace': 'http://openconfig.net/yang/policy-types'}, 'oc-pol-types:STATIC': {'@module': 'openconfig-policy-types', '@namespace': 'http://openconfig.net/yang/policy-types'}, 'DIRECTLY_CONNECTED': {'@module': 'openconfig-policy-types', '@namespace': 'http://openconfig.net/yang/policy-types'}, 'oc-pol-types:DIRECTLY_CONNECTED': {'@module': 'openconfig-policy-types', '@namespace': 'http://openconfig.net/yang/policy-types'}, 'LOCAL_AGGREGATE': {'@module': 'openconfig-policy-types', '@namespace': 'http://openconfig.net/yang/policy-types'}, 'oc-pol-types:LOCAL_AGGREGATE': {'@module': 'openconfig-policy-types', '@namespace': 'http://openconfig.net/yang/policy-types'}, 'PIM': {'@module': 'openconfig-policy-types', '@namespace': 'http://openconfig.net/yang/policy-types'}, 'oc-pol-types:PIM': {'@module': 'openconfig-policy-types', '@namespace': 'http://openconfig.net/yang/policy-types'}, 'IGMP': {'@module': 'openconfig-policy-types', '@namespace': 'http://openconfig.net/yang/policy-types'}, 'oc-pol-types:IGMP': {'@module': 'openconfig-policy-types', '@namespace': 'http://openconfig.net/yang/policy-types'}, 'GRIBI': {'@module': 'openconfig-policy-types', '@namespace': 'http://openconfig.net/yang/policy-types'}, 'oc-pol-types:GRIBI': {'@module': 'openconfig-policy-types', '@namespace': 'http://openconfig.net/yang/policy-types'}, 'PCEP': {'@module': 'openconfig-policy-types', '@namespace': 'http://openconfig.net/yang/policy-types'}, 'oc-pol-types:PCEP': {'@module': 'openconfig-policy-types', '@namespace': 'http://openconfig.net/yang/policy-types'}, 'LOCAL': {'@module': 'openconfig-policy-types', '@namespace': 'http://openconfig.net/yang/policy-types'}, 'oc-pol-types:LOCAL': {'@module': 'openconfig-policy-types', '@namespace': 'http://openconfig.net/yang/policy-types'}},)), is_leaf=False, yang_name="subscribed-protocols", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='identityref', is_config=False)""",
        })

    self.__subscribed_protocols = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_subscribed_protocols(self):
    self.__subscribed_protocols = YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'BGP': {'@module': 'openconfig-policy-types', '@namespace': 'http://openconfig.net/yang/policy-types'}, 'oc-pol-types:BGP': {'@module': 'openconfig-policy-types', '@namespace': 'http://openconfig.net/yang/policy-types'}, 'ISIS': {'@module': 'openconfig-policy-types', '@namespace': 'http://openconfig.net/yang/policy-types'}, 'oc-pol-types:ISIS': {'@module': 'openconfig-policy-types', '@namespace': 'http://openconfig.net/yang/policy-types'}, 'OSPF': {'@module': 'openconfig-policy-types', '@namespace': 'http://openconfig.net/yang/policy-types'}, 'oc-pol-types:OSPF': {'@module': 'openconfig-policy-types', '@namespace': 'http://openconfig.net/yang/policy-types'}, 'OSPF3': {'@module': 'openconfig-policy-types', '@namespace': 'http://openconfig.net/yang/policy-types'}, 'oc-pol-types:OSPF3': {'@module': 'openconfig-policy-types', '@namespace': 'http://openconfig.net/yang/policy-types'}, 'STATIC': {'@module': 'openconfig-policy-types', '@namespace': 'http://openconfig.net/yang/policy-types'}, 'oc-pol-types:STATIC': {'@module': 'openconfig-policy-types', '@namespace': 'http://openconfig.net/yang/policy-types'}, 'DIRECTLY_CONNECTED': {'@module': 'openconfig-policy-types', '@namespace': 'http://openconfig.net/yang/policy-types'}, 'oc-pol-types:DIRECTLY_CONNECTED': {'@module': 'openconfig-policy-types', '@namespace': 'http://openconfig.net/yang/policy-types'}, 'LOCAL_AGGREGATE': {'@module': 'openconfig-policy-types', '@namespace': 'http://openconfig.net/yang/policy-types'}, 'oc-pol-types:LOCAL_AGGREGATE': {'@module': 'openconfig-policy-types', '@namespace': 'http://openconfig.net/yang/policy-types'}, 'PIM': {'@module': 'openconfig-policy-types', '@namespace': 'http://openconfig.net/yang/policy-types'}, 'oc-pol-types:PIM': {'@module': 'openconfig-policy-types', '@namespace': 'http://openconfig.net/yang/policy-types'}, 'IGMP': {'@module': 'openconfig-policy-types', '@namespace': 'http://openconfig.net/yang/policy-types'}, 'oc-pol-types:IGMP': {'@module': 'openconfig-policy-types', '@namespace': 'http://openconfig.net/yang/policy-types'}, 'GRIBI': {'@module': 'openconfig-policy-types', '@namespace': 'http://openconfig.net/yang/policy-types'}, 'oc-pol-types:GRIBI': {'@module': 'openconfig-policy-types', '@namespace': 'http://openconfig.net/yang/policy-types'}, 'PCEP': {'@module': 'openconfig-policy-types', '@namespace': 'http://openconfig.net/yang/policy-types'}, 'oc-pol-types:PCEP': {'@module': 'openconfig-policy-types', '@namespace': 'http://openconfig.net/yang/policy-types'}, 'LOCAL': {'@module': 'openconfig-policy-types', '@namespace': 'http://openconfig.net/yang/policy-types'}, 'oc-pol-types:LOCAL': {'@module': 'openconfig-policy-types', '@namespace': 'http://openconfig.net/yang/policy-types'}},)), is_leaf=False, yang_name="subscribed-protocols", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='identityref', is_config=False)


  def _get_session_state(self):
    """
    Getter method for session_state, mapped from YANG variable /bfd/interfaces/interface/peers/peer/state/session_state (bfd-session-state)

    YANG Description: The state of the BFD session perceived by the local system.
    """
    return self.__session_state
      
  def _set_session_state(self, v, load=False):
    """
    Setter method for session_state, mapped from YANG variable /bfd/interfaces/interface/peers/peer/state/session_state (bfd-session-state)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_session_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_session_state() directly.

    YANG Description: The state of the BFD session perceived by the local system.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'UP': {}, 'DOWN': {}, 'ADMIN_DOWN': {}, 'INIT': {}},), is_leaf=True, yang_name="session-state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='bfd-session-state', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """session_state must be of a type compatible with bfd-session-state""",
          'defined-type': "openconfig-bfd:bfd-session-state",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'UP': {}, 'DOWN': {}, 'ADMIN_DOWN': {}, 'INIT': {}},), is_leaf=True, yang_name="session-state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='bfd-session-state', is_config=False)""",
        })

    self.__session_state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_session_state(self):
    self.__session_state = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'UP': {}, 'DOWN': {}, 'ADMIN_DOWN': {}, 'INIT': {}},), is_leaf=True, yang_name="session-state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='bfd-session-state', is_config=False)


  def _get_remote_session_state(self):
    """
    Getter method for remote_session_state, mapped from YANG variable /bfd/interfaces/interface/peers/peer/state/remote_session_state (bfd-session-state)

    YANG Description: The reported state of the BFD session according to the remote
system. This state reflects the last state reported in a BFD
control packet.
    """
    return self.__remote_session_state
      
  def _set_remote_session_state(self, v, load=False):
    """
    Setter method for remote_session_state, mapped from YANG variable /bfd/interfaces/interface/peers/peer/state/remote_session_state (bfd-session-state)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_remote_session_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_remote_session_state() directly.

    YANG Description: The reported state of the BFD session according to the remote
system. This state reflects the last state reported in a BFD
control packet.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'UP': {}, 'DOWN': {}, 'ADMIN_DOWN': {}, 'INIT': {}},), is_leaf=True, yang_name="remote-session-state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='bfd-session-state', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """remote_session_state must be of a type compatible with bfd-session-state""",
          'defined-type': "openconfig-bfd:bfd-session-state",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'UP': {}, 'DOWN': {}, 'ADMIN_DOWN': {}, 'INIT': {}},), is_leaf=True, yang_name="remote-session-state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='bfd-session-state', is_config=False)""",
        })

    self.__remote_session_state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_remote_session_state(self):
    self.__remote_session_state = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'UP': {}, 'DOWN': {}, 'ADMIN_DOWN': {}, 'INIT': {}},), is_leaf=True, yang_name="remote-session-state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='bfd-session-state', is_config=False)


  def _get_last_failure_time(self):
    """
    Getter method for last_failure_time, mapped from YANG variable /bfd/interfaces/interface/peers/peer/state/last_failure_time (oc-types:timeticks64)

    YANG Description: The time of the last transition of the BFD session out of
the UP state, expressed as the number of nanoseconds since
the Unix epoch.
    """
    return self.__last_failure_time
      
  def _set_last_failure_time(self, v, load=False):
    """
    Setter method for last_failure_time, mapped from YANG variable /bfd/interfaces/interface/peers/peer/state/last_failure_time (oc-types:timeticks64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_last_failure_time is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_last_failure_time() directly.

    YANG Description: The time of the last transition of the BFD session out of
the UP state, expressed as the number of nanoseconds since
the Unix epoch.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="last-failure-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='oc-types:timeticks64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """last_failure_time must be of a type compatible with oc-types:timeticks64""",
          'defined-type': "oc-types:timeticks64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="last-failure-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='oc-types:timeticks64', is_config=False)""",
        })

    self.__last_failure_time = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_last_failure_time(self):
    self.__last_failure_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="last-failure-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='oc-types:timeticks64', is_config=False)


  def _get_failure_transitions(self):
    """
    Getter method for failure_transitions, mapped from YANG variable /bfd/interfaces/interface/peers/peer/state/failure_transitions (uint64)

    YANG Description: The number of times that the BFD session has transitioned
out of the UP state.
    """
    return self.__failure_transitions
      
  def _set_failure_transitions(self, v, load=False):
    """
    Setter method for failure_transitions, mapped from YANG variable /bfd/interfaces/interface/peers/peer/state/failure_transitions (uint64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_failure_transitions is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_failure_transitions() directly.

    YANG Description: The number of times that the BFD session has transitioned
out of the UP state.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="failure-transitions", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='uint64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """failure_transitions must be of a type compatible with uint64""",
          'defined-type': "uint64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="failure-transitions", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='uint64', is_config=False)""",
        })

    self.__failure_transitions = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_failure_transitions(self):
    self.__failure_transitions = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="failure-transitions", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='uint64', is_config=False)


  def _get_local_discriminator(self):
    """
    Getter method for local_discriminator, mapped from YANG variable /bfd/interfaces/interface/peers/peer/state/local_discriminator (string)

    YANG Description: A unique identifier used by the local system to identify this
BFD session.
    """
    return self.__local_discriminator
      
  def _set_local_discriminator(self, v, load=False):
    """
    Setter method for local_discriminator, mapped from YANG variable /bfd/interfaces/interface/peers/peer/state/local_discriminator (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_local_discriminator is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_local_discriminator() directly.

    YANG Description: A unique identifier used by the local system to identify this
BFD session.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="local-discriminator", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """local_discriminator must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="local-discriminator", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='string', is_config=False)""",
        })

    self.__local_discriminator = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_local_discriminator(self):
    self.__local_discriminator = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="local-discriminator", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='string', is_config=False)


  def _get_remote_discriminator(self):
    """
    Getter method for remote_discriminator, mapped from YANG variable /bfd/interfaces/interface/peers/peer/state/remote_discriminator (string)

    YANG Description: A unique identified used by the remote system to identify this
BFD session.
    """
    return self.__remote_discriminator
      
  def _set_remote_discriminator(self, v, load=False):
    """
    Setter method for remote_discriminator, mapped from YANG variable /bfd/interfaces/interface/peers/peer/state/remote_discriminator (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_remote_discriminator is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_remote_discriminator() directly.

    YANG Description: A unique identified used by the remote system to identify this
BFD session.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="remote-discriminator", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """remote_discriminator must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="remote-discriminator", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='string', is_config=False)""",
        })

    self.__remote_discriminator = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_remote_discriminator(self):
    self.__remote_discriminator = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="remote-discriminator", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='string', is_config=False)


  def _get_local_diagnostic_code(self):
    """
    Getter method for local_diagnostic_code, mapped from YANG variable /bfd/interfaces/interface/peers/peer/state/local_diagnostic_code (bfd-diagnostic-code)

    YANG Description: The local BFD diagnostic code indicating the most recent
reason for failure of this BFD session.
    """
    return self.__local_diagnostic_code
      
  def _set_local_diagnostic_code(self, v, load=False):
    """
    Setter method for local_diagnostic_code, mapped from YANG variable /bfd/interfaces/interface/peers/peer/state/local_diagnostic_code (bfd-diagnostic-code)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_local_diagnostic_code is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_local_diagnostic_code() directly.

    YANG Description: The local BFD diagnostic code indicating the most recent
reason for failure of this BFD session.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'NO_DIAGNOSTIC': {'value': 0}, 'DETECTION_TIMEOUT': {'value': 1}, 'ECHO_FAILED': {'value': 2}, 'FORWARDING_RESET': {'value': 3}, 'PATH_DOWN': {'value': 4}, 'CONCATENATED_PATH_DOWN': {'value': 5}, 'ADMIN_DOWN': {'value': 6}, 'REVERSE_CONCATENATED_PATH_DOWN': {'value': 7}},), is_leaf=True, yang_name="local-diagnostic-code", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='bfd-diagnostic-code', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """local_diagnostic_code must be of a type compatible with bfd-diagnostic-code""",
          'defined-type': "openconfig-bfd:bfd-diagnostic-code",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'NO_DIAGNOSTIC': {'value': 0}, 'DETECTION_TIMEOUT': {'value': 1}, 'ECHO_FAILED': {'value': 2}, 'FORWARDING_RESET': {'value': 3}, 'PATH_DOWN': {'value': 4}, 'CONCATENATED_PATH_DOWN': {'value': 5}, 'ADMIN_DOWN': {'value': 6}, 'REVERSE_CONCATENATED_PATH_DOWN': {'value': 7}},), is_leaf=True, yang_name="local-diagnostic-code", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='bfd-diagnostic-code', is_config=False)""",
        })

    self.__local_diagnostic_code = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_local_diagnostic_code(self):
    self.__local_diagnostic_code = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'NO_DIAGNOSTIC': {'value': 0}, 'DETECTION_TIMEOUT': {'value': 1}, 'ECHO_FAILED': {'value': 2}, 'FORWARDING_RESET': {'value': 3}, 'PATH_DOWN': {'value': 4}, 'CONCATENATED_PATH_DOWN': {'value': 5}, 'ADMIN_DOWN': {'value': 6}, 'REVERSE_CONCATENATED_PATH_DOWN': {'value': 7}},), is_leaf=True, yang_name="local-diagnostic-code", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='bfd-diagnostic-code', is_config=False)


  def _get_remote_diagnostic_code(self):
    """
    Getter method for remote_diagnostic_code, mapped from YANG variable /bfd/interfaces/interface/peers/peer/state/remote_diagnostic_code (bfd-diagnostic-code)

    YANG Description: The remote BFD diagnostic code indicating the remote system's
reason for failure of the BFD session
    """
    return self.__remote_diagnostic_code
      
  def _set_remote_diagnostic_code(self, v, load=False):
    """
    Setter method for remote_diagnostic_code, mapped from YANG variable /bfd/interfaces/interface/peers/peer/state/remote_diagnostic_code (bfd-diagnostic-code)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_remote_diagnostic_code is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_remote_diagnostic_code() directly.

    YANG Description: The remote BFD diagnostic code indicating the remote system's
reason for failure of the BFD session
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'NO_DIAGNOSTIC': {'value': 0}, 'DETECTION_TIMEOUT': {'value': 1}, 'ECHO_FAILED': {'value': 2}, 'FORWARDING_RESET': {'value': 3}, 'PATH_DOWN': {'value': 4}, 'CONCATENATED_PATH_DOWN': {'value': 5}, 'ADMIN_DOWN': {'value': 6}, 'REVERSE_CONCATENATED_PATH_DOWN': {'value': 7}},), is_leaf=True, yang_name="remote-diagnostic-code", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='bfd-diagnostic-code', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """remote_diagnostic_code must be of a type compatible with bfd-diagnostic-code""",
          'defined-type': "openconfig-bfd:bfd-diagnostic-code",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'NO_DIAGNOSTIC': {'value': 0}, 'DETECTION_TIMEOUT': {'value': 1}, 'ECHO_FAILED': {'value': 2}, 'FORWARDING_RESET': {'value': 3}, 'PATH_DOWN': {'value': 4}, 'CONCATENATED_PATH_DOWN': {'value': 5}, 'ADMIN_DOWN': {'value': 6}, 'REVERSE_CONCATENATED_PATH_DOWN': {'value': 7}},), is_leaf=True, yang_name="remote-diagnostic-code", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='bfd-diagnostic-code', is_config=False)""",
        })

    self.__remote_diagnostic_code = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_remote_diagnostic_code(self):
    self.__remote_diagnostic_code = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'NO_DIAGNOSTIC': {'value': 0}, 'DETECTION_TIMEOUT': {'value': 1}, 'ECHO_FAILED': {'value': 2}, 'FORWARDING_RESET': {'value': 3}, 'PATH_DOWN': {'value': 4}, 'CONCATENATED_PATH_DOWN': {'value': 5}, 'ADMIN_DOWN': {'value': 6}, 'REVERSE_CONCATENATED_PATH_DOWN': {'value': 7}},), is_leaf=True, yang_name="remote-diagnostic-code", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='bfd-diagnostic-code', is_config=False)


  def _get_remote_minimum_receive_interval(self):
    """
    Getter method for remote_minimum_receive_interval, mapped from YANG variable /bfd/interfaces/interface/peers/peer/state/remote_minimum_receive_interval (uint32)

    YANG Description: The value of the minimum receive interval that was specified
in the most recent BFD control packet received from the peer.
    """
    return self.__remote_minimum_receive_interval
      
  def _set_remote_minimum_receive_interval(self, v, load=False):
    """
    Setter method for remote_minimum_receive_interval, mapped from YANG variable /bfd/interfaces/interface/peers/peer/state/remote_minimum_receive_interval (uint32)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_remote_minimum_receive_interval is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_remote_minimum_receive_interval() directly.

    YANG Description: The value of the minimum receive interval that was specified
in the most recent BFD control packet received from the peer.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="remote-minimum-receive-interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='uint32', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """remote_minimum_receive_interval must be of a type compatible with uint32""",
          'defined-type': "uint32",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="remote-minimum-receive-interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='uint32', is_config=False)""",
        })

    self.__remote_minimum_receive_interval = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_remote_minimum_receive_interval(self):
    self.__remote_minimum_receive_interval = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="remote-minimum-receive-interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='uint32', is_config=False)


  def _get_demand_mode_requested(self):
    """
    Getter method for demand_mode_requested, mapped from YANG variable /bfd/interfaces/interface/peers/peer/state/demand_mode_requested (boolean)

    YANG Description: This leaf is set to true when the remote system has requested
demand mode be run for this session.
    """
    return self.__demand_mode_requested
      
  def _set_demand_mode_requested(self, v, load=False):
    """
    Setter method for demand_mode_requested, mapped from YANG variable /bfd/interfaces/interface/peers/peer/state/demand_mode_requested (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_demand_mode_requested is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_demand_mode_requested() directly.

    YANG Description: This leaf is set to true when the remote system has requested
demand mode be run for this session.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, is_leaf=True, yang_name="demand-mode-requested", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='boolean', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """demand_mode_requested must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, is_leaf=True, yang_name="demand-mode-requested", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='boolean', is_config=False)""",
        })

    self.__demand_mode_requested = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_demand_mode_requested(self):
    self.__demand_mode_requested = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="demand-mode-requested", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='boolean', is_config=False)


  def _get_remote_authentication_enabled(self):
    """
    Getter method for remote_authentication_enabled, mapped from YANG variable /bfd/interfaces/interface/peers/peer/state/remote_authentication_enabled (boolean)

    YANG Description: This leaf is set to true when the remote system has specified
that authentication is present for the BFD session.
    """
    return self.__remote_authentication_enabled
      
  def _set_remote_authentication_enabled(self, v, load=False):
    """
    Setter method for remote_authentication_enabled, mapped from YANG variable /bfd/interfaces/interface/peers/peer/state/remote_authentication_enabled (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_remote_authentication_enabled is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_remote_authentication_enabled() directly.

    YANG Description: This leaf is set to true when the remote system has specified
that authentication is present for the BFD session.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, is_leaf=True, yang_name="remote-authentication-enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='boolean', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """remote_authentication_enabled must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, is_leaf=True, yang_name="remote-authentication-enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='boolean', is_config=False)""",
        })

    self.__remote_authentication_enabled = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_remote_authentication_enabled(self):
    self.__remote_authentication_enabled = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="remote-authentication-enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='boolean', is_config=False)


  def _get_remote_control_plane_independent(self):
    """
    Getter method for remote_control_plane_independent, mapped from YANG variable /bfd/interfaces/interface/peers/peer/state/remote_control_plane_independent (boolean)

    YANG Description: This leaf is set to true when the remote system has specified
that the hardware implementing this BFD session is independent
of the control plane's liveliness.
    """
    return self.__remote_control_plane_independent
      
  def _set_remote_control_plane_independent(self, v, load=False):
    """
    Setter method for remote_control_plane_independent, mapped from YANG variable /bfd/interfaces/interface/peers/peer/state/remote_control_plane_independent (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_remote_control_plane_independent is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_remote_control_plane_independent() directly.

    YANG Description: This leaf is set to true when the remote system has specified
that the hardware implementing this BFD session is independent
of the control plane's liveliness.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, is_leaf=True, yang_name="remote-control-plane-independent", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='boolean', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """remote_control_plane_independent must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, is_leaf=True, yang_name="remote-control-plane-independent", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='boolean', is_config=False)""",
        })

    self.__remote_control_plane_independent = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_remote_control_plane_independent(self):
    self.__remote_control_plane_independent = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="remote-control-plane-independent", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='boolean', is_config=False)


  def _get_echo(self):
    """
    Getter method for echo, mapped from YANG variable /bfd/interfaces/interface/peers/peer/state/echo (container)

    YANG Description: Operational state parameters specifically relating to the
echo mode of BFD.
    """
    return self.__echo
      
  def _set_echo(self, v, load=False):
    """
    Setter method for echo, mapped from YANG variable /bfd/interfaces/interface/peers/peer/state/echo (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_echo is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_echo() directly.

    YANG Description: Operational state parameters specifically relating to the
echo mode of BFD.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_echo_openconfig_bfd__bfd_interfaces_interface_peers_peer_state_echo, is_container='container', yang_name="echo", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """echo must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_echo_openconfig_bfd__bfd_interfaces_interface_peers_peer_state_echo, is_container='container', yang_name="echo", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='container', is_config=False)""",
        })

    self.__echo = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_echo(self):
    self.__echo = YANGDynClass(base=yc_echo_openconfig_bfd__bfd_interfaces_interface_peers_peer_state_echo, is_container='container', yang_name="echo", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='container', is_config=False)


  def _get_async(self):
    """
    Getter method for async, mapped from YANG variable /bfd/interfaces/interface/peers/peer/state/async (container)

    YANG Description: Operational state parameters specifically relating to
asynchronous mode of BFD.
    """
    return self.__async
      
  def _set_async(self, v, load=False):
    """
    Setter method for async, mapped from YANG variable /bfd/interfaces/interface/peers/peer/state/async (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_async is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_async() directly.

    YANG Description: Operational state parameters specifically relating to
asynchronous mode of BFD.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_async_openconfig_bfd__bfd_interfaces_interface_peers_peer_state_async, is_container='container', yang_name="async", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """async must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_async_openconfig_bfd__bfd_interfaces_interface_peers_peer_state_async, is_container='container', yang_name="async", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='container', is_config=False)""",
        })

    self.__async = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_async(self):
    self.__async = YANGDynClass(base=yc_async_openconfig_bfd__bfd_interfaces_interface_peers_peer_state_async, is_container='container', yang_name="async", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='container', is_config=False)

  local_address = __builtin__.property(_get_local_address)
  remote_address = __builtin__.property(_get_remote_address)
  subscribed_protocols = __builtin__.property(_get_subscribed_protocols)
  session_state = __builtin__.property(_get_session_state)
  remote_session_state = __builtin__.property(_get_remote_session_state)
  last_failure_time = __builtin__.property(_get_last_failure_time)
  failure_transitions = __builtin__.property(_get_failure_transitions)
  local_discriminator = __builtin__.property(_get_local_discriminator)
  remote_discriminator = __builtin__.property(_get_remote_discriminator)
  local_diagnostic_code = __builtin__.property(_get_local_diagnostic_code)
  remote_diagnostic_code = __builtin__.property(_get_remote_diagnostic_code)
  remote_minimum_receive_interval = __builtin__.property(_get_remote_minimum_receive_interval)
  demand_mode_requested = __builtin__.property(_get_demand_mode_requested)
  remote_authentication_enabled = __builtin__.property(_get_remote_authentication_enabled)
  remote_control_plane_independent = __builtin__.property(_get_remote_control_plane_independent)
  echo = __builtin__.property(_get_echo)
  async = __builtin__.property(_get_async)


  _pyangbind_elements = OrderedDict([('local_address', local_address), ('remote_address', remote_address), ('subscribed_protocols', subscribed_protocols), ('session_state', session_state), ('remote_session_state', remote_session_state), ('last_failure_time', last_failure_time), ('failure_transitions', failure_transitions), ('local_discriminator', local_discriminator), ('remote_discriminator', remote_discriminator), ('local_diagnostic_code', local_diagnostic_code), ('remote_diagnostic_code', remote_diagnostic_code), ('remote_minimum_receive_interval', remote_minimum_receive_interval), ('demand_mode_requested', demand_mode_requested), ('remote_authentication_enabled', remote_authentication_enabled), ('remote_control_plane_independent', remote_control_plane_independent), ('echo', echo), ('async', async), ])


class yc_peer_openconfig_bfd__bfd_interfaces_interface_peers_peer(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-bfd - based on the path /bfd/interfaces/interface/peers/peer. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Parameters relating to the BFD peer specified by the
remote address.
  """
  __slots__ = ('_path_helper', '_extmethods', '__local_discriminator','__state',)

  _yang_name = 'peer'
  _yang_namespace = 'http://openconfig.net/yang/bfd'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__local_discriminator = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="local-discriminator", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='leafref', is_config=False)
    self.__state = YANGDynClass(base=yc_state_openconfig_bfd__bfd_interfaces_interface_peers_peer_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='container', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['bfd', 'interfaces', 'interface', 'peers', 'peer']

  def _get_local_discriminator(self):
    """
    Getter method for local_discriminator, mapped from YANG variable /bfd/interfaces/interface/peers/peer/local_discriminator (leafref)

    YANG Description: The local discriminator, which is unique for the
session on the system.
    """
    return self.__local_discriminator
      
  def _set_local_discriminator(self, v, load=False):
    """
    Setter method for local_discriminator, mapped from YANG variable /bfd/interfaces/interface/peers/peer/local_discriminator (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_local_discriminator is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_local_discriminator() directly.

    YANG Description: The local discriminator, which is unique for the
session on the system.
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="local-discriminator", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='leafref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """local_discriminator must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="local-discriminator", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='leafref', is_config=False)""",
        })

    self.__local_discriminator = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_local_discriminator(self):
    self.__local_discriminator = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="local-discriminator", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='leafref', is_config=False)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /bfd/interfaces/interface/peers/peer/state (container)

    YANG Description: Operational state parameters for the BFD session.
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /bfd/interfaces/interface/peers/peer/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: Operational state parameters for the BFD session.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_bfd__bfd_interfaces_interface_peers_peer_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_bfd__bfd_interfaces_interface_peers_peer_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='container', is_config=False)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_bfd__bfd_interfaces_interface_peers_peer_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='container', is_config=False)

  local_discriminator = __builtin__.property(_get_local_discriminator)
  state = __builtin__.property(_get_state)


  _pyangbind_elements = OrderedDict([('local_discriminator', local_discriminator), ('state', state), ])


class yc_peers_openconfig_bfd__bfd_interfaces_interface_peers(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-bfd - based on the path /bfd/interfaces/interface/peers. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Parameters relating to the BFD peers which are seen
over this interface.
  """
  __slots__ = ('_path_helper', '_extmethods', '__peer',)

  _yang_name = 'peers'
  _yang_namespace = 'http://openconfig.net/yang/bfd'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__peer = YANGDynClass(base=YANGListType("local_discriminator",yc_peer_openconfig_bfd__bfd_interfaces_interface_peers_peer, yang_name="peer", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='local-discriminator', extensions=None), is_container='list', yang_name="peer", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='list', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['bfd', 'interfaces', 'interface', 'peers']

  def _get_peer(self):
    """
    Getter method for peer, mapped from YANG variable /bfd/interfaces/interface/peers/peer (list)

    YANG Description: Parameters relating to the BFD peer specified by the
remote address.
    """
    return self.__peer
      
  def _set_peer(self, v, load=False):
    """
    Setter method for peer, mapped from YANG variable /bfd/interfaces/interface/peers/peer (list)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_peer is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_peer() directly.

    YANG Description: Parameters relating to the BFD peer specified by the
remote address.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGListType("local_discriminator",yc_peer_openconfig_bfd__bfd_interfaces_interface_peers_peer, yang_name="peer", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='local-discriminator', extensions=None), is_container='list', yang_name="peer", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='list', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """peer must be of a type compatible with list""",
          'defined-type': "list",
          'generated-type': """YANGDynClass(base=YANGListType("local_discriminator",yc_peer_openconfig_bfd__bfd_interfaces_interface_peers_peer, yang_name="peer", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='local-discriminator', extensions=None), is_container='list', yang_name="peer", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='list', is_config=True)""",
        })

    self.__peer = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_peer(self):
    self.__peer = YANGDynClass(base=YANGListType("local_discriminator",yc_peer_openconfig_bfd__bfd_interfaces_interface_peers_peer, yang_name="peer", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='local-discriminator', extensions=None), is_container='list', yang_name="peer", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='list', is_config=True)

  peer = __builtin__.property(_get_peer, _set_peer)


  _pyangbind_elements = OrderedDict([('peer', peer), ])


class yc_interface_openconfig_bfd__bfd_interfaces_interface(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-bfd - based on the path /bfd/interfaces/interface. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Per-interface configuration and state parameters for BFD.
The interface referenced is based on the interface and
subinterface leaves within the interface-ref container -
which reference an entry in the /interfaces/interface list -
and should not rely on the value of the list key.
  """
  __slots__ = ('_path_helper', '_extmethods', '__id','__config','__state','__interface_ref','__micro_bfd_sessions','__peers',)

  _yang_name = 'interface'
  _yang_namespace = 'http://openconfig.net/yang/bfd'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='leafref', is_config=True)
    self.__config = YANGDynClass(base=yc_config_openconfig_bfd__bfd_interfaces_interface_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_bfd__bfd_interfaces_interface_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='container', is_config=True)
    self.__interface_ref = YANGDynClass(base=yc_interface_ref_openconfig_bfd__bfd_interfaces_interface_interface_ref, is_container='container', yang_name="interface-ref", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='container', is_config=True)
    self.__micro_bfd_sessions = YANGDynClass(base=yc_micro_bfd_sessions_openconfig_bfd__bfd_interfaces_interface_micro_bfd_sessions, is_container='container', yang_name="micro-bfd-sessions", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='container', is_config=True)
    self.__peers = YANGDynClass(base=yc_peers_openconfig_bfd__bfd_interfaces_interface_peers, is_container='container', yang_name="peers", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['bfd', 'interfaces', 'interface']

  def _get_id(self):
    """
    Getter method for id, mapped from YANG variable /bfd/interfaces/interface/id (leafref)

    YANG Description: A reference to an identifier for the interface on which
BFD is enabled.
    """
    return self.__id
      
  def _set_id(self, v, load=False):
    """
    Setter method for id, mapped from YANG variable /bfd/interfaces/interface/id (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_id() directly.

    YANG Description: A reference to an identifier for the interface on which
BFD is enabled.
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """id must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='leafref', is_config=True)""",
        })

    self.__id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_id(self):
    self.__id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='leafref', is_config=True)


  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /bfd/interfaces/interface/config (container)

    YANG Description: Configuration parameters for BFD on the specified
interface.
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /bfd/interfaces/interface/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Configuration parameters for BFD on the specified
interface.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_bfd__bfd_interfaces_interface_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_bfd__bfd_interfaces_interface_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_bfd__bfd_interfaces_interface_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /bfd/interfaces/interface/state (container)

    YANG Description: Operational state parameters for BFD on the specified
interface.
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /bfd/interfaces/interface/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: Operational state parameters for BFD on the specified
interface.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_bfd__bfd_interfaces_interface_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_bfd__bfd_interfaces_interface_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_bfd__bfd_interfaces_interface_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='container', is_config=True)


  def _get_interface_ref(self):
    """
    Getter method for interface_ref, mapped from YANG variable /bfd/interfaces/interface/interface_ref (container)

    YANG Description: Reference to an interface or subinterface. The interface
that is being referenced is uniquely referenced based on
the specified interface and subinterface leaves. In contexts
where a Layer 3 interface is to be referenced, both the
interface and subinterface leaves must be populated, as
Layer 3 configuration within the OpenConfig models is
associated with a subinterface. In the case where a
Layer 2 interface is to be referenced, only the
interface is specified.

The interface/subinterface leaf tuple must be used as
the means by which the interface is specified, regardless
of any other context information (e.g., key in a list).
    """
    return self.__interface_ref
      
  def _set_interface_ref(self, v, load=False):
    """
    Setter method for interface_ref, mapped from YANG variable /bfd/interfaces/interface/interface_ref (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_interface_ref is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_interface_ref() directly.

    YANG Description: Reference to an interface or subinterface. The interface
that is being referenced is uniquely referenced based on
the specified interface and subinterface leaves. In contexts
where a Layer 3 interface is to be referenced, both the
interface and subinterface leaves must be populated, as
Layer 3 configuration within the OpenConfig models is
associated with a subinterface. In the case where a
Layer 2 interface is to be referenced, only the
interface is specified.

The interface/subinterface leaf tuple must be used as
the means by which the interface is specified, regardless
of any other context information (e.g., key in a list).
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_interface_ref_openconfig_bfd__bfd_interfaces_interface_interface_ref, is_container='container', yang_name="interface-ref", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """interface_ref must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_interface_ref_openconfig_bfd__bfd_interfaces_interface_interface_ref, is_container='container', yang_name="interface-ref", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='container', is_config=True)""",
        })

    self.__interface_ref = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_interface_ref(self):
    self.__interface_ref = YANGDynClass(base=yc_interface_ref_openconfig_bfd__bfd_interfaces_interface_interface_ref, is_container='container', yang_name="interface-ref", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='container', is_config=True)


  def _get_micro_bfd_sessions(self):
    """
    Getter method for micro_bfd_sessions, mapped from YANG variable /bfd/interfaces/interface/micro_bfd_sessions (container)

    YANG Description: Parameters relating to micro-BFD sessions associated
with the interface.
    """
    return self.__micro_bfd_sessions
      
  def _set_micro_bfd_sessions(self, v, load=False):
    """
    Setter method for micro_bfd_sessions, mapped from YANG variable /bfd/interfaces/interface/micro_bfd_sessions (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_micro_bfd_sessions is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_micro_bfd_sessions() directly.

    YANG Description: Parameters relating to micro-BFD sessions associated
with the interface.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_micro_bfd_sessions_openconfig_bfd__bfd_interfaces_interface_micro_bfd_sessions, is_container='container', yang_name="micro-bfd-sessions", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """micro_bfd_sessions must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_micro_bfd_sessions_openconfig_bfd__bfd_interfaces_interface_micro_bfd_sessions, is_container='container', yang_name="micro-bfd-sessions", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='container', is_config=True)""",
        })

    self.__micro_bfd_sessions = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_micro_bfd_sessions(self):
    self.__micro_bfd_sessions = YANGDynClass(base=yc_micro_bfd_sessions_openconfig_bfd__bfd_interfaces_interface_micro_bfd_sessions, is_container='container', yang_name="micro-bfd-sessions", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='container', is_config=True)


  def _get_peers(self):
    """
    Getter method for peers, mapped from YANG variable /bfd/interfaces/interface/peers (container)

    YANG Description: Parameters relating to the BFD peers which are seen
over this interface.
    """
    return self.__peers
      
  def _set_peers(self, v, load=False):
    """
    Setter method for peers, mapped from YANG variable /bfd/interfaces/interface/peers (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_peers is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_peers() directly.

    YANG Description: Parameters relating to the BFD peers which are seen
over this interface.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_peers_openconfig_bfd__bfd_interfaces_interface_peers, is_container='container', yang_name="peers", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """peers must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_peers_openconfig_bfd__bfd_interfaces_interface_peers, is_container='container', yang_name="peers", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='container', is_config=True)""",
        })

    self.__peers = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_peers(self):
    self.__peers = YANGDynClass(base=yc_peers_openconfig_bfd__bfd_interfaces_interface_peers, is_container='container', yang_name="peers", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='container', is_config=True)

  id = __builtin__.property(_get_id, _set_id)
  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)
  interface_ref = __builtin__.property(_get_interface_ref, _set_interface_ref)
  micro_bfd_sessions = __builtin__.property(_get_micro_bfd_sessions, _set_micro_bfd_sessions)
  peers = __builtin__.property(_get_peers, _set_peers)


  _pyangbind_elements = OrderedDict([('id', id), ('config', config), ('state', state), ('interface_ref', interface_ref), ('micro_bfd_sessions', micro_bfd_sessions), ('peers', peers), ])


class yc_interfaces_openconfig_bfd__bfd_interfaces(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-bfd - based on the path /bfd/interfaces. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Interfaces on which BFD sessions are to be enabled.
  """
  __slots__ = ('_path_helper', '_extmethods', '__interface',)

  _yang_name = 'interfaces'
  _yang_namespace = 'http://openconfig.net/yang/bfd'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__interface = YANGDynClass(base=YANGListType("id",yc_interface_openconfig_bfd__bfd_interfaces_interface, yang_name="interface", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='id', extensions=None), is_container='list', yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='list', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['bfd', 'interfaces']

  def _get_interface(self):
    """
    Getter method for interface, mapped from YANG variable /bfd/interfaces/interface (list)

    YANG Description: Per-interface configuration and state parameters for BFD.
The interface referenced is based on the interface and
subinterface leaves within the interface-ref container -
which reference an entry in the /interfaces/interface list -
and should not rely on the value of the list key.
    """
    return self.__interface
      
  def _set_interface(self, v, load=False):
    """
    Setter method for interface, mapped from YANG variable /bfd/interfaces/interface (list)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_interface is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_interface() directly.

    YANG Description: Per-interface configuration and state parameters for BFD.
The interface referenced is based on the interface and
subinterface leaves within the interface-ref container -
which reference an entry in the /interfaces/interface list -
and should not rely on the value of the list key.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGListType("id",yc_interface_openconfig_bfd__bfd_interfaces_interface, yang_name="interface", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='id', extensions=None), is_container='list', yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='list', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """interface must be of a type compatible with list""",
          'defined-type': "list",
          'generated-type': """YANGDynClass(base=YANGListType("id",yc_interface_openconfig_bfd__bfd_interfaces_interface, yang_name="interface", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='id', extensions=None), is_container='list', yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='list', is_config=True)""",
        })

    self.__interface = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_interface(self):
    self.__interface = YANGDynClass(base=YANGListType("id",yc_interface_openconfig_bfd__bfd_interfaces_interface, yang_name="interface", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='id', extensions=None), is_container='list', yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='list', is_config=True)

  interface = __builtin__.property(_get_interface, _set_interface)


  _pyangbind_elements = OrderedDict([('interface', interface), ])


class yc_bfd_openconfig_bfd__bfd(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-bfd - based on the path /bfd. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configuration and operational state parameters for BFD.
  """
  __slots__ = ('_path_helper', '_extmethods', '__interfaces',)

  _yang_name = 'bfd'
  _yang_namespace = 'http://openconfig.net/yang/bfd'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__interfaces = YANGDynClass(base=yc_interfaces_openconfig_bfd__bfd_interfaces, is_container='container', yang_name="interfaces", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['bfd']

  def _get_interfaces(self):
    """
    Getter method for interfaces, mapped from YANG variable /bfd/interfaces (container)

    YANG Description: Interfaces on which BFD sessions are to be enabled.
    """
    return self.__interfaces
      
  def _set_interfaces(self, v, load=False):
    """
    Setter method for interfaces, mapped from YANG variable /bfd/interfaces (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_interfaces is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_interfaces() directly.

    YANG Description: Interfaces on which BFD sessions are to be enabled.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_interfaces_openconfig_bfd__bfd_interfaces, is_container='container', yang_name="interfaces", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """interfaces must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_interfaces_openconfig_bfd__bfd_interfaces, is_container='container', yang_name="interfaces", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='container', is_config=True)""",
        })

    self.__interfaces = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_interfaces(self):
    self.__interfaces = YANGDynClass(base=yc_interfaces_openconfig_bfd__bfd_interfaces, is_container='container', yang_name="interfaces", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='container', is_config=True)

  interfaces = __builtin__.property(_get_interfaces, _set_interfaces)


  _pyangbind_elements = OrderedDict([('interfaces', interfaces), ])


class openconfig_bfd(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-bfd - based on the path /openconfig-bfd. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: An OpenConfig model of Bi-Directional Forwarding Detection (BFD)
configuration and operational state.
  """
  __slots__ = ('_path_helper', '_extmethods', '__bfd',)

  _yang_name = 'openconfig-bfd'
  _yang_namespace = 'http://openconfig.net/yang/bfd'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__bfd = YANGDynClass(base=yc_bfd_openconfig_bfd__bfd, is_container='container', yang_name="bfd", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return []

  def _get_bfd(self):
    """
    Getter method for bfd, mapped from YANG variable /bfd (container)

    YANG Description: Configuration and operational state parameters for BFD.
    """
    return self.__bfd
      
  def _set_bfd(self, v, load=False):
    """
    Setter method for bfd, mapped from YANG variable /bfd (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_bfd is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_bfd() directly.

    YANG Description: Configuration and operational state parameters for BFD.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_bfd_openconfig_bfd__bfd, is_container='container', yang_name="bfd", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """bfd must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_bfd_openconfig_bfd__bfd, is_container='container', yang_name="bfd", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='container', is_config=True)""",
        })

    self.__bfd = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_bfd(self):
    self.__bfd = YANGDynClass(base=yc_bfd_openconfig_bfd__bfd, is_container='container', yang_name="bfd", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/bfd', defining_module='openconfig-bfd', yang_type='container', is_config=True)

  bfd = __builtin__.property(_get_bfd, _set_bfd)


  _pyangbind_elements = OrderedDict([('bfd', bfd), ])


