/*
Package gostruct is a generated package which contains definitions
of structs which represent a YANG schema. The generated schema can be
compressed by a series of transformations (compression was false
in this case).

This package was generated by /usr/local/google/home/wenbli/gocode/pkg/mod/github.com/openconfig/ygot@v0.20.0/genutil/names.go
using the following YANG input files:
	- public/release/models/interfaces/openconfig-interfaces.yang
	- public/release/models/openflow/openconfig-openflow.yang
	- public/release/models/platform/openconfig-platform.yang
	- public/release/models/system/openconfig-system.yang
Imported modules were sourced from:
	- public/...
	- yang/...
*/
package gostruct

import (
	"encoding/json"
	"fmt"
	"reflect"

	"github.com/openconfig/ygot/ygot"
	"github.com/openconfig/goyang/pkg/yang"
	"github.com/openconfig/ygot/ytypes"
)

// Binary is a type that is used for fields that have a YANG type of
// binary. It is used such that binary fields can be distinguished from
// leaf-lists of uint8s (which are mapped to []uint8, equivalent to
// []byte in reflection).
type Binary []byte

// YANGEmpty is a type that is used for fields that have a YANG type of
// empty. It is used such that empty fields can be distinguished from boolean fields
// in the generated code.
type YANGEmpty bool

var (
	SchemaTree map[string]*yang.Entry
	ΛEnumTypes map[string][]reflect.Type
)

func init() {
	var err error
	initΛEnumTypes()
	if SchemaTree, err = UnzipSchema(); err != nil {
		panic("schema error: " +  err.Error())
	}
}

// Schema returns the details of the generated schema.
func Schema() (*ytypes.Schema, error) {
	uzp, err := UnzipSchema()
	if err != nil {
		return nil, fmt.Errorf("cannot unzip schema, %v", err)
	}

	return &ytypes.Schema{
		Root: &Device{},
		SchemaTree: uzp,
		Unmarshal: Unmarshal,
	}, nil
}

// UnzipSchema unzips the zipped schema and returns a map of yang.Entry nodes,
// keyed by the name of the struct that the yang.Entry describes the schema for.
func UnzipSchema() (map[string]*yang.Entry, error) {
	var schemaTree map[string]*yang.Entry
	var err error
	if schemaTree, err = ygot.GzipToSchema(ySchema); err != nil {
		return nil, fmt.Errorf("could not unzip the schema; %v", err)
	}
	return schemaTree, nil
}

// Unmarshal unmarshals data, which must be RFC7951 JSON format, into
// destStruct, which must be non-nil and the correct GoStruct type. It returns
// an error if the destStruct is not found in the schema or the data cannot be
// unmarshaled. The supplied options (opts) are used to control the behaviour
// of the unmarshal function - for example, determining whether errors are
// thrown for unknown fields in the input JSON.
func Unmarshal(data []byte, destStruct ygot.GoStruct, opts ...ytypes.UnmarshalOpt) error {
	tn := reflect.TypeOf(destStruct).Elem().Name()
	schema, ok := SchemaTree[tn]
	if !ok {
		return fmt.Errorf("could not find schema for type %s", tn )
	}
	var jsonTree interface{}
	if err := json.Unmarshal([]byte(data), &jsonTree); err != nil {
		return err
	}
	return ytypes.Unmarshal(schema, destStruct, jsonTree, opts...)
}

// Device represents the /device YANG schema element.
type Device struct {
	Components	*OpenconfigPlatform_Components	`path:"components" module:"openconfig-platform"`
	Interfaces	*OpenconfigInterfaces_Interfaces	`path:"interfaces" module:"openconfig-interfaces"`
	Messages	*OpenconfigMessages_Messages	`path:"messages" module:"openconfig-messages"`
	System	*OpenconfigSystem_System	`path:"system" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that Device implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*Device) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Device) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["Device"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Device) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *Device) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of Device.
func (*Device) ΛBelongingModule() string {
	return ""
}


// OpenconfigInterfaces_Interfaces represents the /openconfig-interfaces/interfaces YANG schema element.
type OpenconfigInterfaces_Interfaces struct {
	Interface	map[string]*OpenconfigInterfaces_Interfaces_Interface	`path:"interface" module:"openconfig-interfaces"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces) IsYANGGoStruct() {}

// NewInterface creates a new entry in the Interface list of the
// OpenconfigInterfaces_Interfaces struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigInterfaces_Interfaces) NewInterface(Name string) (*OpenconfigInterfaces_Interfaces_Interface, error){

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.Interface == nil {
		t.Interface = make(map[string]*OpenconfigInterfaces_Interfaces_Interface)
	}

	key := Name

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.Interface[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list Interface", key)
	}

	t.Interface[key] = &OpenconfigInterfaces_Interfaces_Interface{
		Name: &Name,
	}

	return t.Interface[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces.
func (*OpenconfigInterfaces_Interfaces) ΛBelongingModule() string {
	return "openconfig-interfaces"
}


// OpenconfigInterfaces_Interfaces_Interface represents the /openconfig-interfaces/interfaces/interface YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface struct {
	Config	*OpenconfigInterfaces_Interfaces_Interface_Config	`path:"config" module:"openconfig-interfaces"`
	HoldTime	*OpenconfigInterfaces_Interfaces_Interface_HoldTime	`path:"hold-time" module:"openconfig-interfaces"`
	Name	*string	`path:"name" module:"openconfig-interfaces"`
	State	*OpenconfigInterfaces_Interfaces_Interface_State	`path:"state" module:"openconfig-interfaces"`
	Subinterfaces	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces	`path:"subinterfaces" module:"openconfig-interfaces"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigInterfaces_Interfaces_Interface struct, which is a YANG list entry.
func (t *OpenconfigInterfaces_Interfaces_Interface) ΛListKeyMap() (map[string]interface{}, error) {
	if t.Name == nil {
		return nil, fmt.Errorf("nil value for key Name")
	}

	return map[string]interface{}{
		"name": *t.Name,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface.
func (*OpenconfigInterfaces_Interfaces_Interface) ΛBelongingModule() string {
	return "openconfig-interfaces"
}


// OpenconfigInterfaces_Interfaces_Interface_Config represents the /openconfig-interfaces/interfaces/interface/config YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Config struct {
	Description	*string	`path:"description" module:"openconfig-interfaces"`
	Enabled	*bool	`path:"enabled" module:"openconfig-interfaces"`
	LoopbackMode	*bool	`path:"loopback-mode" module:"openconfig-interfaces"`
	Mtu	*uint16	`path:"mtu" module:"openconfig-interfaces"`
	Name	*string	`path:"name" module:"openconfig-interfaces"`
	Type	E_IETFInterfaces_InterfaceType	`path:"type" module:"openconfig-interfaces"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Config.
func (*OpenconfigInterfaces_Interfaces_Interface_Config) ΛBelongingModule() string {
	return "openconfig-interfaces"
}


// OpenconfigInterfaces_Interfaces_Interface_HoldTime represents the /openconfig-interfaces/interfaces/interface/hold-time YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_HoldTime struct {
	Config	*OpenconfigInterfaces_Interfaces_Interface_HoldTime_Config	`path:"config" module:"openconfig-interfaces"`
	State	*OpenconfigInterfaces_Interfaces_Interface_HoldTime_State	`path:"state" module:"openconfig-interfaces"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_HoldTime implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_HoldTime) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_HoldTime) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_HoldTime"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_HoldTime) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_HoldTime) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_HoldTime.
func (*OpenconfigInterfaces_Interfaces_Interface_HoldTime) ΛBelongingModule() string {
	return "openconfig-interfaces"
}


// OpenconfigInterfaces_Interfaces_Interface_HoldTime_Config represents the /openconfig-interfaces/interfaces/interface/hold-time/config YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_HoldTime_Config struct {
	Down	*uint32	`path:"down" module:"openconfig-interfaces"`
	Up	*uint32	`path:"up" module:"openconfig-interfaces"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_HoldTime_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_HoldTime_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_HoldTime_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_HoldTime_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_HoldTime_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_HoldTime_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_HoldTime_Config.
func (*OpenconfigInterfaces_Interfaces_Interface_HoldTime_Config) ΛBelongingModule() string {
	return "openconfig-interfaces"
}


// OpenconfigInterfaces_Interfaces_Interface_HoldTime_State represents the /openconfig-interfaces/interfaces/interface/hold-time/state YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_HoldTime_State struct {
	Down	*uint32	`path:"down" module:"openconfig-interfaces"`
	Up	*uint32	`path:"up" module:"openconfig-interfaces"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_HoldTime_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_HoldTime_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_HoldTime_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_HoldTime_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_HoldTime_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_HoldTime_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_HoldTime_State.
func (*OpenconfigInterfaces_Interfaces_Interface_HoldTime_State) ΛBelongingModule() string {
	return "openconfig-interfaces"
}


// OpenconfigInterfaces_Interfaces_Interface_State represents the /openconfig-interfaces/interfaces/interface/state YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_State struct {
	AdminStatus	E_OpenconfigInterfaces_Interfaces_Interface_State_AdminStatus	`path:"admin-status" module:"openconfig-interfaces"`
	Counters	*OpenconfigInterfaces_Interfaces_Interface_State_Counters	`path:"counters" module:"openconfig-interfaces"`
	Cpu	*bool	`path:"cpu" module:"openconfig-interfaces"`
	Description	*string	`path:"description" module:"openconfig-interfaces"`
	Enabled	*bool	`path:"enabled" module:"openconfig-interfaces"`
	Ifindex	*uint32	`path:"ifindex" module:"openconfig-interfaces"`
	LastChange	*uint64	`path:"last-change" module:"openconfig-interfaces"`
	Logical	*bool	`path:"logical" module:"openconfig-interfaces"`
	LoopbackMode	*bool	`path:"loopback-mode" module:"openconfig-interfaces"`
	Management	*bool	`path:"management" module:"openconfig-interfaces"`
	Mtu	*uint16	`path:"mtu" module:"openconfig-interfaces"`
	Name	*string	`path:"name" module:"openconfig-interfaces"`
	OperStatus	E_OpenconfigInterfaces_Interfaces_Interface_State_OperStatus	`path:"oper-status" module:"openconfig-interfaces"`
	Type	E_IETFInterfaces_InterfaceType	`path:"type" module:"openconfig-interfaces"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_State.
func (*OpenconfigInterfaces_Interfaces_Interface_State) ΛBelongingModule() string {
	return "openconfig-interfaces"
}


// OpenconfigInterfaces_Interfaces_Interface_State_Counters represents the /openconfig-interfaces/interfaces/interface/state/counters YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_State_Counters struct {
	CarrierTransitions	*uint64	`path:"carrier-transitions" module:"openconfig-interfaces"`
	InBroadcastPkts	*uint64	`path:"in-broadcast-pkts" module:"openconfig-interfaces"`
	InDiscards	*uint64	`path:"in-discards" module:"openconfig-interfaces"`
	InErrors	*uint64	`path:"in-errors" module:"openconfig-interfaces"`
	InFcsErrors	*uint64	`path:"in-fcs-errors" module:"openconfig-interfaces"`
	InMulticastPkts	*uint64	`path:"in-multicast-pkts" module:"openconfig-interfaces"`
	InOctets	*uint64	`path:"in-octets" module:"openconfig-interfaces"`
	InPkts	*uint64	`path:"in-pkts" module:"openconfig-interfaces"`
	InUnicastPkts	*uint64	`path:"in-unicast-pkts" module:"openconfig-interfaces"`
	InUnknownProtos	*uint64	`path:"in-unknown-protos" module:"openconfig-interfaces"`
	LastClear	*uint64	`path:"last-clear" module:"openconfig-interfaces"`
	OutBroadcastPkts	*uint64	`path:"out-broadcast-pkts" module:"openconfig-interfaces"`
	OutDiscards	*uint64	`path:"out-discards" module:"openconfig-interfaces"`
	OutErrors	*uint64	`path:"out-errors" module:"openconfig-interfaces"`
	OutMulticastPkts	*uint64	`path:"out-multicast-pkts" module:"openconfig-interfaces"`
	OutOctets	*uint64	`path:"out-octets" module:"openconfig-interfaces"`
	OutPkts	*uint64	`path:"out-pkts" module:"openconfig-interfaces"`
	OutUnicastPkts	*uint64	`path:"out-unicast-pkts" module:"openconfig-interfaces"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_State_Counters implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_State_Counters) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_State_Counters) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_State_Counters"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_State_Counters) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_State_Counters) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_State_Counters.
func (*OpenconfigInterfaces_Interfaces_Interface_State_Counters) ΛBelongingModule() string {
	return "openconfig-interfaces"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces represents the /openconfig-interfaces/interfaces/interface/subinterfaces YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces struct {
	Subinterface	map[uint32]*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface	`path:"subinterface" module:"openconfig-interfaces"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces) IsYANGGoStruct() {}

// NewSubinterface creates a new entry in the Subinterface list of the
// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces) NewSubinterface(Index uint32) (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface, error){

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.Subinterface == nil {
		t.Subinterface = make(map[uint32]*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface)
	}

	key := Index

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.Subinterface[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list Subinterface", key)
	}

	t.Subinterface[key] = &OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface{
		Index: &Index,
	}

	return t.Subinterface[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces) ΛBelongingModule() string {
	return "openconfig-interfaces"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface struct {
	Config	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Config	`path:"config" module:"openconfig-interfaces"`
	Index	*uint32	`path:"index" module:"openconfig-interfaces"`
	State	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State	`path:"state" module:"openconfig-interfaces"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface struct, which is a YANG list entry.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface) ΛListKeyMap() (map[string]interface{}, error) {
	if t.Index == nil {
		return nil, fmt.Errorf("nil value for key Index")
	}

	return map[string]interface{}{
		"index": *t.Index,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface) ΛBelongingModule() string {
	return "openconfig-interfaces"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Config represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/config YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Config struct {
	Description	*string	`path:"description" module:"openconfig-interfaces"`
	Enabled	*bool	`path:"enabled" module:"openconfig-interfaces"`
	Index	*uint32	`path:"index" module:"openconfig-interfaces"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Config.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Config) ΛBelongingModule() string {
	return "openconfig-interfaces"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/state YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State struct {
	AdminStatus	E_OpenconfigInterfaces_Interfaces_Interface_State_AdminStatus	`path:"admin-status" module:"openconfig-interfaces"`
	Counters	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State_Counters	`path:"counters" module:"openconfig-interfaces"`
	Cpu	*bool	`path:"cpu" module:"openconfig-interfaces"`
	Description	*string	`path:"description" module:"openconfig-interfaces"`
	Enabled	*bool	`path:"enabled" module:"openconfig-interfaces"`
	Ifindex	*uint32	`path:"ifindex" module:"openconfig-interfaces"`
	Index	*uint32	`path:"index" module:"openconfig-interfaces"`
	LastChange	*uint64	`path:"last-change" module:"openconfig-interfaces"`
	Logical	*bool	`path:"logical" module:"openconfig-interfaces"`
	Management	*bool	`path:"management" module:"openconfig-interfaces"`
	Name	*string	`path:"name" module:"openconfig-interfaces"`
	OperStatus	E_OpenconfigInterfaces_Interfaces_Interface_State_OperStatus	`path:"oper-status" module:"openconfig-interfaces"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State) ΛBelongingModule() string {
	return "openconfig-interfaces"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State_Counters represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/state/counters YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State_Counters struct {
	CarrierTransitions	*uint64	`path:"carrier-transitions" module:"openconfig-interfaces"`
	InBroadcastPkts	*uint64	`path:"in-broadcast-pkts" module:"openconfig-interfaces"`
	InDiscards	*uint64	`path:"in-discards" module:"openconfig-interfaces"`
	InErrors	*uint64	`path:"in-errors" module:"openconfig-interfaces"`
	InFcsErrors	*uint64	`path:"in-fcs-errors" module:"openconfig-interfaces"`
	InMulticastPkts	*uint64	`path:"in-multicast-pkts" module:"openconfig-interfaces"`
	InOctets	*uint64	`path:"in-octets" module:"openconfig-interfaces"`
	InPkts	*uint64	`path:"in-pkts" module:"openconfig-interfaces"`
	InUnicastPkts	*uint64	`path:"in-unicast-pkts" module:"openconfig-interfaces"`
	InUnknownProtos	*uint64	`path:"in-unknown-protos" module:"openconfig-interfaces"`
	LastClear	*uint64	`path:"last-clear" module:"openconfig-interfaces"`
	OutBroadcastPkts	*uint64	`path:"out-broadcast-pkts" module:"openconfig-interfaces"`
	OutDiscards	*uint64	`path:"out-discards" module:"openconfig-interfaces"`
	OutErrors	*uint64	`path:"out-errors" module:"openconfig-interfaces"`
	OutMulticastPkts	*uint64	`path:"out-multicast-pkts" module:"openconfig-interfaces"`
	OutOctets	*uint64	`path:"out-octets" module:"openconfig-interfaces"`
	OutPkts	*uint64	`path:"out-pkts" module:"openconfig-interfaces"`
	OutUnicastPkts	*uint64	`path:"out-unicast-pkts" module:"openconfig-interfaces"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State_Counters implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State_Counters) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State_Counters) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State_Counters"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State_Counters) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State_Counters) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State_Counters.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State_Counters) ΛBelongingModule() string {
	return "openconfig-interfaces"
}


// OpenconfigMessages_Messages represents the /openconfig-messages/messages YANG schema element.
type OpenconfigMessages_Messages struct {
	Config	*OpenconfigMessages_Messages_Config	`path:"config" module:"openconfig-messages"`
	DebugEntries	*OpenconfigMessages_Messages_DebugEntries	`path:"debug-entries" module:"openconfig-messages"`
	State	*OpenconfigMessages_Messages_State	`path:"state" module:"openconfig-messages"`
}

// IsYANGGoStruct ensures that OpenconfigMessages_Messages implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigMessages_Messages) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigMessages_Messages) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigMessages_Messages"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigMessages_Messages) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigMessages_Messages) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigMessages_Messages.
func (*OpenconfigMessages_Messages) ΛBelongingModule() string {
	return "openconfig-messages"
}


// OpenconfigMessages_Messages_Config represents the /openconfig-messages/messages/config YANG schema element.
type OpenconfigMessages_Messages_Config struct {
	Severity	E_OpenconfigMessages_SyslogSeverity	`path:"severity" module:"openconfig-messages"`
}

// IsYANGGoStruct ensures that OpenconfigMessages_Messages_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigMessages_Messages_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigMessages_Messages_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigMessages_Messages_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigMessages_Messages_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigMessages_Messages_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigMessages_Messages_Config.
func (*OpenconfigMessages_Messages_Config) ΛBelongingModule() string {
	return "openconfig-messages"
}


// OpenconfigMessages_Messages_DebugEntries represents the /openconfig-messages/messages/debug-entries YANG schema element.
type OpenconfigMessages_Messages_DebugEntries struct {
	DebugService	map[E_OpenconfigMessages_DEBUG_SERVICE]*OpenconfigMessages_Messages_DebugEntries_DebugService	`path:"debug-service" module:"openconfig-messages"`
}

// IsYANGGoStruct ensures that OpenconfigMessages_Messages_DebugEntries implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigMessages_Messages_DebugEntries) IsYANGGoStruct() {}

// NewDebugService creates a new entry in the DebugService list of the
// OpenconfigMessages_Messages_DebugEntries struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigMessages_Messages_DebugEntries) NewDebugService(Service E_OpenconfigMessages_DEBUG_SERVICE) (*OpenconfigMessages_Messages_DebugEntries_DebugService, error){

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.DebugService == nil {
		t.DebugService = make(map[E_OpenconfigMessages_DEBUG_SERVICE]*OpenconfigMessages_Messages_DebugEntries_DebugService)
	}

	key := Service

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.DebugService[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list DebugService", key)
	}

	t.DebugService[key] = &OpenconfigMessages_Messages_DebugEntries_DebugService{
		Service: Service,
	}

	return t.DebugService[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigMessages_Messages_DebugEntries) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigMessages_Messages_DebugEntries"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigMessages_Messages_DebugEntries) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigMessages_Messages_DebugEntries) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigMessages_Messages_DebugEntries.
func (*OpenconfigMessages_Messages_DebugEntries) ΛBelongingModule() string {
	return "openconfig-messages"
}


// OpenconfigMessages_Messages_DebugEntries_DebugService represents the /openconfig-messages/messages/debug-entries/debug-service YANG schema element.
type OpenconfigMessages_Messages_DebugEntries_DebugService struct {
	Config	*OpenconfigMessages_Messages_DebugEntries_DebugService_Config	`path:"config" module:"openconfig-messages"`
	Service	E_OpenconfigMessages_DEBUG_SERVICE	`path:"service" module:"openconfig-messages"`
	State	*OpenconfigMessages_Messages_DebugEntries_DebugService_State	`path:"state" module:"openconfig-messages"`
}

// IsYANGGoStruct ensures that OpenconfigMessages_Messages_DebugEntries_DebugService implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigMessages_Messages_DebugEntries_DebugService) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigMessages_Messages_DebugEntries_DebugService struct, which is a YANG list entry.
func (t *OpenconfigMessages_Messages_DebugEntries_DebugService) ΛListKeyMap() (map[string]interface{}, error) {

	return map[string]interface{}{
		"service": t.Service,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigMessages_Messages_DebugEntries_DebugService) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigMessages_Messages_DebugEntries_DebugService"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigMessages_Messages_DebugEntries_DebugService) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigMessages_Messages_DebugEntries_DebugService) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigMessages_Messages_DebugEntries_DebugService.
func (*OpenconfigMessages_Messages_DebugEntries_DebugService) ΛBelongingModule() string {
	return "openconfig-messages"
}


// OpenconfigMessages_Messages_DebugEntries_DebugService_Config represents the /openconfig-messages/messages/debug-entries/debug-service/config YANG schema element.
type OpenconfigMessages_Messages_DebugEntries_DebugService_Config struct {
	Enabled	*bool	`path:"enabled" module:"openconfig-messages"`
	Service	E_OpenconfigMessages_DEBUG_SERVICE	`path:"service" module:"openconfig-messages"`
}

// IsYANGGoStruct ensures that OpenconfigMessages_Messages_DebugEntries_DebugService_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigMessages_Messages_DebugEntries_DebugService_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigMessages_Messages_DebugEntries_DebugService_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigMessages_Messages_DebugEntries_DebugService_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigMessages_Messages_DebugEntries_DebugService_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigMessages_Messages_DebugEntries_DebugService_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigMessages_Messages_DebugEntries_DebugService_Config.
func (*OpenconfigMessages_Messages_DebugEntries_DebugService_Config) ΛBelongingModule() string {
	return "openconfig-messages"
}


// OpenconfigMessages_Messages_DebugEntries_DebugService_State represents the /openconfig-messages/messages/debug-entries/debug-service/state YANG schema element.
type OpenconfigMessages_Messages_DebugEntries_DebugService_State struct {
	Enabled	*bool	`path:"enabled" module:"openconfig-messages"`
	Service	E_OpenconfigMessages_DEBUG_SERVICE	`path:"service" module:"openconfig-messages"`
}

// IsYANGGoStruct ensures that OpenconfigMessages_Messages_DebugEntries_DebugService_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigMessages_Messages_DebugEntries_DebugService_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigMessages_Messages_DebugEntries_DebugService_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigMessages_Messages_DebugEntries_DebugService_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigMessages_Messages_DebugEntries_DebugService_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigMessages_Messages_DebugEntries_DebugService_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigMessages_Messages_DebugEntries_DebugService_State.
func (*OpenconfigMessages_Messages_DebugEntries_DebugService_State) ΛBelongingModule() string {
	return "openconfig-messages"
}


// OpenconfigMessages_Messages_State represents the /openconfig-messages/messages/state YANG schema element.
type OpenconfigMessages_Messages_State struct {
	Message	*OpenconfigMessages_Messages_State_Message	`path:"message" module:"openconfig-messages"`
	Severity	E_OpenconfigMessages_SyslogSeverity	`path:"severity" module:"openconfig-messages"`
}

// IsYANGGoStruct ensures that OpenconfigMessages_Messages_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigMessages_Messages_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigMessages_Messages_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigMessages_Messages_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigMessages_Messages_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigMessages_Messages_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigMessages_Messages_State.
func (*OpenconfigMessages_Messages_State) ΛBelongingModule() string {
	return "openconfig-messages"
}


// OpenconfigMessages_Messages_State_Message represents the /openconfig-messages/messages/state/message YANG schema element.
type OpenconfigMessages_Messages_State_Message struct {
	AppName	*string	`path:"app-name" module:"openconfig-messages"`
	Msg	*string	`path:"msg" module:"openconfig-messages"`
	Msgid	*string	`path:"msgid" module:"openconfig-messages"`
	Priority	*uint8	`path:"priority" module:"openconfig-messages"`
	Procid	*string	`path:"procid" module:"openconfig-messages"`
}

// IsYANGGoStruct ensures that OpenconfigMessages_Messages_State_Message implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigMessages_Messages_State_Message) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigMessages_Messages_State_Message) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigMessages_Messages_State_Message"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigMessages_Messages_State_Message) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigMessages_Messages_State_Message) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigMessages_Messages_State_Message.
func (*OpenconfigMessages_Messages_State_Message) ΛBelongingModule() string {
	return "openconfig-messages"
}


// OpenconfigPlatform_Components represents the /openconfig-platform/components YANG schema element.
type OpenconfigPlatform_Components struct {
	Component	map[string]*OpenconfigPlatform_Components_Component	`path:"component" module:"openconfig-platform"`
}

// IsYANGGoStruct ensures that OpenconfigPlatform_Components implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigPlatform_Components) IsYANGGoStruct() {}

// NewComponent creates a new entry in the Component list of the
// OpenconfigPlatform_Components struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigPlatform_Components) NewComponent(Name string) (*OpenconfigPlatform_Components_Component, error){

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.Component == nil {
		t.Component = make(map[string]*OpenconfigPlatform_Components_Component)
	}

	key := Name

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.Component[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list Component", key)
	}

	t.Component[key] = &OpenconfigPlatform_Components_Component{
		Name: &Name,
	}

	return t.Component[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigPlatform_Components"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigPlatform_Components) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigPlatform_Components.
func (*OpenconfigPlatform_Components) ΛBelongingModule() string {
	return "openconfig-platform"
}


// OpenconfigPlatform_Components_Component represents the /openconfig-platform/components/component YANG schema element.
type OpenconfigPlatform_Components_Component struct {
	Backplane	*OpenconfigPlatform_Components_Component_Backplane	`path:"backplane" module:"openconfig-platform"`
	Chassis	*OpenconfigPlatform_Components_Component_Chassis	`path:"chassis" module:"openconfig-platform"`
	Config	*OpenconfigPlatform_Components_Component_Config	`path:"config" module:"openconfig-platform"`
	Cpu	*OpenconfigPlatform_Components_Component_Cpu	`path:"cpu" module:"openconfig-platform"`
	Fabric	*OpenconfigPlatform_Components_Component_Fabric	`path:"fabric" module:"openconfig-platform"`
	Fan	*OpenconfigPlatform_Components_Component_Fan	`path:"fan" module:"openconfig-platform"`
	IntegratedCircuit	*OpenconfigPlatform_Components_Component_IntegratedCircuit	`path:"integrated-circuit" module:"openconfig-platform"`
	Name	*string	`path:"name" module:"openconfig-platform"`
	Port	*OpenconfigPlatform_Components_Component_Port	`path:"port" module:"openconfig-platform"`
	PowerSupply	*OpenconfigPlatform_Components_Component_PowerSupply	`path:"power-supply" module:"openconfig-platform"`
	Properties	*OpenconfigPlatform_Components_Component_Properties	`path:"properties" module:"openconfig-platform"`
	SoftwareModule	*OpenconfigPlatform_Components_Component_SoftwareModule	`path:"software-module" module:"openconfig-platform"`
	State	*OpenconfigPlatform_Components_Component_State	`path:"state" module:"openconfig-platform"`
	Storage	*OpenconfigPlatform_Components_Component_Storage	`path:"storage" module:"openconfig-platform"`
	Subcomponents	*OpenconfigPlatform_Components_Component_Subcomponents	`path:"subcomponents" module:"openconfig-platform"`
}

// IsYANGGoStruct ensures that OpenconfigPlatform_Components_Component implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigPlatform_Components_Component) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigPlatform_Components_Component struct, which is a YANG list entry.
func (t *OpenconfigPlatform_Components_Component) ΛListKeyMap() (map[string]interface{}, error) {
	if t.Name == nil {
		return nil, fmt.Errorf("nil value for key Name")
	}

	return map[string]interface{}{
		"name": *t.Name,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigPlatform_Components_Component"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigPlatform_Components_Component) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigPlatform_Components_Component.
func (*OpenconfigPlatform_Components_Component) ΛBelongingModule() string {
	return "openconfig-platform"
}


// OpenconfigPlatform_Components_Component_Backplane represents the /openconfig-platform/components/component/backplane YANG schema element.
type OpenconfigPlatform_Components_Component_Backplane struct {
	Config	*OpenconfigPlatform_Components_Component_Backplane_Config	`path:"config" module:"openconfig-platform"`
	State	*OpenconfigPlatform_Components_Component_Backplane_State	`path:"state" module:"openconfig-platform"`
}

// IsYANGGoStruct ensures that OpenconfigPlatform_Components_Component_Backplane implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigPlatform_Components_Component_Backplane) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_Backplane) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigPlatform_Components_Component_Backplane"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_Backplane) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigPlatform_Components_Component_Backplane) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigPlatform_Components_Component_Backplane.
func (*OpenconfigPlatform_Components_Component_Backplane) ΛBelongingModule() string {
	return "openconfig-platform"
}


// OpenconfigPlatform_Components_Component_Backplane_Config represents the /openconfig-platform/components/component/backplane/config YANG schema element.
type OpenconfigPlatform_Components_Component_Backplane_Config struct {
}

// IsYANGGoStruct ensures that OpenconfigPlatform_Components_Component_Backplane_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigPlatform_Components_Component_Backplane_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_Backplane_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigPlatform_Components_Component_Backplane_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_Backplane_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigPlatform_Components_Component_Backplane_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigPlatform_Components_Component_Backplane_Config.
func (*OpenconfigPlatform_Components_Component_Backplane_Config) ΛBelongingModule() string {
	return "openconfig-platform"
}


// OpenconfigPlatform_Components_Component_Backplane_State represents the /openconfig-platform/components/component/backplane/state YANG schema element.
type OpenconfigPlatform_Components_Component_Backplane_State struct {
}

// IsYANGGoStruct ensures that OpenconfigPlatform_Components_Component_Backplane_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigPlatform_Components_Component_Backplane_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_Backplane_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigPlatform_Components_Component_Backplane_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_Backplane_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigPlatform_Components_Component_Backplane_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigPlatform_Components_Component_Backplane_State.
func (*OpenconfigPlatform_Components_Component_Backplane_State) ΛBelongingModule() string {
	return "openconfig-platform"
}


// OpenconfigPlatform_Components_Component_Chassis represents the /openconfig-platform/components/component/chassis YANG schema element.
type OpenconfigPlatform_Components_Component_Chassis struct {
	Config	*OpenconfigPlatform_Components_Component_Chassis_Config	`path:"config" module:"openconfig-platform"`
	State	*OpenconfigPlatform_Components_Component_Chassis_State	`path:"state" module:"openconfig-platform"`
}

// IsYANGGoStruct ensures that OpenconfigPlatform_Components_Component_Chassis implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigPlatform_Components_Component_Chassis) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_Chassis) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigPlatform_Components_Component_Chassis"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_Chassis) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigPlatform_Components_Component_Chassis) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigPlatform_Components_Component_Chassis.
func (*OpenconfigPlatform_Components_Component_Chassis) ΛBelongingModule() string {
	return "openconfig-platform"
}


// OpenconfigPlatform_Components_Component_Chassis_Config represents the /openconfig-platform/components/component/chassis/config YANG schema element.
type OpenconfigPlatform_Components_Component_Chassis_Config struct {
}

// IsYANGGoStruct ensures that OpenconfigPlatform_Components_Component_Chassis_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigPlatform_Components_Component_Chassis_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_Chassis_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigPlatform_Components_Component_Chassis_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_Chassis_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigPlatform_Components_Component_Chassis_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigPlatform_Components_Component_Chassis_Config.
func (*OpenconfigPlatform_Components_Component_Chassis_Config) ΛBelongingModule() string {
	return "openconfig-platform"
}


// OpenconfigPlatform_Components_Component_Chassis_State represents the /openconfig-platform/components/component/chassis/state YANG schema element.
type OpenconfigPlatform_Components_Component_Chassis_State struct {
}

// IsYANGGoStruct ensures that OpenconfigPlatform_Components_Component_Chassis_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigPlatform_Components_Component_Chassis_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_Chassis_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigPlatform_Components_Component_Chassis_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_Chassis_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigPlatform_Components_Component_Chassis_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigPlatform_Components_Component_Chassis_State.
func (*OpenconfigPlatform_Components_Component_Chassis_State) ΛBelongingModule() string {
	return "openconfig-platform"
}


// OpenconfigPlatform_Components_Component_Config represents the /openconfig-platform/components/component/config YANG schema element.
type OpenconfigPlatform_Components_Component_Config struct {
	Name	*string	`path:"name" module:"openconfig-platform"`
}

// IsYANGGoStruct ensures that OpenconfigPlatform_Components_Component_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigPlatform_Components_Component_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigPlatform_Components_Component_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigPlatform_Components_Component_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigPlatform_Components_Component_Config.
func (*OpenconfigPlatform_Components_Component_Config) ΛBelongingModule() string {
	return "openconfig-platform"
}


// OpenconfigPlatform_Components_Component_Cpu represents the /openconfig-platform/components/component/cpu YANG schema element.
type OpenconfigPlatform_Components_Component_Cpu struct {
	Config	*OpenconfigPlatform_Components_Component_Cpu_Config	`path:"config" module:"openconfig-platform"`
	State	*OpenconfigPlatform_Components_Component_Cpu_State	`path:"state" module:"openconfig-platform"`
}

// IsYANGGoStruct ensures that OpenconfigPlatform_Components_Component_Cpu implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigPlatform_Components_Component_Cpu) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_Cpu) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigPlatform_Components_Component_Cpu"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_Cpu) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigPlatform_Components_Component_Cpu) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigPlatform_Components_Component_Cpu.
func (*OpenconfigPlatform_Components_Component_Cpu) ΛBelongingModule() string {
	return "openconfig-platform"
}


// OpenconfigPlatform_Components_Component_Cpu_Config represents the /openconfig-platform/components/component/cpu/config YANG schema element.
type OpenconfigPlatform_Components_Component_Cpu_Config struct {
}

// IsYANGGoStruct ensures that OpenconfigPlatform_Components_Component_Cpu_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigPlatform_Components_Component_Cpu_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_Cpu_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigPlatform_Components_Component_Cpu_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_Cpu_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigPlatform_Components_Component_Cpu_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigPlatform_Components_Component_Cpu_Config.
func (*OpenconfigPlatform_Components_Component_Cpu_Config) ΛBelongingModule() string {
	return "openconfig-platform"
}


// OpenconfigPlatform_Components_Component_Cpu_State represents the /openconfig-platform/components/component/cpu/state YANG schema element.
type OpenconfigPlatform_Components_Component_Cpu_State struct {
}

// IsYANGGoStruct ensures that OpenconfigPlatform_Components_Component_Cpu_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigPlatform_Components_Component_Cpu_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_Cpu_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigPlatform_Components_Component_Cpu_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_Cpu_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigPlatform_Components_Component_Cpu_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigPlatform_Components_Component_Cpu_State.
func (*OpenconfigPlatform_Components_Component_Cpu_State) ΛBelongingModule() string {
	return "openconfig-platform"
}


// OpenconfigPlatform_Components_Component_Fabric represents the /openconfig-platform/components/component/fabric YANG schema element.
type OpenconfigPlatform_Components_Component_Fabric struct {
	Config	*OpenconfigPlatform_Components_Component_Fabric_Config	`path:"config" module:"openconfig-platform"`
	State	*OpenconfigPlatform_Components_Component_Fabric_State	`path:"state" module:"openconfig-platform"`
}

// IsYANGGoStruct ensures that OpenconfigPlatform_Components_Component_Fabric implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigPlatform_Components_Component_Fabric) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_Fabric) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigPlatform_Components_Component_Fabric"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_Fabric) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigPlatform_Components_Component_Fabric) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigPlatform_Components_Component_Fabric.
func (*OpenconfigPlatform_Components_Component_Fabric) ΛBelongingModule() string {
	return "openconfig-platform"
}


// OpenconfigPlatform_Components_Component_Fabric_Config represents the /openconfig-platform/components/component/fabric/config YANG schema element.
type OpenconfigPlatform_Components_Component_Fabric_Config struct {
}

// IsYANGGoStruct ensures that OpenconfigPlatform_Components_Component_Fabric_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigPlatform_Components_Component_Fabric_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_Fabric_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigPlatform_Components_Component_Fabric_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_Fabric_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigPlatform_Components_Component_Fabric_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigPlatform_Components_Component_Fabric_Config.
func (*OpenconfigPlatform_Components_Component_Fabric_Config) ΛBelongingModule() string {
	return "openconfig-platform"
}


// OpenconfigPlatform_Components_Component_Fabric_State represents the /openconfig-platform/components/component/fabric/state YANG schema element.
type OpenconfigPlatform_Components_Component_Fabric_State struct {
}

// IsYANGGoStruct ensures that OpenconfigPlatform_Components_Component_Fabric_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigPlatform_Components_Component_Fabric_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_Fabric_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigPlatform_Components_Component_Fabric_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_Fabric_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigPlatform_Components_Component_Fabric_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigPlatform_Components_Component_Fabric_State.
func (*OpenconfigPlatform_Components_Component_Fabric_State) ΛBelongingModule() string {
	return "openconfig-platform"
}


// OpenconfigPlatform_Components_Component_Fan represents the /openconfig-platform/components/component/fan YANG schema element.
type OpenconfigPlatform_Components_Component_Fan struct {
	Config	*OpenconfigPlatform_Components_Component_Fan_Config	`path:"config" module:"openconfig-platform"`
	State	*OpenconfigPlatform_Components_Component_Fan_State	`path:"state" module:"openconfig-platform"`
}

// IsYANGGoStruct ensures that OpenconfigPlatform_Components_Component_Fan implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigPlatform_Components_Component_Fan) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_Fan) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigPlatform_Components_Component_Fan"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_Fan) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigPlatform_Components_Component_Fan) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigPlatform_Components_Component_Fan.
func (*OpenconfigPlatform_Components_Component_Fan) ΛBelongingModule() string {
	return "openconfig-platform"
}


// OpenconfigPlatform_Components_Component_Fan_Config represents the /openconfig-platform/components/component/fan/config YANG schema element.
type OpenconfigPlatform_Components_Component_Fan_Config struct {
}

// IsYANGGoStruct ensures that OpenconfigPlatform_Components_Component_Fan_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigPlatform_Components_Component_Fan_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_Fan_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigPlatform_Components_Component_Fan_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_Fan_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigPlatform_Components_Component_Fan_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigPlatform_Components_Component_Fan_Config.
func (*OpenconfigPlatform_Components_Component_Fan_Config) ΛBelongingModule() string {
	return "openconfig-platform"
}


// OpenconfigPlatform_Components_Component_Fan_State represents the /openconfig-platform/components/component/fan/state YANG schema element.
type OpenconfigPlatform_Components_Component_Fan_State struct {
}

// IsYANGGoStruct ensures that OpenconfigPlatform_Components_Component_Fan_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigPlatform_Components_Component_Fan_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_Fan_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigPlatform_Components_Component_Fan_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_Fan_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigPlatform_Components_Component_Fan_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigPlatform_Components_Component_Fan_State.
func (*OpenconfigPlatform_Components_Component_Fan_State) ΛBelongingModule() string {
	return "openconfig-platform"
}


// OpenconfigPlatform_Components_Component_IntegratedCircuit represents the /openconfig-platform/components/component/integrated-circuit YANG schema element.
type OpenconfigPlatform_Components_Component_IntegratedCircuit struct {
	Config	*OpenconfigPlatform_Components_Component_IntegratedCircuit_Config	`path:"config" module:"openconfig-platform"`
	State	*OpenconfigPlatform_Components_Component_IntegratedCircuit_State	`path:"state" module:"openconfig-platform"`
}

// IsYANGGoStruct ensures that OpenconfigPlatform_Components_Component_IntegratedCircuit implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigPlatform_Components_Component_IntegratedCircuit) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_IntegratedCircuit) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigPlatform_Components_Component_IntegratedCircuit"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_IntegratedCircuit) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigPlatform_Components_Component_IntegratedCircuit) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigPlatform_Components_Component_IntegratedCircuit.
func (*OpenconfigPlatform_Components_Component_IntegratedCircuit) ΛBelongingModule() string {
	return "openconfig-platform"
}


// OpenconfigPlatform_Components_Component_IntegratedCircuit_Config represents the /openconfig-platform/components/component/integrated-circuit/config YANG schema element.
type OpenconfigPlatform_Components_Component_IntegratedCircuit_Config struct {
}

// IsYANGGoStruct ensures that OpenconfigPlatform_Components_Component_IntegratedCircuit_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigPlatform_Components_Component_IntegratedCircuit_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_IntegratedCircuit_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigPlatform_Components_Component_IntegratedCircuit_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_IntegratedCircuit_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigPlatform_Components_Component_IntegratedCircuit_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigPlatform_Components_Component_IntegratedCircuit_Config.
func (*OpenconfigPlatform_Components_Component_IntegratedCircuit_Config) ΛBelongingModule() string {
	return "openconfig-platform"
}


// OpenconfigPlatform_Components_Component_IntegratedCircuit_State represents the /openconfig-platform/components/component/integrated-circuit/state YANG schema element.
type OpenconfigPlatform_Components_Component_IntegratedCircuit_State struct {
}

// IsYANGGoStruct ensures that OpenconfigPlatform_Components_Component_IntegratedCircuit_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigPlatform_Components_Component_IntegratedCircuit_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_IntegratedCircuit_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigPlatform_Components_Component_IntegratedCircuit_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_IntegratedCircuit_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigPlatform_Components_Component_IntegratedCircuit_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigPlatform_Components_Component_IntegratedCircuit_State.
func (*OpenconfigPlatform_Components_Component_IntegratedCircuit_State) ΛBelongingModule() string {
	return "openconfig-platform"
}


// OpenconfigPlatform_Components_Component_Port represents the /openconfig-platform/components/component/port YANG schema element.
type OpenconfigPlatform_Components_Component_Port struct {
	Config	*OpenconfigPlatform_Components_Component_Port_Config	`path:"config" module:"openconfig-platform"`
	State	*OpenconfigPlatform_Components_Component_Port_State	`path:"state" module:"openconfig-platform"`
}

// IsYANGGoStruct ensures that OpenconfigPlatform_Components_Component_Port implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigPlatform_Components_Component_Port) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_Port) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigPlatform_Components_Component_Port"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_Port) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigPlatform_Components_Component_Port) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigPlatform_Components_Component_Port.
func (*OpenconfigPlatform_Components_Component_Port) ΛBelongingModule() string {
	return "openconfig-platform"
}


// OpenconfigPlatform_Components_Component_Port_Config represents the /openconfig-platform/components/component/port/config YANG schema element.
type OpenconfigPlatform_Components_Component_Port_Config struct {
}

// IsYANGGoStruct ensures that OpenconfigPlatform_Components_Component_Port_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigPlatform_Components_Component_Port_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_Port_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigPlatform_Components_Component_Port_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_Port_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigPlatform_Components_Component_Port_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigPlatform_Components_Component_Port_Config.
func (*OpenconfigPlatform_Components_Component_Port_Config) ΛBelongingModule() string {
	return "openconfig-platform"
}


// OpenconfigPlatform_Components_Component_Port_State represents the /openconfig-platform/components/component/port/state YANG schema element.
type OpenconfigPlatform_Components_Component_Port_State struct {
}

// IsYANGGoStruct ensures that OpenconfigPlatform_Components_Component_Port_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigPlatform_Components_Component_Port_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_Port_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigPlatform_Components_Component_Port_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_Port_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigPlatform_Components_Component_Port_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigPlatform_Components_Component_Port_State.
func (*OpenconfigPlatform_Components_Component_Port_State) ΛBelongingModule() string {
	return "openconfig-platform"
}


// OpenconfigPlatform_Components_Component_PowerSupply represents the /openconfig-platform/components/component/power-supply YANG schema element.
type OpenconfigPlatform_Components_Component_PowerSupply struct {
	Config	*OpenconfigPlatform_Components_Component_PowerSupply_Config	`path:"config" module:"openconfig-platform"`
	State	*OpenconfigPlatform_Components_Component_PowerSupply_State	`path:"state" module:"openconfig-platform"`
}

// IsYANGGoStruct ensures that OpenconfigPlatform_Components_Component_PowerSupply implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigPlatform_Components_Component_PowerSupply) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_PowerSupply) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigPlatform_Components_Component_PowerSupply"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_PowerSupply) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigPlatform_Components_Component_PowerSupply) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigPlatform_Components_Component_PowerSupply.
func (*OpenconfigPlatform_Components_Component_PowerSupply) ΛBelongingModule() string {
	return "openconfig-platform"
}


// OpenconfigPlatform_Components_Component_PowerSupply_Config represents the /openconfig-platform/components/component/power-supply/config YANG schema element.
type OpenconfigPlatform_Components_Component_PowerSupply_Config struct {
}

// IsYANGGoStruct ensures that OpenconfigPlatform_Components_Component_PowerSupply_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigPlatform_Components_Component_PowerSupply_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_PowerSupply_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigPlatform_Components_Component_PowerSupply_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_PowerSupply_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigPlatform_Components_Component_PowerSupply_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigPlatform_Components_Component_PowerSupply_Config.
func (*OpenconfigPlatform_Components_Component_PowerSupply_Config) ΛBelongingModule() string {
	return "openconfig-platform"
}


// OpenconfigPlatform_Components_Component_PowerSupply_State represents the /openconfig-platform/components/component/power-supply/state YANG schema element.
type OpenconfigPlatform_Components_Component_PowerSupply_State struct {
}

// IsYANGGoStruct ensures that OpenconfigPlatform_Components_Component_PowerSupply_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigPlatform_Components_Component_PowerSupply_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_PowerSupply_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigPlatform_Components_Component_PowerSupply_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_PowerSupply_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigPlatform_Components_Component_PowerSupply_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigPlatform_Components_Component_PowerSupply_State.
func (*OpenconfigPlatform_Components_Component_PowerSupply_State) ΛBelongingModule() string {
	return "openconfig-platform"
}


// OpenconfigPlatform_Components_Component_Properties represents the /openconfig-platform/components/component/properties YANG schema element.
type OpenconfigPlatform_Components_Component_Properties struct {
	Property	map[string]*OpenconfigPlatform_Components_Component_Properties_Property	`path:"property" module:"openconfig-platform"`
}

// IsYANGGoStruct ensures that OpenconfigPlatform_Components_Component_Properties implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigPlatform_Components_Component_Properties) IsYANGGoStruct() {}

// NewProperty creates a new entry in the Property list of the
// OpenconfigPlatform_Components_Component_Properties struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigPlatform_Components_Component_Properties) NewProperty(Name string) (*OpenconfigPlatform_Components_Component_Properties_Property, error){

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.Property == nil {
		t.Property = make(map[string]*OpenconfigPlatform_Components_Component_Properties_Property)
	}

	key := Name

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.Property[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list Property", key)
	}

	t.Property[key] = &OpenconfigPlatform_Components_Component_Properties_Property{
		Name: &Name,
	}

	return t.Property[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_Properties) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigPlatform_Components_Component_Properties"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_Properties) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigPlatform_Components_Component_Properties) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigPlatform_Components_Component_Properties.
func (*OpenconfigPlatform_Components_Component_Properties) ΛBelongingModule() string {
	return "openconfig-platform"
}


// OpenconfigPlatform_Components_Component_Properties_Property represents the /openconfig-platform/components/component/properties/property YANG schema element.
type OpenconfigPlatform_Components_Component_Properties_Property struct {
	Config	*OpenconfigPlatform_Components_Component_Properties_Property_Config	`path:"config" module:"openconfig-platform"`
	Name	*string	`path:"name" module:"openconfig-platform"`
	State	*OpenconfigPlatform_Components_Component_Properties_Property_State	`path:"state" module:"openconfig-platform"`
}

// IsYANGGoStruct ensures that OpenconfigPlatform_Components_Component_Properties_Property implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigPlatform_Components_Component_Properties_Property) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigPlatform_Components_Component_Properties_Property struct, which is a YANG list entry.
func (t *OpenconfigPlatform_Components_Component_Properties_Property) ΛListKeyMap() (map[string]interface{}, error) {
	if t.Name == nil {
		return nil, fmt.Errorf("nil value for key Name")
	}

	return map[string]interface{}{
		"name": *t.Name,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_Properties_Property) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigPlatform_Components_Component_Properties_Property"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_Properties_Property) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigPlatform_Components_Component_Properties_Property) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigPlatform_Components_Component_Properties_Property.
func (*OpenconfigPlatform_Components_Component_Properties_Property) ΛBelongingModule() string {
	return "openconfig-platform"
}


// OpenconfigPlatform_Components_Component_Properties_Property_Config represents the /openconfig-platform/components/component/properties/property/config YANG schema element.
type OpenconfigPlatform_Components_Component_Properties_Property_Config struct {
	Name	*string	`path:"name" module:"openconfig-platform"`
	Value	OpenconfigPlatform_Components_Component_Properties_Property_Config_Value_Union	`path:"value" module:"openconfig-platform"`
}

// IsYANGGoStruct ensures that OpenconfigPlatform_Components_Component_Properties_Property_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigPlatform_Components_Component_Properties_Property_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_Properties_Property_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigPlatform_Components_Component_Properties_Property_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_Properties_Property_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigPlatform_Components_Component_Properties_Property_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigPlatform_Components_Component_Properties_Property_Config.
func (*OpenconfigPlatform_Components_Component_Properties_Property_Config) ΛBelongingModule() string {
	return "openconfig-platform"
}

// OpenconfigPlatform_Components_Component_Properties_Property_Config_Value_Union is an interface that is implemented by valid types for the union
// for the leaf /openconfig-platform/components/component/properties/property/config/value within the YANG schema.
type OpenconfigPlatform_Components_Component_Properties_Property_Config_Value_Union interface {
	Is_OpenconfigPlatform_Components_Component_Properties_Property_Config_Value_Union()
}

// OpenconfigPlatform_Components_Component_Properties_Property_Config_Value_Union_Bool is used when /openconfig-platform/components/component/properties/property/config/value
// is to be set to a bool value.
type OpenconfigPlatform_Components_Component_Properties_Property_Config_Value_Union_Bool struct {
	Bool	bool
}

// Is_OpenconfigPlatform_Components_Component_Properties_Property_Config_Value_Union ensures that OpenconfigPlatform_Components_Component_Properties_Property_Config_Value_Union_Bool
// implements the OpenconfigPlatform_Components_Component_Properties_Property_Config_Value_Union interface.
func (*OpenconfigPlatform_Components_Component_Properties_Property_Config_Value_Union_Bool) Is_OpenconfigPlatform_Components_Component_Properties_Property_Config_Value_Union() {}

// OpenconfigPlatform_Components_Component_Properties_Property_Config_Value_Union_Float64 is used when /openconfig-platform/components/component/properties/property/config/value
// is to be set to a float64 value.
type OpenconfigPlatform_Components_Component_Properties_Property_Config_Value_Union_Float64 struct {
	Float64	float64
}

// Is_OpenconfigPlatform_Components_Component_Properties_Property_Config_Value_Union ensures that OpenconfigPlatform_Components_Component_Properties_Property_Config_Value_Union_Float64
// implements the OpenconfigPlatform_Components_Component_Properties_Property_Config_Value_Union interface.
func (*OpenconfigPlatform_Components_Component_Properties_Property_Config_Value_Union_Float64) Is_OpenconfigPlatform_Components_Component_Properties_Property_Config_Value_Union() {}

// OpenconfigPlatform_Components_Component_Properties_Property_Config_Value_Union_Int64 is used when /openconfig-platform/components/component/properties/property/config/value
// is to be set to a int64 value.
type OpenconfigPlatform_Components_Component_Properties_Property_Config_Value_Union_Int64 struct {
	Int64	int64
}

// Is_OpenconfigPlatform_Components_Component_Properties_Property_Config_Value_Union ensures that OpenconfigPlatform_Components_Component_Properties_Property_Config_Value_Union_Int64
// implements the OpenconfigPlatform_Components_Component_Properties_Property_Config_Value_Union interface.
func (*OpenconfigPlatform_Components_Component_Properties_Property_Config_Value_Union_Int64) Is_OpenconfigPlatform_Components_Component_Properties_Property_Config_Value_Union() {}

// OpenconfigPlatform_Components_Component_Properties_Property_Config_Value_Union_String is used when /openconfig-platform/components/component/properties/property/config/value
// is to be set to a string value.
type OpenconfigPlatform_Components_Component_Properties_Property_Config_Value_Union_String struct {
	String	string
}

// Is_OpenconfigPlatform_Components_Component_Properties_Property_Config_Value_Union ensures that OpenconfigPlatform_Components_Component_Properties_Property_Config_Value_Union_String
// implements the OpenconfigPlatform_Components_Component_Properties_Property_Config_Value_Union interface.
func (*OpenconfigPlatform_Components_Component_Properties_Property_Config_Value_Union_String) Is_OpenconfigPlatform_Components_Component_Properties_Property_Config_Value_Union() {}

// OpenconfigPlatform_Components_Component_Properties_Property_Config_Value_Union_Uint64 is used when /openconfig-platform/components/component/properties/property/config/value
// is to be set to a uint64 value.
type OpenconfigPlatform_Components_Component_Properties_Property_Config_Value_Union_Uint64 struct {
	Uint64	uint64
}

// Is_OpenconfigPlatform_Components_Component_Properties_Property_Config_Value_Union ensures that OpenconfigPlatform_Components_Component_Properties_Property_Config_Value_Union_Uint64
// implements the OpenconfigPlatform_Components_Component_Properties_Property_Config_Value_Union interface.
func (*OpenconfigPlatform_Components_Component_Properties_Property_Config_Value_Union_Uint64) Is_OpenconfigPlatform_Components_Component_Properties_Property_Config_Value_Union() {}

// To_OpenconfigPlatform_Components_Component_Properties_Property_Config_Value_Union takes an input interface{} and attempts to convert it to a struct
// which implements the OpenconfigPlatform_Components_Component_Properties_Property_Config_Value_Union union. It returns an error if the interface{} supplied
// cannot be converted to a type within the union.
func (t *OpenconfigPlatform_Components_Component_Properties_Property_Config) To_OpenconfigPlatform_Components_Component_Properties_Property_Config_Value_Union(i interface{}) (OpenconfigPlatform_Components_Component_Properties_Property_Config_Value_Union, error) {
	switch v := i.(type) {
	case bool:
		return &OpenconfigPlatform_Components_Component_Properties_Property_Config_Value_Union_Bool{v}, nil
	case float64:
		return &OpenconfigPlatform_Components_Component_Properties_Property_Config_Value_Union_Float64{v}, nil
	case int64:
		return &OpenconfigPlatform_Components_Component_Properties_Property_Config_Value_Union_Int64{v}, nil
	case string:
		return &OpenconfigPlatform_Components_Component_Properties_Property_Config_Value_Union_String{v}, nil
	case uint64:
		return &OpenconfigPlatform_Components_Component_Properties_Property_Config_Value_Union_Uint64{v}, nil
	default:
		return nil, fmt.Errorf("cannot convert %v to OpenconfigPlatform_Components_Component_Properties_Property_Config_Value_Union, unknown union type, got: %T, want any of [bool, float64, int64, string, uint64]", i, i)
	}
}


// OpenconfigPlatform_Components_Component_Properties_Property_State represents the /openconfig-platform/components/component/properties/property/state YANG schema element.
type OpenconfigPlatform_Components_Component_Properties_Property_State struct {
	Configurable	*bool	`path:"configurable" module:"openconfig-platform"`
	Name	*string	`path:"name" module:"openconfig-platform"`
	Value	OpenconfigPlatform_Components_Component_Properties_Property_State_Value_Union	`path:"value" module:"openconfig-platform"`
}

// IsYANGGoStruct ensures that OpenconfigPlatform_Components_Component_Properties_Property_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigPlatform_Components_Component_Properties_Property_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_Properties_Property_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigPlatform_Components_Component_Properties_Property_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_Properties_Property_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigPlatform_Components_Component_Properties_Property_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigPlatform_Components_Component_Properties_Property_State.
func (*OpenconfigPlatform_Components_Component_Properties_Property_State) ΛBelongingModule() string {
	return "openconfig-platform"
}

// OpenconfigPlatform_Components_Component_Properties_Property_State_Value_Union is an interface that is implemented by valid types for the union
// for the leaf /openconfig-platform/components/component/properties/property/state/value within the YANG schema.
type OpenconfigPlatform_Components_Component_Properties_Property_State_Value_Union interface {
	Is_OpenconfigPlatform_Components_Component_Properties_Property_State_Value_Union()
}

// OpenconfigPlatform_Components_Component_Properties_Property_State_Value_Union_Bool is used when /openconfig-platform/components/component/properties/property/state/value
// is to be set to a bool value.
type OpenconfigPlatform_Components_Component_Properties_Property_State_Value_Union_Bool struct {
	Bool	bool
}

// Is_OpenconfigPlatform_Components_Component_Properties_Property_State_Value_Union ensures that OpenconfigPlatform_Components_Component_Properties_Property_State_Value_Union_Bool
// implements the OpenconfigPlatform_Components_Component_Properties_Property_State_Value_Union interface.
func (*OpenconfigPlatform_Components_Component_Properties_Property_State_Value_Union_Bool) Is_OpenconfigPlatform_Components_Component_Properties_Property_State_Value_Union() {}

// OpenconfigPlatform_Components_Component_Properties_Property_State_Value_Union_Float64 is used when /openconfig-platform/components/component/properties/property/state/value
// is to be set to a float64 value.
type OpenconfigPlatform_Components_Component_Properties_Property_State_Value_Union_Float64 struct {
	Float64	float64
}

// Is_OpenconfigPlatform_Components_Component_Properties_Property_State_Value_Union ensures that OpenconfigPlatform_Components_Component_Properties_Property_State_Value_Union_Float64
// implements the OpenconfigPlatform_Components_Component_Properties_Property_State_Value_Union interface.
func (*OpenconfigPlatform_Components_Component_Properties_Property_State_Value_Union_Float64) Is_OpenconfigPlatform_Components_Component_Properties_Property_State_Value_Union() {}

// OpenconfigPlatform_Components_Component_Properties_Property_State_Value_Union_Int64 is used when /openconfig-platform/components/component/properties/property/state/value
// is to be set to a int64 value.
type OpenconfigPlatform_Components_Component_Properties_Property_State_Value_Union_Int64 struct {
	Int64	int64
}

// Is_OpenconfigPlatform_Components_Component_Properties_Property_State_Value_Union ensures that OpenconfigPlatform_Components_Component_Properties_Property_State_Value_Union_Int64
// implements the OpenconfigPlatform_Components_Component_Properties_Property_State_Value_Union interface.
func (*OpenconfigPlatform_Components_Component_Properties_Property_State_Value_Union_Int64) Is_OpenconfigPlatform_Components_Component_Properties_Property_State_Value_Union() {}

// OpenconfigPlatform_Components_Component_Properties_Property_State_Value_Union_String is used when /openconfig-platform/components/component/properties/property/state/value
// is to be set to a string value.
type OpenconfigPlatform_Components_Component_Properties_Property_State_Value_Union_String struct {
	String	string
}

// Is_OpenconfigPlatform_Components_Component_Properties_Property_State_Value_Union ensures that OpenconfigPlatform_Components_Component_Properties_Property_State_Value_Union_String
// implements the OpenconfigPlatform_Components_Component_Properties_Property_State_Value_Union interface.
func (*OpenconfigPlatform_Components_Component_Properties_Property_State_Value_Union_String) Is_OpenconfigPlatform_Components_Component_Properties_Property_State_Value_Union() {}

// OpenconfigPlatform_Components_Component_Properties_Property_State_Value_Union_Uint64 is used when /openconfig-platform/components/component/properties/property/state/value
// is to be set to a uint64 value.
type OpenconfigPlatform_Components_Component_Properties_Property_State_Value_Union_Uint64 struct {
	Uint64	uint64
}

// Is_OpenconfigPlatform_Components_Component_Properties_Property_State_Value_Union ensures that OpenconfigPlatform_Components_Component_Properties_Property_State_Value_Union_Uint64
// implements the OpenconfigPlatform_Components_Component_Properties_Property_State_Value_Union interface.
func (*OpenconfigPlatform_Components_Component_Properties_Property_State_Value_Union_Uint64) Is_OpenconfigPlatform_Components_Component_Properties_Property_State_Value_Union() {}

// To_OpenconfigPlatform_Components_Component_Properties_Property_State_Value_Union takes an input interface{} and attempts to convert it to a struct
// which implements the OpenconfigPlatform_Components_Component_Properties_Property_State_Value_Union union. It returns an error if the interface{} supplied
// cannot be converted to a type within the union.
func (t *OpenconfigPlatform_Components_Component_Properties_Property_State) To_OpenconfigPlatform_Components_Component_Properties_Property_State_Value_Union(i interface{}) (OpenconfigPlatform_Components_Component_Properties_Property_State_Value_Union, error) {
	switch v := i.(type) {
	case bool:
		return &OpenconfigPlatform_Components_Component_Properties_Property_State_Value_Union_Bool{v}, nil
	case float64:
		return &OpenconfigPlatform_Components_Component_Properties_Property_State_Value_Union_Float64{v}, nil
	case int64:
		return &OpenconfigPlatform_Components_Component_Properties_Property_State_Value_Union_Int64{v}, nil
	case string:
		return &OpenconfigPlatform_Components_Component_Properties_Property_State_Value_Union_String{v}, nil
	case uint64:
		return &OpenconfigPlatform_Components_Component_Properties_Property_State_Value_Union_Uint64{v}, nil
	default:
		return nil, fmt.Errorf("cannot convert %v to OpenconfigPlatform_Components_Component_Properties_Property_State_Value_Union, unknown union type, got: %T, want any of [bool, float64, int64, string, uint64]", i, i)
	}
}


// OpenconfigPlatform_Components_Component_SoftwareModule represents the /openconfig-platform/components/component/software-module YANG schema element.
type OpenconfigPlatform_Components_Component_SoftwareModule struct {
	Config	*OpenconfigPlatform_Components_Component_SoftwareModule_Config	`path:"config" module:"openconfig-platform"`
	State	*OpenconfigPlatform_Components_Component_SoftwareModule_State	`path:"state" module:"openconfig-platform"`
}

// IsYANGGoStruct ensures that OpenconfigPlatform_Components_Component_SoftwareModule implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigPlatform_Components_Component_SoftwareModule) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_SoftwareModule) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigPlatform_Components_Component_SoftwareModule"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_SoftwareModule) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigPlatform_Components_Component_SoftwareModule) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigPlatform_Components_Component_SoftwareModule.
func (*OpenconfigPlatform_Components_Component_SoftwareModule) ΛBelongingModule() string {
	return "openconfig-platform"
}


// OpenconfigPlatform_Components_Component_SoftwareModule_Config represents the /openconfig-platform/components/component/software-module/config YANG schema element.
type OpenconfigPlatform_Components_Component_SoftwareModule_Config struct {
}

// IsYANGGoStruct ensures that OpenconfigPlatform_Components_Component_SoftwareModule_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigPlatform_Components_Component_SoftwareModule_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_SoftwareModule_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigPlatform_Components_Component_SoftwareModule_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_SoftwareModule_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigPlatform_Components_Component_SoftwareModule_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigPlatform_Components_Component_SoftwareModule_Config.
func (*OpenconfigPlatform_Components_Component_SoftwareModule_Config) ΛBelongingModule() string {
	return "openconfig-platform"
}


// OpenconfigPlatform_Components_Component_SoftwareModule_State represents the /openconfig-platform/components/component/software-module/state YANG schema element.
type OpenconfigPlatform_Components_Component_SoftwareModule_State struct {
}

// IsYANGGoStruct ensures that OpenconfigPlatform_Components_Component_SoftwareModule_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigPlatform_Components_Component_SoftwareModule_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_SoftwareModule_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigPlatform_Components_Component_SoftwareModule_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_SoftwareModule_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigPlatform_Components_Component_SoftwareModule_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigPlatform_Components_Component_SoftwareModule_State.
func (*OpenconfigPlatform_Components_Component_SoftwareModule_State) ΛBelongingModule() string {
	return "openconfig-platform"
}


// OpenconfigPlatform_Components_Component_State represents the /openconfig-platform/components/component/state YANG schema element.
type OpenconfigPlatform_Components_Component_State struct {
	AllocatedPower	*uint32	`path:"allocated-power" module:"openconfig-platform"`
	Description	*string	`path:"description" module:"openconfig-platform"`
	Empty	*bool	`path:"empty" module:"openconfig-platform"`
	EquipmentFailure	*bool	`path:"equipment-failure" module:"openconfig-alarms"`
	EquipmentMismatch	*bool	`path:"equipment-mismatch" module:"openconfig-alarms"`
	FirmwareVersion	*string	`path:"firmware-version" module:"openconfig-platform"`
	HardwareVersion	*string	`path:"hardware-version" module:"openconfig-platform"`
	Id	*string	`path:"id" module:"openconfig-platform"`
	LastRebootReason	E_OpenconfigPlatformTypes_COMPONENT_REBOOT_REASON	`path:"last-reboot-reason" module:"openconfig-platform"`
	LastRebootTime	*uint64	`path:"last-reboot-time" module:"openconfig-platform"`
	LastSwitchoverReason	*OpenconfigPlatform_Components_Component_State_LastSwitchoverReason	`path:"last-switchover-reason" module:"openconfig-platform"`
	LastSwitchoverTime	*uint64	`path:"last-switchover-time" module:"openconfig-platform"`
	Location	*string	`path:"location" module:"openconfig-platform"`
	Memory	*OpenconfigPlatform_Components_Component_State_Memory	`path:"memory" module:"openconfig-platform"`
	MfgDate	*string	`path:"mfg-date" module:"openconfig-platform"`
	MfgName	*string	`path:"mfg-name" module:"openconfig-platform"`
	Name	*string	`path:"name" module:"openconfig-platform"`
	OperStatus	E_OpenconfigPlatformTypes_COMPONENT_OPER_STATUS	`path:"oper-status" module:"openconfig-platform"`
	Parent	*string	`path:"parent" module:"openconfig-platform"`
	PartNo	*string	`path:"part-no" module:"openconfig-platform"`
	Pcie	*OpenconfigPlatform_Components_Component_State_Pcie	`path:"pcie" module:"openconfig-platform"`
	RedundantRole	E_OpenconfigPlatform_ComponentRedundantRole	`path:"redundant-role" module:"openconfig-platform"`
	Removable	*bool	`path:"removable" module:"openconfig-platform"`
	SerialNo	*string	`path:"serial-no" module:"openconfig-platform"`
	SoftwareVersion	*string	`path:"software-version" module:"openconfig-platform"`
	Temperature	*OpenconfigPlatform_Components_Component_State_Temperature	`path:"temperature" module:"openconfig-platform"`
	Type	OpenconfigPlatform_Components_Component_State_Type_Union	`path:"type" module:"openconfig-platform"`
	UsedPower	*uint32	`path:"used-power" module:"openconfig-platform"`
}

// IsYANGGoStruct ensures that OpenconfigPlatform_Components_Component_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigPlatform_Components_Component_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigPlatform_Components_Component_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigPlatform_Components_Component_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigPlatform_Components_Component_State.
func (*OpenconfigPlatform_Components_Component_State) ΛBelongingModule() string {
	return "openconfig-platform"
}

// OpenconfigPlatform_Components_Component_State_Type_Union is an interface that is implemented by valid types for the union
// for the leaf /openconfig-platform/components/component/state/type within the YANG schema.
type OpenconfigPlatform_Components_Component_State_Type_Union interface {
	Is_OpenconfigPlatform_Components_Component_State_Type_Union()
}

// OpenconfigPlatform_Components_Component_State_Type_Union_E_OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT is used when /openconfig-platform/components/component/state/type
// is to be set to a E_OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT value.
type OpenconfigPlatform_Components_Component_State_Type_Union_E_OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT struct {
	E_OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT	E_OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT
}

// Is_OpenconfigPlatform_Components_Component_State_Type_Union ensures that OpenconfigPlatform_Components_Component_State_Type_Union_E_OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT
// implements the OpenconfigPlatform_Components_Component_State_Type_Union interface.
func (*OpenconfigPlatform_Components_Component_State_Type_Union_E_OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT) Is_OpenconfigPlatform_Components_Component_State_Type_Union() {}

// OpenconfigPlatform_Components_Component_State_Type_Union_E_OpenconfigPlatformTypes_OPENCONFIG_SOFTWARE_COMPONENT is used when /openconfig-platform/components/component/state/type
// is to be set to a E_OpenconfigPlatformTypes_OPENCONFIG_SOFTWARE_COMPONENT value.
type OpenconfigPlatform_Components_Component_State_Type_Union_E_OpenconfigPlatformTypes_OPENCONFIG_SOFTWARE_COMPONENT struct {
	E_OpenconfigPlatformTypes_OPENCONFIG_SOFTWARE_COMPONENT	E_OpenconfigPlatformTypes_OPENCONFIG_SOFTWARE_COMPONENT
}

// Is_OpenconfigPlatform_Components_Component_State_Type_Union ensures that OpenconfigPlatform_Components_Component_State_Type_Union_E_OpenconfigPlatformTypes_OPENCONFIG_SOFTWARE_COMPONENT
// implements the OpenconfigPlatform_Components_Component_State_Type_Union interface.
func (*OpenconfigPlatform_Components_Component_State_Type_Union_E_OpenconfigPlatformTypes_OPENCONFIG_SOFTWARE_COMPONENT) Is_OpenconfigPlatform_Components_Component_State_Type_Union() {}

// To_OpenconfigPlatform_Components_Component_State_Type_Union takes an input interface{} and attempts to convert it to a struct
// which implements the OpenconfigPlatform_Components_Component_State_Type_Union union. It returns an error if the interface{} supplied
// cannot be converted to a type within the union.
func (t *OpenconfigPlatform_Components_Component_State) To_OpenconfigPlatform_Components_Component_State_Type_Union(i interface{}) (OpenconfigPlatform_Components_Component_State_Type_Union, error) {
	switch v := i.(type) {
	case E_OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT:
		return &OpenconfigPlatform_Components_Component_State_Type_Union_E_OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT{v}, nil
	case E_OpenconfigPlatformTypes_OPENCONFIG_SOFTWARE_COMPONENT:
		return &OpenconfigPlatform_Components_Component_State_Type_Union_E_OpenconfigPlatformTypes_OPENCONFIG_SOFTWARE_COMPONENT{v}, nil
	default:
		return nil, fmt.Errorf("cannot convert %v to OpenconfigPlatform_Components_Component_State_Type_Union, unknown union type, got: %T, want any of [E_OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT, E_OpenconfigPlatformTypes_OPENCONFIG_SOFTWARE_COMPONENT]", i, i)
	}
}


// OpenconfigPlatform_Components_Component_State_LastSwitchoverReason represents the /openconfig-platform/components/component/state/last-switchover-reason YANG schema element.
type OpenconfigPlatform_Components_Component_State_LastSwitchoverReason struct {
	Details	*string	`path:"details" module:"openconfig-platform"`
	Trigger	E_OpenconfigPlatformTypes_ComponentRedundantRoleSwitchoverReasonTrigger	`path:"trigger" module:"openconfig-platform"`
}

// IsYANGGoStruct ensures that OpenconfigPlatform_Components_Component_State_LastSwitchoverReason implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigPlatform_Components_Component_State_LastSwitchoverReason) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_State_LastSwitchoverReason) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigPlatform_Components_Component_State_LastSwitchoverReason"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_State_LastSwitchoverReason) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigPlatform_Components_Component_State_LastSwitchoverReason) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigPlatform_Components_Component_State_LastSwitchoverReason.
func (*OpenconfigPlatform_Components_Component_State_LastSwitchoverReason) ΛBelongingModule() string {
	return "openconfig-platform"
}


// OpenconfigPlatform_Components_Component_State_Memory represents the /openconfig-platform/components/component/state/memory YANG schema element.
type OpenconfigPlatform_Components_Component_State_Memory struct {
	Available	*uint64	`path:"available" module:"openconfig-platform"`
	Utilized	*uint64	`path:"utilized" module:"openconfig-platform"`
}

// IsYANGGoStruct ensures that OpenconfigPlatform_Components_Component_State_Memory implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigPlatform_Components_Component_State_Memory) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_State_Memory) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigPlatform_Components_Component_State_Memory"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_State_Memory) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigPlatform_Components_Component_State_Memory) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigPlatform_Components_Component_State_Memory.
func (*OpenconfigPlatform_Components_Component_State_Memory) ΛBelongingModule() string {
	return "openconfig-platform"
}


// OpenconfigPlatform_Components_Component_State_Pcie represents the /openconfig-platform/components/component/state/pcie YANG schema element.
type OpenconfigPlatform_Components_Component_State_Pcie struct {
	CorrectableErrors	*OpenconfigPlatform_Components_Component_State_Pcie_CorrectableErrors	`path:"correctable-errors" module:"openconfig-platform"`
	FatalErrors	*OpenconfigPlatform_Components_Component_State_Pcie_FatalErrors	`path:"fatal-errors" module:"openconfig-platform"`
	NonFatalErrors	*OpenconfigPlatform_Components_Component_State_Pcie_NonFatalErrors	`path:"non-fatal-errors" module:"openconfig-platform"`
}

// IsYANGGoStruct ensures that OpenconfigPlatform_Components_Component_State_Pcie implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigPlatform_Components_Component_State_Pcie) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_State_Pcie) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigPlatform_Components_Component_State_Pcie"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_State_Pcie) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigPlatform_Components_Component_State_Pcie) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigPlatform_Components_Component_State_Pcie.
func (*OpenconfigPlatform_Components_Component_State_Pcie) ΛBelongingModule() string {
	return "openconfig-platform"
}


// OpenconfigPlatform_Components_Component_State_Pcie_CorrectableErrors represents the /openconfig-platform/components/component/state/pcie/correctable-errors YANG schema element.
type OpenconfigPlatform_Components_Component_State_Pcie_CorrectableErrors struct {
	AdvisoryNonFatalErrors	*uint64	`path:"advisory-non-fatal-errors" module:"openconfig-platform"`
	BadDllpErrors	*uint64	`path:"bad-dllp-errors" module:"openconfig-platform"`
	BadTlpErrors	*uint64	`path:"bad-tlp-errors" module:"openconfig-platform"`
	HdrLogOverflowErrors	*uint64	`path:"hdr-log-overflow-errors" module:"openconfig-platform"`
	InternalErrors	*uint64	`path:"internal-errors" module:"openconfig-platform"`
	ReceiverErrors	*uint64	`path:"receiver-errors" module:"openconfig-platform"`
	RelayRolloverErrors	*uint64	`path:"relay-rollover-errors" module:"openconfig-platform"`
	ReplayTimeoutErrors	*uint64	`path:"replay-timeout-errors" module:"openconfig-platform"`
	TotalErrors	*uint64	`path:"total-errors" module:"openconfig-platform"`
}

// IsYANGGoStruct ensures that OpenconfigPlatform_Components_Component_State_Pcie_CorrectableErrors implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigPlatform_Components_Component_State_Pcie_CorrectableErrors) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_State_Pcie_CorrectableErrors) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigPlatform_Components_Component_State_Pcie_CorrectableErrors"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_State_Pcie_CorrectableErrors) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigPlatform_Components_Component_State_Pcie_CorrectableErrors) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigPlatform_Components_Component_State_Pcie_CorrectableErrors.
func (*OpenconfigPlatform_Components_Component_State_Pcie_CorrectableErrors) ΛBelongingModule() string {
	return "openconfig-platform"
}


// OpenconfigPlatform_Components_Component_State_Pcie_FatalErrors represents the /openconfig-platform/components/component/state/pcie/fatal-errors YANG schema element.
type OpenconfigPlatform_Components_Component_State_Pcie_FatalErrors struct {
	AcsViolationErrors	*uint64	`path:"acs-violation-errors" module:"openconfig-platform"`
	AtomicOpBlockedErrors	*uint64	`path:"atomic-op-blocked-errors" module:"openconfig-platform"`
	BlockedTlpErrors	*uint64	`path:"blocked-tlp-errors" module:"openconfig-platform"`
	CompletionAbortErrors	*uint64	`path:"completion-abort-errors" module:"openconfig-platform"`
	CompletionTimeoutErrors	*uint64	`path:"completion-timeout-errors" module:"openconfig-platform"`
	DataLinkErrors	*uint64	`path:"data-link-errors" module:"openconfig-platform"`
	EcrcErrors	*uint64	`path:"ecrc-errors" module:"openconfig-platform"`
	FlowControlProtocolErrors	*uint64	`path:"flow-control-protocol-errors" module:"openconfig-platform"`
	InternalErrors	*uint64	`path:"internal-errors" module:"openconfig-platform"`
	MalformedTlpErrors	*uint64	`path:"malformed-tlp-errors" module:"openconfig-platform"`
	PoisonedTlpErrors	*uint64	`path:"poisoned-tlp-errors" module:"openconfig-platform"`
	ReceiverOverflowErrors	*uint64	`path:"receiver-overflow-errors" module:"openconfig-platform"`
	SurpriseDownErrors	*uint64	`path:"surprise-down-errors" module:"openconfig-platform"`
	TlpPrefixBlockedErrors	*uint64	`path:"tlp-prefix-blocked-errors" module:"openconfig-platform"`
	TotalErrors	*uint64	`path:"total-errors" module:"openconfig-platform"`
	UndefinedErrors	*uint64	`path:"undefined-errors" module:"openconfig-platform"`
	UnexpectedCompletionErrors	*uint64	`path:"unexpected-completion-errors" module:"openconfig-platform"`
	UnsupportedRequestErrors	*uint64	`path:"unsupported-request-errors" module:"openconfig-platform"`
}

// IsYANGGoStruct ensures that OpenconfigPlatform_Components_Component_State_Pcie_FatalErrors implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigPlatform_Components_Component_State_Pcie_FatalErrors) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_State_Pcie_FatalErrors) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigPlatform_Components_Component_State_Pcie_FatalErrors"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_State_Pcie_FatalErrors) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigPlatform_Components_Component_State_Pcie_FatalErrors) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigPlatform_Components_Component_State_Pcie_FatalErrors.
func (*OpenconfigPlatform_Components_Component_State_Pcie_FatalErrors) ΛBelongingModule() string {
	return "openconfig-platform"
}


// OpenconfigPlatform_Components_Component_State_Pcie_NonFatalErrors represents the /openconfig-platform/components/component/state/pcie/non-fatal-errors YANG schema element.
type OpenconfigPlatform_Components_Component_State_Pcie_NonFatalErrors struct {
	AcsViolationErrors	*uint64	`path:"acs-violation-errors" module:"openconfig-platform"`
	AtomicOpBlockedErrors	*uint64	`path:"atomic-op-blocked-errors" module:"openconfig-platform"`
	BlockedTlpErrors	*uint64	`path:"blocked-tlp-errors" module:"openconfig-platform"`
	CompletionAbortErrors	*uint64	`path:"completion-abort-errors" module:"openconfig-platform"`
	CompletionTimeoutErrors	*uint64	`path:"completion-timeout-errors" module:"openconfig-platform"`
	DataLinkErrors	*uint64	`path:"data-link-errors" module:"openconfig-platform"`
	EcrcErrors	*uint64	`path:"ecrc-errors" module:"openconfig-platform"`
	FlowControlProtocolErrors	*uint64	`path:"flow-control-protocol-errors" module:"openconfig-platform"`
	InternalErrors	*uint64	`path:"internal-errors" module:"openconfig-platform"`
	MalformedTlpErrors	*uint64	`path:"malformed-tlp-errors" module:"openconfig-platform"`
	PoisonedTlpErrors	*uint64	`path:"poisoned-tlp-errors" module:"openconfig-platform"`
	ReceiverOverflowErrors	*uint64	`path:"receiver-overflow-errors" module:"openconfig-platform"`
	SurpriseDownErrors	*uint64	`path:"surprise-down-errors" module:"openconfig-platform"`
	TlpPrefixBlockedErrors	*uint64	`path:"tlp-prefix-blocked-errors" module:"openconfig-platform"`
	TotalErrors	*uint64	`path:"total-errors" module:"openconfig-platform"`
	UndefinedErrors	*uint64	`path:"undefined-errors" module:"openconfig-platform"`
	UnexpectedCompletionErrors	*uint64	`path:"unexpected-completion-errors" module:"openconfig-platform"`
	UnsupportedRequestErrors	*uint64	`path:"unsupported-request-errors" module:"openconfig-platform"`
}

// IsYANGGoStruct ensures that OpenconfigPlatform_Components_Component_State_Pcie_NonFatalErrors implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigPlatform_Components_Component_State_Pcie_NonFatalErrors) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_State_Pcie_NonFatalErrors) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigPlatform_Components_Component_State_Pcie_NonFatalErrors"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_State_Pcie_NonFatalErrors) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigPlatform_Components_Component_State_Pcie_NonFatalErrors) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigPlatform_Components_Component_State_Pcie_NonFatalErrors.
func (*OpenconfigPlatform_Components_Component_State_Pcie_NonFatalErrors) ΛBelongingModule() string {
	return "openconfig-platform"
}


// OpenconfigPlatform_Components_Component_State_Temperature represents the /openconfig-platform/components/component/state/temperature YANG schema element.
type OpenconfigPlatform_Components_Component_State_Temperature struct {
	AlarmSeverity	E_OpenconfigAlarmTypes_OPENCONFIG_ALARM_SEVERITY	`path:"alarm-severity" module:"openconfig-platform"`
	AlarmStatus	*bool	`path:"alarm-status" module:"openconfig-platform"`
	AlarmThreshold	*uint32	`path:"alarm-threshold" module:"openconfig-platform"`
	Avg	*float64	`path:"avg" module:"openconfig-platform"`
	Instant	*float64	`path:"instant" module:"openconfig-platform"`
	Interval	*uint64	`path:"interval" module:"openconfig-platform"`
	Max	*float64	`path:"max" module:"openconfig-platform"`
	MaxTime	*uint64	`path:"max-time" module:"openconfig-platform"`
	Min	*float64	`path:"min" module:"openconfig-platform"`
	MinTime	*uint64	`path:"min-time" module:"openconfig-platform"`
}

// IsYANGGoStruct ensures that OpenconfigPlatform_Components_Component_State_Temperature implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigPlatform_Components_Component_State_Temperature) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_State_Temperature) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigPlatform_Components_Component_State_Temperature"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_State_Temperature) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigPlatform_Components_Component_State_Temperature) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigPlatform_Components_Component_State_Temperature.
func (*OpenconfigPlatform_Components_Component_State_Temperature) ΛBelongingModule() string {
	return "openconfig-platform"
}


// OpenconfigPlatform_Components_Component_Storage represents the /openconfig-platform/components/component/storage YANG schema element.
type OpenconfigPlatform_Components_Component_Storage struct {
	Config	*OpenconfigPlatform_Components_Component_Storage_Config	`path:"config" module:"openconfig-platform"`
	State	*OpenconfigPlatform_Components_Component_Storage_State	`path:"state" module:"openconfig-platform"`
}

// IsYANGGoStruct ensures that OpenconfigPlatform_Components_Component_Storage implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigPlatform_Components_Component_Storage) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_Storage) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigPlatform_Components_Component_Storage"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_Storage) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigPlatform_Components_Component_Storage) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigPlatform_Components_Component_Storage.
func (*OpenconfigPlatform_Components_Component_Storage) ΛBelongingModule() string {
	return "openconfig-platform"
}


// OpenconfigPlatform_Components_Component_Storage_Config represents the /openconfig-platform/components/component/storage/config YANG schema element.
type OpenconfigPlatform_Components_Component_Storage_Config struct {
}

// IsYANGGoStruct ensures that OpenconfigPlatform_Components_Component_Storage_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigPlatform_Components_Component_Storage_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_Storage_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigPlatform_Components_Component_Storage_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_Storage_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigPlatform_Components_Component_Storage_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigPlatform_Components_Component_Storage_Config.
func (*OpenconfigPlatform_Components_Component_Storage_Config) ΛBelongingModule() string {
	return "openconfig-platform"
}


// OpenconfigPlatform_Components_Component_Storage_State represents the /openconfig-platform/components/component/storage/state YANG schema element.
type OpenconfigPlatform_Components_Component_Storage_State struct {
}

// IsYANGGoStruct ensures that OpenconfigPlatform_Components_Component_Storage_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigPlatform_Components_Component_Storage_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_Storage_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigPlatform_Components_Component_Storage_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_Storage_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigPlatform_Components_Component_Storage_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigPlatform_Components_Component_Storage_State.
func (*OpenconfigPlatform_Components_Component_Storage_State) ΛBelongingModule() string {
	return "openconfig-platform"
}


// OpenconfigPlatform_Components_Component_Subcomponents represents the /openconfig-platform/components/component/subcomponents YANG schema element.
type OpenconfigPlatform_Components_Component_Subcomponents struct {
	Subcomponent	map[string]*OpenconfigPlatform_Components_Component_Subcomponents_Subcomponent	`path:"subcomponent" module:"openconfig-platform"`
}

// IsYANGGoStruct ensures that OpenconfigPlatform_Components_Component_Subcomponents implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigPlatform_Components_Component_Subcomponents) IsYANGGoStruct() {}

// NewSubcomponent creates a new entry in the Subcomponent list of the
// OpenconfigPlatform_Components_Component_Subcomponents struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigPlatform_Components_Component_Subcomponents) NewSubcomponent(Name string) (*OpenconfigPlatform_Components_Component_Subcomponents_Subcomponent, error){

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.Subcomponent == nil {
		t.Subcomponent = make(map[string]*OpenconfigPlatform_Components_Component_Subcomponents_Subcomponent)
	}

	key := Name

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.Subcomponent[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list Subcomponent", key)
	}

	t.Subcomponent[key] = &OpenconfigPlatform_Components_Component_Subcomponents_Subcomponent{
		Name: &Name,
	}

	return t.Subcomponent[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_Subcomponents) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigPlatform_Components_Component_Subcomponents"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_Subcomponents) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigPlatform_Components_Component_Subcomponents) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigPlatform_Components_Component_Subcomponents.
func (*OpenconfigPlatform_Components_Component_Subcomponents) ΛBelongingModule() string {
	return "openconfig-platform"
}


// OpenconfigPlatform_Components_Component_Subcomponents_Subcomponent represents the /openconfig-platform/components/component/subcomponents/subcomponent YANG schema element.
type OpenconfigPlatform_Components_Component_Subcomponents_Subcomponent struct {
	Config	*OpenconfigPlatform_Components_Component_Subcomponents_Subcomponent_Config	`path:"config" module:"openconfig-platform"`
	Name	*string	`path:"name" module:"openconfig-platform"`
	State	*OpenconfigPlatform_Components_Component_Subcomponents_Subcomponent_State	`path:"state" module:"openconfig-platform"`
}

// IsYANGGoStruct ensures that OpenconfigPlatform_Components_Component_Subcomponents_Subcomponent implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigPlatform_Components_Component_Subcomponents_Subcomponent) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigPlatform_Components_Component_Subcomponents_Subcomponent struct, which is a YANG list entry.
func (t *OpenconfigPlatform_Components_Component_Subcomponents_Subcomponent) ΛListKeyMap() (map[string]interface{}, error) {
	if t.Name == nil {
		return nil, fmt.Errorf("nil value for key Name")
	}

	return map[string]interface{}{
		"name": *t.Name,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_Subcomponents_Subcomponent) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigPlatform_Components_Component_Subcomponents_Subcomponent"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_Subcomponents_Subcomponent) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigPlatform_Components_Component_Subcomponents_Subcomponent) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigPlatform_Components_Component_Subcomponents_Subcomponent.
func (*OpenconfigPlatform_Components_Component_Subcomponents_Subcomponent) ΛBelongingModule() string {
	return "openconfig-platform"
}


// OpenconfigPlatform_Components_Component_Subcomponents_Subcomponent_Config represents the /openconfig-platform/components/component/subcomponents/subcomponent/config YANG schema element.
type OpenconfigPlatform_Components_Component_Subcomponents_Subcomponent_Config struct {
	Name	*string	`path:"name" module:"openconfig-platform"`
}

// IsYANGGoStruct ensures that OpenconfigPlatform_Components_Component_Subcomponents_Subcomponent_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigPlatform_Components_Component_Subcomponents_Subcomponent_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_Subcomponents_Subcomponent_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigPlatform_Components_Component_Subcomponents_Subcomponent_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_Subcomponents_Subcomponent_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigPlatform_Components_Component_Subcomponents_Subcomponent_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigPlatform_Components_Component_Subcomponents_Subcomponent_Config.
func (*OpenconfigPlatform_Components_Component_Subcomponents_Subcomponent_Config) ΛBelongingModule() string {
	return "openconfig-platform"
}


// OpenconfigPlatform_Components_Component_Subcomponents_Subcomponent_State represents the /openconfig-platform/components/component/subcomponents/subcomponent/state YANG schema element.
type OpenconfigPlatform_Components_Component_Subcomponents_Subcomponent_State struct {
	Name	*string	`path:"name" module:"openconfig-platform"`
}

// IsYANGGoStruct ensures that OpenconfigPlatform_Components_Component_Subcomponents_Subcomponent_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigPlatform_Components_Component_Subcomponents_Subcomponent_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_Subcomponents_Subcomponent_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigPlatform_Components_Component_Subcomponents_Subcomponent_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_Subcomponents_Subcomponent_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigPlatform_Components_Component_Subcomponents_Subcomponent_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigPlatform_Components_Component_Subcomponents_Subcomponent_State.
func (*OpenconfigPlatform_Components_Component_Subcomponents_Subcomponent_State) ΛBelongingModule() string {
	return "openconfig-platform"
}


// OpenconfigSystem_System represents the /openconfig-system/system YANG schema element.
type OpenconfigSystem_System struct {
	Aaa	*OpenconfigSystem_System_Aaa	`path:"aaa" module:"openconfig-system"`
	Alarms	*OpenconfigSystem_System_Alarms	`path:"alarms" module:"openconfig-system"`
	Clock	*OpenconfigSystem_System_Clock	`path:"clock" module:"openconfig-system"`
	Config	*OpenconfigSystem_System_Config	`path:"config" module:"openconfig-system"`
	Cpus	*OpenconfigSystem_System_Cpus	`path:"cpus" module:"openconfig-system"`
	Dns	*OpenconfigSystem_System_Dns	`path:"dns" module:"openconfig-system"`
	License	*OpenconfigSystem_System_License	`path:"license" module:"openconfig-system"`
	Logging	*OpenconfigSystem_System_Logging	`path:"logging" module:"openconfig-system"`
	Memory	*OpenconfigSystem_System_Memory	`path:"memory" module:"openconfig-system"`
	Messages	*OpenconfigSystem_System_Messages	`path:"messages" module:"openconfig-system"`
	MountPoints	*OpenconfigSystem_System_MountPoints	`path:"mount-points" module:"openconfig-system"`
	Ntp	*OpenconfigSystem_System_Ntp	`path:"ntp" module:"openconfig-system"`
	Openflow	*OpenconfigSystem_System_Openflow	`path:"openflow" module:"openconfig-openflow"`
	Processes	*OpenconfigSystem_System_Processes	`path:"processes" module:"openconfig-system"`
	SshServer	*OpenconfigSystem_System_SshServer	`path:"ssh-server" module:"openconfig-system"`
	State	*OpenconfigSystem_System_State	`path:"state" module:"openconfig-system"`
	TelnetServer	*OpenconfigSystem_System_TelnetServer	`path:"telnet-server" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System.
func (*OpenconfigSystem_System) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Aaa represents the /openconfig-system/system/aaa YANG schema element.
type OpenconfigSystem_System_Aaa struct {
	Accounting	*OpenconfigSystem_System_Aaa_Accounting	`path:"accounting" module:"openconfig-system"`
	Authentication	*OpenconfigSystem_System_Aaa_Authentication	`path:"authentication" module:"openconfig-system"`
	Authorization	*OpenconfigSystem_System_Aaa_Authorization	`path:"authorization" module:"openconfig-system"`
	Config	*OpenconfigSystem_System_Aaa_Config	`path:"config" module:"openconfig-system"`
	ServerGroups	*OpenconfigSystem_System_Aaa_ServerGroups	`path:"server-groups" module:"openconfig-system"`
	State	*OpenconfigSystem_System_Aaa_State	`path:"state" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Aaa implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Aaa) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Aaa) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Aaa"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Aaa) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Aaa) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Aaa.
func (*OpenconfigSystem_System_Aaa) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Aaa_Accounting represents the /openconfig-system/system/aaa/accounting YANG schema element.
type OpenconfigSystem_System_Aaa_Accounting struct {
	Config	*OpenconfigSystem_System_Aaa_Accounting_Config	`path:"config" module:"openconfig-system"`
	Events	*OpenconfigSystem_System_Aaa_Accounting_Events	`path:"events" module:"openconfig-system"`
	State	*OpenconfigSystem_System_Aaa_Accounting_State	`path:"state" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Aaa_Accounting implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Aaa_Accounting) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Aaa_Accounting) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Aaa_Accounting"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Aaa_Accounting) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Aaa_Accounting) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Aaa_Accounting.
func (*OpenconfigSystem_System_Aaa_Accounting) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Aaa_Accounting_Config represents the /openconfig-system/system/aaa/accounting/config YANG schema element.
type OpenconfigSystem_System_Aaa_Accounting_Config struct {
	AccountingMethod	[]OpenconfigSystem_System_Aaa_Accounting_Config_AccountingMethod_Union	`path:"accounting-method" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Aaa_Accounting_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Aaa_Accounting_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Aaa_Accounting_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Aaa_Accounting_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Aaa_Accounting_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Aaa_Accounting_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Aaa_Accounting_Config.
func (*OpenconfigSystem_System_Aaa_Accounting_Config) ΛBelongingModule() string {
	return "openconfig-system"
}

// OpenconfigSystem_System_Aaa_Accounting_Config_AccountingMethod_Union is an interface that is implemented by valid types for the union
// for the leaf /openconfig-system/system/aaa/accounting/config/accounting-method within the YANG schema.
type OpenconfigSystem_System_Aaa_Accounting_Config_AccountingMethod_Union interface {
	Is_OpenconfigSystem_System_Aaa_Accounting_Config_AccountingMethod_Union()
}

// OpenconfigSystem_System_Aaa_Accounting_Config_AccountingMethod_Union_E_OpenconfigAaaTypes_AAA_METHOD_TYPE is used when /openconfig-system/system/aaa/accounting/config/accounting-method
// is to be set to a E_OpenconfigAaaTypes_AAA_METHOD_TYPE value.
type OpenconfigSystem_System_Aaa_Accounting_Config_AccountingMethod_Union_E_OpenconfigAaaTypes_AAA_METHOD_TYPE struct {
	E_OpenconfigAaaTypes_AAA_METHOD_TYPE	E_OpenconfigAaaTypes_AAA_METHOD_TYPE
}

// Is_OpenconfigSystem_System_Aaa_Accounting_Config_AccountingMethod_Union ensures that OpenconfigSystem_System_Aaa_Accounting_Config_AccountingMethod_Union_E_OpenconfigAaaTypes_AAA_METHOD_TYPE
// implements the OpenconfigSystem_System_Aaa_Accounting_Config_AccountingMethod_Union interface.
func (*OpenconfigSystem_System_Aaa_Accounting_Config_AccountingMethod_Union_E_OpenconfigAaaTypes_AAA_METHOD_TYPE) Is_OpenconfigSystem_System_Aaa_Accounting_Config_AccountingMethod_Union() {}

// OpenconfigSystem_System_Aaa_Accounting_Config_AccountingMethod_Union_String is used when /openconfig-system/system/aaa/accounting/config/accounting-method
// is to be set to a string value.
type OpenconfigSystem_System_Aaa_Accounting_Config_AccountingMethod_Union_String struct {
	String	string
}

// Is_OpenconfigSystem_System_Aaa_Accounting_Config_AccountingMethod_Union ensures that OpenconfigSystem_System_Aaa_Accounting_Config_AccountingMethod_Union_String
// implements the OpenconfigSystem_System_Aaa_Accounting_Config_AccountingMethod_Union interface.
func (*OpenconfigSystem_System_Aaa_Accounting_Config_AccountingMethod_Union_String) Is_OpenconfigSystem_System_Aaa_Accounting_Config_AccountingMethod_Union() {}

// To_OpenconfigSystem_System_Aaa_Accounting_Config_AccountingMethod_Union takes an input interface{} and attempts to convert it to a struct
// which implements the OpenconfigSystem_System_Aaa_Accounting_Config_AccountingMethod_Union union. It returns an error if the interface{} supplied
// cannot be converted to a type within the union.
func (t *OpenconfigSystem_System_Aaa_Accounting_Config) To_OpenconfigSystem_System_Aaa_Accounting_Config_AccountingMethod_Union(i interface{}) (OpenconfigSystem_System_Aaa_Accounting_Config_AccountingMethod_Union, error) {
	switch v := i.(type) {
	case E_OpenconfigAaaTypes_AAA_METHOD_TYPE:
		return &OpenconfigSystem_System_Aaa_Accounting_Config_AccountingMethod_Union_E_OpenconfigAaaTypes_AAA_METHOD_TYPE{v}, nil
	case string:
		return &OpenconfigSystem_System_Aaa_Accounting_Config_AccountingMethod_Union_String{v}, nil
	default:
		return nil, fmt.Errorf("cannot convert %v to OpenconfigSystem_System_Aaa_Accounting_Config_AccountingMethod_Union, unknown union type, got: %T, want any of [E_OpenconfigAaaTypes_AAA_METHOD_TYPE, string]", i, i)
	}
}


// OpenconfigSystem_System_Aaa_Accounting_Events represents the /openconfig-system/system/aaa/accounting/events YANG schema element.
type OpenconfigSystem_System_Aaa_Accounting_Events struct {
	Event	map[E_OpenconfigAaaTypes_AAA_ACCOUNTING_EVENT_TYPE]*OpenconfigSystem_System_Aaa_Accounting_Events_Event	`path:"event" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Aaa_Accounting_Events implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Aaa_Accounting_Events) IsYANGGoStruct() {}

// NewEvent creates a new entry in the Event list of the
// OpenconfigSystem_System_Aaa_Accounting_Events struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigSystem_System_Aaa_Accounting_Events) NewEvent(EventType E_OpenconfigAaaTypes_AAA_ACCOUNTING_EVENT_TYPE) (*OpenconfigSystem_System_Aaa_Accounting_Events_Event, error){

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.Event == nil {
		t.Event = make(map[E_OpenconfigAaaTypes_AAA_ACCOUNTING_EVENT_TYPE]*OpenconfigSystem_System_Aaa_Accounting_Events_Event)
	}

	key := EventType

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.Event[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list Event", key)
	}

	t.Event[key] = &OpenconfigSystem_System_Aaa_Accounting_Events_Event{
		EventType: EventType,
	}

	return t.Event[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Aaa_Accounting_Events) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Aaa_Accounting_Events"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Aaa_Accounting_Events) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Aaa_Accounting_Events) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Aaa_Accounting_Events.
func (*OpenconfigSystem_System_Aaa_Accounting_Events) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Aaa_Accounting_Events_Event represents the /openconfig-system/system/aaa/accounting/events/event YANG schema element.
type OpenconfigSystem_System_Aaa_Accounting_Events_Event struct {
	Config	*OpenconfigSystem_System_Aaa_Accounting_Events_Event_Config	`path:"config" module:"openconfig-system"`
	EventType	E_OpenconfigAaaTypes_AAA_ACCOUNTING_EVENT_TYPE	`path:"event-type" module:"openconfig-system"`
	State	*OpenconfigSystem_System_Aaa_Accounting_Events_Event_State	`path:"state" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Aaa_Accounting_Events_Event implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Aaa_Accounting_Events_Event) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigSystem_System_Aaa_Accounting_Events_Event struct, which is a YANG list entry.
func (t *OpenconfigSystem_System_Aaa_Accounting_Events_Event) ΛListKeyMap() (map[string]interface{}, error) {

	return map[string]interface{}{
		"event-type": t.EventType,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Aaa_Accounting_Events_Event) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Aaa_Accounting_Events_Event"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Aaa_Accounting_Events_Event) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Aaa_Accounting_Events_Event) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Aaa_Accounting_Events_Event.
func (*OpenconfigSystem_System_Aaa_Accounting_Events_Event) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Aaa_Accounting_Events_Event_Config represents the /openconfig-system/system/aaa/accounting/events/event/config YANG schema element.
type OpenconfigSystem_System_Aaa_Accounting_Events_Event_Config struct {
	EventType	E_OpenconfigAaaTypes_AAA_ACCOUNTING_EVENT_TYPE	`path:"event-type" module:"openconfig-system"`
	Record	E_OpenconfigSystem_System_Aaa_Accounting_Events_Event_Config_Record	`path:"record" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Aaa_Accounting_Events_Event_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Aaa_Accounting_Events_Event_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Aaa_Accounting_Events_Event_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Aaa_Accounting_Events_Event_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Aaa_Accounting_Events_Event_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Aaa_Accounting_Events_Event_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Aaa_Accounting_Events_Event_Config.
func (*OpenconfigSystem_System_Aaa_Accounting_Events_Event_Config) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Aaa_Accounting_Events_Event_State represents the /openconfig-system/system/aaa/accounting/events/event/state YANG schema element.
type OpenconfigSystem_System_Aaa_Accounting_Events_Event_State struct {
	EventType	E_OpenconfigAaaTypes_AAA_ACCOUNTING_EVENT_TYPE	`path:"event-type" module:"openconfig-system"`
	Record	E_OpenconfigSystem_System_Aaa_Accounting_Events_Event_Config_Record	`path:"record" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Aaa_Accounting_Events_Event_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Aaa_Accounting_Events_Event_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Aaa_Accounting_Events_Event_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Aaa_Accounting_Events_Event_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Aaa_Accounting_Events_Event_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Aaa_Accounting_Events_Event_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Aaa_Accounting_Events_Event_State.
func (*OpenconfigSystem_System_Aaa_Accounting_Events_Event_State) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Aaa_Accounting_State represents the /openconfig-system/system/aaa/accounting/state YANG schema element.
type OpenconfigSystem_System_Aaa_Accounting_State struct {
	AccountingMethod	[]OpenconfigSystem_System_Aaa_Accounting_State_AccountingMethod_Union	`path:"accounting-method" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Aaa_Accounting_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Aaa_Accounting_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Aaa_Accounting_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Aaa_Accounting_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Aaa_Accounting_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Aaa_Accounting_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Aaa_Accounting_State.
func (*OpenconfigSystem_System_Aaa_Accounting_State) ΛBelongingModule() string {
	return "openconfig-system"
}

// OpenconfigSystem_System_Aaa_Accounting_State_AccountingMethod_Union is an interface that is implemented by valid types for the union
// for the leaf /openconfig-system/system/aaa/accounting/state/accounting-method within the YANG schema.
type OpenconfigSystem_System_Aaa_Accounting_State_AccountingMethod_Union interface {
	Is_OpenconfigSystem_System_Aaa_Accounting_State_AccountingMethod_Union()
}

// OpenconfigSystem_System_Aaa_Accounting_State_AccountingMethod_Union_E_OpenconfigAaaTypes_AAA_METHOD_TYPE is used when /openconfig-system/system/aaa/accounting/state/accounting-method
// is to be set to a E_OpenconfigAaaTypes_AAA_METHOD_TYPE value.
type OpenconfigSystem_System_Aaa_Accounting_State_AccountingMethod_Union_E_OpenconfigAaaTypes_AAA_METHOD_TYPE struct {
	E_OpenconfigAaaTypes_AAA_METHOD_TYPE	E_OpenconfigAaaTypes_AAA_METHOD_TYPE
}

// Is_OpenconfigSystem_System_Aaa_Accounting_State_AccountingMethod_Union ensures that OpenconfigSystem_System_Aaa_Accounting_State_AccountingMethod_Union_E_OpenconfigAaaTypes_AAA_METHOD_TYPE
// implements the OpenconfigSystem_System_Aaa_Accounting_State_AccountingMethod_Union interface.
func (*OpenconfigSystem_System_Aaa_Accounting_State_AccountingMethod_Union_E_OpenconfigAaaTypes_AAA_METHOD_TYPE) Is_OpenconfigSystem_System_Aaa_Accounting_State_AccountingMethod_Union() {}

// OpenconfigSystem_System_Aaa_Accounting_State_AccountingMethod_Union_String is used when /openconfig-system/system/aaa/accounting/state/accounting-method
// is to be set to a string value.
type OpenconfigSystem_System_Aaa_Accounting_State_AccountingMethod_Union_String struct {
	String	string
}

// Is_OpenconfigSystem_System_Aaa_Accounting_State_AccountingMethod_Union ensures that OpenconfigSystem_System_Aaa_Accounting_State_AccountingMethod_Union_String
// implements the OpenconfigSystem_System_Aaa_Accounting_State_AccountingMethod_Union interface.
func (*OpenconfigSystem_System_Aaa_Accounting_State_AccountingMethod_Union_String) Is_OpenconfigSystem_System_Aaa_Accounting_State_AccountingMethod_Union() {}

// To_OpenconfigSystem_System_Aaa_Accounting_State_AccountingMethod_Union takes an input interface{} and attempts to convert it to a struct
// which implements the OpenconfigSystem_System_Aaa_Accounting_State_AccountingMethod_Union union. It returns an error if the interface{} supplied
// cannot be converted to a type within the union.
func (t *OpenconfigSystem_System_Aaa_Accounting_State) To_OpenconfigSystem_System_Aaa_Accounting_State_AccountingMethod_Union(i interface{}) (OpenconfigSystem_System_Aaa_Accounting_State_AccountingMethod_Union, error) {
	switch v := i.(type) {
	case E_OpenconfigAaaTypes_AAA_METHOD_TYPE:
		return &OpenconfigSystem_System_Aaa_Accounting_State_AccountingMethod_Union_E_OpenconfigAaaTypes_AAA_METHOD_TYPE{v}, nil
	case string:
		return &OpenconfigSystem_System_Aaa_Accounting_State_AccountingMethod_Union_String{v}, nil
	default:
		return nil, fmt.Errorf("cannot convert %v to OpenconfigSystem_System_Aaa_Accounting_State_AccountingMethod_Union, unknown union type, got: %T, want any of [E_OpenconfigAaaTypes_AAA_METHOD_TYPE, string]", i, i)
	}
}


// OpenconfigSystem_System_Aaa_Authentication represents the /openconfig-system/system/aaa/authentication YANG schema element.
type OpenconfigSystem_System_Aaa_Authentication struct {
	AdminUser	*OpenconfigSystem_System_Aaa_Authentication_AdminUser	`path:"admin-user" module:"openconfig-system"`
	Config	*OpenconfigSystem_System_Aaa_Authentication_Config	`path:"config" module:"openconfig-system"`
	State	*OpenconfigSystem_System_Aaa_Authentication_State	`path:"state" module:"openconfig-system"`
	Users	*OpenconfigSystem_System_Aaa_Authentication_Users	`path:"users" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Aaa_Authentication implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Aaa_Authentication) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Aaa_Authentication) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Aaa_Authentication"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Aaa_Authentication) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Aaa_Authentication) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Aaa_Authentication.
func (*OpenconfigSystem_System_Aaa_Authentication) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Aaa_Authentication_AdminUser represents the /openconfig-system/system/aaa/authentication/admin-user YANG schema element.
type OpenconfigSystem_System_Aaa_Authentication_AdminUser struct {
	Config	*OpenconfigSystem_System_Aaa_Authentication_AdminUser_Config	`path:"config" module:"openconfig-system"`
	State	*OpenconfigSystem_System_Aaa_Authentication_AdminUser_State	`path:"state" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Aaa_Authentication_AdminUser implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Aaa_Authentication_AdminUser) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Aaa_Authentication_AdminUser) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Aaa_Authentication_AdminUser"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Aaa_Authentication_AdminUser) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Aaa_Authentication_AdminUser) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Aaa_Authentication_AdminUser.
func (*OpenconfigSystem_System_Aaa_Authentication_AdminUser) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Aaa_Authentication_AdminUser_Config represents the /openconfig-system/system/aaa/authentication/admin-user/config YANG schema element.
type OpenconfigSystem_System_Aaa_Authentication_AdminUser_Config struct {
	AdminPassword	*string	`path:"admin-password" module:"openconfig-system"`
	AdminPasswordHashed	*string	`path:"admin-password-hashed" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Aaa_Authentication_AdminUser_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Aaa_Authentication_AdminUser_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Aaa_Authentication_AdminUser_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Aaa_Authentication_AdminUser_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Aaa_Authentication_AdminUser_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Aaa_Authentication_AdminUser_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Aaa_Authentication_AdminUser_Config.
func (*OpenconfigSystem_System_Aaa_Authentication_AdminUser_Config) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Aaa_Authentication_AdminUser_State represents the /openconfig-system/system/aaa/authentication/admin-user/state YANG schema element.
type OpenconfigSystem_System_Aaa_Authentication_AdminUser_State struct {
	AdminPassword	*string	`path:"admin-password" module:"openconfig-system"`
	AdminPasswordHashed	*string	`path:"admin-password-hashed" module:"openconfig-system"`
	AdminUsername	*string	`path:"admin-username" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Aaa_Authentication_AdminUser_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Aaa_Authentication_AdminUser_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Aaa_Authentication_AdminUser_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Aaa_Authentication_AdminUser_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Aaa_Authentication_AdminUser_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Aaa_Authentication_AdminUser_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Aaa_Authentication_AdminUser_State.
func (*OpenconfigSystem_System_Aaa_Authentication_AdminUser_State) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Aaa_Authentication_Config represents the /openconfig-system/system/aaa/authentication/config YANG schema element.
type OpenconfigSystem_System_Aaa_Authentication_Config struct {
	AuthenticationMethod	[]OpenconfigSystem_System_Aaa_Authentication_Config_AuthenticationMethod_Union	`path:"authentication-method" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Aaa_Authentication_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Aaa_Authentication_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Aaa_Authentication_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Aaa_Authentication_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Aaa_Authentication_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Aaa_Authentication_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Aaa_Authentication_Config.
func (*OpenconfigSystem_System_Aaa_Authentication_Config) ΛBelongingModule() string {
	return "openconfig-system"
}

// OpenconfigSystem_System_Aaa_Authentication_Config_AuthenticationMethod_Union is an interface that is implemented by valid types for the union
// for the leaf /openconfig-system/system/aaa/authentication/config/authentication-method within the YANG schema.
type OpenconfigSystem_System_Aaa_Authentication_Config_AuthenticationMethod_Union interface {
	Is_OpenconfigSystem_System_Aaa_Authentication_Config_AuthenticationMethod_Union()
}

// OpenconfigSystem_System_Aaa_Authentication_Config_AuthenticationMethod_Union_E_OpenconfigAaaTypes_AAA_METHOD_TYPE is used when /openconfig-system/system/aaa/authentication/config/authentication-method
// is to be set to a E_OpenconfigAaaTypes_AAA_METHOD_TYPE value.
type OpenconfigSystem_System_Aaa_Authentication_Config_AuthenticationMethod_Union_E_OpenconfigAaaTypes_AAA_METHOD_TYPE struct {
	E_OpenconfigAaaTypes_AAA_METHOD_TYPE	E_OpenconfigAaaTypes_AAA_METHOD_TYPE
}

// Is_OpenconfigSystem_System_Aaa_Authentication_Config_AuthenticationMethod_Union ensures that OpenconfigSystem_System_Aaa_Authentication_Config_AuthenticationMethod_Union_E_OpenconfigAaaTypes_AAA_METHOD_TYPE
// implements the OpenconfigSystem_System_Aaa_Authentication_Config_AuthenticationMethod_Union interface.
func (*OpenconfigSystem_System_Aaa_Authentication_Config_AuthenticationMethod_Union_E_OpenconfigAaaTypes_AAA_METHOD_TYPE) Is_OpenconfigSystem_System_Aaa_Authentication_Config_AuthenticationMethod_Union() {}

// OpenconfigSystem_System_Aaa_Authentication_Config_AuthenticationMethod_Union_String is used when /openconfig-system/system/aaa/authentication/config/authentication-method
// is to be set to a string value.
type OpenconfigSystem_System_Aaa_Authentication_Config_AuthenticationMethod_Union_String struct {
	String	string
}

// Is_OpenconfigSystem_System_Aaa_Authentication_Config_AuthenticationMethod_Union ensures that OpenconfigSystem_System_Aaa_Authentication_Config_AuthenticationMethod_Union_String
// implements the OpenconfigSystem_System_Aaa_Authentication_Config_AuthenticationMethod_Union interface.
func (*OpenconfigSystem_System_Aaa_Authentication_Config_AuthenticationMethod_Union_String) Is_OpenconfigSystem_System_Aaa_Authentication_Config_AuthenticationMethod_Union() {}

// To_OpenconfigSystem_System_Aaa_Authentication_Config_AuthenticationMethod_Union takes an input interface{} and attempts to convert it to a struct
// which implements the OpenconfigSystem_System_Aaa_Authentication_Config_AuthenticationMethod_Union union. It returns an error if the interface{} supplied
// cannot be converted to a type within the union.
func (t *OpenconfigSystem_System_Aaa_Authentication_Config) To_OpenconfigSystem_System_Aaa_Authentication_Config_AuthenticationMethod_Union(i interface{}) (OpenconfigSystem_System_Aaa_Authentication_Config_AuthenticationMethod_Union, error) {
	switch v := i.(type) {
	case E_OpenconfigAaaTypes_AAA_METHOD_TYPE:
		return &OpenconfigSystem_System_Aaa_Authentication_Config_AuthenticationMethod_Union_E_OpenconfigAaaTypes_AAA_METHOD_TYPE{v}, nil
	case string:
		return &OpenconfigSystem_System_Aaa_Authentication_Config_AuthenticationMethod_Union_String{v}, nil
	default:
		return nil, fmt.Errorf("cannot convert %v to OpenconfigSystem_System_Aaa_Authentication_Config_AuthenticationMethod_Union, unknown union type, got: %T, want any of [E_OpenconfigAaaTypes_AAA_METHOD_TYPE, string]", i, i)
	}
}


// OpenconfigSystem_System_Aaa_Authentication_State represents the /openconfig-system/system/aaa/authentication/state YANG schema element.
type OpenconfigSystem_System_Aaa_Authentication_State struct {
	AuthenticationMethod	[]OpenconfigSystem_System_Aaa_Authentication_State_AuthenticationMethod_Union	`path:"authentication-method" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Aaa_Authentication_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Aaa_Authentication_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Aaa_Authentication_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Aaa_Authentication_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Aaa_Authentication_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Aaa_Authentication_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Aaa_Authentication_State.
func (*OpenconfigSystem_System_Aaa_Authentication_State) ΛBelongingModule() string {
	return "openconfig-system"
}

// OpenconfigSystem_System_Aaa_Authentication_State_AuthenticationMethod_Union is an interface that is implemented by valid types for the union
// for the leaf /openconfig-system/system/aaa/authentication/state/authentication-method within the YANG schema.
type OpenconfigSystem_System_Aaa_Authentication_State_AuthenticationMethod_Union interface {
	Is_OpenconfigSystem_System_Aaa_Authentication_State_AuthenticationMethod_Union()
}

// OpenconfigSystem_System_Aaa_Authentication_State_AuthenticationMethod_Union_E_OpenconfigAaaTypes_AAA_METHOD_TYPE is used when /openconfig-system/system/aaa/authentication/state/authentication-method
// is to be set to a E_OpenconfigAaaTypes_AAA_METHOD_TYPE value.
type OpenconfigSystem_System_Aaa_Authentication_State_AuthenticationMethod_Union_E_OpenconfigAaaTypes_AAA_METHOD_TYPE struct {
	E_OpenconfigAaaTypes_AAA_METHOD_TYPE	E_OpenconfigAaaTypes_AAA_METHOD_TYPE
}

// Is_OpenconfigSystem_System_Aaa_Authentication_State_AuthenticationMethod_Union ensures that OpenconfigSystem_System_Aaa_Authentication_State_AuthenticationMethod_Union_E_OpenconfigAaaTypes_AAA_METHOD_TYPE
// implements the OpenconfigSystem_System_Aaa_Authentication_State_AuthenticationMethod_Union interface.
func (*OpenconfigSystem_System_Aaa_Authentication_State_AuthenticationMethod_Union_E_OpenconfigAaaTypes_AAA_METHOD_TYPE) Is_OpenconfigSystem_System_Aaa_Authentication_State_AuthenticationMethod_Union() {}

// OpenconfigSystem_System_Aaa_Authentication_State_AuthenticationMethod_Union_String is used when /openconfig-system/system/aaa/authentication/state/authentication-method
// is to be set to a string value.
type OpenconfigSystem_System_Aaa_Authentication_State_AuthenticationMethod_Union_String struct {
	String	string
}

// Is_OpenconfigSystem_System_Aaa_Authentication_State_AuthenticationMethod_Union ensures that OpenconfigSystem_System_Aaa_Authentication_State_AuthenticationMethod_Union_String
// implements the OpenconfigSystem_System_Aaa_Authentication_State_AuthenticationMethod_Union interface.
func (*OpenconfigSystem_System_Aaa_Authentication_State_AuthenticationMethod_Union_String) Is_OpenconfigSystem_System_Aaa_Authentication_State_AuthenticationMethod_Union() {}

// To_OpenconfigSystem_System_Aaa_Authentication_State_AuthenticationMethod_Union takes an input interface{} and attempts to convert it to a struct
// which implements the OpenconfigSystem_System_Aaa_Authentication_State_AuthenticationMethod_Union union. It returns an error if the interface{} supplied
// cannot be converted to a type within the union.
func (t *OpenconfigSystem_System_Aaa_Authentication_State) To_OpenconfigSystem_System_Aaa_Authentication_State_AuthenticationMethod_Union(i interface{}) (OpenconfigSystem_System_Aaa_Authentication_State_AuthenticationMethod_Union, error) {
	switch v := i.(type) {
	case E_OpenconfigAaaTypes_AAA_METHOD_TYPE:
		return &OpenconfigSystem_System_Aaa_Authentication_State_AuthenticationMethod_Union_E_OpenconfigAaaTypes_AAA_METHOD_TYPE{v}, nil
	case string:
		return &OpenconfigSystem_System_Aaa_Authentication_State_AuthenticationMethod_Union_String{v}, nil
	default:
		return nil, fmt.Errorf("cannot convert %v to OpenconfigSystem_System_Aaa_Authentication_State_AuthenticationMethod_Union, unknown union type, got: %T, want any of [E_OpenconfigAaaTypes_AAA_METHOD_TYPE, string]", i, i)
	}
}


// OpenconfigSystem_System_Aaa_Authentication_Users represents the /openconfig-system/system/aaa/authentication/users YANG schema element.
type OpenconfigSystem_System_Aaa_Authentication_Users struct {
	User	map[string]*OpenconfigSystem_System_Aaa_Authentication_Users_User	`path:"user" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Aaa_Authentication_Users implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Aaa_Authentication_Users) IsYANGGoStruct() {}

// NewUser creates a new entry in the User list of the
// OpenconfigSystem_System_Aaa_Authentication_Users struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigSystem_System_Aaa_Authentication_Users) NewUser(Username string) (*OpenconfigSystem_System_Aaa_Authentication_Users_User, error){

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.User == nil {
		t.User = make(map[string]*OpenconfigSystem_System_Aaa_Authentication_Users_User)
	}

	key := Username

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.User[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list User", key)
	}

	t.User[key] = &OpenconfigSystem_System_Aaa_Authentication_Users_User{
		Username: &Username,
	}

	return t.User[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Aaa_Authentication_Users) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Aaa_Authentication_Users"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Aaa_Authentication_Users) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Aaa_Authentication_Users) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Aaa_Authentication_Users.
func (*OpenconfigSystem_System_Aaa_Authentication_Users) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Aaa_Authentication_Users_User represents the /openconfig-system/system/aaa/authentication/users/user YANG schema element.
type OpenconfigSystem_System_Aaa_Authentication_Users_User struct {
	Config	*OpenconfigSystem_System_Aaa_Authentication_Users_User_Config	`path:"config" module:"openconfig-system"`
	State	*OpenconfigSystem_System_Aaa_Authentication_Users_User_State	`path:"state" module:"openconfig-system"`
	Username	*string	`path:"username" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Aaa_Authentication_Users_User implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Aaa_Authentication_Users_User) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigSystem_System_Aaa_Authentication_Users_User struct, which is a YANG list entry.
func (t *OpenconfigSystem_System_Aaa_Authentication_Users_User) ΛListKeyMap() (map[string]interface{}, error) {
	if t.Username == nil {
		return nil, fmt.Errorf("nil value for key Username")
	}

	return map[string]interface{}{
		"username": *t.Username,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Aaa_Authentication_Users_User) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Aaa_Authentication_Users_User"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Aaa_Authentication_Users_User) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Aaa_Authentication_Users_User) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Aaa_Authentication_Users_User.
func (*OpenconfigSystem_System_Aaa_Authentication_Users_User) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Aaa_Authentication_Users_User_Config represents the /openconfig-system/system/aaa/authentication/users/user/config YANG schema element.
type OpenconfigSystem_System_Aaa_Authentication_Users_User_Config struct {
	Password	*string	`path:"password" module:"openconfig-system"`
	PasswordHashed	*string	`path:"password-hashed" module:"openconfig-system"`
	Role	OpenconfigSystem_System_Aaa_Authentication_Users_User_Config_Role_Union	`path:"role" module:"openconfig-system"`
	SshKey	*string	`path:"ssh-key" module:"openconfig-system"`
	Username	*string	`path:"username" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Aaa_Authentication_Users_User_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Aaa_Authentication_Users_User_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Aaa_Authentication_Users_User_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Aaa_Authentication_Users_User_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Aaa_Authentication_Users_User_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Aaa_Authentication_Users_User_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Aaa_Authentication_Users_User_Config.
func (*OpenconfigSystem_System_Aaa_Authentication_Users_User_Config) ΛBelongingModule() string {
	return "openconfig-system"
}

// OpenconfigSystem_System_Aaa_Authentication_Users_User_Config_Role_Union is an interface that is implemented by valid types for the union
// for the leaf /openconfig-system/system/aaa/authentication/users/user/config/role within the YANG schema.
type OpenconfigSystem_System_Aaa_Authentication_Users_User_Config_Role_Union interface {
	Is_OpenconfigSystem_System_Aaa_Authentication_Users_User_Config_Role_Union()
}

// OpenconfigSystem_System_Aaa_Authentication_Users_User_Config_Role_Union_E_OpenconfigAaaTypes_SYSTEM_DEFINED_ROLES is used when /openconfig-system/system/aaa/authentication/users/user/config/role
// is to be set to a E_OpenconfigAaaTypes_SYSTEM_DEFINED_ROLES value.
type OpenconfigSystem_System_Aaa_Authentication_Users_User_Config_Role_Union_E_OpenconfigAaaTypes_SYSTEM_DEFINED_ROLES struct {
	E_OpenconfigAaaTypes_SYSTEM_DEFINED_ROLES	E_OpenconfigAaaTypes_SYSTEM_DEFINED_ROLES
}

// Is_OpenconfigSystem_System_Aaa_Authentication_Users_User_Config_Role_Union ensures that OpenconfigSystem_System_Aaa_Authentication_Users_User_Config_Role_Union_E_OpenconfigAaaTypes_SYSTEM_DEFINED_ROLES
// implements the OpenconfigSystem_System_Aaa_Authentication_Users_User_Config_Role_Union interface.
func (*OpenconfigSystem_System_Aaa_Authentication_Users_User_Config_Role_Union_E_OpenconfigAaaTypes_SYSTEM_DEFINED_ROLES) Is_OpenconfigSystem_System_Aaa_Authentication_Users_User_Config_Role_Union() {}

// OpenconfigSystem_System_Aaa_Authentication_Users_User_Config_Role_Union_String is used when /openconfig-system/system/aaa/authentication/users/user/config/role
// is to be set to a string value.
type OpenconfigSystem_System_Aaa_Authentication_Users_User_Config_Role_Union_String struct {
	String	string
}

// Is_OpenconfigSystem_System_Aaa_Authentication_Users_User_Config_Role_Union ensures that OpenconfigSystem_System_Aaa_Authentication_Users_User_Config_Role_Union_String
// implements the OpenconfigSystem_System_Aaa_Authentication_Users_User_Config_Role_Union interface.
func (*OpenconfigSystem_System_Aaa_Authentication_Users_User_Config_Role_Union_String) Is_OpenconfigSystem_System_Aaa_Authentication_Users_User_Config_Role_Union() {}

// To_OpenconfigSystem_System_Aaa_Authentication_Users_User_Config_Role_Union takes an input interface{} and attempts to convert it to a struct
// which implements the OpenconfigSystem_System_Aaa_Authentication_Users_User_Config_Role_Union union. It returns an error if the interface{} supplied
// cannot be converted to a type within the union.
func (t *OpenconfigSystem_System_Aaa_Authentication_Users_User_Config) To_OpenconfigSystem_System_Aaa_Authentication_Users_User_Config_Role_Union(i interface{}) (OpenconfigSystem_System_Aaa_Authentication_Users_User_Config_Role_Union, error) {
	switch v := i.(type) {
	case E_OpenconfigAaaTypes_SYSTEM_DEFINED_ROLES:
		return &OpenconfigSystem_System_Aaa_Authentication_Users_User_Config_Role_Union_E_OpenconfigAaaTypes_SYSTEM_DEFINED_ROLES{v}, nil
	case string:
		return &OpenconfigSystem_System_Aaa_Authentication_Users_User_Config_Role_Union_String{v}, nil
	default:
		return nil, fmt.Errorf("cannot convert %v to OpenconfigSystem_System_Aaa_Authentication_Users_User_Config_Role_Union, unknown union type, got: %T, want any of [E_OpenconfigAaaTypes_SYSTEM_DEFINED_ROLES, string]", i, i)
	}
}


// OpenconfigSystem_System_Aaa_Authentication_Users_User_State represents the /openconfig-system/system/aaa/authentication/users/user/state YANG schema element.
type OpenconfigSystem_System_Aaa_Authentication_Users_User_State struct {
	Password	*string	`path:"password" module:"openconfig-system"`
	PasswordHashed	*string	`path:"password-hashed" module:"openconfig-system"`
	Role	OpenconfigSystem_System_Aaa_Authentication_Users_User_State_Role_Union	`path:"role" module:"openconfig-system"`
	SshKey	*string	`path:"ssh-key" module:"openconfig-system"`
	Username	*string	`path:"username" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Aaa_Authentication_Users_User_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Aaa_Authentication_Users_User_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Aaa_Authentication_Users_User_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Aaa_Authentication_Users_User_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Aaa_Authentication_Users_User_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Aaa_Authentication_Users_User_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Aaa_Authentication_Users_User_State.
func (*OpenconfigSystem_System_Aaa_Authentication_Users_User_State) ΛBelongingModule() string {
	return "openconfig-system"
}

// OpenconfigSystem_System_Aaa_Authentication_Users_User_State_Role_Union is an interface that is implemented by valid types for the union
// for the leaf /openconfig-system/system/aaa/authentication/users/user/state/role within the YANG schema.
type OpenconfigSystem_System_Aaa_Authentication_Users_User_State_Role_Union interface {
	Is_OpenconfigSystem_System_Aaa_Authentication_Users_User_State_Role_Union()
}

// OpenconfigSystem_System_Aaa_Authentication_Users_User_State_Role_Union_E_OpenconfigAaaTypes_SYSTEM_DEFINED_ROLES is used when /openconfig-system/system/aaa/authentication/users/user/state/role
// is to be set to a E_OpenconfigAaaTypes_SYSTEM_DEFINED_ROLES value.
type OpenconfigSystem_System_Aaa_Authentication_Users_User_State_Role_Union_E_OpenconfigAaaTypes_SYSTEM_DEFINED_ROLES struct {
	E_OpenconfigAaaTypes_SYSTEM_DEFINED_ROLES	E_OpenconfigAaaTypes_SYSTEM_DEFINED_ROLES
}

// Is_OpenconfigSystem_System_Aaa_Authentication_Users_User_State_Role_Union ensures that OpenconfigSystem_System_Aaa_Authentication_Users_User_State_Role_Union_E_OpenconfigAaaTypes_SYSTEM_DEFINED_ROLES
// implements the OpenconfigSystem_System_Aaa_Authentication_Users_User_State_Role_Union interface.
func (*OpenconfigSystem_System_Aaa_Authentication_Users_User_State_Role_Union_E_OpenconfigAaaTypes_SYSTEM_DEFINED_ROLES) Is_OpenconfigSystem_System_Aaa_Authentication_Users_User_State_Role_Union() {}

// OpenconfigSystem_System_Aaa_Authentication_Users_User_State_Role_Union_String is used when /openconfig-system/system/aaa/authentication/users/user/state/role
// is to be set to a string value.
type OpenconfigSystem_System_Aaa_Authentication_Users_User_State_Role_Union_String struct {
	String	string
}

// Is_OpenconfigSystem_System_Aaa_Authentication_Users_User_State_Role_Union ensures that OpenconfigSystem_System_Aaa_Authentication_Users_User_State_Role_Union_String
// implements the OpenconfigSystem_System_Aaa_Authentication_Users_User_State_Role_Union interface.
func (*OpenconfigSystem_System_Aaa_Authentication_Users_User_State_Role_Union_String) Is_OpenconfigSystem_System_Aaa_Authentication_Users_User_State_Role_Union() {}

// To_OpenconfigSystem_System_Aaa_Authentication_Users_User_State_Role_Union takes an input interface{} and attempts to convert it to a struct
// which implements the OpenconfigSystem_System_Aaa_Authentication_Users_User_State_Role_Union union. It returns an error if the interface{} supplied
// cannot be converted to a type within the union.
func (t *OpenconfigSystem_System_Aaa_Authentication_Users_User_State) To_OpenconfigSystem_System_Aaa_Authentication_Users_User_State_Role_Union(i interface{}) (OpenconfigSystem_System_Aaa_Authentication_Users_User_State_Role_Union, error) {
	switch v := i.(type) {
	case E_OpenconfigAaaTypes_SYSTEM_DEFINED_ROLES:
		return &OpenconfigSystem_System_Aaa_Authentication_Users_User_State_Role_Union_E_OpenconfigAaaTypes_SYSTEM_DEFINED_ROLES{v}, nil
	case string:
		return &OpenconfigSystem_System_Aaa_Authentication_Users_User_State_Role_Union_String{v}, nil
	default:
		return nil, fmt.Errorf("cannot convert %v to OpenconfigSystem_System_Aaa_Authentication_Users_User_State_Role_Union, unknown union type, got: %T, want any of [E_OpenconfigAaaTypes_SYSTEM_DEFINED_ROLES, string]", i, i)
	}
}


// OpenconfigSystem_System_Aaa_Authorization represents the /openconfig-system/system/aaa/authorization YANG schema element.
type OpenconfigSystem_System_Aaa_Authorization struct {
	Config	*OpenconfigSystem_System_Aaa_Authorization_Config	`path:"config" module:"openconfig-system"`
	Events	*OpenconfigSystem_System_Aaa_Authorization_Events	`path:"events" module:"openconfig-system"`
	State	*OpenconfigSystem_System_Aaa_Authorization_State	`path:"state" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Aaa_Authorization implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Aaa_Authorization) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Aaa_Authorization) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Aaa_Authorization"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Aaa_Authorization) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Aaa_Authorization) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Aaa_Authorization.
func (*OpenconfigSystem_System_Aaa_Authorization) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Aaa_Authorization_Config represents the /openconfig-system/system/aaa/authorization/config YANG schema element.
type OpenconfigSystem_System_Aaa_Authorization_Config struct {
	AuthorizationMethod	[]OpenconfigSystem_System_Aaa_Authorization_Config_AuthorizationMethod_Union	`path:"authorization-method" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Aaa_Authorization_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Aaa_Authorization_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Aaa_Authorization_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Aaa_Authorization_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Aaa_Authorization_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Aaa_Authorization_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Aaa_Authorization_Config.
func (*OpenconfigSystem_System_Aaa_Authorization_Config) ΛBelongingModule() string {
	return "openconfig-system"
}

// OpenconfigSystem_System_Aaa_Authorization_Config_AuthorizationMethod_Union is an interface that is implemented by valid types for the union
// for the leaf /openconfig-system/system/aaa/authorization/config/authorization-method within the YANG schema.
type OpenconfigSystem_System_Aaa_Authorization_Config_AuthorizationMethod_Union interface {
	Is_OpenconfigSystem_System_Aaa_Authorization_Config_AuthorizationMethod_Union()
}

// OpenconfigSystem_System_Aaa_Authorization_Config_AuthorizationMethod_Union_E_OpenconfigAaaTypes_AAA_METHOD_TYPE is used when /openconfig-system/system/aaa/authorization/config/authorization-method
// is to be set to a E_OpenconfigAaaTypes_AAA_METHOD_TYPE value.
type OpenconfigSystem_System_Aaa_Authorization_Config_AuthorizationMethod_Union_E_OpenconfigAaaTypes_AAA_METHOD_TYPE struct {
	E_OpenconfigAaaTypes_AAA_METHOD_TYPE	E_OpenconfigAaaTypes_AAA_METHOD_TYPE
}

// Is_OpenconfigSystem_System_Aaa_Authorization_Config_AuthorizationMethod_Union ensures that OpenconfigSystem_System_Aaa_Authorization_Config_AuthorizationMethod_Union_E_OpenconfigAaaTypes_AAA_METHOD_TYPE
// implements the OpenconfigSystem_System_Aaa_Authorization_Config_AuthorizationMethod_Union interface.
func (*OpenconfigSystem_System_Aaa_Authorization_Config_AuthorizationMethod_Union_E_OpenconfigAaaTypes_AAA_METHOD_TYPE) Is_OpenconfigSystem_System_Aaa_Authorization_Config_AuthorizationMethod_Union() {}

// OpenconfigSystem_System_Aaa_Authorization_Config_AuthorizationMethod_Union_String is used when /openconfig-system/system/aaa/authorization/config/authorization-method
// is to be set to a string value.
type OpenconfigSystem_System_Aaa_Authorization_Config_AuthorizationMethod_Union_String struct {
	String	string
}

// Is_OpenconfigSystem_System_Aaa_Authorization_Config_AuthorizationMethod_Union ensures that OpenconfigSystem_System_Aaa_Authorization_Config_AuthorizationMethod_Union_String
// implements the OpenconfigSystem_System_Aaa_Authorization_Config_AuthorizationMethod_Union interface.
func (*OpenconfigSystem_System_Aaa_Authorization_Config_AuthorizationMethod_Union_String) Is_OpenconfigSystem_System_Aaa_Authorization_Config_AuthorizationMethod_Union() {}

// To_OpenconfigSystem_System_Aaa_Authorization_Config_AuthorizationMethod_Union takes an input interface{} and attempts to convert it to a struct
// which implements the OpenconfigSystem_System_Aaa_Authorization_Config_AuthorizationMethod_Union union. It returns an error if the interface{} supplied
// cannot be converted to a type within the union.
func (t *OpenconfigSystem_System_Aaa_Authorization_Config) To_OpenconfigSystem_System_Aaa_Authorization_Config_AuthorizationMethod_Union(i interface{}) (OpenconfigSystem_System_Aaa_Authorization_Config_AuthorizationMethod_Union, error) {
	switch v := i.(type) {
	case E_OpenconfigAaaTypes_AAA_METHOD_TYPE:
		return &OpenconfigSystem_System_Aaa_Authorization_Config_AuthorizationMethod_Union_E_OpenconfigAaaTypes_AAA_METHOD_TYPE{v}, nil
	case string:
		return &OpenconfigSystem_System_Aaa_Authorization_Config_AuthorizationMethod_Union_String{v}, nil
	default:
		return nil, fmt.Errorf("cannot convert %v to OpenconfigSystem_System_Aaa_Authorization_Config_AuthorizationMethod_Union, unknown union type, got: %T, want any of [E_OpenconfigAaaTypes_AAA_METHOD_TYPE, string]", i, i)
	}
}


// OpenconfigSystem_System_Aaa_Authorization_Events represents the /openconfig-system/system/aaa/authorization/events YANG schema element.
type OpenconfigSystem_System_Aaa_Authorization_Events struct {
	Event	map[E_OpenconfigAaaTypes_AAA_AUTHORIZATION_EVENT_TYPE]*OpenconfigSystem_System_Aaa_Authorization_Events_Event	`path:"event" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Aaa_Authorization_Events implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Aaa_Authorization_Events) IsYANGGoStruct() {}

// NewEvent creates a new entry in the Event list of the
// OpenconfigSystem_System_Aaa_Authorization_Events struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigSystem_System_Aaa_Authorization_Events) NewEvent(EventType E_OpenconfigAaaTypes_AAA_AUTHORIZATION_EVENT_TYPE) (*OpenconfigSystem_System_Aaa_Authorization_Events_Event, error){

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.Event == nil {
		t.Event = make(map[E_OpenconfigAaaTypes_AAA_AUTHORIZATION_EVENT_TYPE]*OpenconfigSystem_System_Aaa_Authorization_Events_Event)
	}

	key := EventType

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.Event[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list Event", key)
	}

	t.Event[key] = &OpenconfigSystem_System_Aaa_Authorization_Events_Event{
		EventType: EventType,
	}

	return t.Event[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Aaa_Authorization_Events) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Aaa_Authorization_Events"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Aaa_Authorization_Events) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Aaa_Authorization_Events) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Aaa_Authorization_Events.
func (*OpenconfigSystem_System_Aaa_Authorization_Events) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Aaa_Authorization_Events_Event represents the /openconfig-system/system/aaa/authorization/events/event YANG schema element.
type OpenconfigSystem_System_Aaa_Authorization_Events_Event struct {
	Config	*OpenconfigSystem_System_Aaa_Authorization_Events_Event_Config	`path:"config" module:"openconfig-system"`
	EventType	E_OpenconfigAaaTypes_AAA_AUTHORIZATION_EVENT_TYPE	`path:"event-type" module:"openconfig-system"`
	State	*OpenconfigSystem_System_Aaa_Authorization_Events_Event_State	`path:"state" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Aaa_Authorization_Events_Event implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Aaa_Authorization_Events_Event) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigSystem_System_Aaa_Authorization_Events_Event struct, which is a YANG list entry.
func (t *OpenconfigSystem_System_Aaa_Authorization_Events_Event) ΛListKeyMap() (map[string]interface{}, error) {

	return map[string]interface{}{
		"event-type": t.EventType,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Aaa_Authorization_Events_Event) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Aaa_Authorization_Events_Event"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Aaa_Authorization_Events_Event) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Aaa_Authorization_Events_Event) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Aaa_Authorization_Events_Event.
func (*OpenconfigSystem_System_Aaa_Authorization_Events_Event) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Aaa_Authorization_Events_Event_Config represents the /openconfig-system/system/aaa/authorization/events/event/config YANG schema element.
type OpenconfigSystem_System_Aaa_Authorization_Events_Event_Config struct {
	EventType	E_OpenconfigAaaTypes_AAA_AUTHORIZATION_EVENT_TYPE	`path:"event-type" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Aaa_Authorization_Events_Event_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Aaa_Authorization_Events_Event_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Aaa_Authorization_Events_Event_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Aaa_Authorization_Events_Event_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Aaa_Authorization_Events_Event_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Aaa_Authorization_Events_Event_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Aaa_Authorization_Events_Event_Config.
func (*OpenconfigSystem_System_Aaa_Authorization_Events_Event_Config) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Aaa_Authorization_Events_Event_State represents the /openconfig-system/system/aaa/authorization/events/event/state YANG schema element.
type OpenconfigSystem_System_Aaa_Authorization_Events_Event_State struct {
	EventType	E_OpenconfigAaaTypes_AAA_AUTHORIZATION_EVENT_TYPE	`path:"event-type" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Aaa_Authorization_Events_Event_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Aaa_Authorization_Events_Event_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Aaa_Authorization_Events_Event_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Aaa_Authorization_Events_Event_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Aaa_Authorization_Events_Event_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Aaa_Authorization_Events_Event_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Aaa_Authorization_Events_Event_State.
func (*OpenconfigSystem_System_Aaa_Authorization_Events_Event_State) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Aaa_Authorization_State represents the /openconfig-system/system/aaa/authorization/state YANG schema element.
type OpenconfigSystem_System_Aaa_Authorization_State struct {
	AuthorizationMethod	[]OpenconfigSystem_System_Aaa_Authorization_State_AuthorizationMethod_Union	`path:"authorization-method" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Aaa_Authorization_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Aaa_Authorization_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Aaa_Authorization_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Aaa_Authorization_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Aaa_Authorization_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Aaa_Authorization_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Aaa_Authorization_State.
func (*OpenconfigSystem_System_Aaa_Authorization_State) ΛBelongingModule() string {
	return "openconfig-system"
}

// OpenconfigSystem_System_Aaa_Authorization_State_AuthorizationMethod_Union is an interface that is implemented by valid types for the union
// for the leaf /openconfig-system/system/aaa/authorization/state/authorization-method within the YANG schema.
type OpenconfigSystem_System_Aaa_Authorization_State_AuthorizationMethod_Union interface {
	Is_OpenconfigSystem_System_Aaa_Authorization_State_AuthorizationMethod_Union()
}

// OpenconfigSystem_System_Aaa_Authorization_State_AuthorizationMethod_Union_E_OpenconfigAaaTypes_AAA_METHOD_TYPE is used when /openconfig-system/system/aaa/authorization/state/authorization-method
// is to be set to a E_OpenconfigAaaTypes_AAA_METHOD_TYPE value.
type OpenconfigSystem_System_Aaa_Authorization_State_AuthorizationMethod_Union_E_OpenconfigAaaTypes_AAA_METHOD_TYPE struct {
	E_OpenconfigAaaTypes_AAA_METHOD_TYPE	E_OpenconfigAaaTypes_AAA_METHOD_TYPE
}

// Is_OpenconfigSystem_System_Aaa_Authorization_State_AuthorizationMethod_Union ensures that OpenconfigSystem_System_Aaa_Authorization_State_AuthorizationMethod_Union_E_OpenconfigAaaTypes_AAA_METHOD_TYPE
// implements the OpenconfigSystem_System_Aaa_Authorization_State_AuthorizationMethod_Union interface.
func (*OpenconfigSystem_System_Aaa_Authorization_State_AuthorizationMethod_Union_E_OpenconfigAaaTypes_AAA_METHOD_TYPE) Is_OpenconfigSystem_System_Aaa_Authorization_State_AuthorizationMethod_Union() {}

// OpenconfigSystem_System_Aaa_Authorization_State_AuthorizationMethod_Union_String is used when /openconfig-system/system/aaa/authorization/state/authorization-method
// is to be set to a string value.
type OpenconfigSystem_System_Aaa_Authorization_State_AuthorizationMethod_Union_String struct {
	String	string
}

// Is_OpenconfigSystem_System_Aaa_Authorization_State_AuthorizationMethod_Union ensures that OpenconfigSystem_System_Aaa_Authorization_State_AuthorizationMethod_Union_String
// implements the OpenconfigSystem_System_Aaa_Authorization_State_AuthorizationMethod_Union interface.
func (*OpenconfigSystem_System_Aaa_Authorization_State_AuthorizationMethod_Union_String) Is_OpenconfigSystem_System_Aaa_Authorization_State_AuthorizationMethod_Union() {}

// To_OpenconfigSystem_System_Aaa_Authorization_State_AuthorizationMethod_Union takes an input interface{} and attempts to convert it to a struct
// which implements the OpenconfigSystem_System_Aaa_Authorization_State_AuthorizationMethod_Union union. It returns an error if the interface{} supplied
// cannot be converted to a type within the union.
func (t *OpenconfigSystem_System_Aaa_Authorization_State) To_OpenconfigSystem_System_Aaa_Authorization_State_AuthorizationMethod_Union(i interface{}) (OpenconfigSystem_System_Aaa_Authorization_State_AuthorizationMethod_Union, error) {
	switch v := i.(type) {
	case E_OpenconfigAaaTypes_AAA_METHOD_TYPE:
		return &OpenconfigSystem_System_Aaa_Authorization_State_AuthorizationMethod_Union_E_OpenconfigAaaTypes_AAA_METHOD_TYPE{v}, nil
	case string:
		return &OpenconfigSystem_System_Aaa_Authorization_State_AuthorizationMethod_Union_String{v}, nil
	default:
		return nil, fmt.Errorf("cannot convert %v to OpenconfigSystem_System_Aaa_Authorization_State_AuthorizationMethod_Union, unknown union type, got: %T, want any of [E_OpenconfigAaaTypes_AAA_METHOD_TYPE, string]", i, i)
	}
}


// OpenconfigSystem_System_Aaa_Config represents the /openconfig-system/system/aaa/config YANG schema element.
type OpenconfigSystem_System_Aaa_Config struct {
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Aaa_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Aaa_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Aaa_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Aaa_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Aaa_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Aaa_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Aaa_Config.
func (*OpenconfigSystem_System_Aaa_Config) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Aaa_ServerGroups represents the /openconfig-system/system/aaa/server-groups YANG schema element.
type OpenconfigSystem_System_Aaa_ServerGroups struct {
	ServerGroup	map[string]*OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup	`path:"server-group" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Aaa_ServerGroups implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Aaa_ServerGroups) IsYANGGoStruct() {}

// NewServerGroup creates a new entry in the ServerGroup list of the
// OpenconfigSystem_System_Aaa_ServerGroups struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigSystem_System_Aaa_ServerGroups) NewServerGroup(Name string) (*OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup, error){

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.ServerGroup == nil {
		t.ServerGroup = make(map[string]*OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup)
	}

	key := Name

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.ServerGroup[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list ServerGroup", key)
	}

	t.ServerGroup[key] = &OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup{
		Name: &Name,
	}

	return t.ServerGroup[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Aaa_ServerGroups) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Aaa_ServerGroups"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Aaa_ServerGroups) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Aaa_ServerGroups) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Aaa_ServerGroups.
func (*OpenconfigSystem_System_Aaa_ServerGroups) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup represents the /openconfig-system/system/aaa/server-groups/server-group YANG schema element.
type OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup struct {
	Config	*OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Config	`path:"config" module:"openconfig-system"`
	Name	*string	`path:"name" module:"openconfig-system"`
	Servers	*OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers	`path:"servers" module:"openconfig-system"`
	State	*OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_State	`path:"state" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup struct, which is a YANG list entry.
func (t *OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup) ΛListKeyMap() (map[string]interface{}, error) {
	if t.Name == nil {
		return nil, fmt.Errorf("nil value for key Name")
	}

	return map[string]interface{}{
		"name": *t.Name,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup.
func (*OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Config represents the /openconfig-system/system/aaa/server-groups/server-group/config YANG schema element.
type OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Config struct {
	Name	*string	`path:"name" module:"openconfig-system"`
	Type	E_OpenconfigAaaTypes_AAA_SERVER_TYPE	`path:"type" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Config.
func (*OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Config) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers represents the /openconfig-system/system/aaa/server-groups/server-group/servers YANG schema element.
type OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers struct {
	Server	map[string]*OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server	`path:"server" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers) IsYANGGoStruct() {}

// NewServer creates a new entry in the Server list of the
// OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers) NewServer(Address string) (*OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server, error){

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.Server == nil {
		t.Server = make(map[string]*OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server)
	}

	key := Address

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.Server[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list Server", key)
	}

	t.Server[key] = &OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server{
		Address: &Address,
	}

	return t.Server[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers.
func (*OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server represents the /openconfig-system/system/aaa/server-groups/server-group/servers/server YANG schema element.
type OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server struct {
	Address	*string	`path:"address" module:"openconfig-system"`
	Config	*OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Config	`path:"config" module:"openconfig-system"`
	Radius	*OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Radius	`path:"radius" module:"openconfig-system"`
	State	*OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_State	`path:"state" module:"openconfig-system"`
	Tacacs	*OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Tacacs	`path:"tacacs" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server struct, which is a YANG list entry.
func (t *OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server) ΛListKeyMap() (map[string]interface{}, error) {
	if t.Address == nil {
		return nil, fmt.Errorf("nil value for key Address")
	}

	return map[string]interface{}{
		"address": *t.Address,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server.
func (*OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Config represents the /openconfig-system/system/aaa/server-groups/server-group/servers/server/config YANG schema element.
type OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Config struct {
	Address	*string	`path:"address" module:"openconfig-system"`
	Name	*string	`path:"name" module:"openconfig-system"`
	Timeout	*uint16	`path:"timeout" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Config.
func (*OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Config) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Radius represents the /openconfig-system/system/aaa/server-groups/server-group/servers/server/radius YANG schema element.
type OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Radius struct {
	Config	*OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Radius_Config	`path:"config" module:"openconfig-system"`
	State	*OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Radius_State	`path:"state" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Radius implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Radius) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Radius) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Radius"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Radius) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Radius) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Radius.
func (*OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Radius) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Radius_Config represents the /openconfig-system/system/aaa/server-groups/server-group/servers/server/radius/config YANG schema element.
type OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Radius_Config struct {
	AcctPort	*uint16	`path:"acct-port" module:"openconfig-system"`
	AuthPort	*uint16	`path:"auth-port" module:"openconfig-system"`
	RetransmitAttempts	*uint8	`path:"retransmit-attempts" module:"openconfig-system"`
	SecretKey	*string	`path:"secret-key" module:"openconfig-system"`
	SecretKeyHashed	*string	`path:"secret-key-hashed" module:"openconfig-system"`
	SourceAddress	*string	`path:"source-address" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Radius_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Radius_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Radius_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Radius_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Radius_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Radius_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Radius_Config.
func (*OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Radius_Config) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Radius_State represents the /openconfig-system/system/aaa/server-groups/server-group/servers/server/radius/state YANG schema element.
type OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Radius_State struct {
	AcctPort	*uint16	`path:"acct-port" module:"openconfig-system"`
	AuthPort	*uint16	`path:"auth-port" module:"openconfig-system"`
	Counters	*OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Radius_State_Counters	`path:"counters" module:"openconfig-system"`
	RetransmitAttempts	*uint8	`path:"retransmit-attempts" module:"openconfig-system"`
	SecretKey	*string	`path:"secret-key" module:"openconfig-system"`
	SecretKeyHashed	*string	`path:"secret-key-hashed" module:"openconfig-system"`
	SourceAddress	*string	`path:"source-address" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Radius_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Radius_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Radius_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Radius_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Radius_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Radius_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Radius_State.
func (*OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Radius_State) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Radius_State_Counters represents the /openconfig-system/system/aaa/server-groups/server-group/servers/server/radius/state/counters YANG schema element.
type OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Radius_State_Counters struct {
	AccessAccepts	*uint64	`path:"access-accepts" module:"openconfig-system"`
	AccessRejects	*uint64	`path:"access-rejects" module:"openconfig-system"`
	RetriedAccessRequests	*uint64	`path:"retried-access-requests" module:"openconfig-system"`
	TimeoutAccessRequests	*uint64	`path:"timeout-access-requests" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Radius_State_Counters implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Radius_State_Counters) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Radius_State_Counters) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Radius_State_Counters"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Radius_State_Counters) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Radius_State_Counters) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Radius_State_Counters.
func (*OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Radius_State_Counters) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_State represents the /openconfig-system/system/aaa/server-groups/server-group/servers/server/state YANG schema element.
type OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_State struct {
	Address	*string	`path:"address" module:"openconfig-system"`
	ConnectionAborts	*uint64	`path:"connection-aborts" module:"openconfig-system"`
	ConnectionCloses	*uint64	`path:"connection-closes" module:"openconfig-system"`
	ConnectionFailures	*uint64	`path:"connection-failures" module:"openconfig-system"`
	ConnectionOpens	*uint64	`path:"connection-opens" module:"openconfig-system"`
	ConnectionTimeouts	*uint64	`path:"connection-timeouts" module:"openconfig-system"`
	ErrorsReceived	*uint64	`path:"errors-received" module:"openconfig-system"`
	MessagesReceived	*uint64	`path:"messages-received" module:"openconfig-system"`
	MessagesSent	*uint64	`path:"messages-sent" module:"openconfig-system"`
	Name	*string	`path:"name" module:"openconfig-system"`
	Timeout	*uint16	`path:"timeout" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_State.
func (*OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_State) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Tacacs represents the /openconfig-system/system/aaa/server-groups/server-group/servers/server/tacacs YANG schema element.
type OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Tacacs struct {
	Config	*OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Tacacs_Config	`path:"config" module:"openconfig-system"`
	State	*OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Tacacs_State	`path:"state" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Tacacs implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Tacacs) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Tacacs) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Tacacs"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Tacacs) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Tacacs) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Tacacs.
func (*OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Tacacs) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Tacacs_Config represents the /openconfig-system/system/aaa/server-groups/server-group/servers/server/tacacs/config YANG schema element.
type OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Tacacs_Config struct {
	Port	*uint16	`path:"port" module:"openconfig-system"`
	SecretKey	*string	`path:"secret-key" module:"openconfig-system"`
	SecretKeyHashed	*string	`path:"secret-key-hashed" module:"openconfig-system"`
	SourceAddress	*string	`path:"source-address" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Tacacs_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Tacacs_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Tacacs_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Tacacs_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Tacacs_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Tacacs_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Tacacs_Config.
func (*OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Tacacs_Config) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Tacacs_State represents the /openconfig-system/system/aaa/server-groups/server-group/servers/server/tacacs/state YANG schema element.
type OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Tacacs_State struct {
	Port	*uint16	`path:"port" module:"openconfig-system"`
	SecretKey	*string	`path:"secret-key" module:"openconfig-system"`
	SecretKeyHashed	*string	`path:"secret-key-hashed" module:"openconfig-system"`
	SourceAddress	*string	`path:"source-address" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Tacacs_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Tacacs_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Tacacs_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Tacacs_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Tacacs_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Tacacs_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Tacacs_State.
func (*OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Tacacs_State) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_State represents the /openconfig-system/system/aaa/server-groups/server-group/state YANG schema element.
type OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_State struct {
	Name	*string	`path:"name" module:"openconfig-system"`
	Type	E_OpenconfigAaaTypes_AAA_SERVER_TYPE	`path:"type" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_State.
func (*OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_State) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Aaa_State represents the /openconfig-system/system/aaa/state YANG schema element.
type OpenconfigSystem_System_Aaa_State struct {
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Aaa_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Aaa_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Aaa_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Aaa_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Aaa_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Aaa_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Aaa_State.
func (*OpenconfigSystem_System_Aaa_State) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Alarms represents the /openconfig-system/system/alarms YANG schema element.
type OpenconfigSystem_System_Alarms struct {
	Alarm	map[string]*OpenconfigSystem_System_Alarms_Alarm	`path:"alarm" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Alarms implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Alarms) IsYANGGoStruct() {}

// NewAlarm creates a new entry in the Alarm list of the
// OpenconfigSystem_System_Alarms struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigSystem_System_Alarms) NewAlarm(Id string) (*OpenconfigSystem_System_Alarms_Alarm, error){

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.Alarm == nil {
		t.Alarm = make(map[string]*OpenconfigSystem_System_Alarms_Alarm)
	}

	key := Id

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.Alarm[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list Alarm", key)
	}

	t.Alarm[key] = &OpenconfigSystem_System_Alarms_Alarm{
		Id: &Id,
	}

	return t.Alarm[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Alarms) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Alarms"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Alarms) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Alarms) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Alarms.
func (*OpenconfigSystem_System_Alarms) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Alarms_Alarm represents the /openconfig-system/system/alarms/alarm YANG schema element.
type OpenconfigSystem_System_Alarms_Alarm struct {
	Config	*OpenconfigSystem_System_Alarms_Alarm_Config	`path:"config" module:"openconfig-system"`
	Id	*string	`path:"id" module:"openconfig-system"`
	State	*OpenconfigSystem_System_Alarms_Alarm_State	`path:"state" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Alarms_Alarm implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Alarms_Alarm) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigSystem_System_Alarms_Alarm struct, which is a YANG list entry.
func (t *OpenconfigSystem_System_Alarms_Alarm) ΛListKeyMap() (map[string]interface{}, error) {
	if t.Id == nil {
		return nil, fmt.Errorf("nil value for key Id")
	}

	return map[string]interface{}{
		"id": *t.Id,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Alarms_Alarm) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Alarms_Alarm"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Alarms_Alarm) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Alarms_Alarm) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Alarms_Alarm.
func (*OpenconfigSystem_System_Alarms_Alarm) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Alarms_Alarm_Config represents the /openconfig-system/system/alarms/alarm/config YANG schema element.
type OpenconfigSystem_System_Alarms_Alarm_Config struct {
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Alarms_Alarm_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Alarms_Alarm_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Alarms_Alarm_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Alarms_Alarm_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Alarms_Alarm_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Alarms_Alarm_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Alarms_Alarm_Config.
func (*OpenconfigSystem_System_Alarms_Alarm_Config) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Alarms_Alarm_State represents the /openconfig-system/system/alarms/alarm/state YANG schema element.
type OpenconfigSystem_System_Alarms_Alarm_State struct {
	Id	*string	`path:"id" module:"openconfig-system"`
	Resource	*string	`path:"resource" module:"openconfig-system"`
	Severity	E_OpenconfigAlarmTypes_OPENCONFIG_ALARM_SEVERITY	`path:"severity" module:"openconfig-system"`
	Text	*string	`path:"text" module:"openconfig-system"`
	TimeCreated	*uint64	`path:"time-created" module:"openconfig-system"`
	TypeId	OpenconfigSystem_System_Alarms_Alarm_State_TypeId_Union	`path:"type-id" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Alarms_Alarm_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Alarms_Alarm_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Alarms_Alarm_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Alarms_Alarm_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Alarms_Alarm_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Alarms_Alarm_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Alarms_Alarm_State.
func (*OpenconfigSystem_System_Alarms_Alarm_State) ΛBelongingModule() string {
	return "openconfig-system"
}

// OpenconfigSystem_System_Alarms_Alarm_State_TypeId_Union is an interface that is implemented by valid types for the union
// for the leaf /openconfig-system/system/alarms/alarm/state/type-id within the YANG schema.
type OpenconfigSystem_System_Alarms_Alarm_State_TypeId_Union interface {
	Is_OpenconfigSystem_System_Alarms_Alarm_State_TypeId_Union()
}

// OpenconfigSystem_System_Alarms_Alarm_State_TypeId_Union_E_OpenconfigAlarmTypes_OPENCONFIG_ALARM_TYPE_ID is used when /openconfig-system/system/alarms/alarm/state/type-id
// is to be set to a E_OpenconfigAlarmTypes_OPENCONFIG_ALARM_TYPE_ID value.
type OpenconfigSystem_System_Alarms_Alarm_State_TypeId_Union_E_OpenconfigAlarmTypes_OPENCONFIG_ALARM_TYPE_ID struct {
	E_OpenconfigAlarmTypes_OPENCONFIG_ALARM_TYPE_ID	E_OpenconfigAlarmTypes_OPENCONFIG_ALARM_TYPE_ID
}

// Is_OpenconfigSystem_System_Alarms_Alarm_State_TypeId_Union ensures that OpenconfigSystem_System_Alarms_Alarm_State_TypeId_Union_E_OpenconfigAlarmTypes_OPENCONFIG_ALARM_TYPE_ID
// implements the OpenconfigSystem_System_Alarms_Alarm_State_TypeId_Union interface.
func (*OpenconfigSystem_System_Alarms_Alarm_State_TypeId_Union_E_OpenconfigAlarmTypes_OPENCONFIG_ALARM_TYPE_ID) Is_OpenconfigSystem_System_Alarms_Alarm_State_TypeId_Union() {}

// OpenconfigSystem_System_Alarms_Alarm_State_TypeId_Union_String is used when /openconfig-system/system/alarms/alarm/state/type-id
// is to be set to a string value.
type OpenconfigSystem_System_Alarms_Alarm_State_TypeId_Union_String struct {
	String	string
}

// Is_OpenconfigSystem_System_Alarms_Alarm_State_TypeId_Union ensures that OpenconfigSystem_System_Alarms_Alarm_State_TypeId_Union_String
// implements the OpenconfigSystem_System_Alarms_Alarm_State_TypeId_Union interface.
func (*OpenconfigSystem_System_Alarms_Alarm_State_TypeId_Union_String) Is_OpenconfigSystem_System_Alarms_Alarm_State_TypeId_Union() {}

// To_OpenconfigSystem_System_Alarms_Alarm_State_TypeId_Union takes an input interface{} and attempts to convert it to a struct
// which implements the OpenconfigSystem_System_Alarms_Alarm_State_TypeId_Union union. It returns an error if the interface{} supplied
// cannot be converted to a type within the union.
func (t *OpenconfigSystem_System_Alarms_Alarm_State) To_OpenconfigSystem_System_Alarms_Alarm_State_TypeId_Union(i interface{}) (OpenconfigSystem_System_Alarms_Alarm_State_TypeId_Union, error) {
	switch v := i.(type) {
	case E_OpenconfigAlarmTypes_OPENCONFIG_ALARM_TYPE_ID:
		return &OpenconfigSystem_System_Alarms_Alarm_State_TypeId_Union_E_OpenconfigAlarmTypes_OPENCONFIG_ALARM_TYPE_ID{v}, nil
	case string:
		return &OpenconfigSystem_System_Alarms_Alarm_State_TypeId_Union_String{v}, nil
	default:
		return nil, fmt.Errorf("cannot convert %v to OpenconfigSystem_System_Alarms_Alarm_State_TypeId_Union, unknown union type, got: %T, want any of [E_OpenconfigAlarmTypes_OPENCONFIG_ALARM_TYPE_ID, string]", i, i)
	}
}


// OpenconfigSystem_System_Clock represents the /openconfig-system/system/clock YANG schema element.
type OpenconfigSystem_System_Clock struct {
	Config	*OpenconfigSystem_System_Clock_Config	`path:"config" module:"openconfig-system"`
	State	*OpenconfigSystem_System_Clock_State	`path:"state" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Clock implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Clock) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Clock) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Clock"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Clock) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Clock) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Clock.
func (*OpenconfigSystem_System_Clock) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Clock_Config represents the /openconfig-system/system/clock/config YANG schema element.
type OpenconfigSystem_System_Clock_Config struct {
	TimezoneName	*string	`path:"timezone-name" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Clock_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Clock_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Clock_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Clock_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Clock_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Clock_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Clock_Config.
func (*OpenconfigSystem_System_Clock_Config) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Clock_State represents the /openconfig-system/system/clock/state YANG schema element.
type OpenconfigSystem_System_Clock_State struct {
	TimezoneName	*string	`path:"timezone-name" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Clock_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Clock_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Clock_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Clock_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Clock_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Clock_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Clock_State.
func (*OpenconfigSystem_System_Clock_State) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Config represents the /openconfig-system/system/config YANG schema element.
type OpenconfigSystem_System_Config struct {
	DomainName	*string	`path:"domain-name" module:"openconfig-system"`
	Hostname	*string	`path:"hostname" module:"openconfig-system"`
	LoginBanner	*string	`path:"login-banner" module:"openconfig-system"`
	MotdBanner	*string	`path:"motd-banner" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Config.
func (*OpenconfigSystem_System_Config) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Cpus represents the /openconfig-system/system/cpus YANG schema element.
type OpenconfigSystem_System_Cpus struct {
	Cpu	map[OpenconfigSystem_System_Cpus_Cpu_State_Index_Union]*OpenconfigSystem_System_Cpus_Cpu	`path:"cpu" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Cpus implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Cpus) IsYANGGoStruct() {}

// NewCpu creates a new entry in the Cpu list of the
// OpenconfigSystem_System_Cpus struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigSystem_System_Cpus) NewCpu(Index OpenconfigSystem_System_Cpus_Cpu_State_Index_Union) (*OpenconfigSystem_System_Cpus_Cpu, error){

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.Cpu == nil {
		t.Cpu = make(map[OpenconfigSystem_System_Cpus_Cpu_State_Index_Union]*OpenconfigSystem_System_Cpus_Cpu)
	}

	key := Index

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.Cpu[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list Cpu", key)
	}

	t.Cpu[key] = &OpenconfigSystem_System_Cpus_Cpu{
		Index: Index,
	}

	return t.Cpu[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Cpus) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Cpus"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Cpus) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Cpus) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Cpus.
func (*OpenconfigSystem_System_Cpus) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Cpus_Cpu represents the /openconfig-system/system/cpus/cpu YANG schema element.
type OpenconfigSystem_System_Cpus_Cpu struct {
	Index	OpenconfigSystem_System_Cpus_Cpu_State_Index_Union	`path:"index" module:"openconfig-system"`
	State	*OpenconfigSystem_System_Cpus_Cpu_State	`path:"state" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Cpus_Cpu implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Cpus_Cpu) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigSystem_System_Cpus_Cpu struct, which is a YANG list entry.
func (t *OpenconfigSystem_System_Cpus_Cpu) ΛListKeyMap() (map[string]interface{}, error) {

	return map[string]interface{}{
		"index": t.Index,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Cpus_Cpu) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Cpus_Cpu"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Cpus_Cpu) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Cpus_Cpu) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Cpus_Cpu.
func (*OpenconfigSystem_System_Cpus_Cpu) ΛBelongingModule() string {
	return "openconfig-system"
}

// OpenconfigSystem_System_Cpus_Cpu_State_Index_Union is an interface that is implemented by valid types for the union
// for the leaf /openconfig-system/system/cpus/cpu/index within the YANG schema.
type OpenconfigSystem_System_Cpus_Cpu_State_Index_Union interface {
	Is_OpenconfigSystem_System_Cpus_Cpu_State_Index_Union()
}

// OpenconfigSystem_System_Cpus_Cpu_State_Index_Union_E_OpenconfigSystem_System_Cpus_Cpu_State_Index is used when /openconfig-system/system/cpus/cpu/index
// is to be set to a E_OpenconfigSystem_System_Cpus_Cpu_State_Index value.
type OpenconfigSystem_System_Cpus_Cpu_State_Index_Union_E_OpenconfigSystem_System_Cpus_Cpu_State_Index struct {
	E_OpenconfigSystem_System_Cpus_Cpu_State_Index	E_OpenconfigSystem_System_Cpus_Cpu_State_Index
}

// Is_OpenconfigSystem_System_Cpus_Cpu_State_Index_Union ensures that OpenconfigSystem_System_Cpus_Cpu_State_Index_Union_E_OpenconfigSystem_System_Cpus_Cpu_State_Index
// implements the OpenconfigSystem_System_Cpus_Cpu_State_Index_Union interface.
func (*OpenconfigSystem_System_Cpus_Cpu_State_Index_Union_E_OpenconfigSystem_System_Cpus_Cpu_State_Index) Is_OpenconfigSystem_System_Cpus_Cpu_State_Index_Union() {}

// OpenconfigSystem_System_Cpus_Cpu_State_Index_Union_Uint32 is used when /openconfig-system/system/cpus/cpu/index
// is to be set to a uint32 value.
type OpenconfigSystem_System_Cpus_Cpu_State_Index_Union_Uint32 struct {
	Uint32	uint32
}

// Is_OpenconfigSystem_System_Cpus_Cpu_State_Index_Union ensures that OpenconfigSystem_System_Cpus_Cpu_State_Index_Union_Uint32
// implements the OpenconfigSystem_System_Cpus_Cpu_State_Index_Union interface.
func (*OpenconfigSystem_System_Cpus_Cpu_State_Index_Union_Uint32) Is_OpenconfigSystem_System_Cpus_Cpu_State_Index_Union() {}

// To_OpenconfigSystem_System_Cpus_Cpu_State_Index_Union takes an input interface{} and attempts to convert it to a struct
// which implements the OpenconfigSystem_System_Cpus_Cpu_State_Index_Union union. It returns an error if the interface{} supplied
// cannot be converted to a type within the union.
func (t *OpenconfigSystem_System_Cpus_Cpu) To_OpenconfigSystem_System_Cpus_Cpu_State_Index_Union(i interface{}) (OpenconfigSystem_System_Cpus_Cpu_State_Index_Union, error) {
	switch v := i.(type) {
	case E_OpenconfigSystem_System_Cpus_Cpu_State_Index:
		return &OpenconfigSystem_System_Cpus_Cpu_State_Index_Union_E_OpenconfigSystem_System_Cpus_Cpu_State_Index{v}, nil
	case uint32:
		return &OpenconfigSystem_System_Cpus_Cpu_State_Index_Union_Uint32{v}, nil
	default:
		return nil, fmt.Errorf("cannot convert %v to OpenconfigSystem_System_Cpus_Cpu_State_Index_Union, unknown union type, got: %T, want any of [E_OpenconfigSystem_System_Cpus_Cpu_State_Index, uint32]", i, i)
	}
}


// OpenconfigSystem_System_Cpus_Cpu_State represents the /openconfig-system/system/cpus/cpu/state YANG schema element.
type OpenconfigSystem_System_Cpus_Cpu_State struct {
	HardwareInterrupt	*OpenconfigSystem_System_Cpus_Cpu_State_HardwareInterrupt	`path:"hardware-interrupt" module:"openconfig-system"`
	Idle	*OpenconfigSystem_System_Cpus_Cpu_State_Idle	`path:"idle" module:"openconfig-system"`
	Index	OpenconfigSystem_System_Cpus_Cpu_State_Index_Union	`path:"index" module:"openconfig-system"`
	Kernel	*OpenconfigSystem_System_Cpus_Cpu_State_Kernel	`path:"kernel" module:"openconfig-system"`
	Nice	*OpenconfigSystem_System_Cpus_Cpu_State_Nice	`path:"nice" module:"openconfig-system"`
	SoftwareInterrupt	*OpenconfigSystem_System_Cpus_Cpu_State_SoftwareInterrupt	`path:"software-interrupt" module:"openconfig-system"`
	Total	*OpenconfigSystem_System_Cpus_Cpu_State_Total	`path:"total" module:"openconfig-system"`
	User	*OpenconfigSystem_System_Cpus_Cpu_State_User	`path:"user" module:"openconfig-system"`
	Wait	*OpenconfigSystem_System_Cpus_Cpu_State_Wait	`path:"wait" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Cpus_Cpu_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Cpus_Cpu_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Cpus_Cpu_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Cpus_Cpu_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Cpus_Cpu_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Cpus_Cpu_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Cpus_Cpu_State.
func (*OpenconfigSystem_System_Cpus_Cpu_State) ΛBelongingModule() string {
	return "openconfig-system"
}

// To_OpenconfigSystem_System_Cpus_Cpu_State_Index_Union takes an input interface{} and attempts to convert it to a struct
// which implements the OpenconfigSystem_System_Cpus_Cpu_State_Index_Union union. It returns an error if the interface{} supplied
// cannot be converted to a type within the union.
func (t *OpenconfigSystem_System_Cpus_Cpu_State) To_OpenconfigSystem_System_Cpus_Cpu_State_Index_Union(i interface{}) (OpenconfigSystem_System_Cpus_Cpu_State_Index_Union, error) {
	switch v := i.(type) {
	case E_OpenconfigSystem_System_Cpus_Cpu_State_Index:
		return &OpenconfigSystem_System_Cpus_Cpu_State_Index_Union_E_OpenconfigSystem_System_Cpus_Cpu_State_Index{v}, nil
	case uint32:
		return &OpenconfigSystem_System_Cpus_Cpu_State_Index_Union_Uint32{v}, nil
	default:
		return nil, fmt.Errorf("cannot convert %v to OpenconfigSystem_System_Cpus_Cpu_State_Index_Union, unknown union type, got: %T, want any of [E_OpenconfigSystem_System_Cpus_Cpu_State_Index, uint32]", i, i)
	}
}


// OpenconfigSystem_System_Cpus_Cpu_State_HardwareInterrupt represents the /openconfig-system/system/cpus/cpu/state/hardware-interrupt YANG schema element.
type OpenconfigSystem_System_Cpus_Cpu_State_HardwareInterrupt struct {
	Avg	*uint8	`path:"avg" module:"openconfig-system"`
	Instant	*uint8	`path:"instant" module:"openconfig-system"`
	Interval	*uint64	`path:"interval" module:"openconfig-system"`
	Max	*uint8	`path:"max" module:"openconfig-system"`
	MaxTime	*uint64	`path:"max-time" module:"openconfig-system"`
	Min	*uint8	`path:"min" module:"openconfig-system"`
	MinTime	*uint64	`path:"min-time" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Cpus_Cpu_State_HardwareInterrupt implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Cpus_Cpu_State_HardwareInterrupt) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Cpus_Cpu_State_HardwareInterrupt) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Cpus_Cpu_State_HardwareInterrupt"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Cpus_Cpu_State_HardwareInterrupt) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Cpus_Cpu_State_HardwareInterrupt) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Cpus_Cpu_State_HardwareInterrupt.
func (*OpenconfigSystem_System_Cpus_Cpu_State_HardwareInterrupt) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Cpus_Cpu_State_Idle represents the /openconfig-system/system/cpus/cpu/state/idle YANG schema element.
type OpenconfigSystem_System_Cpus_Cpu_State_Idle struct {
	Avg	*uint8	`path:"avg" module:"openconfig-system"`
	Instant	*uint8	`path:"instant" module:"openconfig-system"`
	Interval	*uint64	`path:"interval" module:"openconfig-system"`
	Max	*uint8	`path:"max" module:"openconfig-system"`
	MaxTime	*uint64	`path:"max-time" module:"openconfig-system"`
	Min	*uint8	`path:"min" module:"openconfig-system"`
	MinTime	*uint64	`path:"min-time" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Cpus_Cpu_State_Idle implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Cpus_Cpu_State_Idle) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Cpus_Cpu_State_Idle) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Cpus_Cpu_State_Idle"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Cpus_Cpu_State_Idle) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Cpus_Cpu_State_Idle) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Cpus_Cpu_State_Idle.
func (*OpenconfigSystem_System_Cpus_Cpu_State_Idle) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Cpus_Cpu_State_Kernel represents the /openconfig-system/system/cpus/cpu/state/kernel YANG schema element.
type OpenconfigSystem_System_Cpus_Cpu_State_Kernel struct {
	Avg	*uint8	`path:"avg" module:"openconfig-system"`
	Instant	*uint8	`path:"instant" module:"openconfig-system"`
	Interval	*uint64	`path:"interval" module:"openconfig-system"`
	Max	*uint8	`path:"max" module:"openconfig-system"`
	MaxTime	*uint64	`path:"max-time" module:"openconfig-system"`
	Min	*uint8	`path:"min" module:"openconfig-system"`
	MinTime	*uint64	`path:"min-time" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Cpus_Cpu_State_Kernel implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Cpus_Cpu_State_Kernel) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Cpus_Cpu_State_Kernel) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Cpus_Cpu_State_Kernel"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Cpus_Cpu_State_Kernel) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Cpus_Cpu_State_Kernel) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Cpus_Cpu_State_Kernel.
func (*OpenconfigSystem_System_Cpus_Cpu_State_Kernel) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Cpus_Cpu_State_Nice represents the /openconfig-system/system/cpus/cpu/state/nice YANG schema element.
type OpenconfigSystem_System_Cpus_Cpu_State_Nice struct {
	Avg	*uint8	`path:"avg" module:"openconfig-system"`
	Instant	*uint8	`path:"instant" module:"openconfig-system"`
	Interval	*uint64	`path:"interval" module:"openconfig-system"`
	Max	*uint8	`path:"max" module:"openconfig-system"`
	MaxTime	*uint64	`path:"max-time" module:"openconfig-system"`
	Min	*uint8	`path:"min" module:"openconfig-system"`
	MinTime	*uint64	`path:"min-time" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Cpus_Cpu_State_Nice implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Cpus_Cpu_State_Nice) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Cpus_Cpu_State_Nice) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Cpus_Cpu_State_Nice"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Cpus_Cpu_State_Nice) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Cpus_Cpu_State_Nice) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Cpus_Cpu_State_Nice.
func (*OpenconfigSystem_System_Cpus_Cpu_State_Nice) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Cpus_Cpu_State_SoftwareInterrupt represents the /openconfig-system/system/cpus/cpu/state/software-interrupt YANG schema element.
type OpenconfigSystem_System_Cpus_Cpu_State_SoftwareInterrupt struct {
	Avg	*uint8	`path:"avg" module:"openconfig-system"`
	Instant	*uint8	`path:"instant" module:"openconfig-system"`
	Interval	*uint64	`path:"interval" module:"openconfig-system"`
	Max	*uint8	`path:"max" module:"openconfig-system"`
	MaxTime	*uint64	`path:"max-time" module:"openconfig-system"`
	Min	*uint8	`path:"min" module:"openconfig-system"`
	MinTime	*uint64	`path:"min-time" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Cpus_Cpu_State_SoftwareInterrupt implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Cpus_Cpu_State_SoftwareInterrupt) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Cpus_Cpu_State_SoftwareInterrupt) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Cpus_Cpu_State_SoftwareInterrupt"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Cpus_Cpu_State_SoftwareInterrupt) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Cpus_Cpu_State_SoftwareInterrupt) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Cpus_Cpu_State_SoftwareInterrupt.
func (*OpenconfigSystem_System_Cpus_Cpu_State_SoftwareInterrupt) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Cpus_Cpu_State_Total represents the /openconfig-system/system/cpus/cpu/state/total YANG schema element.
type OpenconfigSystem_System_Cpus_Cpu_State_Total struct {
	Avg	*uint8	`path:"avg" module:"openconfig-system"`
	Instant	*uint8	`path:"instant" module:"openconfig-system"`
	Interval	*uint64	`path:"interval" module:"openconfig-system"`
	Max	*uint8	`path:"max" module:"openconfig-system"`
	MaxTime	*uint64	`path:"max-time" module:"openconfig-system"`
	Min	*uint8	`path:"min" module:"openconfig-system"`
	MinTime	*uint64	`path:"min-time" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Cpus_Cpu_State_Total implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Cpus_Cpu_State_Total) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Cpus_Cpu_State_Total) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Cpus_Cpu_State_Total"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Cpus_Cpu_State_Total) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Cpus_Cpu_State_Total) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Cpus_Cpu_State_Total.
func (*OpenconfigSystem_System_Cpus_Cpu_State_Total) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Cpus_Cpu_State_User represents the /openconfig-system/system/cpus/cpu/state/user YANG schema element.
type OpenconfigSystem_System_Cpus_Cpu_State_User struct {
	Avg	*uint8	`path:"avg" module:"openconfig-system"`
	Instant	*uint8	`path:"instant" module:"openconfig-system"`
	Interval	*uint64	`path:"interval" module:"openconfig-system"`
	Max	*uint8	`path:"max" module:"openconfig-system"`
	MaxTime	*uint64	`path:"max-time" module:"openconfig-system"`
	Min	*uint8	`path:"min" module:"openconfig-system"`
	MinTime	*uint64	`path:"min-time" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Cpus_Cpu_State_User implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Cpus_Cpu_State_User) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Cpus_Cpu_State_User) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Cpus_Cpu_State_User"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Cpus_Cpu_State_User) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Cpus_Cpu_State_User) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Cpus_Cpu_State_User.
func (*OpenconfigSystem_System_Cpus_Cpu_State_User) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Cpus_Cpu_State_Wait represents the /openconfig-system/system/cpus/cpu/state/wait YANG schema element.
type OpenconfigSystem_System_Cpus_Cpu_State_Wait struct {
	Avg	*uint8	`path:"avg" module:"openconfig-system"`
	Instant	*uint8	`path:"instant" module:"openconfig-system"`
	Interval	*uint64	`path:"interval" module:"openconfig-system"`
	Max	*uint8	`path:"max" module:"openconfig-system"`
	MaxTime	*uint64	`path:"max-time" module:"openconfig-system"`
	Min	*uint8	`path:"min" module:"openconfig-system"`
	MinTime	*uint64	`path:"min-time" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Cpus_Cpu_State_Wait implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Cpus_Cpu_State_Wait) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Cpus_Cpu_State_Wait) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Cpus_Cpu_State_Wait"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Cpus_Cpu_State_Wait) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Cpus_Cpu_State_Wait) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Cpus_Cpu_State_Wait.
func (*OpenconfigSystem_System_Cpus_Cpu_State_Wait) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Dns represents the /openconfig-system/system/dns YANG schema element.
type OpenconfigSystem_System_Dns struct {
	Config	*OpenconfigSystem_System_Dns_Config	`path:"config" module:"openconfig-system"`
	HostEntries	*OpenconfigSystem_System_Dns_HostEntries	`path:"host-entries" module:"openconfig-system"`
	Servers	*OpenconfigSystem_System_Dns_Servers	`path:"servers" module:"openconfig-system"`
	State	*OpenconfigSystem_System_Dns_State	`path:"state" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Dns implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Dns) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Dns) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Dns"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Dns) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Dns) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Dns.
func (*OpenconfigSystem_System_Dns) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Dns_Config represents the /openconfig-system/system/dns/config YANG schema element.
type OpenconfigSystem_System_Dns_Config struct {
	Search	[]string	`path:"search" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Dns_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Dns_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Dns_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Dns_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Dns_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Dns_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Dns_Config.
func (*OpenconfigSystem_System_Dns_Config) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Dns_HostEntries represents the /openconfig-system/system/dns/host-entries YANG schema element.
type OpenconfigSystem_System_Dns_HostEntries struct {
	HostEntry	map[string]*OpenconfigSystem_System_Dns_HostEntries_HostEntry	`path:"host-entry" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Dns_HostEntries implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Dns_HostEntries) IsYANGGoStruct() {}

// NewHostEntry creates a new entry in the HostEntry list of the
// OpenconfigSystem_System_Dns_HostEntries struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigSystem_System_Dns_HostEntries) NewHostEntry(Hostname string) (*OpenconfigSystem_System_Dns_HostEntries_HostEntry, error){

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.HostEntry == nil {
		t.HostEntry = make(map[string]*OpenconfigSystem_System_Dns_HostEntries_HostEntry)
	}

	key := Hostname

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.HostEntry[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list HostEntry", key)
	}

	t.HostEntry[key] = &OpenconfigSystem_System_Dns_HostEntries_HostEntry{
		Hostname: &Hostname,
	}

	return t.HostEntry[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Dns_HostEntries) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Dns_HostEntries"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Dns_HostEntries) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Dns_HostEntries) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Dns_HostEntries.
func (*OpenconfigSystem_System_Dns_HostEntries) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Dns_HostEntries_HostEntry represents the /openconfig-system/system/dns/host-entries/host-entry YANG schema element.
type OpenconfigSystem_System_Dns_HostEntries_HostEntry struct {
	Config	*OpenconfigSystem_System_Dns_HostEntries_HostEntry_Config	`path:"config" module:"openconfig-system"`
	Hostname	*string	`path:"hostname" module:"openconfig-system"`
	State	*OpenconfigSystem_System_Dns_HostEntries_HostEntry_State	`path:"state" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Dns_HostEntries_HostEntry implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Dns_HostEntries_HostEntry) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigSystem_System_Dns_HostEntries_HostEntry struct, which is a YANG list entry.
func (t *OpenconfigSystem_System_Dns_HostEntries_HostEntry) ΛListKeyMap() (map[string]interface{}, error) {
	if t.Hostname == nil {
		return nil, fmt.Errorf("nil value for key Hostname")
	}

	return map[string]interface{}{
		"hostname": *t.Hostname,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Dns_HostEntries_HostEntry) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Dns_HostEntries_HostEntry"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Dns_HostEntries_HostEntry) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Dns_HostEntries_HostEntry) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Dns_HostEntries_HostEntry.
func (*OpenconfigSystem_System_Dns_HostEntries_HostEntry) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Dns_HostEntries_HostEntry_Config represents the /openconfig-system/system/dns/host-entries/host-entry/config YANG schema element.
type OpenconfigSystem_System_Dns_HostEntries_HostEntry_Config struct {
	Alias	[]string	`path:"alias" module:"openconfig-system"`
	Hostname	*string	`path:"hostname" module:"openconfig-system"`
	Ipv4Address	[]string	`path:"ipv4-address" module:"openconfig-system"`
	Ipv6Address	[]string	`path:"ipv6-address" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Dns_HostEntries_HostEntry_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Dns_HostEntries_HostEntry_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Dns_HostEntries_HostEntry_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Dns_HostEntries_HostEntry_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Dns_HostEntries_HostEntry_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Dns_HostEntries_HostEntry_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Dns_HostEntries_HostEntry_Config.
func (*OpenconfigSystem_System_Dns_HostEntries_HostEntry_Config) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Dns_HostEntries_HostEntry_State represents the /openconfig-system/system/dns/host-entries/host-entry/state YANG schema element.
type OpenconfigSystem_System_Dns_HostEntries_HostEntry_State struct {
	Alias	[]string	`path:"alias" module:"openconfig-system"`
	Hostname	*string	`path:"hostname" module:"openconfig-system"`
	Ipv4Address	[]string	`path:"ipv4-address" module:"openconfig-system"`
	Ipv6Address	[]string	`path:"ipv6-address" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Dns_HostEntries_HostEntry_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Dns_HostEntries_HostEntry_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Dns_HostEntries_HostEntry_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Dns_HostEntries_HostEntry_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Dns_HostEntries_HostEntry_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Dns_HostEntries_HostEntry_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Dns_HostEntries_HostEntry_State.
func (*OpenconfigSystem_System_Dns_HostEntries_HostEntry_State) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Dns_Servers represents the /openconfig-system/system/dns/servers YANG schema element.
type OpenconfigSystem_System_Dns_Servers struct {
	Server	map[string]*OpenconfigSystem_System_Dns_Servers_Server	`path:"server" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Dns_Servers implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Dns_Servers) IsYANGGoStruct() {}

// NewServer creates a new entry in the Server list of the
// OpenconfigSystem_System_Dns_Servers struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigSystem_System_Dns_Servers) NewServer(Address string) (*OpenconfigSystem_System_Dns_Servers_Server, error){

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.Server == nil {
		t.Server = make(map[string]*OpenconfigSystem_System_Dns_Servers_Server)
	}

	key := Address

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.Server[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list Server", key)
	}

	t.Server[key] = &OpenconfigSystem_System_Dns_Servers_Server{
		Address: &Address,
	}

	return t.Server[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Dns_Servers) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Dns_Servers"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Dns_Servers) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Dns_Servers) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Dns_Servers.
func (*OpenconfigSystem_System_Dns_Servers) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Dns_Servers_Server represents the /openconfig-system/system/dns/servers/server YANG schema element.
type OpenconfigSystem_System_Dns_Servers_Server struct {
	Address	*string	`path:"address" module:"openconfig-system"`
	Config	*OpenconfigSystem_System_Dns_Servers_Server_Config	`path:"config" module:"openconfig-system"`
	State	*OpenconfigSystem_System_Dns_Servers_Server_State	`path:"state" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Dns_Servers_Server implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Dns_Servers_Server) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigSystem_System_Dns_Servers_Server struct, which is a YANG list entry.
func (t *OpenconfigSystem_System_Dns_Servers_Server) ΛListKeyMap() (map[string]interface{}, error) {
	if t.Address == nil {
		return nil, fmt.Errorf("nil value for key Address")
	}

	return map[string]interface{}{
		"address": *t.Address,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Dns_Servers_Server) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Dns_Servers_Server"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Dns_Servers_Server) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Dns_Servers_Server) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Dns_Servers_Server.
func (*OpenconfigSystem_System_Dns_Servers_Server) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Dns_Servers_Server_Config represents the /openconfig-system/system/dns/servers/server/config YANG schema element.
type OpenconfigSystem_System_Dns_Servers_Server_Config struct {
	Address	*string	`path:"address" module:"openconfig-system"`
	Port	*uint16	`path:"port" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Dns_Servers_Server_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Dns_Servers_Server_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Dns_Servers_Server_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Dns_Servers_Server_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Dns_Servers_Server_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Dns_Servers_Server_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Dns_Servers_Server_Config.
func (*OpenconfigSystem_System_Dns_Servers_Server_Config) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Dns_Servers_Server_State represents the /openconfig-system/system/dns/servers/server/state YANG schema element.
type OpenconfigSystem_System_Dns_Servers_Server_State struct {
	Address	*string	`path:"address" module:"openconfig-system"`
	Port	*uint16	`path:"port" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Dns_Servers_Server_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Dns_Servers_Server_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Dns_Servers_Server_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Dns_Servers_Server_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Dns_Servers_Server_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Dns_Servers_Server_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Dns_Servers_Server_State.
func (*OpenconfigSystem_System_Dns_Servers_Server_State) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Dns_State represents the /openconfig-system/system/dns/state YANG schema element.
type OpenconfigSystem_System_Dns_State struct {
	Search	[]string	`path:"search" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Dns_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Dns_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Dns_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Dns_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Dns_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Dns_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Dns_State.
func (*OpenconfigSystem_System_Dns_State) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_License represents the /openconfig-system/system/license YANG schema element.
type OpenconfigSystem_System_License struct {
	Licenses	*OpenconfigSystem_System_License_Licenses	`path:"licenses" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_License implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_License) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_License) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_License"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_License) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_License) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_License.
func (*OpenconfigSystem_System_License) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_License_Licenses represents the /openconfig-system/system/license/licenses YANG schema element.
type OpenconfigSystem_System_License_Licenses struct {
	License	map[string]*OpenconfigSystem_System_License_Licenses_License	`path:"license" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_License_Licenses implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_License_Licenses) IsYANGGoStruct() {}

// NewLicense creates a new entry in the License list of the
// OpenconfigSystem_System_License_Licenses struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigSystem_System_License_Licenses) NewLicense(LicenseId string) (*OpenconfigSystem_System_License_Licenses_License, error){

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.License == nil {
		t.License = make(map[string]*OpenconfigSystem_System_License_Licenses_License)
	}

	key := LicenseId

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.License[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list License", key)
	}

	t.License[key] = &OpenconfigSystem_System_License_Licenses_License{
		LicenseId: &LicenseId,
	}

	return t.License[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_License_Licenses) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_License_Licenses"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_License_Licenses) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_License_Licenses) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_License_Licenses.
func (*OpenconfigSystem_System_License_Licenses) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_License_Licenses_License represents the /openconfig-system/system/license/licenses/license YANG schema element.
type OpenconfigSystem_System_License_Licenses_License struct {
	Config	*OpenconfigSystem_System_License_Licenses_License_Config	`path:"config" module:"openconfig-system"`
	LicenseId	*string	`path:"license-id" module:"openconfig-system"`
	State	*OpenconfigSystem_System_License_Licenses_License_State	`path:"state" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_License_Licenses_License implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_License_Licenses_License) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigSystem_System_License_Licenses_License struct, which is a YANG list entry.
func (t *OpenconfigSystem_System_License_Licenses_License) ΛListKeyMap() (map[string]interface{}, error) {
	if t.LicenseId == nil {
		return nil, fmt.Errorf("nil value for key LicenseId")
	}

	return map[string]interface{}{
		"license-id": *t.LicenseId,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_License_Licenses_License) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_License_Licenses_License"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_License_Licenses_License) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_License_Licenses_License) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_License_Licenses_License.
func (*OpenconfigSystem_System_License_Licenses_License) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_License_Licenses_License_Config represents the /openconfig-system/system/license/licenses/license/config YANG schema element.
type OpenconfigSystem_System_License_Licenses_License_Config struct {
	Active	*bool	`path:"active" module:"openconfig-system"`
	LicenseData	OpenconfigSystem_System_License_Licenses_License_Config_LicenseData_Union	`path:"license-data" module:"openconfig-system"`
	LicenseId	*string	`path:"license-id" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_License_Licenses_License_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_License_Licenses_License_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_License_Licenses_License_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_License_Licenses_License_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_License_Licenses_License_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_License_Licenses_License_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_License_Licenses_License_Config.
func (*OpenconfigSystem_System_License_Licenses_License_Config) ΛBelongingModule() string {
	return "openconfig-system"
}

// OpenconfigSystem_System_License_Licenses_License_Config_LicenseData_Union is an interface that is implemented by valid types for the union
// for the leaf /openconfig-system/system/license/licenses/license/config/license-data within the YANG schema.
type OpenconfigSystem_System_License_Licenses_License_Config_LicenseData_Union interface {
	Is_OpenconfigSystem_System_License_Licenses_License_Config_LicenseData_Union()
}

// OpenconfigSystem_System_License_Licenses_License_Config_LicenseData_Union_Binary is used when /openconfig-system/system/license/licenses/license/config/license-data
// is to be set to a Binary value.
type OpenconfigSystem_System_License_Licenses_License_Config_LicenseData_Union_Binary struct {
	Binary	Binary
}

// Is_OpenconfigSystem_System_License_Licenses_License_Config_LicenseData_Union ensures that OpenconfigSystem_System_License_Licenses_License_Config_LicenseData_Union_Binary
// implements the OpenconfigSystem_System_License_Licenses_License_Config_LicenseData_Union interface.
func (*OpenconfigSystem_System_License_Licenses_License_Config_LicenseData_Union_Binary) Is_OpenconfigSystem_System_License_Licenses_License_Config_LicenseData_Union() {}

// OpenconfigSystem_System_License_Licenses_License_Config_LicenseData_Union_String is used when /openconfig-system/system/license/licenses/license/config/license-data
// is to be set to a string value.
type OpenconfigSystem_System_License_Licenses_License_Config_LicenseData_Union_String struct {
	String	string
}

// Is_OpenconfigSystem_System_License_Licenses_License_Config_LicenseData_Union ensures that OpenconfigSystem_System_License_Licenses_License_Config_LicenseData_Union_String
// implements the OpenconfigSystem_System_License_Licenses_License_Config_LicenseData_Union interface.
func (*OpenconfigSystem_System_License_Licenses_License_Config_LicenseData_Union_String) Is_OpenconfigSystem_System_License_Licenses_License_Config_LicenseData_Union() {}

// To_OpenconfigSystem_System_License_Licenses_License_Config_LicenseData_Union takes an input interface{} and attempts to convert it to a struct
// which implements the OpenconfigSystem_System_License_Licenses_License_Config_LicenseData_Union union. It returns an error if the interface{} supplied
// cannot be converted to a type within the union.
func (t *OpenconfigSystem_System_License_Licenses_License_Config) To_OpenconfigSystem_System_License_Licenses_License_Config_LicenseData_Union(i interface{}) (OpenconfigSystem_System_License_Licenses_License_Config_LicenseData_Union, error) {
	switch v := i.(type) {
	case Binary:
		return &OpenconfigSystem_System_License_Licenses_License_Config_LicenseData_Union_Binary{v}, nil
	case string:
		return &OpenconfigSystem_System_License_Licenses_License_Config_LicenseData_Union_String{v}, nil
	default:
		return nil, fmt.Errorf("cannot convert %v to OpenconfigSystem_System_License_Licenses_License_Config_LicenseData_Union, unknown union type, got: %T, want any of [Binary, string]", i, i)
	}
}


// OpenconfigSystem_System_License_Licenses_License_State represents the /openconfig-system/system/license/licenses/license/state YANG schema element.
type OpenconfigSystem_System_License_Licenses_License_State struct {
	Active	*bool	`path:"active" module:"openconfig-system"`
	Description	*string	`path:"description" module:"openconfig-system"`
	ExpirationDate	*uint64	`path:"expiration-date" module:"openconfig-system"`
	Expired	*bool	`path:"expired" module:"openconfig-system"`
	InUse	*bool	`path:"in-use" module:"openconfig-system"`
	IssueDate	*uint64	`path:"issue-date" module:"openconfig-system"`
	LicenseData	OpenconfigSystem_System_License_Licenses_License_State_LicenseData_Union	`path:"license-data" module:"openconfig-system"`
	LicenseId	*string	`path:"license-id" module:"openconfig-system"`
	Valid	*bool	`path:"valid" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_License_Licenses_License_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_License_Licenses_License_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_License_Licenses_License_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_License_Licenses_License_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_License_Licenses_License_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_License_Licenses_License_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_License_Licenses_License_State.
func (*OpenconfigSystem_System_License_Licenses_License_State) ΛBelongingModule() string {
	return "openconfig-system"
}

// OpenconfigSystem_System_License_Licenses_License_State_LicenseData_Union is an interface that is implemented by valid types for the union
// for the leaf /openconfig-system/system/license/licenses/license/state/license-data within the YANG schema.
type OpenconfigSystem_System_License_Licenses_License_State_LicenseData_Union interface {
	Is_OpenconfigSystem_System_License_Licenses_License_State_LicenseData_Union()
}

// OpenconfigSystem_System_License_Licenses_License_State_LicenseData_Union_Binary is used when /openconfig-system/system/license/licenses/license/state/license-data
// is to be set to a Binary value.
type OpenconfigSystem_System_License_Licenses_License_State_LicenseData_Union_Binary struct {
	Binary	Binary
}

// Is_OpenconfigSystem_System_License_Licenses_License_State_LicenseData_Union ensures that OpenconfigSystem_System_License_Licenses_License_State_LicenseData_Union_Binary
// implements the OpenconfigSystem_System_License_Licenses_License_State_LicenseData_Union interface.
func (*OpenconfigSystem_System_License_Licenses_License_State_LicenseData_Union_Binary) Is_OpenconfigSystem_System_License_Licenses_License_State_LicenseData_Union() {}

// OpenconfigSystem_System_License_Licenses_License_State_LicenseData_Union_String is used when /openconfig-system/system/license/licenses/license/state/license-data
// is to be set to a string value.
type OpenconfigSystem_System_License_Licenses_License_State_LicenseData_Union_String struct {
	String	string
}

// Is_OpenconfigSystem_System_License_Licenses_License_State_LicenseData_Union ensures that OpenconfigSystem_System_License_Licenses_License_State_LicenseData_Union_String
// implements the OpenconfigSystem_System_License_Licenses_License_State_LicenseData_Union interface.
func (*OpenconfigSystem_System_License_Licenses_License_State_LicenseData_Union_String) Is_OpenconfigSystem_System_License_Licenses_License_State_LicenseData_Union() {}

// To_OpenconfigSystem_System_License_Licenses_License_State_LicenseData_Union takes an input interface{} and attempts to convert it to a struct
// which implements the OpenconfigSystem_System_License_Licenses_License_State_LicenseData_Union union. It returns an error if the interface{} supplied
// cannot be converted to a type within the union.
func (t *OpenconfigSystem_System_License_Licenses_License_State) To_OpenconfigSystem_System_License_Licenses_License_State_LicenseData_Union(i interface{}) (OpenconfigSystem_System_License_Licenses_License_State_LicenseData_Union, error) {
	switch v := i.(type) {
	case Binary:
		return &OpenconfigSystem_System_License_Licenses_License_State_LicenseData_Union_Binary{v}, nil
	case string:
		return &OpenconfigSystem_System_License_Licenses_License_State_LicenseData_Union_String{v}, nil
	default:
		return nil, fmt.Errorf("cannot convert %v to OpenconfigSystem_System_License_Licenses_License_State_LicenseData_Union, unknown union type, got: %T, want any of [Binary, string]", i, i)
	}
}


// OpenconfigSystem_System_Logging represents the /openconfig-system/system/logging YANG schema element.
type OpenconfigSystem_System_Logging struct {
	Console	*OpenconfigSystem_System_Logging_Console	`path:"console" module:"openconfig-system"`
	RemoteServers	*OpenconfigSystem_System_Logging_RemoteServers	`path:"remote-servers" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Logging implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Logging) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Logging) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Logging"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Logging) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Logging) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Logging.
func (*OpenconfigSystem_System_Logging) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Logging_Console represents the /openconfig-system/system/logging/console YANG schema element.
type OpenconfigSystem_System_Logging_Console struct {
	Config	*OpenconfigSystem_System_Logging_Console_Config	`path:"config" module:"openconfig-system"`
	Selectors	*OpenconfigSystem_System_Logging_Console_Selectors	`path:"selectors" module:"openconfig-system"`
	State	*OpenconfigSystem_System_Logging_Console_State	`path:"state" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Logging_Console implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Logging_Console) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Logging_Console) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Logging_Console"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Logging_Console) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Logging_Console) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Logging_Console.
func (*OpenconfigSystem_System_Logging_Console) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Logging_Console_Config represents the /openconfig-system/system/logging/console/config YANG schema element.
type OpenconfigSystem_System_Logging_Console_Config struct {
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Logging_Console_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Logging_Console_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Logging_Console_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Logging_Console_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Logging_Console_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Logging_Console_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Logging_Console_Config.
func (*OpenconfigSystem_System_Logging_Console_Config) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Logging_Console_Selectors represents the /openconfig-system/system/logging/console/selectors YANG schema element.
type OpenconfigSystem_System_Logging_Console_Selectors struct {
	Selector	map[OpenconfigSystem_System_Logging_Console_Selectors_Selector_Key]*OpenconfigSystem_System_Logging_Console_Selectors_Selector	`path:"selector" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Logging_Console_Selectors implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Logging_Console_Selectors) IsYANGGoStruct() {}

// OpenconfigSystem_System_Logging_Console_Selectors_Selector_Key represents the key for list Selector of element /openconfig-system/system/logging/console/selectors.
type OpenconfigSystem_System_Logging_Console_Selectors_Selector_Key struct {
	Facility	E_OpenconfigSystemLogging_SYSLOG_FACILITY	`path:"facility"`
	Severity	E_OpenconfigSystemLogging_SyslogSeverity	`path:"severity"`
}

// NewSelector creates a new entry in the Selector list of the
// OpenconfigSystem_System_Logging_Console_Selectors struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigSystem_System_Logging_Console_Selectors) NewSelector(Facility E_OpenconfigSystemLogging_SYSLOG_FACILITY, Severity E_OpenconfigSystemLogging_SyslogSeverity) (*OpenconfigSystem_System_Logging_Console_Selectors_Selector, error){

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.Selector == nil {
		t.Selector = make(map[OpenconfigSystem_System_Logging_Console_Selectors_Selector_Key]*OpenconfigSystem_System_Logging_Console_Selectors_Selector)
	}

	key := OpenconfigSystem_System_Logging_Console_Selectors_Selector_Key{
		Facility: Facility,
		Severity: Severity,
	}

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.Selector[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list Selector", key)
	}

	t.Selector[key] = &OpenconfigSystem_System_Logging_Console_Selectors_Selector{
		Facility: Facility,
		Severity: Severity,
	}

	return t.Selector[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Logging_Console_Selectors) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Logging_Console_Selectors"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Logging_Console_Selectors) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Logging_Console_Selectors) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Logging_Console_Selectors.
func (*OpenconfigSystem_System_Logging_Console_Selectors) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Logging_Console_Selectors_Selector represents the /openconfig-system/system/logging/console/selectors/selector YANG schema element.
type OpenconfigSystem_System_Logging_Console_Selectors_Selector struct {
	Config	*OpenconfigSystem_System_Logging_Console_Selectors_Selector_Config	`path:"config" module:"openconfig-system"`
	Facility	E_OpenconfigSystemLogging_SYSLOG_FACILITY	`path:"facility" module:"openconfig-system"`
	Severity	E_OpenconfigSystemLogging_SyslogSeverity	`path:"severity" module:"openconfig-system"`
	State	*OpenconfigSystem_System_Logging_Console_Selectors_Selector_State	`path:"state" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Logging_Console_Selectors_Selector implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Logging_Console_Selectors_Selector) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigSystem_System_Logging_Console_Selectors_Selector struct, which is a YANG list entry.
func (t *OpenconfigSystem_System_Logging_Console_Selectors_Selector) ΛListKeyMap() (map[string]interface{}, error) {


	return map[string]interface{}{
		"facility": t.Facility,
		"severity": t.Severity,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Logging_Console_Selectors_Selector) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Logging_Console_Selectors_Selector"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Logging_Console_Selectors_Selector) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Logging_Console_Selectors_Selector) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Logging_Console_Selectors_Selector.
func (*OpenconfigSystem_System_Logging_Console_Selectors_Selector) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Logging_Console_Selectors_Selector_Config represents the /openconfig-system/system/logging/console/selectors/selector/config YANG schema element.
type OpenconfigSystem_System_Logging_Console_Selectors_Selector_Config struct {
	Facility	E_OpenconfigSystemLogging_SYSLOG_FACILITY	`path:"facility" module:"openconfig-system"`
	Severity	E_OpenconfigSystemLogging_SyslogSeverity	`path:"severity" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Logging_Console_Selectors_Selector_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Logging_Console_Selectors_Selector_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Logging_Console_Selectors_Selector_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Logging_Console_Selectors_Selector_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Logging_Console_Selectors_Selector_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Logging_Console_Selectors_Selector_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Logging_Console_Selectors_Selector_Config.
func (*OpenconfigSystem_System_Logging_Console_Selectors_Selector_Config) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Logging_Console_Selectors_Selector_State represents the /openconfig-system/system/logging/console/selectors/selector/state YANG schema element.
type OpenconfigSystem_System_Logging_Console_Selectors_Selector_State struct {
	Facility	E_OpenconfigSystemLogging_SYSLOG_FACILITY	`path:"facility" module:"openconfig-system"`
	Severity	E_OpenconfigSystemLogging_SyslogSeverity	`path:"severity" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Logging_Console_Selectors_Selector_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Logging_Console_Selectors_Selector_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Logging_Console_Selectors_Selector_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Logging_Console_Selectors_Selector_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Logging_Console_Selectors_Selector_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Logging_Console_Selectors_Selector_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Logging_Console_Selectors_Selector_State.
func (*OpenconfigSystem_System_Logging_Console_Selectors_Selector_State) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Logging_Console_State represents the /openconfig-system/system/logging/console/state YANG schema element.
type OpenconfigSystem_System_Logging_Console_State struct {
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Logging_Console_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Logging_Console_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Logging_Console_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Logging_Console_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Logging_Console_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Logging_Console_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Logging_Console_State.
func (*OpenconfigSystem_System_Logging_Console_State) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Logging_RemoteServers represents the /openconfig-system/system/logging/remote-servers YANG schema element.
type OpenconfigSystem_System_Logging_RemoteServers struct {
	RemoteServer	map[string]*OpenconfigSystem_System_Logging_RemoteServers_RemoteServer	`path:"remote-server" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Logging_RemoteServers implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Logging_RemoteServers) IsYANGGoStruct() {}

// NewRemoteServer creates a new entry in the RemoteServer list of the
// OpenconfigSystem_System_Logging_RemoteServers struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigSystem_System_Logging_RemoteServers) NewRemoteServer(Host string) (*OpenconfigSystem_System_Logging_RemoteServers_RemoteServer, error){

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.RemoteServer == nil {
		t.RemoteServer = make(map[string]*OpenconfigSystem_System_Logging_RemoteServers_RemoteServer)
	}

	key := Host

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.RemoteServer[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list RemoteServer", key)
	}

	t.RemoteServer[key] = &OpenconfigSystem_System_Logging_RemoteServers_RemoteServer{
		Host: &Host,
	}

	return t.RemoteServer[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Logging_RemoteServers) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Logging_RemoteServers"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Logging_RemoteServers) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Logging_RemoteServers) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Logging_RemoteServers.
func (*OpenconfigSystem_System_Logging_RemoteServers) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Logging_RemoteServers_RemoteServer represents the /openconfig-system/system/logging/remote-servers/remote-server YANG schema element.
type OpenconfigSystem_System_Logging_RemoteServers_RemoteServer struct {
	Config	*OpenconfigSystem_System_Logging_RemoteServers_RemoteServer_Config	`path:"config" module:"openconfig-system"`
	Host	*string	`path:"host" module:"openconfig-system"`
	Selectors	*OpenconfigSystem_System_Logging_RemoteServers_RemoteServer_Selectors	`path:"selectors" module:"openconfig-system"`
	State	*OpenconfigSystem_System_Logging_RemoteServers_RemoteServer_State	`path:"state" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Logging_RemoteServers_RemoteServer implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Logging_RemoteServers_RemoteServer) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigSystem_System_Logging_RemoteServers_RemoteServer struct, which is a YANG list entry.
func (t *OpenconfigSystem_System_Logging_RemoteServers_RemoteServer) ΛListKeyMap() (map[string]interface{}, error) {
	if t.Host == nil {
		return nil, fmt.Errorf("nil value for key Host")
	}

	return map[string]interface{}{
		"host": *t.Host,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Logging_RemoteServers_RemoteServer) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Logging_RemoteServers_RemoteServer"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Logging_RemoteServers_RemoteServer) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Logging_RemoteServers_RemoteServer) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Logging_RemoteServers_RemoteServer.
func (*OpenconfigSystem_System_Logging_RemoteServers_RemoteServer) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Logging_RemoteServers_RemoteServer_Config represents the /openconfig-system/system/logging/remote-servers/remote-server/config YANG schema element.
type OpenconfigSystem_System_Logging_RemoteServers_RemoteServer_Config struct {
	Host	*string	`path:"host" module:"openconfig-system"`
	RemotePort	*uint16	`path:"remote-port" module:"openconfig-system"`
	SourceAddress	*string	`path:"source-address" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Logging_RemoteServers_RemoteServer_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Logging_RemoteServers_RemoteServer_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Logging_RemoteServers_RemoteServer_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Logging_RemoteServers_RemoteServer_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Logging_RemoteServers_RemoteServer_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Logging_RemoteServers_RemoteServer_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Logging_RemoteServers_RemoteServer_Config.
func (*OpenconfigSystem_System_Logging_RemoteServers_RemoteServer_Config) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Logging_RemoteServers_RemoteServer_Selectors represents the /openconfig-system/system/logging/remote-servers/remote-server/selectors YANG schema element.
type OpenconfigSystem_System_Logging_RemoteServers_RemoteServer_Selectors struct {
	Selector	map[OpenconfigSystem_System_Logging_RemoteServers_RemoteServer_Selectors_Selector_Key]*OpenconfigSystem_System_Logging_RemoteServers_RemoteServer_Selectors_Selector	`path:"selector" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Logging_RemoteServers_RemoteServer_Selectors implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Logging_RemoteServers_RemoteServer_Selectors) IsYANGGoStruct() {}

// OpenconfigSystem_System_Logging_RemoteServers_RemoteServer_Selectors_Selector_Key represents the key for list Selector of element /openconfig-system/system/logging/remote-servers/remote-server/selectors.
type OpenconfigSystem_System_Logging_RemoteServers_RemoteServer_Selectors_Selector_Key struct {
	Facility	E_OpenconfigSystemLogging_SYSLOG_FACILITY	`path:"facility"`
	Severity	E_OpenconfigSystemLogging_SyslogSeverity	`path:"severity"`
}

// NewSelector creates a new entry in the Selector list of the
// OpenconfigSystem_System_Logging_RemoteServers_RemoteServer_Selectors struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigSystem_System_Logging_RemoteServers_RemoteServer_Selectors) NewSelector(Facility E_OpenconfigSystemLogging_SYSLOG_FACILITY, Severity E_OpenconfigSystemLogging_SyslogSeverity) (*OpenconfigSystem_System_Logging_RemoteServers_RemoteServer_Selectors_Selector, error){

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.Selector == nil {
		t.Selector = make(map[OpenconfigSystem_System_Logging_RemoteServers_RemoteServer_Selectors_Selector_Key]*OpenconfigSystem_System_Logging_RemoteServers_RemoteServer_Selectors_Selector)
	}

	key := OpenconfigSystem_System_Logging_RemoteServers_RemoteServer_Selectors_Selector_Key{
		Facility: Facility,
		Severity: Severity,
	}

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.Selector[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list Selector", key)
	}

	t.Selector[key] = &OpenconfigSystem_System_Logging_RemoteServers_RemoteServer_Selectors_Selector{
		Facility: Facility,
		Severity: Severity,
	}

	return t.Selector[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Logging_RemoteServers_RemoteServer_Selectors) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Logging_RemoteServers_RemoteServer_Selectors"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Logging_RemoteServers_RemoteServer_Selectors) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Logging_RemoteServers_RemoteServer_Selectors) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Logging_RemoteServers_RemoteServer_Selectors.
func (*OpenconfigSystem_System_Logging_RemoteServers_RemoteServer_Selectors) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Logging_RemoteServers_RemoteServer_Selectors_Selector represents the /openconfig-system/system/logging/remote-servers/remote-server/selectors/selector YANG schema element.
type OpenconfigSystem_System_Logging_RemoteServers_RemoteServer_Selectors_Selector struct {
	Config	*OpenconfigSystem_System_Logging_RemoteServers_RemoteServer_Selectors_Selector_Config	`path:"config" module:"openconfig-system"`
	Facility	E_OpenconfigSystemLogging_SYSLOG_FACILITY	`path:"facility" module:"openconfig-system"`
	Severity	E_OpenconfigSystemLogging_SyslogSeverity	`path:"severity" module:"openconfig-system"`
	State	*OpenconfigSystem_System_Logging_RemoteServers_RemoteServer_Selectors_Selector_State	`path:"state" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Logging_RemoteServers_RemoteServer_Selectors_Selector implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Logging_RemoteServers_RemoteServer_Selectors_Selector) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigSystem_System_Logging_RemoteServers_RemoteServer_Selectors_Selector struct, which is a YANG list entry.
func (t *OpenconfigSystem_System_Logging_RemoteServers_RemoteServer_Selectors_Selector) ΛListKeyMap() (map[string]interface{}, error) {


	return map[string]interface{}{
		"facility": t.Facility,
		"severity": t.Severity,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Logging_RemoteServers_RemoteServer_Selectors_Selector) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Logging_RemoteServers_RemoteServer_Selectors_Selector"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Logging_RemoteServers_RemoteServer_Selectors_Selector) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Logging_RemoteServers_RemoteServer_Selectors_Selector) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Logging_RemoteServers_RemoteServer_Selectors_Selector.
func (*OpenconfigSystem_System_Logging_RemoteServers_RemoteServer_Selectors_Selector) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Logging_RemoteServers_RemoteServer_Selectors_Selector_Config represents the /openconfig-system/system/logging/remote-servers/remote-server/selectors/selector/config YANG schema element.
type OpenconfigSystem_System_Logging_RemoteServers_RemoteServer_Selectors_Selector_Config struct {
	Facility	E_OpenconfigSystemLogging_SYSLOG_FACILITY	`path:"facility" module:"openconfig-system"`
	Severity	E_OpenconfigSystemLogging_SyslogSeverity	`path:"severity" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Logging_RemoteServers_RemoteServer_Selectors_Selector_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Logging_RemoteServers_RemoteServer_Selectors_Selector_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Logging_RemoteServers_RemoteServer_Selectors_Selector_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Logging_RemoteServers_RemoteServer_Selectors_Selector_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Logging_RemoteServers_RemoteServer_Selectors_Selector_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Logging_RemoteServers_RemoteServer_Selectors_Selector_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Logging_RemoteServers_RemoteServer_Selectors_Selector_Config.
func (*OpenconfigSystem_System_Logging_RemoteServers_RemoteServer_Selectors_Selector_Config) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Logging_RemoteServers_RemoteServer_Selectors_Selector_State represents the /openconfig-system/system/logging/remote-servers/remote-server/selectors/selector/state YANG schema element.
type OpenconfigSystem_System_Logging_RemoteServers_RemoteServer_Selectors_Selector_State struct {
	Facility	E_OpenconfigSystemLogging_SYSLOG_FACILITY	`path:"facility" module:"openconfig-system"`
	Severity	E_OpenconfigSystemLogging_SyslogSeverity	`path:"severity" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Logging_RemoteServers_RemoteServer_Selectors_Selector_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Logging_RemoteServers_RemoteServer_Selectors_Selector_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Logging_RemoteServers_RemoteServer_Selectors_Selector_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Logging_RemoteServers_RemoteServer_Selectors_Selector_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Logging_RemoteServers_RemoteServer_Selectors_Selector_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Logging_RemoteServers_RemoteServer_Selectors_Selector_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Logging_RemoteServers_RemoteServer_Selectors_Selector_State.
func (*OpenconfigSystem_System_Logging_RemoteServers_RemoteServer_Selectors_Selector_State) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Logging_RemoteServers_RemoteServer_State represents the /openconfig-system/system/logging/remote-servers/remote-server/state YANG schema element.
type OpenconfigSystem_System_Logging_RemoteServers_RemoteServer_State struct {
	Host	*string	`path:"host" module:"openconfig-system"`
	RemotePort	*uint16	`path:"remote-port" module:"openconfig-system"`
	SourceAddress	*string	`path:"source-address" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Logging_RemoteServers_RemoteServer_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Logging_RemoteServers_RemoteServer_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Logging_RemoteServers_RemoteServer_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Logging_RemoteServers_RemoteServer_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Logging_RemoteServers_RemoteServer_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Logging_RemoteServers_RemoteServer_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Logging_RemoteServers_RemoteServer_State.
func (*OpenconfigSystem_System_Logging_RemoteServers_RemoteServer_State) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Memory represents the /openconfig-system/system/memory YANG schema element.
type OpenconfigSystem_System_Memory struct {
	Config	*OpenconfigSystem_System_Memory_Config	`path:"config" module:"openconfig-system"`
	State	*OpenconfigSystem_System_Memory_State	`path:"state" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Memory implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Memory) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Memory) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Memory"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Memory) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Memory) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Memory.
func (*OpenconfigSystem_System_Memory) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Memory_Config represents the /openconfig-system/system/memory/config YANG schema element.
type OpenconfigSystem_System_Memory_Config struct {
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Memory_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Memory_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Memory_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Memory_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Memory_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Memory_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Memory_Config.
func (*OpenconfigSystem_System_Memory_Config) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Memory_State represents the /openconfig-system/system/memory/state YANG schema element.
type OpenconfigSystem_System_Memory_State struct {
	Counters	*OpenconfigSystem_System_Memory_State_Counters	`path:"counters" module:"openconfig-system"`
	Free	*uint64	`path:"free" module:"openconfig-system"`
	Physical	*uint64	`path:"physical" module:"openconfig-system"`
	Reserved	*uint64	`path:"reserved" module:"openconfig-system"`
	Used	*uint64	`path:"used" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Memory_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Memory_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Memory_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Memory_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Memory_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Memory_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Memory_State.
func (*OpenconfigSystem_System_Memory_State) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Memory_State_Counters represents the /openconfig-system/system/memory/state/counters YANG schema element.
type OpenconfigSystem_System_Memory_State_Counters struct {
	CorrectableEccErrors	*uint64	`path:"correctable-ecc-errors" module:"openconfig-system"`
	TotalEccErrors	*uint64	`path:"total-ecc-errors" module:"openconfig-system"`
	UncorrectableEccErrors	*uint64	`path:"uncorrectable-ecc-errors" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Memory_State_Counters implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Memory_State_Counters) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Memory_State_Counters) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Memory_State_Counters"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Memory_State_Counters) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Memory_State_Counters) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Memory_State_Counters.
func (*OpenconfigSystem_System_Memory_State_Counters) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Messages represents the /openconfig-system/system/messages YANG schema element.
type OpenconfigSystem_System_Messages struct {
	Config	*OpenconfigSystem_System_Messages_Config	`path:"config" module:"openconfig-system"`
	DebugEntries	*OpenconfigSystem_System_Messages_DebugEntries	`path:"debug-entries" module:"openconfig-system"`
	State	*OpenconfigSystem_System_Messages_State	`path:"state" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Messages implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Messages) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Messages) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Messages"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Messages) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Messages) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Messages.
func (*OpenconfigSystem_System_Messages) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Messages_Config represents the /openconfig-system/system/messages/config YANG schema element.
type OpenconfigSystem_System_Messages_Config struct {
	Severity	E_OpenconfigMessages_SyslogSeverity	`path:"severity" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Messages_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Messages_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Messages_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Messages_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Messages_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Messages_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Messages_Config.
func (*OpenconfigSystem_System_Messages_Config) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Messages_DebugEntries represents the /openconfig-system/system/messages/debug-entries YANG schema element.
type OpenconfigSystem_System_Messages_DebugEntries struct {
	DebugService	map[E_OpenconfigMessages_DEBUG_SERVICE]*OpenconfigSystem_System_Messages_DebugEntries_DebugService	`path:"debug-service" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Messages_DebugEntries implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Messages_DebugEntries) IsYANGGoStruct() {}

// NewDebugService creates a new entry in the DebugService list of the
// OpenconfigSystem_System_Messages_DebugEntries struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigSystem_System_Messages_DebugEntries) NewDebugService(Service E_OpenconfigMessages_DEBUG_SERVICE) (*OpenconfigSystem_System_Messages_DebugEntries_DebugService, error){

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.DebugService == nil {
		t.DebugService = make(map[E_OpenconfigMessages_DEBUG_SERVICE]*OpenconfigSystem_System_Messages_DebugEntries_DebugService)
	}

	key := Service

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.DebugService[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list DebugService", key)
	}

	t.DebugService[key] = &OpenconfigSystem_System_Messages_DebugEntries_DebugService{
		Service: Service,
	}

	return t.DebugService[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Messages_DebugEntries) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Messages_DebugEntries"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Messages_DebugEntries) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Messages_DebugEntries) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Messages_DebugEntries.
func (*OpenconfigSystem_System_Messages_DebugEntries) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Messages_DebugEntries_DebugService represents the /openconfig-system/system/messages/debug-entries/debug-service YANG schema element.
type OpenconfigSystem_System_Messages_DebugEntries_DebugService struct {
	Config	*OpenconfigSystem_System_Messages_DebugEntries_DebugService_Config	`path:"config" module:"openconfig-system"`
	Service	E_OpenconfigMessages_DEBUG_SERVICE	`path:"service" module:"openconfig-system"`
	State	*OpenconfigSystem_System_Messages_DebugEntries_DebugService_State	`path:"state" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Messages_DebugEntries_DebugService implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Messages_DebugEntries_DebugService) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigSystem_System_Messages_DebugEntries_DebugService struct, which is a YANG list entry.
func (t *OpenconfigSystem_System_Messages_DebugEntries_DebugService) ΛListKeyMap() (map[string]interface{}, error) {

	return map[string]interface{}{
		"service": t.Service,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Messages_DebugEntries_DebugService) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Messages_DebugEntries_DebugService"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Messages_DebugEntries_DebugService) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Messages_DebugEntries_DebugService) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Messages_DebugEntries_DebugService.
func (*OpenconfigSystem_System_Messages_DebugEntries_DebugService) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Messages_DebugEntries_DebugService_Config represents the /openconfig-system/system/messages/debug-entries/debug-service/config YANG schema element.
type OpenconfigSystem_System_Messages_DebugEntries_DebugService_Config struct {
	Enabled	*bool	`path:"enabled" module:"openconfig-system"`
	Service	E_OpenconfigMessages_DEBUG_SERVICE	`path:"service" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Messages_DebugEntries_DebugService_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Messages_DebugEntries_DebugService_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Messages_DebugEntries_DebugService_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Messages_DebugEntries_DebugService_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Messages_DebugEntries_DebugService_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Messages_DebugEntries_DebugService_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Messages_DebugEntries_DebugService_Config.
func (*OpenconfigSystem_System_Messages_DebugEntries_DebugService_Config) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Messages_DebugEntries_DebugService_State represents the /openconfig-system/system/messages/debug-entries/debug-service/state YANG schema element.
type OpenconfigSystem_System_Messages_DebugEntries_DebugService_State struct {
	Enabled	*bool	`path:"enabled" module:"openconfig-system"`
	Service	E_OpenconfigMessages_DEBUG_SERVICE	`path:"service" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Messages_DebugEntries_DebugService_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Messages_DebugEntries_DebugService_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Messages_DebugEntries_DebugService_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Messages_DebugEntries_DebugService_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Messages_DebugEntries_DebugService_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Messages_DebugEntries_DebugService_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Messages_DebugEntries_DebugService_State.
func (*OpenconfigSystem_System_Messages_DebugEntries_DebugService_State) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Messages_State represents the /openconfig-system/system/messages/state YANG schema element.
type OpenconfigSystem_System_Messages_State struct {
	Message	*OpenconfigSystem_System_Messages_State_Message	`path:"message" module:"openconfig-system"`
	Severity	E_OpenconfigMessages_SyslogSeverity	`path:"severity" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Messages_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Messages_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Messages_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Messages_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Messages_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Messages_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Messages_State.
func (*OpenconfigSystem_System_Messages_State) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Messages_State_Message represents the /openconfig-system/system/messages/state/message YANG schema element.
type OpenconfigSystem_System_Messages_State_Message struct {
	AppName	*string	`path:"app-name" module:"openconfig-system"`
	Msg	*string	`path:"msg" module:"openconfig-system"`
	Msgid	*string	`path:"msgid" module:"openconfig-system"`
	Priority	*uint8	`path:"priority" module:"openconfig-system"`
	Procid	*string	`path:"procid" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Messages_State_Message implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Messages_State_Message) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Messages_State_Message) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Messages_State_Message"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Messages_State_Message) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Messages_State_Message) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Messages_State_Message.
func (*OpenconfigSystem_System_Messages_State_Message) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_MountPoints represents the /openconfig-system/system/mount-points YANG schema element.
type OpenconfigSystem_System_MountPoints struct {
	MountPoint	map[string]*OpenconfigSystem_System_MountPoints_MountPoint	`path:"mount-point" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_MountPoints implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_MountPoints) IsYANGGoStruct() {}

// NewMountPoint creates a new entry in the MountPoint list of the
// OpenconfigSystem_System_MountPoints struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigSystem_System_MountPoints) NewMountPoint(Name string) (*OpenconfigSystem_System_MountPoints_MountPoint, error){

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.MountPoint == nil {
		t.MountPoint = make(map[string]*OpenconfigSystem_System_MountPoints_MountPoint)
	}

	key := Name

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.MountPoint[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list MountPoint", key)
	}

	t.MountPoint[key] = &OpenconfigSystem_System_MountPoints_MountPoint{
		Name: &Name,
	}

	return t.MountPoint[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_MountPoints) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_MountPoints"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_MountPoints) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_MountPoints) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_MountPoints.
func (*OpenconfigSystem_System_MountPoints) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_MountPoints_MountPoint represents the /openconfig-system/system/mount-points/mount-point YANG schema element.
type OpenconfigSystem_System_MountPoints_MountPoint struct {
	Name	*string	`path:"name" module:"openconfig-system"`
	State	*OpenconfigSystem_System_MountPoints_MountPoint_State	`path:"state" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_MountPoints_MountPoint implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_MountPoints_MountPoint) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigSystem_System_MountPoints_MountPoint struct, which is a YANG list entry.
func (t *OpenconfigSystem_System_MountPoints_MountPoint) ΛListKeyMap() (map[string]interface{}, error) {
	if t.Name == nil {
		return nil, fmt.Errorf("nil value for key Name")
	}

	return map[string]interface{}{
		"name": *t.Name,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_MountPoints_MountPoint) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_MountPoints_MountPoint"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_MountPoints_MountPoint) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_MountPoints_MountPoint) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_MountPoints_MountPoint.
func (*OpenconfigSystem_System_MountPoints_MountPoint) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_MountPoints_MountPoint_State represents the /openconfig-system/system/mount-points/mount-point/state YANG schema element.
type OpenconfigSystem_System_MountPoints_MountPoint_State struct {
	Available	*uint64	`path:"available" module:"openconfig-system"`
	Name	*string	`path:"name" module:"openconfig-system"`
	Size	*uint64	`path:"size" module:"openconfig-system"`
	StorageComponent	*string	`path:"storage-component" module:"openconfig-system"`
	Utilized	*uint64	`path:"utilized" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_MountPoints_MountPoint_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_MountPoints_MountPoint_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_MountPoints_MountPoint_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_MountPoints_MountPoint_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_MountPoints_MountPoint_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_MountPoints_MountPoint_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_MountPoints_MountPoint_State.
func (*OpenconfigSystem_System_MountPoints_MountPoint_State) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Ntp represents the /openconfig-system/system/ntp YANG schema element.
type OpenconfigSystem_System_Ntp struct {
	Config	*OpenconfigSystem_System_Ntp_Config	`path:"config" module:"openconfig-system"`
	NtpKeys	*OpenconfigSystem_System_Ntp_NtpKeys	`path:"ntp-keys" module:"openconfig-system"`
	Servers	*OpenconfigSystem_System_Ntp_Servers	`path:"servers" module:"openconfig-system"`
	State	*OpenconfigSystem_System_Ntp_State	`path:"state" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Ntp implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Ntp) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Ntp) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Ntp"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Ntp) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Ntp) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Ntp.
func (*OpenconfigSystem_System_Ntp) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Ntp_Config represents the /openconfig-system/system/ntp/config YANG schema element.
type OpenconfigSystem_System_Ntp_Config struct {
	EnableNtpAuth	*bool	`path:"enable-ntp-auth" module:"openconfig-system"`
	Enabled	*bool	`path:"enabled" module:"openconfig-system"`
	NtpSourceAddress	*string	`path:"ntp-source-address" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Ntp_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Ntp_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Ntp_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Ntp_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Ntp_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Ntp_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Ntp_Config.
func (*OpenconfigSystem_System_Ntp_Config) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Ntp_NtpKeys represents the /openconfig-system/system/ntp/ntp-keys YANG schema element.
type OpenconfigSystem_System_Ntp_NtpKeys struct {
	NtpKey	map[uint16]*OpenconfigSystem_System_Ntp_NtpKeys_NtpKey	`path:"ntp-key" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Ntp_NtpKeys implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Ntp_NtpKeys) IsYANGGoStruct() {}

// NewNtpKey creates a new entry in the NtpKey list of the
// OpenconfigSystem_System_Ntp_NtpKeys struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigSystem_System_Ntp_NtpKeys) NewNtpKey(KeyId uint16) (*OpenconfigSystem_System_Ntp_NtpKeys_NtpKey, error){

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.NtpKey == nil {
		t.NtpKey = make(map[uint16]*OpenconfigSystem_System_Ntp_NtpKeys_NtpKey)
	}

	key := KeyId

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.NtpKey[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list NtpKey", key)
	}

	t.NtpKey[key] = &OpenconfigSystem_System_Ntp_NtpKeys_NtpKey{
		KeyId: &KeyId,
	}

	return t.NtpKey[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Ntp_NtpKeys) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Ntp_NtpKeys"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Ntp_NtpKeys) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Ntp_NtpKeys) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Ntp_NtpKeys.
func (*OpenconfigSystem_System_Ntp_NtpKeys) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Ntp_NtpKeys_NtpKey represents the /openconfig-system/system/ntp/ntp-keys/ntp-key YANG schema element.
type OpenconfigSystem_System_Ntp_NtpKeys_NtpKey struct {
	Config	*OpenconfigSystem_System_Ntp_NtpKeys_NtpKey_Config	`path:"config" module:"openconfig-system"`
	KeyId	*uint16	`path:"key-id" module:"openconfig-system"`
	State	*OpenconfigSystem_System_Ntp_NtpKeys_NtpKey_State	`path:"state" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Ntp_NtpKeys_NtpKey implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Ntp_NtpKeys_NtpKey) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigSystem_System_Ntp_NtpKeys_NtpKey struct, which is a YANG list entry.
func (t *OpenconfigSystem_System_Ntp_NtpKeys_NtpKey) ΛListKeyMap() (map[string]interface{}, error) {
	if t.KeyId == nil {
		return nil, fmt.Errorf("nil value for key KeyId")
	}

	return map[string]interface{}{
		"key-id": *t.KeyId,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Ntp_NtpKeys_NtpKey) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Ntp_NtpKeys_NtpKey"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Ntp_NtpKeys_NtpKey) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Ntp_NtpKeys_NtpKey) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Ntp_NtpKeys_NtpKey.
func (*OpenconfigSystem_System_Ntp_NtpKeys_NtpKey) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Ntp_NtpKeys_NtpKey_Config represents the /openconfig-system/system/ntp/ntp-keys/ntp-key/config YANG schema element.
type OpenconfigSystem_System_Ntp_NtpKeys_NtpKey_Config struct {
	KeyId	*uint16	`path:"key-id" module:"openconfig-system"`
	KeyType	E_OpenconfigSystem_NTP_AUTH_TYPE	`path:"key-type" module:"openconfig-system"`
	KeyValue	*string	`path:"key-value" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Ntp_NtpKeys_NtpKey_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Ntp_NtpKeys_NtpKey_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Ntp_NtpKeys_NtpKey_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Ntp_NtpKeys_NtpKey_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Ntp_NtpKeys_NtpKey_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Ntp_NtpKeys_NtpKey_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Ntp_NtpKeys_NtpKey_Config.
func (*OpenconfigSystem_System_Ntp_NtpKeys_NtpKey_Config) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Ntp_NtpKeys_NtpKey_State represents the /openconfig-system/system/ntp/ntp-keys/ntp-key/state YANG schema element.
type OpenconfigSystem_System_Ntp_NtpKeys_NtpKey_State struct {
	KeyId	*uint16	`path:"key-id" module:"openconfig-system"`
	KeyType	E_OpenconfigSystem_NTP_AUTH_TYPE	`path:"key-type" module:"openconfig-system"`
	KeyValue	*string	`path:"key-value" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Ntp_NtpKeys_NtpKey_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Ntp_NtpKeys_NtpKey_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Ntp_NtpKeys_NtpKey_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Ntp_NtpKeys_NtpKey_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Ntp_NtpKeys_NtpKey_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Ntp_NtpKeys_NtpKey_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Ntp_NtpKeys_NtpKey_State.
func (*OpenconfigSystem_System_Ntp_NtpKeys_NtpKey_State) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Ntp_Servers represents the /openconfig-system/system/ntp/servers YANG schema element.
type OpenconfigSystem_System_Ntp_Servers struct {
	Server	map[string]*OpenconfigSystem_System_Ntp_Servers_Server	`path:"server" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Ntp_Servers implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Ntp_Servers) IsYANGGoStruct() {}

// NewServer creates a new entry in the Server list of the
// OpenconfigSystem_System_Ntp_Servers struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigSystem_System_Ntp_Servers) NewServer(Address string) (*OpenconfigSystem_System_Ntp_Servers_Server, error){

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.Server == nil {
		t.Server = make(map[string]*OpenconfigSystem_System_Ntp_Servers_Server)
	}

	key := Address

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.Server[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list Server", key)
	}

	t.Server[key] = &OpenconfigSystem_System_Ntp_Servers_Server{
		Address: &Address,
	}

	return t.Server[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Ntp_Servers) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Ntp_Servers"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Ntp_Servers) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Ntp_Servers) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Ntp_Servers.
func (*OpenconfigSystem_System_Ntp_Servers) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Ntp_Servers_Server represents the /openconfig-system/system/ntp/servers/server YANG schema element.
type OpenconfigSystem_System_Ntp_Servers_Server struct {
	Address	*string	`path:"address" module:"openconfig-system"`
	Config	*OpenconfigSystem_System_Ntp_Servers_Server_Config	`path:"config" module:"openconfig-system"`
	State	*OpenconfigSystem_System_Ntp_Servers_Server_State	`path:"state" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Ntp_Servers_Server implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Ntp_Servers_Server) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigSystem_System_Ntp_Servers_Server struct, which is a YANG list entry.
func (t *OpenconfigSystem_System_Ntp_Servers_Server) ΛListKeyMap() (map[string]interface{}, error) {
	if t.Address == nil {
		return nil, fmt.Errorf("nil value for key Address")
	}

	return map[string]interface{}{
		"address": *t.Address,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Ntp_Servers_Server) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Ntp_Servers_Server"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Ntp_Servers_Server) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Ntp_Servers_Server) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Ntp_Servers_Server.
func (*OpenconfigSystem_System_Ntp_Servers_Server) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Ntp_Servers_Server_Config represents the /openconfig-system/system/ntp/servers/server/config YANG schema element.
type OpenconfigSystem_System_Ntp_Servers_Server_Config struct {
	Address	*string	`path:"address" module:"openconfig-system"`
	AssociationType	E_OpenconfigSystem_System_Ntp_Servers_Server_Config_AssociationType	`path:"association-type" module:"openconfig-system"`
	Iburst	*bool	`path:"iburst" module:"openconfig-system"`
	Port	*uint16	`path:"port" module:"openconfig-system"`
	Prefer	*bool	`path:"prefer" module:"openconfig-system"`
	Version	*uint8	`path:"version" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Ntp_Servers_Server_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Ntp_Servers_Server_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Ntp_Servers_Server_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Ntp_Servers_Server_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Ntp_Servers_Server_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Ntp_Servers_Server_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Ntp_Servers_Server_Config.
func (*OpenconfigSystem_System_Ntp_Servers_Server_Config) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Ntp_Servers_Server_State represents the /openconfig-system/system/ntp/servers/server/state YANG schema element.
type OpenconfigSystem_System_Ntp_Servers_Server_State struct {
	Address	*string	`path:"address" module:"openconfig-system"`
	AssociationType	E_OpenconfigSystem_System_Ntp_Servers_Server_Config_AssociationType	`path:"association-type" module:"openconfig-system"`
	Iburst	*bool	`path:"iburst" module:"openconfig-system"`
	Offset	*uint64	`path:"offset" module:"openconfig-system"`
	PollInterval	*uint32	`path:"poll-interval" module:"openconfig-system"`
	Port	*uint16	`path:"port" module:"openconfig-system"`
	Prefer	*bool	`path:"prefer" module:"openconfig-system"`
	RootDelay	*uint32	`path:"root-delay" module:"openconfig-system"`
	RootDispersion	*uint64	`path:"root-dispersion" module:"openconfig-system"`
	Stratum	*uint8	`path:"stratum" module:"openconfig-system"`
	Version	*uint8	`path:"version" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Ntp_Servers_Server_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Ntp_Servers_Server_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Ntp_Servers_Server_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Ntp_Servers_Server_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Ntp_Servers_Server_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Ntp_Servers_Server_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Ntp_Servers_Server_State.
func (*OpenconfigSystem_System_Ntp_Servers_Server_State) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Ntp_State represents the /openconfig-system/system/ntp/state YANG schema element.
type OpenconfigSystem_System_Ntp_State struct {
	AuthMismatch	*uint64	`path:"auth-mismatch" module:"openconfig-system"`
	EnableNtpAuth	*bool	`path:"enable-ntp-auth" module:"openconfig-system"`
	Enabled	*bool	`path:"enabled" module:"openconfig-system"`
	NtpSourceAddress	*string	`path:"ntp-source-address" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Ntp_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Ntp_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Ntp_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Ntp_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Ntp_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Ntp_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Ntp_State.
func (*OpenconfigSystem_System_Ntp_State) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Openflow represents the /openconfig-system/system/openflow YANG schema element.
type OpenconfigSystem_System_Openflow struct {
	Agent	*OpenconfigSystem_System_Openflow_Agent	`path:"agent" module:"openconfig-openflow"`
	Controllers	*OpenconfigSystem_System_Openflow_Controllers	`path:"controllers" module:"openconfig-openflow"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Openflow implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Openflow) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Openflow) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Openflow"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Openflow) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Openflow) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Openflow.
func (*OpenconfigSystem_System_Openflow) ΛBelongingModule() string {
	return "openconfig-openflow"
}


// OpenconfigSystem_System_Openflow_Agent represents the /openconfig-system/system/openflow/agent YANG schema element.
type OpenconfigSystem_System_Openflow_Agent struct {
	Config	*OpenconfigSystem_System_Openflow_Agent_Config	`path:"config" module:"openconfig-openflow"`
	State	*OpenconfigSystem_System_Openflow_Agent_State	`path:"state" module:"openconfig-openflow"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Openflow_Agent implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Openflow_Agent) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Openflow_Agent) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Openflow_Agent"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Openflow_Agent) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Openflow_Agent) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Openflow_Agent.
func (*OpenconfigSystem_System_Openflow_Agent) ΛBelongingModule() string {
	return "openconfig-openflow"
}


// OpenconfigSystem_System_Openflow_Agent_Config represents the /openconfig-system/system/openflow/agent/config YANG schema element.
type OpenconfigSystem_System_Openflow_Agent_Config struct {
	BackoffInterval	*uint32	`path:"backoff-interval" module:"openconfig-openflow"`
	DatapathId	*string	`path:"datapath-id" module:"openconfig-openflow"`
	FailureMode	E_OpenconfigOpenflow_FailureMode	`path:"failure-mode" module:"openconfig-openflow"`
	InactivityProbe	*uint32	`path:"inactivity-probe" module:"openconfig-openflow"`
	MaxBackoff	*uint32	`path:"max-backoff" module:"openconfig-openflow"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Openflow_Agent_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Openflow_Agent_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Openflow_Agent_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Openflow_Agent_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Openflow_Agent_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Openflow_Agent_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Openflow_Agent_Config.
func (*OpenconfigSystem_System_Openflow_Agent_Config) ΛBelongingModule() string {
	return "openconfig-openflow"
}


// OpenconfigSystem_System_Openflow_Agent_State represents the /openconfig-system/system/openflow/agent/state YANG schema element.
type OpenconfigSystem_System_Openflow_Agent_State struct {
	BackoffInterval	*uint32	`path:"backoff-interval" module:"openconfig-openflow"`
	DatapathId	*string	`path:"datapath-id" module:"openconfig-openflow"`
	FailureMode	E_OpenconfigOpenflow_FailureMode	`path:"failure-mode" module:"openconfig-openflow"`
	InactivityProbe	*uint32	`path:"inactivity-probe" module:"openconfig-openflow"`
	MaxBackoff	*uint32	`path:"max-backoff" module:"openconfig-openflow"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Openflow_Agent_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Openflow_Agent_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Openflow_Agent_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Openflow_Agent_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Openflow_Agent_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Openflow_Agent_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Openflow_Agent_State.
func (*OpenconfigSystem_System_Openflow_Agent_State) ΛBelongingModule() string {
	return "openconfig-openflow"
}


// OpenconfigSystem_System_Openflow_Controllers represents the /openconfig-system/system/openflow/controllers YANG schema element.
type OpenconfigSystem_System_Openflow_Controllers struct {
	Controller	map[string]*OpenconfigSystem_System_Openflow_Controllers_Controller	`path:"controller" module:"openconfig-openflow"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Openflow_Controllers implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Openflow_Controllers) IsYANGGoStruct() {}

// NewController creates a new entry in the Controller list of the
// OpenconfigSystem_System_Openflow_Controllers struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigSystem_System_Openflow_Controllers) NewController(Name string) (*OpenconfigSystem_System_Openflow_Controllers_Controller, error){

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.Controller == nil {
		t.Controller = make(map[string]*OpenconfigSystem_System_Openflow_Controllers_Controller)
	}

	key := Name

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.Controller[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list Controller", key)
	}

	t.Controller[key] = &OpenconfigSystem_System_Openflow_Controllers_Controller{
		Name: &Name,
	}

	return t.Controller[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Openflow_Controllers) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Openflow_Controllers"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Openflow_Controllers) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Openflow_Controllers) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Openflow_Controllers.
func (*OpenconfigSystem_System_Openflow_Controllers) ΛBelongingModule() string {
	return "openconfig-openflow"
}


// OpenconfigSystem_System_Openflow_Controllers_Controller represents the /openconfig-system/system/openflow/controllers/controller YANG schema element.
type OpenconfigSystem_System_Openflow_Controllers_Controller struct {
	Config	*OpenconfigSystem_System_Openflow_Controllers_Controller_Config	`path:"config" module:"openconfig-openflow"`
	Connections	*OpenconfigSystem_System_Openflow_Controllers_Controller_Connections	`path:"connections" module:"openconfig-openflow"`
	Name	*string	`path:"name" module:"openconfig-openflow"`
	State	*OpenconfigSystem_System_Openflow_Controllers_Controller_State	`path:"state" module:"openconfig-openflow"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Openflow_Controllers_Controller implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Openflow_Controllers_Controller) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigSystem_System_Openflow_Controllers_Controller struct, which is a YANG list entry.
func (t *OpenconfigSystem_System_Openflow_Controllers_Controller) ΛListKeyMap() (map[string]interface{}, error) {
	if t.Name == nil {
		return nil, fmt.Errorf("nil value for key Name")
	}

	return map[string]interface{}{
		"name": *t.Name,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Openflow_Controllers_Controller) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Openflow_Controllers_Controller"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Openflow_Controllers_Controller) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Openflow_Controllers_Controller) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Openflow_Controllers_Controller.
func (*OpenconfigSystem_System_Openflow_Controllers_Controller) ΛBelongingModule() string {
	return "openconfig-openflow"
}


// OpenconfigSystem_System_Openflow_Controllers_Controller_Config represents the /openconfig-system/system/openflow/controllers/controller/config YANG schema element.
type OpenconfigSystem_System_Openflow_Controllers_Controller_Config struct {
	Name	*string	`path:"name" module:"openconfig-openflow"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Openflow_Controllers_Controller_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Openflow_Controllers_Controller_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Openflow_Controllers_Controller_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Openflow_Controllers_Controller_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Openflow_Controllers_Controller_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Openflow_Controllers_Controller_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Openflow_Controllers_Controller_Config.
func (*OpenconfigSystem_System_Openflow_Controllers_Controller_Config) ΛBelongingModule() string {
	return "openconfig-openflow"
}


// OpenconfigSystem_System_Openflow_Controllers_Controller_Connections represents the /openconfig-system/system/openflow/controllers/controller/connections YANG schema element.
type OpenconfigSystem_System_Openflow_Controllers_Controller_Connections struct {
	Connection	map[uint8]*OpenconfigSystem_System_Openflow_Controllers_Controller_Connections_Connection	`path:"connection" module:"openconfig-openflow"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Openflow_Controllers_Controller_Connections implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Openflow_Controllers_Controller_Connections) IsYANGGoStruct() {}

// NewConnection creates a new entry in the Connection list of the
// OpenconfigSystem_System_Openflow_Controllers_Controller_Connections struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigSystem_System_Openflow_Controllers_Controller_Connections) NewConnection(AuxId uint8) (*OpenconfigSystem_System_Openflow_Controllers_Controller_Connections_Connection, error){

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.Connection == nil {
		t.Connection = make(map[uint8]*OpenconfigSystem_System_Openflow_Controllers_Controller_Connections_Connection)
	}

	key := AuxId

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.Connection[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list Connection", key)
	}

	t.Connection[key] = &OpenconfigSystem_System_Openflow_Controllers_Controller_Connections_Connection{
		AuxId: &AuxId,
	}

	return t.Connection[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Openflow_Controllers_Controller_Connections) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Openflow_Controllers_Controller_Connections"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Openflow_Controllers_Controller_Connections) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Openflow_Controllers_Controller_Connections) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Openflow_Controllers_Controller_Connections.
func (*OpenconfigSystem_System_Openflow_Controllers_Controller_Connections) ΛBelongingModule() string {
	return "openconfig-openflow"
}


// OpenconfigSystem_System_Openflow_Controllers_Controller_Connections_Connection represents the /openconfig-system/system/openflow/controllers/controller/connections/connection YANG schema element.
type OpenconfigSystem_System_Openflow_Controllers_Controller_Connections_Connection struct {
	AuxId	*uint8	`path:"aux-id" module:"openconfig-openflow"`
	Config	*OpenconfigSystem_System_Openflow_Controllers_Controller_Connections_Connection_Config	`path:"config" module:"openconfig-openflow"`
	State	*OpenconfigSystem_System_Openflow_Controllers_Controller_Connections_Connection_State	`path:"state" module:"openconfig-openflow"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Openflow_Controllers_Controller_Connections_Connection implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Openflow_Controllers_Controller_Connections_Connection) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigSystem_System_Openflow_Controllers_Controller_Connections_Connection struct, which is a YANG list entry.
func (t *OpenconfigSystem_System_Openflow_Controllers_Controller_Connections_Connection) ΛListKeyMap() (map[string]interface{}, error) {
	if t.AuxId == nil {
		return nil, fmt.Errorf("nil value for key AuxId")
	}

	return map[string]interface{}{
		"aux-id": *t.AuxId,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Openflow_Controllers_Controller_Connections_Connection) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Openflow_Controllers_Controller_Connections_Connection"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Openflow_Controllers_Controller_Connections_Connection) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Openflow_Controllers_Controller_Connections_Connection) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Openflow_Controllers_Controller_Connections_Connection.
func (*OpenconfigSystem_System_Openflow_Controllers_Controller_Connections_Connection) ΛBelongingModule() string {
	return "openconfig-openflow"
}


// OpenconfigSystem_System_Openflow_Controllers_Controller_Connections_Connection_Config represents the /openconfig-system/system/openflow/controllers/controller/connections/connection/config YANG schema element.
type OpenconfigSystem_System_Openflow_Controllers_Controller_Connections_Connection_Config struct {
	Address	*string	`path:"address" module:"openconfig-openflow"`
	AuxId	*uint8	`path:"aux-id" module:"openconfig-openflow"`
	CertificateId	*string	`path:"certificate-id" module:"openconfig-openflow"`
	Port	*uint16	`path:"port" module:"openconfig-openflow"`
	Priority	*uint8	`path:"priority" module:"openconfig-openflow"`
	SourceInterface	*string	`path:"source-interface" module:"openconfig-openflow"`
	Transport	E_OpenconfigOpenflow_Transport	`path:"transport" module:"openconfig-openflow"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Openflow_Controllers_Controller_Connections_Connection_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Openflow_Controllers_Controller_Connections_Connection_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Openflow_Controllers_Controller_Connections_Connection_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Openflow_Controllers_Controller_Connections_Connection_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Openflow_Controllers_Controller_Connections_Connection_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Openflow_Controllers_Controller_Connections_Connection_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Openflow_Controllers_Controller_Connections_Connection_Config.
func (*OpenconfigSystem_System_Openflow_Controllers_Controller_Connections_Connection_Config) ΛBelongingModule() string {
	return "openconfig-openflow"
}


// OpenconfigSystem_System_Openflow_Controllers_Controller_Connections_Connection_State represents the /openconfig-system/system/openflow/controllers/controller/connections/connection/state YANG schema element.
type OpenconfigSystem_System_Openflow_Controllers_Controller_Connections_Connection_State struct {
	Address	*string	`path:"address" module:"openconfig-openflow"`
	AuxId	*uint8	`path:"aux-id" module:"openconfig-openflow"`
	CertificateId	*string	`path:"certificate-id" module:"openconfig-openflow"`
	Connected	*bool	`path:"connected" module:"openconfig-openflow"`
	Port	*uint16	`path:"port" module:"openconfig-openflow"`
	Priority	*uint8	`path:"priority" module:"openconfig-openflow"`
	SourceInterface	*string	`path:"source-interface" module:"openconfig-openflow"`
	Transport	E_OpenconfigOpenflow_Transport	`path:"transport" module:"openconfig-openflow"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Openflow_Controllers_Controller_Connections_Connection_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Openflow_Controllers_Controller_Connections_Connection_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Openflow_Controllers_Controller_Connections_Connection_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Openflow_Controllers_Controller_Connections_Connection_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Openflow_Controllers_Controller_Connections_Connection_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Openflow_Controllers_Controller_Connections_Connection_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Openflow_Controllers_Controller_Connections_Connection_State.
func (*OpenconfigSystem_System_Openflow_Controllers_Controller_Connections_Connection_State) ΛBelongingModule() string {
	return "openconfig-openflow"
}


// OpenconfigSystem_System_Openflow_Controllers_Controller_State represents the /openconfig-system/system/openflow/controllers/controller/state YANG schema element.
type OpenconfigSystem_System_Openflow_Controllers_Controller_State struct {
	Name	*string	`path:"name" module:"openconfig-openflow"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Openflow_Controllers_Controller_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Openflow_Controllers_Controller_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Openflow_Controllers_Controller_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Openflow_Controllers_Controller_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Openflow_Controllers_Controller_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Openflow_Controllers_Controller_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Openflow_Controllers_Controller_State.
func (*OpenconfigSystem_System_Openflow_Controllers_Controller_State) ΛBelongingModule() string {
	return "openconfig-openflow"
}


// OpenconfigSystem_System_Processes represents the /openconfig-system/system/processes YANG schema element.
type OpenconfigSystem_System_Processes struct {
	Process	map[uint64]*OpenconfigSystem_System_Processes_Process	`path:"process" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Processes implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Processes) IsYANGGoStruct() {}

// NewProcess creates a new entry in the Process list of the
// OpenconfigSystem_System_Processes struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigSystem_System_Processes) NewProcess(Pid uint64) (*OpenconfigSystem_System_Processes_Process, error){

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.Process == nil {
		t.Process = make(map[uint64]*OpenconfigSystem_System_Processes_Process)
	}

	key := Pid

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.Process[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list Process", key)
	}

	t.Process[key] = &OpenconfigSystem_System_Processes_Process{
		Pid: &Pid,
	}

	return t.Process[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Processes) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Processes"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Processes) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Processes) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Processes.
func (*OpenconfigSystem_System_Processes) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Processes_Process represents the /openconfig-system/system/processes/process YANG schema element.
type OpenconfigSystem_System_Processes_Process struct {
	Pid	*uint64	`path:"pid" module:"openconfig-system"`
	State	*OpenconfigSystem_System_Processes_Process_State	`path:"state" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Processes_Process implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Processes_Process) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigSystem_System_Processes_Process struct, which is a YANG list entry.
func (t *OpenconfigSystem_System_Processes_Process) ΛListKeyMap() (map[string]interface{}, error) {
	if t.Pid == nil {
		return nil, fmt.Errorf("nil value for key Pid")
	}

	return map[string]interface{}{
		"pid": *t.Pid,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Processes_Process) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Processes_Process"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Processes_Process) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Processes_Process) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Processes_Process.
func (*OpenconfigSystem_System_Processes_Process) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Processes_Process_State represents the /openconfig-system/system/processes/process/state YANG schema element.
type OpenconfigSystem_System_Processes_Process_State struct {
	Args	[]string	`path:"args" module:"openconfig-system"`
	CpuUsageSystem	*uint64	`path:"cpu-usage-system" module:"openconfig-system"`
	CpuUsageUser	*uint64	`path:"cpu-usage-user" module:"openconfig-system"`
	CpuUtilization	*uint8	`path:"cpu-utilization" module:"openconfig-system"`
	MemoryUsage	*uint64	`path:"memory-usage" module:"openconfig-system"`
	MemoryUtilization	*uint8	`path:"memory-utilization" module:"openconfig-system"`
	Name	*string	`path:"name" module:"openconfig-system"`
	Pid	*uint64	`path:"pid" module:"openconfig-system"`
	StartTime	*uint64	`path:"start-time" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Processes_Process_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Processes_Process_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Processes_Process_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Processes_Process_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Processes_Process_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Processes_Process_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Processes_Process_State.
func (*OpenconfigSystem_System_Processes_Process_State) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_SshServer represents the /openconfig-system/system/ssh-server YANG schema element.
type OpenconfigSystem_System_SshServer struct {
	Config	*OpenconfigSystem_System_SshServer_Config	`path:"config" module:"openconfig-system"`
	State	*OpenconfigSystem_System_SshServer_State	`path:"state" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_SshServer implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_SshServer) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_SshServer) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_SshServer"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_SshServer) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_SshServer) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_SshServer.
func (*OpenconfigSystem_System_SshServer) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_SshServer_Config represents the /openconfig-system/system/ssh-server/config YANG schema element.
type OpenconfigSystem_System_SshServer_Config struct {
	Enable	*bool	`path:"enable" module:"openconfig-system"`
	ProtocolVersion	E_OpenconfigSystem_System_SshServer_Config_ProtocolVersion	`path:"protocol-version" module:"openconfig-system"`
	RateLimit	*uint16	`path:"rate-limit" module:"openconfig-system"`
	SessionLimit	*uint16	`path:"session-limit" module:"openconfig-system"`
	Timeout	*uint16	`path:"timeout" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_SshServer_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_SshServer_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_SshServer_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_SshServer_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_SshServer_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_SshServer_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_SshServer_Config.
func (*OpenconfigSystem_System_SshServer_Config) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_SshServer_State represents the /openconfig-system/system/ssh-server/state YANG schema element.
type OpenconfigSystem_System_SshServer_State struct {
	Enable	*bool	`path:"enable" module:"openconfig-system"`
	ProtocolVersion	E_OpenconfigSystem_System_SshServer_Config_ProtocolVersion	`path:"protocol-version" module:"openconfig-system"`
	RateLimit	*uint16	`path:"rate-limit" module:"openconfig-system"`
	SessionLimit	*uint16	`path:"session-limit" module:"openconfig-system"`
	Timeout	*uint16	`path:"timeout" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_SshServer_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_SshServer_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_SshServer_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_SshServer_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_SshServer_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_SshServer_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_SshServer_State.
func (*OpenconfigSystem_System_SshServer_State) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_State represents the /openconfig-system/system/state YANG schema element.
type OpenconfigSystem_System_State struct {
	BootTime	*uint64	`path:"boot-time" module:"openconfig-system"`
	CurrentDatetime	*string	`path:"current-datetime" module:"openconfig-system"`
	DomainName	*string	`path:"domain-name" module:"openconfig-system"`
	Hostname	*string	`path:"hostname" module:"openconfig-system"`
	LoginBanner	*string	`path:"login-banner" module:"openconfig-system"`
	MotdBanner	*string	`path:"motd-banner" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_State.
func (*OpenconfigSystem_System_State) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_TelnetServer represents the /openconfig-system/system/telnet-server YANG schema element.
type OpenconfigSystem_System_TelnetServer struct {
	Config	*OpenconfigSystem_System_TelnetServer_Config	`path:"config" module:"openconfig-system"`
	State	*OpenconfigSystem_System_TelnetServer_State	`path:"state" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_TelnetServer implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_TelnetServer) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_TelnetServer) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_TelnetServer"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_TelnetServer) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_TelnetServer) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_TelnetServer.
func (*OpenconfigSystem_System_TelnetServer) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_TelnetServer_Config represents the /openconfig-system/system/telnet-server/config YANG schema element.
type OpenconfigSystem_System_TelnetServer_Config struct {
	Enable	*bool	`path:"enable" module:"openconfig-system"`
	RateLimit	*uint16	`path:"rate-limit" module:"openconfig-system"`
	SessionLimit	*uint16	`path:"session-limit" module:"openconfig-system"`
	Timeout	*uint16	`path:"timeout" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_TelnetServer_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_TelnetServer_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_TelnetServer_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_TelnetServer_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_TelnetServer_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_TelnetServer_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_TelnetServer_Config.
func (*OpenconfigSystem_System_TelnetServer_Config) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_TelnetServer_State represents the /openconfig-system/system/telnet-server/state YANG schema element.
type OpenconfigSystem_System_TelnetServer_State struct {
	Enable	*bool	`path:"enable" module:"openconfig-system"`
	RateLimit	*uint16	`path:"rate-limit" module:"openconfig-system"`
	SessionLimit	*uint16	`path:"session-limit" module:"openconfig-system"`
	Timeout	*uint16	`path:"timeout" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_TelnetServer_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_TelnetServer_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_TelnetServer_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_TelnetServer_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_TelnetServer_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_TelnetServer_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_TelnetServer_State.
func (*OpenconfigSystem_System_TelnetServer_State) ΛBelongingModule() string {
	return "openconfig-system"
}


// E_IETFInterfaces_InterfaceType is a derived int64 type which is used to represent
// the enumerated node IETFInterfaces_InterfaceType. An additional value named
// IETFInterfaces_InterfaceType_UNSET is added to the enumeration which is used as
// the nil value, indicating that the enumeration was not explicitly set by
// the program importing the generated structures.
type E_IETFInterfaces_InterfaceType int64

// IsYANGGoEnum ensures that IETFInterfaces_InterfaceType implements the yang.GoEnum
// interface. This ensures that IETFInterfaces_InterfaceType can be identified as a
// mapped type for a YANG enumeration.
func (E_IETFInterfaces_InterfaceType) IsYANGGoEnum() {}

// ΛMap returns the value lookup map associated with  IETFInterfaces_InterfaceType.
func (E_IETFInterfaces_InterfaceType) ΛMap() map[string]map[int64]ygot.EnumDefinition { return ΛEnum; }

// String returns a logging-friendly string for E_IETFInterfaces_InterfaceType.
func (e E_IETFInterfaces_InterfaceType) String() string {
	return ygot.EnumLogString(e, int64(e), "E_IETFInterfaces_InterfaceType")
}

const (
	// IETFInterfaces_InterfaceType_UNSET corresponds to the value UNSET of IETFInterfaces_InterfaceType
	IETFInterfaces_InterfaceType_UNSET E_IETFInterfaces_InterfaceType = 0
)


// E_OpenconfigAaaTypes_AAA_ACCOUNTING_EVENT_TYPE is a derived int64 type which is used to represent
// the enumerated node OpenconfigAaaTypes_AAA_ACCOUNTING_EVENT_TYPE. An additional value named
// OpenconfigAaaTypes_AAA_ACCOUNTING_EVENT_TYPE_UNSET is added to the enumeration which is used as
// the nil value, indicating that the enumeration was not explicitly set by
// the program importing the generated structures.
type E_OpenconfigAaaTypes_AAA_ACCOUNTING_EVENT_TYPE int64

// IsYANGGoEnum ensures that OpenconfigAaaTypes_AAA_ACCOUNTING_EVENT_TYPE implements the yang.GoEnum
// interface. This ensures that OpenconfigAaaTypes_AAA_ACCOUNTING_EVENT_TYPE can be identified as a
// mapped type for a YANG enumeration.
func (E_OpenconfigAaaTypes_AAA_ACCOUNTING_EVENT_TYPE) IsYANGGoEnum() {}

// ΛMap returns the value lookup map associated with  OpenconfigAaaTypes_AAA_ACCOUNTING_EVENT_TYPE.
func (E_OpenconfigAaaTypes_AAA_ACCOUNTING_EVENT_TYPE) ΛMap() map[string]map[int64]ygot.EnumDefinition { return ΛEnum; }

// String returns a logging-friendly string for E_OpenconfigAaaTypes_AAA_ACCOUNTING_EVENT_TYPE.
func (e E_OpenconfigAaaTypes_AAA_ACCOUNTING_EVENT_TYPE) String() string {
	return ygot.EnumLogString(e, int64(e), "E_OpenconfigAaaTypes_AAA_ACCOUNTING_EVENT_TYPE")
}

const (
	// OpenconfigAaaTypes_AAA_ACCOUNTING_EVENT_TYPE_UNSET corresponds to the value UNSET of OpenconfigAaaTypes_AAA_ACCOUNTING_EVENT_TYPE
	OpenconfigAaaTypes_AAA_ACCOUNTING_EVENT_TYPE_UNSET E_OpenconfigAaaTypes_AAA_ACCOUNTING_EVENT_TYPE = 0
	// OpenconfigAaaTypes_AAA_ACCOUNTING_EVENT_TYPE_AAA_ACCOUNTING_EVENT_COMMAND corresponds to the value AAA_ACCOUNTING_EVENT_COMMAND of OpenconfigAaaTypes_AAA_ACCOUNTING_EVENT_TYPE
	OpenconfigAaaTypes_AAA_ACCOUNTING_EVENT_TYPE_AAA_ACCOUNTING_EVENT_COMMAND E_OpenconfigAaaTypes_AAA_ACCOUNTING_EVENT_TYPE = 1
	// OpenconfigAaaTypes_AAA_ACCOUNTING_EVENT_TYPE_AAA_ACCOUNTING_EVENT_LOGIN corresponds to the value AAA_ACCOUNTING_EVENT_LOGIN of OpenconfigAaaTypes_AAA_ACCOUNTING_EVENT_TYPE
	OpenconfigAaaTypes_AAA_ACCOUNTING_EVENT_TYPE_AAA_ACCOUNTING_EVENT_LOGIN E_OpenconfigAaaTypes_AAA_ACCOUNTING_EVENT_TYPE = 2
)


// E_OpenconfigAaaTypes_AAA_AUTHORIZATION_EVENT_TYPE is a derived int64 type which is used to represent
// the enumerated node OpenconfigAaaTypes_AAA_AUTHORIZATION_EVENT_TYPE. An additional value named
// OpenconfigAaaTypes_AAA_AUTHORIZATION_EVENT_TYPE_UNSET is added to the enumeration which is used as
// the nil value, indicating that the enumeration was not explicitly set by
// the program importing the generated structures.
type E_OpenconfigAaaTypes_AAA_AUTHORIZATION_EVENT_TYPE int64

// IsYANGGoEnum ensures that OpenconfigAaaTypes_AAA_AUTHORIZATION_EVENT_TYPE implements the yang.GoEnum
// interface. This ensures that OpenconfigAaaTypes_AAA_AUTHORIZATION_EVENT_TYPE can be identified as a
// mapped type for a YANG enumeration.
func (E_OpenconfigAaaTypes_AAA_AUTHORIZATION_EVENT_TYPE) IsYANGGoEnum() {}

// ΛMap returns the value lookup map associated with  OpenconfigAaaTypes_AAA_AUTHORIZATION_EVENT_TYPE.
func (E_OpenconfigAaaTypes_AAA_AUTHORIZATION_EVENT_TYPE) ΛMap() map[string]map[int64]ygot.EnumDefinition { return ΛEnum; }

// String returns a logging-friendly string for E_OpenconfigAaaTypes_AAA_AUTHORIZATION_EVENT_TYPE.
func (e E_OpenconfigAaaTypes_AAA_AUTHORIZATION_EVENT_TYPE) String() string {
	return ygot.EnumLogString(e, int64(e), "E_OpenconfigAaaTypes_AAA_AUTHORIZATION_EVENT_TYPE")
}

const (
	// OpenconfigAaaTypes_AAA_AUTHORIZATION_EVENT_TYPE_UNSET corresponds to the value UNSET of OpenconfigAaaTypes_AAA_AUTHORIZATION_EVENT_TYPE
	OpenconfigAaaTypes_AAA_AUTHORIZATION_EVENT_TYPE_UNSET E_OpenconfigAaaTypes_AAA_AUTHORIZATION_EVENT_TYPE = 0
	// OpenconfigAaaTypes_AAA_AUTHORIZATION_EVENT_TYPE_AAA_AUTHORIZATION_EVENT_COMMAND corresponds to the value AAA_AUTHORIZATION_EVENT_COMMAND of OpenconfigAaaTypes_AAA_AUTHORIZATION_EVENT_TYPE
	OpenconfigAaaTypes_AAA_AUTHORIZATION_EVENT_TYPE_AAA_AUTHORIZATION_EVENT_COMMAND E_OpenconfigAaaTypes_AAA_AUTHORIZATION_EVENT_TYPE = 1
	// OpenconfigAaaTypes_AAA_AUTHORIZATION_EVENT_TYPE_AAA_AUTHORIZATION_EVENT_CONFIG corresponds to the value AAA_AUTHORIZATION_EVENT_CONFIG of OpenconfigAaaTypes_AAA_AUTHORIZATION_EVENT_TYPE
	OpenconfigAaaTypes_AAA_AUTHORIZATION_EVENT_TYPE_AAA_AUTHORIZATION_EVENT_CONFIG E_OpenconfigAaaTypes_AAA_AUTHORIZATION_EVENT_TYPE = 2
)


// E_OpenconfigAaaTypes_AAA_METHOD_TYPE is a derived int64 type which is used to represent
// the enumerated node OpenconfigAaaTypes_AAA_METHOD_TYPE. An additional value named
// OpenconfigAaaTypes_AAA_METHOD_TYPE_UNSET is added to the enumeration which is used as
// the nil value, indicating that the enumeration was not explicitly set by
// the program importing the generated structures.
type E_OpenconfigAaaTypes_AAA_METHOD_TYPE int64

// IsYANGGoEnum ensures that OpenconfigAaaTypes_AAA_METHOD_TYPE implements the yang.GoEnum
// interface. This ensures that OpenconfigAaaTypes_AAA_METHOD_TYPE can be identified as a
// mapped type for a YANG enumeration.
func (E_OpenconfigAaaTypes_AAA_METHOD_TYPE) IsYANGGoEnum() {}

// ΛMap returns the value lookup map associated with  OpenconfigAaaTypes_AAA_METHOD_TYPE.
func (E_OpenconfigAaaTypes_AAA_METHOD_TYPE) ΛMap() map[string]map[int64]ygot.EnumDefinition { return ΛEnum; }

// String returns a logging-friendly string for E_OpenconfigAaaTypes_AAA_METHOD_TYPE.
func (e E_OpenconfigAaaTypes_AAA_METHOD_TYPE) String() string {
	return ygot.EnumLogString(e, int64(e), "E_OpenconfigAaaTypes_AAA_METHOD_TYPE")
}

const (
	// OpenconfigAaaTypes_AAA_METHOD_TYPE_UNSET corresponds to the value UNSET of OpenconfigAaaTypes_AAA_METHOD_TYPE
	OpenconfigAaaTypes_AAA_METHOD_TYPE_UNSET E_OpenconfigAaaTypes_AAA_METHOD_TYPE = 0
	// OpenconfigAaaTypes_AAA_METHOD_TYPE_LOCAL corresponds to the value LOCAL of OpenconfigAaaTypes_AAA_METHOD_TYPE
	OpenconfigAaaTypes_AAA_METHOD_TYPE_LOCAL E_OpenconfigAaaTypes_AAA_METHOD_TYPE = 1
	// OpenconfigAaaTypes_AAA_METHOD_TYPE_RADIUS_ALL corresponds to the value RADIUS_ALL of OpenconfigAaaTypes_AAA_METHOD_TYPE
	OpenconfigAaaTypes_AAA_METHOD_TYPE_RADIUS_ALL E_OpenconfigAaaTypes_AAA_METHOD_TYPE = 2
	// OpenconfigAaaTypes_AAA_METHOD_TYPE_TACACS_ALL corresponds to the value TACACS_ALL of OpenconfigAaaTypes_AAA_METHOD_TYPE
	OpenconfigAaaTypes_AAA_METHOD_TYPE_TACACS_ALL E_OpenconfigAaaTypes_AAA_METHOD_TYPE = 3
)


// E_OpenconfigAaaTypes_AAA_SERVER_TYPE is a derived int64 type which is used to represent
// the enumerated node OpenconfigAaaTypes_AAA_SERVER_TYPE. An additional value named
// OpenconfigAaaTypes_AAA_SERVER_TYPE_UNSET is added to the enumeration which is used as
// the nil value, indicating that the enumeration was not explicitly set by
// the program importing the generated structures.
type E_OpenconfigAaaTypes_AAA_SERVER_TYPE int64

// IsYANGGoEnum ensures that OpenconfigAaaTypes_AAA_SERVER_TYPE implements the yang.GoEnum
// interface. This ensures that OpenconfigAaaTypes_AAA_SERVER_TYPE can be identified as a
// mapped type for a YANG enumeration.
func (E_OpenconfigAaaTypes_AAA_SERVER_TYPE) IsYANGGoEnum() {}

// ΛMap returns the value lookup map associated with  OpenconfigAaaTypes_AAA_SERVER_TYPE.
func (E_OpenconfigAaaTypes_AAA_SERVER_TYPE) ΛMap() map[string]map[int64]ygot.EnumDefinition { return ΛEnum; }

// String returns a logging-friendly string for E_OpenconfigAaaTypes_AAA_SERVER_TYPE.
func (e E_OpenconfigAaaTypes_AAA_SERVER_TYPE) String() string {
	return ygot.EnumLogString(e, int64(e), "E_OpenconfigAaaTypes_AAA_SERVER_TYPE")
}

const (
	// OpenconfigAaaTypes_AAA_SERVER_TYPE_UNSET corresponds to the value UNSET of OpenconfigAaaTypes_AAA_SERVER_TYPE
	OpenconfigAaaTypes_AAA_SERVER_TYPE_UNSET E_OpenconfigAaaTypes_AAA_SERVER_TYPE = 0
	// OpenconfigAaaTypes_AAA_SERVER_TYPE_RADIUS corresponds to the value RADIUS of OpenconfigAaaTypes_AAA_SERVER_TYPE
	OpenconfigAaaTypes_AAA_SERVER_TYPE_RADIUS E_OpenconfigAaaTypes_AAA_SERVER_TYPE = 1
	// OpenconfigAaaTypes_AAA_SERVER_TYPE_TACACS corresponds to the value TACACS of OpenconfigAaaTypes_AAA_SERVER_TYPE
	OpenconfigAaaTypes_AAA_SERVER_TYPE_TACACS E_OpenconfigAaaTypes_AAA_SERVER_TYPE = 2
)


// E_OpenconfigAaaTypes_SYSTEM_DEFINED_ROLES is a derived int64 type which is used to represent
// the enumerated node OpenconfigAaaTypes_SYSTEM_DEFINED_ROLES. An additional value named
// OpenconfigAaaTypes_SYSTEM_DEFINED_ROLES_UNSET is added to the enumeration which is used as
// the nil value, indicating that the enumeration was not explicitly set by
// the program importing the generated structures.
type E_OpenconfigAaaTypes_SYSTEM_DEFINED_ROLES int64

// IsYANGGoEnum ensures that OpenconfigAaaTypes_SYSTEM_DEFINED_ROLES implements the yang.GoEnum
// interface. This ensures that OpenconfigAaaTypes_SYSTEM_DEFINED_ROLES can be identified as a
// mapped type for a YANG enumeration.
func (E_OpenconfigAaaTypes_SYSTEM_DEFINED_ROLES) IsYANGGoEnum() {}

// ΛMap returns the value lookup map associated with  OpenconfigAaaTypes_SYSTEM_DEFINED_ROLES.
func (E_OpenconfigAaaTypes_SYSTEM_DEFINED_ROLES) ΛMap() map[string]map[int64]ygot.EnumDefinition { return ΛEnum; }

// String returns a logging-friendly string for E_OpenconfigAaaTypes_SYSTEM_DEFINED_ROLES.
func (e E_OpenconfigAaaTypes_SYSTEM_DEFINED_ROLES) String() string {
	return ygot.EnumLogString(e, int64(e), "E_OpenconfigAaaTypes_SYSTEM_DEFINED_ROLES")
}

const (
	// OpenconfigAaaTypes_SYSTEM_DEFINED_ROLES_UNSET corresponds to the value UNSET of OpenconfigAaaTypes_SYSTEM_DEFINED_ROLES
	OpenconfigAaaTypes_SYSTEM_DEFINED_ROLES_UNSET E_OpenconfigAaaTypes_SYSTEM_DEFINED_ROLES = 0
	// OpenconfigAaaTypes_SYSTEM_DEFINED_ROLES_SYSTEM_ROLE_ADMIN corresponds to the value SYSTEM_ROLE_ADMIN of OpenconfigAaaTypes_SYSTEM_DEFINED_ROLES
	OpenconfigAaaTypes_SYSTEM_DEFINED_ROLES_SYSTEM_ROLE_ADMIN E_OpenconfigAaaTypes_SYSTEM_DEFINED_ROLES = 1
)


// E_OpenconfigAlarmTypes_OPENCONFIG_ALARM_SEVERITY is a derived int64 type which is used to represent
// the enumerated node OpenconfigAlarmTypes_OPENCONFIG_ALARM_SEVERITY. An additional value named
// OpenconfigAlarmTypes_OPENCONFIG_ALARM_SEVERITY_UNSET is added to the enumeration which is used as
// the nil value, indicating that the enumeration was not explicitly set by
// the program importing the generated structures.
type E_OpenconfigAlarmTypes_OPENCONFIG_ALARM_SEVERITY int64

// IsYANGGoEnum ensures that OpenconfigAlarmTypes_OPENCONFIG_ALARM_SEVERITY implements the yang.GoEnum
// interface. This ensures that OpenconfigAlarmTypes_OPENCONFIG_ALARM_SEVERITY can be identified as a
// mapped type for a YANG enumeration.
func (E_OpenconfigAlarmTypes_OPENCONFIG_ALARM_SEVERITY) IsYANGGoEnum() {}

// ΛMap returns the value lookup map associated with  OpenconfigAlarmTypes_OPENCONFIG_ALARM_SEVERITY.
func (E_OpenconfigAlarmTypes_OPENCONFIG_ALARM_SEVERITY) ΛMap() map[string]map[int64]ygot.EnumDefinition { return ΛEnum; }

// String returns a logging-friendly string for E_OpenconfigAlarmTypes_OPENCONFIG_ALARM_SEVERITY.
func (e E_OpenconfigAlarmTypes_OPENCONFIG_ALARM_SEVERITY) String() string {
	return ygot.EnumLogString(e, int64(e), "E_OpenconfigAlarmTypes_OPENCONFIG_ALARM_SEVERITY")
}

const (
	// OpenconfigAlarmTypes_OPENCONFIG_ALARM_SEVERITY_UNSET corresponds to the value UNSET of OpenconfigAlarmTypes_OPENCONFIG_ALARM_SEVERITY
	OpenconfigAlarmTypes_OPENCONFIG_ALARM_SEVERITY_UNSET E_OpenconfigAlarmTypes_OPENCONFIG_ALARM_SEVERITY = 0
	// OpenconfigAlarmTypes_OPENCONFIG_ALARM_SEVERITY_CRITICAL corresponds to the value CRITICAL of OpenconfigAlarmTypes_OPENCONFIG_ALARM_SEVERITY
	OpenconfigAlarmTypes_OPENCONFIG_ALARM_SEVERITY_CRITICAL E_OpenconfigAlarmTypes_OPENCONFIG_ALARM_SEVERITY = 1
	// OpenconfigAlarmTypes_OPENCONFIG_ALARM_SEVERITY_MAJOR corresponds to the value MAJOR of OpenconfigAlarmTypes_OPENCONFIG_ALARM_SEVERITY
	OpenconfigAlarmTypes_OPENCONFIG_ALARM_SEVERITY_MAJOR E_OpenconfigAlarmTypes_OPENCONFIG_ALARM_SEVERITY = 2
	// OpenconfigAlarmTypes_OPENCONFIG_ALARM_SEVERITY_MINOR corresponds to the value MINOR of OpenconfigAlarmTypes_OPENCONFIG_ALARM_SEVERITY
	OpenconfigAlarmTypes_OPENCONFIG_ALARM_SEVERITY_MINOR E_OpenconfigAlarmTypes_OPENCONFIG_ALARM_SEVERITY = 3
	// OpenconfigAlarmTypes_OPENCONFIG_ALARM_SEVERITY_UNKNOWN corresponds to the value UNKNOWN of OpenconfigAlarmTypes_OPENCONFIG_ALARM_SEVERITY
	OpenconfigAlarmTypes_OPENCONFIG_ALARM_SEVERITY_UNKNOWN E_OpenconfigAlarmTypes_OPENCONFIG_ALARM_SEVERITY = 4
	// OpenconfigAlarmTypes_OPENCONFIG_ALARM_SEVERITY_WARNING corresponds to the value WARNING of OpenconfigAlarmTypes_OPENCONFIG_ALARM_SEVERITY
	OpenconfigAlarmTypes_OPENCONFIG_ALARM_SEVERITY_WARNING E_OpenconfigAlarmTypes_OPENCONFIG_ALARM_SEVERITY = 5
)


// E_OpenconfigAlarmTypes_OPENCONFIG_ALARM_TYPE_ID is a derived int64 type which is used to represent
// the enumerated node OpenconfigAlarmTypes_OPENCONFIG_ALARM_TYPE_ID. An additional value named
// OpenconfigAlarmTypes_OPENCONFIG_ALARM_TYPE_ID_UNSET is added to the enumeration which is used as
// the nil value, indicating that the enumeration was not explicitly set by
// the program importing the generated structures.
type E_OpenconfigAlarmTypes_OPENCONFIG_ALARM_TYPE_ID int64

// IsYANGGoEnum ensures that OpenconfigAlarmTypes_OPENCONFIG_ALARM_TYPE_ID implements the yang.GoEnum
// interface. This ensures that OpenconfigAlarmTypes_OPENCONFIG_ALARM_TYPE_ID can be identified as a
// mapped type for a YANG enumeration.
func (E_OpenconfigAlarmTypes_OPENCONFIG_ALARM_TYPE_ID) IsYANGGoEnum() {}

// ΛMap returns the value lookup map associated with  OpenconfigAlarmTypes_OPENCONFIG_ALARM_TYPE_ID.
func (E_OpenconfigAlarmTypes_OPENCONFIG_ALARM_TYPE_ID) ΛMap() map[string]map[int64]ygot.EnumDefinition { return ΛEnum; }

// String returns a logging-friendly string for E_OpenconfigAlarmTypes_OPENCONFIG_ALARM_TYPE_ID.
func (e E_OpenconfigAlarmTypes_OPENCONFIG_ALARM_TYPE_ID) String() string {
	return ygot.EnumLogString(e, int64(e), "E_OpenconfigAlarmTypes_OPENCONFIG_ALARM_TYPE_ID")
}

const (
	// OpenconfigAlarmTypes_OPENCONFIG_ALARM_TYPE_ID_UNSET corresponds to the value UNSET of OpenconfigAlarmTypes_OPENCONFIG_ALARM_TYPE_ID
	OpenconfigAlarmTypes_OPENCONFIG_ALARM_TYPE_ID_UNSET E_OpenconfigAlarmTypes_OPENCONFIG_ALARM_TYPE_ID = 0
	// OpenconfigAlarmTypes_OPENCONFIG_ALARM_TYPE_ID_AIS corresponds to the value AIS of OpenconfigAlarmTypes_OPENCONFIG_ALARM_TYPE_ID
	OpenconfigAlarmTypes_OPENCONFIG_ALARM_TYPE_ID_AIS E_OpenconfigAlarmTypes_OPENCONFIG_ALARM_TYPE_ID = 1
	// OpenconfigAlarmTypes_OPENCONFIG_ALARM_TYPE_ID_EQPT corresponds to the value EQPT of OpenconfigAlarmTypes_OPENCONFIG_ALARM_TYPE_ID
	OpenconfigAlarmTypes_OPENCONFIG_ALARM_TYPE_ID_EQPT E_OpenconfigAlarmTypes_OPENCONFIG_ALARM_TYPE_ID = 2
	// OpenconfigAlarmTypes_OPENCONFIG_ALARM_TYPE_ID_LOS corresponds to the value LOS of OpenconfigAlarmTypes_OPENCONFIG_ALARM_TYPE_ID
	OpenconfigAlarmTypes_OPENCONFIG_ALARM_TYPE_ID_LOS E_OpenconfigAlarmTypes_OPENCONFIG_ALARM_TYPE_ID = 3
	// OpenconfigAlarmTypes_OPENCONFIG_ALARM_TYPE_ID_OTS corresponds to the value OTS of OpenconfigAlarmTypes_OPENCONFIG_ALARM_TYPE_ID
	OpenconfigAlarmTypes_OPENCONFIG_ALARM_TYPE_ID_OTS E_OpenconfigAlarmTypes_OPENCONFIG_ALARM_TYPE_ID = 4
)


// E_OpenconfigInterfaces_Interfaces_Interface_State_AdminStatus is a derived int64 type which is used to represent
// the enumerated node OpenconfigInterfaces_Interfaces_Interface_State_AdminStatus. An additional value named
// OpenconfigInterfaces_Interfaces_Interface_State_AdminStatus_UNSET is added to the enumeration which is used as
// the nil value, indicating that the enumeration was not explicitly set by
// the program importing the generated structures.
type E_OpenconfigInterfaces_Interfaces_Interface_State_AdminStatus int64

// IsYANGGoEnum ensures that OpenconfigInterfaces_Interfaces_Interface_State_AdminStatus implements the yang.GoEnum
// interface. This ensures that OpenconfigInterfaces_Interfaces_Interface_State_AdminStatus can be identified as a
// mapped type for a YANG enumeration.
func (E_OpenconfigInterfaces_Interfaces_Interface_State_AdminStatus) IsYANGGoEnum() {}

// ΛMap returns the value lookup map associated with  OpenconfigInterfaces_Interfaces_Interface_State_AdminStatus.
func (E_OpenconfigInterfaces_Interfaces_Interface_State_AdminStatus) ΛMap() map[string]map[int64]ygot.EnumDefinition { return ΛEnum; }

// String returns a logging-friendly string for E_OpenconfigInterfaces_Interfaces_Interface_State_AdminStatus.
func (e E_OpenconfigInterfaces_Interfaces_Interface_State_AdminStatus) String() string {
	return ygot.EnumLogString(e, int64(e), "E_OpenconfigInterfaces_Interfaces_Interface_State_AdminStatus")
}

const (
	// OpenconfigInterfaces_Interfaces_Interface_State_AdminStatus_UNSET corresponds to the value UNSET of OpenconfigInterfaces_Interfaces_Interface_State_AdminStatus
	OpenconfigInterfaces_Interfaces_Interface_State_AdminStatus_UNSET E_OpenconfigInterfaces_Interfaces_Interface_State_AdminStatus = 0
	// OpenconfigInterfaces_Interfaces_Interface_State_AdminStatus_UP corresponds to the value UP of OpenconfigInterfaces_Interfaces_Interface_State_AdminStatus
	OpenconfigInterfaces_Interfaces_Interface_State_AdminStatus_UP E_OpenconfigInterfaces_Interfaces_Interface_State_AdminStatus = 1
	// OpenconfigInterfaces_Interfaces_Interface_State_AdminStatus_DOWN corresponds to the value DOWN of OpenconfigInterfaces_Interfaces_Interface_State_AdminStatus
	OpenconfigInterfaces_Interfaces_Interface_State_AdminStatus_DOWN E_OpenconfigInterfaces_Interfaces_Interface_State_AdminStatus = 2
	// OpenconfigInterfaces_Interfaces_Interface_State_AdminStatus_TESTING corresponds to the value TESTING of OpenconfigInterfaces_Interfaces_Interface_State_AdminStatus
	OpenconfigInterfaces_Interfaces_Interface_State_AdminStatus_TESTING E_OpenconfigInterfaces_Interfaces_Interface_State_AdminStatus = 3
)


// E_OpenconfigInterfaces_Interfaces_Interface_State_OperStatus is a derived int64 type which is used to represent
// the enumerated node OpenconfigInterfaces_Interfaces_Interface_State_OperStatus. An additional value named
// OpenconfigInterfaces_Interfaces_Interface_State_OperStatus_UNSET is added to the enumeration which is used as
// the nil value, indicating that the enumeration was not explicitly set by
// the program importing the generated structures.
type E_OpenconfigInterfaces_Interfaces_Interface_State_OperStatus int64

// IsYANGGoEnum ensures that OpenconfigInterfaces_Interfaces_Interface_State_OperStatus implements the yang.GoEnum
// interface. This ensures that OpenconfigInterfaces_Interfaces_Interface_State_OperStatus can be identified as a
// mapped type for a YANG enumeration.
func (E_OpenconfigInterfaces_Interfaces_Interface_State_OperStatus) IsYANGGoEnum() {}

// ΛMap returns the value lookup map associated with  OpenconfigInterfaces_Interfaces_Interface_State_OperStatus.
func (E_OpenconfigInterfaces_Interfaces_Interface_State_OperStatus) ΛMap() map[string]map[int64]ygot.EnumDefinition { return ΛEnum; }

// String returns a logging-friendly string for E_OpenconfigInterfaces_Interfaces_Interface_State_OperStatus.
func (e E_OpenconfigInterfaces_Interfaces_Interface_State_OperStatus) String() string {
	return ygot.EnumLogString(e, int64(e), "E_OpenconfigInterfaces_Interfaces_Interface_State_OperStatus")
}

const (
	// OpenconfigInterfaces_Interfaces_Interface_State_OperStatus_UNSET corresponds to the value UNSET of OpenconfigInterfaces_Interfaces_Interface_State_OperStatus
	OpenconfigInterfaces_Interfaces_Interface_State_OperStatus_UNSET E_OpenconfigInterfaces_Interfaces_Interface_State_OperStatus = 0
	// OpenconfigInterfaces_Interfaces_Interface_State_OperStatus_UP corresponds to the value UP of OpenconfigInterfaces_Interfaces_Interface_State_OperStatus
	OpenconfigInterfaces_Interfaces_Interface_State_OperStatus_UP E_OpenconfigInterfaces_Interfaces_Interface_State_OperStatus = 1
	// OpenconfigInterfaces_Interfaces_Interface_State_OperStatus_DOWN corresponds to the value DOWN of OpenconfigInterfaces_Interfaces_Interface_State_OperStatus
	OpenconfigInterfaces_Interfaces_Interface_State_OperStatus_DOWN E_OpenconfigInterfaces_Interfaces_Interface_State_OperStatus = 2
	// OpenconfigInterfaces_Interfaces_Interface_State_OperStatus_TESTING corresponds to the value TESTING of OpenconfigInterfaces_Interfaces_Interface_State_OperStatus
	OpenconfigInterfaces_Interfaces_Interface_State_OperStatus_TESTING E_OpenconfigInterfaces_Interfaces_Interface_State_OperStatus = 3
	// OpenconfigInterfaces_Interfaces_Interface_State_OperStatus_UNKNOWN corresponds to the value UNKNOWN of OpenconfigInterfaces_Interfaces_Interface_State_OperStatus
	OpenconfigInterfaces_Interfaces_Interface_State_OperStatus_UNKNOWN E_OpenconfigInterfaces_Interfaces_Interface_State_OperStatus = 4
	// OpenconfigInterfaces_Interfaces_Interface_State_OperStatus_DORMANT corresponds to the value DORMANT of OpenconfigInterfaces_Interfaces_Interface_State_OperStatus
	OpenconfigInterfaces_Interfaces_Interface_State_OperStatus_DORMANT E_OpenconfigInterfaces_Interfaces_Interface_State_OperStatus = 5
	// OpenconfigInterfaces_Interfaces_Interface_State_OperStatus_NOT_PRESENT corresponds to the value NOT_PRESENT of OpenconfigInterfaces_Interfaces_Interface_State_OperStatus
	OpenconfigInterfaces_Interfaces_Interface_State_OperStatus_NOT_PRESENT E_OpenconfigInterfaces_Interfaces_Interface_State_OperStatus = 6
	// OpenconfigInterfaces_Interfaces_Interface_State_OperStatus_LOWER_LAYER_DOWN corresponds to the value LOWER_LAYER_DOWN of OpenconfigInterfaces_Interfaces_Interface_State_OperStatus
	OpenconfigInterfaces_Interfaces_Interface_State_OperStatus_LOWER_LAYER_DOWN E_OpenconfigInterfaces_Interfaces_Interface_State_OperStatus = 7
)


// E_OpenconfigMessages_DEBUG_SERVICE is a derived int64 type which is used to represent
// the enumerated node OpenconfigMessages_DEBUG_SERVICE. An additional value named
// OpenconfigMessages_DEBUG_SERVICE_UNSET is added to the enumeration which is used as
// the nil value, indicating that the enumeration was not explicitly set by
// the program importing the generated structures.
type E_OpenconfigMessages_DEBUG_SERVICE int64

// IsYANGGoEnum ensures that OpenconfigMessages_DEBUG_SERVICE implements the yang.GoEnum
// interface. This ensures that OpenconfigMessages_DEBUG_SERVICE can be identified as a
// mapped type for a YANG enumeration.
func (E_OpenconfigMessages_DEBUG_SERVICE) IsYANGGoEnum() {}

// ΛMap returns the value lookup map associated with  OpenconfigMessages_DEBUG_SERVICE.
func (E_OpenconfigMessages_DEBUG_SERVICE) ΛMap() map[string]map[int64]ygot.EnumDefinition { return ΛEnum; }

// String returns a logging-friendly string for E_OpenconfigMessages_DEBUG_SERVICE.
func (e E_OpenconfigMessages_DEBUG_SERVICE) String() string {
	return ygot.EnumLogString(e, int64(e), "E_OpenconfigMessages_DEBUG_SERVICE")
}

const (
	// OpenconfigMessages_DEBUG_SERVICE_UNSET corresponds to the value UNSET of OpenconfigMessages_DEBUG_SERVICE
	OpenconfigMessages_DEBUG_SERVICE_UNSET E_OpenconfigMessages_DEBUG_SERVICE = 0
)


// E_OpenconfigMessages_SyslogSeverity is a derived int64 type which is used to represent
// the enumerated node OpenconfigMessages_SyslogSeverity. An additional value named
// OpenconfigMessages_SyslogSeverity_UNSET is added to the enumeration which is used as
// the nil value, indicating that the enumeration was not explicitly set by
// the program importing the generated structures.
type E_OpenconfigMessages_SyslogSeverity int64

// IsYANGGoEnum ensures that OpenconfigMessages_SyslogSeverity implements the yang.GoEnum
// interface. This ensures that OpenconfigMessages_SyslogSeverity can be identified as a
// mapped type for a YANG enumeration.
func (E_OpenconfigMessages_SyslogSeverity) IsYANGGoEnum() {}

// ΛMap returns the value lookup map associated with  OpenconfigMessages_SyslogSeverity.
func (E_OpenconfigMessages_SyslogSeverity) ΛMap() map[string]map[int64]ygot.EnumDefinition { return ΛEnum; }

// String returns a logging-friendly string for E_OpenconfigMessages_SyslogSeverity.
func (e E_OpenconfigMessages_SyslogSeverity) String() string {
	return ygot.EnumLogString(e, int64(e), "E_OpenconfigMessages_SyslogSeverity")
}

const (
	// OpenconfigMessages_SyslogSeverity_UNSET corresponds to the value UNSET of OpenconfigMessages_SyslogSeverity
	OpenconfigMessages_SyslogSeverity_UNSET E_OpenconfigMessages_SyslogSeverity = 0
	// OpenconfigMessages_SyslogSeverity_EMERGENCY corresponds to the value EMERGENCY of OpenconfigMessages_SyslogSeverity
	OpenconfigMessages_SyslogSeverity_EMERGENCY E_OpenconfigMessages_SyslogSeverity = 1
	// OpenconfigMessages_SyslogSeverity_ALERT corresponds to the value ALERT of OpenconfigMessages_SyslogSeverity
	OpenconfigMessages_SyslogSeverity_ALERT E_OpenconfigMessages_SyslogSeverity = 2
	// OpenconfigMessages_SyslogSeverity_CRITICAL corresponds to the value CRITICAL of OpenconfigMessages_SyslogSeverity
	OpenconfigMessages_SyslogSeverity_CRITICAL E_OpenconfigMessages_SyslogSeverity = 3
	// OpenconfigMessages_SyslogSeverity_ERROR corresponds to the value ERROR of OpenconfigMessages_SyslogSeverity
	OpenconfigMessages_SyslogSeverity_ERROR E_OpenconfigMessages_SyslogSeverity = 4
	// OpenconfigMessages_SyslogSeverity_WARNING corresponds to the value WARNING of OpenconfigMessages_SyslogSeverity
	OpenconfigMessages_SyslogSeverity_WARNING E_OpenconfigMessages_SyslogSeverity = 5
	// OpenconfigMessages_SyslogSeverity_NOTICE corresponds to the value NOTICE of OpenconfigMessages_SyslogSeverity
	OpenconfigMessages_SyslogSeverity_NOTICE E_OpenconfigMessages_SyslogSeverity = 6
	// OpenconfigMessages_SyslogSeverity_INFORMATIONAL corresponds to the value INFORMATIONAL of OpenconfigMessages_SyslogSeverity
	OpenconfigMessages_SyslogSeverity_INFORMATIONAL E_OpenconfigMessages_SyslogSeverity = 7
	// OpenconfigMessages_SyslogSeverity_DEBUG corresponds to the value DEBUG of OpenconfigMessages_SyslogSeverity
	OpenconfigMessages_SyslogSeverity_DEBUG E_OpenconfigMessages_SyslogSeverity = 8
)


// E_OpenconfigOpenflow_FailureMode is a derived int64 type which is used to represent
// the enumerated node OpenconfigOpenflow_FailureMode. An additional value named
// OpenconfigOpenflow_FailureMode_UNSET is added to the enumeration which is used as
// the nil value, indicating that the enumeration was not explicitly set by
// the program importing the generated structures.
type E_OpenconfigOpenflow_FailureMode int64

// IsYANGGoEnum ensures that OpenconfigOpenflow_FailureMode implements the yang.GoEnum
// interface. This ensures that OpenconfigOpenflow_FailureMode can be identified as a
// mapped type for a YANG enumeration.
func (E_OpenconfigOpenflow_FailureMode) IsYANGGoEnum() {}

// ΛMap returns the value lookup map associated with  OpenconfigOpenflow_FailureMode.
func (E_OpenconfigOpenflow_FailureMode) ΛMap() map[string]map[int64]ygot.EnumDefinition { return ΛEnum; }

// String returns a logging-friendly string for E_OpenconfigOpenflow_FailureMode.
func (e E_OpenconfigOpenflow_FailureMode) String() string {
	return ygot.EnumLogString(e, int64(e), "E_OpenconfigOpenflow_FailureMode")
}

const (
	// OpenconfigOpenflow_FailureMode_UNSET corresponds to the value UNSET of OpenconfigOpenflow_FailureMode
	OpenconfigOpenflow_FailureMode_UNSET E_OpenconfigOpenflow_FailureMode = 0
	// OpenconfigOpenflow_FailureMode_SECURE corresponds to the value SECURE of OpenconfigOpenflow_FailureMode
	OpenconfigOpenflow_FailureMode_SECURE E_OpenconfigOpenflow_FailureMode = 1
	// OpenconfigOpenflow_FailureMode_STANDALONE corresponds to the value STANDALONE of OpenconfigOpenflow_FailureMode
	OpenconfigOpenflow_FailureMode_STANDALONE E_OpenconfigOpenflow_FailureMode = 2
)


// E_OpenconfigOpenflow_Transport is a derived int64 type which is used to represent
// the enumerated node OpenconfigOpenflow_Transport. An additional value named
// OpenconfigOpenflow_Transport_UNSET is added to the enumeration which is used as
// the nil value, indicating that the enumeration was not explicitly set by
// the program importing the generated structures.
type E_OpenconfigOpenflow_Transport int64

// IsYANGGoEnum ensures that OpenconfigOpenflow_Transport implements the yang.GoEnum
// interface. This ensures that OpenconfigOpenflow_Transport can be identified as a
// mapped type for a YANG enumeration.
func (E_OpenconfigOpenflow_Transport) IsYANGGoEnum() {}

// ΛMap returns the value lookup map associated with  OpenconfigOpenflow_Transport.
func (E_OpenconfigOpenflow_Transport) ΛMap() map[string]map[int64]ygot.EnumDefinition { return ΛEnum; }

// String returns a logging-friendly string for E_OpenconfigOpenflow_Transport.
func (e E_OpenconfigOpenflow_Transport) String() string {
	return ygot.EnumLogString(e, int64(e), "E_OpenconfigOpenflow_Transport")
}

const (
	// OpenconfigOpenflow_Transport_UNSET corresponds to the value UNSET of OpenconfigOpenflow_Transport
	OpenconfigOpenflow_Transport_UNSET E_OpenconfigOpenflow_Transport = 0
	// OpenconfigOpenflow_Transport_TCP corresponds to the value TCP of OpenconfigOpenflow_Transport
	OpenconfigOpenflow_Transport_TCP E_OpenconfigOpenflow_Transport = 1
	// OpenconfigOpenflow_Transport_TLS corresponds to the value TLS of OpenconfigOpenflow_Transport
	OpenconfigOpenflow_Transport_TLS E_OpenconfigOpenflow_Transport = 2
)


// E_OpenconfigPlatformTypes_COMPONENT_OPER_STATUS is a derived int64 type which is used to represent
// the enumerated node OpenconfigPlatformTypes_COMPONENT_OPER_STATUS. An additional value named
// OpenconfigPlatformTypes_COMPONENT_OPER_STATUS_UNSET is added to the enumeration which is used as
// the nil value, indicating that the enumeration was not explicitly set by
// the program importing the generated structures.
type E_OpenconfigPlatformTypes_COMPONENT_OPER_STATUS int64

// IsYANGGoEnum ensures that OpenconfigPlatformTypes_COMPONENT_OPER_STATUS implements the yang.GoEnum
// interface. This ensures that OpenconfigPlatformTypes_COMPONENT_OPER_STATUS can be identified as a
// mapped type for a YANG enumeration.
func (E_OpenconfigPlatformTypes_COMPONENT_OPER_STATUS) IsYANGGoEnum() {}

// ΛMap returns the value lookup map associated with  OpenconfigPlatformTypes_COMPONENT_OPER_STATUS.
func (E_OpenconfigPlatformTypes_COMPONENT_OPER_STATUS) ΛMap() map[string]map[int64]ygot.EnumDefinition { return ΛEnum; }

// String returns a logging-friendly string for E_OpenconfigPlatformTypes_COMPONENT_OPER_STATUS.
func (e E_OpenconfigPlatformTypes_COMPONENT_OPER_STATUS) String() string {
	return ygot.EnumLogString(e, int64(e), "E_OpenconfigPlatformTypes_COMPONENT_OPER_STATUS")
}

const (
	// OpenconfigPlatformTypes_COMPONENT_OPER_STATUS_UNSET corresponds to the value UNSET of OpenconfigPlatformTypes_COMPONENT_OPER_STATUS
	OpenconfigPlatformTypes_COMPONENT_OPER_STATUS_UNSET E_OpenconfigPlatformTypes_COMPONENT_OPER_STATUS = 0
	// OpenconfigPlatformTypes_COMPONENT_OPER_STATUS_ACTIVE corresponds to the value ACTIVE of OpenconfigPlatformTypes_COMPONENT_OPER_STATUS
	OpenconfigPlatformTypes_COMPONENT_OPER_STATUS_ACTIVE E_OpenconfigPlatformTypes_COMPONENT_OPER_STATUS = 1
	// OpenconfigPlatformTypes_COMPONENT_OPER_STATUS_DISABLED corresponds to the value DISABLED of OpenconfigPlatformTypes_COMPONENT_OPER_STATUS
	OpenconfigPlatformTypes_COMPONENT_OPER_STATUS_DISABLED E_OpenconfigPlatformTypes_COMPONENT_OPER_STATUS = 2
	// OpenconfigPlatformTypes_COMPONENT_OPER_STATUS_INACTIVE corresponds to the value INACTIVE of OpenconfigPlatformTypes_COMPONENT_OPER_STATUS
	OpenconfigPlatformTypes_COMPONENT_OPER_STATUS_INACTIVE E_OpenconfigPlatformTypes_COMPONENT_OPER_STATUS = 3
)


// E_OpenconfigPlatformTypes_COMPONENT_REBOOT_REASON is a derived int64 type which is used to represent
// the enumerated node OpenconfigPlatformTypes_COMPONENT_REBOOT_REASON. An additional value named
// OpenconfigPlatformTypes_COMPONENT_REBOOT_REASON_UNSET is added to the enumeration which is used as
// the nil value, indicating that the enumeration was not explicitly set by
// the program importing the generated structures.
type E_OpenconfigPlatformTypes_COMPONENT_REBOOT_REASON int64

// IsYANGGoEnum ensures that OpenconfigPlatformTypes_COMPONENT_REBOOT_REASON implements the yang.GoEnum
// interface. This ensures that OpenconfigPlatformTypes_COMPONENT_REBOOT_REASON can be identified as a
// mapped type for a YANG enumeration.
func (E_OpenconfigPlatformTypes_COMPONENT_REBOOT_REASON) IsYANGGoEnum() {}

// ΛMap returns the value lookup map associated with  OpenconfigPlatformTypes_COMPONENT_REBOOT_REASON.
func (E_OpenconfigPlatformTypes_COMPONENT_REBOOT_REASON) ΛMap() map[string]map[int64]ygot.EnumDefinition { return ΛEnum; }

// String returns a logging-friendly string for E_OpenconfigPlatformTypes_COMPONENT_REBOOT_REASON.
func (e E_OpenconfigPlatformTypes_COMPONENT_REBOOT_REASON) String() string {
	return ygot.EnumLogString(e, int64(e), "E_OpenconfigPlatformTypes_COMPONENT_REBOOT_REASON")
}

const (
	// OpenconfigPlatformTypes_COMPONENT_REBOOT_REASON_UNSET corresponds to the value UNSET of OpenconfigPlatformTypes_COMPONENT_REBOOT_REASON
	OpenconfigPlatformTypes_COMPONENT_REBOOT_REASON_UNSET E_OpenconfigPlatformTypes_COMPONENT_REBOOT_REASON = 0
	// OpenconfigPlatformTypes_COMPONENT_REBOOT_REASON_REBOOT_CRITICAL_ERROR corresponds to the value REBOOT_CRITICAL_ERROR of OpenconfigPlatformTypes_COMPONENT_REBOOT_REASON
	OpenconfigPlatformTypes_COMPONENT_REBOOT_REASON_REBOOT_CRITICAL_ERROR E_OpenconfigPlatformTypes_COMPONENT_REBOOT_REASON = 1
	// OpenconfigPlatformTypes_COMPONENT_REBOOT_REASON_REBOOT_POWER_FAILURE corresponds to the value REBOOT_POWER_FAILURE of OpenconfigPlatformTypes_COMPONENT_REBOOT_REASON
	OpenconfigPlatformTypes_COMPONENT_REBOOT_REASON_REBOOT_POWER_FAILURE E_OpenconfigPlatformTypes_COMPONENT_REBOOT_REASON = 2
	// OpenconfigPlatformTypes_COMPONENT_REBOOT_REASON_REBOOT_USER_INITIATED corresponds to the value REBOOT_USER_INITIATED of OpenconfigPlatformTypes_COMPONENT_REBOOT_REASON
	OpenconfigPlatformTypes_COMPONENT_REBOOT_REASON_REBOOT_USER_INITIATED E_OpenconfigPlatformTypes_COMPONENT_REBOOT_REASON = 3
)


// E_OpenconfigPlatformTypes_ComponentRedundantRoleSwitchoverReasonTrigger is a derived int64 type which is used to represent
// the enumerated node OpenconfigPlatformTypes_ComponentRedundantRoleSwitchoverReasonTrigger. An additional value named
// OpenconfigPlatformTypes_ComponentRedundantRoleSwitchoverReasonTrigger_UNSET is added to the enumeration which is used as
// the nil value, indicating that the enumeration was not explicitly set by
// the program importing the generated structures.
type E_OpenconfigPlatformTypes_ComponentRedundantRoleSwitchoverReasonTrigger int64

// IsYANGGoEnum ensures that OpenconfigPlatformTypes_ComponentRedundantRoleSwitchoverReasonTrigger implements the yang.GoEnum
// interface. This ensures that OpenconfigPlatformTypes_ComponentRedundantRoleSwitchoverReasonTrigger can be identified as a
// mapped type for a YANG enumeration.
func (E_OpenconfigPlatformTypes_ComponentRedundantRoleSwitchoverReasonTrigger) IsYANGGoEnum() {}

// ΛMap returns the value lookup map associated with  OpenconfigPlatformTypes_ComponentRedundantRoleSwitchoverReasonTrigger.
func (E_OpenconfigPlatformTypes_ComponentRedundantRoleSwitchoverReasonTrigger) ΛMap() map[string]map[int64]ygot.EnumDefinition { return ΛEnum; }

// String returns a logging-friendly string for E_OpenconfigPlatformTypes_ComponentRedundantRoleSwitchoverReasonTrigger.
func (e E_OpenconfigPlatformTypes_ComponentRedundantRoleSwitchoverReasonTrigger) String() string {
	return ygot.EnumLogString(e, int64(e), "E_OpenconfigPlatformTypes_ComponentRedundantRoleSwitchoverReasonTrigger")
}

const (
	// OpenconfigPlatformTypes_ComponentRedundantRoleSwitchoverReasonTrigger_UNSET corresponds to the value UNSET of OpenconfigPlatformTypes_ComponentRedundantRoleSwitchoverReasonTrigger
	OpenconfigPlatformTypes_ComponentRedundantRoleSwitchoverReasonTrigger_UNSET E_OpenconfigPlatformTypes_ComponentRedundantRoleSwitchoverReasonTrigger = 0
	// OpenconfigPlatformTypes_ComponentRedundantRoleSwitchoverReasonTrigger_USER_INITIATED corresponds to the value USER_INITIATED of OpenconfigPlatformTypes_ComponentRedundantRoleSwitchoverReasonTrigger
	OpenconfigPlatformTypes_ComponentRedundantRoleSwitchoverReasonTrigger_USER_INITIATED E_OpenconfigPlatformTypes_ComponentRedundantRoleSwitchoverReasonTrigger = 1
	// OpenconfigPlatformTypes_ComponentRedundantRoleSwitchoverReasonTrigger_SYSTEM_INITIATED corresponds to the value SYSTEM_INITIATED of OpenconfigPlatformTypes_ComponentRedundantRoleSwitchoverReasonTrigger
	OpenconfigPlatformTypes_ComponentRedundantRoleSwitchoverReasonTrigger_SYSTEM_INITIATED E_OpenconfigPlatformTypes_ComponentRedundantRoleSwitchoverReasonTrigger = 2
)


// E_OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT is a derived int64 type which is used to represent
// the enumerated node OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT. An additional value named
// OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT_UNSET is added to the enumeration which is used as
// the nil value, indicating that the enumeration was not explicitly set by
// the program importing the generated structures.
type E_OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT int64

// IsYANGGoEnum ensures that OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT implements the yang.GoEnum
// interface. This ensures that OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT can be identified as a
// mapped type for a YANG enumeration.
func (E_OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT) IsYANGGoEnum() {}

// ΛMap returns the value lookup map associated with  OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT.
func (E_OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT) ΛMap() map[string]map[int64]ygot.EnumDefinition { return ΛEnum; }

// String returns a logging-friendly string for E_OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT.
func (e E_OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT) String() string {
	return ygot.EnumLogString(e, int64(e), "E_OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT")
}

const (
	// OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT_UNSET corresponds to the value UNSET of OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT
	OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT_UNSET E_OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT = 0
	// OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT_BACKPLANE corresponds to the value BACKPLANE of OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT
	OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT_BACKPLANE E_OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT = 1
	// OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT_CHASSIS corresponds to the value CHASSIS of OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT
	OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT_CHASSIS E_OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT = 2
	// OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT_CONTROLLER_CARD corresponds to the value CONTROLLER_CARD of OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT
	OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT_CONTROLLER_CARD E_OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT = 3
	// OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT_CPU corresponds to the value CPU of OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT
	OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT_CPU E_OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT = 4
	// OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT_FABRIC corresponds to the value FABRIC of OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT
	OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT_FABRIC E_OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT = 5
	// OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT_FAN corresponds to the value FAN of OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT
	OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT_FAN E_OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT = 6
	// OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT_FRU corresponds to the value FRU of OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT
	OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT_FRU E_OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT = 7
	// OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT_INTEGRATED_CIRCUIT corresponds to the value INTEGRATED_CIRCUIT of OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT
	OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT_INTEGRATED_CIRCUIT E_OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT = 8
	// OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT_LINECARD corresponds to the value LINECARD of OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT
	OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT_LINECARD E_OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT = 9
	// OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT_PORT corresponds to the value PORT of OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT
	OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT_PORT E_OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT = 10
	// OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT_POWER_SUPPLY corresponds to the value POWER_SUPPLY of OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT
	OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT_POWER_SUPPLY E_OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT = 11
	// OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT_SENSOR corresponds to the value SENSOR of OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT
	OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT_SENSOR E_OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT = 12
	// OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT_STORAGE corresponds to the value STORAGE of OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT
	OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT_STORAGE E_OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT = 13
	// OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT_TRANSCEIVER corresponds to the value TRANSCEIVER of OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT
	OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT_TRANSCEIVER E_OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT = 14
)


// E_OpenconfigPlatformTypes_OPENCONFIG_SOFTWARE_COMPONENT is a derived int64 type which is used to represent
// the enumerated node OpenconfigPlatformTypes_OPENCONFIG_SOFTWARE_COMPONENT. An additional value named
// OpenconfigPlatformTypes_OPENCONFIG_SOFTWARE_COMPONENT_UNSET is added to the enumeration which is used as
// the nil value, indicating that the enumeration was not explicitly set by
// the program importing the generated structures.
type E_OpenconfigPlatformTypes_OPENCONFIG_SOFTWARE_COMPONENT int64

// IsYANGGoEnum ensures that OpenconfigPlatformTypes_OPENCONFIG_SOFTWARE_COMPONENT implements the yang.GoEnum
// interface. This ensures that OpenconfigPlatformTypes_OPENCONFIG_SOFTWARE_COMPONENT can be identified as a
// mapped type for a YANG enumeration.
func (E_OpenconfigPlatformTypes_OPENCONFIG_SOFTWARE_COMPONENT) IsYANGGoEnum() {}

// ΛMap returns the value lookup map associated with  OpenconfigPlatformTypes_OPENCONFIG_SOFTWARE_COMPONENT.
func (E_OpenconfigPlatformTypes_OPENCONFIG_SOFTWARE_COMPONENT) ΛMap() map[string]map[int64]ygot.EnumDefinition { return ΛEnum; }

// String returns a logging-friendly string for E_OpenconfigPlatformTypes_OPENCONFIG_SOFTWARE_COMPONENT.
func (e E_OpenconfigPlatformTypes_OPENCONFIG_SOFTWARE_COMPONENT) String() string {
	return ygot.EnumLogString(e, int64(e), "E_OpenconfigPlatformTypes_OPENCONFIG_SOFTWARE_COMPONENT")
}

const (
	// OpenconfigPlatformTypes_OPENCONFIG_SOFTWARE_COMPONENT_UNSET corresponds to the value UNSET of OpenconfigPlatformTypes_OPENCONFIG_SOFTWARE_COMPONENT
	OpenconfigPlatformTypes_OPENCONFIG_SOFTWARE_COMPONENT_UNSET E_OpenconfigPlatformTypes_OPENCONFIG_SOFTWARE_COMPONENT = 0
	// OpenconfigPlatformTypes_OPENCONFIG_SOFTWARE_COMPONENT_BIOS corresponds to the value BIOS of OpenconfigPlatformTypes_OPENCONFIG_SOFTWARE_COMPONENT
	OpenconfigPlatformTypes_OPENCONFIG_SOFTWARE_COMPONENT_BIOS E_OpenconfigPlatformTypes_OPENCONFIG_SOFTWARE_COMPONENT = 1
	// OpenconfigPlatformTypes_OPENCONFIG_SOFTWARE_COMPONENT_BOOT_LOADER corresponds to the value BOOT_LOADER of OpenconfigPlatformTypes_OPENCONFIG_SOFTWARE_COMPONENT
	OpenconfigPlatformTypes_OPENCONFIG_SOFTWARE_COMPONENT_BOOT_LOADER E_OpenconfigPlatformTypes_OPENCONFIG_SOFTWARE_COMPONENT = 2
	// OpenconfigPlatformTypes_OPENCONFIG_SOFTWARE_COMPONENT_OPERATING_SYSTEM corresponds to the value OPERATING_SYSTEM of OpenconfigPlatformTypes_OPENCONFIG_SOFTWARE_COMPONENT
	OpenconfigPlatformTypes_OPENCONFIG_SOFTWARE_COMPONENT_OPERATING_SYSTEM E_OpenconfigPlatformTypes_OPENCONFIG_SOFTWARE_COMPONENT = 3
	// OpenconfigPlatformTypes_OPENCONFIG_SOFTWARE_COMPONENT_OPERATING_SYSTEM_UPDATE corresponds to the value OPERATING_SYSTEM_UPDATE of OpenconfigPlatformTypes_OPENCONFIG_SOFTWARE_COMPONENT
	OpenconfigPlatformTypes_OPENCONFIG_SOFTWARE_COMPONENT_OPERATING_SYSTEM_UPDATE E_OpenconfigPlatformTypes_OPENCONFIG_SOFTWARE_COMPONENT = 4
	// OpenconfigPlatformTypes_OPENCONFIG_SOFTWARE_COMPONENT_SOFTWARE_MODULE corresponds to the value SOFTWARE_MODULE of OpenconfigPlatformTypes_OPENCONFIG_SOFTWARE_COMPONENT
	OpenconfigPlatformTypes_OPENCONFIG_SOFTWARE_COMPONENT_SOFTWARE_MODULE E_OpenconfigPlatformTypes_OPENCONFIG_SOFTWARE_COMPONENT = 5
)


// E_OpenconfigPlatform_ComponentRedundantRole is a derived int64 type which is used to represent
// the enumerated node OpenconfigPlatform_ComponentRedundantRole. An additional value named
// OpenconfigPlatform_ComponentRedundantRole_UNSET is added to the enumeration which is used as
// the nil value, indicating that the enumeration was not explicitly set by
// the program importing the generated structures.
type E_OpenconfigPlatform_ComponentRedundantRole int64

// IsYANGGoEnum ensures that OpenconfigPlatform_ComponentRedundantRole implements the yang.GoEnum
// interface. This ensures that OpenconfigPlatform_ComponentRedundantRole can be identified as a
// mapped type for a YANG enumeration.
func (E_OpenconfigPlatform_ComponentRedundantRole) IsYANGGoEnum() {}

// ΛMap returns the value lookup map associated with  OpenconfigPlatform_ComponentRedundantRole.
func (E_OpenconfigPlatform_ComponentRedundantRole) ΛMap() map[string]map[int64]ygot.EnumDefinition { return ΛEnum; }

// String returns a logging-friendly string for E_OpenconfigPlatform_ComponentRedundantRole.
func (e E_OpenconfigPlatform_ComponentRedundantRole) String() string {
	return ygot.EnumLogString(e, int64(e), "E_OpenconfigPlatform_ComponentRedundantRole")
}

const (
	// OpenconfigPlatform_ComponentRedundantRole_UNSET corresponds to the value UNSET of OpenconfigPlatform_ComponentRedundantRole
	OpenconfigPlatform_ComponentRedundantRole_UNSET E_OpenconfigPlatform_ComponentRedundantRole = 0
	// OpenconfigPlatform_ComponentRedundantRole_PRIMARY corresponds to the value PRIMARY of OpenconfigPlatform_ComponentRedundantRole
	OpenconfigPlatform_ComponentRedundantRole_PRIMARY E_OpenconfigPlatform_ComponentRedundantRole = 1
	// OpenconfigPlatform_ComponentRedundantRole_SECONDARY corresponds to the value SECONDARY of OpenconfigPlatform_ComponentRedundantRole
	OpenconfigPlatform_ComponentRedundantRole_SECONDARY E_OpenconfigPlatform_ComponentRedundantRole = 2
)


// E_OpenconfigSystemLogging_SYSLOG_FACILITY is a derived int64 type which is used to represent
// the enumerated node OpenconfigSystemLogging_SYSLOG_FACILITY. An additional value named
// OpenconfigSystemLogging_SYSLOG_FACILITY_UNSET is added to the enumeration which is used as
// the nil value, indicating that the enumeration was not explicitly set by
// the program importing the generated structures.
type E_OpenconfigSystemLogging_SYSLOG_FACILITY int64

// IsYANGGoEnum ensures that OpenconfigSystemLogging_SYSLOG_FACILITY implements the yang.GoEnum
// interface. This ensures that OpenconfigSystemLogging_SYSLOG_FACILITY can be identified as a
// mapped type for a YANG enumeration.
func (E_OpenconfigSystemLogging_SYSLOG_FACILITY) IsYANGGoEnum() {}

// ΛMap returns the value lookup map associated with  OpenconfigSystemLogging_SYSLOG_FACILITY.
func (E_OpenconfigSystemLogging_SYSLOG_FACILITY) ΛMap() map[string]map[int64]ygot.EnumDefinition { return ΛEnum; }

// String returns a logging-friendly string for E_OpenconfigSystemLogging_SYSLOG_FACILITY.
func (e E_OpenconfigSystemLogging_SYSLOG_FACILITY) String() string {
	return ygot.EnumLogString(e, int64(e), "E_OpenconfigSystemLogging_SYSLOG_FACILITY")
}

const (
	// OpenconfigSystemLogging_SYSLOG_FACILITY_UNSET corresponds to the value UNSET of OpenconfigSystemLogging_SYSLOG_FACILITY
	OpenconfigSystemLogging_SYSLOG_FACILITY_UNSET E_OpenconfigSystemLogging_SYSLOG_FACILITY = 0
	// OpenconfigSystemLogging_SYSLOG_FACILITY_ALL corresponds to the value ALL of OpenconfigSystemLogging_SYSLOG_FACILITY
	OpenconfigSystemLogging_SYSLOG_FACILITY_ALL E_OpenconfigSystemLogging_SYSLOG_FACILITY = 1
	// OpenconfigSystemLogging_SYSLOG_FACILITY_AUDIT corresponds to the value AUDIT of OpenconfigSystemLogging_SYSLOG_FACILITY
	OpenconfigSystemLogging_SYSLOG_FACILITY_AUDIT E_OpenconfigSystemLogging_SYSLOG_FACILITY = 2
	// OpenconfigSystemLogging_SYSLOG_FACILITY_AUTH corresponds to the value AUTH of OpenconfigSystemLogging_SYSLOG_FACILITY
	OpenconfigSystemLogging_SYSLOG_FACILITY_AUTH E_OpenconfigSystemLogging_SYSLOG_FACILITY = 3
	// OpenconfigSystemLogging_SYSLOG_FACILITY_AUTHPRIV corresponds to the value AUTHPRIV of OpenconfigSystemLogging_SYSLOG_FACILITY
	OpenconfigSystemLogging_SYSLOG_FACILITY_AUTHPRIV E_OpenconfigSystemLogging_SYSLOG_FACILITY = 4
	// OpenconfigSystemLogging_SYSLOG_FACILITY_CONSOLE corresponds to the value CONSOLE of OpenconfigSystemLogging_SYSLOG_FACILITY
	OpenconfigSystemLogging_SYSLOG_FACILITY_CONSOLE E_OpenconfigSystemLogging_SYSLOG_FACILITY = 5
	// OpenconfigSystemLogging_SYSLOG_FACILITY_KERNEL corresponds to the value KERNEL of OpenconfigSystemLogging_SYSLOG_FACILITY
	OpenconfigSystemLogging_SYSLOG_FACILITY_KERNEL E_OpenconfigSystemLogging_SYSLOG_FACILITY = 6
	// OpenconfigSystemLogging_SYSLOG_FACILITY_LOCAL0 corresponds to the value LOCAL0 of OpenconfigSystemLogging_SYSLOG_FACILITY
	OpenconfigSystemLogging_SYSLOG_FACILITY_LOCAL0 E_OpenconfigSystemLogging_SYSLOG_FACILITY = 7
	// OpenconfigSystemLogging_SYSLOG_FACILITY_LOCAL1 corresponds to the value LOCAL1 of OpenconfigSystemLogging_SYSLOG_FACILITY
	OpenconfigSystemLogging_SYSLOG_FACILITY_LOCAL1 E_OpenconfigSystemLogging_SYSLOG_FACILITY = 8
	// OpenconfigSystemLogging_SYSLOG_FACILITY_LOCAL2 corresponds to the value LOCAL2 of OpenconfigSystemLogging_SYSLOG_FACILITY
	OpenconfigSystemLogging_SYSLOG_FACILITY_LOCAL2 E_OpenconfigSystemLogging_SYSLOG_FACILITY = 9
	// OpenconfigSystemLogging_SYSLOG_FACILITY_LOCAL3 corresponds to the value LOCAL3 of OpenconfigSystemLogging_SYSLOG_FACILITY
	OpenconfigSystemLogging_SYSLOG_FACILITY_LOCAL3 E_OpenconfigSystemLogging_SYSLOG_FACILITY = 10
	// OpenconfigSystemLogging_SYSLOG_FACILITY_LOCAL4 corresponds to the value LOCAL4 of OpenconfigSystemLogging_SYSLOG_FACILITY
	OpenconfigSystemLogging_SYSLOG_FACILITY_LOCAL4 E_OpenconfigSystemLogging_SYSLOG_FACILITY = 11
	// OpenconfigSystemLogging_SYSLOG_FACILITY_LOCAL5 corresponds to the value LOCAL5 of OpenconfigSystemLogging_SYSLOG_FACILITY
	OpenconfigSystemLogging_SYSLOG_FACILITY_LOCAL5 E_OpenconfigSystemLogging_SYSLOG_FACILITY = 12
	// OpenconfigSystemLogging_SYSLOG_FACILITY_LOCAL6 corresponds to the value LOCAL6 of OpenconfigSystemLogging_SYSLOG_FACILITY
	OpenconfigSystemLogging_SYSLOG_FACILITY_LOCAL6 E_OpenconfigSystemLogging_SYSLOG_FACILITY = 13
	// OpenconfigSystemLogging_SYSLOG_FACILITY_LOCAL7 corresponds to the value LOCAL7 of OpenconfigSystemLogging_SYSLOG_FACILITY
	OpenconfigSystemLogging_SYSLOG_FACILITY_LOCAL7 E_OpenconfigSystemLogging_SYSLOG_FACILITY = 14
	// OpenconfigSystemLogging_SYSLOG_FACILITY_MAIL corresponds to the value MAIL of OpenconfigSystemLogging_SYSLOG_FACILITY
	OpenconfigSystemLogging_SYSLOG_FACILITY_MAIL E_OpenconfigSystemLogging_SYSLOG_FACILITY = 15
	// OpenconfigSystemLogging_SYSLOG_FACILITY_NTP corresponds to the value NTP of OpenconfigSystemLogging_SYSLOG_FACILITY
	OpenconfigSystemLogging_SYSLOG_FACILITY_NTP E_OpenconfigSystemLogging_SYSLOG_FACILITY = 16
	// OpenconfigSystemLogging_SYSLOG_FACILITY_SYSLOG corresponds to the value SYSLOG of OpenconfigSystemLogging_SYSLOG_FACILITY
	OpenconfigSystemLogging_SYSLOG_FACILITY_SYSLOG E_OpenconfigSystemLogging_SYSLOG_FACILITY = 17
	// OpenconfigSystemLogging_SYSLOG_FACILITY_SYSTEM_DAEMON corresponds to the value SYSTEM_DAEMON of OpenconfigSystemLogging_SYSLOG_FACILITY
	OpenconfigSystemLogging_SYSLOG_FACILITY_SYSTEM_DAEMON E_OpenconfigSystemLogging_SYSLOG_FACILITY = 18
	// OpenconfigSystemLogging_SYSLOG_FACILITY_USER corresponds to the value USER of OpenconfigSystemLogging_SYSLOG_FACILITY
	OpenconfigSystemLogging_SYSLOG_FACILITY_USER E_OpenconfigSystemLogging_SYSLOG_FACILITY = 19
)


// E_OpenconfigSystemLogging_SyslogSeverity is a derived int64 type which is used to represent
// the enumerated node OpenconfigSystemLogging_SyslogSeverity. An additional value named
// OpenconfigSystemLogging_SyslogSeverity_UNSET is added to the enumeration which is used as
// the nil value, indicating that the enumeration was not explicitly set by
// the program importing the generated structures.
type E_OpenconfigSystemLogging_SyslogSeverity int64

// IsYANGGoEnum ensures that OpenconfigSystemLogging_SyslogSeverity implements the yang.GoEnum
// interface. This ensures that OpenconfigSystemLogging_SyslogSeverity can be identified as a
// mapped type for a YANG enumeration.
func (E_OpenconfigSystemLogging_SyslogSeverity) IsYANGGoEnum() {}

// ΛMap returns the value lookup map associated with  OpenconfigSystemLogging_SyslogSeverity.
func (E_OpenconfigSystemLogging_SyslogSeverity) ΛMap() map[string]map[int64]ygot.EnumDefinition { return ΛEnum; }

// String returns a logging-friendly string for E_OpenconfigSystemLogging_SyslogSeverity.
func (e E_OpenconfigSystemLogging_SyslogSeverity) String() string {
	return ygot.EnumLogString(e, int64(e), "E_OpenconfigSystemLogging_SyslogSeverity")
}

const (
	// OpenconfigSystemLogging_SyslogSeverity_UNSET corresponds to the value UNSET of OpenconfigSystemLogging_SyslogSeverity
	OpenconfigSystemLogging_SyslogSeverity_UNSET E_OpenconfigSystemLogging_SyslogSeverity = 0
	// OpenconfigSystemLogging_SyslogSeverity_EMERGENCY corresponds to the value EMERGENCY of OpenconfigSystemLogging_SyslogSeverity
	OpenconfigSystemLogging_SyslogSeverity_EMERGENCY E_OpenconfigSystemLogging_SyslogSeverity = 1
	// OpenconfigSystemLogging_SyslogSeverity_ALERT corresponds to the value ALERT of OpenconfigSystemLogging_SyslogSeverity
	OpenconfigSystemLogging_SyslogSeverity_ALERT E_OpenconfigSystemLogging_SyslogSeverity = 2
	// OpenconfigSystemLogging_SyslogSeverity_CRITICAL corresponds to the value CRITICAL of OpenconfigSystemLogging_SyslogSeverity
	OpenconfigSystemLogging_SyslogSeverity_CRITICAL E_OpenconfigSystemLogging_SyslogSeverity = 3
	// OpenconfigSystemLogging_SyslogSeverity_ERROR corresponds to the value ERROR of OpenconfigSystemLogging_SyslogSeverity
	OpenconfigSystemLogging_SyslogSeverity_ERROR E_OpenconfigSystemLogging_SyslogSeverity = 4
	// OpenconfigSystemLogging_SyslogSeverity_WARNING corresponds to the value WARNING of OpenconfigSystemLogging_SyslogSeverity
	OpenconfigSystemLogging_SyslogSeverity_WARNING E_OpenconfigSystemLogging_SyslogSeverity = 5
	// OpenconfigSystemLogging_SyslogSeverity_NOTICE corresponds to the value NOTICE of OpenconfigSystemLogging_SyslogSeverity
	OpenconfigSystemLogging_SyslogSeverity_NOTICE E_OpenconfigSystemLogging_SyslogSeverity = 6
	// OpenconfigSystemLogging_SyslogSeverity_INFORMATIONAL corresponds to the value INFORMATIONAL of OpenconfigSystemLogging_SyslogSeverity
	OpenconfigSystemLogging_SyslogSeverity_INFORMATIONAL E_OpenconfigSystemLogging_SyslogSeverity = 7
	// OpenconfigSystemLogging_SyslogSeverity_DEBUG corresponds to the value DEBUG of OpenconfigSystemLogging_SyslogSeverity
	OpenconfigSystemLogging_SyslogSeverity_DEBUG E_OpenconfigSystemLogging_SyslogSeverity = 8
)


// E_OpenconfigSystem_NTP_AUTH_TYPE is a derived int64 type which is used to represent
// the enumerated node OpenconfigSystem_NTP_AUTH_TYPE. An additional value named
// OpenconfigSystem_NTP_AUTH_TYPE_UNSET is added to the enumeration which is used as
// the nil value, indicating that the enumeration was not explicitly set by
// the program importing the generated structures.
type E_OpenconfigSystem_NTP_AUTH_TYPE int64

// IsYANGGoEnum ensures that OpenconfigSystem_NTP_AUTH_TYPE implements the yang.GoEnum
// interface. This ensures that OpenconfigSystem_NTP_AUTH_TYPE can be identified as a
// mapped type for a YANG enumeration.
func (E_OpenconfigSystem_NTP_AUTH_TYPE) IsYANGGoEnum() {}

// ΛMap returns the value lookup map associated with  OpenconfigSystem_NTP_AUTH_TYPE.
func (E_OpenconfigSystem_NTP_AUTH_TYPE) ΛMap() map[string]map[int64]ygot.EnumDefinition { return ΛEnum; }

// String returns a logging-friendly string for E_OpenconfigSystem_NTP_AUTH_TYPE.
func (e E_OpenconfigSystem_NTP_AUTH_TYPE) String() string {
	return ygot.EnumLogString(e, int64(e), "E_OpenconfigSystem_NTP_AUTH_TYPE")
}

const (
	// OpenconfigSystem_NTP_AUTH_TYPE_UNSET corresponds to the value UNSET of OpenconfigSystem_NTP_AUTH_TYPE
	OpenconfigSystem_NTP_AUTH_TYPE_UNSET E_OpenconfigSystem_NTP_AUTH_TYPE = 0
	// OpenconfigSystem_NTP_AUTH_TYPE_NTP_AUTH_MD5 corresponds to the value NTP_AUTH_MD5 of OpenconfigSystem_NTP_AUTH_TYPE
	OpenconfigSystem_NTP_AUTH_TYPE_NTP_AUTH_MD5 E_OpenconfigSystem_NTP_AUTH_TYPE = 1
)


// E_OpenconfigSystem_System_Aaa_Accounting_Events_Event_Config_Record is a derived int64 type which is used to represent
// the enumerated node OpenconfigSystem_System_Aaa_Accounting_Events_Event_Config_Record. An additional value named
// OpenconfigSystem_System_Aaa_Accounting_Events_Event_Config_Record_UNSET is added to the enumeration which is used as
// the nil value, indicating that the enumeration was not explicitly set by
// the program importing the generated structures.
type E_OpenconfigSystem_System_Aaa_Accounting_Events_Event_Config_Record int64

// IsYANGGoEnum ensures that OpenconfigSystem_System_Aaa_Accounting_Events_Event_Config_Record implements the yang.GoEnum
// interface. This ensures that OpenconfigSystem_System_Aaa_Accounting_Events_Event_Config_Record can be identified as a
// mapped type for a YANG enumeration.
func (E_OpenconfigSystem_System_Aaa_Accounting_Events_Event_Config_Record) IsYANGGoEnum() {}

// ΛMap returns the value lookup map associated with  OpenconfigSystem_System_Aaa_Accounting_Events_Event_Config_Record.
func (E_OpenconfigSystem_System_Aaa_Accounting_Events_Event_Config_Record) ΛMap() map[string]map[int64]ygot.EnumDefinition { return ΛEnum; }

// String returns a logging-friendly string for E_OpenconfigSystem_System_Aaa_Accounting_Events_Event_Config_Record.
func (e E_OpenconfigSystem_System_Aaa_Accounting_Events_Event_Config_Record) String() string {
	return ygot.EnumLogString(e, int64(e), "E_OpenconfigSystem_System_Aaa_Accounting_Events_Event_Config_Record")
}

const (
	// OpenconfigSystem_System_Aaa_Accounting_Events_Event_Config_Record_UNSET corresponds to the value UNSET of OpenconfigSystem_System_Aaa_Accounting_Events_Event_Config_Record
	OpenconfigSystem_System_Aaa_Accounting_Events_Event_Config_Record_UNSET E_OpenconfigSystem_System_Aaa_Accounting_Events_Event_Config_Record = 0
	// OpenconfigSystem_System_Aaa_Accounting_Events_Event_Config_Record_START_STOP corresponds to the value START_STOP of OpenconfigSystem_System_Aaa_Accounting_Events_Event_Config_Record
	OpenconfigSystem_System_Aaa_Accounting_Events_Event_Config_Record_START_STOP E_OpenconfigSystem_System_Aaa_Accounting_Events_Event_Config_Record = 1
	// OpenconfigSystem_System_Aaa_Accounting_Events_Event_Config_Record_STOP corresponds to the value STOP of OpenconfigSystem_System_Aaa_Accounting_Events_Event_Config_Record
	OpenconfigSystem_System_Aaa_Accounting_Events_Event_Config_Record_STOP E_OpenconfigSystem_System_Aaa_Accounting_Events_Event_Config_Record = 2
)


// E_OpenconfigSystem_System_Cpus_Cpu_State_Index is a derived int64 type which is used to represent
// the enumerated node OpenconfigSystem_System_Cpus_Cpu_State_Index. An additional value named
// OpenconfigSystem_System_Cpus_Cpu_State_Index_UNSET is added to the enumeration which is used as
// the nil value, indicating that the enumeration was not explicitly set by
// the program importing the generated structures.
type E_OpenconfigSystem_System_Cpus_Cpu_State_Index int64

// IsYANGGoEnum ensures that OpenconfigSystem_System_Cpus_Cpu_State_Index implements the yang.GoEnum
// interface. This ensures that OpenconfigSystem_System_Cpus_Cpu_State_Index can be identified as a
// mapped type for a YANG enumeration.
func (E_OpenconfigSystem_System_Cpus_Cpu_State_Index) IsYANGGoEnum() {}

// ΛMap returns the value lookup map associated with  OpenconfigSystem_System_Cpus_Cpu_State_Index.
func (E_OpenconfigSystem_System_Cpus_Cpu_State_Index) ΛMap() map[string]map[int64]ygot.EnumDefinition { return ΛEnum; }

// String returns a logging-friendly string for E_OpenconfigSystem_System_Cpus_Cpu_State_Index.
func (e E_OpenconfigSystem_System_Cpus_Cpu_State_Index) String() string {
	return ygot.EnumLogString(e, int64(e), "E_OpenconfigSystem_System_Cpus_Cpu_State_Index")
}

const (
	// OpenconfigSystem_System_Cpus_Cpu_State_Index_UNSET corresponds to the value UNSET of OpenconfigSystem_System_Cpus_Cpu_State_Index
	OpenconfigSystem_System_Cpus_Cpu_State_Index_UNSET E_OpenconfigSystem_System_Cpus_Cpu_State_Index = 0
	// OpenconfigSystem_System_Cpus_Cpu_State_Index_ALL corresponds to the value ALL of OpenconfigSystem_System_Cpus_Cpu_State_Index
	OpenconfigSystem_System_Cpus_Cpu_State_Index_ALL E_OpenconfigSystem_System_Cpus_Cpu_State_Index = 1
)


// E_OpenconfigSystem_System_Ntp_Servers_Server_Config_AssociationType is a derived int64 type which is used to represent
// the enumerated node OpenconfigSystem_System_Ntp_Servers_Server_Config_AssociationType. An additional value named
// OpenconfigSystem_System_Ntp_Servers_Server_Config_AssociationType_UNSET is added to the enumeration which is used as
// the nil value, indicating that the enumeration was not explicitly set by
// the program importing the generated structures.
type E_OpenconfigSystem_System_Ntp_Servers_Server_Config_AssociationType int64

// IsYANGGoEnum ensures that OpenconfigSystem_System_Ntp_Servers_Server_Config_AssociationType implements the yang.GoEnum
// interface. This ensures that OpenconfigSystem_System_Ntp_Servers_Server_Config_AssociationType can be identified as a
// mapped type for a YANG enumeration.
func (E_OpenconfigSystem_System_Ntp_Servers_Server_Config_AssociationType) IsYANGGoEnum() {}

// ΛMap returns the value lookup map associated with  OpenconfigSystem_System_Ntp_Servers_Server_Config_AssociationType.
func (E_OpenconfigSystem_System_Ntp_Servers_Server_Config_AssociationType) ΛMap() map[string]map[int64]ygot.EnumDefinition { return ΛEnum; }

// String returns a logging-friendly string for E_OpenconfigSystem_System_Ntp_Servers_Server_Config_AssociationType.
func (e E_OpenconfigSystem_System_Ntp_Servers_Server_Config_AssociationType) String() string {
	return ygot.EnumLogString(e, int64(e), "E_OpenconfigSystem_System_Ntp_Servers_Server_Config_AssociationType")
}

const (
	// OpenconfigSystem_System_Ntp_Servers_Server_Config_AssociationType_UNSET corresponds to the value UNSET of OpenconfigSystem_System_Ntp_Servers_Server_Config_AssociationType
	OpenconfigSystem_System_Ntp_Servers_Server_Config_AssociationType_UNSET E_OpenconfigSystem_System_Ntp_Servers_Server_Config_AssociationType = 0
	// OpenconfigSystem_System_Ntp_Servers_Server_Config_AssociationType_SERVER corresponds to the value SERVER of OpenconfigSystem_System_Ntp_Servers_Server_Config_AssociationType
	OpenconfigSystem_System_Ntp_Servers_Server_Config_AssociationType_SERVER E_OpenconfigSystem_System_Ntp_Servers_Server_Config_AssociationType = 1
	// OpenconfigSystem_System_Ntp_Servers_Server_Config_AssociationType_PEER corresponds to the value PEER of OpenconfigSystem_System_Ntp_Servers_Server_Config_AssociationType
	OpenconfigSystem_System_Ntp_Servers_Server_Config_AssociationType_PEER E_OpenconfigSystem_System_Ntp_Servers_Server_Config_AssociationType = 2
	// OpenconfigSystem_System_Ntp_Servers_Server_Config_AssociationType_POOL corresponds to the value POOL of OpenconfigSystem_System_Ntp_Servers_Server_Config_AssociationType
	OpenconfigSystem_System_Ntp_Servers_Server_Config_AssociationType_POOL E_OpenconfigSystem_System_Ntp_Servers_Server_Config_AssociationType = 3
)


// E_OpenconfigSystem_System_SshServer_Config_ProtocolVersion is a derived int64 type which is used to represent
// the enumerated node OpenconfigSystem_System_SshServer_Config_ProtocolVersion. An additional value named
// OpenconfigSystem_System_SshServer_Config_ProtocolVersion_UNSET is added to the enumeration which is used as
// the nil value, indicating that the enumeration was not explicitly set by
// the program importing the generated structures.
type E_OpenconfigSystem_System_SshServer_Config_ProtocolVersion int64

// IsYANGGoEnum ensures that OpenconfigSystem_System_SshServer_Config_ProtocolVersion implements the yang.GoEnum
// interface. This ensures that OpenconfigSystem_System_SshServer_Config_ProtocolVersion can be identified as a
// mapped type for a YANG enumeration.
func (E_OpenconfigSystem_System_SshServer_Config_ProtocolVersion) IsYANGGoEnum() {}

// ΛMap returns the value lookup map associated with  OpenconfigSystem_System_SshServer_Config_ProtocolVersion.
func (E_OpenconfigSystem_System_SshServer_Config_ProtocolVersion) ΛMap() map[string]map[int64]ygot.EnumDefinition { return ΛEnum; }

// String returns a logging-friendly string for E_OpenconfigSystem_System_SshServer_Config_ProtocolVersion.
func (e E_OpenconfigSystem_System_SshServer_Config_ProtocolVersion) String() string {
	return ygot.EnumLogString(e, int64(e), "E_OpenconfigSystem_System_SshServer_Config_ProtocolVersion")
}

const (
	// OpenconfigSystem_System_SshServer_Config_ProtocolVersion_UNSET corresponds to the value UNSET of OpenconfigSystem_System_SshServer_Config_ProtocolVersion
	OpenconfigSystem_System_SshServer_Config_ProtocolVersion_UNSET E_OpenconfigSystem_System_SshServer_Config_ProtocolVersion = 0
	// OpenconfigSystem_System_SshServer_Config_ProtocolVersion_V2 corresponds to the value V2 of OpenconfigSystem_System_SshServer_Config_ProtocolVersion
	OpenconfigSystem_System_SshServer_Config_ProtocolVersion_V2 E_OpenconfigSystem_System_SshServer_Config_ProtocolVersion = 1
	// OpenconfigSystem_System_SshServer_Config_ProtocolVersion_V1 corresponds to the value V1 of OpenconfigSystem_System_SshServer_Config_ProtocolVersion
	OpenconfigSystem_System_SshServer_Config_ProtocolVersion_V1 E_OpenconfigSystem_System_SshServer_Config_ProtocolVersion = 2
	// OpenconfigSystem_System_SshServer_Config_ProtocolVersion_V1_V2 corresponds to the value V1_V2 of OpenconfigSystem_System_SshServer_Config_ProtocolVersion
	OpenconfigSystem_System_SshServer_Config_ProtocolVersion_V1_V2 E_OpenconfigSystem_System_SshServer_Config_ProtocolVersion = 3
)


// ΛEnum is a map, keyed by the name of the type defined for each enum in the
// generated Go code, which provides a mapping between the constant int64 value
// of each value of the enumeration, and the string that is used to represent it
// in the YANG schema. The map is named ΛEnum in order to avoid clash with any
// valid YANG identifier.
var ΛEnum = map[string]map[int64]ygot.EnumDefinition{
	"E_IETFInterfaces_InterfaceType": {
	},
	"E_OpenconfigAaaTypes_AAA_ACCOUNTING_EVENT_TYPE": {
		1: {Name: "AAA_ACCOUNTING_EVENT_COMMAND", DefiningModule: "openconfig-aaa-types"},
		2: {Name: "AAA_ACCOUNTING_EVENT_LOGIN", DefiningModule: "openconfig-aaa-types"},
	},
	"E_OpenconfigAaaTypes_AAA_AUTHORIZATION_EVENT_TYPE": {
		1: {Name: "AAA_AUTHORIZATION_EVENT_COMMAND", DefiningModule: "openconfig-aaa-types"},
		2: {Name: "AAA_AUTHORIZATION_EVENT_CONFIG", DefiningModule: "openconfig-aaa-types"},
	},
	"E_OpenconfigAaaTypes_AAA_METHOD_TYPE": {
		1: {Name: "LOCAL", DefiningModule: "openconfig-aaa-types"},
		2: {Name: "RADIUS_ALL", DefiningModule: "openconfig-aaa-types"},
		3: {Name: "TACACS_ALL", DefiningModule: "openconfig-aaa-types"},
	},
	"E_OpenconfigAaaTypes_AAA_SERVER_TYPE": {
		1: {Name: "RADIUS", DefiningModule: "openconfig-aaa"},
		2: {Name: "TACACS", DefiningModule: "openconfig-aaa"},
	},
	"E_OpenconfigAaaTypes_SYSTEM_DEFINED_ROLES": {
		1: {Name: "SYSTEM_ROLE_ADMIN", DefiningModule: "openconfig-aaa-types"},
	},
	"E_OpenconfigAlarmTypes_OPENCONFIG_ALARM_SEVERITY": {
		1: {Name: "CRITICAL", DefiningModule: "openconfig-alarm-types"},
		2: {Name: "MAJOR", DefiningModule: "openconfig-alarm-types"},
		3: {Name: "MINOR", DefiningModule: "openconfig-alarm-types"},
		4: {Name: "UNKNOWN", DefiningModule: "openconfig-alarm-types"},
		5: {Name: "WARNING", DefiningModule: "openconfig-alarm-types"},
	},
	"E_OpenconfigAlarmTypes_OPENCONFIG_ALARM_TYPE_ID": {
		1: {Name: "AIS", DefiningModule: "openconfig-alarm-types"},
		2: {Name: "EQPT", DefiningModule: "openconfig-alarm-types"},
		3: {Name: "LOS", DefiningModule: "openconfig-alarm-types"},
		4: {Name: "OTS", DefiningModule: "openconfig-alarm-types"},
	},
	"E_OpenconfigInterfaces_Interfaces_Interface_State_AdminStatus": {
		1: {Name: "UP"},
		2: {Name: "DOWN"},
		3: {Name: "TESTING"},
	},
	"E_OpenconfigInterfaces_Interfaces_Interface_State_OperStatus": {
		1: {Name: "UP"},
		2: {Name: "DOWN"},
		3: {Name: "TESTING"},
		4: {Name: "UNKNOWN"},
		5: {Name: "DORMANT"},
		6: {Name: "NOT_PRESENT"},
		7: {Name: "LOWER_LAYER_DOWN"},
	},
	"E_OpenconfigMessages_DEBUG_SERVICE": {
	},
	"E_OpenconfigMessages_SyslogSeverity": {
		1: {Name: "EMERGENCY"},
		2: {Name: "ALERT"},
		3: {Name: "CRITICAL"},
		4: {Name: "ERROR"},
		5: {Name: "WARNING"},
		6: {Name: "NOTICE"},
		7: {Name: "INFORMATIONAL"},
		8: {Name: "DEBUG"},
	},
	"E_OpenconfigOpenflow_FailureMode": {
		1: {Name: "SECURE"},
		2: {Name: "STANDALONE"},
	},
	"E_OpenconfigOpenflow_Transport": {
		1: {Name: "TCP"},
		2: {Name: "TLS"},
	},
	"E_OpenconfigPlatformTypes_COMPONENT_OPER_STATUS": {
		1: {Name: "ACTIVE", DefiningModule: "openconfig-platform-types"},
		2: {Name: "DISABLED", DefiningModule: "openconfig-platform-types"},
		3: {Name: "INACTIVE", DefiningModule: "openconfig-platform-types"},
	},
	"E_OpenconfigPlatformTypes_COMPONENT_REBOOT_REASON": {
		1: {Name: "REBOOT_CRITICAL_ERROR", DefiningModule: "openconfig-platform-types"},
		2: {Name: "REBOOT_POWER_FAILURE", DefiningModule: "openconfig-platform-types"},
		3: {Name: "REBOOT_USER_INITIATED", DefiningModule: "openconfig-platform-types"},
	},
	"E_OpenconfigPlatformTypes_ComponentRedundantRoleSwitchoverReasonTrigger": {
		1: {Name: "USER_INITIATED"},
		2: {Name: "SYSTEM_INITIATED"},
	},
	"E_OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT": {
		1: {Name: "BACKPLANE", DefiningModule: "openconfig-platform-types"},
		2: {Name: "CHASSIS", DefiningModule: "openconfig-platform-types"},
		3: {Name: "CONTROLLER_CARD", DefiningModule: "openconfig-platform-types"},
		4: {Name: "CPU", DefiningModule: "openconfig-platform-types"},
		5: {Name: "FABRIC", DefiningModule: "openconfig-platform-types"},
		6: {Name: "FAN", DefiningModule: "openconfig-platform-types"},
		7: {Name: "FRU", DefiningModule: "openconfig-platform-types"},
		8: {Name: "INTEGRATED_CIRCUIT", DefiningModule: "openconfig-platform-types"},
		9: {Name: "LINECARD", DefiningModule: "openconfig-platform-types"},
		10: {Name: "PORT", DefiningModule: "openconfig-platform-types"},
		11: {Name: "POWER_SUPPLY", DefiningModule: "openconfig-platform-types"},
		12: {Name: "SENSOR", DefiningModule: "openconfig-platform-types"},
		13: {Name: "STORAGE", DefiningModule: "openconfig-platform-types"},
		14: {Name: "TRANSCEIVER", DefiningModule: "openconfig-platform-types"},
	},
	"E_OpenconfigPlatformTypes_OPENCONFIG_SOFTWARE_COMPONENT": {
		1: {Name: "BIOS", DefiningModule: "openconfig-platform-types"},
		2: {Name: "BOOT_LOADER", DefiningModule: "openconfig-platform-types"},
		3: {Name: "OPERATING_SYSTEM", DefiningModule: "openconfig-platform-types"},
		4: {Name: "OPERATING_SYSTEM_UPDATE", DefiningModule: "openconfig-platform-types"},
		5: {Name: "SOFTWARE_MODULE", DefiningModule: "openconfig-platform-types"},
	},
	"E_OpenconfigPlatform_ComponentRedundantRole": {
		1: {Name: "PRIMARY"},
		2: {Name: "SECONDARY"},
	},
	"E_OpenconfigSystemLogging_SYSLOG_FACILITY": {
		1: {Name: "ALL", DefiningModule: "openconfig-system-logging"},
		2: {Name: "AUDIT", DefiningModule: "openconfig-system-logging"},
		3: {Name: "AUTH", DefiningModule: "openconfig-system-logging"},
		4: {Name: "AUTHPRIV", DefiningModule: "openconfig-system-logging"},
		5: {Name: "CONSOLE", DefiningModule: "openconfig-system-logging"},
		6: {Name: "KERNEL", DefiningModule: "openconfig-system-logging"},
		7: {Name: "LOCAL0", DefiningModule: "openconfig-system-logging"},
		8: {Name: "LOCAL1", DefiningModule: "openconfig-system-logging"},
		9: {Name: "LOCAL2", DefiningModule: "openconfig-system-logging"},
		10: {Name: "LOCAL3", DefiningModule: "openconfig-system-logging"},
		11: {Name: "LOCAL4", DefiningModule: "openconfig-system-logging"},
		12: {Name: "LOCAL5", DefiningModule: "openconfig-system-logging"},
		13: {Name: "LOCAL6", DefiningModule: "openconfig-system-logging"},
		14: {Name: "LOCAL7", DefiningModule: "openconfig-system-logging"},
		15: {Name: "MAIL", DefiningModule: "openconfig-system-logging"},
		16: {Name: "NTP", DefiningModule: "openconfig-system-logging"},
		17: {Name: "SYSLOG", DefiningModule: "openconfig-system-logging"},
		18: {Name: "SYSTEM_DAEMON", DefiningModule: "openconfig-system-logging"},
		19: {Name: "USER", DefiningModule: "openconfig-system-logging"},
	},
	"E_OpenconfigSystemLogging_SyslogSeverity": {
		1: {Name: "EMERGENCY"},
		2: {Name: "ALERT"},
		3: {Name: "CRITICAL"},
		4: {Name: "ERROR"},
		5: {Name: "WARNING"},
		6: {Name: "NOTICE"},
		7: {Name: "INFORMATIONAL"},
		8: {Name: "DEBUG"},
	},
	"E_OpenconfigSystem_NTP_AUTH_TYPE": {
		1: {Name: "NTP_AUTH_MD5", DefiningModule: "openconfig-system"},
	},
	"E_OpenconfigSystem_System_Aaa_Accounting_Events_Event_Config_Record": {
		1: {Name: "START_STOP"},
		2: {Name: "STOP"},
	},
	"E_OpenconfigSystem_System_Cpus_Cpu_State_Index": {
		1: {Name: "ALL"},
	},
	"E_OpenconfigSystem_System_Ntp_Servers_Server_Config_AssociationType": {
		1: {Name: "SERVER"},
		2: {Name: "PEER"},
		3: {Name: "POOL"},
	},
	"E_OpenconfigSystem_System_SshServer_Config_ProtocolVersion": {
		1: {Name: "V2"},
		2: {Name: "V1"},
		3: {Name: "V1_V2"},
	},
}


var (
	// ySchema is a byte slice contain a gzip compressed representation of the
	// YANG schema from which the Go code was generated. When uncompressed the
	// contents of the byte slice is a JSON document containing an object, keyed
	// on the name of the generated struct, and containing the JSON marshalled
	// contents of a goyang yang.Entry struct, which defines the schema for the
	// fields within the struct.
	ySchema = []byte{
		0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xec, 0xfd, 0x6d, 0x73, 0xda, 0x48,
		0xfa, 0x3e, 0x80, 0xbe, 0xcf, 0xa7, 0x50, 0x51, 0x5b, 0x75, 0xec, 0x2d, 0x2b, 0x36, 0xd8, 0xd8,
		0x71, 0xde, 0x4c, 0x11, 0x9b, 0xcc, 0xf8, 0x3f, 0xf1, 0xc3, 0xb1, 0x9d, 0xd9, 0x9d, 0x8d, 0x59,
		0x97, 0x2c, 0x1a, 0x5b, 0x27, 0x20, 0xf1, 0x93, 0x1a, 0x27, 0xde, 0x98, 0xef, 0x7e, 0x0a, 0x21,
		0x04, 0x18, 0x04, 0xea, 0xee, 0xbb, 0x85, 0x04, 0xd7, 0xd4, 0xd6, 0xc6, 0x71, 0xe8, 0x16, 0xea,
		0xbe, 0x1f, 0xae, 0xfb, 0xf9, 0xd7, 0x3b, 0xc3, 0x30, 0x8c, 0xd2, 0x85, 0xd5, 0x61, 0xa5, 0x8f,
		0x46, 0xa9, 0xc9, 0x9e, 0x1d, 0x9b, 0x95, 0x76, 0x86, 0xbf, 0xfd, 0xd3, 0x71, 0x9b, 0xa5, 0x8f,
		0x46, 0x39, 0xfa, 0xeb, 0x89, 0xe7, 0xb6, 0x9c, 0xc7, 0xd2, 0x47, 0x63, 0x2f, 0xfa, 0xc5, 0xa9,
		0xe3, 0x97, 0x3e, 0x1a, 0xc3, 0x2d, 0xc2, 0x5f, 0xd8, 0x5e, 0xa7, 0xeb, 0xb9, 0xcc, 0xe5, 0xc1,
		0xd4, 0xef, 0xa7, 0x1e, 0x31, 0xf1, 0x99, 0x9d, 0xe9, 0x4f, 0x4c, 0x3f, 0x2e, 0xfe, 0xf5, 0xdb,
		0xc7, 0xc6, 0xff, 0x70, 0xe5, 0xb3, 0x96, 0xf3, 0x73, 0xe6, 0x49, 0x53, 0x4f, 0xf3, 0x6c, 0xb3,
		0xdb, 0xb6, 0x78, 0xcb, 0xf3, 0x3b, 0x6f, 0x1e, 0x17, 0x7e, 0xec, 0xc6, 0xeb, 0xf9, 0x36, 0x9b,
		0xbb, 0xc5, 0xf0, 0x2b, 0xb1, 0x97, 0x1f, 0x9e, 0x3f, 0xf8, 0x56, 0xa5, 0xee, 0xf0, 0x69, 0x3b,
		0xf3, 0x3f, 0xf8, 0x87, 0x15, 0xd4, 0xfc, 0xc7, 0x5e, 0x87, 0xb9, 0xbc, 0xf4, 0xd1, 0xe0, 0x7e,
		0x8f, 0x25, 0x7c, 0x70, 0xe2, 0x53, 0x53, 0x5f, 0x6e, 0xe6, 0xd3, 0xfd, 0xa9, 0xdf, 0xf4, 0xdf,
		0xbc, 0xfb, 0xdb, 0xa3, 0x9f, 0xbd, 0x82, 0xe4, 0x97, 0x9a, 0xb9, 0x89, 0xa4, 0x97, 0x9a, 0x7f,
		0x21, 0x4b, 0x2f, 0x26, 0xcd, 0x05, 0x09, 0x5e, 0x54, 0xda, 0x0b, 0x13, 0xbe, 0x38, 0xe1, 0x0b,
		0x14, 0xbf, 0xc8, 0xf9, 0x17, 0x9a, 0x70, 0xb1, 0x4b, 0x2f, 0x38, 0xfe, 0xc0, 0x83, 0x65, 0x7f,
		0xef, 0xb6, 0x2d, 0x37, 0xc5, 0x61, 0x8c, 0xce, 0x78, 0xbc, 0x64, 0xc9, 0xbb, 0x2d, 0xbe, 0xf8,
		0xd4, 0x04, 0x20, 0x42, 0x08, 0x92, 0x04, 0x21, 0x4a, 0x18, 0xd2, 0x04, 0x22, 0x4d, 0x28, 0xf2,
		0x04, 0xb3, 0x98, 0x70, 0x96, 0x10, 0x50, 0x6a, 0x42, 0x9a, 0x90, 0x1c, 0xd1, 0x6d, 0xa6, 0x3c,
		0xc1, 0xb1, 0x18, 0x09, 0xd7, 0xa5, 0x3c, 0x85, 0x74, 0xa4, 0x25, 0x4c, 0x62, 0x32, 0xa4, 0xa6,
		0x48, 0x72, 0xb2, 0xa4, 0xa7, 0x4c, 0x82, 0xca, 0xa4, 0xa8, 0x4e, 0x92, 0xe9, 0x48, 0x33, 0x25,
		0x89, 0x8e, 0xbf, 0x8e, 0xeb, 0x7a, 0xdc, 0xe2, 0x8e, 0xe7, 0x8a, 0xdd, 0x5f, 0x60, 0x3f, 0xb1,
		0x8e, 0xd5, 0xb5, 0xf8, 0xd3, 0xe0, 0x45, 0x76, 0xbd, 0x2e, 0x73, 0x87, 0x44, 0x19, 0xbf, 0xd1,
		0xee, 0x18, 0x75, 0x8c, 0x7f, 0xdc, 0x8d, 0xe5, 0xe1, 0xae, 0x10, 0x0d, 0x0f, 0x9f, 0xc9, 0xfd,
		0x9e, 0xcd, 0xdd, 0x88, 0x72, 0x2e, 0xe3, 0x47, 0x5e, 0x45, 0x4f, 0xbc, 0x3f, 0x89, 0x9f, 0x38,
		0xfe, 0xf1, 0xfe, 0xd3, 0xe8, 0x89, 0xf7, 0x11, 0x61, 0xbf, 0xa3, 0x39, 0xe5, 0x14, 0x27, 0x5c,
		0x0a, 0xb8, 0xc5, 0x99, 0x38, 0x7b, 0x0f, 0x97, 0x69, 0xe6, 0xee, 0x0a, 0xb8, 0x1b, 0xdc, 0xad,
		0x8d, 0xbb, 0x45, 0x48, 0x98, 0x84, 0xb9, 0x6f, 0xc2, 0x07, 0x52, 0xf1, 0xb6, 0x92, 0xfa, 0x17,
		0x3c, 0x75, 0xf5, 0xd3, 0x2e, 0xa5, 0x12, 0x45, 0x4a, 0xe7, 0xbb, 0xf8, 0x64, 0x93, 0xcf, 0x6b,
		0xc1, 0x59, 0x95, 0xec, 0x27, 0x2b, 0x08, 0x9c, 0x20, 0x3d, 0x98, 0x1e, 0x2d, 0x00, 0x94, 0x06,
		0x94, 0x06, 0x94, 0x86, 0xb2, 0xdd, 0x6c, 0x65, 0x1b, 0x49, 0xc3, 0xcc, 0x80, 0xf4, 0xc9, 0xf0,
		0x79, 0x80, 0xd1, 0x80, 0xd1, 0xe0, 0xec, 0x4c, 0x38, 0x3b, 0x23, 0x10, 0x3d, 0x62, 0xec, 0x0d,
		0x84, 0xd0, 0xe9, 0x10, 0xa5, 0xfa, 0xd9, 0x6a, 0x81, 0xcf, 0xe9, 0x10, 0x8f, 0x18, 0xd2, 0x01,
		0x78, 0xde, 0x44, 0xf0, 0x1c, 0x51, 0xb5, 0xa0, 0x7e, 0x0d, 0x57, 0x89, 0xa9, 0xd7, 0x3d, 0x00,
		0x67, 0xa8, 0xd7, 0xb7, 0x5f, 0xe7, 0xf6, 0xa5, 0xcb, 0xe4, 0x6e, 0x2e, 0xe0, 0xbe, 0xe3, 0x0a,
		0x41, 0xdf, 0x91, 0x78, 0xfb, 0xb0, 0x59, 0x6a, 0x2e, 0xad, 0x89, 0x20, 0xab, 0xe5, 0x52, 0x98,
		0x04, 0x92, 0x4a, 0xae, 0xdb, 0x13, 0xd0, 0x70, 0xdd, 0x1e, 0xd4, 0x1b, 0xd4, 0x1b, 0x7c, 0x43,
		0x50, 0x71, 0x9b, 0x6e, 0x41, 0x76, 0x7b, 0xd9, 0xf9, 0x85, 0xba, 0x3d, 0xf8, 0x84, 0xe0, 0x13,
		0x02, 0x47, 0x6b, 0xe7, 0xe8, 0xac, 0xfc, 0x41, 0xdd, 0xde, 0x46, 0xfa, 0x82, 0x96, 0xa2, 0x47,
		0xb5, 0x33, 0xd5, 0x01, 0x8f, 0x5b, 0xd6, 0x83, 0xef, 0xd8, 0xe9, 0x11, 0x72, 0xf4, 0x79, 0x80,
		0x64, 0x80, 0x64, 0x80, 0x64, 0xa8, 0xd4, 0xcd, 0x56, 0xa9, 0x43, 0x61, 0x98, 0x19, 0x4e, 0xfe,
		0x1c, 0x3e, 0x0e, 0x50, 0x19, 0x50, 0x19, 0x7c, 0x9d, 0x05, 0x5f, 0x67, 0x84, 0x96, 0x23, 0xb6,
		0xde, 0x40, 0xc0, 0x9c, 0x0a, 0x4c, 0x2a, 0x9f, 0xac, 0x1e, 0xd8, 0xec, 0x8a, 0x60, 0x66, 0x17,
		0x80, 0x19, 0x80, 0x19, 0x80, 0x19, 0x8a, 0x75, 0xe3, 0x15, 0xab, 0x9b, 0x21, 0x5a, 0x76, 0x01,
		0x95, 0x01, 0x95, 0xc1, 0xd1, 0xda, 0x39, 0x3a, 0x33, 0x9c, 0xec, 0x6e, 0x26, 0x48, 0x76, 0x75,
		0x22, 0x64, 0x57, 0x07, 0x3c, 0x76, 0x5c, 0xce, 0x1e, 0x7d, 0x8b, 0xb3, 0xa6, 0x69, 0x3b, 0xbe,
		0xdd, 0x73, 0x78, 0x7a, 0xb4, 0x3c, 0x67, 0x2d, 0xc0, 0x33, 0xc0, 0x33, 0xc0, 0x33, 0x54, 0xed,
		0x66, 0xab, 0xda, 0x59, 0xc1, 0x98, 0x19, 0x96, 0x3e, 0x8b, 0x1f, 0x7d, 0x32, 0x7c, 0x32, 0x90,
		0x35, 0x90, 0x35, 0xd8, 0x3d, 0x6b, 0x76, 0xcf, 0x08, 0x68, 0xcf, 0x72, 0xfb, 0x06, 0xc2, 0x6e,
		0x61, 0x18, 0x4a, 0x79, 0xe0, 0x3a, 0x30, 0x79, 0xaa, 0x12, 0x0d, 0x91, 0xd2, 0x8c, 0x94, 0x25,
		0x19, 0xc0, 0xdd, 0x45, 0xc0, 0xdd, 0xa9, 0x4b, 0x28, 0xe2, 0x93, 0x6f, 0x33, 0xab, 0xe5, 0xb3,
		0x56, 0x9a, 0x53, 0x1f, 0xa9, 0xd5, 0xa3, 0x14, 0x9f, 0xbd, 0x8a, 0x38, 0xf5, 0xfd, 0xfb, 0x08,
		0xdd, 0xec, 0x86, 0xa4, 0xa8, 0x81, 0x21, 0xba, 0x9e, 0x2f, 0x60, 0x96, 0x86, 0x9f, 0x86, 0x21,
		0x0a, 0x43, 0x14, 0x86, 0x28, 0x90, 0xe9, 0x66, 0x23, 0xd3, 0x81, 0x28, 0xcc, 0xcc, 0xf4, 0xbc,
		0xf2, 0x7c, 0x58, 0x9b, 0xb0, 0x36, 0xc1, 0xd3, 0x19, 0xf0, 0x74, 0x46, 0xf6, 0x65, 0xc8, 0xd2,
		0x1b, 0x68, 0x52, 0xa6, 0x80, 0x90, 0x8a, 0xa7, 0xaa, 0x07, 0x26, 0xff, 0x60, 0xbe, 0x19, 0xf4,
		0xba, 0xdd, 0xf6, 0x8b, 0x08, 0x5c, 0x9e, 0x58, 0x05, 0xd8, 0x0c, 0xd8, 0x0c, 0xd8, 0x0c, 0x15,
		0xbb, 0xe9, 0x2a, 0x76, 0x2c, 0x12, 0x33, 0x84, 0xcf, 0x3f, 0x98, 0x7f, 0x13, 0x3e, 0x13, 0x28,
		0x1a, 0x28, 0x1a, 0x2c, 0x9e, 0x1d, 0x8b, 0x67, 0x86, 0xa6, 0xc7, 0x1c, 0xbe, 0x91, 0xa0, 0x3a,
		0x35, 0xd0, 0xa4, 0x39, 0x64, 0x2d, 0x18, 0xdb, 0xf7, 0xba, 0xcc, 0xe7, 0x0e, 0x13, 0xe8, 0x65,
		0x3c, 0xb1, 0x06, 0xf8, 0x1a, 0xf8, 0x3a, 0x81, 0xa4, 0x5e, 0xc4, 0xb5, 0x6f, 0xbc, 0x12, 0x18,
		0x1b, 0x0a, 0x58, 0x51, 0x01, 0xa7, 0x25, 0x57, 0x59, 0xb3, 0x50, 0xcd, 0x3c, 0x94, 0x24, 0x61,
		0x69, 0x52, 0x56, 0x21, 0x69, 0x22, 0xd2, 0x56, 0x25, 0x71, 0x32, 0x52, 0x27, 0x23, 0x79, 0x3a,
		0xd2, 0x17, 0x63, 0x01, 0x41, 0x56, 0x90, 0x66, 0x89, 0x78, 0xa1, 0x50, 0x8f, 0xcd, 0x44, 0xb2,
		0x11, 0xe8, 0xb9, 0x99, 0xc4, 0x26, 0x7b, 0x92, 0xcb, 0x65, 0xd9, 0x85, 0x82, 0x6d, 0x88, 0xd9,
		0x87, 0x8a, 0x8d, 0xc8, 0xd9, 0x89, 0x9c, 0xad, 0xe8, 0xd9, 0x4b, 0x8e, 0xcd, 0x24, 0xd9, 0x2d,
		0xfe, 0xfa, 0xc2, 0x3d, 0x42, 0x17, 0x78, 0x27, 0x04, 0x7b, 0x86, 0x26, 0xaa, 0x9b, 0x0f, 0xef,
		0xb2, 0x39, 0x37, 0x89, 0x33, 0x2b, 0x3d, 0x5b, 0xed, 0x1e, 0x81, 0xb8, 0x19, 0x6e, 0x03, 0x79,
		0x03, 0x79, 0x03, 0x79, 0x23, 0x49, 0x39, 0x3d, 0xd7, 0xf1, 0x5c, 0x0a, 0x71, 0x73, 0xac, 0xb0,
		0x47, 0xf4, 0x3a, 0xdf, 0x94, 0xee, 0x54, 0x8d, 0x66, 0x69, 0x85, 0x30, 0x91, 0x30, 0x56, 0x24,
		0x13, 0x0d, 0x27, 0xf3, 0xe0, 0x79, 0x6d, 0x66, 0xb9, 0x94, 0x47, 0x53, 0x5e, 0x93, 0xa3, 0x71,
		0x5c, 0x7e, 0x78, 0x40, 0x78, 0x30, 0x07, 0x04, 0x5b, 0x5d, 0x5b, 0xee, 0xa3, 0x3a, 0x67, 0xd1,
		0x1d, 0x56, 0xfc, 0xc5, 0xce, 0x1d, 0x57, 0x59, 0xcd, 0xcc, 0x6c, 0xfa, 0x57, 0x84, 0x2a, 0x8e,
		0x2b, 0x95, 0xfd, 0xfd, 0xa3, 0xca, 0xde, 0xfe, 0xe1, 0x87, 0xea, 0xc1, 0xd1, 0x51, 0xf5, 0xc3,
		0xde, 0x87, 0x1d, 0xda, 0x27, 0x7d, 0xf6, 0x2d, 0x9b, 0x3b, 0x9e, 0x7b, 0xea, 0x3c, 0x3a, 0xe1,
		0x68, 0xf3, 0x3d, 0xe2, 0x07, 0x5c, 0xb0, 0x47, 0x8b, 0x3b, 0xcf, 0x2c, 0xd2, 0x76, 0x64, 0x9b,
		0xf7, 0x77, 0x08, 0xef, 0xd0, 0xfa, 0x99, 0xe5, 0x1d, 0x1e, 0x15, 0xf8, 0x0e, 0x5b, 0x56, 0x3b,
		0x20, 0xbc, 0xc4, 0x77, 0xf9, 0xd8, 0xa5, 0xb1, 0x26, 0x92, 0xbb, 0x47, 0x2d, 0xba, 0x3f, 0x40,
		0x74, 0x4b, 0xb2, 0xfd, 0x1e, 0x98, 0xbc, 0x68, 0x92, 0xba, 0xfc, 0xe1, 0xe0, 0xe0, 0xf0, 0xe8,
		0xe0, 0x60, 0xef, 0x68, 0xff, 0x68, 0xef, 0xb8, 0x5a, 0x2d, 0x1f, 0x96, 0xab, 0xb8, 0x45, 0x88,
		0x6a, 0x2d, 0xa2, 0xba, 0xc9, 0x6c, 0xa7, 0x63, 0xb5, 0x49, 0xa5, 0x75, 0xb9, 0x42, 0xb0, 0xd7,
		0x0c, 0x89, 0x56, 0xa0, 0x03, 0x8a, 0x03, 0xdf, 0x2b, 0x80, 0xef, 0x85, 0x87, 0xef, 0x15, 0xe8,
		0x84, 0x4c, 0x75, 0xc2, 0xbb, 0x6c, 0x9f, 0xdb, 0xcf, 0x59, 0xa4, 0x55, 0x32, 0xfb, 0x2f, 0x5e,
		0x2f, 0x9d, 0x92, 0x16, 0x67, 0x66, 0x8d, 0x7e, 0x94, 0xc8, 0xf7, 0x1d, 0x7f, 0x0b, 0xb9, 0x84,
		0xb5, 0xf8, 0x3b, 0x8c, 0x7e, 0x14, 0xcb, 0xff, 0x15, 0xbf, 0x21, 0x81, 0xdb, 0x91, 0x0b, 0x65,
		0xab, 0x84, 0xb0, 0x25, 0x43, 0x49, 0xc8, 0xf0, 0x40, 0x86, 0x87, 0xb8, 0xdc, 0x91, 0x0e, 0xfd,
		0x48, 0xf4, 0x56, 0x48, 0x44, 0xcc, 0x12, 0xca, 0x5c, 0xaa, 0xf7, 0x42, 0x36, 0x02, 0x43, 0xac,
		0x90, 0x60, 0xe6, 0x3c, 0x45, 0x53, 0xb1, 0x0d, 0x8a, 0xa4, 0xb0, 0x0a, 0x44, 0x06, 0x44, 0x46,
		0xca, 0xaf, 0x29, 0x9d, 0x14, 0x36, 0xe4, 0xd3, 0x9e, 0x6f, 0x3d, 0xb4, 0x09, 0xb2, 0x35, 0xa6,
		0x76, 0x43, 0xd2, 0x06, 0x92, 0x36, 0x56, 0xc6, 0x6e, 0x6a, 0x36, 0xcc, 0xea, 0x93, 0x36, 0xd4,
		0xa3, 0xf0, 0x8a, 0xd1, 0xf7, 0x6c, 0xb2, 0xc4, 0x90, 0x93, 0x0a, 0x71, 0x03, 0x71, 0x83, 0x9c,
		0x54, 0xe4, 0xa4, 0x42, 0xde, 0x40, 0xde, 0x6c, 0x8e, 0xbc, 0x41, 0x4e, 0xaa, 0x0e, 0x21, 0x4c,
		0x24, 0x8c, 0x15, 0xc9, 0x44, 0xc3, 0xc9, 0x20, 0x27, 0x35, 0xf1, 0x68, 0x90, 0x93, 0x2a, 0xf0,
		0xc5, 0x90, 0x93, 0xba, 0x84, 0xa8, 0x10, 0xd4, 0x46, 0x4e, 0x2a, 0x2d, 0xd6, 0xa0, 0xdf, 0x05,
		0x39, 0xa9, 0x09, 0xa2, 0x1b, 0x39, 0xa9, 0xb2, 0x6c, 0x8f, 0x9c, 0xd4, 0xc2, 0x49, 0x6a, 0xe4,
		0xa4, 0x42, 0x54, 0x67, 0x26, 0xaa, 0x91, 0x93, 0x0a, 0xf8, 0x6e, 0xe4, 0xf2, 0xb2, 0x00, 0xdf,
		0x91, 0x93, 0xba, 0x51, 0x3a, 0x01, 0x39, 0xa9, 0xb9, 0xc9, 0x49, 0x95, 0xc9, 0x8a, 0x32, 0x68,
		0x53, 0x52, 0x05, 0x1a, 0x56, 0x8a, 0xdf, 0x0f, 0x6d, 0x2b, 0xb3, 0x3f, 0xd9, 0x8b, 0x60, 0xac,
		0xba, 0xf4, 0xc5, 0x09, 0x78, 0x8d, 0x73, 0xc1, 0x16, 0x68, 0xe7, 0x8e, 0x5b, 0x6f, 0xb3, 0xce,
		0xe0, 0xf4, 0xc4, 0x30, 0xeb, 0x40, 0x36, 0x4f, 0xac, 0x54, 0x43, 0xd8, 0xa5, 0x4b, 0xbf, 0xc9,
		0x7c, 0xd6, 0xfc, 0x34, 0x78, 0x6b, 0xb7, 0xd7, 0x6e, 0x17, 0xbb, 0x31, 0xeb, 0x2c, 0xf9, 0x67,
		0xd0, 0x99, 0x75, 0x96, 0xe0, 0x37, 0xac, 0x37, 0x6b, 0xda, 0x16, 0xa5, 0x24, 0x87, 0xac, 0xa3,
		0x31, 0x6b, 0xe0, 0xb5, 0xf8, 0x0f, 0xcb, 0x67, 0x66, 0xc7, 0x6b, 0xf6, 0xda, 0x02, 0xf3, 0xf3,
		0xde, 0x2e, 0x44, 0x8b, 0x56, 0xb4, 0x68, 0x7d, 0xfb, 0x41, 0x8c, 0x40, 0x40, 0x7b, 0xd6, 0xcd,
		0xea, 0x8f, 0xfe, 0x46, 0x2a, 0x66, 0x36, 0x05, 0xe1, 0x26, 0x7a, 0xee, 0x79, 0xf8, 0x58, 0x0c,
		0x42, 0xc0, 0x20, 0x04, 0x30, 0x7a, 0xa6, 0x8c, 0x9e, 0xd1, 0x2c, 0x84, 0x37, 0x7c, 0xbe, 0x81,
		0xe3, 0x10, 0xc4, 0x70, 0x27, 0xd9, 0x51, 0x6b, 0xc1, 0xde, 0xa9, 0x64, 0xa6, 0x90, 0xac, 0x14,
		0xc6, 0xd9, 0x15, 0xe0, 0xec, 0xe2, 0xe3, 0x6c, 0xab, 0xdd, 0xf6, 0xec, 0x70, 0x92, 0x7b, 0x38,
		0x2c, 0x44, 0x5c, 0x0d, 0xbf, 0xdd, 0x40, 0x4c, 0x21, 0xef, 0x01, 0x79, 0x43, 0x21, 0xbf, 0xfd,
		0x3a, 0xc2, 0xa9, 0xb8, 0x53, 0x69, 0x27, 0xfb, 0x15, 0x91, 0x4b, 0x8b, 0xe8, 0x50, 0x20, 0x94,
		0x22, 0x19, 0x42, 0x94, 0xf0, 0x67, 0xab, 0x84, 0x04, 0x55, 0xd3, 0x3f, 0xc8, 0x12, 0x04, 0xd4,
		0x83, 0x3e, 0x32, 0xd5, 0x10, 0x2a, 0x91, 0xb8, 0xf8, 0xe8, 0x0e, 0x2a, 0xc7, 0x07, 0xc7, 0x87,
		0x47, 0x95, 0xe3, 0x6a, 0xf1, 0xcf, 0x50, 0x53, 0x18, 0xa1, 0x91, 0xa1, 0x9d, 0xd8, 0x64, 0x81,
		0xed, 0x3b, 0x5d, 0x21, 0xa0, 0x3e, 0x91, 0xe5, 0x30, 0x5e, 0x0c, 0x15, 0x05, 0x15, 0xb5, 0x32,
		0x15, 0x25, 0x5c, 0x08, 0x21, 0x58, 0xf0, 0x40, 0xc3, 0x6b, 0xac, 0xd3, 0x95, 0x19, 0x8f, 0x35,
		0x5c, 0x96, 0x76, 0xfe, 0x11, 0x6b, 0x59, 0xbd, 0x36, 0x17, 0xd2, 0xa4, 0xa5, 0x50, 0xfc, 0xa5,
		0xbb, 0xf5, 0x06, 0xf8, 0x1c, 0x7c, 0xbe, 0x32, 0x3e, 0x17, 0x2f, 0xeb, 0x11, 0x2c, 0xdf, 0x21,
		0x62, 0xf4, 0xff, 0xeb, 0x39, 0xdd, 0xc1, 0x81, 0x9b, 0x2d, 0xcb, 0x69, 0xf7, 0x7c, 0x09, 0x47,
		0xec, 0xec, 0x16, 0x10, 0x00, 0x94, 0x02, 0xc0, 0x6a, 0x5b, 0x7e, 0x27, 0xd8, 0x48, 0xf6, 0x8f,
		0x5e, 0x1d, 0xcc, 0xaf, 0x9b, 0xf9, 0x3b, 0x4e, 0xd0, 0xb1, 0xb8, 0xfd, 0xa4, 0xc2, 0xfd, 0xf1,
		0x1e, 0x60, 0x7f, 0xb0, 0x3f, 0xd8, 0x3f, 0xff, 0xec, 0xdf, 0x72, 0xfc, 0x4e, 0x18, 0x0f, 0x79,
		0x66, 0x7e, 0x20, 0x65, 0x55, 0xcf, 0xec, 0x00, 0xc8, 0x0d, 0xc8, 0x0d, 0xd3, 0x7a, 0xe1, 0x33,
		0x9f, 0x2c, 0xbf, 0xa9, 0xc6, 0x75, 0x33, 0x3b, 0x80, 0xeb, 0xc0, 0x75, 0xe0, 0xba, 0x85, 0xcf,
		0x74, 0x9a, 0xe2, 0x7c, 0xe6, 0x34, 0xc1, 0x59, 0xe0, 0x2c, 0x70, 0xd6, 0xe2, 0x67, 0xb6, 0xad,
		0x80, 0x9b, 0x3e, 0x7b, 0xf0, 0xbc, 0xc1, 0x1f, 0x56, 0x20, 0xa3, 0xd1, 0xe6, 0xec, 0x01, 0xce,
		0x03, 0xe7, 0xad, 0x8c, 0xf3, 0x9c, 0x26, 0x73, 0xb9, 0xc3, 0x5f, 0xc4, 0xfa, 0x8c, 0xc7, 0xec,
		0x27, 0x52, 0x4a, 0x74, 0x16, 0x3d, 0xea, 0x93, 0x15, 0x28, 0x34, 0xf1, 0x3e, 0xb9, 0x3c, 0xbf,
		0xba, 0xbc, 0xa8, 0x5f, 0xdc, 0xde, 0x5f, 0xd7, 0x3f, 0x5d, 0x5e, 0x0e, 0xfe, 0xa8, 0xdd, 0x5c,
		0x5e, 0x88, 0x52, 0x40, 0x18, 0xf9, 0x0e, 0xa4, 0xca, 0xa3, 0x15, 0xfb, 0x0e, 0x46, 0x5f, 0xfb,
		0xeb, 0x4d, 0xfd, 0xfa, 0xfe, 0xec, 0xe2, 0xec, 0xf6, 0xac, 0x76, 0x5b, 0x3f, 0x2d, 0x65, 0x91,
		0x2b, 0x40, 0xf3, 0xc5, 0xaf, 0x2e, 0xff, 0x55, 0xbf, 0xbe, 0xff, 0x5c, 0x3b, 0xfb, 0xf2, 0xf5,
		0xba, 0x5e, 0xa0, 0xef, 0x7d, 0x72, 0x7d, 0x76, 0x7b, 0x76, 0x52, 0xfb, 0x72, 0x5f, 0xbf, 0xbe,
		0xbe, 0xbc, 0xd6, 0xdd, 0xfa, 0xbb, 0x41, 0x2d, 0x09, 0xc8, 0x35, 0x18, 0x77, 0x3a, 0x4c, 0x4d,
		0x7f, 0x85, 0x3b, 0x40, 0x7b, 0x41, 0x7b, 0xad, 0x4c, 0x7b, 0x0d, 0x28, 0x90, 0x3b, 0xf6, 0xf7,
		0x40, 0xa8, 0xa7, 0x87, 0x44, 0xa7, 0xa5, 0xd2, 0x57, 0x77, 0x98, 0xd7, 0x54, 0x72, 0x2d, 0xd7,
		0x0b, 0x98, 0xed, 0xb9, 0x4d, 0x21, 0x4f, 0x35, 0x52, 0xe9, 0xc4, 0x64, 0x77, 0x61, 0x53, 0xe9,
		0xe8, 0x3a, 0x1a, 0x21, 0xa9, 0x8e, 0x5e, 0xf7, 0x05, 0x3f, 0x1c, 0x6e, 0x3f, 0x79, 0xcf, 0xcc,
		0x57, 0xb3, 0xe0, 0x66, 0xf7, 0x41, 0x1d, 0x26, 0xf4, 0xa0, 0xa2, 0x1e, 0x14, 0x1d, 0xff, 0x52,
		0x6a, 0x32, 0x6e, 0x39, 0xed, 0x40, 0xde, 0x98, 0x1a, 0x6d, 0xb0, 0x59, 0x63, 0xd4, 0x4c, 0xfe,
		0xd2, 0x65, 0x01, 0x26, 0x23, 0x2d, 0x60, 0x81, 0xe8, 0x88, 0xd6, 0x6e, 0xa4, 0x9a, 0x74, 0x73,
		0x6e, 0xc9, 0x66, 0xdc, 0x7a, 0xe6, 0xa0, 0x71, 0xdf, 0x79, 0x7c, 0x64, 0xbe, 0x3c, 0xdf, 0x8f,
		0x36, 0x00, 0xdf, 0x83, 0xef, 0x37, 0x82, 0xef, 0xe3, 0xd2, 0x58, 0xd3, 0x67, 0xcd, 0x9e, 0xdb,
		0xb4, 0x06, 0x3f, 0x79, 0x6d, 0x36, 0x0b, 0xe4, 0x4c, 0x39, 0xde, 0x98, 0x92, 0x11, 0x12, 0xdd,
		0xd7, 0x4b, 0x75, 0xb7, 0xd7, 0x19, 0xbc, 0x63, 0xbf, 0x10, 0x6d, 0xb0, 0x32, 0xaf, 0x24, 0xe7,
		0x16, 0x67, 0xbb, 0x4a, 0xd0, 0xdb, 0x50, 0xa8, 0x72, 0x1e, 0x3c, 0xfd, 0xfe, 0x8b, 0x15, 0xf0,
		0x9b, 0xf8, 0xe1, 0xd7, 0xc3, 0x67, 0xaf, 0xd0, 0x80, 0x51, 0x70, 0xe0, 0xbd, 0xdd, 0x05, 0x4e,
		0x3c, 0x18, 0x2f, 0x70, 0xe2, 0xc1, 0x89, 0x07, 0x27, 0x1e, 0x9c, 0x78, 0xf9, 0x76, 0xe2, 0x79,
		0xb6, 0x25, 0x57, 0x16, 0x1b, 0xaf, 0x84, 0xae, 0x83, 0xae, 0x5b, 0x99, 0xae, 0x2b, 0x46, 0xa2,
		0x53, 0x87, 0x75, 0x3c, 0x5f, 0xa2, 0x28, 0x36, 0x5a, 0x07, 0x57, 0x38, 0x38, 0x2c, 0x6b, 0x57,
		0xb8, 0xf5, 0x6c, 0x39, 0x6d, 0xa9, 0xf1, 0xe7, 0xe3, 0xfe, 0x3e, 0xf1, 0x16, 0x9b, 0xe5, 0x16,
		0x83, 0x43, 0x8c, 0x74, 0xa8, 0x67, 0xde, 0x5d, 0x61, 0xd2, 0x03, 0xab, 0x14, 0x06, 0x54, 0x29,
		0x0e, 0x23, 0x51, 0x18, 0x55, 0x4a, 0x31, 0x6c, 0x84, 0x6a, 0xc0, 0x14, 0xf9, 0x28, 0x22, 0xba,
		0x31, 0x13, 0x0a, 0xb3, 0x41, 0x48, 0x66, 0x81, 0x68, 0x1c, 0x08, 0x95, 0xe7, 0x53, 0xcf, 0x68,
		0x98, 0x45, 0x23, 0x07, 0x31, 0xab, 0x1e, 0x77, 0xda, 0xce, 0xff, 0x58, 0x53, 0x5e, 0x3f, 0xc7,
		0x3b, 0x40, 0x3d, 0x43, 0x3d, 0x43, 0x3d, 0x43, 0x3d, 0x43, 0x3d, 0x43, 0x3d, 0x43, 0x3d, 0x67,
		0x65, 0x92, 0xaf, 0x26, 0xe4, 0x2b, 0xe4, 0x52, 0x32, 0x54, 0x43, 0xbc, 0xe7, 0xc3, 0xa7, 0x65,
		0xe9, 0x6a, 0x6b, 0x3d, 0x9a, 0x4d, 0xa9, 0xa9, 0x00, 0xf1, 0x4a, 0x38, 0xb4, 0xe1, 0x6e, 0x53,
		0xe4, 0x6d, 0x79, 0x87, 0x76, 0x53, 0xb0, 0xa3, 0x7f, 0xec, 0xce, 0x16, 0x58, 0x73, 0x65, 0x71,
		0xce, 0x7c, 0x57, 0x18, 0x9f, 0x94, 0xbe, 0xed, 0x99, 0xc7, 0x8d, 0x5f, 0x07, 0xfd, 0xbb, 0x3b,
		0x73, 0x6b, 0xef, 0x5b, 0xd9, 0x3c, 0x6e, 0xbc, 0x96, 0xbf, 0xed, 0x99, 0x95, 0xc6, 0xf6, 0xc4,
		0x6f, 0xbe, 0x95, 0x2b, 0x8d, 0xf0, 0x83, 0xaf, 0xfb, 0xdf, 0xf6, 0xca, 0x8d, 0xed, 0xf4, 0x77,
		0xd0, 0x10, 0x79, 0x87, 0xcb, 0x9b, 0xb3, 0x7f, 0x4b, 0xbf, 0xc8, 0x7f, 0xb7, 0xa4, 0x5e, 0x65,
		0xfb, 0x1f, 0xa5, 0x5c, 0x46, 0xf1, 0x06, 0xa2, 0x2b, 0x12, 0xd0, 0x12, 0x42, 0x4f, 0x64, 0xf6,
		0x1e, 0x84, 0x1e, 0x84, 0x1e, 0xbd, 0xd0, 0x2b, 0x46, 0x14, 0x4f, 0x8e, 0xc3, 0xc0, 0x5d, 0xe0,
		0x2e, 0x70, 0xd7, 0x72, 0xee, 0xf2, 0xba, 0xcc, 0x37, 0x07, 0x36, 0x4a, 0x2f, 0x10, 0x67, 0xb2,
		0xc9, 0xc5, 0xe0, 0x35, 0xf0, 0xda, 0xca, 0x78, 0xad, 0xc0, 0xed, 0x3f, 0x2e, 0xaf, 0xea, 0xd7,
		0xf7, 0x37, 0xb7, 0xb5, 0xdb, 0xaf, 0x37, 0xc5, 0x69, 0xfe, 0x71, 0x7a, 0x76, 0x53, 0xfb, 0xf4,
		0xa5, 0x18, 0xfd, 0x3e, 0x6a, 0x27, 0xb7, 0x67, 0x7f, 0x15, 0xa2, 0xc3, 0xc7, 0xd9, 0x85, 0xf4,
		0x77, 0x5d, 0x83, 0xa6, 0x1e, 0x5d, 0xcb, 0x1f, 0x8a, 0x22, 0x41, 0x25, 0x14, 0xad, 0x83, 0xfe,
		0x81, 0xfe, 0x59, 0x99, 0xfe, 0x69, 0x33, 0xab, 0x25, 0xa9, 0x7b, 0x8e, 0xc4, 0x3c, 0x48, 0xa1,
		0xf7, 0xf9, 0xfd, 0xfb, 0xdd, 0xe1, 0xff, 0xc6, 0x6e, 0xe6, 0xa1, 0x73, 0x78, 0x37, 0x34, 0x7b,
		0xb2, 0x65, 0x5a, 0x6e, 0xba, 0x9e, 0x14, 0xd7, 0x86, 0x0b, 0xc1, 0xb6, 0x60, 0x5b, 0x98, 0x68,
		0x8b, 0x79, 0xcc, 0x76, 0x24, 0x1c, 0x20, 0xe1, 0x2a, 0xa4, 0x30, 0x83, 0xbb, 0x14, 0xb9, 0x4b,
		0x38, 0x85, 0xd9, 0xf6, 0x7c, 0x9f, 0xd9, 0xdc, 0x7a, 0x68, 0x33, 0x93, 0xf9, 0xbe, 0xe7, 0x2b,
		0x34, 0xf6, 0x98, 0xb3, 0x97, 0x5c, 0xd6, 0x54, 0x19, 0x59, 0x53, 0x99, 0xb1, 0x00, 0x19, 0x2b,
		0xd0, 0xb1, 0x84, 0x9c, 0x9d, 0x24, 0x9a, 0x35, 0x25, 0xca, 0x2a, 0xf1, 0x42, 0xab, 0xf9, 0xec,
		0x04, 0x9e, 0xff, 0x62, 0xba, 0x9e, 0x6b, 0xb6, 0x2c, 0x6e, 0xb5, 0x65, 0x39, 0x67, 0x86, 0x96,
		0x92, 0xb7, 0x96, 0xbc, 0x0b, 0xb9, 0x34, 0x44, 0x65, 0xc6, 0xa2, 0x60, 0x30, 0x62, 0x46, 0xa3,
		0x62, 0x38, 0x72, 0xc6, 0x23, 0x67, 0x40, 0x7a, 0x46, 0x94, 0x63, 0x48, 0x05, 0xd7, 0x8c, 0xa1,
		0x94, 0xd6, 0x38, 0x47, 0x31, 0xf5, 0x5c, 0xce, 0x7c, 0xa9, 0x0c, 0xc7, 0xb7, 0xac, 0xf4, 0x41,
		0x61, 0x0b, 0xb5, 0x8c, 0x47, 0x35, 0xbf, 0xd5, 0xd4, 0x17, 0xa1, 0xc8, 0x80, 0x9c, 0x76, 0x6c,
		0xaa, 0xa7, 0xd0, 0xc5, 0xfb, 0x51, 0xe7, 0xe6, 0x8d, 0xc9, 0x81, 0x2a, 0x47, 0x4f, 0x91, 0xb2,
		0xa7, 0xaf, 0x82, 0x20, 0x53, 0x72, 0xe6, 0x2a, 0xe8, 0x33, 0x26, 0x8b, 0x78, 0x3b, 0xef, 0x56,
		0xb3, 0xba, 0x91, 0x51, 0x06, 0xa7, 0x4c, 0xa3, 0x82, 0x07, 0xab, 0x69, 0x36, 0xdb, 0xed, 0x2e,
		0x19, 0x62, 0x79, 0xbb, 0x21, 0x70, 0x0a, 0x70, 0x0a, 0x70, 0x0a, 0x70, 0x0a, 0x70, 0x0a, 0x70,
		0x0a, 0x70, 0x0a, 0x70, 0x8a, 0x02, 0x4e, 0xe1, 0xc4, 0x30, 0x85, 0x03, 0xa5, 0x00, 0xa5, 0x00,
		0xa5, 0x00, 0xa5, 0x00, 0xa5, 0x00, 0xa5, 0x00, 0xa5, 0x00, 0xa5, 0x28, 0xa3, 0x94, 0xa7, 0xa6,
		0x6f, 0xb6, 0xbd, 0x47, 0xd3, 0x7b, 0x66, 0x7e, 0xab, 0xed, 0xfd, 0x20, 0x83, 0x2b, 0x49, 0x1b,
		0x03, 0xb7, 0x00, 0xb7, 0x00, 0xb7, 0x00, 0xb7, 0x00, 0xb7, 0x00, 0xb7, 0x00, 0xb7, 0x00, 0xb7,
		0x48, 0xe2, 0x16, 0x67, 0x20, 0x07, 0x5d, 0xc2, 0xbc, 0x95, 0xb7, 0x1b, 0x02, 0xa7, 0x00, 0xa7,
		0x00, 0xa7, 0x00, 0xa7, 0x00, 0xa7, 0x00, 0xa7, 0x00, 0xa7, 0x00, 0xa7, 0x48, 0xe2, 0x14, 0x9f,
		0xd9, 0xcc, 0x79, 0x66, 0x3e, 0x19, 0x4e, 0x79, 0xbb, 0x21, 0x70, 0x0a, 0x70, 0x0a, 0x70, 0x0a,
		0x70, 0x0a, 0x70, 0x0a, 0x70, 0x0a, 0x70, 0x0a, 0x70, 0x8a, 0x34, 0x4e, 0x69, 0x5b, 0x2f, 0xa6,
		0xef, 0xb5, 0xdb, 0x1e, 0x2d, 0x5a, 0x99, 0xb7, 0x2d, 0x30, 0x0b, 0x30, 0x0b, 0x30, 0x0b, 0x30,
		0x0b, 0x30, 0x0b, 0x30, 0x0b, 0x30, 0x0b, 0x30, 0x8b, 0x34, 0x66, 0xe9, 0x0e, 0xd0, 0x05, 0x77,
		0x3a, 0xcc, 0xeb, 0x71, 0x42, 0xcc, 0x32, 0x6f, 0x5b, 0x60, 0x16, 0x60, 0x16, 0x60, 0x16, 0x60,
		0x16, 0x60, 0x16, 0x60, 0x16, 0x60, 0x16, 0x60, 0x16, 0x49, 0xcc, 0xc2, 0x3d, 0xca, 0x66, 0x2b,
		0x53, 0xbb, 0x01, 0xa1, 0x00, 0xa1, 0x00, 0xa1, 0x00, 0xa1, 0x00, 0xa1, 0x00, 0xa1, 0x00, 0xa1,
		0x00, 0xa1, 0x68, 0x6f, 0x3f, 0x27, 0x39, 0xd9, 0x2e, 0x5e, 0xaf, 0x36, 0xe1, 0xae, 0x6b, 0x3b,
		0x6c, 0x57, 0xb9, 0x5f, 0xa3, 0xa1, 0x3a, 0xfa, 0xee, 0xca, 0x76, 0xd8, 0xfd, 0xc9, 0xf8, 0x6b,
		0xd4, 0x87, 0xdf, 0x22, 0x07, 0x93, 0x83, 0x95, 0xfa, 0xfa, 0xc5, 0x8a, 0x51, 0xa1, 0x85, 0x1f,
		0x7a, 0x61, 0xae, 0x0e, 0x32, 0xa2, 0x17, 0x66, 0xda, 0x85, 0x96, 0x1d, 0x98, 0xcf, 0x8e, 0xd7,
		0x0e, 0x05, 0x19, 0x5d, 0x1b, 0xcc, 0x79, 0xbb, 0xc2, 0x42, 0x83, 0x85, 0x06, 0x0b, 0x0d, 0x16,
		0x1a, 0x2c, 0x34, 0x58, 0x68, 0xb0, 0xd0, 0x60, 0xa1, 0x49, 0xfa, 0x90, 0x2d, 0xee, 0x75, 0x1c,
		0xdb, 0xf4, 0xba, 0xe6, 0x43, 0xdb, 0xb3, 0xbf, 0xb3, 0x26, 0x1d, 0x6a, 0x49, 0xda, 0x19, 0xc8,
		0x05, 0xc8, 0x05, 0xc8, 0x05, 0xc8, 0x05, 0xc8, 0x05, 0xc8, 0x05, 0xc8, 0x05, 0xc8, 0x45, 0xb6,
		0x27, 0x66, 0x84, 0x2a, 0x48, 0xfb, 0x62, 0xce, 0xee, 0x09, 0xb4, 0x02, 0xb4, 0x02, 0xb4, 0x02,
		0xb4, 0x02, 0xb4, 0x02, 0xb4, 0x02, 0xb4, 0x02, 0xb4, 0x22, 0x89, 0x56, 0x6c, 0xaf, 0xd3, 0x6d,
		0xb3, 0x30, 0x80, 0x63, 0x3d, 0x78, 0x3e, 0x5d, 0x85, 0x41, 0xd2, 0xc6, 0xc0, 0x2d, 0xc0, 0x2d,
		0xc0, 0x2d, 0xc0, 0x2d, 0xc0, 0x2d, 0xc0, 0x2d, 0xc0, 0x2d, 0xc0, 0x2d, 0xea, 0xb8, 0x85, 0xba,
		0x36, 0x32, 0x79, 0x6b, 0x60, 0x17, 0x60, 0x17, 0x60, 0x17, 0x60, 0x17, 0x60, 0x17, 0x60, 0x17,
		0x60, 0x17, 0x60, 0x17, 0x49, 0xec, 0xd2, 0xb4, 0xb8, 0x65, 0xb6, 0x1d, 0xf7, 0x3b, 0x19, 0x64,
		0x99, 0xd9, 0x11, 0x48, 0x05, 0x48, 0x05, 0x48, 0x05, 0x48, 0x05, 0x48, 0x05, 0x48, 0x05, 0x48,
		0x05, 0x48, 0x45, 0x12, 0xa9, 0x30, 0xdb, 0xb7, 0xc9, 0x40, 0xca, 0xe4, 0x66, 0xc0, 0x27, 0xc0,
		0x27, 0xc0, 0x27, 0xc0, 0x27, 0xc0, 0x27, 0xc0, 0x27, 0xc0, 0x27, 0xc0, 0x27, 0x92, 0xf8, 0x24,
		0x1c, 0xba, 0x6a, 0x7b, 0x2e, 0xf7, 0xbd, 0xb6, 0xd9, 0xf5, 0x3d, 0xee, 0xd9, 0x1e, 0x5d, 0xe7,
		0xa9, 0x85, 0xbb, 0x03, 0xc1, 0x00, 0xc1, 0x00, 0xc1, 0x00, 0xc1, 0x00, 0xc1, 0x00, 0xc1, 0x00,
		0xc1, 0x00, 0xc1, 0x60, 0xc6, 0x2b, 0x70, 0x0a, 0x70, 0x0a, 0x70, 0x0a, 0x70, 0x0a, 0x70, 0x0a,
		0x70, 0x0a, 0x70, 0xca, 0x9a, 0xe1, 0x94, 0x8e, 0xd5, 0x1e, 0xa8, 0x00, 0xe2, 0xba, 0xe6, 0xb9,
		0xbb, 0x02, 0xb1, 0x00, 0xb1, 0x00, 0xb1, 0x00, 0xb1, 0x00, 0xb1, 0x00, 0xb1, 0x00, 0xb1, 0x00,
		0xb1, 0x48, 0x22, 0x96, 0xae, 0xe7, 0x04, 0x9e, 0x4b, 0x0c, 0x58, 0xe6, 0x6d, 0x0a, 0xbc, 0x02,
		0xbc, 0x02, 0xbc, 0x02, 0xbc, 0x02, 0xbc, 0x02, 0xbc, 0x02, 0xbc, 0x02, 0xbc, 0x22, 0x3d, 0xe9,
		0xd5, 0x66, 0xce, 0x33, 0xf3, 0x4d, 0xef, 0x99, 0xf9, 0x61, 0xea, 0x09, 0xdd, 0xb0, 0xd7, 0x84,
		0x9d, 0x81, 0x5c, 0x80, 0x5c, 0x80, 0x5c, 0x80, 0x5c, 0x80, 0x5c, 0x80, 0x5c, 0x80, 0x5c, 0x80,
		0x5c, 0x24, 0x91, 0x4b, 0xd0, 0xf3, 0xbb, 0xbe, 0x13, 0x30, 0xb3, 0xe9, 0xfd, 0xa0, 0x9b, 0x2e,
		0x34, 0x77, 0x57, 0x20, 0x16, 0x20, 0x16, 0x20, 0x16, 0x20, 0x16, 0x20, 0x16, 0x20, 0x16, 0x20,
		0x16, 0x20, 0x16, 0xd9, 0x09, 0xf5, 0xed, 0xae, 0x39, 0xd4, 0x56, 0xe4, 0xe3, 0x85, 0x92, 0xb7,
		0x06, 0x76, 0x01, 0x76, 0x01, 0x76, 0x01, 0x76, 0x01, 0x76, 0x01, 0x76, 0x01, 0x76, 0x01, 0x76,
		0x91, 0xc5, 0x2e, 0x1e, 0x27, 0x2c, 0x17, 0x9a, 0xda, 0x0d, 0x08, 0x05, 0x08, 0x05, 0x08, 0x05,
		0x08, 0x05, 0x08, 0x05, 0x08, 0x05, 0x08, 0x05, 0x08, 0x45, 0x12, 0xa1, 0xf4, 0xdc, 0x26, 0x6b,
		0x39, 0x2e, 0xa1, 0x53, 0x65, 0x66, 0x47, 0x20, 0x15, 0x20, 0x15, 0x20, 0x15, 0x20, 0x15, 0x20,
		0x15, 0x20, 0x15, 0x20, 0x15, 0x20, 0x15, 0x69, 0xa4, 0xc2, 0x7e, 0x76, 0x99, 0xcd, 0x59, 0xd3,
		0x9c, 0x98, 0xfa, 0x43, 0x87, 0x5a, 0x16, 0xec, 0x0e, 0x04, 0x03, 0x04, 0x03, 0x04, 0x03, 0x04,
		0x03, 0x04, 0x03, 0x04, 0x03, 0x04, 0x03, 0x04, 0x23, 0x8d, 0x60, 0x82, 0x5e, 0xb7, 0xeb, 0xf9,
		0x03, 0x90, 0xe1, 0xb3, 0xff, 0xeb, 0xb1, 0x80, 0x13, 0xe2, 0x97, 0xc4, 0xbd, 0x81, 0x5e, 0x80,
		0x5e, 0x80, 0x5e, 0x80, 0x5e, 0x80, 0x5e, 0x80, 0x5e, 0x80, 0x5e, 0x80, 0x5e, 0x84, 0x57, 0x08,
		0xd2, 0x6a, 0xa9, 0xe6, 0xba, 0x1e, 0xb7, 0x06, 0x37, 0x2d, 0x45, 0x9e, 0xa5, 0xc0, 0x7e, 0x62,
		0x1d, 0xab, 0x6b, 0xf1, 0xa7, 0x81, 0x04, 0xde, 0xf5, 0xba, 0xcc, 0xb5, 0x43, 0x34, 0x11, 0xeb,
		0xa1, 0x5d, 0xdb, 0xeb, 0x74, 0x3d, 0x97, 0xb9, 0x3c, 0x18, 0xff, 0xb8, 0x1b, 0x70, 0x8b, 0xb3,
		0xdd, 0xae, 0xed, 0xb0, 0xdd, 0x96, 0xa5, 0x94, 0x2a, 0x53, 0x0a, 0xb8, 0xdf, 0xb3, 0xb9, 0x1b,
		0x29, 0x81, 0xcb, 0xf8, 0x1b, 0x5c, 0x45, 0x5f, 0xe0, 0xfe, 0x24, 0xfe, 0x02, 0xe3, 0x1f, 0xef,
		0x6f, 0x06, 0x5f, 0xe0, 0xfe, 0xca, 0x76, 0xd8, 0xfd, 0xe7, 0xc1, 0x17, 0xa8, 0x0f, 0x9f, 0xff,
		0x4e, 0xcf, 0xd5, 0x08, 0x5c, 0x4b, 0xc9, 0xf5, 0x5c, 0x73, 0xea, 0x4c, 0x44, 0x2f, 0x26, 0x56,
		0x88, 0x33, 0x3b, 0x09, 0x12, 0x47, 0xa4, 0x0b, 0xcb, 0x82, 0xcb, 0x64, 0xe1, 0xa4, 0x0a, 0x8c,
		0x24, 0x82, 0x8f, 0xaa, 0xb0, 0x91, 0x0c, 0x2e, 0x92, 0xc1, 0x44, 0x3a, 0x78, 0xa8, 0x57, 0x10,
		0x9d, 0x3a, 0xbe, 0xdc, 0xc5, 0x5b, 0x76, 0x60, 0x3e, 0x3b, 0x5e, 0xdb, 0x22, 0xf5, 0x31, 0xcf,
		0xdd, 0x15, 0xd6, 0x19, 0xac, 0x33, 0x58, 0x67, 0xb0, 0xce, 0x60, 0x9d, 0xc1, 0x3a, 0x83, 0x75,
		0x06, 0xeb, 0x4c, 0xd2, 0xb7, 0x6c, 0x71, 0xaf, 0xe3, 0xd8, 0xa6, 0xd7, 0x25, 0x2f, 0x92, 0x4c,
		0xdc, 0x19, 0xc8, 0x05, 0xc8, 0x05, 0xc8, 0x05, 0xc8, 0x05, 0xc8, 0x05, 0xc8, 0x05, 0xc8, 0x05,
		0xc8, 0x45, 0x12, 0xb9, 0x8c, 0x50, 0x05, 0x65, 0xeb, 0xef, 0x39, 0x7b, 0x02, 0xad, 0x00, 0xad,
		0x00, 0xad, 0x00, 0xad, 0x00, 0xad, 0x00, 0xad, 0x00, 0xad, 0x00, 0xad, 0x48, 0xa2, 0x95, 0x89,
		0xe2, 0x00, 0xeb, 0xc1, 0xf3, 0xe9, 0x12, 0xf8, 0x92, 0x36, 0x06, 0x6e, 0x01, 0x6e, 0x01, 0x6e,
		0x01, 0x6e, 0x01, 0x6e, 0x01, 0x6e, 0x01, 0x6e, 0x01, 0x6e, 0x51, 0xc7, 0x2d, 0xdc, 0xe9, 0x30,
		0xaf, 0xa7, 0x05, 0xb9, 0xbc, 0xd9, 0x1a, 0xd8, 0x05, 0xd8, 0x05, 0xd8, 0x05, 0xd8, 0x05, 0xd8,
		0x05, 0xd8, 0x05, 0xd8, 0x05, 0xd8, 0x45, 0x12, 0xbb, 0x34, 0x2d, 0x6e, 0x99, 0x6d, 0xc7, 0xfd,
		0x4e, 0x06, 0x59, 0x66, 0x76, 0x04, 0x52, 0x01, 0x52, 0x01, 0x52, 0x01, 0x52, 0x01, 0x52, 0x01,
		0x52, 0x01, 0x52, 0x01, 0x52, 0x91, 0x44, 0x2a, 0xcc, 0xf6, 0x6d, 0x32, 0x90, 0x32, 0xb9, 0x19,
		0xf0, 0x09, 0xf0, 0x09, 0xf0, 0x09, 0xf0, 0x09, 0xf0, 0x09, 0xf0, 0x09, 0xf0, 0x09, 0xf0, 0x89,
		0x24, 0x3e, 0x09, 0x07, 0xca, 0xdb, 0x9e, 0xcb, 0x7d, 0xaf, 0x6d, 0x76, 0x7d, 0x8f, 0x7b, 0xb6,
		0x47, 0x37, 0x9f, 0x64, 0xe1, 0xee, 0x40, 0x30, 0x40, 0x30, 0x40, 0x30, 0x40, 0x30, 0x40, 0x30,
		0x40, 0x30, 0x40, 0x30, 0x40, 0x30, 0x92, 0x08, 0xc6, 0x19, 0xc8, 0x41, 0x97, 0x70, 0xa8, 0xda,
		0xdb, 0x0d, 0x81, 0x53, 0x80, 0x53, 0x80, 0x53, 0x80, 0x53, 0x80, 0x53, 0x80, 0x53, 0x80, 0x53,
		0x80, 0x53, 0x24, 0x71, 0x4a, 0xc7, 0x6a, 0x0f, 0x54, 0x00, 0x71, 0x5d, 0xf3, 0xdc, 0x5d, 0x81,
		0x58, 0x80, 0x58, 0x80, 0x58, 0x80, 0x58, 0x80, 0x58, 0x80, 0x58, 0x80, 0x58, 0x80, 0x58, 0x24,
		0x11, 0x4b, 0xd7, 0x73, 0x02, 0xcf, 0x25, 0x06, 0x2c, 0xf3, 0x36, 0x05, 0x5e, 0x01, 0x5e, 0x01,
		0x5e, 0x01, 0x5e, 0x01, 0x5e, 0x01, 0x5e, 0x01, 0x5e, 0x01, 0x5e, 0x91, 0xc4, 0x2b, 0x3e, 0xb3,
		0x99, 0xf3, 0xcc, 0x7c, 0xd3, 0x7b, 0x66, 0x7e, 0x98, 0x7a, 0x42, 0x05, 0x5a, 0x12, 0x77, 0x06,
		0x72, 0x01, 0x72, 0x01, 0x72, 0x01, 0x72, 0x01, 0x72, 0x01, 0x72, 0x01, 0x72, 0x01, 0x72, 0x91,
		0x44, 0x2e, 0x41, 0xcf, 0xef, 0xfa, 0x4e, 0xc0, 0xcc, 0xa6, 0xf7, 0x83, 0x6e, 0xba, 0xd0, 0xdc,
		0x5d, 0x81, 0x58, 0x80, 0x58, 0x80, 0x58, 0x80, 0x58, 0x80, 0x58, 0x80, 0x58, 0x80, 0x58, 0x80,
		0x58, 0x24, 0x11, 0x0b, 0x6f, 0x77, 0xcd, 0xa1, 0xb6, 0x22, 0x1f, 0x2f, 0x94, 0xbc, 0x35, 0xb0,
		0x0b, 0xb0, 0x0b, 0xb0, 0x0b, 0xb0, 0x0b, 0xb0, 0x0b, 0xb0, 0x0b, 0xb0, 0x0b, 0xb0, 0x8b, 0x2c,
		0x76, 0xf1, 0x38, 0x61, 0xb9, 0xd0, 0xd4, 0x6e, 0x40, 0x28, 0x40, 0x28, 0x40, 0x28, 0x40, 0x28,
		0x40, 0x28, 0x40, 0x28, 0x40, 0x28, 0x40, 0x28, 0x92, 0x08, 0xa5, 0xe7, 0x36, 0x59, 0xcb, 0x71,
		0x09, 0x9d, 0x2a, 0x33, 0x3b, 0x02, 0xa9, 0x00, 0xa9, 0x00, 0xa9, 0x00, 0xa9, 0x00, 0xa9, 0x00,
		0xa9, 0x00, 0xa9, 0x00, 0xa9, 0x48, 0x23, 0x15, 0xf6, 0xb3, 0xcb, 0x6c, 0xce, 0x9a, 0xe6, 0xc4,
		0xd4, 0x1f, 0x3a, 0xd4, 0xb2, 0x60, 0x77, 0x20, 0x18, 0x20, 0x18, 0x20, 0x18, 0x20, 0x18, 0x20,
		0x18, 0x20, 0x18, 0x20, 0x18, 0x20, 0x18, 0x69, 0x04, 0x13, 0xf4, 0xba, 0x5d, 0xcf, 0x1f, 0x80,
		0x0c, 0x9f, 0xfd, 0x5f, 0x8f, 0x05, 0x9c, 0x10, 0xbf, 0x24, 0xee, 0x0d, 0xf4, 0x02, 0xf4, 0x02,
		0xf4, 0x02, 0xf4, 0x02, 0xf4, 0x02, 0xf4, 0x02, 0xf4, 0x02, 0xf4, 0x22, 0xbc, 0x42, 0x90, 0x56,
		0x4b, 0x35, 0xd7, 0xf5, 0xb8, 0x35, 0xb8, 0x69, 0x29, 0xf2, 0x2c, 0x05, 0xf6, 0x13, 0xeb, 0x58,
		0x5d, 0x8b, 0x3f, 0x0d, 0x24, 0xf0, 0xae, 0xd7, 0x65, 0xae, 0x1d, 0xa2, 0x89, 0x58, 0x0f, 0xed,
		0xda, 0x5e, 0xa7, 0xeb, 0xb9, 0xcc, 0xe5, 0xc1, 0xf8, 0xc7, 0xdd, 0x80, 0x5b, 0x9c, 0xed, 0x76,
		0x6d, 0x87, 0xed, 0xba, 0x9e, 0x6b, 0xb6, 0x2c, 0xa5, 0x74, 0x99, 0x52, 0xc0, 0xfd, 0x9e, 0xcd,
		0xdd, 0x48, 0x11, 0x5c, 0xc6, 0xdf, 0xe2, 0x2a, 0xfa, 0x12, 0xf7, 0x27, 0xf1, 0x97, 0x18, 0xff,
		0x78, 0x7f, 0x33, 0xf8, 0x12, 0xf7, 0x57, 0xb6, 0xc3, 0xee, 0x2f, 0x3c, 0xf7, 0xf3, 0xe0, 0x3b,
		0xd4, 0x87, 0x5f, 0xe1, 0x9d, 0x9e, 0x1b, 0x4a, 0xf7, 0xc9, 0x94, 0x77, 0x28, 0x7b, 0x77, 0x04,
		0x77, 0x26, 0x70, 0x45, 0xca, 0x57, 0x93, 0xee, 0x2e, 0x96, 0x9f, 0x6c, 0x8a, 0x53, 0x2d, 0xf9,
		0xac, 0xd9, 0x73, 0x9b, 0x96, 0xcb, 0x4d, 0xdf, 0x6b, 0xa7, 0x47, 0x25, 0x13, 0x1d, 0x01, 0xa6,
		0xd6, 0xa7, 0xbc, 0x47, 0x31, 0xf4, 0x2e, 0x8c, 0xd6, 0x65, 0xd0, 0xb9, 0x22, 0x1a, 0x97, 0x45,
		0xdf, 0xca, 0x68, 0x5b, 0x19, 0x5d, 0xab, 0xa3, 0x69, 0x5a, 0x1e, 0x17, 0x46, 0xc7, 0x53, 0xe3,
		0xf6, 0x43, 0x5e, 0x32, 0xa5, 0xa8, 0x72, 0x92, 0x32, 0xcb, 0x07, 0x02, 0x6b, 0xea, 0x6e, 0xaf,
		0x33, 0xf8, 0xc6, 0xfd, 0x4c, 0xf9, 0xb6, 0xe3, 0x3d, 0x5b, 0x0f, 0x72, 0x2c, 0x3b, 0x5a, 0x0a,
		0x6e, 0x05, 0xb7, 0xae, 0x8c, 0x5b, 0x1f, 0x3c, 0xaf, 0xcd, 0x2c, 0x57, 0x86, 0x39, 0xcb, 0x19,
		0x32, 0x5a, 0xc0, 0x7c, 0xc7, 0x6a, 0x9b, 0xae, 0x27, 0xce, 0x68, 0xe3, 0xa5, 0x60, 0x34, 0x30,
		0xda, 0xca, 0x18, 0x2d, 0xe0, 0xbe, 0xe3, 0x3e, 0xca, 0xf0, 0xd9, 0x87, 0x2c, 0xf9, 0xcc, 0x6b,
		0xf1, 0x1f, 0x96, 0xcf, 0xcc, 0x67, 0xe6, 0x07, 0x22, 0x00, 0x7f, 0xfc, 0x9e, 0x6f, 0x77, 0x00,
		0xd7, 0x81, 0xeb, 0xc0, 0x75, 0x0b, 0x9f, 0xc9, 0x59, 0xa7, 0xcb, 0x7c, 0x8b, 0xf7, 0x7c, 0x09,
		0x20, 0x39, 0xb9, 0x58, 0x8c, 0xd7, 0xca, 0xe0, 0x35, 0xf0, 0xda, 0xdb, 0xaf, 0x73, 0xea, 0xf8,
		0x62, 0x17, 0x67, 0xb5, 0x2d, 0xbf, 0x63, 0x06, 0xec, 0x99, 0xf9, 0x0e, 0x7f, 0x11, 0xbf, 0x81,
		0xd1, 0xc5, 0xbf, 0xd9, 0x47, 0xf0, 0x14, 0xe5, 0x22, 0x91, 0xd2, 0x11, 0x48, 0x95, 0xc8, 0x23,
		0x51, 0xc4, 0x51, 0x35, 0xd2, 0x48, 0x16, 0x61, 0x24, 0x8b, 0x2c, 0xd2, 0x45, 0x14, 0xf5, 0xfa,
		0xae, 0xa5, 0x23, 0x87, 0xe3, 0xa1, 0x6e, 0x4d, 0xe6, 0x72, 0x87, 0xbf, 0xf8, 0xac, 0x25, 0x73,
		0xf3, 0x23, 0xf9, 0x2d, 0x11, 0x74, 0x29, 0x9d, 0x45, 0x8f, 0xfe, 0x64, 0x05, 0x4c, 0x3d, 0xa5,
		0xe0, 0xf2, 0xaa, 0x7e, 0x71, 0x72, 0x79, 0xf1, 0xf9, 0xec, 0xf7, 0xfb, 0xda, 0x97, 0xda, 0xf5,
		0xf9, 0xfd, 0x4d, 0xfd, 0xaf, 0xfa, 0xf5, 0xd9, 0xed, 0xdf, 0xb2, 0xb4, 0x14, 0x86, 0x98, 0x02,
		0xa5, 0x20, 0xa6, 0x62, 0xe0, 0x7d, 0xf4, 0x6a, 0x27, 0xd7, 0x67, 0xb7, 0x67, 0x27, 0xb5, 0x2f,
		0x0a, 0xf1, 0xec, 0x9d, 0x55, 0xbf, 0xc3, 0xf9, 0xd9, 0xc5, 0xe5, 0x75, 0xa1, 0x5f, 0xa0, 0xf6,
		0xff, 0x8a, 0xfd, 0x02, 0xff, 0xaa, 0x5d, 0x5f, 0x9c, 0x5d, 0xfc, 0x5e, 0xe4, 0x57, 0xf8, 0x7a,
		0xf1, 0xe7, 0xc5, 0xe5, 0xbf, 0x2e, 0xb2, 0xce, 0xeb, 0x68, 0xe8, 0x96, 0xfa, 0xef, 0x34, 0x5c,
		0xc1, 0x08, 0xc5, 0x70, 0x8b, 0xf7, 0x02, 0x65, 0x2c, 0x34, 0xdc, 0x05, 0x48, 0x08, 0x48, 0x68,
		0x6d, 0x91, 0x90, 0xb8, 0xff, 0x79, 0x06, 0x05, 0x95, 0x73, 0xc3, 0xf6, 0xfc, 0xc9, 0x67, 0xc1,
		0x93, 0xd7, 0x6e, 0xaa, 0x72, 0xfe, 0x78, 0x23, 0x30, 0x3f, 0x98, 0x7f, 0x6d, 0x99, 0xbf, 0xe7,
		0xb8, 0x7c, 0xbf, 0xa2, 0xc0, 0xfb, 0x47, 0x12, 0x4b, 0xd5, 0xb2, 0x24, 0x15, 0xd2, 0x45, 0x29,
		0xb2, 0x22, 0xa9, 0xb2, 0x21, 0xc9, 0xf3, 0xec, 0xe8, 0xf2, 0xeb, 0x14, 0x00, 0x2f, 0x49, 0xb6,
		0x63, 0x7c, 0xc4, 0x07, 0x95, 0xe3, 0x83, 0xe3, 0xc3, 0xa3, 0xca, 0x71, 0x75, 0x7d, 0xcf, 0x3a,
		0xa3, 0x5c, 0xc2, 0x46, 0x1e, 0x54, 0xf4, 0xf3, 0xa3, 0x82, 0x5a, 0x7e, 0x7e, 0xdc, 0x30, 0x55,
		0x6c, 0xf2, 0x97, 0x2e, 0x0b, 0xa0, 0x90, 0x17, 0x28, 0xe4, 0xe8, 0x88, 0xd6, 0x4e, 0x2d, 0x37,
		0x99, 0xed, 0x74, 0xac, 0xb6, 0x54, 0x3d, 0x43, 0x8c, 0xca, 0x2b, 0x12, 0x6b, 0x67, 0x04, 0x65,
		0x79, 0x63, 0xf5, 0xfb, 0x71, 0xa5, 0xb2, 0xbf, 0x7f, 0x54, 0xd9, 0xdb, 0x3f, 0xfc, 0x50, 0x3d,
		0x38, 0x3a, 0xaa, 0x7e, 0xd8, 0xfb, 0x40, 0xad, 0x85, 0xca, 0x74, 0x5a, 0x68, 0xc0, 0x5b, 0xc5,
		0x57, 0xf8, 0xb3, 0x67, 0x7e, 0x94, 0xe3, 0x33, 0x87, 0xe6, 0x4f, 0x7b, 0x68, 0x8e, 0x1b, 0x70,
		0x2b, 0x94, 0xde, 0x92, 0xda, 0x7f, 0xb4, 0x01, 0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 0x10, 0x00,
		0x10, 0x00, 0x10, 0x00, 0x10, 0x40, 0xa1, 0x10, 0x00, 0x67, 0xfe, 0xb3, 0xd5, 0x56, 0x81, 0x00,
		0xd1, 0x0e, 0x9b, 0x81, 0x01, 0xa0, 0xfa, 0x93, 0x54, 0xff, 0x9a, 0x6a, 0xfc, 0x80, 0x5b, 0xdc,
		0x94, 0x24, 0x72, 0x43, 0xad, 0x7f, 0x41, 0xe9, 0xab, 0x3b, 0x14, 0x8d, 0x25, 0xd7, 0x72, 0xbd,
		0x80, 0xd9, 0x9e, 0xdb, 0x94, 0xa2, 0x3d, 0x78, 0xf6, 0xe1, 0xd9, 0x4f, 0x75, 0xc4, 0xf4, 0xfd,
		0x0b, 0xe0, 0xe3, 0xcf, 0x85, 0x9e, 0xef, 0x48, 0x50, 0x49, 0x2c, 0x02, 0x07, 0x8b, 0x61, 0xe1,
		0x43, 0xcd, 0xc3, 0xc2, 0x87, 0x85, 0x0f, 0x0b, 0x1f, 0x16, 0x3e, 0x2c, 0xfc, 0x62, 0x69, 0x7e,
		0x93, 0x3b, 0x1d, 0xa6, 0xa4, 0xfe, 0x87, 0x3b, 0xc0, 0xc2, 0x87, 0x85, 0xbf, 0x86, 0x1a, 0x7f,
		0x40, 0xdb, 0xdc, 0xb1, 0xbf, 0x07, 0x4a, 0x3a, 0x1f, 0xf6, 0x3d, 0xec, 0x7b, 0xd8, 0xf7, 0xb0,
		0xef, 0x57, 0xa4, 0xe5, 0x25, 0x18, 0x71, 0xac, 0xe0, 0x1d, 0x17, 0xf6, 0x3d, 0x94, 0x3c, 0xec,
		0x7b, 0xd8, 0xf7, 0xb0, 0xef, 0x61, 0xdf, 0xc3, 0xbe, 0x2f, 0x98, 0xe6, 0x57, 0xb5, 0xef, 0x47,
		0x3b, 0xc0, 0xbe, 0x87, 0x7d, 0x0f, 0xfb, 0x1e, 0xf6, 0x3d, 0xec, 0x7b, 0xd8, 0xf7, 0xb0, 0xef,
		0xf5, 0x6b, 0xf9, 0x35, 0xe8, 0x3d, 0x2f, 0xde, 0x63, 0xcf, 0x50, 0x6d, 0x41, 0x7f, 0x3b, 0xf1,
		0xc8, 0x2c, 0x5b, 0x11, 0x8a, 0xe8, 0xa1, 0xb1, 0xee, 0x19, 0xac, 0x42, 0xa3, 0x4f, 0x34, 0x1f,
		0x54, 0xe4, 0x6e, 0xf9, 0x46, 0x9f, 0x3d, 0x37, 0x7d, 0xaf, 0xd9, 0x29, 0x1f, 0xc7, 0xb1, 0xc0,
		0x9a, 0xe8, 0xeb, 0x89, 0xe1, 0x13, 0xb4, 0x89, 0x9b, 0x6a, 0x13, 0xf7, 0x47, 0xed, 0xfa, 0xf4,
		0x5f, 0xb5, 0xeb, 0xfa, 0xfd, 0xc9, 0xe5, 0xf9, 0xd5, 0xe5, 0x45, 0xfd, 0xe2, 0x76, 0x0d, 0x5a,
		0xc5, 0x5d, 0x5e, 0xdc, 0x5e, 0x5f, 0x7e, 0xf9, 0x52, 0xbf, 0xbe, 0x3f, 0xa9, 0x5d, 0x9f, 0x16,
		0xb9, 0xd9, 0xd7, 0xa7, 0xda, 0xc9, 0x9f, 0x57, 0x5f, 0x6a, 0x17, 0xf5, 0x22, 0xbf, 0xc4, 0xc9,
		0xd5, 0xd7, 0x22, 0x7f, 0xfd, 0xb3, 0x8b, 0xdb, 0xfa, 0xef, 0xd7, 0xb5, 0xdb, 0xfa, 0xe9, 0xfd,
		0xc9, 0xd9, 0xf5, 0xc9, 0xd7, 0xb3, 0xdb, 0x42, 0x5f, 0xc6, 0x1f, 0xb5, 0x9b, 0x9b, 0xb3, 0x9b,
		0x22, 0xbf, 0xc2, 0xe7, 0xda, 0xa7, 0xeb, 0xb3, 0x93, 0x22, 0xbf, 0xc1, 0xd5, 0xe5, 0x75, 0xa1,
		0x89, 0xe8, 0xcb, 0xd9, 0x45, 0xbd, 0xe8, 0xa2, 0xf5, 0xe6, 0xf6, 0xf2, 0xba, 0xf6, 0x7b, 0xbd,
		0xd8, 0x64, 0xf4, 0xaf, 0xfa, 0xf5, 0xfd, 0xcd, 0xd7, 0xab, 0xab, 0x2f, 0x7f, 0x17, 0x9b, 0xa1,
		0x2f, 0x0a, 0x4d, 0x49, 0xf5, 0x8b, 0x9b, 0x62, 0xb7, 0x45, 0xfd, 0x7c, 0x5d, 0x68, 0x0d, 0x7d,
		0x7b, 0x5d, 0xbb, 0xb8, 0x39, 0xa9, 0x9f, 0xfd, 0x55, 0xbf, 0x5e, 0xbb, 0xb6, 0xa8, 0x3b, 0xb0,
		0x6e, 0xe4, 0xad, 0x9b, 0x9b, 0xcb, 0xcf, 0xb7, 0xeb, 0x66, 0xdd, 0x5c, 0x5e, 0xd5, 0xaf, 0x6b,
		0xb7, 0x67, 0x17, 0xbf, 0xdf, 0xdf, 0xfc, 0x7d, 0x73, 0x5b, 0x3f, 0x2f, 0xb4, 0x79, 0x73, 0x76,
		0x59, 0x68, 0x24, 0xfa, 0xf6, 0x2e, 0xee, 0xbf, 0x5e, 0x9d, 0xd6, 0x6e, 0x0b, 0x8d, 0x29, 0x3e,
		0x5d, 0x5e, 0xde, 0xde, 0x7f, 0xb9, 0xac, 0x9d, 0xd6, 0x0b, 0xad, 0xd1, 0x62, 0xce, 0x3f, 0xbf,
		0x3c, 0xfd, 0xfa, 0xa5, 0xbe, 0xb9, 0xdd, 0xb2, 0x1b, 0x19, 0x7a, 0xab, 0x7b, 0x01, 0x6b, 0x9a,
		0x5d, 0xef, 0x07, 0xf3, 0xc5, 0x7d, 0xd6, 0x13, 0x6b, 0xe1, 0xb9, 0x86, 0xe7, 0x5a, 0x4d, 0xb0,
		0xa8, 0x78, 0xae, 0x45, 0x9b, 0xe0, 0x4a, 0x34, 0xbf, 0x95, 0x0c, 0xad, 0x4b, 0x80, 0x3b, 0x95,
		0x50, 0xba, 0x6a, 0x08, 0x9d, 0x2c, 0x88, 0xab, 0x1e, 0xbc, 0x95, 0xd0, 0x47, 0x4a, 0x21, 0x72,
		0xb2, 0xa6, 0xb5, 0x79, 0x3a, 0xc3, 0xbc, 0x2b, 0xa8, 0x77, 0x0a, 0x14, 0x50, 0xaa, 0xf5, 0x1e,
		0x07, 0xe2, 0x8b, 0x35, 0x53, 0x71, 0xa5, 0xa0, 0x6e, 0xdb, 0x9d, 0x90, 0x88, 0x1f, 0x27, 0xe2,
		0xda, 0x73, 0x7f, 0x3d, 0xf5, 0xdb, 0x30, 0xde, 0x9d, 0x56, 0x21, 0x9e, 0xb2, 0xc0, 0xf6, 0x9d,
		0x6e, 0x14, 0x8d, 0x2f, 0xd5, 0x9a, 0xcd, 0xc0, 0x08, 0xba, 0xcc, 0x76, 0x5a, 0x8e, 0x6d, 0x84,
		0x9d, 0xec, 0x03, 0xc3, 0x67, 0x6d, 0x8b, 0xb3, 0xa6, 0xc1, 0x3d, 0xc3, 0x32, 0xe2, 0x67, 0xbe,
		0x5f, 0x93, 0x51, 0x75, 0xc3, 0x97, 0xdc, 0x48, 0x8d, 0x1b, 0xbd, 0x7a, 0x51, 0xc6, 0xd4, 0xb1,
		0xff, 0xeb, 0x39, 0xdd, 0xc1, 0xd7, 0x37, 0x5b, 0x96, 0xd3, 0x16, 0x99, 0xb4, 0x38, 0x73, 0xef,
		0xb3, 0x5b, 0x09, 0x9e, 0xe4, 0x1b, 0xbe, 0x39, 0x6b, 0x0d, 0xaf, 0xc3, 0xe0, 0x4f, 0xcc, 0x78,
		0xb2, 0xfc, 0xe6, 0x0f, 0xcb, 0x67, 0x86, 0xe3, 0x36, 0x1d, 0xdb, 0xe2, 0x2c, 0x30, 0xf8, 0x93,
		0xc5, 0xc3, 0x7f, 0x8b, 0xd9, 0xe7, 0xff, 0x13, 0x18, 0xdd, 0xa7, 0x97, 0xc0, 0xb1, 0xad, 0xb6,
		0x11, 0x7f, 0x9b, 0x3b, 0xf7, 0xc9, 0x0a, 0x8c, 0xc1, 0x57, 0x62, 0x4d, 0xf1, 0x6f, 0xd4, 0xb2,
		0x7a, 0x6d, 0x2e, 0xe5, 0x6e, 0x28, 0x85, 0xe2, 0x5d, 0xcc, 0xe0, 0x69, 0x6c, 0x46, 0x12, 0xae,
		0xb0, 0x78, 0x50, 0x15, 0x13, 0x64, 0xe2, 0x82, 0x4c, 0x6c, 0x50, 0x89, 0x8f, 0x4c, 0xbc, 0x99,
		0x18, 0x68, 0x33, 0x2b, 0x2e, 0x3b, 0x4e, 0xd0, 0xb1, 0xb8, 0xfd, 0x44, 0x21, 0x2f, 0xe3, 0xbd,
		0xb2, 0x16, 0x98, 0x86, 0xe3, 0x06, 0xcc, 0x1f, 0xe0, 0x10, 0xc7, 0xe5, 0xde, 0xe0, 0xdf, 0xee,
		0x5c, 0xab, 0xd5, 0x62, 0xf6, 0xe0, 0x57, 0x73, 0xc5, 0x6a, 0xdb, 0xb3, 0xc3, 0x34, 0x43, 0xc3,
		0x09, 0x0c, 0xaf, 0x65, 0x58, 0x46, 0xd3, 0x69, 0xb5, 0x98, 0x3f, 0xd8, 0x8b, 0xbf, 0x74, 0xd9,
		0xe0, 0x19, 0xae, 0xf1, 0xe3, 0xc9, 0xe2, 0x77, 0xae, 0x13, 0x18, 0xc3, 0xbc, 0xbe, 0x9e, 0x0f,
		0xc9, 0x0b, 0xc9, 0x0b, 0xc9, 0x0b, 0xc9, 0x2b, 0x87, 0x7d, 0x15, 0x4d, 0xce, 0xc6, 0x32, 0x93,
		0x53, 0x2c, 0x77, 0x5a, 0x2d, 0x67, 0x3a, 0xc5, 0x35, 0xa8, 0xe4, 0x47, 0x2f, 0x26, 0xdf, 0xe4,
		0x73, 0x5a, 0x40, 0x96, 0xa5, 0x80, 0x7b, 0xbe, 0xf5, 0xb8, 0x9c, 0x0a, 0x27, 0x9a, 0x66, 0x0e,
		0x17, 0x2c, 0x39, 0xf7, 0x74, 0x36, 0x6c, 0x6a, 0x91, 0x29, 0x22, 0x22, 0x25, 0xfd, 0xc3, 0xa2,
		0x42, 0x50, 0x5a, 0xe8, 0x49, 0x0b, 0x39, 0x79, 0xff, 0xaf, 0x9a, 0xdb, 0x26, 0xad, 0xdd, 0x59,
		0xb2, 0x47, 0xb7, 0x29, 0xe8, 0xba, 0x89, 0xd6, 0x61, 0x92, 0x3f, 0x42, 0x12, 0x8a, 0x2e, 0x92,
		0xec, 0x4b, 0x65, 0x42, 0x69, 0xb8, 0x2b, 0x44, 0xc1, 0x4a, 0x7a, 0x20, 0x7c, 0xde, 0x7d, 0x44,
		0xd4, 0x19, 0x86, 0x1d, 0x87, 0x0a, 0x4e, 0x98, 0xb5, 0x85, 0x7c, 0xab, 0xb2, 0x9c, 0x5d, 0x01,
		0x67, 0x83, 0xb3, 0x35, 0x71, 0xb6, 0x08, 0x01, 0x13, 0x30, 0x76, 0x0a, 0xa0, 0x47, 0x05, 0x9d,
		0xfb, 0xb9, 0x81, 0xce, 0x69, 0x10, 0xa5, 0xfa, 0xd9, 0x6a, 0x81, 0xcf, 0xbd, 0x87, 0xf1, 0x3b,
		0x09, 0x80, 0xe8, 0xa9, 0x65, 0x80, 0xd2, 0x80, 0xd2, 0x8b, 0x08, 0x4b, 0x42, 0xeb, 0x4e, 0xae,
		0x06, 0xac, 0x86, 0xf2, 0x55, 0x54, 0xbe, 0xc2, 0x91, 0x47, 0x41, 0x4b, 0x50, 0xcd, 0x22, 0x94,
		0x24, 0xe1, 0xdc, 0xf8, 0x6d, 0x31, 0x09, 0x9e, 0x94, 0xf4, 0xb3, 0xf1, 0xdd, 0x8a, 0xb2, 0x44,
		0xbc, 0x30, 0x42, 0x2f, 0x8a, 0xf9, 0xf7, 0xe1, 0x2e, 0x92, 0x27, 0x2c, 0x17, 0xde, 0x50, 0x66,
		0x17, 0x0a, 0xb6, 0x21, 0x66, 0x1f, 0x2a, 0x36, 0x22, 0x67, 0x27, 0x72, 0xb6, 0xa2, 0x67, 0x2f,
		0x39, 0x36, 0x93, 0x64, 0xb7, 0xf8, 0xeb, 0x4b, 0x87, 0x4c, 0x66, 0x28, 0xa7, 0xcd, 0xac, 0x96,
		0x5c, 0x19, 0xce, 0x8c, 0xbe, 0x51, 0x68, 0xb7, 0x57, 0xba, 0x8a, 0xec, 0xa5, 0xf7, 0xef, 0x77,
		0x27, 0xff, 0x37, 0x36, 0x8f, 0x86, 0xaa, 0x70, 0x37, 0x64, 0xf8, 0x8c, 0xda, 0xe2, 0xe8, 0x95,
		0x9c, 0x92, 0x96, 0xbc, 0xba, 0x9d, 0x39, 0x69, 0x74, 0x4d, 0xfd, 0x6d, 0x57, 0x0a, 0x6e, 0xa8,
		0x58, 0xa4, 0x93, 0x5f, 0x65, 0xea, 0x6f, 0x42, 0x9e, 0x3d, 0xf1, 0xfb, 0x12, 0x49, 0x87, 0x90,
		0x52, 0x54, 0x2a, 0x0a, 0xaa, 0xe8, 0xad, 0x87, 0x81, 0xdf, 0x0a, 0x84, 0xdf, 0xd4, 0x63, 0xef,
		0xf2, 0x0a, 0x44, 0x45, 0x71, 0x4c, 0x2a, 0x0c, 0x69, 0xd5, 0xa0, 0x47, 0x60, 0x88, 0x85, 0x08,
		0x66, 0x9d, 0x16, 0x82, 0x9e, 0x56, 0x12, 0x93, 0xaf, 0x02, 0x91, 0x01, 0x91, 0x01, 0x93, 0x0f,
		0x26, 0x1f, 0x4c, 0x3e, 0x98, 0x7c, 0x30, 0xf9, 0x36, 0xc7, 0xe4, 0x93, 0x41, 0x1b, 0x7a, 0x2c,
		0x3e, 0x81, 0x90, 0xaf, 0x04, 0x7e, 0x23, 0x8d, 0x03, 0xfc, 0xc9, 0x5e, 0x04, 0x35, 0x51, 0xe9,
		0x8b, 0x13, 0xf0, 0x1a, 0xe7, 0x82, 0xf1, 0x83, 0x73, 0xc7, 0xad, 0xb7, 0x59, 0x27, 0x8a, 0xaa,
		0x0a, 0x68, 0x9d, 0xd2, 0xb9, 0xf5, 0x73, 0x62, 0xa5, 0x5a, 0xd7, 0xe4, 0xd2, 0xa5, 0xdf, 0x64,
		0x3e, 0x6b, 0x7e, 0x1a, 0xbc, 0xb5, 0xdb, 0x6b, 0xb7, 0x8b, 0x9d, 0xd1, 0x90, 0xc8, 0x0c, 0x19,
		0xa4, 0x37, 0x24, 0x92, 0xff, 0x86, 0xe5, 0x3a, 0x08, 0x04, 0xfe, 0xa9, 0x8e, 0x5b, 0x3a, 0xef,
		0xe1, 0x9d, 0xc0, 0x49, 0xa6, 0x10, 0x0d, 0xe9, 0x44, 0x41, 0x7a, 0xd6, 0x57, 0x62, 0xf5, 0x74,
		0xac, 0x9d, 0xf4, 0xb2, 0x29, 0xc9, 0x45, 0x96, 0x4c, 0x4a, 0x0b, 0x13, 0xb6, 0x25, 0x08, 0x62,
		0x3e, 0x09, 0xcc, 0x5e, 0xf0, 0xf4, 0x6f, 0xde, 0xbc, 0xfd, 0xb2, 0xb7, 0x16, 0x7b, 0xdb, 0x39,
		0xef, 0x28, 0xf2, 0x6e, 0xd3, 0x6f, 0x34, 0xfe, 0xde, 0x13, 0xdf, 0xb9, 0xe4, 0xb8, 0x9c, 0xf9,
		0x2d, 0xcb, 0x66, 0xb3, 0x99, 0x39, 0xe3, 0x86, 0x5c, 0xe3, 0xcf, 0xbc, 0x79, 0xdb, 0xf9, 0x9e,
		0x85, 0x44, 0x53, 0x68, 0x91, 0x89, 0x33, 0x69, 0xba, 0x38, 0xf3, 0xe0, 0xe7, 0x32, 0x63, 0x24,
		0xb5, 0x91, 0x91, 0xda, 0x78, 0x78, 0x6b, 0x14, 0x38, 0xad, 0x92, 0x20, 0x35, 0x24, 0x59, 0xc3,
		0xe3, 0x23, 0x4d, 0x7e, 0x9d, 0x99, 0xd3, 0x4f, 0x7a, 0x9d, 0xc5, 0xee, 0x9d, 0xa5, 0x76, 0x69,
		0x1a, 0xbb, 0x73, 0xe9, 0xe5, 0x88, 0x5a, 0x8c, 0xc2, 0x16, 0xa1, 0xb0, 0xc5, 0x97, 0xe6, 0xf2,
		0xe4, 0xa4, 0xf8, 0x32, 0x17, 0x47, 0xda, 0xc4, 0x0e, 0xb1, 0x44, 0x8e, 0xbc, 0xa4, 0xb8, 0x39,
		0xad, 0xb5, 0x4c, 0x6e, 0x5b, 0x44, 0x1e, 0x34, 0xf0, 0x29, 0x75, 0x5a, 0x5b, 0x73, 0xaa, 0xa8,
		0x55, 0x30, 0xab, 0x6d, 0x72, 0xf1, 0x7a, 0xb4, 0xaf, 0x72, 0x5a, 0x1b, 0x99, 0xce, 0x96, 0x86,
		0x20, 0xf5, 0x18, 0xb0, 0xf2, 0x2d, 0xab, 0x02, 0xee, 0x3b, 0xee, 0xa3, 0xcc, 0xb4, 0x85, 0x0f,
		0xa4, 0x6f, 0xc0, 0x7e, 0x72, 0xdf, 0x32, 0x7b, 0x6e, 0xc0, 0xad, 0x87, 0xb6, 0xe0, 0xbb, 0xf8,
		0x2c, 0xac, 0xe6, 0xb6, 0x33, 0x1d, 0xe8, 0x70, 0xfd, 0xf9, 0xc4, 0xa8, 0x7c, 0x38, 0xdc, 0xff,
		0x68, 0xdc, 0x3e, 0x31, 0xe3, 0x2c, 0xc6, 0x5b, 0xc6, 0xef, 0xbe, 0xd7, 0xeb, 0x1a, 0xe7, 0x67,
		0x9f, 0x0c, 0xd3, 0x70, 0x5a, 0xb5, 0xb6, 0x63, 0xad, 0xba, 0x76, 0x79, 0x7c, 0x3e, 0x79, 0x8a,
		0x88, 0x08, 0x1d, 0xe0, 0x46, 0xb6, 0x44, 0x64, 0xee, 0x80, 0x17, 0x9a, 0xe2, 0x1a, 0x65, 0xb4,
		0x30, 0x75, 0xef, 0x27, 0xf1, 0xbe, 0x05, 0xa5, 0x01, 0x15, 0xa4, 0xbb, 0x96, 0x06, 0x94, 0x1a,
		0x94, 0x5a, 0xa6, 0x4a, 0x4d, 0xbc, 0x7d, 0x80, 0x60, 0xdb, 0x80, 0x8d, 0xd7, 0x6a, 0xcd, 0x8e,
		0xe3, 0xde, 0x70, 0x8b, 0xf7, 0xa0, 0xdb, 0x54, 0x74, 0xdb, 0xc4, 0x31, 0x6e, 0xa4, 0x86, 0x6b,
		0x7b, 0x5e, 0xf7, 0xc1, 0xb2, 0xbf, 0x9b, 0x1d, 0xaf, 0x29, 0x51, 0x85, 0x3b, 0xbd, 0x5c, 0xa7,
		0xb6, 0x13, 0xe8, 0xce, 0x03, 0x75, 0x07, 0x75, 0xb7, 0x6e, 0xea, 0x8e, 0x84, 0xd9, 0x3b, 0xbc,
		0x27, 0xce, 0xe2, 0x83, 0x45, 0x60, 0x28, 0x30, 0x54, 0xa6, 0x0c, 0xd5, 0x73, 0x5c, 0x5e, 0x3e,
		0x94, 0xe0, 0xa7, 0x43, 0xf4, 0xf1, 0x7e, 0xb3, 0x1e, 0x7d, 0xbc, 0x8d, 0xc3, 0x6a, 0x75, 0x1f,
		0x2d, 0xbc, 0xf3, 0x00, 0x37, 0x85, 0x12, 0x56, 0x65, 0x12, 0x54, 0xa1, 0x83, 0xa0, 0x83, 0x88,
		0x74, 0x90, 0x76, 0xc7, 0x3c, 0x66, 0x8c, 0x83, 0xa3, 0x0a, 0xc8, 0x51, 0xe7, 0x96, 0xdb, 0xb4,
		0xb8, 0xe7, 0xbf, 0x08, 0x34, 0xf5, 0x90, 0xe7, 0x42, 0xb9, 0xc1, 0x76, 0x32, 0x03, 0xed, 0xd4,
		0x06, 0xd9, 0xcd, 0xa6, 0x9e, 0x98, 0x21, 0x93, 0xad, 0xe8, 0x92, 0xd6, 0xd5, 0xef, 0x79, 0x9b,
		0x5e, 0x70, 0xc1, 0xe1, 0x99, 0x74, 0x7e, 0x98, 0x1e, 0x33, 0x75, 0x8c, 0xf5, 0x9f, 0x3c, 0xa0,
		0x1c, 0x1c, 0x33, 0x41, 0x2b, 0x9e, 0x6d, 0xb2, 0x9f, 0xfc, 0x23, 0x67, 0x6d, 0xd6, 0x61, 0xdc,
		0x7f, 0x31, 0x3d, 0xd7, 0xb4, 0x9f, 0x42, 0xbb, 0x53, 0x2a, 0x57, 0x27, 0xb4, 0x1c, 0x24, 0x92,
		0x75, 0x4a, 0x85, 0xe9, 0x86, 0x3c, 0xce, 0x9b, 0xdc, 0x9d, 0xf7, 0x63, 0xfa, 0x8a, 0xfa, 0xc4,
		0xa4, 0xcf, 0x31, 0x6f, 0xdc, 0xcf, 0xfb, 0x31, 0x55, 0xa1, 0xbc, 0x5c, 0x53, 0xb7, 0x27, 0xaf,
		0xdd, 0x34, 0xb9, 0xd3, 0x11, 0xe8, 0x8a, 0x3c, 0x5e, 0x82, 0x4c, 0x37, 0x64, 0xba, 0xa1, 0x17,
		0x32, 0x40, 0xff, 0x6a, 0xf0, 0xa4, 0x70, 0xa3, 0xb6, 0xa6, 0xf7, 0xc3, 0x95, 0x07, 0xd1, 0xe1,
		0xea, 0x2c, 0x87, 0x7f, 0xec, 0x61, 0xf0, 0x87, 0x2a, 0x9b, 0xe9, 0xc0, 0xda, 0xf9, 0xec, 0x23,
		0x20, 0xc2, 0x86, 0x92, 0x10, 0x3a, 0xf3, 0xa6, 0x23, 0xc2, 0x93, 0x53, 0xdf, 0xd2, 0xb6, 0x4c,
		0xcb, 0x11, 0xb9, 0x08, 0x8c, 0xbc, 0xb5, 0x39, 0xf6, 0x61, 0x28, 0x44, 0x64, 0xe2, 0x4d, 0x14,
		0x23, 0x33, 0xf1, 0x3e, 0x54, 0x21, 0x86, 0xf1, 0x9d, 0xaa, 0x86, 0x1a, 0x24, 0xc9, 0xf0, 0x8d,
		0x9b, 0xe8, 0x27, 0xdd, 0x11, 0xab, 0x4e, 0x62, 0x2d, 0xc2, 0x59, 0x67, 0x54, 0x90, 0xdf, 0xc8,
		0x41, 0x43, 0x9f, 0x5e, 0x57, 0x1e, 0x1a, 0xf4, 0xba, 0x00, 0x06, 0x00, 0x06, 0x00, 0x06, 0x00,
		0x06, 0x00, 0x06, 0x00, 0x06, 0x00, 0x06, 0xf9, 0x07, 0x06, 0xa4, 0x8e, 0x88, 0xd4, 0xce, 0x7a,
		0x39, 0x61, 0x40, 0xea, 0xbc, 0x4f, 0xd0, 0x37, 0x02, 0x4e, 0xfc, 0xb9, 0x8a, 0x86, 0xda, 0x07,
		0xd4, 0x58, 0x59, 0x5f, 0x99, 0x65, 0xce, 0xfe, 0xd8, 0xfb, 0x4d, 0x38, 0x07, 0x6b, 0x99, 0xfb,
		0xff, 0x0f, 0xaf, 0xdd, 0xbc, 0x75, 0x3a, 0x18, 0x85, 0x65, 0xac, 0x62, 0x14, 0x16, 0x1c, 0xbb,
		0x19, 0xcb, 0x53, 0x38, 0x76, 0x61, 0xbf, 0xc1, 0x7e, 0x83, 0xfd, 0x06, 0xfb, 0x0d, 0xf6, 0x1b,
		0xec, 0x37, 0xd8, 0x6f, 0x4a, 0xb4, 0x02, 0xc7, 0x2e, 0x80, 0x01, 0x80, 0x01, 0x80, 0x01, 0x80,
		0x01, 0x80, 0x01, 0x80, 0xc1, 0xda, 0x03, 0x83, 0x9c, 0x77, 0xad, 0x4e, 0xef, 0x5d, 0x24, 0x9b,
		0xc5, 0x9d, 0xda, 0xb9, 0xb8, 0x96, 0xe3, 0xb8, 0x53, 0x1f, 0xb8, 0xce, 0xf4, 0xed, 0xd1, 0x11,
		0xeb, 0x48, 0xe0, 0x4e, 0x55, 0xbe, 0x2a, 0x52, 0xb6, 0x9a, 0x12, 0x26, 0x22, 0x6d, 0x3b, 0xaf,
		0x69, 0xdb, 0xa9, 0x61, 0x98, 0xc4, 0xac, 0x10, 0x91, 0x99, 0x20, 0x52, 0xd3, 0xbb, 0x24, 0x47,
		0xd3, 0xa7, 0x8a, 0x52, 0x08, 0x45, 0x27, 0x84, 0xab, 0x17, 0x2a, 0x60, 0x83, 0x5c, 0xb1, 0x41,
		0xea, 0xea, 0x05, 0xab, 0xd9, 0x71, 0x5c, 0x33, 0x18, 0x76, 0xdc, 0x12, 0x8e, 0x74, 0x4d, 0xad,
		0x46, 0xf9, 0x72, 0x76, 0x06, 0x36, 0xca, 0x97, 0x25, 0xcb, 0x97, 0x99, 0xdb, 0xeb, 0x30, 0xdf,
		0x12, 0x68, 0x2d, 0x3d, 0x25, 0x0f, 0x0f, 0x04, 0xd6, 0xd4, 0xdd, 0x5e, 0x67, 0xf0, 0x25, 0x91,
		0x6f, 0xb1, 0xba, 0x7c, 0x8b, 0x9d, 0xec, 0x8e, 0xc9, 0xeb, 0x46, 0x74, 0x65, 0xb5, 0x37, 0x33,
		0x1d, 0x05, 0xad, 0x3d, 0x75, 0xfb, 0x62, 0xd1, 0xda, 0x93, 0xfa, 0xd3, 0x59, 0xf6, 0x5a, 0xb2,
		0xbd, 0xde, 0xe0, 0x6c, 0x02, 0x99, 0x52, 0xd1, 0x68, 0x25, 0x8a, 0x45, 0x01, 0xb1, 0x24, 0x30,
		0x83, 0x70, 0x4e, 0x91, 0x6d, 0xf9, 0xbe, 0xc3, 0x7c, 0x93, 0xfb, 0x96, 0x1b, 0x38, 0x03, 0xa5,
		0x16, 0xc8, 0xc7, 0x11, 0xe7, 0x6d, 0x86, 0xe0, 0x5d, 0x26, 0x0a, 0x03, 0xc1, 0x3b, 0x43, 0x8f,
		0x3d, 0x91, 0x24, 0xa2, 0x0f, 0x0f, 0x14, 0xe2, 0x77, 0x1f, 0x10, 0xbf, 0x93, 0xdc, 0x07, 0xf1,
		0xbb, 0xa5, 0x47, 0xac, 0x36, 0x20, 0xb5, 0x68, 0xa7, 0x9e, 0xcf, 0x48, 0x9e, 0xa0, 0x54, 0x12,
		0x36, 0xf5, 0xd5, 0xd8, 0x5a, 0x8b, 0xe9, 0x4f, 0x67, 0xe3, 0x2a, 0xda, 0xba, 0x72, 0x97, 0xdc,
		0xd0, 0x92, 0x95, 0xe5, 0xb8, 0xe6, 0x83, 0xef, 0x59, 0x4d, 0xdb, 0x0a, 0xb8, 0xd9, 0xfd, 0xce,
		0x03, 0x95, 0xee, 0x76, 0x6f, 0xb7, 0x02, 0xb4, 0x02, 0xb4, 0x02, 0xb4, 0x02, 0xb4, 0x02, 0xb4,
		0x02, 0xb4, 0x02, 0xb4, 0x4a, 0x38, 0x0e, 0x05, 0x5f, 0x75, 0xbc, 0x87, 0xbc, 0xcf, 0x9a, 0x40,
		0x46, 0x88, 0xf8, 0xb0, 0xef, 0xdc, 0xf1, 0x42, 0xa7, 0xf5, 0xc7, 0xc9, 0x99, 0xfb, 0x69, 0x04,
		0x19, 0xae, 0xc4, 0x11, 0x03, 0xa5, 0x42, 0x9d, 0xa7, 0x58, 0x55, 0x9d, 0xdc, 0xe4, 0x3a, 0x76,
		0xae, 0xae, 0xa5, 0x38, 0x77, 0x54, 0x30, 0xa4, 0xc3, 0xca, 0x4d, 0x27, 0xb0, 0x2d, 0xbf, 0xa9,
		0x86, 0x92, 0xe3, 0x4d, 0x80, 0x8f, 0x81, 0x8f, 0x81, 0x8f, 0x81, 0x8f, 0x81, 0x8f, 0x81, 0x8f,
		0x81, 0x8f, 0x81, 0x8f, 0xc3, 0xe4, 0x84, 0x33, 0xf7, 0x54, 0x0e, 0x1f, 0x00, 0x0d, 0xcb, 0x9d,
		0x32, 0xb0, 0x6f, 0x3a, 0xec, 0xcb, 0x7c, 0xdf, 0xf3, 0xd5, 0x90, 0x6f, 0xb4, 0x05, 0x70, 0x2f,
		0x70, 0x2f, 0x70, 0x2f, 0x70, 0x2f, 0x70, 0x2f, 0x70, 0x2f, 0x70, 0x2f, 0x70, 0x6f, 0x84, 0xc8,
		0xea, 0x32, 0xe8, 0x00, 0xa8, 0x57, 0xe6, 0x8c, 0x81, 0x79, 0xd3, 0x61, 0xde, 0x96, 0x1d, 0x50,
		0xe0, 0xde, 0x89, 0x6d, 0x80, 0x7d, 0x81, 0x7d, 0x81, 0x7d, 0x81, 0x7d, 0x81, 0x7d, 0x81, 0x7d,
		0x37, 0x07, 0xfb, 0xea, 0xd2, 0xcf, 0x9d, 0x5e, 0x9b, 0x3b, 0x34, 0xb9, 0x8b, 0x6f, 0xb6, 0x82,
		0x9e, 0x86, 0x9e, 0x86, 0x9e, 0x86, 0x9e, 0x86, 0x9e, 0x86, 0x9e, 0x86, 0x8f, 0x0a, 0x3e, 0xaa,
		0x79, 0x39, 0x74, 0xe7, 0x23, 0xc8, 0x80, 0xdc, 0x45, 0x8d, 0x7e, 0xab, 0x65, 0xe7, 0x0e, 0xac,
		0x9c, 0x0e, 0x2b, 0x7b, 0x36, 0x67, 0x8a, 0x18, 0x39, 0xda, 0x02, 0xd8, 0x18, 0xd8, 0x18, 0xd8,
		0x18, 0xd8, 0x18, 0xd8, 0x18, 0xd8, 0x18, 0xd8, 0x18, 0xd8, 0x38, 0x8c, 0x2d, 0x0e, 0x80, 0xd9,
		0xa5, 0x0c, 0x3e, 0x00, 0x12, 0x96, 0x3b, 0x65, 0xe0, 0xde, 0x74, 0xb8, 0x57, 0xd9, 0x33, 0x0c,
		0x7f, 0x30, 0x30, 0x2f, 0x30, 0x2f, 0x30, 0x2f, 0x30, 0x2f, 0x30, 0x2f, 0x30, 0xef, 0x06, 0x61,
		0xde, 0xf2, 0xf1, 0x47, 0xe3, 0x9a, 0x75, 0x3c, 0xce, 0x8c, 0x0b, 0xc6, 0x7f, 0x78, 0xfe, 0x77,
		0xe3, 0xdc, 0x73, 0x1d, 0xee, 0xf9, 0x8e, 0xfb, 0x68, 0x9c, 0x5b, 0xae, 0xf5, 0xc8, 0x06, 0x5a,
		0xc2, 0x38, 0x73, 0x5b, 0x9e, 0xdf, 0x09, 0x5b, 0xee, 0xde, 0xb9, 0x9f, 0xac, 0x80, 0x01, 0x02,
		0x4b, 0x43, 0x60, 0x85, 0x43, 0x07, 0x22, 0x4e, 0x87, 0x88, 0x7b, 0x2e, 0x51, 0xce, 0xc4, 0xd4,
		0x46, 0x40, 0xc8, 0x40, 0xc8, 0x40, 0xc8, 0x40, 0xc8, 0x40, 0xc8, 0x40, 0xc8, 0x40, 0xc8, 0x9b,
		0x81, 0x90, 0x53, 0xf9, 0x2b, 0xbf, 0x22, 0x45, 0x42, 0x19, 0x15, 0x0b, 0x1e, 0x34, 0x90, 0x70,
		0x5a, 0x24, 0xfc, 0xdd, 0xf5, 0x7e, 0xb8, 0x66, 0xd7, 0xf7, 0xb8, 0xa7, 0x8a, 0x85, 0xa7, 0xb6,
		0x02, 0x1a, 0x06, 0x1a, 0x06, 0x1a, 0x06, 0x1a, 0x06, 0x1a, 0x06, 0x1a, 0x06, 0x1a, 0x06, 0x1a,
		0x8e, 0xea, 0xaf, 0xbf, 0x0e, 0x51, 0xc2, 0x95, 0x0c, 0x48, 0x00, 0x1e, 0x56, 0x38, 0x6a, 0x20,
		0xe2, 0x14, 0xe7, 0xdc, 0xb6, 0x02, 0x6e, 0xda, 0x6d, 0x66, 0xf9, 0xf2, 0x50, 0x78, 0x62, 0x0f,
		0x60, 0x60, 0x60, 0xe0, 0xb5, 0xc2, 0xc0, 0xdc, 0xe9, 0x30, 0xee, 0xd8, 0xdf, 0x83, 0xcc, 0x51,
		0xf0, 0x57, 0x77, 0x08, 0x40, 0x4a, 0xae, 0xe5, 0x7a, 0x01, 0xb3, 0x3d, 0x57, 0xaa, 0x3f, 0x20,
		0xd0, 0x34, 0xd0, 0x34, 0xd0, 0xf4, 0x9a, 0xa2, 0x69, 0x0c, 0x69, 0x5a, 0xaa, 0x97, 0x8a, 0x39,
		0xa4, 0xc9, 0xeb, 0x71, 0xb2, 0x29, 0x4d, 0x73, 0xf6, 0x02, 0x4c, 0x03, 0x4c, 0x83, 0xab, 0x12,
		0xae, 0x4a, 0x80, 0x2b, 0x80, 0x2b, 0x80, 0x2b, 0xb8, 0x2a, 0x67, 0x4b, 0xee, 0x2f, 0x7b, 0x1c,
		0x73, 0x9a, 0xb2, 0x70, 0x5c, 0x2e, 0x3d, 0x78, 0xb8, 0x31, 0x53, 0xe2, 0x65, 0xf5, 0x49, 0x4d,
		0x53, 0xbb, 0x00, 0x23, 0x03, 0x23, 0x03, 0x23, 0x03, 0x23, 0x03, 0x23, 0x03, 0x23, 0x03, 0x23,
		0x03, 0x23, 0x87, 0x31, 0xe6, 0xcb, 0x1e, 0xc7, 0xac, 0x26, 0xcd, 0x88, 0xf8, 0xcd, 0x31, 0x03,
		0xff, 0xa6, 0xc4, 0xbf, 0xaa, 0x5d, 0xeb, 0x27, 0xf6, 0x00, 0xf6, 0x05, 0xf6, 0x05, 0xf6, 0x05,
		0xf6, 0x05, 0xf6, 0x05, 0xf6, 0x05, 0xf6, 0x05, 0xf6, 0x1d, 0x81, 0x32, 0xcc, 0x6b, 0xca, 0x00,
		0xf9, 0x62, 0x60, 0x93, 0x18, 0xee, 0xa5, 0x9a, 0x08, 0x31, 0x67, 0x2f, 0xe0, 0x60, 0xe0, 0x60,
		0xe0, 0x60, 0xe0, 0x60, 0xe0, 0x60, 0xe0, 0x60, 0xe0, 0x60, 0xe0, 0xe0, 0xb9, 0xe1, 0x7a, 0xcc,
		0x84, 0xc8, 0x02, 0x1b, 0x2f, 0x3d, 0x78, 0xe0, 0xe5, 0x94, 0x78, 0x59, 0x75, 0x2a, 0xc4, 0xc4,
		0x1e, 0xc0, 0xc7, 0xc0, 0xc7, 0xc0, 0xc7, 0xc0, 0xc7, 0xc0, 0xc7, 0xc0, 0xc7, 0xc0, 0xc7, 0xc0,
		0xc7, 0x51, 0x5f, 0xaa, 0xcb, 0x1e, 0xc7, 0x5c, 0x08, 0xad, 0x68, 0xf8, 0xcd, 0x31, 0x03, 0xfb,
		0xa6, 0xc4, 0xbe, 0xea, 0x1e, 0x62, 0xf8, 0x85, 0x81, 0x7b, 0x81, 0x7b, 0x81, 0x7b, 0x81, 0x7b,
		0x81, 0x7b, 0x81, 0x7b, 0x37, 0x08, 0xf7, 0x62, 0x34, 0xc4, 0x0a, 0x50, 0x30, 0x46, 0x43, 0xe8,
		0xc7, 0xc4, 0x34, 0xb3, 0x21, 0x66, 0x76, 0x02, 0x46, 0x06, 0x46, 0x06, 0x46, 0x06, 0x46, 0x06,
		0x46, 0x06, 0x46, 0x06, 0x46, 0xde, 0x0c, 0x8c, 0x9c, 0xce, 0x69, 0x89, 0xe9, 0x10, 0xea, 0xc0,
		0x58, 0xf4, 0xa4, 0x37, 0x17, 0x0d, 0xbf, 0x23, 0xe4, 0x5b, 0xf1, 0x86, 0x7b, 0x82, 0x68, 0x7a,
		0xb6, 0xc1, 0x9e, 0xd7, 0x65, 0x7e, 0x68, 0xd6, 0x58, 0x6d, 0x51, 0x48, 0xad, 0xdc, 0x50, 0x4f,
		0xb2, 0x91, 0x5e, 0xba, 0x23, 0x6f, 0xa4, 0x3c, 0xf2, 0x9a, 0xeb, 0x7a, 0x3c, 0x3c, 0x01, 0x21,
		0x66, 0x2f, 0x05, 0xf6, 0x13, 0xeb, 0x58, 0x5d, 0x8b, 0x3f, 0x0d, 0xbe, 0xfd, 0xae, 0xd7, 0x65,
		0xae, 0x1d, 0x1a, 0x0b, 0xa6, 0x13, 0xf3, 0xcc, 0xee, 0xbc, 0x1f, 0x77, 0x03, 0x6e, 0x71, 0xb6,
		0x1b, 0xc1, 0x3d, 0x11, 0x21, 0x55, 0x0a, 0xb8, 0xdf, 0xb3, 0xb9, 0x1b, 0xc9, 0xc4, 0xcb, 0xf8,
		0x91, 0x63, 0x2e, 0xbd, 0x9f, 0xf7, 0xe3, 0xfd, 0xcd, 0xe0, 0x89, 0xf7, 0x27, 0xa3, 0x27, 0xbe,
		0xa3, 0x39, 0xe5, 0x14, 0x44, 0x5d, 0xb2, 0xbb, 0xbd, 0xd4, 0xc7, 0x3a, 0x46, 0xc2, 0xdd, 0x5e,
		0xca, 0x53, 0x11, 0x34, 0xeb, 0x84, 0xcd, 0x39, 0x19, 0x33, 0x4e, 0xda, 0x7c, 0x93, 0xd5, 0x39,
		0xca, 0xe6, 0x9a, 0xb2, 0x42, 0x51, 0x31, 0xcf, 0x68, 0x05, 0xa8, 0xb0, 0x19, 0x16, 0xdf, 0xd6,
		0x83, 0xe7, 0xb5, 0x99, 0xe5, 0x8a, 0xdc, 0x57, 0x44, 0x7c, 0xe5, 0x72, 0xc1, 0x75, 0x80, 0x7a,
		0x93, 0xd5, 0xd5, 0xe9, 0x82, 0x1d, 0xa8, 0x4a, 0x75, 0x55, 0x49, 0x22, 0xea, 0x9b, 0x2c, 0xb0,
		0x7d, 0xa7, 0x2b, 0xa4, 0x49, 0x63, 0xee, 0x9b, 0x5c, 0x0c, 0xd1, 0x0f, 0xd1, 0x9f, 0xa9, 0xe8,
		0x0f, 0xb8, 0xef, 0xb8, 0x8f, 0x32, 0x92, 0xff, 0x03, 0xe9, 0x1b, 0x28, 0x58, 0xeb, 0x0a, 0x56,
		0xba, 0x82, 0xcb, 0x32, 0xa5, 0xad, 0x58, 0x6b, 0x3b, 0x56, 0xb0, 0x62, 0x3f, 0xb6, 0xaa, 0xf1,
		0xad, 0xc7, 0x95, 0x2d, 0x74, 0x80, 0xba, 0x3d, 0xde, 0xef, 0x68, 0x6d, 0x69, 0x1a, 0x03, 0x82,
		0xb9, 0x03, 0x5e, 0x68, 0x8a, 0x6b, 0x94, 0xd1, 0xc2, 0x94, 0xbc, 0x77, 0xca, 0x5a, 0x56, 0xaf,
		0xcd, 0x85, 0xb8, 0xa7, 0x34, 0xa0, 0x82, 0x12, 0xa9, 0x35, 0x0a, 0xa5, 0x06, 0xa5, 0xb6, 0x66,
		0xf6, 0xcc, 0xda, 0x6a, 0xb5, 0x66, 0xc7, 0x71, 0x6f, 0xb8, 0xc5, 0x7b, 0xd0, 0x6d, 0x2a, 0xba,
		0x6d, 0xe2, 0x18, 0x37, 0x52, 0xc3, 0x39, 0x2d, 0xc7, 0x6d, 0xb2, 0x9f, 0xe2, 0x1a, 0x6e, 0xb4,
		0x10, 0xaa, 0x05, 0xaa, 0x25, 0x53, 0xd5, 0xd2, 0x73, 0x5c, 0xbe, 0x5f, 0x91, 0xd0, 0x2c, 0x47,
		0x02, 0x4b, 0xe4, 0xd2, 0x12, 0x24, 0xc4, 0xbe, 0x4a, 0x1a, 0x82, 0x6a, 0xfa, 0x01, 0x59, 0x00,
		0x5c, 0x3d, 0xf0, 0x2d, 0x91, 0x66, 0xa0, 0x94, 0x5e, 0x10, 0x1f, 0xdd, 0x41, 0xe5, 0xf8, 0xe0,
		0xf8, 0xf0, 0xa8, 0x72, 0x5c, 0x2d, 0xfe, 0x19, 0xae, 0x56, 0x1d, 0xc1, 0xc1, 0x0c, 0x07, 0x73,
		0xa1, 0x63, 0xb1, 0x85, 0x35, 0x15, 0x0c, 0x33, 0x11, 0xe4, 0xc2, 0x36, 0x58, 0x60, 0x1b, 0x2c,
		0x3a, 0xb7, 0x8d, 0x34, 0x06, 0x86, 0xb3, 0x8e, 0x9f, 0x22, 0xec, 0x23, 0x68, 0x10, 0x4c, 0x2e,
		0x86, 0x51, 0x00, 0xa3, 0x20, 0x53, 0xa3, 0x40, 0x6e, 0x92, 0xb1, 0x44, 0xe2, 0xb2, 0xea, 0xe4,
		0x62, 0x58, 0x16, 0x9b, 0x62, 0x59, 0xd0, 0x25, 0x2c, 0xc3, 0xc6, 0x80, 0x8d, 0x01, 0x1b, 0x63,
		0x03, 0x92, 0x58, 0xda, 0xde, 0xa3, 0x63, 0x5b, 0x6d, 0x09, 0xec, 0x15, 0x2d, 0x04, 0xee, 0x02,
		0xee, 0xca, 0x14, 0x77, 0x21, 0x6f, 0x11, 0x22, 0x1f, 0x22, 0x5f, 0x49, 0xe4, 0x7b, 0xdd, 0x07,
		0xcb, 0xfe, 0x6e, 0x76, 0xbc, 0xa6, 0x8c, 0xd1, 0x3d, 0xb5, 0x5c, 0x67, 0xb6, 0x49, 0x78, 0xfc,
		0x48, 0x37, 0x81, 0x1a, 0xda, 0x4c, 0x35, 0x44, 0xc2, 0xec, 0x9d, 0xb8, 0xa5, 0x83, 0x38, 0xa7,
		0x4f, 0xac, 0x05, 0x7b, 0x81, 0xbd, 0x80, 0xf2, 0x80, 0xf2, 0x80, 0xf2, 0x8a, 0x82, 0xf2, 0x3a,
		0x5c, 0xa2, 0x10, 0x71, 0xb0, 0x08, 0xa2, 0x1e, 0xa2, 0x3e, 0x53, 0x51, 0xdf, 0x73, 0x5c, 0x5e,
		0x3e, 0x94, 0x90, 0xf4, 0x87, 0x88, 0x81, 0xbc, 0x59, 0x8f, 0x18, 0x88, 0x71, 0x58, 0xad, 0xee,
		0x23, 0xe8, 0x21, 0xaf, 0x5b, 0xe8, 0x4c, 0x8f, 0xa8, 0x6c, 0x5f, 0x50, 0x05, 0x85, 0xab, 0xa0,
		0x83, 0xa0, 0x83, 0x32, 0xd5, 0x41, 0xda, 0x2b, 0x22, 0x49, 0x38, 0x6a, 0x00, 0x79, 0xcd, 0x60,
		0x58, 0x3a, 0x20, 0xcc, 0x58, 0x93, 0x8b, 0xc1, 0x5f, 0xe0, 0x2f, 0x09, 0xfe, 0x3a, 0xb7, 0xdc,
		0xa6, 0xc5, 0x3d, 0xff, 0x65, 0x40, 0xf8, 0xda, 0x79, 0x92, 0xb9, 0xbd, 0x4e, 0x64, 0xe2, 0xc9,
		0x30, 0xe6, 0x81, 0xc0, 0x9a, 0xba, 0xdb, 0xeb, 0x0c, 0xbe, 0x64, 0x1f, 0xae, 0x03, 0xb8, 0x0e,
		0x8a, 0xec, 0x3a, 0xd8, 0xf0, 0x12, 0xc5, 0xcb, 0x2e, 0xf3, 0x51, 0xa1, 0x98, 0x48, 0x6e, 0xe2,
		0xa7, 0xb8, 0x91, 0x86, 0x0b, 0x17, 0x51, 0x59, 0xe3, 0x7c, 0xd0, 0xc1, 0x2a, 0x00, 0x2b, 0x00,
		0xab, 0xdc, 0x03, 0x2b, 0xa7, 0xc9, 0x5c, 0xee, 0xf0, 0x17, 0x9f, 0xb5, 0x64, 0x80, 0x95, 0x80,
		0x77, 0xa5, 0x74, 0x16, 0x3d, 0x2a, 0xec, 0x20, 0x2f, 0xdd, 0x0b, 0x3d, 0x6e, 0x25, 0x68, 0x86,
		0x4c, 0xb6, 0xa2, 0x4b, 0x5a, 0x57, 0xa5, 0x79, 0x9b, 0x5e, 0x70, 0x41, 0x5d, 0x26, 0x9d, 0xdf,
		0xfa, 0x29, 0xca, 0x77, 0x0a, 0x3c, 0x23, 0xda, 0x64, 0x54, 0xb5, 0xb9, 0x68, 0x0a, 0xb2, 0x51,
		0xeb, 0x25, 0xba, 0xf8, 0x7e, 0x93, 0xcf, 0x6a, 0xc1, 0x39, 0x95, 0x82, 0xde, 0xc3, 0xf8, 0x8d,
		0x96, 0x1e, 0xd3, 0xd8, 0x55, 0x35, 0xb5, 0x6c, 0xc9, 0x3d, 0x8c, 0x64, 0xf6, 0x92, 0x8f, 0xa5,
		0x05, 0x18, 0x22, 0xc0, 0x42, 0x18, 0x50, 0x88, 0x0a, 0x14, 0x69, 0x00, 0x21, 0x2d, 0x2d, 0x64,
		0x00, 0x83, 0x1a, 0x1f, 0x9d, 0x3a, 0x7e, 0x4a, 0x06, 0x9a, 0xa0, 0x0a, 0x71, 0xec, 0x3a, 0xb5,
		0x5a, 0x0c, 0xc3, 0x96, 0x81, 0x61, 0x81, 0x61, 0x45, 0x48, 0x35, 0x5e, 0x60, 0x8f, 0x28, 0x42,
		0x12, 0x15, 0x46, 0xeb, 0xe5, 0xe6, 0xe2, 0x94, 0x31, 0x17, 0x27, 0x03, 0xf2, 0xd6, 0x8b, 0xcf,
		0x72, 0x39, 0x17, 0x47, 0x94, 0x0d, 0xe2, 0x85, 0x32, 0xed, 0x64, 0x13, 0x29, 0x46, 0xbc, 0xbd,
		0xac, 0xa2, 0x8f, 0x82, 0x8c, 0x61, 0x28, 0x18, 0x87, 0x8c, 0x81, 0xa8, 0x18, 0x89, 0x9c, 0xa1,
		0xc8, 0x19, 0x8b, 0x92, 0xc1, 0xe4, 0x18, 0x4d, 0x92, 0xe1, 0xe4, 0xfd, 0x21, 0xc9, 0x68, 0x48,
		0x34, 0x18, 0x9c, 0xa8, 0x64, 0x3e, 0x64, 0x7a, 0x02, 0x04, 0xc3, 0x6f, 0x08, 0x1c, 0x16, 0xea,
		0x0e, 0x0c, 0x55, 0x87, 0x86, 0x6c, 0xfb, 0x5d, 0x5d, 0x5c, 0xaf, 0xc3, 0xe3, 0xa1, 0x5d, 0x10,
		0xa8, 0x78, 0x44, 0x24, 0xdb, 0xf7, 0xd2, 0xc8, 0x0f, 0xf5, 0xd5, 0x8d, 0x8c, 0x46, 0xf4, 0xc8,
		0xe4, 0xc8, 0x89, 0xb6, 0x07, 0x4e, 0xe4, 0x25, 0xb1, 0x76, 0xc1, 0xb3, 0x30, 0x47, 0xa2, 0xa0,
		0x6b, 0x66, 0x93, 0xf4, 0xed, 0x84, 0x67, 0xae, 0x08, 0xa0, 0x06, 0xa0, 0x06, 0xa0, 0x46, 0x80,
		0x5a, 0xc4, 0x0b, 0x6a, 0x12, 0x51, 0x4d, 0x19, 0xa8, 0x66, 0x15, 0xa8, 0x46, 0xa9, 0xfd, 0x32,
		0xb0, 0x0d, 0x15, 0xb6, 0x51, 0x69, 0xdf, 0x0c, 0x84, 0xb3, 0xfc, 0x4e, 0xc4, 0x9a, 0x43, 0x27,
		0x72, 0x95, 0x48, 0xab, 0x68, 0x3d, 0xe8, 0x66, 0x0f, 0xd0, 0x06, 0xd0, 0x06, 0xd0, 0x46, 0x3f,
		0xb4, 0x11, 0x6e, 0xcf, 0x9d, 0xc4, 0x3b, 0x47, 0x0a, 0x5b, 0xa8, 0x4d, 0x15, 0x27, 0x84, 0x15,
		0x14, 0x53, 0xc6, 0xe3, 0xcd, 0x88, 0xa6, 0x8d, 0xc7, 0xfb, 0x51, 0xcf, 0xbf, 0x1e, 0xd3, 0x02,
		0xd5, 0x1c, 0x6c, 0x45, 0xb2, 0x9e, 0xbe, 0x0a, 0x82, 0x69, 0xe4, 0x33, 0x57, 0xa1, 0xda, 0x3e,
		0xbc, 0xc8, 0x77, 0xb2, 0xee, 0x70, 0x49, 0x6b, 0x64, 0x4a, 0xb8, 0x1c, 0x41, 0x4d, 0x28, 0x69,
		0x29, 0x4f, 0x48, 0xd0, 0xa3, 0x12, 0x79, 0xf8, 0x73, 0x15, 0xa8, 0xee, 0x60, 0x62, 0x43, 0x34,
		0xb8, 0x2f, 0x37, 0xab, 0x39, 0x5e, 0xaf, 0x90, 0x56, 0x35, 0x99, 0x65, 0x34, 0xf5, 0xb7, 0x5d,
		0xa9, 0xb8, 0xbb, 0xa1, 0x94, 0x82, 0x35, 0xf9, 0x65, 0xa6, 0xfe, 0x76, 0x1f, 0xc1, 0x56, 0x5d,
		0xc3, 0xce, 0x05, 0x52, 0x48, 0xe4, 0xec, 0x16, 0x25, 0x7b, 0x45, 0x12, 0xf3, 0x23, 0x99, 0x01,
		0xc9, 0x0c, 0x9a, 0x31, 0xfa, 0xb8, 0x5b, 0x1c, 0xb3, 0x5a, 0x62, 0x79, 0xe6, 0x33, 0xee, 0x46,
		0x09, 0x54, 0x5e, 0xba, 0x8a, 0x44, 0xde, 0xfb, 0xf7, 0x91, 0xb8, 0xda, 0x1d, 0xf2, 0x57, 0x0e,
		0xe4, 0xc4, 0x30, 0x61, 0x55, 0x5a, 0x4e, 0xa4, 0xcd, 0x77, 0x9d, 0x7b, 0x94, 0xb2, 0x72, 0xa2,
		0x02, 0x39, 0x01, 0x39, 0xb1, 0xc8, 0x5f, 0x26, 0x9b, 0xf4, 0x64, 0x35, 0x3b, 0x8e, 0x2b, 0x5a,
		0xd2, 0x9e, 0x48, 0x32, 0x53, 0xbb, 0xc1, 0x8d, 0x06, 0x37, 0xda, 0x06, 0xb8, 0xd1, 0x24, 0x4a,
		0xc7, 0x34, 0xba, 0xe2, 0xe4, 0x6a, 0xf6, 0x13, 0xf5, 0xd5, 0x81, 0xc2, 0x1e, 0x62, 0x35, 0xfd,
		0x54, 0xd7, 0x21, 0x6d, 0x64, 0xd3, 0x78, 0x00, 0xb5, 0x1a, 0xdd, 0xf4, 0xc6, 0x37, 0x91, 0x11,
		0x4e, 0xe0, 0xb3, 0x23, 0x3f, 0x76, 0xf9, 0x1e, 0x03, 0x38, 0x6e, 0x1c, 0x37, 0x9d, 0x5e, 0x69,
		0x20, 0xed, 0x62, 0xbe, 0xaa, 0x42, 0xda, 0x45, 0xd6, 0x20, 0x6b, 0x2e, 0x3f, 0x20, 0xed, 0x82,
		0xfe, 0x79, 0x32, 0x69, 0x17, 0xb6, 0xd7, 0x1b, 0x9c, 0x3d, 0x81, 0x15, 0x16, 0xef, 0xa4, 0x66,
		0x81, 0x95, 0x61, 0x81, 0xc1, 0x02, 0x2b, 0x82, 0x05, 0x26, 0xeb, 0xfc, 0x18, 0xb3, 0x9e, 0xe5,
		0xfb, 0x0e, 0xf3, 0x4d, 0xee, 0x5b, 0x6e, 0xe0, 0x0c, 0x40, 0x4c, 0xa0, 0x7e, 0xe1, 0x31, 0x37,
		0xce, 0xd9, 0x5c, 0xf1, 0xa6, 0xd4, 0x5c, 0x24, 0x64, 0x8c, 0x4a, 0xc9, 0xb0, 0xe4, 0x8c, 0x9b,
		0x85, 0xc2, 0x27, 0x61, 0xe4, 0x6c, 0xb5, 0xbd, 0x22, 0x63, 0x13, 0x29, 0x70, 0x45, 0x7a, 0x53,
		0x76, 0x97, 0x24, 0xa9, 0x4c, 0xa1, 0x49, 0xa2, 0xcb, 0xd8, 0xf3, 0x03, 0xc1, 0x56, 0x34, 0x49,
		0x4d, 0x74, 0xe0, 0x7d, 0xec, 0xf5, 0x22, 0x4c, 0x72, 0x8a, 0x37, 0x25, 0x4e, 0x76, 0x8a, 0xf7,
		0xd5, 0x95, 0x60, 0x33, 0x26, 0x23, 0xea, 0x44, 0x1b, 0x22, 0x4e, 0x79, 0xe3, 0xa8, 0xfc, 0xa9,
		0xef, 0xca, 0xe8, 0x26, 0x9f, 0xae, 0xe3, 0x2d, 0xbe, 0xcb, 0xc7, 0x2e, 0x8d, 0x95, 0x4a, 0x6d,
		0x65, 0xcf, 0x2c, 0xad, 0x18, 0xcb, 0xc4, 0x53, 0xab, 0xcf, 0xa7, 0x45, 0xec, 0xdb, 0xa2, 0x21,
		0xb2, 0xc6, 0x2a, 0x5c, 0x99, 0x25, 0xc7, 0x35, 0x1f, 0x7c, 0xcf, 0x6a, 0xda, 0x56, 0xc0, 0xcd,
		0xee, 0x77, 0x4e, 0x08, 0xde, 0x67, 0xb7, 0x06, 0x74, 0x07, 0x74, 0x07, 0x74, 0x07, 0x74, 0x07,
		0x74, 0x07, 0x74, 0x07, 0x74, 0x07, 0x74, 0xdf, 0x08, 0xe8, 0x4e, 0x18, 0x8b, 0x8c, 0xf7, 0xa4,
		0x8b, 0x49, 0x6a, 0x90, 0x91, 0x22, 0x31, 0xca, 0x3b, 0x77, 0xbc, 0xd0, 0x69, 0xfd, 0x71, 0x72,
		0xe6, 0x7e, 0x1a, 0x41, 0xc6, 0x2b, 0x75, 0xc4, 0xa8, 0x13, 0x10, 0xcd, 0x03, 0x46, 0xd4, 0x41,
		0x4c, 0xed, 0x18, 0x69, 0x2e, 0x56, 0xa2, 0xb8, 0x37, 0xc8, 0x10, 0xa2, 0xe7, 0x2b, 0xda, 0x76,
		0x4d, 0x27, 0xb0, 0x2d, 0xbf, 0x49, 0x6b, 0xd5, 0xc5, 0x9b, 0xc2, 0x9e, 0x83, 0x3d, 0x07, 0x7b,
		0x0e, 0xf6, 0x1c, 0xec, 0x39, 0xd8, 0x73, 0xb0, 0xe7, 0x60, 0xcf, 0xc1, 0x9e, 0xdb, 0x74, 0x7b,
		0xce, 0x70, 0x5a, 0x67, 0xee, 0x29, 0x0d, 0x3e, 0x84, 0xf5, 0xa6, 0xcb, 0x7a, 0x9b, 0xbe, 0x25,
		0xc8, 0x87, 0x7c, 0xd8, 0x6a, 0xcc, 0xf7, 0x3d, 0x9f, 0xd6, 0x52, 0x8b, 0xb6, 0x84, 0x9d, 0x06,
		0x3b, 0x0d, 0x76, 0x1a, 0xec, 0x34, 0xd8, 0x69, 0xb0, 0xd3, 0x60, 0xa7, 0xc1, 0x4e, 0x83, 0x9d,
		0x06, 0x3b, 0xad, 0x75, 0xe6, 0xd6, 0x29, 0xd0, 0x21, 0xac, 0x34, 0xad, 0x56, 0x5a, 0x74, 0x47,
		0x90, 0x0d, 0xf9, 0xb0, 0xd1, 0x5a, 0x76, 0xa0, 0xc3, 0x4e, 0x9b, 0xd8, 0x16, 0xb6, 0x1a, 0x6c,
		0x35, 0xd8, 0x6a, 0xb0, 0xd5, 0x60, 0xab, 0xc1, 0x56, 0x83, 0xad, 0x06, 0x5b, 0x0d, 0x78, 0x6c,
		0x11, 0x1e, 0xeb, 0xf4, 0xda, 0xdc, 0xd1, 0x53, 0xbb, 0xf2, 0x66, 0x6b, 0xe0, 0x32, 0xe0, 0x32,
		0xe0, 0x32, 0xe0, 0x32, 0xe0, 0x32, 0xe0, 0x32, 0xe0, 0x32, 0xe0, 0xb2, 0x62, 0xe0, 0x32, 0xf8,
		0xd0, 0xe5, 0x94, 0x8b, 0x5c, 0x0d, 0xc4, 0xf9, 0x08, 0x32, 0xa2, 0x76, 0x45, 0x3f, 0x46, 0x9a,
		0x8b, 0x95, 0x28, 0xee, 0x0d, 0x32, 0x24, 0x1f, 0xb6, 0x9d, 0x67, 0x73, 0x46, 0x6c, 0xd3, 0x45,
		0x5b, 0xc2, 0x96, 0x83, 0x2d, 0x07, 0x5b, 0x0e, 0xb6, 0x1c, 0x6c, 0x39, 0xd8, 0x72, 0xb0, 0xe5,
		0x60, 0xcb, 0xc1, 0x96, 0xdb, 0x74, 0x5b, 0x2e, 0x32, 0x04, 0x2e, 0x29, 0xf0, 0x21, 0x2c, 0x37,
		0x5d, 0x96, 0xdb, 0xf4, 0x2d, 0x41, 0x3e, 0xe4, 0xc3, 0x4e, 0x23, 0x8f, 0xbc, 0x21, 0xde, 0x06,
		0x1b, 0x0d, 0x36, 0x1a, 0x6c, 0x34, 0xd8, 0x68, 0xb0, 0xd1, 0x60, 0xa3, 0xc1, 0x46, 0x83, 0x8d,
		0xb6, 0x21, 0x36, 0x5a, 0xf9, 0xf8, 0xa3, 0x71, 0xcd, 0x3a, 0x1e, 0x67, 0xc6, 0x05, 0xe3, 0x3f,
		0x3c, 0xff, 0xbb, 0x71, 0xee, 0xb9, 0x0e, 0xf7, 0x7c, 0xc7, 0x7d, 0x34, 0xce, 0x2d, 0xd7, 0x7a,
		0x64, 0x03, 0x2d, 0x6d, 0x9c, 0xb9, 0x2d, 0xcf, 0xef, 0x84, 0x23, 0xd3, 0xee, 0xdc, 0x4f, 0x56,
		0xc0, 0x60, 0xb2, 0xad, 0xcc, 0x64, 0x53, 0xb8, 0x34, 0x48, 0x8f, 0x7c, 0x58, 0x70, 0x3d, 0x57,
		0x53, 0x0e, 0xe5, 0xd4, 0xc6, 0xb0, 0xe8, 0x60, 0xd1, 0xc1, 0xa2, 0x83, 0x45, 0x07, 0x8b, 0x0e,
		0x16, 0x1d, 0x2c, 0x3a, 0x58, 0x74, 0xb0, 0xe8, 0xd6, 0xdf, 0xa2, 0x4b, 0x15, 0xcf, 0xf9, 0x8a,
		0x94, 0xc9, 0x95, 0x5b, 0x71, 0x82, 0x17, 0x05, 0x29, 0x91, 0x17, 0xcb, 0xed, 0xbb, 0xeb, 0xfd,
		0x70, 0xcd, 0xae, 0xef, 0x71, 0x8f, 0xda, 0x76, 0x9b, 0xda, 0x1a, 0xd6, 0x1b, 0xac, 0x37, 0x58,
		0x6f, 0xb0, 0xde, 0x60, 0xbd, 0xc1, 0x7a, 0x83, 0xf5, 0x06, 0xeb, 0x0d, 0xd6, 0x1b, 0xac, 0xb7,
		0xd6, 0x99, 0xfb, 0x75, 0x88, 0x12, 0xaf, 0x28, 0x40, 0x22, 0xec, 0x37, 0x8d, 0xf6, 0xdb, 0xdb,
		0xab, 0x82, 0xa4, 0xc8, 0x81, 0x05, 0xd7, 0xb6, 0x02, 0x6e, 0xda, 0x6d, 0x66, 0xf9, 0x74, 0xa6,
		0xdb, 0xc4, 0x9e, 0xb0, 0xd9, 0x60, 0xb3, 0xc1, 0x66, 0xcb, 0x91, 0xcd, 0xc6, 0x9d, 0x0e, 0xe3,
		0x8e, 0xfd, 0x3d, 0xc8, 0x9d, 0xd5, 0xf6, 0xd5, 0x1d, 0x02, 0xd4, 0x92, 0x6b, 0xb9, 0x5e, 0xc0,
		0x6c, 0xcf, 0x25, 0x99, 0xdf, 0x01, 0x6b, 0x10, 0xd6, 0x20, 0xac, 0x41, 0x58, 0x83, 0x6b, 0x61,
		0x0d, 0xd6, 0x7f, 0x86, 0xb7, 0xa6, 0x2e, 0xca, 0xe8, 0x21, 0x82, 0x67, 0x9b, 0xec, 0x27, 0xff,
		0xc8, 0x59, 0x9b, 0x75, 0x18, 0xf7, 0x5f, 0x4c, 0xcf, 0x35, 0xed, 0xa7, 0x50, 0xf6, 0x6a, 0x81,
		0x0d, 0x21, 0x79, 0x69, 0xc0, 0x0d, 0xab, 0x86, 0x0c, 0x8d, 0x95, 0x98, 0x01, 0x5e, 0x8f, 0x9b,
		0x0f, 0xa3, 0xf9, 0xb9, 0xc4, 0x59, 0x78, 0x73, 0xf6, 0x86, 0x59, 0x00, 0xb3, 0x00, 0x66, 0x41,
		0x8e, 0xcc, 0x02, 0x84, 0x72, 0x00, 0xde, 0x01, 0xde, 0x01, 0xde, 0x01, 0xde, 0xf5, 0x49, 0x6d,
		0x84, 0x72, 0x04, 0x5a, 0xe2, 0x5d, 0xf6, 0xf8, 0xa7, 0x11, 0x66, 0x44, 0x62, 0x9e, 0x7e, 0x90,
		0x34, 0x17, 0x2c, 0x91, 0x5c, 0x1c, 0xa4, 0x08, 0xd1, 0xf3, 0x55, 0xed, 0xbb, 0xe6, 0x68, 0xdc,
		0x2e, 0xa9, 0x65, 0xd7, 0xa4, 0x19, 0xb5, 0x0c, 0x9b, 0x0e, 0x36, 0x1d, 0x6c, 0x3a, 0xd8, 0x74,
		0xb0, 0xe9, 0x60, 0xd3, 0xc1, 0xa6, 0x83, 0x4d, 0x07, 0x9b, 0x6e, 0x2d, 0xd2, 0xf3, 0x2e, 0x7b,
		0xfc, 0x94, 0x06, 0x20, 0xc2, 0x82, 0xd3, 0x65, 0xc1, 0xbd, 0xb9, 0x26, 0x48, 0x88, 0x9c, 0xd8,
		0x6b, 0xd4, 0x53, 0x5e, 0x27, 0xf6, 0x84, 0xad, 0x06, 0x5b, 0x0d, 0xb6, 0x1a, 0x6c, 0x35, 0xd8,
		0x6a, 0xb0, 0xd5, 0x60, 0xab, 0xc1, 0x56, 0x83, 0xad, 0x06, 0x5b, 0x6d, 0x60, 0x04, 0xd4, 0x29,
		0xe0, 0x21, 0x2c, 0x35, 0xbd, 0x96, 0x5a, 0x74, 0x49, 0x90, 0x0e, 0x39, 0xb1, 0xd3, 0x74, 0x4d,
		0x80, 0x9e, 0xb3, 0x37, 0xec, 0x36, 0xd8, 0x6d, 0xb0, 0xdb, 0x60, 0xb7, 0xc1, 0x6e, 0x83, 0xdd,
		0x06, 0xbb, 0x0d, 0x76, 0x1b, 0xec, 0xb6, 0x4d, 0xb7, 0xdb, 0xe6, 0xa4, 0xdf, 0x61, 0x06, 0x74,
		0x11, 0x6c, 0xb9, 0xa5, 0x17, 0x07, 0x29, 0x92, 0x13, 0xfb, 0x8e, 0x7a, 0x0a, 0xf4, 0xc4, 0x9e,
		0xb0, 0xe7, 0x60, 0xcf, 0xc1, 0x9e, 0x83, 0x3d, 0x07, 0x7b, 0x0e, 0xf6, 0x1c, 0xec, 0x39, 0xd8,
		0x73, 0xb0, 0xe7, 0x36, 0xdd, 0x9e, 0x1b, 0xd9, 0x02, 0x98, 0x03, 0x9d, 0x6b, 0xeb, 0xed, 0xcd,
		0x35, 0x41, 0x42, 0xe4, 0xc4, 0x56, 0xa3, 0x8f, 0xc0, 0x21, 0xee, 0x06, 0x3b, 0x0d, 0x76, 0x1a,
		0xec, 0x34, 0xd8, 0x69, 0xb0, 0xd3, 0x60, 0xa7, 0xc1, 0x4e, 0x83, 0x9d, 0xb6, 0x21, 0x76, 0x1a,
		0x46, 0x41, 0x17, 0xd0, 0x6a, 0xc3, 0x28, 0xe8, 0xe2, 0xdb, 0x70, 0x7a, 0x66, 0x41, 0xcf, 0xec,
		0x0c, 0x9b, 0x0e, 0x36, 0x1d, 0x6c, 0x3a, 0xd8, 0x74, 0xb0, 0xe9, 0x60, 0xd3, 0xc1, 0xa6, 0x83,
		0x4d, 0x07, 0x9b, 0x6e, 0xfd, 0x6d, 0xba, 0x74, 0x41, 0x1d, 0x4c, 0x83, 0x5e, 0xbd, 0x21, 0x27,
		0x7a, 0x53, 0x90, 0x13, 0x54, 0xd6, 0xdb, 0xbb, 0x0c, 0xe5, 0x92, 0xfa, 0x40, 0x0b, 0x45, 0xeb,
		0x70, 0x76, 0x80, 0x85, 0xd7, 0x65, 0x7e, 0xe8, 0x16, 0xb0, 0xda, 0xaa, 0x26, 0x22, 0xf9, 0xc0,
		0x0a, 0xa2, 0x41, 0x15, 0x0a, 0x4a, 0x04, 0xc7, 0x9d, 0x15, 0x47, 0x35, 0x24, 0x39, 0xaa, 0xe6,
		0xba, 0x1e, 0x0f, 0x4f, 0x54, 0x49, 0xd7, 0x94, 0x02, 0xfb, 0x89, 0x75, 0xac, 0xae, 0xc5, 0x9f,
		0x06, 0x6f, 0xbf, 0xeb, 0x75, 0x99, 0x6b, 0x87, 0xbe, 0x0a, 0xd3, 0x89, 0x45, 0xf2, 0xee, 0xbc,
		0x1f, 0x77, 0x83, 0xde, 0xc3, 0xc4, 0xef, 0x27, 0xff, 0xb6, 0x1b, 0x70, 0x8b, 0xb3, 0xdd, 0xc8,
		0xd0, 0x53, 0x51, 0xaf, 0xa5, 0x80, 0xfb, 0x3d, 0x9b, 0xbb, 0x91, 0x76, 0xbf, 0x8c, 0xbf, 0xdd,
		0x58, 0x5f, 0xdc, 0xcf, 0xfb, 0xf1, 0xfe, 0x66, 0xf2, 0xcb, 0x4d, 0xfd, 0xed, 0xfe, 0x66, 0xf0,
		0xe5, 0xee, 0x4f, 0x46, 0x5f, 0xee, 0x5d, 0x36, 0x77, 0x2d, 0xc1, 0x8c, 0x25, 0xbb, 0xdb, 0x93,
		0xbe, 0xdc, 0xb1, 0xb9, 0xdd, 0xed, 0x49, 0x5e, 0x80, 0xa2, 0xef, 0x4b, 0xd9, 0xe7, 0x45, 0xe1,
		0xeb, 0x22, 0xf3, 0x71, 0x51, 0x01, 0x3b, 0x72, 0x9f, 0x16, 0x39, 0x6a, 0xa3, 0xf4, 0x61, 0x65,
		0x8b, 0x32, 0x94, 0x7d, 0x55, 0x31, 0xb5, 0x3c, 0x78, 0x5e, 0x9b, 0x59, 0xae, 0x0a, 0xbd, 0x44,
		0xcc, 0x53, 0x2e, 0x6f, 0x38, 0xd0, 0xa2, 0x9f, 0x14, 0x06, 0xc0, 0x05, 0xc0, 0x85, 0xe3, 0x2e,
		0x0a, 0xbe, 0xcd, 0x04, 0x29, 0x35, 0x59, 0x60, 0xfb, 0x4e, 0x57, 0x09, 0x0e, 0xc7, 0xc2, 0x7f,
		0x72, 0x33, 0x20, 0x27, 0x20, 0x27, 0x20, 0x27, 0x01, 0x6a, 0x09, 0xb8, 0xef, 0xb8, 0x8f, 0x14,
		0xc0, 0xe9, 0x43, 0xa6, 0x27, 0x40, 0xe8, 0x31, 0x27, 0xf4, 0x94, 0x13, 0x86, 0x5d, 0x53, 0xfa,
		0x5b, 0x6b, 0x6d, 0xc7, 0x0a, 0x72, 0x9e, 0x0b, 0x40, 0xed, 0x00, 0xcf, 0x26, 0x1d, 0x40, 0xe8,
		0x02, 0x56, 0x9d, 0x35, 0x20, 0xbd, 0xba, 0x91, 0x63, 0x7f, 0x0a, 0x73, 0x07, 0xbc, 0xdd, 0x54,
		0x47, 0x08, 0xa3, 0x8d, 0x24, 0x65, 0xcd, 0x29, 0x6b, 0x59, 0xbd, 0x36, 0x57, 0x92, 0x0e, 0xa5,
		0x01, 0x95, 0x96, 0x32, 0x75, 0x39, 0x02, 0xd4, 0x00, 0xd4, 0xc0, 0x1d, 0x54, 0x28, 0x77, 0x10,
		0x50, 0x4d, 0xa4, 0x54, 0x9b, 0x1d, 0xc7, 0xbd, 0xe1, 0x16, 0xef, 0x01, 0xdb, 0xac, 0x12, 0xdb,
		0x4c, 0x5c, 0x03, 0x10, 0x8e, 0x06, 0x84, 0xe3, 0xb4, 0x1c, 0xb7, 0xc9, 0x7e, 0xaa, 0x23, 0x9c,
		0xd1, 0x46, 0x80, 0x0a, 0x80, 0x0a, 0x80, 0x0a, 0x02, 0xd4, 0xd2, 0x73, 0x5c, 0xbe, 0x5f, 0x21,
		0x40, 0x0a, 0x47, 0x0a, 0x5b, 0xd0, 0xa4, 0x32, 0x13, 0xa8, 0x69, 0xca, 0xd4, 0x65, 0xea, 0x94,
		0x65, 0x6d, 0x49, 0xae, 0xf4, 0xc9, 0xad, 0x04, 0xa9, 0xc9, 0xa4, 0x29, 0xc9, 0xf1, 0x55, 0x1c,
		0x54, 0x8e, 0x0f, 0x8e, 0x0f, 0x8f, 0x2a, 0xc7, 0xd5, 0xcd, 0xbb, 0x93, 0x62, 0xc1, 0x0f, 0xc4,
		0x93, 0xd3, 0xea, 0x41, 0x04, 0x38, 0x11, 0x4f, 0xc6, 0x71, 0x67, 0x70, 0xdc, 0x99, 0x3a, 0x2f,
		0x37, 0xc6, 0x13, 0x62, 0x98, 0x89, 0x36, 0x38, 0x5c, 0x1f, 0x1a, 0x5d, 0x1f, 0x8b, 0xce, 0x1d,
		0xbe, 0x0e, 0x1d, 0xbe, 0x0e, 0x22, 0x4f, 0x87, 0x8a, 0x9f, 0x83, 0x24, 0x92, 0xb3, 0x87, 0x30,
		0x0e, 0x7c, 0x33, 0xf0, 0xcd, 0xc0, 0x37, 0x03, 0xdf, 0x0c, 0x7c, 0x33, 0xf0, 0xcd, 0x6c, 0x9e,
		0x6f, 0x26, 0x13, 0xb8, 0xd4, 0xb6, 0x02, 0x3e, 0xf2, 0x97, 0x28, 0x83, 0xa6, 0xc9, 0xcd, 0x00,
		0x43, 0x00, 0x43, 0x00, 0x43, 0x04, 0xa8, 0x85, 0x3b, 0x1d, 0xc6, 0x1d, 0xfb, 0x7b, 0xa0, 0xd4,
		0x02, 0x87, 0xa0, 0xf5, 0x4d, 0xe9, 0xab, 0x3b, 0x14, 0xe4, 0x25, 0xd7, 0x72, 0xbd, 0x80, 0xd9,
		0x9e, 0xdb, 0x54, 0xaa, 0xd6, 0x04, 0xb6, 0x01, 0xb6, 0xc9, 0x04, 0xdb, 0xe8, 0x6b, 0x81, 0x03,
		0x94, 0xa3, 0x0b, 0xe5, 0x20, 0x02, 0x95, 0x56, 0xcd, 0x22, 0x24, 0x82, 0x08, 0x14, 0x8e, 0x3b,
		0x83, 0xe3, 0xce, 0x71, 0x45, 0x63, 0xdb, 0x7b, 0x74, 0x6c, 0xab, 0x4d, 0x60, 0xaa, 0x45, 0x1b,
		0xc1, 0x4c, 0x83, 0x99, 0x06, 0x33, 0x4d, 0x80, 0x5a, 0xd0, 0x03, 0x02, 0x88, 0x09, 0x2a, 0x1c,
		0xc7, 0x8d, 0xe3, 0x2e, 0x06, 0x62, 0xea, 0xc4, 0x5d, 0xff, 0xd5, 0x41, 0xd3, 0xc4, 0x5e, 0xc0,
		0x4d, 0xc0, 0x4d, 0xc0, 0x4d, 0xc0, 0x4d, 0xc0, 0x4d, 0x50, 0xe4, 0x38, 0x6e, 0x1c, 0xf7, 0xda,
		0xe1, 0xa6, 0xa8, 0xb9, 0xaa, 0x22, 0x62, 0x0a, 0x77, 0x01, 0x56, 0x02, 0x56, 0x02, 0x56, 0x12,
		0xa0, 0x96, 0xa2, 0x76, 0xcb, 0x02, 0x54, 0x82, 0xee, 0x86, 0xee, 0x5e, 0xbd, 0xee, 0x1e, 0x1c,
		0xbf, 0x19, 0x0c, 0x1b, 0x6a, 0x28, 0xab, 0xf0, 0xc9, 0xcd, 0xa0, 0xc9, 0xa1, 0xc9, 0x37, 0x40,
		0x93, 0x9f, 0x5b, 0x6e, 0xd3, 0xe2, 0x9e, 0xff, 0x32, 0x50, 0xa1, 0x2b, 0x47, 0x03, 0xcc, 0xed,
		0x75, 0x22, 0x71, 0x4a, 0x01, 0x09, 0x0e, 0x14, 0xf6, 0xa8, 0xbb, 0xbd, 0xce, 0xe0, 0xa5, 0xfa,
		0x80, 0x15, 0x80, 0x15, 0x80, 0x15, 0x38, 0xee, 0x0d, 0x45, 0x71, 0xa8, 0x36, 0x9f, 0xaf, 0xaa,
		0x52, 0x36, 0x7c, 0xbb, 0xec, 0x32, 0x1f, 0x6d, 0xf7, 0x56, 0xdd, 0x76, 0x6f, 0xe2, 0x16, 0x50,
		0x5a, 0x45, 0xba, 0x42, 0x50, 0x88, 0xab, 0x4e, 0xed, 0xd2, 0x38, 0xad, 0x4b, 0x82, 0xee, 0xb5,
		0x0d, 0xe7, 0x12, 0xa3, 0xd2, 0xf4, 0x37, 0x96, 0xee, 0x93, 0x29, 0xef, 0x74, 0x20, 0x3d, 0x44,
		0xfb, 0x07, 0x94, 0xbe, 0x38, 0x01, 0xaf, 0x71, 0xee, 0x0b, 0xdd, 0x7e, 0xe9, 0xdc, 0x71, 0xeb,
		0xed, 0x30, 0x1b, 0x41, 0xb0, 0x1e, 0xa1, 0x74, 0x6e, 0xfd, 0x9c, 0x58, 0xa9, 0x56, 0x35, 0x51,
		0xba, 0xf4, 0x9b, 0xcc, 0x67, 0xcd, 0x4f, 0x83, 0xd7, 0x76, 0x7b, 0xed, 0x36, 0xe9, 0x69, 0x4a,
		0x72, 0x86, 0x16, 0x8e, 0x10, 0xe0, 0x05, 0x0d, 0x3c, 0x90, 0x8e, 0xfa, 0x97, 0xd3, 0xf2, 0xe2,
		0x4f, 0x2c, 0xb9, 0x17, 0xd1, 0xfb, 0xa0, 0xba, 0x87, 0x14, 0x47, 0x4f, 0x73, 0xe4, 0x8b, 0x4f,
		0x39, 0xf9, 0xec, 0xe6, 0xff, 0x4b, 0xc2, 0x69, 0x8e, 0x64, 0xc4, 0x82, 0xe0, 0x58, 0x3a, 0x91,
		0x90, 0x5e, 0x04, 0x28, 0xb1, 0x7c, 0x3a, 0x16, 0x4f, 0x7a, 0xd9, 0x94, 0x24, 0x23, 0x4f, 0x2a,
		0x0b, 0x88, 0x43, 0x96, 0x28, 0xe6, 0x93, 0xc1, 0xec, 0x25, 0x4f, 0xff, 0xe6, 0xcd, 0x09, 0x2c,
		0x7b, 0x73, 0xd1, 0x37, 0x9e, 0xf3, 0x9e, 0x62, 0xef, 0x37, 0xfd, 0x56, 0xe3, 0xef, 0x3e, 0xf1,
		0xbd, 0x4b, 0x1d, 0x16, 0x04, 0xd6, 0x23, 0x9b, 0xf5, 0x1b, 0x8f, 0x93, 0xe0, 0x46, 0x9f, 0x78,
		0xf3, 0xb6, 0x23, 0xff, 0xd2, 0x9b, 0x5f, 0x27, 0x39, 0x6f, 0x17, 0x39, 0x65, 0x27, 0x9d, 0xad,
		0x09, 0x8f, 0x4b, 0x83, 0xfc, 0x53, 0xbb, 0x48, 0x53, 0xc3, 0xf2, 0xb7, 0x2e, 0xcd, 0xf8, 0xcb,
		0x09, 0x52, 0xc6, 0xa9, 0x33, 0x9f, 0xb1, 0x4b, 0xf6, 0xe8, 0xb4, 0x12, 0xde, 0x28, 0x1e, 0xdf,
		0x39, 0xfc, 0x5c, 0x92, 0x7c, 0x99, 0x7b, 0x15, 0xa9, 0xfd, 0xe9, 0x69, 0xfc, 0xe5, 0x29, 0xaf,
		0x48, 0xd4, 0x48, 0x13, 0xf6, 0x6a, 0x0b, 0x5b, 0x54, 0xe9, 0xaf, 0x50, 0x4e, 0xb6, 0x27, 0x5d,
		0xed, 0x98, 0x65, 0xd9, 0x33, 0xf3, 0x1d, 0xfe, 0xb2, 0xfc, 0x2c, 0xe2, 0x70, 0xf0, 0x68, 0xc5,
		0x92, 0x37, 0x4b, 0x17, 0x66, 0x49, 0x1d, 0x4e, 0x11, 0x09, 0x9b, 0x08, 0x92, 0x83, 0xac, 0xed,
		0x2e, 0x1d, 0xf4, 0x90, 0x36, 0xbc, 0xc5, 0xc9, 0x85, 0x06, 0x68, 0xa5, 0x0e, 0x1f, 0x8c, 0xa9,
		0xe4, 0x25, 0x68, 0x7b, 0x8f, 0x66, 0x4a, 0x62, 0x11, 0x0d, 0x09, 0xa4, 0x74, 0xfd, 0x53, 0x21,
		0x24, 0x75, 0xd0, 0x30, 0xba, 0xa8, 0xdd, 0xf8, 0x87, 0x85, 0x32, 0x73, 0xa1, 0x36, 0x3d, 0x8f,
		0xb6, 0xb8, 0x8f, 0x7f, 0x88, 0x78, 0x28, 0x2d, 0x4c, 0x98, 0xa3, 0xbb, 0x9a, 0xec, 0xa1, 0xf7,
		0x68, 0x32, 0x97, 0xfb, 0x0e, 0x0b, 0x96, 0x0b, 0xfc, 0xe9, 0x8f, 0x43, 0xee, 0x17, 0x4f, 0xee,
		0x0f, 0x6f, 0x30, 0x60, 0xfe, 0xb3, 0x93, 0xe6, 0x40, 0xa6, 0x2f, 0x7e, 0xb4, 0x2c, 0x9d, 0x06,
		0x28, 0x43, 0x03, 0x14, 0x5f, 0x03, 0x2c, 0x23, 0xa8, 0xb4, 0x98, 0x51, 0x0e, 0x43, 0x4a, 0x92,
		0x96, 0x30, 0x89, 0xc9, 0x90, 0x9a, 0x22, 0xc9, 0xa9, 0x06, 0x0e, 0x94, 0x33, 0x2f, 0x94, 0xa3,
		0x00, 0xf2, 0x24, 0xa9, 0xc7, 0xe7, 0x99, 0x96, 0x54, 0xc7, 0x81, 0x30, 0xc9, 0x91, 0x7b, 0x8a,
		0xa3, 0xf6, 0x94, 0x1a, 0xb3, 0x96, 0xc2, 0xa8, 0xa5, 0x98, 0x13, 0x5a, 0x30, 0x50, 0x28, 0x99,
		0x28, 0x25, 0x9d, 0x20, 0xa5, 0x92, 0x18, 0xa5, 0xc8, 0x7c, 0x54, 0xd1, 0x3b, 0xb2, 0x34, 0x28,
		0xb2, 0xd0, 0x9c, 0x3a, 0x73, 0x66, 0x13, 0x74, 0x92, 0x4e, 0x50, 0x22, 0x28, 0xe9, 0x92, 0x2c,
		0xe5, 0x12, 0x88, 0xe9, 0x88, 0xf8, 0xea, 0x53, 0x42, 0xb2, 0x05, 0xf6, 0x79, 0x1a, 0x70, 0x06,
		0x66, 0x07, 0xb3, 0x17, 0x98, 0xd9, 0x9d, 0x26, 0x73, 0xb9, 0xc3, 0x5f, 0x7c, 0xd6, 0x52, 0x61,
		0x78, 0x89, 0x7e, 0x6c, 0xa5, 0xb3, 0xe8, 0xd1, 0x9f, 0xac, 0x80, 0xa0, 0x24, 0xe9, 0xb4, 0xfe,
		0xe9, 0xeb, 0xef, 0xf7, 0x37, 0xf5, 0xeb, 0xbf, 0xce, 0x4e, 0xea, 0xda, 0xef, 0x69, 0x45, 0x88,
		0x8c, 0x3e, 0x6e, 0x3a, 0xeb, 0x4f, 0x99, 0x72, 0x49, 0xec, 0x4e, 0xd9, 0xa9, 0xbb, 0x42, 0xb6,
		0x85, 0xa0, 0xef, 0xe5, 0x74, 0xf0, 0xa4, 0xfa, 0xf0, 0xb1, 0xc3, 0xbf, 0xdc, 0x0c, 0x9f, 0xba,
		0xd0, 0x2b, 0x23, 0x7e, 0xde, 0xfd, 0x34, 0x41, 0x47, 0x41, 0xdd, 0x21, 0xa9, 0x33, 0x04, 0x75,
		0x05, 0xac, 0xaf, 0x4d, 0xb2, 0xbe, 0x84, 0x65, 0xfb, 0xb8, 0x09, 0x18, 0xb3, 0x5a, 0x62, 0xf2,
		0x3c, 0x96, 0xe3, 0x02, 0xbd, 0xee, 0x4b, 0x57, 0x91, 0x38, 0x79, 0xff, 0x3e, 0x92, 0x0b, 0xbb,
		0x23, 0xea, 0xcf, 0x92, 0x53, 0xc3, 0x14, 0x22, 0x71, 0x3e, 0x15, 0xc8, 0x82, 0x92, 0xf6, 0x91,
		0x54, 0xc0, 0xa5, 0xf0, 0x91, 0xc0, 0x47, 0x02, 0xb3, 0x09, 0x66, 0x13, 0x7c, 0x24, 0xf0, 0x91,
		0x80, 0xd9, 0xc1, 0xec, 0xf0, 0x91, 0xc0, 0x47, 0xb2, 0xe6, 0x3e, 0x12, 0xd1, 0x02, 0x0b, 0x12,
		0x17, 0x89, 0x40, 0x25, 0x85, 0xee, 0x5c, 0xf2, 0x28, 0x0b, 0x3a, 0x65, 0x6a, 0x83, 0x50, 0x8d,
		0x84, 0x78, 0x6d, 0x04, 0x49, 0x4d, 0x84, 0x58, 0x2d, 0x44, 0x76, 0xb9, 0xf6, 0x42, 0x74, 0xa9,
		0x92, 0x6b, 0x2f, 0x40, 0x89, 0xa5, 0xc2, 0xe6, 0x91, 0xa5, 0x49, 0xc5, 0x52, 0x38, 0x25, 0x95,
		0xa4, 0xb2, 0xc5, 0x4e, 0x8e, 0x54, 0x4e, 0x8d, 0xd4, 0x49, 0x64, 0x15, 0x24, 0x91, 0x65, 0x9f,
		0x44, 0x16, 0x3d, 0x30, 0x7d, 0xfa, 0xd8, 0x68, 0x01, 0x71, 0xe2, 0x58, 0x05, 0x89, 0x63, 0x1a,
		0x71, 0x6f, 0x46, 0x89, 0x63, 0x56, 0xb7, 0x6b, 0x0a, 0xb5, 0xf9, 0x8b, 0xaf, 0x2a, 0x5e, 0x89,
		0xf0, 0x05, 0x1c, 0xa3, 0x2b, 0x0b, 0x5f, 0x08, 0xb7, 0xc9, 0x13, 0x6c, 0x8b, 0x97, 0xf6, 0x0d,
		0x14, 0xda, 0x3a, 0x28, 0xb4, 0x71, 0x50, 0xb0, 0x53, 0xcf, 0xea, 0xb7, 0x9f, 0x8d, 0xeb, 0xcf,
		0x27, 0x46, 0xf5, 0xa0, 0x72, 0xb0, 0x63, 0xdc, 0xb0, 0x70, 0xb4, 0x99, 0x71, 0xf8, 0xbe, 0xf2,
		0xbe, 0xfa, 0x7e, 0xc5, 0x3e, 0x0b, 0xd5, 0x96, 0x0b, 0x7a, 0xdc, 0x16, 0x8b, 0x4f, 0x2c, 0x37,
		0x06, 0x72, 0x23, 0xc3, 0x80, 0x5a, 0x27, 0x90, 0xc8, 0x39, 0x1e, 0x2c, 0x82, 0xce, 0x80, 0xce,
		0x58, 0x5f, 0x9d, 0x41, 0xc5, 0x5b, 0x4e, 0x53, 0x8a, 0xbb, 0x9c, 0x26, 0xf8, 0x0b, 0xfc, 0x05,
		0x4c, 0xb6, 0x4e, 0x98, 0xec, 0x08, 0x98, 0x4c, 0x10, 0x93, 0x1d, 0x6d, 0x28, 0x26, 0xeb, 0xfa,
		0x8e, 0x97, 0xaa, 0xb6, 0x7c, 0x86, 0xfc, 0xe2, 0x95, 0xd0, 0x1e, 0xd0, 0x1e, 0x2b, 0xd3, 0x1e,
		0x3d, 0xc7, 0xe5, 0x1f, 0x24, 0x94, 0x87, 0x48, 0xbf, 0x2a, 0xb9, 0x69, 0xf4, 0x12, 0x92, 0x5d,
		0x65, 0xda, 0xbc, 0xea, 0x74, 0x79, 0xb2, 0x79, 0xe5, 0xea, 0xf3, 0xc9, 0x65, 0x1a, 0x98, 0xab,
		0x4c, 0x87, 0x8f, 0x8f, 0xae, 0x52, 0xad, 0x16, 0xff, 0xf0, 0x56, 0xab, 0x94, 0x36, 0x10, 0x6c,
		0x95, 0x81, 0xb5, 0xc4, 0xb0, 0x56, 0x79, 0x53, 0xa1, 0x96, 0x67, 0xcb, 0xd8, 0xe8, 0xd1, 0x3a,
		0xc0, 0x2c, 0xc0, 0x2c, 0x18, 0xe9, 0x6b, 0xa4, 0x37, 0x0e, 0x61, 0xa4, 0x0b, 0x2a, 0x8e, 0xc3,
		0x75, 0x34, 0xd2, 0x95, 0x22, 0xf7, 0xa9, 0x07, 0x5d, 0x88, 0xa7, 0x3c, 0xcc, 0x0c, 0xae, 0xb0,
		0xb8, 0xd7, 0x71, 0x6c, 0xb9, 0x1c, 0x08, 0x81, 0xfe, 0xfd, 0x82, 0x7d, 0xfa, 0x17, 0x9f, 0xdf,
		0x92, 0x52, 0x11, 0x19, 0x79, 0x22, 0x21, 0x47, 0x24, 0x04, 0xee, 0x14, 0x17, 0x18, 0x66, 0xd8,
		0x97, 0xfd, 0x26, 0xec, 0xd7, 0x66, 0x5c, 0xf9, 0x1e, 0xf7, 0x6c, 0xaf, 0x9d, 0xb1, 0x0a, 0x95,
		0x95, 0x16, 0xb4, 0x5a, 0x34, 0xcd, 0xb9, 0x50, 0x6b, 0xd7, 0x77, 0x6a, 0xb2, 0x60, 0x95, 0x59,
		0x9b, 0x61, 0xde, 0xde, 0x6e, 0xba, 0x94, 0x2e, 0x43, 0x2c, 0x03, 0x31, 0xcc, 0x0b, 0x1e, 0xfd,
		0x55, 0x3a, 0x37, 0x73, 0x07, 0x6d, 0x2f, 0x91, 0xbb, 0xa6, 0xc2, 0x3d, 0x68, 0x7b, 0x49, 0x9e,
		0xae, 0xbc, 0xac, 0xcc, 0x40, 0x54, 0x48, 0xac, 0xba, 0x37, 0xf6, 0xcc, 0x1b, 0x8a, 0xf4, 0xc5,
		0x9e, 0x79, 0xa7, 0x34, 0x3d, 0xb1, 0x83, 0x97, 0x80, 0xb3, 0x4e, 0x72, 0x47, 0xec, 0xe8, 0xdf,
		0xb3, 0xe9, 0x87, 0x1d, 0xbc, 0xe4, 0xb3, 0x15, 0xf6, 0xe0, 0x7b, 0x51, 0x75, 0xc1, 0xb6, 0x2c,
		0x6b, 0x79, 0x12, 0xfb, 0xe0, 0x43, 0xf9, 0xe8, 0x83, 0x9a, 0xfc, 0x4d, 0x8c, 0x5c, 0x67, 0xaf,
		0x0f, 0xbe, 0x77, 0x56, 0x89, 0xeb, 0x96, 0x6d, 0x7b, 0x3d, 0x97, 0x3b, 0xee, 0x63, 0x7a, 0x00,
		0x30, 0xb1, 0xa6, 0x18, 0x7d, 0x4f, 0x17, 0x13, 0x42, 0x71, 0xb5, 0xff, 0x42, 0x42, 0xa1, 0x51,
		0xfc, 0xe8, 0x76, 0x4a, 0x4f, 0x68, 0xeb, 0xe7, 0x72, 0x4d, 0x45, 0x88, 0x7a, 0xbc, 0xad, 0xc2,
		0xfd, 0x3b, 0xc6, 0xd2, 0xcb, 0xec, 0x30, 0xfe, 0xe4, 0x29, 0x74, 0xf2, 0x98, 0xdd, 0x6a, 0x33,
		0xca, 0xe8, 0xc5, 0xc8, 0x5c, 0x87, 0x53, 0x35, 0x9f, 0x15, 0xf4, 0x42, 0x6c, 0x20, 0xe9, 0x3a,
		0xcd, 0xbc, 0x78, 0xbe, 0xe7, 0xca, 0x0d, 0x38, 0x8e, 0x65, 0xf5, 0xb1, 0xc4, 0xda, 0xe8, 0x6b,
		0xcb, 0x0d, 0xd0, 0x24, 0x98, 0xed, 0xac, 0xd6, 0x31, 0x60, 0xe6, 0x08, 0xaa, 0x0a, 0x7b, 0x90,
		0x74, 0x10, 0x98, 0x79, 0xc1, 0x5a, 0xad, 0x76, 0x7f, 0x5e, 0xbf, 0xfd, 0xe3, 0xf2, 0xf4, 0xfe,
		0xf6, 0xef, 0xab, 0xba, 0xea, 0x1c, 0xd9, 0x30, 0xb7, 0x23, 0x50, 0x1e, 0x79, 0x6a, 0x90, 0x8c,
		0x3d, 0x9d, 0x7a, 0xd1, 0x2f, 0x97, 0x27, 0xb5, 0x2f, 0x04, 0x83, 0x34, 0x77, 0xf2, 0xf6, 0x62,
		0xd7, 0xb5, 0xd3, 0xb3, 0xaf, 0x37, 0xf7, 0xb5, 0x2f, 0x6b, 0xf9, 0x76, 0xb7, 0xb5, 0x93, 0xda,
		0x09, 0xd5, 0xdb, 0x29, 0xed, 0xd0, 0x28, 0xc6, 0x70, 0x7c, 0x02, 0xa1, 0x27, 0x1c, 0x7e, 0x4e,
		0x94, 0x77, 0x1f, 0x32, 0x1a, 0xff, 0xda, 0xd0, 0xaa, 0x3b, 0xa5, 0xc6, 0x7f, 0xc6, 0xab, 0xa5,
		0xc7, 0x80, 0x8e, 0x77, 0x20, 0x1c, 0x07, 0x1a, 0x6f, 0x3a, 0xd9, 0x0a, 0x43, 0xb1, 0x1b, 0x4d,
		0x2f, 0x60, 0xbe, 0x2c, 0x04, 0x23, 0x18, 0x0e, 0x3d, 0x15, 0x46, 0x1d, 0xbe, 0x95, 0xf9, 0xf0,
		0xa2, 0x42, 0xbe, 0x94, 0x53, 0xa0, 0xa7, 0xb0, 0x61, 0x78, 0x52, 0xf9, 0x1c, 0x89, 0xbc, 0x36,
		0x4d, 0x7e, 0x86, 0xde, 0xde, 0xdd, 0xe8, 0x0f, 0xcb, 0xb2, 0x76, 0xc7, 0xe6, 0x19, 0x61, 0xdf,
		0xe3, 0x9b, 0x70, 0xff, 0xfb, 0xe8, 0x8f, 0x9a, 0x65, 0xdd, 0xd7, 0xe2, 0xc7, 0xac, 0xa0, 0xd1,
		0x31, 0x7b, 0x8e, 0xc4, 0x83, 0xa0, 0xdb, 0x25, 0x5a, 0x07, 0xb7, 0x0b, 0xdc, 0x2e, 0xd9, 0xb8,
		0x5d, 0x42, 0x82, 0x53, 0x68, 0x9a, 0x1a, 0x2e, 0x97, 0x73, 0xaf, 0x94, 0xe1, 0x5e, 0x81, 0x7b,
		0x45, 0x0f, 0x44, 0x14, 0x65, 0x83, 0x78, 0xa1, 0xa0, 0xbb, 0x3c, 0x91, 0x5c, 0x84, 0x15, 0x1b,
		0x01, 0x83, 0x28, 0x33, 0x0a, 0x05, 0xc3, 0xd0, 0x31, 0x0e, 0x25, 0x26, 0x25, 0x65, 0x24, 0x2d,
		0xb8, 0x94, 0x8c, 0xb1, 0x56, 0x62, 0xe5, 0x4a, 0x33, 0xdc, 0xb4, 0x1e, 0x32, 0xb9, 0xac, 0x5b,
		0x34, 0x59, 0x39, 0x0d, 0xf7, 0x54, 0xbc, 0x18, 0xb9, 0x80, 0x00, 0x39, 0x63, 0x52, 0x32, 0x28,
		0x3d, 0xa3, 0x52, 0x33, 0xac, 0x36, 0xc6, 0xd5, 0xc6, 0xc0, 0x5a, 0x18, 0x99, 0xc6, 0x5d, 0xa6,
		0xe8, 0x4a, 0x94, 0x0f, 0x58, 0x24, 0xd2, 0x1b, 0x8d, 0x2f, 0x7f, 0x46, 0x67, 0x56, 0x09, 0xf6,
		0x22, 0xf5, 0xed, 0xcf, 0xbc, 0x78, 0xad, 0x56, 0xbb, 0xaf, 0x9d, 0x9c, 0x5c, 0x7e, 0xbd, 0xb8,
		0x3d, 0xbb, 0xf8, 0xfd, 0xbe, 0xfe, 0x57, 0xfd, 0xe2, 0x96, 0xc2, 0xdb, 0x1f, 0x3f, 0x88, 0xd0,
		0xeb, 0xaf, 0xee, 0xc6, 0x14, 0x3f, 0x8a, 0x2f, 0x97, 0xbf, 0x9f, 0x5d, 0x94, 0xc8, 0x1e, 0xd8,
		0xdf, 0x29, 0xe4, 0x29, 0x9c, 0x5c, 0x9e, 0x9f, 0xd7, 0x2e, 0x4e, 0x09, 0xcf, 0x81, 0x64, 0xa7,
		0xc6, 0xaa, 0xe5, 0xd8, 0xbb, 0x15, 0xd0, 0x41, 0xc9, 0x67, 0xf6, 0x50, 0x01, 0x11, 0x21, 0x93,
		0x68, 0x3f, 0xa0, 0x12, 0xa0, 0x12, 0xa0, 0x92, 0x5c, 0xa1, 0x12, 0xe6, 0xf6, 0x3a, 0xcc, 0x1f,
		0x7a, 0xc0, 0x09, 0x51, 0xc9, 0x01, 0xc1, 0x5e, 0xe9, 0x72, 0xeb, 0x35, 0x0a, 0xd0, 0x4c, 0x2d,
		0x4a, 0xc9, 0x48, 0xc4, 0xcc, 0x3e, 0x92, 0x91, 0x89, 0xa1, 0x23, 0x7e, 0xf8, 0xc7, 0xae, 0x92,
		0x37, 0xc7, 0x90, 0x0e, 0x5b, 0xd4, 0xc3, 0xef, 0x30, 0xfc, 0x43, 0x28, 0x86, 0xa1, 0x7e, 0x73,
		0x32, 0x5d, 0x48, 0x08, 0x4c, 0x78, 0x3a, 0xd3, 0x5d, 0x51, 0x39, 0xc2, 0x87, 0x06, 0x1f, 0x5a,
		0xd6, 0x12, 0x4f, 0x59, 0x99, 0x29, 0x0c, 0xaa, 0x4c, 0x54, 0x5c, 0x47, 0x0a, 0x7b, 0xcc, 0x0e,
		0xb2, 0x9c, 0x60, 0xeb, 0x1c, 0x0b, 0x32, 0xb1, 0xd9, 0x97, 0x89, 0xb7, 0x20, 0x3a, 0xb0, 0x66,
		0xee, 0xf9, 0xab, 0x8a, 0xaf, 0x0a, 0xc4, 0x17, 0xc4, 0x57, 0x26, 0xe2, 0x0b, 0x21, 0x00, 0x18,
		0xdb, 0x30, 0xb6, 0x61, 0x6c, 0x0b, 0xd0, 0x1b, 0x42, 0x00, 0x08, 0x01, 0x20, 0x04, 0x80, 0x10,
		0x40, 0x66, 0x1e, 0x2c, 0x84, 0x00, 0x80, 0x4a, 0x80, 0x4a, 0x80, 0x4a, 0x16, 0xdb, 0x0c, 0x08,
		0x01, 0xe4, 0xc3, 0xa2, 0xcc, 0x53, 0x08, 0x40, 0xc5, 0x99, 0x63, 0xd0, 0x44, 0x00, 0x04, 0x66,
		0x11, 0x13, 0xf8, 0xcd, 0xb4, 0xe6, 0xe7, 0x46, 0xb3, 0x8c, 0xa5, 0xad, 0xf3, 0xf5, 0xaf, 0x01,
		0x5b, 0x3a, 0x0e, 0x59, 0xf5, 0x0a, 0x14, 0x99, 0x8b, 0x82, 0xa9, 0x4a, 0x52, 0xbe, 0x59, 0x45,
		0x36, 0x2a, 0xa1, 0x0e, 0x2b, 0xe9, 0x56, 0xb4, 0xd7, 0x61, 0x0d, 0xef, 0x21, 0xcb, 0x3a, 0x2c,
		0x31, 0x57, 0xbe, 0x94, 0xeb, 0x5e, 0xba, 0x0a, 0xab, 0x82, 0x2a, 0x2c, 0x4a, 0xcc, 0x8b, 0xe6,
		0x37, 0x68, 0x7e, 0x83, 0xea, 0x2c, 0x34, 0xbf, 0x49, 0x25, 0xab, 0xd1, 0xfc, 0x06, 0xcd, 0x6f,
		0x32, 0xf7, 0xfa, 0xa2, 0xf9, 0x4d, 0xb1, 0xdf, 0x0e, 0xcd, 0x6f, 0xb2, 0x17, 0x7a, 0x68, 0x7e,
		0xb3, 0x61, 0x8e, 0x0f, 0x34, 0xbf, 0xd1, 0x83, 0x0b, 0x0d, 0x34, 0xbf, 0xc9, 0x99, 0xd3, 0x45,
		0xd4, 0xa5, 0x2c, 0xe7, 0x73, 0x11, 0xf0, 0x1a, 0xeb, 0x9e, 0xd7, 0x43, 0x37, 0xeb, 0x63, 0xd1,
		0xb9, 0xaa, 0x0c, 0xfa, 0x58, 0x74, 0x92, 0x3a, 0xa6, 0x7c, 0x58, 0x3d, 0xfe, 0x34, 0x40, 0xd2,
		0x76, 0xba, 0x53, 0x19, 0x1b, 0xf9, 0xd3, 0xeb, 0xd0, 0xee, 0x1b, 0xed, 0xbe, 0x23, 0x82, 0x6a,
		0x76, 0x1c, 0xd7, 0x0c, 0x45, 0xbb, 0xb0, 0xd3, 0x73, 0x62, 0x2d, 0xfa, 0x4f, 0xc1, 0xf3, 0x99,
		0x8d, 0xe7, 0x53, 0xb2, 0xe1, 0x8e, 0x5a, 0xa3, 0x1d, 0x74, 0xa0, 0x82, 0x8f, 0x33, 0xaf, 0x1d,
		0xa8, 0x86, 0x52, 0xb8, 0x6b, 0x05, 0xc1, 0x0f, 0x95, 0x7c, 0xb3, 0x37, 0x52, 0x3d, 0xde, 0x0f,
		0xd5, 0x74, 0x28, 0x47, 0xc9, 0x98, 0xd1, 0x56, 0xe2, 0x7a, 0x22, 0xac, 0xa6, 0x5b, 0xb9, 0x0b,
		0x4a, 0xf2, 0x04, 0x52, 0x8f, 0x47, 0xd5, 0xe3, 0x3e, 0x9d, 0x33, 0x4e, 0x75, 0xc2, 0x82, 0x7b,
		0xb2, 0x82, 0x27, 0xd6, 0x34, 0x9f, 0xad, 0x76, 0x8f, 0xd1, 0x52, 0xbd, 0xc0, 0xb4, 0xd5, 0x54,
		0x64, 0x9f, 0x35, 0xc1, 0x37, 0x32, 0xa9, 0x71, 0x9c, 0x56, 0x0b, 0xd1, 0x75, 0x50, 0x6b, 0x9b,
		0xd1, 0xb6, 0x50, 0x3a, 0x50, 0x3a, 0x50, 0x3a, 0x62, 0x76, 0x8d, 0xff, 0xd2, 0xe5, 0x63, 0x46,
		0x52, 0xac, 0x60, 0xcc, 0x3c, 0x08, 0xd2, 0x5f, 0x9f, 0xdc, 0xc5, 0x29, 0x57, 0xdb, 0xee, 0xd8,
		0x49, 0x22, 0xdf, 0x15, 0x44, 0xc4, 0xfd, 0x38, 0xf5, 0xf4, 0xfb, 0xda, 0xe0, 0xe9, 0x5f, 0x03,
		0xe6, 0x4b, 0xb5, 0x03, 0x11, 0xf0, 0xab, 0x0b, 0x79, 0xa5, 0x65, 0xaa, 0xe5, 0x95, 0xaa, 0xe4,
		0x95, 0xed, 0xf7, 0x0a, 0xec, 0x77, 0xd8, 0xef, 0xb0, 0xdf, 0x01, 0xa5, 0x00, 0xa5, 0x60, 0xbf,
		0xc3, 0x7e, 0x87, 0xfd, 0x0e, 0xfb, 0x1d, 0xf6, 0x3b, 0x94, 0x0e, 0x94, 0x0e, 0xec, 0x77, 0x55,
		0x91, 0x34, 0x30, 0x8d, 0x23, 0xcb, 0x96, 0x44, 0x16, 0xc5, 0xfb, 0x41, 0x08, 0x41, 0x08, 0x41,
		0x08, 0x15, 0x0b, 0xf9, 0xc2, 0x6f, 0x38, 0xc7, 0x6f, 0x28, 0xdb, 0x4a, 0x80, 0xc2, 0x6d, 0x28,
		0xd1, 0x43, 0x60, 0xad, 0xb3, 0x71, 0x93, 0x2e, 0x49, 0x53, 0x5a, 0x6e, 0xc2, 0xb5, 0x64, 0x59,
		0x11, 0x2d, 0x98, 0x70, 0x25, 0x97, 0x68, 0x85, 0xcc, 0x40, 0x03, 0x99, 0x81, 0x6a, 0x0e, 0xd5,
		0x37, 0x39, 0xce, 0xea, 0x75, 0xd1, 0x73, 0xb7, 0x43, 0x6d, 0xb4, 0x3e, 0xb0, 0x88, 0xb8, 0x03,
		0x6a, 0xa3, 0x35, 0xfb, 0x29, 0x51, 0x1b, 0x2d, 0xb9, 0x2d, 0x6a, 0xa3, 0x33, 0x7f, 0x31, 0xd4,
		0x46, 0xeb, 0x35, 0xb7, 0x47, 0xff, 0xa1, 0x36, 0x3a, 0xbf, 0xe6, 0x3d, 0x6a, 0xa3, 0x85, 0x37,
		0x45, 0x6d, 0x74, 0x36, 0x4e, 0x43, 0xd4, 0x46, 0xe7, 0xcd, 0x1b, 0x23, 0x9c, 0x5f, 0x27, 0xef,
		0x89, 0x11, 0xc9, 0xa6, 0x43, 0x63, 0x3a, 0x38, 0x61, 0xe0, 0x84, 0x81, 0x13, 0x06, 0x4e, 0x18,
		0x38, 0x61, 0xe0, 0x84, 0x81, 0x13, 0x06, 0x4e, 0x18, 0x38, 0x61, 0xe0, 0x84, 0x81, 0x13, 0x06,
		0x4e, 0x18, 0x38, 0x61, 0xe0, 0x84, 0x81, 0x13, 0x66, 0xbd, 0x9c, 0x30, 0x3a, 0x9b, 0xd4, 0x4d,
		0xfb, 0x60, 0x68, 0x1b, 0xd5, 0xa5, 0x70, 0xc1, 0x0c, 0xe8, 0x2b, 0x10, 0x77, 0xc1, 0x0c, 0x97,
		0x21, 0x0f, 0x06, 0x2e, 0x98, 0x6c, 0x5c, 0x30, 0x42, 0xcd, 0xdc, 0x28, 0xd4, 0x0d, 0xba, 0x63,
		0xc1, 0xc1, 0x92, 0xd7, 0xea, 0x5a, 0xc9, 0x76, 0x71, 0x33, 0xe4, 0x22, 0x5d, 0xbb, 0x6f, 0x50,
		0x0e, 0x67, 0x47, 0x4d, 0x81, 0x0e, 0x46, 0xd2, 0x82, 0x4c, 0x8d, 0x0d, 0x1f, 0xce, 0xae, 0x5c,
		0xd0, 0x3e, 0x43, 0x78, 0x8a, 0x25, 0xed, 0x6f, 0x99, 0x11, 0x23, 0x50, 0xb3, 0x64, 0x56, 0x6d,
		0x4c, 0xab, 0x8d, 0x79, 0xb5, 0x30, 0x31, 0x8d, 0xb3, 0x2c, 0x7f, 0x23, 0x50, 0x95, 0x9d, 0x5a,
		0x44, 0xce, 0x2d, 0xaa, 0x13, 0x52, 0x2e, 0xa5, 0x57, 0x77, 0x18, 0x26, 0x3a, 0x61, 0x74, 0x96,
		0xd6, 0x27, 0x70, 0x13, 0x41, 0x89, 0xfd, 0x5c, 0x76, 0x2a, 0xb0, 0xd7, 0x79, 0x47, 0x5d, 0x35,
		0xaa, 0x16, 0xe1, 0x27, 0x6a, 0x48, 0xb5, 0x32, 0x7c, 0x28, 0x4a, 0x28, 0x4a, 0x28, 0x4a, 0x4d,
		0x8a, 0x92, 0xb6, 0xcc, 0x9f, 0x5a, 0x6b, 0xae, 0x44, 0x1c, 0xfa, 0x5e, 0x9b, 0x30, 0xe4, 0x1e,
		0xee, 0x06, 0xc1, 0x07, 0xc1, 0x07, 0xc1, 0x97, 0x2b, 0xc1, 0x27, 0x9b, 0xe0, 0x94, 0x28, 0xea,
		0x8e, 0x09, 0xf6, 0x52, 0x4a, 0x80, 0xd2, 0x03, 0xf5, 0xf5, 0x98, 0x55, 0xc4, 0x8a, 0x82, 0x88,
		0xcc, 0x34, 0x9e, 0x1c, 0x4d, 0x6a, 0x59, 0xe2, 0xf1, 0x55, 0x09, 0xf7, 0x24, 0x4d, 0x3d, 0x4b,
		0x3c, 0x90, 0x9b, 0xbf, 0x6f, 0x6e, 0xeb, 0xe7, 0xf7, 0xa7, 0xf5, 0xcf, 0x67, 0x17, 0xf5, 0xd3,
		0xfb, 0xeb, 0xcb, 0x2f, 0xf5, 0x1b, 0xc2, 0x93, 0x31, 0x88, 0xf3, 0xd3, 0xf4, 0x91, 0xc8, 0xa2,
		0xd3, 0x19, 0x9c, 0xca, 0x7d, 0xed, 0xf4, 0xfc, 0xec, 0xa2, 0x44, 0xfe, 0xbc, 0x3e, 0xe9, 0x8e,
		0x8d, 0x77, 0xf9, 0xfa, 0x5e, 0xea, 0xbb, 0x34, 0x0a, 0x08, 0x5d, 0x83, 0xe0, 0xc9, 0xfc, 0xce,
		0x5e, 0xe8, 0xd0, 0xeb, 0x68, 0x43, 0x00, 0x58, 0x00, 0x58, 0x00, 0xd8, 0x5c, 0x01, 0xd8, 0xdc,
		0xb9, 0xb8, 0x57, 0x22, 0xf1, 0x94, 0xbb, 0xf5, 0xcd, 0x1a, 0x06, 0x6a, 0xfd, 0xfa, 0x20, 0xf3,
		0x20, 0xf3, 0x20, 0xf3, 0x20, 0xf3, 0xb4, 0xac, 0x94, 0xcd, 0x9e, 0x50, 0xec, 0x1b, 0x38, 0xc6,
		0x97, 0xf2, 0x79, 0xb8, 0x61, 0xd6, 0xe9, 0xae, 0xda, 0xdc, 0x91, 0xf1, 0xf7, 0x90, 0xcd, 0xd1,
		0xfd, 0x3a, 0xf8, 0x16, 0xf7, 0xd2, 0x03, 0x48, 0xe4, 0x6f, 0xaf, 0x2f, 0xd5, 0x2e, 0x51, 0x66,
		0x30, 0xc9, 0x1c, 0xa6, 0x91, 0x6b, 0xd7, 0x68, 0x50, 0x66, 0x8a, 0x55, 0x90, 0x29, 0xa6, 0x51,
		0x3b, 0x21, 0x53, 0x6c, 0xfc, 0xcd, 0x91, 0x29, 0x06, 0x48, 0x09, 0x48, 0x09, 0x48, 0x59, 0x54,
		0x48, 0x89, 0x4c, 0x31, 0x4a, 0x6e, 0x42, 0xa6, 0x18, 0xa5, 0xb7, 0x05, 0x99, 0x62, 0x50, 0x94,
		0x50, 0x94, 0x9b, 0xa9, 0x28, 0x91, 0x29, 0x36, 0xf3, 0xdd, 0x91, 0x29, 0x06, 0xc1, 0x07, 0xc1,
		0xb7, 0xee, 0x82, 0x0f, 0x99, 0x62, 0xab, 0x34, 0xab, 0x88, 0x15, 0x05, 0x11, 0x99, 0x69, 0x3c,
		0x39, 0x64, 0x8a, 0xbd, 0x39, 0x10, 0x64, 0x8a, 0xa5, 0x38, 0x1d, 0x64, 0x8a, 0xad, 0x6e, 0x17,
		0x64, 0x8a, 0x21, 0x53, 0x0c, 0x00, 0x16, 0x00, 0x36, 0xaf, 0x00, 0x16, 0x99, 0x62, 0xc8, 0x14,
		0x83, 0xcc, 0x83, 0xcc, 0x83, 0xcc, 0x2b, 0xa4, 0xcc, 0xdb, 0xe0, 0x4c, 0x31, 0x95, 0xd4, 0x25,
		0x83, 0x2a, 0x51, 0x4c, 0x62, 0xe4, 0xac, 0xfc, 0xdd, 0xc9, 0xe4, 0x89, 0xd1, 0x4d, 0x2c, 0xc7,
		0xac, 0x72, 0x64, 0x8b, 0xad, 0x5a, 0x23, 0x15, 0x75, 0x56, 0x79, 0x9b, 0x59, 0x2d, 0xa2, 0xc1,
		0x01, 0x47, 0x0a, 0x7b, 0x5c, 0x45, 0x22, 0xf7, 0xfd, 0xfb, 0x28, 0xcf, 0x76, 0x37, 0x66, 0xea,
		0xb5, 0x18, 0x81, 0xfe, 0x67, 0xe8, 0xb4, 0x90, 0x95, 0x54, 0xeb, 0xdf, 0xdd, 0xdb, 0xed, 0xb5,
		0xdb, 0xeb, 0x3a, 0x83, 0x7e, 0x8c, 0x0c, 0x32, 0x9d, 0x3e, 0x3f, 0xc6, 0x02, 0x18, 0x3c, 0xbf,
		0xe8, 0x66, 0x32, 0xe9, 0xb2, 0x1d, 0x5e, 0x06, 0x59, 0x97, 0xed, 0x77, 0x0a, 0xe7, 0x2d, 0x7a,
		0xce, 0x0a, 0xe7, 0x5b, 0x4a, 0x35, 0x90, 0x4d, 0xee, 0x44, 0x17, 0x9f, 0x65, 0xf2, 0x09, 0x2d,
		0x38, 0x9d, 0x70, 0x4c, 0x96, 0xe7, 0x3b, 0xff, 0x4b, 0x77, 0x38, 0x53, 0xd3, 0xb5, 0xc6, 0xcb,
		0x96, 0x9c, 0x7e, 0xba, 0xca, 0x84, 0xd4, 0x98, 0x52, 0x04, 0x3b, 0x8a, 0x63, 0x44, 0x51, 0x2c,
		0x28, 0x8d, 0xf9, 0xa4, 0xb1, 0x9d, 0x14, 0x86, 0x53, 0xe3, 0x9f, 0xb4, 0x99, 0xfa, 0xa2, 0x4d,
		0x93, 0xe5, 0x9a, 0x24, 0xa3, 0xd5, 0xbd, 0x81, 0x56, 0xf7, 0x72, 0x04, 0x3a, 0x5f, 0xee, 0x91,
		0x0c, 0x1b, 0x9c, 0xd9, 0x0d, 0xb3, 0x06, 0xf5, 0x59, 0xdc, 0x68, 0x85, 0x8f, 0x59, 0x83, 0xa9,
		0xfe, 0xc3, 0xac, 0xc1, 0xe5, 0x2f, 0x88, 0x59, 0x83, 0x99, 0x78, 0xb0, 0x34, 0xbe, 0x18, 0x66,
		0x0d, 0xea, 0xf5, 0x59, 0x8e, 0xfe, 0xc3, 0xac, 0x41, 0x71, 0x79, 0x87, 0x59, 0x83, 0x98, 0x35,
		0xa8, 0x15, 0x0b, 0x1a, 0x98, 0x35, 0x48, 0x84, 0x27, 0xd7, 0xdc, 0x0b, 0x1a, 0x5b, 0x68, 0xe2,
		0x7d, 0x4d, 0x04, 0x7d, 0x76, 0xf1, 0x93, 0x84, 0x7a, 0x97, 0xd0, 0xcc, 0x1a, 0x64, 0xcf, 0x91,
		0x90, 0x10, 0x74, 0xc1, 0x44, 0xeb, 0xe0, 0x82, 0x81, 0x0b, 0x26, 0x1b, 0x17, 0x4c, 0x48, 0x70,
		0xf2, 0x3e, 0x97, 0xe1, 0x72, 0xcc, 0x1b, 0x84, 0x93, 0x25, 0x57, 0x4e, 0x16, 0xcc, 0x1b, 0x44,
		0x5e, 0x90, 0x36, 0x46, 0xd2, 0x82, 0x4e, 0x8d, 0x0d, 0xef, 0x22, 0x15, 0x2a, 0x92, 0x61, 0x95,
		0x3c, 0x99, 0x4b, 0x6d, 0x62, 0x4f, 0xa4, 0x9c, 0xeb, 0x67, 0x54, 0x6a, 0x86, 0xd5, 0xc6, 0xb8,
		0xda, 0x18, 0x58, 0x0b, 0x23, 0xd3, 0x38, 0xcd, 0xf2, 0x97, 0x72, 0x4e, 0x5b, 0xb8, 0x4b, 0x59,
		0xb0, 0xab, 0xa7, 0x50, 0x77, 0xca, 0xd3, 0x5f, 0xfb, 0x7a, 0xfb, 0xc7, 0xe5, 0xf5, 0xd9, 0x7f,
		0x6a, 0xb7, 0x67, 0x97, 0x17, 0xf7, 0xf5, 0xbf, 0xea, 0x17, 0xb7, 0x14, 0x6e, 0xff, 0xf8, 0x59,
		0x1a, 0x0a, 0x74, 0x35, 0x95, 0x2b, 0x27, 0x9d, 0xc6, 0xc9, 0xe5, 0xc5, 0xe7, 0xb3, 0xdf, 0xe9,
		0xaa, 0x73, 0xfb, 0x3b, 0xc5, 0x3d, 0x89, 0xf3, 0xf3, 0xda, 0xc5, 0x69, 0x29, 0x67, 0x85, 0xc0,
		0x8d, 0x55, 0x4b, 0x34, 0x94, 0x88, 0xa4, 0x74, 0xb4, 0x0d, 0x9d, 0x4a, 0xc3, 0x3f, 0x32, 0xef,
		0x26, 0x3c, 0xf6, 0xc2, 0xd5, 0xc3, 0xaf, 0x31, 0xfc, 0xa3, 0x00, 0xed, 0x84, 0x09, 0x10, 0x29,
		0x1d, 0x12, 0x45, 0xa9, 0x08, 0x4c, 0x42, 0x94, 0x8a, 0xe4, 0xad, 0x54, 0x64, 0x82, 0xad, 0xd1,
		0x17, 0x3d, 0x13, 0x8f, 0x16, 0xfa, 0xa2, 0x43, 0x7c, 0xc1, 0xa3, 0x05, 0x8f, 0x16, 0x3c, 0x5a,
		0xf0, 0x68, 0xc1, 0xa3, 0x05, 0x8f, 0x16, 0x3c, 0x5a, 0xf0, 0x68, 0xc1, 0xa3, 0xb5, 0xd9, 0x1e,
		0xad, 0x8c, 0xbb, 0x9e, 0x24, 0x38, 0xb4, 0xb2, 0x6d, 0x7b, 0x92, 0x45, 0xcf, 0x00, 0x69, 0xb0,
		0x89, 0xae, 0x01, 0xca, 0x57, 0x90, 0x75, 0xd7, 0x80, 0xf9, 0xac, 0xa5, 0xbf, 0x6d, 0xc0, 0x7c,
		0x66, 0x42, 0xdf, 0x80, 0x45, 0x77, 0x93, 0x45, 0xc6, 0xec, 0xf0, 0x36, 0xb2, 0xcc, 0x98, 0x15,
		0xf3, 0x52, 0x49, 0x79, 0xa5, 0xa4, 0xf3, 0x65, 0x2b, 0xc8, 0x97, 0xa5, 0x34, 0x32, 0x51, 0xb2,
		0x8c, 0x92, 0x65, 0x64, 0xd3, 0x52, 0x7a, 0x56, 0x50, 0xb2, 0x9c, 0xfc, 0xb5, 0x51, 0xb2, 0x8c,
		0x92, 0x65, 0xc5, 0x17, 0x45, 0xc9, 0x72, 0x21, 0xdf, 0x0e, 0x25, 0xcb, 0xd9, 0x0b, 0x3d, 0x94,
		0x2c, 0x6f, 0x98, 0x2b, 0x04, 0x25, 0xcb, 0x7a, 0x70, 0xa1, 0x81, 0x92, 0xe5, 0xfc, 0x39, 0x60,
		0x44, 0x5d, 0xcd, 0xd2, 0xfe, 0x17, 0x01, 0x6f, 0x72, 0xd1, 0xdb, 0x36, 0xa6, 0xed, 0x60, 0xa8,
		0x72, 0x9e, 0x3a, 0x9a, 0x36, 0xa6, 0x2c, 0x15, 0x14, 0x2b, 0x09, 0x44, 0x9b, 0x46, 0x5a, 0xa9,
		0xba, 0x82, 0x36, 0x8d, 0x3a, 0xf9, 0x25, 0x75, 0xf2, 0xb6, 0x00, 0xa3, 0xa4, 0xc9, 0xc4, 0x96,
		0xe3, 0x90, 0x80, 0xf9, 0xcf, 0xcc, 0x37, 0x1f, 0x7d, 0xaf, 0xd7, 0x0d, 0xd2, 0x33, 0xca, 0xf4,
		0x32, 0xf0, 0x0b, 0xda, 0x9a, 0xce, 0x92, 0x93, 0x44, 0xa0, 0x60, 0x72, 0x35, 0xfa, 0x6b, 0x64,
		0xe8, 0x32, 0xdd, 0xe8, 0x78, 0x81, 0x64, 0x43, 0x01, 0xb5, 0x46, 0x02, 0xe8, 0xb0, 0x91, 0x29,
		0x81, 0x93, 0xdb, 0x7e, 0xeb, 0xdc, 0x61, 0x83, 0x66, 0xf2, 0x0e, 0xa6, 0xee, 0xa0, 0x16, 0x61,
		0x15, 0x4c, 0xb5, 0x12, 0xb7, 0x2c, 0x61, 0x29, 0x55, 0xf1, 0xdc, 0xb3, 0x32, 0x15, 0x4f, 0x34,
		0x45, 0x9b, 0x28, 0xd7, 0x84, 0x8c, 0x81, 0x8c, 0x11, 0xa7, 0x97, 0x8d, 0x88, 0x7b, 0xdf, 0xd4,
		0xaf, 0xff, 0xaa, 0x5f, 0xaf, 0x79, 0xdc, 0x7b, 0x18, 0x1e, 0x5e, 0xdf, 0xd0, 0xf0, 0xc6, 0x85,
		0x85, 0x73, 0x66, 0x44, 0x64, 0x99, 0xe5, 0x3c, 0xe5, 0x55, 0x9c, 0xfa, 0x9b, 0x7c, 0x4b, 0x0c,
		0x01, 0x2f, 0xeb, 0x4d, 0xf8, 0xc0, 0xdf, 0xc3, 0xa7, 0x4f, 0xfe, 0x45, 0xaa, 0x11, 0x86, 0x40,
		0xc0, 0x4d, 0xc0, 0x3f, 0x24, 0x65, 0x99, 0xa9, 0x58, 0x64, 0x48, 0x5d, 0x84, 0x9b, 0x22, 0xf7,
		0xa9, 0x8b, 0xf2, 0xcd, 0x27, 0x54, 0x9a, 0x4e, 0xcc, 0x69, 0x36, 0x21, 0x3e, 0x93, 0x54, 0x8f,
		0x98, 0x18, 0x8a, 0xce, 0x40, 0x5e, 0x52, 0x8c, 0x36, 0x80, 0x4f, 0x13, 0xc2, 0x62, 0x3d, 0x7c,
		0x9a, 0x43, 0x8a, 0x26, 0x68, 0xb1, 0x32, 0xdc, 0x07, 0x5d, 0x83, 0xe1, 0x73, 0xd8, 0x08, 0x9f,
		0x83, 0x72, 0x8f, 0x15, 0xab, 0xd9, 0xf4, 0x59, 0x10, 0xd0, 0x99, 0xf6, 0xa3, 0x0d, 0xd1, 0x5d,
		0x45, 0x3f, 0x8b, 0x52, 0xb3, 0xaa, 0x36, 0x96, 0xd5, 0xc6, 0xba, 0x5a, 0x58, 0x98, 0xc6, 0x35,
		0x91, 0xbf, 0xee, 0x2a, 0xea, 0x5d, 0xe0, 0x28, 0x80, 0x79, 0x0a, 0xa0, 0x3e, 0x92, 0x21, 0xab,
		0xea, 0x05, 0xa1, 0xa0, 0x34, 0x15, 0xc7, 0x1f, 0xcc, 0xdc, 0x99, 0x72, 0xb3, 0x51, 0x02, 0x60,
		0x03, 0x69, 0x0a, 0x69, 0x5a, 0x74, 0x69, 0xaa, 0x0a, 0x94, 0xc8, 0x01, 0x93, 0x26, 0xe0, 0x44,
		0x0c, 0xa0, 0xc8, 0x59, 0x5f, 0x87, 0x08, 0xd0, 0x27, 0x0a, 0x74, 0x89, 0x04, 0xed, 0xa2, 0x41,
		0xbb, 0x88, 0xd0, 0x2a, 0x2a, 0x68, 0x44, 0x06, 0x91, 0xe8, 0xa0, 0x07, 0x64, 0x33, 0xf4, 0xea,
		0x74, 0x4d, 0x5a, 0xee, 0x37, 0x14, 0x2b, 0xbf, 0x97, 0x9d, 0xc1, 0x37, 0x52, 0x1a, 0xa2, 0xe5,
		0xa9, 0x37, 0x27, 0xfb, 0x7c, 0xa0, 0xe1, 0x6c, 0x67, 0xce, 0xf8, 0x83, 0x86, 0xbd, 0xaf, 0x2c,
		0xce, 0x99, 0xef, 0x92, 0x1f, 0x77, 0xfc, 0x80, 0xad, 0x6f, 0x7b, 0xe6, 0x71, 0xe3, 0xf5, 0x5b,
		0xd9, 0x3c, 0x6e, 0x0c, 0x7f, 0x2c, 0x87, 0x7f, 0xfc, 0xaa, 0xf4, 0x5f, 0x2b, 0xdf, 0xf6, 0xcc,
		0x83, 0xe8, 0xb7, 0x95, 0xea, 0xb7, 0x3d, 0xb3, 0xda, 0xd8, 0xde, 0xba, 0xbb, 0x7b, 0x2f, 0xba,
		0x66, 0xfb, 0xd7, 0x7e, 0xbf, 0x44, 0xfe, 0xf5, 0x1b, 0x3a, 0x8e, 0xfb, 0xf2, 0xe6, 0xec, 0xdf,
		0xda, 0xcf, 0xfc, 0xbf, 0x5b, 0x59, 0x9d, 0xfa, 0xf6, 0x3f, 0x34, 0x9c, 0x3b, 0xe9, 0x8e, 0xfd,
		0x9d, 0x02, 0x89, 0x91, 0x43, 0x88, 0x91, 0x24, 0x31, 0x12, 0x52, 0xa7, 0x65, 0xb6, 0x6a, 0xe6,
		0xe7, 0xc6, 0xaf, 0xf2, 0xce, 0x41, 0xff, 0xe3, 0xf6, 0xaf, 0xa3, 0xfe, 0xdb, 0x5f, 0xbe, 0xce,
		0xfb, 0x58, 0x79, 0xe7, 0xa8, 0xff, 0x31, 0xe1, 0x5f, 0x0e, 0xfb, 0x1f, 0x53, 0xee, 0x51, 0xed,
		0x6f, 0xcd, 0x7c, 0x74, 0xf0, 0xfb, 0x4a, 0xd2, 0x82, 0x83, 0x84, 0x05, 0xfb, 0x49, 0x0b, 0xf6,
		0x13, 0x16, 0x24, 0x7e, 0xa5, 0x4a, 0xc2, 0x82, 0x6a, 0xff, 0x75, 0xe6, 0xf3, 0x5b, 0xf3, 0x3f,
		0x7a, 0xd8, 0xdf, 0x7e, 0x4d, 0xfa, 0xb7, 0xa3, 0xfe, 0xeb, 0xc7, 0xed, 0x6d, 0x08, 0xd6, 0x19,
		0xc1, 0x0a, 0x32, 0xcc, 0x9e, 0x0c, 0xf3, 0xaf, 0x68, 0xde, 0xe5, 0xeb, 0x7b, 0xf5, 0xf3, 0x90,
		0x0f, 0xa8, 0x56, 0x47, 0x92, 0xa8, 0x2a, 0x15, 0xea, 0x4a, 0xe0, 0xc3, 0x80, 0x0f, 0x03, 0x3e,
		0x8c, 0x82, 0xfa, 0x30, 0x94, 0xeb, 0x62, 0x92, 0x41, 0xf1, 0x1a, 0xc9, 0x5c, 0xee, 0x74, 0x98,
		0xd7, 0xe3, 0xf4, 0x62, 0x77, 0xb4, 0x31, 0x24, 0x2f, 0x24, 0x2f, 0x24, 0xef, 0x46, 0x49, 0xde,
		0x9e, 0xe3, 0xf2, 0xf2, 0xa1, 0x06, 0xc9, 0x7b, 0x48, 0xb8, 0xe5, 0xb5, 0xe5, 0x3e, 0x16, 0xc2,
		0x73, 0x7c, 0xee, 0xb8, 0xe4, 0x8c, 0x1a, 0x6f, 0x1e, 0x16, 0x2a, 0xd1, 0x89, 0xc1, 0x99, 0xfd,
		0x3f, 0xfb, 0x96, 0xcd, 0x1d, 0xcf, 0x3d, 0x75, 0x1e, 0x1d, 0xd9, 0x86, 0x77, 0xe9, 0x68, 0x8f,
		0x3d, 0x5a, 0xdc, 0x79, 0x1e, 0xbc, 0x4b, 0xcb, 0x6a, 0x07, 0x8c, 0xfc, 0x29, 0x7d, 0x0d, 0x8e,
		0x88, 0x73, 0xeb, 0xa7, 0xfe, 0xab, 0x3d, 0xac, 0x56, 0xf7, 0xab, 0xb8, 0xde, 0xcc, 0x2c, 0xf2,
		0x35, 0xb5, 0xef, 0x57, 0x9a, 0x2c, 0x41, 0x34, 0x9e, 0x26, 0xde, 0x8f, 0xa8, 0xca, 0x2c, 0x2a,
		0x7b, 0x88, 0xfe, 0xdc, 0x25, 0x49, 0x8d, 0x32, 0x88, 0x8a, 0xd0, 0x86, 0x3f, 0x8f, 0x7e, 0xa7,
		0x34, 0x9c, 0x59, 0x9d, 0x06, 0x54, 0x12, 0xd8, 0x7c, 0xab, 0xe9, 0xf4, 0x08, 0xf3, 0x81, 0xa3,
		0xfd, 0x90, 0xc0, 0x96, 0x9d, 0xdd, 0x81, 0x04, 0x36, 0x24, 0xb0, 0x25, 0x6f, 0x44, 0x94, 0xa1,
		0x3a, 0x43, 0xbe, 0x64, 0xe2, 0x98, 0x90, 0xe1, 0xe1, 0x80, 0x80, 0x03, 0x02, 0x0e, 0x08, 0x5a,
		0x01, 0x12, 0x6f, 0x68, 0xd9, 0x36, 0x37, 0xbb, 0x9e, 0xcf, 0xe9, 0xe9, 0x2a, 0xce, 0x89, 0x8d,
		0x1f, 0x41, 0x7c, 0xed, 0xa7, 0xac, 0x65, 0xf5, 0xda, 0x5c, 0x4b, 0x38, 0xba, 0x54, 0xfe, 0x50,
		0xde, 0xa7, 0x0d, 0x89, 0x12, 0x87, 0xe5, 0x89, 0xdd, 0xbb, 0xda, 0xa4, 0xac, 0x4e, 0x69, 0xab,
		0x5f, 0xea, 0xea, 0x96, 0xbe, 0x99, 0x49, 0xe1, 0xcc, 0xa4, 0x71, 0x26, 0x52, 0x59, 0x93, 0x0b,
		0x82, 0x98, 0xe2, 0xc9, 0xdd, 0xc5, 0x33, 0xf4, 0x3e, 0x10, 0xab, 0xa6, 0xdb, 0xeb, 0x3c, 0x48,
		0xd7, 0x4b, 0xa7, 0x11, 0x31, 0x87, 0x1a, 0xb6, 0xd6, 0xe3, 0x4b, 0x1e, 0xfd, 0xa7, 0x87, 0x49,
		0x0d, 0xdd, 0xbe, 0xe5, 0xf8, 0x21, 0x9a, 0x7d, 0xcc, 0xf1, 0x73, 0xb2, 0x72, 0x46, 0x8e, 0x09,
		0x57, 0xb7, 0x53, 0x52, 0x13, 0x2f, 0x4f, 0x93, 0x80, 0x46, 0x1f, 0xf4, 0x0c, 0x09, 0x68, 0xf4,
		0x45, 0x6f, 0x02, 0x19, 0xbc, 0x2b, 0xc6, 0xae, 0x79, 0xcd, 0x95, 0x23, 0x64, 0xa3, 0x70, 0xcc,
		0xa7, 0x6e, 0x5b, 0x23, 0x7e, 0x44, 0xc1, 0x6c, 0x8d, 0x0a, 0x6c, 0x0d, 0xd8, 0x1a, 0xb0, 0x35,
		0x60, 0x6b, 0xc0, 0xd6, 0x80, 0xad, 0x01, 0x5b, 0x03, 0xb6, 0x06, 0x6c, 0x0d, 0xd8, 0x1a, 0xb0,
		0x35, 0xa4, 0x2f, 0xdd, 0x67, 0xdc, 0xb7, 0xdc, 0xa0, 0xe3, 0x70, 0xd3, 0xe2, 0x9c, 0x75, 0xba,
		0x3c, 0xd0, 0x67, 0x75, 0xcc, 0x7b, 0x18, 0x00, 0x38, 0x00, 0x38, 0x00, 0x38, 0x00, 0x38, 0x21,
		0xbd, 0xf7, 0x1c, 0x97, 0x7f, 0xd0, 0x08, 0xbd, 0xab, 0x80, 0xde, 0x80, 0xde, 0x80, 0xde, 0xab,
		0x81, 0xde, 0x95, 0x2a, 0x80, 0x37, 0x80, 0x77, 0xf1, 0x81, 0x77, 0xc0, 0x6c, 0x9f, 0x71, 0xf3,
		0x3b, 0x7b, 0xd1, 0x87, 0xb7, 0x27, 0x9e, 0x01, 0x98, 0x0d, 0x98, 0x0d, 0x98, 0x0d, 0x98, 0x4d,
		0x69, 0xcd, 0x7b, 0x3d, 0xee, 0xb8, 0x8f, 0x66, 0xd7, 0x0a, 0x82, 0x90, 0x7c, 0x74, 0xf6, 0x8a,
		0xda, 0x28, 0x8d, 0x60, 0x3e, 0x59, 0xc1, 0x13, 0x6b, 0x66, 0xa1, 0x18, 0x46, 0x8f, 0x82, 0x7e,
		0x80, 0x7e, 0x80, 0x7e, 0x80, 0x7e, 0x20, 0xa4, 0x77, 0xdb, 0x7f, 0xe9, 0xf2, 0x58, 0x3b, 0x98,
		0x0a, 0xf3, 0x71, 0xa1, 0x22, 0x46, 0x2a, 0x22, 0x64, 0x74, 0x93, 0xba, 0x2d, 0xf7, 0xac, 0x7e,
		0x98, 0x7e, 0x0e, 0x94, 0x03, 0x94, 0x03, 0x94, 0x03, 0x94, 0x03, 0x21, 0xbd, 0x6b, 0xe9, 0x02,
		0x3e, 0xa3, 0x13, 0x8e, 0x35, 0xec, 0xad, 0xa5, 0x2b, 0xf8, 0xe8, 0x3f, 0x8d, 0x8e, 0xfa, 0x8c,
		0xba, 0x84, 0xcf, 0xea, 0x65, 0x8d, 0xcf, 0xd0, 0xdd, 0x68, 0x35, 0x7e, 0x50, 0x71, 0xbb, 0x87,
		0x8f, 0xfe, 0x6b, 0xe8, 0xbc, 0x86, 0x2c, 0x9a, 0xde, 0xc6, 0x4f, 0x2b, 0x76, 0x57, 0xf1, 0xf8,
		0x3e, 0xf4, 0xf8, 0xe2, 0x77, 0x0a, 0x2c, 0x96, 0x0e, 0x21, 0x96, 0x44, 0xc5, 0x12, 0xda, 0x40,
		0xaf, 0x4d, 0x37, 0xf2, 0xb5, 0x15, 0xd4, 0x20, 0xcf, 0xb5, 0xe8, 0x52, 0xae, 0x59, 0x71, 0x6d,
		0x4e, 0x10, 0x39, 0x57, 0x8d, 0x32, 0x88, 0xbb, 0x9f, 0x8d, 0x3d, 0x55, 0x5a, 0xba, 0xa0, 0x0d,
		0xfb, 0x6b, 0xed, 0x92, 0x76, 0xdf, 0x31, 0xf4, 0x34, 0x45, 0xbb, 0x0e, 0xbf, 0x2a, 0x49, 0x6f,
		0x34, 0x3a, 0xca, 0xe9, 0x93, 0xf4, 0x8f, 0xb3, 0xb8, 0x86, 0x56, 0xfa, 0xc3, 0x6d, 0x73, 0xde,
		0x50, 0xa9, 0x82, 0x86, 0x4a, 0x05, 0xf2, 0x1c, 0xa2, 0xa1, 0x12, 0x1a, 0x2a, 0xa1, 0xa1, 0x12,
		0x8a, 0x9c, 0x11, 0xbf, 0x59, 0xa5, 0x14, 0xce, 0x4c, 0x1a, 0x67, 0x22, 0x95, 0xf5, 0xd8, 0x2b,
		0x28, 0x72, 0x9e, 0x2f, 0x62, 0x50, 0xe4, 0x3c, 0xf1, 0xc5, 0x51, 0x69, 0xa1, 0x44, 0xb8, 0xa8,
		0xb4, 0x10, 0x24, 0x01, 0x14, 0x39, 0xe7, 0xcb, 0xa1, 0x65, 0xa0, 0xd6, 0x42, 0xd6, 0xd6, 0x40,
		0x43, 0xa5, 0x44, 0x5b, 0x03, 0x0d, 0x95, 0x60, 0x6b, 0xc0, 0xd6, 0x80, 0xad, 0x01, 0x5b, 0x03,
		0xb6, 0x06, 0x6c, 0x0d, 0xd8, 0x1a, 0xb0, 0x35, 0x60, 0x6b, 0xc0, 0xd6, 0x90, 0xbf, 0x74, 0xdb,
		0xeb, 0xb9, 0x9c, 0xf9, 0x1a, 0x8b, 0x33, 0xe2, 0x27, 0xe8, 0x81, 0xda, 0x65, 0x40, 0x6d, 0x40,
		0x6d, 0x40, 0xed, 0x3c, 0x42, 0x6d, 0xea, 0x20, 0xec, 0xd8, 0x41, 0x62, 0xdb, 0x2c, 0x08, 0xcc,
		0xc1, 0x1f, 0x3a, 0x1a, 0xc0, 0xcd, 0x7a, 0x4b, 0xa6, 0x9f, 0xa7, 0x89, 0x60, 0xf4, 0xf8, 0x0e,
		0xb4, 0x0b, 0xb6, 0x2c, 0x04, 0x5c, 0x76, 0x82, 0x2e, 0x2b, 0x81, 0x97, 0xb9, 0xe0, 0xcb, 0x5c,
		0x00, 0x66, 0x2a, 0x08, 0x35, 0x43, 0x4b, 0x4d, 0x1c, 0xa3, 0xcd, 0x17, 0x91, 0x04, 0xc2, 0x0e,
		0x0f, 0x32, 0xa8, 0x55, 0xd0, 0x59, 0xaa, 0xa0, 0xd7, 0x43, 0xa1, 0xdf, 0x53, 0x91, 0xa9, 0xc7,
		0x22, 0x6b, 0xcf, 0xc5, 0xca, 0x4c, 0xd7, 0xec, 0x4d, 0xd8, 0x0c, 0x3c, 0x1a, 0x99, 0x7a, 0x36,
		0x66, 0x48, 0xa5, 0xfc, 0xe1, 0xe0, 0xe0, 0xf0, 0xe8, 0xe0, 0x60, 0xef, 0x68, 0xff, 0x68, 0xef,
		0xb8, 0x5a, 0x2d, 0x1f, 0x96, 0xab, 0xa0, 0x9e, 0x42, 0x68, 0x2b, 0xfd, 0xbb, 0x17, 0xa5, 0xa6,
		0x42, 0x03, 0x77, 0x8e, 0x6c, 0x01, 0x9f, 0xfd, 0xff, 0x98, 0x9d, 0xa1, 0xed, 0x31, 0x7a, 0x1e,
		0x6c, 0x0f, 0xd8, 0x1e, 0xb0, 0x3d, 0x60, 0x7b, 0xc0, 0xf6, 0x80, 0xed, 0x01, 0xdb, 0x03, 0xb6,
		0x07, 0x6c, 0x0f, 0x50, 0x0f, 0x6c, 0x8f, 0x0d, 0xb1, 0x3d, 0x7c, 0xc6, 0x7d, 0x87, 0x35, 0xcd,
		0xd8, 0x26, 0xf8, 0xbf, 0x1e, 0x0b, 0xb2, 0x30, 0x42, 0x92, 0x1e, 0x0c, 0x6b, 0x04, 0xd6, 0x08,
		0xac, 0x11, 0x58, 0x23, 0xb0, 0x46, 0x60, 0x8d, 0xc0, 0x1a, 0x81, 0x35, 0x02, 0x6b, 0x04, 0xd4,
		0x03, 0x6b, 0x64, 0x43, 0xac, 0x11, 0xee, 0x74, 0x98, 0xd7, 0xe3, 0xd9, 0x5b, 0x23, 0x49, 0x0f,
		0x86, 0x35, 0x02, 0x6b, 0x04, 0xd6, 0x08, 0xac, 0x11, 0x58, 0x23, 0xb0, 0x46, 0x60, 0x8d, 0xc0,
		0x1a, 0x81, 0x35, 0x02, 0xea, 0x81, 0x35, 0x92, 0x47, 0x6b, 0x24, 0xd7, 0x65, 0x2b, 0x9a, 0x7a,
		0xcc, 0xc6, 0xfb, 0x6b, 0xed, 0x35, 0x1b, 0xf6, 0x25, 0xdd, 0xd5, 0x54, 0x73, 0x67, 0x68, 0xed,
		0x3d, 0x7b, 0x33, 0xf8, 0xea, 0xf7, 0x27, 0xa3, 0xaf, 0xbe, 0x01, 0xc5, 0x97, 0x3e, 0xe3, 0xbe,
		0xe5, 0x06, 0x1d, 0x87, 0x9b, 0x16, 0xe7, 0xac, 0xa3, 0xa3, 0x98, 0x69, 0x2a, 0x86, 0xf7, 0xf6,
		0x61, 0xe8, 0x7e, 0x82, 0x92, 0xcc, 0x95, 0x5b, 0xc0, 0x28, 0xc9, 0xcc, 0x4e, 0xb7, 0xe9, 0xef,
		0x7e, 0xd2, 0x73, 0x5c, 0xfe, 0x41, 0x63, 0xdf, 0x93, 0x2a, 0xfa, 0x9e, 0x64, 0x6b, 0xad, 0xa2,
		0xef, 0x49, 0x9e, 0xad, 0xd1, 0x6c, 0xfb, 0x9e, 0x54, 0xaa, 0xe8, 0x7a, 0x92, 0x2f, 0xb3, 0x0f,
		0x5d, 0x4f, 0xa4, 0x6c, 0x98, 0x78, 0xa0, 0x78, 0x16, 0x43, 0xcb, 0x01, 0xb3, 0x01, 0xb3, 0x01,
		0xb3, 0x01, 0xb3, 0x49, 0xad, 0x79, 0xaf, 0xc7, 0x1d, 0xf7, 0x31, 0x9e, 0x57, 0x8e, 0x51, 0xe5,
		0x54, 0x1a, 0xc1, 0x7c, 0xb2, 0x82, 0x27, 0xd6, 0xcc, 0x42, 0x31, 0x8c, 0x1e, 0x05, 0xfd, 0x00,
		0xfd, 0x00, 0xfd, 0x00, 0xfd, 0x40, 0x48, 0xef, 0xb6, 0xff, 0xd2, 0xe5, 0xb1, 0x76, 0x30, 0xf9,
		0xe0, 0x81, 0x50, 0x11, 0x6a, 0x2a, 0x22, 0x64, 0xf4, 0x78, 0xe8, 0xaf, 0x3e, 0xfd, 0x30, 0xfd,
		0x1c, 0x28, 0x07, 0x28, 0x07, 0x28, 0x07, 0x28, 0x07, 0x42, 0x7a, 0x77, 0xba, 0x1a, 0x47, 0x97,
		0xc7, 0x3a, 0xe1, 0x58, 0xc3, 0xde, 0xd1, 0xd9, 0x7c, 0x2b, 0xf0, 0xd8, 0xf8, 0x03, 0x8c, 0x8d,
		0x17, 0x7c, 0x50, 0x38, 0x98, 0xba, 0xf1, 0xfa, 0xad, 0x6c, 0x1e, 0x37, 0x86, 0x3f, 0x96, 0xc3,
		0x3f, 0x7e, 0x55, 0xfa, 0xaf, 0x95, 0x6f, 0x7b, 0xe6, 0x41, 0xf4, 0xdb, 0x4a, 0xf5, 0xdb, 0x9e,
		0x59, 0x6d, 0x6c, 0x6f, 0xdd, 0xdd, 0xbd, 0x17, 0x5d, 0xb3, 0xfd, 0x6b, 0xbf, 0x8f, 0x21, 0xe9,
		0xcb, 0x9f, 0x16, 0x0d, 0x49, 0xcf, 0xe0, 0x36, 0x0a, 0x38, 0x14, 0x7c, 0xa7, 0xc0, 0x62, 0xe9,
		0x10, 0x62, 0x49, 0x54, 0x2c, 0xcd, 0x1b, 0x98, 0x7f, 0xd4, 0x4f, 0x39, 0xea, 0xff, 0xa8, 0xff,
		0x31, 0xe1, 0x5f, 0x0e, 0xfb, 0x1f, 0x53, 0xee, 0x51, 0x4d, 0x98, 0xcd, 0x5f, 0x49, 0x5a, 0x70,
		0x90, 0xb0, 0x60, 0x3f, 0x69, 0xc1, 0x7e, 0xc2, 0x82, 0xc4, 0xaf, 0x54, 0x49, 0x58, 0x50, 0xed,
		0xbf, 0xce, 0x7c, 0x7e, 0x6b, 0xfe, 0x47, 0x0f, 0xfb, 0xdb, 0xaf, 0x49, 0xff, 0x76, 0xd4, 0x7f,
		0xfd, 0xb8, 0xbd, 0x0d, 0x41, 0x9d, 0x5a, 0x50, 0x83, 0x3c, 0xb3, 0x27, 0xcf, 0xe2, 0x29, 0xae,
		0xcd, 0x09, 0x22, 0xe7, 0x6a, 0x4a, 0xb9, 0xa6, 0x4c, 0xe3, 0x0c, 0x32, 0x8c, 0x29, 0xe7, 0xf5,
		0xeb, 0x4d, 0x28, 0xa6, 0xe1, 0x45, 0x75, 0xba, 0x51, 0xdb, 0x41, 0x91, 0xe2, 0xa8, 0x29, 0x4d,
		0x2b, 0x85, 0x11, 0xd0, 0x96, 0x36, 0x9a, 0x52, 0xa3, 0x26, 0x79, 0x1a, 0x50, 0xb8, 0xff, 0xd2,
		0x90, 0x61, 0x55, 0xaf, 0x7d, 0xec, 0x9e, 0x26, 0xe0, 0x7f, 0xa2, 0xe1, 0x3d, 0x63, 0xaf, 0x73,
		0x45, 0x71, 0x23, 0x42, 0x2f, 0x33, 0xbd, 0x57, 0x99, 0xda, 0x8b, 0xac, 0xcd, 0x6b, 0xac, 0xcd,
		0x4b, 0xac, 0xc5, 0x2b, 0xbc, 0x5a, 0x89, 0x4c, 0x35, 0x1c, 0xa7, 0x44, 0x1d, 0x8f, 0x1a, 0x77,
		0x9e, 0x26, 0xf5, 0x07, 0x10, 0x07, 0x9e, 0xc8, 0x03, 0x4e, 0x3a, 0x02, 0x4d, 0xfa, 0x02, 0x4c,
		0xba, 0x02, 0x4b, 0xda, 0x03, 0x4a, 0xda, 0x03, 0x49, 0x5a, 0x03, 0x48, 0xf9, 0x32, 0x1f, 0xc8,
		0x03, 0x45, 0x7a, 0x03, 0x44, 0x3a, 0x02, 0x43, 0x7a, 0x02, 0x42, 0x5a, 0x43, 0x6f, 0x5a, 0x03,
		0x40, 0x3a, 0x3d, 0xac, 0xda, 0x3d, 0xab, 0x05, 0x0e, 0xf4, 0x34, 0x74, 0x1c, 0x77, 0x16, 0xfe,
		0xc2, 0x82, 0x07, 0x74, 0x1a, 0x79, 0x8e, 0xe4, 0xeb, 0x15, 0x23, 0x87, 0x10, 0x23, 0x49, 0x62,
		0x04, 0x9e, 0xef, 0xb5, 0x09, 0xcc, 0x14, 0x5e, 0xb0, 0x82, 0x0c, 0xd7, 0x22, 0x00, 0x93, 0xd7,
		0x80, 0x46, 0x23, 0x2f, 0xee, 0x6d, 0x02, 0x37, 0x97, 0xed, 0xb9, 0x2e, 0x0b, 0xab, 0x3f, 0x4d,
		0xeb, 0xc1, 0xf3, 0xb9, 0x06, 0x9f, 0xc6, 0xec, 0x23, 0xe0, 0xdd, 0x80, 0x77, 0x03, 0xde, 0x8d,
		0x8d, 0xf2, 0x6e, 0xe8, 0x68, 0xba, 0xa8, 0xa1, 0xc9, 0xa2, 0xa6, 0xb6, 0x14, 0x1a, 0xac, 0x12,
		0x9d, 0x6d, 0x28, 0x74, 0xb7, 0x9f, 0xc8, 0xac, 0xe3, 0x80, 0xfe, 0x4e, 0x03, 0x3a, 0x9a, 0x3c,
		0xeb, 0x6c, 0x2f, 0xb1, 0x82, 0xa6, 0x86, 0xeb, 0x74, 0xdb, 0x40, 0xa4, 0x59, 0x22, 0x52, 0xbb,
		0xed, 0x05, 0x4c, 0x2f, 0x22, 0x8d, 0x1e, 0x01, 0x44, 0x0a, 0x44, 0x0a, 0x44, 0x0a, 0x44, 0x0a,
		0x44, 0x0a, 0x44, 0x0a, 0x44, 0x0a, 0x44, 0x0a, 0x44, 0x0a, 0x44, 0x3a, 0x0f, 0x91, 0xb6, 0x2c,
		0xa7, 0xdd, 0xf3, 0x35, 0x63, 0xd2, 0xf8, 0x21, 0x40, 0xa5, 0x40, 0xa5, 0x40, 0xa5, 0x40, 0xa5,
		0x40, 0xa5, 0x40, 0xa5, 0x40, 0xa5, 0x40, 0xa5, 0x40, 0xa5, 0x40, 0xa5, 0xf3, 0x50, 0xa9, 0xd7,
		0x65, 0xae, 0x5e, 0x48, 0x3a, 0x7c, 0x02, 0xf0, 0x28, 0xf0, 0x28, 0xf0, 0x28, 0xf0, 0x28, 0xf0,
		0x28, 0xf0, 0x28, 0xf0, 0x28, 0xf0, 0x28, 0xf0, 0x28, 0xf0, 0xe8, 0x3c, 0x3c, 0x1a, 0x0d, 0x0b,
		0xd7, 0x0b, 0x49, 0xe3, 0x87, 0x00, 0x95, 0x02, 0x95, 0x02, 0x95, 0x02, 0x95, 0x02, 0x95, 0x02,
		0x95, 0x02, 0x95, 0x02, 0x95, 0x02, 0x95, 0x02, 0x95, 0xc6, 0x97, 0xc8, 0x7c, 0xdf, 0xf3, 0x03,
		0xd3, 0x67, 0x36, 0x73, 0x9e, 0x09, 0x27, 0xcc, 0xc4, 0xaa, 0xe8, 0xed, 0x03, 0x80, 0x46, 0x81,
		0x46, 0x81, 0x46, 0x81, 0x46, 0x81, 0x46, 0x81, 0x46, 0x81, 0x46, 0x81, 0x46, 0x81, 0x46, 0x81,
		0x46, 0xe3, 0x4b, 0xec, 0xb0, 0x20, 0xb0, 0x1e, 0x99, 0x4e, 0x3c, 0x3a, 0xfb, 0x08, 0x20, 0x52,
		0x20, 0x52, 0x20, 0x52, 0x20, 0x52, 0x20, 0x52, 0x20, 0x52, 0x20, 0x52, 0x20, 0x52, 0x20, 0x52,
		0x20, 0xd2, 0x59, 0x44, 0x1a, 0x0c, 0x55, 0xae, 0x2e, 0x34, 0x1a, 0x6e, 0x0f, 0x24, 0x0a, 0x24,
		0x0a, 0x24, 0x0a, 0x24, 0x0a, 0x24, 0x0a, 0x24, 0x0a, 0x24, 0x0a, 0x24, 0x0a, 0x24, 0x0a, 0x24,
		0x1a, 0x5f, 0x62, 0x34, 0x38, 0x8a, 0x18, 0x80, 0x86, 0xbb, 0x02, 0x77, 0x02, 0x77, 0x02, 0x77,
		0x6e, 0x14, 0xee, 0x0c, 0xb8, 0xef, 0xb8, 0x8f, 0x3a, 0x26, 0xa9, 0x7c, 0x58, 0x23, 0x99, 0x1b,
		0xe5, 0xd0, 0xd3, 0x8b, 0xdd, 0xd1, 0xc6, 0x90, 0xbc, 0x90, 0xbc, 0x90, 0xbc, 0x1b, 0x25, 0x79,
		0x7b, 0x8e, 0xcb, 0xcb, 0x87, 0x1a, 0x24, 0xef, 0x21, 0xcc, 0x7d, 0x98, 0xfb, 0x30, 0xf7, 0xc5,
		0xae, 0xf6, 0xb0, 0x5a, 0xdd, 0x87, 0x7d, 0x0f, 0xfb, 0x7e, 0x95, 0x3b, 0x6c, 0xc6, 0x20, 0x6d,
		0xaa, 0x19, 0xed, 0x1a, 0xe6, 0x68, 0x13, 0x0c, 0x65, 0x5f, 0xcd, 0x18, 0x6d, 0x6e, 0xd9, 0x96,
		0x1d, 0xd0, 0xcd, 0xd1, 0x8e, 0xf6, 0xcb, 0xd9, 0x20, 0xed, 0x3d, 0x0c, 0xd2, 0xce, 0x81, 0x95,
		0x81, 0x41, 0xda, 0xe9, 0xdf, 0x88, 0x6c, 0x90, 0xb6, 0x3d, 0xe2, 0x01, 0xfa, 0x3e, 0x01, 0x83,
		0x7d, 0x69, 0xdd, 0x0f, 0x65, 0xb8, 0x1f, 0xe0, 0x7e, 0x80, 0xfb, 0x81, 0xe2, 0x4d, 0xa9, 0x04,
		0x48, 0xbc, 0x61, 0xd7, 0xf3, 0x39, 0x3d, 0x49, 0x8d, 0x98, 0x20, 0xdc, 0x9d, 0xf8, 0xb2, 0x4f,
		0x59, 0xcb, 0xea, 0xb5, 0xb9, 0x96, 0x61, 0x98, 0xa5, 0x83, 0x63, 0xda, 0x71, 0x8c, 0xc4, 0x23,
		0x41, 0x89, 0x1d, 0xba, 0xda, 0x24, 0xab, 0x4e, 0x09, 0xab, 0x5f, 0xd2, 0xea, 0x96, 0xb8, 0x99,
		0x49, 0xde, 0xcc, 0x24, 0x70, 0x26, 0x92, 0x58, 0x93, 0xd3, 0x81, 0x98, 0xe2, 0xc9, 0x1d, 0xc4,
		0x73, 0x85, 0xaa, 0xe9, 0xf6, 0x3a, 0x0f, 0xcc, 0xd7, 0x38, 0x4e, 0xfb, 0x50, 0xc3, 0xd6, 0x7a,
		0xbc, 0xc7, 0xa3, 0xff, 0xf4, 0x30, 0xa9, 0xa1, 0xdb, 0x9b, 0x1c, 0x3f, 0x44, 0xb3, 0x57, 0x39,
		0x7e, 0x4e, 0x56, 0xee, 0xc7, 0x31, 0xe1, 0xea, 0x76, 0x43, 0x6a, 0xe2, 0xe5, 0x69, 0x12, 0xd0,
		0xe8, 0x75, 0x9e, 0x21, 0x01, 0x8d, 0xde, 0xe7, 0x4d, 0x20, 0x83, 0x77, 0xc5, 0xd8, 0x35, 0xaf,
		0x73, 0xba, 0x09, 0xd9, 0xa8, 0x14, 0x30, 0xdb, 0x67, 0xdc, 0xfc, 0xce, 0x5e, 0xf4, 0x59, 0x19,
		0x13, 0xcf, 0x00, 0xdc, 0x06, 0xdc, 0x06, 0xdc, 0x06, 0xdc, 0x26, 0xa4, 0x77, 0xdf, 0xeb, 0x71,
		0xc7, 0x7d, 0x34, 0xbb, 0x56, 0x10, 0x84, 0xe4, 0xa3, 0x0f, 0x73, 0x13, 0xe5, 0xc8, 0x15, 0x45,
		0x23, 0x98, 0x4f, 0x56, 0xf0, 0x44, 0xd8, 0xcb, 0x61, 0x81, 0x62, 0x18, 0x3d, 0x0a, 0xfa, 0x01,
		0xfa, 0x01, 0xfa, 0x01, 0xfa, 0x81, 0x90, 0xde, 0x6d, 0xff, 0xa5, 0xcb, 0x63, 0xed, 0x60, 0xf2,
		0xc1, 0x03, 0xa1, 0x22, 0xd4, 0x54, 0x44, 0xc8, 0xe8, 0xa6, 0xd5, 0x6c, 0xfa, 0x2c, 0x08, 0x34,
		0xea, 0x87, 0xe9, 0xe7, 0x40, 0x39, 0x40, 0x39, 0x40, 0x39, 0x40, 0x39, 0x10, 0xd2, 0xbb, 0xd3,
		0xd5, 0x24, 0x5d, 0xa6, 0x74, 0xc2, 0xb1, 0x86, 0xbd, 0xa3, 0xb3, 0x29, 0x9c, 0xab, 0x7e, 0x7c,
		0xf2, 0xcf, 0x07, 0x1a, 0xcf, 0x7e, 0x56, 0x2f, 0x6b, 0x7c, 0xc6, 0x95, 0xc5, 0x39, 0xf3, 0x5d,
		0x6d, 0xd7, 0x11, 0x3f, 0x68, 0xeb, 0xdb, 0x9e, 0x79, 0xdc, 0x78, 0xfd, 0x56, 0x36, 0x8f, 0x1b,
		0xc3, 0x1f, 0xcb, 0xe1, 0x1f, 0xbf, 0x2a, 0xfd, 0xd7, 0xca, 0xb7, 0x3d, 0xf3, 0x20, 0xfa, 0x6d,
		0xa5, 0xfa, 0x6d, 0xcf, 0xac, 0x36, 0xb6, 0xb7, 0xee, 0xee, 0xde, 0x8b, 0xae, 0xd9, 0xfe, 0xb5,
		0xdf, 0x2f, 0x69, 0x7b, 0x8d, 0x86, 0xce, 0x6b, 0xb8, 0xbc, 0x39, 0xfb, 0x77, 0x66, 0x77, 0xf1,
		0xdf, 0xad, 0xac, 0x6e, 0x63, 0xfb, 0x1f, 0x1a, 0xef, 0x43, 0x8f, 0x2f, 0x7e, 0xa7, 0xc0, 0x62,
		0xe9, 0x10, 0x62, 0x49, 0x54, 0x2c, 0x85, 0x54, 0x6d, 0x99, 0xad, 0x9a, 0xf9, 0xb9, 0xf1, 0xab,
		0xbc, 0x73, 0xd0, 0xff, 0xb8, 0xfd, 0xeb, 0xa8, 0xff, 0xf6, 0x97, 0xaf, 0xf3, 0x3e, 0x56, 0xde,
		0x39, 0xea, 0x7f, 0x4c, 0xf8, 0x97, 0xc3, 0xfe, 0xc7, 0x94, 0x7b, 0x54, 0xfb, 0x5b, 0x33, 0x1f,
		0x1d, 0xfc, 0xbe, 0x92, 0xb4, 0xe0, 0x20, 0x61, 0xc1, 0x7e, 0xd2, 0x82, 0xfd, 0x84, 0x05, 0x89,
		0x5f, 0xa9, 0x92, 0xb0, 0xa0, 0xda, 0x7f, 0x9d, 0xf9, 0xfc, 0xd6, 0xfc, 0x8f, 0x1e, 0xf6, 0xb7,
		0x5f, 0x93, 0xfe, 0xed, 0xa8, 0xff, 0xfa, 0x71, 0x7b, 0x1b, 0x82, 0x3a, 0xb5, 0xa0, 0x06, 0x79,
		0x66, 0x4f, 0x9e, 0xc5, 0x53, 0x5c, 0x9b, 0x13, 0x44, 0xce, 0x55, 0xde, 0x2c, 0x71, 0x29, 0xd4,
		0xd8, 0x53, 0xa5, 0xa5, 0x24, 0x6a, 0x58, 0x6e, 0xb3, 0x4b, 0x9a, 0x8c, 0x6f, 0xe8, 0x29, 0x91,
		0xba, 0x0d, 0xbf, 0xea, 0x7d, 0xe4, 0x94, 0x5a, 0xa3, 0x16, 0x0f, 0xc3, 0xb2, 0x34, 0xf2, 0x02,
		0x0b, 0xaa, 0x6a, 0x37, 0x43, 0x67, 0x7d, 0x45, 0x05, 0xf5, 0x15, 0x05, 0xf2, 0x1c, 0xa2, 0xbe,
		0x02, 0xf5, 0x15, 0x84, 0x7b, 0xa3, 0xbe, 0x02, 0x31, 0x1b, 0x03, 0x31, 0x9b, 0x5c, 0x49, 0xe0,
		0x4c, 0x24, 0xb1, 0x1e, 0x1b, 0x05, 0xf5, 0x15, 0xf3, 0x45, 0x0c, 0xea, 0x2b, 0x26, 0xbe, 0x38,
		0xea, 0x2b, 0x94, 0x08, 0x17, 0xf5, 0x15, 0x82, 0x24, 0x80, 0xfa, 0x8a, 0x7c, 0x39, 0xb1, 0x0c,
		0xd4, 0x57, 0xc8, 0xba, 0x29, 0x50, 0x5f, 0x01, 0xb8, 0x0d, 0xb8, 0x0d, 0xb8, 0x5d, 0x58, 0xb8,
		0x8d, 0xfa, 0x0a, 0xd4, 0x57, 0x40, 0x3f, 0x40, 0x3f, 0x40, 0x3f, 0x40, 0x3f, 0xcc, 0xa3, 0x77,
		0xd4, 0x57, 0xd0, 0xab, 0x08, 0xd4, 0x57, 0x40, 0x39, 0x40, 0x39, 0x40, 0x39, 0x14, 0x5e, 0x39,
		0xa0, 0xbe, 0x62, 0xee, 0x7f, 0xa8, 0xaf, 0x10, 0x93, 0xcc, 0xa8, 0xaf, 0x48, 0xfb, 0x1f, 0xea,
		0x2b, 0x50, 0x5f, 0x91, 0x73, 0xb1, 0x84, 0xfa, 0x0a, 0x61, 0xb1, 0x84, 0x04, 0x76, 0xd4, 0x57,
		0xe4, 0x5d, 0x50, 0x83, 0x3c, 0x51, 0x5f, 0x91, 0xb1, 0x3d, 0x64, 0xa0, 0xbe, 0x22, 0xad, 0xad,
		0x5b, 0xc4, 0xfa, 0x0a, 0xca, 0x5c, 0x7c, 0x43, 0x6b, 0x79, 0x05, 0xc1, 0x20, 0x1a, 0x3a, 0xba,
		0xc1, 0x50, 0xa3, 0xb4, 0x14, 0x96, 0xcf, 0xa9, 0x46, 0x43, 0x9a, 0x5a, 0xd9, 0x58, 0xa3, 0x77,
		0x19, 0x52, 0x4d, 0xe9, 0xcf, 0x30, 0x2f, 0xa6, 0xa4, 0x66, 0x10, 0x94, 0xbe, 0x38, 0x01, 0xaf,
		0x71, 0xae, 0x56, 0x1a, 0x50, 0x3a, 0x77, 0xdc, 0x7a, 0x9b, 0x75, 0x98, 0xab, 0x9a, 0x0d, 0x56,
		0x3a, 0xb7, 0x7e, 0x4e, 0xec, 0x44, 0x3b, 0x99, 0xbe, 0x74, 0xe9, 0x37, 0x99, 0xcf, 0x9a, 0x9f,
		0x06, 0x07, 0xe7, 0xf6, 0xda, 0xed, 0x4c, 0xef, 0x8b, 0x88, 0xbb, 0xf5, 0x70, 0xb5, 0x02, 0x3b,
		0xd3, 0xb3, 0xb1, 0x1c, 0xff, 0x8a, 0x73, 0x9f, 0xd8, 0x0a, 0xc1, 0x7b, 0x57, 0xbd, 0x6f, 0xe2,
		0x7b, 0x96, 0xb8, 0x60, 0xc2, 0x8b, 0x15, 0xbb, 0xd1, 0xf4, 0xf7, 0x22, 0x70, 0x27, 0x92, 0x55,
		0x8f, 0x4a, 0xd5, 0x8d, 0x92, 0x55, 0x8c, 0xd2, 0xd5, 0x8a, 0x2a, 0x71, 0x38, 0xf5, 0x38, 0x9b,
		0x6a, 0x1c, 0x8d, 0x2c, 0x4e, 0x46, 0x16, 0x07, 0x23, 0x89, 0x73, 0xe9, 0x95, 0x32, 0xb2, 0x55,
		0x7d, 0xa5, 0x88, 0xad, 0x25, 0xaf, 0x6a, 0x44, 0x2c, 0xe1, 0x2e, 0xb2, 0x00, 0x46, 0x29, 0xc8,
		0xad, 0x1c, 0xcc, 0xa6, 0x08, 0x5a, 0xd3, 0x05, 0xa7, 0xa9, 0x82, 0xd0, 0xe4, 0xc1, 0x66, 0xf2,
		0xa0, 0x32, 0x69, 0xf0, 0x38, 0x5b, 0xc8, 0xad, 0x1c, 0xf4, 0x9d, 0xd0, 0x26, 0xbe, 0xe3, 0xaa,
		0xf4, 0x3f, 0x50, 0x4c, 0xea, 0x91, 0x00, 0x4b, 0x12, 0x0a, 0x81, 0xab, 0x9c, 0xd7, 0x78, 0x42,
		0xab, 0x7c, 0x5a, 0x14, 0x64, 0x0c, 0x64, 0xcc, 0xc6, 0xca, 0x18, 0xa7, 0xc9, 0x5c, 0xee, 0xf0,
		0x17, 0x9f, 0xb5, 0x28, 0x04, 0x8d, 0x8a, 0xe1, 0x7d, 0x16, 0x7d, 0x95, 0x4f, 0x56, 0xc0, 0xe8,
		0x46, 0x37, 0xd7, 0x6a, 0xb5, 0xfb, 0x9b, 0xfa, 0xf5, 0x5f, 0xf5, 0xeb, 0xfb, 0xdb, 0xbf, 0xaf,
		0xea, 0xaa, 0x44, 0x18, 0x56, 0xd0, 0x05, 0x24, 0x41, 0x1f, 0xe2, 0xce, 0x2a, 0xd7, 0xb5, 0xd3,
		0xb3, 0xaf, 0x37, 0xa5, 0x3c, 0x34, 0x8f, 0x21, 0x7e, 0xb3, 0xdb, 0xda, 0x49, 0xed, 0xe4, 0x66,
		0xd5, 0xb3, 0x8f, 0x1b, 0x59, 0xcb, 0x06, 0xb8, 0x2a, 0xe6, 0xba, 0x2a, 0x24, 0x83, 0x16, 0x24,
		0x8e, 0x0a, 0xf1, 0x30, 0x84, 0x80, 0x9b, 0xe2, 0x1d, 0xe1, 0xad, 0x8d, 0x1c, 0xbf, 0x02, 0xa6,
		0x97, 0x9c, 0x97, 0x57, 0xde, 0xab, 0x4b, 0xea, 0xc5, 0x95, 0xf3, 0xda, 0xa6, 0x3d, 0x4c, 0x49,
		0xd2, 0x27, 0x22, 0xf9, 0x92, 0x90, 0xff, 0x4a, 0x95, 0xc8, 0xd3, 0x91, 0xf7, 0x72, 0x62, 0x5d,
		0xfc, 0x89, 0x25, 0x27, 0x2f, 0x7a, 0xe2, 0xf2, 0x27, 0x9d, 0xe2, 0x70, 0x25, 0x0f, 0x75, 0xf1,
		0x41, 0x26, 0x1f, 0xcf, 0x82, 0xa3, 0x49, 0xe9, 0x9e, 0x14, 0x72, 0x47, 0xa6, 0x74, 0x3f, 0xa6,
		0x76, 0x37, 0x8a, 0x58, 0x33, 0xe2, 0x56, 0x8b, 0xa8, 0x75, 0x22, 0x6d, 0x85, 0x48, 0x5b, 0x1b,
		0x52, 0x56, 0x45, 0x8e, 0x99, 0x25, 0xa5, 0xba, 0x15, 0x61, 0x92, 0xe5, 0x5a, 0x74, 0x01, 0x77,
		0xbc, 0x13, 0x38, 0xa1, 0xb4, 0x27, 0x23, 0x72, 0x22, 0xa5, 0x85, 0xec, 0x99, 0xf2, 0x0c, 0xe6,
		0xbf, 0xfd, 0xec, 0xbb, 0xcd, 0x79, 0xaf, 0x92, 0xd5, 0xb6, 0xfc, 0x4e, 0x72, 0xd1, 0x52, 0xcc,
		0x53, 0xd1, 0xe7, 0x12, 0x4e, 0x66, 0x31, 0xd7, 0x2f, 0xe5, 0xf6, 0x34, 0x5c, 0x3e, 0xc5, 0xdd,
		0x8b, 0xbe, 0x8c, 0x08, 0x63, 0x0b, 0x33, 0xb4, 0x30, 0x23, 0xcf, 0x30, 0xf0, 0xf0, 0xab, 0x13,
		0x51, 0xe4, 0x32, 0x57, 0xfc, 0xf0, 0xda, 0xd2, 0x8b, 0xf8, 0xe1, 0xc7, 0x89, 0x45, 0xfc, 0x9e,
		0x26, 0x11, 0xbf, 0x8c, 0x08, 0x0a, 0x2c, 0xe5, 0x97, 0x10, 0x09, 0x8d, 0xa0, 0x4f, 0x1b, 0xc7,
		0x29, 0xd9, 0xa3, 0x9b, 0x4c, 0x79, 0x7e, 0x71, 0xad, 0xa9, 0x48, 0xc7, 0x5d, 0xc1, 0xc0, 0xa5,
		0xb0, 0x9f, 0x54, 0xc6, 0x2f, 0x2a, 0x45, 0x6e, 0xaa, 0xae, 0x4f, 0x65, 0x57, 0xa7, 0xb2, 0x6b,
		0x53, 0x96, 0x1c, 0xf5, 0xd8, 0x9e, 0xda, 0xcd, 0xa5, 0xf0, 0xed, 0x86, 0x7f, 0x88, 0x37, 0x89,
		0x4e, 0xab, 0xa5, 0xc3, 0x87, 0x0c, 0xff, 0x10, 0x6a, 0xef, 0x9c, 0xc2, 0x34, 0x4a, 0x21, 0x01,
		0x9d, 0xa6, 0x38, 0xf7, 0x3a, 0x4d, 0x41, 0xce, 0xdd, 0x03, 0xe7, 0x82, 0x73, 0x95, 0xe2, 0x0a,
		0xf1, 0xad, 0xb5, 0x99, 0xd5, 0x12, 0x8b, 0x21, 0xc4, 0xea, 0xe3, 0x48, 0x60, 0xcd, 0x55, 0x24,
		0x1c, 0xde, 0xbf, 0x1f, 0x5a, 0x26, 0xbb, 0x4e, 0x33, 0x4b, 0xae, 0x14, 0x4b, 0x0f, 0x92, 0x4a,
		0x0b, 0x92, 0xd6, 0xaa, 0x15, 0xf0, 0xe6, 0x5a, 0xf3, 0xa6, 0x68, 0x12, 0x8f, 0x88, 0x0a, 0x91,
		0x57, 0x25, 0x92, 0x2a, 0x45, 0x5a, 0xb5, 0xa8, 0x90, 0x31, 0x09, 0x39, 0xab, 0x92, 0x35, 0x19,
		0x79, 0x93, 0x91, 0x39, 0x15, 0xb9, 0x8b, 0x87, 0x3c, 0x0c, 0x89, 0x30, 0x94, 0x74, 0xe8, 0x5b,
		0x3d, 0xad, 0x46, 0x32, 0x9d, 0x46, 0x4f, 0xa6, 0xaa, 0xcf, 0x02, 0x49, 0xb9, 0x1a, 0x37, 0x9e,
		0x1b, 0xed, 0x00, 0x4e, 0x07, 0xa7, 0x83, 0xd3, 0x29, 0x38, 0x5d, 0xf0, 0x0d, 0xd9, 0x4f, 0xee,
		0x5b, 0x66, 0xcf, 0x0d, 0xb8, 0xf5, 0xd0, 0x96, 0x7c, 0x57, 0x9f, 0xb5, 0x98, 0xcf, 0x5c, 0x5b,
		0xbe, 0x99, 0x0a, 0x41, 0x16, 0xd1, 0x59, 0xfd, 0xf6, 0xb3, 0xf1, 0x77, 0xed, 0xe2, 0x77, 0x23,
		0xb4, 0x97, 0x8d, 0x73, 0xaf, 0xd9, 0x6b, 0xb3, 0x8f, 0xc6, 0xa9, 0x6f, 0xb5, 0xb8, 0x61, 0x1a,
		0xfc, 0xa5, 0xcb, 0x9a, 0xac, 0x65, 0x8c, 0x44, 0xce, 0x9d, 0xfb, 0xc4, 0x79, 0x37, 0xf8, 0xb8,
		0xbb, 0xcb, 0x3d, 0xaf, 0x1d, 0xbc, 0x77, 0x18, 0x6f, 0xbd, 0xf7, 0xfc, 0xc7, 0xdd, 0x27, 0xde,
		0x69, 0xef, 0x36, 0x07, 0xab, 0xcc, 0x67, 0xab, 0xdd, 0x76, 0x5c, 0xd3, 0x65, 0xbc, 0xe3, 0x35,
		0x87, 0x24, 0x6a, 0x76, 0xc2, 0x7d, 0xcd, 0xbd, 0x4a, 0xce, 0x12, 0xdc, 0xc6, 0x97, 0x90, 0xe7,
		0x1c, 0xb7, 0xec, 0x6f, 0x29, 0xf7, 0x29, 0x33, 0x8d, 0x3c, 0xd4, 0x9c, 0xb0, 0x67, 0xe6, 0x3b,
		0xfc, 0x45, 0xa1, 0xec, 0x64, 0xb4, 0x03, 0x34, 0x39, 0x34, 0xf9, 0x5a, 0x6a, 0x72, 0xb5, 0x34,
		0x55, 0x95, 0xf4, 0x54, 0x9a, 0xb4, 0xd4, 0xf8, 0x45, 0x2e, 0xaf, 0xea, 0x17, 0x27, 0x97, 0x17,
		0x9f, 0xcf, 0x7e, 0xbf, 0xaf, 0x7d, 0xa9, 0x5d, 0x9f, 0xdf, 0xdf, 0xd4, 0xff, 0xaa, 0x5f, 0x9f,
		0xdd, 0xfe, 0x2d, 0x4b, 0x49, 0x04, 0x09, 0xa9, 0x44, 0x99, 0xb6, 0x27, 0xd7, 0x67, 0xb7, 0x67,
		0x27, 0xb5, 0x2f, 0x0a, 0x52, 0x7f, 0x67, 0xd5, 0xef, 0x70, 0x7e, 0x76, 0x71, 0x79, 0x5d, 0xe8,
		0x17, 0xa8, 0xfd, 0xbf, 0x62, 0xbf, 0xc0, 0xbf, 0x6a, 0xd7, 0x17, 0x67, 0x17, 0xbf, 0x17, 0xf9,
		0x15, 0xbe, 0x5e, 0xfc, 0x79, 0x71, 0xf9, 0xaf, 0x8b, 0xac, 0xd1, 0x4f, 0x23, 0x67, 0x52, 0x7f,
		0xe3, 0xac, 0x9b, 0x11, 0x0c, 0x83, 0x75, 0x93, 0x67, 0xeb, 0x86, 0xee, 0x96, 0x60, 0xdd, 0xa4,
		0xb8, 0x22, 0xce, 0x7e, 0x72, 0x79, 0xcb, 0x26, 0x5c, 0x0d, 0xab, 0x06, 0x56, 0x0d, 0xfc, 0x93,
		0xf0, 0x4f, 0xea, 0xd7, 0xe0, 0x43, 0x09, 0x3f, 0x10, 0x3a, 0xd0, 0xe1, 0x79, 0xd6, 0xe1, 0x94,
		0xf7, 0x04, 0x2d, 0x9e, 0x46, 0x8b, 0x3b, 0x1d, 0x66, 0xda, 0x3e, 0xb3, 0x38, 0x53, 0xc8, 0x2a,
		0x98, 0xda, 0x05, 0x5a, 0x1d, 0x5a, 0x7d, 0x2d, 0xb5, 0xfa, 0x80, 0xca, 0xb9, 0x63, 0x7f, 0x0f,
		0x0e, 0x0f, 0x14, 0x54, 0xbb, 0x44, 0x63, 0xed, 0xd2, 0x57, 0x77, 0x38, 0x69, 0xb5, 0xe4, 0x5a,
		0xae, 0x17, 0x30, 0xdb, 0x73, 0x9b, 0x52, 0xa4, 0xa7, 0x36, 0x47, 0x59, 0xad, 0x45, 0xa0, 0xba,
		0xd6, 0x23, 0x9a, 0x73, 0x4c, 0x3e, 0xc0, 0x96, 0x6e, 0x40, 0x6d, 0x5f, 0xad, 0x77, 0x22, 0xdd,
		0x11, 0xd3, 0xb6, 0x5e, 0xcc, 0xfb, 0xa9, 0x6f, 0x92, 0xbe, 0x7f, 0xe9, 0x32, 0x53, 0x25, 0x81,
		0x70, 0xb4, 0x01, 0xb4, 0x3c, 0xb4, 0xfc, 0x5a, 0x6a, 0xf9, 0x9e, 0xeb, 0x78, 0xae, 0x8a, 0xe9,
		0x2e, 0x31, 0x54, 0x49, 0x6d, 0x68, 0xd2, 0x3a, 0x74, 0x24, 0xdb, 0x59, 0xd5, 0x9b, 0xaf, 0x7d,
		0x9f, 0xa4, 0x99, 0xc0, 0xf4, 0xed, 0xdf, 0x57, 0xf5, 0xfb, 0xb3, 0xd3, 0xf5, 0x6d, 0x98, 0xf4,
		0xe5, 0x72, 0x2d, 0xbb, 0x25, 0x5d, 0xde, 0xae, 0xe5, 0x6b, 0xd5, 0xce, 0xd6, 0xf2, 0xb5, 0xea,
		0xff, 0xdf, 0xab, 0x5b, 0x74, 0xb6, 0x22, 0x86, 0xc4, 0x70, 0x73, 0xa7, 0x72, 0x9f, 0x0e, 0x21,
		0x3a, 0x3c, 0xdd, 0x9a, 0x11, 0xf1, 0x5c, 0x64, 0xbc, 0xa2, 0xab, 0xda, 0x5c, 0xe3, 0xb7, 0xb8,
		0x15, 0xee, 0xa2, 0x1d, 0xef, 0x64, 0x0a, 0xdc, 0x05, 0x3a, 0xdb, 0xe9, 0x6e, 0xfd, 0x15, 0x75,
		0xae, 0x5b, 0xea, 0x3b, 0x10, 0xeb, 0x57, 0x27, 0xde, 0xa7, 0x8e, 0xa4, 0x3f, 0x9d, 0x58, 0x5f,
		0xba, 0x95, 0x35, 0x7a, 0x9a, 0x20, 0x37, 0xc2, 0x5e, 0x4f, 0x13, 0x04, 0x56, 0xd0, 0x76, 0x4f,
		0x4b, 0xbb, 0x16, 0x89, 0x9c, 0x84, 0x4a, 0xd3, 0x27, 0xbb, 0xed, 0xd9, 0xdf, 0x97, 0xf7, 0x7c,
		0x1a, 0x7e, 0x4c, 0xb1, 0xe5, 0xd3, 0x1e, 0x4d, 0xcb, 0xa7, 0xe0, 0xa5, 0x98, 0xfd, 0x9e, 0x06,
		0xdf, 0x3b, 0xab, 0x66, 0x4f, 0x29, 0xfb, 0xf4, 0x88, 0xf5, 0xe7, 0xc9, 0x4b, 0xbb, 0xa7, 0xc5,
		0x04, 0x20, 0x0b, 0x01, 0x57, 0xdf, 0xeb, 0x69, 0x21, 0x81, 0xd0, 0xe8, 0xc0, 0xd4, 0x8d, 0x9e,
		0xb8, 0xd3, 0x61, 0xff, 0xf3, 0x5c, 0x66, 0x0a, 0x4d, 0xea, 0x98, 0x0a, 0x55, 0x8e, 0x97, 0xaf,
		0x47, 0xf3, 0x98, 0x74, 0x64, 0xa7, 0x6a, 0x81, 0xe4, 0xaf, 0x3b, 0x45, 0x2a, 0xb2, 0xd4, 0x03,
		0x87, 0xe5, 0xdb, 0xc6, 0x4c, 0x11, 0xa0, 0x29, 0x38, 0xc4, 0x41, 0xd0, 0x99, 0x9c, 0xf6, 0x6d,
		0x14, 0xdc, 0x01, 0x0a, 0x6e, 0x00, 0x85, 0x50, 0xc4, 0x59, 0xed, 0xa2, 0x66, 0xdc, 0x3a, 0x1d,
		0x66, 0xfc, 0xc7, 0x73, 0x99, 0x71, 0x6a, 0x71, 0xeb, 0xc1, 0x0a, 0xa2, 0xf2, 0xcd, 0x8f, 0xbb,
		0xbb, 0x3f, 0x7e, 0xfc, 0x78, 0xef, 0x58, 0xae, 0x15, 0x9a, 0x8a, 0x61, 0x0e, 0xce, 0xe0, 0xc8,
		0x57, 0x1d, 0xae, 0x52, 0xb5, 0xd3, 0xf5, 0x44, 0xac, 0x64, 0xcf, 0x52, 0x77, 0x7c, 0xeb, 0x1d,
		0xad, 0x01, 0x5d, 0xd4, 0xfe, 0xcd, 0x21, 0xc0, 0x4d, 0xdf, 0xf3, 0x2d, 0x25, 0x3e, 0x3f, 0x19,
		0xec, 0x9a, 0xaa, 0xc9, 0x1b, 0xda, 0x36, 0x03, 0xe4, 0x01, 0xe4, 0x01, 0xe4, 0x01, 0xe4, 0x01,
		0xe4, 0x01, 0xe4, 0x01, 0xe4, 0x01, 0xe4, 0x69, 0x03, 0x79, 0xc4, 0x93, 0x07, 0x86, 0x18, 0xaf,
		0xc0, 0xb3, 0x07, 0x16, 0xf9, 0x76, 0x45, 0xcf, 0x41, 0xc9, 0x15, 0xbd, 0xd8, 0x67, 0x99, 0xce,
		0x57, 0x09, 0x67, 0x74, 0xfe, 0x9c, 0xd1, 0x4d, 0xaf, 0x63, 0x39, 0x6e, 0x3a, 0x90, 0x19, 0x9f,
		0xed, 0xe4, 0xa2, 0x74, 0x16, 0xcb, 0x1e, 0xdc, 0xd2, 0x45, 0xb5, 0x58, 0x52, 0x43, 0x40, 0x09,
		0xf2, 0x98, 0xc6, 0x7a, 0x29, 0x3e, 0xfb, 0x85, 0xb9, 0x8f, 0xa1, 0xcc, 0x4c, 0x07, 0xc1, 0xc4,
		0x46, 0x9a, 0x89, 0x9b, 0x0a, 0x71, 0x49, 0x84, 0x20, 0xc0, 0x57, 0xad, 0x77, 0x90, 0xaf, 0x6f,
		0xe8, 0x8b, 0xcd, 0x6a, 0x93, 0x3f, 0x92, 0x4a, 0x75, 0xbf, 0x38, 0x87, 0x42, 0x84, 0xac, 0x1a,
		0x29, 0x28, 0xf8, 0xca, 0xe2, 0x9c, 0xf9, 0x6e, 0x6a, 0x12, 0x2e, 0x6d, 0x6d, 0x6d, 0x6d, 0x7d,
		0xb3, 0xcc, 0xff, 0xd5, 0xcc, 0xff, 0xec, 0x99, 0xc7, 0xf7, 0x8d, 0x89, 0xbf, 0xdc, 0xdd, 0x99,
		0xf7, 0x8d, 0xed, 0x5f, 0x7b, 0x3b, 0x87, 0xe5, 0xfe, 0xf6, 0x6f, 0xe3, 0xdf, 0x37, 0xee, 0xee,
		0xde, 0x6f, 0xff, 0x53, 0x66, 0xd5, 0x6f, 0xdb, 0xaf, 0x83, 0xb5, 0x25, 0x9a, 0x57, 0xbd, 0xbc,
		0x39, 0xfb, 0xb7, 0xf0, 0xfb, 0xfe, 0x77, 0x15, 0x2f, 0xfc, 0x8f, 0x14, 0x6f, 0xac, 0xc1, 0x47,
		0xf8, 0xe4, 0x05, 0x5c, 0x4c, 0xf5, 0xc6, 0x2b, 0xa0, 0x77, 0xa1, 0x77, 0xa1, 0x77, 0xa1, 0x77,
		0xa1, 0x77, 0xa1, 0x77, 0xa1, 0x77, 0x05, 0xf5, 0x6e, 0xdb, 0x7b, 0x74, 0x5c, 0xf3, 0xc1, 0x72,
		0x5d, 0xe6, 0xa7, 0xd7, 0xbd, 0x53, 0xab, 0xa0, 0x7f, 0xa1, 0x7f, 0xdf, 0x9c, 0x77, 0xea, 0x42,
		0xc9, 0x94, 0xe1, 0x0d, 0x39, 0xda, 0xee, 0x78, 0xbc, 0x29, 0x4c, 0xda, 0x93, 0x8b, 0x40, 0xd9,
		0xa0, 0xec, 0xd5, 0x51, 0xf6, 0x6a, 0xdd, 0xed, 0xcb, 0x72, 0x4c, 0xd2, 0xfa, 0xdb, 0x17, 0x64,
		0x95, 0xa4, 0x74, 0xb8, 0x77, 0x7b, 0x29, 0xc6, 0xfd, 0x86, 0x9f, 0xca, 0xc7, 0xb0, 0x5f, 0x38,
		0xdb, 0x53, 0x64, 0x7e, 0x77, 0x7b, 0x02, 0x69, 0xdf, 0xdd, 0x1e, 0x72, 0xbe, 0x91, 0x0e, 0x14,
		0x7d, 0xd0, 0x71, 0x9b, 0xec, 0xa7, 0xc4, 0x74, 0xd0, 0x70, 0x19, 0xd2, 0x7f, 0x04, 0xac, 0x59,
		0xa4, 0xff, 0x48, 0x20, 0x85, 0x59, 0x5b, 0x69, 0x55, 0xa3, 0x41, 0x43, 0x82, 0xc7, 0x74, 0x50,
		0x30, 0xe6, 0x5a, 0x33, 0xa6, 0xf0, 0x5c, 0xd0, 0x27, 0xcb, 0x6f, 0xfe, 0xb0, 0x7c, 0x66, 0x3a,
		0x2e, 0x67, 0xbe, 0xdf, 0xeb, 0x2a, 0xf4, 0xe7, 0x9e, 0xb3, 0x97, 0x5c, 0xc7, 0xaf, 0x72, 0xc1,
		0x3a, 0x7e, 0x89, 0x11, 0xba, 0x2a, 0xc1, 0x93, 0x11, 0x3e, 0x19, 0x03, 0x90, 0x30, 0x82, 0x18,
		0x43, 0x48, 0xf8, 0xcf, 0xa5, 0x18, 0x24, 0x5e, 0x68, 0x3d, 0x3f, 0xaa, 0x0f, 0xfc, 0x19, 0x6c,
		0x22, 0x79, 0xb4, 0x72, 0xcd, 0xf0, 0x94, 0x59, 0x84, 0x82, 0x55, 0xe6, 0xb1, 0x0c, 0x7f, 0xe9,
		0x4a, 0xe5, 0xa3, 0x52, 0x31, 0x0f, 0x39, 0x13, 0x91, 0x33, 0x53, 0x12, 0x53, 0x0d, 0x4f, 0x2e,
		0xeb, 0xde, 0x1d, 0x92, 0x54, 0x23, 0xdd, 0x5a, 0x6f, 0x86, 0x66, 0xba, 0xcc, 0xb7, 0x99, 0xcb,
		0xad, 0x47, 0x46, 0xd0, 0x72, 0x4d, 0xa5, 0xe3, 0x9a, 0x5a, 0x3f, 0xdc, 0xd1, 0x7f, 0xea, 0x9d,
		0xa3, 0x48, 0xfa, 0xe3, 0xc6, 0x9b, 0x11, 0xf5, 0xc9, 0x8d, 0xf7, 0xa3, 0xee, 0xdc, 0x3a, 0xa6,
		0x07, 0xaa, 0x0e, 0xae, 0x8a, 0xa4, 0x3d, 0x7d, 0x15, 0x04, 0x7d, 0x74, 0x67, 0xae, 0xa2, 0xbc,
		0xb7, 0x81, 0x97, 0xf1, 0x6e, 0x35, 0xab, 0x1b, 0x19, 0x75, 0x34, 0x92, 0x20, 0xb6, 0x92, 0xe3,
		0x06, 0xdc, 0x72, 0xb9, 0x3a, 0xfa, 0x18, 0x6d, 0x04, 0x04, 0x02, 0x04, 0x02, 0x04, 0x02, 0x04,
		0x02, 0x04, 0x02, 0x04, 0x02, 0x04, 0x02, 0x04, 0x92, 0x02, 0x81, 0x70, 0xe6, 0x3f, 0x5b, 0x6d,
		0x0a, 0x08, 0x12, 0xed, 0x04, 0x0c, 0x02, 0x0c, 0x02, 0x0c, 0x22, 0x4c, 0x33, 0x01, 0xb7, 0xb8,
		0xa9, 0xc8, 0x44, 0x86, 0xda, 0x60, 0xa1, 0x78, 0x0b, 0xa2, 0x01, 0x43, 0x80, 0x35, 0x80, 0x35,
		0x19, 0xc3, 0x1a, 0xf2, 0x41, 0x45, 0xc0, 0x39, 0x6b, 0x81, 0x73, 0x3a, 0x0a, 0xd4, 0x36, 0x4e,
		0x99, 0xb5, 0x7e, 0x02, 0xdd, 0x00, 0xdd, 0x00, 0xdd, 0xc0, 0xc3, 0x02, 0x28, 0x02, 0x28, 0x02,
		0x0f, 0x0b, 0x90, 0x47, 0x2a, 0xe4, 0x61, 0x72, 0xa7, 0xc3, 0x48, 0xe0, 0xc7, 0x70, 0x27, 0x60,
		0x10, 0x60, 0x10, 0x60, 0x10, 0x61, 0x9a, 0x51, 0x1b, 0xd8, 0x0c, 0xff, 0x0a, 0x40, 0x0d, 0x40,
		0x0d, 0xfc, 0x2b, 0x40, 0x39, 0x73, 0x51, 0x8e, 0x02, 0xe3, 0x8f, 0x01, 0x8e, 0xe3, 0x02, 0xdb,
		0x00, 0xdb, 0x00, 0xdb, 0xc0, 0xbf, 0x02, 0x28, 0x02, 0x28, 0x02, 0xff, 0x0a, 0x90, 0x47, 0x2a,
		0xe4, 0x41, 0xe5, 0x5f, 0x19, 0xed, 0x04, 0x0c, 0x02, 0x0c, 0x02, 0x0c, 0x02, 0xff, 0x0a, 0x40,
		0x0d, 0x40, 0x0d, 0xfc, 0x2b, 0x40, 0x39, 0xd4, 0x28, 0x47, 0x6b, 0x19, 0xb4, 0xe4, 0xcc, 0xf2,
		0x78, 0x7d, 0xea, 0xc6, 0x59, 0xdd, 0x5e, 0x30, 0xf8, 0xbf, 0xa8, 0x0b, 0x87, 0x72, 0x87, 0x00,
		0x43, 0xa0, 0xd7, 0x56, 0xb7, 0x17, 0x0c, 0xfe, 0x6f, 0x38, 0xe6, 0xe3, 0xfe, 0x8f, 0xe8, 0xd1,
		0x67, 0xf1, 0x93, 0x75, 0x0d, 0x97, 0x17, 0x68, 0x79, 0xe1, 0x34, 0xdb, 0x4c, 0xbe, 0xdf, 0x42,
		0xb8, 0x1a, 0x1d, 0x16, 0xf4, 0x81, 0x4b, 0x74, 0x58, 0x40, 0x87, 0x05, 0x58, 0x66, 0xb0, 0xcc,
		0x36, 0xc3, 0x32, 0x83, 0x77, 0x18, 0x86, 0x14, 0xbc, 0xc3, 0xb0, 0x9b, 0x0a, 0x6e, 0x37, 0xa1,
		0xc3, 0x02, 0x10, 0x08, 0x10, 0x08, 0x10, 0x08, 0x10, 0x08, 0x10, 0x08, 0x10, 0x08, 0x10, 0x48,
		0x41, 0x10, 0x08, 0x3a, 0x2c, 0x00, 0x83, 0x00, 0x83, 0xa0, 0xc3, 0xc2, 0xe4, 0x16, 0x88, 0x50,
		0x03, 0xd6, 0x14, 0x13, 0xd6, 0x20, 0x42, 0x0d, 0x9c, 0x33, 0xef, 0x90, 0xd1, 0x61, 0x01, 0xe8,
		0x06, 0xe8, 0x06, 0x1e, 0x16, 0x40, 0x11, 0x40, 0x11, 0x78, 0x58, 0x80, 0x3c, 0x0c, 0x74, 0x58,
		0x00, 0x06, 0x01, 0x06, 0xd9, 0x28, 0x0c, 0x82, 0x0a, 0x00, 0x80, 0x1a, 0x80, 0x1a, 0xf8, 0x57,
		0x80, 0x72, 0x34, 0xa0, 0x1c, 0x74, 0x58, 0x00, 0xb6, 0x01, 0xb6, 0x81, 0x7f, 0x05, 0x50, 0x04,
		0x50, 0x04, 0xfe, 0x15, 0x20, 0x0f, 0x74, 0x58, 0x00, 0x06, 0x01, 0x06, 0x81, 0x7f, 0x05, 0xfe,
		0x15, 0x80, 0x1a, 0x80, 0x1a, 0xf8, 0x57, 0x80, 0x72, 0x24, 0x57, 0x14, 0xa4, 0xc3, 0x82, 0x44,
		0x4f, 0x00, 0x43, 0xba, 0xa7, 0xc2, 0xd9, 0xe0, 0x61, 0x79, 0x68, 0xa3, 0xe0, 0x36, 0xd9, 0x4f,
		0x85, 0x3e, 0x0a, 0xe1, 0x72, 0xb9, 0x46, 0x0a, 0x7b, 0x68, 0xa4, 0x90, 0x25, 0x76, 0xdc, 0xa4,
		0x46, 0x0a, 0xd2, 0x88, 0x30, 0xbe, 0xef, 0x9e, 0x3b, 0x10, 0x3f, 0x12, 0xd7, 0x3d, 0xea, 0x12,
		0x72, 0x2c, 0xb1, 0x36, 0xfa, 0xda, 0x72, 0x18, 0x8d, 0x00, 0xfe, 0x32, 0xb7, 0xd7, 0x61, 0xfe,
		0x50, 0xf2, 0xaa, 0xc3, 0xdf, 0xf2, 0x81, 0xc2, 0x1e, 0x75, 0xb7, 0xd7, 0x19, 0xdc, 0x60, 0xa6,
		0x96, 0x04, 0xc1, 0x11, 0xf6, 0x1c, 0x97, 0xef, 0x57, 0x08, 0x4e, 0xef, 0x08, 0x60, 0x1f, 0x60,
		0x3f, 0xef, 0x60, 0xff, 0xa0, 0x72, 0x7c, 0x70, 0x7c, 0x78, 0x54, 0x39, 0x06, 0xc4, 0x5f, 0x37,
		0x88, 0xdf, 0xc8, 0x01, 0x38, 0xfd, 0xce, 0x7c, 0x97, 0xb5, 0xe5, 0xd1, 0x69, 0xb4, 0x1e, 0x7d,
		0xbe, 0x00, 0x4f, 0x73, 0x05, 0x4f, 0xd1, 0xe7, 0x0b, 0xf1, 0x01, 0x2d, 0x4c, 0x44, 0xce, 0x4c,
		0x49, 0x4c, 0x85, 0x1c, 0x05, 0xe4, 0x28, 0x00, 0xe1, 0x23, 0x47, 0x01, 0xd0, 0xbe, 0x80, 0xd0,
		0x1e, 0x7d, 0xbe, 0x80, 0x40, 0x80, 0x40, 0x80, 0x40, 0x80, 0x40, 0x80, 0x40, 0x80, 0x40, 0x80,
		0x40, 0x8a, 0x82, 0x40, 0xd0, 0xe7, 0x0b, 0x18, 0x04, 0x18, 0x04, 0x7d, 0xbe, 0x26, 0xb7, 0x40,
		0x9e, 0x24, 0x60, 0x4d, 0x31, 0x61, 0x0d, 0xf2, 0x24, 0x81, 0x73, 0xe6, 0x1d, 0x32, 0xfa, 0x7c,
		0x01, 0xdd, 0x00, 0xdd, 0xc0, 0xc3, 0x02, 0x28, 0x02, 0x28, 0x02, 0x0f, 0x0b, 0x90, 0x87, 0x81,
		0x3e, 0x5f, 0xc0, 0x20, 0xc0, 0x20, 0x1b, 0x85, 0x41, 0x50, 0x87, 0x0a, 0x50, 0x03, 0x50, 0x03,
		0xff, 0x0a, 0x50, 0x8e, 0x06, 0x94, 0x83, 0x3e, 0x5f, 0xc0, 0x36, 0xc0, 0x36, 0xf0, 0xaf, 0x00,
		0x8a, 0x00, 0x8a, 0xc0, 0xbf, 0x02, 0xe4, 0x81, 0x3e, 0x5f, 0xc0, 0x20, 0xc0, 0x20, 0xf0, 0xaf,
		0xc0, 0xbf, 0x02, 0x50, 0x03, 0x50, 0x03, 0xff, 0x0a, 0x50, 0x8e, 0xe4, 0x8a, 0x82, 0xf4, 0xf9,
		0x92, 0xea, 0x0a, 0x60, 0x48, 0x77, 0xfa, 0xfa, 0x73, 0xf8, 0xb8, 0x1c, 0xb4, 0x53, 0x70, 0x1d,
		0x09, 0x8c, 0x13, 0xeb, 0xcc, 0x70, 0x35, 0x5a, 0x29, 0xe8, 0x43, 0x91, 0x68, 0xa5, 0x80, 0x56,
		0x0a, 0x30, 0xc1, 0x60, 0x82, 0x6d, 0x86, 0x09, 0x06, 0x37, 0x30, 0x2c, 0x26, 0xb8, 0x81, 0x61,
		0x20, 0x15, 0xdc, 0x40, 0x42, 0x2b, 0x05, 0x20, 0x10, 0x20, 0x10, 0x20, 0x10, 0x20, 0x10, 0x20,
		0x10, 0x20, 0x10, 0x20, 0x90, 0x82, 0x20, 0x10, 0xb4, 0x52, 0x00, 0x06, 0x01, 0x06, 0x41, 0x2b,
		0x85, 0xc9, 0x2d, 0x10, 0x8a, 0x06, 0xac, 0x29, 0x26, 0xac, 0x41, 0x28, 0x1a, 0x38, 0x67, 0xde,
		0x21, 0xa3, 0x95, 0x02, 0xd0, 0x0d, 0xd0, 0x0d, 0x3c, 0x2c, 0x80, 0x22, 0x80, 0x22, 0xf0, 0xb0,
		0x00, 0x79, 0x18, 0x68, 0xa5, 0x00, 0x0c, 0x02, 0x0c, 0xb2, 0x51, 0x18, 0x04, 0xa9, 0xfe, 0x00,
		0x35, 0x00, 0x35, 0xf0, 0xaf, 0x00, 0xe5, 0x68, 0x40, 0x39, 0x68, 0xa5, 0x00, 0x6c, 0x03, 0x6c,
		0x03, 0xff, 0x0a, 0xa0, 0x08, 0xa0, 0x08, 0xfc, 0x2b, 0x40, 0x1e, 0x68, 0xa5, 0x00, 0x0c, 0x02,
		0x0c, 0x02, 0xff, 0x0a, 0xfc, 0x2b, 0x00, 0x35, 0x00, 0x35, 0xf0, 0xaf, 0x00, 0xe5, 0x48, 0xae,
		0x28, 0x48, 0x2b, 0x05, 0x89, 0x9e, 0x00, 0x86, 0x74, 0x23, 0x85, 0x8b, 0xc1, 0xc3, 0x72, 0xd0,
		0x46, 0x21, 0xf0, 0x5a, 0xfc, 0x87, 0xe5, 0xb3, 0x61, 0xde, 0xa6, 0xdf, 0xeb, 0x72, 0xf9, 0xa6,
		0x0a, 0x73, 0xf6, 0x42, 0x8b, 0x05, 0x7d, 0xe8, 0x12, 0x2d, 0x16, 0xd0, 0x62, 0x01, 0xa6, 0x19,
		0x4c, 0xb3, 0xcd, 0x30, 0xcd, 0xe0, 0x1e, 0x86, 0x25, 0x05, 0xf7, 0x30, 0x0c, 0xa7, 0x82, 0x1b,
		0x4e, 0x68, 0xb1, 0x00, 0x04, 0x02, 0x04, 0x02, 0x04, 0x02, 0x04, 0x02, 0x04, 0x02, 0x04, 0x02,
		0x04, 0x52, 0x10, 0x04, 0x82, 0x16, 0x0b, 0xc0, 0x20, 0xc0, 0x20, 0x68, 0xb1, 0x30, 0xb9, 0x05,
		0x42, 0xd4, 0x80, 0x35, 0xc5, 0x84, 0x35, 0x08, 0x51, 0x03, 0xe7, 0xcc, 0x3b, 0x64, 0xb4, 0x58,
		0x00, 0xba, 0x01, 0xba, 0x81, 0x87, 0x05, 0x50, 0x04, 0x50, 0x04, 0x1e, 0x16, 0x20, 0x0f, 0x03,
		0x2d, 0x16, 0x80, 0x41, 0x80, 0x41, 0x36, 0x0a, 0x83, 0xa0, 0x04, 0x00, 0xa0, 0x06, 0xa0, 0x06,
		0xfe, 0x15, 0xa0, 0x1c, 0x0d, 0x28, 0x07, 0x2d, 0x16, 0x80, 0x6d, 0x80, 0x6d, 0xe0, 0x5f, 0x01,
		0x14, 0x01, 0x14, 0x81, 0x7f, 0x05, 0xc8, 0x03, 0x2d, 0x16, 0x80, 0x41, 0x80, 0x41, 0xe0, 0x5f,
		0x81, 0x7f, 0x05, 0xa0, 0x06, 0xa0, 0x06, 0xfe, 0x15, 0xa0, 0x1c, 0xc9, 0x15, 0x05, 0x69, 0xb1,
		0xa0, 0xdc, 0x21, 0xc0, 0x90, 0x6e, 0xb8, 0x70, 0x13, 0x3d, 0xfa, 0x2c, 0x7e, 0x72, 0x0e, 0xba,
		0x2f, 0x70, 0x8f, 0x4b, 0x64, 0x55, 0x8f, 0x75, 0x69, 0xb8, 0x1c, 0x3d, 0x16, 0xf4, 0xc1, 0x4b,
		0xf4, 0x58, 0x40, 0x8f, 0x05, 0xd8, 0x66, 0xb0, 0xcd, 0x36, 0xc3, 0x36, 0x83, 0x7f, 0x18, 0xa6,
		0x14, 0xfc, 0xc3, 0xb0, 0x9c, 0x0a, 0x6e, 0x39, 0xa1, 0xc7, 0x02, 0x10, 0x08, 0x10, 0x08, 0x10,
		0x08, 0x10, 0x08, 0x10, 0x08, 0x10, 0x08, 0x10, 0x48, 0x41, 0x10, 0x08, 0x7a, 0x2c, 0x00, 0x83,
		0x00, 0x83, 0xa0, 0xc7, 0xc2, 0xe4, 0x16, 0x88, 0x51, 0x03, 0xd6, 0x14, 0x13, 0xd6, 0x20, 0x46,
		0x0d, 0x9c, 0x33, 0xef, 0x90, 0xd1, 0x63, 0x01, 0xe8, 0x06, 0xe8, 0x06, 0x1e, 0x16, 0x40, 0x11,
		0x40, 0x11, 0x78, 0x58, 0x80, 0x3c, 0x0c, 0xf4, 0x58, 0x00, 0x06, 0x01, 0x06, 0xd9, 0x28, 0x0c,
		0x82, 0x1a, 0x00, 0x80, 0x1a, 0x80, 0x1a, 0xf8, 0x57, 0x80, 0x72, 0x34, 0xa0, 0x1c, 0xf4, 0x58,
		0x00, 0xb6, 0x01, 0xb6, 0x81, 0x7f, 0x05, 0x50, 0x04, 0x50, 0x04, 0xfe, 0x15, 0x20, 0x0f, 0xf4,
		0x58, 0x00, 0x06, 0x01, 0x06, 0x81, 0x7f, 0x05, 0xfe, 0x15, 0x80, 0x1a, 0x80, 0x1a, 0xf8, 0x57,
		0x80, 0x72, 0x24, 0x57, 0x14, 0xa4, 0xc7, 0x82, 0x4c, 0x53, 0x00, 0x43, 0xba, 0xad, 0xc2, 0x6d,
		0xf8, 0xb4, 0x1c, 0xb4, 0x52, 0xe8, 0x05, 0xcc, 0x97, 0xef, 0xa4, 0x10, 0xae, 0x46, 0x23, 0x05,
		0x7d, 0x18, 0x12, 0x8d, 0x14, 0xd0, 0x48, 0x01, 0x06, 0x18, 0x0c, 0xb0, 0xcd, 0x30, 0xc0, 0xe0,
		0x04, 0x86, 0xbd, 0x04, 0x27, 0x30, 0xcc, 0xa3, 0x82, 0x9b, 0x47, 0x68, 0xa4, 0x00, 0x04, 0x02,
		0x04, 0x02, 0x04, 0x02, 0x04, 0x02, 0x04, 0x02, 0x04, 0x02, 0x04, 0x52, 0x10, 0x04, 0x82, 0x46,
		0x0a, 0xc0, 0x20, 0xc0, 0x20, 0x68, 0xa4, 0x30, 0xb9, 0x05, 0x02, 0xd1, 0x80, 0x35, 0xc5, 0x84,
		0x35, 0x08, 0x44, 0x03, 0xe7, 0xcc, 0x3b, 0x64, 0x34, 0x52, 0x00, 0xba, 0x01, 0xba, 0x81, 0x87,
		0x05, 0x50, 0x04, 0x50, 0x04, 0x1e, 0x16, 0x20, 0x0f, 0x03, 0x8d, 0x14, 0x80, 0x41, 0x80, 0x41,
		0x36, 0x0a, 0x83, 0x20, 0xd1, 0x1f, 0xa0, 0x06, 0xa0, 0x06, 0xfe, 0x15, 0xa0, 0x1c, 0x0d, 0x28,
		0x07, 0x8d, 0x14, 0x80, 0x6d, 0x80, 0x6d, 0xe0, 0x5f, 0x01, 0x14, 0x01, 0x14, 0x81, 0x7f, 0x05,
		0xc8, 0x03, 0x8d, 0x14, 0x80, 0x41, 0x80, 0x41, 0xe0, 0x5f, 0x81, 0x7f, 0x05, 0xa0, 0x06, 0xa0,
		0x06, 0xfe, 0x15, 0xa0, 0x1c, 0xc9, 0x15, 0x05, 0x69, 0xa4, 0x20, 0xd1, 0x13, 0xc0, 0x90, 0xee,
		0xa3, 0xf0, 0x75, 0xf0, 0xb0, 0x1c, 0xb4, 0x51, 0xf8, 0x61, 0x39, 0x5c, 0xbe, 0x8d, 0x42, 0xb8,
		0x1a, 0x6d, 0x14, 0xf4, 0x21, 0x48, 0xb4, 0x51, 0x40, 0x1b, 0x05, 0x98, 0x5f, 0x30, 0xbf, 0x36,
		0xc3, 0xfc, 0x82, 0x0b, 0x18, 0xd6, 0x12, 0x5c, 0xc0, 0x30, 0x8e, 0x0a, 0x6e, 0x1c, 0xa1, 0x8d,
		0x02, 0x10, 0x08, 0x10, 0x08, 0x10, 0x08, 0x10, 0x08, 0x10, 0x08, 0x10, 0x08, 0x10, 0x48, 0x41,
		0x10, 0x08, 0xda, 0x28, 0x00, 0x83, 0x00, 0x83, 0xa0, 0x8d, 0xc2, 0xe4, 0x16, 0x08, 0x43, 0x03,
		0xd6, 0x14, 0x13, 0xd6, 0x20, 0x0c, 0x0d, 0x9c, 0x33, 0xef, 0x90, 0xd1, 0x46, 0x01, 0xe8, 0x06,
		0xe8, 0x06, 0x1e, 0x16, 0x40, 0x11, 0x40, 0x11, 0x78, 0x58, 0x80, 0x3c, 0x0c, 0xb4, 0x51, 0x00,
		0x06, 0x01, 0x06, 0xd9, 0x28, 0x0c, 0x82, 0x34, 0x7f, 0x80, 0x1a, 0x80, 0x1a, 0xf8, 0x57, 0x80,
		0x72, 0x34, 0xa0, 0x1c, 0xb4, 0x51, 0x00, 0xb6, 0x01, 0xb6, 0x81, 0x7f, 0x05, 0x50, 0x04, 0x50,
		0x04, 0xfe, 0x15, 0x20, 0x0f, 0xb4, 0x51, 0x00, 0x06, 0x01, 0x06, 0x81, 0x7f, 0x05, 0xfe, 0x15,
		0x80, 0x1a, 0x80, 0x1a, 0xf8, 0x57, 0x80, 0x72, 0x24, 0x57, 0x14, 0xa4, 0x8d, 0x82, 0x44, 0x4f,
		0x00, 0x43, 0xba, 0x8d, 0xc2, 0xbf, 0x06, 0x0f, 0xd3, 0xd5, 0x46, 0xe1, 0x1d, 0xe1, 0xad, 0xc8,
		0xde, 0x86, 0xe4, 0x2d, 0x08, 0x5c, 0x80, 0xd4, 0xc1, 0xa7, 0x3b, 0xf3, 0xe5, 0x27, 0xb8, 0xf8,
		0x13, 0x4b, 0xce, 0x76, 0x80, 0x07, 0x87, 0x09, 0xe7, 0x4d, 0xb6, 0x0c, 0x0a, 0x96, 0xbe, 0x38,
		0x01, 0xaf, 0x71, 0x9e, 0xae, 0x33, 0xc0, 0x40, 0xbd, 0xd6, 0xdb, 0x6c, 0x80, 0xe4, 0x52, 0x0a,
		0xc8, 0x81, 0x16, 0x98, 0x58, 0x21, 0x27, 0xbe, 0x4b, 0x97, 0x7e, 0x93, 0xf9, 0xac, 0xf9, 0x69,
		0xf0, 0x5a, 0x6e, 0xaf, 0xdd, 0x56, 0x3a, 0x1d, 0x41, 0x8a, 0x13, 0xa6, 0xb4, 0x14, 0x34, 0x26,
		0x48, 0x5b, 0x8b, 0xa9, 0x2a, 0x99, 0x56, 0xe6, 0xff, 0x4b, 0xc2, 0xf9, 0xa4, 0x3d, 0x17, 0xa1,
		0xf3, 0x58, 0x70, 0x16, 0x02, 0x67, 0x30, 0xff, 0xfd, 0x67, 0xdf, 0x6e, 0xce, 0x9b, 0x95, 0x9a,
		0x6e, 0x90, 0xf8, 0x3a, 0x31, 0x30, 0x1f, 0x7c, 0x28, 0xe1, 0x54, 0x16, 0xb7, 0x65, 0x59, 0x6a,
		0x93, 0xa6, 0xb1, 0x39, 0xd3, 0xb7, 0x53, 0x49, 0x6b, 0x31, 0x0a, 0x5b, 0x84, 0xc2, 0x16, 0x9f,
		0x50, 0xbb, 0x13, 0x31, 0x3a, 0x5c, 0xd6, 0xa6, 0xa4, 0x64, 0x8f, 0xce, 0x7c, 0xc9, 0x21, 0x8c,
		0x8e, 0x35, 0xfa, 0xfc, 0x32, 0xa1, 0x99, 0xaa, 0xff, 0x4e, 0x6a, 0x27, 0x84, 0x88, 0xb3, 0x41,
		0xbc, 0x9f, 0x8e, 0xa8, 0xeb, 0x40, 0xda, 0x45, 0x20, 0xed, 0x0a, 0x90, 0xea, 0x87, 0xa3, 0xa6,
		0xf6, 0xd2, 0xf6, 0xb7, 0x29, 0x05, 0xcc, 0xf2, 0xed, 0xa7, 0xf4, 0x87, 0x17, 0x57, 0xa0, 0x0c,
		0xd7, 0xa5, 0x3c, 0x00, 0x31, 0x6f, 0x97, 0xb0, 0x77, 0x4b, 0xc6, 0x9b, 0x25, 0xdf, 0xb8, 0x49,
		0xd6, 0x57, 0xa5, 0xec, 0x9b, 0x52, 0xf6, 0x45, 0x29, 0x35, 0x66, 0xa2, 0xc5, 0xba, 0xc2, 0x9e,
		0xa4, 0xb1, 0x82, 0xf2, 0x3a, 0x96, 0xe3, 0x9a, 0xa1, 0xb2, 0x14, 0xb8, 0xb4, 0x91, 0x4c, 0x13,
		0x70, 0x15, 0x95, 0xbe, 0x30, 0xf7, 0x31, 0x54, 0xed, 0x62, 0xbe, 0x1c, 0x09, 0x43, 0x4a, 0xc5,
		0x57, 0x33, 0x76, 0x08, 0x48, 0x7a, 0xf5, 0xa8, 0xac, 0x7d, 0x75, 0xeb, 0x5e, 0xc6, 0xa7, 0xaf,
		0xe2, 0x5b, 0x89, 0x8f, 0xae, 0x52, 0xdd, 0x2f, 0xfe, 0xe1, 0x69, 0x32, 0x72, 0x1b, 0x02, 0x1c,
		0x73, 0x65, 0x71, 0xce, 0x7c, 0x57, 0x98, 0x65, 0x4a, 0x5b, 0x5b, 0x5b, 0x5b, 0xdf, 0x2c, 0xf3,
		0x7f, 0x35, 0xf3, 0x3f, 0x7b, 0xe6, 0xf1, 0x7d, 0x63, 0xe2, 0x2f, 0x77, 0x77, 0xe6, 0x7d, 0x63,
		0xfb, 0xd7, 0xde, 0xce, 0x61, 0xb9, 0xbf, 0xfd, 0xdb, 0xf8, 0xf7, 0x8d, 0xbb, 0xbb, 0xf7, 0xdb,
		0xff, 0x94, 0x59, 0xf5, 0xdb, 0xf6, 0xeb, 0x60, 0x6d, 0x49, 0xcf, 0x11, 0x5c, 0xde, 0x9c, 0xfd,
		0x5b, 0xfa, 0x1c, 0xfe, 0xbb, 0x8a, 0x83, 0xf8, 0x87, 0xc0, 0x49, 0x90, 0x6a, 0x01, 0x21, 0x8b,
		0x5b, 0xde, 0xf2, 0x26, 0xb5, 0xc0, 0xe7, 0x5a, 0xe2, 0x92, 0xcd, 0x31, 0x25, 0xfa, 0x89, 0xaa,
		0x44, 0xca, 0x26, 0x11, 0x88, 0x37, 0xfc, 0xf6, 0xe6, 0xc3, 0x8b, 0x8c, 0x27, 0x8e, 0x22, 0x2a,
		0x36, 0x85, 0x46, 0x7a, 0x3a, 0x9b, 0x9d, 0xe6, 0xc2, 0x13, 0xa5, 0xcb, 0xd7, 0xd2, 0x74, 0x83,
		0xdd, 0x54, 0x66, 0x9d, 0x80, 0xa7, 0xe1, 0xd4, 0x0d, 0xee, 0x23, 0x10, 0x2e, 0xeb, 0x6f, 0x59,
		0x60, 0xb9, 0x3f, 0x79, 0x01, 0x37, 0x99, 0xcb, 0x7d, 0x87, 0x05, 0xe9, 0x4d, 0xd7, 0xa9, 0x55,
		0x30, 0x60, 0x61, 0xc0, 0xbe, 0x21, 0xa6, 0x17, 0x71, 0x23, 0x76, 0x62, 0xad, 0x98, 0x21, 0x5b,
		0x86, 0x21, 0x0b, 0x43, 0x56, 0x8c, 0x50, 0x45, 0x5d, 0x76, 0x6a, 0x2e, 0x3c, 0x45, 0xc2, 0x95,
		0x26, 0x60, 0x15, 0x42, 0x56, 0x27, 0x68, 0x0a, 0x8c, 0x64, 0xa0, 0xa5, 0xb6, 0x94, 0x2d, 0xae,
		0xd0, 0x52, 0xbb, 0xed, 0x58, 0x01, 0x41, 0x53, 0xed, 0x70, 0x1b, 0xa4, 0xe3, 0xc9, 0xb3, 0x0d,
		0x15, 0xfb, 0x90, 0xb3, 0x11, 0x39, 0x3b, 0x91, 0xb2, 0x95, 0x1c, 0x7b, 0x29, 0xb8, 0xbc, 0x0c,
		0xea, 0x66, 0x52, 0xbe, 0xe3, 0x3e, 0x12, 0x64, 0xe1, 0x95, 0x3f, 0x64, 0x7a, 0x02, 0x52, 0xce,
		0x03, 0x3a, 0x67, 0x82, 0x56, 0xe7, 0xc2, 0x42, 0x67, 0xc3, 0xd2, 0xb0, 0x3f, 0x1d, 0x85, 0xca,
		0x38, 0x64, 0x07, 0xa8, 0x3a, 0x32, 0x30, 0x15, 0x45, 0x7a, 0xbc, 0x13, 0xa4, 0x3a, 0xa4, 0x3a,
		0xa4, 0x7a, 0xb1, 0xa4, 0x7a, 0x36, 0x2d, 0x49, 0xbb, 0xcf, 0x07, 0xa6, 0xd5, 0x6c, 0xfa, 0x2c,
		0x20, 0x80, 0x90, 0x53, 0xbb, 0x41, 0xe6, 0x40, 0xe6, 0x40, 0xe6, 0x64, 0xcd, 0x3f, 0x86, 0x64,
		0xac, 0x7e, 0x96, 0x0f, 0x24, 0x23, 0x70, 0x33, 0x1b, 0x6d, 0x7d, 0xdb, 0x33, 0x8f, 0x1b, 0xaf,
		0xdf, 0xca, 0xe6, 0x71, 0x63, 0xf8, 0x63, 0x39, 0xfc, 0xe3, 0x57, 0xa5, 0xff, 0x5a, 0xf9, 0xb6,
		0x67, 0x1e, 0x44, 0xbf, 0xad, 0x54, 0xbf, 0xed, 0x99, 0xd5, 0xc6, 0xf6, 0xd6, 0xdd, 0xdd, 0x7b,
		0xd1, 0x35, 0xdb, 0xbf, 0xf6, 0xfb, 0xf2, 0xe4, 0xd2, 0x50, 0x39, 0x26, 0x95, 0x68, 0xe5, 0xcc,
		0x6e, 0xff, 0xdd, 0xca, 0xea, 0xb4, 0x44, 0x62, 0x96, 0x33, 0xe7, 0x05, 0x33, 0x05, 0x66, 0xca,
		0x40, 0x58, 0x1d, 0x92, 0x42, 0x87, 0x43, 0x40, 0x07, 0x40, 0x07, 0x40, 0x87, 0x95, 0xf1, 0x4f,
		0x0e, 0xa1, 0x43, 0xa8, 0xd9, 0x2c, 0xb3, 0x55, 0x33, 0x3f, 0x37, 0x7e, 0x95, 0x77, 0x0e, 0xfa,
		0x1f, 0xb7, 0x7f, 0x1d, 0xf5, 0xdf, 0xfe, 0xf2, 0x75, 0xde, 0xc7, 0xca, 0x3b, 0x47, 0xfd, 0x8f,
		0x09, 0xff, 0x72, 0xd8, 0xff, 0x98, 0x72, 0x8f, 0x6a, 0x7f, 0x6b, 0xe6, 0xa3, 0x83, 0xdf, 0x57,
		0x92, 0x16, 0x1c, 0x24, 0x2c, 0xd8, 0x4f, 0x5a, 0xb0, 0x9f, 0xb0, 0x20, 0xf1, 0x2b, 0x55, 0x12,
		0x16, 0x54, 0xfb, 0xaf, 0x33, 0x9f, 0xdf, 0x9a, 0xff, 0xd1, 0xc3, 0xfe, 0xf6, 0x6b, 0xd2, 0xbf,
		0x1d, 0xf5, 0x5f, 0x3f, 0x6e, 0x6f, 0xaf, 0x11, 0x98, 0x02, 0xf9, 0x64, 0x4f, 0x3e, 0x00, 0x97,
		0x00, 0x97, 0x92, 0x2b, 0xf2, 0x5a, 0x82, 0xdb, 0x74, 0x83, 0xdd, 0xc9, 0x14, 0xaa, 0xf1, 0x5f,
		0x5e, 0x76, 0xa5, 0x52, 0x0a, 0x0c, 0xb1, 0x74, 0xb2, 0x3f, 0xbc, 0x80, 0xd7, 0x87, 0x8f, 0x8e,
		0x7f, 0x7e, 0x49, 0x95, 0x64, 0x26, 0x7f, 0x1f, 0x22, 0x53, 0xce, 0xa5, 0xa3, 0x16, 0xaa, 0xd1,
		0x0a, 0x49, 0xd8, 0x8f, 0xd4, 0x0c, 0xa4, 0x66, 0x68, 0x87, 0xe9, 0xf1, 0x7d, 0xb7, 0x99, 0xd5,
		0xf2, 0x59, 0x4b, 0xe6, 0xc2, 0x47, 0x88, 0xfc, 0x48, 0x62, 0xed, 0x55, 0x24, 0xd6, 0xde, 0xbf,
		0x8f, 0x64, 0xd4, 0x6e, 0xcc, 0x64, 0x39, 0x10, 0x19, 0xc3, 0x32, 0x7a, 0x69, 0x79, 0x21, 0x5a,
		0x85, 0x6f, 0x50, 0xe4, 0x71, 0x55, 0x20, 0x2c, 0x20, 0x2c, 0x16, 0x7e, 0x43, 0xe4, 0x71, 0xc1,
		0x85, 0x06, 0x17, 0x5a, 0x01, 0x5d, 0x68, 0xc8, 0xe3, 0x82, 0x0d, 0x4b, 0x78, 0x37, 0xc8, 0xe3,
		0x82, 0x54, 0x87, 0x54, 0x87, 0x54, 0x47, 0x1e, 0x17, 0x64, 0x0e, 0x64, 0xce, 0x46, 0xc9, 0x1c,
		0xe4, 0x71, 0x21, 0x8f, 0x0b, 0x79, 0x5c, 0x30, 0x53, 0x90, 0xc7, 0x05, 0xe8, 0x00, 0xe8, 0x00,
		0xe8, 0x90, 0x2d, 0xff, 0x18, 0xc8, 0xe3, 0x42, 0x22, 0x0e, 0xf2, 0xb8, 0x40, 0x3e, 0xc8, 0xe3,
		0x02, 0xb8, 0xa4, 0x04, 0x97, 0x6b, 0x9f, 0xc7, 0x25, 0x93, 0x51, 0x60, 0x50, 0xa4, 0x71, 0x09,
		0x34, 0xfc, 0x17, 0xbf, 0x0d, 0xda, 0x7e, 0x3d, 0xd1, 0x40, 0x00, 0xc1, 0x90, 0xc4, 0xfa, 0x74,
		0x2a, 0x4c, 0xcd, 0x70, 0x79, 0x99, 0x5a, 0xb1, 0x80, 0xe0, 0xe9, 0x47, 0x58, 0x24, 0x92, 0x78,
		0x69, 0xed, 0x7b, 0x08, 0x0a, 0xf4, 0xd7, 0x93, 0x3f, 0x50, 0x1d, 0xed, 0x04, 0x03, 0xe6, 0x3f,
		0x33, 0x5f, 0xa0, 0x93, 0xe0, 0x68, 0x01, 0x9a, 0x08, 0xa2, 0x89, 0xe0, 0x24, 0x09, 0xc9, 0x74,
		0xc1, 0x0f, 0xd7, 0xa1, 0x79, 0x60, 0x86, 0x7e, 0x9c, 0x8d, 0x6e, 0x1e, 0x28, 0xeb, 0xe7, 0x1c,
		0x67, 0xd7, 0x49, 0xb9, 0x66, 0x90, 0xa3, 0xbe, 0x12, 0x57, 0x25, 0x72, 0xd4, 0x45, 0xee, 0x3b,
		0x37, 0x39, 0xea, 0x23, 0x1e, 0xcb, 0x41, 0x8a, 0x3a, 0x9a, 0x8d, 0x42, 0x5a, 0xac, 0xa3, 0xb4,
		0x90, 0x4f, 0x52, 0xa7, 0x0a, 0x14, 0x22, 0x46, 0x88, 0x18, 0xe1, 0x8a, 0x58, 0x4b, 0xde, 0x05,
		0x6a, 0xe4, 0x24, 0x46, 0x48, 0x19, 0x21, 0x3c, 0x56, 0xd8, 0x23, 0x7a, 0xa7, 0x95, 0x8f, 0xea,
		0x26, 0x4e, 0xbc, 0x9a, 0x39, 0xa3, 0x0f, 0x04, 0x7b, 0x51, 0xc5, 0xc3, 0xe2, 0x0d, 0xf3, 0x9f,
		0x90, 0x35, 0xfa, 0xaf, 0x41, 0x71, 0x7c, 0x94, 0x31, 0xc5, 0x78, 0xd7, 0x62, 0x24, 0x6a, 0xc5,
		0xe7, 0xa8, 0x36, 0xac, 0x7b, 0x27, 0x47, 0x6c, 0x7a, 0xb8, 0x39, 0x6c, 0x8a, 0xe8, 0x75, 0xe1,
		0x92, 0x1f, 0x0a, 0x23, 0xb8, 0x40, 0x56, 0x85, 0x4a, 0x8a, 0x20, 0x12, 0xe4, 0x59, 0x27, 0x65,
		0x64, 0x92, 0x87, 0xda, 0xf5, 0x7c, 0xae, 0x6e, 0x56, 0x86, 0xbb, 0x48, 0x22, 0xf4, 0x53, 0xd6,
		0xb2, 0x7a, 0x6d, 0xae, 0xc4, 0xa4, 0xa5, 0xea, 0xbe, 0x1c, 0x79, 0x34, 0x60, 0x08, 0xc3, 0x10,
		0x86, 0x21, 0x2c, 0xcc, 0xec, 0xa6, 0xdb, 0xeb, 0x3c, 0x08, 0x4f, 0x81, 0x9c, 0xc7, 0x42, 0x87,
		0x0a, 0x5b, 0x5c, 0x5b, 0xee, 0x63, 0x2e, 0x2c, 0x61, 0x95, 0x41, 0xc8, 0x33, 0x9b, 0x8d, 0xa6,
		0xfb, 0xee, 0xed, 0xd0, 0xec, 0x47, 0x35, 0xeb, 0x77, 0x96, 0x20, 0x54, 0x67, 0xff, 0x12, 0xdb,
		0x4a, 0x86, 0xea, 0x60, 0xe5, 0xc4, 0xab, 0x38, 0xac, 0x56, 0xf7, 0xab, 0x9b, 0x77, 0x1d, 0xeb,
		0x8e, 0x97, 0xd6, 0x26, 0xb5, 0x32, 0xca, 0x0d, 0x8a, 0xfe, 0xcc, 0xa4, 0x33, 0xde, 0xcd, 0xf0,
		0x91, 0xd1, 0x9f, 0x39, 0x6a, 0x89, 0x87, 0xfe, 0x56, 0x9a, 0x61, 0x1f, 0x42, 0x87, 0x2b, 0x90,
		0x26, 0x08, 0x1d, 0xc2, 0x62, 0x82, 0xc5, 0x84, 0xd0, 0x21, 0x42, 0x87, 0xa9, 0xce, 0x08, 0xa1,
		0x43, 0x35, 0x4f, 0x29, 0x42, 0x87, 0x08, 0x1d, 0x22, 0x74, 0x88, 0x18, 0x0f, 0x42, 0x87, 0x08,
		0x1d, 0x22, 0x74, 0x88, 0xd0, 0xe1, 0x3c, 0x8a, 0x46, 0xe8, 0x10, 0x86, 0x30, 0x0c, 0x61, 0x18,
		0xc2, 0x82, 0xcc, 0x8e, 0xd0, 0xe1, 0xd4, 0x17, 0x41, 0xe8, 0x10, 0xa1, 0xc3, 0x35, 0xbc, 0x0e,
		0x84, 0x0e, 0xe5, 0x89, 0x73, 0x95, 0xa1, 0xc3, 0x0c, 0x9a, 0xb1, 0xbc, 0x89, 0x1c, 0x16, 0xaf,
		0x0b, 0x8b, 0x98, 0x23, 0x64, 0x7d, 0x9a, 0xb0, 0x48, 0x46, 0x54, 0x7b, 0x81, 0xb0, 0xb6, 0x57,
		0x81, 0x85, 0x93, 0x50, 0xd0, 0x1b, 0x7e, 0x7b, 0xf3, 0xe1, 0x45, 0x86, 0xa4, 0x29, 0x20, 0xe0,
		0x14, 0xec, 0x0b, 0x4f, 0xa2, 0x10, 0x94, 0xce, 0x7e, 0x72, 0xdf, 0x32, 0x7b, 0x6e, 0xc0, 0xad,
		0x87, 0xb6, 0xd8, 0x3d, 0x4c, 0x1e, 0xba, 0x28, 0xbe, 0x52, 0x08, 0x67, 0x4b, 0x50, 0x99, 0x41,
		0x1c, 0xcc, 0x56, 0xa2, 0x36, 0x43, 0x5b, 0x40, 0x5b, 0x9c, 0xea, 0x24, 0x34, 0xdc, 0x3b, 0x5a,
		0x0d, 0x9d, 0xa7, 0x36, 0x4e, 0xd3, 0x1a, 0x52, 0x4f, 0xf7, 0xa6, 0x69, 0x9d, 0xb8, 0xfe, 0x6d,
		0x9b, 0xd2, 0x35, 0x33, 0x92, 0x3b, 0x44, 0x2d, 0xdd, 0x9a, 0x52, 0x25, 0x15, 0x09, 0x25, 0x11,
		0x09, 0x77, 0x6a, 0xaa, 0xa0, 0x53, 0x13, 0xb9, 0x83, 0x25, 0xb3, 0x4e, 0x4d, 0x96, 0x6f, 0x3f,
		0xc9, 0x74, 0x6a, 0x0a, 0xd7, 0x89, 0x75, 0x6a, 0xda, 0x43, 0xa7, 0x26, 0x74, 0x6a, 0x92, 0xf4,
		0xdc, 0xc5, 0xf7, 0xd5, 0xf4, 0x3a, 0x96, 0xe3, 0x9a, 0x82, 0xf3, 0xaf, 0x64, 0x02, 0xbb, 0xa5,
		0x2f, 0xcc, 0x7d, 0x0c, 0x75, 0x86, 0x76, 0xac, 0xa8, 0xe2, 0x6b, 0x8b, 0x1d, 0x3a, 0x65, 0x49,
		0x48, 0x46, 0xe5, 0xbc, 0x51, 0x77, 0xd6, 0xc8, 0x04, 0x7b, 0x54, 0x7c, 0x63, 0xf1, 0xd1, 0x55,
		0xaa, 0xfb, 0xc5, 0x3f, 0x3c, 0x5d, 0xb8, 0x58, 0x80, 0x63, 0x64, 0x83, 0xd3, 0xa5, 0xad, 0xad,
		0xad, 0xad, 0x6f, 0x96, 0xf9, 0xbf, 0x9a, 0xf9, 0x9f, 0x3d, 0xf3, 0xf8, 0xbe, 0x31, 0xf1, 0x97,
		0xbb, 0x3b, 0xf3, 0xbe, 0xb1, 0xfd, 0x6b, 0x6f, 0xe7, 0xb0, 0xdc, 0xdf, 0xfe, 0x6d, 0xfc, 0xfb,
		0xc6, 0xdd, 0xdd, 0xfb, 0xed, 0x7f, 0xca, 0xac, 0xfa, 0x6d, 0xfb, 0x75, 0xb0, 0xb6, 0xa4, 0xe7,
		0x08, 0x54, 0x82, 0xf4, 0xa5, 0xff, 0xae, 0xe2, 0x20, 0x04, 0xc2, 0xd0, 0xb4, 0x46, 0x12, 0x1c,
		0x50, 0x70, 0x40, 0xe5, 0xc6, 0x01, 0x55, 0x64, 0xa3, 0x35, 0xa5, 0x6f, 0x5c, 0xc4, 0x64, 0x5d,
		0xee, 0xfc, 0x5e, 0x60, 0xb0, 0xbe, 0x13, 0x38, 0xa1, 0xb4, 0x27, 0x23, 0x72, 0x22, 0xa5, 0x85,
		0x16, 0x73, 0xca, 0x33, 0x98, 0xff, 0xf6, 0xb3, 0xef, 0x36, 0xe7, 0xbd, 0x4a, 0x6d, 0xc7, 0x66,
		0x6e, 0x90, 0xcc, 0xa6, 0xe3, 0x2e, 0x8b, 0xd1, 0x07, 0x13, 0xce, 0x66, 0xb1, 0x29, 0xbe, 0xd4,
		0x52, 0x4a, 0x63, 0x19, 0x4d, 0x5a, 0x42, 0x8b, 0xbf, 0x8d, 0x88, 0xfc, 0x11, 0xb6, 0x76, 0x84,
		0x65, 0xca, 0x5b, 0x6b, 0x66, 0xf4, 0xdd, 0x89, 0xa8, 0x72, 0x99, 0x09, 0x3d, 0xba, 0x39, 0x81,
		0x46, 0xd9, 0xf1, 0x8a, 0x62, 0x74, 0xca, 0x5e, 0x4e, 0x0c, 0xc5, 0xf5, 0xc1, 0x2c, 0x25, 0x96,
		0x8c, 0xfd, 0x30, 0xcb, 0xe4, 0x85, 0xa4, 0xfc, 0x90, 0x24, 0xad, 0x95, 0x79, 0x62, 0xc4, 0xde,
		0x66, 0xbd, 0xbc, 0x31, 0xa9, 0x49, 0x52, 0x8f, 0x47, 0x46, 0xb8, 0x77, 0x36, 0x7a, 0xe1, 0x6a,
		0x25, 0x6c, 0x0a, 0xc0, 0x6f, 0x14, 0xa2, 0xa8, 0x55, 0x98, 0xf0, 0x25, 0x3d, 0x1e, 0x99, 0x15,
		0xb6, 0xda, 0x91, 0x1f, 0x47, 0xb5, 0xae, 0x75, 0xb8, 0xcf, 0x2a, 0x53, 0x90, 0x43, 0x4f, 0x14,
		0xb2, 0x90, 0x57, 0xc2, 0xf8, 0x54, 0x02, 0x80, 0x5c, 0x10, 0x90, 0x0b, 0x04, 0x72, 0xc1, 0x20,
		0x27, 0x20, 0x14, 0xbc, 0xd0, 0x06, 0x6d, 0x36, 0xf2, 0x83, 0xe7, 0xb5, 0x99, 0xe5, 0x52, 0xd4,
		0xe4, 0x96, 0x73, 0x5c, 0xa7, 0x11, 0xdd, 0xaf, 0xd9, 0xb4, 0xb8, 0xa5, 0x2e, 0x2e, 0xa7, 0x76,
		0x83, 0xf0, 0x81, 0xf0, 0x81, 0xf0, 0x91, 0x73, 0x4a, 0xbb, 0x8e, 0xe7, 0xa2, 0x1d, 0xc0, 0x1b,
		0x89, 0xec, 0xb8, 0x96, 0xff, 0x42, 0x58, 0x61, 0x7c, 0xbc, 0x26, 0x05, 0xd8, 0x01, 0xf7, 0x1d,
		0xf7, 0x91, 0xb4, 0xf4, 0x1a, 0x15, 0x8d, 0x89, 0x9a, 0xd2, 0x69, 0xd2, 0xe9, 0x49, 0xa7, 0x09,
		0x2d, 0x09, 0x2d, 0x09, 0x2d, 0xb9, 0x22, 0xb9, 0xa7, 0x28, 0xef, 0x36, 0xb5, 0x32, 0x28, 0x22,
		0xb8, 0xd1, 0x9f, 0x41, 0xfc, 0x0b, 0xdd, 0xad, 0x05, 0xbf, 0x0c, 0x9f, 0x33, 0xfa, 0x33, 0x88,
		0x7f, 0x91, 0x9f, 0x06, 0x83, 0x0a, 0x5a, 0x42, 0x5d, 0x3b, 0x14, 0x75, 0xa6, 0x21, 0x3c, 0xb3,
		0x1a, 0xa4, 0x3b, 0x66, 0x1b, 0xce, 0x27, 0xd9, 0x99, 0xd9, 0x86, 0x13, 0xec, 0x86, 0x0e, 0xa5,
		0x52, 0x62, 0xa3, 0x02, 0xb1, 0x01, 0xb1, 0x91, 0xea, 0x5b, 0x22, 0xa0, 0x83, 0x80, 0x0e, 0xac,
		0x45, 0x58, 0x8b, 0x2b, 0xb0, 0x16, 0x37, 0x24, 0xa0, 0xd3, 0x64, 0x81, 0xed, 0x3b, 0x5d, 0x69,
		0x2b, 0x70, 0xea, 0xcc, 0x26, 0x37, 0x83, 0xe8, 0x81, 0xe8, 0x81, 0xe8, 0xd9, 0x14, 0x47, 0x95,
		0x84, 0xe4, 0x61, 0x3f, 0xbb, 0x8e, 0x1f, 0xba, 0x9f, 0xcc, 0xa6, 0x8c, 0x0d, 0x33, 0x73, 0x6c,
		0x6f, 0x37, 0x84, 0x04, 0x82, 0x04, 0x82, 0x04, 0x92, 0xa2, 0x9b, 0x9e, 0xe3, 0xf2, 0xc3, 0x03,
		0x02, 0x09, 0xf4, 0x01, 0x6d, 0xf5, 0xde, 0x6c, 0x86, 0xb6, 0x7a, 0x4a, 0x57, 0xa1, 0xa3, 0xad,
		0x9e, 0x5a, 0x55, 0xe1, 0xba, 0xdc, 0x0e, 0x62, 0xf8, 0xf3, 0x21, 0x0a, 0x6b, 0x12, 0x41, 0x13,
		0x86, 0xe8, 0x3d, 0x20, 0x09, 0x20, 0x09, 0xfc, 0x31, 0x8b, 0xbe, 0xa3, 0xe3, 0x9a, 0xbd, 0x80,
		0xc0, 0x18, 0x8a, 0xf6, 0x81, 0xc0, 0x81, 0xc0, 0x81, 0xc0, 0x81, 0xc0, 0x59, 0x20, 0x70, 0x82,
		0xa0, 0xc7, 0x88, 0x3c, 0x30, 0x13, 0x7b, 0x41, 0xf0, 0x40, 0xf0, 0x40, 0xf0, 0xc0, 0xf9, 0x02,
		0xe7, 0x0b, 0x9c, 0x2f, 0x70, 0xbe, 0xc0, 0xf9, 0x82, 0x52, 0x43, 0x80, 0x13, 0x80, 0x93, 0x35,
		0x00, 0x27, 0x28, 0x35, 0x9c, 0x63, 0x2a, 0xa2, 0xd4, 0x70, 0xfe, 0xc1, 0xa0, 0xd4, 0x30, 0x4b,
		0x4d, 0x89, 0x52, 0x43, 0x68, 0x49, 0x68, 0x49, 0x64, 0x70, 0x65, 0x25, 0x77, 0x9e, 0xad, 0x36,
		0x85, 0xc8, 0x19, 0x6e, 0x03, 0x69, 0x03, 0x69, 0x03, 0x69, 0x23, 0x07, 0x3f, 0x0b, 0x18, 0xa9,
		0x58, 0xef, 0xca, 0x66, 0xcd, 0x93, 0x0f, 0x13, 0x0b, 0x9b, 0x8b, 0x37, 0xff, 0x50, 0x18, 0x6f,
		0xae, 0x4f, 0x07, 0x7a, 0xb7, 0xd7, 0x6e, 0x17, 0x6a, 0x80, 0x59, 0x12, 0xb9, 0xd3, 0x8f, 0x31,
		0x4b, 0x22, 0xf0, 0xf5, 0x1e, 0x66, 0xf6, 0xf6, 0x7c, 0xe9, 0xda, 0xc3, 0xbf, 0x3d, 0xcf, 0x62,
		0x76, 0x89, 0x4f, 0xd1, 0xea, 0x5c, 0xe8, 0x38, 0x94, 0xba, 0xc5, 0x7b, 0x8f, 0x8f, 0x03, 0x88,
		0xbf, 0xbc, 0x5b, 0x7c, 0xf4, 0xc1, 0x9c, 0x74, 0x8b, 0xf7, 0x1e, 0x8b, 0xd9, 0x29, 0xde, 0x7b,
		0xcc, 0xac, 0x4b, 0xbc, 0xed, 0xb9, 0x81, 0xd7, 0x16, 0x98, 0xd0, 0x37, 0x5a, 0x50, 0x90, 0x1e,
		0xf1, 0xde, 0xe3, 0x7a, 0xf6, 0x87, 0xf7, 0x1e, 0x73, 0xd3, 0x1b, 0x5e, 0xb0, 0xd1, 0xb6, 0x5c,
		0x83, 0xed, 0xdc, 0x77, 0x86, 0xf7, 0x1e, 0x37, 0xb3, 0x2b, 0xbc, 0xf7, 0xb8, 0xaa, 0x8e, 0xf0,
		0xda, 0x11, 0xe0, 0x50, 0x99, 0xed, 0x46, 0x12, 0x4f, 0xbc, 0x83, 0x53, 0x5a, 0x05, 0x3d, 0x7c,
		0xce, 0xfd, 0xc9, 0xf0, 0x39, 0x42, 0x0d, 0x9b, 0x52, 0xa0, 0xbf, 0x34, 0xb8, 0x8a, 0xb5, 0x99,
		0xcd, 0x3d, 0x3f, 0x90, 0x19, 0xb4, 0x39, 0x5a, 0x0a, 0x3e, 0x06, 0x1f, 0x4b, 0xf1, 0xb1, 0xf0,
		0x64, 0x87, 0x11, 0xcd, 0x29, 0x74, 0x02, 0x1a, 0xed, 0xb0, 0x21, 0xd3, 0x1d, 0xbc, 0x47, 0x34,
		0x02, 0x52, 0x25, 0xfa, 0x6c, 0xbc, 0x79, 0xd2, 0x4d, 0x80, 0x24, 0xc7, 0x9d, 0xa8, 0xa1, 0x32,
		0x22, 0x06, 0xc9, 0x6f, 0x84, 0xc2, 0x7b, 0x44, 0x74, 0x22, 0x2b, 0xc6, 0x5a, 0x4d, 0x64, 0x42,
		0x96, 0xe1, 0xe2, 0x0d, 0x5a, 0x96, 0xed, 0xb4, 0x1d, 0xfe, 0xa2, 0x7e, 0xcd, 0x23, 0xc2, 0x8b,
		0x77, 0x54, 0xbc, 0x14, 0xb5, 0x70, 0x21, 0x19, 0x53, 0x52, 0x32, 0x27, 0x3d, 0x93, 0x52, 0x33,
		0xab, 0x36, 0xa6, 0xd5, 0xc6, 0xbc, 0x5a, 0x98, 0x58, 0x8d, 0x99, 0x15, 0x99, 0x3a, 0x7e, 0x23,
		0xe5, 0xb0, 0xe3, 0x0c, 0xbd, 0x39, 0x4d, 0xe6, 0x72, 0x87, 0xbf, 0xc8, 0x75, 0xe7, 0x4c, 0xd4,
		0x97, 0x04, 0x59, 0xe0, 0xa5, 0xb3, 0xe8, 0xab, 0x7d, 0xb2, 0x02, 0x42, 0x32, 0x1e, 0xbd, 0xf8,
		0xcd, 0xdf, 0x37, 0x5f, 0x2e, 0x7f, 0xbf, 0xff, 0x5c, 0x3b, 0x39, 0xfb, 0x72, 0x76, 0xfb, 0x37,
		0x15, 0x31, 0x87, 0x99, 0xf1, 0x81, 0x72, 0x7e, 0xe3, 0xe4, 0x7f, 0xbf, 0xc8, 0x76, 0x9a, 0x3a,
		0x80, 0x2f, 0x97, 0x27, 0xb5, 0x2f, 0xe5, 0x12, 0xd9, 0xe6, 0xfd, 0x9d, 0xbc, 0xbf, 0x71, 0xed,
		0xeb, 0xed, 0x1f, 0x57, 0xd7, 0x67, 0x7f, 0x6d, 0xd2, 0x3b, 0x87, 0xb7, 0x7c, 0xb0, 0x69, 0xb7,
		0xbc, 0x49, 0xef, 0x7b, 0x71, 0x7b, 0xb5, 0x59, 0xd7, 0x7b, 0x7a, 0x76, 0xbb, 0x49, 0x2f, 0x7c,
		0x72, 0x79, 0x71, 0x73, 0xf9, 0xa5, 0xbe, 0x71, 0x42, 0xab, 0xb2, 0x71, 0x6f, 0xbc, 0xbf, 0x49,
		0x6f, 0x7c, 0xf3, 0xf7, 0xcd, 0x6d, 0xfd, 0xfc, 0xfe, 0xb4, 0x56, 0x3f, 0xbf, 0xbc, 0xd8, 0xb0,
		0x17, 0xff, 0x72, 0xf9, 0xfb, 0x26, 0xbd, 0xf1, 0xd7, 0x9b, 0xfa, 0xf5, 0xc6, 0x31, 0xf3, 0xe1,
		0xc6, 0xbd, 0xf1, 0xde, 0x26, 0xbd, 0xf1, 0x79, 0xed, 0xec, 0xcb, 0xc6, 0xdd, 0x70, 0x75, 0x93,
		0xde, 0xf8, 0xcf, 0xfa, 0xf5, 0x45, 0x7d, 0xa3, 0xee, 0xb8, 0xf6, 0x65, 0xf3, 0x48, 0xfa, 0x88,
		0xf0, 0x8d, 0x49, 0x76, 0x6a, 0x14, 0xb6, 0x1f, 0x81, 0xc2, 0x8d, 0x97, 0x02, 0xf6, 0xcc, 0x7c,
		0xd2, 0xa0, 0x43, 0xbc, 0x23, 0x82, 0x0e, 0x4b, 0xcf, 0x0a, 0x41, 0x07, 0x04, 0x1d, 0x92, 0xdf,
		0x88, 0x3e, 0xe8, 0x10, 0xbc, 0x04, 0x6d, 0xef, 0xd1, 0x24, 0x62, 0xd1, 0x49, 0x36, 0x2d, 0x1f,
		0x10, 0xec, 0x55, 0x77, 0x7b, 0x9d, 0xc1, 0x0b, 0xaf, 0x4c, 0x90, 0x66, 0x1a, 0x30, 0x56, 0xac,
		0xb7, 0x1a, 0x8b, 0x70, 0xc9, 0x34, 0xc4, 0x38, 0xe3, 0x2e, 0xfe, 0x69, 0x57, 0x29, 0x67, 0xc3,
		0x90, 0xcf, 0x54, 0xbc, 0x19, 0x7d, 0x95, 0xf8, 0x27, 0xa9, 0x69, 0x93, 0xf2, 0xf7, 0x28, 0x53,
		0xc8, 0xab, 0x1c, 0xaf, 0xa7, 0x8a, 0xd3, 0xaf, 0x5d, 0x39, 0x2f, 0x92, 0x65, 0xb2, 0x57, 0x79,
		0x45, 0x2d, 0xe3, 0x95, 0x9f, 0x70, 0x39, 0xa3, 0xc2, 0x8e, 0x14, 0xf6, 0x98, 0x9d, 0x78, 0x19,
		0x33, 0x75, 0x8e, 0x45, 0x98, 0x32, 0xfa, 0xa7, 0x42, 0xfd, 0x10, 0x61, 0x10, 0x61, 0x10, 0x61,
		0x79, 0x13, 0x61, 0x31, 0x53, 0xe7, 0x59, 0x84, 0x71, 0x92, 0x26, 0xcc, 0xb2, 0xbd, 0x07, 0x0c,
		0xca, 0x64, 0xe5, 0x0a, 0x84, 0x17, 0x84, 0x57, 0x26, 0xc2, 0x0b, 0xc9, 0xca, 0xf0, 0x1b, 0xc2,
		0x6f, 0x08, 0xbf, 0x61, 0x4a, 0x7a, 0x43, 0xb2, 0x32, 0x92, 0x95, 0x69, 0xfe, 0x43, 0xb2, 0x72,
		0x6e, 0x6f, 0x19, 0xc9, 0xca, 0x6b, 0xfc, 0xbe, 0x48, 0x56, 0x5e, 0xef, 0x17, 0x46, 0xb2, 0xf2,
		0xa6, 0xbc, 0x31, 0x92, 0x95, 0x37, 0xe4, 0xc5, 0x91, 0xac, 0xbc, 0xfe, 0xcc, 0x8c, 0x64, 0xe5,
		0xb5, 0x7e, 0x63, 0x24, 0x2b, 0xaf, 0xfb, 0x1b, 0x23, 0x59, 0x79, 0x13, 0x48, 0x1a, 0xc9, 0xca,
		0x64, 0xab, 0x91, 0xac, 0xbc, 0x60, 0x1b, 0x04, 0x1d, 0xe4, 0x4e, 0x1f, 0x41, 0x07, 0x24, 0x2b,
		0x0b, 0xb0, 0x29, 0x92, 0x95, 0xc5, 0x09, 0x36, 0x7f, 0xc9, 0xca, 0x2a, 0x29, 0x1b, 0x06, 0x69,
		0xae, 0xb2, 0xc4, 0x00, 0x09, 0xf9, 0x5b, 0xd4, 0xdb, 0x36, 0x30, 0x1a, 0x30, 0x31, 0x0a, 0xc6,
		0x1b, 0x92, 0xdc, 0x27, 0x37, 0x6f, 0x22, 0x5e, 0x2d, 0x3d, 0x77, 0x62, 0xbc, 0x03, 0xe1, 0xfc,
		0x89, 0x78, 0x53, 0xa9, 0x39, 0x14, 0xb2, 0x37, 0x91, 0xd9, 0x38, 0x96, 0xa5, 0x9c, 0xa6, 0x71,
		0x24, 0xcb, 0x52, 0xde, 0x2a, 0xc6, 0x58, 0x96, 0xac, 0x3b, 0x48, 0x8b, 0x36, 0x4b, 0xa6, 0xb8,
		0x92, 0x4c, 0xfb, 0x48, 0x0b, 0x25, 0xf5, 0x49, 0x25, 0xf1, 0x49, 0xf7, 0x8f, 0xae, 0xa0, 0x7f,
		0x34, 0x25, 0x44, 0xde, 0xe0, 0x3e, 0xf0, 0xa2, 0x00, 0x46, 0x96, 0x83, 0xd3, 0xa3, 0x93, 0xc2,
		0xce, 0x00, 0x9a, 0x3e, 0x59, 0xc2, 0x11, 0x40, 0xd3, 0x67, 0x29, 0x3d, 0x01, 0x68, 0xc1, 0xf4,
		0x18, 0x9f, 0x75, 0x3c, 0xce, 0xcc, 0x80, 0xf9, 0xcf, 0x2c, 0x45, 0xe3, 0xfc, 0x58, 0x46, 0xbc,
		0x59, 0x87, 0x31, 0x2a, 0x18, 0xa3, 0x32, 0x87, 0xa0, 0xc4, 0x95, 0xe8, 0xf4, 0x72, 0x0c, 0x63,
		0x80, 0x32, 0x95, 0x52, 0xa6, 0xc2, 0xc3, 0x18, 0x24, 0xfb, 0xce, 0xab, 0xf5, 0x9b, 0xc7, 0x20,
		0x86, 0x95, 0x38, 0x5a, 0x31, 0x88, 0x21, 0xc5, 0xc2, 0x27, 0x2f, 0xe0, 0xea, 0x85, 0x4d, 0xe1,
		0x2e, 0x28, 0xca, 0x44, 0x5d, 0x53, 0xc6, 0x4c, 0xb5, 0x1a, 0x37, 0x35, 0x5d, 0x51, 0xa6, 0x02,
		0xdf, 0x4c, 0x29, 0x96, 0x63, 0x85, 0x3d, 0xa2, 0xb7, 0x51, 0x2b, 0x12, 0xa0, 0x2c, 0x03, 0xe9,
		0x9a, 0x56, 0xb3, 0xe9, 0xb3, 0x20, 0xa0, 0x0c, 0xc6, 0x1c, 0x13, 0xec, 0x45, 0x72, 0x52, 0x74,
		0x27, 0x36, 0xe7, 0xe4, 0x9e, 0x0f, 0x08, 0xcf, 0x6e, 0xe6, 0x0c, 0x3f, 0x10, 0xee, 0x79, 0x65,
		0x71, 0xce, 0x7c, 0x97, 0xb4, 0x3a, 0x25, 0xdc, 0x78, 0xeb, 0xdb, 0x9e, 0x79, 0xdc, 0x78, 0xfd,
		0x56, 0x36, 0x8f, 0x1b, 0xc3, 0x1f, 0xcb, 0xe1, 0x1f, 0xbf, 0x2a, 0xfd, 0xd7, 0xca, 0xb7, 0x3d,
		0xf3, 0x20, 0xfa, 0x6d, 0xa5, 0xfa, 0x6d, 0xcf, 0xac, 0x36, 0xb6, 0xb7, 0xee, 0xee, 0xde, 0x8b,
		0xae, 0xd9, 0xfe, 0xb5, 0xdf, 0xa7, 0x4b, 0xd6, 0x68, 0x50, 0x1e, 0xeb, 0xe5, 0xcd, 0xd9, 0xbf,
		0xb5, 0x9d, 0xed, 0x7f, 0xb7, 0xb2, 0x3a, 0xdd, 0xed, 0x7f, 0x10, 0x9e, 0x2f, 0xc9, 0x4e, 0x44,
		0x49, 0x44, 0x7a, 0xd8, 0xfe, 0x10, 0x6c, 0x1f, 0x52, 0x99, 0x65, 0xb6, 0x6a, 0xe6, 0xe7, 0xc6,
		0xaf, 0xf2, 0xce, 0x41, 0xff, 0xe3, 0xf6, 0xaf, 0xa3, 0xfe, 0xdb, 0x5f, 0xbe, 0xce, 0xfb, 0x58,
		0x79, 0xe7, 0xa8, 0xff, 0x31, 0xe1, 0x5f, 0x0e, 0xfb, 0x1f, 0x53, 0xee, 0x51, 0xed, 0x6f, 0xcd,
		0x7c, 0x74, 0xf0, 0xfb, 0x4a, 0xd2, 0x82, 0x83, 0x84, 0x05, 0xfb, 0x49, 0x0b, 0xf6, 0x13, 0x16,
		0x24, 0x7e, 0xa5, 0x4a, 0xc2, 0x82, 0x6a, 0xff, 0x75, 0xe6, 0xf3, 0x5b, 0xf3, 0x3f, 0x7a, 0xd8,
		0xdf, 0x7e, 0x4d, 0xfa, 0xb7, 0xa3, 0xfe, 0xeb, 0xc7, 0xed, 0xed, 0x0d, 0x16, 0x84, 0x20, 0xb7,
		0xec, 0xc9, 0x2d, 0x7f, 0x8a, 0xe1, 0xdd, 0x6a, 0xbf, 0x87, 0xa2, 0x62, 0x22, 0x44, 0xee, 0x4d,
		0xaf, 0x63, 0x39, 0xae, 0x19, 0x86, 0x3b, 0x08, 0xa1, 0x3b, 0x81, 0xfe, 0x29, 0x7d, 0x61, 0xee,
		0x63, 0x18, 0xdf, 0xc9, 0x1d, 0x78, 0x3f, 0x77, 0x5c, 0xb2, 0x1c, 0xc5, 0x78, 0xd3, 0xb0, 0xf4,
		0x5b, 0xbe, 0x59, 0x4c, 0xe2, 0xbe, 0x9f, 0x7d, 0xcb, 0xe6, 0x8e, 0xe7, 0x9e, 0x3a, 0x8f, 0x8e,
		0x6c, 0xd6, 0xcc, 0x62, 0x52, 0x62, 0x8f, 0x16, 0x77, 0x9e, 0x07, 0xdf, 0xbd, 0x65, 0xb5, 0x03,
		0x96, 0xc7, 0x1c, 0xf0, 0xd2, 0xb9, 0xf5, 0x53, 0xdf, 0x95, 0x55, 0xaa, 0xfb, 0xb8, 0x34, 0x32,
		0xd1, 0x4a, 0x24, 0xa0, 0x09, 0x24, 0x10, 0x35, 0x16, 0x29, 0x6d, 0x6d, 0x6d, 0x6d, 0x7d, 0xb3,
		0xcc, 0xff, 0xd5, 0xcc, 0xff, 0xec, 0x99, 0xc7, 0xf7, 0x8d, 0x89, 0xbf, 0xdc, 0xdd, 0x99, 0xf7,
		0x8d, 0xed, 0x5f, 0x7b, 0x3b, 0x87, 0xe5, 0xfe, 0xf6, 0x6f, 0xe3, 0xdf, 0x37, 0xee, 0xee, 0xde,
		0x6f, 0xff, 0x53, 0x66, 0xd5, 0x6f, 0xdb, 0xaf, 0x83, 0xb5, 0xa5, 0x7c, 0x1c, 0xa5, 0x0e, 0x6c,
		0x37, 0xc0, 0x74, 0xd9, 0x1f, 0x28, 0x01, 0x9a, 0x69, 0xac, 0x28, 0x35, 0xb8, 0x91, 0xe3, 0x7e,
		0x6d, 0x51, 0x78, 0xb9, 0xeb, 0xf9, 0x04, 0xc1, 0x8d, 0xc9, 0xcd, 0x64, 0x3b, 0x61, 0xb1, 0x96,
		0xd5, 0x6b, 0x73, 0x25, 0x62, 0x2d, 0x55, 0xcb, 0x92, 0xcd, 0x33, 0x1a, 0x88, 0xcc, 0x20, 0x32,
		0x23, 0xb0, 0x21, 0x22, 0x33, 0x46, 0x69, 0xc0, 0xed, 0xa6, 0xdb, 0xeb, 0x3c, 0x30, 0x9f, 0x20,
		0x40, 0x73, 0xa8, 0xb0, 0xc5, 0xb5, 0xe5, 0x3e, 0xe6, 0x22, 0x40, 0x43, 0x69, 0xa9, 0xc4, 0x70,
		0x97, 0x08, 0x8b, 0x6a, 0x03, 0xb9, 0xf4, 0xe0, 0x96, 0xc0, 0x12, 0x21, 0xb5, 0x40, 0xe2, 0xab,
		0x38, 0xac, 0x56, 0xf7, 0xab, 0x9b, 0x77, 0x1d, 0x80, 0x4f, 0x33, 0x87, 0x1c, 0x84, 0xaa, 0x2e,
		0x8e, 0x29, 0xa8, 0xf7, 0xbd, 0x9d, 0xde, 0x0f, 0x70, 0x04, 0x70, 0x04, 0x70, 0x44, 0x88, 0x5e,
		0x48, 0x92, 0x22, 0xd6, 0x34, 0x5d, 0x84, 0x34, 0xe9, 0x81, 0xd4, 0xeb, 0x4c, 0xef, 0xf3, 0x29,
		0x4c, 0x72, 0x43, 0xae, 0xfd, 0x3c, 0x05, 0x4a, 0x62, 0x58, 0x97, 0xd8, 0x10, 0x71, 0x92, 0x42,
		0xce, 0xd9, 0x14, 0xd1, 0xe1, 0xc2, 0x26, 0x23, 0xe4, 0x5e, 0x70, 0x81, 0xac, 0x0a, 0x99, 0x74,
		0xb0, 0xf6, 0x6e, 0xfa, 0xb5, 0xea, 0x53, 0x30, 0x5d, 0xf7, 0x38, 0xfd, 0x57, 0xf9, 0x01, 0x86,
		0x82, 0xf5, 0xa0, 0xd7, 0xe1, 0x53, 0x6f, 0x86, 0xdf, 0x61, 0xea, 0x6f, 0x52, 0x83, 0x0b, 0x05,
		0xfa, 0x16, 0x08, 0x94, 0xb1, 0x49, 0x15, 0x90, 0xa8, 0x24, 0xc0, 0x4b, 0xfa, 0x01, 0x50, 0x4d,
		0x85, 0x6a, 0x2a, 0xed, 0x76, 0x3b, 0xc1, 0xb4, 0x2d, 0x95, 0x29, 0x5b, 0x73, 0xa6, 0x6b, 0x85,
		0x0c, 0x96, 0x03, 0x31, 0x31, 0x6e, 0x26, 0x22, 0x2d, 0x2b, 0x64, 0xfa, 0x91, 0x18, 0x28, 0xbf,
		0x84, 0xc0, 0x30, 0xf2, 0x5b, 0x7e, 0x19, 0x77, 0x3f, 0x22, 0x98, 0x8d, 0x29, 0xdd, 0x47, 0xc9,
		0xa0, 0x1c, 0x2f, 0x07, 0xef, 0x3a, 0xbc, 0xeb, 0xd9, 0x78, 0xd7, 0x95, 0xc7, 0xcb, 0x49, 0x36,
		0x03, 0x48, 0x24, 0x3b, 0xe5, 0xc1, 0xe6, 0x04, 0x8c, 0x48, 0xc6, 0x90, 0x94, 0x8c, 0x49, 0xcf,
		0xa0, 0xd4, 0x8c, 0xaa, 0x8d, 0x61, 0xb5, 0x31, 0xae, 0x16, 0x06, 0x56, 0x77, 0x37, 0x10, 0x78,
		0x9d, 0x95, 0x19, 0x3b, 0xde, 0x88, 0x6c, 0x7e, 0xe4, 0x0c, 0x01, 0x13, 0xcd, 0x91, 0x54, 0xb4,
		0x69, 0xb5, 0x33, 0xbf, 0x0e, 0x21, 0xa0, 0x4f, 0x18, 0xe8, 0x12, 0x0a, 0xda, 0x85, 0x83, 0x76,
		0x21, 0xa1, 0x55, 0x58, 0xd0, 0x08, 0x0d, 0x22, 0xe1, 0xa1, 0x6e, 0xc3, 0x2f, 0xa5, 0x57, 0xda,
		0x39, 0x95, 0x33, 0x7a, 0xbf, 0x4a, 0xb8, 0xa7, 0x96, 0xb9, 0x95, 0x33, 0x07, 0xa2, 0x67, 0x7e,
		0x65, 0xfc, 0x18, 0x0d, 0x73, 0x2c, 0x47, 0xff, 0xfd, 0x22, 0xdf, 0xd1, 0xd0, 0x39, 0xd7, 0x92,
		0x98, 0x47, 0x32, 0x3c, 0x09, 0xfa, 0x79, 0x97, 0xc5, 0x3d, 0x0b, 0xea, 0x39, 0x98, 0xc5, 0xa6,
		0x0a, 0x9c, 0x03, 0xf1, 0xdc, 0xcc, 0x22, 0x93, 0x03, 0xe9, 0x3c, 0xcd, 0xe2, 0x1e, 0x04, 0xf9,
		0x9c, 0xcd, 0x82, 0x0b, 0xcb, 0x0a, 0x4e, 0x82, 0x7e, 0x2e, 0x67, 0x71, 0x4f, 0x42, 0xd3, 0xbc,
		0xce, 0x42, 0x1f, 0x08, 0xe9, 0x1c, 0xcf, 0xe2, 0x9e, 0x04, 0xed, 0x7c, 0xcf, 0x82, 0x0b, 0x8b,
		0x43, 0x9c, 0x04, 0xfd, 0x3c, 0xd0, 0xe2, 0x9e, 0x04, 0xed, 0x9c, 0xd0, 0x82, 0x53, 0x44, 0x15,
		0x27, 0x41, 0x3f, 0x57, 0xb4, 0xc0, 0xa6, 0xc7, 0x17, 0x1c, 0x83, 0x86, 0x39, 0xa4, 0xf1, 0x49,
		0x90, 0xee, 0xd8, 0x58, 0xbb, 0x06, 0x33, 0x14, 0x35, 0xc1, 0x64, 0x73, 0x4b, 0x67, 0xa8, 0x82,
		0x70, 0x38, 0xa2, 0x81, 0x60, 0x17, 0x82, 0x5d, 0xd1, 0x03, 0x10, 0xec, 0x2a, 0x40, 0xb0, 0x8b,
		0x7e, 0x3e, 0xea, 0x5b, 0x31, 0x40, 0x31, 0x27, 0x35, 0xde, 0x93, 0x66, 0x5e, 0x2a, 0xa1, 0x60,
		0x5f, 0x69, 0x22, 0x05, 0xd1, 0x3c, 0xd5, 0xb1, 0x8a, 0xa1, 0xac, 0xa2, 0x98, 0x33, 0x6c, 0x95,
		0x24, 0x81, 0xca, 0x20, 0x2d, 0xb4, 0x98, 0x33, 0x88, 0x55, 0xa6, 0xf6, 0x82, 0x8e, 0x2e, 0x54,
		0x46, 0x9b, 0x93, 0xe5, 0xc3, 0x50, 0xe7, 0xc1, 0x60, 0xb4, 0xf9, 0x2a, 0x55, 0x3e, 0x92, 0xde,
		0x72, 0x20, 0xab, 0xe9, 0x47, 0x9b, 0xcb, 0xd7, 0xa0, 0x24, 0xaa, 0xea, 0x23, 0x9a, 0x6a, 0xeb,
		0x37, 0x35, 0x2a, 0xb1, 0x10, 0x29, 0xa0, 0x48, 0x25, 0xb3, 0xba, 0xa8, 0xad, 0x2d, 0x88, 0x54,
		0x88, 0x54, 0x88, 0xd4, 0x4d, 0x15, 0xa9, 0xb1, 0x10, 0x29, 0xa2, 0x48, 0x15, 0x9a, 0xcb, 0xbd,
		0x5c, 0x9e, 0x0a, 0x0e, 0x40, 0x5e, 0x78, 0x5b, 0x54, 0xc2, 0xb4, 0x02, 0x61, 0x0a, 0x61, 0x5a,
		0x28, 0x61, 0x8a, 0xa2, 0x0c, 0xd5, 0xed, 0xe0, 0xa7, 0x86, 0x9f, 0x3a, 0x33, 0x61, 0x41, 0xe7,
		0xc2, 0x34, 0x50, 0x94, 0x81, 0xa2, 0x8c, 0x99, 0xc7, 0xa0, 0x28, 0x43, 0x13, 0x8f, 0x64, 0x78,
		0x12, 0x28, 0xca, 0x40, 0x51, 0xc6, 0x7c, 0xaa, 0xc0, 0x39, 0xa0, 0x28, 0x03, 0x45, 0x19, 0xd3,
		0x07, 0x81, 0xa2, 0x0c, 0x14, 0x65, 0xcc, 0x3f, 0x09, 0x14, 0x65, 0xa0, 0x28, 0x23, 0x09, 0x80,
		0xe3, 0x24, 0x50, 0x94, 0x81, 0xa2, 0x8c, 0xb9, 0x27, 0x81, 0xa2, 0x0c, 0x14, 0x65, 0xa0, 0x28,
		0x63, 0xe6, 0x24, 0x50, 0x94, 0x81, 0xa2, 0x0c, 0x03, 0x45, 0x19, 0xab, 0xdf, 0x05, 0x45, 0x19,
		0x0a, 0xdb, 0x21, 0xd8, 0x85, 0x60, 0xd7, 0xdc, 0x07, 0x20, 0xd8, 0x45, 0xc0, 0xfb, 0x28, 0xca,
		0x58, 0xdd, 0x0e, 0x9b, 0x56, 0x94, 0x41, 0x91, 0x3f, 0x65, 0xe8, 0xae, 0xc9, 0xb8, 0x09, 0xbf,
		0xe4, 0xaa, 0x92, 0xdd, 0x32, 0x6d, 0x7b, 0xfc, 0x27, 0x7b, 0x99, 0x4c, 0x76, 0x31, 0x14, 0xa5,
		0x40, 0xe9, 0x8b, 0x13, 0xf0, 0x1a, 0xe7, 0x8a, 0xbd, 0x94, 0xcf, 0x1d, 0xb7, 0xde, 0x66, 0x03,
		0xc1, 0xae, 0x38, 0xed, 0xb5, 0x74, 0x6e, 0xfd, 0x9c, 0xd8, 0xa9, 0xfc, 0xe1, 0xe0, 0xe0, 0xf0,
		0xe8, 0xe0, 0x60, 0xef, 0x68, 0xff, 0x68, 0xef, 0xb8, 0x5a, 0x2d, 0x1f, 0xaa, 0xc4, 0xe2, 0x4b,
		0x97, 0x7e, 0x93, 0xf9, 0xac, 0xf9, 0x69, 0x70, 0x84, 0x6e, 0xaf, 0xdd, 0xce, 0xf4, 0xe6, 0x88,
		0x38, 0x5f, 0x37, 0xc7, 0x97, 0x94, 0x72, 0x37, 0xb5, 0xf1, 0x78, 0x09, 0x83, 0x8c, 0xb4, 0xdd,
		0xfd, 0x4a, 0x67, 0x19, 0xc5, 0x57, 0x9d, 0x8b, 0x39, 0x25, 0x52, 0xc9, 0xc7, 0x4a, 0xc9, 0xc6,
		0xca, 0xf3, 0x49, 0x2a, 0x98, 0x4f, 0xb2, 0x4a, 0x53, 0x67, 0x9d, 0xe7, 0x93, 0x48, 0x4d, 0xf7,
		0x9a, 0x21, 0x16, 0x89, 0x29, 0x5f, 0x44, 0x7e, 0x09, 0xcc, 0x25, 0xc9, 0xc6, 0x8f, 0x80, 0xb9,
		0x24, 0x84, 0x76, 0x3f, 0x05, 0xdf, 0x18, 0xeb, 0x3b, 0xef, 0x5b, 0xc7, 0x18, 0xe1, 0x63, 0x82,
		0xbd, 0x48, 0x4e, 0x8a, 0xee, 0xc4, 0xe6, 0x9c, 0x1c, 0xe9, 0xa4, 0xf4, 0x99, 0x33, 0xfc, 0x40,
		0xb8, 0x27, 0xf5, 0xf0, 0xdc, 0x78, 0xe3, 0xe2, 0x4c, 0x50, 0x1f, 0xfd, 0xd7, 0xa0, 0x3c, 0x56,
		0x1d, 0x83, 0x89, 0xe3, 0xdd, 0x8b, 0x35, 0x59, 0x3d, 0x3e, 0xdf, 0x3c, 0x39, 0x8d, 0xf5, 0xb0,
		0xfd, 0x21, 0xd8, 0x1e, 0xa3, 0xb3, 0x0b, 0x3b, 0x91, 0xbd, 0xb0, 0x82, 0x10, 0xe4, 0x56, 0xc8,
		0x49, 0xed, 0xc4, 0x8a, 0x61, 0xd5, 0x93, 0xe3, 0x77, 0xf2, 0x82, 0xdc, 0x9b, 0x5e, 0xc7, 0x72,
		0x5c, 0x33, 0xf4, 0x18, 0x12, 0x42, 0x77, 0x02, 0xfd, 0x53, 0xfa, 0xc2, 0xdc, 0xc7, 0xd0, 0xa3,
		0x9a, 0x3b, 0xf0, 0x7e, 0xee, 0xb8, 0xf4, 0x59, 0x04, 0x61, 0xf1, 0x9e, 0x7a, 0x3b, 0x83, 0x99,
		0x7d, 0x3f, 0xfb, 0x96, 0xcd, 0x1d, 0xcf, 0x3d, 0x75, 0x1e, 0x1d, 0xd5, 0x38, 0xd0, 0x7c, 0x52,
		0x62, 0x8f, 0x16, 0x77, 0x9e, 0x07, 0xdf, 0xbd, 0x65, 0xb5, 0x03, 0x46, 0x97, 0x39, 0x40, 0xa8,
		0x5b, 0xce, 0xad, 0x9f, 0xfa, 0xae, 0xac, 0x52, 0xdd, 0xc7, 0xa5, 0x91, 0x89, 0x56, 0x22, 0x01,
		0x4d, 0xd3, 0xc2, 0x85, 0x14, 0x8b, 0x94, 0xb6, 0xb6, 0xb6, 0xb6, 0xbe, 0x59, 0xe6, 0xff, 0x6a,
		0xe6, 0x7f, 0xf6, 0xcc, 0xe3, 0xfb, 0xc6, 0xc4, 0x5f, 0xee, 0xee, 0xcc, 0xfb, 0xc6, 0xf6, 0xaf,
		0xbd, 0x9d, 0xc3, 0x72, 0x7f, 0xfb, 0xb7, 0xf1, 0xef, 0x1b, 0x77, 0x77, 0xef, 0xb7, 0xff, 0x29,
		0xb3, 0xea, 0xb7, 0xed, 0xd7, 0xc1, 0xda, 0x52, 0x3e, 0x8e, 0x52, 0x07, 0xb6, 0x1b, 0x60, 0xba,
		0xec, 0x0f, 0x94, 0x00, 0xcd, 0x34, 0x56, 0x94, 0x14, 0xd1, 0xc8, 0x2a, 0x5c, 0x2b, 0x11, 0x82,
		0x8a, 0xa2, 0xa0, 0x5d, 0xcf, 0x27, 0x08, 0x6e, 0x4c, 0x6e, 0x26, 0x3b, 0xc9, 0x9a, 0xb5, 0xac,
		0x5e, 0x9b, 0x2b, 0x11, 0x6b, 0xa9, 0x5a, 0x96, 0x2c, 0x5f, 0x6e, 0x20, 0x32, 0x83, 0xc8, 0x8c,
		0xc0, 0x86, 0x88, 0xcc, 0x18, 0xa5, 0x01, 0xb7, 0x9b, 0x6e, 0xaf, 0xf3, 0xc0, 0x7c, 0x82, 0x00,
		0xcd, 0xa1, 0xc2, 0x16, 0xd7, 0x96, 0xfb, 0x98, 0x8b, 0x00, 0x0d, 0xa5, 0xa5, 0x12, 0xc3, 0x5d,
		0xaa, 0xec, 0x71, 0x5d, 0x20, 0x97, 0x1e, 0xdc, 0x52, 0x54, 0x1d, 0x50, 0x5a, 0x20, 0xf1, 0x55,
		0x1c, 0x56, 0xab, 0xfb, 0xd5, 0xcd, 0xbb, 0x0e, 0xc0, 0xa7, 0x99, 0x43, 0x0e, 0x42, 0x55, 0x17,
		0xc7, 0x14, 0x94, 0x11, 0xd4, 0x9b, 0xfd, 0x00, 0x47, 0x00, 0x47, 0x00, 0x47, 0x84, 0xe8, 0x85,
		0x24, 0x29, 0x62, 0x4d, 0xd3, 0x45, 0x48, 0x93, 0x1e, 0x48, 0xbd, 0xce, 0xf4, 0x3e, 0x9f, 0xc2,
		0x24, 0x37, 0xe4, 0xda, 0xcf, 0x53, 0xa0, 0x24, 0x86, 0x75, 0x89, 0x0d, 0x11, 0x27, 0x29, 0xe4,
		0x9c, 0x4d, 0x11, 0x1d, 0x2e, 0x6c, 0x32, 0x42, 0xee, 0x05, 0x17, 0xc8, 0xaa, 0x90, 0x49, 0x07,
		0x6b, 0xef, 0xa6, 0xdf, 0xa0, 0xaa, 0x2a, 0xc9, 0x82, 0x59, 0xc2, 0x8a, 0x2a, 0xf1, 0x6a, 0x58,
		0x81, 0x6a, 0xaa, 0x77, 0x84, 0x37, 0x38, 0xaa, 0x66, 0x15, 0xc8, 0x74, 0x97, 0x2b, 0x58, 0x95,
		0x2f, 0x50, 0x25, 0x2d, 0x48, 0x95, 0x2b, 0x40, 0x4d, 0x7b, 0x98, 0x92, 0x6c, 0x40, 0x4a, 0xfe,
		0x25, 0xa1, 0x62, 0x3b, 0x1a, 0x82, 0x4f, 0x47, 0xea, 0xcb, 0x09, 0x77, 0xf1, 0x27, 0x96, 0xdc,
		0x82, 0xe8, 0xe9, 0x2b, 0x9e, 0x7a, 0x8a, 0x73, 0x56, 0x39, 0xdf, 0xc5, 0x47, 0x9a, 0x7c, 0x50,
		0xf3, 0xff, 0x25, 0xe1, 0xe8, 0xd2, 0x1e, 0x99, 0xe8, 0x51, 0x2d, 0x38, 0x1b, 0xb1, 0x33, 0x99,
		0x7f, 0x0a, 0xb3, 0xef, 0x38, 0xe7, 0xfd, 0x4a, 0x1d, 0xd6, 0xf1, 0xfc, 0xe4, 0xc6, 0x3f, 0xb1,
		0xe9, 0x13, 0x7d, 0x2e, 0xe1, 0x84, 0x16, 0xd7, 0x86, 0x2e, 0xf5, 0x5a, 0xa6, 0xf1, 0x4a, 0x4e,
		0x7a, 0x1d, 0x83, 0x97, 0x45, 0x84, 0x95, 0xd6, 0xab, 0x28, 0xec, 0x35, 0x14, 0xf6, 0x0a, 0xbe,
		0xf5, 0xfa, 0x0d, 0xbe, 0x37, 0x11, 0x4d, 0x2e, 0xab, 0x95, 0x2c, 0xd9, 0xa3, 0x33, 0x5f, 0x72,
		0x08, 0xa3, 0x63, 0x4d, 0x35, 0xd5, 0x34, 0x65, 0x11, 0x70, 0x6a, 0x37, 0xb5, 0x88, 0x3b, 0x3a,
		0x3d, 0x01, 0xc8, 0xba, 0x97, 0xa5, 0xdd, 0xc8, 0xd2, 0xee, 0x62, 0x21, 0x02, 0xc9, 0xb7, 0xfc,
		0x1f, 0x0a, 0x88, 0xf4, 0xc3, 0x71, 0x53, 0x8a, 0xb8, 0xf3, 0x70, 0xdb, 0x54, 0xd3, 0x6c, 0x17,
		0x88, 0xfb, 0x85, 0x92, 0x36, 0x4d, 0x29, 0xbd, 0x50, 0xe9, 0xbc, 0x30, 0x97, 0x54, 0xc0, 0x25,
		0x39, 0xe3, 0x92, 0xb4, 0xa5, 0xe8, 0x25, 0xdb, 0xeb, 0xb9, 0x7c, 0x80, 0x44, 0x52, 0x1f, 0xdf,
		0x58, 0xe0, 0x46, 0x2b, 0xd3, 0xda, 0x20, 0x42, 0xfd, 0x17, 0x84, 0x23, 0x85, 0x32, 0x91, 0x41,
		0x71, 0x62, 0x53, 0x8d, 0xfc, 0x29, 0x47, 0xfa, 0x94, 0x23, 0x7b, 0x52, 0xc4, 0xa8, 0xc7, 0x2a,
		0x15, 0xed, 0x97, 0x50, 0xb2, 0x3d, 0xdf, 0x67, 0x36, 0xb7, 0x1e, 0xda, 0xcc, 0x64, 0xb6, 0x6d,
		0x32, 0xdf, 0xf7, 0xfc, 0x40, 0xbe, 0x8f, 0x48, 0xc2, 0x7e, 0x72, 0x8d, 0x45, 0xf6, 0x64, 0x1b,
		0x8b, 0xec, 0xad, 0xa6, 0xb1, 0x88, 0x18, 0xc1, 0xab, 0x12, 0x3e, 0x19, 0x03, 0x90, 0x31, 0x02,
		0x09, 0x43, 0x64, 0xe3, 0x78, 0x93, 0x0e, 0x61, 0xc7, 0xf7, 0xdd, 0x73, 0x5c, 0x7e, 0x78, 0x20,
		0x73, 0xdf, 0x11, 0x75, 0x4b, 0x84, 0x78, 0x14, 0x93, 0xe6, 0xd4, 0xda, 0xa4, 0xa9, 0xe7, 0x64,
		0x10, 0x25, 0xc7, 0x91, 0x67, 0x61, 0xd1, 0x65, 0x5f, 0xf5, 0xd5, 0xfa, 0xc7, 0xd1, 0x1d, 0x31,
		0x6d, 0xfb, 0xb9, 0xbc, 0x9f, 0x7a, 0x46, 0xb1, 0x80, 0x46, 0x0e, 0xfa, 0x7c, 0x71, 0x8f, 0x5b,
		0x6d, 0x12, 0x55, 0x3d, 0xb3, 0x13, 0x94, 0x34, 0x94, 0x34, 0x94, 0x34, 0x94, 0x34, 0x94, 0x34,
		0x94, 0x34, 0x94, 0xb4, 0x8a, 0x92, 0xee, 0xb9, 0xd4, 0x76, 0x75, 0xe2, 0x8e, 0x50, 0xda, 0x50,
		0xda, 0x50, 0xda, 0x50, 0xda, 0x50, 0xda, 0x50, 0xda, 0x50, 0xda, 0x72, 0x9f, 0xcc, 0x4b, 0x9a,
		0x52, 0x14, 0x30, 0x0d, 0x03, 0x8a, 0xbb, 0x82, 0xc1, 0x20, 0x43, 0x38, 0x80, 0x1a, 0x26, 0xdb,
		0xdd, 0x9f, 0x8c, 0x1e, 0x43, 0x95, 0x8a, 0x94, 0x22, 0xbc, 0xd8, 0xf2, 0x19, 0x13, 0x8f, 0x8e,
		0x85, 0xab, 0xc4, 0x22, 0x63, 0x7b, 0x88, 0x8c, 0x21, 0x32, 0x26, 0x09, 0x4b, 0xe4, 0xe1, 0x88,
		0x04, 0x0c, 0x91, 0x84, 0x1f, 0x12, 0x20, 0x4b, 0x05, 0x6e, 0xa8, 0xc2, 0x0c, 0x32, 0x45, 0xa7,
		0xae, 0xe0, 0x64, 0xca, 0x87, 0x55, 0x60, 0x84, 0x06, 0xf8, 0x90, 0xa7, 0xd3, 0xd4, 0xa4, 0xbe,
		0x1b, 0x19, 0x2a, 0xa5, 0xee, 0xd3, 0x4b, 0xe0, 0xd8, 0x56, 0x5b, 0x5c, 0x31, 0xc5, 0x2b, 0xa1,
		0x9c, 0xa0, 0x9c, 0xa0, 0x9c, 0xa0, 0x9c, 0xa0, 0x9c, 0xa0, 0x9c, 0x68, 0x95, 0x93, 0xcf, 0xc2,
		0xea, 0x89, 0xa6, 0xb8, 0x72, 0x8a, 0x57, 0x42, 0x39, 0x41, 0x39, 0x41, 0x39, 0x41, 0x39, 0x41,
		0x39, 0x41, 0x39, 0xd1, 0x2a, 0xa7, 0x5e, 0x20, 0xa3, 0x98, 0xc2, 0x55, 0x50, 0x4a, 0x50, 0x4a,
		0x50, 0x4a, 0x50, 0x4a, 0x50, 0x4a, 0x50, 0x4a, 0x02, 0x4a, 0x29, 0xcf, 0xe5, 0x8e, 0x69, 0xbb,
		0x68, 0x48, 0x04, 0xeb, 0x8a, 0x59, 0xdb, 0xbe, 0xb0, 0x4e, 0x5c, 0xf8, 0x24, 0xd4, 0x2a, 0xdb,
		0x83, 0xc0, 0x7a, 0x64, 0x41, 0x9a, 0xda, 0xf6, 0xe8, 0x93, 0xf9, 0xa8, 0x6e, 0x5f, 0xf2, 0x75,
		0x8c, 0x5c, 0x97, 0xb8, 0xc7, 0x5f, 0x1e, 0x75, 0xee, 0x92, 0x98, 0x53, 0x90, 0x14, 0x64, 0x81,
		0xe6, 0xea, 0xcb, 0x78, 0x97, 0x93, 0x0a, 0x8d, 0x0a, 0x48, 0x5d, 0xcb, 0x1b, 0xb0, 0x67, 0xe6,
		0x3b, 0xfc, 0x45, 0xdc, 0xbc, 0x89, 0x57, 0xae, 0x87, 0x89, 0x23, 0x40, 0x76, 0xeb, 0x67, 0xe7,
		0xa4, 0x27, 0xcb, 0xbc, 0x19, 0x3b, 0xc1, 0x4b, 0xd0, 0xf6, 0x1e, 0x4d, 0x41, 0x62, 0x9c, 0x92,
		0x77, 0x07, 0x02, 0x6b, 0xea, 0x6e, 0xaf, 0x33, 0xf8, 0xa2, 0xfd, 0x35, 0x07, 0x7a, 0x43, 0x72,
		0xd0, 0xd0, 0xd9, 0x62, 0xb8, 0xb1, 0xc6, 0xde, 0x16, 0x4d, 0xf6, 0xd0, 0x7b, 0x34, 0x99, 0xcb,
		0x7d, 0x87, 0x05, 0xe9, 0x55, 0xe4, 0xf4, 0x32, 0x68, 0x4a, 0x68, 0xca, 0xf9, 0x84, 0x15, 0x30,
		0xff, 0xd9, 0xb1, 0x25, 0x92, 0xfb, 0xa6, 0x97, 0xaf, 0x47, 0xff, 0x0b, 0xe8, 0xcc, 0x15, 0xea,
		0x4c, 0x89, 0x4e, 0x18, 0xa9, 0xac, 0x06, 0x35, 0x2b, 0x42, 0x91, 0x84, 0xa5, 0x49, 0x59, 0x85,
		0xa4, 0x89, 0x48, 0x5b, 0x95, 0xc4, 0xc9, 0x48, 0x9d, 0x8c, 0xe4, 0xe9, 0x48, 0x5f, 0xd2, 0xf1,
		0x26, 0x78, 0xf7, 0xa2, 0x2c, 0x11, 0x2f, 0x64, 0xae, 0xf5, 0xd0, 0x16, 0x88, 0xf1, 0x24, 0x52,
		0xce, 0x68, 0xa3, 0x55, 0x8e, 0x9b, 0x0b, 0x5d, 0xa2, 0x18, 0x38, 0xb7, 0x1a, 0xe6, 0xa7, 0x12,
		0x02, 0xe4, 0xc2, 0x80, 0x5c, 0x28, 0xd0, 0x0b, 0x07, 0x39, 0x21, 0x21, 0x29, 0x2c, 0xe4, 0x6d,
		0xcf, 0x44, 0xca, 0x79, 0xf0, 0xbc, 0x36, 0xb3, 0x5c, 0x8a, 0x41, 0x2f, 0xe5, 0x3c, 0x0f, 0x99,
		0x12, 0x84, 0xc0, 0x0b, 0x3c, 0x48, 0x22, 0x60, 0x18, 0x42, 0x07, 0x42, 0x07, 0x42, 0x67, 0x86,
		0x72, 0x9c, 0x26, 0x73, 0xb9, 0xc3, 0x5f, 0x7c, 0xd6, 0xa2, 0x10, 0x3c, 0x0a, 0x95, 0x9e, 0xa5,
		0xb3, 0xe8, 0xab, 0x7c, 0xb2, 0x02, 0x02, 0x1a, 0x1c, 0xbd, 0xe0, 0x69, 0xfd, 0xd3, 0xd7, 0xdf,
		0xef, 0x6f, 0xea, 0xd7, 0x7f, 0x9d, 0x9d, 0xd4, 0x4b, 0xb9, 0x2f, 0xf4, 0x5c, 0x8f, 0x71, 0x0a,
		0xb1, 0x07, 0x70, 0xca, 0x2f, 0xb6, 0x3b, 0xe5, 0xc4, 0xd8, 0x95, 0x32, 0x08, 0x65, 0xbc, 0x85,
		0xa7, 0x83, 0xc7, 0xd6, 0x87, 0xdf, 0x61, 0xf8, 0x97, 0x9b, 0xe1, 0x57, 0x48, 0xe5, 0x47, 0x94,
		0xbf, 0x21, 0x91, 0x8e, 0x18, 0xb2, 0x5a, 0x51, 0x51, 0x1b, 0x16, 0xb5, 0xdf, 0x05, 0xec, 0xeb,
		0x02, 0xda, 0xd7, 0xea, 0x9d, 0x2f, 0xda, 0xcc, 0x6a, 0xc9, 0x69, 0xaa, 0x58, 0x43, 0x1d, 0x49,
		0xac, 0xbd, 0x8a, 0x04, 0xde, 0xfb, 0xf7, 0x91, 0xd0, 0xda, 0x1d, 0x71, 0x5b, 0x1e, 0x24, 0x47,
		0xaa, 0x6e, 0xdc, 0xc9, 0x72, 0x43, 0x62, 0xa8, 0x8d, 0xb2, 0x57, 0xae, 0x02, 0xa9, 0x01, 0xa9,
		0x01, 0xaf, 0x1c, 0xbc, 0x72, 0x30, 0x90, 0x61, 0x20, 0xc3, 0x2b, 0x07, 0xaf, 0x1c, 0x84, 0x0e,
		0x84, 0x0e, 0x84, 0x0e, 0xbc, 0x72, 0xf0, 0xca, 0xad, 0xda, 0x2b, 0xa7, 0x79, 0xc8, 0x69, 0x0a,
		0xa7, 0x5c, 0xf1, 0x86, 0x9c, 0x0a, 0xa6, 0x65, 0x61, 0xce, 0x29, 0x31, 0x27, 0x90, 0x72, 0x80,
		0x8e, 0x7e, 0x82, 0xcb, 0x68, 0xbe, 0xb4, 0x19, 0xf9, 0xc0, 0x22, 0x59, 0xb2, 0xaa, 0xe7, 0x8b,
		0xc1, 0x77, 0x48, 0x06, 0xce, 0x6d, 0x32, 0x70, 0xf4, 0x85, 0xc4, 0xd3, 0x80, 0x47, 0x0b, 0x35,
		0x27, 0x00, 0x57, 0x90, 0x00, 0x4c, 0x6e, 0xed, 0x14, 0x3e, 0x01, 0xd8, 0xea, 0x76, 0xcd, 0x48,
		0x14, 0x4b, 0xc6, 0x1a, 0xe2, 0x1d, 0x10, 0xa4, 0xd4, 0x6c, 0xf4, 0x23, 0xdc, 0x20, 0x6b, 0x8c,
		0xa9, 0x07, 0x29, 0x03, 0xee, 0x2f, 0x1e, 0x55, 0xbe, 0x54, 0x5c, 0x7f, 0xd0, 0xfa, 0x86, 0xec,
		0x27, 0xf7, 0x2d, 0xb3, 0xe7, 0x06, 0xe1, 0xac, 0x0c, 0xb9, 0x77, 0xf5, 0x59, 0x8b, 0xf9, 0xcc,
		0xb5, 0x57, 0x32, 0x11, 0x60, 0x74, 0xd0, 0x67, 0xf5, 0xdb, 0xcf, 0xc6, 0xf5, 0xe7, 0x13, 0xa3,
		0x7a, 0x50, 0x39, 0xd8, 0x31, 0x6e, 0x58, 0xd8, 0x1e, 0xc2, 0x38, 0x7c, 0x5f, 0x79, 0x5f, 0x7d,
		0x9f, 0x33, 0x8f, 0xdb, 0xf8, 0xc0, 0xf2, 0xec, 0x74, 0x5b, 0x7c, 0xa2, 0x18, 0x6d, 0x93, 0xe2,
		0x38, 0x3b, 0x81, 0x42, 0x8d, 0xcc, 0x60, 0x31, 0x74, 0x23, 0x74, 0x23, 0x74, 0x23, 0x95, 0x6e,
		0xd4, 0xc5, 0xe3, 0x4e, 0x53, 0x89, 0xcb, 0x9d, 0x26, 0xf8, 0x1c, 0x7c, 0x0e, 0x3e, 0x07, 0x06,
		0xd6, 0x87, 0x81, 0x8f, 0x80, 0x81, 0x89, 0x31, 0xf0, 0x11, 0x30, 0x70, 0xaa, 0xe3, 0xec, 0xfa,
		0x8e, 0x27, 0xd4, 0x15, 0x68, 0x86, 0xac, 0xe3, 0x1d, 0xa0, 0x25, 0xa1, 0x25, 0xd7, 0x56, 0x4b,
		0xf6, 0x1c, 0x97, 0x7f, 0x50, 0x50, 0x92, 0x55, 0xcc, 0x71, 0x94, 0xdc, 0x07, 0x73, 0x1c, 0x97,
		0x1e, 0x71, 0xa5, 0x8a, 0xb1, 0x8d, 0x19, 0x2b, 0x63, 0x80, 0xd8, 0x19, 0xc8, 0x55, 0x06, 0x86,
		0xa5, 0xc5, 0xb0, 0x65, 0x40, 0xd8, 0x74, 0x10, 0xd6, 0xb3, 0x55, 0x7c, 0x3c, 0xd1, 0x7a, 0xc0,
		0x57, 0xc0, 0x57, 0x38, 0x79, 0xe0, 0xe4, 0xd1, 0xa6, 0x1f, 0x0f, 0xe1, 0xe4, 0x21, 0x56, 0x90,
		0x87, 0x9b, 0xec, 0xe4, 0x21, 0xcd, 0x30, 0xaa, 0xff, 0x0c, 0x51, 0x7f, 0x7a, 0xb6, 0x91, 0x4f,
		0xe9, 0xf2, 0x6c, 0x93, 0xfd, 0xe4, 0x1f, 0x39, 0x6b, 0xb3, 0x0e, 0xe3, 0xfe, 0x8b, 0x69, 0x71,
		0xaf, 0xe3, 0xd8, 0x6a, 0x39, 0x5e, 0xa1, 0x8d, 0xa1, 0x90, 0xe4, 0x45, 0x9d, 0xd9, 0x95, 0xb2,
		0x90, 0x53, 0x45, 0xee, 0x29, 0xc8, 0x3b, 0x05, 0x45, 0x32, 0xc5, 0x8d, 0x86, 0x69, 0xdc, 0x3e,
		0x31, 0xe3, 0x26, 0xec, 0xcc, 0x6c, 0x5c, 0xf9, 0x1e, 0xf7, 0x6c, 0xaf, 0xbd, 0x62, 0x68, 0xa1,
		0x2a, 0xd5, 0xf4, 0xa0, 0x8b, 0x34, 0xe7, 0x56, 0xb4, 0xe1, 0x26, 0x79, 0xab, 0x14, 0x08, 0x93,
		0xb8, 0x77, 0xc5, 0xf2, 0x6e, 0x0d, 0x89, 0xdc, 0xf5, 0xb0, 0xea, 0x65, 0xf4, 0xd7, 0x52, 0x86,
		0xd3, 0xc9, 0xd0, 0xc2, 0x1f, 0xd9, 0xc8, 0x68, 0xe1, 0x9f, 0x7a, 0xcd, 0x86, 0xb5, 0xf0, 0x27,
		0x9f, 0xd6, 0x34, 0x29, 0xee, 0x8a, 0x3a, 0xaf, 0x69, 0xf9, 0xb0, 0x21, 0xb1, 0xd3, 0x50, 0x9a,
		0xd9, 0xe4, 0xf5, 0x5c, 0x6e, 0x76, 0x3d, 0x67, 0x58, 0xdd, 0xb7, 0x6c, 0x6e, 0xd3, 0xe4, 0xa7,
		0x15, 0x67, 0x37, 0x55, 0x68, 0x66, 0x37, 0x2d, 0x1e, 0x0e, 0x99, 0xdf, 0xb1, 0x4d, 0x0b, 0x87,
		0x3b, 0x12, 0x4f, 0x6c, 0x9a, 0xb8, 0xb6, 0xf4, 0xe5, 0x67, 0x93, 0x8b, 0x8a, 0x31, 0x91, 0x22,
		0xdd, 0x9c, 0xd0, 0xe2, 0xd5, 0x9f, 0xa5, 0x9a, 0x03, 0x9a, 0x51, 0xe9, 0x99, 0x50, 0x05, 0x4f,
		0x7c, 0x39, 0x02, 0x55, 0x3b, 0x18, 0x46, 0x6b, 0x60, 0x18, 0x2d, 0x15, 0xb8, 0x13, 0x6f, 0xf8,
		0x27, 0xd3, 0xe8, 0x6f, 0xb2, 0xc1, 0xdf, 0xd0, 0xde, 0x0b, 0xe9, 0x3d, 0x4b, 0x23, 0x4c, 0xa8,
		0x89, 0x9f, 0x54, 0xf3, 0xbe, 0xbc, 0x17, 0x83, 0x82, 0x2f, 0x33, 0xe7, 0x4b, 0xf1, 0x12, 0xd0,
		0x67, 0xcb, 0x69, 0x4b, 0x05, 0x53, 0xc6, 0x35, 0xa0, 0xf1, 0x16, 0x9b, 0x11, 0x1b, 0x15, 0x23,
		0x6b, 0x1d, 0xbe, 0xcb, 0x7c, 0x86, 0x45, 0x85, 0xc8, 0x5e, 0xd2, 0x37, 0xb9, 0x92, 0x84, 0x3e,
		0xa1, 0xd9, 0xe9, 0x6f, 0xa9, 0xfb, 0x03, 0x32, 0xfa, 0x24, 0xf7, 0x41, 0x46, 0xdf, 0xd2, 0x23,
		0xa6, 0x9b, 0xc5, 0x5e, 0x84, 0x53, 0xdf, 0xa0, 0x64, 0x25, 0xb5, 0xae, 0x0c, 0x1b, 0xd4, 0x91,
		0x01, 0xca, 0x78, 0x83, 0x94, 0xf1, 0x7a, 0xd4, 0x9a, 0x06, 0xce, 0xff, 0x54, 0xba, 0xbb, 0x0f,
		0x56, 0x83, 0xb7, 0xc1, 0xdb, 0x00, 0xda, 0x00, 0xda, 0x00, 0xda, 0x00, 0xda, 0x00, 0xda, 0x4a,
		0xca, 0x98, 0x7b, 0xbe, 0xf5, 0xc8, 0x4c, 0xdb, 0xeb, 0x74, 0x3d, 0x97, 0xa5, 0x88, 0xc6, 0x2d,
		0x40, 0x27, 0x6f, 0xb7, 0x82, 0x9a, 0x86, 0x9a, 0x5e, 0x33, 0x35, 0xbd, 0xe2, 0x79, 0x4d, 0xbb,
		0x9e, 0x6d, 0x76, 0xdb, 0x16, 0x6f, 0x79, 0x7e, 0xe7, 0x63, 0xcc, 0x68, 0xc1, 0xfc, 0x5f, 0x4f,
		0xfd, 0x36, 0x7d, 0xfc, 0x47, 0xaf, 0xc0, 0xe9, 0x71, 0xa7, 0xed, 0xfc, 0x8f, 0x29, 0x14, 0x22,
		0xc5, 0x3b, 0x40, 0xbc, 0x40, 0xbc, 0xc0, 0x0a, 0x80, 0x15, 0x00, 0x2b, 0x00, 0x56, 0x00, 0xac,
		0x00, 0xb9, 0x4f, 0xe6, 0xa6, 0x3a, 0x61, 0x22, 0x8d, 0x73, 0xf2, 0x2f, 0xc2, 0xd3, 0x3b, 0xd2,
		0x26, 0xaa, 0x0e, 0x1e, 0x71, 0x15, 0x3e, 0x6e, 0xe2, 0x67, 0x91, 0x49, 0x1d, 0xba, 0x13, 0xa1,
		0xa3, 0x49, 0x1c, 0x29, 0x62, 0x19, 0x62, 0xe3, 0x37, 0xc4, 0xc7, 0x6e, 0x90, 0x8c, 0xdb, 0x10,
		0x1b, 0xb3, 0xb1, 0xb2, 0x2c, 0xf1, 0x04, 0x32, 0x24, 0xcc, 0x17, 0x9f, 0x4b, 0x78, 0x05, 0xcd,
		0x1b, 0x5f, 0x9e, 0x7b, 0x2d, 0x77, 0x32, 0x2a, 0xe9, 0xe3, 0x2e, 0xef, 0x2e, 0xcf, 0x1a, 0x1f,
		0x7c, 0x48, 0x31, 0x59, 0x7c, 0x0f, 0xc9, 0xe2, 0x59, 0x25, 0x8b, 0xdb, 0xa3, 0x33, 0x4f, 0x99,
		0x27, 0x9e, 0x6a, 0x0e, 0x3b, 0x52, 0xc4, 0x69, 0xed, 0xb5, 0x3c, 0xa7, 0x88, 0x0f, 0xe7, 0xdd,
		0x9a, 0x2e, 0xef, 0x9a, 0x56, 0x2f, 0x94, 0x6a, 0x82, 0x69, 0xa9, 0x6f, 0x37, 0x48, 0x9b, 0x8e,
		0x28, 0x31, 0x28, 0x57, 0x64, 0x30, 0x6e, 0x03, 0x09, 0xec, 0x19, 0xba, 0x34, 0x90, 0xc0, 0x2e,
		0x37, 0x3e, 0x56, 0x70, 0x5c, 0x2c, 0x4d, 0xfe, 0xb9, 0xe8, 0xac, 0x6c, 0xc9, 0xd9, 0xd8, 0x60,
		0x71, 0xb0, 0x38, 0x58, 0x7c, 0x35, 0x2c, 0x3e, 0xd0, 0xc6, 0x41, 0x48, 0x28, 0xa6, 0xd5, 0x6c,
		0xfa, 0x2c, 0x08, 0x24, 0xca, 0xc0, 0x66, 0xf7, 0x00, 0xc3, 0x81, 0xe1, 0x32, 0x66, 0x38, 0xa7,
		0x2b, 0x48, 0x7d, 0x53, 0x3c, 0x77, 0x2c, 0xb0, 0x26, 0xfa, 0x8e, 0x99, 0x35, 0xc2, 0x71, 0xba,
		0xcf, 0x07, 0x12, 0xef, 0x36, 0xf3, 0x8e, 0x1f, 0xe4, 0x82, 0xa6, 0x9c, 0xf9, 0xae, 0x74, 0x64,
		0xa3, 0xb4, 0xf5, 0x6d, 0xcf, 0x3c, 0x6e, 0xbc, 0x7e, 0x2b, 0x9b, 0xc7, 0x8d, 0xe1, 0x8f, 0xe5,
		0xf0, 0x8f, 0x5f, 0x95, 0xfe, 0x6b, 0xe5, 0xdb, 0x9e, 0x79, 0x10, 0xfd, 0xb6, 0x52, 0xfd, 0xb6,
		0x67, 0x56, 0x1b, 0xdb, 0x5b, 0x77, 0x77, 0xef, 0x45, 0xd7, 0x6c, 0xff, 0xda, 0xef, 0x8b, 0xc7,
		0xb1, 0x1a, 0x32, 0xc7, 0x71, 0x79, 0x73, 0xf6, 0x6f, 0xe5, 0x33, 0xf9, 0xef, 0x56, 0x56, 0xa7,
		0xb2, 0xfd, 0x8f, 0x52, 0xbe, 0xda, 0xd3, 0xaa, 0xb1, 0xc1, 0x61, 0x71, 0xd9, 0x20, 0xbc, 0x3d,
		0xcb, 0x6c, 0xd5, 0xcc, 0xcf, 0x8d, 0x5f, 0xe5, 0x9d, 0x83, 0xfe, 0xc7, 0xed, 0x5f, 0x47, 0xfd,
		0xb7, 0xbf, 0x7c, 0x9d, 0xf7, 0xb1, 0xf2, 0xce, 0x51, 0xff, 0x63, 0xc2, 0xbf, 0x1c, 0xf6, 0x3f,
		0xa6, 0xdc, 0xa3, 0xda, 0xdf, 0x9a, 0xf9, 0xe8, 0xe0, 0xf7, 0x95, 0xa4, 0x05, 0x07, 0x09, 0x0b,
		0xf6, 0x93, 0x16, 0xec, 0x27, 0x2c, 0x48, 0xfc, 0x4a, 0x95, 0x84, 0x05, 0xd5, 0xfe, 0xeb, 0xcc,
		0xe7, 0xb7, 0xe6, 0x7f, 0xf4, 0xb0, 0xbf, 0xfd, 0x9a, 0xf4, 0x6f, 0x47, 0xfd, 0xd7, 0x8f, 0xdb,
		0xdb, 0x05, 0x14, 0x0c, 0x20, 0x93, 0xec, 0xc9, 0x44, 0xbf, 0xa0, 0xa4, 0xee, 0x89, 0x56, 0xd0,
		0x26, 0x42, 0x2e, 0xef, 0xee, 0xa6, 0x72, 0x2e, 0x0b, 0x84, 0x3d, 0x2e, 0x78, 0xf7, 0x3e, 0x32,
		0x0e, 0x34, 0x0c, 0xf8, 0x1e, 0xd8, 0x37, 0xdf, 0xd9, 0x4b, 0x90, 0xde, 0x79, 0x1e, 0xaf, 0x80,
		0xfb, 0x1c, 0xee, 0xf3, 0x29, 0x22, 0x92, 0xb3, 0xae, 0x07, 0x0b, 0x35, 0xf7, 0x73, 0x80, 0x49,
		0xbd, 0xae, 0x26, 0xb5, 0x70, 0x3f, 0x87, 0x94, 0xa1, 0xc2, 0xc4, 0x6b, 0x4e, 0x2d, 0xdd, 0x15,
		0x08, 0x57, 0x9a, 0x80, 0x55, 0x08, 0x59, 0x9d, 0xa0, 0x55, 0x09, 0x9b, 0x8c, 0xc0, 0xc9, 0x08,
		0x9d, 0x84, 0xe0, 0xc5, 0x31, 0x92, 0x84, 0xe9, 0x29, 0xcc, 0x08, 0xf1, 0xc2, 0xef, 0xec, 0xc5,
		0x94, 0x18, 0xfb, 0x30, 0x43, 0x2e, 0xd1, 0x3e, 0x92, 0x07, 0x2c, 0x97, 0x7b, 0xad, 0xcc, 0x28,
		0x14, 0x0c, 0x43, 0xc7, 0x38, 0x54, 0x0c, 0x44, 0xce, 0x48, 0xe4, 0x0c, 0x45, 0xca, 0x58, 0x72,
		0x0c, 0x26, 0xc9, 0x68, 0xf2, 0xce, 0xdc, 0x44, 0x7a, 0xe9, 0x39, 0x2e, 0x2f, 0x1f, 0xaa, 0xd0,
		0x4b, 0xc4, 0x3d, 0x87, 0x0a, 0x5b, 0xa8, 0xe5, 0x78, 0xcb, 0x7b, 0xc0, 0x66, 0xbe, 0x08, 0x45,
		0xce, 0x77, 0xbc, 0x19, 0x51, 0xee, 0x77, 0xbc, 0x1f, 0x75, 0x36, 0xf2, 0x98, 0x16, 0xa8, 0xb2,
		0x92, 0x15, 0xc9, 0x7a, 0xfa, 0x2a, 0x08, 0x72, 0xc3, 0x67, 0xae, 0xe2, 0xb0, 0x5a, 0xdd, 0xaf,
		0x6e, 0xde, 0x75, 0xbc, 0x5b, 0xcd, 0xea, 0x46, 0x46, 0x49, 0xea, 0x12, 0xe4, 0x16, 0x22, 0x06,
		0xae, 0x22, 0x45, 0xa7, 0xb0, 0x47, 0xb8, 0x13, 0xd0, 0x07, 0xd0, 0x07, 0xd0, 0x87, 0x10, 0xbd,
		0x38, 0x4d, 0xe6, 0x72, 0x87, 0xbf, 0xc8, 0x15, 0xad, 0xce, 0x58, 0xb8, 0x0a, 0xa2, 0xbd, 0x74,
		0x16, 0x7d, 0x95, 0x4f, 0x56, 0x40, 0x40, 0x7e, 0xa3, 0x17, 0xbc, 0xb8, 0xbd, 0xba, 0xaf, 0x7d,
		0xbd, 0xfd, 0xe3, 0xfe, 0xf6, 0xef, 0xab, 0xba, 0x2a, 0x09, 0x86, 0x5a, 0x2c, 0x50, 0xc6, 0x49,
		0x34, 0x58, 0x69, 0xfe, 0x6b, 0x9e, 0x9f, 0x56, 0x4b, 0x2b, 0xd6, 0x57, 0x8d, 0xdc, 0x17, 0x55,
		0xc9, 0xea, 0xab, 0xe7, 0x08, 0xc5, 0x10, 0x28, 0xac, 0xe1, 0x56, 0xd0, 0x58, 0xd0, 0x58, 0xd0,
		0x58, 0x42, 0xf4, 0x22, 0xdd, 0xe5, 0x6c, 0x46, 0x59, 0x7d, 0xc8, 0x4a, 0xda, 0x68, 0x75, 0xfd,
		0x49, 0x96, 0x5e, 0xc6, 0xeb, 0x45, 0x82, 0x9b, 0xa3, 0xe0, 0xdf, 0xe8, 0x87, 0x5d, 0x29, 0x7f,
		0xb8, 0x21, 0x16, 0xfd, 0xbc, 0xe0, 0xdd, 0x3f, 0xd9, 0x4b, 0x10, 0xfd, 0x99, 0x2a, 0x18, 0x2a,
		0x7f, 0x03, 0x22, 0xbd, 0x2a, 0x24, 0x7d, 0xa7, 0x6a, 0x3e, 0x53, 0xf4, 0xa9, 0x58, 0x89, 0x4c,
		0x47, 0x9f, 0x0a, 0x91, 0xfb, 0x5e, 0x71, 0x1b, 0x9c, 0xf7, 0xef, 0x23, 0xc1, 0xb4, 0x1b, 0xb1,
		0x58, 0x2e, 0x3a, 0x69, 0x89, 0x0c, 0x3c, 0x98, 0xa3, 0xf5, 0xc4, 0xea, 0xdc, 0x0d, 0x8a, 0xb8,
		0x63, 0x05, 0xa2, 0x02, 0xa2, 0x62, 0xe1, 0x37, 0x44, 0xdc, 0x11, 0x76, 0x14, 0xec, 0xa8, 0x42,
		0xda, 0x51, 0x88, 0x3b, 0x4e, 0x7e, 0x11, 0xc4, 0x1d, 0x11, 0x77, 0x5c, 0xc3, 0xeb, 0x40, 0xdc,
		0x71, 0x2e, 0xf2, 0x40, 0xdc, 0x11, 0xe8, 0x03, 0xe8, 0x63, 0x95, 0xe8, 0x03, 0x71, 0x47, 0x61,
		0x2d, 0x86, 0xb8, 0xa3, 0x16, 0xad, 0x63, 0x20, 0xee, 0x08, 0x8d, 0x05, 0x8d, 0x05, 0x8d, 0xb5,
		0x84, 0x5e, 0x10, 0x77, 0x7c, 0x43, 0x13, 0xab, 0x8c, 0x3b, 0xca, 0xb8, 0xc3, 0x0d, 0xa5, 0xb0,
		0xa3, 0x40, 0xeb, 0x57, 0xf1, 0xf3, 0xa7, 0xad, 0x8a, 0x8a, 0x5a, 0xc3, 0x0a, 0xb9, 0x46, 0xc5,
		0x9a, 0xc4, 0x4e, 0xba, 0x4d, 0xc4, 0x9a, 0xc5, 0x4e, 0x5a, 0xf9, 0xca, 0x4d, 0x63, 0xe3, 0xcd,
		0x84, 0x9a, 0xc7, 0x8a, 0x1e, 0xa7, 0xee, 0xde, 0xc6, 0xf3, 0x08, 0x9c, 0xbe, 0xa3, 0xf1, 0x2c,
		0x49, 0x97, 0xd6, 0xbe, 0x16, 0x3b, 0x65, 0xad, 0xb2, 0xdc, 0x29, 0xea, 0x28, 0xc7, 0x0e, 0x98,
		0xff, 0xcc, 0x7c, 0x81, 0x6a, 0xec, 0xd1, 0x02, 0x14, 0x63, 0xa3, 0x18, 0x7b, 0x92, 0x84, 0x24,
		0x26, 0xeb, 0x0f, 0xd7, 0xa1, 0x14, 0x3b, 0x43, 0xe0, 0xbe, 0xd9, 0xa3, 0xf5, 0x05, 0x7b, 0xf2,
		0xcd, 0xdc, 0xb3, 0x5c, 0xbf, 0x24, 0xe4, 0x4f, 0xad, 0xc4, 0x36, 0x45, 0xfe, 0x94, 0xc8, 0x7d,
		0xe7, 0x26, 0x7f, 0x6a, 0xc4, 0x63, 0x39, 0x48, 0xa0, 0x42, 0xeb, 0x06, 0x48, 0x8b, 0x75, 0x94,
		0x16, 0xd2, 0x29, 0x54, 0xb2, 0x0a, 0x94, 0x48, 0x91, 0xc2, 0x29, 0x0c, 0xa7, 0xf0, 0xc6, 0x3b,
		0x85, 0x9f, 0xbc, 0x80, 0x53, 0xb8, 0x84, 0x8f, 0x15, 0xf6, 0x90, 0xea, 0xd9, 0xfb, 0xf6, 0x3f,
		0x82, 0x14, 0x2a, 0xa5, 0x6e, 0xc5, 0x3a, 0x4f, 0x88, 0xf6, 0xa4, 0xe8, 0x4e, 0x6c, 0xce, 0xc9,
		0x29, 0x75, 0x43, 0x5e, 0x7a, 0x86, 0x1f, 0x08, 0xf7, 0x54, 0x6d, 0x08, 0x9a, 0xb8, 0x71, 0x7e,
		0xbb, 0x2a, 0x27, 0xfd, 0xd7, 0xa0, 0x3c, 0x56, 0x8a, 0x66, 0xab, 0x89, 0xbb, 0xe7, 0xbb, 0x3b,
		0x73, 0xe2, 0xf9, 0x92, 0xec, 0xd4, 0xdf, 0xc9, 0x31, 0xdb, 0x1f, 0x82, 0xed, 0xd1, 0x1e, 0xb8,
		0x30, 0x5d, 0xa4, 0xd7, 0x46, 0x10, 0x82, 0xdc, 0x0a, 0xd1, 0x8d, 0x5a, 0xb3, 0x62, 0x78, 0xb7,
		0xda, 0xef, 0xa1, 0xa8, 0x98, 0x08, 0x91, 0x7b, 0xd3, 0xeb, 0x58, 0x8e, 0x6b, 0xa6, 0x98, 0x29,
		0x9b, 0xb5, 0xfe, 0x29, 0x7d, 0x61, 0xee, 0x63, 0xe8, 0x9c, 0xcc, 0x1d, 0x78, 0xa7, 0xac, 0x1c,
		0x89, 0x37, 0x8d, 0x47, 0x6a, 0xef, 0xd0, 0xee, 0xab, 0xab, 0x74, 0x61, 0x4c, 0x4a, 0xd4, 0x25,
		0x0c, 0xc4, 0xf0, 0xcd, 0xa0, 0xae, 0x30, 0x99, 0xb9, 0xb2, 0x4a, 0x75, 0x1f, 0x97, 0x46, 0x26,
		0x5a, 0x89, 0x04, 0x34, 0x81, 0x04, 0xa2, 0xc6, 0x22, 0xa5, 0xad, 0xad, 0xad, 0xad, 0x6f, 0x96,
		0xf9, 0xbf, 0x9a, 0xf9, 0x9f, 0x3d, 0xf3, 0xf8, 0xbe, 0x31, 0xf1, 0x97, 0xbb, 0x3b, 0xf3, 0xbe,
		0xb1, 0xfd, 0x6b, 0x6f, 0xe7, 0xb0, 0xdc, 0xdf, 0xfe, 0x6d, 0xfc, 0xfb, 0xc6, 0xdd, 0xdd, 0xfb,
		0xed, 0x7f, 0xca, 0xac, 0xfa, 0x6d, 0xfb, 0x75, 0xb0, 0xb6, 0x94, 0x8f, 0xa3, 0xd4, 0x81, 0xed,
		0x06, 0x98, 0x2e, 0xfb, 0x03, 0x25, 0x40, 0x33, 0x0d, 0x14, 0x69, 0xcd, 0xdc, 0xa5, 0x15, 0x04,
		0x9e, 0xed, 0x84, 0x69, 0x61, 0x44, 0xc5, 0x5a, 0x33, 0x3b, 0x4a, 0xfa, 0x8e, 0x65, 0x06, 0x7a,
		0xce, 0x6c, 0x72, 0x53, 0xbf, 0xfe, 0xab, 0x7e, 0x2d, 0x47, 0x3a, 0x0d, 0x84, 0x69, 0x10, 0xa6,
		0x11, 0xd8, 0x10, 0x61, 0x1a, 0xa3, 0xc4, 0xdc, 0x5e, 0x87, 0xf9, 0xc3, 0x2c, 0x53, 0x82, 0x68,
		0xcd, 0x81, 0xc2, 0x1e, 0x75, 0xb7, 0xd7, 0x19, 0xbc, 0x54, 0x9e, 0x4b, 0x8e, 0x9c, 0x87, 0x9e,
		0x1f, 0x70, 0x75, 0x99, 0x1b, 0xed, 0xb3, 0x4a, 0x49, 0x2b, 0x30, 0x4a, 0x19, 0x82, 0x16, 0x82,
		0x16, 0x82, 0x56, 0x8d, 0x5e, 0xc4, 0x47, 0x43, 0x27, 0x0a, 0xd9, 0x72, 0x8e, 0x05, 0x64, 0xd7,
		0xf3, 0x09, 0xc4, 0x63, 0xb8, 0xcb, 0x2a, 0x85, 0x63, 0xb9, 0xb2, 0x0f, 0xd1, 0x08, 0xd1, 0x08,
		0xd1, 0x98, 0x85, 0x68, 0x1c, 0x70, 0xbb, 0xe9, 0xf6, 0x3a, 0x0f, 0xa9, 0xab, 0x2c, 0x16, 0xb1,
		0x10, 0x9a, 0x2e, 0xbd, 0xdd, 0x0c, 0x4d, 0x97, 0x94, 0xae, 0x02, 0x4d, 0x97, 0xd0, 0x74, 0x49,
		0x23, 0x60, 0xf2, 0x59, 0x8b, 0xf9, 0x04, 0x90, 0x69, 0xb8, 0x0f, 0x2c, 0x4a, 0xc0, 0x26, 0xc0,
		0x26, 0x58, 0x94, 0xeb, 0x63, 0x51, 0x3e, 0x33, 0x3f, 0x90, 0x6d, 0xa5, 0x31, 0x75, 0x5e, 0xa3,
		0x8d, 0x56, 0x29, 0x22, 0x0f, 0x20, 0x1e, 0x21, 0x1e, 0x21, 0x1e, 0xb3, 0x10, 0x8f, 0x3d, 0xc7,
		0xe5, 0x1f, 0x08, 0x84, 0x63, 0x15, 0xf6, 0x64, 0x82, 0x11, 0x53, 0x86, 0x3d, 0x99, 0x17, 0x7b,
		0xf2, 0x00, 0xb6, 0xe4, 0xba, 0xd9, 0x92, 0x6b, 0xd3, 0xa2, 0x2c, 0xea, 0xc4, 0x13, 0xfd, 0x99,
		0xc9, 0x60, 0xa4, 0x9b, 0xe1, 0x23, 0xa3, 0x3f, 0x73, 0x34, 0x18, 0x09, 0xb3, 0x4e, 0x34, 0x83,
		0x3d, 0x14, 0xea, 0xaf, 0x40, 0x9a, 0xa0, 0x50, 0x1f, 0x76, 0x12, 0xec, 0x24, 0x14, 0xea, 0x4b,
		0xef, 0x81, 0x42, 0xfd, 0x4c, 0x4f, 0x8a, 0xee, 0xc4, 0xe6, 0x9c, 0x1c, 0x0a, 0xf5, 0x51, 0xa8,
		0x8f, 0x42, 0x7d, 0x12, 0xab, 0x51, 0x83, 0xfb, 0xc1, 0x40, 0xa1, 0x3e, 0x0a, 0xf5, 0x51, 0xa8,
		0xbf, 0x3e, 0x82, 0x10, 0xe4, 0x86, 0x42, 0x7d, 0x14, 0xea, 0xa3, 0x50, 0x5f, 0xe5, 0x9b, 0xa1,
		0x50, 0x7f, 0x8a, 0x94, 0x50, 0xa8, 0x8f, 0x42, 0x7d, 0x42, 0xd1, 0x6a, 0xa0, 0x50, 0x1f, 0x85,
		0xfa, 0xa9, 0x31, 0x1d, 0x0a, 0xf5, 0xb5, 0x3f, 0x17, 0x85, 0xfa, 0x28, 0xd4, 0x97, 0x63, 0x7a,
		0x84, 0x69, 0xd2, 0x6c, 0x88, 0x30, 0xcd, 0x5b, 0x77, 0x3d, 0x0a, 0xf5, 0xb3, 0x96, 0xbe, 0x28,
		0xd4, 0x87, 0xa0, 0x85, 0xa0, 0x85, 0xa0, 0x15, 0xa7, 0x97, 0x0d, 0x29, 0xab, 0xf0, 0x5a, 0xad,
		0x80, 0x11, 0x08, 0xc8, 0x68, 0x1f, 0x08, 0x1a, 0x08, 0x1a, 0x08, 0x1a, 0x21, 0x7a, 0xe9, 0x39,
		0x2e, 0x3f, 0x3c, 0x20, 0x90, 0x33, 0x1f, 0x50, 0xa1, 0x90, 0xe0, 0xc8, 0x44, 0xc5, 0xbb, 0xd4,
		0x55, 0xe8, 0xa8, 0x50, 0x50, 0x9b, 0x63, 0xbc, 0x2e, 0xb7, 0x03, 0x3f, 0xd9, 0xcc, 0x21, 0x77,
		0xbd, 0x76, 0xdb, 0x74, 0x5c, 0xce, 0xfc, 0x67, 0xab, 0x4d, 0xd1, 0x3a, 0x68, 0x72, 0x3b, 0xc0,
		0x12, 0xc0, 0x12, 0xc0, 0x12, 0x61, 0x58, 0xb2, 0x5f, 0x21, 0x80, 0x25, 0x47, 0x80, 0x25, 0x80,
		0x25, 0x79, 0x87, 0x25, 0x07, 0x95, 0xe3, 0x83, 0xe3, 0xc3, 0xa3, 0xca, 0x31, 0xc0, 0x08, 0xc0,
		0x08, 0xda, 0x17, 0xc2, 0x61, 0x0c, 0xc0, 0x04, 0xc0, 0x24, 0xce, 0xed, 0x68, 0x5f, 0x08, 0xd4,
		0x84, 0xf6, 0x85, 0x00, 0x4c, 0x9b, 0x07, 0x98, 0xd0, 0xbe, 0x10, 0xb0, 0x09, 0xb0, 0x09, 0xb0,
		0x49, 0x98, 0x5e, 0x36, 0x24, 0xce, 0xee, 0x7b, 0x1e, 0x37, 0x9b, 0xac, 0x6d, 0xbd, 0xa8, 0x0b,
		0xc9, 0x89, 0xbd, 0x20, 0x70, 0x20, 0x70, 0x20, 0x70, 0x84, 0xe8, 0x05, 0x8e, 0xed, 0xff, 0x3f,
		0x7b, 0xd7, 0xd7, 0xdb, 0xb6, 0xf1, 0x6c, 0xdf, 0xfd, 0x29, 0x08, 0xa2, 0x0f, 0xd6, 0x6d, 0x18,
		0x4b, 0xb2, 0x25, 0xd7, 0x7e, 0x29, 0xdc, 0xb4, 0x05, 0x2e, 0xd0, 0xde, 0x04, 0x4d, 0x6e, 0xf1,
		0x43, 0x65, 0x35, 0xa0, 0xa5, 0x95, 0x43, 0x44, 0x22, 0x0d, 0x92, 0x4a, 0x93, 0xda, 0xfa, 0xee,
		0x3f, 0xe8, 0xff, 0x7f, 0x71, 0x67, 0x76, 0x96, 0xa2, 0xa4, 0x93, 0x97, 0x38, 0x8e, 0xb8, 0x22,
		0x87, 0x33, 0x73, 0xe6, 0xcc, 0xee, 0x9e, 0x05, 0x45, 0x43, 0x63, 0x1b, 0x3c, 0xad, 0x68, 0x3c,
		0x8d, 0x99, 0x18, 0xd5, 0xd7, 0x34, 0xf6, 0xbd, 0x7e, 0x98, 0xa4, 0xfe, 0x43, 0xd7, 0x30, 0x45,
		0x8e, 0xc8, 0x97, 0x0a, 0x5b, 0x85, 0x12, 0xe1, 0xf9, 0xe3, 0xd7, 0x37, 0x4e, 0xed, 0xa6, 0x5c,
		0x73, 0x3c, 0xe7, 0xff, 0x54, 0xfa, 0x4f, 0x14, 0x7f, 0x76, 0x3e, 0x04, 0x3d, 0xe5, 0xbc, 0x8b,
		0xa3, 0x34, 0x6a, 0x45, 0x5d, 0xe7, 0xcf, 0xb1, 0xa0, 0xb3, 0x73, 0x75, 0x3b, 0xff, 0x9d, 0x1f,
		0xb6, 0xef, 0xc3, 0xbb, 0xee, 0x63, 0x14, 0x07, 0xe9, 0xa7, 0x5e, 0xe2, 0xbc, 0x7f, 0x52, 0xad,
		0xa0, 0x13, 0xb4, 0x4c, 0x17, 0xce, 0x4b, 0xd7, 0x0c, 0x9b, 0x6a, 0x87, 0xf9, 0x5b, 0x10, 0x8a,
		0x2c, 0xe9, 0x32, 0x62, 0x63, 0x39, 0x61, 0xe1, 0x35, 0xa1, 0x53, 0x63, 0x8d, 0x88, 0x04, 0xc9,
		0x93, 0x94, 0x9e, 0xfa, 0xea, 0x80, 0xa0, 0x24, 0xa0, 0x24, 0xa0, 0x24, 0x64, 0x4a, 0x82, 0x25,
		0xc0, 0xa0, 0x24, 0x58, 0x02, 0x0c, 0x72, 0x02, 0x72, 0x02, 0x72, 0x02, 0x72, 0x02, 0x72, 0x72,
		0x92, 0xe4, 0x24, 0x49, 0x63, 0x3f, 0x1d, 0xef, 0x2a, 0x37, 0x23, 0x25, 0xd3, 0x81, 0x40, 0x46,
		0x40, 0x46, 0x40, 0x46, 0xc8, 0x64, 0x04, 0x07, 0x26, 0x81, 0x8b, 0x9c, 0x04, 0x17, 0xa9, 0xd6,
		0x40, 0x3d, 0x40, 0x3d, 0x40, 0x3d, 0x40, 0x3d, 0x40, 0x3d, 0x4e, 0x9b, 0x7a, 0xe0, 0x7c, 0x59,
		0xac, 0x5f, 0x05, 0x5d, 0x02, 0x5d, 0x02, 0x5d, 0x2a, 0x1a, 0x5d, 0xc2, 0xf9, 0xb2, 0x85, 0xa1,
		0x4b, 0x38, 0x5f, 0xf6, 0xe8, 0x4a, 0xa5, 0x63, 0x3d, 0x5f, 0x96, 0x73, 0x46, 0xaa, 0x63, 0x74,
		0xbc, 0xec, 0xfb, 0xd1, 0x37, 0xda, 0x3a, 0x5d, 0xf6, 0x4c, 0xf0, 0xfd, 0x0c, 0x4b, 0x0b, 0xfa,
		0x71, 0x99, 0xee, 0x6f, 0x41, 0x92, 0xde, 0xa5, 0x29, 0x6d, 0x9b, 0xd7, 0x10, 0x13, 0x7e, 0xe9,
		0xaa, 0x61, 0x99, 0x40, 0x0c, 0xf4, 0x61, 0x0a, 0x5b, 0xb8, 0xd2, 0x6c, 0xda, 0xd8, 0x7d, 0x1b,
		0xb7, 0x55, 0xac, 0xda, 0x3f, 0x0d, 0x1f, 0x3c, 0xec, 0x77, 0xbb, 0xa2, 0xf6, 0x64, 0xfa, 0xb9,
		0x81, 0x7f, 0xbb, 0xa4, 0xd3, 0x86, 0x79, 0x1e, 0xad, 0xe7, 0xcb, 0xd9, 0x9e, 0xb9, 0xfb, 0x13,
		0x19, 0x36, 0xa6, 0xda, 0x96, 0x63, 0x53, 0x0d, 0x63, 0xd2, 0x8d, 0xb8, 0xdb, 0x7a, 0xdb, 0x6d,
		0xb2, 0xc3, 0x1e, 0x9a, 0xe7, 0x46, 0x93, 0xce, 0x89, 0xd6, 0x3c, 0x17, 0x5a, 0xfb, 0x1c, 0x68,
		0x0a, 0x19, 0xa3, 0x93, 0x2e, 0x2a, 0xb9, 0x62, 0x93, 0x28, 0x36, 0x59, 0x62, 0x91, 0x22, 0xb3,
		0x08, 0xd1, 0x3d, 0x77, 0xd9, 0xf5, 0xfb, 0xe9, 0x27, 0xaf, 0x17, 0x24, 0x3d, 0x3f, 0x6d, 0x7d,
		0xd2, 0xb7, 0xe1, 0xec, 0xe0, 0x81, 0xa5, 0xcb, 0x75, 0xa1, 0x86, 0xd4, 0x1b, 0x20, 0xf7, 0x02,
		0x38, 0xdc, 0x9f, 0xcf, 0xf5, 0xb9, 0xdc, 0xde, 0x98, 0xcb, 0x1b, 0x73, 0x77, 0x23, 0xae, 0x2e,
		0x5b, 0x7c, 0x90, 0xb9, 0xf7, 0xec, 0x7d, 0xb5, 0xa2, 0x7e, 0x98, 0xaa, 0x98, 0xb4, 0x54, 0x92,
		0xb1, 0x34, 0x92, 0xc9, 0xa7, 0x19, 0xf5, 0xad, 0x09, 0x5f, 0x36, 0x9d, 0x4e, 0x14, 0x23, 0x61,
		0xe6, 0xa4, 0x8b, 0xd3, 0xaf, 0x35, 0xe1, 0xb7, 0x16, 0x96, 0x22, 0x16, 0xc9, 0x9a, 0x96, 0x28,
		0x48, 0x53, 0xaa, 0x1c, 0xd4, 0x80, 0x79, 0x15, 0xfa, 0x0f, 0x5d, 0xe5, 0x85, 0xe9, 0x93, 0x37,
		0x44, 0x1d, 0x3a, 0x56, 0xad, 0x0e, 0xa0, 0x99, 0x9b, 0x38, 0xdd, 0x77, 0x8a, 0x62, 0x44, 0x13,
		0xa8, 0x09, 0xd4, 0xcc, 0x19, 0x35, 0xe9, 0x0a, 0x0b, 0x44, 0x45, 0x05, 0xc9, 0x90, 0x6f, 0x73,
		0x43, 0xbd, 0x8d, 0x10, 0x47, 0x88, 0x23, 0xc4, 0x0b, 0x1d, 0xe2, 0x43, 0x34, 0x4e, 0x46, 0x8e,
		0x32, 0x3b, 0x24, 0x9e, 0x1c, 0xed, 0x1b, 0xc6, 0x40, 0xc0, 0x21, 0xe0, 0x72, 0x0e, 0xb8, 0xe0,
		0x89, 0xe8, 0x7d, 0x4b, 0x31, 0x77, 0x43, 0xb8, 0x66, 0x72, 0x8f, 0xd6, 0xa9, 0xe8, 0xfc, 0xc9,
		0xbe, 0x5c, 0x31, 0x9e, 0x6d, 0xed, 0x19, 0x19, 0x5b, 0x11, 0x8d, 0x0f, 0xa6, 0x75, 0x47, 0x87,
		0xc1, 0x37, 0x5f, 0x1a, 0x15, 0xef, 0xa6, 0x39, 0xfe, 0xb1, 0x32, 0xfa, 0xeb, 0xb9, 0x3a, 0x78,
		0xa9, 0x36, 0xca, 0xde, 0xd5, 0xe4, 0xb7, 0xd5, 0x5a, 0xa3, 0xec, 0xd5, 0x9a, 0xa5, 0xf3, 0xfb,
		0xfb, 0xd7, 0xd4, 0x6b, 0x4a, 0xcf, 0x97, 0x03, 0xfa, 0x32, 0x87, 0x26, 0xc7, 0x1c, 0x12, 0x87,
		0xcb, 0xba, 0x7f, 0x9f, 0xe7, 0x65, 0x15, 0xce, 0x11, 0xb2, 0x4d, 0x9b, 0xf3, 0x8f, 0x66, 0x61,
		0x50, 0x3f, 0xdc, 0x30, 0x18, 0xbd, 0x3d, 0xdf, 0xeb, 0xdc, 0x79, 0xbf, 0x36, 0x9f, 0x2b, 0xaf,
		0xae, 0x06, 0xb7, 0xa5, 0xe7, 0xeb, 0xc1, 0xea, 0x2f, 0x5f, 0x36, 0x7d, 0xac, 0xf2, 0xea, 0x7a,
		0x70, 0xbb, 0xe5, 0x7f, 0xea, 0x83, 0x5b, 0xcd, 0x31, 0x6a, 0x83, 0xf3, 0xb5, 0x8f, 0x0e, 0x7f,
		0x5f, 0xdd, 0x76, 0xc1, 0xd5, 0x96, 0x0b, 0x2e, 0xb7, 0x5d, 0x70, 0xb9, 0xe5, 0x82, 0xad, 0xb7,
		0x54, 0xdd, 0x72, 0x41, 0x6d, 0xf0, 0xb2, 0xf6, 0xf9, 0xf3, 0xcd, 0x1f, 0xad, 0x0f, 0x4a, 0x2f,
		0xdb, 0xfe, 0xef, 0x7a, 0xf0, 0x72, 0x5b, 0x2a, 0x1d, 0x60, 0x62, 0x80, 0x9b, 0xe4, 0xef, 0x26,
		0xf6, 0x13, 0x65, 0xfe, 0x5d, 0xbd, 0xe2, 0x4e, 0xf2, 0x6a, 0xae, 0x04, 0xa1, 0x4c, 0xf1, 0x66,
		0x2f, 0xf5, 0xd8, 0x31, 0xc1, 0x7b, 0x46, 0xb0, 0x90, 0xae, 0x65, 0x28, 0x16, 0x71, 0x77, 0xce,
		0x30, 0x6b, 0xda, 0x60, 0xf3, 0xd3, 0xaf, 0x3f, 0xdb, 0x86, 0xe7, 0x72, 0x87, 0x37, 0xd7, 0xe9,
		0x46, 0xff, 0x6c, 0x7d, 0xa2, 0x39, 0x2f, 0x9a, 0x7e, 0x72, 0x8b, 0x75, 0x76, 0x4f, 0x5e, 0x67,
		0x72, 0x38, 0x1d, 0xce, 0xa6, 0x7b, 0x2f, 0x14, 0x56, 0x46, 0x66, 0x61, 0x64, 0xd6, 0xb5, 0xcc,
		0xb2, 0xa6, 0x77, 0x2e, 0xe4, 0x93, 0x59, 0x13, 0xce, 0xae, 0xff, 0x38, 0xfe, 0x66, 0xcd, 0x75,
		0x0a, 0xe3, 0x8f, 0x0b, 0xaf, 0x53, 0x28, 0xdb, 0x58, 0xa7, 0x90, 0xed, 0x02, 0x5c, 0x82, 0xbe,
		0xef, 0x95, 0x0a, 0x99, 0x2e, 0x22, 0x93, 0xe8, 0xb5, 0xd7, 0x2a, 0xb4, 0xa6, 0xef, 0x91, 0xd8,
		0x1f, 0x9a, 0x5c, 0x47, 0xeb, 0x09, 0x55, 0x0a, 0xd9, 0x13, 0xd2, 0x77, 0xb6, 0x63, 0xeb, 0x0a,
		0x69, 0x3b, 0xa3, 0x9d, 0xbe, 0x90, 0xae, 0x93, 0xce, 0x2e, 0x78, 0xf0, 0x5b, 0x9f, 0xa3, 0x4e,
		0x87, 0x7f, 0x7e, 0xe1, 0xbc, 0x93, 0xbb, 0x3a, 0x12, 0xd1, 0x8c, 0xbc, 0xad, 0x38, 0xec, 0x2d,
		0x38, 0x26, 0x5b, 0x6f, 0x4c, 0x1c, 0xdd, 0xd4, 0xe1, 0xc5, 0x1c, 0x5f, 0x2c, 0x00, 0x84, 0x02,
		0x81, 0x4e, 0x00, 0x18, 0x7d, 0x15, 0xfe, 0xf6, 0x19, 0x73, 0x15, 0x66, 0x03, 0xf5, 0x65, 0xc3,
		0x7d, 0x32, 0x06, 0x9b, 0x85, 0x24, 0xf6, 0xc5, 0x48, 0xc9, 0x07, 0x88, 0x6f, 0xbe, 0x90, 0xdb,
		0x74, 0x61, 0xb0, 0xef, 0x45, 0x64, 0xbf, 0x8b, 0xb8, 0x6a, 0x72, 0x91, 0x6d, 0x9d, 0xd3, 0x06,
		0x13, 0x5b, 0x7d, 0x0b, 0x82, 0xaf, 0xb8, 0x6d, 0x3f, 0x1d, 0x31, 0x63, 0x2f, 0x68, 0xf3, 0x91,
		0x79, 0x71, 0x10, 0x80, 0x32, 0x40, 0xf9, 0x08, 0x41, 0x99, 0xef, 0xe2, 0xfb, 0x9f, 0xf3, 0xf8,
		0x7b, 0xb1, 0xdb, 0xba, 0xda, 0xc4, 0xad, 0x0e, 0x4a, 0xcf, 0xd7, 0x83, 0xef, 0x0e, 0xaa, 0x3b,
		0x6f, 0xe7, 0x79, 0x0a, 0x90, 0x8d, 0x3b, 0x7e, 0xd0, 0xed, 0xc7, 0xca, 0xeb, 0x45, 0x6d, 0xc5,
		0x4f, 0xc7, 0x4b, 0xa3, 0x20, 0x1f, 0x23, 0x1f, 0x1f, 0x61, 0x3e, 0x36, 0xf0, 0xf1, 0xa5, 0x84,
		0xcc, 0xd8, 0xb6, 0xed, 0xfe, 0x12, 0x8e, 0x75, 0x18, 0x07, 0x05, 0xc8, 0x18, 0x41, 0x38, 0xac,
		0xa2, 0xbf, 0x04, 0xe9, 0x37, 0xef, 0x29, 0x8e, 0x1e, 0x0c, 0xb2, 0xc6, 0xda, 0x48, 0xc8, 0x1c,
		0xc8, 0x1c, 0x68, 0xaf, 0xa0, 0xbd, 0x82, 0xf6, 0x0a, 0xda, 0x2b, 0x68, 0xaf, 0xf0, 0xe0, 0xb9,
		0xe7, 0x7f, 0xf5, 0x26, 0xf3, 0x16, 0x7c, 0x64, 0x5e, 0x1c, 0x04, 0xa0, 0x0c, 0x50, 0x06, 0x28,
		0x03, 0x94, 0x01, 0xca, 0x00, 0x65, 0x80, 0x32, 0xf5, 0x93, 0x45, 0x11, 0x2d, 0x9a, 0x26, 0xf2,
		0x8b, 0xd1, 0xf2, 0xae, 0x0b, 0xd2, 0xc2, 0x1c, 0x47, 0x7f, 0x2d, 0xe2, 0xdb, 0xc9, 0xd7, 0x7c,
		0xbc, 0x1b, 0x7e, 0xcd, 0xc7, 0x09, 0xaa, 0xe7, 0xb8, 0xab, 0x4d, 0x4f, 0x94, 0x67, 0x0d, 0x0d,
		0x28, 0x02, 0x65, 0xec, 0x75, 0x4a, 0x55, 0xac, 0x53, 0x92, 0x2d, 0x59, 0xb0, 0x4e, 0x09, 0xeb,
		0x94, 0x50, 0xb3, 0xa3, 0x66, 0x47, 0xcd, 0x8e, 0x9a, 0x1d, 0x35, 0x3b, 0x6a, 0x76, 0xd1, 0x46,
		0x1a, 0xd6, 0x29, 0x01, 0x94, 0x01, 0xca, 0x36, 0x5d, 0xdc, 0xc1, 0x3a, 0xa5, 0xf9, 0xa3, 0x60,
		0x9d, 0xd2, 0xce, 0x27, 0xc3, 0x3a, 0x25, 0xe4, 0x63, 0xe4, 0x63, 0xcb, 0x3e, 0xee, 0x60, 0x9d,
		0xd2, 0x26, 0x8b, 0x62, 0x9d, 0x12, 0x32, 0x07, 0xda, 0x2b, 0x68, 0xaf, 0xa0, 0xbd, 0x82, 0xf6,
		0x0a, 0xda, 0x2b, 0x42, 0xf0, 0x8c, 0x75, 0x4a, 0x00, 0x65, 0x80, 0x32, 0x40, 0x19, 0xa0, 0x0c,
		0x50, 0x06, 0x28, 0x63, 0x9d, 0xd2, 0xe6, 0x75, 0x4a, 0xd4, 0x83, 0x03, 0x79, 0xcb, 0x94, 0x08,
		0x87, 0x05, 0x1e, 0xaa, 0xf6, 0xde, 0xb2, 0x5d, 0xe5, 0x04, 0xf8, 0x96, 0x2d, 0x69, 0xe3, 0x98,
		0xb5, 0x56, 0x14, 0xa6, 0x71, 0xd4, 0xed, 0xaa, 0x38, 0xd1, 0x17, 0x31, 0x5b, 0xbc, 0x08, 0x52,
		0x66, 0x90, 0x32, 0xdb, 0xe4, 0x4e, 0x2c, 0x39, 0xb3, 0xe9, 0xb5, 0x90, 0x34, 0xcb, 0x95, 0x3d,
		0x9c, 0xf8, 0x52, 0x41, 0xa2, 0xfe, 0xde, 0x26, 0xc7, 0xa5, 0x2d, 0xf7, 0x65, 0x38, 0x2f, 0x28,
		0x32, 0x28, 0x32, 0x87, 0x22, 0x53, 0x83, 0x61, 0x76, 0xe1, 0xa4, 0x34, 0x61, 0xbe, 0xac, 0xd9,
		0x11, 0x26, 0xc3, 0xbf, 0x99, 0xe6, 0xe5, 0xf5, 0x90, 0x8c, 0x03, 0x45, 0x22, 0x60, 0x24, 0x03,
		0x47, 0x2a, 0x80, 0xc4, 0x03, 0x49, 0x3c, 0xa0, 0x84, 0x03, 0xcb, 0x90, 0x62, 0x32, 0xbd, 0x86,
		0xdd, 0x93, 0x5a, 0xf3, 0x99, 0x24, 0x8d, 0x83, 0xf0, 0xd1, 0xc4, 0x63, 0x66, 0xab, 0x7f, 0x70,
		0xc2, 0x3e, 0x87, 0xcc, 0x2d, 0xd0, 0x9c, 0x85, 0x9f, 0x2f, 0x58, 0x70, 0xcf, 0x21, 0x7d, 0x6f,
		0xe6, 0xdf, 0xbf, 0xf0, 0x33, 0x69, 0xdb, 0x0f, 0xa3, 0xa1, 0xf1, 0x8a, 0x54, 0x38, 0x85, 0x6a,
		0xd4, 0x58, 0x4a, 0x8c, 0xaa, 0xa7, 0xd9, 0x20, 0x28, 0xa1, 0x50, 0x42, 0x1d, 0x4f, 0x09, 0x35,
		0xf7, 0x6c, 0xf3, 0x42, 0x6a, 0x61, 0x2c, 0xb3, 0x72, 0xaa, 0x82, 0x72, 0x0a, 0xe5, 0xd4, 0xe1,
		0x94, 0x53, 0xdc, 0xe0, 0x9b, 0x0d, 0xe0, 0xf7, 0xbf, 0x72, 0xf6, 0x18, 0x6c, 0x75, 0xbd, 0xc9,
		0x78, 0x86, 0xaf, 0xc4, 0x8c, 0xdb, 0x88, 0x05, 0xa5, 0x64, 0x70, 0xda, 0x08, 0x52, 0xe9, 0x60,
		0xb5, 0x16, 0xb4, 0xd6, 0x82, 0xd7, 0x52, 0x10, 0x9b, 0x05, 0xb3, 0x61, 0x50, 0xcb, 0x71, 0xa5,
		0x35, 0x9f, 0xeb, 0x2a, 0xbf, 0x13, 0xab, 0x8e, 0x84, 0xcb, 0x4d, 0xf1, 0xf2, 0x5a, 0x60, 0xac,
		0x77, 0x13, 0xd2, 0xf1, 0xfa, 0xf5, 0x84, 0x3d, 0x5c, 0x4c, 0xd2, 0xc8, 0xd9, 0x7e, 0x5e, 0x9e,
		0xc9, 0x0c, 0x37, 0xb3, 0x5b, 0x2a, 0xdb, 0x3d, 0x15, 0xae, 0x6e, 0x90, 0x50, 0x91, 0x50, 0x8f,
		0x21, 0xa1, 0x9a, 0x56, 0x4b, 0xf3, 0xaa, 0x89, 0x78, 0x66, 0xb5, 0x7e, 0xf9, 0xc4, 0x3e, 0x67,
		0xd4, 0x62, 0x1d, 0x25, 0x1e, 0xfe, 0x36, 0xd2, 0x80, 0xcd, 0x74, 0x60, 0x2b, 0x2d, 0x58, 0x4f,
		0x0f, 0xd6, 0xd3, 0x84, 0xe5, 0x74, 0x21, 0x93, 0x36, 0x84, 0xd2, 0x87, 0x7c, 0x5d, 0xb6, 0xe6,
		0xb3, 0xac, 0xc3, 0xc4, 0xb5, 0xc1, 0xff, 0x46, 0x70, 0x4c, 0xd6, 0x61, 0xe4, 0x59, 0x7f, 0x64,
		0xa3, 0xca, 0x11, 0x3c, 0xcc, 0x5c, 0xdb, 0xc6, 0x3f, 0x58, 0x18, 0xdb, 0x74, 0x67, 0x6e, 0xe6,
		0x17, 0x14, 0xf7, 0xb0, 0xf4, 0xac, 0x3f, 0x4d, 0x1b, 0xe6, 0x96, 0xd8, 0x0d, 0x9d, 0xf9, 0x2d,
		0xc5, 0x3e, 0x8c, 0x3d, 0xd3, 0xee, 0xa2, 0x23, 0x0e, 0x5e, 0x1d, 0x50, 0x1a, 0xa9, 0x23, 0x8d,
		0x6c, 0x4b, 0x23, 0x38, 0x45, 0xfc, 0x60, 0x0e, 0x9b, 0x3f, 0xfa, 0xc4, 0x0a, 0x37, 0x3c, 0x88,
		0xc3, 0xec, 0x73, 0x06, 0x9a, 0xb3, 0x62, 0xdd, 0x97, 0xf9, 0xfd, 0x08, 0x40, 0xa7, 0xd4, 0x1c,
		0xd0, 0x7a, 0x33, 0x43, 0x62, 0x2e, 0x08, 0xbd, 0x0c, 0xf4, 0x32, 0xd0, 0xcb, 0x38, 0xc0, 0x5e,
		0x86, 0xdf, 0xff, 0x1a, 0x74, 0x03, 0x3f, 0xfe, 0x26, 0x97, 0x03, 0x16, 0xf3, 0x40, 0x4d, 0x70,
		0x48, 0xb3, 0x1d, 0xa7, 0x39, 0xd2, 0x10, 0x89, 0x1d, 0xaa, 0x5b, 0x07, 0x17, 0xda, 0xb9, 0xba,
		0x75, 0x7c, 0xe9, 0x5d, 0x96, 0xdb, 0x3d, 0x50, 0x6a, 0xf7, 0x65, 0x4e, 0x7c, 0xd5, 0x91, 0xda,
		0x19, 0x9b, 0xf9, 0x6a, 0x2b, 0x35, 0xbc, 0xdb, 0xdc, 0x4a, 0x44, 0x14, 0x9c, 0xdb, 0x5e, 0x62,
		0x4b, 0xc5, 0x69, 0xd0, 0x09, 0x5a, 0x7e, 0xaa, 0xac, 0x14, 0x9e, 0x2b, 0xe3, 0xa3, 0x00, 0x45,
		0x01, 0x8a, 0x02, 0xf4, 0xe4, 0x0a, 0x50, 0xe3, 0x0d, 0x22, 0xdb, 0xbb, 0xb3, 0x47, 0x94, 0x8b,
		0x9f, 0xa2, 0x38, 0x95, 0xcf, 0xc0, 0xa3, 0x51, 0x85, 0x3c, 0xe4, 0x67, 0xd5, 0xf1, 0xfb, 0xdd,
		0x54, 0xb4, 0x3e, 0x77, 0xeb, 0xf5, 0xda, 0xa5, 0x4c, 0x48, 0x35, 0x01, 0x2f, 0x80, 0x17, 0xc0,
		0xcb, 0xc9, 0xc1, 0xcb, 0x30, 0xc5, 0x79, 0x61, 0xbf, 0xf7, 0xa0, 0x2d, 0xc8, 0x40, 0x49, 0x03,
		0x75, 0xb4, 0x37, 0xd0, 0xde, 0x40, 0x7b, 0x83, 0xf6, 0x6a, 0xeb, 0xb5, 0xda, 0x25, 0x3a, 0x1c,
		0xe8, 0x70, 0x14, 0xa0, 0xaa, 0x8e, 0x83, 0x28, 0x0e, 0xd2, 0x6f, 0x16, 0x2a, 0xeb, 0xe9, 0xc8,
		0x28, 0x3b, 0x51, 0x76, 0xa2, 0xec, 0x3c, 0xb9, 0xb2, 0xb3, 0x1f, 0x84, 0xe9, 0x0f, 0x98, 0x4f,
		0x43, 0xc1, 0x89, 0x82, 0x73, 0xff, 0x05, 0x67, 0xb5, 0x86, 0x72, 0x13, 0xe5, 0xe6, 0xfe, 0xcb,
		0xcd, 0x64, 0x54, 0x74, 0x8c, 0x8f, 0xe0, 0xed, 0xf8, 0x92, 0x1b, 0x17, 0x67, 0xcd, 0xf4, 0xd5,
		0x6f, 0x40, 0xf9, 0x89, 0xf2, 0x13, 0xe5, 0xe7, 0xc9, 0x95, 0x9f, 0x0f, 0x7e, 0xb2, 0x90, 0x05,
		0x3c, 0x19, 0x31, 0x81, 0xd5, 0x6c, 0x20, 0x21, 0x2a, 0x30, 0x8f, 0xe0, 0x99, 0xa2, 0x59, 0xcb,
		0x0b, 0x3a, 0xb7, 0xb3, 0x7b, 0x4f, 0x56, 0x7f, 0x31, 0xf9, 0xf7, 0x48, 0x7f, 0xec, 0x88, 0xb0,
		0x21, 0x8d, 0xfd, 0x30, 0xb1, 0x33, 0xcb, 0x37, 0x1f, 0xba, 0xc8, 0x53, 0x7d, 0x1f, 0xde, 0xbc,
		0xc3, 0x4c, 0x1f, 0x30, 0x0f, 0x98, 0x07, 0xcc, 0x2b, 0x46, 0x9a, 0x73, 0x0c, 0x4f, 0xba, 0xdc,
		0x3a, 0x26, 0xef, 0x04, 0x4c, 0x8b, 0xf0, 0xb5, 0x57, 0xb5, 0x0f, 0x43, 0x41, 0xd4, 0x75, 0x92,
		0x25, 0x27, 0x90, 0x3a, 0x55, 0xf4, 0x5c, 0xf8, 0xf9, 0x42, 0x44, 0xe8, 0xc7, 0x11, 0xd5, 0x51,
		0x9d, 0xde, 0xe6, 0xc2, 0xcf, 0x2c, 0x79, 0x55, 0x39, 0xbf, 0x30, 0x51, 0x66, 0x1a, 0x1f, 0xe7,
		0x22, 0x26, 0xcc, 0x44, 0x3d, 0x1d, 0x66, 0x67, 0x16, 0x90, 0xd2, 0x65, 0xaa, 0x42, 0x97, 0xa9,
		0x10, 0x10, 0x0f, 0x5d, 0x26, 0x52, 0xd9, 0x0f, 0x5d, 0x26, 0x30, 0x00, 0x30, 0x00, 0x30, 0x80,
		0xa2, 0x32, 0x00, 0xe8, 0x32, 0x09, 0xff, 0x81, 0x2e, 0x93, 0xce, 0x17, 0x40, 0x97, 0x69, 0xc9,
		0xdc, 0xd0, 0x65, 0xca, 0xb6, 0x3b, 0x74, 0x99, 0x90, 0x46, 0xd6, 0xd2, 0x08, 0x04, 0x71, 0xa0,
		0xcb, 0x54, 0x94, 0xc4, 0x0a, 0x37, 0x84, 0x2e, 0x93, 0x25, 0x1e, 0xe1, 0x40, 0x97, 0x49, 0xaf,
		0x99, 0x01, 0x5d, 0x26, 0xf4, 0x32, 0xd0, 0xcb, 0x38, 0xd1, 0x5e, 0x06, 0x74, 0x99, 0xb0, 0x8e,
		0x7c, 0x69, 0x7c, 0xac, 0x23, 0xdf, 0xf9, 0x6a, 0xa1, 0xcb, 0x54, 0x8c, 0x77, 0x8b, 0x82, 0xd3,
		0x7a, 0xc1, 0x09, 0x5d, 0x26, 0x14, 0xa0, 0x28, 0x40, 0x51, 0x80, 0x42, 0x97, 0xa9, 0x00, 0xb9,
		0x78, 0xbc, 0xe4, 0x4a, 0xd9, 0x48, 0xc3, 0xb3, 0xa1, 0x91, 0x81, 0x91, 0x81, 0x91, 0x81, 0x4f,
		0x2e, 0x03, 0x3f, 0x44, 0x51, 0x57, 0xf9, 0xa1, 0x8d, 0x14, 0x5c, 0x81, 0x34, 0x5e, 0x86, 0xf1,
		0x21, 0x8d, 0x07, 0x7c, 0x01, 0xbe, 0x00, 0x5f, 0x8e, 0x18, 0x5f, 0x20, 0x8d, 0x27, 0xde, 0x5f,
		0x43, 0x87, 0x59, 0xcb, 0x01, 0xd1, 0x61, 0xde, 0xf2, 0x6a, 0x21, 0x8d, 0x97, 0x5f, 0x82, 0x96,
		0x1f, 0x0d, 0xd2, 0x78, 0x5a, 0xb0, 0x03, 0x69, 0x3c, 0x94, 0x9d, 0x28, 0x3b, 0x4f, 0xb6, 0xec,
		0x84, 0x34, 0x1e, 0x0a, 0x4e, 0x14, 0x9c, 0x05, 0x29, 0x38, 0x21, 0x8d, 0x87, 0x72, 0xb3, 0x08,
		0xe5, 0x26, 0xa4, 0xf1, 0x50, 0x7e, 0xa2, 0xfc, 0x44, 0xf9, 0x69, 0xbf, 0xfc, 0x84, 0x34, 0xde,
		0xa1, 0x61, 0x03, 0xa4, 0xf1, 0x20, 0x8d, 0x07, 0xcc, 0x03, 0xe6, 0x01, 0xf3, 0x8a, 0x92, 0xe6,
		0x1c, 0x48, 0xe3, 0xe5, 0xe0, 0x18, 0x87, 0x26, 0x8d, 0x27, 0x21, 0xb5, 0xe6, 0x58, 0x57, 0xc6,
		0x7b, 0x3f, 0xba, 0xcb, 0x7d, 0x09, 0xe3, 0x9d, 0xe5, 0xe8, 0x47, 0xc3, 0xf4, 0x6f, 0xbc, 0x91,
		0xd4, 0xfd, 0x2d, 0x48, 0xd2, 0xbb, 0x34, 0x35, 0x93, 0xfe, 0x72, 0x7f, 0x0f, 0xc2, 0x5f, 0xba,
		0x6a, 0x98, 0xc9, 0x0d, 0x5b, 0x41, 0xee, 0xef, 0xfe, 0xd7, 0x85, 0x91, 0x2a, 0x3f, 0x5c, 0x5d,
		0xd5, 0xaf, 0xaf, 0xae, 0xca, 0xd7, 0x97, 0xd7, 0xe5, 0x9b, 0x5a, 0xad, 0x52, 0x37, 0xd9, 0xa4,
		0xe3, 0xbe, 0x8d, 0xdb, 0x2a, 0x56, 0xed, 0x9f, 0x86, 0x76, 0x0b, 0xfb, 0xdd, 0x6e, 0xae, 0xaf,
		0x4b, 0x28, 0xdc, 0x2d, 0x87, 0xb9, 0x6b, 0xa4, 0xed, 0x68, 0x2f, 0xb0, 0x79, 0x21, 0x4d, 0x0f,
		0x48, 0xda, 0x15, 0x44, 0x5f, 0x30, 0xf5, 0x01, 0x1b, 0xef, 0x9e, 0xf1, 0xc2, 0xe5, 0x5f, 0x34,
		0xed, 0xed, 0xea, 0xbf, 0x23, 0xc2, 0xfb, 0x71, 0x27, 0x8f, 0x43, 0x7b, 0x2b, 0xb3, 0x1a, 0x6c,
		0x74, 0x35, 0xd1, 0x1b, 0x78, 0x3c, 0x8b, 0xcd, 0xa7, 0x4c, 0x78, 0x93, 0x04, 0x3f, 0x32, 0xe5,
		0x41, 0x62, 0x7c, 0x47, 0x8c, 0xd7, 0x08, 0xf1, 0x17, 0xbb, 0x39, 0x87, 0xcd, 0x3b, 0x66, 0xef,
		0xbc, 0xab, 0xfc, 0x0e, 0xaf, 0x91, 0x66, 0xd2, 0x30, 0x9b, 0x35, 0xc6, 0x5e, 0xbf, 0x9e, 0xc8,
		0x32, 0x5f, 0xd0, 0x5b, 0x5f, 0x76, 0x52, 0x05, 0x4f, 0xc4, 0xd8, 0x48, 0xb4, 0x98, 0x29, 0x52,
		0xcc, 0x16, 0x25, 0x46, 0xb2, 0x38, 0xc9, 0x64, 0xc1, 0x15, 0x01, 0xe6, 0xa1, 0xa7, 0x04, 0x8a,
		0x0a, 0x75, 0x2d, 0x8d, 0xbb, 0x94, 0x12, 0x5d, 0x49, 0xc9, 0x2e, 0xa4, 0x54, 0xd7, 0x51, 0xbc,
		0xcb, 0x28, 0xde, 0x55, 0x14, 0xee, 0x22, 0xe6, 0x4b, 0xe2, 0x8d, 0xbb, 0x82, 0x72, 0x3b, 0x7a,
		0x0d, 0x77, 0xf0, 0x82, 0x6b, 0x6d, 0xe6, 0x5a, 0xdc, 0xbe, 0x99, 0x10, 0xcb, 0x62, 0x34, 0xc4,
		0x08, 0x45, 0xd3, 0x99, 0xe0, 0x9b, 0x9b, 0x36, 0xb4, 0x08, 0x20, 0xc0, 0x6b, 0x5f, 0xf1, 0xdb,
		0x55, 0xa2, 0xed, 0x29, 0x5e, 0x3b, 0x4a, 0xd7, 0x98, 0x4c, 0xf7, 0x97, 0x72, 0x7b, 0x97, 0x54,
		0x4e, 0x0b, 0x38, 0xba, 0x9e, 0x8b, 0x67, 0x3b, 0xec, 0xee, 0x4f, 0x64, 0x58, 0x9f, 0x6a, 0x75,
		0x23, 0x6b, 0x6b, 0x98, 0xd8, 0xc0, 0xb4, 0xbb, 0xed, 0xb9, 0xdd, 0x4a, 0x9b, 0xff, 0x67, 0x8b,
		0xdd, 0x74, 0xed, 0x45, 0xb6, 0xd3, 0x0e, 0xdb, 0x10, 0x6d, 0xb2, 0xd9, 0x0e, 0xeb, 0x4f, 0xb9,
		0xe1, 0x09, 0xdd, 0xa7, 0x38, 0x6a, 0xa9, 0x24, 0x51, 0xdb, 0xcf, 0xc2, 0x58, 0xd8, 0x36, 0x31,
		0xfd, 0xe8, 0x16, 0x4b, 0xed, 0xe6, 0x7f, 0x99, 0xe5, 0xab, 0x4e, 0x79, 0x3a, 0x2f, 0x3f, 0x5b,
		0xde, 0xf0, 0x7e, 0x76, 0x19, 0x51, 0xb3, 0xba, 0x24, 0x57, 0x8f, 0xe4, 0xea, 0x70, 0xb9, 0xfa,
		0x9b, 0xdc, 0xb8, 0x90, 0x77, 0x66, 0xb1, 0xa1, 0xe9, 0x5b, 0xcb, 0x36, 0xc3, 0xca, 0x6b, 0xce,
		0x32, 0x82, 0x1e, 0xd9, 0xd7, 0x26, 0xf7, 0x14, 0x6e, 0x42, 0x70, 0x02, 0x2e, 0xd5, 0x60, 0x53,
		0x0a, 0x36, 0x75, 0xa0, 0x39, 0x89, 0x0c, 0x14, 0xe8, 0x52, 0x69, 0xf7, 0x89, 0xa0, 0xf2, 0x35,
		0x77, 0x24, 0xed, 0x29, 0x3f, 0x22, 0x31, 0x26, 0x13, 0x61, 0x0e, 0xf1, 0x65, 0x38, 0x99, 0x29,
		0xaf, 0x35, 0xe6, 0xb1, 0xc6, 0xbc, 0x95, 0xe7, 0x84, 0x76, 0x4a, 0x6d, 0x32, 0xed, 0x34, 0x68,
		0x06, 0x73, 0x9a, 0xc0, 0x8b, 0xcd, 0xdf, 0x11, 0x81, 0xba, 0x18, 0x3a, 0xbc, 0x54, 0x89, 0xa7,
		0x55, 0x38, 0x51, 0x5a, 0xbc, 0xac, 0xd6, 0x2e, 0xb1, 0xa5, 0x4b, 0x6e, 0xe5, 0x22, 0x30, 0x0f,
		0x30, 0x30, 0xa9, 0x0d, 0x58, 0xd7, 0x8f, 0x1f, 0x13, 0xfe, 0x54, 0xc4, 0xe8, 0xea, 0x53, 0x98,
		0xb6, 0x24, 0xbb, 0xf3, 0xa9, 0x4c, 0x44, 0x50, 0xdd, 0x3d, 0x9f, 0xe6, 0x9d, 0xf9, 0xa4, 0x25,
		0xbb, 0x1d, 0xca, 0x6c, 0x83, 0x52, 0x9f, 0xd0, 0x68, 0xe1, 0x95, 0xf9, 0x82, 0x2b, 0x2b, 0x0b,
		0xad, 0xcc, 0x16, 0x58, 0xd9, 0x99, 0xab, 0x6d, 0x3d, 0xf5, 0xbd, 0x7e, 0xe2, 0x3f, 0xaa, 0x49,
		0xa7, 0x80, 0x9f, 0x2b, 0xd7, 0x46, 0x42, 0xde, 0x44, 0xde, 0x3c, 0xba, 0xbc, 0xd9, 0x8a, 0xfa,
		0x61, 0xaa, 0xe2, 0xfa, 0x95, 0x41, 0xea, 0x64, 0x1c, 0xd0, 0x65, 0xb8, 0x27, 0xdf, 0x6c, 0xed,
		0xaa, 0xf9, 0x24, 0xa9, 0xd0, 0x5e, 0x7a, 0xf1, 0x6d, 0xd5, 0x72, 0xdb, 0xa7, 0x07, 0x66, 0x8b,
		0x7a, 0xe5, 0x4c, 0x2c, 0xbb, 0x26, 0xb8, 0xe8, 0x56, 0xcf, 0x69, 0x2a, 0xb6, 0x59, 0x28, 0xa4,
		0xee, 0x27, 0x2a, 0x96, 0xc0, 0xe9, 0xd1, 0x38, 0x40, 0x69, 0xa0, 0x34, 0x50, 0x1a, 0x28, 0x0d,
		0x94, 0x06, 0x4a, 0x03, 0xa5, 0x65, 0x50, 0x3a, 0x0d, 0xba, 0xc1, 0xbf, 0xbc, 0xb5, 0x55, 0xcb,
		0x30, 0xbd, 0x30, 0x10, 0x70, 0x1a, 0x38, 0x7d, 0x74, 0x38, 0xfd, 0xa4, 0xe2, 0x96, 0x0a, 0x53,
		0xff, 0x51, 0x19, 0x00, 0x75, 0x0d, 0x40, 0x0d, 0xa0, 0xb6, 0x06, 0xd4, 0xe5, 0x32, 0x70, 0xf9,
		0x08, 0x70, 0xb9, 0xa7, 0x7a, 0x51, 0xfc, 0x6d, 0x4c, 0x7c, 0xf9, 0xa0, 0xbc, 0x34, 0x0a, 0x10,
		0x19, 0x88, 0x7c, 0x74, 0x88, 0xdc, 0x0f, 0xc2, 0x14, 0xb4, 0x19, 0x68, 0x0c, 0xda, 0x0c, 0x78,
		0xde, 0x03, 0x3c, 0x4b, 0x30, 0xe7, 0x0d, 0x63, 0x01, 0xaa, 0x01, 0xd5, 0x20, 0xcf, 0x20, 0xcf,
		0x80, 0x6b, 0x90, 0x67, 0xa0, 0x33, 0x19, 0x9d, 0xa1, 0xfd, 0x03, 0x04, 0x06, 0x02, 0xaf, 0xbf,
		0xf1, 0xdc, 0x17, 0xd1, 0x5a, 0x89, 0x6e, 0xca, 0x06, 0xab, 0xf5, 0x22, 0x84, 0xac, 0xad, 0x88,
		0xd8, 0x46, 0x6c, 0xa3, 0x11, 0x86, 0xca, 0x1a, 0x95, 0x35, 0x1a, 0x61, 0x28, 0xb5, 0x57, 0x8d,
		0x96, 0xa4, 0x7e, 0x9c, 0x7a, 0x69, 0xd0, 0x33, 0x13, 0xd0, 0x9b, 0x8e, 0x01, 0x68, 0x06, 0x34,
		0x1f, 0x1d, 0x34, 0x0f, 0x3d, 0x3b, 0x0d, 0x5a, 0x9f, 0x93, 0xdc, 0xf1, 0xf9, 0xff, 0xc3, 0x71,
		0x6a, 0x74, 0x43, 0x3f, 0x8c, 0x12, 0xd5, 0x8a, 0xc2, 0x36, 0x4b, 0x21, 0x18, 0x38, 0x0f, 0x9c,
		0x07, 0xce, 0x1f, 0x1d, 0xce, 0x1f, 0x94, 0x42, 0xd9, 0x4c, 0x52, 0x69, 0xfa, 0x13, 0x59, 0x8a,
		0x4f, 0x53, 0x2a, 0xea, 0xdd, 0xf4, 0x8b, 0xa6, 0x3f, 0x51, 0x44, 0xf7, 0x6c, 0x2b, 0x92, 0x4d,
		0x44, 0xf5, 0xb2, 0xdb, 0x18, 0xb4, 0x1d, 0xc9, 0xf4, 0x1d, 0xc8, 0x22, 0x3b, 0x8e, 0x69, 0x3b,
		0x8c, 0xf7, 0xa5, 0xd6, 0xb6, 0xe6, 0x79, 0x72, 0x52, 0x6d, 0x6b, 0xbe, 0x76, 0x98, 0x3a, 0x6d,
		0x59, 0x72, 0x67, 0x1c, 0x8b, 0x98, 0x28, 0xb5, 0x25, 0xc9, 0x27, 0x2f, 0x51, 0xf1, 0x97, 0x1d,
		0xfb, 0xce, 0xe6, 0xec, 0x63, 0xfe, 0xd9, 0x62, 0x68, 0xb5, 0x25, 0xdf, 0x12, 0x2f, 0x55, 0x71,
		0xef, 0x20, 0xf5, 0xda, 0x66, 0x37, 0x9f, 0x97, 0x66, 0x5b, 0x6b, 0x6a, 0x7d, 0x4d, 0xc9, 0xb6,
		0xc9, 0xe7, 0x85, 0x15, 0xdb, 0xca, 0x76, 0x14, 0xdb, 0x34, 0x5c, 0x81, 0x4b, 0x0e, 0xf7, 0xaf,
		0xda, 0x96, 0xed, 0x2a, 0x32, 0x90, 0xa9, 0xad, 0xdc, 0xa6, 0x42, 0xff, 0xa1, 0xcb, 0x50, 0x89,
		0x9a, 0x5c, 0xa7, 0x2b, 0x09, 0xc4, 0x38, 0x74, 0xd2, 0x1d, 0x5a, 0x59, 0xaf, 0x00, 0x69, 0x1e,
		0x87, 0x8c, 0x1c, 0xc1, 0xf3, 0x4d, 0xdb, 0x23, 0xc5, 0x53, 0xac, 0xd2, 0x8f, 0x0c, 0x3b, 0xa5,
		0x3c, 0x5f, 0x4e, 0xee, 0x21, 0x8a, 0xba, 0xca, 0x0f, 0x39, 0x72, 0x72, 0x95, 0x1c, 0xe5, 0xe0,
		0x9e, 0xe2, 0x28, 0x8d, 0x5a, 0x51, 0xd7, 0xfb, 0xa2, 0xe2, 0x84, 0xc2, 0x58, 0x16, 0x95, 0x3f,
		0x97, 0x47, 0xb0, 0x19, 0xfd, 0x7f, 0x56, 0x11, 0xfb, 0x88, 0xfd, 0xa2, 0xc7, 0xbe, 0x0a, 0xfb,
		0x3d, 0x15, 0x53, 0x17, 0xb0, 0x72, 0x4e, 0x26, 0x25, 0x9e, 0x3c, 0x2a, 0x93, 0x33, 0x62, 0x3f,
		0x55, 0x5e, 0x37, 0xe8, 0x05, 0x29, 0x3d, 0x5b, 0x2c, 0x5c, 0x8b, 0x10, 0x45, 0x88, 0xee, 0x2d,
		0x44, 0xfb, 0x41, 0x98, 0x56, 0xea, 0x8c, 0xe8, 0xac, 0x13, 0x2e, 0xe1, 0x4d, 0x16, 0xf0, 0x54,
		0xf3, 0xf8, 0x73, 0x61, 0x86, 0x93, 0x02, 0x62, 0x6d, 0x69, 0xf3, 0x76, 0xf4, 0x80, 0x27, 0x17,
		0x68, 0x6e, 0xba, 0x7a, 0xad, 0x76, 0x59, 0x3b, 0x7c, 0xf3, 0x59, 0xea, 0xae, 0x37, 0xf3, 0x94,
		0x37, 0x56, 0xc9, 0xb0, 0x08, 0xe5, 0xc2, 0xd3, 0xf2, 0xe5, 0x40, 0x28, 0x20, 0x14, 0x10, 0x0a,
		0x08, 0x05, 0x84, 0x02, 0x42, 0x89, 0x21, 0x54, 0x1a, 0xf4, 0x54, 0xd4, 0x67, 0x60, 0xd3, 0xf4,
		0x42, 0xa0, 0x12, 0x50, 0x09, 0xa8, 0x04, 0x54, 0x02, 0x2a, 0x01, 0x95, 0x0e, 0xf8, 0xe4, 0xbf,
		0xf9, 0x6a, 0x83, 0x0b, 0xad, 0x99, 0x68, 0x47, 0x7f, 0xe5, 0xc4, 0xfb, 0xe4, 0xd3, 0xfb, 0xd1,
		0xc8, 0x1f, 0x27, 0xa8, 0xc6, 0x5d, 0x4a, 0xb2, 0x73, 0x0d, 0x87, 0xce, 0x39, 0x3a, 0xa4, 0xf3,
		0x73, 0x8a, 0x72, 0x3a, 0x1a, 0xe6, 0xda, 0x05, 0xc2, 0x06, 0x73, 0xed, 0x28, 0x4a, 0x51, 0x94,
		0x3a, 0x98, 0x6b, 0x9f, 0x7f, 0x27, 0xe6, 0xda, 0x11, 0xfb, 0x88, 0x7d, 0xe1, 0xd8, 0xc7, 0x5c,
		0xfb, 0x56, 0xd3, 0x60, 0xae, 0x1d, 0x21, 0x8a, 0x9e, 0x11, 0x7a, 0x46, 0xe8, 0x19, 0xa1, 0x67,
		0x64, 0x03, 0x9b, 0x30, 0xd7, 0x0e, 0x84, 0x02, 0x42, 0x01, 0xa1, 0x80, 0x50, 0x40, 0x28, 0xcc,
		0xb5, 0x03, 0x95, 0x80, 0x4a, 0x40, 0x25, 0xa0, 0x12, 0x50, 0xe9, 0xa4, 0x51, 0xa9, 0xe8, 0x73,
		0xed, 0xba, 0x52, 0x21, 0xe4, 0xa9, 0x76, 0x0d, 0x69, 0x90, 0xa2, 0x8a, 0x36, 0x64, 0x0a, 0x1f,
		0x70, 0x0c, 0x62, 0xa4, 0xda, 0xb0, 0x73, 0x71, 0x81, 0xd6, 0xa2, 0x02, 0x6d, 0xad, 0x86, 0xaa,
		0x98, 0x56, 0xc3, 0xa1, 0xca, 0x34, 0xe4, 0xa6, 0xd0, 0xf0, 0x10, 0x45, 0x9a, 0x0a, 0x81, 0x8b,
		0x53, 0x9b, 0x5a, 0x82, 0x80, 0x9a, 0x25, 0x68, 0x1e, 0x3a, 0x0d, 0xc7, 0xba, 0x6c, 0xc4, 0xf6,
		0x8a, 0x11, 0xed, 0x42, 0x91, 0x29, 0xa7, 0x47, 0x90, 0xcf, 0xe3, 0xca, 0xe5, 0x11, 0xab, 0x49,
		0x42, 0x4d, 0xcc, 0xa9, 0x1e, 0xb9, 0x55, 0xa3, 0x71, 0xb9, 0xc3, 0x2f, 0x73, 0x28, 0x82, 0xa3,
		0x9c, 0xaa, 0x50, 0x50, 0x9e, 0x6e, 0x9f, 0x56, 0x12, 0x2a, 0xd6, 0x9a, 0x16, 0xd6, 0x05, 0xb6,
		0xfa, 0x71, 0xac, 0xc2, 0xd4, 0x6b, 0xfb, 0xa9, 0xa2, 0xa5, 0xfa, 0xb5, 0x2b, 0x91, 0xf1, 0x91,
		0xf1, 0x57, 0xec, 0x3d, 0xf4, 0x0d, 0xcf, 0x0f, 0xdb, 0xba, 0x1a, 0xc1, 0xf3, 0xe3, 0x0a, 0x34,
		0x3e, 0xfb, 0xce, 0x4f, 0x53, 0x15, 0x87, 0xda, 0xe9, 0xdb, 0x6d, 0x94, 0xbd, 0x9b, 0xe6, 0xf3,
		0xd5, 0xe0, 0xfe, 0xde, 0x3b, 0x2f, 0x37, 0x2a, 0xde, 0x4d, 0xf3, 0xa5, 0xd2, 0x28, 0x7b, 0xd5,
		0x66, 0x69, 0xe1, 0x37, 0x8d, 0x4a, 0xb5, 0x39, 0xfa, 0xe0, 0xcb, 0x65, 0xa3, 0x5c, 0x69, 0x96,
		0x1a, 0x1f, 0xd2, 0xe6, 0x79, 0x79, 0xfc, 0x9b, 0xca, 0xf8, 0xaf, 0x6a, 0xa3, 0xec, 0x5d, 0x36,
		0x4b, 0xb7, 0xd3, 0x5f, 0x37, 0x2a, 0x5e, 0x6d, 0x7c, 0xcd, 0xa6, 0xdf, 0xbd, 0xd4, 0xcb, 0xa5,
		0xf3, 0xfb, 0xfb, 0xd7, 0xa3, 0x7f, 0x7c, 0x5f, 0xfa, 0xf1, 0xbc, 0xf1, 0xd7, 0xbf, 0xcd, 0x97,
		0xf3, 0xc6, 0xf7, 0x1e, 0x61, 0xdc, 0x52, 0x29, 0xfb, 0xe5, 0x36, 0x75, 0x6c, 0xf6, 0xf6, 0xfd,
		0xff, 0xfe, 0x87, 0x6c, 0xb8, 0xbf, 0xcf, 0x0f, 0xda, 0x74, 0xa5, 0xef, 0xdc, 0xbd, 0xe4, 0xd6,
		0x76, 0xd4, 0xf3, 0x83, 0xd0, 0xd3, 0x3a, 0xd4, 0x66, 0x1e, 0x32, 0x0b, 0x17, 0x21, 0xa3, 0x22,
		0xa3, 0xb2, 0xdd, 0x83, 0x9c, 0x4f, 0x7f, 0x53, 0xe1, 0xe3, 0xa8, 0xf5, 0x50, 0xac, 0x6a, 0xb8,
		0x82, 0x6a, 0x78, 0xd5, 0x24, 0xd5, 0xda, 0xe5, 0xe9, 0x15, 0xbf, 0x36, 0x2a, 0x82, 0xf3, 0xf3,
		0xf3, 0xf3, 0x86, 0xef, 0xfd, 0x7b, 0xe7, 0xfd, 0x55, 0xf6, 0x6e, 0x3e, 0x36, 0x17, 0xfe, 0x71,
		0x7f, 0xef, 0x7d, 0x6c, 0x96, 0x9e, 0xcb, 0xaf, 0xea, 0x95, 0x41, 0xe9, 0xc7, 0xf9, 0xef, 0x9b,
		0xf7, 0xf7, 0xaf, 0x4b, 0xff, 0xc3, 0xb9, 0xea, 0xc7, 0xd2, 0xcb, 0xf0, 0xda, 0xfd, 0x02, 0xf9,
		0x1e, 0x1e, 0x78, 0x4f, 0xe8, 0xfb, 0x29, 0x4a, 0x52, 0x1a, 0xf4, 0xce, 0xae, 0x00, 0xee, 0x02,
		0x77, 0x81, 0xbb, 0xc0, 0x5d, 0xe0, 0x2e, 0x70, 0x17, 0xb8, 0x4b, 0xc4, 0xdd, 0x6e, 0xf4, 0x18,
		0x84, 0xde, 0x83, 0x1f, 0x86, 0x2a, 0xd6, 0xc7, 0xde, 0xa5, 0xab, 0x80, 0xbf, 0xc0, 0xdf, 0x15,
		0x7b, 0x6b, 0x9f, 0x80, 0xaa, 0x79, 0xe2, 0x29, 0xcf, 0xb7, 0x7b, 0x51, 0xda, 0x26, 0xbb, 0xf6,
		0xe2, 0x45, 0xf0, 0x6c, 0x78, 0xf6, 0xfe, 0x3c, 0x7b, 0xbf, 0xab, 0x56, 0x32, 0x56, 0xf2, 0xe8,
		0x2e, 0x58, 0xd9, 0xbe, 0x6e, 0x47, 0x6f, 0xb1, 0x4a, 0xaa, 0xba, 0xa1, 0x4a, 0xb5, 0x4f, 0x19,
		0x59, 0xfe, 0x38, 0x0e, 0x1a, 0xc1, 0x41, 0x23, 0x3a, 0xaf, 0x3c, 0xcf, 0x54, 0x0d, 0xf1, 0x13,
		0x88, 0x9f, 0x38, 0xee, 0x88, 0x1d, 0x42, 0x01, 0x41, 0x36, 0x04, 0x8c, 0x43, 0xc1, 0x38, 0x24,
		0xcc, 0x43, 0x83, 0xd8, 0x10, 0x80, 0xfa, 0xc9, 0xf8, 0x3b, 0xa1, 0x64, 0x80, 0x50, 0xc3, 0x8e,
		0x1c, 0x8d, 0x4b, 0xb0, 0x23, 0x27, 0x9f, 0x86, 0x2e, 0xa3, 0xdb, 0x6d, 0xd4, 0xf5, 0x5e, 0x33,
		0x1d, 0x76, 0xe4, 0xf0, 0x5b, 0xa9, 0xb2, 0xd8, 0x04, 0x25, 0x03, 0x20, 0x14, 0x10, 0x0a, 0x08,
		0x05, 0x84, 0x02, 0x42, 0x41, 0xc9, 0x00, 0xa8, 0x04, 0x54, 0x02, 0x2a, 0x01, 0x95, 0x80, 0x4a,
		0x27, 0x8d, 0x4a, 0x85, 0x54, 0x32, 0x58, 0x9a, 0x3d, 0x14, 0x3f, 0x38, 0xe0, 0xc3, 0x68, 0x74,
		0x9c, 0x1d, 0x80, 0xe9, 0x33, 0x43, 0x00, 0xc6, 0xf4, 0x19, 0xa6, 0xcf, 0x50, 0x9b, 0x1e, 0x44,
		0x6d, 0x8a, 0xe9, 0x33, 0x84, 0x1a, 0x42, 0x0d, 0x34, 0x10, 0x34, 0x10, 0x34, 0x10, 0x34, 0x90,
		0x85, 0x4d, 0x98, 0x3e, 0x03, 0x42, 0x01, 0xa1, 0x80, 0x50, 0x40, 0x28, 0x20, 0x14, 0xa6, 0xcf,
		0x80, 0x4a, 0x40, 0x25, 0xa0, 0x12, 0x50, 0x09, 0xa8, 0x74, 0xd2, 0xa8, 0x74, 0x00, 0xd3, 0x67,
		0xc2, 0x5a, 0xe0, 0x4b, 0xb3, 0x67, 0x07, 0x2c, 0x07, 0xae, 0xb3, 0x43, 0x91, 0x69, 0x16, 0xed,
		0x7d, 0x96, 0x67, 0x3b, 0x1e, 0xdc, 0xbd, 0xeb, 0x3f, 0x0e, 0x71, 0x4d, 0xb5, 0x37, 0xa6, 0xeb,
		0x8c, 0xfd, 0x97, 0x17, 0x63, 0x28, 0xbc, 0x1d, 0x3f, 0xec, 0xb6, 0x0d, 0x98, 0x3f, 0xab, 0xa4,
		0x15, 0x07, 0x4f, 0x13, 0xa3, 0xba, 0x77, 0xed, 0x76, 0x10, 0x3e, 0x3a, 0xc3, 0x47, 0x1c, 0xd7,
		0x2c, 0x4e, 0xdb, 0x4f, 0x7d, 0x27, 0x8d, 0x9c, 0xf4, 0x93, 0x72, 0xc6, 0x43, 0x39, 0xbd, 0xa8,
		0xad, 0xba, 0x85, 0xd8, 0xd1, 0xf9, 0xa4, 0xc2, 0x4e, 0x37, 0xfa, 0xe7, 0x00, 0xb7, 0x73, 0x4e,
		0xef, 0x3c, 0xaf, 0xbd, 0x9c, 0xb3, 0x2f, 0xd4, 0x9e, 0x8d, 0xd6, 0x30, 0xee, 0x26, 0x0f, 0x7a,
		0x13, 0x85, 0xa9, 0x1f, 0x84, 0x2a, 0x76, 0x3a, 0x51, 0x3c, 0x72, 0xa4, 0xe1, 0x20, 0x3b, 0x7d,
		0x46, 0xd3, 0x77, 0xc8, 0xd5, 0x34, 0x6f, 0x6e, 0x5b, 0xef, 0xb1, 0x9d, 0x03, 0x9c, 0xd8, 0xce,
		0xf4, 0x39, 0x4d, 0x4c, 0xa3, 0xfa, 0x6c, 0x46, 0xd6, 0x6b, 0xae, 0x66, 0xbd, 0xdd, 0x69, 0x5e,
		0x37, 0xbd, 0xbb, 0x1b, 0xcf, 0x5b, 0xd0, 0x48, 0xe4, 0xcb, 0xf6, 0x99, 0xdf, 0xeb, 0xf8, 0xa7,
		0x49, 0x04, 0x6e, 0xbb, 0x4b, 0x37, 0x48, 0x7e, 0xf5, 0x3f, 0xab, 0x3f, 0xa2, 0x68, 0xfd, 0x4d,
		0xad, 0xde, 0xb9, 0xbb, 0xf8, 0x5f, 0x4b, 0x77, 0xf6, 0xb3, 0xfa, 0x12, 0xb4, 0x26, 0xa8, 0x3a,
		0x38, 0x1b, 0xfc, 0x17, 0x00, 0x00, 0xff, 0xff, 0x01, 0x00, 0x00, 0xff, 0xff, 0xc7, 0xa2, 0x23,
		0xa5, 0xf3, 0xa4, 0x13, 0x00,
	}
)


// ΛEnumTypes is a map, keyed by a YANG schema path, of the enumerated types that
// correspond with the leaf. The type is represented as a reflect.Type. The naming
// of the map ensures that there are no clashes with valid YANG identifiers.
func initΛEnumTypes(){
  ΛEnumTypes = map[string][]reflect.Type{
	"/components/component/state/last-reboot-reason": []reflect.Type{
		reflect.TypeOf((E_OpenconfigPlatformTypes_COMPONENT_REBOOT_REASON)(0)),
	},
	"/components/component/state/last-switchover-reason/trigger": []reflect.Type{
		reflect.TypeOf((E_OpenconfigPlatformTypes_ComponentRedundantRoleSwitchoverReasonTrigger)(0)),
	},
	"/components/component/state/oper-status": []reflect.Type{
		reflect.TypeOf((E_OpenconfigPlatformTypes_COMPONENT_OPER_STATUS)(0)),
	},
	"/components/component/state/redundant-role": []reflect.Type{
		reflect.TypeOf((E_OpenconfigPlatform_ComponentRedundantRole)(0)),
	},
	"/components/component/state/temperature/alarm-severity": []reflect.Type{
		reflect.TypeOf((E_OpenconfigAlarmTypes_OPENCONFIG_ALARM_SEVERITY)(0)),
	},
	"/components/component/state/type": []reflect.Type{
		reflect.TypeOf((E_OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT)(0)),
		reflect.TypeOf((E_OpenconfigPlatformTypes_OPENCONFIG_SOFTWARE_COMPONENT)(0)),
	},
	"/interfaces/interface/config/type": []reflect.Type{
		reflect.TypeOf((E_IETFInterfaces_InterfaceType)(0)),
	},
	"/interfaces/interface/state/admin-status": []reflect.Type{
		reflect.TypeOf((E_OpenconfigInterfaces_Interfaces_Interface_State_AdminStatus)(0)),
	},
	"/interfaces/interface/state/oper-status": []reflect.Type{
		reflect.TypeOf((E_OpenconfigInterfaces_Interfaces_Interface_State_OperStatus)(0)),
	},
	"/interfaces/interface/state/type": []reflect.Type{
		reflect.TypeOf((E_IETFInterfaces_InterfaceType)(0)),
	},
	"/interfaces/interface/subinterfaces/subinterface/state/admin-status": []reflect.Type{
		reflect.TypeOf((E_OpenconfigInterfaces_Interfaces_Interface_State_AdminStatus)(0)),
	},
	"/interfaces/interface/subinterfaces/subinterface/state/oper-status": []reflect.Type{
		reflect.TypeOf((E_OpenconfigInterfaces_Interfaces_Interface_State_OperStatus)(0)),
	},
	"/messages/config/severity": []reflect.Type{
		reflect.TypeOf((E_OpenconfigMessages_SyslogSeverity)(0)),
	},
	"/messages/debug-entries/debug-service/config/service": []reflect.Type{
		reflect.TypeOf((E_OpenconfigMessages_DEBUG_SERVICE)(0)),
	},
	"/messages/debug-entries/debug-service/service": []reflect.Type{
		reflect.TypeOf((E_OpenconfigMessages_DEBUG_SERVICE)(0)),
	},
	"/messages/debug-entries/debug-service/state/service": []reflect.Type{
		reflect.TypeOf((E_OpenconfigMessages_DEBUG_SERVICE)(0)),
	},
	"/messages/state/severity": []reflect.Type{
		reflect.TypeOf((E_OpenconfigMessages_SyslogSeverity)(0)),
	},
	"/system/aaa/accounting/config/accounting-method": []reflect.Type{
		reflect.TypeOf((E_OpenconfigAaaTypes_AAA_METHOD_TYPE)(0)),
	},
	"/system/aaa/accounting/events/event/config/event-type": []reflect.Type{
		reflect.TypeOf((E_OpenconfigAaaTypes_AAA_ACCOUNTING_EVENT_TYPE)(0)),
	},
	"/system/aaa/accounting/events/event/config/record": []reflect.Type{
		reflect.TypeOf((E_OpenconfigSystem_System_Aaa_Accounting_Events_Event_Config_Record)(0)),
	},
	"/system/aaa/accounting/events/event/event-type": []reflect.Type{
		reflect.TypeOf((E_OpenconfigAaaTypes_AAA_ACCOUNTING_EVENT_TYPE)(0)),
	},
	"/system/aaa/accounting/events/event/state/event-type": []reflect.Type{
		reflect.TypeOf((E_OpenconfigAaaTypes_AAA_ACCOUNTING_EVENT_TYPE)(0)),
	},
	"/system/aaa/accounting/events/event/state/record": []reflect.Type{
		reflect.TypeOf((E_OpenconfigSystem_System_Aaa_Accounting_Events_Event_Config_Record)(0)),
	},
	"/system/aaa/accounting/state/accounting-method": []reflect.Type{
		reflect.TypeOf((E_OpenconfigAaaTypes_AAA_METHOD_TYPE)(0)),
	},
	"/system/aaa/authentication/config/authentication-method": []reflect.Type{
		reflect.TypeOf((E_OpenconfigAaaTypes_AAA_METHOD_TYPE)(0)),
	},
	"/system/aaa/authentication/state/authentication-method": []reflect.Type{
		reflect.TypeOf((E_OpenconfigAaaTypes_AAA_METHOD_TYPE)(0)),
	},
	"/system/aaa/authentication/users/user/config/role": []reflect.Type{
		reflect.TypeOf((E_OpenconfigAaaTypes_SYSTEM_DEFINED_ROLES)(0)),
	},
	"/system/aaa/authentication/users/user/state/role": []reflect.Type{
		reflect.TypeOf((E_OpenconfigAaaTypes_SYSTEM_DEFINED_ROLES)(0)),
	},
	"/system/aaa/authorization/config/authorization-method": []reflect.Type{
		reflect.TypeOf((E_OpenconfigAaaTypes_AAA_METHOD_TYPE)(0)),
	},
	"/system/aaa/authorization/events/event/config/event-type": []reflect.Type{
		reflect.TypeOf((E_OpenconfigAaaTypes_AAA_AUTHORIZATION_EVENT_TYPE)(0)),
	},
	"/system/aaa/authorization/events/event/event-type": []reflect.Type{
		reflect.TypeOf((E_OpenconfigAaaTypes_AAA_AUTHORIZATION_EVENT_TYPE)(0)),
	},
	"/system/aaa/authorization/events/event/state/event-type": []reflect.Type{
		reflect.TypeOf((E_OpenconfigAaaTypes_AAA_AUTHORIZATION_EVENT_TYPE)(0)),
	},
	"/system/aaa/authorization/state/authorization-method": []reflect.Type{
		reflect.TypeOf((E_OpenconfigAaaTypes_AAA_METHOD_TYPE)(0)),
	},
	"/system/aaa/server-groups/server-group/config/type": []reflect.Type{
		reflect.TypeOf((E_OpenconfigAaaTypes_AAA_SERVER_TYPE)(0)),
	},
	"/system/aaa/server-groups/server-group/state/type": []reflect.Type{
		reflect.TypeOf((E_OpenconfigAaaTypes_AAA_SERVER_TYPE)(0)),
	},
	"/system/alarms/alarm/state/severity": []reflect.Type{
		reflect.TypeOf((E_OpenconfigAlarmTypes_OPENCONFIG_ALARM_SEVERITY)(0)),
	},
	"/system/alarms/alarm/state/type-id": []reflect.Type{
		reflect.TypeOf((E_OpenconfigAlarmTypes_OPENCONFIG_ALARM_TYPE_ID)(0)),
	},
	"/system/cpus/cpu/index": []reflect.Type{
		reflect.TypeOf((E_OpenconfigSystem_System_Cpus_Cpu_State_Index)(0)),
	},
	"/system/cpus/cpu/state/index": []reflect.Type{
		reflect.TypeOf((E_OpenconfigSystem_System_Cpus_Cpu_State_Index)(0)),
	},
	"/system/logging/console/selectors/selector/config/facility": []reflect.Type{
		reflect.TypeOf((E_OpenconfigSystemLogging_SYSLOG_FACILITY)(0)),
	},
	"/system/logging/console/selectors/selector/config/severity": []reflect.Type{
		reflect.TypeOf((E_OpenconfigSystemLogging_SyslogSeverity)(0)),
	},
	"/system/logging/console/selectors/selector/facility": []reflect.Type{
		reflect.TypeOf((E_OpenconfigSystemLogging_SYSLOG_FACILITY)(0)),
	},
	"/system/logging/console/selectors/selector/severity": []reflect.Type{
		reflect.TypeOf((E_OpenconfigSystemLogging_SyslogSeverity)(0)),
	},
	"/system/logging/console/selectors/selector/state/facility": []reflect.Type{
		reflect.TypeOf((E_OpenconfigSystemLogging_SYSLOG_FACILITY)(0)),
	},
	"/system/logging/console/selectors/selector/state/severity": []reflect.Type{
		reflect.TypeOf((E_OpenconfigSystemLogging_SyslogSeverity)(0)),
	},
	"/system/logging/remote-servers/remote-server/selectors/selector/config/facility": []reflect.Type{
		reflect.TypeOf((E_OpenconfigSystemLogging_SYSLOG_FACILITY)(0)),
	},
	"/system/logging/remote-servers/remote-server/selectors/selector/config/severity": []reflect.Type{
		reflect.TypeOf((E_OpenconfigSystemLogging_SyslogSeverity)(0)),
	},
	"/system/logging/remote-servers/remote-server/selectors/selector/facility": []reflect.Type{
		reflect.TypeOf((E_OpenconfigSystemLogging_SYSLOG_FACILITY)(0)),
	},
	"/system/logging/remote-servers/remote-server/selectors/selector/severity": []reflect.Type{
		reflect.TypeOf((E_OpenconfigSystemLogging_SyslogSeverity)(0)),
	},
	"/system/logging/remote-servers/remote-server/selectors/selector/state/facility": []reflect.Type{
		reflect.TypeOf((E_OpenconfigSystemLogging_SYSLOG_FACILITY)(0)),
	},
	"/system/logging/remote-servers/remote-server/selectors/selector/state/severity": []reflect.Type{
		reflect.TypeOf((E_OpenconfigSystemLogging_SyslogSeverity)(0)),
	},
	"/system/messages/config/severity": []reflect.Type{
		reflect.TypeOf((E_OpenconfigMessages_SyslogSeverity)(0)),
	},
	"/system/messages/debug-entries/debug-service/config/service": []reflect.Type{
		reflect.TypeOf((E_OpenconfigMessages_DEBUG_SERVICE)(0)),
	},
	"/system/messages/debug-entries/debug-service/service": []reflect.Type{
		reflect.TypeOf((E_OpenconfigMessages_DEBUG_SERVICE)(0)),
	},
	"/system/messages/debug-entries/debug-service/state/service": []reflect.Type{
		reflect.TypeOf((E_OpenconfigMessages_DEBUG_SERVICE)(0)),
	},
	"/system/messages/state/severity": []reflect.Type{
		reflect.TypeOf((E_OpenconfigMessages_SyslogSeverity)(0)),
	},
	"/system/ntp/ntp-keys/ntp-key/config/key-type": []reflect.Type{
		reflect.TypeOf((E_OpenconfigSystem_NTP_AUTH_TYPE)(0)),
	},
	"/system/ntp/ntp-keys/ntp-key/state/key-type": []reflect.Type{
		reflect.TypeOf((E_OpenconfigSystem_NTP_AUTH_TYPE)(0)),
	},
	"/system/ntp/servers/server/config/association-type": []reflect.Type{
		reflect.TypeOf((E_OpenconfigSystem_System_Ntp_Servers_Server_Config_AssociationType)(0)),
	},
	"/system/ntp/servers/server/state/association-type": []reflect.Type{
		reflect.TypeOf((E_OpenconfigSystem_System_Ntp_Servers_Server_Config_AssociationType)(0)),
	},
	"/system/openflow/agent/config/failure-mode": []reflect.Type{
		reflect.TypeOf((E_OpenconfigOpenflow_FailureMode)(0)),
	},
	"/system/openflow/agent/state/failure-mode": []reflect.Type{
		reflect.TypeOf((E_OpenconfigOpenflow_FailureMode)(0)),
	},
	"/system/openflow/controllers/controller/connections/connection/config/transport": []reflect.Type{
		reflect.TypeOf((E_OpenconfigOpenflow_Transport)(0)),
	},
	"/system/openflow/controllers/controller/connections/connection/state/transport": []reflect.Type{
		reflect.TypeOf((E_OpenconfigOpenflow_Transport)(0)),
	},
	"/system/ssh-server/config/protocol-version": []reflect.Type{
		reflect.TypeOf((E_OpenconfigSystem_System_SshServer_Config_ProtocolVersion)(0)),
	},
	"/system/ssh-server/state/protocol-version": []reflect.Type{
		reflect.TypeOf((E_OpenconfigSystem_System_SshServer_Config_ProtocolVersion)(0)),
	},
  }
}

