//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/appcontainers/armappcontainers/v3"
	"net/http"
	"net/url"
	"regexp"
)

// ConnectedEnvironmentsDaprComponentsServer is a fake server for instances of the armappcontainers.ConnectedEnvironmentsDaprComponentsClient type.
type ConnectedEnvironmentsDaprComponentsServer struct {
	// CreateOrUpdate is the fake for method ConnectedEnvironmentsDaprComponentsClient.CreateOrUpdate
	// HTTP status codes to indicate success: http.StatusOK
	CreateOrUpdate func(ctx context.Context, resourceGroupName string, connectedEnvironmentName string, componentName string, daprComponentEnvelope armappcontainers.DaprComponent, options *armappcontainers.ConnectedEnvironmentsDaprComponentsClientCreateOrUpdateOptions) (resp azfake.Responder[armappcontainers.ConnectedEnvironmentsDaprComponentsClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// Delete is the fake for method ConnectedEnvironmentsDaprComponentsClient.Delete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusNoContent
	Delete func(ctx context.Context, resourceGroupName string, connectedEnvironmentName string, componentName string, options *armappcontainers.ConnectedEnvironmentsDaprComponentsClientDeleteOptions) (resp azfake.Responder[armappcontainers.ConnectedEnvironmentsDaprComponentsClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method ConnectedEnvironmentsDaprComponentsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, connectedEnvironmentName string, componentName string, options *armappcontainers.ConnectedEnvironmentsDaprComponentsClientGetOptions) (resp azfake.Responder[armappcontainers.ConnectedEnvironmentsDaprComponentsClientGetResponse], errResp azfake.ErrorResponder)

	// NewListPager is the fake for method ConnectedEnvironmentsDaprComponentsClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(resourceGroupName string, connectedEnvironmentName string, options *armappcontainers.ConnectedEnvironmentsDaprComponentsClientListOptions) (resp azfake.PagerResponder[armappcontainers.ConnectedEnvironmentsDaprComponentsClientListResponse])

	// ListSecrets is the fake for method ConnectedEnvironmentsDaprComponentsClient.ListSecrets
	// HTTP status codes to indicate success: http.StatusOK
	ListSecrets func(ctx context.Context, resourceGroupName string, connectedEnvironmentName string, componentName string, options *armappcontainers.ConnectedEnvironmentsDaprComponentsClientListSecretsOptions) (resp azfake.Responder[armappcontainers.ConnectedEnvironmentsDaprComponentsClientListSecretsResponse], errResp azfake.ErrorResponder)
}

// NewConnectedEnvironmentsDaprComponentsServerTransport creates a new instance of ConnectedEnvironmentsDaprComponentsServerTransport with the provided implementation.
// The returned ConnectedEnvironmentsDaprComponentsServerTransport instance is connected to an instance of armappcontainers.ConnectedEnvironmentsDaprComponentsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewConnectedEnvironmentsDaprComponentsServerTransport(srv *ConnectedEnvironmentsDaprComponentsServer) *ConnectedEnvironmentsDaprComponentsServerTransport {
	return &ConnectedEnvironmentsDaprComponentsServerTransport{
		srv:          srv,
		newListPager: newTracker[azfake.PagerResponder[armappcontainers.ConnectedEnvironmentsDaprComponentsClientListResponse]](),
	}
}

// ConnectedEnvironmentsDaprComponentsServerTransport connects instances of armappcontainers.ConnectedEnvironmentsDaprComponentsClient to instances of ConnectedEnvironmentsDaprComponentsServer.
// Don't use this type directly, use NewConnectedEnvironmentsDaprComponentsServerTransport instead.
type ConnectedEnvironmentsDaprComponentsServerTransport struct {
	srv          *ConnectedEnvironmentsDaprComponentsServer
	newListPager *tracker[azfake.PagerResponder[armappcontainers.ConnectedEnvironmentsDaprComponentsClientListResponse]]
}

// Do implements the policy.Transporter interface for ConnectedEnvironmentsDaprComponentsServerTransport.
func (c *ConnectedEnvironmentsDaprComponentsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "ConnectedEnvironmentsDaprComponentsClient.CreateOrUpdate":
		resp, err = c.dispatchCreateOrUpdate(req)
	case "ConnectedEnvironmentsDaprComponentsClient.Delete":
		resp, err = c.dispatchDelete(req)
	case "ConnectedEnvironmentsDaprComponentsClient.Get":
		resp, err = c.dispatchGet(req)
	case "ConnectedEnvironmentsDaprComponentsClient.NewListPager":
		resp, err = c.dispatchNewListPager(req)
	case "ConnectedEnvironmentsDaprComponentsClient.ListSecrets":
		resp, err = c.dispatchListSecrets(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (c *ConnectedEnvironmentsDaprComponentsServerTransport) dispatchCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if c.srv.CreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method CreateOrUpdate not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.App/connectedEnvironments/(?P<connectedEnvironmentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/daprComponents/(?P<componentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armappcontainers.DaprComponent](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	connectedEnvironmentNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("connectedEnvironmentName")])
	if err != nil {
		return nil, err
	}
	componentNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("componentName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := c.srv.CreateOrUpdate(req.Context(), resourceGroupNameParam, connectedEnvironmentNameParam, componentNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).DaprComponent, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *ConnectedEnvironmentsDaprComponentsServerTransport) dispatchDelete(req *http.Request) (*http.Response, error) {
	if c.srv.Delete == nil {
		return nil, &nonRetriableError{errors.New("fake for method Delete not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.App/connectedEnvironments/(?P<connectedEnvironmentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/daprComponents/(?P<componentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	connectedEnvironmentNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("connectedEnvironmentName")])
	if err != nil {
		return nil, err
	}
	componentNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("componentName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := c.srv.Delete(req.Context(), resourceGroupNameParam, connectedEnvironmentNameParam, componentNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *ConnectedEnvironmentsDaprComponentsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if c.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.App/connectedEnvironments/(?P<connectedEnvironmentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/daprComponents/(?P<componentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	connectedEnvironmentNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("connectedEnvironmentName")])
	if err != nil {
		return nil, err
	}
	componentNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("componentName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := c.srv.Get(req.Context(), resourceGroupNameParam, connectedEnvironmentNameParam, componentNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).DaprComponent, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *ConnectedEnvironmentsDaprComponentsServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if c.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := c.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.App/connectedEnvironments/(?P<connectedEnvironmentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/daprComponents`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		connectedEnvironmentNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("connectedEnvironmentName")])
		if err != nil {
			return nil, err
		}
		resp := c.srv.NewListPager(resourceGroupNameParam, connectedEnvironmentNameParam, nil)
		newListPager = &resp
		c.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armappcontainers.ConnectedEnvironmentsDaprComponentsClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		c.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		c.newListPager.remove(req)
	}
	return resp, nil
}

func (c *ConnectedEnvironmentsDaprComponentsServerTransport) dispatchListSecrets(req *http.Request) (*http.Response, error) {
	if c.srv.ListSecrets == nil {
		return nil, &nonRetriableError{errors.New("fake for method ListSecrets not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.App/connectedEnvironments/(?P<connectedEnvironmentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/daprComponents/(?P<componentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/listSecrets`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	connectedEnvironmentNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("connectedEnvironmentName")])
	if err != nil {
		return nil, err
	}
	componentNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("componentName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := c.srv.ListSecrets(req.Context(), resourceGroupNameParam, connectedEnvironmentNameParam, componentNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).DaprSecretsCollection, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
