---
name: 'Libp2p Release'
about: 'Start a new libp2p release.'
---

## 🗺 What's left for release

<List of items with remaining PRs and/or Issues to be considered for this release>

## 🔦 Highlights

< top highlights for this release notes >

## Changelog

< changelog generated by scripts/mkreleaselog >

## ✅ Release Checklist

- [ ] **Stage 0 - Finishing Touches**
    - [ ] Go through relevant libp2p repos looking for unreleased changes that should make it into the release. If you find any, cut releases.
    - [ ] Run `go get -u ./...` to see if there are any out-of-date deps that look important. If there are, bubble them. Try to avoid _directly_ updating indirect deps in go-libp2p's `go.mod` when possible.
- [ ] **Stage 1 - Release**
  - [ ] Publish the release through the GitHub UI, adding the release notes. Some users rely on this to receive notifications of new releases.
  - [ ] Announce the release on the [discuss.libp2p.io](https://discuss.libp2p.io).
- [ ] **Stage 2 - Update Upstream**
  - [ ] Update the examples to the final release
  - [ ] Update the upstream dependencies to the final release and create PRs.
    - [ ] [filecoin-project/lotus](https://github.com/filecoin-project/lotus)
    - [ ] [go-libp2p-kad-dht](https://github.com/libp2p/go-libp2p-kad-dht/)
    - [ ] [go-libp2p-pubsub](https://github.com/libp2p/go-libp2p-pubsub) (In case of breaking changes.)
    - [ ] [ipfs/kubo](https://github.com/ipfs/kubo)
  - [ ] Add new release to interop tester in [test-plans](https://github.com/libp2p/test-plans/)
- [ ] Make required changes to the release process.
