package model

import (
	"github.com/huaweicloud/huaweicloud-sdk-go-v3/core/utils"

	"errors"
	"github.com/huaweicloud/huaweicloud-sdk-go-v3/core/converter"

	"strings"
)

// BackupInfo 备份信息。
type BackupInfo struct {

	// 备份ID。
	Id string `json:"id"`

	// 备份名称。
	Name string `json:"name"`

	// 备份描述。
	Description string `json:"description"`

	// 备份开始时间，格式为“yyyy-mm-ddThh:mm:ssZ”。  其中，T指某个时间的开始；Z指时区偏移量，例如北京时间偏移显示为+0800。
	BeginTime string `json:"begin_time"`

	// 备份状态，取值：  - BUILDING: 备份中。 - COMPLETED: 备份完成。 - FAILED：备份失败。 - DELETING：备份删除中。
	Status BackupInfoStatus `json:"status"`

	// 备份类型，取值： - “manual”: 手动全量备份
	Type BackupInfoType `json:"type"`

	// **参数解释**: 实例ID。 **约束限制**: 不涉及。 **取值范围**: 不涉及。 **默认取值**: 不涉及。
	InstanceId string `json:"instance_id"`
}

func (o BackupInfo) String() string {
	data, err := utils.Marshal(o)
	if err != nil {
		return "BackupInfo struct{}"
	}

	return strings.Join([]string{"BackupInfo", string(data)}, " ")
}

type BackupInfoStatus struct {
	value string
}

type BackupInfoStatusEnum struct {
	BUILDING  BackupInfoStatus
	COMPLETED BackupInfoStatus
	FAILED    BackupInfoStatus
	DELETING  BackupInfoStatus
}

func GetBackupInfoStatusEnum() BackupInfoStatusEnum {
	return BackupInfoStatusEnum{
		BUILDING: BackupInfoStatus{
			value: "BUILDING",
		},
		COMPLETED: BackupInfoStatus{
			value: "COMPLETED",
		},
		FAILED: BackupInfoStatus{
			value: "FAILED",
		},
		DELETING: BackupInfoStatus{
			value: "DELETING",
		},
	}
}

func (c BackupInfoStatus) Value() string {
	return c.value
}

func (c BackupInfoStatus) MarshalJSON() ([]byte, error) {
	return utils.Marshal(c.value)
}

func (c *BackupInfoStatus) UnmarshalJSON(b []byte) error {
	myConverter := converter.StringConverterFactory("string")
	if myConverter == nil {
		return errors.New("unsupported StringConverter type: string")
	}

	interf, err := myConverter.CovertStringToInterface(strings.Trim(string(b[:]), "\""))
	if err != nil {
		return err
	}

	if val, ok := interf.(string); ok {
		c.value = val
		return nil
	} else {
		return errors.New("convert enum data to string error")
	}
}

type BackupInfoType struct {
	value string
}

type BackupInfoTypeEnum struct {
	MANUAL BackupInfoType
}

func GetBackupInfoTypeEnum() BackupInfoTypeEnum {
	return BackupInfoTypeEnum{
		MANUAL: BackupInfoType{
			value: "manual",
		},
	}
}

func (c BackupInfoType) Value() string {
	return c.value
}

func (c BackupInfoType) MarshalJSON() ([]byte, error) {
	return utils.Marshal(c.value)
}

func (c *BackupInfoType) UnmarshalJSON(b []byte) error {
	myConverter := converter.StringConverterFactory("string")
	if myConverter == nil {
		return errors.New("unsupported StringConverter type: string")
	}

	interf, err := myConverter.CovertStringToInterface(strings.Trim(string(b[:]), "\""))
	if err != nil {
		return err
	}

	if val, ok := interf.(string); ok {
		c.value = val
		return nil
	} else {
		return errors.New("convert enum data to string error")
	}
}
