package model

import (
	"github.com/huaweicloud/huaweicloud-sdk-go-v3/core/utils"

	"errors"
	"github.com/huaweicloud/huaweicloud-sdk-go-v3/core/converter"

	"strings"
)

type TemplateType struct {
	value string
}

type TemplateTypeEnum struct {
	MOBILE       TemplateType
	MICROSERVICE TemplateType
	WEB          TemplateType
	FUNCTION     TemplateType
	IOT          TemplateType
	AI           TemplateType
	OTHERS       TemplateType
	NONE         TemplateType
}

func GetTemplateTypeEnum() TemplateTypeEnum {
	return TemplateTypeEnum{
		MOBILE: TemplateType{
			value: "mobile",
		},
		MICROSERVICE: TemplateType{
			value: "microservice",
		},
		WEB: TemplateType{
			value: "web",
		},
		FUNCTION: TemplateType{
			value: "function",
		},
		IOT: TemplateType{
			value: "iot",
		},
		AI: TemplateType{
			value: "ai",
		},
		OTHERS: TemplateType{
			value: "others",
		},
		NONE: TemplateType{
			value: "none",
		},
	}
}

func (c TemplateType) Value() string {
	return c.value
}

func (c TemplateType) MarshalJSON() ([]byte, error) {
	return utils.Marshal(c.value)
}

func (c *TemplateType) UnmarshalJSON(b []byte) error {
	myConverter := converter.StringConverterFactory("string")
	if myConverter == nil {
		return errors.New("unsupported StringConverter type: string")
	}

	interf, err := myConverter.CovertStringToInterface(strings.Trim(string(b[:]), "\""))
	if err != nil {
		return err
	}

	if val, ok := interf.(string); ok {
		c.value = val
		return nil
	} else {
		return errors.New("convert enum data to string error")
	}
}
