// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/ai/generativelanguage/v1alpha/retriever_service.proto

package generativelanguagepb

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	RetrieverService_CreateCorpus_FullMethodName      = "/google.ai.generativelanguage.v1alpha.RetrieverService/CreateCorpus"
	RetrieverService_GetCorpus_FullMethodName         = "/google.ai.generativelanguage.v1alpha.RetrieverService/GetCorpus"
	RetrieverService_UpdateCorpus_FullMethodName      = "/google.ai.generativelanguage.v1alpha.RetrieverService/UpdateCorpus"
	RetrieverService_DeleteCorpus_FullMethodName      = "/google.ai.generativelanguage.v1alpha.RetrieverService/DeleteCorpus"
	RetrieverService_ListCorpora_FullMethodName       = "/google.ai.generativelanguage.v1alpha.RetrieverService/ListCorpora"
	RetrieverService_QueryCorpus_FullMethodName       = "/google.ai.generativelanguage.v1alpha.RetrieverService/QueryCorpus"
	RetrieverService_CreateDocument_FullMethodName    = "/google.ai.generativelanguage.v1alpha.RetrieverService/CreateDocument"
	RetrieverService_GetDocument_FullMethodName       = "/google.ai.generativelanguage.v1alpha.RetrieverService/GetDocument"
	RetrieverService_UpdateDocument_FullMethodName    = "/google.ai.generativelanguage.v1alpha.RetrieverService/UpdateDocument"
	RetrieverService_DeleteDocument_FullMethodName    = "/google.ai.generativelanguage.v1alpha.RetrieverService/DeleteDocument"
	RetrieverService_ListDocuments_FullMethodName     = "/google.ai.generativelanguage.v1alpha.RetrieverService/ListDocuments"
	RetrieverService_QueryDocument_FullMethodName     = "/google.ai.generativelanguage.v1alpha.RetrieverService/QueryDocument"
	RetrieverService_CreateChunk_FullMethodName       = "/google.ai.generativelanguage.v1alpha.RetrieverService/CreateChunk"
	RetrieverService_BatchCreateChunks_FullMethodName = "/google.ai.generativelanguage.v1alpha.RetrieverService/BatchCreateChunks"
	RetrieverService_GetChunk_FullMethodName          = "/google.ai.generativelanguage.v1alpha.RetrieverService/GetChunk"
	RetrieverService_UpdateChunk_FullMethodName       = "/google.ai.generativelanguage.v1alpha.RetrieverService/UpdateChunk"
	RetrieverService_BatchUpdateChunks_FullMethodName = "/google.ai.generativelanguage.v1alpha.RetrieverService/BatchUpdateChunks"
	RetrieverService_DeleteChunk_FullMethodName       = "/google.ai.generativelanguage.v1alpha.RetrieverService/DeleteChunk"
	RetrieverService_BatchDeleteChunks_FullMethodName = "/google.ai.generativelanguage.v1alpha.RetrieverService/BatchDeleteChunks"
	RetrieverService_ListChunks_FullMethodName        = "/google.ai.generativelanguage.v1alpha.RetrieverService/ListChunks"
)

// RetrieverServiceClient is the client API for RetrieverService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type RetrieverServiceClient interface {
	// Creates an empty `Corpus`.
	CreateCorpus(ctx context.Context, in *CreateCorpusRequest, opts ...grpc.CallOption) (*Corpus, error)
	// Gets information about a specific `Corpus`.
	GetCorpus(ctx context.Context, in *GetCorpusRequest, opts ...grpc.CallOption) (*Corpus, error)
	// Updates a `Corpus`.
	UpdateCorpus(ctx context.Context, in *UpdateCorpusRequest, opts ...grpc.CallOption) (*Corpus, error)
	// Deletes a `Corpus`.
	DeleteCorpus(ctx context.Context, in *DeleteCorpusRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Lists all `Corpora` owned by the user.
	ListCorpora(ctx context.Context, in *ListCorporaRequest, opts ...grpc.CallOption) (*ListCorporaResponse, error)
	// Performs semantic search over a `Corpus`.
	QueryCorpus(ctx context.Context, in *QueryCorpusRequest, opts ...grpc.CallOption) (*QueryCorpusResponse, error)
	// Creates an empty `Document`.
	CreateDocument(ctx context.Context, in *CreateDocumentRequest, opts ...grpc.CallOption) (*Document, error)
	// Gets information about a specific `Document`.
	GetDocument(ctx context.Context, in *GetDocumentRequest, opts ...grpc.CallOption) (*Document, error)
	// Updates a `Document`.
	UpdateDocument(ctx context.Context, in *UpdateDocumentRequest, opts ...grpc.CallOption) (*Document, error)
	// Deletes a `Document`.
	DeleteDocument(ctx context.Context, in *DeleteDocumentRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Lists all `Document`s in a `Corpus`.
	ListDocuments(ctx context.Context, in *ListDocumentsRequest, opts ...grpc.CallOption) (*ListDocumentsResponse, error)
	// Performs semantic search over a `Document`.
	QueryDocument(ctx context.Context, in *QueryDocumentRequest, opts ...grpc.CallOption) (*QueryDocumentResponse, error)
	// Creates a `Chunk`.
	CreateChunk(ctx context.Context, in *CreateChunkRequest, opts ...grpc.CallOption) (*Chunk, error)
	// Batch create `Chunk`s.
	BatchCreateChunks(ctx context.Context, in *BatchCreateChunksRequest, opts ...grpc.CallOption) (*BatchCreateChunksResponse, error)
	// Gets information about a specific `Chunk`.
	GetChunk(ctx context.Context, in *GetChunkRequest, opts ...grpc.CallOption) (*Chunk, error)
	// Updates a `Chunk`.
	UpdateChunk(ctx context.Context, in *UpdateChunkRequest, opts ...grpc.CallOption) (*Chunk, error)
	// Batch update `Chunk`s.
	BatchUpdateChunks(ctx context.Context, in *BatchUpdateChunksRequest, opts ...grpc.CallOption) (*BatchUpdateChunksResponse, error)
	// Deletes a `Chunk`.
	DeleteChunk(ctx context.Context, in *DeleteChunkRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Batch delete `Chunk`s.
	BatchDeleteChunks(ctx context.Context, in *BatchDeleteChunksRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Lists all `Chunk`s in a `Document`.
	ListChunks(ctx context.Context, in *ListChunksRequest, opts ...grpc.CallOption) (*ListChunksResponse, error)
}

type retrieverServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewRetrieverServiceClient(cc grpc.ClientConnInterface) RetrieverServiceClient {
	return &retrieverServiceClient{cc}
}

func (c *retrieverServiceClient) CreateCorpus(ctx context.Context, in *CreateCorpusRequest, opts ...grpc.CallOption) (*Corpus, error) {
	out := new(Corpus)
	err := c.cc.Invoke(ctx, RetrieverService_CreateCorpus_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *retrieverServiceClient) GetCorpus(ctx context.Context, in *GetCorpusRequest, opts ...grpc.CallOption) (*Corpus, error) {
	out := new(Corpus)
	err := c.cc.Invoke(ctx, RetrieverService_GetCorpus_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *retrieverServiceClient) UpdateCorpus(ctx context.Context, in *UpdateCorpusRequest, opts ...grpc.CallOption) (*Corpus, error) {
	out := new(Corpus)
	err := c.cc.Invoke(ctx, RetrieverService_UpdateCorpus_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *retrieverServiceClient) DeleteCorpus(ctx context.Context, in *DeleteCorpusRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, RetrieverService_DeleteCorpus_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *retrieverServiceClient) ListCorpora(ctx context.Context, in *ListCorporaRequest, opts ...grpc.CallOption) (*ListCorporaResponse, error) {
	out := new(ListCorporaResponse)
	err := c.cc.Invoke(ctx, RetrieverService_ListCorpora_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *retrieverServiceClient) QueryCorpus(ctx context.Context, in *QueryCorpusRequest, opts ...grpc.CallOption) (*QueryCorpusResponse, error) {
	out := new(QueryCorpusResponse)
	err := c.cc.Invoke(ctx, RetrieverService_QueryCorpus_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *retrieverServiceClient) CreateDocument(ctx context.Context, in *CreateDocumentRequest, opts ...grpc.CallOption) (*Document, error) {
	out := new(Document)
	err := c.cc.Invoke(ctx, RetrieverService_CreateDocument_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *retrieverServiceClient) GetDocument(ctx context.Context, in *GetDocumentRequest, opts ...grpc.CallOption) (*Document, error) {
	out := new(Document)
	err := c.cc.Invoke(ctx, RetrieverService_GetDocument_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *retrieverServiceClient) UpdateDocument(ctx context.Context, in *UpdateDocumentRequest, opts ...grpc.CallOption) (*Document, error) {
	out := new(Document)
	err := c.cc.Invoke(ctx, RetrieverService_UpdateDocument_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *retrieverServiceClient) DeleteDocument(ctx context.Context, in *DeleteDocumentRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, RetrieverService_DeleteDocument_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *retrieverServiceClient) ListDocuments(ctx context.Context, in *ListDocumentsRequest, opts ...grpc.CallOption) (*ListDocumentsResponse, error) {
	out := new(ListDocumentsResponse)
	err := c.cc.Invoke(ctx, RetrieverService_ListDocuments_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *retrieverServiceClient) QueryDocument(ctx context.Context, in *QueryDocumentRequest, opts ...grpc.CallOption) (*QueryDocumentResponse, error) {
	out := new(QueryDocumentResponse)
	err := c.cc.Invoke(ctx, RetrieverService_QueryDocument_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *retrieverServiceClient) CreateChunk(ctx context.Context, in *CreateChunkRequest, opts ...grpc.CallOption) (*Chunk, error) {
	out := new(Chunk)
	err := c.cc.Invoke(ctx, RetrieverService_CreateChunk_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *retrieverServiceClient) BatchCreateChunks(ctx context.Context, in *BatchCreateChunksRequest, opts ...grpc.CallOption) (*BatchCreateChunksResponse, error) {
	out := new(BatchCreateChunksResponse)
	err := c.cc.Invoke(ctx, RetrieverService_BatchCreateChunks_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *retrieverServiceClient) GetChunk(ctx context.Context, in *GetChunkRequest, opts ...grpc.CallOption) (*Chunk, error) {
	out := new(Chunk)
	err := c.cc.Invoke(ctx, RetrieverService_GetChunk_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *retrieverServiceClient) UpdateChunk(ctx context.Context, in *UpdateChunkRequest, opts ...grpc.CallOption) (*Chunk, error) {
	out := new(Chunk)
	err := c.cc.Invoke(ctx, RetrieverService_UpdateChunk_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *retrieverServiceClient) BatchUpdateChunks(ctx context.Context, in *BatchUpdateChunksRequest, opts ...grpc.CallOption) (*BatchUpdateChunksResponse, error) {
	out := new(BatchUpdateChunksResponse)
	err := c.cc.Invoke(ctx, RetrieverService_BatchUpdateChunks_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *retrieverServiceClient) DeleteChunk(ctx context.Context, in *DeleteChunkRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, RetrieverService_DeleteChunk_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *retrieverServiceClient) BatchDeleteChunks(ctx context.Context, in *BatchDeleteChunksRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, RetrieverService_BatchDeleteChunks_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *retrieverServiceClient) ListChunks(ctx context.Context, in *ListChunksRequest, opts ...grpc.CallOption) (*ListChunksResponse, error) {
	out := new(ListChunksResponse)
	err := c.cc.Invoke(ctx, RetrieverService_ListChunks_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// RetrieverServiceServer is the server API for RetrieverService service.
// All implementations should embed UnimplementedRetrieverServiceServer
// for forward compatibility
type RetrieverServiceServer interface {
	// Creates an empty `Corpus`.
	CreateCorpus(context.Context, *CreateCorpusRequest) (*Corpus, error)
	// Gets information about a specific `Corpus`.
	GetCorpus(context.Context, *GetCorpusRequest) (*Corpus, error)
	// Updates a `Corpus`.
	UpdateCorpus(context.Context, *UpdateCorpusRequest) (*Corpus, error)
	// Deletes a `Corpus`.
	DeleteCorpus(context.Context, *DeleteCorpusRequest) (*emptypb.Empty, error)
	// Lists all `Corpora` owned by the user.
	ListCorpora(context.Context, *ListCorporaRequest) (*ListCorporaResponse, error)
	// Performs semantic search over a `Corpus`.
	QueryCorpus(context.Context, *QueryCorpusRequest) (*QueryCorpusResponse, error)
	// Creates an empty `Document`.
	CreateDocument(context.Context, *CreateDocumentRequest) (*Document, error)
	// Gets information about a specific `Document`.
	GetDocument(context.Context, *GetDocumentRequest) (*Document, error)
	// Updates a `Document`.
	UpdateDocument(context.Context, *UpdateDocumentRequest) (*Document, error)
	// Deletes a `Document`.
	DeleteDocument(context.Context, *DeleteDocumentRequest) (*emptypb.Empty, error)
	// Lists all `Document`s in a `Corpus`.
	ListDocuments(context.Context, *ListDocumentsRequest) (*ListDocumentsResponse, error)
	// Performs semantic search over a `Document`.
	QueryDocument(context.Context, *QueryDocumentRequest) (*QueryDocumentResponse, error)
	// Creates a `Chunk`.
	CreateChunk(context.Context, *CreateChunkRequest) (*Chunk, error)
	// Batch create `Chunk`s.
	BatchCreateChunks(context.Context, *BatchCreateChunksRequest) (*BatchCreateChunksResponse, error)
	// Gets information about a specific `Chunk`.
	GetChunk(context.Context, *GetChunkRequest) (*Chunk, error)
	// Updates a `Chunk`.
	UpdateChunk(context.Context, *UpdateChunkRequest) (*Chunk, error)
	// Batch update `Chunk`s.
	BatchUpdateChunks(context.Context, *BatchUpdateChunksRequest) (*BatchUpdateChunksResponse, error)
	// Deletes a `Chunk`.
	DeleteChunk(context.Context, *DeleteChunkRequest) (*emptypb.Empty, error)
	// Batch delete `Chunk`s.
	BatchDeleteChunks(context.Context, *BatchDeleteChunksRequest) (*emptypb.Empty, error)
	// Lists all `Chunk`s in a `Document`.
	ListChunks(context.Context, *ListChunksRequest) (*ListChunksResponse, error)
}

// UnimplementedRetrieverServiceServer should be embedded to have forward compatible implementations.
type UnimplementedRetrieverServiceServer struct {
}

func (UnimplementedRetrieverServiceServer) CreateCorpus(context.Context, *CreateCorpusRequest) (*Corpus, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateCorpus not implemented")
}
func (UnimplementedRetrieverServiceServer) GetCorpus(context.Context, *GetCorpusRequest) (*Corpus, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetCorpus not implemented")
}
func (UnimplementedRetrieverServiceServer) UpdateCorpus(context.Context, *UpdateCorpusRequest) (*Corpus, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateCorpus not implemented")
}
func (UnimplementedRetrieverServiceServer) DeleteCorpus(context.Context, *DeleteCorpusRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteCorpus not implemented")
}
func (UnimplementedRetrieverServiceServer) ListCorpora(context.Context, *ListCorporaRequest) (*ListCorporaResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListCorpora not implemented")
}
func (UnimplementedRetrieverServiceServer) QueryCorpus(context.Context, *QueryCorpusRequest) (*QueryCorpusResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method QueryCorpus not implemented")
}
func (UnimplementedRetrieverServiceServer) CreateDocument(context.Context, *CreateDocumentRequest) (*Document, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateDocument not implemented")
}
func (UnimplementedRetrieverServiceServer) GetDocument(context.Context, *GetDocumentRequest) (*Document, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetDocument not implemented")
}
func (UnimplementedRetrieverServiceServer) UpdateDocument(context.Context, *UpdateDocumentRequest) (*Document, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateDocument not implemented")
}
func (UnimplementedRetrieverServiceServer) DeleteDocument(context.Context, *DeleteDocumentRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteDocument not implemented")
}
func (UnimplementedRetrieverServiceServer) ListDocuments(context.Context, *ListDocumentsRequest) (*ListDocumentsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListDocuments not implemented")
}
func (UnimplementedRetrieverServiceServer) QueryDocument(context.Context, *QueryDocumentRequest) (*QueryDocumentResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method QueryDocument not implemented")
}
func (UnimplementedRetrieverServiceServer) CreateChunk(context.Context, *CreateChunkRequest) (*Chunk, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateChunk not implemented")
}
func (UnimplementedRetrieverServiceServer) BatchCreateChunks(context.Context, *BatchCreateChunksRequest) (*BatchCreateChunksResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BatchCreateChunks not implemented")
}
func (UnimplementedRetrieverServiceServer) GetChunk(context.Context, *GetChunkRequest) (*Chunk, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetChunk not implemented")
}
func (UnimplementedRetrieverServiceServer) UpdateChunk(context.Context, *UpdateChunkRequest) (*Chunk, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateChunk not implemented")
}
func (UnimplementedRetrieverServiceServer) BatchUpdateChunks(context.Context, *BatchUpdateChunksRequest) (*BatchUpdateChunksResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BatchUpdateChunks not implemented")
}
func (UnimplementedRetrieverServiceServer) DeleteChunk(context.Context, *DeleteChunkRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteChunk not implemented")
}
func (UnimplementedRetrieverServiceServer) BatchDeleteChunks(context.Context, *BatchDeleteChunksRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BatchDeleteChunks not implemented")
}
func (UnimplementedRetrieverServiceServer) ListChunks(context.Context, *ListChunksRequest) (*ListChunksResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListChunks not implemented")
}

// UnsafeRetrieverServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to RetrieverServiceServer will
// result in compilation errors.
type UnsafeRetrieverServiceServer interface {
	mustEmbedUnimplementedRetrieverServiceServer()
}

func RegisterRetrieverServiceServer(s grpc.ServiceRegistrar, srv RetrieverServiceServer) {
	s.RegisterService(&RetrieverService_ServiceDesc, srv)
}

func _RetrieverService_CreateCorpus_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateCorpusRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RetrieverServiceServer).CreateCorpus(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: RetrieverService_CreateCorpus_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RetrieverServiceServer).CreateCorpus(ctx, req.(*CreateCorpusRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RetrieverService_GetCorpus_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetCorpusRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RetrieverServiceServer).GetCorpus(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: RetrieverService_GetCorpus_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RetrieverServiceServer).GetCorpus(ctx, req.(*GetCorpusRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RetrieverService_UpdateCorpus_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateCorpusRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RetrieverServiceServer).UpdateCorpus(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: RetrieverService_UpdateCorpus_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RetrieverServiceServer).UpdateCorpus(ctx, req.(*UpdateCorpusRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RetrieverService_DeleteCorpus_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteCorpusRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RetrieverServiceServer).DeleteCorpus(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: RetrieverService_DeleteCorpus_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RetrieverServiceServer).DeleteCorpus(ctx, req.(*DeleteCorpusRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RetrieverService_ListCorpora_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListCorporaRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RetrieverServiceServer).ListCorpora(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: RetrieverService_ListCorpora_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RetrieverServiceServer).ListCorpora(ctx, req.(*ListCorporaRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RetrieverService_QueryCorpus_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(QueryCorpusRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RetrieverServiceServer).QueryCorpus(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: RetrieverService_QueryCorpus_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RetrieverServiceServer).QueryCorpus(ctx, req.(*QueryCorpusRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RetrieverService_CreateDocument_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateDocumentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RetrieverServiceServer).CreateDocument(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: RetrieverService_CreateDocument_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RetrieverServiceServer).CreateDocument(ctx, req.(*CreateDocumentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RetrieverService_GetDocument_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetDocumentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RetrieverServiceServer).GetDocument(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: RetrieverService_GetDocument_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RetrieverServiceServer).GetDocument(ctx, req.(*GetDocumentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RetrieverService_UpdateDocument_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateDocumentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RetrieverServiceServer).UpdateDocument(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: RetrieverService_UpdateDocument_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RetrieverServiceServer).UpdateDocument(ctx, req.(*UpdateDocumentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RetrieverService_DeleteDocument_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteDocumentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RetrieverServiceServer).DeleteDocument(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: RetrieverService_DeleteDocument_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RetrieverServiceServer).DeleteDocument(ctx, req.(*DeleteDocumentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RetrieverService_ListDocuments_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListDocumentsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RetrieverServiceServer).ListDocuments(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: RetrieverService_ListDocuments_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RetrieverServiceServer).ListDocuments(ctx, req.(*ListDocumentsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RetrieverService_QueryDocument_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(QueryDocumentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RetrieverServiceServer).QueryDocument(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: RetrieverService_QueryDocument_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RetrieverServiceServer).QueryDocument(ctx, req.(*QueryDocumentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RetrieverService_CreateChunk_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateChunkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RetrieverServiceServer).CreateChunk(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: RetrieverService_CreateChunk_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RetrieverServiceServer).CreateChunk(ctx, req.(*CreateChunkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RetrieverService_BatchCreateChunks_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchCreateChunksRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RetrieverServiceServer).BatchCreateChunks(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: RetrieverService_BatchCreateChunks_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RetrieverServiceServer).BatchCreateChunks(ctx, req.(*BatchCreateChunksRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RetrieverService_GetChunk_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetChunkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RetrieverServiceServer).GetChunk(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: RetrieverService_GetChunk_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RetrieverServiceServer).GetChunk(ctx, req.(*GetChunkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RetrieverService_UpdateChunk_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateChunkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RetrieverServiceServer).UpdateChunk(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: RetrieverService_UpdateChunk_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RetrieverServiceServer).UpdateChunk(ctx, req.(*UpdateChunkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RetrieverService_BatchUpdateChunks_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchUpdateChunksRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RetrieverServiceServer).BatchUpdateChunks(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: RetrieverService_BatchUpdateChunks_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RetrieverServiceServer).BatchUpdateChunks(ctx, req.(*BatchUpdateChunksRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RetrieverService_DeleteChunk_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteChunkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RetrieverServiceServer).DeleteChunk(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: RetrieverService_DeleteChunk_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RetrieverServiceServer).DeleteChunk(ctx, req.(*DeleteChunkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RetrieverService_BatchDeleteChunks_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchDeleteChunksRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RetrieverServiceServer).BatchDeleteChunks(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: RetrieverService_BatchDeleteChunks_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RetrieverServiceServer).BatchDeleteChunks(ctx, req.(*BatchDeleteChunksRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RetrieverService_ListChunks_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListChunksRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RetrieverServiceServer).ListChunks(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: RetrieverService_ListChunks_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RetrieverServiceServer).ListChunks(ctx, req.(*ListChunksRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// RetrieverService_ServiceDesc is the grpc.ServiceDesc for RetrieverService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var RetrieverService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.ai.generativelanguage.v1alpha.RetrieverService",
	HandlerType: (*RetrieverServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateCorpus",
			Handler:    _RetrieverService_CreateCorpus_Handler,
		},
		{
			MethodName: "GetCorpus",
			Handler:    _RetrieverService_GetCorpus_Handler,
		},
		{
			MethodName: "UpdateCorpus",
			Handler:    _RetrieverService_UpdateCorpus_Handler,
		},
		{
			MethodName: "DeleteCorpus",
			Handler:    _RetrieverService_DeleteCorpus_Handler,
		},
		{
			MethodName: "ListCorpora",
			Handler:    _RetrieverService_ListCorpora_Handler,
		},
		{
			MethodName: "QueryCorpus",
			Handler:    _RetrieverService_QueryCorpus_Handler,
		},
		{
			MethodName: "CreateDocument",
			Handler:    _RetrieverService_CreateDocument_Handler,
		},
		{
			MethodName: "GetDocument",
			Handler:    _RetrieverService_GetDocument_Handler,
		},
		{
			MethodName: "UpdateDocument",
			Handler:    _RetrieverService_UpdateDocument_Handler,
		},
		{
			MethodName: "DeleteDocument",
			Handler:    _RetrieverService_DeleteDocument_Handler,
		},
		{
			MethodName: "ListDocuments",
			Handler:    _RetrieverService_ListDocuments_Handler,
		},
		{
			MethodName: "QueryDocument",
			Handler:    _RetrieverService_QueryDocument_Handler,
		},
		{
			MethodName: "CreateChunk",
			Handler:    _RetrieverService_CreateChunk_Handler,
		},
		{
			MethodName: "BatchCreateChunks",
			Handler:    _RetrieverService_BatchCreateChunks_Handler,
		},
		{
			MethodName: "GetChunk",
			Handler:    _RetrieverService_GetChunk_Handler,
		},
		{
			MethodName: "UpdateChunk",
			Handler:    _RetrieverService_UpdateChunk_Handler,
		},
		{
			MethodName: "BatchUpdateChunks",
			Handler:    _RetrieverService_BatchUpdateChunks_Handler,
		},
		{
			MethodName: "DeleteChunk",
			Handler:    _RetrieverService_DeleteChunk_Handler,
		},
		{
			MethodName: "BatchDeleteChunks",
			Handler:    _RetrieverService_BatchDeleteChunks_Handler,
		},
		{
			MethodName: "ListChunks",
			Handler:    _RetrieverService_ListChunks_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/ai/generativelanguage/v1alpha/retriever_service.proto",
}
