// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.7
// source: google/ai/generativelanguage/v1alpha/retriever.proto

package generativelanguagepb

import (
	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Defines the valid operators that can be applied to a key-value pair.
type Condition_Operator int32

const (
	// The default value. This value is unused.
	Condition_OPERATOR_UNSPECIFIED Condition_Operator = 0
	// Supported by numeric.
	Condition_LESS Condition_Operator = 1
	// Supported by numeric.
	Condition_LESS_EQUAL Condition_Operator = 2
	// Supported by numeric & string.
	Condition_EQUAL Condition_Operator = 3
	// Supported by numeric.
	Condition_GREATER_EQUAL Condition_Operator = 4
	// Supported by numeric.
	Condition_GREATER Condition_Operator = 5
	// Supported by numeric & string.
	Condition_NOT_EQUAL Condition_Operator = 6
	// Supported by string only when `CustomMetadata` value type for the given
	// key has a `string_list_value`.
	Condition_INCLUDES Condition_Operator = 7
	// Supported by string only when `CustomMetadata` value type for the given
	// key has a `string_list_value`.
	Condition_EXCLUDES Condition_Operator = 8
)

// Enum value maps for Condition_Operator.
var (
	Condition_Operator_name = map[int32]string{
		0: "OPERATOR_UNSPECIFIED",
		1: "LESS",
		2: "LESS_EQUAL",
		3: "EQUAL",
		4: "GREATER_EQUAL",
		5: "GREATER",
		6: "NOT_EQUAL",
		7: "INCLUDES",
		8: "EXCLUDES",
	}
	Condition_Operator_value = map[string]int32{
		"OPERATOR_UNSPECIFIED": 0,
		"LESS":                 1,
		"LESS_EQUAL":           2,
		"EQUAL":                3,
		"GREATER_EQUAL":        4,
		"GREATER":              5,
		"NOT_EQUAL":            6,
		"INCLUDES":             7,
		"EXCLUDES":             8,
	}
)

func (x Condition_Operator) Enum() *Condition_Operator {
	p := new(Condition_Operator)
	*p = x
	return p
}

func (x Condition_Operator) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Condition_Operator) Descriptor() protoreflect.EnumDescriptor {
	return file_google_ai_generativelanguage_v1alpha_retriever_proto_enumTypes[0].Descriptor()
}

func (Condition_Operator) Type() protoreflect.EnumType {
	return &file_google_ai_generativelanguage_v1alpha_retriever_proto_enumTypes[0]
}

func (x Condition_Operator) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Condition_Operator.Descriptor instead.
func (Condition_Operator) EnumDescriptor() ([]byte, []int) {
	return file_google_ai_generativelanguage_v1alpha_retriever_proto_rawDescGZIP(), []int{5, 0}
}

// States for the lifecycle of a `Chunk`.
type Chunk_State int32

const (
	// The default value. This value is used if the state is omitted.
	Chunk_STATE_UNSPECIFIED Chunk_State = 0
	// `Chunk` is being processed (embedding and vector storage).
	Chunk_STATE_PENDING_PROCESSING Chunk_State = 1
	// `Chunk` is processed and available for querying.
	Chunk_STATE_ACTIVE Chunk_State = 2
	// `Chunk` failed processing.
	Chunk_STATE_FAILED Chunk_State = 10
)

// Enum value maps for Chunk_State.
var (
	Chunk_State_name = map[int32]string{
		0:  "STATE_UNSPECIFIED",
		1:  "STATE_PENDING_PROCESSING",
		2:  "STATE_ACTIVE",
		10: "STATE_FAILED",
	}
	Chunk_State_value = map[string]int32{
		"STATE_UNSPECIFIED":        0,
		"STATE_PENDING_PROCESSING": 1,
		"STATE_ACTIVE":             2,
		"STATE_FAILED":             10,
	}
)

func (x Chunk_State) Enum() *Chunk_State {
	p := new(Chunk_State)
	*p = x
	return p
}

func (x Chunk_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Chunk_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_ai_generativelanguage_v1alpha_retriever_proto_enumTypes[1].Descriptor()
}

func (Chunk_State) Type() protoreflect.EnumType {
	return &file_google_ai_generativelanguage_v1alpha_retriever_proto_enumTypes[1]
}

func (x Chunk_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Chunk_State.Descriptor instead.
func (Chunk_State) EnumDescriptor() ([]byte, []int) {
	return file_google_ai_generativelanguage_v1alpha_retriever_proto_rawDescGZIP(), []int{6, 0}
}

// A `Corpus` is a collection of `Document`s.
// A project can create up to 5 corpora.
type Corpus struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Immutable. Identifier. The `Corpus` resource name. The ID (name excluding
	// the "corpora/" prefix) can contain up to 40 characters that are lowercase
	// alphanumeric or dashes
	// (-). The ID cannot start or end with a dash. If the name is empty on
	// create, a unique name will be derived from `display_name` along with a 12
	// character random suffix.
	// Example: `corpora/my-awesome-corpora-123a456b789c`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. The human-readable display name for the `Corpus`. The display
	// name must be no more than 512 characters in length, including spaces.
	// Example: "Docs on Semantic Retriever"
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Output only. The Timestamp of when the `Corpus` was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The Timestamp of when the `Corpus` was last updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
}

func (x *Corpus) Reset() {
	*x = Corpus{}
	mi := &file_google_ai_generativelanguage_v1alpha_retriever_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Corpus) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Corpus) ProtoMessage() {}

func (x *Corpus) ProtoReflect() protoreflect.Message {
	mi := &file_google_ai_generativelanguage_v1alpha_retriever_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Corpus.ProtoReflect.Descriptor instead.
func (*Corpus) Descriptor() ([]byte, []int) {
	return file_google_ai_generativelanguage_v1alpha_retriever_proto_rawDescGZIP(), []int{0}
}

func (x *Corpus) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Corpus) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *Corpus) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Corpus) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

// A `Document` is a collection of `Chunk`s.
// A `Corpus` can have a maximum of 10,000 `Document`s.
type Document struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Immutable. Identifier. The `Document` resource name. The ID (name excluding
	// the "corpora/*/documents/" prefix) can contain up to 40 characters that are
	// lowercase alphanumeric or dashes (-). The ID cannot start or end with a
	// dash. If the name is empty on create, a unique name will be derived from
	// `display_name` along with a 12 character random suffix.
	// Example: `corpora/{corpus_id}/documents/my-awesome-doc-123a456b789c`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. The human-readable display name for the `Document`. The display
	// name must be no more than 512 characters in length, including spaces.
	// Example: "Semantic Retriever Documentation"
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Optional. User provided custom metadata stored as key-value pairs used for
	// querying. A `Document` can have a maximum of 20 `CustomMetadata`.
	CustomMetadata []*CustomMetadata `protobuf:"bytes,3,rep,name=custom_metadata,json=customMetadata,proto3" json:"custom_metadata,omitempty"`
	// Output only. The Timestamp of when the `Document` was last updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Output only. The Timestamp of when the `Document` was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
}

func (x *Document) Reset() {
	*x = Document{}
	mi := &file_google_ai_generativelanguage_v1alpha_retriever_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Document) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Document) ProtoMessage() {}

func (x *Document) ProtoReflect() protoreflect.Message {
	mi := &file_google_ai_generativelanguage_v1alpha_retriever_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Document.ProtoReflect.Descriptor instead.
func (*Document) Descriptor() ([]byte, []int) {
	return file_google_ai_generativelanguage_v1alpha_retriever_proto_rawDescGZIP(), []int{1}
}

func (x *Document) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Document) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *Document) GetCustomMetadata() []*CustomMetadata {
	if x != nil {
		return x.CustomMetadata
	}
	return nil
}

func (x *Document) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *Document) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

// User provided string values assigned to a single metadata key.
type StringList struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The string values of the metadata to store.
	Values []string `protobuf:"bytes,1,rep,name=values,proto3" json:"values,omitempty"`
}

func (x *StringList) Reset() {
	*x = StringList{}
	mi := &file_google_ai_generativelanguage_v1alpha_retriever_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *StringList) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StringList) ProtoMessage() {}

func (x *StringList) ProtoReflect() protoreflect.Message {
	mi := &file_google_ai_generativelanguage_v1alpha_retriever_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StringList.ProtoReflect.Descriptor instead.
func (*StringList) Descriptor() ([]byte, []int) {
	return file_google_ai_generativelanguage_v1alpha_retriever_proto_rawDescGZIP(), []int{2}
}

func (x *StringList) GetValues() []string {
	if x != nil {
		return x.Values
	}
	return nil
}

// User provided metadata stored as key-value pairs.
type CustomMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Value:
	//
	//	*CustomMetadata_StringValue
	//	*CustomMetadata_StringListValue
	//	*CustomMetadata_NumericValue
	Value isCustomMetadata_Value `protobuf_oneof:"value"`
	// Required. The key of the metadata to store.
	Key string `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
}

func (x *CustomMetadata) Reset() {
	*x = CustomMetadata{}
	mi := &file_google_ai_generativelanguage_v1alpha_retriever_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CustomMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CustomMetadata) ProtoMessage() {}

func (x *CustomMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_ai_generativelanguage_v1alpha_retriever_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CustomMetadata.ProtoReflect.Descriptor instead.
func (*CustomMetadata) Descriptor() ([]byte, []int) {
	return file_google_ai_generativelanguage_v1alpha_retriever_proto_rawDescGZIP(), []int{3}
}

func (m *CustomMetadata) GetValue() isCustomMetadata_Value {
	if m != nil {
		return m.Value
	}
	return nil
}

func (x *CustomMetadata) GetStringValue() string {
	if x, ok := x.GetValue().(*CustomMetadata_StringValue); ok {
		return x.StringValue
	}
	return ""
}

func (x *CustomMetadata) GetStringListValue() *StringList {
	if x, ok := x.GetValue().(*CustomMetadata_StringListValue); ok {
		return x.StringListValue
	}
	return nil
}

func (x *CustomMetadata) GetNumericValue() float32 {
	if x, ok := x.GetValue().(*CustomMetadata_NumericValue); ok {
		return x.NumericValue
	}
	return 0
}

func (x *CustomMetadata) GetKey() string {
	if x != nil {
		return x.Key
	}
	return ""
}

type isCustomMetadata_Value interface {
	isCustomMetadata_Value()
}

type CustomMetadata_StringValue struct {
	// The string value of the metadata to store.
	StringValue string `protobuf:"bytes,2,opt,name=string_value,json=stringValue,proto3,oneof"`
}

type CustomMetadata_StringListValue struct {
	// The StringList value of the metadata to store.
	StringListValue *StringList `protobuf:"bytes,6,opt,name=string_list_value,json=stringListValue,proto3,oneof"`
}

type CustomMetadata_NumericValue struct {
	// The numeric value of the metadata to store.
	NumericValue float32 `protobuf:"fixed32,7,opt,name=numeric_value,json=numericValue,proto3,oneof"`
}

func (*CustomMetadata_StringValue) isCustomMetadata_Value() {}

func (*CustomMetadata_StringListValue) isCustomMetadata_Value() {}

func (*CustomMetadata_NumericValue) isCustomMetadata_Value() {}

// User provided filter to limit retrieval based on `Chunk` or `Document` level
// metadata values.
// Example (genre = drama OR genre = action):
//
//	key = "document.custom_metadata.genre"
//	conditions = [{string_value = "drama", operation = EQUAL},
//	              {string_value = "action", operation = EQUAL}]
type MetadataFilter struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The key of the metadata to filter on.
	Key string `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	// Required. The `Condition`s for the given key that will trigger this filter.
	// Multiple `Condition`s are joined by logical ORs.
	Conditions []*Condition `protobuf:"bytes,2,rep,name=conditions,proto3" json:"conditions,omitempty"`
}

func (x *MetadataFilter) Reset() {
	*x = MetadataFilter{}
	mi := &file_google_ai_generativelanguage_v1alpha_retriever_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MetadataFilter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MetadataFilter) ProtoMessage() {}

func (x *MetadataFilter) ProtoReflect() protoreflect.Message {
	mi := &file_google_ai_generativelanguage_v1alpha_retriever_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MetadataFilter.ProtoReflect.Descriptor instead.
func (*MetadataFilter) Descriptor() ([]byte, []int) {
	return file_google_ai_generativelanguage_v1alpha_retriever_proto_rawDescGZIP(), []int{4}
}

func (x *MetadataFilter) GetKey() string {
	if x != nil {
		return x.Key
	}
	return ""
}

func (x *MetadataFilter) GetConditions() []*Condition {
	if x != nil {
		return x.Conditions
	}
	return nil
}

// Filter condition applicable to a single key.
type Condition struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The value type must be consistent with the value type defined in the field
	// for the corresponding key. If the value types are not consistent, the
	// result will be an empty set. When the `CustomMetadata` has a `StringList`
	// value type, the filtering condition should use `string_value` paired with
	// an INCLUDES/EXCLUDES operation, otherwise the result will also be an empty
	// set.
	//
	// Types that are assignable to Value:
	//
	//	*Condition_StringValue
	//	*Condition_NumericValue
	Value isCondition_Value `protobuf_oneof:"value"`
	// Required. Operator applied to the given key-value pair to trigger the
	// condition.
	Operation Condition_Operator `protobuf:"varint,5,opt,name=operation,proto3,enum=google.ai.generativelanguage.v1alpha.Condition_Operator" json:"operation,omitempty"`
}

func (x *Condition) Reset() {
	*x = Condition{}
	mi := &file_google_ai_generativelanguage_v1alpha_retriever_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Condition) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Condition) ProtoMessage() {}

func (x *Condition) ProtoReflect() protoreflect.Message {
	mi := &file_google_ai_generativelanguage_v1alpha_retriever_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Condition.ProtoReflect.Descriptor instead.
func (*Condition) Descriptor() ([]byte, []int) {
	return file_google_ai_generativelanguage_v1alpha_retriever_proto_rawDescGZIP(), []int{5}
}

func (m *Condition) GetValue() isCondition_Value {
	if m != nil {
		return m.Value
	}
	return nil
}

func (x *Condition) GetStringValue() string {
	if x, ok := x.GetValue().(*Condition_StringValue); ok {
		return x.StringValue
	}
	return ""
}

func (x *Condition) GetNumericValue() float32 {
	if x, ok := x.GetValue().(*Condition_NumericValue); ok {
		return x.NumericValue
	}
	return 0
}

func (x *Condition) GetOperation() Condition_Operator {
	if x != nil {
		return x.Operation
	}
	return Condition_OPERATOR_UNSPECIFIED
}

type isCondition_Value interface {
	isCondition_Value()
}

type Condition_StringValue struct {
	// The string value to filter the metadata on.
	StringValue string `protobuf:"bytes,1,opt,name=string_value,json=stringValue,proto3,oneof"`
}

type Condition_NumericValue struct {
	// The numeric value to filter the metadata on.
	NumericValue float32 `protobuf:"fixed32,6,opt,name=numeric_value,json=numericValue,proto3,oneof"`
}

func (*Condition_StringValue) isCondition_Value() {}

func (*Condition_NumericValue) isCondition_Value() {}

// A `Chunk` is a subpart of a `Document` that is treated as an independent unit
// for the purposes of vector representation and storage.
// A `Corpus` can have a maximum of 1 million `Chunk`s.
type Chunk struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Immutable. Identifier. The `Chunk` resource name. The ID (name excluding
	// the "corpora/*/documents/*/chunks/" prefix) can contain up to 40 characters
	// that are lowercase alphanumeric or dashes (-). The ID cannot start or end
	// with a dash. If the name is empty on create, a random 12-character unique
	// ID will be generated.
	// Example: `corpora/{corpus_id}/documents/{document_id}/chunks/123a456b789c`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The content for the `Chunk`, such as the text string.
	// The maximum number of tokens per chunk is 2043.
	Data *ChunkData `protobuf:"bytes,2,opt,name=data,proto3" json:"data,omitempty"`
	// Optional. User provided custom metadata stored as key-value pairs.
	// The maximum number of `CustomMetadata` per chunk is 20.
	CustomMetadata []*CustomMetadata `protobuf:"bytes,3,rep,name=custom_metadata,json=customMetadata,proto3" json:"custom_metadata,omitempty"`
	// Output only. The Timestamp of when the `Chunk` was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The Timestamp of when the `Chunk` was last updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Output only. Current state of the `Chunk`.
	State Chunk_State `protobuf:"varint,6,opt,name=state,proto3,enum=google.ai.generativelanguage.v1alpha.Chunk_State" json:"state,omitempty"`
}

func (x *Chunk) Reset() {
	*x = Chunk{}
	mi := &file_google_ai_generativelanguage_v1alpha_retriever_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Chunk) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Chunk) ProtoMessage() {}

func (x *Chunk) ProtoReflect() protoreflect.Message {
	mi := &file_google_ai_generativelanguage_v1alpha_retriever_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Chunk.ProtoReflect.Descriptor instead.
func (*Chunk) Descriptor() ([]byte, []int) {
	return file_google_ai_generativelanguage_v1alpha_retriever_proto_rawDescGZIP(), []int{6}
}

func (x *Chunk) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Chunk) GetData() *ChunkData {
	if x != nil {
		return x.Data
	}
	return nil
}

func (x *Chunk) GetCustomMetadata() []*CustomMetadata {
	if x != nil {
		return x.CustomMetadata
	}
	return nil
}

func (x *Chunk) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Chunk) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *Chunk) GetState() Chunk_State {
	if x != nil {
		return x.State
	}
	return Chunk_STATE_UNSPECIFIED
}

// Extracted data that represents the `Chunk` content.
type ChunkData struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Data:
	//
	//	*ChunkData_StringValue
	Data isChunkData_Data `protobuf_oneof:"data"`
}

func (x *ChunkData) Reset() {
	*x = ChunkData{}
	mi := &file_google_ai_generativelanguage_v1alpha_retriever_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ChunkData) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ChunkData) ProtoMessage() {}

func (x *ChunkData) ProtoReflect() protoreflect.Message {
	mi := &file_google_ai_generativelanguage_v1alpha_retriever_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ChunkData.ProtoReflect.Descriptor instead.
func (*ChunkData) Descriptor() ([]byte, []int) {
	return file_google_ai_generativelanguage_v1alpha_retriever_proto_rawDescGZIP(), []int{7}
}

func (m *ChunkData) GetData() isChunkData_Data {
	if m != nil {
		return m.Data
	}
	return nil
}

func (x *ChunkData) GetStringValue() string {
	if x, ok := x.GetData().(*ChunkData_StringValue); ok {
		return x.StringValue
	}
	return ""
}

type isChunkData_Data interface {
	isChunkData_Data()
}

type ChunkData_StringValue struct {
	// The `Chunk` content as a string.
	// The maximum number of tokens per chunk is 2043.
	StringValue string `protobuf:"bytes,1,opt,name=string_value,json=stringValue,proto3,oneof"`
}

func (*ChunkData_StringValue) isChunkData_Data() {}

var File_google_ai_generativelanguage_v1alpha_retriever_proto protoreflect.FileDescriptor

var file_google_ai_generativelanguage_v1alpha_retriever_proto_rawDesc = []byte{
	0x0a, 0x34, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x69, 0x2f, 0x67, 0x65, 0x6e, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2f, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x72, 0x65, 0x74, 0x72, 0x69, 0x65, 0x76, 0x65, 0x72,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x24, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67,
	0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x1a, 0x1f, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62,
	0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xa2, 0x02, 0x0a, 0x06, 0x43, 0x6f,
	0x72, 0x70, 0x75, 0x73, 0x12, 0x1a, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x06, 0xe0, 0x41, 0x08, 0xe0, 0x41, 0x05, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x12, 0x26, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x64, 0x69, 0x73,
	0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a,
	0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x3a, 0x50, 0xea, 0x41,
	0x4d, 0x0a, 0x28, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e,
	0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6f, 0x72, 0x70, 0x75, 0x73, 0x12, 0x10, 0x63, 0x6f, 0x72,
	0x70, 0x6f, 0x72, 0x61, 0x2f, 0x7b, 0x63, 0x6f, 0x72, 0x70, 0x75, 0x73, 0x7d, 0x2a, 0x07, 0x63,
	0x6f, 0x72, 0x70, 0x6f, 0x72, 0x61, 0x32, 0x06, 0x63, 0x6f, 0x72, 0x70, 0x75, 0x73, 0x22, 0xa3,
	0x03, 0x0a, 0x08, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x1a, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x06, 0xe0, 0x41, 0x08, 0xe0, 0x41,
	0x05, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x26, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c,
	0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12,
	0x62, 0x0a, 0x0f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c,
	0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e,
	0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x0e, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x3a, 0x6b, 0xea, 0x41, 0x68, 0x0a, 0x2a, 0x67, 0x65,
	0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x25, 0x63, 0x6f, 0x72, 0x70, 0x6f, 0x72,
	0x61, 0x2f, 0x7b, 0x63, 0x6f, 0x72, 0x70, 0x75, 0x73, 0x7d, 0x2f, 0x64, 0x6f, 0x63, 0x75, 0x6d,
	0x65, 0x6e, 0x74, 0x73, 0x2f, 0x7b, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x7d, 0x2a,
	0x09, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x32, 0x08, 0x64, 0x6f, 0x63, 0x75,
	0x6d, 0x65, 0x6e, 0x74, 0x22, 0x24, 0x0a, 0x0a, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x4c, 0x69,
	0x73, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x09, 0x52, 0x06, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x22, 0xdc, 0x01, 0x0a, 0x0e, 0x43,
	0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x23, 0x0a,
	0x0c, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x0b, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x12, 0x5e, 0x0a, 0x11, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x5f, 0x6c, 0x69, 0x73,
	0x74, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x4c, 0x69, 0x73, 0x74, 0x48,
	0x00, 0x52, 0x0f, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x4c, 0x69, 0x73, 0x74, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x12, 0x25, 0x0a, 0x0d, 0x6e, 0x75, 0x6d, 0x65, 0x72, 0x69, 0x63, 0x5f, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x02, 0x48, 0x00, 0x52, 0x0c, 0x6e, 0x75, 0x6d,
	0x65, 0x72, 0x69, 0x63, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x15, 0x0a, 0x03, 0x6b, 0x65, 0x79,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x03, 0x6b, 0x65, 0x79,
	0x42, 0x07, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x22, 0x7d, 0x0a, 0x0e, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x15, 0x0a, 0x03, 0x6b,
	0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x03, 0x6b,
	0x65, 0x79, 0x12, 0x54, 0x0a, 0x0a, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e,
	0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x43, 0x6f,
	0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x63, 0x6f,
	0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0xd4, 0x02, 0x0a, 0x09, 0x43, 0x6f, 0x6e,
	0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x23, 0x0a, 0x0c, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67,
	0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x0b,
	0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x25, 0x0a, 0x0d, 0x6e,
	0x75, 0x6d, 0x65, 0x72, 0x69, 0x63, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x02, 0x48, 0x00, 0x52, 0x0c, 0x6e, 0x75, 0x6d, 0x65, 0x72, 0x69, 0x63, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x12, 0x5b, 0x0a, 0x09, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67,
	0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x43, 0x6f, 0x6e,
	0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22,
	0x94, 0x01, 0x0a, 0x08, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x12, 0x18, 0x0a, 0x14,
	0x4f, 0x50, 0x45, 0x52, 0x41, 0x54, 0x4f, 0x52, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49,
	0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x08, 0x0a, 0x04, 0x4c, 0x45, 0x53, 0x53, 0x10, 0x01,
	0x12, 0x0e, 0x0a, 0x0a, 0x4c, 0x45, 0x53, 0x53, 0x5f, 0x45, 0x51, 0x55, 0x41, 0x4c, 0x10, 0x02,
	0x12, 0x09, 0x0a, 0x05, 0x45, 0x51, 0x55, 0x41, 0x4c, 0x10, 0x03, 0x12, 0x11, 0x0a, 0x0d, 0x47,
	0x52, 0x45, 0x41, 0x54, 0x45, 0x52, 0x5f, 0x45, 0x51, 0x55, 0x41, 0x4c, 0x10, 0x04, 0x12, 0x0b,
	0x0a, 0x07, 0x47, 0x52, 0x45, 0x41, 0x54, 0x45, 0x52, 0x10, 0x05, 0x12, 0x0d, 0x0a, 0x09, 0x4e,
	0x4f, 0x54, 0x5f, 0x45, 0x51, 0x55, 0x41, 0x4c, 0x10, 0x06, 0x12, 0x0c, 0x0a, 0x08, 0x49, 0x4e,
	0x43, 0x4c, 0x55, 0x44, 0x45, 0x53, 0x10, 0x07, 0x12, 0x0c, 0x0a, 0x08, 0x45, 0x58, 0x43, 0x4c,
	0x55, 0x44, 0x45, 0x53, 0x10, 0x08, 0x42, 0x07, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x22,
	0xf8, 0x04, 0x0a, 0x05, 0x43, 0x68, 0x75, 0x6e, 0x6b, 0x12, 0x1a, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x06, 0xe0, 0x41, 0x08, 0xe0, 0x41, 0x05, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x48, 0x0a, 0x04, 0x64, 0x61, 0x74, 0x61, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x69, 0x2e,
	0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61,
	0x67, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x43, 0x68, 0x75, 0x6e, 0x6b,
	0x44, 0x61, 0x74, 0x61, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x64, 0x61, 0x74, 0x61, 0x12,
	0x62, 0x0a, 0x0f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c,
	0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e,
	0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x0e, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x4c, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65,
	0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e,
	0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x43, 0x68,
	0x75, 0x6e, 0x6b, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05,
	0x73, 0x74, 0x61, 0x74, 0x65, 0x22, 0x60, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15,
	0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x1c, 0x0a, 0x18, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x50,
	0x45, 0x4e, 0x44, 0x49, 0x4e, 0x47, 0x5f, 0x50, 0x52, 0x4f, 0x43, 0x45, 0x53, 0x53, 0x49, 0x4e,
	0x47, 0x10, 0x01, 0x12, 0x10, 0x0a, 0x0c, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x41, 0x43, 0x54,
	0x49, 0x56, 0x45, 0x10, 0x02, 0x12, 0x10, 0x0a, 0x0c, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x46,
	0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x0a, 0x3a, 0x71, 0xea, 0x41, 0x6e, 0x0a, 0x27, 0x67, 0x65,
	0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x43, 0x68, 0x75, 0x6e, 0x6b, 0x12, 0x34, 0x63, 0x6f, 0x72, 0x70, 0x6f, 0x72, 0x61, 0x2f, 0x7b,
	0x63, 0x6f, 0x72, 0x70, 0x75, 0x73, 0x7d, 0x2f, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74,
	0x73, 0x2f, 0x7b, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x7d, 0x2f, 0x63, 0x68, 0x75,
	0x6e, 0x6b, 0x73, 0x2f, 0x7b, 0x63, 0x68, 0x75, 0x6e, 0x6b, 0x7d, 0x2a, 0x06, 0x63, 0x68, 0x75,
	0x6e, 0x6b, 0x73, 0x32, 0x05, 0x63, 0x68, 0x75, 0x6e, 0x6b, 0x22, 0x38, 0x0a, 0x09, 0x43, 0x68,
	0x75, 0x6e, 0x6b, 0x44, 0x61, 0x74, 0x61, 0x12, 0x23, 0x0a, 0x0c, 0x73, 0x74, 0x72, 0x69, 0x6e,
	0x67, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52,
	0x0b, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x06, 0x0a, 0x04,
	0x64, 0x61, 0x74, 0x61, 0x42, 0x9c, 0x01, 0x0a, 0x28, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76,
	0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x42, 0x0e, 0x52, 0x65, 0x74, 0x72, 0x69, 0x65, 0x76, 0x65, 0x72, 0x50, 0x72, 0x6f, 0x74,
	0x6f, 0x50, 0x01, 0x5a, 0x5e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x61, 0x69, 0x2f, 0x67, 0x65, 0x6e, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2f, 0x61,
	0x70, 0x69, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x70, 0x62, 0x3b, 0x67,
	0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67,
	0x65, 0x70, 0x62, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_ai_generativelanguage_v1alpha_retriever_proto_rawDescOnce sync.Once
	file_google_ai_generativelanguage_v1alpha_retriever_proto_rawDescData = file_google_ai_generativelanguage_v1alpha_retriever_proto_rawDesc
)

func file_google_ai_generativelanguage_v1alpha_retriever_proto_rawDescGZIP() []byte {
	file_google_ai_generativelanguage_v1alpha_retriever_proto_rawDescOnce.Do(func() {
		file_google_ai_generativelanguage_v1alpha_retriever_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_ai_generativelanguage_v1alpha_retriever_proto_rawDescData)
	})
	return file_google_ai_generativelanguage_v1alpha_retriever_proto_rawDescData
}

var file_google_ai_generativelanguage_v1alpha_retriever_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_google_ai_generativelanguage_v1alpha_retriever_proto_msgTypes = make([]protoimpl.MessageInfo, 8)
var file_google_ai_generativelanguage_v1alpha_retriever_proto_goTypes = []any{
	(Condition_Operator)(0),       // 0: google.ai.generativelanguage.v1alpha.Condition.Operator
	(Chunk_State)(0),              // 1: google.ai.generativelanguage.v1alpha.Chunk.State
	(*Corpus)(nil),                // 2: google.ai.generativelanguage.v1alpha.Corpus
	(*Document)(nil),              // 3: google.ai.generativelanguage.v1alpha.Document
	(*StringList)(nil),            // 4: google.ai.generativelanguage.v1alpha.StringList
	(*CustomMetadata)(nil),        // 5: google.ai.generativelanguage.v1alpha.CustomMetadata
	(*MetadataFilter)(nil),        // 6: google.ai.generativelanguage.v1alpha.MetadataFilter
	(*Condition)(nil),             // 7: google.ai.generativelanguage.v1alpha.Condition
	(*Chunk)(nil),                 // 8: google.ai.generativelanguage.v1alpha.Chunk
	(*ChunkData)(nil),             // 9: google.ai.generativelanguage.v1alpha.ChunkData
	(*timestamppb.Timestamp)(nil), // 10: google.protobuf.Timestamp
}
var file_google_ai_generativelanguage_v1alpha_retriever_proto_depIdxs = []int32{
	10, // 0: google.ai.generativelanguage.v1alpha.Corpus.create_time:type_name -> google.protobuf.Timestamp
	10, // 1: google.ai.generativelanguage.v1alpha.Corpus.update_time:type_name -> google.protobuf.Timestamp
	5,  // 2: google.ai.generativelanguage.v1alpha.Document.custom_metadata:type_name -> google.ai.generativelanguage.v1alpha.CustomMetadata
	10, // 3: google.ai.generativelanguage.v1alpha.Document.update_time:type_name -> google.protobuf.Timestamp
	10, // 4: google.ai.generativelanguage.v1alpha.Document.create_time:type_name -> google.protobuf.Timestamp
	4,  // 5: google.ai.generativelanguage.v1alpha.CustomMetadata.string_list_value:type_name -> google.ai.generativelanguage.v1alpha.StringList
	7,  // 6: google.ai.generativelanguage.v1alpha.MetadataFilter.conditions:type_name -> google.ai.generativelanguage.v1alpha.Condition
	0,  // 7: google.ai.generativelanguage.v1alpha.Condition.operation:type_name -> google.ai.generativelanguage.v1alpha.Condition.Operator
	9,  // 8: google.ai.generativelanguage.v1alpha.Chunk.data:type_name -> google.ai.generativelanguage.v1alpha.ChunkData
	5,  // 9: google.ai.generativelanguage.v1alpha.Chunk.custom_metadata:type_name -> google.ai.generativelanguage.v1alpha.CustomMetadata
	10, // 10: google.ai.generativelanguage.v1alpha.Chunk.create_time:type_name -> google.protobuf.Timestamp
	10, // 11: google.ai.generativelanguage.v1alpha.Chunk.update_time:type_name -> google.protobuf.Timestamp
	1,  // 12: google.ai.generativelanguage.v1alpha.Chunk.state:type_name -> google.ai.generativelanguage.v1alpha.Chunk.State
	13, // [13:13] is the sub-list for method output_type
	13, // [13:13] is the sub-list for method input_type
	13, // [13:13] is the sub-list for extension type_name
	13, // [13:13] is the sub-list for extension extendee
	0,  // [0:13] is the sub-list for field type_name
}

func init() { file_google_ai_generativelanguage_v1alpha_retriever_proto_init() }
func file_google_ai_generativelanguage_v1alpha_retriever_proto_init() {
	if File_google_ai_generativelanguage_v1alpha_retriever_proto != nil {
		return
	}
	file_google_ai_generativelanguage_v1alpha_retriever_proto_msgTypes[3].OneofWrappers = []any{
		(*CustomMetadata_StringValue)(nil),
		(*CustomMetadata_StringListValue)(nil),
		(*CustomMetadata_NumericValue)(nil),
	}
	file_google_ai_generativelanguage_v1alpha_retriever_proto_msgTypes[5].OneofWrappers = []any{
		(*Condition_StringValue)(nil),
		(*Condition_NumericValue)(nil),
	}
	file_google_ai_generativelanguage_v1alpha_retriever_proto_msgTypes[7].OneofWrappers = []any{
		(*ChunkData_StringValue)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_ai_generativelanguage_v1alpha_retriever_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   8,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_ai_generativelanguage_v1alpha_retriever_proto_goTypes,
		DependencyIndexes: file_google_ai_generativelanguage_v1alpha_retriever_proto_depIdxs,
		EnumInfos:         file_google_ai_generativelanguage_v1alpha_retriever_proto_enumTypes,
		MessageInfos:      file_google_ai_generativelanguage_v1alpha_retriever_proto_msgTypes,
	}.Build()
	File_google_ai_generativelanguage_v1alpha_retriever_proto = out.File
	file_google_ai_generativelanguage_v1alpha_retriever_proto_rawDesc = nil
	file_google_ai_generativelanguage_v1alpha_retriever_proto_goTypes = nil
	file_google_ai_generativelanguage_v1alpha_retriever_proto_depIdxs = nil
}
