/**************************************************************************
 Copyright (c) 1996-2021 Freeciv21 and Freeciv contributors. This file is
                   part of Freeciv21. Freeciv21 is free software: you can
    ^oo^      redistribute it and/or modify it under the terms of the GNU
    (..)        General Public License  as published by the Free Software
   ()  ()       Foundation, either version 3 of the License,  or (at your
   ()__()             option) any later version. You should have received
    a copy of the GNU General Public License along with Freeciv21. If not,
                  see https://www.gnu.org/licenses/.
**************************************************************************/
#pragma once

// utility
#include "support.h" // bool type

/*
 *  temperature_map[] stores the temperature of each tile
 *  values on tmap can get one of these 4 values
 *  there is 4 extra values as macros combining the 4 basics ones
 */
typedef int temperature_type;

#define TT_FROZEN 1
#define TT_COLD 2
#define TT_TEMPERATE 4
#define TT_TROPICAL 8

#define TT_NFROZEN (TT_COLD | TT_TEMPERATE | TT_TROPICAL)
#define TT_ALL (TT_FROZEN | TT_NFROZEN)
#define TT_NHOT (TT_FROZEN | TT_COLD)
#define TT_HOT (TT_TEMPERATE | TT_TROPICAL)

bool temperature_is_initialized();
bool tmap_is(const struct tile *ptile, temperature_type tt);
bool is_temperature_type_near(const struct tile *ptile, temperature_type tt);
void destroy_tmap();
void create_tmap(bool real);
