/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.interpreter.state;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrParameterKind;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.interpreter.IrInterpreterEnvironment;
import org.jetbrains.kotlin.ir.interpreter.UtilsKt;
import org.jetbrains.kotlin.ir.interpreter.state.Complex;
import org.jetbrains.kotlin.ir.interpreter.state.State;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypeArgument;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.util.capitalizeDecapitalize.CapitalizeDecapitalizeKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0000\u0018\u0000 -2\u00020\u0001:\u0001-B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0012\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010%\u001a\u00020&H\u0016J\u0010\u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010)\u001a\u00020$J\u0012\u0010*\u001a\u0004\u0018\u00010+2\u0006\u0010)\u001a\u00020$H\u0002J\b\u0010,\u001a\u00020+H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR$\u0010\u000e\u001a\u0012\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000fj\u0002`\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001c\u0010\u0015\u001a\u0004\u0018\u00010\u0000X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R.\u0010\u001a\u001a\u0016\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u001bj\u0004\u0018\u0001`\u001cX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u0016\u0010!\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lorg/jetbrains/kotlin/ir/interpreter/state/Wrapper;", "Lorg/jetbrains/kotlin/ir/interpreter/state/Complex;", "value", "", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "environment", "Lorg/jetbrains/kotlin/ir/interpreter/IrInterpreterEnvironment;", "<init>", "(Ljava/lang/Object;Lorg/jetbrains/kotlin/ir/declarations/IrClass;Lorg/jetbrains/kotlin/ir/interpreter/IrInterpreterEnvironment;)V", "getValue", "()Ljava/lang/Object;", "getIrClass", "()Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "fields", "", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "Lorg/jetbrains/kotlin/ir/interpreter/state/State;", "Lorg/jetbrains/kotlin/ir/interpreter/stack/Fields;", "getFields", "()Ljava/util/Map;", "superWrapperClass", "getSuperWrapperClass", "()Lorg/jetbrains/kotlin/ir/interpreter/state/Wrapper;", "setSuperWrapperClass", "(Lorg/jetbrains/kotlin/ir/interpreter/state/Wrapper;)V", "outerClass", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/ir/interpreter/stack/Field;", "getOuterClass", "()Lkotlin/Pair;", "setOuterClass", "(Lkotlin/Pair;)V", "receiverClass", "Ljava/lang/Class;", "getIrFunctionByIrCall", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "getMethod", "Ljava/lang/invoke/MethodHandle;", "irFunction", "getJavaOriginalName", "", "toString", "Companion", "ir.interpreter"})
@SourceDebugExtension(value={"SMAP\nWrapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Wrapper.kt\norg/jetbrains/kotlin/ir/interpreter/state/Wrapper\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,302:1\n2945#2,12:303\n2945#2,12:351\n12637#2,2:412\n1617#3,9:315\n1869#3:324\n1870#3:326\n1626#3:327\n626#3,12:328\n808#3,11:340\n1617#3,9:363\n1869#3:372\n1870#3:374\n1626#3:375\n626#3,12:376\n808#3,11:388\n808#3,11:399\n295#3:411\n296#3:414\n1#4:325\n1#4:373\n1#4:410\n*S KotlinDebug\n*F\n+ 1 Wrapper.kt\norg/jetbrains/kotlin/ir/interpreter/state/Wrapper\n*L\n37#1:303,12\n43#1:351,12\n68#1:412,2\n38#1:315,9\n38#1:324\n38#1:326\n38#1:327\n39#1:328,12\n40#1:340,11\n44#1:363,9\n44#1:372\n44#1:374\n44#1:375\n45#1:376,12\n46#1:388,11\n49#1:399,11\n68#1:411\n68#1:414\n38#1:325\n44#1:373\n*E\n"})
public final class Wrapper
implements Complex {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Object value;
    @NotNull
    private final IrClass irClass;
    @NotNull
    private final Map<IrSymbol, State> fields;
    @Nullable
    private Wrapper superWrapperClass;
    @Nullable
    private Pair<? extends IrSymbol, ? extends State> outerClass;
    @NotNull
    private final Class<? extends Object> receiverClass;
    @NotNull
    private static final Map<String, Object> companionObjectValue = MapsKt.mapOf((Pair)TuplesKt.to((Object)"kotlin.text.Regex$Companion", (Object)Regex.Companion));
    @NotNull
    private static final Set<String> intrinsicClasses;
    @NotNull
    private static final Set<String> intrinsicJavaClasses;
    @NotNull
    private static final Map<String, String> intrinsicFunctionToHandler;
    @NotNull
    private static final Set<String> ranges;

    /*
     * WARNING - void declaration
     */
    public Wrapper(@NotNull Object value, @NotNull IrClass irClass, @NotNull IrInterpreterEnvironment environment) {
        IrClass mutableMap;
        Object[] $this$single$iv;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)irClass, (String)"irClass");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        this.value = value;
        this.irClass = irClass;
        this.fields = new LinkedHashMap();
        this.receiverClass = Wrapper.Companion.getClass(IrUtilsKt.getDefaultType(this.getIrClass()), true);
        Class<?> javaClass = this.value.getClass();
        if (Intrinsics.areEqual(javaClass, HashMap.class)) {
            void $this$filterIsInstanceTo$iv$iv;
            Pair $this$filterIsInstance$iv;
            Map<Class<?>, IrClass> $this$single$iv2;
            void $this$mapNotNullTo$iv$iv;
            Class<?>[] classArray = javaClass.getDeclaredClasses();
            Intrinsics.checkNotNullExpressionValue(classArray, (String)"getDeclaredClasses(...)");
            $this$single$iv = classArray;
            boolean $i$f$single = false;
            Object single$iv = null;
            boolean found$iv22 = false;
            for (Object element$iv : $this$single$iv) {
                Class it = (Class)element$iv;
                boolean bl = false;
                String string = it.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                if (!StringsKt.contains$default((CharSequence)string, (CharSequence)"$Node", (boolean)false, (int)2, null)) continue;
                if (found$iv22) {
                    throw new IllegalArgumentException("Array contains more than one matching element.");
                }
                single$iv = element$iv;
                found$iv22 = true;
            }
            if (!found$iv22) {
                throw new NoSuchElementException("Array contains no element matching the predicate.");
            }
            Class nodeClass = (Class)single$iv;
            Iterable $this$mapNotNull$iv = this.getIrClass().getSuperTypes();
            boolean $i$f$mapNotNull = false;
            Iterable found$iv22 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo22 = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator bl = $this$forEach$iv$iv$iv.iterator();
            while (bl.hasNext()) {
                IrClass it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = bl.next();
                boolean bl2 = false;
                IrType it = (IrType)element$iv$iv;
                boolean bl3 = false;
                IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull(it);
                if ((irClassSymbol != null ? (IrClass)irClassSymbol.getOwner() : null) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl4 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            $this$mapNotNull$iv = (List)destination$iv$iv;
            boolean $i$f$single22 = false;
            Object single$iv2 = null;
            boolean found$iv32 = false;
            Iterator $i$f$mapNotNullTo22 = $this$single$iv2.iterator();
            while ($i$f$mapNotNullTo22.hasNext()) {
                Object element$iv;
                element$iv = $i$f$mapNotNullTo22.next();
                IrClass it = (IrClass)element$iv;
                boolean bl5 = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)StandardNames.FqNames.mutableMap.shortName())) continue;
                if (found$iv32) {
                    throw new IllegalArgumentException("Collection contains more than one matching element.");
                }
                single$iv2 = element$iv;
                found$iv32 = true;
            }
            if (!found$iv32) {
                throw new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            mutableMap = (IrClass)single$iv2;
            $this$single$iv2 = environment.getJavaClassToIrClass$ir_interpreter();
            Iterable $i$f$single22 = mutableMap.getDeclarations();
            Class clazz = nodeClass;
            boolean $i$f$filterIsInstance = false;
            void found$iv32 = $this$filterIsInstance$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof IrClass)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            $this$filterIsInstance$iv = TuplesKt.to((Object)clazz, (Object)CollectionsKt.single((List)((List)destination$iv$iv2)));
            $this$single$iv2.put((Class<?>)$this$filterIsInstance$iv.getFirst(), (IrClass)$this$filterIsInstance$iv.getSecond());
        } else if (Intrinsics.areEqual(javaClass, LinkedHashMap.class)) {
            void $this$filterIsInstanceTo$iv$iv;
            Pair $this$filterIsInstance$iv2;
            Map<Class<?>, IrClass> $this$single$iv3;
            void $this$mapNotNullTo$iv$iv;
            Class<?>[] classArray = javaClass.getDeclaredClasses();
            Intrinsics.checkNotNullExpressionValue(classArray, (String)"getDeclaredClasses(...)");
            $this$single$iv = classArray;
            boolean $i$f$single = false;
            Object single$iv = null;
            boolean found$iv42 = false;
            for (Object element$iv : $this$single$iv) {
                Class it = (Class)element$iv;
                boolean bl = false;
                String string = it.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                if (!StringsKt.contains$default((CharSequence)string, (CharSequence)"$Entry", (boolean)false, (int)2, null)) continue;
                if (found$iv42) {
                    throw new IllegalArgumentException("Array contains more than one matching element.");
                }
                single$iv = element$iv;
                found$iv42 = true;
            }
            if (!found$iv42) {
                throw new NoSuchElementException("Array contains no element matching the predicate.");
            }
            Class entryClass = (Class)single$iv;
            Iterable $this$mapNotNull$iv = this.getIrClass().getSuperTypes();
            boolean $i$f$mapNotNull = false;
            Iterable found$iv42 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo32 = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator bl = $this$forEach$iv$iv$iv.iterator();
            while (bl.hasNext()) {
                IrClass it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = bl.next();
                boolean bl6 = false;
                IrType it = (IrType)element$iv$iv;
                boolean bl7 = false;
                IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull(it);
                if ((irClassSymbol != null ? (IrClass)irClassSymbol.getOwner() : null) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl8 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            $this$mapNotNull$iv = (List)destination$iv$iv;
            boolean $i$f$single32 = false;
            Object single$iv3 = null;
            boolean found$iv52 = false;
            Iterator $i$f$mapNotNullTo32 = $this$single$iv3.iterator();
            while ($i$f$mapNotNullTo32.hasNext()) {
                Object element$iv;
                element$iv = $i$f$mapNotNullTo32.next();
                IrClass it = (IrClass)element$iv;
                boolean bl9 = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)StandardNames.FqNames.mutableMap.shortName())) continue;
                if (found$iv52) {
                    throw new IllegalArgumentException("Collection contains more than one matching element.");
                }
                single$iv3 = element$iv;
                found$iv52 = true;
            }
            if (!found$iv52) {
                throw new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            mutableMap = (IrClass)single$iv3;
            $this$single$iv3 = environment.getJavaClassToIrClass$ir_interpreter();
            Iterable $i$f$single32 = mutableMap.getDeclarations();
            Class clazz = entryClass;
            boolean $i$f$filterIsInstance = false;
            void found$iv52 = $this$filterIsInstance$iv2;
            Collection destination$iv$iv3 = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof IrClass)) continue;
                destination$iv$iv3.add(element$iv$iv);
            }
            $this$filterIsInstance$iv2 = TuplesKt.to((Object)clazz, (Object)CollectionsKt.single((List)((List)destination$iv$iv3)));
            $this$single$iv3.put((Class<?>)$this$filterIsInstance$iv2.getFirst(), (IrClass)$this$filterIsInstance$iv2.getSecond());
        } else if (Intrinsics.areEqual((Object)javaClass.getCanonicalName(), (Object)"java.util.Collections.SingletonMap")) {
            void $this$filterIsInstanceTo$iv$iv;
            Map<Class<?>, IrClass> $this$filterIsInstance$iv = this.getIrClass().getDeclarations();
            boolean $i$f$filterIsInstance22 = false;
            Iterable $this$filterIsInstance$iv2 = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof IrClass)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            IrClass irClassMapEntry = (IrClass)CollectionsKt.single((List)((List)destination$iv$iv));
            $this$filterIsInstance$iv = environment.getJavaClassToIrClass$ir_interpreter();
            Pair $i$f$filterIsInstance22 = TuplesKt.to(AbstractMap.SimpleEntry.class, (Object)irClassMapEntry);
            $this$filterIsInstance$iv.put((Class<?>)$i$f$filterIsInstance22.getFirst(), (IrClass)$i$f$filterIsInstance22.getSecond());
            $this$filterIsInstance$iv = environment.getJavaClassToIrClass$ir_interpreter();
            $i$f$filterIsInstance22 = TuplesKt.to(AbstractMap.SimpleImmutableEntry.class, (Object)irClassMapEntry);
            $this$filterIsInstance$iv.put((Class<?>)$i$f$filterIsInstance22.getFirst(), (IrClass)$i$f$filterIsInstance22.getSecond());
        }
        IrClass it = environment.getJavaClassToIrClass$ir_interpreter().get(this.value.getClass());
        boolean bl = false;
        boolean bl10 = it == null || IrUtilsKt.isSubclassOf(this.getIrClass(), it);
        if (bl10) {
            environment.getJavaClassToIrClass$ir_interpreter().put(this.value.getClass(), this.getIrClass());
        }
    }

    @NotNull
    public final Object getValue() {
        return this.value;
    }

    @Override
    @NotNull
    public IrClass getIrClass() {
        return this.irClass;
    }

    @Override
    @NotNull
    public Map<IrSymbol, State> getFields() {
        return this.fields;
    }

    @Override
    @Nullable
    public Wrapper getSuperWrapperClass() {
        return this.superWrapperClass;
    }

    @Override
    public void setSuperWrapperClass(@Nullable Wrapper wrapper) {
        this.superWrapperClass = wrapper;
    }

    @Override
    @Nullable
    public Pair<IrSymbol, State> getOuterClass() {
        return this.outerClass;
    }

    @Override
    public void setOuterClass(@Nullable Pair<? extends IrSymbol, ? extends State> pair) {
        this.outerClass = pair;
    }

    @Override
    @Nullable
    public IrFunction getIrFunctionByIrCall(@NotNull IrCall expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final MethodHandle getMethod(@NotNull IrFunction irFunction) {
        Object v4;
        block4: {
            void $this$firstOrNull$iv;
            Intrinsics.checkNotNullParameter((Object)irFunction, (String)"irFunction");
            IrProperty irProperty = UtilsKt.getProperty(irFunction);
            String propertyName = irProperty != null && (irProperty = irProperty.getName()) != null ? irProperty.asString() : null;
            Object object = new String[2];
            object[0] = propertyName;
            String string = propertyName;
            object[1] = "get" + (string != null ? CapitalizeDecapitalizeKt.capitalizeAsciiOnly((String)string) : null);
            object = CollectionsKt.listOfNotNull((Object[])object);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                boolean bl;
                block3: {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    Method[] methodArray = this.receiverClass.getMethods();
                    Intrinsics.checkNotNullExpressionValue((Object)methodArray, (String)"getMethods(...)");
                    Object[] $this$any$iv = methodArray;
                    boolean $i$f$any = false;
                    for (Object element$iv2 : $this$any$iv) {
                        Method method = (Method)element$iv2;
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual((Object)method.getName(), (Object)it)) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
                if (!bl) continue;
                v4 = element$iv;
                break block4;
            }
            v4 = null;
        }
        String propertyCall = v4;
        String intrinsicName = this.getJavaOriginalName(irFunction);
        String string = intrinsicName;
        if (string == null && (string = propertyCall) == null) {
            String string2 = irFunction.getName().toString();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        }
        String methodName = string;
        MethodType methodType = Wrapper.Companion.getMethodType(irFunction);
        return MethodHandles.lookup().findVirtual(this.receiverClass, methodName, methodType);
    }

    private final String getJavaOriginalName(IrFunction irFunction) {
        String string;
        switch (UtilsKt.getFqName(UtilsKt.getLastOverridden(irFunction))) {
            case "kotlin.collections.Map.<get-entries>": {
                string = "entrySet";
                break;
            }
            case "kotlin.collections.Map.<get-keys>": {
                string = "keySet";
                break;
            }
            case "kotlin.CharSequence.get": {
                string = "charAt";
                break;
            }
            case "kotlin.collections.MutableList.removeAt": {
                string = "remove";
                break;
            }
            default: {
                string = null;
            }
        }
        return string;
    }

    @NotNull
    public String toString() {
        return this.value.toString();
    }

    static {
        Object[] objectArray = new String[]{"kotlin.text.StringBuilder", "kotlin.Pair", "kotlin.collections.ArrayList", "kotlin.collections.HashMap", "kotlin.collections.LinkedHashMap", "kotlin.collections.HashSet", "kotlin.collections.LinkedHashSet", "kotlin.text.RegexOption", "kotlin.text.Regex", "kotlin.text.Regex.Companion", "kotlin.text.MatchGroup"};
        intrinsicClasses = SetsKt.setOf((Object[])objectArray);
        objectArray = new String[]{"java.lang.StringBuilder", "java.util.ArrayList", "java.util.LinkedHashMap", "java.util.LinkedHashSet", "java.lang.Exception", "java.util.NoSuchElementException", "java.lang.NullPointerException", "java.lang.IllegalArgumentException", "java.lang.ArithmeticException", "java.lang.UnsupportedOperationException"};
        intrinsicJavaClasses = SetsKt.setOf((Object[])objectArray);
        objectArray = new Pair[]{TuplesKt.to((Object)"Array.kotlin.collections.asList()", (Object)"kotlin.collections.ArraysKt"), TuplesKt.to((Object)"kotlin.collections.mutableListOf(Array)", (Object)"kotlin.collections.CollectionsKt"), TuplesKt.to((Object)"kotlin.collections.arrayListOf(Array)", (Object)"kotlin.collections.CollectionsKt"), TuplesKt.to((Object)"Char.kotlin.text.isWhitespace()", (Object)"kotlin.text.CharsKt"), TuplesKt.to((Object)"Array.kotlin.collections.toMutableList()", (Object)"kotlin.collections.ArraysKt"), TuplesKt.to((Object)"Array.kotlin.collections.copyToArrayOfAny(Boolean)", (Object)"kotlin.collections.CollectionsKt")};
        intrinsicFunctionToHandler = MapsKt.mapOf((Pair[])objectArray);
        objectArray = new String[]{"kotlin.ranges.CharRange", "kotlin.ranges.IntRange", "kotlin.ranges.LongRange"};
        ranges = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\f\u001a\u00020\u0006*\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u0006H\u0002J\u000e\u0010\u000f\u001a\u0004\u0018\u00010\u0006*\u00020\rH\u0002J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\rJ\u0016\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cJ\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u001e\u001a\u00020\rJ\u0010\u0010\u001f\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\rJ\u000e\u0010 \u001a\u00020\u00152\u0006\u0010!\u001a\u00020\"J\u000e\u0010#\u001a\u00020\u00152\u0006\u0010$\u001a\u00020\u001aJ\f\u0010%\u001a\u00020&*\u00020\rH\u0002J\u0017\u0010'\u001a\u0006\u0012\u0002\b\u00030(*\u0004\u0018\u00010)H\u0002\u00a2\u0006\u0002\u0010*J\u001c\u0010+\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010(*\u00020,2\u0006\u0010-\u001a\u00020\u0011H\u0002J\u0012\u0010.\u001a\b\u0012\u0004\u0012\u0002000/*\u00020\rH\u0002J\f\u00101\u001a\u00020\u0011*\u00020\rH\u0002J\u0014\u00102\u001a\u00020\u0011*\u00020\r2\u0006\u00103\u001a\u00020)H\u0002R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lorg/jetbrains/kotlin/ir/interpreter/state/Wrapper$Companion;", "", "<init>", "()V", "companionObjectValue", "", "", "intrinsicClasses", "", "intrinsicJavaClasses", "intrinsicFunctionToHandler", "ranges", "getSignature", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "fqName", "getJvmClassName", "mustBeHandledWithWrapper", "", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationWithName;", "getReflectionMethod", "Ljava/lang/invoke/MethodHandle;", "irFunction", "getCompanionObject", "Lorg/jetbrains/kotlin/ir/interpreter/state/Wrapper;", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "environment", "Lorg/jetbrains/kotlin/ir/interpreter/IrInterpreterEnvironment;", "getConstructorMethod", "irConstructor", "getStaticMethod", "getStaticGetter", "field", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "getEnumEntry", "irEnumClass", "getMethodType", "Ljava/lang/invoke/MethodType;", "getCorrespondingFunction", "Ljava/lang/Class;", "", "(Ljava/lang/Integer;)Ljava/lang/Class;", "getClass", "Lorg/jetbrains/kotlin/ir/types/IrType;", "asObject", "getOriginalOverriddenSymbols", "", "Lorg/jetbrains/kotlin/ir/symbols/IrFunctionSymbol;", "isReturnTypePrimitiveAsObject", "isValueParameterPrimitiveAsObject", "index", "ir.interpreter"})
    @SourceDebugExtension(value={"SMAP\nWrapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Wrapper.kt\norg/jetbrains/kotlin/ir/interpreter/state/Wrapper$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,302:1\n3301#2,10:303\n1563#2:314\n1634#2,3:315\n1869#2,2:318\n1#3:313\n*S KotlinDebug\n*F\n+ 1 Wrapper.kt\norg/jetbrains/kotlin/ir/interpreter/state/Wrapper$Companion\n*L\n122#1:303,10\n195#1:314\n195#1:315,3\n274#1:318,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        private final String getSignature(IrFunction $this$getSignature, String fqName) {
            Object object;
            List otherParameters;
            block4: {
                block3: {
                    void $this$partition$iv;
                    Iterable iterable = $this$getSignature.getParameters();
                    boolean $i$f$partition = false;
                    ArrayList first$iv = new ArrayList();
                    ArrayList second$iv = new ArrayList();
                    for (Object element$iv : $this$partition$iv) {
                        IrValueParameter it = (IrValueParameter)element$iv;
                        boolean bl = false;
                        boolean bl2 = it.getKind() == IrParameterKind.DispatchReceiver || it.getKind() == IrParameterKind.ExtensionReceiver ? first$iv.add(element$iv) : second$iv.add(element$iv);
                    }
                    Pair pair = new Pair(first$iv, second$iv);
                    List receiverParameters = (List)pair.component1();
                    otherParameters = (List)pair.component2();
                    object = (IrValueParameter)CollectionsKt.firstOrNull((List)receiverParameters);
                    if (object == null || (object = object.getType()) == null || (object = UtilsKt.getOnlyName((IrType)object)) == null) break block3;
                    Object it = object;
                    boolean bl = false;
                    String string = (String)it + '.';
                    object = string;
                    if (string != null) break block4;
                }
                object = "";
            }
            Object receiver = object;
            return CollectionsKt.joinToString$default((Iterable)otherParameters, null, (CharSequence)((String)receiver + fqName + '('), (CharSequence)")", (int)0, null, Companion::getSignature$lambda$2, (int)25, null);
        }

        static /* synthetic */ String getSignature$default(Companion companion, IrFunction irFunction, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = UtilsKt.getFqName(irFunction);
            }
            return companion.getSignature(irFunction, string);
        }

        private final String getJvmClassName(IrFunction $this$getJvmClassName) {
            return (String)intrinsicFunctionToHandler.get(org.jetbrains.kotlin.ir.interpreter.state.Wrapper$Companion.getSignature$default(this, $this$getJvmClassName, null, 1, null));
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean mustBeHandledWithWrapper(@NotNull IrDeclarationWithName declaration) {
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            String fqName = UtilsKt.getFqName(declaration);
            if (!(declaration instanceof IrFunction)) {
                if (ranges.contains(fqName)) {
                    IrConstructor irConstructor = IrUtilsKt.getPrimaryConstructor((IrClass)declaration);
                    if (irConstructor == null) return true;
                    IrBody irBody = irConstructor.getBody();
                    if (irBody == null) {
                        return true;
                    }
                }
                if (intrinsicClasses.contains(fqName)) return true;
                if (!intrinsicJavaClasses.contains(fqName)) return false;
                return true;
            }
            boolean bl = intrinsicFunctionToHandler.containsKey(this.getSignature((IrFunction)declaration, fqName));
            return bl;
        }

        @NotNull
        public final MethodHandle getReflectionMethod(@NotNull IrFunction irFunction) {
            String string;
            Intrinsics.checkNotNullParameter((Object)irFunction, (String)"irFunction");
            IrValueParameter irValueParameter = irFunction.getDispatchReceiverParameter();
            Intrinsics.checkNotNull((Object)irValueParameter);
            Class<? extends Object> receiverClass = this.getClass(irValueParameter.getType(), true);
            MethodType methodType = this.getMethodType(irFunction);
            IrFunction irFunction2 = irFunction;
            if (irFunction2 instanceof IrSimpleFunction) {
                IrProperty property = UtilsKt.getProperty(irFunction);
                IrProperty irProperty = property;
                if (Intrinsics.areEqual((Object)(irProperty != null ? irProperty.getGetter() : null), (Object)irFunction)) {
                    StringBuilder stringBuilder = new StringBuilder().append("get");
                    String string2 = property.getName().asString();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asString(...)");
                    string = stringBuilder.append(CapitalizeDecapitalizeKt.capitalizeAsciiOnly((String)string2)).toString();
                } else {
                    IrProperty irProperty2 = property;
                    if (Intrinsics.areEqual((Object)(irProperty2 != null ? irProperty2.getSetter() : null), (Object)irFunction)) {
                        StringBuilder stringBuilder = new StringBuilder().append("set");
                        String string3 = property.getName().asString();
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"asString(...)");
                        string = stringBuilder.append(CapitalizeDecapitalizeKt.capitalizeAsciiOnly((String)string3)).toString();
                    } else {
                        String string4 = irFunction.getName().asString();
                        string = string4;
                        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"asString(...)");
                    }
                }
            } else if (irFunction2 instanceof IrConstructor) {
                String string5 = irFunction.getName().asString();
                string = string5;
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"asString(...)");
            } else {
                throw new NoWhenBranchMatchedException();
            }
            String methodName = string;
            MethodHandle methodHandle = MethodHandles.lookup().findVirtual(receiverClass, methodName, methodType);
            Intrinsics.checkNotNullExpressionValue((Object)methodHandle, (String)"findVirtual(...)");
            return methodHandle;
        }

        @NotNull
        public final Wrapper getCompanionObject(@NotNull IrClass irClass, @NotNull IrInterpreterEnvironment environment) {
            Intrinsics.checkNotNullParameter((Object)irClass, (String)"irClass");
            Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
            String objectName = UtilsKt.internalName(irClass);
            Object v = companionObjectValue.get(objectName);
            if (v == null) {
                throw new InternalError("Companion object " + objectName + " cannot be interpreted");
            }
            Object objectValue = v;
            return new Wrapper(objectValue, irClass, environment);
        }

        @Nullable
        public final MethodHandle getConstructorMethod(@NotNull IrFunction irConstructor) {
            Intrinsics.checkNotNullParameter((Object)irConstructor, (String)"irConstructor");
            String intrinsicValue = UtilsKt.internalName(IrUtilsKt.getParentAsClass(irConstructor));
            if (Intrinsics.areEqual((Object)intrinsicValue, (Object)"kotlin.Char") || Intrinsics.areEqual((Object)intrinsicValue, (Object)"kotlin.Long")) {
                return null;
            }
            MethodType methodType = this.getMethodType(irConstructor);
            return MethodHandles.lookup().findConstructor(this.getClass(irConstructor.getReturnType(), true), methodType);
        }

        @Nullable
        public final MethodHandle getStaticMethod(@NotNull IrFunction irFunction) {
            String intrinsicName;
            Intrinsics.checkNotNullParameter((Object)irFunction, (String)"irFunction");
            String string = intrinsicName = this.getJvmClassName(irFunction);
            if (!(string != null ? !(((CharSequence)string).length() == 0) : false)) {
                return null;
            }
            Class<?> jvmClass = Class.forName(intrinsicName);
            MethodType methodType = this.getMethodType(irFunction);
            return MethodHandles.lookup().findStatic(jvmClass, irFunction.getName().asString(), methodType);
        }

        @NotNull
        public final MethodHandle getStaticGetter(@NotNull IrField field) {
            Intrinsics.checkNotNullParameter((Object)field, (String)"field");
            Class<? extends Object> jvmClass = this.getClass(IrUtilsKt.getDefaultType(IrUtilsKt.getParentAsClass(field)), true);
            IrType it = field.getType();
            boolean bl = false;
            Class<? extends Object> returnType = Companion.getClass(it, IrTypeUtilsKt.isNullable(it));
            MethodHandle methodHandle = MethodHandles.lookup().findStaticGetter(jvmClass, field.getName().asString(), returnType);
            Intrinsics.checkNotNullExpressionValue((Object)methodHandle, (String)"findStaticGetter(...)");
            return methodHandle;
        }

        @NotNull
        public final MethodHandle getEnumEntry(@NotNull IrClass irEnumClass) {
            Intrinsics.checkNotNullParameter((Object)irEnumClass, (String)"irEnumClass");
            String intrinsicName = UtilsKt.internalName(irEnumClass);
            Class<?> jvmEnumClass = Class.forName(intrinsicName);
            MethodType methodType = MethodType.methodType(jvmEnumClass, String.class);
            MethodHandle methodHandle = MethodHandles.lookup().findStatic(jvmEnumClass, StandardNames.ENUM_VALUE_OF.getIdentifier(), methodType);
            Intrinsics.checkNotNullExpressionValue((Object)methodHandle, (String)"findStatic(...)");
            return methodHandle;
        }

        /*
         * WARNING - void declaration
         */
        private final MethodType getMethodType(IrFunction $this$getMethodType) {
            MethodType methodType;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = IrUtilsKt.getNonDispatchParameters($this$getMethodType);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                IrValueParameter irValueParameter = (IrValueParameter)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(Companion.getClass(it.getType(), Companion.isValueParameterPrimitiveAsObject($this$getMethodType, it.getIndexInParameters())));
            }
            List parameterClasses = (List)destination$iv$iv;
            IrFunction irFunction = $this$getMethodType;
            if (irFunction instanceof IrSimpleFunction) {
                Class<? extends Object> returnClass = this.getClass($this$getMethodType.getReturnType(), this.isReturnTypePrimitiveAsObject($this$getMethodType));
                MethodType methodType2 = MethodType.methodType(returnClass, parameterClasses);
                Intrinsics.checkNotNull((Object)methodType2);
                methodType = methodType2;
            } else if (irFunction instanceof IrConstructor) {
                MethodType methodType3 = MethodType.methodType(Void.TYPE, parameterClasses);
                Intrinsics.checkNotNull((Object)methodType3);
                methodType = methodType3;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return methodType;
        }

        private final Class<?> getCorrespondingFunction(Integer $this$getCorrespondingFunction) {
            Class<?> clazz;
            if ($this$getCorrespondingFunction == null || $this$getCorrespondingFunction >= 23) {
                Class<?> clazz2 = Class.forName("kotlin.jvm.functions.FunctionN");
                clazz = clazz2;
                Intrinsics.checkNotNullExpressionValue(clazz2, (String)"forName(...)");
            } else {
                Class<?> clazz3 = Class.forName("kotlin.jvm.functions.Function" + $this$getCorrespondingFunction);
                clazz = clazz3;
                Intrinsics.checkNotNullExpressionValue(clazz3, (String)"forName(...)");
            }
            return clazz;
        }

        private final Class<? extends Object> getClass(IrType $this$getClass, boolean asObject) {
            Class<Object> clazz;
            IrClass owner;
            IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull($this$getClass);
            IrClass irClass = owner = irClassSymbol != null ? (IrClass)irClassSymbol.getOwner() : null;
            String fqName = irClass != null ? UtilsKt.getFqName(irClass) : null;
            IrType notNullType = IrTypesKt.makeNotNull($this$getClass);
            if (IrTypePredicatesKt.isPrimitiveType$default(notNullType, false, 1, null) || IrTypePredicatesKt.isString(notNullType)) {
                Class<?> clazz2 = UtilsKt.getPrimitiveClass(notNullType, asObject);
                clazz = clazz2;
                Intrinsics.checkNotNull(clazz2);
            } else if (IrTypePredicatesKt.isArray(notNullType)) {
                Class clazz3;
                Intrinsics.checkNotNull((Object)$this$getClass, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.types.IrSimpleType");
                Object object = IrTypesKt.getTypeOrNull((IrTypeArgument)CollectionsKt.single(((IrSimpleType)$this$getClass).getArguments()));
                String argumentFqName = object != null && (object = IrTypesKt.getClassOrNull((IrType)object)) != null && (object = (IrClass)object.getOwner()) != null ? UtilsKt.getFqName((IrElement)object) : null;
                if (argumentFqName != null && !Intrinsics.areEqual((Object)argumentFqName, (Object)"kotlin.Any")) {
                    String it = argumentFqName;
                    boolean bl = false;
                    clazz3 = Class.forName("[L" + it + ';');
                } else {
                    clazz3 = Object[].class;
                }
                Class<Object[]> clazz4 = clazz3;
                Intrinsics.checkNotNull(clazz4);
                clazz = clazz4;
            } else if (IrTypePredicatesKt.isNothing(notNullType)) {
                clazz = Void.class;
            } else if (IrTypePredicatesKt.isAny(notNullType)) {
                clazz = Object.class;
            } else if (IrTypePredicatesKt.isUnit(notNullType)) {
                if (asObject) {
                    clazz = Void.class;
                } else {
                    Class<Void> clazz5 = Void.TYPE;
                    clazz = clazz5;
                    Intrinsics.checkNotNull(clazz5);
                }
            } else if (IrTypePredicatesKt.isNumber(notNullType)) {
                clazz = Number.class;
            } else if (IrTypePredicatesKt.isCharSequence(notNullType)) {
                clazz = CharSequence.class;
            } else if (IrTypePredicatesKt.isComparable(notNullType)) {
                clazz = Comparable.class;
            } else if (IrTypeUtilsKt.isThrowable(notNullType)) {
                clazz = Throwable.class;
            } else if (IrTypePredicatesKt.isIterable(notNullType)) {
                clazz = Iterable.class;
            } else if (IrTypeUtilsKt.isKFunction(notNullType) || IrTypeUtilsKt.isKSuspendFunction(notNullType)) {
                Class<?> clazz6 = Class.forName("kotlin.reflect.KFunction");
                clazz = clazz6;
                Intrinsics.checkNotNullExpressionValue(clazz6, (String)"forName(...)");
            } else {
                if (IrTypeUtilsKt.isFunction(notNullType)) {
                    String string = fqName;
                    Integer arity = string != null && (string = StringsKt.removePrefix((String)string, (CharSequence)"kotlin.Function")) != null ? StringsKt.toIntOrNull((String)string) : null;
                    return this.getCorrespondingFunction(arity);
                }
                if (IrTypeUtilsKt.isSuspendFunction(notNullType)) {
                    throw new IllegalStateException(("Interpretation of " + fqName + " is not supported").toString());
                }
                if (Intrinsics.areEqual((Object)fqName, (Object)"kotlin.Enum")) {
                    clazz = Enum.class;
                } else if (Intrinsics.areEqual((Object)fqName, (Object)"kotlin.collections.Collection") || Intrinsics.areEqual((Object)fqName, (Object)"kotlin.collections.MutableCollection")) {
                    clazz = Collection.class;
                } else if (Intrinsics.areEqual((Object)fqName, (Object)"kotlin.collections.List") || Intrinsics.areEqual((Object)fqName, (Object)"kotlin.collections.MutableList")) {
                    clazz = List.class;
                } else if (Intrinsics.areEqual((Object)fqName, (Object)"kotlin.collections.Set") || Intrinsics.areEqual((Object)fqName, (Object)"kotlin.collections.MutableSet")) {
                    clazz = Set.class;
                } else if (Intrinsics.areEqual((Object)fqName, (Object)"kotlin.collections.Map") || Intrinsics.areEqual((Object)fqName, (Object)"kotlin.collections.MutableMap")) {
                    clazz = Map.class;
                } else if (Intrinsics.areEqual((Object)fqName, (Object)"kotlin.collections.ListIterator") || Intrinsics.areEqual((Object)fqName, (Object)"kotlin.collections.MutableListIterator")) {
                    clazz = ListIterator.class;
                } else if (Intrinsics.areEqual((Object)fqName, (Object)"kotlin.collections.Iterator") || Intrinsics.areEqual((Object)fqName, (Object)"kotlin.collections.MutableIterator")) {
                    clazz = Iterator.class;
                } else if (Intrinsics.areEqual((Object)fqName, (Object)"kotlin.collections.Map.Entry") || Intrinsics.areEqual((Object)fqName, (Object)"kotlin.collections.MutableMap.MutableEntry")) {
                    clazz = Map.Entry.class;
                } else if (Intrinsics.areEqual((Object)fqName, (Object)"kotlin.collections.ArrayList")) {
                    clazz = ArrayList.class;
                } else if (Intrinsics.areEqual((Object)fqName, (Object)"kotlin.collections.HashMap")) {
                    clazz = HashMap.class;
                } else if (Intrinsics.areEqual((Object)fqName, (Object)"kotlin.collections.HashSet")) {
                    clazz = HashSet.class;
                } else if (Intrinsics.areEqual((Object)fqName, (Object)"kotlin.collections.LinkedHashMap")) {
                    clazz = LinkedHashMap.class;
                } else if (Intrinsics.areEqual((Object)fqName, (Object)"kotlin.collections.LinkedHashSet")) {
                    clazz = LinkedHashSet.class;
                } else if (Intrinsics.areEqual((Object)fqName, (Object)"kotlin.text.StringBuilder")) {
                    clazz = StringBuilder.class;
                } else if (Intrinsics.areEqual((Object)fqName, (Object)"kotlin.text.Appendable")) {
                    clazz = Appendable.class;
                } else if (fqName == null) {
                    clazz = Object.class;
                } else {
                    Class<?> clazz7 = Class.forName(UtilsKt.internalName(owner));
                    clazz = clazz7;
                    Intrinsics.checkNotNullExpressionValue(clazz7, (String)"forName(...)");
                }
            }
            return clazz;
        }

        private final List<IrFunctionSymbol> getOriginalOverriddenSymbols(IrFunction $this$getOriginalOverriddenSymbols) {
            List overriddenSymbols = new ArrayList();
            if ($this$getOriginalOverriddenSymbols instanceof IrSimpleFunction) {
                ListIterator<IrSimpleFunctionSymbol> iterator;
                List pool = CollectionsKt.toMutableList((Collection)((IrSimpleFunction)$this$getOriginalOverriddenSymbols).getOverriddenSymbols());
                ListIterator<IrSimpleFunctionSymbol> listIterator = iterator = pool.listIterator();
                while (((Iterator)listIterator).hasNext()) {
                    IrSimpleFunctionSymbol symbol = (IrSimpleFunctionSymbol)listIterator.next();
                    if (((IrSimpleFunction)symbol.getOwner()).getOverriddenSymbols().isEmpty()) {
                        ((Collection)overriddenSymbols).add(symbol);
                        iterator.remove();
                        continue;
                    }
                    Iterable $this$forEach$iv = ((IrSimpleFunction)symbol.getOwner()).getOverriddenSymbols();
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        IrSimpleFunctionSymbol it = (IrSimpleFunctionSymbol)element$iv;
                        boolean bl = false;
                        iterator.add(it);
                    }
                }
            }
            if (overriddenSymbols.isEmpty()) {
                overriddenSymbols.add($this$getOriginalOverriddenSymbols.getSymbol());
            }
            return overriddenSymbols;
        }

        private final boolean isReturnTypePrimitiveAsObject(IrFunction $this$isReturnTypePrimitiveAsObject) {
            for (IrFunctionSymbol symbol : this.getOriginalOverriddenSymbols($this$isReturnTypePrimitiveAsObject)) {
                if (IrTypeUtilsKt.isTypeParameter(symbol.getOwner().getReturnType()) || IrTypeUtilsKt.isNullable(symbol.getOwner().getReturnType())) continue;
                return false;
            }
            return true;
        }

        private final boolean isValueParameterPrimitiveAsObject(IrFunction $this$isValueParameterPrimitiveAsObject, int index) {
            for (IrFunctionSymbol symbol : this.getOriginalOverriddenSymbols($this$isValueParameterPrimitiveAsObject)) {
                if (IrTypeUtilsKt.isTypeParameter(symbol.getOwner().getParameters().get(index).getType()) || IrTypeUtilsKt.isNullable(symbol.getOwner().getParameters().get(index).getType())) continue;
                return false;
            }
            return true;
        }

        private static final CharSequence getSignature$lambda$2(IrValueParameter it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return UtilsKt.getOnlyName(it.getType());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

