/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.GrFunctionalExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyNamesUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtilKt;
import org.jetbrains.plugins.groovy.lang.resolve.api.JustTypeArgument;
import org.jetbrains.plugins.groovy.lang.resolve.delegatesTo.DelegatesToInfo;
import org.jetbrains.plugins.groovy.lang.resolve.delegatesTo.GrDelegatesToUtilKt;
import org.jetbrains.plugins.groovy.lang.resolve.processors.ClassHint;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001c\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u001a.\u0010\u0007\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\tH\u0000\u001a$\u0010\u000b\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\tH\u0002\u001a$\u0010\f\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\tH\u0000\u001a.\u0010\r\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\tH\u0000\u001a+\u0010\u000e\u001a\u0004\u0018\u00010\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0002\u0010\u000f\u001a.\u0010\u0010\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\t2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002\u001a\u000e\u0010\u0013\u001a\u0004\u0018\u00010\u0012*\u00020\u0002H\u0000\u00a8\u0006\u0014"}, d2={"processParameters", "", "Lorg/jetbrains/plugins/groovy/lang/psi/api/GrFunctionalExpression;", "processor", "Lcom/intellij/psi/scope/PsiScopeProcessor;", "state", "Lcom/intellij/psi/ResolveState;", "processClosureClassMembers", "lastParent", "Lcom/intellij/psi/PsiElement;", "place", "processOwner", "processOwnerAndDelegate", "processDeclarationsWithCallsite", "processDelegatesTo", "(Lorg/jetbrains/plugins/groovy/lang/psi/api/GrFunctionalExpression;Lcom/intellij/psi/scope/PsiScopeProcessor;Lcom/intellij/psi/ResolveState;Lcom/intellij/psi/PsiElement;)Ljava/lang/Boolean;", "processDelegate", "classToDelegate", "Lcom/intellij/psi/PsiType;", "doGetOwnerType", "intellij.groovy.psi"})
public final class FunctionalExpressionsKt {
    public static final boolean processParameters(@NotNull GrFunctionalExpression $this$processParameters, @NotNull PsiScopeProcessor processor, @NotNull ResolveState state) {
        Intrinsics.checkNotNullParameter((Object)$this$processParameters, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)processor, (String)"processor");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        if (!ResolveUtilKt.shouldProcessLocals(processor)) {
            return true;
        }
        for (GrParameter parameter : $this$processParameters.getAllParameters()) {
            if (ResolveUtil.processElement(processor, (PsiNamedElement)parameter, state)) continue;
            return false;
        }
        return true;
    }

    public static final boolean processClosureClassMembers(@NotNull GrFunctionalExpression $this$processClosureClassMembers, @NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @Nullable PsiElement lastParent, @NotNull PsiElement place) {
        Intrinsics.checkNotNullParameter((Object)$this$processClosureClassMembers, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)processor, (String)"processor");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)place, (String)"place");
        PsiClass psiClass = JavaPsiFacade.getInstance((Project)$this$processClosureClassMembers.getProject()).findClass("groovy.lang.Closure", $this$processClosureClassMembers.getResolveScope());
        if (psiClass == null) {
            return true;
        }
        PsiClass closureClass = psiClass;
        ResolveState resolveState = state.put(ClassHint.RESOLVE_CONTEXT, (Object)$this$processClosureClassMembers);
        Intrinsics.checkNotNullExpressionValue((Object)resolveState, (String)"put(...)");
        ResolveState newState = resolveState;
        return ResolveUtil.processClassDeclarations(closureClass, processor, newState, lastParent, place);
    }

    private static final boolean processOwner(GrFunctionalExpression $this$processOwner, PsiScopeProcessor processor, ResolveState state, PsiElement place) {
        PsiElement psiElement = $this$processOwner.getParent();
        if (psiElement == null) {
            return true;
        }
        PsiElement parent = psiElement;
        if (!ResolveUtil.processStaticImports(processor, $this$processOwner.getContainingFile(), state, place)) {
            return false;
        }
        return ResolveUtil.treeWalkUp(parent, place, processor, state);
    }

    public static final boolean processOwnerAndDelegate(@NotNull GrFunctionalExpression $this$processOwnerAndDelegate, @NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @NotNull PsiElement place) {
        Intrinsics.checkNotNullParameter((Object)$this$processOwnerAndDelegate, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)processor, (String)"processor");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)place, (String)"place");
        Boolean result2 = FunctionalExpressionsKt.processDelegatesTo($this$processOwnerAndDelegate, processor, state, place);
        if (result2 != null) {
            return result2;
        }
        return FunctionalExpressionsKt.processOwner($this$processOwnerAndDelegate, processor, state, place);
    }

    public static final boolean processDeclarationsWithCallsite(@NotNull GrFunctionalExpression $this$processDeclarationsWithCallsite, @NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @Nullable PsiElement lastParent, @NotNull PsiElement place) {
        Intrinsics.checkNotNullParameter((Object)$this$processDeclarationsWithCallsite, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)processor, (String)"processor");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)place, (String)"place");
        return $this$processDeclarationsWithCallsite.processDeclarations(processor, state, lastParent, place) && FunctionalExpressionsKt.processOwnerAndDelegate($this$processDeclarationsWithCallsite, processor, state, place);
    }

    private static final Boolean processDelegatesTo(GrFunctionalExpression $this$processDelegatesTo, PsiScopeProcessor processor, ResolveState state, PsiElement place) {
        DelegatesToInfo delegatesToInfo = GrDelegatesToUtilKt.getDelegatesToInfo($this$processDelegatesTo);
        if (delegatesToInfo == null) {
            return null;
        }
        DelegatesToInfo info = delegatesToInfo;
        switch (info.getStrategy()) {
            case 0: {
                return FunctionalExpressionsKt.processOwner($this$processDelegatesTo, processor, state, place) && FunctionalExpressionsKt.processDelegate($this$processDelegatesTo, processor, state, place, info.getTypeToDelegate());
            }
            case 1: {
                return FunctionalExpressionsKt.processDelegate($this$processDelegatesTo, processor, state, place, info.getTypeToDelegate()) && FunctionalExpressionsKt.processOwner($this$processDelegatesTo, processor, state, place);
            }
            case 2: {
                return FunctionalExpressionsKt.processOwner($this$processDelegatesTo, processor, state, place);
            }
            case 3: {
                return FunctionalExpressionsKt.processDelegate($this$processDelegatesTo, processor, state, place, info.getTypeToDelegate());
            }
            case 4: {
                return true;
            }
        }
        return null;
    }

    private static final boolean processDelegate(GrFunctionalExpression $this$processDelegate, PsiScopeProcessor processor, ResolveState state, PsiElement place, PsiType classToDelegate) {
        if (classToDelegate == null) {
            return true;
        }
        if (!ResolveUtil.processStaticImports(processor, $this$processDelegate.getContainingFile(), state, place)) {
            return false;
        }
        ResolveState resolveState = state.put(ClassHint.RECEIVER, (Object)new JustTypeArgument(classToDelegate)).put(ClassHint.RESOLVE_CONTEXT, (Object)$this$processDelegate);
        Intrinsics.checkNotNullExpressionValue((Object)resolveState, (String)"put(...)");
        ResolveState delegateState = resolveState;
        return ResolveUtil.processAllDeclarations(classToDelegate, processor, delegateState, place);
    }

    @Nullable
    public static final PsiType doGetOwnerType(@NotNull GrFunctionalExpression $this$doGetOwnerType) {
        PsiClass scriptClass;
        Intrinsics.checkNotNullParameter((Object)$this$doGetOwnerType, (String)"<this>");
        Class[] classArray = new Class[]{GrTypeDefinition.class, GrFunctionalExpression.class, GroovyFile.class};
        GroovyPsiElement context = (GroovyPsiElement)PsiTreeUtil.getParentOfType((PsiElement)$this$doGetOwnerType, (Class[])classArray);
        PsiElementFactory psiElementFactory = JavaPsiFacade.getInstance((Project)$this$doGetOwnerType.getProject()).getElementFactory();
        Intrinsics.checkNotNullExpressionValue((Object)psiElementFactory, (String)"getElementFactory(...)");
        PsiElementFactory factory = psiElementFactory;
        if (context instanceof GrTypeDefinition) {
            return (PsiType)factory.createType((PsiClass)context);
        }
        if (context instanceof GrFunctionalExpression) {
            return ((GrFunctionalExpression)context).getType();
        }
        if (context instanceof GroovyFile && (scriptClass = ((GroovyFile)context).getScriptClass()) != null && GroovyNamesUtil.isIdentifier(scriptClass.getName())) {
            return (PsiType)factory.createType(scriptClass);
        }
        return null;
    }
}

