/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class FileTreeAccessFilter
implements VirtualFileFilter {
    private final Set<VirtualFile> myAddedClasses = new HashSet<VirtualFile>();
    private boolean myTreeAccessAllowed;

    public boolean accept(@NotNull VirtualFile file) {
        if (file == null) {
            FileTreeAccessFilter.$$$reportNull$$$0(0);
        }
        if (file instanceof VirtualFileWindow) {
            return false;
        }
        if (this.myAddedClasses.contains(file) || this.myTreeAccessAllowed) {
            return false;
        }
        FileType fileType = file.getFileType();
        return (fileType == StdFileTypes.JAVA || fileType == StdFileTypes.CLASS) && !file.getName().equals("package-info.java");
    }

    public void allowTreeAccessForFile(@NotNull VirtualFile file) {
        if (file == null) {
            FileTreeAccessFilter.$$$reportNull$$$0(1);
        }
        this.myAddedClasses.add(file);
    }

    public void allowTreeAccessForAllFiles() {
        this.myTreeAccessAllowed = true;
    }

    public String toString() {
        return "JAVA {allowed=" + this.myTreeAccessAllowed + " files=" + String.valueOf(new ArrayList<VirtualFile>(this.myAddedClasses)) + "}";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "file";
        objectArray2[1] = "com/intellij/testFramework/FileTreeAccessFilter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "accept";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "allowTreeAccessForFile";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

