/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.cmdline;

import com.intellij.openapi.diagnostic.Logger;

class ProfilingHelper {
    private static final Logger LOG = Logger.getInstance(ProfilingHelper.class);
    private final Class<?> myControllerClass = Class.forName("com.yourkit.api.controller.Controller");
    private final Object myController;

    ProfilingHelper() throws Exception {
        Object builder = this.myControllerClass.getDeclaredMethod("newBuilder", new Class[0]).invoke(null, new Object[0]);
        Class<?> builderClass = builder.getClass();
        this.myController = builderClass.getMethod("build", new Class[0]).invoke(builderClass.getMethod("self", new Class[0]).invoke(builder, new Object[0]), new Object[0]);
    }

    private void startProfiling(String startMethod) throws Exception {
        Class<?> settingsClass = Class.forName("com.yourkit.api.controller.CpuProfilingSettings");
        this.myControllerClass.getMethod(startMethod, settingsClass).invoke(this.myController, settingsClass.newInstance());
    }

    public void startSamplingProfiling() throws Exception {
        this.startProfiling("startSampling");
    }

    public void startTracingProfiling() throws Exception {
        this.startProfiling("startTracing");
    }

    public void stopProfiling() {
        try {
            String path = (String)this.myControllerClass.getMethod("capturePerformanceSnapshot", new Class[0]).invoke(this.myController, new Object[0]);
            String message = "CPU Snapshot captured: " + path;
            LOG.warn(message);
            System.err.println(message);
            this.myControllerClass.getMethod("stopCpuProfiling", new Class[0]).invoke(this.myController, new Object[0]);
        }
        catch (Throwable e) {
            e.printStackTrace();
            LOG.error(e);
        }
    }
}

