/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermState;
import org.apache.lucene.index.TermStates;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.ConstantScoreWeight;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.DocIdSetBuilder;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.NumberType;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.ExtendedQuery;
import org.apache.solr.search.PointSetQuery;
import org.apache.solr.search.QParser;
import org.apache.solr.search.QParserPlugin;
import org.apache.solr.search.SyntaxError;

public class GraphTermsQParserPlugin
extends QParserPlugin {
    public static final String NAME = "graphTerms";

    @Override
    public QParser createParser(String qstr, SolrParams localParams, SolrParams params, SolrQueryRequest req) {
        return new QParser(qstr, localParams, params, req){

            @Override
            public Query parse() throws SyntaxError {
                String fname = this.localParams.get("f");
                FieldType ft = this.req.getSchema().getFieldTypeNoEx(fname);
                int maxDocFreq = this.localParams.getInt("maxDocFreq", Integer.MAX_VALUE);
                String qstr = this.localParams.get("v");
                if (qstr.length() == 0) {
                    return new MatchNoDocsQuery();
                }
                String[] splitVals = qstr.split(",");
                SchemaField sf = this.req.getSchema().getField(fname);
                if (maxDocFreq == Integer.MAX_VALUE) {
                    return sf.getType().getSetQuery(this, sf, Arrays.asList(splitVals));
                }
                if (sf.getType().isPointField()) {
                    PointSetQuery setQ = null;
                    if (sf.getType().getNumberType() == NumberType.INTEGER) {
                        int[] vals = new int[splitVals.length];
                        for (int i = 0; i < vals.length; ++i) {
                            vals[i] = Integer.parseInt(splitVals[i]);
                        }
                        Arrays.sort(vals);
                        setQ = PointSetQuery.newSetQuery(sf.getName(), vals);
                    } else if (sf.getType().getNumberType() == NumberType.LONG || sf.getType().getNumberType() == NumberType.DATE) {
                        long[] vals = new long[splitVals.length];
                        for (int i = 0; i < vals.length; ++i) {
                            vals[i] = Long.parseLong(splitVals[i]);
                        }
                        Arrays.sort(vals);
                        setQ = PointSetQuery.newSetQuery(sf.getName(), vals);
                    } else if (sf.getType().getNumberType() == NumberType.FLOAT) {
                        float[] vals = new float[splitVals.length];
                        for (int i = 0; i < vals.length; ++i) {
                            vals[i] = Float.parseFloat(splitVals[i]);
                        }
                        Arrays.sort(vals);
                        setQ = PointSetQuery.newSetQuery(sf.getName(), vals);
                    } else if (sf.getType().getNumberType() == NumberType.DOUBLE) {
                        double[] vals = new double[splitVals.length];
                        for (int i = 0; i < vals.length; ++i) {
                            vals[i] = Double.parseDouble(splitVals[i]);
                        }
                        Arrays.sort(vals);
                        setQ = PointSetQuery.newSetQuery(sf.getName(), vals);
                    }
                    setQ.setMaxDocFreq(maxDocFreq);
                    return setQ;
                }
                Term[] terms = new Term[splitVals.length];
                BytesRefBuilder term = new BytesRefBuilder();
                for (int i = 0; i < splitVals.length; ++i) {
                    String stringVal = splitVals[i].trim();
                    if (ft != null) {
                        ft.readableToIndexed(stringVal, term);
                    } else {
                        term.copyChars((CharSequence)stringVal);
                    }
                    BytesRef ref = term.toBytesRef();
                    terms[i] = new Term(fname, ref);
                }
                ArrayUtil.timSort((Comparable[])terms);
                return new ConstantScoreQuery((Query)new GraphTermsQuery(fname, terms, maxDocFreq));
            }
        };
    }

    private static class GraphTermsQuery
    extends Query
    implements ExtendedQuery {
        private Term[] queryTerms;
        private String field;
        private int maxDocFreq;
        private Object id;

        public GraphTermsQuery(String field, Term[] terms, int maxDocFreq) {
            this.maxDocFreq = maxDocFreq;
            this.field = field;
            this.queryTerms = terms;
            this.id = new Object();
        }

        private GraphTermsQuery(String field, Term[] terms, int maxDocFreq, Object id) {
            this.field = field;
            this.queryTerms = terms;
            this.maxDocFreq = maxDocFreq;
            this.id = id;
        }

        @Override
        public boolean getCache() {
            return false;
        }

        @Override
        public void setCache(boolean cache) {
        }

        @Override
        public int getCost() {
            return 0;
        }

        @Override
        public void setCost(int cost) {
        }

        public Query rewrite(IndexReader reader) throws IOException {
            return this;
        }

        public int hashCode() {
            return 31 * this.classHash() + this.id.hashCode();
        }

        public boolean equals(Object other) {
            return this.sameClassAs(other) && this.id == ((GraphTermsQuery)other).id;
        }

        public GraphTermsQuery clone() {
            GraphTermsQuery clone = new GraphTermsQuery(this.field, this.queryTerms, this.maxDocFreq, this.id);
            return clone;
        }

        public String toString(String defaultField) {
            return Arrays.stream(this.queryTerms).map(Term::toString).collect(Collectors.joining(","));
        }

        public void visit(QueryVisitor visitor) {
            visitor.visitLeaf((Query)this);
        }

        public Weight createWeight(IndexSearcher searcher, final ScoreMode scoreMode, float boost) throws IOException {
            final ArrayList<TermStates> finalContexts = new ArrayList<TermStates>();
            final ArrayList<Term> finalTerms = new ArrayList<Term>();
            List contexts = searcher.getTopReaderContext().leaves();
            TermStates[] termStates = new TermStates[this.queryTerms.length];
            this.collectTermStates(searcher.getIndexReader(), contexts, termStates, this.queryTerms);
            for (int i = 0; i < termStates.length; ++i) {
                TermStates ts = termStates[i];
                if (ts == null || ts.docFreq() > this.maxDocFreq) continue;
                finalContexts.add(ts);
                finalTerms.add(this.queryTerms[i]);
            }
            return new ConstantScoreWeight(this, boost){

                public Scorer scorer(LeafReaderContext context) throws IOException {
                    LeafReader reader = context.reader();
                    Terms terms = reader.terms(field);
                    if (terms == null) {
                        return null;
                    }
                    TermsEnum termsEnum = terms.iterator();
                    PostingsEnum docs = null;
                    DocIdSetBuilder builder = new DocIdSetBuilder(reader.maxDoc(), terms);
                    for (int i = 0; i < finalContexts.size(); ++i) {
                        TermStates ts = (TermStates)finalContexts.get(i);
                        TermState termState = ts.get(context);
                        if (termState == null) continue;
                        Term term = (Term)finalTerms.get(i);
                        termsEnum.seekExact(term.bytes(), ts.get(context));
                        docs = termsEnum.postings(docs, 0);
                        builder.add((DocIdSetIterator)docs);
                    }
                    DocIdSet docIdSet = builder.build();
                    DocIdSetIterator disi = docIdSet.iterator();
                    return disi == null ? null : new ConstantScoreScorer((Weight)this, this.score(), scoreMode, disi);
                }

                public boolean isCacheable(LeafReaderContext ctx) {
                    return true;
                }
            };
        }

        private void collectTermStates(IndexReader reader, List<LeafReaderContext> leaves, TermStates[] contextArray, Term[] queryTerms) throws IOException {
            TermsEnum termsEnum = null;
            for (LeafReaderContext context : leaves) {
                Terms terms = context.reader().terms(this.field);
                if (terms == null || (termsEnum = terms.iterator()) == TermsEnum.EMPTY) continue;
                for (int i = 0; i < queryTerms.length; ++i) {
                    Term term = queryTerms[i];
                    TermStates termStates = contextArray[i];
                    if (!termsEnum.seekExact(term.bytes())) continue;
                    if (termStates == null) {
                        contextArray[i] = new TermStates(reader.getContext(), termsEnum.termState(), context.ord, termsEnum.docFreq(), termsEnum.totalTermFreq());
                        continue;
                    }
                    termStates.register(termsEnum.termState(), context.ord, termsEnum.docFreq(), termsEnum.totalTermFreq());
                }
            }
        }
    }
}

