/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.metrics.prometheus.jvm;

import com.codahale.metrics.Metric;
import com.google.common.base.Enums;
import org.apache.solr.metrics.prometheus.SolrMetric;
import org.apache.solr.metrics.prometheus.SolrNoOpMetric;
import org.apache.solr.metrics.prometheus.SolrPrometheusFormatter;
import org.apache.solr.metrics.prometheus.jvm.PrometheusJvmFormatterInfo;
import org.apache.solr.metrics.prometheus.jvm.SolrJvmBuffersMetric;
import org.apache.solr.metrics.prometheus.jvm.SolrJvmGcMetrics;
import org.apache.solr.metrics.prometheus.jvm.SolrJvmMemoryMetric;
import org.apache.solr.metrics.prometheus.jvm.SolrJvmOsMetric;

public class SolrPrometheusJvmFormatter
extends SolrPrometheusFormatter
implements PrometheusJvmFormatterInfo {
    @Override
    public void exportDropwizardMetric(Metric dropwizardMetric, String metricName) {
        SolrMetric solrJvmMetric = this.categorizeMetric(dropwizardMetric, metricName);
        solrJvmMetric.parseLabels().toPrometheus(this);
    }

    @Override
    public SolrMetric categorizeMetric(Metric dropwizardMetric, String metricName) {
        String metricCategory = metricName.split("\\.", 2)[0];
        if (!Enums.getIfPresent(PrometheusJvmFormatterInfo.JvmCategory.class, (String)metricCategory).isPresent()) {
            return new SolrNoOpMetric();
        }
        switch (PrometheusJvmFormatterInfo.JvmCategory.valueOf(metricCategory)) {
            case gc: {
                return new SolrJvmGcMetrics(dropwizardMetric, metricName);
            }
            case memory: {
                return new SolrJvmMemoryMetric(dropwizardMetric, metricName);
            }
            case os: 
            case threads: {
                return new SolrJvmOsMetric(dropwizardMetric, metricName);
            }
            case buffers: {
                return new SolrJvmBuffersMetric(dropwizardMetric, metricName);
            }
        }
        return new SolrNoOpMetric();
    }
}

