/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import org.apache.kafka.streams.processor.Processor;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.api.Record;
import org.apache.kafka.streams.processor.internals.InternalProcessorContext;
import org.apache.kafka.streams.processor.internals.ProcessorRecordContext;

public final class ProcessorAdapter<KIn, VIn, KOut, VOut>
implements org.apache.kafka.streams.processor.api.Processor<KIn, VIn, KOut, VOut> {
    private final Processor<KIn, VIn> delegate;
    private InternalProcessorContext context;

    public static <KIn, VIn, KOut, VOut> org.apache.kafka.streams.processor.api.Processor<KIn, VIn, KOut, VOut> adapt(Processor<KIn, VIn> delegate) {
        if (delegate == null) {
            return null;
        }
        return new ProcessorAdapter<KIn, VIn, KOut, VOut>(delegate);
    }

    public static <KIn, VIn, KOut, VOut> org.apache.kafka.streams.processor.api.Processor<KIn, VIn, KOut, VOut> adaptRaw(Processor delegate) {
        if (delegate == null) {
            return null;
        }
        return new ProcessorAdapter<KIn, VIn, KOut, VOut>(delegate);
    }

    private ProcessorAdapter(Processor<KIn, VIn> delegate) {
        this.delegate = delegate;
    }

    @Override
    public void init(org.apache.kafka.streams.processor.api.ProcessorContext<KOut, VOut> context) {
        this.context = (InternalProcessorContext)context;
        this.delegate.init((ProcessorContext)((Object)context));
    }

    @Override
    public void process(Record<KIn, VIn> record) {
        ProcessorRecordContext processorRecordContext = this.context.recordContext();
        try {
            this.context.setRecordContext(new ProcessorRecordContext(record.timestamp(), this.context.offset(), this.context.partition(), this.context.topic(), record.headers()));
            this.delegate.process(record.key(), record.value());
        }
        finally {
            this.context.setRecordContext(processorRecordContext);
        }
    }

    @Override
    public void close() {
        this.delegate.close();
    }
}

