/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.util;

import java.io.IOException;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Base64;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAccumulator;
import java.util.concurrent.atomic.LongAdder;
import org.apache.solr.client.api.util.ReflectWritable;
import org.apache.solr.common.EnumFieldValue;
import org.apache.solr.common.IteratorWriter;
import org.apache.solr.common.MapSerializable;
import org.apache.solr.common.MapWriter;
import org.apache.solr.common.PushWriter;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SolrJSONWriter;
import org.apache.solr.common.util.Utils;

public interface TextWriter
extends PushWriter {
    default public void writeVal(String name, Object val) throws IOException {
        this.writeVal(name, val, false);
    }

    default public void writeVal(String name, Object val, boolean raw) throws IOException {
        if (val == null) {
            this.writeNull(name);
        } else if (val instanceof CharSequence) {
            if (raw) {
                this.writeStrRaw(name, val.toString());
            } else {
                this.writeStr(name, val.toString(), true);
            }
        } else if (val instanceof Number) {
            this.writeNumber(name, (Number)val);
        } else if (val instanceof Boolean) {
            this.writeBool(name, (Boolean)val);
        } else if (val instanceof AtomicBoolean) {
            this.writeBool(name, ((AtomicBoolean)val).get());
        } else if (val instanceof Date) {
            this.writeDate(name, (Date)val);
        } else if (val instanceof NamedList) {
            this.writeNamedList(name, (NamedList)val);
        } else if (val instanceof Path) {
            String pathStr = ((Path)val).toAbsolutePath().toString();
            if (raw) {
                this.writeStrRaw(name, pathStr);
            } else {
                this.writeStr(name, pathStr, true);
            }
        } else if (val instanceof IteratorWriter) {
            this.writeIterator(name, (IteratorWriter)val, raw);
        } else if (val instanceof MapWriter) {
            this.writeMap(name, (MapWriter)val);
        } else if (val instanceof ReflectWritable) {
            this.writeVal(name, Utils.getReflectWriter(val));
        } else if (val instanceof MapSerializable) {
            this.writeMap(name, ((MapSerializable)val).toMap(new LinkedHashMap<String, Object>()), false, true);
        } else if (val instanceof Map) {
            this.writeMap(name, (Map)val, false, true);
        } else if (val instanceof Iterator) {
            this.writeArray(name, (Iterator)val, raw);
        } else if (val instanceof Iterable) {
            this.writeArray(name, ((Iterable)val).iterator(), raw);
        } else if (val instanceof Object[]) {
            this.writeArray(name, (Object[])val, raw);
        } else if (val instanceof byte[]) {
            byte[] arr = (byte[])val;
            this.writeByteArr(name, arr, 0, arr.length);
        } else if (val instanceof EnumFieldValue) {
            if (raw) {
                this.writeStrRaw(name, val.toString());
            } else {
                this.writeStr(name, val.toString(), true);
            }
        } else {
            this.writeVal(name, Utils.getReflectWriter(val));
        }
    }

    default public void writeStrRaw(String name, String val) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void writeStr(String var1, String var2, boolean var3) throws IOException;

    public void writeMap(String var1, Map<?, ?> var2, boolean var3, boolean var4) throws IOException;

    public void writeArray(String var1, Iterator<?> var2, boolean var3) throws IOException;

    public void writeNull(String var1) throws IOException;

    public void writeInt(String var1, String var2) throws IOException;

    public void writeLong(String var1, String var2) throws IOException;

    public void writeBool(String var1, String var2) throws IOException;

    public void writeFloat(String var1, String var2) throws IOException;

    public void writeDouble(String var1, String var2) throws IOException;

    public void writeDate(String var1, String var2) throws IOException;

    public void writeNamedList(String var1, NamedList<?> var2) throws IOException;

    public Writer getWriter();

    default public void writeNumber(String name, Number val) throws IOException {
        if (val instanceof Integer) {
            this.writeInt(name, val.toString());
        } else if (val instanceof Long) {
            this.writeLong(name, val.toString());
        } else if (val instanceof Float) {
            this.writeFloat(name, val.floatValue());
        } else if (val instanceof Double) {
            this.writeDouble(name, val.doubleValue());
        } else if (val instanceof Short) {
            this.writeInt(name, val.toString());
        } else if (val instanceof Byte) {
            this.writeInt(name, val.toString());
        } else if (val instanceof AtomicInteger) {
            this.writeInt(name, ((AtomicInteger)val).get());
        } else if (val instanceof AtomicLong) {
            this.writeLong(name, ((AtomicLong)val).get());
        } else if (val instanceof LongAdder) {
            this.writeLong(name, val.toString());
        } else if (val instanceof LongAccumulator) {
            this.writeLong(name, val.toString());
        } else {
            this.writeStr(name, val.getClass().getName() + ":" + val.toString(), true);
        }
    }

    default public void writeArray(String name, Object[] val, boolean raw) throws IOException {
        this.writeArray(name, Arrays.asList(val), raw);
    }

    default public void writeArray(String name, List<?> l, boolean raw) throws IOException {
        this.writeArray(name, l.iterator(), raw);
    }

    default public void writeDate(String name, Date val) throws IOException {
        this.writeDate(name, val.toInstant().toString());
    }

    default public void writeByteArr(String name, byte[] buf, int offset, int len) throws IOException {
        this.writeStr(name, new String(Base64.getEncoder().encode(ByteBuffer.wrap(buf, offset, len)).array(), StandardCharsets.ISO_8859_1), false);
    }

    default public void writeInt(String name, int val) throws IOException {
        this.writeInt(name, Integer.toString(val));
    }

    default public void writeLong(String name, long val) throws IOException {
        this.writeLong(name, Long.toString(val));
    }

    default public void writeBool(String name, boolean val) throws IOException {
        this.writeBool(name, Boolean.toString(val));
    }

    default public void writeFloat(String name, float val) throws IOException {
        String s = Float.toString(val);
        if (val > Float.NEGATIVE_INFINITY && val < Float.POSITIVE_INFINITY) {
            this.writeFloat(name, s);
        } else {
            this.writeStr(name, s, false);
        }
    }

    default public void writeDouble(String name, double val) throws IOException {
        String s = Double.toString(val);
        if (val > Double.NEGATIVE_INFINITY && val < Double.POSITIVE_INFINITY) {
            this.writeDouble(name, s);
        } else {
            this.writeStr(name, s, false);
        }
    }

    default public void writeBool(String name, Boolean val) throws IOException {
        this.writeBool(name, val.toString());
    }

    @Override
    default public void writeMap(MapWriter mw) throws IOException {
    }

    default public void writeMap(String name, MapWriter mw) throws IOException {
        this.writeMap(mw);
    }

    @Override
    default public void writeIterator(IteratorWriter iw) throws IOException {
    }

    default public void writeIterator(String name, IteratorWriter iw, boolean raw) throws IOException {
        this.writeIterator(iw);
    }

    default public void indent() throws IOException {
        if (this.doIndent()) {
            this.indent(this.level());
        }
    }

    public int incLevel();

    public int decLevel();

    public TextWriter setIndent(boolean var1);

    public int level();

    public boolean doIndent();

    default public void indent(int lev) throws IOException {
        this.getWriter().write(SolrJSONWriter.indentChars, 0, Math.min((lev << 1) + 1, SolrJSONWriter.indentChars.length));
    }
}

