/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.clustering;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TotalHits;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.clustering.EngineEntry;
import org.apache.solr.handler.clustering.EngineParameters;
import org.apache.solr.handler.clustering.InputDocument;
import org.apache.solr.handler.component.HighlightComponent;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.handler.component.SearchComponent;
import org.apache.solr.handler.component.ShardRequest;
import org.apache.solr.highlight.SolrHighlighter;
import org.apache.solr.request.LocalSolrQueryRequest;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.search.DocIterator;
import org.apache.solr.search.DocList;
import org.apache.solr.search.DocSlice;
import org.apache.solr.search.QueryLimits;
import org.apache.solr.search.SolrDocumentFetcher;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.util.plugin.SolrCoreAware;
import org.carrot2.clustering.Cluster;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusteringComponent
extends SearchComponent
implements SolrCoreAware {
    public static final String COMPONENT_NAME = "clustering";
    public static final String REQUEST_PARAM_ENGINE = "clustering.engine";
    public static final String INIT_SECTION_ENGINE = "engine";
    public static final String RESPONSE_SECTION_CLUSTERS = "clusters";
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String REQUEST_PARAM_COLLECT_INPUTS = "clustering.collect-inputs";
    private static final String RESPONSE_SECTION_INPUT_DOCUMENTS = "clustering-inputs";
    private final List<EngineEntry> declaredEngines = new ArrayList<EngineEntry>();
    private final LinkedHashMap<String, EngineEntry> engines = new LinkedHashMap();

    private static boolean isComponentEnabled(ResponseBuilder rb) {
        return rb.req.getParams().getBool(COMPONENT_NAME, false);
    }

    private static List<InputDocument> documentsFromNamedList(List<NamedList<Object>> docList) {
        return docList.stream().map(docProps -> {
            InputDocument doc = new InputDocument(docProps.get("id"), (String)docProps.get("language"));
            docProps.forEach((fieldName, value) -> doc.addClusteredField((String)fieldName, (String)value));
            doc.visitFields((arg_0, arg_1) -> ((NamedList)docProps).add(arg_0, arg_1));
            return doc;
        }).collect(Collectors.toList());
    }

    private static List<NamedList<Object>> documentsToNamedList(List<InputDocument> documents) {
        return documents.stream().map(doc -> {
            SimpleOrderedMap docProps = new SimpleOrderedMap();
            docProps.add("id", doc.getId());
            docProps.add("language", (Object)doc.language());
            doc.visitFields((arg_0, arg_1) -> ((NamedList)docProps).add(arg_0, arg_1));
            return docProps;
        }).collect(Collectors.toList());
    }

    private static List<NamedList<Object>> clustersToNamedList(List<InputDocument> documents, List<Cluster<InputDocument>> clusters, EngineParameters params) {
        ArrayList<NamedList<Object>> result = new ArrayList<NamedList<Object>>();
        ClusteringComponent.clustersToNamedListRecursive(clusters, result, params);
        if (params.includeOtherTopics()) {
            LinkedHashSet clustered = new LinkedHashSet();
            clusters.forEach(cluster -> ClusteringComponent.collectUniqueDocuments((Cluster<InputDocument>)cluster, clustered));
            List unclustered = documents.stream().filter(doc -> !clustered.contains(doc)).collect(Collectors.toList());
            if (!unclustered.isEmpty()) {
                SimpleOrderedMap cluster2 = new SimpleOrderedMap();
                result.add((NamedList<Object>)cluster2);
                cluster2.add("other-topics", (Object)true);
                cluster2.add("labels", Collections.singletonList("Other topics"));
                cluster2.add("score", (Object)0.0);
                cluster2.add("docs", unclustered.stream().map(InputDocument::getId).collect(Collectors.toList()));
            }
        }
        return result;
    }

    private static void clustersToNamedListRecursive(List<Cluster<InputDocument>> outputClusters, List<NamedList<Object>> parent, EngineParameters params) {
        for (Cluster<InputDocument> cluster : outputClusters) {
            SimpleOrderedMap converted = new SimpleOrderedMap();
            parent.add((NamedList<Object>)converted);
            List labels = cluster.getLabels();
            if (labels.size() > params.maxLabels()) {
                labels = labels.subList(0, params.maxLabels());
            }
            converted.add("labels", (Object)labels);
            Double score = cluster.getScore();
            if (score != null) {
                converted.add("score", (Object)score);
            }
            ArrayList<InputDocument> docs = params.includeSubclusters() ? cluster.getDocuments() : new ArrayList<InputDocument>(ClusteringComponent.collectUniqueDocuments(cluster, new LinkedHashSet<InputDocument>()));
            converted.add("docs", docs.stream().map(InputDocument::getId).collect(Collectors.toList()));
            if (!params.includeSubclusters() || cluster.getClusters().isEmpty()) continue;
            ArrayList<NamedList<Object>> subclusters = new ArrayList<NamedList<Object>>();
            converted.add(RESPONSE_SECTION_CLUSTERS, subclusters);
            ClusteringComponent.clustersToNamedListRecursive(cluster.getClusters(), subclusters, params);
        }
    }

    private static LinkedHashSet<InputDocument> collectUniqueDocuments(Cluster<InputDocument> cluster, LinkedHashSet<InputDocument> unique) {
        unique.addAll(cluster.getDocuments());
        for (Cluster sub : cluster.getClusters()) {
            ClusteringComponent.collectUniqueDocuments((Cluster<InputDocument>)sub, unique);
        }
        return unique;
    }

    public void init(NamedList<?> args) {
        super.init(args);
        if (args != null) {
            for (Map.Entry entry : args) {
                if (!INIT_SECTION_ENGINE.equals(entry.getKey())) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unrecognized configuration entry: " + (String)entry.getKey());
                }
                this.declaredEngines.add(new EngineEntry(((NamedList)entry.getValue()).toSolrParams()));
            }
        }
    }

    public void inform(SolrCore core) {
        this.declaredEngines.forEach(engineEntry -> {
            if (!engineEntry.initialize(core)) {
                if (!engineEntry.optional) throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "A required clustering engine failed to initialize, check the logs: " + engineEntry.engineName);
                if (!log.isInfoEnabled()) return;
                log.info("Optional clustering engine is not available: {}", (Object)engineEntry.engineName);
                return;
            } else {
                if (this.engines.put(engineEntry.engineName, (EngineEntry)engineEntry) == null) return;
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, String.format(Locale.ROOT, "Duplicate clustering engine named '%s'.", engineEntry.engineName));
            }
        });
        if (this.engines.size() > 0) {
            if (log.isInfoEnabled()) {
                log.info("The following clustering engines are available: {}", (Object)String.join((CharSequence)", ", this.engines.keySet()));
            }
        } else {
            log.warn("No clustering engines are available.");
        }
    }

    public void prepare(ResponseBuilder rb) {
    }

    public void process(ResponseBuilder rb) throws IOException {
        if (!ClusteringComponent.isComponentEnabled(rb)) {
            return;
        }
        EngineEntry engine = this.getEngine(rb);
        EngineParameters parameters = engine.defaults.derivedFrom(rb.req.getParams());
        List<InputDocument> inputs = this.getDocuments(rb, parameters);
        QueryLimits queryLimits = QueryLimits.getCurrentLimits();
        if (queryLimits.maybeExitWithPartialResults("Clustering process")) {
            return;
        }
        if (rb.req.getParams().getBool("isShard", false) && rb.req.getParams().getBool(REQUEST_PARAM_COLLECT_INPUTS, false)) {
            rb.rsp.add(RESPONSE_SECTION_INPUT_DOCUMENTS, ClusteringComponent.documentsToNamedList(inputs));
        } else {
            this.doCluster(rb, engine, inputs, parameters);
        }
    }

    public void modifyRequest(ResponseBuilder rb, SearchComponent who, ShardRequest sreq) {
        if (!ClusteringComponent.isComponentEnabled(rb)) {
            return;
        }
        assert (sreq.params.getBool(COMPONENT_NAME, false)) : "Shard request should propagate clustering component enabled state?";
        if ((sreq.purpose & 0x40) != 0) {
            sreq.params.set(REQUEST_PARAM_COLLECT_INPUTS, true);
        }
    }

    public void finishStage(ResponseBuilder rb) {
        if (!ClusteringComponent.isComponentEnabled(rb)) {
            return;
        }
        if (rb.stage == 3000) {
            ArrayList<InputDocument> inputs = new ArrayList<InputDocument>();
            rb.finished.stream().filter(shardRequest -> (shardRequest.purpose & 0x40) != 0).flatMap(shardRequest -> shardRequest.responses.stream()).filter(rsp -> rsp.getException() == null).map(rsp -> rsp.getSolrResponse().getResponse()).forEach(response -> {
                List partialInputs = (List)response.get(RESPONSE_SECTION_INPUT_DOCUMENTS);
                if (partialInputs != null) {
                    inputs.addAll(ClusteringComponent.documentsFromNamedList(partialInputs));
                }
            });
            EngineEntry engine = this.getEngine(rb);
            EngineParameters parameters = engine.defaults.derivedFrom(rb.req.getParams());
            this.doCluster(rb, engine, inputs, parameters);
        }
    }

    private void doCluster(ResponseBuilder rb, EngineEntry engine, List<InputDocument> inputs, EngineParameters parameters) {
        QueryLimits queryLimits = QueryLimits.getCurrentLimits();
        if (queryLimits.maybeExitWithPartialResults("Clustering doCluster")) {
            return;
        }
        List<Cluster<InputDocument>> clusters = engine.get().cluster(parameters, rb.getQuery(), inputs);
        rb.rsp.add(RESPONSE_SECTION_CLUSTERS, ClusteringComponent.clustersToNamedList(inputs, clusters, parameters));
    }

    private List<InputDocument> getDocuments(ResponseBuilder responseBuilder, EngineParameters requestParameters) throws IOException {
        SolrQueryRequest solrRequest = responseBuilder.req;
        Query query = responseBuilder.getQuery();
        final SolrIndexSearcher indexSearcher = responseBuilder.req.getSearcher();
        SolrCore core = solrRequest.getCore();
        String[] fieldsToCluster = (String[])requestParameters.fields().toArray(String[]::new);
        IndexSchema schema = indexSearcher.getSchema();
        boolean preferQueryContext = requestParameters.preferQueryContext();
        LocalSolrQueryRequest req = null;
        SolrHighlighter highlighter = null;
        if (preferQueryContext) {
            highlighter = ((HighlightComponent)core.getSearchComponents().get("highlight")).getHighlighter((SolrParams)new ModifiableSolrParams().add("hl.method", new String[]{"original"}));
            HashMap<String, Object> args = new HashMap<String, Object>();
            args.put("hl.fl", fieldsToCluster);
            args.put("hl", "true");
            args.put("hl.simple.pre", "");
            args.put("hl.simple.post", "");
            args.put("hl.fragsize", requestParameters.contextSize());
            args.put("hl.snippets", requestParameters.contextCount());
            req = new LocalSolrQueryRequest(core, query.toString(), "", 0, 1, args){

                public SolrIndexSearcher getSearcher() {
                    return indexSearcher;
                }
            };
        }
        LinkedHashMap<String, Function<IndexableField, String>> fieldsToLoad = new LinkedHashMap<String, Function<IndexableField, String>>();
        for (String fld : requestParameters.getFieldsToLoad()) {
            FieldType type = schema.getField(fld).getType();
            fieldsToLoad.put(fld, fieldValue -> type.toObject(fieldValue).toString());
        }
        String languageField = requestParameters.languageField();
        Function<Map, String> docLanguage = languageField != null ? doc -> doc.getOrDefault(languageField, requestParameters.language()) : doc -> requestParameters.language();
        SolrDocumentFetcher docFetcher = indexSearcher.getDocFetcher();
        ArrayList<InputDocument> result = new ArrayList<InputDocument>();
        DocIterator it = responseBuilder.getResults().docList.iterator();
        while (it.hasNext()) {
            DocSlice docAsList;
            NamedList highlights;
            int docId = it.nextDoc();
            LinkedHashMap<String, String> docFieldValues = new LinkedHashMap<String, String>();
            for (IndexableField indexableField : docFetcher.doc(docId, fieldsToLoad.keySet())) {
                String fieldName = indexableField.name();
                Function toString = (Function)fieldsToLoad.get(fieldName);
                if (toString == null) continue;
                String value = (String)toString.apply(indexableField);
                docFieldValues.compute(fieldName, (k, v) -> {
                    if (v == null) {
                        return value;
                    }
                    return v + " . " + value;
                });
            }
            InputDocument inputDocument = new InputDocument(docFieldValues.get(requestParameters.docIdField()), docLanguage.apply(docFieldValues));
            result.add(inputDocument);
            Function<String, String> snippetProvider = field -> null;
            if (preferQueryContext && (highlights = highlighter.doHighlighting((DocList)(docAsList = new DocSlice(0, 1, new int[]{docId}, new float[]{1.0f}, 1L, 1.0f, TotalHits.Relation.EQUAL_TO)), query, (SolrQueryRequest)req, fieldsToCluster)) != null && highlights.size() == 1) {
                NamedList tmp = (NamedList)highlights.getVal(0);
                snippetProvider = field -> {
                    String[] values = (String[])tmp.get(field);
                    if (values == null) {
                        return null;
                    }
                    return String.join((CharSequence)" . ", Arrays.asList(values));
                };
            }
            Function<String, String> fullValueProvider = docFieldValues::get;
            for (String field2 : fieldsToCluster) {
                String values = snippetProvider.apply(field2);
                if (values == null) {
                    values = fullValueProvider.apply(field2);
                }
                if (values == null) continue;
                inputDocument.addClusteredField(field2, values);
            }
        }
        return result;
    }

    private EngineEntry getEngine(ResponseBuilder rb) {
        EngineEntry engine;
        if (this.engines.isEmpty()) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "No clustering engines are defined or loaded.");
        }
        String name = rb.req.getParams().get(REQUEST_PARAM_ENGINE, null);
        if (name != null) {
            engine = this.engines.get(name);
            if (engine == null) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Clustering engine unknown or not loaded: " + name);
            }
        } else {
            engine = this.engines.values().iterator().next();
        }
        return engine;
    }

    Set<String> getEngineNames() {
        return this.engines.keySet();
    }

    public String getDescription() {
        return "Search results clustering component";
    }
}

