/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import kafka.server.CachedPartition;
import kafka.server.FetchContext;
import kafka.server.FetchSessionCache;
import kafka.server.FullFetchContext$;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.FetchMetadata;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Option$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005ms!\u0002\r\u001a\u0011\u0003qb!\u0002\u0011\u001a\u0011\u0003\t\u0003\"\u0002\u0015\u0002\t\u0003I\u0003b\u0002\u0016\u0002\u0005\u0004%ia\u000b\u0005\u0007m\u0005\u0001\u000bQ\u0002\u0017\u0007\t\u0001J\u0002a\u000e\u0005\tw\u0015\u0011)\u0019!C\u0005y!A!*\u0002B\u0001B\u0003%Q\b\u0003\u0005L\u000b\t\u0015\r\u0011\"\u0003M\u0011!\u0001VA!A!\u0002\u0013i\u0005\u0002C)\u0006\u0005\u000b\u0007I\u0011\u0002*\t\u0011e+!\u0011!Q\u0001\nMC\u0001BW\u0003\u0003\u0006\u0004%Ia\u0017\u0005\t_\u0016\u0011\t\u0011)A\u00059\"A\u0001/\u0002BC\u0002\u0013%\u0011\u000f\u0003\u0005v\u000b\t\u0005\t\u0015!\u0003s\u0011!1XA!b\u0001\n\u0013\t\b\u0002C<\u0006\u0005\u0003\u0005\u000b\u0011\u0002:\t\u000b!*A\u0011\u0001=\t\u0011)*\u0001R1A\u0005B-Bq!!\u0001\u0006\t\u0003\n\u0019\u0001C\u0004\u0002\u0016\u0015!\t%a\u0006\t\u000f\u0005%R\u0001\"\u0011\u0002,!9\u0011qJ\u0003\u0005B\u0005E\u0013\u0001\u0005$vY24U\r^2i\u0007>tG/\u001a=u\u0015\tQ2$\u0001\u0004tKJ4XM\u001d\u0006\u00029\u0005)1.\u00194lC\u000e\u0001\u0001CA\u0010\u0002\u001b\u0005I\"\u0001\u0005$vY24U\r^2i\u0007>tG/\u001a=u'\t\t!\u0005\u0005\u0002$M5\tAEC\u0001&\u0003\u0015\u00198-\u00197b\u0013\t9CE\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003y\ta\u0001\\8hO\u0016\u0014X#\u0001\u0017\u0011\u00055\"T\"\u0001\u0018\u000b\u0005=\u0002\u0014\u0001D:dC2\fGn\\4hS:<'BA\u00193\u0003!!\u0018\u0010]3tC\u001a,'\"A\u001a\u0002\u0007\r|W.\u0003\u00026]\t1Aj\\4hKJ\fq\u0001\\8hO\u0016\u0014\beE\u0002\u0006Ea\u0002\"aH\u001d\n\u0005iJ\"\u0001\u0004$fi\u000eD7i\u001c8uKb$\u0018\u0001\u0002;j[\u0016,\u0012!\u0010\t\u0003}!k\u0011a\u0010\u0006\u0003\u0001\u0006\u000bQ!\u001e;jYNT!AQ\"\u0002\r\r|W.\\8o\u0015\taBI\u0003\u0002F\r\u00061\u0011\r]1dQ\u0016T\u0011aR\u0001\u0004_J<\u0017BA%@\u0005\u0011!\u0016.\\3\u0002\u000bQLW.\u001a\u0011\u0002\u000b\r\f7\r[3\u0016\u00035\u0003\"a\b(\n\u0005=K\"!\u0005$fi\u000eD7+Z:tS>t7)Y2iK\u000611-Y2iK\u0002\n1B]3r\u001b\u0016$\u0018\rZ1uCV\t1\u000b\u0005\u0002U/6\tQK\u0003\u0002W\u0003\u0006A!/Z9vKN$8/\u0003\u0002Y+\nia)\u001a;dQ6+G/\u00193bi\u0006\fAB]3r\u001b\u0016$\u0018\rZ1uC\u0002\n\u0011BZ3uG\"$\u0015\r^1\u0016\u0003q\u0003B!\u00182eQ6\taL\u0003\u0002`A\u0006!Q\u000f^5m\u0015\u0005\t\u0017\u0001\u00026bm\u0006L!a\u00190\u0003\u00075\u000b\u0007\u000f\u0005\u0002fM6\t\u0011)\u0003\u0002h\u0003\n\u0001Bk\u001c9jG&#\u0007+\u0019:uSRLwN\u001c\t\u0003S2t!\u0001\u00166\n\u0005-,\u0016\u0001\u0004$fi\u000eD'+Z9vKN$\u0018BA7o\u00055\u0001\u0016M\u001d;ji&|g\u000eR1uC*\u00111.V\u0001\u000bM\u0016$8\r\u001b#bi\u0006\u0004\u0013\u0001D;tKN$v\u000e]5d\u0013\u0012\u001cX#\u0001:\u0011\u0005\r\u001a\u0018B\u0001;%\u0005\u001d\u0011un\u001c7fC:\fQ\"^:fgR{\u0007/[2JIN\u0004\u0013AD5t\rJ|WNR8mY><XM]\u0001\u0010SN4%o\\7G_2dwn^3sAQ9\u0011P_>}{z|\bCA\u0010\u0006\u0011\u0015Y$\u00031\u0001>\u0011\u0015Y%\u00031\u0001N\u0011\u0015\t&\u00031\u0001T\u0011\u0015Q&\u00031\u0001]\u0011\u0015\u0001(\u00031\u0001s\u0011\u00151(\u00031\u0001s\u000399W\r\u001e$fi\u000eDwJ\u001a4tKR$B!!\u0002\u0002\u0012A)1%a\u0002\u0002\f%\u0019\u0011\u0011\u0002\u0013\u0003\r=\u0003H/[8o!\r\u0019\u0013QB\u0005\u0004\u0003\u001f!#\u0001\u0002'p]\u001eDa!a\u0005\u0015\u0001\u0004!\u0017\u0001\u00029beR\f\u0001CZ8sK\u0006\u001c\u0007\u000eU1si&$\u0018n\u001c8\u0015\t\u0005e\u0011q\u0004\t\u0004G\u0005m\u0011bAA\u000fI\t!QK\\5u\u0011\u001d\t\t#\u0006a\u0001\u0003G\t1AZ;o!\u001d\u0019\u0013Q\u00053i\u00033I1!a\n%\u0005%1UO\\2uS>t''A\bhKR\u0014Vm\u001d9p]N,7+\u001b>f)\u0019\ti#a\r\u0002FA\u00191%a\f\n\u0007\u0005EBEA\u0002J]RDq!!\u000e\u0017\u0001\u0004\t9$A\u0004va\u0012\fG/Z:\u0011\t\u0005e\u0012q\b\b\u0004?\u0005m\u0012bAA\u001f3\u0005aa)\u001a;dQN+7o]5p]&!\u0011\u0011IA\"\u0005!\u0011Vi\u0015)`\u001b\u0006\u0003&bAA\u001f3!9\u0011q\t\fA\u0002\u0005%\u0013!\u0003<feNLwN\\%e!\r\u0019\u00131J\u0005\u0004\u0003\u001b\"#!B*i_J$\u0018!H;qI\u0006$X-\u00118e\u000f\u0016tWM]1uKJ+7\u000f]8og\u0016$\u0015\r^1\u0015\t\u0005M\u0013\u0011\f\t\u0004)\u0006U\u0013bAA,+\nia)\u001a;dQJ+7\u000f]8og\u0016Dq!!\u000e\u0018\u0001\u0004\t9\u0004")
public class FullFetchContext
implements FetchContext {
    private Logger logger;
    private final Time time;
    private final FetchSessionCache cache;
    private final FetchMetadata reqMetadata;
    private final Map<TopicIdPartition, FetchRequest.PartitionData> fetchData;
    private final boolean usesTopicIds;
    private final boolean isFromFollower;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String partitionsToLogString(Collection<TopicIdPartition> partitions) {
        return FetchContext.partitionsToLogString$(this, partitions);
    }

    @Override
    public FetchResponse getThrottledResponse(int throttleTimeMs) {
        return FetchContext.getThrottledResponse$(this, throttleTimeMs);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private Time time() {
        return this.time;
    }

    private FetchSessionCache cache() {
        return this.cache;
    }

    private FetchMetadata reqMetadata() {
        return this.reqMetadata;
    }

    private Map<TopicIdPartition, FetchRequest.PartitionData> fetchData() {
        return this.fetchData;
    }

    private boolean usesTopicIds() {
        return this.usesTopicIds;
    }

    private boolean isFromFollower() {
        return this.isFromFollower;
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = FullFetchContext$.MODULE$.kafka$server$FullFetchContext$$logger();
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public Option<Object> getFetchOffset(TopicIdPartition part) {
        return Option$.MODULE$.apply((Object)this.fetchData().get(part)).map((Function1 & Serializable)x$3 -> BoxesRunTime.boxToLong((long)x$3.fetchOffset));
    }

    @Override
    public void foreachPartition(Function2<TopicIdPartition, FetchRequest.PartitionData, BoxedUnit> fun) {
        this.fetchData().forEach((tp, data) -> fun.apply(tp, data));
    }

    @Override
    public int getResponseSize(LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData> updates, short versionId) {
        return FetchResponse.sizeOf((short)versionId, updates.entrySet().iterator());
    }

    @Override
    public FetchResponse updateAndGenerateResponseData(LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData> updates) {
        int responseSessionId = this.cache().maybeCreateSession(this.time().milliseconds(), this.isFromFollower(), updates.size(), this.usesTopicIds(), (Function0<ImplicitLinkedHashCollection<CachedPartition>>)(Function0 & Serializable)() -> this.createNewSession$1(updates));
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(46).append("Full fetch context with session id ").append(responseSessionId).append(" returning ").append(this.partitionsToLogString(updates.keySet())).toString());
        return FetchResponse.of((Errors)Errors.NONE, (int)0, (int)responseSessionId, updates);
    }

    private final ImplicitLinkedHashCollection createNewSession$1(LinkedHashMap updates$2) {
        ImplicitLinkedHashCollection cachedPartitions = new ImplicitLinkedHashCollection(updates$2.size());
        updates$2.forEach((part, respData) -> {
            FetchRequest.PartitionData reqData = this.fetchData().get(part);
            cachedPartitions.mustAdd((ImplicitLinkedHashCollection.Element)new CachedPartition((TopicIdPartition)part, reqData, (FetchResponseData.PartitionData)respData));
        });
        return cachedPartitions;
    }

    public FullFetchContext(Time time, FetchSessionCache cache, FetchMetadata reqMetadata, Map<TopicIdPartition, FetchRequest.PartitionData> fetchData, boolean usesTopicIds, boolean isFromFollower) {
        this.time = time;
        this.cache = cache;
        this.reqMetadata = reqMetadata;
        this.fetchData = fetchData;
        this.usesTopicIds = usesTopicIds;
        this.isFromFollower = isFromFollower;
    }
}

