/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Meter;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import kafka.server.CachedPartition;
import kafka.server.EvictableKey;
import kafka.server.FetchSession;
import kafka.server.FetchSession$;
import kafka.server.LastUsedKey;
import kafka.utils.Logging;
import org.apache.kafka.common.requests.FetchMetadata;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.server.metrics.KafkaMetricsGroup;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.mutable.HashMap;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005\re\u0001\u0002\u0010 \u0001\u0011B\u0001\"\r\u0001\u0003\u0006\u0004%IA\r\u0005\tm\u0001\u0011\t\u0011)A\u0005g!Aq\u0007\u0001BC\u0002\u0013%\u0001\b\u0003\u0005=\u0001\t\u0005\t\u0015!\u0003:\u0011\u0015i\u0004\u0001\"\u0001?\u0011\u001d\u0019\u0005A1A\u0005\n\u0011Ca!\u0015\u0001!\u0002\u0013)\u0005b\u0002*\u0001\u0001\u0004%I\u0001\u000f\u0005\b'\u0002\u0001\r\u0011\"\u0003U\u0011\u0019Q\u0006\u0001)Q\u0005s!91\f\u0001b\u0001\n\u0013a\u0006B\u00025\u0001A\u0003%Q\fC\u0004j\u0001\t\u0007I\u0011\u00026\t\rY\u0004\u0001\u0015!\u0003l\u0011\u001d9\bA1A\u0005\naDa! \u0001!\u0002\u0013I\bb\u0002@\u0001\u0005\u0004%I\u0001\u001f\u0005\u0007\u007f\u0002\u0001\u000b\u0011B=\t\u0015\u0005\u0005\u0001A1A\u0005\u0002}\t\u0019\u0001\u0003\u0005\u0002\u001c\u0001\u0001\u000b\u0011BA\u0003\u0011\u001d\ti\u0002\u0001C\u0001\u0003?Aa!a\u000b\u0001\t\u0003\u0011\u0004BBA\u0017\u0001\u0011\u0005\u0001\bC\u0004\u00020\u0001!\t!!\r\t\u000f\u0005M\u0002\u0001\"\u0001\u00026!9\u00111\r\u0001\u0005\u0002\u0005\u0015\u0004bBA8\u0001\u0011\u0005\u0011\u0011\u000f\u0005\b\u0003_\u0002A\u0011AA;\u0011\u001d\tY\b\u0001C\u0001\u0003{\u0012\u0011CR3uG\"\u001cVm]:j_:\u001c\u0015m\u00195f\u0015\t\u0001\u0013%\u0001\u0004tKJ4XM\u001d\u0006\u0002E\u0005)1.\u00194lC\u000e\u00011c\u0001\u0001&WA\u0011a%K\u0007\u0002O)\t\u0001&A\u0003tG\u0006d\u0017-\u0003\u0002+O\t1\u0011I\\=SK\u001a\u0004\"\u0001L\u0018\u000e\u00035R!AL\u0011\u0002\u000bU$\u0018\u000e\\:\n\u0005Aj#a\u0002'pO\u001eLgnZ\u0001\u000b[\u0006DXI\u001c;sS\u0016\u001cX#A\u001a\u0011\u0005\u0019\"\u0014BA\u001b(\u0005\rIe\u000e^\u0001\f[\u0006DXI\u001c;sS\u0016\u001c\b%\u0001\u0006fm&\u001cG/[8o\u001bN,\u0012!\u000f\t\u0003MiJ!aO\u0014\u0003\t1{gnZ\u0001\fKZL7\r^5p]6\u001b\b%\u0001\u0004=S:LGO\u0010\u000b\u0004\u007f\u0005\u0013\u0005C\u0001!\u0001\u001b\u0005y\u0002\"B\u0019\u0006\u0001\u0004\u0019\u0004\"B\u001c\u0006\u0001\u0004I\u0014\u0001D7fiJL7m]$s_V\u0004X#A#\u0011\u0005\u0019{U\"A$\u000b\u0005!K\u0015aB7fiJL7m\u001d\u0006\u0003A)S!AI&\u000b\u00051k\u0015AB1qC\u000eDWMC\u0001O\u0003\ry'oZ\u0005\u0003!\u001e\u0013\u0011cS1gW\u0006lU\r\u001e:jGN<%o\\;q\u00035iW\r\u001e:jGN<%o\\;qA\u0005ia.^7QCJ$\u0018\u000e^5p]N\f\u0011C\\;n!\u0006\u0014H/\u001b;j_:\u001cx\fJ3r)\t)\u0006\f\u0005\u0002'-&\u0011qk\n\u0002\u0005+:LG\u000fC\u0004Z\u0013\u0005\u0005\t\u0019A\u001d\u0002\u0007a$\u0013'\u0001\bok6\u0004\u0016M\u001d;ji&|gn\u001d\u0011\u0002\u0011M,7o]5p]N,\u0012!\u0018\t\u0005=\u000e\u001cT-D\u0001`\u0015\t\u0001\u0017-A\u0004nkR\f'\r\\3\u000b\u0005\t<\u0013AC2pY2,7\r^5p]&\u0011Am\u0018\u0002\b\u0011\u0006\u001c\b.T1q!\t\u0001e-\u0003\u0002h?\taa)\u001a;dQN+7o]5p]\u0006I1/Z:tS>t7\u000fI\u0001\tY\u0006\u001cH/V:fIV\t1\u000e\u0005\u0003mcN,W\"A7\u000b\u00059|\u0017\u0001B;uS2T\u0011\u0001]\u0001\u0005U\u00064\u0018-\u0003\u0002s[\n9AK]3f\u001b\u0006\u0004\bC\u0001!u\u0013\t)xDA\u0006MCN$Xk]3e\u0017\u0016L\u0018!\u00037bgR,6/\u001a3!\u00039)g/[2uC\ndWMQ=BY2,\u0012!\u001f\t\u0005YFTX\r\u0005\u0002Aw&\u0011Ap\b\u0002\r\u000bZL7\r^1cY\u0016\\U-_\u0001\u0010KZL7\r^1cY\u0016\u0014\u00150\u00117mA\u0005)RM^5di\u0006\u0014G.\u001a\"z!JLg/\u001b7fO\u0016$\u0017AF3wS\u000e$\u0018M\u00197f\u0005f\u0004&/\u001b<jY\u0016<W\r\u001a\u0011\u0002\u001d\u00154\u0018n\u0019;j_:\u001cX*\u001a;feV\u0011\u0011Q\u0001\t\u0005\u0003\u000f\t9\"\u0004\u0002\u0002\n)!\u00111BA\u0007\u0003\u0011\u0019wN]3\u000b\u0007!\u000byA\u0003\u0003\u0002\u0012\u0005M\u0011AB=b[6,'O\u0003\u0002\u0002\u0016\u0005\u00191m\\7\n\t\u0005e\u0011\u0011\u0002\u0002\u0006\u001b\u0016$XM]\u0001\u0010KZL7\r^5p]NlU\r^3sA\u0005\u0019q-\u001a;\u0015\t\u0005\u0005\u0012q\u0005\t\u0005M\u0005\rR-C\u0002\u0002&\u001d\u0012aa\u00149uS>t\u0007BBA\u0015+\u0001\u00071'A\u0005tKN\u001c\u0018n\u001c8JI\u0006!1/\u001b>f\u0003=!x\u000e^1m!\u0006\u0014H/\u001b;j_:\u001c\u0018\u0001\u00048foN+7o]5p]&#G#A\u001a\u0002%5\f\u0017PY3De\u0016\fG/Z*fgNLwN\u001c\u000b\fg\u0005]\u00121HA#\u0003\u000f\nY\u0005\u0003\u0004\u0002:e\u0001\r!O\u0001\u0004]><\bbBA\u001f3\u0001\u0007\u0011qH\u0001\u000baJLg/\u001b7fO\u0016$\u0007c\u0001\u0014\u0002B%\u0019\u00111I\u0014\u0003\u000f\t{w\u000e\\3b]\"1\u00111F\rA\u0002MBq!!\u0013\u001a\u0001\u0004\ty$\u0001\u0007vg\u0016\u001cHk\u001c9jG&#7\u000fC\u0004\u0002Ne\u0001\r!a\u0014\u0002!\r\u0014X-\u0019;f!\u0006\u0014H/\u001b;j_:\u001c\b#\u0002\u0014\u0002R\u0005U\u0013bAA*O\tIa)\u001e8di&|g\u000e\r\t\u0005\u0003/\niFD\u0002A\u00033J1!a\u0017 \u000311U\r^2i'\u0016\u001c8/[8o\u0013\u0011\ty&!\u0019\u0003\u0013\r\u000b5\tS#`\u001b\u0006\u0003&bAA.?\u0005AAO]=Fm&\u001cG\u000f\u0006\u0005\u0002@\u0005\u001d\u0014\u0011NA7\u0011\u001d\tiD\u0007a\u0001\u0003\u007fAa!a\u001b\u001b\u0001\u0004Q\u0018aA6fs\"1\u0011\u0011\b\u000eA\u0002e\naA]3n_Z,G\u0003BA\u0011\u0003gBa!!\u000b\u001c\u0001\u0004\u0019D\u0003BA\u0011\u0003oBa!!\u001f\u001d\u0001\u0004)\u0017aB:fgNLwN\\\u0001\u0006i>,8\r\u001b\u000b\u0006+\u0006}\u0014\u0011\u0011\u0005\u0007\u0003sj\u0002\u0019A3\t\r\u0005eR\u00041\u0001:\u0001")
public class FetchSessionCache
implements Logging {
    private final int maxEntries;
    private final long evictionMs;
    private final KafkaMetricsGroup metricsGroup;
    private long numPartitions;
    private final HashMap<Object, FetchSession> sessions;
    private final TreeMap<LastUsedKey, FetchSession> lastUsed;
    private final TreeMap<EvictableKey, FetchSession> evictableByAll;
    private final TreeMap<EvictableKey, FetchSession> evictableByPrivileged;
    private final Meter evictionsMeter;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private int maxEntries() {
        return this.maxEntries;
    }

    private long evictionMs() {
        return this.evictionMs;
    }

    private KafkaMetricsGroup metricsGroup() {
        return this.metricsGroup;
    }

    private long numPartitions() {
        return this.numPartitions;
    }

    private void numPartitions_$eq(long x$1) {
        this.numPartitions = x$1;
    }

    private HashMap<Object, FetchSession> sessions() {
        return this.sessions;
    }

    private TreeMap<LastUsedKey, FetchSession> lastUsed() {
        return this.lastUsed;
    }

    private TreeMap<EvictableKey, FetchSession> evictableByAll() {
        return this.evictableByAll;
    }

    private TreeMap<EvictableKey, FetchSession> evictableByPrivileged() {
        return this.evictableByPrivileged;
    }

    public Meter evictionsMeter() {
        return this.evictionsMeter;
    }

    public synchronized Option<FetchSession> get(int sessionId) {
        return this.sessions().get((Object)BoxesRunTime.boxToInteger((int)sessionId));
    }

    public synchronized int size() {
        return this.sessions().size();
    }

    public synchronized long totalPartitions() {
        return this.numPartitions();
    }

    public synchronized int newSessionId() {
        int id;
        do {
            id = ThreadLocalRandom.current().nextInt(1, Integer.MAX_VALUE);
        } while (this.sessions().contains((Object)BoxesRunTime.boxToInteger((int)id)) || id == 0);
        return id;
    }

    public synchronized int maybeCreateSession(long now, boolean privileged, int size, boolean usesTopicIds, Function0<ImplicitLinkedHashCollection<CachedPartition>> createPartitions) {
        if (this.sessions().size() < this.maxEntries() || this.tryEvict(privileged, new EvictableKey(privileged, size, 0), now)) {
            ImplicitLinkedHashCollection partitionMap = (ImplicitLinkedHashCollection)createPartitions.apply();
            FetchSession session = new FetchSession(this.newSessionId(), privileged, (ImplicitLinkedHashCollection<CachedPartition>)partitionMap, usesTopicIds, now, now, FetchMetadata.nextEpoch((int)0));
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(22).append("Created fetch session ").append(session.toString()).toString());
            this.sessions().put((Object)BoxesRunTime.boxToInteger((int)session.id()), (Object)session);
            this.touch(session, now);
            return session.id();
        }
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(48).append("No fetch session created for privileged=").append(privileged).append(", size=").append(size).append(".").toString());
        return 0;
    }

    public synchronized boolean tryEvict(boolean privileged, EvictableKey key, long now) {
        Map.Entry<LastUsedKey, FetchSession> lastUsedEntry = this.lastUsed().firstEntry();
        if (lastUsedEntry == null) {
            this.trace((Function0<String>)(Function0 & Serializable)() -> "There are no cache entries to evict.");
            return false;
        }
        if (now - lastUsedEntry.getKey().lastUsedMs() > this.evictionMs()) {
            FetchSession session = lastUsedEntry.getValue();
            this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(29).append("Evicting stale FetchSession ").append(session.id()).append(".").toString());
            this.remove(session);
            this.evictionsMeter().mark();
            return true;
        }
        Map.Entry<EvictableKey, FetchSession> evictableEntry = (privileged ? this.evictableByPrivileged() : this.evictableByAll()).firstEntry();
        if (evictableEntry == null) {
            this.trace((Function0<String>)(Function0 & Serializable)() -> "No evictable entries found.");
            return false;
        }
        if (key.compareTo(evictableEntry.getKey()) < 0) {
            this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(18).append("Can't evict ").append(evictableEntry.getKey()).append(" with ").append(key.toString()).toString());
            return false;
        }
        this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(16).append("Evicting ").append(evictableEntry.getKey()).append(" with ").append(key.toString()).append(".").toString());
        this.remove(evictableEntry.getValue());
        this.evictionsMeter().mark();
        return true;
    }

    public synchronized Option<FetchSession> remove(int sessionId) {
        Option<FetchSession> option = this.get(sessionId);
        if (None$.MODULE$.equals(option)) {
            return None$.MODULE$;
        }
        if (option instanceof Some) {
            FetchSession session = (FetchSession)((Some)option).value();
            return this.remove(session);
        }
        throw new MatchError(option);
    }

    public synchronized Option<FetchSession> remove(FetchSession session) {
        EvictableKey evictableKey;
        synchronized (session) {
            this.lastUsed().remove(session.lastUsedKey());
            evictableKey = session.evictableKey();
        }
        this.evictableByAll().remove(evictableKey);
        this.evictableByPrivileged().remove(evictableKey);
        Option removeResult = this.sessions().remove((Object)BoxesRunTime.boxToInteger((int)session.id()));
        if (removeResult.isDefined()) {
            this.numPartitions_$eq(this.numPartitions() - (long)session.cachedSize());
        }
        return removeResult;
    }

    public synchronized void touch(FetchSession session, long now) {
        synchronized (session) {
            this.lastUsed().remove(session.lastUsedKey());
            session.lastUsedMs_$eq(now);
            this.lastUsed().put(session.lastUsedKey(), session);
            int oldSize = session.cachedSize();
            if (oldSize != -1) {
                EvictableKey oldEvictableKey = session.evictableKey();
                this.evictableByPrivileged().remove(oldEvictableKey);
                this.evictableByAll().remove(oldEvictableKey);
                this.numPartitions_$eq(this.numPartitions() - (long)oldSize);
            }
            session.cachedSize_$eq(session.size());
            EvictableKey newEvictableKey = session.evictableKey();
            if (!session.privileged() || now - session.creationMs() > this.evictionMs()) {
                this.evictableByPrivileged().put(newEvictableKey, session);
            }
            if (now - session.creationMs() > this.evictionMs()) {
                this.evictableByAll().put(newEvictableKey, session);
            }
            this.numPartitions_$eq(this.numPartitions() + (long)session.cachedSize());
            return;
        }
    }

    public final /* synthetic */ int kafka$server$FetchSessionCache$$$anonfun$new$1() {
        return this.size();
    }

    public final /* synthetic */ long kafka$server$FetchSessionCache$$$anonfun$new$2() {
        return this.totalPartitions();
    }

    public FetchSessionCache(int maxEntries, long evictionMs) {
        this.maxEntries = maxEntries;
        this.evictionMs = evictionMs;
        this.metricsGroup = new KafkaMetricsGroup(this.getClass());
        this.numPartitions = 0L;
        this.sessions = new HashMap();
        this.lastUsed = new TreeMap();
        this.evictableByAll = new TreeMap();
        this.evictableByPrivileged = new TreeMap();
        this.metricsGroup().removeMetric(FetchSession$.MODULE$.NUM_INCREMENTAL_FETCH_SESSIONS());
        this.metricsGroup().newGauge(FetchSession$.MODULE$.NUM_INCREMENTAL_FETCH_SESSIONS(), (Gauge)new Gauge<Object>(this){
            private final /* synthetic */ FetchSessionCache $outer;

            public final int value() {
                FetchSessionCache fetchSessionCache = this.$outer;
                if (fetchSessionCache == null) {
                    throw null;
                }
                return fetchSessionCache.size();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.metricsGroup().removeMetric(FetchSession$.MODULE$.NUM_INCREMENTAL_FETCH_PARTITIONS_CACHED());
        this.metricsGroup().newGauge(FetchSession$.MODULE$.NUM_INCREMENTAL_FETCH_PARTITIONS_CACHED(), (Gauge)new Gauge<Object>(this){
            private final /* synthetic */ FetchSessionCache $outer;

            public final long value() {
                FetchSessionCache fetchSessionCache = this.$outer;
                if (fetchSessionCache == null) {
                    throw null;
                }
                return fetchSessionCache.totalPartitions();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.metricsGroup().removeMetric(FetchSession$.MODULE$.INCREMENTAL_FETCH_SESSIONS_EVICTIONS_PER_SEC());
        this.evictionsMeter = this.metricsGroup().newMeter(FetchSession$.MODULE$.INCREMENTAL_FETCH_SESSIONS_EVICTIONS_PER_SEC(), FetchSession$.MODULE$.EVICTIONS(), TimeUnit.SECONDS, Collections.emptyMap());
    }
}

