/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.schema;

import com.ibm.icu.text.Collator;
import com.ibm.icu.text.RuleBasedCollator;
import com.ibm.icu.util.ULocale;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.icu.ICUCollationKeyAnalyzer;
import org.apache.lucene.analysis.tokenattributes.TermToBytesRefAttribute;
import org.apache.lucene.document.SortedDocValuesField;
import org.apache.lucene.document.SortedSetDocValuesField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TermRangeQuery;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.ResourceLoader;
import org.apache.lucene.util.Version;
import org.apache.solr.common.SolrException;
import org.apache.solr.core.XmlConfigFile;
import org.apache.solr.response.TextResponseWriter;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.QParser;
import org.apache.solr.uninverting.UninvertingReader;

public class ICUCollationField
extends FieldType {
    private Analyzer analyzer;
    private boolean failHardOnUdvas;
    static final Version UDVAS_FORBIDDEN_AS_OF = Version.LUCENE_9_0_0;
    static final String UDVAS_MESSAGE = "useDocValuesAsStored is forbidden for " + ICUCollationField.class + " as of luceneMatchVersion " + UDVAS_FORBIDDEN_AS_OF;

    private static void warnOrFailUdvas(boolean failHardOnUdvas) {
        XmlConfigFile.assertWarnOrFail((String)UDVAS_MESSAGE, (boolean)false, (boolean)failHardOnUdvas);
    }

    public void checkSchemaField(SchemaField field) {
        if (field.useDocValuesAsStored()) {
            ICUCollationField.warnOrFailUdvas(this.failHardOnUdvas);
        }
        super.checkSchemaField(field);
    }

    protected void init(IndexSchema schema, Map<String, String> args) {
        this.failHardOnUdvas = schema.getDefaultLuceneMatchVersion().onOrAfter(UDVAS_FORBIDDEN_AS_OF);
        if ((this.trueProperties & 0x20000) != 0) {
            ICUCollationField.warnOrFailUdvas(this.failHardOnUdvas);
        }
        this.properties &= 0xFFFDFFFF;
        this.properties |= 2;
        this.setup((ResourceLoader)schema.getResourceLoader(), args);
        super.init(schema, args);
    }

    private void setup(ResourceLoader loader, Map<String, String> args) {
        String custom = args.remove("custom");
        String localeID = args.remove("locale");
        String strength = args.remove("strength");
        String decomposition = args.remove("decomposition");
        String alternate = args.remove("alternate");
        String caseLevel = args.remove("caseLevel");
        String caseFirst = args.remove("caseFirst");
        String numeric = args.remove("numeric");
        String variableTop = args.remove("variableTop");
        if (custom == null && localeID == null) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Either custom or locale is required.");
        }
        if (custom != null && localeID != null) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Cannot specify both locale and custom. To tailor rules for a built-in language, see the javadocs for RuleBasedCollator. Then save the entire customized ruleset to a file, and use with the custom parameter");
        }
        Collator collator = localeID != null ? this.createFromLocale(localeID) : ICUCollationField.createFromRules(custom, loader);
        if (strength != null) {
            if (strength.equalsIgnoreCase("primary")) {
                collator.setStrength(0);
            } else if (strength.equalsIgnoreCase("secondary")) {
                collator.setStrength(1);
            } else if (strength.equalsIgnoreCase("tertiary")) {
                collator.setStrength(2);
            } else if (strength.equalsIgnoreCase("quaternary")) {
                collator.setStrength(3);
            } else if (strength.equalsIgnoreCase("identical")) {
                collator.setStrength(15);
            } else {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Invalid strength: " + strength);
            }
        }
        if (decomposition != null) {
            if (decomposition.equalsIgnoreCase("no")) {
                collator.setDecomposition(16);
            } else if (decomposition.equalsIgnoreCase("canonical")) {
                collator.setDecomposition(17);
            } else {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Invalid decomposition: " + decomposition);
            }
        }
        RuleBasedCollator rbc = (RuleBasedCollator)collator;
        if (alternate != null) {
            if (alternate.equalsIgnoreCase("shifted")) {
                rbc.setAlternateHandlingShifted(true);
            } else if (alternate.equalsIgnoreCase("non-ignorable")) {
                rbc.setAlternateHandlingShifted(false);
            } else {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Invalid alternate: " + alternate);
            }
        }
        if (caseLevel != null) {
            rbc.setCaseLevel(Boolean.parseBoolean(caseLevel));
        }
        if (caseFirst != null) {
            if (caseFirst.equalsIgnoreCase("lower")) {
                rbc.setLowerCaseFirst(true);
            } else if (caseFirst.equalsIgnoreCase("upper")) {
                rbc.setUpperCaseFirst(true);
            } else {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Invalid caseFirst: " + caseFirst);
            }
        }
        if (numeric != null) {
            rbc.setNumericCollation(Boolean.parseBoolean(numeric));
        }
        if (variableTop != null) {
            rbc.setVariableTop(variableTop);
        }
        this.analyzer = new ICUCollationKeyAnalyzer(collator);
    }

    private Collator createFromLocale(String localeID) {
        return Collator.getInstance((ULocale)new ULocale(localeID));
    }

    static Collator createFromRules(String fileName, ResourceLoader loader) {
        RuleBasedCollator ruleBasedCollator;
        block8: {
            InputStream input = loader.openResource(fileName);
            try {
                String rules = new String(input.readAllBytes(), StandardCharsets.UTF_8);
                ruleBasedCollator = new RuleBasedCollator(rules);
                if (input == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            input.close();
        }
        return ruleBasedCollator;
    }

    public void write(TextResponseWriter writer, String name, IndexableField f) throws IOException {
        writer.writeStr(name, f.stringValue(), true);
    }

    public SortField getSortField(SchemaField field, boolean top) {
        return this.getStringSort(field, top);
    }

    public UninvertingReader.Type getUninversionType(SchemaField sf) {
        if (sf.multiValued()) {
            return UninvertingReader.Type.SORTED_SET_BINARY;
        }
        return UninvertingReader.Type.SORTED;
    }

    public Analyzer getIndexAnalyzer() {
        return this.analyzer;
    }

    public Analyzer getQueryAnalyzer() {
        return this.analyzer;
    }

    private BytesRef getCollationKey(String field, String text) {
        BytesRef bytesRef;
        block10: {
            TokenStream source = this.analyzer.tokenStream(field, text);
            try {
                source.reset();
                TermToBytesRefAttribute termAtt = (TermToBytesRefAttribute)source.getAttribute(TermToBytesRefAttribute.class);
                if (!source.incrementToken()) {
                    throw new IllegalArgumentException("analyzer returned no terms for text: " + text);
                }
                BytesRef bytes = BytesRef.deepCopyOf((BytesRef)termAtt.getBytesRef());
                assert (!source.incrementToken());
                source.end();
                bytesRef = bytes;
                if (source == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (source != null) {
                        try {
                            source.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException("Unable to analyze text: " + text, e);
                }
            }
            source.close();
        }
        return bytesRef;
    }

    protected Query getSpecializedRangeQuery(QParser parser, SchemaField field, String part1, String part2, boolean minInclusive, boolean maxInclusive) {
        BytesRef high;
        String f = field.getName();
        BytesRef low = part1 == null ? null : this.getCollationKey(f, part1);
        BytesRef bytesRef = high = part2 == null ? null : this.getCollationKey(f, part2);
        if (!field.indexed() && field.hasDocValues()) {
            return SortedSetDocValuesField.newSlowRangeQuery((String)field.getName(), (BytesRef)low, (BytesRef)high, (boolean)minInclusive, (boolean)maxInclusive);
        }
        return new TermRangeQuery(field.getName(), low, high, minInclusive, maxInclusive);
    }

    protected void checkSupportsDocValues() {
    }

    protected boolean enableDocValuesByDefault() {
        return true;
    }

    public List<IndexableField> createFields(SchemaField field, Object value) {
        if (field.hasDocValues()) {
            ArrayList<IndexableField> fields = new ArrayList<IndexableField>();
            fields.add(this.createField(field, value));
            BytesRef bytes = this.getCollationKey(field.getName(), value.toString());
            if (field.multiValued()) {
                fields.add((IndexableField)new SortedSetDocValuesField(field.getName(), bytes));
            } else {
                fields.add((IndexableField)new SortedDocValuesField(field.getName(), bytes));
            }
            return fields;
        }
        return Collections.singletonList(this.createField(field, value));
    }

    public Object marshalSortValue(Object value) {
        return ICUCollationField.marshalBase64SortValue((Object)value);
    }

    public Object unmarshalSortValue(Object value) {
        return ICUCollationField.unmarshalBase64SortValue((Object)value);
    }
}

