/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.util;

import java.io.File;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.codehaus.plexus.util.SelectorUtils;

public class MatchPattern {
    private final String source;
    private final String regexPattern;
    private final String separator;
    private final String[] tokenized;
    private final char[][] tokenizedChar;

    private MatchPattern(String source, String separator) {
        this.regexPattern = SelectorUtils.isRegexPrefixedPattern(source) ? source.substring("%regex[".length(), source.length() - "]".length()) : null;
        this.source = SelectorUtils.isAntPrefixedPattern(source) ? source.substring("%ant[".length(), source.length() - "]".length()) : source;
        this.separator = separator;
        this.tokenized = MatchPattern.tokenizePathToString(this.source, separator);
        this.tokenizedChar = new char[this.tokenized.length][];
        for (int i2 = 0; i2 < this.tokenized.length; ++i2) {
            this.tokenizedChar[i2] = this.tokenized[i2].toCharArray();
        }
    }

    public boolean matchPath(String str, boolean isCaseSensitive) {
        if (this.regexPattern != null) {
            return str.matches(this.regexPattern);
        }
        return SelectorUtils.matchAntPathPattern(this, str, this.separator, isCaseSensitive);
    }

    boolean matchPath(String str, char[][] strDirs, boolean isCaseSensitive) {
        if (this.regexPattern != null) {
            return str.matches(this.regexPattern);
        }
        return SelectorUtils.matchAntPathPattern(this.getTokenizedPathChars(), strDirs, isCaseSensitive);
    }

    public boolean matchPatternStart(String str, boolean isCaseSensitive) {
        if (this.regexPattern != null) {
            return true;
        }
        String altStr = str.replace('\\', '/');
        return SelectorUtils.matchAntPathPatternStart(this, str, File.separator, isCaseSensitive) || SelectorUtils.matchAntPathPatternStart(this, altStr, "/", isCaseSensitive);
    }

    public String[] getTokenizedPathString() {
        return this.tokenized;
    }

    public char[][] getTokenizedPathChars() {
        return this.tokenizedChar;
    }

    public boolean startsWith(String string2) {
        return this.source.startsWith(string2);
    }

    static String[] tokenizePathToString(String path, String separator) {
        ArrayList<String> ret = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(path, separator);
        while (st.hasMoreTokens()) {
            ret.add(st.nextToken());
        }
        return ret.toArray(new String[0]);
    }

    static char[][] tokenizePathToCharArray(String path, String separator) {
        String[] tokenizedName = MatchPattern.tokenizePathToString(path, separator);
        char[][] tokenizedNameChar = new char[tokenizedName.length][];
        for (int i2 = 0; i2 < tokenizedName.length; ++i2) {
            tokenizedNameChar[i2] = tokenizedName[i2].toCharArray();
        }
        return tokenizedNameChar;
    }

    public static MatchPattern fromString(String source) {
        return new MatchPattern(source, File.separator);
    }
}

