/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.handler.codec.http.HttpConstants;
import io.netty.util.CharsetUtil;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.StringUtil;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;

public class QueryStringEncoder {
    private final Charset charset;
    private final StringBuilder uriBuilder;
    private boolean hasParams;
    private static final byte WRITE_UTF_UNKNOWN = 63;
    private static final char[] CHAR_MAP = "0123456789ABCDEF".toCharArray();

    public QueryStringEncoder(String uri) {
        this(uri, HttpConstants.DEFAULT_CHARSET);
    }

    public QueryStringEncoder(String uri, Charset charset) {
        ObjectUtil.checkNotNull(charset, "charset");
        this.uriBuilder = new StringBuilder(uri);
        this.charset = CharsetUtil.UTF_8.equals(charset) ? null : charset;
    }

    public void addParam(String name, String value) {
        ObjectUtil.checkNotNull(name, "name");
        if (this.hasParams) {
            this.uriBuilder.append('&');
        } else {
            this.uriBuilder.append('?');
            this.hasParams = true;
        }
        this.encodeComponent(name);
        if (value != null) {
            this.uriBuilder.append('=');
            this.encodeComponent(value);
        }
    }

    private void encodeComponent(CharSequence s2) {
        if (this.charset == null) {
            this.encodeUtf8Component(s2);
        } else {
            this.encodeNonUtf8Component(s2);
        }
    }

    public URI toUri() throws URISyntaxException {
        return new URI(this.toString());
    }

    public String toString() {
        return this.uriBuilder.toString();
    }

    private void encodeNonUtf8Component(CharSequence s2) {
        char[] buf = null;
        int i2 = 0;
        int len = s2.length();
        while (i2 < len) {
            byte[] bytes;
            char c2 = s2.charAt(i2);
            if (QueryStringEncoder.dontNeedEncoding(c2)) {
                this.uriBuilder.append(c2);
                ++i2;
                continue;
            }
            int index = 0;
            if (buf == null) {
                buf = new char[s2.length() - i2];
            }
            do {
                buf[index] = c2;
                ++index;
            } while (++i2 < s2.length() && !QueryStringEncoder.dontNeedEncoding(c2 = s2.charAt(i2)));
            for (byte b2 : bytes = new String(buf, 0, index).getBytes(this.charset)) {
                this.appendEncoded(b2);
            }
        }
    }

    private void encodeUtf8Component(CharSequence s2) {
        int len = s2.length();
        for (int i2 = 0; i2 < len; ++i2) {
            char c2 = s2.charAt(i2);
            if (QueryStringEncoder.dontNeedEncoding(c2)) continue;
            this.encodeUtf8Component(s2, i2, len);
            return;
        }
        this.uriBuilder.append(s2);
    }

    private void encodeUtf8Component(CharSequence s2, int encodingStart, int len) {
        if (encodingStart > 0) {
            this.uriBuilder.append(s2, 0, encodingStart);
        }
        this.encodeUtf8ComponentSlow(s2, encodingStart, len);
    }

    private void encodeUtf8ComponentSlow(CharSequence s2, int start, int len) {
        for (int i2 = start; i2 < len; ++i2) {
            char c2 = s2.charAt(i2);
            if (c2 < '\u0080') {
                if (QueryStringEncoder.dontNeedEncoding(c2)) {
                    this.uriBuilder.append(c2);
                    continue;
                }
                this.appendEncoded(c2);
                continue;
            }
            if (c2 < '\u0800') {
                this.appendEncoded(0xC0 | c2 >> 6);
                this.appendEncoded(0x80 | c2 & 0x3F);
                continue;
            }
            if (StringUtil.isSurrogate(c2)) {
                if (!Character.isHighSurrogate(c2)) {
                    this.appendEncoded(63);
                    continue;
                }
                if (++i2 == s2.length()) {
                    this.appendEncoded(63);
                    break;
                }
                this.writeUtf8Surrogate(c2, s2.charAt(i2));
                continue;
            }
            this.appendEncoded(0xE0 | c2 >> 12);
            this.appendEncoded(0x80 | c2 >> 6 & 0x3F);
            this.appendEncoded(0x80 | c2 & 0x3F);
        }
    }

    private void writeUtf8Surrogate(char c2, char c22) {
        if (!Character.isLowSurrogate(c22)) {
            this.appendEncoded(63);
            this.appendEncoded(Character.isHighSurrogate(c22) ? 63 : (int)c22);
            return;
        }
        int codePoint = Character.toCodePoint(c2, c22);
        this.appendEncoded(0xF0 | codePoint >> 18);
        this.appendEncoded(0x80 | codePoint >> 12 & 0x3F);
        this.appendEncoded(0x80 | codePoint >> 6 & 0x3F);
        this.appendEncoded(0x80 | codePoint & 0x3F);
    }

    private void appendEncoded(int b2) {
        this.uriBuilder.append('%').append(QueryStringEncoder.forDigit(b2 >> 4)).append(QueryStringEncoder.forDigit(b2));
    }

    private static char forDigit(int digit) {
        return CHAR_MAP[digit & 0xF];
    }

    private static boolean dontNeedEncoding(char ch) {
        return ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch >= '0' && ch <= '9' || ch == '-' || ch == '_' || ch == '.' || ch == '*' || ch == '~';
    }
}

