/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.hash.EqualityPolicy;
import com.intellij.util.indexing.impl.ChangeTrackingValueContainer;
import com.intellij.util.indexing.impl.MapIndexStorageCache;
import com.intellij.util.indexing.impl.MapIndexStorageCacheProvider;
import com.intellij.util.indexing.impl.MapIndexStorageCaffeineCache;
import com.intellij.util.indexing.impl.MapIndexStorageSlruCache;
import java.util.function.BiConsumer;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002Jj\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u0002H\t\u0012\u0004\u0012\u0002H\n0\b\"\u0004\b\u0000\u0010\t\"\u0004\b\u0001\u0010\n2\u0018\u0010\u000b\u001a\u0014\u0012\u0004\u0012\u0002H\t\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\n0\r0\f2\u0018\u0010\u000e\u001a\u0014\u0012\u0004\u0012\u0002H\t\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\n0\r0\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\t0\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/util/indexing/impl/MapIndexStorageCacheSlruProvider;", "Lcom/intellij/util/indexing/impl/MapIndexStorageCacheProvider;", "()V", "CAFFEINE_OFFLOAD_IO", "", "USE_CAFFEINE", "USE_SLRU", "createCache", "Lcom/intellij/util/indexing/impl/MapIndexStorageCache;", "Key", "Value", "keyReader", "Ljava/util/function/Function;", "Lcom/intellij/util/indexing/impl/ChangeTrackingValueContainer;", "evictionListener", "Ljava/util/function/BiConsumer;", "hashingStrategy", "Lcom/intellij/util/containers/hash/EqualityPolicy;", "cacheSize", "", "intellij.platform.util"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nMapIndexStorageCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MapIndexStorageCache.kt\ncom/intellij/util/indexing/impl/MapIndexStorageCacheSlruProvider\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,188:1\n13#2:189\n*S KotlinDebug\n*F\n+ 1 MapIndexStorageCache.kt\ncom/intellij/util/indexing/impl/MapIndexStorageCacheSlruProvider\n*L\n61#1:189\n*E\n"})
public final class MapIndexStorageCacheSlruProvider
implements MapIndexStorageCacheProvider {
    @NotNull
    public static final MapIndexStorageCacheSlruProvider INSTANCE = new MapIndexStorageCacheSlruProvider();
    private static final boolean USE_SLRU = System.getProperty("idea.indexes.cache.type", "slru").equals("slru");
    private static final boolean USE_CAFFEINE = System.getProperty("idea.indexes.cache.type", "slru").equals("caffeine");
    private static final boolean CAFFEINE_OFFLOAD_IO = SystemProperties.getBooleanProperty("idea.indexes.cache.offload-io", false);

    private MapIndexStorageCacheSlruProvider() {
    }

    @Override
    @NotNull
    public <Key, Value> MapIndexStorageCache<Key, Value> createCache(@NotNull Function<Key, ChangeTrackingValueContainer<Value>> keyReader, @NotNull BiConsumer<Key, ChangeTrackingValueContainer<Value>> evictionListener, @NotNull EqualityPolicy<Key> hashingStrategy, int cacheSize) {
        MapIndexStorageCache mapIndexStorageCache;
        Intrinsics.checkNotNullParameter(keyReader, "keyReader");
        Intrinsics.checkNotNullParameter(evictionListener, "evictionListener");
        Intrinsics.checkNotNullParameter(hashingStrategy, "hashingStrategy");
        if (USE_SLRU) {
            mapIndexStorageCache = new MapIndexStorageSlruCache<Key, Value>(keyReader, evictionListener, hashingStrategy, cacheSize);
        } else if (USE_CAFFEINE) {
            mapIndexStorageCache = new MapIndexStorageCaffeineCache<Key, Value>(keyReader, evictionListener, CAFFEINE_OFFLOAD_IO, hashingStrategy, cacheSize);
        } else {
            throw new AssertionError((Object)"'slru'/'caffeine' are the only cache implementations available now");
        }
        return mapIndexStorageCache;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(MapIndexStorageCacheProvider.class);
        Intrinsics.checkNotNullExpressionValue(logger, "getInstance(...)");
        Logger logger2 = logger;
        if (USE_SLRU) {
            logger2.info("SLRU-cache will be used for indexes");
        } else if (USE_CAFFEINE) {
            logger2.info("Caffeine-cache will be used for indexes");
        } else {
            logger2.warn("Unrecognized cache impl is configured for indexes! ('slru' and 'caffeine' are the supported impls)");
        }
    }
}

