/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.jarRepository.JarRepositoryManager;
import com.intellij.jarRepository.RemoteRepositoryDescription;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.LanguageLevelUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.JdkUtil;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.projectRoots.impl.JavaSdkImpl;
import com.intellij.openapi.roots.LanguageLevelModuleExtension;
import com.intellij.openapi.roots.LanguageLevelProjectExtension;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.ui.OrderRoot;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.testFramework.IndexingTestUtil;
import com.intellij.testFramework.PlatformTestUtil;
import com.intellij.testFramework.Timings;
import com.intellij.testFramework.fixtures.MavenDependencyUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.PathUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.lang.JavaVersion;
import com.sun.tools.javac.Main;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import org.codehaus.groovy.tools.FileSystemCompiler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.idea.maven.utils.library.RepositoryLibraryProperties;
import org.junit.Assert;
import org.junit.Assume;

@TestOnly
public final class IdeaTestUtil {
    private static final String MOCK_JDK_DIR_NAME_PREFIX = "mockJDK-";
    private static final String MOCK_JDK_GROUP_ID = "mockjdk-base-java";

    public static void printDetectedPerformanceTimings() {
        System.out.println(Timings.getStatistics());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void withLevel(@NotNull Module module2, @NotNull LanguageLevel level, @NotNull Runnable r) {
        if (module2 == null) {
            IdeaTestUtil.$$$reportNull$$$0(0);
        }
        if (level == null) {
            IdeaTestUtil.$$$reportNull$$$0(1);
        }
        if (r == null) {
            IdeaTestUtil.$$$reportNull$$$0(2);
        }
        LanguageLevelProjectExtension projectExt = LanguageLevelProjectExtension.getInstance((Project)module2.getProject());
        LanguageLevel projectLevel = projectExt.getLanguageLevel();
        LanguageLevel moduleLevel = LanguageLevelUtil.getCustomLanguageLevel((Module)module2);
        try {
            projectExt.setLanguageLevel(level);
            IdeaTestUtil.setModuleLanguageLevel(module2, level);
            IndexingTestUtil.waitUntilIndexesAreReady(module2.getProject());
            r.run();
        }
        finally {
            IdeaTestUtil.setModuleLanguageLevel(module2, moduleLevel);
            projectExt.setLanguageLevel(projectLevel);
            IndexingTestUtil.waitUntilIndexesAreReady(module2.getProject());
        }
    }

    public static void setProjectLanguageLevel(@NotNull Project project2, @NotNull LanguageLevel level, @NotNull Disposable disposable) {
        if (project2 == null) {
            IdeaTestUtil.$$$reportNull$$$0(3);
        }
        if (level == null) {
            IdeaTestUtil.$$$reportNull$$$0(4);
        }
        if (disposable == null) {
            IdeaTestUtil.$$$reportNull$$$0(5);
        }
        LanguageLevel oldLevel = IdeaTestUtil.setProjectLanguageLevel(project2, level);
        Disposer.register((Disposable)disposable, () -> IdeaTestUtil.setProjectLanguageLevel(project2, oldLevel));
    }

    public static LanguageLevel setProjectLanguageLevel(@NotNull Project project2, @NotNull LanguageLevel level) {
        if (project2 == null) {
            IdeaTestUtil.$$$reportNull$$$0(6);
        }
        if (level == null) {
            IdeaTestUtil.$$$reportNull$$$0(7);
        }
        LanguageLevelProjectExtension projectExt = LanguageLevelProjectExtension.getInstance((Project)project2);
        LanguageLevel oldLevel = projectExt.getLanguageLevel();
        projectExt.setLanguageLevel(level);
        IndexingTestUtil.waitUntilIndexesAreReady(project2);
        return oldLevel;
    }

    public static LanguageLevel setModuleLanguageLevel(@NotNull Module module2, @Nullable LanguageLevel level) {
        if (module2 == null) {
            IdeaTestUtil.$$$reportNull$$$0(8);
        }
        LanguageLevel prev = LanguageLevelUtil.getCustomLanguageLevel((Module)module2);
        ModuleRootModificationUtil.updateModel((Module)module2, model2 -> ((LanguageLevelModuleExtension)model2.getModuleExtension(LanguageLevelModuleExtension.class)).setLanguageLevel(level));
        IndexingTestUtil.waitUntilIndexesAreReady(module2.getProject());
        return prev;
    }

    public static void setModuleLanguageLevel(@NotNull Module module2, @NotNull LanguageLevel level, @NotNull Disposable parentDisposable) {
        if (module2 == null) {
            IdeaTestUtil.$$$reportNull$$$0(9);
        }
        if (level == null) {
            IdeaTestUtil.$$$reportNull$$$0(10);
        }
        if (parentDisposable == null) {
            IdeaTestUtil.$$$reportNull$$$0(11);
        }
        LanguageLevel prev = IdeaTestUtil.setModuleLanguageLevel(module2, level);
        Disposer.register((Disposable)parentDisposable, () -> IdeaTestUtil.setModuleLanguageLevel(module2, prev));
    }

    @NotNull
    public static Sdk getMockJdk(@NotNull JavaVersion version) {
        if (version == null) {
            IdeaTestUtil.$$$reportNull$$$0(12);
        }
        int mockJdk = version.feature >= 21 ? 21 : (version.feature >= 11 ? 11 : (version.feature >= 9 ? 9 : (version.feature >= 7 ? version.feature : (version.feature >= 5 ? 7 : 4))));
        String sdkName = IdeaTestUtil.getMockJdkName(version);
        if (mockJdk > 9) {
            Sdk sdk = IdeaTestUtil.createMockJdkFromRepository(sdkName, mockJdk);
            if (sdk == null) {
                IdeaTestUtil.$$$reportNull$$$0(13);
            }
            return sdk;
        }
        String path = IdeaTestUtil.getPathForJdkNamed("mockJDK-1." + mockJdk).getPath();
        return IdeaTestUtil.createMockJdk(sdkName, path);
    }

    @NotNull
    public static String getMockJdkName(@NotNull JavaVersion version) {
        if (version == null) {
            IdeaTestUtil.$$$reportNull$$$0(14);
        }
        String string = "java " + version;
        if (string == null) {
            IdeaTestUtil.$$$reportNull$$$0(15);
        }
        return string;
    }

    private static Sdk createMockJdkFromRepository(String name, int version) {
        List<RemoteRepositoryDescription> repos = MavenDependencyUtil.getRemoteRepositoryDescriptions();
        String coordinates = "org.jetbrains.mockjdk:mockjdk-base-java:" + version + ".0";
        RepositoryLibraryProperties libraryProperties = new RepositoryLibraryProperties(coordinates, false);
        Collection roots = JarRepositoryManager.loadDependenciesModal((Project)ProjectManager.getInstance().getDefaultProject(), (RepositoryLibraryProperties)libraryProperties, (boolean)false, (boolean)false, null, repos);
        if (roots.isEmpty()) {
            throw new IllegalStateException("MockJDK artifact not found: " + coordinates);
        }
        if (roots.size() != 1) {
            throw new IllegalStateException("Unexpected number of roots: " + coordinates + ": " + roots);
        }
        VirtualFile file2 = ((OrderRoot)roots.iterator().next()).getFile();
        String canonicalPath = file2.getCanonicalPath();
        if (canonicalPath == null) {
            throw new IllegalStateException("No canonical path found for " + file2);
        }
        return IdeaTestUtil.createMockJdk(name, canonicalPath);
    }

    @Nullable
    public static Sdk createMockJdkFromLegacyPath(@NotNull String path) {
        if (path == null) {
            IdeaTestUtil.$$$reportNull$$$0(16);
        }
        if (Path.of(path, new String[0]).getFileName().toString().equals("mockJDK-11")) {
            return IdeaTestUtil.getMockJdk(JavaVersion.compose((int)11));
        }
        return null;
    }

    @NotNull
    public static Sdk createMockJdk(@NotNull String name, @NotNull String path, Consumer<SdkModificator> sdkModificatorCustomizer) {
        String sdkPath;
        Sdk fromLegacyPath;
        if (name == null) {
            IdeaTestUtil.$$$reportNull$$$0(17);
        }
        if (path == null) {
            IdeaTestUtil.$$$reportNull$$$0(18);
        }
        if ((fromLegacyPath = IdeaTestUtil.createMockJdkFromLegacyPath(path)) != null) {
            Sdk sdk = fromLegacyPath;
            if (sdk == null) {
                IdeaTestUtil.$$$reportNull$$$0(19);
            }
            return sdk;
        }
        JavaSdk javaSdk = JavaSdk.getInstance();
        if (javaSdk == null) {
            throw new AssertionError((Object)"The test uses classes from Java plugin but Java plugin wasn't loaded; make sure that Java plugin classes are included into classpath and that the plugin isn't disabled by 'idea.load.plugins' or 'idea.load.plugins.id' system properties");
        }
        Sdk sdk = ProjectJdkTable.getInstance().createSdk(name, (SdkTypeId)JavaSdk.getInstance());
        SdkModificator sdkModificator = sdk.getSdkModificator();
        if (path.endsWith(".jar!/")) {
            sdkPath = PathUtil.getParentPath((String)path);
            sdkModificator.addRoot("jar://" + path, OrderRootType.CLASSES);
        } else {
            sdkPath = PathUtil.toSystemIndependentName((String)path);
            File[] jars = new File(path, "jre/lib").listFiles(f -> f.getName().endsWith(".jar"));
            if (jars != null) {
                for (File jar : jars) {
                    sdkModificator.addRoot("jar://" + PathUtil.toSystemIndependentName((String)jar.getPath()) + "!/", OrderRootType.CLASSES);
                }
            }
        }
        sdkModificator.setHomePath(sdkPath);
        sdkModificator.setVersionString(name);
        if (sdkModificatorCustomizer != null) {
            sdkModificatorCustomizer.accept(sdkModificator);
        }
        if ((path.endsWith("mockJDK-1.7") || path.endsWith("mockJDK-1.4")) && new File(path, "src.zip").exists()) {
            sdkModificator.addRoot("jar://" + PathUtil.toSystemIndependentName((String)path) + "/src.zip!/", OrderRootType.SOURCES);
        }
        JavaSdkImpl.attachJdkAnnotations((SdkModificator)sdkModificator);
        Application application = ApplicationManager.getApplication();
        Runnable runnable2 = () -> sdkModificator.commitChanges();
        if (application.isDispatchThread()) {
            application.runWriteAction(runnable2);
        } else {
            application.invokeAndWait(() -> application.runWriteAction(runnable2));
        }
        Sdk sdk2 = sdk;
        if (sdk2 == null) {
            IdeaTestUtil.$$$reportNull$$$0(20);
        }
        return sdk2;
    }

    @NotNull
    public static Sdk createMockJdk(@NotNull String name, @NotNull String path) {
        if (name == null) {
            IdeaTestUtil.$$$reportNull$$$0(21);
        }
        if (path == null) {
            IdeaTestUtil.$$$reportNull$$$0(22);
        }
        return IdeaTestUtil.createMockJdk(name, path, null);
    }

    @NotNull
    public static Sdk getMockJdk14() {
        return IdeaTestUtil.getMockJdk(JavaVersion.compose((int)4));
    }

    @NotNull
    public static Sdk getMockJdk16() {
        return IdeaTestUtil.getMockJdk(JavaVersion.compose((int)6));
    }

    @NotNull
    public static Sdk getMockJdk17() {
        return IdeaTestUtil.getMockJdk(JavaVersion.compose((int)7));
    }

    @NotNull
    public static Sdk getMockJdk17(@NotNull String name) {
        if (name == null) {
            IdeaTestUtil.$$$reportNull$$$0(23);
        }
        return IdeaTestUtil.createMockJdk(name, IdeaTestUtil.getMockJdk17Path().getPath());
    }

    @NotNull
    public static Sdk getMockJdk18() {
        return IdeaTestUtil.getMockJdk(JavaVersion.compose((int)8));
    }

    @NotNull
    public static Sdk getMockJdk9() {
        return IdeaTestUtil.getMockJdk(JavaVersion.compose((int)9));
    }

    @NotNull
    public static Sdk getMockJdk11() {
        return IdeaTestUtil.getMockJdk(JavaVersion.compose((int)11));
    }

    @NotNull
    public static Sdk getMockJdk21() {
        return IdeaTestUtil.getMockJdk(JavaVersion.compose((int)21));
    }

    @NotNull
    public static File getMockJdk14Path() {
        return IdeaTestUtil.getPathForJdkNamed("mockJDK-1.4");
    }

    @NotNull
    public static File getMockJdk17Path() {
        return IdeaTestUtil.getPathForJdkNamed("mockJDK-1.7");
    }

    @NotNull
    public static File getMockJdk18Path() {
        return IdeaTestUtil.getPathForJdkNamed("mockJDK-1.8");
    }

    public static String getMockJdkVersion(@NotNull String path) {
        String name;
        if (path == null) {
            IdeaTestUtil.$$$reportNull$$$0(24);
        }
        return (name = PathUtil.getFileName((String)path)).startsWith(MOCK_JDK_DIR_NAME_PREFIX) ? "java " + StringUtil.trimStart((String)name, (String)MOCK_JDK_DIR_NAME_PREFIX) : null;
    }

    @NotNull
    private static File getPathForJdkNamed(@NotNull String name) {
        if (name == null) {
            IdeaTestUtil.$$$reportNull$$$0(25);
        }
        return new File(PlatformTestUtil.getCommunityPath(), "java/" + name);
    }

    public static void addWebJarsToModule(@NotNull Module module2) {
        if (module2 == null) {
            IdeaTestUtil.$$$reportNull$$$0(26);
        }
        ModuleRootModificationUtil.updateModel((Module)module2, IdeaTestUtil::addWebJarsToModule);
        IndexingTestUtil.waitUntilIndexesAreReady(module2.getProject());
    }

    public static void addWebJarsToModule(@NotNull ModifiableRootModel model2) {
        if (model2 == null) {
            IdeaTestUtil.$$$reportNull$$$0(27);
        }
        MavenDependencyUtil.addFromMaven(model2, "javax.servlet.jsp:javax.servlet.jsp-api:2.3.3");
        MavenDependencyUtil.addFromMaven(model2, "javax.servlet:javax.servlet-api:3.1.0");
        IndexingTestUtil.waitUntilIndexesAreReady(model2.getProject());
    }

    public static void setTestVersion(@NotNull JavaSdkVersion testVersion, @NotNull Module module2, @NotNull Disposable parentDisposable) {
        if (testVersion == null) {
            IdeaTestUtil.$$$reportNull$$$0(28);
        }
        if (module2 == null) {
            IdeaTestUtil.$$$reportNull$$$0(29);
        }
        if (parentDisposable == null) {
            IdeaTestUtil.$$$reportNull$$$0(30);
        }
        Sdk sdk = ModuleRootManager.getInstance((Module)module2).getSdk();
        Assert.assertNotNull((Object)sdk);
        String oldVersionString = sdk.getVersionString();
        IdeaTestUtil.setSdkVersion(sdk, testVersion.getDescription());
        IndexingTestUtil.waitUntilIndexesAreReady(module2.getProject());
        Assert.assertSame((Object)testVersion, (Object)JavaSdk.getInstance().getVersion(sdk));
        Disposer.register((Disposable)parentDisposable, () -> {
            IdeaTestUtil.setSdkVersion(sdk, oldVersionString);
            IndexingTestUtil.waitUntilIndexesAreReady(module2.getProject());
        });
    }

    private static void setSdkVersion(@NotNull Sdk sdk, @Nullable String sdkVersion) {
        if (sdk == null) {
            IdeaTestUtil.$$$reportNull$$$0(31);
        }
        SdkModificator sdkModificator = sdk.getSdkModificator();
        sdkModificator.setVersionString(sdkVersion);
        ApplicationManager.getApplication().runWriteAction(() -> sdkModificator.commitChanges());
    }

    @NotNull
    public static String requireRealJdkHome() {
        String javaHome = SystemProperties.getJavaHome();
        List paths = ContainerUtil.packNullables((Object[])new String[]{javaHome, new File(javaHome).getParent(), System.getenv("JDK_16_x64"), System.getenv("JDK_16")});
        for (String path : paths) {
            if (!JdkUtil.checkForJdk((String)path)) continue;
            String string = path;
            if (string == null) {
                IdeaTestUtil.$$$reportNull$$$0(32);
            }
            return string;
        }
        Assume.assumeTrue((String)("Cannot find JDK, checked paths: " + paths), (boolean)false);
        if (null == null) {
            IdeaTestUtil.$$$reportNull$$$0(33);
        }
        return null;
    }

    @NotNull
    public static File findSourceFile(@NotNull String basePath) {
        File testFile;
        if (basePath == null) {
            IdeaTestUtil.$$$reportNull$$$0(34);
        }
        if (!(testFile = new File(basePath + ".java")).exists()) {
            testFile = new File(basePath + ".groovy");
        }
        if (!testFile.exists()) {
            throw new IllegalArgumentException("No test source for " + basePath);
        }
        File file2 = testFile;
        if (file2 == null) {
            IdeaTestUtil.$$$reportNull$$$0(35);
        }
        return file2;
    }

    public static void compileFile(@NotNull File source, @NotNull File out, String ... options2) {
        if (source == null) {
            IdeaTestUtil.$$$reportNull$$$0(36);
        }
        if (out == null) {
            IdeaTestUtil.$$$reportNull$$$0(37);
        }
        if (options2 == null) {
            IdeaTestUtil.$$$reportNull$$$0(38);
        }
        Assert.assertTrue((String)("source does not exist: " + source.getPath()), (boolean)source.isFile());
        ArrayList<String> args = new ArrayList<String>();
        args.add("-d");
        args.add(out.getAbsolutePath());
        ContainerUtil.addAll(args, (Object[])options2);
        args.add(source.getAbsolutePath());
        if (source.getName().endsWith(".groovy")) {
            try {
                FileSystemCompiler.commandLineCompile((String[])ArrayUtilRt.toStringArray(args));
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        } else {
            int result2 = Main.compile(ArrayUtilRt.toStringArray(args));
            if (result2 != 0) {
                throw new IllegalStateException("javac failed with exit code " + result2);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 13, 15, 19, 20, 32, 33, 35 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "r";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 11: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 13: 
            case 15: 
            case 19: 
            case 20: 
            case 32: 
            case 33: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/testFramework/IdeaTestUtil";
                break;
            }
            case 16: 
            case 18: 
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 17: 
            case 21: 
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testVersion";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "basePath";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "out";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/testFramework/IdeaTestUtil";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getMockJdk";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getMockJdkName";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "createMockJdk";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "requireRealJdkHome";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "findSourceFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "withLevel";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setProjectLanguageLevel";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setModuleLanguageLevel";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getMockJdk";
                break;
            }
            case 13: 
            case 15: 
            case 19: 
            case 20: 
            case 32: 
            case 33: 
            case 35: {
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getMockJdkName";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createMockJdkFromLegacyPath";
                break;
            }
            case 17: 
            case 18: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "createMockJdk";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getMockJdk17";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getMockJdkVersion";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getPathForJdkNamed";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "addWebJarsToModule";
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "setTestVersion";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "setSdkVersion";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "findSourceFile";
                break;
            }
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "compileFile";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 13, 15, 19, 20, 32, 33, 35 -> new IllegalStateException(string);
        };
    }
}

