/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.nativecerts.mac;

import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import com.sun.jna.platform.mac.CoreFoundation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.nativecerts.mac.CFArrayRefByReference;
import org.jetbrains.nativecerts.mac.CFStringRefByReference;

public interface SecurityFramework
extends Library {
    public static final SecurityFramework INSTANCE = (SecurityFramework)Native.load((String)"Security", SecurityFramework.class);
    public static final CoreFoundation.CFTypeID SEC_CERTIFICATE_TYPE_ID = INSTANCE.SecCertificateGetTypeID();
    public static final CoreFoundation.CFTypeID SEC_POLICY_TYPE_ID = INSTANCE.SecPolicyGetTypeID();
    public static final CoreFoundation.CFStringRef kSecPolicyAppleSSL = CoreFoundation.CFStringRef.createCFString((String)"1.2.840.113635.100.1.3");
    public static final CoreFoundation.CFStringRef kSecPolicyOid = CoreFoundation.CFStringRef.createCFString((String)"SecPolicyOid");
    public static final CoreFoundation.CFStringRef kSecTrustSettingsResult = CoreFoundation.CFStringRef.createCFString((String)"kSecTrustSettingsResult");
    public static final CoreFoundation.CFStringRef kSecTrustSettingsAllowedError = CoreFoundation.CFStringRef.createCFString((String)"kSecTrustSettingsAllowedError");
    public static final CoreFoundation.CFStringRef kSecTrustSettingsPolicyName = CoreFoundation.CFStringRef.createCFString((String)"kSecTrustSettingsPolicyName");
    public static final CoreFoundation.CFStringRef kSecTrustSettingsPolicy = CoreFoundation.CFStringRef.createCFString((String)"kSecTrustSettingsPolicy");

    @Nullable
    public CoreFoundation.CFStringRef SecCopyErrorMessageString(@NotNull OSStatus var1, @Nullable Pointer var2);

    @NotNull
    public OSStatus SecTrustSettingsCopyCertificates(@NotNull SecTrustSettingsDomain var1, @NotNull CFArrayRefByReference var2);

    @NotNull
    public OSStatus SecCertificateCopyCommonName(@NotNull SecCertificateRef var1, @NotNull CFStringRefByReference var2);

    public CoreFoundation.CFTypeID SecCertificateGetTypeID();

    public CoreFoundation.CFTypeID SecPolicyGetTypeID();

    public CoreFoundation.CFDictionaryRef SecPolicyCopyProperties(SecPolicyRef var1);

    public CoreFoundation.CFDataRef SecCertificateCopyData(SecCertificateRef var1);

    public OSStatus SecTrustSettingsCopyTrustSettings(SecCertificateRef var1, SecTrustSettingsDomain var2, CFArrayRefByReference var3);

    public static class SecTrustSettingsDomain
    extends NativeLong {
        public static final SecTrustSettingsDomain user = new SecTrustSettingsDomain(0L);
        public static final SecTrustSettingsDomain admin = new SecTrustSettingsDomain(1L);
        public static final SecTrustSettingsDomain system = new SecTrustSettingsDomain(2L);

        public SecTrustSettingsDomain() {
        }

        public SecTrustSettingsDomain(long value) {
            super(value);
        }
    }

    public static class OSStatus
    extends NativeLong {
        public static final OSStatus errSecSuccess = new OSStatus(0L);
        public static final OSStatus errSecItemNotFound = new OSStatus(-25300L);
        public static final OSStatus errSecNoTrustSettings = new OSStatus(-25263L);

        public OSStatus() {
        }

        public OSStatus(long value) {
            super(value);
        }

        @NotNull
        public String getErrorMessageString() {
            CoreFoundation.CFStringRef string = INSTANCE.SecCopyErrorMessageString(this, Pointer.NULL);
            if (string == null) {
                return "OSStatus:" + this.longValue();
            }
            try {
                String string2 = string.stringValue();
                return string2;
            }
            finally {
                string.release();
            }
        }

        public boolean equals(Object rhs) {
            if (!(rhs instanceof OSStatus)) {
                return false;
            }
            return this.intValue() == ((OSStatus)((Object)rhs)).intValue();
        }

        public int hashCode() {
            return this.intValue();
        }

        public String toString() {
            return this.getErrorMessageString();
        }
    }

    public static class SecTrustSettingsResult
    extends NativeLong {
        public static final SecTrustSettingsResult kSecTrustSettingsResultInvalid = new SecTrustSettingsResult(0L);
        public static final SecTrustSettingsResult kSecTrustSettingsResultTrustRoot = new SecTrustSettingsResult(1L);
        public static final SecTrustSettingsResult kSecTrustSettingsResultTrustAsRoot = new SecTrustSettingsResult(2L);
        public static final SecTrustSettingsResult kSecTrustSettingsResultDeny = new SecTrustSettingsResult(3L);
        public static final SecTrustSettingsResult kSecTrustSettingsResultUnspecified = new SecTrustSettingsResult(4L);

        public SecTrustSettingsResult() {
        }

        public SecTrustSettingsResult(long value) {
            super(value);
        }
    }

    public static class SecPolicyRef
    extends CoreFoundation.CFTypeRef {
        public SecPolicyRef() {
        }

        public SecPolicyRef(Pointer p) {
            super(p);
            if (!this.isTypeID(SEC_POLICY_TYPE_ID)) {
                throw new ClassCastException("Unable to cast to SecPolicyRef. Type ID: " + this.getTypeID());
            }
        }
    }

    public static class SecCertificateRef
    extends CoreFoundation.CFTypeRef {
        public SecCertificateRef() {
        }

        public SecCertificateRef(Pointer p) {
            super(p);
            if (!this.isTypeID(SEC_CERTIFICATE_TYPE_ID)) {
                throw new ClassCastException("Unable to cast to SecCertificateRef. Type ID: " + this.getTypeID());
            }
        }
    }
}

