/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.sudo;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.sudo.LocalSudoCommandProvider;
import com.intellij.execution.sudo.SudoCommandProvider;
import com.intellij.execution.util.ExecUtil;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.io.PathExecLazyValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.io.IdeUtilIoBundle;
import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\u001f\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u000b\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\nH\u0016\u00a8\u0006\f"}, d2={"Lcom/intellij/execution/sudo/LocalSudoCommandProvider;", "Lcom/intellij/execution/sudo/SudoCommandProvider;", "()V", "isAvailable", "", "sudoCommand", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "wrappedCommand", "prompt", "", "Lorg/jetbrains/annotations/Nls;", "Companion", "intellij.platform.ide.util.io"})
@ApiStatus.Internal
public class LocalSudoCommandProvider
implements SudoCommandProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Supplier<Boolean> hasGkSudo;
    @NotNull
    private static final Supplier<Boolean> hasKdeSudo;
    @NotNull
    private static final Supplier<Boolean> hasPkExec;

    @Override
    public boolean isAvailable() {
        return true;
    }

    @Override
    @Nullable
    public GeneralCommandLine sudoCommand(@NotNull GeneralCommandLine wrappedCommand, @NotNull String prompt) {
        GeneralCommandLine generalCommandLine;
        Intrinsics.checkNotNullParameter((Object)wrappedCommand, (String)"wrappedCommand");
        Intrinsics.checkNotNullParameter((Object)prompt, (String)"prompt");
        Object object = new String[]{wrappedCommand.getExePath()};
        List command = CollectionsKt.mutableListOf((Object[])object);
        object = command;
        List<String> list = wrappedCommand.getParametersList().getList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getList(...)");
        CollectionsKt.addAll((Collection)object, (Iterable)list);
        if (SystemInfoRt.isWindows) {
            Path path = PathManager.findBinFileWithException((String)"launcher.exe");
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"findBinFileWithException(...)");
            Path launcherExe = path;
            Object[] objectArray = new String[2];
            objectArray[0] = ((Object)launcherExe).toString();
            Intrinsics.checkNotNullExpressionValue((Object)wrappedCommand.getExePath(), (String)"getExePath(...)");
            Collection collection = CollectionsKt.listOf((Object[])objectArray);
            List<String> list2 = wrappedCommand.getParametersList().getParameters();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"getParameters(...)");
            generalCommandLine = new GeneralCommandLine(CollectionsKt.plus((Collection)collection, (Iterable)list2));
        } else if (SystemInfoRt.isMac) {
            escapedCommand = CollectionsKt.joinToString$default((Iterable)command, (CharSequence)" & \" \" & ", null, null, (int)0, null, (Function1)sudoCommand.escapedCommand.1.INSTANCE, (int)30, null);
            String messageArg = " with prompt \"" + StringUtil.escapeQuotes((String)prompt) + "\"";
            String escapedScript = "tell current application\n   activate\n   do shell script " + (String)escapedCommand + messageArg + " with administrator privileges without altering line endings\nend tell";
            String[] stringArray = new String[]{ExecUtil.getOsascriptPath(), "-e", escapedScript};
            GeneralCommandLine generalCommandLine2 = new GeneralCommandLine(stringArray);
            generalCommandLine = generalCommandLine2;
        } else {
            Boolean bl = hasGkSudo.get();
            Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"get(...)");
            if (bl.booleanValue()) {
                escapedCommand = new String[]{"gksudo", "--message", prompt, "--"};
                GeneralCommandLine generalCommandLine3 = new GeneralCommandLine(CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.listOf((Object[])escapedCommand), (Iterable)ExecUtil.INSTANCE.envCommand(wrappedCommand)), (Iterable)command));
                generalCommandLine = generalCommandLine3;
            } else {
                Boolean bl2 = hasKdeSudo.get();
                Intrinsics.checkNotNullExpressionValue((Object)bl2, (String)"get(...)");
                if (bl2.booleanValue()) {
                    escapedCommand = new String[]{"kdesudo", "--comment", prompt, "--"};
                    GeneralCommandLine generalCommandLine4 = new GeneralCommandLine(CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.listOf((Object[])escapedCommand), (Iterable)ExecUtil.INSTANCE.envCommand(wrappedCommand)), (Iterable)command));
                    generalCommandLine = generalCommandLine4;
                } else {
                    Boolean bl3 = hasPkExec.get();
                    Intrinsics.checkNotNullExpressionValue((Object)bl3, (String)"get(...)");
                    if (bl3.booleanValue()) {
                        generalCommandLine = new GeneralCommandLine(CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)"pkexec"), (Iterable)ExecUtil.INSTANCE.envCommand(wrappedCommand)), (Iterable)command));
                    } else if (ExecUtil.hasTerminalApp()) {
                        String escapedCommandLine2 = CollectionsKt.joinToString$default((Iterable)command, (CharSequence)" ", null, null, (int)0, null, (Function1)sudoCommand.escapedCommandLine.1.INSTANCE, (int)30, null);
                        List<String> args = ExecUtil.INSTANCE.envCommandArgs$intellij_platform_ide_util_io(wrappedCommand);
                        String escapedEnvCommand2 = Intrinsics.areEqual(args, (Object)CollectionsKt.emptyList()) ? "" : "env " + CollectionsKt.joinToString$default((Iterable)args, (CharSequence)" ", null, null, (int)0, null, (Function1)sudoCommand.escapedEnvCommand.1.INSTANCE, (int)30, null) + " ";
                        File script = ExecUtil.createTempExecutableScript("sudo", ".sh", "#!/bin/sh\necho " + ExecUtil.escapeUnixShellArgument(prompt) + "\necho\nsudo -- " + escapedEnvCommand2 + escapedCommandLine2 + "\nSTATUS=$?\necho\nread -p \"Press Enter to close this window...\" TEMP\nexit $STATUS\n");
                        String string = IdeUtilIoBundle.message("terminal.title.install", new Object[0]);
                        String string2 = script.getAbsolutePath();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getAbsolutePath(...)");
                        generalCommandLine = new GeneralCommandLine(ExecUtil.getTerminalCommand(string, string2));
                    } else {
                        generalCommandLine = null;
                    }
                }
            }
        }
        return generalCommandLine;
    }

    static {
        Supplier supplier = PathExecLazyValue.create((String)"gksudo");
        Intrinsics.checkNotNullExpressionValue((Object)supplier, (String)"create(...)");
        hasGkSudo = supplier;
        Supplier supplier2 = PathExecLazyValue.create((String)"kdesudo");
        Intrinsics.checkNotNullExpressionValue((Object)supplier2, (String)"create(...)");
        hasKdeSudo = supplier2;
        Supplier supplier3 = PathExecLazyValue.create((String)"pkexec");
        Intrinsics.checkNotNullExpressionValue((Object)supplier3, (String)"create(...)");
        hasPkExec = supplier3;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R!\u0010\u0003\u001a\u0015\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\b\u001a\u0015\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\t\u001a\u0015\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/execution/sudo/LocalSudoCommandProvider$Companion;", "", "()V", "hasGkSudo", "Ljava/util/function/Supplier;", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "hasKdeSudo", "hasPkExec", "intellij.platform.ide.util.io"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

