/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.tasks;

import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.GithubServerPath;
import org.jetbrains.plugins.github.authentication.GHAccountsUtil;
import org.jetbrains.plugins.github.authentication.GHLoginRequest;
import org.jetbrains.plugins.github.authentication.ui.GHLoginModel;
import org.jetbrains.plugins.github.exceptions.GithubParseException;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0007\u001a\u00020\u0004H\u0002\u00a8\u0006\n"}, d2={"Lorg/jetbrains/plugins/github/tasks/GHRepositoryEditorKt;", "", "()V", "askToken", "", "project", "Lcom/intellij/openapi/project/Project;", "host", "tryParse", "Lorg/jetbrains/plugins/github/api/GithubServerPath;", "intellij.vcs.github"})
final class GHRepositoryEditorKt {
    @NotNull
    public static final GHRepositoryEditorKt INSTANCE = new GHRepositoryEditorKt();

    private GHRepositoryEditorKt() {
    }

    @Nullable
    public final String askToken(@NotNull Project project, @NotNull String host) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        GithubServerPath githubServerPath = this.tryParse(host);
        if (githubServerPath == null) {
            return null;
        }
        GithubServerPath server = githubServerPath;
        var model2 = new GHLoginModel(){
            @Nullable
            private String token;

            @Nullable
            public final String getToken() {
                return this.token;
            }

            public final void setToken(@Nullable String string) {
                this.token = string;
            }

            public boolean isAccountUnique(@NotNull GithubServerPath server, @NotNull String login2) {
                Intrinsics.checkNotNullParameter((Object)server, (String)"server");
                Intrinsics.checkNotNullParameter((Object)login2, (String)"login");
                return true;
            }

            @Nullable
            public Object saveLogin(@NotNull GithubServerPath server, @NotNull String login2, @NotNull String token2, @NotNull Continuation<? super Unit> $completion) {
                this.token = token2;
                return Unit.INSTANCE;
            }
        };
        GHAccountsUtil.login$intellij_vcs_github(model2, new GHLoginRequest(null, null, server, false, null, false, null, 123, null), project, null);
        return model2.getToken();
    }

    private final GithubServerPath tryParse(String host) {
        GithubServerPath githubServerPath;
        try {
            githubServerPath = GithubServerPath.from(host);
        }
        catch (GithubParseException ignored) {
            githubServerPath = null;
        }
        return githubServerPath;
    }
}

