/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.jsonSchema.JsonDependencyModificationTracker;
import com.jetbrains.jsonSchema.JsonPointerUtil;
import com.jetbrains.jsonSchema.extension.JsonSchemaValidation;
import com.jetbrains.jsonSchema.extension.adapters.JsonValueAdapter;
import com.jetbrains.jsonSchema.ide.JsonSchemaService;
import com.jetbrains.jsonSchema.impl.IfThenElse;
import com.jetbrains.jsonSchema.impl.JsonCachedValues;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import com.jetbrains.jsonSchema.impl.JsonSchemaType;
import com.jetbrains.jsonSchema.impl.PatternProperties;
import com.jetbrains.jsonSchema.impl.PropertyNamePattern;
import com.jetbrains.jsonSchema.impl.light.legacy.JsonSchemaObjectReadingUtils;
import com.jetbrains.jsonSchema.impl.validations.JsonSchemaValidationsCollectorKt;
import com.jetbrains.jsonSchema.remote.JsonFileResolver;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated
public class JsonSchemaObjectImpl
extends JsonSchemaObject {
    public static final Logger LOG = Logger.getInstance(JsonSchemaObjectImpl.class);
    @NonNls
    public static final String DEFINITIONS = "definitions";
    @NonNls
    public static final String DEFINITIONS_v9 = "$defs";
    @NonNls
    public static final String PROPERTIES = "properties";
    @NonNls
    public static final String ITEMS = "items";
    @NonNls
    public static final String ADDITIONAL_ITEMS = "additionalItems";
    @Nullable
    public final String myFileUrl;
    @Nullable
    public JsonSchemaObjectImpl myBackRef;
    @NotNull
    public final String myPointer;
    @Nullable
    public final VirtualFile myRawFile;
    @Nullable
    public Map<String, JsonSchemaObjectImpl> myDefinitionsMap;
    @NotNull
    public Map<String, JsonSchemaObjectImpl> myProperties;
    @Nullable
    public PatternProperties myPatternProperties;
    @Nullable
    public PropertyNamePattern myPattern;
    @Nullable
    public String myId;
    @Nullable
    public String mySchema;
    @Nullable
    public String myTitle;
    @Nullable
    public String myDescription;
    @Nullable
    public String myHtmlDescription;
    @Nullable
    public String myLanguageInjection;
    @Nullable
    public String myLanguageInjectionPrefix;
    @Nullable
    public String myLanguageInjectionPostfix;
    @Nullable
    public JsonSchemaType myType;
    @Nullable
    public Object myDefault;
    @Nullable
    public Map<String, Object> myExample;
    @Nullable
    public String myRef;
    public boolean myRefIsRecursive;
    public boolean myIsRecursiveAnchor;
    @Nullable
    public String myFormat;
    @Nullable
    public Set<JsonSchemaType> myTypeVariants;
    @Nullable
    public Number myMultipleOf;
    @Nullable
    public Number myMaximum;
    public boolean myExclusiveMaximum;
    @Nullable
    public Number myExclusiveMaximumNumber;
    @Nullable
    public Number myMinimum;
    public boolean myExclusiveMinimum;
    @Nullable
    public Number myExclusiveMinimumNumber;
    @Nullable
    public Integer myMaxLength;
    @Nullable
    public Integer myMinLength;
    @Nullable
    public Boolean myAdditionalPropertiesAllowed;
    @Nullable
    public Set<String> myAdditionalPropertiesNotAllowedFor;
    @Nullable
    public JsonSchemaObjectImpl myAdditionalPropertiesSchema;
    @Nullable
    public JsonSchemaObjectImpl myPropertyNamesSchema;
    @Nullable
    public Boolean myAdditionalItemsAllowed;
    @Nullable
    public JsonSchemaObjectImpl myAdditionalItemsSchema;
    @Nullable
    public JsonSchemaObjectImpl myItemsSchema;
    @Nullable
    public JsonSchemaObjectImpl myContainsSchema;
    @Nullable
    public List<JsonSchemaObjectImpl> myItemsSchemaList;
    @Nullable
    public Integer myMaxItems;
    @Nullable
    public Integer myMinItems;
    @Nullable
    public Boolean myUniqueItems;
    @Nullable
    public Integer myMaxProperties;
    @Nullable
    public Integer myMinProperties;
    @Nullable
    public Set<String> myRequired;
    @Nullable
    public Map<String, List<String>> myPropertyDependencies;
    @Nullable
    public Map<String, JsonSchemaObjectImpl> mySchemaDependencies;
    @Nullable
    public List<Object> myEnum;
    @Nullable
    public List<JsonSchemaObjectImpl> myAllOf;
    @Nullable
    public List<JsonSchemaObjectImpl> myAnyOf;
    @Nullable
    public List<JsonSchemaObjectImpl> myOneOf;
    @Nullable
    public JsonSchemaObjectImpl myNot;
    @Nullable
    public List<IfThenElse> myIfThenElse;
    @Nullable
    public JsonSchemaObjectImpl myIf;
    @Nullable
    public JsonSchemaObjectImpl myThen;
    @Nullable
    public JsonSchemaObjectImpl myElse;
    public boolean myShouldValidateAgainstJSType;
    @Nullable
    public String myDeprecationMessage;
    @Nullable
    public Map<String, String> myIdsMap;
    @Nullable
    public Map<String, Map<String, String>> myEnumMetadata;
    public boolean myForceCaseInsensitive;
    public final UserDataHolderBase myUserDataHolder;
    public boolean myIsValidByExclusion;

    @Override
    @Nullable
    public String readChildNodeValue(String ... childNodeName) {
        if (childNodeName == null) {
            JsonSchemaObjectImpl.$$$reportNull$$$0(0);
        }
        return null;
    }

    @Override
    public boolean hasChildNode(String ... childNodeName) {
        if (childNodeName == null) {
            JsonSchemaObjectImpl.$$$reportNull$$$0(1);
        }
        return false;
    }

    @Override
    @Nullable
    public Boolean getConstantSchema() {
        return null;
    }

    @Override
    public boolean hasChildFieldsExcept(String ... namesToSkip) {
        if (namesToSkip == null) {
            JsonSchemaObjectImpl.$$$reportNull$$$0(2);
        }
        return false;
    }

    @Override
    @NotNull
    public Iterable<JsonSchemaValidation> getValidations(final @Nullable JsonSchemaType type2, final @NotNull JsonValueAdapter value) {
        if (value == null) {
            JsonSchemaObjectImpl.$$$reportNull$$$0(3);
        }
        return new Iterable<JsonSchemaValidation>(){

            @Override
            @NotNull
            public Iterator<JsonSchemaValidation> iterator() {
                Iterator iterator = JsonSchemaValidationsCollectorKt.getSchema7AndEarlierValidations(JsonSchemaObjectImpl.this, type2, value).iterator();
                if (iterator == null) {
                    1.$$$reportNull$$$0(0);
                }
                return iterator;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/jsonSchema/impl/JsonSchemaObjectImpl$1", "iterator"));
            }
        };
    }

    @Override
    @NotNull
    public JsonSchemaObject getRootSchemaObject() {
        throw new UnsupportedOperationException("Do not use the method against old json schema implementation!");
    }

    @Override
    public boolean isValidByExclusion() {
        return this.myIsValidByExclusion;
    }

    public void setValidByExclusion(boolean validByExclusion) {
        this.myIsValidByExclusion = validByExclusion;
    }

    @Override
    public boolean isForceCaseInsensitive() {
        return this.myForceCaseInsensitive;
    }

    public void setForceCaseInsensitive(boolean forceCaseInsensitive) {
        this.myForceCaseInsensitive = forceCaseInsensitive;
    }

    public JsonSchemaObjectImpl(@Nullable VirtualFile file, @NotNull String pointer) {
        if (pointer == null) {
            JsonSchemaObjectImpl.$$$reportNull$$$0(4);
        }
        this.myForceCaseInsensitive = false;
        this.myUserDataHolder = new UserDataHolderBase();
        this.myIsValidByExclusion = true;
        this.myFileUrl = file == null ? null : file.getUrl();
        this.myRawFile = this.myFileUrl != null && JsonFileResolver.isTempOrMockUrl(this.myFileUrl) ? file : null;
        this.myPointer = pointer;
        this.myProperties = new HashMap<String, JsonSchemaObjectImpl>();
    }

    public JsonSchemaObjectImpl(@Nullable VirtualFile rawFile, @Nullable String fileUrl, @NotNull String pointer) {
        if (pointer == null) {
            JsonSchemaObjectImpl.$$$reportNull$$$0(5);
        }
        this.myForceCaseInsensitive = false;
        this.myUserDataHolder = new UserDataHolderBase();
        this.myIsValidByExclusion = true;
        this.myFileUrl = fileUrl;
        this.myRawFile = rawFile;
        this.myPointer = pointer;
        this.myProperties = new HashMap<String, JsonSchemaObjectImpl>();
    }

    public JsonSchemaObjectImpl(@NotNull String pointer) {
        if (pointer == null) {
            JsonSchemaObjectImpl.$$$reportNull$$$0(6);
        }
        this(null, pointer);
    }

    public void completeInitialization(JsonValueAdapter jsonObject) {
        if (this.myIf != null) {
            this.myIfThenElse = new ArrayList<IfThenElse>();
            this.myIfThenElse.add(new IfThenElse(this.myIf, this.myThen, this.myElse));
        }
        this.myIdsMap = JsonCachedValues.getOrComputeIdsMap(jsonObject.getDelegate().getContainingFile());
    }

    @Override
    @NotNull
    public String getPointer() {
        String string2 = this.myPointer;
        if (string2 == null) {
            JsonSchemaObjectImpl.$$$reportNull$$$0(7);
        }
        return string2;
    }

    @Override
    @Nullable
    public String getFileUrl() {
        return this.myFileUrl;
    }

    @Override
    @Nullable
    public VirtualFile getRawFile() {
        return this.myRawFile;
    }

    public void setLanguageInjection(@Nullable String injection) {
        this.myLanguageInjection = injection;
    }

    public void setLanguageInjectionPrefix(@Nullable String prefix) {
        this.myLanguageInjectionPrefix = prefix;
    }

    public void setLanguageInjectionPostfix(@Nullable String postfix) {
        this.myLanguageInjectionPostfix = postfix;
    }

    @Override
    @Nullable
    public String getLanguageInjection() {
        return this.myLanguageInjection;
    }

    @Override
    @Nullable
    public String getLanguageInjectionPrefix() {
        return this.myLanguageInjectionPrefix;
    }

    @Override
    @Nullable
    public String getLanguageInjectionPostfix() {
        return this.myLanguageInjectionPostfix;
    }

    @Nullable
    public static JsonSchemaType getSubtypeOfBoth(@NotNull JsonSchemaType selfType, @NotNull JsonSchemaType otherType) {
        if (selfType == null) {
            JsonSchemaObjectImpl.$$$reportNull$$$0(8);
        }
        if (otherType == null) {
            JsonSchemaObjectImpl.$$$reportNull$$$0(9);
        }
        if (otherType == JsonSchemaType._any) {
            return selfType;
        }
        if (selfType == JsonSchemaType._any) {
            return otherType;
        }
        return switch (selfType) {
            case JsonSchemaType._string -> {
                if (otherType == JsonSchemaType._string || otherType == JsonSchemaType._string_number) {
                    yield JsonSchemaType._string;
                }
                yield null;
            }
            case JsonSchemaType._number -> {
                if (otherType == JsonSchemaType._integer) {
                    yield JsonSchemaType._integer;
                }
                if (otherType == JsonSchemaType._number || otherType == JsonSchemaType._string_number) {
                    yield JsonSchemaType._number;
                }
                yield null;
            }
            case JsonSchemaType._integer -> {
                if (otherType == JsonSchemaType._number || otherType == JsonSchemaType._string_number || otherType == JsonSchemaType._integer) {
                    yield JsonSchemaType._integer;
                }
                yield null;
            }
            case JsonSchemaType._object -> {
                if (otherType == JsonSchemaType._object) {
                    yield JsonSchemaType._object;
                }
                yield null;
            }
            case JsonSchemaType._array -> {
                if (otherType == JsonSchemaType._array) {
                    yield JsonSchemaType._array;
                }
                yield null;
            }
            case JsonSchemaType._boolean -> {
                if (otherType == JsonSchemaType._boolean) {
                    yield JsonSchemaType._boolean;
                }
                yield null;
            }
            case JsonSchemaType._null -> {
                if (otherType == JsonSchemaType._null) {
                    yield JsonSchemaType._null;
                }
                yield null;
            }
            case JsonSchemaType._string_number -> {
                if (otherType == JsonSchemaType._integer || otherType == JsonSchemaType._number || otherType == JsonSchemaType._string || otherType == JsonSchemaType._string_number) {
                    yield otherType;
                }
                yield null;
            }
            default -> otherType;
        };
    }

    @Override
    @Nullable
    public JsonSchemaType mergeTypes(@Nullable JsonSchemaType selfType, @Nullable JsonSchemaType otherType, @Nullable Set<JsonSchemaType> otherTypeVariants) {
        if (selfType == null) {
            return otherType;
        }
        if (otherType == null) {
            if (otherTypeVariants != null && !otherTypeVariants.isEmpty()) {
                EnumSet<JsonSchemaType> filteredVariants = EnumSet.noneOf(JsonSchemaType.class);
                for (JsonSchemaType variant : otherTypeVariants) {
                    JsonSchemaType subtype = JsonSchemaObjectImpl.getSubtypeOfBoth(selfType, variant);
                    if (subtype == null) continue;
                    filteredVariants.add(subtype);
                }
                if (filteredVariants.size() == 0) {
                    this.myIsValidByExclusion = false;
                    return selfType;
                }
                if (filteredVariants.size() == 1) {
                    return (JsonSchemaType)((Object)filteredVariants.iterator().next());
                }
                return null;
            }
            return selfType;
        }
        JsonSchemaType subtypeOfBoth = JsonSchemaObjectImpl.getSubtypeOfBoth(selfType, otherType);
        if (subtypeOfBoth == null) {
            this.myIsValidByExclusion = false;
            return otherType;
        }
        return subtypeOfBoth;
    }

    @Override
    public Set<JsonSchemaType> mergeTypeVariantSets(@Nullable Set<JsonSchemaType> self, @Nullable Set<JsonSchemaType> other) {
        if (self == null) {
            return other;
        }
        if (other == null) {
            return self;
        }
        EnumSet<JsonSchemaType> resultSet = EnumSet.noneOf(JsonSchemaType.class);
        for (JsonSchemaType type2 : self) {
            JsonSchemaType merged = this.mergeTypes(type2, null, other);
            if (merged == null) continue;
            resultSet.add(merged);
        }
        if (resultSet.isEmpty()) {
            this.myIsValidByExclusion = false;
            return other;
        }
        return resultSet;
    }

    @Override
    public void mergeValues(@NotNull JsonSchemaObject otherBase) {
        if (otherBase == null) {
            JsonSchemaObjectImpl.$$$reportNull$$$0(10);
        }
        JsonSchemaObjectImpl other = (JsonSchemaObjectImpl)otherBase;
        JsonSchemaObjectImpl.mergeProperties(this, other);
        this.myDefinitionsMap = JsonSchemaObjectImpl.copyMap(this.myDefinitionsMap, other.getDefinitionsMap());
        Map<String, JsonSchemaObject> map = JsonSchemaObjectImpl.copyMap(this.myPatternProperties == null ? null : this.myPatternProperties.mySchemasMap, other.myPatternProperties == null ? null : other.myPatternProperties.mySchemasMap);
        PatternProperties patternProperties = this.myPatternProperties = map == null ? null : new PatternProperties(map);
        if (!StringUtil.isEmptyOrSpaces((String)other.myTitle)) {
            this.myTitle = other.myTitle;
        }
        if (!StringUtil.isEmptyOrSpaces((String)other.myDescription)) {
            this.myDescription = other.myDescription;
        }
        if (!StringUtil.isEmptyOrSpaces((String)other.myHtmlDescription)) {
            this.myHtmlDescription = other.myHtmlDescription;
        }
        if (!StringUtil.isEmptyOrSpaces((String)other.myDeprecationMessage)) {
            this.myDeprecationMessage = other.myDeprecationMessage;
        }
        this.myType = this.mergeTypes(this.myType, other.myType, other.myTypeVariants);
        if (other.myDefault != null) {
            this.myDefault = other.myDefault;
        }
        if (other.myExample != null) {
            this.myExample = other.myExample;
        }
        if (other.myRef != null) {
            this.myRef = other.myRef;
        }
        if (other.myFormat != null) {
            this.myFormat = other.myFormat;
        }
        this.myTypeVariants = this.mergeTypeVariantSets(this.myTypeVariants, other.myTypeVariants);
        if (other.myMultipleOf != null) {
            this.myMultipleOf = other.myMultipleOf;
        }
        if (other.myMaximum != null) {
            this.myMaximum = other.myMaximum;
        }
        if (other.myExclusiveMaximumNumber != null) {
            this.myExclusiveMaximumNumber = other.myExclusiveMaximumNumber;
        }
        this.myExclusiveMaximum |= other.myExclusiveMaximum;
        if (other.myMinimum != null) {
            this.myMinimum = other.myMinimum;
        }
        if (other.myExclusiveMinimumNumber != null) {
            this.myExclusiveMinimumNumber = other.myExclusiveMinimumNumber;
        }
        this.myExclusiveMinimum |= other.myExclusiveMinimum;
        if (other.myMaxLength != null) {
            this.myMaxLength = other.myMaxLength;
        }
        if (other.myMinLength != null) {
            this.myMinLength = other.myMinLength;
        }
        if (other.myPattern != null) {
            this.myPattern = other.myPattern;
        }
        if (other.myAdditionalPropertiesAllowed != null) {
            this.myAdditionalPropertiesAllowed = other.myAdditionalPropertiesAllowed;
            if (other.myAdditionalPropertiesAllowed == Boolean.FALSE) {
                this.addAdditionalPropsNotAllowedFor(other.myFileUrl, other.myPointer);
            }
        }
        if (other.myAdditionalPropertiesSchema != null) {
            this.myAdditionalPropertiesSchema = other.myAdditionalPropertiesSchema;
        }
        if (other.myPropertyNamesSchema != null) {
            this.myPropertyNamesSchema = other.myPropertyNamesSchema;
        }
        if (other.myAdditionalItemsAllowed != null) {
            this.myAdditionalItemsAllowed = other.myAdditionalItemsAllowed;
        }
        if (other.myAdditionalItemsSchema != null) {
            this.myAdditionalItemsSchema = other.myAdditionalItemsSchema;
        }
        if (other.myItemsSchema != null) {
            this.myItemsSchema = other.myItemsSchema;
        }
        if (other.myContainsSchema != null) {
            this.myContainsSchema = other.myContainsSchema;
        }
        this.myItemsSchemaList = JsonSchemaObjectImpl.copyList(this.myItemsSchemaList, other.myItemsSchemaList);
        if (other.myMaxItems != null) {
            this.myMaxItems = other.myMaxItems;
        }
        if (other.myMinItems != null) {
            this.myMinItems = other.myMinItems;
        }
        if (other.myUniqueItems != null) {
            this.myUniqueItems = other.myUniqueItems;
        }
        if (other.myMaxProperties != null) {
            this.myMaxProperties = other.myMaxProperties;
        }
        if (other.myMinProperties != null) {
            this.myMinProperties = other.myMinProperties;
        }
        if (this.myRequired != null && other.myRequired != null) {
            HashSet<String> set = new HashSet<String>(this.myRequired.size() + other.myRequired.size());
            set.addAll(this.myRequired);
            set.addAll(other.myRequired);
            this.myRequired = set;
        } else if (other.myRequired != null) {
            this.myRequired = other.myRequired;
        }
        this.myPropertyDependencies = JsonSchemaObjectImpl.copyMap(this.myPropertyDependencies, other.myPropertyDependencies);
        this.mySchemaDependencies = JsonSchemaObjectImpl.copyMap(this.mySchemaDependencies, other.mySchemaDependencies);
        this.myEnumMetadata = JsonSchemaObjectImpl.copyMap(this.myEnumMetadata, other.myEnumMetadata);
        if (other.myEnum != null) {
            this.myEnum = other.myEnum;
        }
        this.myAllOf = JsonSchemaObjectImpl.copyList(this.myAllOf, other.myAllOf);
        this.myAnyOf = JsonSchemaObjectImpl.copyList(this.myAnyOf, other.myAnyOf);
        this.myOneOf = JsonSchemaObjectImpl.copyList(this.myOneOf, other.myOneOf);
        if (other.myNot != null) {
            this.myNot = other.myNot;
        }
        if (other.myIfThenElse != null) {
            this.myIfThenElse = this.myIfThenElse == null ? other.myIfThenElse : ContainerUtil.concat(this.myIfThenElse, other.myIfThenElse);
        }
        this.myShouldValidateAgainstJSType |= other.myShouldValidateAgainstJSType;
        if (this.myLanguageInjection == null) {
            this.myLanguageInjection = other.myLanguageInjection;
        }
        this.myForceCaseInsensitive = this.myForceCaseInsensitive || other.myForceCaseInsensitive;
    }

    public static void mergeProperties(@NotNull JsonSchemaObjectImpl thisObject, @NotNull JsonSchemaObject otherObject) {
        if (thisObject == null) {
            JsonSchemaObjectImpl.$$$reportNull$$$0(11);
        }
        if (otherObject == null) {
            JsonSchemaObjectImpl.$$$reportNull$$$0(12);
        }
        for (Map.Entry<String, ? extends JsonSchemaObject> prop : otherObject.getProperties().entrySet()) {
            String key2 = prop.getKey();
            JsonSchemaObject otherProp = prop.getValue();
            if (!(otherProp instanceof JsonSchemaObjectImpl)) continue;
            JsonSchemaObjectImpl impl = (JsonSchemaObjectImpl)otherProp;
            if (!thisObject.myProperties.containsKey(key2)) {
                thisObject.myProperties.put(key2, impl);
                continue;
            }
            JsonSchemaObjectImpl existingProp = thisObject.myProperties.get(key2);
            thisObject.myProperties.put(key2, JsonSchemaObjectImpl.merge(existingProp, impl, (JsonSchemaObjectImpl)otherProp));
        }
    }

    public void setShouldValidateAgainstJSType(boolean value) {
        this.myShouldValidateAgainstJSType = value;
    }

    @Override
    public boolean isShouldValidateAgainstJSType() {
        return this.myShouldValidateAgainstJSType;
    }

    @Nullable
    public static <T> List<T> copyList(@Nullable List<T> target, @Nullable List<T> source2) {
        if (source2 == null || source2.isEmpty()) {
            return target;
        }
        if (target == null) {
            target = new ArrayList<T>(source2.size());
        }
        target.addAll(source2);
        return target;
    }

    @Nullable
    public static <K, V> Map<K, V> copyMap(@Nullable Map<K, V> target, @Nullable Map<K, V> source2) {
        if (source2 == null || source2.isEmpty()) {
            return target;
        }
        if (target == null) {
            target = new HashMap(source2.size());
        }
        target.putAll(source2);
        return target;
    }

    @Nullable
    public Map<String, JsonSchemaObjectImpl> getDefinitionsMap() {
        return this.myDefinitionsMap;
    }

    public void setDefinitionsMap(@NotNull Map<String, JsonSchemaObjectImpl> definitionsMap) {
        if (definitionsMap == null) {
            JsonSchemaObjectImpl.$$$reportNull$$$0(13);
        }
        this.myDefinitionsMap = definitionsMap;
    }

    @NotNull
    public Map<String, JsonSchemaObjectImpl> getProperties() {
        Map<String, JsonSchemaObjectImpl> map = this.myProperties;
        if (map == null) {
            JsonSchemaObjectImpl.$$$reportNull$$$0(14);
        }
        return map;
    }

    public void setProperties(@NotNull Map<String, JsonSchemaObjectImpl> properties2) {
        if (properties2 == null) {
            JsonSchemaObjectImpl.$$$reportNull$$$0(15);
        }
        this.myProperties = properties2;
    }

    @Override
    public boolean hasPatternProperties() {
        return this.myPatternProperties != null;
    }

    public void setPatternProperties(@NotNull Map<String, JsonSchemaObjectImpl> patternProperties) {
        if (patternProperties == null) {
            JsonSchemaObjectImpl.$$$reportNull$$$0(16);
        }
        this.myPatternProperties = new PatternProperties(patternProperties);
    }

    @Nullable
    public PatternProperties getPatternProperties() {
        return this.myPatternProperties;
    }

    @Override
    @Nullable
    public JsonSchemaType getType() {
        return this.myType;
    }

    public void setType(@Nullable JsonSchemaType type2) {
        this.myType = type2;
    }

    @Override
    @Nullable
    public Number getMultipleOf() {
        return this.myMultipleOf;
    }

    public void setMultipleOf(@Nullable Number multipleOf) {
        this.myMultipleOf = multipleOf;
    }

    @Override
    @Nullable
    public Number getMaximum() {
        return this.myMaximum;
    }

    public void setMaximum(@Nullable Number maximum) {
        this.myMaximum = maximum;
    }

    @Override
    public boolean isExclusiveMaximum() {
        return this.myExclusiveMaximum;
    }

    @Override
    @Nullable
    public Number getExclusiveMaximumNumber() {
        return this.myExclusiveMaximumNumber;
    }

    public void setExclusiveMaximumNumber(@Nullable Number exclusiveMaximumNumber) {
        this.myExclusiveMaximumNumber = exclusiveMaximumNumber;
    }

    @Override
    @Nullable
    public Number getExclusiveMinimumNumber() {
        return this.myExclusiveMinimumNumber;
    }

    public void setExclusiveMinimumNumber(@Nullable Number exclusiveMinimumNumber) {
        this.myExclusiveMinimumNumber = exclusiveMinimumNumber;
    }

    public void setExclusiveMaximum(boolean exclusiveMaximum) {
        this.myExclusiveMaximum = exclusiveMaximum;
    }

    @Override
    @Nullable
    public Number getMinimum() {
        return this.myMinimum;
    }

    public void setMinimum(@Nullable Number minimum) {
        this.myMinimum = minimum;
    }

    @Override
    public boolean isExclusiveMinimum() {
        return this.myExclusiveMinimum;
    }

    public void setExclusiveMinimum(boolean exclusiveMinimum) {
        this.myExclusiveMinimum = exclusiveMinimum;
    }

    @Override
    @Nullable
    public Integer getMaxLength() {
        return this.myMaxLength;
    }

    public void setMaxLength(@Nullable Integer maxLength) {
        this.myMaxLength = maxLength;
    }

    @Override
    @Nullable
    public Integer getMinLength() {
        return this.myMinLength;
    }

    public void setMinLength(@Nullable Integer minLength) {
        this.myMinLength = minLength;
    }

    @Override
    @Nullable
    public String getPattern() {
        return this.myPattern == null ? null : this.myPattern.getPattern();
    }

    public void setPattern(@Nullable String pattern2) {
        this.myPattern = pattern2 == null ? null : new PropertyNamePattern(pattern2);
    }

    @Override
    public boolean getAdditionalPropertiesAllowed() {
        return this.myAdditionalPropertiesAllowed == null || this.myAdditionalPropertiesAllowed != false;
    }

    public void setAdditionalPropertiesAllowed(@Nullable Boolean additionalPropertiesAllowed) {
        this.myAdditionalPropertiesAllowed = additionalPropertiesAllowed;
        if (additionalPropertiesAllowed == Boolean.FALSE) {
            this.addAdditionalPropsNotAllowedFor(this.myFileUrl, this.myPointer);
        }
    }

    @Override
    public boolean hasOwnExtraPropertyProhibition() {
        return this.getAdditionalPropertiesAllowed() == Boolean.FALSE.booleanValue() && (this.myAdditionalPropertiesNotAllowedFor == null || this.myAdditionalPropertiesNotAllowedFor.contains(this.myFileUrl + this.myPointer));
    }

    public void addAdditionalPropsNotAllowedFor(String url, String pointer) {
        HashSet<String> newSet = this.myAdditionalPropertiesNotAllowedFor == null ? new HashSet<String>() : new HashSet<String>(this.myAdditionalPropertiesNotAllowedFor);
        newSet.add(url + pointer);
        this.myAdditionalPropertiesNotAllowedFor = newSet;
    }

    @Override
    @Nullable
    public JsonSchemaObjectImpl getPropertyNamesSchema() {
        return this.myPropertyNamesSchema;
    }

    public void setPropertyNamesSchema(@Nullable JsonSchemaObjectImpl propertyNamesSchema) {
        this.myPropertyNamesSchema = propertyNamesSchema;
    }

    @Override
    @Nullable
    public JsonSchemaObject getUnevaluatedItemsSchema() {
        return null;
    }

    @Override
    @Nullable
    public JsonSchemaObjectImpl getAdditionalPropertiesSchema() {
        return this.myAdditionalPropertiesSchema;
    }

    @Override
    @Nullable
    public JsonSchemaObject getUnevaluatedPropertiesSchema() {
        return null;
    }

    public void setAdditionalPropertiesSchema(@Nullable JsonSchemaObjectImpl additionalPropertiesSchema) {
        this.myAdditionalPropertiesSchema = additionalPropertiesSchema;
    }

    @Override
    @Nullable
    public Boolean getAdditionalItemsAllowed() {
        return this.myAdditionalItemsAllowed == null || this.myAdditionalItemsAllowed != false;
    }

    public void setAdditionalItemsAllowed(@Nullable Boolean additionalItemsAllowed) {
        this.myAdditionalItemsAllowed = additionalItemsAllowed;
    }

    @Override
    @Nullable
    public String getDeprecationMessage() {
        return this.myDeprecationMessage;
    }

    public void setDeprecationMessage(@Nullable String deprecationMessage) {
        this.myDeprecationMessage = deprecationMessage;
    }

    @Override
    @Nullable
    public JsonSchemaObjectImpl getAdditionalItemsSchema() {
        return this.myAdditionalItemsSchema;
    }

    public void setAdditionalItemsSchema(@Nullable JsonSchemaObjectImpl additionalItemsSchema) {
        this.myAdditionalItemsSchema = additionalItemsSchema;
    }

    @Override
    @Nullable
    public JsonSchemaObjectImpl getItemsSchema() {
        return this.myItemsSchema;
    }

    public void setItemsSchema(@Nullable JsonSchemaObjectImpl itemsSchema) {
        this.myItemsSchema = itemsSchema;
    }

    @Override
    @Nullable
    public JsonSchemaObjectImpl getContainsSchema() {
        return this.myContainsSchema;
    }

    public void setContainsSchema(@Nullable JsonSchemaObjectImpl containsSchema) {
        this.myContainsSchema = containsSchema;
    }

    @Nullable
    public List<JsonSchemaObjectImpl> getItemsSchemaList() {
        return this.myItemsSchemaList;
    }

    public void setItemsSchemaList(@Nullable List<JsonSchemaObjectImpl> itemsSchemaList) {
        this.myItemsSchemaList = itemsSchemaList;
    }

    @Override
    @Nullable
    public Integer getMaxItems() {
        return this.myMaxItems;
    }

    public void setMaxItems(@Nullable Integer maxItems) {
        this.myMaxItems = maxItems;
    }

    @Override
    @Nullable
    public Integer getMinItems() {
        return this.myMinItems;
    }

    public void setMinItems(@Nullable Integer minItems) {
        this.myMinItems = minItems;
    }

    @Override
    public boolean isUniqueItems() {
        return Boolean.TRUE.equals(this.myUniqueItems);
    }

    public void setUniqueItems(boolean uniqueItems) {
        this.myUniqueItems = uniqueItems;
    }

    @Override
    @Nullable
    public Integer getMaxProperties() {
        return this.myMaxProperties;
    }

    public void setMaxProperties(@Nullable Integer maxProperties) {
        this.myMaxProperties = maxProperties;
    }

    @Override
    @Nullable
    public Integer getMinProperties() {
        return this.myMinProperties;
    }

    public void setMinProperties(@Nullable Integer minProperties) {
        this.myMinProperties = minProperties;
    }

    @Override
    @Nullable
    public Set<String> getRequired() {
        return this.myRequired;
    }

    public void setRequired(@Nullable Set<String> required2) {
        this.myRequired = required2;
    }

    @Override
    @Nullable
    public Map<String, List<String>> getPropertyDependencies() {
        return this.myPropertyDependencies;
    }

    public void setPropertyDependencies(@Nullable Map<String, List<String>> propertyDependencies) {
        this.myPropertyDependencies = propertyDependencies;
    }

    @Nullable
    public Map<String, JsonSchemaObjectImpl> getSchemaDependencies() {
        return this.mySchemaDependencies;
    }

    public void setSchemaDependencies(@Nullable Map<String, JsonSchemaObjectImpl> schemaDependencies) {
        this.mySchemaDependencies = schemaDependencies;
    }

    @Override
    @Nullable
    public Map<String, Map<String, String>> getEnumMetadata() {
        return this.myEnumMetadata;
    }

    public void setEnumMetadata(@Nullable Map<String, Map<String, String>> enumMetadata) {
        this.myEnumMetadata = enumMetadata;
    }

    @Override
    @Nullable
    public List<Object> getEnum() {
        return this.myEnum;
    }

    public void setEnum(@Nullable List<Object> anEnum) {
        this.myEnum = anEnum;
    }

    @Nullable
    public List<JsonSchemaObjectImpl> getAllOf() {
        return this.myAllOf;
    }

    public void setAllOf(@Nullable List<JsonSchemaObjectImpl> allOf2) {
        this.myAllOf = allOf2;
    }

    @Nullable
    public List<JsonSchemaObjectImpl> getAnyOf() {
        return this.myAnyOf;
    }

    public void setAnyOf(@Nullable List<JsonSchemaObjectImpl> anyOf) {
        this.myAnyOf = anyOf;
    }

    @Nullable
    public List<JsonSchemaObjectImpl> getOneOf() {
        return this.myOneOf;
    }

    public void setOneOf(@Nullable List<JsonSchemaObjectImpl> oneOf) {
        this.myOneOf = oneOf;
    }

    @Override
    @Nullable
    public JsonSchemaObjectImpl getNot() {
        return this.myNot;
    }

    public void setNot(@Nullable JsonSchemaObjectImpl not) {
        this.myNot = not;
    }

    @Override
    @Nullable
    public List<IfThenElse> getIfThenElse() {
        return this.myIfThenElse;
    }

    public void setIfThenElse(@Nullable List<IfThenElse> ifThenElse) {
        this.myIfThenElse = ifThenElse;
    }

    public void setIf(@Nullable JsonSchemaObjectImpl anIf) {
        this.myIf = anIf;
    }

    public void setThen(@Nullable JsonSchemaObjectImpl then) {
        this.myThen = then;
    }

    public void setElse(@Nullable JsonSchemaObjectImpl anElse) {
        this.myElse = anElse;
    }

    @Override
    @Nullable
    public Set<JsonSchemaType> getTypeVariants() {
        return this.myTypeVariants;
    }

    public void setTypeVariants(@Nullable Set<JsonSchemaType> typeVariants) {
        this.myTypeVariants = typeVariants;
    }

    @Override
    @Nullable
    public String getRef() {
        return this.myRef;
    }

    public void setRef(@Nullable String ref) {
        this.myRef = ref;
    }

    public void setRefRecursive(boolean isRecursive) {
        this.myRefIsRecursive = isRecursive;
    }

    @Override
    public boolean isRefRecursive() {
        return this.myRefIsRecursive;
    }

    public void setRecursiveAnchor(boolean isRecursive) {
        this.myIsRecursiveAnchor = isRecursive;
    }

    @Override
    public boolean isRecursiveAnchor() {
        return this.myIsRecursiveAnchor;
    }

    public void setBackReference(JsonSchemaObjectImpl object) {
        this.myBackRef = object;
    }

    @Override
    public JsonSchemaObjectImpl getBackReference() {
        return this.myBackRef;
    }

    @Override
    @Nullable
    public Object getDefault() {
        if (JsonSchemaType._integer.equals((Object)this.myType)) {
            return this.myDefault instanceof Number ? Integer.valueOf(((Number)this.myDefault).intValue()) : this.myDefault;
        }
        return this.myDefault;
    }

    public void setDefault(@Nullable Object aDefault) {
        this.myDefault = aDefault;
    }

    @Override
    @Nullable
    public Map<String, Object> getExample() {
        return this.myExample;
    }

    @Override
    @Nullable
    public JsonSchemaObject getExampleByName(@NotNull String name) {
        if (name == null) {
            JsonSchemaObjectImpl.$$$reportNull$$$0(17);
        }
        return null;
    }

    public void setExample(@Nullable Map<String, Object> example) {
        this.myExample = example;
    }

    @Override
    @Nullable
    public String getFormat() {
        return this.myFormat;
    }

    public void setFormat(@Nullable String format) {
        this.myFormat = format;
    }

    @Override
    @Nullable
    public String getId() {
        return this.myId;
    }

    public void setId(@Nullable String id) {
        this.myId = id == null ? null : JsonPointerUtil.normalizeId(id);
    }

    @Override
    @Nullable
    public String getSchema() {
        return this.mySchema;
    }

    public void setSchema(@Nullable String schema) {
        this.mySchema = schema;
    }

    @Override
    @Nullable
    public String getDescription() {
        return this.myDescription;
    }

    public void setDescription(@NotNull String description2) {
        if (description2 == null) {
            JsonSchemaObjectImpl.$$$reportNull$$$0(18);
        }
        this.myDescription = JsonSchemaObjectImpl.unescapeJsonString(description2);
    }

    @Override
    @Nullable
    public String getHtmlDescription() {
        return this.myHtmlDescription;
    }

    public void setHtmlDescription(@NotNull String htmlDescription) {
        if (htmlDescription == null) {
            JsonSchemaObjectImpl.$$$reportNull$$$0(19);
        }
        this.myHtmlDescription = JsonSchemaObjectImpl.unescapeJsonString(htmlDescription);
    }

    @Override
    @Nullable
    public String getTitle() {
        return this.myTitle;
    }

    public void setTitle(@NotNull String title) {
        if (title == null) {
            JsonSchemaObjectImpl.$$$reportNull$$$0(20);
        }
        this.myTitle = JsonSchemaObjectImpl.unescapeJsonString(title);
    }

    public static String unescapeJsonString(@NotNull String text2) {
        if (text2 == null) {
            JsonSchemaObjectImpl.$$$reportNull$$$0(21);
        }
        return StringUtil.unescapeStringCharacters((String)text2);
    }

    @Override
    @Nullable
    public JsonSchemaObjectImpl getMatchingPatternPropertySchema(@NotNull String name) {
        if (name == null) {
            JsonSchemaObjectImpl.$$$reportNull$$$0(22);
        }
        if (this.myPatternProperties == null) {
            return null;
        }
        return (JsonSchemaObjectImpl)this.myPatternProperties.getPatternPropertySchema(name);
    }

    @Override
    @NotNull
    public Iterator<String> getSchemaDependencyNames() {
        Map<String, JsonSchemaObjectImpl> dependencies = this.getSchemaDependencies();
        Iterator<String> iterator = dependencies == null ? Collections.emptyIterator() : dependencies.keySet().iterator();
        if (iterator == null) {
            JsonSchemaObjectImpl.$$$reportNull$$$0(23);
        }
        return iterator;
    }

    @Override
    @Nullable
    public JsonSchemaObject getSchemaDependencyByName(@NotNull String name) {
        Map<String, JsonSchemaObjectImpl> dependencies;
        if (name == null) {
            JsonSchemaObjectImpl.$$$reportNull$$$0(24);
        }
        return (dependencies = this.getSchemaDependencies()) == null ? null : (JsonSchemaObject)dependencies.get(name);
    }

    @Override
    @Nullable
    public JsonSchemaObject getDefinitionByName(@NotNull String name) {
        Map<String, JsonSchemaObjectImpl> map;
        if (name == null) {
            JsonSchemaObjectImpl.$$$reportNull$$$0(25);
        }
        return (map = this.getDefinitionsMap()) == null ? null : (JsonSchemaObject)map.get(name);
    }

    @Override
    @NotNull
    public Iterator<String> getDefinitionNames() {
        Map<String, JsonSchemaObjectImpl> map = this.getDefinitionsMap();
        Iterator<String> iterator = map == null ? Collections.emptyIterator() : map.keySet().iterator();
        if (iterator == null) {
            JsonSchemaObjectImpl.$$$reportNull$$$0(26);
        }
        return iterator;
    }

    @Override
    @NotNull
    public Iterator<String> getPropertyNames() {
        Iterator<String> iterator = this.getProperties().keySet().iterator();
        if (iterator == null) {
            JsonSchemaObjectImpl.$$$reportNull$$$0(27);
        }
        return iterator;
    }

    @Override
    @Nullable
    public JsonSchemaObject getPropertyByName(@NotNull String name) {
        if (name == null) {
            JsonSchemaObjectImpl.$$$reportNull$$$0(28);
        }
        return this.getProperties().get(name);
    }

    @Override
    public boolean checkByPattern(@NotNull String value) {
        if (value == null) {
            JsonSchemaObjectImpl.$$$reportNull$$$0(29);
        }
        return this.myPattern != null && this.myPattern.checkByPattern(value);
    }

    @Override
    @Nullable
    public String getPatternError() {
        return this.myPattern == null ? null : this.myPattern.getPatternError();
    }

    @Override
    @Nullable
    public JsonSchemaObject findRelativeDefinition(@NotNull String ref) {
        if (ref == null) {
            JsonSchemaObjectImpl.$$$reportNull$$$0(30);
        }
        return JsonSchemaObjectReadingUtils.findRelativeDefinition(this, ref);
    }

    @Override
    @Nullable
    public JsonSchemaObject resolveRefSchema(@NotNull JsonSchemaService service) {
        if (service == null) {
            JsonSchemaObjectImpl.$$$reportNull$$$0(31);
        }
        return JsonSchemaObjectReadingUtils.resolveRefSchema(this, service);
    }

    public ConcurrentMap<String, JsonSchemaObject> getComputedRefsStorage(@NotNull Project project2) {
        if (project2 == null) {
            JsonSchemaObjectImpl.$$$reportNull$$$0(32);
        }
        return (ConcurrentMap)CachedValuesManager.getManager((Project)project2).getCachedValue((UserDataHolder)this.myUserDataHolder, () -> CachedValueProvider.Result.create(new ConcurrentHashMap(), (Object[])new Object[]{JsonDependencyModificationTracker.forProject(project2)}));
    }

    @NotNull
    public static JsonSchemaObjectImpl merge(@NotNull JsonSchemaObjectImpl base, @NotNull JsonSchemaObjectImpl other, @NotNull JsonSchemaObjectImpl pointTo) {
        if (base == null) {
            JsonSchemaObjectImpl.$$$reportNull$$$0(33);
        }
        if (other == null) {
            JsonSchemaObjectImpl.$$$reportNull$$$0(34);
        }
        if (pointTo == null) {
            JsonSchemaObjectImpl.$$$reportNull$$$0(35);
        }
        JsonSchemaObjectImpl object = new JsonSchemaObjectImpl(pointTo.myRawFile, pointTo.myFileUrl, pointTo.getPointer());
        object.mergeValues(other);
        object.mergeValues(base);
        object.setRef(other.getRef());
        JsonSchemaObjectImpl jsonSchemaObjectImpl = object;
        if (jsonSchemaObjectImpl == null) {
            JsonSchemaObjectImpl.$$$reportNull$$$0(36);
        }
        return jsonSchemaObjectImpl;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 14, 23, 26, 27, 36 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childNodeName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namesToSkip";
                break;
            }
            case 3: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pointer";
                break;
            }
            case 7: 
            case 14: 
            case 23: 
            case 26: 
            case 27: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/jsonSchema/impl/JsonSchemaObjectImpl";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selfType";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "otherType";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "otherBase";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thisObject";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "otherObject";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "definitionsMap";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = PROPERTIES;
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patternProperties";
                break;
            }
            case 17: 
            case 22: 
            case 24: 
            case 25: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "htmlDescription";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "service";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "base";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pointTo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/jsonSchema/impl/JsonSchemaObjectImpl";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getPointer";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getProperties";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getSchemaDependencyNames";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefinitionNames";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropertyNames";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "merge";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "readChildNodeValue";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "hasChildNode";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "hasChildFieldsExcept";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getValidations";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: 
            case 14: 
            case 23: 
            case 26: 
            case 27: 
            case 36: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getSubtypeOfBoth";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "mergeValues";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "mergeProperties";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "setDefinitionsMap";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "setProperties";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "setPatternProperties";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getExampleByName";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "setDescription";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "setHtmlDescription";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "setTitle";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "unescapeJsonString";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getMatchingPatternPropertySchema";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getSchemaDependencyByName";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getDefinitionByName";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyByName";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "checkByPattern";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "findRelativeDefinition";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "resolveRefSchema";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getComputedRefsStorage";
                break;
            }
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "merge";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 7, 14, 23, 26, 27, 36 -> new IllegalStateException(string2);
        };
    }
}

