/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.formatter.xml;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.DelegatingFormattingModelBuilder;
import com.intellij.formatting.FormattingModelBuilder;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.formatting.WrapType;
import com.intellij.ide.highlighter.HtmlFileType;
import com.intellij.ide.highlighter.XHtmlFileType;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageFormatting;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.TokenType;
import com.intellij.psi.formatter.FormatterUtil;
import com.intellij.psi.formatter.WhiteSpaceFormattingStrategy;
import com.intellij.psi.formatter.WhiteSpaceFormattingStrategyFactory;
import com.intellij.psi.formatter.common.AbstractBlock;
import com.intellij.psi.formatter.xml.XmlBlock;
import com.intellij.psi.formatter.xml.XmlFormattingPolicy;
import com.intellij.psi.formatter.xml.XmlInjectedLanguageBlockBuilder;
import com.intellij.psi.formatter.xml.XmlTagBlock;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.templateLanguages.TemplateLanguageFileViewProvider;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.xml.IXmlAttributeElementType;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlElementType;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.containers.JBIterable;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractXmlBlock
extends AbstractBlock {
    protected XmlFormattingPolicy myXmlFormattingPolicy;
    protected final XmlInjectedLanguageBlockBuilder myInjectedBlockBuilder;
    private final boolean myPreserveSpace;

    protected AbstractXmlBlock(@NotNull ASTNode node, @Nullable Wrap wrap2, @Nullable Alignment alignment, @NotNull XmlFormattingPolicy policy) {
        if (node == null) {
            AbstractXmlBlock.$$$reportNull$$$0(0);
        }
        if (policy == null) {
            AbstractXmlBlock.$$$reportNull$$$0(1);
        }
        this(node, wrap2, alignment, policy, false);
    }

    protected AbstractXmlBlock(@NotNull ASTNode node, @Nullable Wrap wrap2, @Nullable Alignment alignment, @NotNull XmlFormattingPolicy policy, boolean preserveSpace) {
        if (node == null) {
            AbstractXmlBlock.$$$reportNull$$$0(2);
        }
        if (policy == null) {
            AbstractXmlBlock.$$$reportNull$$$0(3);
        }
        super(node, wrap2, alignment);
        this.myXmlFormattingPolicy = policy;
        if (node.getTreeParent() == null) {
            this.myXmlFormattingPolicy.setRootBlock(node, (Block)this);
        }
        this.myInjectedBlockBuilder = new XmlInjectedLanguageBlockBuilder(this.myXmlFormattingPolicy);
        this.myPreserveSpace = AbstractXmlBlock.shouldPreserveSpace(node, preserveSpace);
    }

    private static boolean shouldPreserveSpace(ASTNode node, boolean defaultValue2) {
        XmlTag tag;
        XmlAttribute spaceAttr;
        PsiElement psiElement = node.getPsi();
        if (psiElement instanceof XmlTag && (spaceAttr = (tag = (XmlTag)psiElement).getAttribute("xml:space")) != null) {
            String value = spaceAttr.getValue();
            if ("preserve".equals(value)) {
                return true;
            }
            if ("default".equals(value)) {
                return false;
            }
        }
        return defaultValue2;
    }

    public boolean isPreserveSpace() {
        return this.myPreserveSpace;
    }

    @NotNull
    public static WrapType getWrapType(int type2) {
        if (type2 == 0) {
            WrapType wrapType = WrapType.NONE;
            if (wrapType == null) {
                AbstractXmlBlock.$$$reportNull$$$0(4);
            }
            return wrapType;
        }
        if (type2 == 2) {
            WrapType wrapType = WrapType.ALWAYS;
            if (wrapType == null) {
                AbstractXmlBlock.$$$reportNull$$$0(5);
            }
            return wrapType;
        }
        if (type2 == 1) {
            WrapType wrapType = WrapType.NORMAL;
            if (wrapType == null) {
                AbstractXmlBlock.$$$reportNull$$$0(6);
            }
            return wrapType;
        }
        WrapType wrapType = WrapType.CHOP_DOWN_IF_LONG;
        if (wrapType == null) {
            AbstractXmlBlock.$$$reportNull$$$0(7);
        }
        return wrapType;
    }

    protected boolean isTextNode(IElementType elementType) {
        return elementType == XmlElementType.XML_TEXT || elementType == XmlElementType.HTML_RAW_TEXT;
    }

    @Nullable
    protected Alignment chooseAlignment(@NotNull ASTNode child, @Nullable Alignment attrAlignment, @Nullable Alignment textAlignment) {
        if (child == null) {
            AbstractXmlBlock.$$$reportNull$$$0(8);
        }
        if (this.isTextNode(this.myNode.getElementType())) {
            return this.getAlignment();
        }
        IElementType elementType = child.getElementType();
        if (this.isAttributeElementType(elementType) && this.myXmlFormattingPolicy.getShouldAlignAttributes()) {
            return attrAlignment;
        }
        if (this.isTextNode(elementType) && this.myXmlFormattingPolicy.getShouldAlignText()) {
            return textAlignment;
        }
        return null;
    }

    private Wrap getTagEndWrapping(XmlTag parent) {
        return Wrap.createWrap((WrapType)this.myXmlFormattingPolicy.getWrappingTypeForTagEnd(parent), (boolean)true);
    }

    protected Wrap chooseWrap(ASTNode child, Wrap tagBeginWrap, Wrap attrWrap, Wrap textWrap) {
        if (this.isTextNode(this.myNode.getElementType())) {
            return textWrap;
        }
        IElementType elementType = child.getElementType();
        if (this.isAttributeElementType(elementType)) {
            return attrWrap;
        }
        if (elementType == XmlTokenType.XML_START_TAG_START) {
            return tagBeginWrap;
        }
        if (elementType == XmlTokenType.XML_END_TAG_START) {
            XmlTag tag;
            PsiElement parent = SourceTreeToPsiMap.treeElementToPsi((ASTNode)child.getTreeParent());
            if (parent instanceof XmlTag && this.canWrapTagEnd(tag = (XmlTag)parent)) {
                return this.getTagEndWrapping(tag);
            }
            return null;
        }
        if (this.isTextNode(elementType) || elementType == XmlTokenType.XML_DATA_CHARACTERS) {
            ASTNode previous = FormatterUtil.getPreviousNonWhitespaceSibling((ASTNode)child);
            if (previous == null || !this.isTextNode(previous.getElementType())) {
                return this.myXmlFormattingPolicy.allowWrapBeforeText() ? textWrap : null;
            }
            return textWrap;
        }
        return null;
    }

    protected boolean canWrapTagEnd(XmlTag tag) {
        return AbstractXmlBlock.hasSubTags(tag);
    }

    static boolean hasSubTags(XmlTag tag) {
        for (PsiElement child = tag.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof XmlTag)) continue;
            return true;
        }
        return false;
    }

    protected XmlTag getTag() {
        return AbstractXmlBlock.getTag(this.myNode);
    }

    protected static XmlTag getTag(ASTNode node) {
        PsiElement element = SourceTreeToPsiMap.treeElementToPsi((ASTNode)node);
        if (element instanceof XmlTag) {
            return (XmlTag)element;
        }
        return null;
    }

    protected Wrap createTagBeginWrapping(XmlTag tag) {
        return Wrap.createWrap((WrapType)this.myXmlFormattingPolicy.getWrappingTypeForTagBegin(tag), (boolean)true);
    }

    @Nullable
    protected ASTNode processChild(@NotNull List<Block> result2, @NotNull ASTNode child, @Nullable Wrap wrap2, @Nullable Alignment alignment, @Nullable Indent indent) {
        PsiElement childPsi;
        Language childLanguage;
        Language myLanguage;
        if (result2 == null) {
            AbstractXmlBlock.$$$reportNull$$$0(9);
        }
        if (child == null) {
            AbstractXmlBlock.$$$reportNull$$$0(10);
        }
        if (this.useMyFormatter(myLanguage = this.myNode.getPsi().getLanguage(), childLanguage = (childPsi = child.getPsi()).getLanguage(), childPsi)) {
            XmlTag tag = this.getAnotherTreeTag(child);
            if (tag != null && this.containsTag(tag) && this.doesNotIntersectSubTagsWith(tag)) {
                ASTNode currentChild = this.createAnotherTreeNode(result2, child, tag, indent, wrap2, alignment);
                if (currentChild == null) {
                    return null;
                }
                while (currentChild != null && currentChild.getTreeParent() != this.myNode && currentChild.getTreeParent() != child.getTreeParent()) {
                    if ((currentChild = this.processAllChildrenFrom(result2, currentChild, wrap2, alignment, indent)) != null && (currentChild.getTreeParent() == this.myNode || currentChild.getTreeParent() == child.getTreeParent())) {
                        return currentChild;
                    }
                    if (currentChild == null) continue;
                    currentChild = currentChild.getTreeParent();
                }
                return currentChild;
            }
            this.processSimpleChild(child, indent, result2, wrap2, alignment);
            return child;
        }
        if (!this.isBuildIndentsOnly()) {
            this.myInjectedBlockBuilder.addInjectedLanguageBlockWrapper(result2, child, indent, 0, null);
        }
        return child;
    }

    protected boolean doesNotIntersectSubTagsWith(PsiElement tag) {
        TextRange tagRange = tag.getTextRange();
        for (XmlTag subTag : JBIterable.of((Object[])this.myNode.getPsi().getChildren()).filter(XmlTag.class)) {
            TextRange subTagRange = subTag.getTextRange();
            if (subTagRange.getEndOffset() < tagRange.getStartOffset()) continue;
            if (subTagRange.getStartOffset() > tagRange.getEndOffset()) {
                return true;
            }
            if (tagRange.getStartOffset() > subTagRange.getStartOffset() && tagRange.getEndOffset() < subTagRange.getEndOffset()) {
                return false;
            }
            if (tagRange.getEndOffset() <= subTagRange.getStartOffset() || tagRange.getEndOffset() >= subTagRange.getEndOffset()) continue;
            return false;
        }
        return true;
    }

    protected boolean containsTag(PsiElement tag) {
        ASTNode closingTagStart = XmlChildRole.CLOSING_TAG_START_FINDER.findChild(this.myNode);
        ASTNode startTagStart = XmlChildRole.START_TAG_END_FINDER.findChild(this.myNode);
        if (closingTagStart == null && startTagStart == null) {
            return tag.getTextRange().getEndOffset() <= this.myNode.getTextRange().getEndOffset();
        }
        if (closingTagStart == null) {
            return false;
        }
        return tag.getTextRange().getEndOffset() <= closingTagStart.getTextRange().getEndOffset();
    }

    private ASTNode processAllChildrenFrom(List<Block> result2, @NotNull ASTNode child, Wrap wrap2, Alignment alignment, Indent indent) {
        if (child == null) {
            AbstractXmlBlock.$$$reportNull$$$0(11);
        }
        ASTNode resultNode = child;
        ASTNode currentChild = child.getTreeNext();
        while (currentChild != null && currentChild.getElementType() != XmlTokenType.XML_END_TAG_START) {
            if (!AbstractXmlBlock.containsWhiteSpacesOnly(currentChild)) {
                resultNode = currentChild = this.processChild(result2, currentChild, wrap2, alignment, indent);
            }
            if (currentChild == null) continue;
            currentChild = currentChild.getTreeNext();
        }
        return resultNode;
    }

    protected void processSimpleChild(@NotNull ASTNode child, @Nullable Indent indent, @NotNull List<? super Block> result2, @Nullable Wrap wrap2, @Nullable Alignment alignment) {
        if (child == null) {
            AbstractXmlBlock.$$$reportNull$$$0(12);
        }
        if (result2 == null) {
            AbstractXmlBlock.$$$reportNull$$$0(13);
        }
        if (this.isXmlTag(child)) {
            result2.add((Block)this.createTagBlock(child, indent != null ? indent : Indent.getNoneIndent(), wrap2, alignment));
        } else if (child.getElementType() == XmlElementType.XML_DOCTYPE) {
            result2.add((Block)new XmlBlock(child, wrap2, alignment, this.myXmlFormattingPolicy, indent, null, this.isPreserveSpace()){

                @Override
                protected Wrap getDefaultWrap(ASTNode node) {
                    IElementType type2 = node.getElementType();
                    return type2 == XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN ? Wrap.createWrap((WrapType)1.getWrapType(this.myXmlFormattingPolicy.getAttributesWrap()), (boolean)false) : null;
                }
            });
        } else if (child.getElementType() == XmlTokenType.XML_DATA_CHARACTERS && child.getTreeParent().getElementType() != XmlElementType.XML_CDATA && child.textContains('\n')) {
            result2.add((Block)this.createRawTextChild(child, indent, wrap2, alignment));
        } else {
            result2.add((Block)this.createSimpleChild(child, indent, wrap2, alignment, null));
        }
    }

    @NotNull
    protected XmlBlock createRawTextChild(@NotNull ASTNode child, @Nullable Indent indent, @Nullable Wrap wrap2, @Nullable Alignment alignment) {
        TextRange textRange;
        int textEnd;
        String text2;
        int textStart;
        if (child == null) {
            AbstractXmlBlock.$$$reportNull$$$0(14);
        }
        if ((textStart = StringUtil.skipWhitespaceOrNewLineForward((CharSequence)(text2 = child.getText()), (int)0)) < (textEnd = StringUtil.skipWhitespaceOrNewLineBackward((CharSequence)text2, (int)text2.length()))) {
            textRange = child.getTextRange();
            textRange = new TextRange(textRange.getStartOffset() + textStart, textRange.getStartOffset() + textEnd);
        } else {
            textRange = null;
        }
        return new XmlBlock(child, wrap2, alignment, this.myXmlFormattingPolicy, indent, textRange, this.isPreserveSpace());
    }

    @NotNull
    protected XmlBlock createSimpleChild(@NotNull ASTNode child, @Nullable Indent indent, @Nullable Wrap wrap2, @Nullable Alignment alignment, @Nullable TextRange range) {
        if (child == null) {
            AbstractXmlBlock.$$$reportNull$$$0(15);
        }
        return new XmlBlock(child, wrap2, alignment, this.myXmlFormattingPolicy, indent, range, this.isPreserveSpace());
    }

    protected XmlTagBlock createTagBlock(@NotNull ASTNode child, @Nullable Indent indent, Wrap wrap2, Alignment alignment) {
        if (child == null) {
            AbstractXmlBlock.$$$reportNull$$$0(16);
        }
        return new XmlTagBlock(child, wrap2, alignment, this.myXmlFormattingPolicy, indent != null ? indent : Indent.getNoneIndent(), this.isPreserveSpace());
    }

    @Nullable
    protected XmlTag findXmlTagAt(ASTNode child, int startOffset) {
        return null;
    }

    @Nullable
    protected ASTNode createAnotherTreeNode(List<? super Block> result2, ASTNode child, PsiElement tag, Indent indent, Wrap wrap2, Alignment alignment) {
        return null;
    }

    @Nullable
    protected Block createAnotherTreeTagBlock(PsiElement tag, Indent childIndent) {
        return null;
    }

    protected XmlFormattingPolicy createPolicyFor() {
        return this.myXmlFormattingPolicy;
    }

    @Nullable
    protected XmlTag getAnotherTreeTag(ASTNode child) {
        return null;
    }

    protected boolean isAttributeElementType(IElementType elementType) {
        return elementType instanceof IXmlAttributeElementType;
    }

    protected boolean isXmlTag(ASTNode child) {
        return this.isXmlTag(child.getPsi());
    }

    protected boolean isXmlTag(PsiElement psi) {
        return psi instanceof XmlTag;
    }

    protected boolean useMyFormatter(@NotNull Language myLanguage, @NotNull Language childLanguage, @NotNull PsiElement childPsi) {
        if (myLanguage == null) {
            AbstractXmlBlock.$$$reportNull$$$0(17);
        }
        if (childLanguage == null) {
            AbstractXmlBlock.$$$reportNull$$$0(18);
        }
        if (childPsi == null) {
            AbstractXmlBlock.$$$reportNull$$$0(19);
        }
        if (myLanguage == childLanguage || childLanguage == HtmlFileType.INSTANCE.getLanguage() || childLanguage == XHtmlFileType.INSTANCE.getLanguage() || childLanguage == XmlFileType.INSTANCE.getLanguage()) {
            return true;
        }
        FormattingModelBuilder childFormatter = (FormattingModelBuilder)LanguageFormatting.INSTANCE.forLanguage(childLanguage);
        return childFormatter == null || childFormatter instanceof DelegatingFormattingModelBuilder && ((DelegatingFormattingModelBuilder)childFormatter).dontFormatMyModel(childPsi);
    }

    protected boolean isJspxJavaContainingNode(ASTNode child) {
        return false;
    }

    public abstract boolean insertLineBreakBeforeTag();

    public int getBlankLinesBeforeTag() {
        return this.insertLineBreakBeforeTag() ? 1 : 0;
    }

    public abstract boolean removeLineBreakBeforeTag();

    protected Spacing createDefaultSpace(boolean forceKeepLineBreaks, boolean inText) {
        boolean shouldKeepLineBreaks = this.getShouldKeepLineBreaks(inText, forceKeepLineBreaks);
        return Spacing.createSpacing((int)0, (int)Integer.MAX_VALUE, (int)0, (boolean)shouldKeepLineBreaks, (int)this.myXmlFormattingPolicy.getKeepBlankLines());
    }

    private boolean getShouldKeepLineBreaks(boolean inText, boolean forceKeepLineBreaks) {
        if (forceKeepLineBreaks) {
            return true;
        }
        if (inText && this.myXmlFormattingPolicy.getShouldKeepLineBreaksInText()) {
            return true;
        }
        return !inText && this.myXmlFormattingPolicy.getShouldKeepLineBreaks();
    }

    public abstract boolean isTextElement();

    protected void createJspTextNode(List<? super Block> localResult, ASTNode child, Indent indent) {
    }

    @Nullable
    protected static ASTNode findChildAfter(@NotNull ASTNode child, int endOffset) {
        FileElement fileNode;
        LeafElement leaf;
        if (child == null) {
            AbstractXmlBlock.$$$reportNull$$$0(20);
        }
        if ((leaf = (fileNode = TreeUtil.getFileElement((TreeElement)((TreeElement)child))).findLeafElementAt(endOffset)) != null && leaf.getStartOffset() == endOffset && endOffset > 0) {
            return fileNode.findLeafElementAt(endOffset - 1);
        }
        return leaf;
    }

    public boolean isLeaf() {
        return AbstractXmlBlock.isComment(this.myNode) || this.myNode.getElementType() == TokenType.WHITE_SPACE || this.myNode.getElementType() == XmlTokenType.XML_DATA_CHARACTERS || this.myNode.getElementType() == XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN;
    }

    private static boolean isComment(ASTNode node) {
        PsiElement psiElement = SourceTreeToPsiMap.treeElementToPsi((ASTNode)node);
        if (psiElement instanceof PsiComment) {
            return true;
        }
        ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(psiElement.getLanguage());
        if (parserDefinition == null) {
            return false;
        }
        TokenSet commentTokens = parserDefinition.getCommentTokens();
        return commentTokens.contains(node.getElementType());
    }

    public void setXmlFormattingPolicy(XmlFormattingPolicy xmlFormattingPolicy) {
        this.myXmlFormattingPolicy = xmlFormattingPolicy;
    }

    protected boolean buildInjectedPsiBlocks(List<Block> result2, ASTNode child, Wrap wrap2, Alignment alignment, Indent indent) {
        if (this.isBuildIndentsOnly()) {
            return false;
        }
        if (this.myInjectedBlockBuilder.addInjectedBlocks(result2, child, wrap2, alignment, indent)) {
            return true;
        }
        PsiFile containingFile = child.getPsi().getContainingFile();
        FileViewProvider fileViewProvider = containingFile.getViewProvider();
        if (fileViewProvider instanceof TemplateLanguageFileViewProvider) {
            Language templateLanguage = ((TemplateLanguageFileViewProvider)fileViewProvider).getTemplateDataLanguage();
            PsiElement at = fileViewProvider.findElementAt(child.getStartOffset(), templateLanguage);
            if (at instanceof XmlToken) {
                at = at.getParent();
            }
            if (at instanceof PsiComment && at.getTextRange().equals((Object)child.getTextRange()) && at.getNode() != child) {
                return this.buildInjectedPsiBlocks(result2, at.getNode(), wrap2, alignment, indent);
            }
        }
        return false;
    }

    public boolean isCDATAStart() {
        return this.myNode.getElementType() == XmlTokenType.XML_CDATA_START;
    }

    public boolean isCDATAEnd() {
        return this.myNode.getElementType() == XmlTokenType.XML_CDATA_END;
    }

    public static boolean containsWhiteSpacesOnly(@NotNull ASTNode node) {
        PsiElement psiElement;
        if (node == null) {
            AbstractXmlBlock.$$$reportNull$$$0(21);
        }
        if ((psiElement = node.getPsi()) instanceof PsiWhiteSpace) {
            return true;
        }
        Language nodeLang = psiElement.getLanguage();
        if (!nodeLang.isKindOf((Language)XMLLanguage.INSTANCE) || AbstractXmlBlock.isTextOnlyNode(node) || node.getElementType() == XmlElementType.XML_PROLOG) {
            WhiteSpaceFormattingStrategy strategy = WhiteSpaceFormattingStrategyFactory.getStrategy((Language)nodeLang);
            int length = node.getTextLength();
            return strategy.check(node.getChars(), 0, length) >= length;
        }
        return false;
    }

    private static boolean isTextOnlyNode(@NotNull ASTNode node) {
        if (node == null) {
            AbstractXmlBlock.$$$reportNull$$$0(22);
        }
        if (node.getPsi() instanceof XmlText || node.getElementType() == XmlElementType.HTML_RAW_TEXT) {
            return true;
        }
        ASTNode firstChild = node.getFirstChildNode();
        ASTNode lastChild = node.getLastChildNode();
        return firstChild != null && firstChild == lastChild && firstChild.getPsi() instanceof XmlText;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "policy";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/formatter/xml/AbstractXmlBlock";
                break;
            }
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "myLanguage";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childLanguage";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childPsi";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/formatter/xml/AbstractXmlBlock";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getWrapType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "chooseAlignment";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "processChild";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "processAllChildrenFrom";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "processSimpleChild";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createRawTextChild";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createSimpleChild";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createTagBlock";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "useMyFormatter";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "findChildAfter";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "containsWhiteSpacesOnly";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isTextOnlyNode";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 4, 5, 6, 7 -> new IllegalStateException(string2);
        };
    }
}

