/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.json.formatter;

import com.intellij.json.JsonElementTypes;
import com.intellij.openapi.editor.DefaultLineWrapPositionStrategy;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JsonLineWrapPositionStrategy
extends DefaultLineWrapPositionStrategy {
    private static final int SKIP_WRAPPING = -2;

    public int calculateWrapPosition(@NotNull Document document2, @Nullable Project project2, int startOffset, int endOffset, int maxPreferredOffset, boolean allowToBeyondMaxPreferredOffset, boolean isSoftWrap) {
        if (document2 == null) {
            JsonLineWrapPositionStrategy.$$$reportNull$$$0(0);
        }
        if (isSoftWrap) {
            return super.calculateWrapPosition(document2, project2, startOffset, endOffset, maxPreferredOffset, allowToBeyondMaxPreferredOffset, true);
        }
        if (project2 == null) {
            return -1;
        }
        int wrapPosition = JsonLineWrapPositionStrategy.getMinWrapPosition(document2, project2, maxPreferredOffset);
        if (wrapPosition == -2) {
            return -1;
        }
        int minWrapPosition = Math.max(startOffset, wrapPosition);
        return super.calculateWrapPosition(document2, project2, minWrapPosition, endOffset, maxPreferredOffset, allowToBeyondMaxPreferredOffset, isSoftWrap);
    }

    private static int getMinWrapPosition(@NotNull Document document2, @NotNull Project project2, int offset) {
        PsiFile psiFile;
        PsiDocumentManager manager;
        if (document2 == null) {
            JsonLineWrapPositionStrategy.$$$reportNull$$$0(1);
        }
        if (project2 == null) {
            JsonLineWrapPositionStrategy.$$$reportNull$$$0(2);
        }
        if ((manager = PsiDocumentManager.getInstance((Project)project2)).isUncommited(document2)) {
            manager.commitDocument(document2);
        }
        if ((psiFile = manager.getPsiFile(document2)) != null) {
            PsiElement currElement = psiFile.findElementAt(offset);
            IElementType elementType = PsiUtilCore.getElementType((PsiElement)currElement);
            if (elementType == JsonElementTypes.DOUBLE_QUOTED_STRING || elementType == JsonElementTypes.SINGLE_QUOTED_STRING || elementType == JsonElementTypes.LITERAL || elementType == JsonElementTypes.BOOLEAN_LITERAL || elementType == JsonElementTypes.TRUE || elementType == JsonElementTypes.FALSE || elementType == JsonElementTypes.IDENTIFIER || elementType == JsonElementTypes.NULL_LITERAL || elementType == JsonElementTypes.NUMBER_LITERAL) {
                return currElement.getTextRange().getEndOffset();
            }
            if (elementType == JsonElementTypes.COLON) {
                return -2;
            }
            if (currElement != null && (currElement instanceof PsiComment || PsiUtilCore.getElementType((PsiElement)PsiTreeUtil.skipWhitespacesForward((PsiElement)currElement)) == JsonElementTypes.COMMA)) {
                return -2;
            }
        }
        return -1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/intellij/json/formatter/JsonLineWrapPositionStrategy";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "calculateWrapPosition";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getMinWrapPosition";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

