/*
 * Decompiled with CFR 0.152.
 */
package com.theoryinpractice.testng.inspection;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.codeInspection.options.OptionController;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.JDOMExternalizableStringList;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.profile.codeInspection.ProjectInspectionProfileManager;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.ContainerUtil;
import com.theoryinpractice.testng.TestngBundle;
import com.theoryinpractice.testng.util.TestNGUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DependsOnGroupsInspection
extends AbstractBaseJavaLocalInspectionTool {
    private static final Logger LOGGER = Logger.getInstance((String)"TestNG Runner");
    private static final Pattern PATTERN = Pattern.compile("\"([a-zA-Z0-9_\\-\\(\\)]*)\"");
    public JDOMExternalizableStringList groups = new JDOMExternalizableStringList();
    @NonNls
    public static final String SHORT_NAME = "groupsTestNG";

    @NotNull
    public String getGroupDisplayName() {
        return "TestNG";
    }

    @NotNull
    public String getShortName() {
        return SHORT_NAME;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.string((String)"groups", (String)TestngBundle.message("inspection.depends.on.groups.defined.groups.panel.title", new Object[0]), (int)30)});
        if (optPane == null) {
            DependsOnGroupsInspection.$$$reportNull$$$0(0);
        }
        return optPane;
    }

    @NotNull
    public OptionController getOptionController() {
        OptionController optionController = super.getOptionController().onValue("groups", () -> StringUtil.join((String[])ArrayUtilRt.toStringArray((Collection)this.groups), (String)","), value -> {
            this.groups.clear();
            if (!StringUtil.isEmptyOrSpaces((String)value)) {
                ContainerUtil.addAll((Collection)this.groups, (Object[])value.split("[, ]"));
            }
        });
        if (optionController == null) {
            DependsOnGroupsInspection.$$$reportNull$$$0(1);
        }
        return optionController;
    }

    public ProblemDescriptor @Nullable [] checkClass(@NotNull PsiClass psiClass, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (psiClass == null) {
            DependsOnGroupsInspection.$$$reportNull$$$0(2);
        }
        if (manager == null) {
            DependsOnGroupsInspection.$$$reportNull$$$0(3);
        }
        if (!psiClass.getContainingFile().isWritable()) {
            return null;
        }
        PsiAnnotation[] annotations = TestNGUtil.getTestNGAnnotations((PsiElement)psiClass);
        if (annotations.length == 0) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        ArrayList<ProblemDescriptor> problemDescriptors = new ArrayList<ProblemDescriptor>();
        for (PsiAnnotation annotation : annotations) {
            PsiExpression initializer;
            PsiElement resolve;
            PsiAnnotationMemberValue value;
            PsiNameValuePair[] params;
            PsiNameValuePair dep = null;
            for (PsiNameValuePair param : params = annotation.getParameterList().getAttributes()) {
                if (param.getName() == null || !param.getName().matches("(groups|dependsOnGroups)")) continue;
                dep = param;
                break;
            }
            if (dep == null || (value = dep.getValue()) == null) continue;
            LOGGER.debug("Found " + dep.getName() + " with: " + value.getText());
            String text = value.getText();
            if (value instanceof PsiReferenceExpression && (resolve = ((PsiReferenceExpression)value).resolve()) instanceof PsiField && ((PsiField)resolve).hasModifierProperty("static") && ((PsiField)resolve).hasModifierProperty("final") && (initializer = ((PsiField)resolve).getInitializer()) != null) {
                text = initializer.getText();
            }
            Matcher matcher = PATTERN.matcher(text);
            while (matcher.find()) {
                String methodName = matcher.group(1);
                if (this.groups.contains((Object)methodName)) continue;
                LOGGER.debug("group doesn't exist:" + methodName);
                ProblemDescriptor descriptor = manager.createProblemDescriptor((PsiElement)annotation, TestngBundle.message("inspection.depends.on.groups.undefined.group.problem", methodName), (LocalQuickFix)new GroupNameQuickFix(methodName), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly);
                problemDescriptors.add(descriptor);
            }
        }
        return problemDescriptors.toArray(ProblemDescriptor.EMPTY_ARRAY);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/theoryinpractice/testng/inspection/DependsOnGroupsInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionController";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/theoryinpractice/testng/inspection/DependsOnGroupsInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "checkClass";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3 -> new IllegalArgumentException(string);
        };
    }

    private class GroupNameQuickFix
    implements LocalQuickFix {
        String myGroupName;

        GroupNameQuickFix(String groupName) {
            if (groupName == null) {
                GroupNameQuickFix.$$$reportNull$$$0(0);
            }
            this.myGroupName = groupName;
        }

        @NotNull
        public String getName() {
            String string = TestngBundle.message("inspection.depends.on.groups.add.as.defined.test.group.fix", this.myGroupName);
            if (string == null) {
                GroupNameQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = TestngBundle.message("inspection.depends.on.groups.family.name", new Object[0]);
            if (string == null) {
                GroupNameQuickFix.$$$reportNull$$$0(2);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor problemDescriptor) {
            if (project == null) {
                GroupNameQuickFix.$$$reportNull$$$0(3);
            }
            if (problemDescriptor == null) {
                GroupNameQuickFix.$$$reportNull$$$0(4);
            }
            DependsOnGroupsInspection.this.groups.add((Object)this.myGroupName);
            ProjectInspectionProfileManager.getInstance((Project)project).fireProfileChanged();
        }

        public boolean startInWriteAction() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "groupName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/theoryinpractice/testng/inspection/DependsOnGroupsInspection$GroupNameQuickFix";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "problemDescriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/theoryinpractice/testng/inspection/DependsOnGroupsInspection$GroupNameQuickFix";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2 -> new IllegalStateException(string);
            };
        }
    }
}

