/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageChecker.service;

import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.packageChecker.model.SeverityFactory;
import com.intellij.packageChecker.service.Checked;
import com.intellij.packageChecker.service.PackageStatusKt;
import com.intellij.packageChecker.service.Vulnerable;
import java.util.Date;
import java.util.Iterator;
import java.util.NoSuchElementException;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.security.VulnerablePackage;
import org.jetbrains.security.problems.vulnerabilities.Severity;
import org.jetbrains.security.problems.vulnerabilities.Vulnerability;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0096\u0002J\u001a\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001e2\n\b\u0002\u0010 \u001a\u0004\u0018\u00010\u001eJ\b\u0010!\u001a\u00020\"H\u0016J\t\u0010#\u001a\u00020\u001eH\u00d6\u0001R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001b\u0010\t\u001a\u00020\n8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\fR\u001b\u0010\u000f\u001a\u00020\u00108FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u000e\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006$"}, d2={"Lcom/intellij/packageChecker/service/Vulnerable;", "Lcom/intellij/packageChecker/service/Checked;", "vulnerablePackage", "Lorg/jetbrains/security/VulnerablePackage;", "checkTime", "Ljava/util/Date;", "(Lorg/jetbrains/security/VulnerablePackage;Ljava/util/Date;)V", "getCheckTime", "()Ljava/util/Date;", "maxSeverity", "Lorg/jetbrains/security/problems/vulnerabilities/Severity;", "getMaxSeverity", "()Lorg/jetbrains/security/problems/vulnerabilities/Severity;", "maxSeverity$delegate", "Lkotlin/Lazy;", "problemHighlightType", "Lcom/intellij/codeInspection/ProblemHighlightType;", "getProblemHighlightType", "()Lcom/intellij/codeInspection/ProblemHighlightType;", "problemHighlightType$delegate", "getVulnerablePackage", "()Lorg/jetbrains/security/VulnerablePackage;", "component1", "component2", "copy", "equals", "", "other", "", "generateInspectionMessage", "", "property", "safeVersion", "hashCode", "", "toString", "intellij.packageChecker"})
public final class Vulnerable
extends Checked {
    @NotNull
    private final VulnerablePackage vulnerablePackage;
    @NotNull
    private final Date checkTime;
    @NotNull
    private final Lazy maxSeverity$delegate;
    @NotNull
    private final Lazy problemHighlightType$delegate;

    public Vulnerable(@NotNull VulnerablePackage vulnerablePackage, @NotNull Date checkTime) {
        Intrinsics.checkNotNullParameter((Object)vulnerablePackage, (String)"vulnerablePackage");
        Intrinsics.checkNotNullParameter((Object)checkTime, (String)"checkTime");
        super(vulnerablePackage.getPkg(), checkTime, null);
        this.vulnerablePackage = vulnerablePackage;
        this.checkTime = checkTime;
        this.maxSeverity$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Severity>(this){
            final /* synthetic */ Vulnerable this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Severity invoke() {
                Iterator<T> iterator = ((Iterable)this.this$0.getVulnerablePackage().getVulnerabilities()).iterator();
                if (!iterator.hasNext()) {
                    throw new NoSuchElementException();
                }
                Vulnerability it = (Vulnerability)iterator.next();
                boolean bl = false;
                float f = it.getCvssScore();
                while (iterator.hasNext()) {
                    Vulnerability it2 = (Vulnerability)iterator.next();
                    $i$a$-maxOf-Vulnerable$maxSeverity$2$maxScore$1 = false;
                    float f2 = it2.getCvssScore();
                    f = Math.max(f, f2);
                }
                float maxScore = f;
                return SeverityFactory.Companion.fromScore(maxScore);
            }
        }));
        this.problemHighlightType$delegate = LazyKt.lazy((Function0)((Function0)new Function0<ProblemHighlightType>(this){
            final /* synthetic */ Vulnerable this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final ProblemHighlightType invoke() {
                return switch (problemHighlightType.WhenMappings.$EnumSwitchMapping$0[this.this$0.getMaxSeverity().getType().ordinal()]) {
                    case 1 -> ProblemHighlightType.WEAK_WARNING;
                    case 2 -> ProblemHighlightType.WEAK_WARNING;
                    case 3 -> ProblemHighlightType.WARNING;
                    case 4 -> ProblemHighlightType.ERROR;
                    default -> throw new NoWhenBranchMatchedException();
                };
            }
        }));
    }

    @NotNull
    public final VulnerablePackage getVulnerablePackage() {
        return this.vulnerablePackage;
    }

    @Override
    @NotNull
    public Date getCheckTime() {
        return this.checkTime;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type com.intellij.packageChecker.service.Vulnerable");
        Vulnerable cfr_ignored_0 = (Vulnerable)other;
        return Intrinsics.areEqual((Object)this.vulnerablePackage, (Object)((Vulnerable)other).vulnerablePackage);
    }

    @NotNull
    public final Severity getMaxSeverity() {
        Lazy lazy = this.maxSeverity$delegate;
        return (Severity)lazy.getValue();
    }

    @NotNull
    public final ProblemHighlightType getProblemHighlightType() {
        Lazy lazy = this.problemHighlightType$delegate;
        return (ProblemHighlightType)lazy.getValue();
    }

    public int hashCode() {
        return this.vulnerablePackage.hashCode();
    }

    @NotNull
    public final String generateInspectionMessage(@NotNull String property, @Nullable String safeVersion) {
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        return PackageStatusKt.generateInspectionMessage$default(this.vulnerablePackage, property, safeVersion, null, null, 12, null);
    }

    public static /* synthetic */ String generateInspectionMessage$default(Vulnerable vulnerable, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        return vulnerable.generateInspectionMessage(string, string2);
    }

    @NotNull
    public final VulnerablePackage component1() {
        return this.vulnerablePackage;
    }

    @NotNull
    public final Date component2() {
        return this.checkTime;
    }

    @NotNull
    public final Vulnerable copy(@NotNull VulnerablePackage vulnerablePackage, @NotNull Date checkTime) {
        Intrinsics.checkNotNullParameter((Object)vulnerablePackage, (String)"vulnerablePackage");
        Intrinsics.checkNotNullParameter((Object)checkTime, (String)"checkTime");
        return new Vulnerable(vulnerablePackage, checkTime);
    }

    public static /* synthetic */ Vulnerable copy$default(Vulnerable vulnerable, VulnerablePackage vulnerablePackage, Date date, int n, Object object) {
        if ((n & 1) != 0) {
            vulnerablePackage = vulnerable.vulnerablePackage;
        }
        if ((n & 2) != 0) {
            date = vulnerable.checkTime;
        }
        return vulnerable.copy(vulnerablePackage, date);
    }

    @NotNull
    public String toString() {
        return "Vulnerable(vulnerablePackage=" + this.vulnerablePackage + ", checkTime=" + this.checkTime + ")";
    }
}

