/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageChecker.service;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.packageChecker.fus.PackageCheckerUsageStat;
import com.intellij.packageChecker.inspection.VulnerableLibrariesLocalInspection;
import com.intellij.packageChecker.service.IgnoreReason;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.security.package.Package;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u001a(\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0000\u001a\u001e\u0010\t\u001a\u00020\n2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\u000b"}, d2={"ignoreVulnerability", "", "project", "Lcom/intellij/openapi/project/Project;", "pkg", "Lorg/jetbrains/security/package/Package;", "moduleName", "", "reason", "isPackageIgnored", "", "intellij.packageChecker"})
public final class IgnorableDependenciesServiceKt {
    public static final void ignoreVulnerability(@NotNull Project project, @NotNull Package pkg, @NotNull String moduleName, @NotNull String reason) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)pkg, (String)"pkg");
        Intrinsics.checkNotNullParameter((Object)moduleName, (String)"moduleName");
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        ApplicationManager.getApplication().runWriteAction(() -> IgnorableDependenciesServiceKt.ignoreVulnerability$lambda$0(project, pkg, moduleName, reason));
    }

    public static final boolean isPackageIgnored(@NotNull Project project, @NotNull Package pkg, @NotNull String moduleName) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)pkg, (String)"pkg");
        Intrinsics.checkNotNullParameter((Object)moduleName, (String)"moduleName");
        InspectionProfileImpl inspectionProfileImpl = InspectionProjectProfileManager.getInstance((Project)project).getCurrentProfile();
        Intrinsics.checkNotNullExpressionValue((Object)inspectionProfileImpl, (String)"getCurrentProfile(...)");
        InspectionProfileImpl profile = inspectionProfileImpl;
        InspectionToolWrapper inspectionToolWrapper = profile.getInspectionTool("VulnerableLibrariesLocal", project);
        Object object = inspectionToolWrapper != null ? inspectionToolWrapper.getTool() : null;
        if (object == null) {
            return false;
        }
        InspectionProfileEntry inspectionInstance = object;
        VulnerableLibrariesLocalInspection instance = (VulnerableLibrariesLocalInspection)inspectionInstance;
        return instance.isIgnorable(pkg, moduleName);
    }

    private static final void ignoreVulnerability$lambda$0(Project $project, Package $pkg, String $moduleName, String $reason) {
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        Intrinsics.checkNotNullParameter((Object)$pkg, (String)"$pkg");
        Intrinsics.checkNotNullParameter((Object)$moduleName, (String)"$moduleName");
        Intrinsics.checkNotNullParameter((Object)$reason, (String)"$reason");
        InspectionProfileImpl inspectionProfileImpl = InspectionProjectProfileManager.getInstance((Project)$project).getCurrentProfile();
        Intrinsics.checkNotNullExpressionValue((Object)inspectionProfileImpl, (String)"getCurrentProfile(...)");
        InspectionProfileImpl profile = inspectionProfileImpl;
        InspectionToolWrapper inspectionToolWrapper = profile.getInspectionTool("VulnerableLibrariesLocal", $project);
        InspectionProfileEntry inspectionInstance = inspectionToolWrapper != null ? inspectionToolWrapper.getTool() : null;
        Intrinsics.checkNotNull((Object)inspectionInstance, (String)"null cannot be cast to non-null type com.intellij.packageChecker.inspection.VulnerableLibrariesLocalInspection");
        VulnerableLibrariesLocalInspection instance = (VulnerableLibrariesLocalInspection)inspectionInstance;
        instance.ignoreVulnerability($project, $pkg, $moduleName, $reason);
        PackageCheckerUsageStat.INSTANCE.getDependencyIsIgnored().log((Object)IgnoreReason.Companion.getOriginalReason($reason));
    }
}

