/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.ui.bindable.views;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.ui.ColorUtil;
import com.intellij.util.ui.EventListeners;
import com.intellij.util.ui.HTMLEditorKitBuilder;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.ide.model.uiautomation.BeHtmlViewer;
import com.jetbrains.ide.model.uiautomation.HyperlinkEventModel;
import com.jetbrains.rd.ui.bedsl.extensions.BeGetterExtensionsKt;
import com.jetbrains.rd.ui.bindable.ViewBinder;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.ISignal;
import java.awt.Color;
import java.net.URL;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.text.Document;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\bH\u0016J\f\u0010\t\u001a\u00020\n*\u00020\u000bH\u0002\u00a8\u0006\f"}, d2={"Lcom/jetbrains/rd/ui/bindable/views/HtmlViewerViewControl;", "Lcom/jetbrains/rd/ui/bindable/ViewBinder;", "Lcom/jetbrains/ide/model/uiautomation/BeHtmlViewer;", "()V", "bind", "Ljavax/swing/JComponent;", "viewModel", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "toProtocol", "Lcom/jetbrains/ide/model/uiautomation/HyperlinkEventModel;", "Ljavax/swing/event/HyperlinkEvent;", "intellij.rd.ui"})
@SourceDebugExtension(value={"SMAP\nHtmlViewerViewControl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HtmlViewerViewControl.kt\ncom/jetbrains/rd/ui/bindable/views/HtmlViewerViewControl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,61:1\n1855#2,2:62\n*S KotlinDebug\n*F\n+ 1 HtmlViewerViewControl.kt\ncom/jetbrains/rd/ui/bindable/views/HtmlViewerViewControl\n*L\n38#1:62,2\n*E\n"})
public final class HtmlViewerViewControl
implements ViewBinder<BeHtmlViewer> {
    @Override
    @NotNull
    public JComponent bind(@NotNull BeHtmlViewer viewModel, @NotNull Lifetime lifetime) {
        Intrinsics.checkNotNullParameter((Object)((Object)viewModel), (String)"viewModel");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        JEditorPane jEditorPane = new JEditorPane();
        jEditorPane.setEditable(false);
        HTMLEditorKit kit = new HTMLEditorKitBuilder().withWordWrapViewFactory().build();
        jEditorPane.setEditorKit(kit);
        jEditorPane.setBackground(UIUtil.getPanelBackground());
        Document doc = kit.createDefaultDocument();
        jEditorPane.setDocument(doc);
        String htmlString = (String)viewModel.getText().getValue();
        jEditorPane.setContentType("text/html");
        StyleSheet css = kit.getStyleSheet();
        css.addRule("body {color:#" + ColorUtil.toHex((Color)UIUtil.getLabelForeground()) + " }");
        css.addRule("body {font:" + StartupUiUtil.getLabelFont().getFamily() + " }");
        css.addRule("body {word-break: break-all;}");
        Iterable $this$forEach$iv = BeGetterExtensionsKt.valueOrEmpty(viewModel.getCssRules());
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            css.addRule(it);
        }
        if (htmlString != null) {
            viewModel.getText().advise(lifetime, (Function1)new Function1<String, Unit>(jEditorPane){
                final /* synthetic */ JEditorPane $jEditorPane;
                {
                    this.$jEditorPane = $jEditorPane;
                    super(1);
                }

                public final void invoke(@Nullable String v) {
                    this.$jEditorPane.setText(v);
                }
            });
        } else {
            viewModel.getUrl().advise(lifetime, (Function1)new Function1<String, Unit>(jEditorPane){
                final /* synthetic */ JEditorPane $jEditorPane;
                {
                    this.$jEditorPane = $jEditorPane;
                    super(1);
                }

                public final void invoke(@NotNull String v) {
                    Intrinsics.checkNotNullParameter((Object)v, (String)"v");
                    this.$jEditorPane.setPage(new URL(v));
                }
            });
            jEditorPane.setText("<html> " + viewModel.getTextOnError() + "</html>");
        }
        EventListeners.addHyperLinkListener((JEditorPane)jEditorPane, (Disposable)LifetimeDisposableExKt.createNestedDisposable$default((Lifetime)lifetime, null, (int)1, null), arg_0 -> HtmlViewerViewControl.bind$lambda$1(viewModel, this, arg_0));
        return jEditorPane;
    }

    private final HyperlinkEventModel toProtocol(HyperlinkEvent $this$toProtocol) {
        URL uRL = $this$toProtocol.getURL();
        return new HyperlinkEventModel(uRL != null ? uRL.toExternalForm() : null, $this$toProtocol.getDescription());
    }

    private static final void bind$lambda$1(BeHtmlViewer $viewModel, HtmlViewerViewControl this$0, HyperlinkEvent event) {
        Intrinsics.checkNotNullParameter((Object)((Object)$viewModel), (String)"$viewModel");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if (Intrinsics.areEqual((Object)event.getEventType(), (Object)HyperlinkEvent.EventType.ACTIVATED)) {
            ISignal<HyperlinkEventModel> iSignal = $viewModel.getLinkClicked();
            Intrinsics.checkNotNull((Object)event);
            iSignal.fire((Object)this$0.toProtocol(event));
        }
    }
}

