/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.protocol;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.client.ClientProjectSession;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.rd.DisposableEx;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.rd.framework.ExtCreationInfo;
import com.jetbrains.rd.framework.ExtCreationInfoEx;
import com.jetbrains.rd.framework.IProtocol;
import com.jetbrains.rd.framework.IRdDynamic;
import com.jetbrains.rd.framework.Protocol;
import com.jetbrains.rd.framework.RdId;
import com.jetbrains.rd.framework.base.RdBindableBase;
import com.jetbrains.rd.framework.base.RdExtBase;
import com.jetbrains.rd.ide.model.Solution;
import com.jetbrains.rd.ide.model.SolutionModel;
import com.jetbrains.rd.platform.protocol.IRdDispatcher;
import com.jetbrains.rd.platform.protocol.IRdDispatcherKt;
import com.jetbrains.rd.platform.util.ComponentsKt;
import com.jetbrains.rd.protocol.AppExtListener;
import com.jetbrains.rd.protocol.BaseExtListenerDescriptor;
import com.jetbrains.rd.protocol.ProjectExtListener;
import com.jetbrains.rd.protocol.ProtocolExtListener;
import com.jetbrains.rd.protocol.ProtocolExtListenerAdapter;
import com.jetbrains.rd.protocol.ProtocolExtListenerAdapterBase;
import com.jetbrains.rd.protocol.ProtocolExtListenerDescriptor;
import com.jetbrains.rd.protocol.ProtocolExtListenerManager;
import com.jetbrains.rd.protocol.RootExtListener;
import com.jetbrains.rd.protocol.RootExtListenerDescriptor;
import com.jetbrains.rd.protocol.SolutionExtListenerDescriptor;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rd.util.string.RName;
import com.jetbrains.rd.util.threading.coroutines.LifetimeCoroutineUtilKt;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DelayKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00b4\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0016\u0018\u0000 P2\u00020\u0001:\u0002PQB%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010#\u001a\u00020$H\u0002J(\u0010%\u001a\u00020$\"\b\b\u0000\u0010&*\u00020'2\f\u0010(\u001a\b\u0012\u0004\u0012\u0002H&0)2\u0006\u0010*\u001a\u00020+H\u0002J\b\u0010,\u001a\u00020$H\u0002J\b\u0010-\u001a\u00020$H\u0002J\u0018\u0010.\u001a\u00020$2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010/\u001a\u000200H\u0002J\u0018\u00101\u001a\u00020$2\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u00020\u001eH\u0014JD\u00105\u001a\u000e\u0012\u0004\u0012\u000207\u0012\u0004\u0012\u00020\u001e062\u0006\u0010\u0006\u001a\u0002082\f\u00109\u001a\b\u0012\u0004\u0012\u0002070:2\u0006\u0010;\u001a\u00020 2\b\u0010<\u001a\u0004\u0018\u00010=2\u0006\u0010>\u001a\u00020?H\u0002J2\u0010@\u001a\u00020$2\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010A\u001a\u0004\u0018\u00010\u001a2\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u00020\u001e2\u0006\u0010B\u001a\u00020\u001eH\u0014J'\u0010C\u001a\u00020$\"\b\b\u0000\u0010&*\u00020'2\u0006\u0010D\u001a\u0002H&2\u0006\u0010E\u001a\u00020FH\u0002\u00a2\u0006\u0002\u0010GJ\u0018\u0010H\u001a\u00020$2\u0006\u0010D\u001a\u00020'2\u0006\u0010I\u001a\u00020FH\u0002J\u0016\u0010J\u001a\u00020$2\u0006\u0010A\u001a\u00020\u001a2\u0006\u0010K\u001a\u00020LJ\u0010\u0010M\u001a\u00020$2\u0006\u0010N\u001a\u00020\tH\u0002J\u000e\u0010O\u001a\u0004\u0018\u00010\t*\u00020 H\u0002R \u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u001a0\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u001e0\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001f\u001a\u0004\u0018\u00010\t*\u00020 8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u0006R"}, d2={"Lcom/jetbrains/rd/protocol/ProtocolExtListenerManager;", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "appSession", "Lcom/intellij/openapi/client/ClientAppSession;", "protocol", "Lcom/jetbrains/rd/framework/Protocol;", "endpoint", "", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/intellij/openapi/client/ClientAppSession;Lcom/jetbrains/rd/framework/Protocol;Ljava/lang/String;)V", "accumulatedMessages", "", "", "Lcom/jetbrains/rd/framework/ExtCreationInfoEx;", "adapters", "Lcom/intellij/util/containers/MultiMap;", "Lcom/jetbrains/rd/protocol/ProtocolExtListenerAdapterBase;", "getAppSession", "()Lcom/intellij/openapi/client/ClientAppSession;", "getEndpoint", "()Ljava/lang/String;", "getLifetime", "()Lcom/jetbrains/rd/util/lifetime/Lifetime;", "lock", "projectSessions", "Lcom/intellij/openapi/client/ClientProjectSession;", "getProtocol", "()Lcom/jetbrains/rd/framework/Protocol;", "recentlyClosedProjectSessions", "", "asSolutionId", "Lcom/jetbrains/rd/util/string/RName;", "getAsSolutionId", "(Lcom/jetbrains/rd/util/string/RName;)Ljava/lang/String;", "addSolutionModelListener", "", "adviseOnExtensionPoint", "T", "Lcom/jetbrains/rd/protocol/BaseExtListenerDescriptor;", "extensionPoint", "Lcom/intellij/openapi/extensions/ExtensionPoint;", "disposable", "Lcom/intellij/openapi/Disposable;", "adviseOnListeners", "adviseOnProtocol", "adviseOnSolutionsMap", "model", "Lcom/jetbrains/rd/ide/model/SolutionModel;", "beforeAccumulateExcCreationSignal", "info", "Lcom/jetbrains/rd/framework/ExtCreationInfo;", "isLocal", "createExtInstance", "Lkotlin/Pair;", "Lcom/jetbrains/rd/framework/base/RdExtBase;", "Lcom/jetbrains/rd/framework/IProtocol;", "extClass", "Ljava/lang/Class;", "rName", "parent", "Lcom/jetbrains/rd/framework/base/RdBindableBase;", "hash", "", "handleMessage", "projectSession", "onlyProjectListeners", "onExtensionAdded", "extension", "descriptor", "Lcom/intellij/openapi/extensions/PluginDescriptor;", "(Lcom/jetbrains/rd/protocol/BaseExtListenerDescriptor;Lcom/intellij/openapi/extensions/PluginDescriptor;)V", "onExtensionRemoved", "pluginDescriptor", "startDeliveringMessages", "solution", "Lcom/jetbrains/rd/ide/model/Solution;", "stopDeliveringMessages", "solutionId", "tryGetSolutionId", "Companion", "SolutionModelListener", "intellij.rd.platform"})
@SourceDebugExtension(value={"SMAP\nProtocolExtListenerManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProtocolExtListenerManager.kt\ncom/jetbrains/rd/protocol/ProtocolExtListenerManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 4 ProtocolExtListenerManager.kt\ncom/jetbrains/rd/protocol/ProtocolExtListenerManagerKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 RLifetime.kt\ncom/jetbrains/rd/util/lifetime/Lifetime$Companion\n+ 7 RdBindableBase.kt\ncom/jetbrains/rd/framework/base/RdBindableBase\n*L\n1#1,376:1\n1855#2:377\n1856#2:382\n1726#2,3:396\n1855#2,2:399\n65#3,4:378\n13#3:403\n367#4,9:383\n1#5:392\n39#6,3:393\n43#6:401\n118#7:402\n*S KotlinDebug\n*F\n+ 1 ProtocolExtListenerManager.kt\ncom/jetbrains/rd/protocol/ProtocolExtListenerManager\n*L\n62#1:377\n62#1:382\n214#1:396,3\n234#1:399,2\n63#1:378,4\n273#1:403\n168#1:383,9\n209#1:393,3\n209#1:401\n260#1:402\n*E\n"})
public class ProtocolExtListenerManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lifetime lifetime;
    @NotNull
    private final ClientAppSession appSession;
    @NotNull
    private final Protocol protocol;
    @NotNull
    private final String endpoint;
    @NotNull
    private Map<String, ClientProjectSession> projectSessions;
    @NotNull
    private Map<String, Boolean> recentlyClosedProjectSessions;
    @NotNull
    private final Map<String, List<ExtCreationInfoEx>> accumulatedMessages;
    @NotNull
    private final Object lock;
    @NotNull
    private final MultiMap<String, ProtocolExtListenerAdapterBase> adapters;
    @NotNull
    private static final Logger logger;

    public ProtocolExtListenerManager(@NotNull Lifetime lifetime, @NotNull ClientAppSession appSession, @NotNull Protocol protocol, @NotNull String endpoint) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)appSession, (String)"appSession");
        Intrinsics.checkNotNullParameter((Object)protocol, (String)"protocol");
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        this.lifetime = lifetime;
        this.appSession = appSession;
        this.protocol = protocol;
        this.endpoint = endpoint;
        this.projectSessions = new LinkedHashMap();
        this.recentlyClosedProjectSessions = new LinkedHashMap();
        this.accumulatedMessages = new LinkedHashMap();
        this.lock = new Object();
        this.adapters = new MultiMap();
        this.adviseOnListeners();
        this.adviseOnProtocol();
    }

    @NotNull
    public final Lifetime getLifetime() {
        return this.lifetime;
    }

    @NotNull
    public final ClientAppSession getAppSession() {
        return this.appSession;
    }

    @NotNull
    public final Protocol getProtocol() {
        return this.protocol;
    }

    @NotNull
    public final String getEndpoint() {
        return this.endpoint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void startDeliveringMessages(@NotNull ClientProjectSession projectSession, @NotNull Solution solution) {
        List list2;
        Intrinsics.checkNotNullParameter((Object)projectSession, (String)"projectSession");
        Intrinsics.checkNotNullParameter((Object)((Object)solution), (String)"solution");
        String solutionId = this.tryGetSolutionId(solution.getLocation());
        if (solutionId == null) {
            logger.error("Failed to get solution location for solution: " + solution.getLocation());
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            if (!(this.projectSessions.get(solutionId) == null)) {
                boolean $i$a$-check-ProtocolExtListenerManager$startDeliveringMessages$messages$1$22 = false;
                String $i$a$-check-ProtocolExtListenerManager$startDeliveringMessages$messages$1$22 = "Tried to reset a project session " + this.projectSessions.get(solutionId) + " " + solutionId + " with " + projectSession;
                throw new IllegalStateException($i$a$-check-ProtocolExtListenerManager$startDeliveringMessages$messages$1$22.toString());
            }
            this.projectSessions.put(solutionId, projectSession);
            List list3 = this.accumulatedMessages.remove(solutionId);
            if (list3 == null) {
                list3 = CollectionsKt.emptyList();
            }
            list2 = list3;
        }
        List messages = list2;
        Iterable $this$forEach$iv = messages;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ExtCreationInfoEx extCreationInfoEx = (ExtCreationInfoEx)element$iv;
            boolean bl = false;
            ExtCreationInfo info = extCreationInfoEx.component1();
            boolean isLocal = extCreationInfoEx.component2();
            Logger $this$trace$iv = logger;
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv;
                boolean bl2 = false;
                logger.trace("init listeners on background for model " + info.getRName() + ", isLocal=" + isLocal);
            }
            this.handleMessage(this.protocol, projectSession, info, isLocal, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void stopDeliveringMessages(String solutionId) {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            this.accumulatedMessages.remove(solutionId);
            this.projectSessions.remove(solutionId);
            boolean bl2 = logger.assertTrue(this.recentlyClosedProjectSessions.put(solutionId, false) == null, (Object)("Solution: " + solutionId + " closed twice?"));
        }
        LifetimeCoroutineUtilKt.launch$default((Lifetime)this.lifetime, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, solutionId, null){
            int label;
            final /* synthetic */ ProtocolExtListenerManager this$0;
            final /* synthetic */ String $solutionId;
            {
                this.this$0 = $receiver;
                this.$solutionId = $solutionId;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var7_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        this.label = 1;
                        v0 = DelayKt.delay-VtjQ1oo((long)DurationKt.toDuration((int)1, (DurationUnit)DurationUnit.MINUTES), (Continuation)((Continuation)this));
                        if (v0 == var7_2) {
                            return var7_2;
                        }
                        ** GOTO lbl14
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl14:
                        // 2 sources

                        var2_3 = ProtocolExtListenerManager.access$getLock$p(this.this$0);
                        var3_4 = this.this$0;
                        var4_5 = this.$solutionId;
                        var5_6 = var2_3;
                        synchronized (var5_6) {
                            $i$a$-synchronized-ProtocolExtListenerManager$stopDeliveringMessages$2$1 = false;
                            ProtocolExtListenerManager.access$getRecentlyClosedProjectSessions$p(var3_4).put(var4_5, Boxing.boxBoolean((boolean)true));
                            $i$a$-synchronized-ProtocolExtListenerManager$stopDeliveringMessages$2$1 = Unit.INSTANCE;
                        }
                        this.label = 2;
                        v1 = DelayKt.delay-VtjQ1oo((long)DurationKt.toDuration((int)5, (DurationUnit)DurationUnit.MINUTES), (Continuation)((Continuation)this));
                        if (v1 == var7_2) {
                            return var7_2;
                        }
                        ** GOTO lbl37
                    }
                    case 2: {
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl37:
                        // 2 sources

                        var2_3 = ProtocolExtListenerManager.access$getLock$p(this.this$0);
                        var3_4 = this.this$0;
                        var4_5 = this.$solutionId;
                        var5_6 = var2_3;
                        synchronized (var5_6) {
                            $i$a$-synchronized-ProtocolExtListenerManager$stopDeliveringMessages$2$2 = false;
                            ProtocolExtListenerManager.access$getLogger$cp().assertTrue(ProtocolExtListenerManager.access$getRecentlyClosedProjectSessions$p(var3_4).remove(var4_5) != null);
                            var6_11 = Unit.INSTANCE;
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final void adviseOnProtocol() {
        IRdDispatcher scheduler = IRdDispatcherKt.getAsRdDispatcher(this.protocol.getScheduler());
        this.protocol.getExtCreated().advise(this.lifetime, (Function1)new Function1<ExtCreationInfoEx, Unit>(this, scheduler){
            final /* synthetic */ ProtocolExtListenerManager this$0;
            final /* synthetic */ IRdDispatcher $scheduler;
            {
                this.this$0 = $receiver;
                this.$scheduler = $scheduler;
                super(1);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke(@NotNull ExtCreationInfoEx infoEx) {
                ClientProjectSession localProjectSession;
                Intrinsics.checkNotNullParameter((Object)infoEx, (String)"infoEx");
                ExtCreationInfo info = infoEx.component1();
                boolean isLocal = infoEx.component2();
                String solutionId = ProtocolExtListenerManager.access$tryGetSolutionId(this.this$0, info.getRName());
                if (solutionId != null) {
                    Object object = ProtocolExtListenerManager.access$getLock$p(this.this$0);
                    ProtocolExtListenerManager protocolExtListenerManager = this.this$0;
                    Object object2 = object;
                    synchronized (object2) {
                        boolean bl = false;
                        ClientProjectSession projectSession = (ClientProjectSession)ProtocolExtListenerManager.access$getProjectSessions$p(protocolExtListenerManager).get(solutionId);
                        if (projectSession == null) {
                            Object object3;
                            Boolean closedLongTimeAgo = (Boolean)ProtocolExtListenerManager.access$getRecentlyClosedProjectSessions$p(protocolExtListenerManager).get(solutionId);
                            if (closedLongTimeAgo != null) {
                                if (closedLongTimeAgo.booleanValue()) {
                                    ProtocolExtListenerManager.access$getLogger$cp().error("Solution: " + solutionId + " has long been closed, but ext: " + infoEx + " is still trying to be created");
                                }
                                return;
                            }
                            protocolExtListenerManager.beforeAccumulateExcCreationSignal(info, isLocal);
                            Map $this$getOrPut$iv = ProtocolExtListenerManager.access$getAccumulatedMessages$p(protocolExtListenerManager);
                            boolean $i$f$getOrPut = false;
                            V value$iv = $this$getOrPut$iv.get(solutionId);
                            if (value$iv == null) {
                                boolean bl2 = false;
                                List answer$iv = new ArrayList<E>();
                                $this$getOrPut$iv.put(solutionId, answer$iv);
                                object3 = answer$iv;
                            } else {
                                object3 = value$iv;
                            }
                            ((List)object3).add(infoEx);
                        }
                        ClientProjectSession clientProjectSession = projectSession;
                        // MONITOREXIT @DISABLED, blocks:[0, 1, 11] lbl39 : MonitorExitStatement: MONITOREXIT : var8_7
                        v1 = clientProjectSession;
                    }
                } else {
                    v1 = localProjectSession = null;
                }
                if (isLocal) {
                    this.this$0.handleMessage(this.this$0.getProtocol(), localProjectSession, info, isLocal, false);
                } else {
                    this.$scheduler.getBackgroundScheduler().invokeOrQueue((Function0)new Function0<Unit>(this.this$0, localProjectSession, info, isLocal){
                        final /* synthetic */ ProtocolExtListenerManager this$0;
                        final /* synthetic */ ClientProjectSession $localProjectSession;
                        final /* synthetic */ ExtCreationInfo $info;
                        final /* synthetic */ boolean $isLocal;
                        {
                            this.this$0 = $receiver;
                            this.$localProjectSession = $localProjectSession;
                            this.$info = $info;
                            this.$isLocal = $isLocal;
                            super(0);
                        }

                        public final void invoke() {
                            this.this$0.handleMessage(this.this$0.getProtocol(), this.$localProjectSession, this.$info, this.$isLocal, false);
                        }
                    });
                }
            }
        });
    }

    protected void beforeAccumulateExcCreationSignal(@NotNull ExtCreationInfo info, boolean isLocal) {
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
    }

    private final void adviseOnSolutionsMap(Lifetime lifetime, SolutionModel model2) {
        model2.getSolutions().view(lifetime, (Function2)new Function2<Lifetime, Map.Entry<? extends Integer, ? extends Solution>, Unit>(this){
            final /* synthetic */ ProtocolExtListenerManager this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            public final void invoke(@NotNull Lifetime solutionLifetime, @NotNull Map.Entry<Integer, Solution> solution) {
                Intrinsics.checkNotNullParameter((Object)solutionLifetime, (String)"solutionLifetime");
                Intrinsics.checkNotNullParameter(solution, (String)"solution");
                solutionLifetime.bracketIfAliveEx((Function0)new Function0<String>(this.this$0, solution){
                    final /* synthetic */ ProtocolExtListenerManager this$0;
                    final /* synthetic */ Map.Entry<Integer, Solution> $solution;
                    {
                        this.this$0 = $receiver;
                        this.$solution = $solution;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        String string = ProtocolExtListenerManager.access$tryGetSolutionId(this.this$0, this.$solution.getValue().getLocation());
                        if (string == null) {
                            throw new IllegalStateException(("Failed to get solution location from solution: " + this.$solution).toString());
                        }
                        return string;
                    }
                }, (Function1)new Function1<String, Unit>(this.this$0){
                    final /* synthetic */ ProtocolExtListenerManager this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull String it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        ProtocolExtListenerManager.access$stopDeliveringMessages(this.this$0, it);
                    }
                });
            }
        });
    }

    private final void adviseOnListeners() {
        Disposable disposable = DisposableEx.createNestedDisposable$default(this.lifetime, null, 1, null);
        this.addSolutionModelListener();
        this.adviseOnExtensionPoint(ProtocolExtListenerDescriptor.Companion.getEP_NAME().getPoint(), disposable);
        this.adviseOnExtensionPoint(SolutionExtListenerDescriptor.Companion.getEP_NAME().getPoint(), disposable);
        this.adviseOnExtensionPoint(RootExtListenerDescriptor.Companion.getEP_NAME().getPoint(), disposable);
    }

    private final void addSolutionModelListener() {
        SolutionModelListener listener2 = new SolutionModelListener(this);
        this.adapters.putValue((Object)Reflection.getOrCreateKotlinClass(SolutionModel.class).getSimpleName(), (Object)new ProtocolExtListenerAdapterBase(listener2){
            @NotNull
            private final Class<RdExtBase> extClass;
            final /* synthetic */ SolutionModelListener $listener;
            {
                this.$listener = $listener;
                this.extClass = SolutionModel.class;
            }

            @NotNull
            public ProtocolExtListener<RdBindableBase, RdExtBase> getHandlerInstance() {
                SolutionModelListener solutionModelListener = this.$listener;
                Intrinsics.checkNotNull((Object)solutionModelListener, (String)"null cannot be cast to non-null type com.jetbrains.rd.protocol.ProtocolExtListener<com.jetbrains.rd.framework.base.RdBindableBase?, com.jetbrains.rd.framework.base.RdExtBase>");
                return solutionModelListener;
            }

            @NotNull
            public Class<RdExtBase> getExtClass() {
                return this.extClass;
            }
        });
    }

    private final <T extends BaseExtListenerDescriptor> void adviseOnExtensionPoint(ExtensionPoint<T> extensionPoint, Disposable disposable) {
        boolean $i$f$createListener = false;
        ExtensionPointListener listener2 = new ExtensionPointListener<T>(this, this){
            final /* synthetic */ ProtocolExtListenerManager $receiver$inlined;
            final /* synthetic */ ProtocolExtListenerManager $receiver$inlined$1;
            {
                this.$receiver$inlined = protocolExtListenerManager;
                this.$receiver$inlined$1 = protocolExtListenerManager2;
            }

            /*
             * WARNING - void declaration
             */
            public void extensionAdded(T extension, @NotNull PluginDescriptor pluginDescriptor) {
                void p1;
                Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
                PluginDescriptor pluginDescriptor2 = pluginDescriptor;
                BaseExtListenerDescriptor p0 = (BaseExtListenerDescriptor)extension;
                boolean bl = false;
                ProtocolExtListenerManager.access$onExtensionAdded(this.$receiver$inlined, p0, (PluginDescriptor)p1);
            }

            /*
             * WARNING - void declaration
             */
            public void extensionRemoved(T extension, @NotNull PluginDescriptor pluginDescriptor) {
                void p1;
                Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
                PluginDescriptor pluginDescriptor2 = pluginDescriptor;
                BaseExtListenerDescriptor p0 = (BaseExtListenerDescriptor)extension;
                boolean bl = false;
                ProtocolExtListenerManager.access$onExtensionRemoved(this.$receiver$inlined$1, p0, (PluginDescriptor)p1);
            }
        };
        extensionPoint.addExtensionPointListener(listener2, true, disposable);
    }

    private final <T extends BaseExtListenerDescriptor> void onExtensionAdded(T extension, PluginDescriptor descriptor) {
        if (!extension.isValid()) {
            logger.error("extension is broken: " + extension);
            return;
        }
        if (!Intrinsics.areEqual((Object)extension.getEndpoint(), (Object)this.endpoint)) {
            return;
        }
        ProtocolExtListenerAdapter adapter = new ProtocolExtListenerAdapter(extension, descriptor);
        this.adapters.putValue((Object)adapter.getLocation(), (Object)adapter);
    }

    private final void onExtensionRemoved(BaseExtListenerDescriptor extension, PluginDescriptor pluginDescriptor) {
        if (!Intrinsics.areEqual((Object)extension.getEndpoint(), (Object)this.endpoint)) {
            return;
        }
        ProtocolExtListenerAdapter adapter = new ProtocolExtListenerAdapter(extension, pluginDescriptor);
        this.adapters.remove((Object)adapter.getLocation(), (Object)adapter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleMessage(@NotNull Protocol protocol, @Nullable ClientProjectSession projectSession, @NotNull ExtCreationInfo info, boolean isLocal, boolean onlyProjectListeners) {
        RdBindableBase parent;
        Intrinsics.checkNotNullParameter((Object)protocol, (String)"protocol");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        String location = ProtocolExtListenerManager.Companion.toLocation(info.getRName());
        Collection collection = this.adapters.get((Object)location);
        if (collection.isEmpty()) {
            boolean bl = false;
            return;
        }
        Collection collection2 = collection;
        Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"ifEmpty(...)");
        Collection listeners = collection2;
        RdId rdId = info.getRdId-vX8-7Ic();
        if (rdId != null) {
            long it = rdId.unbox-impl();
            boolean bl = false;
            v2 = ProtocolExtListenerManager.Companion.findParent-v_l8LFs(protocol, it);
        } else {
            v2 = parent = null;
        }
        if (info.getRdId-vX8-7Ic() != null && parent == null) {
            if (projectSession != null && (projectSession.isDisposed() || projectSession.getProject().isDisposed() || RLifetimeKt.isNotAlive((Lifetime)ComponentsKt.getLifetime((UserDataHolder)projectSession.getProject())))) {
                return;
            }
            if (this.appSession.isDisposed()) {
                return;
            }
            Application application = ApplicationManager.getApplication();
            if (application.isDisposed() || RLifetimeKt.isNotAlive((Lifetime)ComponentsKt.getLifetime((UserDataHolder)application))) {
                return;
            }
            logger.error("Failed to get parent for location \"" + info.getRName() + "\"");
            return;
        }
        Lifetime.Companion this_$iv = Lifetime.Companion;
        boolean $i$f$using = false;
        LifetimeDefinition def$iv = new LifetimeDefinition();
        try {
            block23: {
                Class<RdExtBase> extClass2;
                Lifetime backgroundLifetime = def$iv.getLifetime();
                boolean bl = false;
                IRdDispatcherKt.getAsRdDispatcher(protocol.getScheduler()).allowBackgroundThreadAndSuppressPumping(backgroundLifetime);
                try {
                    boolean bl2;
                    block22: {
                        extClass2 = ((ProtocolExtListenerAdapterBase)CollectionsKt.first((Iterable)listeners)).getExtClass();
                        Iterable $this$all$iv = listeners;
                        boolean $i$f$all = false;
                        if (((Collection)$this$all$iv).isEmpty()) {
                            bl2 = true;
                        } else {
                            for (Object element$iv : $this$all$iv) {
                                ProtocolExtListenerAdapterBase it = (ProtocolExtListenerAdapterBase)element$iv;
                                boolean bl3 = false;
                                if (Intrinsics.areEqual(it.getExtClass(), extClass2)) continue;
                                bl2 = false;
                                break block22;
                            }
                            bl2 = true;
                        }
                    }
                    if (!bl2) {
                        boolean $i$a$-check-ProtocolExtListenerManager$handleMessage$1$32 = false;
                        String $i$a$-check-ProtocolExtListenerManager$handleMessage$1$32 = "All ext classes must be the same, found: [" + CollectionsKt.joinToString$default((Iterable)listeners, null, null, null, (int)0, null, (Function1)handleMessage.1.2.1.INSTANCE, (int)31, null) + "]";
                        throw new IllegalStateException($i$a$-check-ProtocolExtListenerManager$handleMessage$1$32.toString());
                    }
                    extClass2 = this.createExtInstance((IProtocol)protocol, extClass2, info.getRName(), parent, info.getHash());
                }
                catch (Exception e) {
                    logger.error("Failed to create extension instance for location \"" + location + "\"", (Throwable)e);
                    break block23;
                }
                Class<RdExtBase> clazz = extClass2;
                RdExtBase boundExt = (RdExtBase)clazz.component1();
                boolean isNew = (Boolean)clazz.component2();
                if (isLocal) {
                    logger.assertTrue(!isNew);
                    Iterable $this$forEach$iv = listeners;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        ProtocolExtListenerAdapterBase it = (ProtocolExtListenerAdapterBase)element$iv;
                        boolean bl4 = false;
                        try {
                            Lifetime bindLifetime;
                            ProtocolExtListener<RdBindableBase, RdExtBase> handler2 = it.getHandlerInstance();
                            if (boundExt.getBindLifetime() == null) {
                                throw new IllegalStateException("Bind lifetime is not initialized yet for extension " + it.getExtClass());
                            }
                            if (handler2 instanceof ProjectExtListener && projectSession != null) {
                                ((ProjectExtListener)handler2).extensionCreated(RLifetimeKt.intersect((Lifetime)bindLifetime, (Lifetime)ComponentsKt.getLifetime((UserDataHolder)projectSession)), projectSession, parent, boundExt);
                                continue;
                            }
                            if (!(handler2 instanceof AppExtListener) || onlyProjectListeners) continue;
                            ((AppExtListener)handler2).extensionCreated(bindLifetime, this.appSession, parent, boundExt);
                        }
                        catch (Exception e) {
                            logger.error("Failed to create protocol listener for location \"" + location + "\"", (Throwable)e);
                        }
                    }
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            LifetimeDefinition.terminate$default((LifetimeDefinition)def$iv, (boolean)false, (int)1, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Pair<RdExtBase, Boolean> createExtInstance(IProtocol protocol, Class<RdExtBase> extClass2, RName rName, RdBindableBase parent, long hash) {
        RdExtBase ext2;
        RdExtBase newInstance = null;
        if (parent != null) {
            void this_$iv;
            RdExtBase rdExtBase = extClass2.getConstructor(new Class[0]).newInstance(new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)rdExtBase, (String)"newInstance(...)");
            newInstance = rdExtBase;
            RdBindableBase rdBindableBase = parent;
            String string = rName.getLocalName();
            Function0 create$iv = (Function0)new Function0<RdExtBase>(newInstance){
                final /* synthetic */ RdExtBase $newInstance;
                {
                    this.$newInstance = $newInstance;
                    super(0);
                }

                @NotNull
                public final RdExtBase invoke() {
                    return this.$newInstance;
                }
            };
            boolean $i$f$getOrCreateExtension = false;
            v1 = (RdExtBase)this_$iv.getOrCreateExtension((String)name$iv, Reflection.getOrCreateKotlinClass(RdExtBase.class), create$iv);
        } else {
            name$iv = new Class[]{Lifetime.class, IProtocol.class};
            Method createModelMethod = extClass2.getMethod("internalCreateModel", name$iv);
            Object[] objectArray = new Object[]{protocol.getLifetime(), protocol};
            Object object = createModelMethod.invoke(null, objectArray);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.jetbrains.rd.framework.base.RdExtBase");
            newInstance = (RdExtBase)object;
            v1 = ext2 = protocol.getOrCreateExtension(JvmClassMappingKt.getKotlinClass(extClass2), (Function0)new Function0<RdExtBase>(newInstance){
                final /* synthetic */ RdExtBase $newInstance;
                {
                    this.$newInstance = $newInstance;
                    super(0);
                }

                @NotNull
                public final RdExtBase invoke() {
                    return this.$newInstance;
                }
            });
        }
        if (!(ext2.getSerializationHash() == hash)) {
            boolean bl = false;
            String string = "Hash mismatch: expected hash " + hash + ", actual ext hash was " + ext2.getSerializationHash();
            throw new IllegalStateException(string.toString());
        }
        return TuplesKt.to((Object)ext2, (Object)(newInstance == ext2 ? 1 : 0));
    }

    private final String tryGetSolutionId(RName $this$tryGetSolutionId) {
        for (RName name = $this$tryGetSolutionId; name != null; name = name.getParent()) {
            String solutionId = this.getAsSolutionId(name);
            if (solutionId == null) continue;
            return solutionId;
        }
        return null;
    }

    private final String getAsSolutionId(RName $this$asSolutionId) {
        RName rName = $this$asSolutionId.getParent();
        if (rName == null) {
            return null;
        }
        RName solutions = rName;
        RName rName2 = solutions.getParent();
        if (rName2 == null) {
            return null;
        }
        RName solutionModel2 = rName2;
        RName rName3 = solutionModel2.getParent();
        if (rName3 == null) {
            return null;
        }
        RName root = rName3;
        if (!Intrinsics.areEqual((Object)root.getParent(), (Object)RName.Companion.getEmpty())) {
            return null;
        }
        if (!Intrinsics.areEqual((Object)solutions.getLocalName(), (Object)"solutions")) {
            return null;
        }
        if (!Intrinsics.areEqual((Object)solutionModel2.getLocalName(), (Object)SolutionModel.class.getSimpleName())) {
            return null;
        }
        return $this$asSolutionId.getLocalName();
    }

    public static final /* synthetic */ Object access$getLock$p(ProtocolExtListenerManager $this) {
        return $this.lock;
    }

    public static final /* synthetic */ Map access$getRecentlyClosedProjectSessions$p(ProtocolExtListenerManager $this) {
        return $this.recentlyClosedProjectSessions;
    }

    public static final /* synthetic */ Logger access$getLogger$cp() {
        return logger;
    }

    public static final /* synthetic */ String access$tryGetSolutionId(ProtocolExtListenerManager $this, RName $receiver) {
        return $this.tryGetSolutionId($receiver);
    }

    public static final /* synthetic */ Map access$getProjectSessions$p(ProtocolExtListenerManager $this) {
        return $this.projectSessions;
    }

    public static final /* synthetic */ Map access$getAccumulatedMessages$p(ProtocolExtListenerManager $this) {
        return $this.accumulatedMessages;
    }

    public static final /* synthetic */ void access$stopDeliveringMessages(ProtocolExtListenerManager $this, String solutionId) {
        $this.stopDeliveringMessages(solutionId);
    }

    public static final /* synthetic */ void access$onExtensionAdded(ProtocolExtListenerManager $this, BaseExtListenerDescriptor extension, PluginDescriptor descriptor) {
        $this.onExtensionAdded(extension, descriptor);
    }

    public static final /* synthetic */ void access$onExtensionRemoved(ProtocolExtListenerManager $this, BaseExtListenerDescriptor extension, PluginDescriptor pluginDescriptor) {
        $this.onExtensionRemoved(extension, pluginDescriptor);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ProtocolExtListenerManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        ProtocolExtListenerManager.logger = logger;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0005\u001a\u0004\u0018\u00010\u0006*\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u00f8\u0001\u0000\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0014\u0010\f\u001a\u00020\r*\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0002J\u001e\u0010\u000f\u001a\u00020\r*\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00120\u00110\u0010H\u0002J\f\u0010\u0013\u001a\u00020\u0012*\u00020\rH\u0002J\u001e\u0010\u0014\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00120\u00110\u0015*\u00020\rH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/rd/protocol/ProtocolExtListenerManager$Companion;", "", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "findParent", "Lcom/jetbrains/rd/framework/base/RdBindableBase;", "Lcom/jetbrains/rd/framework/Protocol;", "rdId", "Lcom/jetbrains/rd/framework/RdId;", "findParent-v_l8LFs", "(Lcom/jetbrains/rd/framework/Protocol;J)Lcom/jetbrains/rd/framework/base/RdBindableBase;", "removePrefix", "Lcom/jetbrains/rd/util/string/RName;", "prefix", "reversedChainToRName", "", "Lkotlin/Pair;", "", "toLocation", "toReversedChain", "", "intellij.rd.platform"})
    @SourceDebugExtension(value={"SMAP\nProtocolExtListenerManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProtocolExtListenerManager.kt\ncom/jetbrains/rd/protocol/ProtocolExtListenerManager$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,376:1\n1#2:377\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final String toLocation(RName $this$toLocation) {
            List<Pair<String, String>> chain = this.toReversedChain($this$toLocation);
            CollectionsKt.removeLast(chain);
            chain.set(chain.size() - 1, (Pair<String, String>)TuplesKt.to((Object)"", (Object)((Pair)CollectionsKt.last(chain)).getSecond()));
            chain.removeIf(arg_0 -> Companion.toLocation$lambda$0(toLocation.1.INSTANCE, arg_0));
            chain.removeIf(arg_0 -> Companion.toLocation$lambda$1(toLocation.2.INSTANCE, arg_0));
            return CollectionsKt.joinToString$default((Iterable)CollectionsKt.asReversedMutable(chain), (CharSequence)"", null, null, (int)0, null, (Function1)toLocation.3.INSTANCE, (int)30, null);
        }

        private final RName removePrefix(RName $this$removePrefix, RName prefix2) {
            List<Pair<String, String>> nameChain = this.toReversedChain($this$removePrefix);
            List<Pair<String, String>> prefixChain = this.toReversedChain(prefix2);
            CollectionsKt.removeLast(nameChain);
            CollectionsKt.removeLast(prefixChain);
            while (!((Collection)nameChain).isEmpty() && !((Collection)prefixChain).isEmpty() && Intrinsics.areEqual((Object)CollectionsKt.last(prefixChain), (Object)CollectionsKt.last(nameChain))) {
                CollectionsKt.removeLast(nameChain);
                CollectionsKt.removeLast(prefixChain);
            }
            if (!prefixChain.isEmpty()) {
                boolean bl = false;
                String string = prefix2 + " is not a prefix of " + $this$removePrefix;
                throw new IllegalStateException(string.toString());
            }
            return this.reversedChainToRName(nameChain);
        }

        private final RdBindableBase findParent-v_l8LFs(Protocol $this$findParent_u2dv_l8LFs, long rdId) {
            IRdDynamic iRdDynamic = $this$findParent_u2dv_l8LFs.getRdEntitiesRegistrar().tryGetDynamic-s1GeQ58(rdId);
            RdBindableBase rdBindableBase = iRdDynamic instanceof RdBindableBase ? (RdBindableBase)iRdDynamic : null;
            if (rdBindableBase == null) {
                return null;
            }
            return rdBindableBase;
        }

        private final List<Pair<String, String>> toReversedChain(RName $this$toReversedChain) {
            List chain = new ArrayList();
            for (RName current = $this$toReversedChain; current != null && !Intrinsics.areEqual((Object)current, (Object)RName.Companion.getEmpty()); current = current.getParent()) {
                chain.add(TuplesKt.to((Object)current.getSeparator(), (Object)current.getLocalName()));
            }
            return chain;
        }

        private final RName reversedChainToRName(List<Pair<String, String>> $this$reversedChainToRName) {
            RName current = RName.Companion.getEmpty();
            for (Pair pair : CollectionsKt.asReversed($this$reversedChainToRName)) {
                String separator = (String)pair.component1();
                String localName = (String)pair.component2();
                current = current.sub(localName, separator);
            }
            return current;
        }

        private static final boolean toLocation$lambda$0(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (Boolean)$tmp0.invoke(p0);
        }

        private static final boolean toLocation$lambda$1(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (Boolean)$tmp0.invoke(p0);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0002H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/rd/protocol/ProtocolExtListenerManager$SolutionModelListener;", "Lcom/jetbrains/rd/protocol/RootExtListener;", "Lcom/jetbrains/rd/ide/model/SolutionModel;", "manager", "Lcom/jetbrains/rd/protocol/ProtocolExtListenerManager;", "(Lcom/jetbrains/rd/protocol/ProtocolExtListenerManager;)V", "getManager", "()Lcom/jetbrains/rd/protocol/ProtocolExtListenerManager;", "extensionCreated", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "model", "intellij.rd.platform"})
    private static final class SolutionModelListener
    implements RootExtListener<SolutionModel> {
        @NotNull
        private final ProtocolExtListenerManager manager;

        public SolutionModelListener(@NotNull ProtocolExtListenerManager manager) {
            Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
            this.manager = manager;
        }

        @NotNull
        public final ProtocolExtListenerManager getManager() {
            return this.manager;
        }

        @Override
        public void extensionCreated(@NotNull Lifetime lifetime, @NotNull ClientAppSession session, @NotNull SolutionModel model2) {
            Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            Intrinsics.checkNotNullParameter((Object)((Object)model2), (String)"model");
            this.manager.adviseOnSolutionsMap(lifetime, model2);
        }
    }
}

